/* pride.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from pride.vala, do not modify */

/* This file is part of Elastic. License: GPL-3.0+.*/
/* Adapted from Warp, source:*/
/* https://gitlab.gnome.org/World/warp/-/blob/cb6c29013fb96358a871087029754dfdc102335c/src/ui/pride.rs*/
/* https://gitlab.gnome.org/World/warp/-/blob/cb6c29013fb96358a871087029754dfdc102335c/data/resources/style.css#L52-163*/

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	ELASTIC_SEASON_INTERSEX,
	ELASTIC_SEASON_LESBIAN,
	ELASTIC_SEASON_AIDS,
	ELASTIC_SEASON_AUTISM,
	ELASTIC_SEASON_PAN,
	ELASTIC_SEASON_TRANS,
	ELASTIC_SEASON_ARO,
	ELASTIC_SEASON_ACE,
	ELASTIC_SEASON_BI,
	ELASTIC_SEASON_NON_BINARY,
	ELASTIC_SEASON_PRIDE,
	ELASTIC_SEASON_DISABILITY,
	ELASTIC_SEASON_BLACK_HISTORY
} ElasticSeason;

#define ELASTIC_TYPE_SEASON (elastic_season_get_type ())
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

VALA_EXTERN GType elastic_season_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ElasticSeason* elastic_season_all (gint* result_length1);
static inline gboolean elastic_season_is_aro_week (ElasticSeason self,
                                     gint year,
                                     gint month,
                                     gint day);
static inline gboolean elastic_season_is_ace_week (ElasticSeason self,
                                     gint year,
                                     gint month,
                                     gint day);
static inline gboolean elastic_season_is_non_binary_week (ElasticSeason self,
                                            gint year,
                                            gint month,
                                            gint day);
VALA_EXTERN gboolean elastic_season_is_season (ElasticSeason self,
                                   GDateTime* date);
VALA_EXTERN ElasticSeason* elastic_season_get_for_date (GDateTime* date);
static ElasticSeason* _elastic_season_dup (ElasticSeason* self);
VALA_EXTERN ElasticSeason* elastic_season_get_current (void);
VALA_EXTERN gchar** elastic_season_get_colors (ElasticSeason self,
                                   gint* result_length1);

ElasticSeason*
elastic_season_all (gint* result_length1)
{
	ElasticSeason* _tmp0_;
	ElasticSeason* _tmp1_;
	gint _tmp1__length1;
	ElasticSeason* result;
	_tmp0_ = g_new0 (ElasticSeason, 13);
	_tmp0_[0] = ELASTIC_SEASON_INTERSEX;
	_tmp0_[1] = ELASTIC_SEASON_LESBIAN;
	_tmp0_[2] = ELASTIC_SEASON_AIDS;
	_tmp0_[3] = ELASTIC_SEASON_AUTISM;
	_tmp0_[4] = ELASTIC_SEASON_PAN;
	_tmp0_[5] = ELASTIC_SEASON_TRANS;
	_tmp0_[6] = ELASTIC_SEASON_ARO;
	_tmp0_[7] = ELASTIC_SEASON_ACE;
	_tmp0_[8] = ELASTIC_SEASON_BI;
	_tmp0_[9] = ELASTIC_SEASON_NON_BINARY;
	_tmp0_[10] = ELASTIC_SEASON_PRIDE;
	_tmp0_[11] = ELASTIC_SEASON_DISABILITY;
	_tmp0_[12] = ELASTIC_SEASON_BLACK_HISTORY;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 13;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static inline gboolean
elastic_season_is_aro_week (ElasticSeason self,
                            gint year,
                            gint month,
                            gint day)
{
	GDateTime* february_14 = NULL;
	GDateTime* _tmp0_;
	gint weekday = 0;
	GDateTime* _tmp1_;
	gint start = 0;
	gint end = 0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean result;
	_tmp0_ = g_date_time_new_local (year, 2, 14, 0, 0, (gdouble) 0);
	february_14 = _tmp0_;
	_tmp1_ = february_14;
	weekday = g_date_time_get_day_of_week (_tmp1_) % 7;
	start = (14 + 7) - weekday;
	end = start + 6;
	if (month == 2) {
		_tmp3_ = day >= start;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = day <= end;
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	_g_date_time_unref0 (february_14);
	return result;
}

static inline gboolean
elastic_season_is_ace_week (ElasticSeason self,
                            gint year,
                            gint month,
                            gint day)
{
	GDateTime* last_day_october = NULL;
	GDateTime* _tmp0_;
	gint weekday = 0;
	GDateTime* _tmp1_;
	gint _tmp2_ = 0;
	gint start = 0;
	gint end = 0;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean result;
	_tmp0_ = g_date_time_new_local (year, 10, 31, 0, 0, (gdouble) 0);
	last_day_october = _tmp0_;
	_tmp1_ = last_day_october;
	weekday = g_date_time_get_day_of_week (_tmp1_) % 7;
	if (weekday == 6) {
		_tmp2_ = 31 - 7;
	} else {
		_tmp2_ = (31 - weekday) - 7;
	}
	start = _tmp2_;
	end = start + 6;
	if (month == 10) {
		_tmp4_ = day >= start;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = day <= end;
	} else {
		_tmp3_ = FALSE;
	}
	result = _tmp3_;
	_g_date_time_unref0 (last_day_october);
	return result;
}

static inline gboolean
elastic_season_is_non_binary_week (ElasticSeason self,
                                   gint year,
                                   gint month,
                                   gint day)
{
	GDateTime* july_14 = NULL;
	GDateTime* _tmp0_;
	gint weekday = 0;
	GDateTime* _tmp1_;
	gint start = 0;
	gint end = 0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean result;
	_tmp0_ = g_date_time_new_local (year, 7, 14, 0, 0, (gdouble) 0);
	july_14 = _tmp0_;
	_tmp1_ = july_14;
	weekday = g_date_time_get_day_of_week (_tmp1_) % 7;
	start = 14 - weekday;
	end = start + 7;
	if (month == 7) {
		_tmp3_ = day >= start;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = day <= end;
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	_g_date_time_unref0 (july_14);
	return result;
}

gboolean
elastic_season_is_season (ElasticSeason self,
                          GDateTime* date)
{
	gint month = 0;
	gint day = 0;
	gint year = 0;
	gboolean result;
	g_return_val_if_fail (date != NULL, FALSE);
	month = g_date_time_get_month (date);
	day = g_date_time_get_day_of_month (date);
	year = g_date_time_get_year (date);
	switch (self) {
		case ELASTIC_SEASON_INTERSEX:
		{
			gboolean _tmp0_ = FALSE;
			gboolean _tmp1_ = FALSE;
			if (month == 10) {
				_tmp1_ = day == 26;
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				_tmp0_ = TRUE;
			} else {
				gboolean _tmp2_ = FALSE;
				if (month == 11) {
					_tmp2_ = day == 8;
				} else {
					_tmp2_ = FALSE;
				}
				_tmp0_ = _tmp2_;
			}
			result = _tmp0_;
			return result;
		}
		case ELASTIC_SEASON_LESBIAN:
		{
			gboolean _tmp3_ = FALSE;
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			if (month == 10) {
				_tmp5_ = day == 8;
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				_tmp4_ = TRUE;
			} else {
				gboolean _tmp6_ = FALSE;
				if (month == 4) {
					_tmp6_ = day >= 26;
				} else {
					_tmp6_ = FALSE;
				}
				_tmp4_ = _tmp6_;
			}
			if (_tmp4_) {
				_tmp3_ = TRUE;
			} else {
				gboolean _tmp7_ = FALSE;
				if (month == 5) {
					_tmp7_ = day <= 2;
				} else {
					_tmp7_ = FALSE;
				}
				_tmp3_ = _tmp7_;
			}
			result = _tmp3_;
			return result;
		}
		case ELASTIC_SEASON_AIDS:
		{
			gboolean _tmp8_ = FALSE;
			if (month == 12) {
				_tmp8_ = day == 1;
			} else {
				_tmp8_ = FALSE;
			}
			result = _tmp8_;
			return result;
		}
		case ELASTIC_SEASON_AUTISM:
		{
			gboolean _tmp9_ = FALSE;
			if (month == 6) {
				_tmp9_ = day == 18;
			} else {
				_tmp9_ = FALSE;
			}
			result = _tmp9_;
			return result;
		}
		case ELASTIC_SEASON_PAN:
		{
			gboolean _tmp10_ = FALSE;
			if (month == 5) {
				_tmp10_ = day == 24;
			} else {
				_tmp10_ = FALSE;
			}
			result = _tmp10_;
			return result;
		}
		case ELASTIC_SEASON_TRANS:
		{
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_ = FALSE;
			if (month == 11) {
				_tmp14_ = day >= 13;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				_tmp13_ = day <= 19;
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				_tmp12_ = TRUE;
			} else {
				gboolean _tmp15_ = FALSE;
				if (month == 11) {
					_tmp15_ = day == 20;
				} else {
					_tmp15_ = FALSE;
				}
				_tmp12_ = _tmp15_;
			}
			if (_tmp12_) {
				_tmp11_ = TRUE;
			} else {
				gboolean _tmp16_ = FALSE;
				if (month == 3) {
					_tmp16_ = day == 31;
				} else {
					_tmp16_ = FALSE;
				}
				_tmp11_ = _tmp16_;
			}
			result = _tmp11_;
			return result;
		}
		case ELASTIC_SEASON_ARO:
		{
			result = elastic_season_is_aro_week (self, year, month, day);
			return result;
		}
		case ELASTIC_SEASON_ACE:
		{
			result = elastic_season_is_ace_week (self, year, month, day);
			return result;
		}
		case ELASTIC_SEASON_BI:
		{
			gboolean _tmp17_ = FALSE;
			gboolean _tmp18_ = FALSE;
			if (month == 9) {
				_tmp18_ = day >= 16;
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				_tmp17_ = day <= 23;
			} else {
				_tmp17_ = FALSE;
			}
			result = _tmp17_;
			return result;
		}
		case ELASTIC_SEASON_NON_BINARY:
		{
			result = elastic_season_is_non_binary_week (self, year, month, day);
			return result;
		}
		case ELASTIC_SEASON_PRIDE:
		{
			result = month == 6;
			return result;
		}
		case ELASTIC_SEASON_DISABILITY:
		{
			result = month == 7;
			return result;
		}
		case ELASTIC_SEASON_BLACK_HISTORY:
		{
			gboolean _tmp19_ = FALSE;
			if (month == 2) {
				_tmp19_ = TRUE;
			} else {
				_tmp19_ = month == 10;
			}
			result = _tmp19_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static ElasticSeason*
_elastic_season_dup (ElasticSeason* self)
{
	ElasticSeason* dup;
	dup = g_new0 (ElasticSeason, 1);
	memcpy (dup, self, sizeof (ElasticSeason));
	return dup;
}

static gpointer
__elastic_season_dup0 (gpointer self)
{
	return self ? _elastic_season_dup (self) : NULL;
}

ElasticSeason*
elastic_season_get_for_date (GDateTime* date)
{
	gint _tmp0_ = 0;
	ElasticSeason* _tmp1_;
	ElasticSeason* result;
	g_return_val_if_fail (date != NULL, NULL);
	_tmp1_ = elastic_season_all (&_tmp0_);
	{
		ElasticSeason* season_collection = NULL;
		gint season_collection_length1 = 0;
		gint _season_collection_size_ = 0;
		gint season_it = 0;
		season_collection = _tmp1_;
		season_collection_length1 = _tmp0_;
		for (season_it = 0; season_it < season_collection_length1; season_it = season_it + 1) {
			ElasticSeason season = 0;
			season = season_collection[season_it];
			{
				if (elastic_season_is_season (season, date)) {
					ElasticSeason* _tmp2_;
					_tmp2_ = __elastic_season_dup0 (&season);
					result = _tmp2_;
					season_collection = (g_free (season_collection), NULL);
					return result;
				}
			}
		}
		season_collection = (g_free (season_collection), NULL);
	}
	result = NULL;
	return result;
}

ElasticSeason*
elastic_season_get_current (void)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	ElasticSeason* _tmp2_;
	ElasticSeason* _tmp3_;
	ElasticSeason* result;
	_tmp0_ = g_date_time_new_now_local ();
	_tmp1_ = _tmp0_;
	_tmp2_ = elastic_season_get_for_date (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_date_time_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gchar**
elastic_season_get_colors (ElasticSeason self,
                           gint* result_length1)
{
	gchar** result;
	switch (self) {
		case ELASTIC_SEASON_INTERSEX:
		{
			gchar* _tmp0_;
			gchar* _tmp1_;
			gchar** _tmp2_;
			gchar** _tmp3_;
			gint _tmp3__length1;
			_tmp0_ = g_strdup ("#FFD800");
			_tmp1_ = g_strdup ("#7902AA");
			_tmp2_ = g_new0 (gchar*, 2 + 1);
			_tmp2_[0] = _tmp0_;
			_tmp2_[1] = _tmp1_;
			_tmp3_ = _tmp2_;
			_tmp3__length1 = 2;
			if (result_length1) {
				*result_length1 = _tmp3__length1;
			}
			result = _tmp3_;
			return result;
		}
		case ELASTIC_SEASON_LESBIAN:
		{
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar** _tmp11_;
			gchar** _tmp12_;
			gint _tmp12__length1;
			_tmp4_ = g_strdup ("#D52D00");
			_tmp5_ = g_strdup ("#EF7627");
			_tmp6_ = g_strdup ("#FF9A56");
			_tmp7_ = g_strdup ("#FFFFFF");
			_tmp8_ = g_strdup ("#D162A4");
			_tmp9_ = g_strdup ("#B55690");
			_tmp10_ = g_strdup ("#A30262");
			_tmp11_ = g_new0 (gchar*, 7 + 1);
			_tmp11_[0] = _tmp4_;
			_tmp11_[1] = _tmp5_;
			_tmp11_[2] = _tmp6_;
			_tmp11_[3] = _tmp7_;
			_tmp11_[4] = _tmp8_;
			_tmp11_[5] = _tmp9_;
			_tmp11_[6] = _tmp10_;
			_tmp12_ = _tmp11_;
			_tmp12__length1 = 7;
			if (result_length1) {
				*result_length1 = _tmp12__length1;
			}
			result = _tmp12_;
			return result;
		}
		case ELASTIC_SEASON_AIDS:
		{
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar** _tmp18_;
			gchar** _tmp19_;
			gint _tmp19__length1;
			_tmp13_ = g_strdup ("#FFFFFF");
			_tmp14_ = g_strdup ("#D11113");
			_tmp15_ = g_strdup ("#FFFFFF");
			_tmp16_ = g_strdup ("#D11113");
			_tmp17_ = g_strdup ("#FFFFFF");
			_tmp18_ = g_new0 (gchar*, 5 + 1);
			_tmp18_[0] = _tmp13_;
			_tmp18_[1] = _tmp14_;
			_tmp18_[2] = _tmp15_;
			_tmp18_[3] = _tmp16_;
			_tmp18_[4] = _tmp17_;
			_tmp19_ = _tmp18_;
			_tmp19__length1 = 5;
			if (result_length1) {
				*result_length1 = _tmp19__length1;
			}
			result = _tmp19_;
			return result;
		}
		case ELASTIC_SEASON_AUTISM:
		{
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar** _tmp26_;
			gchar** _tmp27_;
			gint _tmp27__length1;
			_tmp20_ = g_strdup ("#E53043");
			_tmp21_ = g_strdup ("#F68347");
			_tmp22_ = g_strdup ("#FAC857");
			_tmp23_ = g_strdup ("#FAC857");
			_tmp24_ = g_strdup ("#99D671");
			_tmp25_ = g_strdup ("#21AE75");
			_tmp26_ = g_new0 (gchar*, 6 + 1);
			_tmp26_[0] = _tmp20_;
			_tmp26_[1] = _tmp21_;
			_tmp26_[2] = _tmp22_;
			_tmp26_[3] = _tmp23_;
			_tmp26_[4] = _tmp24_;
			_tmp26_[5] = _tmp25_;
			_tmp27_ = _tmp26_;
			_tmp27__length1 = 6;
			if (result_length1) {
				*result_length1 = _tmp27__length1;
			}
			result = _tmp27_;
			return result;
		}
		case ELASTIC_SEASON_PAN:
		{
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar** _tmp31_;
			gchar** _tmp32_;
			gint _tmp32__length1;
			_tmp28_ = g_strdup ("#FF218C");
			_tmp29_ = g_strdup ("#FFD800");
			_tmp30_ = g_strdup ("#21B1FF");
			_tmp31_ = g_new0 (gchar*, 3 + 1);
			_tmp31_[0] = _tmp28_;
			_tmp31_[1] = _tmp29_;
			_tmp31_[2] = _tmp30_;
			_tmp32_ = _tmp31_;
			_tmp32__length1 = 3;
			if (result_length1) {
				*result_length1 = _tmp32__length1;
			}
			result = _tmp32_;
			return result;
		}
		case ELASTIC_SEASON_TRANS:
		{
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar** _tmp38_;
			gchar** _tmp39_;
			gint _tmp39__length1;
			_tmp33_ = g_strdup ("#5BCEFA");
			_tmp34_ = g_strdup ("#F5A9B8");
			_tmp35_ = g_strdup ("#FFFFFF");
			_tmp36_ = g_strdup ("#F5A9B8");
			_tmp37_ = g_strdup ("#5BCEFA");
			_tmp38_ = g_new0 (gchar*, 5 + 1);
			_tmp38_[0] = _tmp33_;
			_tmp38_[1] = _tmp34_;
			_tmp38_[2] = _tmp35_;
			_tmp38_[3] = _tmp36_;
			_tmp38_[4] = _tmp37_;
			_tmp39_ = _tmp38_;
			_tmp39__length1 = 5;
			if (result_length1) {
				*result_length1 = _tmp39__length1;
			}
			result = _tmp39_;
			return result;
		}
		case ELASTIC_SEASON_ARO:
		{
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar** _tmp45_;
			gchar** _tmp46_;
			gint _tmp46__length1;
			_tmp40_ = g_strdup ("#3DA542");
			_tmp41_ = g_strdup ("#A8D377");
			_tmp42_ = g_strdup ("#FEFEFE");
			_tmp43_ = g_strdup ("#A9A9A9");
			_tmp44_ = g_strdup ("#000000");
			_tmp45_ = g_new0 (gchar*, 5 + 1);
			_tmp45_[0] = _tmp40_;
			_tmp45_[1] = _tmp41_;
			_tmp45_[2] = _tmp42_;
			_tmp45_[3] = _tmp43_;
			_tmp45_[4] = _tmp44_;
			_tmp46_ = _tmp45_;
			_tmp46__length1 = 5;
			if (result_length1) {
				*result_length1 = _tmp46__length1;
			}
			result = _tmp46_;
			return result;
		}
		case ELASTIC_SEASON_ACE:
		{
			gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			gchar** _tmp51_;
			gchar** _tmp52_;
			gint _tmp52__length1;
			_tmp47_ = g_strdup ("#000000");
			_tmp48_ = g_strdup ("#A3A3A3");
			_tmp49_ = g_strdup ("#FFFFFF");
			_tmp50_ = g_strdup ("#800080");
			_tmp51_ = g_new0 (gchar*, 4 + 1);
			_tmp51_[0] = _tmp47_;
			_tmp51_[1] = _tmp48_;
			_tmp51_[2] = _tmp49_;
			_tmp51_[3] = _tmp50_;
			_tmp52_ = _tmp51_;
			_tmp52__length1 = 4;
			if (result_length1) {
				*result_length1 = _tmp52__length1;
			}
			result = _tmp52_;
			return result;
		}
		case ELASTIC_SEASON_BI:
		{
			gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar** _tmp58_;
			gchar** _tmp59_;
			gint _tmp59__length1;
			_tmp53_ = g_strdup ("#D60270");
			_tmp54_ = g_strdup ("#D60270");
			_tmp55_ = g_strdup ("#9B4F96");
			_tmp56_ = g_strdup ("#0038A8");
			_tmp57_ = g_strdup ("#0038A8");
			_tmp58_ = g_new0 (gchar*, 5 + 1);
			_tmp58_[0] = _tmp53_;
			_tmp58_[1] = _tmp54_;
			_tmp58_[2] = _tmp55_;
			_tmp58_[3] = _tmp56_;
			_tmp58_[4] = _tmp57_;
			_tmp59_ = _tmp58_;
			_tmp59__length1 = 5;
			if (result_length1) {
				*result_length1 = _tmp59__length1;
			}
			result = _tmp59_;
			return result;
		}
		case ELASTIC_SEASON_NON_BINARY:
		{
			gchar* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			gchar** _tmp64_;
			gchar** _tmp65_;
			gint _tmp65__length1;
			_tmp60_ = g_strdup ("#FFF534");
			_tmp61_ = g_strdup ("#FFFFFF");
			_tmp62_ = g_strdup ("#995ACF");
			_tmp63_ = g_strdup ("#2E2E2E");
			_tmp64_ = g_new0 (gchar*, 4 + 1);
			_tmp64_[0] = _tmp60_;
			_tmp64_[1] = _tmp61_;
			_tmp64_[2] = _tmp62_;
			_tmp64_[3] = _tmp63_;
			_tmp65_ = _tmp64_;
			_tmp65__length1 = 4;
			if (result_length1) {
				*result_length1 = _tmp65__length1;
			}
			result = _tmp65_;
			return result;
		}
		case ELASTIC_SEASON_PRIDE:
		{
			gchar* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			gchar* _tmp71_;
			gchar** _tmp72_;
			gchar** _tmp73_;
			gint _tmp73__length1;
			_tmp66_ = g_strdup ("#E40303");
			_tmp67_ = g_strdup ("#FF8C00");
			_tmp68_ = g_strdup ("#FFED00");
			_tmp69_ = g_strdup ("#008026");
			_tmp70_ = g_strdup ("#24408E");
			_tmp71_ = g_strdup ("#732982");
			_tmp72_ = g_new0 (gchar*, 6 + 1);
			_tmp72_[0] = _tmp66_;
			_tmp72_[1] = _tmp67_;
			_tmp72_[2] = _tmp68_;
			_tmp72_[3] = _tmp69_;
			_tmp72_[4] = _tmp70_;
			_tmp72_[5] = _tmp71_;
			_tmp73_ = _tmp72_;
			_tmp73__length1 = 6;
			if (result_length1) {
				*result_length1 = _tmp73__length1;
			}
			result = _tmp73_;
			return result;
		}
		case ELASTIC_SEASON_DISABILITY:
		{
			gchar* _tmp74_;
			gchar* _tmp75_;
			gchar* _tmp76_;
			gchar* _tmp77_;
			gchar* _tmp78_;
			gchar* _tmp79_;
			gchar* _tmp80_;
			gchar* _tmp81_;
			gchar* _tmp82_;
			gchar** _tmp83_;
			gchar** _tmp84_;
			gint _tmp84__length1;
			_tmp74_ = g_strdup ("#585858");
			_tmp75_ = g_strdup ("#585858");
			_tmp76_ = g_strdup ("#CF7280");
			_tmp77_ = g_strdup ("#EEDF77");
			_tmp78_ = g_strdup ("#E9E9E9");
			_tmp79_ = g_strdup ("#7AC1E0");
			_tmp80_ = g_strdup ("#3AAF7D");
			_tmp81_ = g_strdup ("#585858");
			_tmp82_ = g_strdup ("#585858");
			_tmp83_ = g_new0 (gchar*, 9 + 1);
			_tmp83_[0] = _tmp74_;
			_tmp83_[1] = _tmp75_;
			_tmp83_[2] = _tmp76_;
			_tmp83_[3] = _tmp77_;
			_tmp83_[4] = _tmp78_;
			_tmp83_[5] = _tmp79_;
			_tmp83_[6] = _tmp80_;
			_tmp83_[7] = _tmp81_;
			_tmp83_[8] = _tmp82_;
			_tmp84_ = _tmp83_;
			_tmp84__length1 = 9;
			if (result_length1) {
				*result_length1 = _tmp84__length1;
			}
			result = _tmp84_;
			return result;
		}
		case ELASTIC_SEASON_BLACK_HISTORY:
		{
			gchar* _tmp85_;
			gchar* _tmp86_;
			gchar* _tmp87_;
			gchar* _tmp88_;
			gchar** _tmp89_;
			gchar** _tmp90_;
			gint _tmp90__length1;
			_tmp85_ = g_strdup ("#000000");
			_tmp86_ = g_strdup ("#C31F1E");
			_tmp87_ = g_strdup ("#F9CA00");
			_tmp88_ = g_strdup ("#1C6935");
			_tmp89_ = g_new0 (gchar*, 4 + 1);
			_tmp89_[0] = _tmp85_;
			_tmp89_[1] = _tmp86_;
			_tmp89_[2] = _tmp87_;
			_tmp89_[3] = _tmp88_;
			_tmp90_ = _tmp89_;
			_tmp90__length1 = 4;
			if (result_length1) {
				*result_length1 = _tmp90__length1;
			}
			result = _tmp90_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
elastic_season_get_type_once (void)
{
	static const GEnumValue values[] = {{ELASTIC_SEASON_INTERSEX, "ELASTIC_SEASON_INTERSEX", "intersex"}, {ELASTIC_SEASON_LESBIAN, "ELASTIC_SEASON_LESBIAN", "lesbian"}, {ELASTIC_SEASON_AIDS, "ELASTIC_SEASON_AIDS", "aids"}, {ELASTIC_SEASON_AUTISM, "ELASTIC_SEASON_AUTISM", "autism"}, {ELASTIC_SEASON_PAN, "ELASTIC_SEASON_PAN", "pan"}, {ELASTIC_SEASON_TRANS, "ELASTIC_SEASON_TRANS", "trans"}, {ELASTIC_SEASON_ARO, "ELASTIC_SEASON_ARO", "aro"}, {ELASTIC_SEASON_ACE, "ELASTIC_SEASON_ACE", "ace"}, {ELASTIC_SEASON_BI, "ELASTIC_SEASON_BI", "bi"}, {ELASTIC_SEASON_NON_BINARY, "ELASTIC_SEASON_NON_BINARY", "non-binary"}, {ELASTIC_SEASON_PRIDE, "ELASTIC_SEASON_PRIDE", "pride"}, {ELASTIC_SEASON_DISABILITY, "ELASTIC_SEASON_DISABILITY", "disability"}, {ELASTIC_SEASON_BLACK_HISTORY, "ELASTIC_SEASON_BLACK_HISTORY", "black-history"}, {0, NULL, NULL}};
	GType elastic_season_type_id;
	elastic_season_type_id = g_enum_register_static ("ElasticSeason", values);
	return elastic_season_type_id;
}

GType
elastic_season_get_type (void)
{
	static volatile gsize elastic_season_type_id__once = 0;
	if (g_once_init_enter (&elastic_season_type_id__once)) {
		GType elastic_season_type_id;
		elastic_season_type_id = elastic_season_get_type_once ();
		g_once_init_leave (&elastic_season_type_id__once, elastic_season_type_id);
	}
	return elastic_season_type_id__once;
}

