
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "qtsingleapplication_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_QtSingleApplication_Type = nullptr;
static PyTypeObject *Sbk_QtSingleApplication_TypeF(void)
{
    return _Sbk_QtSingleApplication_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void QtSingleApplicationWrapper::pysideInitQtMetaTypes()
{
}

void QtSingleApplicationWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

void QtSingleApplicationWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_QtSingleApplication_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("QtSingleApplication", funcName, gil, pyOverride, event);
}

void QtSingleApplicationWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_QtSingleApplication_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("QtSingleApplication", funcName, gil, pyOverride, signal);
}

void QtSingleApplicationWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_QtSingleApplication_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("QtSingleApplication", funcName, gil, pyOverride, event);
}

void QtSingleApplicationWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_QtSingleApplication_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("QtSingleApplication", funcName, gil, pyOverride, signal);
}

bool QtSingleApplicationWrapper::event(::QEvent * arg__1)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_QtSingleApplication_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QApplication::event(arg__1);
    }
    return WebViewWrapper::sbk_o_event("QtSingleApplication", funcName, gil, pyOverride, arg__1);
}

bool QtSingleApplicationWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_QtSingleApplication_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("QtSingleApplication", funcName, gil, pyOverride, watched, event);
}

bool QtSingleApplicationWrapper::notify(::QObject * arg__1, ::QEvent * arg__2)
{
    static const char *funcName = "notify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_QtSingleApplication_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QApplication::notify(arg__1, arg__2);
    }
    return sbk_o_notify("QtSingleApplication", funcName, gil, pyOverride, arg__1, arg__2);
}

bool QtSingleApplicationWrapper::sbk_o_notify(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QObject * arg__1, ::QEvent * arg__2)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), arg__1),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), arg__2)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), arg__1),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), arg__2)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QtSingleApplicationWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_QtSingleApplication_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("QtSingleApplication", funcName, gil, pyOverride, event);
}

const QMetaObject *QtSingleApplicationWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QtSingleApplication::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QtSingleApplicationWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QtSingleApplication::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QtSingleApplicationWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< QtSingleApplicationWrapper *>(this));
    }
    return QtSingleApplication::qt_metacast(_clname);
}

QtSingleApplicationWrapper::~QtSingleApplicationWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_QtSingleApplication_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int Sbk_QtSingleApplication_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNonConstructible("QtSingleApplication");
    return -1;
}

static PyObject *Sbk_QtSingleApplicationFunc_activateWindow(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<QtSingleApplicationWrapper *>(reinterpret_cast< ::QtSingleApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QtSingleApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // activateWindow()
        cppSelf->activateWindow();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_QtSingleApplicationFunc_activationWindow(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<QtSingleApplicationWrapper *>(reinterpret_cast< ::QtSingleApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QtSingleApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // activationWindow()const
        QWidget * cppResult = const_cast<const QtSingleApplicationWrapper *>(cppSelf)->activationWindow();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QtSingleApplicationFunc_id(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<QtSingleApplicationWrapper *>(reinterpret_cast< ::QtSingleApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QtSingleApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // id()const
        QString cppResult = const_cast<const QtSingleApplicationWrapper *>(cppSelf)->id();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QtSingleApplicationFunc_initialize(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<QtSingleApplicationWrapper *>(reinterpret_cast< ::QtSingleApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QtSingleApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "initialize", errInfo, SbkPyFalkonTypeStructs[SBK_QtSingleApplication_IDX]);

    if (PyArg_ParseTuple(args, "|O:initialize", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QtSingleApplication::initialize(bool=)
    if (numArgs == 0) {
        overloadId = 0; // initialize(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // initialize(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "initialize", errInfo, SbkPyFalkonTypeStructs[SBK_QtSingleApplication_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"dummy", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "initialize", errInfo, SbkPyFalkonTypeStructs[SBK_QtSingleApplication_IDX]);
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // initialize(bool)
            cppSelf->initialize(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_QtSingleApplicationFunc_isRunning(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<QtSingleApplicationWrapper *>(reinterpret_cast< ::QtSingleApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QtSingleApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isRunning()
        bool cppResult = cppSelf->isRunning();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QtSingleApplicationFunc_removeLockFile(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<QtSingleApplicationWrapper *>(reinterpret_cast< ::QtSingleApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QtSingleApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // removeLockFile()
        cppSelf->removeLockFile();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_QtSingleApplicationFunc_sendMessage(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<QtSingleApplicationWrapper *>(reinterpret_cast< ::QtSingleApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QtSingleApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "sendMessage", errInfo, SbkPyFalkonTypeStructs[SBK_QtSingleApplication_IDX]);

    if (PyArg_ParseTuple(args, "|OO:sendMessage", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QtSingleApplication::sendMessage(QString,int=)->bool
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // sendMessage(QString,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // sendMessage(QString,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "sendMessage", errInfo, SbkPyFalkonTypeStructs[SBK_QtSingleApplication_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"timeout", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "sendMessage", errInfo, SbkPyFalkonTypeStructs[SBK_QtSingleApplication_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 5000;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // sendMessage(QString,int)
            bool cppResult = cppSelf->sendMessage(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QtSingleApplicationFunc_setActivationWindow(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<QtSingleApplicationWrapper *>(reinterpret_cast< ::QtSingleApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QtSingleApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setActivationWindow", errInfo, SbkPyFalkonTypeStructs[SBK_QtSingleApplication_IDX]);

    if (PyArg_ParseTuple(args, "|OO:setActivationWindow", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QtSingleApplication::setActivationWindow(QWidget*,bool=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setActivationWindow(QWidget*,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // setActivationWindow(QWidget*,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setActivationWindow", errInfo, SbkPyFalkonTypeStructs[SBK_QtSingleApplication_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"activateOnMessage", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setActivationWindow", errInfo, SbkPyFalkonTypeStructs[SBK_QtSingleApplication_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = true;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setActivationWindow(QWidget*,bool)
            cppSelf->setActivationWindow(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_QtSingleApplicationFunc_setAppId(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<QtSingleApplicationWrapper *>(reinterpret_cast< ::QtSingleApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QtSingleApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QtSingleApplication::setAppId(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setAppId(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setAppId", errInfo, SbkPyFalkonTypeStructs[SBK_QtSingleApplication_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAppId(QString)
            cppSelf->setAppId(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_QtSingleApplication_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QtSingleApplication_methods[] = {
    {"activateWindow", reinterpret_cast<PyCFunction>(Sbk_QtSingleApplicationFunc_activateWindow), METH_NOARGS, nullptr},
    {"activationWindow", reinterpret_cast<PyCFunction>(Sbk_QtSingleApplicationFunc_activationWindow), METH_NOARGS, nullptr},
    {"id", reinterpret_cast<PyCFunction>(Sbk_QtSingleApplicationFunc_id), METH_NOARGS, nullptr},
    {"initialize", reinterpret_cast<PyCFunction>(Sbk_QtSingleApplicationFunc_initialize), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"isRunning", reinterpret_cast<PyCFunction>(Sbk_QtSingleApplicationFunc_isRunning), METH_NOARGS, nullptr},
    {"removeLockFile", reinterpret_cast<PyCFunction>(Sbk_QtSingleApplicationFunc_removeLockFile), METH_NOARGS, nullptr},
    {"sendMessage", reinterpret_cast<PyCFunction>(Sbk_QtSingleApplicationFunc_sendMessage), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setActivationWindow", reinterpret_cast<PyCFunction>(Sbk_QtSingleApplicationFunc_setActivationWindow), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setAppId", reinterpret_cast<PyCFunction>(Sbk_QtSingleApplicationFunc_setAppId), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_QtSingleApplication_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::QtSingleApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QtSingleApplication_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<QtSingleApplicationWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QtSingleApplication_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_QtSingleApplication_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_QtSingleApplication_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocQAppWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QtSingleApplication_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QtSingleApplication_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QtSingleApplication_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QtSingleApplication_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QtSingleApplication_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkQApp_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_QtSingleApplication_spec = {
    "1:PyFalkon.QtSingleApplication",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_QtSingleApplication_slots
};

} //extern "C"

static void *Sbk_QtSingleApplication_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::QtSingleApplication *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QtSingleApplication_PythonToCpp_QtSingleApplication_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_QtSingleApplication_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QtSingleApplication_PythonToCpp_QtSingleApplication_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_QtSingleApplication_TypeF()))
        return QtSingleApplication_PythonToCpp_QtSingleApplication_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QtSingleApplication_PTR_CppToPython_QtSingleApplication(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::QtSingleApplication *>(const_cast<void *>(cppIn)), Sbk_QtSingleApplication_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *QtSingleApplication_SignatureStrings[] = {
    "PyFalkon.QtSingleApplication.activateWindow(self)",
    "PyFalkon.QtSingleApplication.activationWindow(self)->PySide6.QtWidgets.QWidget",
    "PyFalkon.QtSingleApplication.id(self)->QString",
    "PyFalkon.QtSingleApplication.initialize(self,dummy:bool=true)",
    "PyFalkon.QtSingleApplication.isRunning(self)->bool",
    "PyFalkon.QtSingleApplication.removeLockFile(self)",
    "PyFalkon.QtSingleApplication.sendMessage(self,message:QString,timeout:int=5000)->bool",
    "PyFalkon.QtSingleApplication.setActivationWindow(self,aw:PySide6.QtWidgets.QWidget,activateOnMessage:bool=true)",
    "PyFalkon.QtSingleApplication.setAppId(self,id:QString)",
    nullptr}; // Sentinel
#else
static constexpr size_t QtSingleApplication_SignatureByteSize = 218;
static constexpr uint8_t QtSingleApplication_SignatureBytes[218] = {
    0x78, 0xda, 0x8d, 0x91, 0x4d, 0x0f, 0x82, 0x30, 0x0c, 0x86, 0xef, 0xfe, 0x12, 0x4d, 0xa6, 0xe1,
    0xa2, 0x07, 0x12, 0x4c, 0xbc, 0x98, 0x98, 0x68, 0x04, 0x39, 0x70, 0x9e, 0xac, 0x92, 0x86, 0xad,
    0x23, 0xac, 0x68, 0xf0, 0xd7, 0x3b, 0x05, 0x12, 0x0f, 0x7e, 0x70, 0x6b, 0xbb, 0x3e, 0xed, 0xbb,
    0xb7, 0x71, 0xbb, 0x95, 0xba, 0xb4, 0xb4, 0x48, 0x38, 0x45, 0x2a, 0x34, 0x6c, 0xaa, 0x4a, 0x63,
    0x2e, 0x19, 0x7d, 0x4d, 0xe6, 0x8c, 0x57, 0xc9, 0x90, 0x21, 0x29, 0x7b, 0x9b, 0x3a, 0xd0, 0x97,
    0xd9, 0x24, 0x1e, 0x41, 0xf8, 0xf0, 0x9d, 0x99, 0xaf, 0xe3, 0x36, 0x45, 0x05, 0x2b, 0xcf, 0x64,
    0xa8, 0x0a, 0x60, 0xb7, 0x48, 0xba, 0xe0, 0xf7, 0x38, 0x54, 0xc3, 0x80, 0x24, 0xe5, 0xda, 0x3f,
    0xff, 0x69, 0x27, 0x64, 0x94, 0x1a, 0xef, 0xf0, 0xc2, 0x84, 0x6a, 0x8c, 0x69, 0xc3, 0xb3, 0xb5,
    0x3a, 0xe2, 0xba, 0x81, 0x3f, 0xda, 0xd1, 0x9d, 0x1a, 0x22, 0x5f, 0x1e, 0x76, 0x3e, 0xc1, 0xdf,
    0x48, 0x0d, 0xc6, 0x5e, 0x61, 0x6f, 0xf3, 0x72, 0x8b, 0x1a, 0xc6, 0x18, 0xe4, 0x80, 0xd4, 0x01,
    0x9c, 0x93, 0x45, 0xaf, 0xd1, 0x74, 0x49, 0xd8, 0x7f, 0x50, 0x30, 0x1a, 0xb0, 0x0d, 0x87, 0x48,
    0x1c, 0x2d, 0x83, 0x20, 0x18, 0xa5, 0xc3, 0x01, 0x6f, 0x3e, 0x39, 0x2f, 0xe4, 0x2d, 0xfc, 0x6a,
    0xbd, 0x18, 0xce, 0x7b, 0xa4, 0x5e, 0xd1, 0x68, 0xab, 0x9e, 0xfb, 0xaa, 0x6a, 0xd7, 0x5d, 0x47,
    0xa0, 0x1a, 0xd4, 0xcf, 0x26, 0x0f, 0x98, 0xb3, 0xdc, 0x97
};
#endif

PyTypeObject *init_QtSingleApplication(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_QtSingleApplication_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_QtSingleApplication_IDX].type;

    Shiboken::AutoDecRef Sbk_QtSingleApplication_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QApplication_IDX]))));

    _Sbk_QtSingleApplication_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QtSingleApplication",
        "QtSingleApplication*",
        &Sbk_QtSingleApplication_spec,
        &Shiboken::callCppDestructor< QtSingleApplication >,
        Sbk_QtSingleApplication_Type_bases.object(),
        0);
    auto *pyType = _Sbk_QtSingleApplication_Type; // references _Sbk_QtSingleApplication_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, QtSingleApplication_SignatureStrings);
#else
    InitSignatureBytes(pyType, QtSingleApplication_SignatureBytes, QtSingleApplication_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_QtSingleApplication_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_QtSingleApplication_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        QtSingleApplication_PythonToCpp_QtSingleApplication_PTR,
        is_QtSingleApplication_PythonToCpp_QtSingleApplication_PTR_Convertible,
        QtSingleApplication_PTR_CppToPython_QtSingleApplication);

    Shiboken::Conversions::registerConverterName(converter, "QtSingleApplication");
    Shiboken::Conversions::registerConverterName(converter, "QtSingleApplication*");
    Shiboken::Conversions::registerConverterName(converter, "QtSingleApplication&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QtSingleApplication).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(QtSingleApplicationWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_QtSingleApplication_TypeF(), &Sbk_QtSingleApplication_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::QtSingleApplication::staticMetaObject);
    QtSingleApplicationWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::QtSingleApplication::staticMetaObject, sizeof(QtSingleApplicationWrapper));

    return pyType;
}
