#include <stdint.h>
#include <fcitx/fcitx.h>
#include <fcitx-utils/utils.h>
#include <fcitx/instance.h>
#include <fcitx/addon.h>
#include <fcitx/module.h>


#ifndef __FCITX_MODULE_FCITX_CLIPBOARD_ADD_FUNCTION_H
#define __FCITX_MODULE_FCITX_CLIPBOARD_ADD_FUNCTION_H

#ifdef __cplusplus
extern "C" {
#endif

DEFINE_GET_ADDON("fcitx-clipboard", _Clipboard_)

static void*
__fcitx_Clipboard_function_GetPrimarySelection(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxClipboard*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(unsigned int*, arg0, _args.args[0]);
    FcitxClipboard* self = __self;
    FCITX_UNUSED(self);
    if ((arg0)) *(arg0) = (self)->primary.len;
    const char* res = ((self)->primary.str);
    FCITX_RETURN_AS_PTR(const char*, res);
}

static void*
__fcitx_Clipboard_function_GetClipboardHistory(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxClipboard*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(unsigned int, arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(unsigned int*, arg1, _args.args[1]);
    FcitxClipboard* self = __self;
    FCITX_UNUSED(self);
    const char* res = (ClipboardGetClipboard(self, arg0, arg1));
    FCITX_RETURN_AS_PTR(const char*, res);
}

static void
FcitxClipboardAddFunctions(FcitxInstance *instance)
{
    int i;
    FcitxAddon *addon = Fcitx_Clipboard_GetAddon(instance);
    static const FcitxModuleFunction ____fcitx_Clipboard_addon_functions_table[] = {
        __fcitx_Clipboard_function_GetPrimarySelection,
        __fcitx_Clipboard_function_GetClipboardHistory,
    };
    for (i = 0;i < 2;i++) {
        FcitxModuleAddFunction(addon, ____fcitx_Clipboard_addon_functions_table[i]);
    }
}

#ifdef __cplusplus
}
#endif

#endif
