/* FontModel.c generated by valac 0.56.18, the Vala compiler
 * generated from FontModel.vala, do not modify */

/* FontModel.vala
 *
 * Copyright (C) 2020-2025 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

#include <json-glib/json-glib.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "font-manager.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FONT_MANAGER_TYPE_BASE_FONT_MODEL (font_manager_base_font_model_get_type ())
#define FONT_MANAGER_BASE_FONT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_BASE_FONT_MODEL, FontManagerBaseFontModel))
#define FONT_MANAGER_BASE_FONT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_BASE_FONT_MODEL, FontManagerBaseFontModelClass))
#define FONT_MANAGER_IS_BASE_FONT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_BASE_FONT_MODEL))
#define FONT_MANAGER_IS_BASE_FONT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_BASE_FONT_MODEL))
#define FONT_MANAGER_BASE_FONT_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_BASE_FONT_MODEL, FontManagerBaseFontModelClass))

typedef struct _FontManagerBaseFontModel FontManagerBaseFontModel;
typedef struct _FontManagerBaseFontModelClass FontManagerBaseFontModelClass;
typedef struct _FontManagerBaseFontModelPrivate FontManagerBaseFontModelPrivate;

#define FONT_MANAGER_TYPE_CACHEABLE (font_manager_cacheable_get_type ())
#define FONT_MANAGER_CACHEABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_CACHEABLE, FontManagerCacheable))
#define FONT_MANAGER_CACHEABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_CACHEABLE, FontManagerCacheableClass))
#define FONT_MANAGER_IS_CACHEABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_CACHEABLE))
#define FONT_MANAGER_IS_CACHEABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_CACHEABLE))
#define FONT_MANAGER_CACHEABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_CACHEABLE, FontManagerCacheableClass))

typedef struct _FontManagerCacheable FontManagerCacheable;
typedef struct _FontManagerCacheableClass FontManagerCacheableClass;

#define FONT_MANAGER_TYPE_FONT_LIST_FILTER (font_manager_font_list_filter_get_type ())
#define FONT_MANAGER_FONT_LIST_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_FONT_LIST_FILTER, FontManagerFontListFilter))
#define FONT_MANAGER_FONT_LIST_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_FONT_LIST_FILTER, FontManagerFontListFilterClass))
#define FONT_MANAGER_IS_FONT_LIST_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_FONT_LIST_FILTER))
#define FONT_MANAGER_IS_FONT_LIST_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_FONT_LIST_FILTER))
#define FONT_MANAGER_FONT_LIST_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_FONT_LIST_FILTER, FontManagerFontListFilterClass))

typedef struct _FontManagerFontListFilter FontManagerFontListFilter;
typedef struct _FontManagerFontListFilterClass FontManagerFontListFilterClass;
enum  {
	FONT_MANAGER_BASE_FONT_MODEL_0_PROPERTY,
	FONT_MANAGER_BASE_FONT_MODEL_ITEM_TYPE_PROPERTY,
	FONT_MANAGER_BASE_FONT_MODEL_N_ITEMS_PROPERTY,
	FONT_MANAGER_BASE_FONT_MODEL_ENTRIES_PROPERTY,
	FONT_MANAGER_BASE_FONT_MODEL_ITEMS_PROPERTY,
	FONT_MANAGER_BASE_FONT_MODEL_SEARCH_TERM_PROPERTY,
	FONT_MANAGER_BASE_FONT_MODEL_FILTER_PROPERTY,
	FONT_MANAGER_BASE_FONT_MODEL_NUM_PROPERTIES
};
static GParamSpec* font_manager_base_font_model_properties[FONT_MANAGER_BASE_FONT_MODEL_NUM_PROPERTIES];
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define FONT_MANAGER_TYPE_CATEGORY (font_manager_category_get_type ())
#define FONT_MANAGER_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_CATEGORY, FontManagerCategory))
#define FONT_MANAGER_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_CATEGORY, FontManagerCategoryClass))
#define FONT_MANAGER_IS_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_CATEGORY))
#define FONT_MANAGER_IS_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_CATEGORY))
#define FONT_MANAGER_CATEGORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_CATEGORY, FontManagerCategoryClass))

typedef struct _FontManagerCategory FontManagerCategory;
typedef struct _FontManagerCategoryClass FontManagerCategoryClass;
typedef enum  {
	FONT_MANAGER_CATEGORY_INDEX_ALL,
	FONT_MANAGER_CATEGORY_INDEX_SYSTEM,
	FONT_MANAGER_CATEGORY_INDEX_USER,
	FONT_MANAGER_CATEGORY_INDEX_PANOSE,
	FONT_MANAGER_CATEGORY_INDEX_WIDTH,
	FONT_MANAGER_CATEGORY_INDEX_WEIGHT,
	FONT_MANAGER_CATEGORY_INDEX_SLANT,
	FONT_MANAGER_CATEGORY_INDEX_SPACING,
	FONT_MANAGER_CATEGORY_INDEX_LICENSE,
	FONT_MANAGER_CATEGORY_INDEX_VENDOR,
	FONT_MANAGER_CATEGORY_INDEX_FILETYPE,
	FONT_MANAGER_CATEGORY_INDEX_UNSORTED,
	FONT_MANAGER_CATEGORY_INDEX_DISABLED,
	FONT_MANAGER_CATEGORY_INDEX_LANGUAGE,
	FONT_MANAGER_CATEGORY_INDEX_N_CATEGORIES
} FontManagerCategoryIndex;

#define FONT_MANAGER_TYPE_CATEGORY_INDEX (font_manager_category_index_get_type ())
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;
enum  {
	FONT_MANAGER_BASE_FONT_MODEL_ITEMS_UPDATED_SIGNAL,
	FONT_MANAGER_BASE_FONT_MODEL_NUM_SIGNALS
};
static guint font_manager_base_font_model_signals[FONT_MANAGER_BASE_FONT_MODEL_NUM_SIGNALS] = {0};

#define FONT_MANAGER_TYPE_VARIANT_MODEL (font_manager_variant_model_get_type ())
#define FONT_MANAGER_VARIANT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_VARIANT_MODEL, FontManagerVariantModel))
#define FONT_MANAGER_VARIANT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_VARIANT_MODEL, FontManagerVariantModelClass))
#define FONT_MANAGER_IS_VARIANT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_VARIANT_MODEL))
#define FONT_MANAGER_IS_VARIANT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_VARIANT_MODEL))
#define FONT_MANAGER_VARIANT_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_VARIANT_MODEL, FontManagerVariantModelClass))

typedef struct _FontManagerVariantModel FontManagerVariantModel;
typedef struct _FontManagerVariantModelClass FontManagerVariantModelClass;
typedef struct _FontManagerVariantModelPrivate FontManagerVariantModelPrivate;
enum  {
	FONT_MANAGER_VARIANT_MODEL_0_PROPERTY,
	FONT_MANAGER_VARIANT_MODEL_NUM_PROPERTIES
};
static GParamSpec* font_manager_variant_model_properties[FONT_MANAGER_VARIANT_MODEL_NUM_PROPERTIES];

#define FONT_MANAGER_TYPE_FONT_MODEL (font_manager_font_model_get_type ())
#define FONT_MANAGER_FONT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_FONT_MODEL, FontManagerFontModel))
#define FONT_MANAGER_FONT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_FONT_MODEL, FontManagerFontModelClass))
#define FONT_MANAGER_IS_FONT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_FONT_MODEL))
#define FONT_MANAGER_IS_FONT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_FONT_MODEL))
#define FONT_MANAGER_FONT_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_FONT_MODEL, FontManagerFontModelClass))

typedef struct _FontManagerFontModel FontManagerFontModel;
typedef struct _FontManagerFontModelClass FontManagerFontModelClass;
typedef struct _FontManagerFontModelPrivate FontManagerFontModelPrivate;
enum  {
	FONT_MANAGER_FONT_MODEL_0_PROPERTY,
	FONT_MANAGER_FONT_MODEL_NUM_PROPERTIES
};
static GParamSpec* font_manager_font_model_properties[FONT_MANAGER_FONT_MODEL_NUM_PROPERTIES];

struct _FontManagerBaseFontModel {
	GObject parent_instance;
	FontManagerBaseFontModelPrivate * priv;
};

struct _FontManagerBaseFontModelClass {
	GObjectClass parent_class;
};

struct _FontManagerBaseFontModelPrivate {
	GType _item_type;
	JsonArray* _entries;
	GPtrArray* _items;
	gchar* _search_term;
	FontManagerFontListFilter* _filter;
	gchar* char_search;
	JsonObject* char_support;
};

struct _Block9Data {
	int _ref_count_;
	FontManagerBaseFontModel* self;
	gint n_matches;
};

struct _Block10Data {
	int _ref_count_;
	GPtrArray* self;
	GCompareFunc compare_func;
};

struct _FontManagerVariantModel {
	FontManagerBaseFontModel parent_instance;
	FontManagerVariantModelPrivate * priv;
};

struct _FontManagerVariantModelClass {
	FontManagerBaseFontModelClass parent_class;
};

struct _FontManagerFontModel {
	FontManagerBaseFontModel parent_instance;
	FontManagerFontModelPrivate * priv;
};

struct _FontManagerFontModelClass {
	FontManagerBaseFontModelClass parent_class;
};

static gint FontManagerBaseFontModel_private_offset;
static gpointer font_manager_base_font_model_parent_class = NULL;
static GListModelInterface * font_manager_base_font_model_g_list_model_parent_iface = NULL;
static gpointer font_manager_variant_model_parent_class = NULL;
static gpointer font_manager_font_model_parent_class = NULL;

VALA_EXTERN gint64 GET_INDEX (JsonObject* o);
VALA_EXTERN GType font_manager_base_font_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerBaseFontModel, g_object_unref)
VALA_EXTERN GType font_manager_cacheable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerCacheable, g_object_unref)
VALA_EXTERN GType font_manager_font_list_filter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerFontListFilter, g_object_unref)
static GType font_manager_base_font_model_real_get_item_type (GListModel* base);
VALA_EXTERN GType font_manager_base_font_model_get_item_type (FontManagerBaseFontModel* self);
static guint font_manager_base_font_model_real_get_n_items (GListModel* base);
VALA_EXTERN GPtrArray* font_manager_base_font_model_get_items (FontManagerBaseFontModel* self);
static GObject* font_manager_base_font_model_real_get_item (GListModel* base,
                                                     guint position);
static gchar* font_manager_base_font_model_get_filepath_from_object (FontManagerBaseFontModel* self,
                                                              JsonObject* item);
static gboolean font_manager_base_font_model_array_matches (FontManagerBaseFontModel* self,
                                                     gchar** needles,
                                                     gint needles_length1,
                                                     const gchar* style,
                                                     const gchar* description);
static gboolean font_manager_base_font_model_matches_search_term (FontManagerBaseFontModel* self,
                                                           JsonObject* item);
VALA_EXTERN const gchar* font_manager_base_font_model_get_search_term (FontManagerBaseFontModel* self);
static gboolean font_manager_base_font_model_matches_filter (FontManagerBaseFontModel* self,
                                                      JsonObject* item);
VALA_EXTERN FontManagerFontListFilter* font_manager_base_font_model_get_filter (FontManagerBaseFontModel* self);
VALA_EXTERN GType font_manager_category_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerCategory, g_object_unref)
VALA_EXTERN gint font_manager_font_list_filter_get_index (FontManagerFontListFilter* self);
VALA_EXTERN GType font_manager_category_index_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean font_manager_font_list_filter_matches (FontManagerFontListFilter* self,
                                                GObject* item);
VALA_EXTERN void font_manager_base_font_model_update_items (FontManagerBaseFontModel* self);
VALA_EXTERN void font_manager_base_font_model_set_items (FontManagerBaseFontModel* self,
                                             GPtrArray* value);
VALA_EXTERN JsonArray* font_manager_base_font_model_get_entries (FontManagerBaseFontModel* self);
static void ___lambda79_ (FontManagerBaseFontModel* self,
                   JsonArray* array,
                   guint index,
                   JsonNode* node);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void ___lambda80_ (Block9Data* _data9_,
                   JsonArray* a,
                   guint i,
                   JsonNode* n);
static void ____lambda80__json_array_foreach (JsonArray* array,
                                       guint index_,
                                       JsonNode* element_node,
                                       gpointer self);
static void ____lambda79__json_array_foreach (JsonArray* array,
                                       guint index_,
                                       JsonNode* element_node,
                                       gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static gint ___lambda0__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
static gint ___lambda81_ (JsonObject* a,
                   JsonObject* b);
static gint ____lambda81__gcompare_func (gconstpointer a,
                                  gconstpointer b);
VALA_EXTERN FontManagerBaseFontModel* font_manager_base_font_model_new (void);
VALA_EXTERN FontManagerBaseFontModel* font_manager_base_font_model_construct (GType object_type);
VALA_EXTERN void font_manager_base_font_model_set_item_type (FontManagerBaseFontModel* self,
                                                 GType value);
VALA_EXTERN guint font_manager_base_font_model_get_n_items (FontManagerBaseFontModel* self);
VALA_EXTERN void font_manager_base_font_model_set_entries (FontManagerBaseFontModel* self,
                                               JsonArray* value);
VALA_EXTERN void font_manager_base_font_model_set_search_term (FontManagerBaseFontModel* self,
                                                   const gchar* value);
VALA_EXTERN void font_manager_base_font_model_set_filter (FontManagerBaseFontModel* self,
                                              FontManagerFontListFilter* value);
static GObject * font_manager_base_font_model_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static void _font_manager_base_font_model___lambda82_ (FontManagerBaseFontModel* self);
static void __font_manager_base_font_model___lambda82__g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static void _font_manager_base_font_model___lambda83_ (FontManagerBaseFontModel* self);
static gboolean __lambda84_ (FontManagerBaseFontModel* self);
static gboolean ___lambda84__gsource_func (gpointer self);
static void __font_manager_base_font_model___lambda83__g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static void font_manager_base_font_model_finalize (GObject * obj);
static GType font_manager_base_font_model_get_type_once (void);
static void _vala_font_manager_base_font_model_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_font_manager_base_font_model_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
VALA_EXTERN GType font_manager_variant_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerVariantModel, g_object_unref)
VALA_EXTERN FontManagerVariantModel* font_manager_variant_model_new (void);
VALA_EXTERN FontManagerVariantModel* font_manager_variant_model_construct (GType object_type);
static GType font_manager_variant_model_get_type_once (void);
VALA_EXTERN GType font_manager_font_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerFontModel, g_object_unref)
VALA_EXTERN FontManagerFontModel* font_manager_font_model_new (void);
VALA_EXTERN FontManagerFontModel* font_manager_font_model_construct (GType object_type);
VALA_EXTERN GListModel* font_manager_font_model_get_child_model (FontManagerFontModel* self,
                                                     GObject* item);
static GType font_manager_font_model_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

gint64
GET_INDEX (JsonObject* o)
{
	gint64 result;
	g_return_val_if_fail (o != NULL, 0LL);
	result = json_object_get_int_member (o, "_index");
	return result;
}

static inline gpointer
font_manager_base_font_model_get_instance_private (FontManagerBaseFontModel* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerBaseFontModel_private_offset);
}

static GType
font_manager_base_font_model_real_get_item_type (GListModel* base)
{
	FontManagerBaseFontModel * self;
	GType _tmp0_;
	GType result;
	self = (FontManagerBaseFontModel*) base;
	_tmp0_ = self->priv->_item_type;
	result = _tmp0_;
	return result;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static guint
font_manager_base_font_model_real_get_n_items (GListModel* base)
{
	FontManagerBaseFontModel * self;
	gint _tmp0_ = 0;
	GPtrArray* _tmp1_;
	guint result;
	self = (FontManagerBaseFontModel*) base;
	_tmp1_ = self->priv->_items;
	if (_tmp1_ != NULL) {
		GPtrArray* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->_items;
		_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = 0;
	}
	result = (guint) _tmp0_;
	return result;
}

static GObject*
font_manager_base_font_model_real_get_item (GListModel* base,
                                            guint position)
{
	FontManagerBaseFontModel * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GPtrArray* _tmp2_;
	GPtrArray* _tmp3_;
	gconstpointer _tmp4_;
	GObject* retval = NULL;
	GType _tmp5_;
	GObject* _tmp6_;
	GObject* _tmp7_;
	GObject* _tmp8_;
	GPtrArray* _tmp9_;
	gconstpointer _tmp10_;
	GObject* result;
	self = (FontManagerBaseFontModel*) base;
	_tmp2_ = self->priv->_items;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_list_model_get_n_items ((GListModel*) self) < ((guint) 1);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = position >= g_list_model_get_n_items ((GListModel*) self);
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp3_ = self->priv->_items;
	_tmp4_ = g_ptr_array_index (_tmp3_, position);
	g_return_val_if_fail (((JsonObject*) _tmp4_) != NULL, NULL);
	_tmp5_ = self->priv->_item_type;
	_tmp6_ = g_object_new (_tmp5_, NULL);
	_tmp7_ = G_IS_INITIALLY_UNOWNED (_tmp6_) ? g_object_ref_sink (_tmp6_) : _tmp6_;
	retval = _tmp7_;
	_tmp8_ = retval;
	_tmp9_ = self->priv->_items;
	_tmp10_ = g_ptr_array_index (_tmp9_, position);
	g_object_set (_tmp8_, "source-object", (JsonObject*) _tmp10_, NULL, NULL);
	result = retval;
	return result;
}

static gchar*
font_manager_base_font_model_get_filepath_from_object (FontManagerBaseFontModel* self,
                                                       JsonObject* item)
{
	GObject* obj = NULL;
	GType _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	GObject* _tmp3_;
	gchar* _tmp4_ = NULL;
	GType _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = self->priv->_item_type;
	_tmp1_ = g_object_new (_tmp0_, NULL);
	_tmp2_ = G_IS_INITIALLY_UNOWNED (_tmp1_) ? g_object_ref_sink (_tmp1_) : _tmp1_;
	obj = _tmp2_;
	_tmp3_ = obj;
	g_object_set (_tmp3_, "source-object", item, NULL, NULL);
	_tmp5_ = self->priv->_item_type;
	if (_tmp5_ == font_manager_font_get_type ()) {
		GObject* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = obj;
		g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, font_manager_font_get_type (), FontManagerFont), "filepath", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp8_;
	} else {
		const gchar* _tmp9_ = NULL;
		GType _tmp10_;
		gchar* _tmp14_;
		_tmp10_ = self->priv->_item_type;
		if (_tmp10_ == font_manager_family_get_type ()) {
			GObject* _tmp11_;
			JsonObject* _tmp12_;
			const gchar* _tmp13_;
			_tmp11_ = obj;
			_tmp12_ = font_manager_family_get_default_variant (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, font_manager_family_get_type (), FontManagerFamily));
			_tmp13_ = json_object_get_string_member (_tmp12_, "filepath");
			_tmp9_ = _tmp13_;
		} else {
			_tmp9_ = "";
		}
		_tmp14_ = g_strdup (_tmp9_);
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp14_;
	}
	result = _tmp4_;
	_g_object_unref0 (obj);
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
font_manager_base_font_model_array_matches (FontManagerBaseFontModel* self,
                                            gchar** needles,
                                            gint needles_length1,
                                            const gchar* style,
                                            const gchar* description)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (style != NULL, FALSE);
	g_return_val_if_fail (description != NULL, FALSE);
	{
		gchar** term_collection = NULL;
		gint term_collection_length1 = 0;
		gint _term_collection_size_ = 0;
		gint term_it = 0;
		term_collection = needles;
		term_collection_length1 = needles_length1;
		for (term_it = 0; term_it < term_collection_length1; term_it = term_it + 1) {
			gchar* _tmp0_;
			gchar* term = NULL;
			_tmp0_ = g_strdup (term_collection[term_it]);
			term = _tmp0_;
			{
				gboolean _tmp1_ = FALSE;
				const gchar* _tmp2_;
				_tmp2_ = term;
				if (string_contains (style, _tmp2_)) {
					_tmp1_ = TRUE;
				} else {
					const gchar* _tmp3_;
					_tmp3_ = term;
					_tmp1_ = string_contains (description, _tmp3_);
				}
				if (_tmp1_) {
					_g_free0 (term);
					continue;
				} else {
					result = FALSE;
					_g_free0 (term);
					return result;
				}
				_g_free0 (term);
			}
		}
	}
	result = TRUE;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static gboolean
font_manager_base_font_model_matches_search_term (FontManagerBaseFontModel* self,
                                                  JsonObject* item)
{
	gboolean item_matches = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gchar* search = NULL;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	item_matches = TRUE;
	_tmp1_ = self->priv->_search_term;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = self->priv->_search_term;
		_tmp3_ = string_strip (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, "") == 0;
		_g_free0 (_tmp4_);
	}
	if (_tmp0_) {
		result = item_matches;
		return result;
	}
	_tmp5_ = self->priv->_search_term;
	_tmp6_ = string_strip (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_utf8_casefold (_tmp7_, (gssize) -1);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	search = _tmp9_;
	_tmp10_ = search;
	if (g_str_has_prefix (_tmp10_, G_DIR_SEPARATOR_S)) {
		gchar* filepath = NULL;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp11_ = font_manager_base_font_model_get_filepath_from_object (self, item);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_utf8_casefold (_tmp12_, (gssize) -1);
		_tmp14_ = _tmp13_;
		_g_free0 (_tmp12_);
		filepath = _tmp14_;
		_tmp15_ = filepath;
		_tmp16_ = search;
		item_matches = string_contains (_tmp15_, _tmp16_);
		_g_free0 (filepath);
	} else {
		const gchar* _tmp17_;
		_tmp17_ = search;
		if (g_str_has_prefix (_tmp17_, G_SEARCHPATH_SEPARATOR_S)) {
			gchar* needle = NULL;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			const gchar* _tmp20_;
			gchar* family = NULL;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			gboolean _tmp23_ = FALSE;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			JsonObject* _tmp31_;
			const gchar* _tmp32_;
			gboolean _tmp33_ = FALSE;
			_tmp18_ = search;
			_tmp19_ = string_replace (_tmp18_, G_SEARCHPATH_SEPARATOR_S, "");
			needle = _tmp19_;
			_tmp20_ = needle;
			if (g_strcmp0 (_tmp20_, "") == 0) {
				result = FALSE;
				_g_free0 (needle);
				_g_free0 (search);
				return result;
			}
			_tmp21_ = json_object_get_string_member (item, "family");
			_tmp22_ = g_strdup (_tmp21_);
			family = _tmp22_;
			_tmp24_ = self->priv->char_search;
			_tmp25_ = needle;
			if (g_strcmp0 (_tmp24_, _tmp25_) != 0) {
				_tmp23_ = TRUE;
			} else {
				JsonObject* _tmp26_;
				_tmp26_ = self->priv->char_support;
				_tmp23_ = _tmp26_ == NULL;
			}
			if (_tmp23_) {
				const gchar* _tmp27_;
				gchar* _tmp28_;
				const gchar* _tmp29_;
				JsonObject* _tmp30_;
				_tmp27_ = needle;
				_tmp28_ = g_strdup (_tmp27_);
				_g_free0 (self->priv->char_search);
				self->priv->char_search = _tmp28_;
				_tmp29_ = self->priv->char_search;
				_tmp30_ = font_manager_get_available_fonts_for_chars (_tmp29_);
				_json_object_unref0 (self->priv->char_support);
				self->priv->char_support = _tmp30_;
			}
			_tmp31_ = self->priv->char_support;
			_tmp32_ = family;
			item_matches = json_object_has_member (_tmp31_, _tmp32_);
			if (item_matches) {
				_tmp33_ = json_object_has_member (item, "style");
			} else {
				_tmp33_ = FALSE;
			}
			if (_tmp33_) {
				JsonObject* family_obj = NULL;
				JsonObject* _tmp34_;
				const gchar* _tmp35_;
				JsonObject* _tmp36_;
				JsonObject* _tmp37_;
				JsonObject* _tmp38_;
				const gchar* _tmp39_;
				_tmp34_ = self->priv->char_support;
				_tmp35_ = family;
				_tmp36_ = json_object_get_object_member (_tmp34_, _tmp35_);
				_tmp37_ = _json_object_ref0 (_tmp36_);
				family_obj = _tmp37_;
				_tmp38_ = family_obj;
				_tmp39_ = json_object_get_string_member (item, "style");
				item_matches = json_object_has_member (_tmp38_, _tmp39_);
				_json_object_unref0 (family_obj);
			}
			_g_free0 (family);
			_g_free0 (needle);
		} else {
			gchar* family = NULL;
			const gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* description = NULL;
			const gchar* _tmp42_;
			gchar* _tmp43_;
			const gchar* _tmp44_;
			const gchar* _tmp45_;
			gboolean _tmp48_ = FALSE;
			_tmp40_ = json_object_get_string_member (item, "family");
			_tmp41_ = g_utf8_casefold (_tmp40_, (gssize) -1);
			family = _tmp41_;
			_tmp42_ = json_object_get_string_member (item, "description");
			_tmp43_ = g_utf8_casefold (_tmp42_, (gssize) -1);
			description = _tmp43_;
			_tmp44_ = family;
			_tmp45_ = search;
			item_matches = string_contains (_tmp44_, _tmp45_);
			if (!item_matches) {
				const gchar* _tmp46_;
				const gchar* _tmp47_;
				_tmp46_ = description;
				_tmp47_ = search;
				item_matches = string_contains (_tmp46_, _tmp47_);
			}
			if (!item_matches) {
				_tmp48_ = json_object_has_member (item, "style");
			} else {
				_tmp48_ = FALSE;
			}
			if (_tmp48_) {
				gchar** needles = NULL;
				const gchar* _tmp49_;
				gchar** _tmp50_;
				gchar** _tmp51_;
				gint needles_length1;
				gint _needles_size_;
				gchar* style = NULL;
				const gchar* _tmp52_;
				gchar* _tmp53_;
				gchar** _tmp54_;
				gint _tmp54__length1;
				const gchar* _tmp55_;
				const gchar* _tmp56_;
				_tmp49_ = search;
				_tmp51_ = _tmp50_ = g_strsplit_set (_tmp49_, " ", -1);
				needles = _tmp51_;
				needles_length1 = _vala_array_length (_tmp50_);
				_needles_size_ = needles_length1;
				_tmp52_ = json_object_get_string_member (item, "style");
				_tmp53_ = g_utf8_casefold (_tmp52_, (gssize) -1);
				style = _tmp53_;
				_tmp54_ = needles;
				_tmp54__length1 = needles_length1;
				_tmp55_ = style;
				_tmp56_ = description;
				item_matches = font_manager_base_font_model_array_matches (self, _tmp54_, (gint) _tmp54__length1, _tmp55_, _tmp56_);
				_g_free0 (style);
				needles = (_vala_array_free (needles, needles_length1, (GDestroyNotify) g_free), NULL);
			}
			_g_free0 (description);
			_g_free0 (family);
		}
	}
	result = item_matches;
	_g_free0 (search);
	return result;
}

static gboolean
font_manager_base_font_model_matches_filter (FontManagerBaseFontModel* self,
                                             JsonObject* item)
{
	gboolean _tmp0_ = FALSE;
	FontManagerFontListFilter* _tmp1_;
	GType _tmp7_ = 0UL;
	GType type = 0UL;
	GObject* object = NULL;
	GObject* _tmp8_;
	GObject* _tmp9_;
	FontManagerFontListFilter* _tmp10_;
	GObject* _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp1_ = self->priv->_filter;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		FontManagerFontListFilter* _tmp3_;
		_tmp3_ = self->priv->_filter;
		if (FONT_MANAGER_IS_CATEGORY (_tmp3_)) {
			FontManagerFontListFilter* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			_tmp4_ = self->priv->_filter;
			_tmp5_ = font_manager_font_list_filter_get_index (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp2_ = _tmp6_ == ((gint) FONT_MANAGER_CATEGORY_INDEX_ALL);
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	if (json_object_has_member (item, "filepath")) {
		_tmp7_ = font_manager_font_get_type ();
	} else {
		_tmp7_ = font_manager_family_get_type ();
	}
	type = _tmp7_;
	_tmp8_ = g_object_new (type, FONT_MANAGER_JSON_PROXY_SOURCE, item, NULL, NULL);
	_tmp9_ = G_IS_INITIALLY_UNOWNED (_tmp8_) ? g_object_ref_sink (_tmp8_) : _tmp8_;
	object = _tmp9_;
	_tmp10_ = self->priv->_filter;
	_tmp11_ = object;
	result = font_manager_font_list_filter_matches (_tmp10_, _tmp11_);
	_g_object_unref0 (object);
	return result;
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		FontManagerBaseFontModel* self;
		self = _data9_->self;
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static gpointer
_json_array_ref0 (gpointer self)
{
	return self ? json_array_ref (self) : NULL;
}

static void
___lambda80_ (Block9Data* _data9_,
              JsonArray* a,
              guint i,
              JsonNode* n)
{
	FontManagerBaseFontModel* self;
	JsonObject* v = NULL;
	JsonObject* _tmp0_;
	JsonObject* _tmp1_;
	gboolean _tmp2_ = FALSE;
	JsonObject* _tmp3_;
	self = _data9_->self;
	g_return_if_fail (a != NULL);
	g_return_if_fail (n != NULL);
	_tmp0_ = json_node_get_object (n);
	_tmp1_ = _json_object_ref0 (_tmp0_);
	v = _tmp1_;
	_tmp3_ = v;
	if (font_manager_base_font_model_matches_search_term (self, _tmp3_)) {
		JsonObject* _tmp4_;
		_tmp4_ = v;
		_tmp2_ = font_manager_base_font_model_matches_filter (self, _tmp4_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint _tmp5_;
		_tmp5_ = _data9_->n_matches;
		_data9_->n_matches = _tmp5_ + 1;
	}
	_json_object_unref0 (v);
}

static void
____lambda80__json_array_foreach (JsonArray* array,
                                  guint index_,
                                  JsonNode* element_node,
                                  gpointer self)
{
	___lambda80_ (self, array, index_, element_node);
}

static void
___lambda79_ (FontManagerBaseFontModel* self,
              JsonArray* array,
              guint index,
              JsonNode* node)
{
	JsonObject* item = NULL;
	JsonObject* _tmp0_;
	JsonObject* _tmp1_;
	JsonObject* _tmp2_;
	g_return_if_fail (array != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = json_node_get_object (node);
	_tmp1_ = _json_object_ref0 (_tmp0_);
	item = _tmp1_;
	_tmp2_ = item;
	if (json_object_has_member (_tmp2_, "variations")) {
		Block9Data* _data9_;
		JsonArray* variants = NULL;
		JsonObject* _tmp3_;
		JsonArray* _tmp4_;
		JsonArray* _tmp5_;
		JsonArray* _tmp6_;
		JsonObject* _tmp7_;
		_data9_ = g_slice_new0 (Block9Data);
		_data9_->_ref_count_ = 1;
		_data9_->self = g_object_ref (self);
		_tmp3_ = item;
		_tmp4_ = json_object_get_array_member (_tmp3_, "variations");
		_tmp5_ = _json_array_ref0 (_tmp4_);
		variants = _tmp5_;
		_data9_->n_matches = 0;
		_tmp6_ = variants;
		json_array_foreach_element (_tmp6_, ____lambda80__json_array_foreach, _data9_);
		_tmp7_ = item;
		json_object_set_int_member (_tmp7_, "n-variations", (gint64) _data9_->n_matches);
		if (_data9_->n_matches > 0) {
			GPtrArray* _tmp8_;
			JsonObject* _tmp9_;
			_tmp8_ = self->priv->_items;
			_tmp9_ = item;
			g_ptr_array_add (_tmp8_, _tmp9_);
		}
		_json_array_unref0 (variants);
		block9_data_unref (_data9_);
		_data9_ = NULL;
	} else {
		gboolean _tmp10_ = FALSE;
		JsonObject* _tmp11_;
		_tmp11_ = item;
		if (font_manager_base_font_model_matches_search_term (self, _tmp11_)) {
			JsonObject* _tmp12_;
			_tmp12_ = item;
			_tmp10_ = font_manager_base_font_model_matches_filter (self, _tmp12_);
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			GPtrArray* _tmp13_;
			JsonObject* _tmp14_;
			_tmp13_ = self->priv->_items;
			_tmp14_ = item;
			g_ptr_array_add (_tmp13_, _tmp14_);
		}
	}
	_json_object_unref0 (item);
}

static void
____lambda79__json_array_foreach (JsonArray* array,
                                  guint index_,
                                  JsonNode* element_node,
                                  gpointer self)
{
	___lambda79_ ((FontManagerBaseFontModel*) self, array, index_, element_node);
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		GPtrArray* self;
		self = _data10_->self;
		_g_ptr_array_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static gint
__lambda0_ (Block10Data* _data10_,
            gconstpointer** a,
            gconstpointer** b)
{
	GPtrArray* self;
	gint result;
	self = _data10_->self;
	result = _data10_->compare_func ((gconstpointer**) (*a), (gconstpointer**) (*b));
	return result;
}

static gint
___lambda0__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda0_ (self, a, b);
	return result;
}

static void
vala_g_ptr_array_sort (GPtrArray* self,
                       GCompareFunc compare_func)
{
	Block10Data* _data10_;
	g_return_if_fail (self != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_ptr_array_ref (self);
	_data10_->compare_func = compare_func;
	g_ptr_array_sort_with_data (self, ___lambda0__gcompare_data_func, _data10_);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

static gint
___lambda81_ (JsonObject* a,
              JsonObject* b)
{
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	result = (gint) (GET_INDEX (a) - GET_INDEX (b));
	return result;
}

static gint
____lambda81__gcompare_func (gconstpointer a,
                             gconstpointer b)
{
	gint result;
	result = ___lambda81_ ((JsonObject*) a, (JsonObject*) b);
	return result;
}

void
font_manager_base_font_model_update_items (FontManagerBaseFontModel* self)
{
	guint n_items = 0U;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	JsonArray* _tmp2_;
	g_return_if_fail (self != NULL);
	n_items = g_list_model_get_n_items ((GListModel*) self);
	font_manager_base_font_model_set_items (self, NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, NULL);
	_tmp1_ = _tmp0_;
	font_manager_base_font_model_set_items (self, _tmp1_);
	_g_ptr_array_unref0 (_tmp1_);
	if (n_items > ((guint) 0)) {
		g_list_model_items_changed ((GListModel*) self, (guint) 0, n_items, (guint) 0);
	}
	_tmp2_ = self->priv->_entries;
	if (_tmp2_ != NULL) {
		JsonArray* _tmp3_;
		GPtrArray* _tmp4_;
		_tmp3_ = self->priv->_entries;
		json_array_foreach_element (_tmp3_, ____lambda79__json_array_foreach, self);
		_tmp4_ = self->priv->_items;
		vala_g_ptr_array_sort (_tmp4_, ____lambda81__gcompare_func);
	}
	g_list_model_items_changed ((GListModel*) self, (guint) 0, (guint) 0, g_list_model_get_n_items ((GListModel*) self));
	g_signal_emit (self, font_manager_base_font_model_signals[FONT_MANAGER_BASE_FONT_MODEL_ITEMS_UPDATED_SIGNAL], 0);
	return;
}

FontManagerBaseFontModel*
font_manager_base_font_model_construct (GType object_type)
{
	FontManagerBaseFontModel * self = NULL;
	self = (FontManagerBaseFontModel*) g_object_new (object_type, NULL);
	return self;
}

FontManagerBaseFontModel*
font_manager_base_font_model_new (void)
{
	return font_manager_base_font_model_construct (FONT_MANAGER_TYPE_BASE_FONT_MODEL);
}

GType
font_manager_base_font_model_get_item_type (FontManagerBaseFontModel* self)
{
	GType result;
	g_return_val_if_fail (self != NULL, 0UL);
	result = self->priv->_item_type;
	return result;
}

void
font_manager_base_font_model_set_item_type (FontManagerBaseFontModel* self,
                                            GType value)
{
	GType old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_base_font_model_get_item_type (self);
	if (old_value != value) {
		self->priv->_item_type = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_base_font_model_properties[FONT_MANAGER_BASE_FONT_MODEL_ITEM_TYPE_PROPERTY]);
	}
}

guint
font_manager_base_font_model_get_n_items (FontManagerBaseFontModel* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_list_model_get_n_items ((GListModel*) self);
	return result;
}

JsonArray*
font_manager_base_font_model_get_entries (FontManagerBaseFontModel* self)
{
	JsonArray* result;
	JsonArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_entries;
	result = _tmp0_;
	return result;
}

void
font_manager_base_font_model_set_entries (FontManagerBaseFontModel* self,
                                          JsonArray* value)
{
	JsonArray* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_base_font_model_get_entries (self);
	if (old_value != value) {
		JsonArray* _tmp0_;
		_tmp0_ = _json_array_ref0 (value);
		_json_array_unref0 (self->priv->_entries);
		self->priv->_entries = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_base_font_model_properties[FONT_MANAGER_BASE_FONT_MODEL_ENTRIES_PROPERTY]);
	}
}

GPtrArray*
font_manager_base_font_model_get_items (FontManagerBaseFontModel* self)
{
	GPtrArray* result;
	GPtrArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_items;
	result = _tmp0_;
	return result;
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

void
font_manager_base_font_model_set_items (FontManagerBaseFontModel* self,
                                        GPtrArray* value)
{
	GPtrArray* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_base_font_model_get_items (self);
	if (old_value != value) {
		GPtrArray* _tmp0_;
		_tmp0_ = _g_ptr_array_ref0 (value);
		_g_ptr_array_unref0 (self->priv->_items);
		self->priv->_items = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_base_font_model_properties[FONT_MANAGER_BASE_FONT_MODEL_ITEMS_PROPERTY]);
	}
}

const gchar*
font_manager_base_font_model_get_search_term (FontManagerBaseFontModel* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_search_term;
	result = _tmp0_;
	return result;
}

void
font_manager_base_font_model_set_search_term (FontManagerBaseFontModel* self,
                                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_base_font_model_get_search_term (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_search_term);
		self->priv->_search_term = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_base_font_model_properties[FONT_MANAGER_BASE_FONT_MODEL_SEARCH_TERM_PROPERTY]);
	}
}

FontManagerFontListFilter*
font_manager_base_font_model_get_filter (FontManagerBaseFontModel* self)
{
	FontManagerFontListFilter* result;
	FontManagerFontListFilter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filter;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
font_manager_base_font_model_set_filter (FontManagerBaseFontModel* self,
                                         FontManagerFontListFilter* value)
{
	FontManagerFontListFilter* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_base_font_model_get_filter (self);
	if (old_value != value) {
		FontManagerFontListFilter* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_filter);
		self->priv->_filter = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_base_font_model_properties[FONT_MANAGER_BASE_FONT_MODEL_FILTER_PROPERTY]);
	}
}

static void
_font_manager_base_font_model___lambda82_ (FontManagerBaseFontModel* self)
{
	font_manager_base_font_model_update_items (self);
}

static void
__font_manager_base_font_model___lambda82__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	_font_manager_base_font_model___lambda82_ ((FontManagerBaseFontModel*) self);
}

static gboolean
__lambda84_ (FontManagerBaseFontModel* self)
{
	gboolean result;
	font_manager_base_font_model_update_items (self);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda84__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda84_ ((FontManagerBaseFontModel*) self);
	return result;
}

static void
_font_manager_base_font_model___lambda83_ (FontManagerBaseFontModel* self)
{
	FontManagerFontListFilter* _tmp0_;
	_tmp0_ = self->priv->_filter;
	if (_tmp0_ == NULL) {
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda84__gsource_func, g_object_ref (self), g_object_unref);
}

static void
__font_manager_base_font_model___lambda83__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	_font_manager_base_font_model___lambda83_ ((FontManagerBaseFontModel*) self);
}

static GObject *
font_manager_base_font_model_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FontManagerBaseFontModel * self;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	parent_class = G_OBJECT_CLASS (font_manager_base_font_model_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_BASE_FONT_MODEL, FontManagerBaseFontModel);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, NULL);
	_tmp1_ = _tmp0_;
	font_manager_base_font_model_set_items (self, _tmp1_);
	_g_ptr_array_unref0 (_tmp1_);
	g_signal_connect_object ((GObject*) self, "notify::entries", (GCallback) __font_manager_base_font_model___lambda82__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::filter", (GCallback) __font_manager_base_font_model___lambda83__g_object_notify, self, G_CONNECT_AFTER);
	return obj;
}

static void
font_manager_base_font_model_class_init (FontManagerBaseFontModelClass * klass,
                                         gpointer klass_data)
{
	font_manager_base_font_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerBaseFontModel_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_base_font_model_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_base_font_model_set_property;
	G_OBJECT_CLASS (klass)->constructor = font_manager_base_font_model_constructor;
	G_OBJECT_CLASS (klass)->finalize = font_manager_base_font_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BASE_FONT_MODEL_ITEM_TYPE_PROPERTY, font_manager_base_font_model_properties[FONT_MANAGER_BASE_FONT_MODEL_ITEM_TYPE_PROPERTY] = g_param_spec_gtype ("item-type", "item-type", "item-type", G_TYPE_OBJECT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BASE_FONT_MODEL_N_ITEMS_PROPERTY, font_manager_base_font_model_properties[FONT_MANAGER_BASE_FONT_MODEL_N_ITEMS_PROPERTY] = g_param_spec_uint ("n-items", "n-items", "n-items", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BASE_FONT_MODEL_ENTRIES_PROPERTY, font_manager_base_font_model_properties[FONT_MANAGER_BASE_FONT_MODEL_ENTRIES_PROPERTY] = g_param_spec_boxed ("entries", "entries", "entries", json_array_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BASE_FONT_MODEL_ITEMS_PROPERTY, font_manager_base_font_model_properties[FONT_MANAGER_BASE_FONT_MODEL_ITEMS_PROPERTY] = g_param_spec_boxed ("items", "items", "items", G_TYPE_PTR_ARRAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BASE_FONT_MODEL_SEARCH_TERM_PROPERTY, font_manager_base_font_model_properties[FONT_MANAGER_BASE_FONT_MODEL_SEARCH_TERM_PROPERTY] = g_param_spec_string ("search-term", "search-term", "search-term", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BASE_FONT_MODEL_FILTER_PROPERTY, font_manager_base_font_model_properties[FONT_MANAGER_BASE_FONT_MODEL_FILTER_PROPERTY] = g_param_spec_object ("filter", "filter", "filter", FONT_MANAGER_TYPE_FONT_LIST_FILTER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	font_manager_base_font_model_signals[FONT_MANAGER_BASE_FONT_MODEL_ITEMS_UPDATED_SIGNAL] = g_signal_new ("items-updated", FONT_MANAGER_TYPE_BASE_FONT_MODEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
font_manager_base_font_model_g_list_model_interface_init (GListModelInterface * iface,
                                                          gpointer iface_data)
{
	font_manager_base_font_model_g_list_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_item_type = (GType (*) (GListModel*)) font_manager_base_font_model_real_get_item_type;
	iface->get_n_items = (guint (*) (GListModel*)) font_manager_base_font_model_real_get_n_items;
	iface->get_item = (GObject* (*) (GListModel*, guint)) font_manager_base_font_model_real_get_item;
}

static void
font_manager_base_font_model_instance_init (FontManagerBaseFontModel * self,
                                            gpointer klass)
{
	self->priv = font_manager_base_font_model_get_instance_private (self);
	self->priv->_item_type = G_TYPE_OBJECT;
	self->priv->_entries = NULL;
	self->priv->_items = NULL;
	self->priv->_search_term = NULL;
	self->priv->_filter = NULL;
	self->priv->char_search = NULL;
	self->priv->char_support = NULL;
}

static void
font_manager_base_font_model_finalize (GObject * obj)
{
	FontManagerBaseFontModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_BASE_FONT_MODEL, FontManagerBaseFontModel);
	_json_array_unref0 (self->priv->_entries);
	_g_ptr_array_unref0 (self->priv->_items);
	_g_free0 (self->priv->_search_term);
	_g_object_unref0 (self->priv->_filter);
	_g_free0 (self->priv->char_search);
	_json_object_unref0 (self->priv->char_support);
	G_OBJECT_CLASS (font_manager_base_font_model_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_base_font_model_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerBaseFontModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_base_font_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerBaseFontModel), 0, (GInstanceInitFunc) font_manager_base_font_model_instance_init, NULL };
	static const GInterfaceInfo g_list_model_info = { (GInterfaceInitFunc) font_manager_base_font_model_g_list_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType font_manager_base_font_model_type_id;
	font_manager_base_font_model_type_id = g_type_register_static (G_TYPE_OBJECT, "FontManagerBaseFontModel", &g_define_type_info, 0);
	g_type_add_interface_static (font_manager_base_font_model_type_id, g_list_model_get_type (), &g_list_model_info);
	FontManagerBaseFontModel_private_offset = g_type_add_instance_private (font_manager_base_font_model_type_id, sizeof (FontManagerBaseFontModelPrivate));
	return font_manager_base_font_model_type_id;
}

GType
font_manager_base_font_model_get_type (void)
{
	static volatile gsize font_manager_base_font_model_type_id__once = 0;
	if (g_once_init_enter (&font_manager_base_font_model_type_id__once)) {
		GType font_manager_base_font_model_type_id;
		font_manager_base_font_model_type_id = font_manager_base_font_model_get_type_once ();
		g_once_init_leave (&font_manager_base_font_model_type_id__once, font_manager_base_font_model_type_id);
	}
	return font_manager_base_font_model_type_id__once;
}

static void
_vala_font_manager_base_font_model_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	FontManagerBaseFontModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_BASE_FONT_MODEL, FontManagerBaseFontModel);
	switch (property_id) {
		case FONT_MANAGER_BASE_FONT_MODEL_ITEM_TYPE_PROPERTY:
		g_value_set_gtype (value, font_manager_base_font_model_get_item_type (self));
		break;
		case FONT_MANAGER_BASE_FONT_MODEL_N_ITEMS_PROPERTY:
		g_value_set_uint (value, font_manager_base_font_model_get_n_items (self));
		break;
		case FONT_MANAGER_BASE_FONT_MODEL_ENTRIES_PROPERTY:
		g_value_set_boxed (value, font_manager_base_font_model_get_entries (self));
		break;
		case FONT_MANAGER_BASE_FONT_MODEL_ITEMS_PROPERTY:
		g_value_set_boxed (value, font_manager_base_font_model_get_items (self));
		break;
		case FONT_MANAGER_BASE_FONT_MODEL_SEARCH_TERM_PROPERTY:
		g_value_set_string (value, font_manager_base_font_model_get_search_term (self));
		break;
		case FONT_MANAGER_BASE_FONT_MODEL_FILTER_PROPERTY:
		g_value_set_object (value, font_manager_base_font_model_get_filter (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_base_font_model_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	FontManagerBaseFontModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_BASE_FONT_MODEL, FontManagerBaseFontModel);
	switch (property_id) {
		case FONT_MANAGER_BASE_FONT_MODEL_ITEM_TYPE_PROPERTY:
		font_manager_base_font_model_set_item_type (self, g_value_get_gtype (value));
		break;
		case FONT_MANAGER_BASE_FONT_MODEL_ENTRIES_PROPERTY:
		font_manager_base_font_model_set_entries (self, g_value_get_boxed (value));
		break;
		case FONT_MANAGER_BASE_FONT_MODEL_ITEMS_PROPERTY:
		font_manager_base_font_model_set_items (self, g_value_get_boxed (value));
		break;
		case FONT_MANAGER_BASE_FONT_MODEL_SEARCH_TERM_PROPERTY:
		font_manager_base_font_model_set_search_term (self, g_value_get_string (value));
		break;
		case FONT_MANAGER_BASE_FONT_MODEL_FILTER_PROPERTY:
		font_manager_base_font_model_set_filter (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

FontManagerVariantModel*
font_manager_variant_model_construct (GType object_type)
{
	FontManagerVariantModel * self = NULL;
	self = (FontManagerVariantModel*) font_manager_base_font_model_construct (object_type);
	font_manager_base_font_model_set_item_type ((FontManagerBaseFontModel*) self, font_manager_font_get_type ());
	return self;
}

FontManagerVariantModel*
font_manager_variant_model_new (void)
{
	return font_manager_variant_model_construct (FONT_MANAGER_TYPE_VARIANT_MODEL);
}

static void
font_manager_variant_model_class_init (FontManagerVariantModelClass * klass,
                                       gpointer klass_data)
{
	font_manager_variant_model_parent_class = g_type_class_peek_parent (klass);
}

static void
font_manager_variant_model_instance_init (FontManagerVariantModel * self,
                                          gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
font_manager_variant_model_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerVariantModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_variant_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerVariantModel), 0, (GInstanceInitFunc) font_manager_variant_model_instance_init, NULL };
	GType font_manager_variant_model_type_id;
	font_manager_variant_model_type_id = g_type_register_static (FONT_MANAGER_TYPE_BASE_FONT_MODEL, "FontManagerVariantModel", &g_define_type_info, 0);
	return font_manager_variant_model_type_id;
}

GType
font_manager_variant_model_get_type (void)
{
	static volatile gsize font_manager_variant_model_type_id__once = 0;
	if (g_once_init_enter (&font_manager_variant_model_type_id__once)) {
		GType font_manager_variant_model_type_id;
		font_manager_variant_model_type_id = font_manager_variant_model_get_type_once ();
		g_once_init_leave (&font_manager_variant_model_type_id__once, font_manager_variant_model_type_id);
	}
	return font_manager_variant_model_type_id__once;
}

FontManagerFontModel*
font_manager_font_model_construct (GType object_type)
{
	FontManagerFontModel * self = NULL;
	self = (FontManagerFontModel*) font_manager_base_font_model_construct (object_type);
	font_manager_base_font_model_set_item_type ((FontManagerBaseFontModel*) self, font_manager_family_get_type ());
	return self;
}

FontManagerFontModel*
font_manager_font_model_new (void)
{
	return font_manager_font_model_construct (FONT_MANAGER_TYPE_FONT_MODEL);
}

GListModel*
font_manager_font_model_get_child_model (FontManagerFontModel* self,
                                         GObject* item)
{
	FontManagerVariantModel* child = NULL;
	FontManagerVariantModel* _tmp0_;
	GBindingFlags flags = 0U;
	FontManagerVariantModel* _tmp1_;
	FontManagerVariantModel* _tmp2_;
	FontManagerVariantModel* _tmp3_;
	JsonArray* _tmp4_;
	JsonArray* _tmp5_;
	JsonArray* _tmp6_;
	GListModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	if (!G_TYPE_CHECK_INSTANCE_TYPE (item, font_manager_family_get_type ())) {
		result = NULL;
		return result;
	}
	_tmp0_ = font_manager_variant_model_new ();
	child = _tmp0_;
	flags = G_BINDING_SYNC_CREATE;
	_tmp1_ = child;
	g_object_bind_property_with_closures ((GObject*) self, "filter", (GObject*) _tmp1_, "filter", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp2_ = child;
	g_object_bind_property_with_closures ((GObject*) self, "search-term", (GObject*) _tmp2_, "search-term", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp3_ = child;
	g_object_get (G_TYPE_CHECK_INSTANCE_CAST (item, font_manager_family_get_type (), FontManagerFamily), "variations", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	font_manager_base_font_model_set_entries ((FontManagerBaseFontModel*) _tmp3_, _tmp6_);
	_json_array_unref0 (_tmp6_);
	result = (GListModel*) child;
	return result;
}

static void
font_manager_font_model_class_init (FontManagerFontModelClass * klass,
                                    gpointer klass_data)
{
	font_manager_font_model_parent_class = g_type_class_peek_parent (klass);
}

static void
font_manager_font_model_instance_init (FontManagerFontModel * self,
                                       gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
font_manager_font_model_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerFontModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_font_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerFontModel), 0, (GInstanceInitFunc) font_manager_font_model_instance_init, NULL };
	GType font_manager_font_model_type_id;
	font_manager_font_model_type_id = g_type_register_static (FONT_MANAGER_TYPE_BASE_FONT_MODEL, "FontManagerFontModel", &g_define_type_info, 0);
	return font_manager_font_model_type_id;
}

GType
font_manager_font_model_get_type (void)
{
	static volatile gsize font_manager_font_model_type_id__once = 0;
	if (g_once_init_enter (&font_manager_font_model_type_id__once)) {
		GType font_manager_font_model_type_id;
		font_manager_font_model_type_id = font_manager_font_model_get_type_once ();
		g_once_init_leave (&font_manager_font_model_type_id__once, font_manager_font_model_type_id);
	}
	return font_manager_font_model_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

