/* SelectionArea.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SelectionArea.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2017 Santiago León O.
 *                         2017 Adam Bieńkowski
 *                         2025 elementary, Inc. (https://elementary.io)
 */

#include "gala.h"
#include <glib-object.h>
#include <glib.h>
#include <graphene-gobject.h>
#include <clutter/clutter.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <meta/meta-plugin.h>
#include <meta/display.h>
#include <meta/common.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_SELECTION_AREA (gala_selection_area_get_type ())
#define GALA_SELECTION_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SELECTION_AREA, GalaSelectionArea))
#define GALA_SELECTION_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SELECTION_AREA, GalaSelectionAreaClass))
#define GALA_IS_SELECTION_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SELECTION_AREA))
#define GALA_IS_SELECTION_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SELECTION_AREA))
#define GALA_SELECTION_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SELECTION_AREA, GalaSelectionAreaClass))

typedef struct _GalaSelectionArea GalaSelectionArea;
typedef struct _GalaSelectionAreaClass GalaSelectionAreaClass;
typedef struct _GalaSelectionAreaPrivate GalaSelectionAreaPrivate;
enum  {
	GALA_SELECTION_AREA_0_PROPERTY,
	GALA_SELECTION_AREA_WM_PROPERTY,
	GALA_SELECTION_AREA_CANCELLED_PROPERTY,
	GALA_SELECTION_AREA_NUM_PROPERTIES
};
static GParamSpec* gala_selection_area_properties[GALA_SELECTION_AREA_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	GALA_SELECTION_AREA_CLOSED_SIGNAL,
	GALA_SELECTION_AREA_NUM_SIGNALS
};
static guint gala_selection_area_signals[GALA_SELECTION_AREA_NUM_SIGNALS] = {0};

struct _GalaSelectionArea {
	GalaCanvasActor parent_instance;
	GalaSelectionAreaPrivate * priv;
};

struct _GalaSelectionAreaClass {
	GalaCanvasActorClass parent_class;
};

struct _GalaSelectionAreaPrivate {
	GalaWindowManager* _wm;
	gboolean _cancelled;
	GalaModalProxy* modal_proxy;
	graphene_point_t start_point;
	graphene_point_t end_point;
	gboolean dragging;
	gboolean clicked;
};

static gint GalaSelectionArea_private_offset;
static gpointer gala_selection_area_parent_class = NULL;

VALA_EXTERN GType gala_selection_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaSelectionArea, g_object_unref)
VALA_EXTERN GalaSelectionArea* gala_selection_area_new (GalaWindowManager* wm);
VALA_EXTERN GalaSelectionArea* gala_selection_area_construct (GType object_type,
                                                  GalaWindowManager* wm);
static gboolean gala_selection_area_real_key_press_event (ClutterActor* base,
                                                   ClutterEvent* e);
VALA_EXTERN void gala_selection_area_close (GalaSelectionArea* self);
static void gala_selection_area_set_cancelled (GalaSelectionArea* self,
                                        gboolean value);
static gboolean gala_selection_area_real_button_press_event (ClutterActor* base,
                                                      ClutterEvent* e);
static gboolean gala_selection_area_real_button_release_event (ClutterActor* base,
                                                        ClutterEvent* e);
static gboolean gala_selection_area_real_motion_event (ClutterActor* base,
                                                ClutterEvent* e);
VALA_EXTERN GalaWindowManager* gala_selection_area_get_wm (GalaSelectionArea* self);
VALA_EXTERN void gala_selection_area_start_selection (GalaSelectionArea* self);
VALA_EXTERN void gala_selection_area_get_selection_rectangle (GalaSelectionArea* self,
                                                  graphene_rect_t* result);
static void gala_selection_area_real_draw (GalaCanvasActor* base,
                                    cairo_t* ctx,
                                    gint width,
                                    gint height);
static void gala_selection_area_set_wm (GalaSelectionArea* self,
                                 GalaWindowManager* value);
VALA_EXTERN gboolean gala_selection_area_get_cancelled (GalaSelectionArea* self);
static GObject * gala_selection_area_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void gala_selection_area_finalize (GObject * obj);
static GType gala_selection_area_get_type_once (void);
static void _vala_gala_selection_area_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_gala_selection_area_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
gala_selection_area_get_instance_private (GalaSelectionArea* self)
{
	return G_STRUCT_MEMBER_P (self, GalaSelectionArea_private_offset);
}

GalaSelectionArea*
gala_selection_area_construct (GType object_type,
                               GalaWindowManager* wm)
{
	GalaSelectionArea * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaSelectionArea*) g_object_new (object_type, "wm", wm, NULL);
	return self;
}

GalaSelectionArea*
gala_selection_area_new (GalaWindowManager* wm)
{
	return gala_selection_area_construct (GALA_TYPE_SELECTION_AREA, wm);
}

static gboolean
gala_selection_area_real_key_press_event (ClutterActor* base,
                                          ClutterEvent* e)
{
	GalaSelectionArea * self;
	gboolean result;
	self = (GalaSelectionArea*) base;
	g_return_val_if_fail (e != NULL, FALSE);
	if (clutter_event_get_key_symbol (e) == CLUTTER_KEY_Escape) {
		gala_selection_area_close (self);
		gala_selection_area_set_cancelled (self, TRUE);
		g_signal_emit (self, gala_selection_area_signals[GALA_SELECTION_AREA_CLOSED_SIGNAL], 0);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
gala_selection_area_real_button_press_event (ClutterActor* base,
                                             ClutterEvent* e)
{
	GalaSelectionArea * self;
	gboolean _tmp0_ = FALSE;
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	gfloat _tmp1_ = 0.0F;
	gfloat _tmp2_ = 0.0F;
	gboolean result;
	self = (GalaSelectionArea*) base;
	g_return_val_if_fail (e != NULL, FALSE);
	if (self->priv->dragging) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = clutter_event_get_button (e) != CLUTTER_BUTTON_PRIMARY;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	self->priv->clicked = TRUE;
	clutter_event_get_coords (e, &_tmp1_, &_tmp2_);
	x = _tmp1_;
	y = _tmp2_;
	graphene_point_init (&self->priv->start_point, x, y);
	result = TRUE;
	return result;
}

static gboolean
gala_selection_area_real_button_release_event (ClutterActor* base,
                                               ClutterEvent* e)
{
	GalaSelectionArea * self;
	ClutterContent* _tmp0_;
	ClutterContent* _tmp1_;
	gboolean result;
	self = (GalaSelectionArea*) base;
	g_return_val_if_fail (e != NULL, FALSE);
	if (clutter_event_get_button (e) != CLUTTER_BUTTON_PRIMARY) {
		result = TRUE;
		return result;
	}
	if (!self->priv->dragging) {
		gala_selection_area_close (self);
		gala_selection_area_set_cancelled (self, TRUE);
		g_signal_emit (self, gala_selection_area_signals[GALA_SELECTION_AREA_CLOSED_SIGNAL], 0);
		result = TRUE;
		return result;
	}
	self->priv->dragging = FALSE;
	self->priv->clicked = FALSE;
	gala_selection_area_close (self);
	clutter_actor_hide ((ClutterActor*) self);
	_tmp0_ = clutter_actor_get_content ((ClutterActor*) self);
	_tmp1_ = _tmp0_;
	clutter_content_invalidate (_tmp1_);
	g_signal_emit (self, gala_selection_area_signals[GALA_SELECTION_AREA_CLOSED_SIGNAL], 0);
	result = TRUE;
	return result;
}

static gboolean
gala_selection_area_real_motion_event (ClutterActor* base,
                                       ClutterEvent* e)
{
	GalaSelectionArea * self;
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	gfloat _tmp0_ = 0.0F;
	gfloat _tmp1_ = 0.0F;
	ClutterContent* _tmp2_;
	ClutterContent* _tmp3_;
	gboolean result;
	self = (GalaSelectionArea*) base;
	g_return_val_if_fail (e != NULL, FALSE);
	if (!self->priv->clicked) {
		result = TRUE;
		return result;
	}
	clutter_event_get_coords (e, &_tmp0_, &_tmp1_);
	x = _tmp0_;
	y = _tmp1_;
	graphene_point_init (&self->priv->end_point, x, y);
	_tmp2_ = clutter_actor_get_content ((ClutterActor*) self);
	_tmp3_ = _tmp2_;
	clutter_content_invalidate (_tmp3_);
	if (!self->priv->dragging) {
		self->priv->dragging = TRUE;
	}
	result = TRUE;
	return result;
}

void
gala_selection_area_close (GalaSelectionArea* self)
{
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	GalaModalProxy* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	meta_display_set_cursor (_tmp1_, META_CURSOR_DEFAULT);
	_tmp2_ = self->priv->modal_proxy;
	if (_tmp2_ != NULL) {
		GalaWindowManager* _tmp3_;
		GalaModalProxy* _tmp4_;
		_tmp3_ = self->priv->_wm;
		_tmp4_ = self->priv->modal_proxy;
		gala_window_manager_pop_modal (_tmp3_, _tmp4_);
	}
}

void
gala_selection_area_start_selection (GalaSelectionArea* self)
{
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	GalaWindowManager* _tmp2_;
	GalaModalProxy* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	meta_display_set_cursor (_tmp1_, META_CURSOR_CROSSHAIR);
	clutter_actor_grab_key_focus ((ClutterActor*) self);
	_tmp2_ = self->priv->_wm;
	_tmp3_ = gala_window_manager_push_modal (_tmp2_, (ClutterActor*) self, TRUE);
	_g_object_unref0 (self->priv->modal_proxy);
	self->priv->modal_proxy = _tmp3_;
}

void
gala_selection_area_get_selection_rectangle (GalaSelectionArea* self,
                                             graphene_rect_t* result)
{
	graphene_point_t _tmp0_;
	graphene_rect_t _tmp1_ = {0};
	graphene_point_t _tmp2_;
	graphene_rect_t _tmp3_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->start_point;
	memset (&_tmp1_, 0, sizeof (graphene_rect_t));
	_tmp1_.origin = _tmp0_;
	_tmp1_.size = *graphene_size_zero ();
	_tmp2_ = self->priv->end_point;
	graphene_rect_expand (&_tmp1_, &_tmp2_, &_tmp3_);
	*result = _tmp3_;
	return;
}

static void
gala_selection_area_real_draw (GalaCanvasActor* base,
                               cairo_t* ctx,
                               gint width,
                               gint height)
{
	GalaSelectionArea * self;
	graphene_rect_t rect = {0};
	graphene_rect_t _tmp0_ = {0};
	graphene_rect_t _tmp1_;
	graphene_point_t _tmp2_;
	graphene_rect_t _tmp3_;
	graphene_point_t _tmp4_;
	graphene_rect_t _tmp5_;
	graphene_size_t _tmp6_;
	graphene_rect_t _tmp7_;
	graphene_size_t _tmp8_;
	graphene_rect_t _tmp9_;
	graphene_point_t _tmp10_;
	graphene_rect_t _tmp11_;
	graphene_point_t _tmp12_;
	graphene_rect_t _tmp13_;
	graphene_size_t _tmp14_;
	graphene_rect_t _tmp15_;
	graphene_size_t _tmp16_;
	self = (GalaSelectionArea*) base;
	g_return_if_fail (ctx != NULL);
	cairo_save (ctx);
	cairo_set_operator (ctx, CAIRO_OPERATOR_CLEAR);
	cairo_paint (ctx);
	cairo_restore (ctx);
	if (!self->priv->dragging) {
		return;
	}
	cairo_translate (ctx, 0.5, 0.5);
	gala_selection_area_get_selection_rectangle (self, &_tmp0_);
	rect = _tmp0_;
	_tmp1_ = rect;
	_tmp2_ = _tmp1_.origin;
	_tmp3_ = rect;
	_tmp4_ = _tmp3_.origin;
	_tmp5_ = rect;
	_tmp6_ = _tmp5_.size;
	_tmp7_ = rect;
	_tmp8_ = _tmp7_.size;
	cairo_rectangle (ctx, (gdouble) _tmp2_.x, (gdouble) _tmp4_.y, (gdouble) _tmp6_.width, (gdouble) _tmp8_.height);
	cairo_set_source_rgba (ctx, 0.1, 0.1, 0.1, 0.2);
	cairo_fill (ctx);
	_tmp9_ = rect;
	_tmp10_ = _tmp9_.origin;
	_tmp11_ = rect;
	_tmp12_ = _tmp11_.origin;
	_tmp13_ = rect;
	_tmp14_ = _tmp13_.size;
	_tmp15_ = rect;
	_tmp16_ = _tmp15_.size;
	cairo_rectangle (ctx, (gdouble) _tmp10_.x, (gdouble) _tmp12_.y, (gdouble) _tmp14_.width, (gdouble) _tmp16_.height);
	cairo_set_source_rgb (ctx, 0.7, 0.7, 0.7);
	cairo_set_line_width (ctx, 1.0);
	cairo_stroke (ctx);
}

GalaWindowManager*
gala_selection_area_get_wm (GalaSelectionArea* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_selection_area_set_wm (GalaSelectionArea* self,
                            GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_selection_area_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_selection_area_properties[GALA_SELECTION_AREA_WM_PROPERTY]);
	}
}

gboolean
gala_selection_area_get_cancelled (GalaSelectionArea* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_cancelled;
	return result;
}

static void
gala_selection_area_set_cancelled (GalaSelectionArea* self,
                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_selection_area_get_cancelled (self);
	if (old_value != value) {
		self->priv->_cancelled = value;
		g_object_notify_by_pspec ((GObject *) self, gala_selection_area_properties[GALA_SELECTION_AREA_CANCELLED_PROPERTY]);
	}
}

static GObject *
gala_selection_area_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaSelectionArea * self;
	gint screen_width = 0;
	gint screen_height = 0;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	parent_class = G_OBJECT_CLASS (gala_selection_area_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_SELECTION_AREA, GalaSelectionArea);
	graphene_point_init (&self->priv->start_point, (gfloat) 0, (gfloat) 0);
	graphene_point_init (&self->priv->end_point, (gfloat) 0, (gfloat) 0);
	g_object_set ((ClutterActor*) self, "visible", TRUE, NULL);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	meta_display_get_size (_tmp1_, &_tmp2_, &_tmp3_);
	screen_width = _tmp2_;
	screen_height = _tmp3_;
	clutter_actor_set_width ((ClutterActor*) self, (gfloat) screen_width);
	clutter_actor_set_height ((ClutterActor*) self, (gfloat) screen_height);
	return obj;
}

static void
gala_selection_area_class_init (GalaSelectionAreaClass * klass,
                                gpointer klass_data)
{
	gala_selection_area_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaSelectionArea_private_offset);
	((ClutterActorClass *) klass)->key_press_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_selection_area_real_key_press_event;
	((ClutterActorClass *) klass)->button_press_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_selection_area_real_button_press_event;
	((ClutterActorClass *) klass)->button_release_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_selection_area_real_button_release_event;
	((ClutterActorClass *) klass)->motion_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_selection_area_real_motion_event;
	((GalaCanvasActorClass *) klass)->draw = (void (*) (GalaCanvasActor*, cairo_t*, gint, gint)) gala_selection_area_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_selection_area_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_selection_area_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_selection_area_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_selection_area_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_SELECTION_AREA_WM_PROPERTY, gala_selection_area_properties[GALA_SELECTION_AREA_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_SELECTION_AREA_CANCELLED_PROPERTY, gala_selection_area_properties[GALA_SELECTION_AREA_CANCELLED_PROPERTY] = g_param_spec_boolean ("cancelled", "cancelled", "cancelled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gala_selection_area_signals[GALA_SELECTION_AREA_CLOSED_SIGNAL] = g_signal_new ("closed", GALA_TYPE_SELECTION_AREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_selection_area_instance_init (GalaSelectionArea * self,
                                   gpointer klass)
{
	self->priv = gala_selection_area_get_instance_private (self);
	self->priv->dragging = FALSE;
	self->priv->clicked = FALSE;
}

static void
gala_selection_area_finalize (GObject * obj)
{
	GalaSelectionArea * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_SELECTION_AREA, GalaSelectionArea);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->modal_proxy);
	G_OBJECT_CLASS (gala_selection_area_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_selection_area_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaSelectionAreaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_selection_area_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaSelectionArea), 0, (GInstanceInitFunc) gala_selection_area_instance_init, NULL };
	GType gala_selection_area_type_id;
	gala_selection_area_type_id = g_type_register_static (GALA_TYPE_CANVAS_ACTOR, "GalaSelectionArea", &g_define_type_info, 0);
	GalaSelectionArea_private_offset = g_type_add_instance_private (gala_selection_area_type_id, sizeof (GalaSelectionAreaPrivate));
	return gala_selection_area_type_id;
}

GType
gala_selection_area_get_type (void)
{
	static gsize gala_selection_area_type_id__once = 0;
	if (g_once_init_enter (&gala_selection_area_type_id__once)) {
		GType gala_selection_area_type_id;
		gala_selection_area_type_id = gala_selection_area_get_type_once ();
		g_once_init_leave (&gala_selection_area_type_id__once, gala_selection_area_type_id);
	}
	return gala_selection_area_type_id__once;
}

static void
_vala_gala_selection_area_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	GalaSelectionArea * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_SELECTION_AREA, GalaSelectionArea);
	switch (property_id) {
		case GALA_SELECTION_AREA_WM_PROPERTY:
		g_value_set_object (value, gala_selection_area_get_wm (self));
		break;
		case GALA_SELECTION_AREA_CANCELLED_PROPERTY:
		g_value_set_boolean (value, gala_selection_area_get_cancelled (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_selection_area_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	GalaSelectionArea * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_SELECTION_AREA, GalaSelectionArea);
	switch (property_id) {
		case GALA_SELECTION_AREA_WM_PROPERTY:
		gala_selection_area_set_wm (self, g_value_get_object (value));
		break;
		case GALA_SELECTION_AREA_CANCELLED_PROPERTY:
		gala_selection_area_set_cancelled (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

