/* MicroBreakView.c generated by valac 0.56.17, the Vala compiler
 * generated from MicroBreakView.vala, do not modify */

/* MicroBreakView.vala
 *
 * Copyright 2020 Dylan McCall <dylan@dylanmccall.ca>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "daemon.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include "common.h"
#include <glib/gi18n-lib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BREAK_TIMER_DAEMON_MICRO_BREAK_MICRO_BREAK_VIEW_0_PROPERTY,
	BREAK_TIMER_DAEMON_MICRO_BREAK_MICRO_BREAK_VIEW_MICRO_BREAK_PROPERTY,
	BREAK_TIMER_DAEMON_MICRO_BREAK_MICRO_BREAK_VIEW_FOCUS_PRIORITY_PROPERTY,
	BREAK_TIMER_DAEMON_MICRO_BREAK_MICRO_BREAK_VIEW_NOTIFICATION_IDS_PROPERTY,
	BREAK_TIMER_DAEMON_MICRO_BREAK_MICRO_BREAK_VIEW_NUM_PROPERTIES
};
static GParamSpec* break_timer_daemon_micro_break_micro_break_view_properties[BREAK_TIMER_DAEMON_MICRO_BREAK_MICRO_BREAK_VIEW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _BreakTimerDaemonMicroBreakMicroBreakViewPrivate {
	BreakTimerDaemonUtilFocusPriority _focus_priority;
	gchar** _notification_ids;
	gint _notification_ids_length1;
	gint __notification_ids_size_;
	gint delay_time_notified;
};

static gint BreakTimerDaemonMicroBreakMicroBreakView_private_offset;
static gpointer break_timer_daemon_micro_break_micro_break_view_parent_class = NULL;

static void break_timer_daemon_micro_break_micro_break_view_focused_and_activated_cb (BreakTimerDaemonMicroBreakMicroBreakView* self);
static void _break_timer_daemon_micro_break_micro_break_view_focused_and_activated_cb_break_timer_daemon_break_break_view_focused_and_activated (BreakTimerDaemonBreakBreakView* _sender,
                                                                                                                                          gpointer self);
static void break_timer_daemon_micro_break_micro_break_view_lost_ui_focus_cb (BreakTimerDaemonMicroBreakMicroBreakView* self);
static void _break_timer_daemon_micro_break_micro_break_view_lost_ui_focus_cb_break_timer_daemon_break_break_view_lost_ui_focus (BreakTimerDaemonBreakBreakView* _sender,
                                                                                                                          gpointer self);
static void break_timer_daemon_micro_break_micro_break_view_finished_cb (BreakTimerDaemonMicroBreakMicroBreakView* self,
                                                                  BreakTimerDaemonBreakBreakControllerFinishedReason reason,
                                                                  gboolean was_active);
static void _break_timer_daemon_micro_break_micro_break_view_finished_cb_break_timer_daemon_break_break_controller_finished (BreakTimerDaemonBreakBreakController* _sender,
                                                                                                                      BreakTimerDaemonBreakBreakControllerFinishedReason reason,
                                                                                                                      gboolean was_active,
                                                                                                                      gpointer self);
static gchar* break_timer_daemon_micro_break_micro_break_view_real_get_status_message (BreakTimerDaemonBreakBreakView* base);
static void break_timer_daemon_micro_break_micro_break_view_real_dismiss_break (BreakTimerDaemonBreakBreakView* base);
static void break_timer_daemon_micro_break_micro_break_view_show_start_notification (BreakTimerDaemonMicroBreakMicroBreakView* self);
static void break_timer_daemon_micro_break_micro_break_view_add_notification_actions (BreakTimerDaemonMicroBreakMicroBreakView* self,
                                                                               GNotification* notification);
static void break_timer_daemon_micro_break_micro_break_view_show_overdue_notification (BreakTimerDaemonMicroBreakMicroBreakView* self);
static void break_timer_daemon_micro_break_micro_break_view_show_finished_notification (BreakTimerDaemonMicroBreakMicroBreakView* self);
static void break_timer_daemon_micro_break_micro_break_view_delayed_cb (BreakTimerDaemonMicroBreakMicroBreakView* self,
                                                                 gint lap_time,
                                                                 gint total_time);
static void _break_timer_daemon_micro_break_micro_break_view_delayed_cb_break_timer_daemon_timer_break_timer_break_controller_delayed (BreakTimerDaemonTimerBreakTimerBreakController* _sender,
                                                                                                                                gint lap_time,
                                                                                                                                gint total_time,
                                                                                                                                gpointer self);
static void break_timer_daemon_micro_break_micro_break_view_finalize (GObject * obj);
static GType break_timer_daemon_micro_break_micro_break_view_get_type_once (void);
static void _vala_break_timer_daemon_micro_break_micro_break_view_get_property (GObject * object,
                                                                         guint property_id,
                                                                         GValue * value,
                                                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
break_timer_daemon_micro_break_micro_break_view_get_instance_private (BreakTimerDaemonMicroBreakMicroBreakView* self)
{
	return G_STRUCT_MEMBER_P (self, BreakTimerDaemonMicroBreakMicroBreakView_private_offset);
}

static void
_break_timer_daemon_micro_break_micro_break_view_focused_and_activated_cb_break_timer_daemon_break_break_view_focused_and_activated (BreakTimerDaemonBreakBreakView* _sender,
                                                                                                                                     gpointer self)
{
	break_timer_daemon_micro_break_micro_break_view_focused_and_activated_cb ((BreakTimerDaemonMicroBreakMicroBreakView*) self);
}

static void
_break_timer_daemon_micro_break_micro_break_view_lost_ui_focus_cb_break_timer_daemon_break_break_view_lost_ui_focus (BreakTimerDaemonBreakBreakView* _sender,
                                                                                                                     gpointer self)
{
	break_timer_daemon_micro_break_micro_break_view_lost_ui_focus_cb ((BreakTimerDaemonMicroBreakMicroBreakView*) self);
}

static void
_break_timer_daemon_micro_break_micro_break_view_finished_cb_break_timer_daemon_break_break_controller_finished (BreakTimerDaemonBreakBreakController* _sender,
                                                                                                                 BreakTimerDaemonBreakBreakControllerFinishedReason reason,
                                                                                                                 gboolean was_active,
                                                                                                                 gpointer self)
{
	break_timer_daemon_micro_break_micro_break_view_finished_cb ((BreakTimerDaemonMicroBreakMicroBreakView*) self, reason, was_active);
}

BreakTimerDaemonMicroBreakMicroBreakView*
break_timer_daemon_micro_break_micro_break_view_construct (GType object_type,
                                                           BreakTimerDaemonMicroBreakMicroBreakController* micro_break,
                                                           BreakTimerDaemonUIManager* ui_manager)
{
	BreakTimerDaemonMicroBreakMicroBreakView * self = NULL;
	BreakTimerDaemonMicroBreakMicroBreakController* _tmp0_;
	BreakTimerDaemonMicroBreakMicroBreakController* _tmp1_;
	g_return_val_if_fail (micro_break != NULL, NULL);
	g_return_val_if_fail (ui_manager != NULL, NULL);
	self = (BreakTimerDaemonMicroBreakMicroBreakView*) break_timer_daemon_timer_break_timer_break_view_construct (object_type, (BreakTimerDaemonTimerBreakTimerBreakController*) micro_break, ui_manager);
	g_signal_connect_object ((BreakTimerDaemonBreakBreakView*) self, "focused-and-activated", (GCallback) _break_timer_daemon_micro_break_micro_break_view_focused_and_activated_cb_break_timer_daemon_break_break_view_focused_and_activated, self, 0);
	g_signal_connect_object ((BreakTimerDaemonBreakBreakView*) self, "lost-ui-focus", (GCallback) _break_timer_daemon_micro_break_micro_break_view_lost_ui_focus_cb_break_timer_daemon_break_break_view_lost_ui_focus, self, 0);
	_tmp0_ = break_timer_daemon_micro_break_micro_break_view_get_micro_break (self);
	_tmp1_ = _tmp0_;
	g_signal_connect_object ((BreakTimerDaemonBreakBreakController*) _tmp1_, "finished", (GCallback) _break_timer_daemon_micro_break_micro_break_view_finished_cb_break_timer_daemon_break_break_controller_finished, self, 0);
	return self;
}

BreakTimerDaemonMicroBreakMicroBreakView*
break_timer_daemon_micro_break_micro_break_view_new (BreakTimerDaemonMicroBreakMicroBreakController* micro_break,
                                                     BreakTimerDaemonUIManager* ui_manager)
{
	return break_timer_daemon_micro_break_micro_break_view_construct (BREAK_TIMER_DAEMON_MICRO_BREAK_TYPE_MICRO_BREAK_VIEW, micro_break, ui_manager);
}

static gchar*
break_timer_daemon_micro_break_micro_break_view_real_get_status_message (BreakTimerDaemonBreakBreakView* base)
{
	BreakTimerDaemonMicroBreakMicroBreakView * self;
	gint starts_in_value = 0;
	BreakTimerDaemonMicroBreakMicroBreakController* _tmp0_;
	BreakTimerDaemonMicroBreakMicroBreakController* _tmp1_;
	gchar* starts_in_text = NULL;
	BreakTimerCommonNaturalTime* _tmp2_;
	BreakTimerCommonNaturalTime* _tmp3_;
	gchar* _tmp4_;
	BreakTimerDaemonMicroBreakMicroBreakController* _tmp5_;
	BreakTimerDaemonMicroBreakMicroBreakController* _tmp6_;
	BreakTimerDaemonBreakBreakControllerState _tmp7_;
	BreakTimerDaemonBreakBreakControllerState _tmp8_;
	gchar* result;
	self = (BreakTimerDaemonMicroBreakMicroBreakView*) base;
	_tmp0_ = break_timer_daemon_micro_break_micro_break_view_get_micro_break (self);
	_tmp1_ = _tmp0_;
	starts_in_value = break_timer_daemon_timer_break_timer_break_controller_starts_in ((BreakTimerDaemonTimerBreakTimerBreakController*) _tmp1_);
	_tmp2_ = break_timer_common_natural_time_get_instance ();
	_tmp3_ = _tmp2_;
	_tmp4_ = break_timer_common_natural_time_get_countdown_for_seconds (_tmp3_, starts_in_value, NULL);
	starts_in_text = _tmp4_;
	_tmp5_ = break_timer_daemon_micro_break_micro_break_view_get_micro_break (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = break_timer_daemon_break_break_controller_get_state ((BreakTimerDaemonBreakBreakController*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_WAITING) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = starts_in_text;
		_tmp10_ = g_strdup_printf (ngettext ("Microbreak starts in %s", "Microbreak starts in %s", (gulong) starts_in_value), _tmp9_);
		result = _tmp10_;
		_g_free0 (starts_in_text);
		return result;
	} else {
		BreakTimerDaemonMicroBreakMicroBreakController* _tmp11_;
		BreakTimerDaemonMicroBreakMicroBreakController* _tmp12_;
		BreakTimerDaemonBreakBreakControllerState _tmp13_;
		BreakTimerDaemonBreakBreakControllerState _tmp14_;
		_tmp11_ = break_timer_daemon_micro_break_micro_break_view_get_micro_break (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = break_timer_daemon_break_break_controller_get_state ((BreakTimerDaemonBreakBreakController*) _tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_ == BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_ACTIVE) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup (_ ("Time for a microbreak"));
			result = _tmp15_;
			_g_free0 (starts_in_text);
			return result;
		} else {
			result = NULL;
			_g_free0 (starts_in_text);
			return result;
		}
	}
}

static void
break_timer_daemon_micro_break_micro_break_view_real_dismiss_break (BreakTimerDaemonBreakBreakView* base)
{
	BreakTimerDaemonMicroBreakMicroBreakView * self;
	BreakTimerDaemonMicroBreakMicroBreakController* _tmp0_;
	BreakTimerDaemonMicroBreakMicroBreakController* _tmp1_;
	self = (BreakTimerDaemonMicroBreakMicroBreakView*) base;
	_tmp0_ = break_timer_daemon_micro_break_micro_break_view_get_micro_break (self);
	_tmp1_ = _tmp0_;
	break_timer_daemon_break_break_controller_skip ((BreakTimerDaemonBreakBreakController*) _tmp1_, TRUE);
}

static void
break_timer_daemon_micro_break_micro_break_view_show_start_notification (BreakTimerDaemonMicroBreakMicroBreakView* self)
{
	gchar* body_text = NULL;
	gchar* _tmp0_;
	GNotification* notification = NULL;
	GNotification* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (_ ("Take a break from typing and look away from the screen"));
	body_text = _tmp0_;
	_tmp1_ = g_notification_new (_ ("It’s time for a micro break"));
	notification = _tmp1_;
	g_notification_set_body (notification, body_text);
	g_notification_set_priority (notification, G_NOTIFICATION_PRIORITY_HIGH);
	break_timer_daemon_micro_break_micro_break_view_add_notification_actions (self, notification);
	break_timer_daemon_ui_fragment_hide_notification ((BreakTimerDaemonUIFragment*) self, "microbreak.finished");
	break_timer_daemon_ui_fragment_show_notification ((BreakTimerDaemonUIFragment*) self, "microbreak.active", notification);
	_g_object_unref0 (notification);
	_g_free0 (body_text);
}

static void
break_timer_daemon_micro_break_micro_break_view_show_overdue_notification (BreakTimerDaemonMicroBreakMicroBreakView* self)
{
	gint delay_value = 0;
	gint time_since_start = 0;
	BreakTimerDaemonMicroBreakMicroBreakController* _tmp0_;
	BreakTimerDaemonMicroBreakMicroBreakController* _tmp1_;
	gchar* delay_text = NULL;
	BreakTimerCommonNaturalTime* _tmp2_;
	BreakTimerCommonNaturalTime* _tmp3_;
	gint _tmp4_ = 0;
	gchar* _tmp5_;
	gchar* body_text = NULL;
	gchar* _tmp6_;
	GNotification* notification = NULL;
	GNotification* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = break_timer_daemon_micro_break_micro_break_view_get_micro_break (self);
	_tmp1_ = _tmp0_;
	time_since_start = break_timer_daemon_break_break_controller_get_seconds_since_start ((BreakTimerDaemonBreakBreakController*) _tmp1_);
	_tmp2_ = break_timer_common_natural_time_get_instance ();
	_tmp3_ = _tmp2_;
	_tmp5_ = break_timer_common_natural_time_get_simplest_label_for_seconds (_tmp3_, time_since_start, &_tmp4_);
	delay_value = _tmp4_;
	delay_text = _tmp5_;
	_tmp6_ = g_strdup_printf (ngettext ("You were due to take a micro break %s ago", "You were due to take a micro break %s ago", (gulong) delay_value), delay_text);
	body_text = _tmp6_;
	_tmp7_ = g_notification_new (_ ("Overdue micro break"));
	notification = _tmp7_;
	g_notification_set_body (notification, body_text);
	g_notification_set_priority (notification, G_NOTIFICATION_PRIORITY_HIGH);
	break_timer_daemon_micro_break_micro_break_view_add_notification_actions (self, notification);
	break_timer_daemon_ui_fragment_hide_notification ((BreakTimerDaemonUIFragment*) self, "microbreak.finished");
	break_timer_daemon_ui_fragment_show_notification ((BreakTimerDaemonUIFragment*) self, "microbreak.active", notification);
	_g_object_unref0 (notification);
	_g_free0 (body_text);
	_g_free0 (delay_text);
}

static void
break_timer_daemon_micro_break_micro_break_view_show_finished_notification (BreakTimerDaemonMicroBreakMicroBreakView* self)
{
	gchar* body_text = NULL;
	gchar* _tmp0_;
	GNotification* notification = NULL;
	GNotification* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (_ ("Your micro break has ended"));
	body_text = _tmp0_;
	_tmp1_ = g_notification_new (_ ("Break is over"));
	notification = _tmp1_;
	g_notification_set_body (notification, body_text);
	g_notification_set_priority (notification, G_NOTIFICATION_PRIORITY_NORMAL);
	g_notification_set_default_action (notification, "app.show-break-info");
	break_timer_daemon_ui_fragment_hide_notification ((BreakTimerDaemonUIFragment*) self, "microbreak.active");
	break_timer_daemon_ui_fragment_show_transient_notification ((BreakTimerDaemonUIFragment*) self, "microbreak.finished", notification);
	break_timer_daemon_ui_fragment_play_sound_from_id ((BreakTimerDaemonUIFragment*) self, "complete");
	_g_object_unref0 (notification);
	_g_free0 (body_text);
}

static void
break_timer_daemon_micro_break_micro_break_view_add_notification_actions (BreakTimerDaemonMicroBreakMicroBreakView* self,
                                                                          GNotification* notification)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (notification != NULL);
	g_notification_add_button (notification, _ ("Skip this one"), "app.dismiss-break::microbreak");
	g_notification_add_button (notification, _ ("What should I do?"), "app.show-break-info");
	g_notification_set_default_action (notification, "app.show-break-info");
}

static void
_break_timer_daemon_micro_break_micro_break_view_delayed_cb_break_timer_daemon_timer_break_timer_break_controller_delayed (BreakTimerDaemonTimerBreakTimerBreakController* _sender,
                                                                                                                           gint lap_time,
                                                                                                                           gint total_time,
                                                                                                                           gpointer self)
{
	break_timer_daemon_micro_break_micro_break_view_delayed_cb ((BreakTimerDaemonMicroBreakMicroBreakView*) self, lap_time, total_time);
}

static void
break_timer_daemon_micro_break_micro_break_view_focused_and_activated_cb (BreakTimerDaemonMicroBreakMicroBreakView* self)
{
	BreakTimerDaemonMicroBreakMicroBreakController* _tmp0_;
	BreakTimerDaemonMicroBreakMicroBreakController* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->delay_time_notified = 0;
	break_timer_daemon_micro_break_micro_break_view_show_start_notification (self);
	_tmp0_ = break_timer_daemon_micro_break_micro_break_view_get_micro_break (self);
	_tmp1_ = _tmp0_;
	g_signal_connect_object ((BreakTimerDaemonTimerBreakTimerBreakController*) _tmp1_, "delayed", (GCallback) _break_timer_daemon_micro_break_micro_break_view_delayed_cb_break_timer_daemon_timer_break_timer_break_controller_delayed, self, 0);
}

static void
break_timer_daemon_micro_break_micro_break_view_lost_ui_focus_cb (BreakTimerDaemonMicroBreakMicroBreakView* self)
{
	BreakTimerDaemonMicroBreakMicroBreakController* _tmp0_;
	BreakTimerDaemonMicroBreakMicroBreakController* _tmp1_;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = break_timer_daemon_micro_break_micro_break_view_get_micro_break (self);
	_tmp1_ = _tmp0_;
	g_signal_parse_name ("delayed", BREAK_TIMER_DAEMON_TIMER_BREAK_TYPE_TIMER_BREAK_CONTROLLER, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((BreakTimerDaemonTimerBreakTimerBreakController*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _break_timer_daemon_micro_break_micro_break_view_delayed_cb_break_timer_daemon_timer_break_timer_break_controller_delayed, self);
	break_timer_daemon_ui_fragment_hide_notification ((BreakTimerDaemonUIFragment*) self, "microbreak.active");
}

static void
break_timer_daemon_micro_break_micro_break_view_finished_cb (BreakTimerDaemonMicroBreakMicroBreakView* self,
                                                             BreakTimerDaemonBreakBreakControllerFinishedReason reason,
                                                             gboolean was_active)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (reason == BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_FINISHED_REASON_SATISFIED) {
		_tmp0_ = was_active;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		break_timer_daemon_micro_break_micro_break_view_show_finished_notification (self);
	} else {
		break_timer_daemon_ui_fragment_hide_notification ((BreakTimerDaemonUIFragment*) self, "microbreak.active");
	}
}

static void
break_timer_daemon_micro_break_micro_break_view_delayed_cb (BreakTimerDaemonMicroBreakMicroBreakView* self,
                                                            gint lap_time,
                                                            gint total_time)
{
	gint time_since_notified = 0;
	BreakTimerDaemonMicroBreakMicroBreakController* _tmp0_;
	BreakTimerDaemonMicroBreakMicroBreakController* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	time_since_notified = total_time - self->priv->delay_time_notified;
	_tmp0_ = break_timer_daemon_micro_break_micro_break_view_get_micro_break (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = break_timer_daemon_timer_break_timer_break_controller_get_interval ((BreakTimerDaemonTimerBreakTimerBreakController*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (time_since_notified > _tmp3_) {
		break_timer_daemon_micro_break_micro_break_view_show_overdue_notification (self);
		self->priv->delay_time_notified = total_time;
	}
}

BreakTimerDaemonMicroBreakMicroBreakController*
break_timer_daemon_micro_break_micro_break_view_get_micro_break (BreakTimerDaemonMicroBreakMicroBreakView* self)
{
	BreakTimerDaemonMicroBreakMicroBreakController* result;
	BreakTimerDaemonBreakBreakController* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ((BreakTimerDaemonBreakBreakView*) self)->break_controller;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, BREAK_TIMER_DAEMON_MICRO_BREAK_TYPE_MICRO_BREAK_CONTROLLER, BreakTimerDaemonMicroBreakMicroBreakController);
	return result;
}

static BreakTimerDaemonUtilFocusPriority
break_timer_daemon_micro_break_micro_break_view_real_get_focus_priority (BreakTimerDaemonUIFragment* base)
{
	BreakTimerDaemonUtilFocusPriority result;
	BreakTimerDaemonMicroBreakMicroBreakView* self;
	self = (BreakTimerDaemonMicroBreakMicroBreakView*) base;
	result = self->priv->_focus_priority;
	return result;
}

static gchar**
break_timer_daemon_micro_break_micro_break_view_real_get_notification_ids (BreakTimerDaemonUIFragment* base,
                                                                           gint* result_length1)
{
	gchar** result;
	BreakTimerDaemonMicroBreakMicroBreakView* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	self = (BreakTimerDaemonMicroBreakMicroBreakView*) base;
	_tmp0_ = self->priv->_notification_ids;
	_tmp0__length1 = self->priv->_notification_ids_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static void
break_timer_daemon_micro_break_micro_break_view_class_init (BreakTimerDaemonMicroBreakMicroBreakViewClass * klass,
                                                            gpointer klass_data)
{
	break_timer_daemon_micro_break_micro_break_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BreakTimerDaemonMicroBreakMicroBreakView_private_offset);
	((BreakTimerDaemonBreakBreakViewClass *) klass)->get_status_message = (gchar* (*) (BreakTimerDaemonBreakBreakView*)) break_timer_daemon_micro_break_micro_break_view_real_get_status_message;
	((BreakTimerDaemonBreakBreakViewClass *) klass)->dismiss_break = (void (*) (BreakTimerDaemonBreakBreakView*)) break_timer_daemon_micro_break_micro_break_view_real_dismiss_break;
	BREAK_TIMER_DAEMON_UI_FRAGMENT_CLASS (klass)->get_focus_priority = (BreakTimerDaemonUtilFocusPriority (*) (BreakTimerDaemonUIFragment*)) break_timer_daemon_micro_break_micro_break_view_real_get_focus_priority;
	BREAK_TIMER_DAEMON_UI_FRAGMENT_CLASS (klass)->get_notification_ids = (gchar** (*) (BreakTimerDaemonUIFragment*, gint*)) break_timer_daemon_micro_break_micro_break_view_real_get_notification_ids;
	G_OBJECT_CLASS (klass)->get_property = _vala_break_timer_daemon_micro_break_micro_break_view_get_property;
	G_OBJECT_CLASS (klass)->finalize = break_timer_daemon_micro_break_micro_break_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BREAK_TIMER_DAEMON_MICRO_BREAK_MICRO_BREAK_VIEW_MICRO_BREAK_PROPERTY, break_timer_daemon_micro_break_micro_break_view_properties[BREAK_TIMER_DAEMON_MICRO_BREAK_MICRO_BREAK_VIEW_MICRO_BREAK_PROPERTY] = g_param_spec_object ("micro-break", "micro-break", "micro-break", BREAK_TIMER_DAEMON_MICRO_BREAK_TYPE_MICRO_BREAK_CONTROLLER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BREAK_TIMER_DAEMON_MICRO_BREAK_MICRO_BREAK_VIEW_FOCUS_PRIORITY_PROPERTY, break_timer_daemon_micro_break_micro_break_view_properties[BREAK_TIMER_DAEMON_MICRO_BREAK_MICRO_BREAK_VIEW_FOCUS_PRIORITY_PROPERTY] = g_param_spec_enum ("focus-priority", "focus-priority", "focus-priority", BREAK_TIMER_DAEMON_UTIL_TYPE_FOCUS_PRIORITY, BREAK_TIMER_DAEMON_UTIL_FOCUS_PRIORITY_LOW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BREAK_TIMER_DAEMON_MICRO_BREAK_MICRO_BREAK_VIEW_NOTIFICATION_IDS_PROPERTY, break_timer_daemon_micro_break_micro_break_view_properties[BREAK_TIMER_DAEMON_MICRO_BREAK_MICRO_BREAK_VIEW_NOTIFICATION_IDS_PROPERTY] = g_param_spec_boxed ("notification-ids", "notification-ids", "notification-ids", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
break_timer_daemon_micro_break_micro_break_view_instance_init (BreakTimerDaemonMicroBreakMicroBreakView * self,
                                                               gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	self->priv = break_timer_daemon_micro_break_micro_break_view_get_instance_private (self);
	self->priv->_focus_priority = BREAK_TIMER_DAEMON_UTIL_FOCUS_PRIORITY_LOW;
	_tmp0_ = g_strdup ("microbreak.active");
	_tmp1_ = g_strdup ("microbreak.finished");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	self->priv->_notification_ids = _tmp2_;
	self->priv->_notification_ids_length1 = 2;
	self->priv->__notification_ids_size_ = self->priv->_notification_ids_length1;
	self->priv->delay_time_notified = 0;
}

static void
break_timer_daemon_micro_break_micro_break_view_finalize (GObject * obj)
{
	BreakTimerDaemonMicroBreakMicroBreakView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BREAK_TIMER_DAEMON_MICRO_BREAK_TYPE_MICRO_BREAK_VIEW, BreakTimerDaemonMicroBreakMicroBreakView);
	self->priv->_notification_ids = (_vala_array_free (self->priv->_notification_ids, self->priv->_notification_ids_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (break_timer_daemon_micro_break_micro_break_view_parent_class)->finalize (obj);
}

static GType
break_timer_daemon_micro_break_micro_break_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BreakTimerDaemonMicroBreakMicroBreakViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) break_timer_daemon_micro_break_micro_break_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BreakTimerDaemonMicroBreakMicroBreakView), 0, (GInstanceInitFunc) break_timer_daemon_micro_break_micro_break_view_instance_init, NULL };
	GType break_timer_daemon_micro_break_micro_break_view_type_id;
	break_timer_daemon_micro_break_micro_break_view_type_id = g_type_register_static (BREAK_TIMER_DAEMON_TIMER_BREAK_TYPE_TIMER_BREAK_VIEW, "BreakTimerDaemonMicroBreakMicroBreakView", &g_define_type_info, 0);
	BreakTimerDaemonMicroBreakMicroBreakView_private_offset = g_type_add_instance_private (break_timer_daemon_micro_break_micro_break_view_type_id, sizeof (BreakTimerDaemonMicroBreakMicroBreakViewPrivate));
	return break_timer_daemon_micro_break_micro_break_view_type_id;
}

GType
break_timer_daemon_micro_break_micro_break_view_get_type (void)
{
	static volatile gsize break_timer_daemon_micro_break_micro_break_view_type_id__once = 0;
	if (g_once_init_enter (&break_timer_daemon_micro_break_micro_break_view_type_id__once)) {
		GType break_timer_daemon_micro_break_micro_break_view_type_id;
		break_timer_daemon_micro_break_micro_break_view_type_id = break_timer_daemon_micro_break_micro_break_view_get_type_once ();
		g_once_init_leave (&break_timer_daemon_micro_break_micro_break_view_type_id__once, break_timer_daemon_micro_break_micro_break_view_type_id);
	}
	return break_timer_daemon_micro_break_micro_break_view_type_id__once;
}

static void
_vala_break_timer_daemon_micro_break_micro_break_view_get_property (GObject * object,
                                                                    guint property_id,
                                                                    GValue * value,
                                                                    GParamSpec * pspec)
{
	BreakTimerDaemonMicroBreakMicroBreakView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BREAK_TIMER_DAEMON_MICRO_BREAK_TYPE_MICRO_BREAK_VIEW, BreakTimerDaemonMicroBreakMicroBreakView);
	switch (property_id) {
		case BREAK_TIMER_DAEMON_MICRO_BREAK_MICRO_BREAK_VIEW_MICRO_BREAK_PROPERTY:
		g_value_set_object (value, break_timer_daemon_micro_break_micro_break_view_get_micro_break (self));
		break;
		case BREAK_TIMER_DAEMON_MICRO_BREAK_MICRO_BREAK_VIEW_FOCUS_PRIORITY_PROPERTY:
		g_value_set_enum (value, break_timer_daemon_ui_fragment_get_focus_priority ((BreakTimerDaemonUIFragment*) self));
		break;
		case BREAK_TIMER_DAEMON_MICRO_BREAK_MICRO_BREAK_VIEW_NOTIFICATION_IDS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, break_timer_daemon_ui_fragment_get_notification_ids ((BreakTimerDaemonUIFragment*) self, &length));
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

