/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_rotator_cc = R"doc(Complex rotator.

Rotates an input complex sequence using a complex exponential in the form of exp(1j * phase_inc * n), where \"phase_inc\" is a chosen phase increment in radians and \"n\" is the sample index.


Message Ports:

Constructor Specific Documentation:

Make a complex rotator block.

Args:
    phase_inc : rotational velocity
    tag_inc_updates : Tag the sample where a phase increment update is applied following the reception of a control message received via the input message port.)doc";


static const char* __doc_gr_blocks_rotator_cc_rotator_cc_0 = R"doc()doc";


static const char* __doc_gr_blocks_rotator_cc_rotator_cc_1 = R"doc()doc";


static const char* __doc_gr_blocks_rotator_cc_make = R"doc(Complex rotator.

Rotates an input complex sequence using a complex exponential in the form of exp(1j * phase_inc * n), where \"phase_inc\" is a chosen phase increment in radians and \"n\" is the sample index.


Message Ports:

Constructor Specific Documentation:

Make a complex rotator block.

Args:
    phase_inc : rotational velocity
    tag_inc_updates : Tag the sample where a phase increment update is applied following the reception of a control message received via the input message port.)doc";


static const char* __doc_gr_blocks_rotator_cc_set_phase_inc = R"doc()doc";
