/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, dtv, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_dtv_dvbt_energy_dispersal = R"doc(Energy dispersal.

ETSI EN 300 744 - Clause 4.3.1 
Input - MPEG-2 transport packets (including sync - 0x47). 
Output - Randomized MPEG-2 transport packets. 
If first byte is not a SYNC then look for it. 
First sync in a row of 8 packets is reversed - 0xB8. 
Block size is 188 bytes.

Constructor Specific Documentation:

Create DVB-T energy dispersal.

Args:
    nsize : number of blocks.)doc";


static const char* __doc_gr_dtv_dvbt_energy_dispersal_dvbt_energy_dispersal = R"doc()doc";


static const char* __doc_gr_dtv_dvbt_energy_dispersal_make = R"doc(Energy dispersal.

ETSI EN 300 744 - Clause 4.3.1 
Input - MPEG-2 transport packets (including sync - 0x47). 
Output - Randomized MPEG-2 transport packets. 
If first byte is not a SYNC then look for it. 
First sync in a row of 8 packets is reversed - 0xB8. 
Block size is 188 bytes.

Constructor Specific Documentation:

Create DVB-T energy dispersal.

Args:
    nsize : number of blocks.)doc";
