/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_tag_gate = R"doc(Control tag propagation.

Use this block to stop tags from propagating.

Constructor Specific Documentation:



Args:
    item_size : Item size
    propagate_tags : Set this to true to allow tags to pass through this block.)doc";


static const char* __doc_gr_blocks_tag_gate_tag_gate_0 = R"doc()doc";


static const char* __doc_gr_blocks_tag_gate_tag_gate_1 = R"doc()doc";


static const char* __doc_gr_blocks_tag_gate_set_propagation = R"doc()doc";


static const char* __doc_gr_blocks_tag_gate_make = R"doc(Control tag propagation.

Use this block to stop tags from propagating.

Constructor Specific Documentation:



Args:
    item_size : Item size
    propagate_tags : Set this to true to allow tags to pass through this block.)doc";


static const char* __doc_gr_blocks_tag_gate_set_single_key = R"doc(Only gate stream tags with one specific key instead of all keys.

If set to \"\", all tags will be affected by the gate. If set to \"foo\", all tags with key different from \"foo\" will pass through.)doc";


static const char* __doc_gr_blocks_tag_gate_single_key = R"doc(Get the current single key.)doc";
