/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, qtgui, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_qtgui_const_sink_c = R"doc(A graphical sink to display the IQ constellation of multiple signals.

This is a QT-based graphical sink the takes set of a complex streams and plots them on an IQ constellation plot.


The sink supports plotting streaming complex data or messages. The message port is named \"in\". The two modes cannot be used simultaneously, and  should be set to 0 when using the message mode. GRC handles this issue by providing the \"Complex Message\" type that removes the streaming port(s).


This sink can plot messages that contain either uniform vectors of complex 32 values (pmt::is_c32vector) or PDUs where the data is a uniform vector of complex 32 values.

Constructor Specific Documentation:

Build a constellation plot sink.

Args:
    size : number of points to plot at once
    name : title for the plot
    nconnections : number of signals connected to sink
    parent : a QWidget parent object, if any)doc";


static const char* __doc_gr_qtgui_const_sink_c_const_sink_c_0 = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_const_sink_c_1 = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_make = R"doc(A graphical sink to display the IQ constellation of multiple signals.

This is a QT-based graphical sink the takes set of a complex streams and plots them on an IQ constellation plot.


The sink supports plotting streaming complex data or messages. The message port is named \"in\". The two modes cannot be used simultaneously, and  should be set to 0 when using the message mode. GRC handles this issue by providing the \"Complex Message\" type that removes the streaming port(s).


This sink can plot messages that contain either uniform vectors of complex 32 values (pmt::is_c32vector) or PDUs where the data is a uniform vector of complex 32 values.

Constructor Specific Documentation:

Build a constellation plot sink.

Args:
    size : number of points to plot at once
    name : title for the plot
    nconnections : number of signals connected to sink
    parent : a QWidget parent object, if any)doc";


static const char* __doc_gr_qtgui_const_sink_c_exec_ = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_qwidget = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_set_y_axis = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_set_x_axis = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_set_update_time = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_set_title = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_set_line_label = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_set_line_color = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_set_line_width = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_set_line_style = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_set_line_marker = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_set_nsamps = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_set_line_alpha = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_set_trigger_mode = R"doc(Set up a trigger for the sink to know when to start plotting. Useful to isolate events and avoid noise.


The trigger modes are Free, Auto, Normal, and Tag (see gr::qtgui::trigger_mode). The first three are like a normal oscope trigger function. Free means free running with no trigger, auto will trigger if the trigger event is seen, but will still plot otherwise, and normal will hold until the trigger event is observed. The Tag trigger mode allows us to trigger off a specific stream tag. The tag trigger is based only on the name of the tag, so when a tag of the given name is seen, the trigger is activated.


In auto and normal mode, we look for the slope of the magnitude of the signal. As a constellation sink, this only takes in complex numbers to plot. Given a gr::qtgui::trigger_slope as either Positive or Negative, if the magnitude between two samples moves in the given direction (x[1] > x[0] for Positive or x[1] < x[0] for Negative), then the trigger is activated.)doc";


static const char* __doc_gr_qtgui_const_sink_c_title = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_line_label = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_line_color = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_line_width = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_line_style = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_line_marker = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_line_alpha = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_set_size = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_enable_menu = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_enable_autoscale = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_enable_grid = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_enable_axis_labels = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_disable_legend = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_nsamps = R"doc()doc";


static const char* __doc_gr_qtgui_const_sink_c_reset = R"doc()doc";
