/* gpx-file-base.c generated by valac 0.56.18, the Vala compiler
 * generated from gpx-file-base.vala, do not modify */

/* Gpx Viewer
 * Copyright (C) 2009-2015 Qball Cow <qball@sarine.nl>
 * Project homepage: http://blog.sarine.nl/

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "gpx.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GPX_FILE_BASE_0_PROPERTY,
	GPX_FILE_BASE_NUM_PROPERTIES
};
static GParamSpec* gpx_file_base_properties[GPX_FILE_BASE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

static gpointer gpx_file_base_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void _gpx_point_unref0_ (gpointer var);
static inline void _g_list_free__gpx_point_unref0_ (GList* self);
static void gpx_file_base_finalize (GObject * obj);
static GType gpx_file_base_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

GQuark
gpx_file_error_quark (void)
{
	return g_quark_from_static_string ("gpx-file-error-quark");
}

static GType
gpx_file_error_get_type_once (void)
{
	static const GEnumValue values[] = {{GPX_FILE_ERROR_INVALID_FILE, "GPX_FILE_ERROR_INVALID_FILE", "invalid-file"}, {GPX_FILE_ERROR_IO_ERROR, "GPX_FILE_ERROR_IO_ERROR", "io-error"}, {0, NULL, NULL}};
	GType gpx_file_error_type_id;
	gpx_file_error_type_id = g_enum_register_static ("GpxFileError", values);
	return gpx_file_error_type_id;
}

GType
gpx_file_error_get_type (void)
{
	static volatile gsize gpx_file_error_type_id__once = 0;
	if (g_once_init_enter (&gpx_file_error_type_id__once)) {
		GType gpx_file_error_type_id;
		gpx_file_error_type_id = gpx_file_error_get_type_once ();
		g_once_init_leave (&gpx_file_error_type_id__once, gpx_file_error_type_id);
	}
	return gpx_file_error_type_id__once;
}

static void
_g_object_unref0_ (gpointer var)
{
#line 36 "../gpx-viewer/libgpx/gpx-file-base.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 91 "gpx-file-base.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 36 "../gpx-viewer/libgpx/gpx-file-base.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 99 "gpx-file-base.c"
}

static void
_gpx_point_unref0_ (gpointer var)
{
#line 38 "../gpx-viewer/libgpx/gpx-file-base.vala"
	(var == NULL) ? NULL : (var = (gpx_point_unref (var), NULL));
#line 107 "gpx-file-base.c"
}

static inline void
_g_list_free__gpx_point_unref0_ (GList* self)
{
#line 38 "../gpx-viewer/libgpx/gpx-file-base.vala"
	g_list_free_full (self, (GDestroyNotify) _gpx_point_unref0_);
#line 115 "gpx-file-base.c"
}

/**
         * Helpers
         */
gchar*
gpx_file_base_get_keywords (GpxFileBase* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 56 "../gpx-viewer/libgpx/gpx-file-base.vala"
	_tmp0_ = self->keywords;
#line 56 "../gpx-viewer/libgpx/gpx-file-base.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 56 "../gpx-viewer/libgpx/gpx-file-base.vala"
	result = _tmp1_;
#line 56 "../gpx-viewer/libgpx/gpx-file-base.vala"
	return result;
#line 135 "gpx-file-base.c"
}

gchar*
gpx_file_base_get_time (GpxFileBase* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 61 "../gpx-viewer/libgpx/gpx-file-base.vala"
	_tmp0_ = self->time;
#line 61 "../gpx-viewer/libgpx/gpx-file-base.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 61 "../gpx-viewer/libgpx/gpx-file-base.vala"
	result = _tmp1_;
#line 61 "../gpx-viewer/libgpx/gpx-file-base.vala"
	return result;
#line 152 "gpx-file-base.c"
}

gchar*
gpx_file_base_get_name (GpxFileBase* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 66 "../gpx-viewer/libgpx/gpx-file-base.vala"
	_tmp0_ = self->name;
#line 66 "../gpx-viewer/libgpx/gpx-file-base.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 66 "../gpx-viewer/libgpx/gpx-file-base.vala"
	result = _tmp1_;
#line 66 "../gpx-viewer/libgpx/gpx-file-base.vala"
	return result;
#line 169 "gpx-file-base.c"
}

gchar*
gpx_file_base_get_description (GpxFileBase* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 71 "../gpx-viewer/libgpx/gpx-file-base.vala"
	_tmp0_ = self->description;
#line 71 "../gpx-viewer/libgpx/gpx-file-base.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 71 "../gpx-viewer/libgpx/gpx-file-base.vala"
	result = _tmp1_;
#line 71 "../gpx-viewer/libgpx/gpx-file-base.vala"
	return result;
#line 186 "gpx-file-base.c"
}

gchar*
gpx_file_base_get_creator (GpxFileBase* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 76 "../gpx-viewer/libgpx/gpx-file-base.vala"
	_tmp0_ = self->creator;
#line 76 "../gpx-viewer/libgpx/gpx-file-base.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 76 "../gpx-viewer/libgpx/gpx-file-base.vala"
	result = _tmp1_;
#line 76 "../gpx-viewer/libgpx/gpx-file-base.vala"
	return result;
#line 203 "gpx-file-base.c"
}

gchar*
gpx_file_base_get_uri (GpxFileBase* self)
{
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 81 "../gpx-viewer/libgpx/gpx-file-base.vala"
	_tmp0_ = self->file;
#line 81 "../gpx-viewer/libgpx/gpx-file-base.vala"
	_tmp1_ = g_file_get_uri (_tmp0_);
#line 81 "../gpx-viewer/libgpx/gpx-file-base.vala"
	result = _tmp1_;
#line 81 "../gpx-viewer/libgpx/gpx-file-base.vala"
	return result;
#line 220 "gpx-file-base.c"
}

gchar*
gpx_file_base_get_basename (GpxFileBase* self)
{
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 87 "../gpx-viewer/libgpx/gpx-file-base.vala"
	_tmp0_ = self->file;
#line 87 "../gpx-viewer/libgpx/gpx-file-base.vala"
	_tmp1_ = g_file_get_basename (_tmp0_);
#line 87 "../gpx-viewer/libgpx/gpx-file-base.vala"
	result = _tmp1_;
#line 87 "../gpx-viewer/libgpx/gpx-file-base.vala"
	return result;
#line 237 "gpx-file-base.c"
}

/**
         * Accessors
         */
GList*
gpx_file_base_get_tracks (GpxFileBase* self)
{
	GList* _tmp0_;
	GList* result;
#line 95 "../gpx-viewer/libgpx/gpx-file-base.vala"
	_tmp0_ = self->tracks;
#line 95 "../gpx-viewer/libgpx/gpx-file-base.vala"
	result = _tmp0_;
#line 95 "../gpx-viewer/libgpx/gpx-file-base.vala"
	return result;
#line 254 "gpx-file-base.c"
}

GList*
gpx_file_base_get_waypoints (GpxFileBase* self)
{
	GList* _tmp0_;
	GList* result;
#line 101 "../gpx-viewer/libgpx/gpx-file-base.vala"
	_tmp0_ = self->waypoints;
#line 101 "../gpx-viewer/libgpx/gpx-file-base.vala"
	result = _tmp0_;
#line 101 "../gpx-viewer/libgpx/gpx-file-base.vala"
	return result;
#line 268 "gpx-file-base.c"
}

GList*
gpx_file_base_get_routes (GpxFileBase* self)
{
	GList* _tmp0_;
	GList* result;
#line 107 "../gpx-viewer/libgpx/gpx-file-base.vala"
	_tmp0_ = self->routes;
#line 107 "../gpx-viewer/libgpx/gpx-file-base.vala"
	result = _tmp0_;
#line 107 "../gpx-viewer/libgpx/gpx-file-base.vala"
	return result;
#line 282 "gpx-file-base.c"
}

GpxFileBase*
gpx_file_base_construct (GType object_type)
{
	GpxFileBase * self = NULL;
#line 32 "../gpx-viewer/libgpx/gpx-file-base.vala"
	self = (GpxFileBase*) g_object_new (object_type, NULL);
#line 32 "../gpx-viewer/libgpx/gpx-file-base.vala"
	return self;
#line 293 "gpx-file-base.c"
}

static void
gpx_file_base_class_init (GpxFileBaseClass * klass,
                          gpointer klass_data)
{
#line 32 "../gpx-viewer/libgpx/gpx-file-base.vala"
	gpx_file_base_parent_class = g_type_class_peek_parent (klass);
#line 32 "../gpx-viewer/libgpx/gpx-file-base.vala"
	G_OBJECT_CLASS (klass)->finalize = gpx_file_base_finalize;
#line 304 "gpx-file-base.c"
}

static void
gpx_file_base_instance_init (GpxFileBase * self,
                             gpointer klass)
{
#line 36 "../gpx-viewer/libgpx/gpx-file-base.vala"
	self->tracks = NULL;
#line 38 "../gpx-viewer/libgpx/gpx-file-base.vala"
	self->waypoints = NULL;
#line 40 "../gpx-viewer/libgpx/gpx-file-base.vala"
	self->routes = NULL;
#line 43 "../gpx-viewer/libgpx/gpx-file-base.vala"
	self->file = NULL;
#line 319 "gpx-file-base.c"
}

static void
gpx_file_base_finalize (GObject * obj)
{
	GpxFileBase * self;
#line 32 "../gpx-viewer/libgpx/gpx-file-base.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GPX_TYPE_FILE_BASE, GpxFileBase);
#line 36 "../gpx-viewer/libgpx/gpx-file-base.vala"
	(self->tracks == NULL) ? NULL : (self->tracks = (_g_list_free__g_object_unref0_ (self->tracks), NULL));
#line 38 "../gpx-viewer/libgpx/gpx-file-base.vala"
	(self->waypoints == NULL) ? NULL : (self->waypoints = (_g_list_free__gpx_point_unref0_ (self->waypoints), NULL));
#line 40 "../gpx-viewer/libgpx/gpx-file-base.vala"
	(self->routes == NULL) ? NULL : (self->routes = (_g_list_free__g_object_unref0_ (self->routes), NULL));
#line 43 "../gpx-viewer/libgpx/gpx-file-base.vala"
	_g_object_unref0 (self->file);
#line 45 "../gpx-viewer/libgpx/gpx-file-base.vala"
	_g_free0 (self->creator);
#line 46 "../gpx-viewer/libgpx/gpx-file-base.vala"
	_g_free0 (self->name);
#line 47 "../gpx-viewer/libgpx/gpx-file-base.vala"
	_g_free0 (self->description);
#line 48 "../gpx-viewer/libgpx/gpx-file-base.vala"
	_g_free0 (self->time);
#line 49 "../gpx-viewer/libgpx/gpx-file-base.vala"
	_g_free0 (self->keywords);
#line 32 "../gpx-viewer/libgpx/gpx-file-base.vala"
	G_OBJECT_CLASS (gpx_file_base_parent_class)->finalize (obj);
#line 348 "gpx-file-base.c"
}

/**
     * This is the top level class representing the gpx file it self.
     * This contains a list of tracks and waypoints.
     */
static GType
gpx_file_base_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GpxFileBaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gpx_file_base_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GpxFileBase), 0, (GInstanceInitFunc) gpx_file_base_instance_init, NULL };
	GType gpx_file_base_type_id;
	gpx_file_base_type_id = g_type_register_static (G_TYPE_OBJECT, "GpxFileBase", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return gpx_file_base_type_id;
}

GType
gpx_file_base_get_type (void)
{
	static volatile gsize gpx_file_base_type_id__once = 0;
	if (g_once_init_enter (&gpx_file_base_type_id__once)) {
		GType gpx_file_base_type_id;
		gpx_file_base_type_id = gpx_file_base_get_type_once ();
		g_once_init_leave (&gpx_file_base_type_id__once, gpx_file_base_type_id);
	}
	return gpx_file_base_type_id__once;
}

/**
     * @param file A GLib.File to open.
     *
     * Tries to open the file.. check extension, if that fails, try it.
     *
     * @returns a file.
     * @throws a FileError
     */
GpxFileBase*
gpx_file_open (GFile* path,
               GError** error)
{
	GError* _inner_error0_ = NULL;
	GpxFileBase* result;
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		gboolean _tmp2_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gboolean _tmp8_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gboolean _tmp12_;
		GpxFileBase* f = NULL;
		GpxFitFile* _tmp14_;
#line 123 "../gpx-viewer/libgpx/gpx-file-base.vala"
		_tmp0_ = g_file_get_uri (path);
#line 123 "../gpx-viewer/libgpx/gpx-file-base.vala"
		_tmp1_ = _tmp0_;
#line 123 "../gpx-viewer/libgpx/gpx-file-base.vala"
		_tmp2_ = g_str_has_suffix (_tmp1_, "fit");
#line 123 "../gpx-viewer/libgpx/gpx-file-base.vala"
		_g_free0 (_tmp1_);
#line 123 "../gpx-viewer/libgpx/gpx-file-base.vala"
		if (_tmp2_) {
#line 412 "gpx-file-base.c"
			GpxFitFile* _tmp3_ = NULL;
			GpxFitFile* _tmp4_;
			GpxFitFile* _tmp5_;
#line 124 "../gpx-viewer/libgpx/gpx-file-base.vala"
			_tmp4_ = gpx_fit_file_new (path, &_inner_error0_);
#line 124 "../gpx-viewer/libgpx/gpx-file-base.vala"
			_tmp3_ = _tmp4_;
#line 124 "../gpx-viewer/libgpx/gpx-file-base.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 422 "gpx-file-base.c"
				goto __catch0_g_error;
			}
#line 124 "../gpx-viewer/libgpx/gpx-file-base.vala"
			_tmp5_ = _tmp3_;
#line 124 "../gpx-viewer/libgpx/gpx-file-base.vala"
			_tmp3_ = NULL;
#line 124 "../gpx-viewer/libgpx/gpx-file-base.vala"
			result = (GpxFileBase*) _tmp5_;
#line 124 "../gpx-viewer/libgpx/gpx-file-base.vala"
			_g_object_unref0 (_tmp3_);
#line 124 "../gpx-viewer/libgpx/gpx-file-base.vala"
			return result;
#line 435 "gpx-file-base.c"
		}
#line 127 "../gpx-viewer/libgpx/gpx-file-base.vala"
		_tmp6_ = g_file_get_uri (path);
#line 127 "../gpx-viewer/libgpx/gpx-file-base.vala"
		_tmp7_ = _tmp6_;
#line 127 "../gpx-viewer/libgpx/gpx-file-base.vala"
		_tmp8_ = g_str_has_suffix (_tmp7_, "gpx");
#line 127 "../gpx-viewer/libgpx/gpx-file-base.vala"
		_g_free0 (_tmp7_);
#line 127 "../gpx-viewer/libgpx/gpx-file-base.vala"
		if (_tmp8_) {
#line 447 "gpx-file-base.c"
			GpxXmlFile* _tmp9_;
#line 128 "../gpx-viewer/libgpx/gpx-file-base.vala"
			_tmp9_ = gpx_xml_file_new (path);
#line 128 "../gpx-viewer/libgpx/gpx-file-base.vala"
			result = (GpxFileBase*) _tmp9_;
#line 128 "../gpx-viewer/libgpx/gpx-file-base.vala"
			return result;
#line 455 "gpx-file-base.c"
		}
#line 131 "../gpx-viewer/libgpx/gpx-file-base.vala"
		_tmp10_ = g_file_get_uri (path);
#line 131 "../gpx-viewer/libgpx/gpx-file-base.vala"
		_tmp11_ = _tmp10_;
#line 131 "../gpx-viewer/libgpx/gpx-file-base.vala"
		_tmp12_ = g_str_has_suffix (_tmp11_, "json");
#line 131 "../gpx-viewer/libgpx/gpx-file-base.vala"
		_g_free0 (_tmp11_);
#line 131 "../gpx-viewer/libgpx/gpx-file-base.vala"
		if (_tmp12_) {
#line 467 "gpx-file-base.c"
			GpxJsonFile* _tmp13_;
#line 132 "../gpx-viewer/libgpx/gpx-file-base.vala"
			_tmp13_ = gpx_json_file_new (path);
#line 132 "../gpx-viewer/libgpx/gpx-file-base.vala"
			result = (GpxFileBase*) _tmp13_;
#line 132 "../gpx-viewer/libgpx/gpx-file-base.vala"
			return result;
#line 475 "gpx-file-base.c"
		}
#line 135 "../gpx-viewer/libgpx/gpx-file-base.vala"
		_tmp14_ = gpx_fit_file_new (path, &_inner_error0_);
#line 135 "../gpx-viewer/libgpx/gpx-file-base.vala"
		f = (GpxFileBase*) _tmp14_;
#line 135 "../gpx-viewer/libgpx/gpx-file-base.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 483 "gpx-file-base.c"
			goto __catch0_g_error;
		}
#line 136 "../gpx-viewer/libgpx/gpx-file-base.vala"
		result = f;
#line 136 "../gpx-viewer/libgpx/gpx-file-base.vala"
		return result;
#line 490 "gpx-file-base.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GpxXmlFile* _tmp15_;
#line 121 "../gpx-viewer/libgpx/gpx-file-base.vala"
		g_clear_error (&_inner_error0_);
#line 138 "../gpx-viewer/libgpx/gpx-file-base.vala"
		_tmp15_ = gpx_xml_file_new (path);
#line 138 "../gpx-viewer/libgpx/gpx-file-base.vala"
		result = (GpxFileBase*) _tmp15_;
#line 138 "../gpx-viewer/libgpx/gpx-file-base.vala"
		return result;
#line 504 "gpx-file-base.c"
	}
	__finally0:
#line 121 "../gpx-viewer/libgpx/gpx-file-base.vala"
	if (_inner_error0_->domain == GPX_FILE_ERROR) {
#line 121 "../gpx-viewer/libgpx/gpx-file-base.vala"
		g_propagate_error (error, _inner_error0_);
#line 121 "../gpx-viewer/libgpx/gpx-file-base.vala"
		return NULL;
#line 513 "gpx-file-base.c"
	} else {
#line 121 "../gpx-viewer/libgpx/gpx-file-base.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 121 "../gpx-viewer/libgpx/gpx-file-base.vala"
		g_clear_error (&_inner_error0_);
#line 121 "../gpx-viewer/libgpx/gpx-file-base.vala"
		return NULL;
#line 521 "gpx-file-base.c"
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

