// Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
// This product includes software developed at Datadog (https://www.datadoghq.com/).
// Copyright 2019-Present Datadog, Inc.

package datadogV2

import (
	"fmt"

	"github.com/DataDog/datadog-api-client-go/v2/api/datadog"
)

// VulnerabilityAttributes The JSON:API attributes of the vulnerability.
type VulnerabilityAttributes struct {
	// Advisory associated with the vulnerability.
	Advisory *VulnerabilityAdvisory `json:"advisory,omitempty"`
	// Vulnerability advisory ID.
	AdvisoryId *string `json:"advisory_id,omitempty"`
	// Code vulnerability location.
	CodeLocation *CodeLocation `json:"code_location,omitempty"`
	// Vulnerability CVE list.
	CveList []string `json:"cve_list"`
	// Vulnerability severities.
	Cvss VulnerabilityCvss `json:"cvss"`
	// Static library vulnerability location.
	DependencyLocations *VulnerabilityDependencyLocations `json:"dependency_locations,omitempty"`
	// Vulnerability description.
	Description string `json:"description"`
	// The related vulnerability asset ecosystem.
	Ecosystem *VulnerabilityEcosystem `json:"ecosystem,omitempty"`
	// Vulnerability exposure time in seconds.
	ExposureTime int64 `json:"exposure_time"`
	// First detection of the vulnerability in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339) format
	FirstDetection string `json:"first_detection"`
	// Whether the vulnerability has a remediation or not.
	FixAvailable bool `json:"fix_available"`
	// Vulnerability language.
	Language string `json:"language"`
	// Last detection of the vulnerability in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339) format
	LastDetection string `json:"last_detection"`
	// Vulnerability library.
	Library *Library `json:"library,omitempty"`
	// Vulnerability origin.
	Origin []string `json:"origin"`
	// List of remediations.
	Remediations []Remediation `json:"remediations"`
	// Vulnerability `repo_digest` list (when the vulnerability is related to `Image` asset).
	RepoDigests []string `json:"repo_digests,omitempty"`
	// Vulnerability risks.
	Risks VulnerabilityRisks `json:"risks"`
	// The vulnerability status.
	Status VulnerabilityStatus `json:"status"`
	// Vulnerability title.
	Title string `json:"title"`
	// The vulnerability tool.
	Tool VulnerabilityTool `json:"tool"`
	// The vulnerability type.
	Type VulnerabilityType `json:"type"`
	// UnparsedObject contains the raw value of the object if there was an error when deserializing into the struct
	UnparsedObject       map[string]interface{} `json:"-"`
	AdditionalProperties map[string]interface{} `json:"-"`
}

// NewVulnerabilityAttributes instantiates a new VulnerabilityAttributes object.
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed.
func NewVulnerabilityAttributes(cveList []string, cvss VulnerabilityCvss, description string, exposureTime int64, firstDetection string, fixAvailable bool, language string, lastDetection string, origin []string, remediations []Remediation, risks VulnerabilityRisks, status VulnerabilityStatus, title string, tool VulnerabilityTool, typeVar VulnerabilityType) *VulnerabilityAttributes {
	this := VulnerabilityAttributes{}
	this.CveList = cveList
	this.Cvss = cvss
	this.Description = description
	this.ExposureTime = exposureTime
	this.FirstDetection = firstDetection
	this.FixAvailable = fixAvailable
	this.Language = language
	this.LastDetection = lastDetection
	this.Origin = origin
	this.Remediations = remediations
	this.Risks = risks
	this.Status = status
	this.Title = title
	this.Tool = tool
	this.Type = typeVar
	return &this
}

// NewVulnerabilityAttributesWithDefaults instantiates a new VulnerabilityAttributes object.
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set.
func NewVulnerabilityAttributesWithDefaults() *VulnerabilityAttributes {
	this := VulnerabilityAttributes{}
	return &this
}

// GetAdvisory returns the Advisory field value if set, zero value otherwise.
func (o *VulnerabilityAttributes) GetAdvisory() VulnerabilityAdvisory {
	if o == nil || o.Advisory == nil {
		var ret VulnerabilityAdvisory
		return ret
	}
	return *o.Advisory
}

// GetAdvisoryOk returns a tuple with the Advisory field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *VulnerabilityAttributes) GetAdvisoryOk() (*VulnerabilityAdvisory, bool) {
	if o == nil || o.Advisory == nil {
		return nil, false
	}
	return o.Advisory, true
}

// HasAdvisory returns a boolean if a field has been set.
func (o *VulnerabilityAttributes) HasAdvisory() bool {
	return o != nil && o.Advisory != nil
}

// SetAdvisory gets a reference to the given VulnerabilityAdvisory and assigns it to the Advisory field.
func (o *VulnerabilityAttributes) SetAdvisory(v VulnerabilityAdvisory) {
	o.Advisory = &v
}

// GetAdvisoryId returns the AdvisoryId field value if set, zero value otherwise.
func (o *VulnerabilityAttributes) GetAdvisoryId() string {
	if o == nil || o.AdvisoryId == nil {
		var ret string
		return ret
	}
	return *o.AdvisoryId
}

// GetAdvisoryIdOk returns a tuple with the AdvisoryId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *VulnerabilityAttributes) GetAdvisoryIdOk() (*string, bool) {
	if o == nil || o.AdvisoryId == nil {
		return nil, false
	}
	return o.AdvisoryId, true
}

// HasAdvisoryId returns a boolean if a field has been set.
func (o *VulnerabilityAttributes) HasAdvisoryId() bool {
	return o != nil && o.AdvisoryId != nil
}

// SetAdvisoryId gets a reference to the given string and assigns it to the AdvisoryId field.
func (o *VulnerabilityAttributes) SetAdvisoryId(v string) {
	o.AdvisoryId = &v
}

// GetCodeLocation returns the CodeLocation field value if set, zero value otherwise.
func (o *VulnerabilityAttributes) GetCodeLocation() CodeLocation {
	if o == nil || o.CodeLocation == nil {
		var ret CodeLocation
		return ret
	}
	return *o.CodeLocation
}

// GetCodeLocationOk returns a tuple with the CodeLocation field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *VulnerabilityAttributes) GetCodeLocationOk() (*CodeLocation, bool) {
	if o == nil || o.CodeLocation == nil {
		return nil, false
	}
	return o.CodeLocation, true
}

// HasCodeLocation returns a boolean if a field has been set.
func (o *VulnerabilityAttributes) HasCodeLocation() bool {
	return o != nil && o.CodeLocation != nil
}

// SetCodeLocation gets a reference to the given CodeLocation and assigns it to the CodeLocation field.
func (o *VulnerabilityAttributes) SetCodeLocation(v CodeLocation) {
	o.CodeLocation = &v
}

// GetCveList returns the CveList field value.
func (o *VulnerabilityAttributes) GetCveList() []string {
	if o == nil {
		var ret []string
		return ret
	}
	return o.CveList
}

// GetCveListOk returns a tuple with the CveList field value
// and a boolean to check if the value has been set.
func (o *VulnerabilityAttributes) GetCveListOk() (*[]string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.CveList, true
}

// SetCveList sets field value.
func (o *VulnerabilityAttributes) SetCveList(v []string) {
	o.CveList = v
}

// GetCvss returns the Cvss field value.
func (o *VulnerabilityAttributes) GetCvss() VulnerabilityCvss {
	if o == nil {
		var ret VulnerabilityCvss
		return ret
	}
	return o.Cvss
}

// GetCvssOk returns a tuple with the Cvss field value
// and a boolean to check if the value has been set.
func (o *VulnerabilityAttributes) GetCvssOk() (*VulnerabilityCvss, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Cvss, true
}

// SetCvss sets field value.
func (o *VulnerabilityAttributes) SetCvss(v VulnerabilityCvss) {
	o.Cvss = v
}

// GetDependencyLocations returns the DependencyLocations field value if set, zero value otherwise.
func (o *VulnerabilityAttributes) GetDependencyLocations() VulnerabilityDependencyLocations {
	if o == nil || o.DependencyLocations == nil {
		var ret VulnerabilityDependencyLocations
		return ret
	}
	return *o.DependencyLocations
}

// GetDependencyLocationsOk returns a tuple with the DependencyLocations field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *VulnerabilityAttributes) GetDependencyLocationsOk() (*VulnerabilityDependencyLocations, bool) {
	if o == nil || o.DependencyLocations == nil {
		return nil, false
	}
	return o.DependencyLocations, true
}

// HasDependencyLocations returns a boolean if a field has been set.
func (o *VulnerabilityAttributes) HasDependencyLocations() bool {
	return o != nil && o.DependencyLocations != nil
}

// SetDependencyLocations gets a reference to the given VulnerabilityDependencyLocations and assigns it to the DependencyLocations field.
func (o *VulnerabilityAttributes) SetDependencyLocations(v VulnerabilityDependencyLocations) {
	o.DependencyLocations = &v
}

// GetDescription returns the Description field value.
func (o *VulnerabilityAttributes) GetDescription() string {
	if o == nil {
		var ret string
		return ret
	}
	return o.Description
}

// GetDescriptionOk returns a tuple with the Description field value
// and a boolean to check if the value has been set.
func (o *VulnerabilityAttributes) GetDescriptionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Description, true
}

// SetDescription sets field value.
func (o *VulnerabilityAttributes) SetDescription(v string) {
	o.Description = v
}

// GetEcosystem returns the Ecosystem field value if set, zero value otherwise.
func (o *VulnerabilityAttributes) GetEcosystem() VulnerabilityEcosystem {
	if o == nil || o.Ecosystem == nil {
		var ret VulnerabilityEcosystem
		return ret
	}
	return *o.Ecosystem
}

// GetEcosystemOk returns a tuple with the Ecosystem field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *VulnerabilityAttributes) GetEcosystemOk() (*VulnerabilityEcosystem, bool) {
	if o == nil || o.Ecosystem == nil {
		return nil, false
	}
	return o.Ecosystem, true
}

// HasEcosystem returns a boolean if a field has been set.
func (o *VulnerabilityAttributes) HasEcosystem() bool {
	return o != nil && o.Ecosystem != nil
}

// SetEcosystem gets a reference to the given VulnerabilityEcosystem and assigns it to the Ecosystem field.
func (o *VulnerabilityAttributes) SetEcosystem(v VulnerabilityEcosystem) {
	o.Ecosystem = &v
}

// GetExposureTime returns the ExposureTime field value.
func (o *VulnerabilityAttributes) GetExposureTime() int64 {
	if o == nil {
		var ret int64
		return ret
	}
	return o.ExposureTime
}

// GetExposureTimeOk returns a tuple with the ExposureTime field value
// and a boolean to check if the value has been set.
func (o *VulnerabilityAttributes) GetExposureTimeOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return &o.ExposureTime, true
}

// SetExposureTime sets field value.
func (o *VulnerabilityAttributes) SetExposureTime(v int64) {
	o.ExposureTime = v
}

// GetFirstDetection returns the FirstDetection field value.
func (o *VulnerabilityAttributes) GetFirstDetection() string {
	if o == nil {
		var ret string
		return ret
	}
	return o.FirstDetection
}

// GetFirstDetectionOk returns a tuple with the FirstDetection field value
// and a boolean to check if the value has been set.
func (o *VulnerabilityAttributes) GetFirstDetectionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.FirstDetection, true
}

// SetFirstDetection sets field value.
func (o *VulnerabilityAttributes) SetFirstDetection(v string) {
	o.FirstDetection = v
}

// GetFixAvailable returns the FixAvailable field value.
func (o *VulnerabilityAttributes) GetFixAvailable() bool {
	if o == nil {
		var ret bool
		return ret
	}
	return o.FixAvailable
}

// GetFixAvailableOk returns a tuple with the FixAvailable field value
// and a boolean to check if the value has been set.
func (o *VulnerabilityAttributes) GetFixAvailableOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.FixAvailable, true
}

// SetFixAvailable sets field value.
func (o *VulnerabilityAttributes) SetFixAvailable(v bool) {
	o.FixAvailable = v
}

// GetLanguage returns the Language field value.
func (o *VulnerabilityAttributes) GetLanguage() string {
	if o == nil {
		var ret string
		return ret
	}
	return o.Language
}

// GetLanguageOk returns a tuple with the Language field value
// and a boolean to check if the value has been set.
func (o *VulnerabilityAttributes) GetLanguageOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Language, true
}

// SetLanguage sets field value.
func (o *VulnerabilityAttributes) SetLanguage(v string) {
	o.Language = v
}

// GetLastDetection returns the LastDetection field value.
func (o *VulnerabilityAttributes) GetLastDetection() string {
	if o == nil {
		var ret string
		return ret
	}
	return o.LastDetection
}

// GetLastDetectionOk returns a tuple with the LastDetection field value
// and a boolean to check if the value has been set.
func (o *VulnerabilityAttributes) GetLastDetectionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.LastDetection, true
}

// SetLastDetection sets field value.
func (o *VulnerabilityAttributes) SetLastDetection(v string) {
	o.LastDetection = v
}

// GetLibrary returns the Library field value if set, zero value otherwise.
func (o *VulnerabilityAttributes) GetLibrary() Library {
	if o == nil || o.Library == nil {
		var ret Library
		return ret
	}
	return *o.Library
}

// GetLibraryOk returns a tuple with the Library field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *VulnerabilityAttributes) GetLibraryOk() (*Library, bool) {
	if o == nil || o.Library == nil {
		return nil, false
	}
	return o.Library, true
}

// HasLibrary returns a boolean if a field has been set.
func (o *VulnerabilityAttributes) HasLibrary() bool {
	return o != nil && o.Library != nil
}

// SetLibrary gets a reference to the given Library and assigns it to the Library field.
func (o *VulnerabilityAttributes) SetLibrary(v Library) {
	o.Library = &v
}

// GetOrigin returns the Origin field value.
func (o *VulnerabilityAttributes) GetOrigin() []string {
	if o == nil {
		var ret []string
		return ret
	}
	return o.Origin
}

// GetOriginOk returns a tuple with the Origin field value
// and a boolean to check if the value has been set.
func (o *VulnerabilityAttributes) GetOriginOk() (*[]string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Origin, true
}

// SetOrigin sets field value.
func (o *VulnerabilityAttributes) SetOrigin(v []string) {
	o.Origin = v
}

// GetRemediations returns the Remediations field value.
func (o *VulnerabilityAttributes) GetRemediations() []Remediation {
	if o == nil {
		var ret []Remediation
		return ret
	}
	return o.Remediations
}

// GetRemediationsOk returns a tuple with the Remediations field value
// and a boolean to check if the value has been set.
func (o *VulnerabilityAttributes) GetRemediationsOk() (*[]Remediation, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Remediations, true
}

// SetRemediations sets field value.
func (o *VulnerabilityAttributes) SetRemediations(v []Remediation) {
	o.Remediations = v
}

// GetRepoDigests returns the RepoDigests field value if set, zero value otherwise.
func (o *VulnerabilityAttributes) GetRepoDigests() []string {
	if o == nil || o.RepoDigests == nil {
		var ret []string
		return ret
	}
	return o.RepoDigests
}

// GetRepoDigestsOk returns a tuple with the RepoDigests field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *VulnerabilityAttributes) GetRepoDigestsOk() (*[]string, bool) {
	if o == nil || o.RepoDigests == nil {
		return nil, false
	}
	return &o.RepoDigests, true
}

// HasRepoDigests returns a boolean if a field has been set.
func (o *VulnerabilityAttributes) HasRepoDigests() bool {
	return o != nil && o.RepoDigests != nil
}

// SetRepoDigests gets a reference to the given []string and assigns it to the RepoDigests field.
func (o *VulnerabilityAttributes) SetRepoDigests(v []string) {
	o.RepoDigests = v
}

// GetRisks returns the Risks field value.
func (o *VulnerabilityAttributes) GetRisks() VulnerabilityRisks {
	if o == nil {
		var ret VulnerabilityRisks
		return ret
	}
	return o.Risks
}

// GetRisksOk returns a tuple with the Risks field value
// and a boolean to check if the value has been set.
func (o *VulnerabilityAttributes) GetRisksOk() (*VulnerabilityRisks, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Risks, true
}

// SetRisks sets field value.
func (o *VulnerabilityAttributes) SetRisks(v VulnerabilityRisks) {
	o.Risks = v
}

// GetStatus returns the Status field value.
func (o *VulnerabilityAttributes) GetStatus() VulnerabilityStatus {
	if o == nil {
		var ret VulnerabilityStatus
		return ret
	}
	return o.Status
}

// GetStatusOk returns a tuple with the Status field value
// and a boolean to check if the value has been set.
func (o *VulnerabilityAttributes) GetStatusOk() (*VulnerabilityStatus, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Status, true
}

// SetStatus sets field value.
func (o *VulnerabilityAttributes) SetStatus(v VulnerabilityStatus) {
	o.Status = v
}

// GetTitle returns the Title field value.
func (o *VulnerabilityAttributes) GetTitle() string {
	if o == nil {
		var ret string
		return ret
	}
	return o.Title
}

// GetTitleOk returns a tuple with the Title field value
// and a boolean to check if the value has been set.
func (o *VulnerabilityAttributes) GetTitleOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Title, true
}

// SetTitle sets field value.
func (o *VulnerabilityAttributes) SetTitle(v string) {
	o.Title = v
}

// GetTool returns the Tool field value.
func (o *VulnerabilityAttributes) GetTool() VulnerabilityTool {
	if o == nil {
		var ret VulnerabilityTool
		return ret
	}
	return o.Tool
}

// GetToolOk returns a tuple with the Tool field value
// and a boolean to check if the value has been set.
func (o *VulnerabilityAttributes) GetToolOk() (*VulnerabilityTool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Tool, true
}

// SetTool sets field value.
func (o *VulnerabilityAttributes) SetTool(v VulnerabilityTool) {
	o.Tool = v
}

// GetType returns the Type field value.
func (o *VulnerabilityAttributes) GetType() VulnerabilityType {
	if o == nil {
		var ret VulnerabilityType
		return ret
	}
	return o.Type
}

// GetTypeOk returns a tuple with the Type field value
// and a boolean to check if the value has been set.
func (o *VulnerabilityAttributes) GetTypeOk() (*VulnerabilityType, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Type, true
}

// SetType sets field value.
func (o *VulnerabilityAttributes) SetType(v VulnerabilityType) {
	o.Type = v
}

// MarshalJSON serializes the struct using spec logic.
func (o VulnerabilityAttributes) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.UnparsedObject != nil {
		return datadog.Marshal(o.UnparsedObject)
	}
	if o.Advisory != nil {
		toSerialize["advisory"] = o.Advisory
	}
	if o.AdvisoryId != nil {
		toSerialize["advisory_id"] = o.AdvisoryId
	}
	if o.CodeLocation != nil {
		toSerialize["code_location"] = o.CodeLocation
	}
	toSerialize["cve_list"] = o.CveList
	toSerialize["cvss"] = o.Cvss
	if o.DependencyLocations != nil {
		toSerialize["dependency_locations"] = o.DependencyLocations
	}
	toSerialize["description"] = o.Description
	if o.Ecosystem != nil {
		toSerialize["ecosystem"] = o.Ecosystem
	}
	toSerialize["exposure_time"] = o.ExposureTime
	toSerialize["first_detection"] = o.FirstDetection
	toSerialize["fix_available"] = o.FixAvailable
	toSerialize["language"] = o.Language
	toSerialize["last_detection"] = o.LastDetection
	if o.Library != nil {
		toSerialize["library"] = o.Library
	}
	toSerialize["origin"] = o.Origin
	toSerialize["remediations"] = o.Remediations
	if o.RepoDigests != nil {
		toSerialize["repo_digests"] = o.RepoDigests
	}
	toSerialize["risks"] = o.Risks
	toSerialize["status"] = o.Status
	toSerialize["title"] = o.Title
	toSerialize["tool"] = o.Tool
	toSerialize["type"] = o.Type

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}
	return datadog.Marshal(toSerialize)
}

// UnmarshalJSON deserializes the given payload.
func (o *VulnerabilityAttributes) UnmarshalJSON(bytes []byte) (err error) {
	all := struct {
		Advisory            *VulnerabilityAdvisory            `json:"advisory,omitempty"`
		AdvisoryId          *string                           `json:"advisory_id,omitempty"`
		CodeLocation        *CodeLocation                     `json:"code_location,omitempty"`
		CveList             *[]string                         `json:"cve_list"`
		Cvss                *VulnerabilityCvss                `json:"cvss"`
		DependencyLocations *VulnerabilityDependencyLocations `json:"dependency_locations,omitempty"`
		Description         *string                           `json:"description"`
		Ecosystem           *VulnerabilityEcosystem           `json:"ecosystem,omitempty"`
		ExposureTime        *int64                            `json:"exposure_time"`
		FirstDetection      *string                           `json:"first_detection"`
		FixAvailable        *bool                             `json:"fix_available"`
		Language            *string                           `json:"language"`
		LastDetection       *string                           `json:"last_detection"`
		Library             *Library                          `json:"library,omitempty"`
		Origin              *[]string                         `json:"origin"`
		Remediations        *[]Remediation                    `json:"remediations"`
		RepoDigests         []string                          `json:"repo_digests,omitempty"`
		Risks               *VulnerabilityRisks               `json:"risks"`
		Status              *VulnerabilityStatus              `json:"status"`
		Title               *string                           `json:"title"`
		Tool                *VulnerabilityTool                `json:"tool"`
		Type                *VulnerabilityType                `json:"type"`
	}{}
	if err = datadog.Unmarshal(bytes, &all); err != nil {
		return datadog.Unmarshal(bytes, &o.UnparsedObject)
	}
	if all.CveList == nil {
		return fmt.Errorf("required field cve_list missing")
	}
	if all.Cvss == nil {
		return fmt.Errorf("required field cvss missing")
	}
	if all.Description == nil {
		return fmt.Errorf("required field description missing")
	}
	if all.ExposureTime == nil {
		return fmt.Errorf("required field exposure_time missing")
	}
	if all.FirstDetection == nil {
		return fmt.Errorf("required field first_detection missing")
	}
	if all.FixAvailable == nil {
		return fmt.Errorf("required field fix_available missing")
	}
	if all.Language == nil {
		return fmt.Errorf("required field language missing")
	}
	if all.LastDetection == nil {
		return fmt.Errorf("required field last_detection missing")
	}
	if all.Origin == nil {
		return fmt.Errorf("required field origin missing")
	}
	if all.Remediations == nil {
		return fmt.Errorf("required field remediations missing")
	}
	if all.Risks == nil {
		return fmt.Errorf("required field risks missing")
	}
	if all.Status == nil {
		return fmt.Errorf("required field status missing")
	}
	if all.Title == nil {
		return fmt.Errorf("required field title missing")
	}
	if all.Tool == nil {
		return fmt.Errorf("required field tool missing")
	}
	if all.Type == nil {
		return fmt.Errorf("required field type missing")
	}
	additionalProperties := make(map[string]interface{})
	if err = datadog.Unmarshal(bytes, &additionalProperties); err == nil {
		datadog.DeleteKeys(additionalProperties, &[]string{"advisory", "advisory_id", "code_location", "cve_list", "cvss", "dependency_locations", "description", "ecosystem", "exposure_time", "first_detection", "fix_available", "language", "last_detection", "library", "origin", "remediations", "repo_digests", "risks", "status", "title", "tool", "type"})
	} else {
		return err
	}

	hasInvalidField := false
	if all.Advisory != nil && all.Advisory.UnparsedObject != nil && o.UnparsedObject == nil {
		hasInvalidField = true
	}
	o.Advisory = all.Advisory
	o.AdvisoryId = all.AdvisoryId
	if all.CodeLocation != nil && all.CodeLocation.UnparsedObject != nil && o.UnparsedObject == nil {
		hasInvalidField = true
	}
	o.CodeLocation = all.CodeLocation
	o.CveList = *all.CveList
	if all.Cvss.UnparsedObject != nil && o.UnparsedObject == nil {
		hasInvalidField = true
	}
	o.Cvss = *all.Cvss
	if all.DependencyLocations != nil && all.DependencyLocations.UnparsedObject != nil && o.UnparsedObject == nil {
		hasInvalidField = true
	}
	o.DependencyLocations = all.DependencyLocations
	o.Description = *all.Description
	if all.Ecosystem != nil && !all.Ecosystem.IsValid() {
		hasInvalidField = true
	} else {
		o.Ecosystem = all.Ecosystem
	}
	o.ExposureTime = *all.ExposureTime
	o.FirstDetection = *all.FirstDetection
	o.FixAvailable = *all.FixAvailable
	o.Language = *all.Language
	o.LastDetection = *all.LastDetection
	if all.Library != nil && all.Library.UnparsedObject != nil && o.UnparsedObject == nil {
		hasInvalidField = true
	}
	o.Library = all.Library
	o.Origin = *all.Origin
	o.Remediations = *all.Remediations
	o.RepoDigests = all.RepoDigests
	if all.Risks.UnparsedObject != nil && o.UnparsedObject == nil {
		hasInvalidField = true
	}
	o.Risks = *all.Risks
	if !all.Status.IsValid() {
		hasInvalidField = true
	} else {
		o.Status = *all.Status
	}
	o.Title = *all.Title
	if !all.Tool.IsValid() {
		hasInvalidField = true
	} else {
		o.Tool = *all.Tool
	}
	if !all.Type.IsValid() {
		hasInvalidField = true
	} else {
		o.Type = *all.Type
	}

	if len(additionalProperties) > 0 {
		o.AdditionalProperties = additionalProperties
	}

	if hasInvalidField {
		return datadog.Unmarshal(bytes, &o.UnparsedObject)
	}

	return nil
}
