{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GdkX11.Objects.X11AppLaunchContext
    ( 

-- * Exported types
    X11AppLaunchContext(..)                 ,
    IsX11AppLaunchContext                   ,
    toX11AppLaunchContext                   ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [launchFailed]("GI.Gio.Objects.AppLaunchContext#g:method:launchFailed"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [setenv]("GI.Gio.Objects.AppLaunchContext#g:method:setenv"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetenv]("GI.Gio.Objects.AppLaunchContext#g:method:unsetenv"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDisplay]("GI.Gdk.Objects.AppLaunchContext#g:method:getDisplay"), [getEnvironment]("GI.Gio.Objects.AppLaunchContext#g:method:getEnvironment"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getStartupNotifyId]("GI.Gio.Objects.AppLaunchContext#g:method:getStartupNotifyId").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDesktop]("GI.Gdk.Objects.AppLaunchContext#g:method:setDesktop"), [setIcon]("GI.Gdk.Objects.AppLaunchContext#g:method:setIcon"), [setIconName]("GI.Gdk.Objects.AppLaunchContext#g:method:setIconName"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setTimestamp]("GI.Gdk.Objects.AppLaunchContext#g:method:setTimestamp").

#if defined(ENABLE_OVERLOADING)
    ResolveX11AppLaunchContextMethod        ,
#endif



    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#endif

-- | Memory-managed wrapper type.
newtype X11AppLaunchContext = X11AppLaunchContext (SP.ManagedPtr X11AppLaunchContext)
    deriving (Eq)

instance SP.ManagedPtrNewtype X11AppLaunchContext where
    toManagedPtr (X11AppLaunchContext p) = p

foreign import ccall "gdk_x11_app_launch_context_get_type"
    c_gdk_x11_app_launch_context_get_type :: IO B.Types.GType

instance B.Types.TypedObject X11AppLaunchContext where
    glibType = c_gdk_x11_app_launch_context_get_type

instance B.Types.GObject X11AppLaunchContext

-- | Type class for types which can be safely cast to t'X11AppLaunchContext', for instance with `toX11AppLaunchContext`.
class (SP.GObject o, O.IsDescendantOf X11AppLaunchContext o) => IsX11AppLaunchContext o
instance (SP.GObject o, O.IsDescendantOf X11AppLaunchContext o) => IsX11AppLaunchContext o

instance O.HasParentTypes X11AppLaunchContext
type instance O.ParentTypes X11AppLaunchContext = '[Gdk.AppLaunchContext.AppLaunchContext, Gio.AppLaunchContext.AppLaunchContext, GObject.Object.Object]

-- | Cast to t'X11AppLaunchContext', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toX11AppLaunchContext :: (MIO.MonadIO m, IsX11AppLaunchContext o) => o -> m X11AppLaunchContext
toX11AppLaunchContext = MIO.liftIO . B.ManagedPtr.unsafeCastTo X11AppLaunchContext

-- | Convert t'X11AppLaunchContext' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe X11AppLaunchContext) where
    gvalueGType_ = c_gdk_x11_app_launch_context_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr X11AppLaunchContext)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr X11AppLaunchContext)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject X11AppLaunchContext ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveX11AppLaunchContextMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveX11AppLaunchContextMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveX11AppLaunchContextMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveX11AppLaunchContextMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveX11AppLaunchContextMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveX11AppLaunchContextMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveX11AppLaunchContextMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveX11AppLaunchContextMethod "launchFailed" o = Gio.AppLaunchContext.AppLaunchContextLaunchFailedMethodInfo
    ResolveX11AppLaunchContextMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveX11AppLaunchContextMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveX11AppLaunchContextMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveX11AppLaunchContextMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveX11AppLaunchContextMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveX11AppLaunchContextMethod "setenv" o = Gio.AppLaunchContext.AppLaunchContextSetenvMethodInfo
    ResolveX11AppLaunchContextMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveX11AppLaunchContextMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveX11AppLaunchContextMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveX11AppLaunchContextMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveX11AppLaunchContextMethod "unsetenv" o = Gio.AppLaunchContext.AppLaunchContextUnsetenvMethodInfo
    ResolveX11AppLaunchContextMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveX11AppLaunchContextMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveX11AppLaunchContextMethod "getDisplay" o = Gdk.AppLaunchContext.AppLaunchContextGetDisplayMethodInfo
    ResolveX11AppLaunchContextMethod "getEnvironment" o = Gio.AppLaunchContext.AppLaunchContextGetEnvironmentMethodInfo
    ResolveX11AppLaunchContextMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveX11AppLaunchContextMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveX11AppLaunchContextMethod "getStartupNotifyId" o = Gio.AppLaunchContext.AppLaunchContextGetStartupNotifyIdMethodInfo
    ResolveX11AppLaunchContextMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveX11AppLaunchContextMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveX11AppLaunchContextMethod "setDesktop" o = Gdk.AppLaunchContext.AppLaunchContextSetDesktopMethodInfo
    ResolveX11AppLaunchContextMethod "setIcon" o = Gdk.AppLaunchContext.AppLaunchContextSetIconMethodInfo
    ResolveX11AppLaunchContextMethod "setIconName" o = Gdk.AppLaunchContext.AppLaunchContextSetIconNameMethodInfo
    ResolveX11AppLaunchContextMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveX11AppLaunchContextMethod "setTimestamp" o = Gdk.AppLaunchContext.AppLaunchContextSetTimestampMethodInfo
    ResolveX11AppLaunchContextMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveX11AppLaunchContextMethod t X11AppLaunchContext, O.OverloadedMethod info X11AppLaunchContext p) => OL.IsLabel t (X11AppLaunchContext -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveX11AppLaunchContextMethod t X11AppLaunchContext, O.OverloadedMethod info X11AppLaunchContext p, R.HasField t X11AppLaunchContext p) => R.HasField t X11AppLaunchContext p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveX11AppLaunchContextMethod t X11AppLaunchContext, O.OverloadedMethodInfo info X11AppLaunchContext) => OL.IsLabel t (O.MethodProxy info X11AppLaunchContext) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList X11AppLaunchContext
type instance O.AttributeList X11AppLaunchContext = X11AppLaunchContextAttributeList
type X11AppLaunchContextAttributeList = ('[ '("display", Gdk.AppLaunchContext.AppLaunchContextDisplayPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList X11AppLaunchContext = X11AppLaunchContextSignalList
type X11AppLaunchContextSignalList = ('[ '("launchFailed", Gio.AppLaunchContext.AppLaunchContextLaunchFailedSignalInfo), '("launchStarted", Gio.AppLaunchContext.AppLaunchContextLaunchStartedSignalInfo), '("launched", Gio.AppLaunchContext.AppLaunchContextLaunchedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


