{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Triggers when a specific keyval and modifiers are pressed.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.KeyvalTrigger
    ( 

-- * Exported types
    KeyvalTrigger(..)                       ,
    IsKeyvalTrigger                         ,
    toKeyvalTrigger                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [compare]("GI.Gtk.Objects.ShortcutTrigger#g:method:compare"), [equal]("GI.Gtk.Objects.ShortcutTrigger#g:method:equal"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hash]("GI.Gtk.Objects.ShortcutTrigger#g:method:hash"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [print]("GI.Gtk.Objects.ShortcutTrigger#g:method:print"), [printLabel]("GI.Gtk.Objects.ShortcutTrigger#g:method:printLabel"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [toLabel]("GI.Gtk.Objects.ShortcutTrigger#g:method:toLabel"), [toString]("GI.Gtk.Objects.ShortcutTrigger#g:method:toString"), [trigger]("GI.Gtk.Objects.ShortcutTrigger#g:method:trigger"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getKeyval]("GI.Gtk.Objects.KeyvalTrigger#g:method:getKeyval"), [getModifiers]("GI.Gtk.Objects.KeyvalTrigger#g:method:getModifiers"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveKeyvalTriggerMethod              ,
#endif

-- ** getKeyval #method:getKeyval#

#if defined(ENABLE_OVERLOADING)
    KeyvalTriggerGetKeyvalMethodInfo        ,
#endif
    keyvalTriggerGetKeyval                  ,


-- ** getModifiers #method:getModifiers#

#if defined(ENABLE_OVERLOADING)
    KeyvalTriggerGetModifiersMethodInfo     ,
#endif
    keyvalTriggerGetModifiers               ,


-- ** new #method:new#

    keyvalTriggerNew                        ,




 -- * Properties


-- ** keyval #attr:keyval#
-- | The key value for the trigger.

#if defined(ENABLE_OVERLOADING)
    KeyvalTriggerKeyvalPropertyInfo         ,
#endif
    constructKeyvalTriggerKeyval            ,
    getKeyvalTriggerKeyval                  ,
#if defined(ENABLE_OVERLOADING)
    keyvalTriggerKeyval                     ,
#endif


-- ** modifiers #attr:modifiers#
-- | The key modifiers for the trigger.

#if defined(ENABLE_OVERLOADING)
    KeyvalTriggerModifiersPropertyInfo      ,
#endif
    constructKeyvalTriggerModifiers         ,
    getKeyvalTriggerModifiers               ,
#if defined(ENABLE_OVERLOADING)
    keyvalTriggerModifiers                  ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Enums as Gdk.Enums
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gtk.Objects.ShortcutTrigger as Gtk.ShortcutTrigger

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Objects.ShortcutTrigger as Gtk.ShortcutTrigger

#endif

-- | Memory-managed wrapper type.
newtype KeyvalTrigger = KeyvalTrigger (SP.ManagedPtr KeyvalTrigger)
    deriving (Eq)

instance SP.ManagedPtrNewtype KeyvalTrigger where
    toManagedPtr (KeyvalTrigger p) = p

foreign import ccall "gtk_keyval_trigger_get_type"
    c_gtk_keyval_trigger_get_type :: IO B.Types.GType

instance B.Types.TypedObject KeyvalTrigger where
    glibType = c_gtk_keyval_trigger_get_type

instance B.Types.GObject KeyvalTrigger

-- | Type class for types which can be safely cast to t'KeyvalTrigger', for instance with `toKeyvalTrigger`.
class (SP.GObject o, O.IsDescendantOf KeyvalTrigger o) => IsKeyvalTrigger o
instance (SP.GObject o, O.IsDescendantOf KeyvalTrigger o) => IsKeyvalTrigger o

instance O.HasParentTypes KeyvalTrigger
type instance O.ParentTypes KeyvalTrigger = '[Gtk.ShortcutTrigger.ShortcutTrigger, GObject.Object.Object]

-- | Cast to t'KeyvalTrigger', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toKeyvalTrigger :: (MIO.MonadIO m, IsKeyvalTrigger o) => o -> m KeyvalTrigger
toKeyvalTrigger = MIO.liftIO . B.ManagedPtr.unsafeCastTo KeyvalTrigger

-- | Convert t'KeyvalTrigger' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe KeyvalTrigger) where
    gvalueGType_ = c_gtk_keyval_trigger_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr KeyvalTrigger)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr KeyvalTrigger)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject KeyvalTrigger ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveKeyvalTriggerMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveKeyvalTriggerMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveKeyvalTriggerMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveKeyvalTriggerMethod "compare" o = Gtk.ShortcutTrigger.ShortcutTriggerCompareMethodInfo
    ResolveKeyvalTriggerMethod "equal" o = Gtk.ShortcutTrigger.ShortcutTriggerEqualMethodInfo
    ResolveKeyvalTriggerMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveKeyvalTriggerMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveKeyvalTriggerMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveKeyvalTriggerMethod "hash" o = Gtk.ShortcutTrigger.ShortcutTriggerHashMethodInfo
    ResolveKeyvalTriggerMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveKeyvalTriggerMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveKeyvalTriggerMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveKeyvalTriggerMethod "print" o = Gtk.ShortcutTrigger.ShortcutTriggerPrintMethodInfo
    ResolveKeyvalTriggerMethod "printLabel" o = Gtk.ShortcutTrigger.ShortcutTriggerPrintLabelMethodInfo
    ResolveKeyvalTriggerMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveKeyvalTriggerMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveKeyvalTriggerMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveKeyvalTriggerMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveKeyvalTriggerMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveKeyvalTriggerMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveKeyvalTriggerMethod "toLabel" o = Gtk.ShortcutTrigger.ShortcutTriggerToLabelMethodInfo
    ResolveKeyvalTriggerMethod "toString" o = Gtk.ShortcutTrigger.ShortcutTriggerToStringMethodInfo
    ResolveKeyvalTriggerMethod "trigger" o = Gtk.ShortcutTrigger.ShortcutTriggerTriggerMethodInfo
    ResolveKeyvalTriggerMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveKeyvalTriggerMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveKeyvalTriggerMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveKeyvalTriggerMethod "getKeyval" o = KeyvalTriggerGetKeyvalMethodInfo
    ResolveKeyvalTriggerMethod "getModifiers" o = KeyvalTriggerGetModifiersMethodInfo
    ResolveKeyvalTriggerMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveKeyvalTriggerMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveKeyvalTriggerMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveKeyvalTriggerMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveKeyvalTriggerMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveKeyvalTriggerMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveKeyvalTriggerMethod t KeyvalTrigger, O.OverloadedMethod info KeyvalTrigger p) => OL.IsLabel t (KeyvalTrigger -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveKeyvalTriggerMethod t KeyvalTrigger, O.OverloadedMethod info KeyvalTrigger p, R.HasField t KeyvalTrigger p) => R.HasField t KeyvalTrigger p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveKeyvalTriggerMethod t KeyvalTrigger, O.OverloadedMethodInfo info KeyvalTrigger) => OL.IsLabel t (O.MethodProxy info KeyvalTrigger) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "keyval"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@keyval@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' keyvalTrigger #keyval
-- @
getKeyvalTriggerKeyval :: (MonadIO m, IsKeyvalTrigger o) => o -> m Word32
getKeyvalTriggerKeyval obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "keyval"

-- | Construct a t'GValueConstruct' with valid value for the “@keyval@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructKeyvalTriggerKeyval :: (IsKeyvalTrigger o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructKeyvalTriggerKeyval val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "keyval" val

#if defined(ENABLE_OVERLOADING)
data KeyvalTriggerKeyvalPropertyInfo
instance AttrInfo KeyvalTriggerKeyvalPropertyInfo where
    type AttrAllowedOps KeyvalTriggerKeyvalPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint KeyvalTriggerKeyvalPropertyInfo = IsKeyvalTrigger
    type AttrSetTypeConstraint KeyvalTriggerKeyvalPropertyInfo = (~) Word32
    type AttrTransferTypeConstraint KeyvalTriggerKeyvalPropertyInfo = (~) Word32
    type AttrTransferType KeyvalTriggerKeyvalPropertyInfo = Word32
    type AttrGetType KeyvalTriggerKeyvalPropertyInfo = Word32
    type AttrLabel KeyvalTriggerKeyvalPropertyInfo = "keyval"
    type AttrOrigin KeyvalTriggerKeyvalPropertyInfo = KeyvalTrigger
    attrGet = getKeyvalTriggerKeyval
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructKeyvalTriggerKeyval
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.KeyvalTrigger.keyval"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-KeyvalTrigger.html#g:attr:keyval"
        })
#endif

-- VVV Prop "modifiers"
   -- Type: TInterface (Name {namespace = "Gdk", name = "ModifierType"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@modifiers@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' keyvalTrigger #modifiers
-- @
getKeyvalTriggerModifiers :: (MonadIO m, IsKeyvalTrigger o) => o -> m [Gdk.Flags.ModifierType]
getKeyvalTriggerModifiers obj = MIO.liftIO $ B.Properties.getObjectPropertyFlags obj "modifiers"

-- | Construct a t'GValueConstruct' with valid value for the “@modifiers@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructKeyvalTriggerModifiers :: (IsKeyvalTrigger o, MIO.MonadIO m) => [Gdk.Flags.ModifierType] -> m (GValueConstruct o)
constructKeyvalTriggerModifiers val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyFlags "modifiers" val

#if defined(ENABLE_OVERLOADING)
data KeyvalTriggerModifiersPropertyInfo
instance AttrInfo KeyvalTriggerModifiersPropertyInfo where
    type AttrAllowedOps KeyvalTriggerModifiersPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint KeyvalTriggerModifiersPropertyInfo = IsKeyvalTrigger
    type AttrSetTypeConstraint KeyvalTriggerModifiersPropertyInfo = (~) [Gdk.Flags.ModifierType]
    type AttrTransferTypeConstraint KeyvalTriggerModifiersPropertyInfo = (~) [Gdk.Flags.ModifierType]
    type AttrTransferType KeyvalTriggerModifiersPropertyInfo = [Gdk.Flags.ModifierType]
    type AttrGetType KeyvalTriggerModifiersPropertyInfo = [Gdk.Flags.ModifierType]
    type AttrLabel KeyvalTriggerModifiersPropertyInfo = "modifiers"
    type AttrOrigin KeyvalTriggerModifiersPropertyInfo = KeyvalTrigger
    attrGet = getKeyvalTriggerModifiers
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructKeyvalTriggerModifiers
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.KeyvalTrigger.modifiers"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-KeyvalTrigger.html#g:attr:modifiers"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList KeyvalTrigger
type instance O.AttributeList KeyvalTrigger = KeyvalTriggerAttributeList
type KeyvalTriggerAttributeList = ('[ '("keyval", KeyvalTriggerKeyvalPropertyInfo), '("modifiers", KeyvalTriggerModifiersPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
keyvalTriggerKeyval :: AttrLabelProxy "keyval"
keyvalTriggerKeyval = AttrLabelProxy

keyvalTriggerModifiers :: AttrLabelProxy "modifiers"
keyvalTriggerModifiers = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList KeyvalTrigger = KeyvalTriggerSignalList
type KeyvalTriggerSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method KeyvalTrigger::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "keyval"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The keyval to trigger for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "modifiers"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the modifiers that need to be present"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "KeyvalTrigger" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_keyval_trigger_new" gtk_keyval_trigger_new :: 
    Word32 ->                               -- keyval : TBasicType TUInt
    CUInt ->                                -- modifiers : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    IO (Ptr KeyvalTrigger)

-- | Creates a @GtkShortcutTrigger@ that will trigger whenever
-- the key with the given /@keyval@/ and /@modifiers@/ is pressed.
keyvalTriggerNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@keyval@/: The keyval to trigger for
    -> [Gdk.Flags.ModifierType]
    -- ^ /@modifiers@/: the modifiers that need to be present
    -> m KeyvalTrigger
    -- ^ __Returns:__ A new @GtkShortcutTrigger@
keyvalTriggerNew keyval modifiers = liftIO $ do
    let modifiers' = gflagsToWord modifiers
    result <- gtk_keyval_trigger_new keyval modifiers'
    checkUnexpectedReturnNULL "keyvalTriggerNew" result
    result' <- (wrapObject KeyvalTrigger) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method KeyvalTrigger::get_keyval
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "KeyvalTrigger" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a keyval `GtkShortcutTrigger`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_keyval_trigger_get_keyval" gtk_keyval_trigger_get_keyval :: 
    Ptr KeyvalTrigger ->                    -- self : TInterface (Name {namespace = "Gtk", name = "KeyvalTrigger"})
    IO Word32

-- | Gets the keyval that must be pressed to succeed
-- triggering /@self@/.
keyvalTriggerGetKeyval ::
    (B.CallStack.HasCallStack, MonadIO m, IsKeyvalTrigger a) =>
    a
    -- ^ /@self@/: a keyval @GtkShortcutTrigger@
    -> m Word32
    -- ^ __Returns:__ the keyval
keyvalTriggerGetKeyval self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_keyval_trigger_get_keyval self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data KeyvalTriggerGetKeyvalMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsKeyvalTrigger a) => O.OverloadedMethod KeyvalTriggerGetKeyvalMethodInfo a signature where
    overloadedMethod = keyvalTriggerGetKeyval

instance O.OverloadedMethodInfo KeyvalTriggerGetKeyvalMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.KeyvalTrigger.keyvalTriggerGetKeyval",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-KeyvalTrigger.html#v:keyvalTriggerGetKeyval"
        })


#endif

-- method KeyvalTrigger::get_modifiers
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "KeyvalTrigger" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a keyval `GtkShortcutTrigger`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "ModifierType" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_keyval_trigger_get_modifiers" gtk_keyval_trigger_get_modifiers :: 
    Ptr KeyvalTrigger ->                    -- self : TInterface (Name {namespace = "Gtk", name = "KeyvalTrigger"})
    IO CUInt

-- | Gets the modifiers that must be present to succeed
-- triggering /@self@/.
keyvalTriggerGetModifiers ::
    (B.CallStack.HasCallStack, MonadIO m, IsKeyvalTrigger a) =>
    a
    -- ^ /@self@/: a keyval @GtkShortcutTrigger@
    -> m [Gdk.Flags.ModifierType]
    -- ^ __Returns:__ the modifiers
keyvalTriggerGetModifiers self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_keyval_trigger_get_modifiers self'
    let result' = wordToGFlags result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data KeyvalTriggerGetModifiersMethodInfo
instance (signature ~ (m [Gdk.Flags.ModifierType]), MonadIO m, IsKeyvalTrigger a) => O.OverloadedMethod KeyvalTriggerGetModifiersMethodInfo a signature where
    overloadedMethod = keyvalTriggerGetModifiers

instance O.OverloadedMethodInfo KeyvalTriggerGetModifiersMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.KeyvalTrigger.keyvalTriggerGetModifiers",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-KeyvalTrigger.html#v:keyvalTriggerGetModifiers"
        })


#endif


