#ifndef __4xBRZ_INCLUDE_H__
#define __4xBRZ_INCLUDE_H__
static const GLchar Yglprg_blit_4xbrz_v[] =
"#version 310 es \n"
" layout (location = 0) in vec2 VertexCoord;\n"
" layout (location = 1) in vec2 TexCoord;\n"
" uniform vec2 DrawingSize;\n"
"out vec2 vTexCoord;\n"
"out vec4 t1;\n"
"out vec4 t2;\n"
"out vec4 t3;\n"
"out vec4 t4;\n"
"out vec4 t5;\n"
"out vec4 t6;\n"
"out vec4 t7;\n"
"\n"
"#define SourceSize vec4(DrawingSize, 1.0 / DrawingSize)\n"
"\n"
"void main()\n"
"{\n"
"    gl_Position = vec4(VertexCoord, 0.0, 1.0);\n"
"    vTexCoord = TexCoord;\n"
"	vec2 ps = vec2(SourceSize.z, SourceSize.w);\n"
"	float dx = ps.x;\n"
"	float dy = ps.y;\n"
"	float hdx = -ps.x/2.0;\n"
"	float hdy = -ps.y/2.0;\n"
"\n"
"	 //  A1 B1 C1\n"
"	// A0 A  B  C C4\n"
"	// D0 D  E  F F4\n"
"	// G0 G  H  I I4\n"
"	 //  G5 H5 I5\n"
"\n"
"	t1 = TexCoord.xxxy + vec4( -dx-hdx, 0.0, dx+hdx,-2.0*dy-hdy); // A1 B1 C1\n"
"	t2 = TexCoord.xxxy + vec4( -dx-hdx, 0.0, dx+hdx, -dy-hdy);    //  A  B  C\n"
"	t3 = TexCoord.xxxy + vec4( -dx-hdx, 0.0, dx+hdx, 0.0);    //  D  E  F\n"
"	t4 = TexCoord.xxxy + vec4( -dx-hdx, 0.0, dx+hdx, dy+hdy);     //  G  H  I\n"
"	t5 = TexCoord.xxxy + vec4( -dx-hdx, 0.0, dx+hdx, 2.0*dy+hdy); // G5 H5 I5\n"
"	t6 = TexCoord.xyyy + vec4(-2.0*dx-hdx,-dy-hdy, 0.0, dy+hdy);  // A0 D0 G0\n"
"	t7 = TexCoord.xyyy + vec4( 2.0*dx+hdx,-dy-hdy, 0.0, dy+hdy);  // C4 F4 I4\n"
"}\n";

static const GLchar Yglprg_blit_4xbrz_f[] =
"#version 310 es \n"

"\n"
"#ifdef GL_ES\n"
"#ifdef GL_FRAGMENT_PRECISION_HIGH\n"
"precision highp float;\n"
"#else\n"
"precision mediump float;\n"
"#endif\n"
"#endif\n"
"#define BLEND_NONE 0\n"
"#define BLEND_NORMAL 1\n"
"#define BLEND_DOMINANT 2\n"
"#define LUMINANCE_WEIGHT 1.0\n"
"#define EQUAL_COLOR_TOLERANCE 30.0/255.0\n"
"#define STEEP_DIRECTION_THRESHOLD 2.2\n"
"#define DOMINANT_DIRECTION_THRESHOLD 3.6\n"
"\n"
"uniform vec2 TextureSize;\n"
"uniform vec2 DrawingSize;\n"
"uniform sampler2D Texture;\n"
"out vec4 fragColor;\n"
"in vec2 vTexCoord;\n"
"in vec4 t1;\n"
"in vec4 t2;\n"
"in vec4 t3;\n"
"in vec4 t4;\n"
"in vec4 t5;\n"
"in vec4 t6;\n"
"in vec4 t7;\n"
"\n"
"#define SourceSize vec4(DrawingSize, 1.0 / DrawingSize)"
"\n"
"	const float  one_sixth = 1.0 / 6.0;\n"
"	const float  two_sixth = 2.0 / 6.0;\n"
"	const float four_sixth = 4.0 / 6.0;\n"
"	const float five_sixth = 5.0 / 6.0;\n"
"\n"
"	float reduce(const vec3 color)\n"
"	{\n"
"		return dot(color, vec3(65536.0, 256.0, 1.0));\n"
"	}\n"
"	\n"
"	float DistYCbCr(const vec3 pixA, const vec3 pixB)\n"
"	{\n"
"		const vec3 w = vec3(0.2627, 0.6780, 0.0593);\n"
"		const float scaleB = 0.5 / (1.0 - w.b);\n"
"		const float scaleR = 0.5 / (1.0 - w.r);\n"
"		vec3 diff = pixA - pixB;\n"
"		float Y = dot(diff, w);\n"
"		float Cb = scaleB * (diff.b - Y);\n"
"		float Cr = scaleR * (diff.r - Y);\n"
"		\n"
"		return sqrt( ((LUMINANCE_WEIGHT * Y) * (LUMINANCE_WEIGHT * Y)) + (Cb * Cb) + (Cr * Cr) );\n"
"	}\n"
"	\n"
"	bool IsPixEqual(const vec3 pixA, const vec3 pixB)\n"
"	{\n"
"		return (DistYCbCr(pixA, pixB) < EQUAL_COLOR_TOLERANCE);\n"
"	}\n"
"	\n"
"	bool IsBlendingNeeded(const ivec4 blend)\n"
"	{\n"
"		return any(notEqual(blend, ivec4(BLEND_NONE)));\n"
"	}\n"
"	\n"
"	//---------------------------------------\n"
"	// Input Pixel Mapping:    --|21|22|23|--\n"
"	//                         19|06|07|08|09\n"
"	//                         18|05|00|01|10\n"
"	//                         17|04|03|02|11\n"
"	//                         --|15|14|13|--\n"
"	//\n"
"	// Output Pixel Mapping: 20|21|22|23|24|25\n"
"	//                       19|06|07|08|09|26\n"
"	//                       18|05|00|01|10|27\n"
"	//                       17|04|03|02|11|28\n"
"	//                       16|15|14|13|12|29\n"
"	//                       35|34|33|32|31|30\n"
"\n"
"void main()\n"
"{\n"
"vec2 f = fract(vTexCoord * SourceSize.xy);\n"
"\n"
"	//---------------------------------------\n"
"	// Input Pixel Mapping:  20|21|22|23|24\n"
"	//                       19|06|07|08|09\n"
"	//                       18|05|00|01|10\n"
"	//                       17|04|03|02|11\n"
"	//                       16|15|14|13|12\n"
"  \n"
"	vec3 src[25];\n"
"  \n"
"	src[21] = texelFetch(Texture, ivec2((t1.xw*TextureSize)), 0).rgb;\n"
"	src[22] = texelFetch(Texture, ivec2((t1.yw*TextureSize)), 0).rgb;\n"
"	src[23] = texelFetch(Texture, ivec2((t1.zw*TextureSize)), 0).rgb;\n"
"	src[ 6] = texelFetch(Texture, ivec2((t2.xw*TextureSize)), 0).rgb;\n"
"	src[ 7] = texelFetch(Texture, ivec2((t2.yw*TextureSize)), 0).rgb;\n"
"	src[ 8] = texelFetch(Texture, ivec2((t2.zw*TextureSize)), 0).rgb;\n"
"	src[ 5] = texelFetch(Texture, ivec2((t3.xw*TextureSize)), 0).rgb;\n"
"	src[ 0] = texelFetch(Texture, ivec2((t3.yw*TextureSize)), 0).rgb;\n"
"	src[ 1] = texelFetch(Texture, ivec2((t3.zw*TextureSize)), 0).rgb;\n"
"	src[ 4] = texelFetch(Texture, ivec2((t4.xw*TextureSize)), 0).rgb;\n"
"	src[ 3] = texelFetch(Texture, ivec2((t4.yw*TextureSize)), 0).rgb;\n"
"	src[ 2] = texelFetch(Texture, ivec2((t4.zw*TextureSize)), 0).rgb;\n"
"	src[15] = texelFetch(Texture, ivec2((t5.xw*TextureSize)), 0).rgb;\n"
"	src[14] = texelFetch(Texture, ivec2((t5.yw*TextureSize)), 0).rgb;\n"
"	src[13] = texelFetch(Texture, ivec2((t5.zw*TextureSize)), 0).rgb;\n"
"	src[19] = texelFetch(Texture, ivec2((t6.xy*TextureSize)), 0).rgb;\n"
"	src[18] = texelFetch(Texture, ivec2((t6.xz*TextureSize)), 0).rgb;\n"
"	src[17] = texelFetch(Texture, ivec2((t6.xw*TextureSize)), 0).rgb;\n"
"	src[ 9] = texelFetch(Texture, ivec2((t7.xy*TextureSize)), 0).rgb;\n"
"	src[10] = texelFetch(Texture, ivec2((t7.xz*TextureSize)), 0).rgb;\n"
"	src[11] = texelFetch(Texture, ivec2((t7.xw*TextureSize)), 0).rgb;\n"
"	\n"
"		float v[9];\n"
"		v[0] = reduce(src[0]);\n"
"		v[1] = reduce(src[1]);\n"
"		v[2] = reduce(src[2]);\n"
"		v[3] = reduce(src[3]);\n"
"		v[4] = reduce(src[4]);\n"
"		v[5] = reduce(src[5]);\n"
"		v[6] = reduce(src[6]);\n"
"		v[7] = reduce(src[7]);\n"
"		v[8] = reduce(src[8]);\n"
"		\n"
"		ivec4 blendResult = ivec4(BLEND_NONE);\n"
"		\n"
"		// Preprocess corners\n"
"		// Pixel Tap Mapping: --|--|--|--|--\n"
"		//                    --|--|07|08|--\n"
"		//                    --|05|00|01|10\n"
"		//                    --|04|03|02|11\n"
"		//                    --|--|14|13|--\n"
"		// Corner (1, 1)\n"
"		if ( ((v[0] == v[1] && v[3] == v[2]) || (v[0] == v[3] && v[1] == v[2])) == false)\n"
"		{\n"
"			float dist_03_01 = DistYCbCr(src[ 4], src[ 0]) + DistYCbCr(src[ 0], src[ 8]) + DistYCbCr(src[14], src[ 2]) + DistYCbCr(src[ 2], src[10]) + (4.0 * DistYCbCr(src[ 3], src[ 1]));\n"
"			float dist_00_02 = DistYCbCr(src[ 5], src[ 3]) + DistYCbCr(src[ 3], src[13]) + DistYCbCr(src[ 7], src[ 1]) + DistYCbCr(src[ 1], src[11]) + (4.0 * DistYCbCr(src[ 0], src[ 2]));\n"
"			bool dominantGradient = (DOMINANT_DIRECTION_THRESHOLD * dist_03_01) < dist_00_02;\n"
"			blendResult[2] = ((dist_03_01 < dist_00_02) && (v[0] != v[1]) && (v[0] != v[3])) ? ((dominantGradient) ? BLEND_DOMINANT : BLEND_NORMAL) : BLEND_NONE;\n"
"		}\n"
"\n"
"		// Pixel Tap Mapping: --|--|--|--|--\n"
"		//                    --|06|07|--|--\n"
"		//                    18|05|00|01|--\n"
"		//                    17|04|03|02|--\n"
"		//                    --|15|14|--|--\n"
"		// Corner (0, 1)\n"
"		if ( ((v[5] == v[0] && v[4] == v[3]) || (v[5] == v[4] && v[0] == v[3])) == false)\n"
"		{\n"
"			float dist_04_00 = DistYCbCr(src[17], src[ 5]) + DistYCbCr(src[ 5], src[ 7]) + DistYCbCr(src[15], src[ 3]) + DistYCbCr(src[ 3], src[ 1]) + (4.0 * DistYCbCr(src[ 4], src[ 0]));\n"
"			float dist_05_03 = DistYCbCr(src[18], src[ 4]) + DistYCbCr(src[ 4], src[14]) + DistYCbCr(src[ 6], src[ 0]) + DistYCbCr(src[ 0], src[ 2]) + (4.0 * DistYCbCr(src[ 5], src[ 3]));\n"
"			bool dominantGradient = (DOMINANT_DIRECTION_THRESHOLD * dist_05_03) < dist_04_00;\n"
"			blendResult[3] = ((dist_04_00 > dist_05_03) && (v[0] != v[5]) && (v[0] != v[3])) ? ((dominantGradient) ? BLEND_DOMINANT : BLEND_NORMAL) : BLEND_NONE;\n"
"		}\n"
"		\n"
"		// Pixel Tap Mapping: --|--|22|23|--\n"
"		//                    --|06|07|08|09\n"
"		//                    --|05|00|01|10\n"
"		//                    --|--|03|02|--\n"
"		//                    --|--|--|--|--\n"
"		// Corner (1, 0)\n"
"		if ( ((v[7] == v[8] && v[0] == v[1]) || (v[7] == v[0] && v[8] == v[1])) == false)\n"
"		{\n"
"			float dist_00_08 = DistYCbCr(src[ 5], src[ 7]) + DistYCbCr(src[ 7], src[23]) + DistYCbCr(src[ 3], src[ 1]) + DistYCbCr(src[ 1], src[ 9]) + (4.0 * DistYCbCr(src[ 0], src[ 8]));\n"
"			float dist_07_01 = DistYCbCr(src[ 6], src[ 0]) + DistYCbCr(src[ 0], src[ 2]) + DistYCbCr(src[22], src[ 8]) + DistYCbCr(src[ 8], src[10]) + (4.0 * DistYCbCr(src[ 7], src[ 1]));\n"
"			bool dominantGradient = (DOMINANT_DIRECTION_THRESHOLD * dist_07_01) < dist_00_08;\n"
"			blendResult[1] = ((dist_00_08 > dist_07_01) && (v[0] != v[7]) && (v[0] != v[1])) ? ((dominantGradient) ? BLEND_DOMINANT : BLEND_NORMAL) : BLEND_NONE;\n"
"		}\n"
"		\n"
"		// Pixel Tap Mapping: --|21|22|--|--\n"
"		//                    19|06|07|08|--\n"
"		//                    18|05|00|01|--\n"
"		//                    --|04|03|--|--\n"
"		//                    --|--|--|--|--\n"
"		// Corner (0, 0)\n"
"		if ( ((v[6] == v[7] && v[5] == v[0]) || (v[6] == v[5] && v[7] == v[0])) == false)\n"
"		{\n"
"			float dist_05_07 = DistYCbCr(src[18], src[ 6]) + DistYCbCr(src[ 6], src[22]) + DistYCbCr(src[ 4], src[ 0]) + DistYCbCr(src[ 0], src[ 8]) + (4.0 * DistYCbCr(src[ 5], src[ 7]));\n"
"			float dist_06_00 = DistYCbCr(src[19], src[ 5]) + DistYCbCr(src[ 5], src[ 3]) + DistYCbCr(src[21], src[ 7]) + DistYCbCr(src[ 7], src[ 1]) + (4.0 * DistYCbCr(src[ 6], src[ 0]));\n"
"			bool dominantGradient = (DOMINANT_DIRECTION_THRESHOLD * dist_05_07) < dist_06_00;\n"
"			blendResult[0] = ((dist_05_07 < dist_06_00) && (v[0] != v[5]) && (v[0] != v[7])) ? ((dominantGradient) ? BLEND_DOMINANT : BLEND_NORMAL) : BLEND_NONE;\n"
"		}\n"
"		\n"
"		vec3 dst[16];\n"
"		dst[ 0] = src[0];\n"
"		dst[ 1] = src[0];\n"
"		dst[ 2] = src[0];\n"
"		dst[ 3] = src[0];\n"
"		dst[ 4] = src[0];\n"
"		dst[ 5] = src[0];\n"
"		dst[ 6] = src[0];\n"
"		dst[ 7] = src[0];\n"
"		dst[ 8] = src[0];\n"
"		dst[ 9] = src[0];\n"
"		dst[10] = src[0];\n"
"		dst[11] = src[0];\n"
"		dst[12] = src[0];\n"
"		dst[13] = src[0];\n"
"		dst[14] = src[0];\n"
"		dst[15] = src[0];\n"
"		\n"
"		// Scale pixel\n"
"		if (IsBlendingNeeded(blendResult) == true)\n"
"		{\n"
"			float dist_01_04 = DistYCbCr(src[1], src[4]);\n"
"			float dist_03_08 = DistYCbCr(src[3], src[8]);\n"
"			bool haveShallowLine = (STEEP_DIRECTION_THRESHOLD * dist_01_04 <= dist_03_08) && (v[0] != v[4]) && (v[5] != v[4]);\n"
"			bool haveSteepLine   = (STEEP_DIRECTION_THRESHOLD * dist_03_08 <= dist_01_04) && (v[0] != v[8]) && (v[7] != v[8]);\n"
"			bool needBlend = (blendResult[2] != BLEND_NONE);\n"
"			bool doLineBlend = (  blendResult[2] >= BLEND_DOMINANT ||\n"
"							   ((blendResult[1] != BLEND_NONE && !IsPixEqual(src[0], src[4])) ||\n"
"								 (blendResult[3] != BLEND_NONE && !IsPixEqual(src[0], src[8])) ||\n"
"								 (IsPixEqual(src[4], src[3]) && IsPixEqual(src[3], src[2]) && IsPixEqual(src[2], src[1]) && IsPixEqual(src[1], src[8]) && IsPixEqual(src[0], src[2]) == false) ) == false );\n"
"			\n"
"			vec3 blendPix = ( DistYCbCr(src[0], src[1]) <= DistYCbCr(src[0], src[3]) ) ? src[1] : src[3];\n"
"			dst[ 2] = mix(dst[ 2], blendPix, (needBlend && doLineBlend) ? ((haveShallowLine) ? ((haveSteepLine) ? 1.0/3.0 : 0.25) : ((haveSteepLine) ? 0.25 : 0.00)) : 0.00);\n"
"			dst[ 9] = mix(dst[ 9], blendPix, (needBlend && doLineBlend && haveSteepLine) ? 0.25 : 0.00);\n"
"			dst[10] = mix(dst[10], blendPix, (needBlend && doLineBlend && haveSteepLine) ? 0.75 : 0.00);\n"
"			dst[11] = mix(dst[11], blendPix, (needBlend) ? ((doLineBlend) ? ((haveSteepLine) ? 1.00 : ((haveShallowLine) ? 0.75 : 0.50)) : 0.08677704501) : 0.00);\n"
"			dst[12] = mix(dst[12], blendPix, (needBlend) ? ((doLineBlend) ? 1.00 : 0.6848532563) : 0.00);\n"
"			dst[13] = mix(dst[13], blendPix, (needBlend) ? ((doLineBlend) ? ((haveShallowLine) ? 1.00 : ((haveSteepLine) ? 0.75 : 0.50)) : 0.08677704501) : 0.00);\n"
"			dst[14] = mix(dst[14], blendPix, (needBlend && doLineBlend && haveShallowLine) ? 0.75 : 0.00);\n"
"			dst[15] = mix(dst[15], blendPix, (needBlend && doLineBlend && haveShallowLine) ? 0.25 : 0.00);\n"
"			\n"
"			dist_01_04 = DistYCbCr(src[7], src[2]);\n"
"			dist_03_08 = DistYCbCr(src[1], src[6]);\n"
"			haveShallowLine = (STEEP_DIRECTION_THRESHOLD * dist_01_04 <= dist_03_08) && (v[0] != v[2]) && (v[3] != v[2]);\n"
"			haveSteepLine   = (STEEP_DIRECTION_THRESHOLD * dist_03_08 <= dist_01_04) && (v[0] != v[6]) && (v[5] != v[6]);\n"
"			needBlend = (blendResult[1] != BLEND_NONE);\n"
"			doLineBlend = (  blendResult[1] >= BLEND_DOMINANT ||\n"
"						  !((blendResult[0] != BLEND_NONE && !IsPixEqual(src[0], src[2])) ||\n"
"							(blendResult[2] != BLEND_NONE && !IsPixEqual(src[0], src[6])) ||\n"
"							(IsPixEqual(src[2], src[1]) && IsPixEqual(src[1], src[8]) && IsPixEqual(src[8], src[7]) && IsPixEqual(src[7], src[6]) && !IsPixEqual(src[0], src[8])) ) );\n"
"			\n"
"			blendPix = ( DistYCbCr(src[0], src[7]) <= DistYCbCr(src[0], src[1]) ) ? src[7] : src[1];\n"
"			dst[ 1] = mix(dst[ 1], blendPix, (needBlend && doLineBlend) ? ((haveShallowLine) ? ((haveSteepLine) ? 1.0/3.0 : 0.25) : ((haveSteepLine) ? 0.25 : 0.00)) : 0.00);\n"
"			dst[ 6] = mix(dst[ 6], blendPix, (needBlend && doLineBlend && haveSteepLine) ? 0.25 : 0.00);\n"
"			dst[ 7] = mix(dst[ 7], blendPix, (needBlend && doLineBlend && haveSteepLine) ? 0.75 : 0.00);\n"
"			dst[ 8] = mix(dst[ 8], blendPix, (needBlend) ? ((doLineBlend) ? ((haveSteepLine) ? 1.00 : ((haveShallowLine) ? 0.75 : 0.50)) : 0.08677704501) : 0.00);\n"
"			dst[ 9] = mix(dst[ 9], blendPix, (needBlend) ? ((doLineBlend) ? 1.00 : 0.6848532563) : 0.00);\n"
"			dst[10] = mix(dst[10], blendPix, (needBlend) ? ((doLineBlend) ? ((haveShallowLine) ? 1.00 : ((haveSteepLine) ? 0.75 : 0.50)) : 0.08677704501) : 0.00);\n"
"			dst[11] = mix(dst[11], blendPix, (needBlend && doLineBlend && haveShallowLine) ? 0.75 : 0.00);\n"
"			dst[12] = mix(dst[12], blendPix, (needBlend && doLineBlend && haveShallowLine) ? 0.25 : 0.00);\n"
"\n"
"			dist_01_04 = DistYCbCr(src[5], src[8]);\n"
"			dist_03_08 = DistYCbCr(src[7], src[4]);\n"
"			haveShallowLine = (STEEP_DIRECTION_THRESHOLD * dist_01_04 <= dist_03_08) && (v[0] != v[8]) && (v[1] != v[8]);\n"
"			haveSteepLine   = (STEEP_DIRECTION_THRESHOLD * dist_03_08 <= dist_01_04) && (v[0] != v[4]) && (v[3] != v[4]);\n"
"			needBlend = (blendResult[0] != BLEND_NONE);\n"
"			doLineBlend = (  blendResult[0] >= BLEND_DOMINANT ||\n"
"						  !((blendResult[3] != BLEND_NONE && !IsPixEqual(src[0], src[8])) ||\n"
"							(blendResult[1] != BLEND_NONE && !IsPixEqual(src[0], src[4])) ||\n"
"							(IsPixEqual(src[8], src[7]) && IsPixEqual(src[7], src[6]) && IsPixEqual(src[6], src[5]) && IsPixEqual(src[5], src[4]) && !IsPixEqual(src[0], src[6])) ) );\n"
"			\n"
"			blendPix = ( DistYCbCr(src[0], src[5]) <= DistYCbCr(src[0], src[7]) ) ? src[5] : src[7];\n"
"			dst[ 0] = mix(dst[ 0], blendPix, (needBlend && doLineBlend) ? ((haveShallowLine) ? ((haveSteepLine) ? 1.0/3.0 : 0.25) : ((haveSteepLine) ? 0.25 : 0.00)) : 0.00);\n"
"			dst[15] = mix(dst[15], blendPix, (needBlend && doLineBlend && haveSteepLine) ? 0.25 : 0.00);\n"
"			dst[ 4] = mix(dst[ 4], blendPix, (needBlend && doLineBlend && haveSteepLine) ? 0.75 : 0.00);\n"
"			dst[ 5] = mix(dst[ 5], blendPix, (needBlend) ? ((doLineBlend) ? ((haveSteepLine) ? 1.00 : ((haveShallowLine) ? 0.75 : 0.50)) : 0.08677704501) : 0.00);\n"
"			dst[ 6] = mix(dst[ 6], blendPix, (needBlend) ? ((doLineBlend) ? 1.00 : 0.6848532563) : 0.00);\n"
"			dst[ 7] = mix(dst[ 7], blendPix, (needBlend) ? ((doLineBlend) ? ((haveShallowLine) ? 1.00 : ((haveSteepLine) ? 0.75 : 0.50)) : 0.08677704501) : 0.00);\n"
"			dst[ 8] = mix(dst[ 8], blendPix, (needBlend && doLineBlend && haveShallowLine) ? 0.75 : 0.00);\n"
"			dst[ 9] = mix(dst[ 9], blendPix, (needBlend && doLineBlend && haveShallowLine) ? 0.25 : 0.00);\n"
"			\n"
"			\n"
"			dist_01_04 = DistYCbCr(src[3], src[6]);\n"
"			dist_03_08 = DistYCbCr(src[5], src[2]);\n"
"			haveShallowLine = (STEEP_DIRECTION_THRESHOLD * dist_01_04 <= dist_03_08) && (v[0] != v[6]) && (v[7] != v[6]);\n"
"			haveSteepLine   = (STEEP_DIRECTION_THRESHOLD * dist_03_08 <= dist_01_04) && (v[0] != v[2]) && (v[1] != v[2]);\n"
"			needBlend = (blendResult[3] != BLEND_NONE);\n"
"			doLineBlend = (  blendResult[3] >= BLEND_DOMINANT ||\n"
"						  !((blendResult[2] != BLEND_NONE && !IsPixEqual(src[0], src[6])) ||\n"
"							(blendResult[0] != BLEND_NONE && !IsPixEqual(src[0], src[2])) ||\n"
"							(IsPixEqual(src[6], src[5]) && IsPixEqual(src[5], src[4]) && IsPixEqual(src[4], src[3]) && IsPixEqual(src[3], src[2]) && !IsPixEqual(src[0], src[4])) ) );\n"
"			\n"
"			blendPix = ( DistYCbCr(src[0], src[3]) <= DistYCbCr(src[0], src[5]) ) ? src[3] : src[5];\n"
"			dst[ 3] = mix(dst[ 3], blendPix, (needBlend && doLineBlend) ? ((haveShallowLine) ? ((haveSteepLine) ? 1.0/3.0 : 0.25) : ((haveSteepLine) ? 0.25 : 0.00)) : 0.00);\n"
"			dst[12] = mix(dst[12], blendPix, (needBlend && doLineBlend && haveSteepLine) ? 0.25 : 0.00);\n"
"			dst[13] = mix(dst[13], blendPix, (needBlend && doLineBlend && haveSteepLine) ? 0.75 : 0.00);\n"
"			dst[14] = mix(dst[14], blendPix, (needBlend) ? ((doLineBlend) ? ((haveSteepLine) ? 1.00 : ((haveShallowLine) ? 0.75 : 0.50)) : 0.08677704501) : 0.00);\n"
"			dst[15] = mix(dst[15], blendPix, (needBlend) ? ((doLineBlend) ? 1.00 : 0.6848532563) : 0.00);\n"
"			dst[ 4] = mix(dst[ 4], blendPix, (needBlend) ? ((doLineBlend) ? ((haveShallowLine) ? 1.00 : ((haveSteepLine) ? 0.75 : 0.50)) : 0.08677704501) : 0.00);\n"
"			dst[ 5] = mix(dst[ 5], blendPix, (needBlend && doLineBlend && haveShallowLine) ? 0.75 : 0.00);\n"
"			dst[ 6] = mix(dst[ 6], blendPix, (needBlend && doLineBlend && haveShallowLine) ? 0.25 : 0.00);\n"
"		}\n"
"		\n"
"		vec3 res = mix( mix( mix( mix(dst[ 6], dst[ 7], step(0.25, f.x)), mix(dst[ 8], dst[ 9], step(0.75, f.x)), step(0.50, f.x)),\n"
"		                             mix( mix(dst[ 5], dst[ 0], step(0.25, f.x)), mix(dst[ 1], dst[10], step(0.75, f.x)), step(0.50, f.x)), step(0.25, f.y)),\n"
"		                        mix( mix( mix(dst[ 4], dst[ 3], step(0.25, f.x)), mix(dst[ 2], dst[11], step(0.75, f.x)), step(0.50, f.x)),\n"
"		                             mix( mix(dst[15], dst[14], step(0.25, f.x)), mix(dst[13], dst[12], step(0.75, f.x)), step(0.50, f.x)), step(0.75, f.y)),\n"
"		                                                                                                                                    step(0.50, f.y));\n"
"								 \n"
"   fragColor = vec4(res, 1.0);\n"
"} \n";

#endif
