/* nicola.c generated by valac 0.56.17, the Vala compiler
 * generated from nicola.vala, do not modify */

/*
 * Copyright (C) 2011-2018 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2018 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "libskk/libskk.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SKK_NICOLA_KEY_EVENT_FILTER_TYPE_TIMED_ENTRY (skk_nicola_key_event_filter_timed_entry_get_type ())
#define SKK_NICOLA_KEY_EVENT_FILTER_TIMED_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_NICOLA_KEY_EVENT_FILTER_TYPE_TIMED_ENTRY, SkkNicolaKeyEventFilterTimedEntry))
#define SKK_NICOLA_KEY_EVENT_FILTER_TIMED_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_NICOLA_KEY_EVENT_FILTER_TYPE_TIMED_ENTRY, SkkNicolaKeyEventFilterTimedEntryClass))
#define SKK_NICOLA_KEY_EVENT_FILTER_IS_TIMED_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_NICOLA_KEY_EVENT_FILTER_TYPE_TIMED_ENTRY))
#define SKK_NICOLA_KEY_EVENT_FILTER_IS_TIMED_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_NICOLA_KEY_EVENT_FILTER_TYPE_TIMED_ENTRY))
#define SKK_NICOLA_KEY_EVENT_FILTER_TIMED_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_NICOLA_KEY_EVENT_FILTER_TYPE_TIMED_ENTRY, SkkNicolaKeyEventFilterTimedEntryClass))

typedef struct _SkkNicolaKeyEventFilterTimedEntry SkkNicolaKeyEventFilterTimedEntry;
typedef struct _SkkNicolaKeyEventFilterTimedEntryClass SkkNicolaKeyEventFilterTimedEntryClass;
enum  {
	SKK_NICOLA_KEY_EVENT_FILTER_0_PROPERTY,
	SKK_NICOLA_KEY_EVENT_FILTER_NUM_PROPERTIES
};
static GParamSpec* skk_nicola_key_event_filter_properties[SKK_NICOLA_KEY_EVENT_FILTER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SkkNicolaKeyEventFilterTimedEntryPrivate SkkNicolaKeyEventFilterTimedEntryPrivate;
#define _skk_nicola_key_event_filter_timed_entry_unref0(var) ((var == NULL) ? NULL : (var = (skk_nicola_key_event_filter_timed_entry_unref (var), NULL)))
typedef struct _SkkNicolaKeyEventFilterParamSpecTimedEntry SkkNicolaKeyEventFilterParamSpecTimedEntry;

struct _SkkNicolaKeyEventFilterPrivate {
	GeeLinkedList* pending;
	guint timeout_id;
};

struct _SkkNicolaKeyEventFilterTimedEntry {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SkkNicolaKeyEventFilterTimedEntryPrivate * priv;
	gpointer data;
	gint64 time;
};

struct _SkkNicolaKeyEventFilterTimedEntryClass {
	GTypeClass parent_class;
	void (*finalize) (SkkNicolaKeyEventFilterTimedEntry *self);
};

struct _SkkNicolaKeyEventFilterTimedEntryPrivate {
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
};

struct _SkkNicolaKeyEventFilterParamSpecTimedEntry {
	GParamSpec parent_instance;
};

static gint SkkNicolaKeyEventFilter_private_offset;
static gpointer skk_nicola_key_event_filter_parent_class = NULL;
static gint SkkNicolaKeyEventFilterTimedEntry_private_offset;
static gpointer skk_nicola_key_event_filter_timed_entry_parent_class = NULL;

static gpointer skk_nicola_key_event_filter_timed_entry_ref (gpointer instance);
static void skk_nicola_key_event_filter_timed_entry_unref (gpointer instance);
static GParamSpec* skk_nicola_key_event_filter_param_spec_timed_entry (const gchar* name,
                                                                const gchar* nick,
                                                                const gchar* blurb,
                                                                GType object_type,
                                                                GParamFlags flags) G_GNUC_UNUSED ;
static void skk_nicola_key_event_filter_value_set_timed_entry (GValue* value,
                                                        gpointer v_object) G_GNUC_UNUSED ;
static void skk_nicola_key_event_filter_value_take_timed_entry (GValue* value,
                                                         gpointer v_object) G_GNUC_UNUSED ;
static gpointer skk_nicola_key_event_filter_value_get_timed_entry (const GValue* value) G_GNUC_UNUSED ;
static GType skk_nicola_key_event_filter_timed_entry_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gint64 skk_nicola_key_event_filter_get_time (void);
static gint64 _skk_nicola_key_event_filter_get_time_skk_get_time (gpointer self);
static gboolean skk_nicola_key_event_filter_is_char (SkkKeyEvent* key);
static gboolean skk_nicola_key_event_filter_is_lshift (SkkKeyEvent* key);
static gboolean skk_nicola_key_event_filter_is_rshift (SkkKeyEvent* key);
static gboolean skk_nicola_key_event_filter_is_shift (SkkKeyEvent* key);
static gchar* skk_nicola_key_event_filter_get_special_double_name (SkkKeyEvent* a,
                                                            SkkKeyEvent* b);
static SkkKeyEvent* skk_nicola_key_event_filter_queue (SkkNicolaKeyEventFilter* self,
                                                SkkKeyEvent* key,
                                                gint64 time,
                                                gint64* wait);
static gint64 skk_nicola_key_event_filter_get_next_wait (SkkNicolaKeyEventFilter* self,
                                                  SkkKeyEvent* key,
                                                  gint64 time);
static SkkNicolaKeyEventFilterTimedEntry* skk_nicola_key_event_filter_timed_entry_new (GType t_type,
                                                                                GBoxedCopyFunc t_dup_func,
                                                                                GDestroyNotify t_destroy_func,
                                                                                gconstpointer data,
                                                                                gint64 time);
static SkkNicolaKeyEventFilterTimedEntry* skk_nicola_key_event_filter_timed_entry_construct (GType object_type,
                                                                                      GType t_type,
                                                                                      GBoxedCopyFunc t_dup_func,
                                                                                      GDestroyNotify t_destroy_func,
                                                                                      gconstpointer data,
                                                                                      gint64 time);
static SkkKeyEvent* skk_nicola_key_event_filter_dispatch_single (SkkNicolaKeyEventFilter* self,
                                                          gint64 time);
static void skk_nicola_key_event_filter_apply_shift (SkkNicolaKeyEventFilter* self,
                                              SkkKeyEvent* s,
                                              SkkKeyEvent* c);
static SkkKeyEvent* skk_nicola_key_event_filter_dispatch (SkkNicolaKeyEventFilter* self,
                                                   gint64 time);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static gboolean skk_nicola_key_event_filter_timeout_func (SkkNicolaKeyEventFilter* self);
static SkkKeyEvent* skk_nicola_key_event_filter_real_filter_key_event (SkkKeyEventFilter* base,
                                                                SkkKeyEvent* key);
static gboolean _skk_nicola_key_event_filter_timeout_func_gsource_func (gpointer self);
static void skk_nicola_key_event_filter_real_reset (SkkKeyEventFilter* base);
static void skk_nicola_key_event_filter_timed_entry_finalize (SkkNicolaKeyEventFilterTimedEntry * obj);
static GType skk_nicola_key_event_filter_timed_entry_get_type_once (void);
static GObject * skk_nicola_key_event_filter_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static gchar** _vala_array_dup6 (gchar** self,
                          gssize length);
static void skk_nicola_key_event_filter_finalize (GObject * obj);
static GType skk_nicola_key_event_filter_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const gchar* SKK_NICOLA_KEY_EVENT_FILTER_SPECIAL_DOUBLES[4] = {"[fj]", "[gh]", "[dk]", "[LR]"};

static inline gpointer
skk_nicola_key_event_filter_get_instance_private (SkkNicolaKeyEventFilter* self)
{
	return G_STRUCT_MEMBER_P (self, SkkNicolaKeyEventFilter_private_offset);
}

static gint64
_skk_nicola_key_event_filter_get_time_skk_get_time (gpointer self)
{
	gint64 result;
	result = skk_nicola_key_event_filter_get_time ();
	return result;
}

static gint64
skk_nicola_key_event_filter_get_time (void)
{
	GTimeVal tv = {0};
	GTimeVal _tmp0_;
	GTimeVal _tmp1_;
	gint64 result;
	g_get_current_time (&tv);
	_tmp0_ = tv;
	_tmp1_ = tv;
	result = (((gint64) _tmp0_.tv_sec) * 1000000) + _tmp1_.tv_usec;
	return result;
}

static gboolean
skk_nicola_key_event_filter_is_char (SkkKeyEvent* key)
{
	gunichar _tmp0_;
	gunichar _tmp1_;
	gboolean result;
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = skk_key_event_get_code (key);
	_tmp1_ = _tmp0_;
	result = _tmp1_ != ((gunichar) 0);
	return result;
}

static gboolean
skk_nicola_key_event_filter_is_lshift (SkkKeyEvent* key)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp1_ = skk_key_event_get_name (key);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "lshift") == 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = skk_key_event_get_name (key);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, "Muhenkan") == 0;
	}
	result = _tmp0_;
	return result;
}

static gboolean
skk_nicola_key_event_filter_is_rshift (SkkKeyEvent* key)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp1_ = skk_key_event_get_name (key);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "rshift") == 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = skk_key_event_get_name (key);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, "Henkan") == 0;
	}
	result = _tmp0_;
	return result;
}

static gboolean
skk_nicola_key_event_filter_is_shift (SkkKeyEvent* key)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (key != NULL, FALSE);
	if (skk_nicola_key_event_filter_is_lshift (key)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = skk_nicola_key_event_filter_is_rshift (key);
	}
	result = _tmp0_;
	return result;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static gchar*
skk_nicola_key_event_filter_get_special_double_name (SkkKeyEvent* a,
                                                     SkkKeyEvent* b)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	g_return_val_if_fail (a != NULL, NULL);
	g_return_val_if_fail (b != NULL, NULL);
	if (skk_nicola_key_event_filter_is_shift (a)) {
		_tmp0_ = skk_nicola_key_event_filter_is_shift (b);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("[LR]");
		result = _tmp1_;
		return result;
	} else {
		gboolean _tmp2_ = FALSE;
		if (skk_nicola_key_event_filter_is_char (a)) {
			_tmp2_ = skk_nicola_key_event_filter_is_char (b);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			gunichar ac = 0U;
			gunichar bc = 0U;
			gunichar _tmp3_;
			gunichar _tmp4_;
			gunichar _tmp5_;
			gunichar _tmp6_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp3_ = skk_key_event_get_code (a);
			_tmp4_ = _tmp3_;
			_tmp5_ = skk_key_event_get_code (b);
			_tmp6_ = _tmp5_;
			if (_tmp4_ < _tmp6_) {
				gunichar _tmp7_;
				gunichar _tmp8_;
				gunichar _tmp9_;
				gunichar _tmp10_;
				_tmp7_ = skk_key_event_get_code (a);
				_tmp8_ = _tmp7_;
				ac = _tmp8_;
				_tmp9_ = skk_key_event_get_code (b);
				_tmp10_ = _tmp9_;
				bc = _tmp10_;
			} else {
				gunichar _tmp11_;
				gunichar _tmp12_;
				gunichar _tmp13_;
				gunichar _tmp14_;
				_tmp11_ = skk_key_event_get_code (b);
				_tmp12_ = _tmp11_;
				ac = _tmp12_;
				_tmp13_ = skk_key_event_get_code (a);
				_tmp14_ = _tmp13_;
				bc = _tmp14_;
			}
			_tmp15_ = g_unichar_to_string (ac);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_unichar_to_string (bc);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strconcat ("[", _tmp16_, _tmp18_, "]", NULL);
			_tmp20_ = _tmp19_;
			_g_free0 (_tmp18_);
			_g_free0 (_tmp16_);
			result = _tmp20_;
			return result;
		} else {
			g_return_val_if_reached (NULL);
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static SkkKeyEvent*
skk_nicola_key_event_filter_queue (SkkNicolaKeyEventFilter* self,
                                   SkkKeyEvent* key,
                                   gint64 time,
                                   gint64* wait)
{
	gint64 _vala_wait = 0LL;
	SkkModifierType _tmp0_;
	SkkModifierType _tmp1_;
	SkkKeyEvent* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = skk_key_event_get_modifiers (key);
	_tmp1_ = _tmp0_;
	if ((_tmp1_ & SKK_MODIFIER_TYPE_RELEASE_MASK) != 0) {
		gboolean _tmp2_ = FALSE;
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = self->priv->pending;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ > 0) {
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			SkkNicolaKeyEventFilterTimedEntry* _tmp8_;
			gconstpointer _tmp9_;
			_tmp6_ = self->priv->pending;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, 0);
			_tmp8_ = (SkkNicolaKeyEventFilterTimedEntry*) _tmp7_;
			_tmp9_ = _tmp8_->data;
			_tmp2_ = skk_key_event_base_equal ((SkkKeyEvent*) _tmp9_, key);
			_skk_nicola_key_event_filter_timed_entry_unref0 (_tmp8_);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			SkkNicolaKeyEventFilterTimedEntry* entry = NULL;
			GeeLinkedList* _tmp10_;
			gpointer _tmp11_;
			GeeLinkedList* _tmp12_;
			SkkNicolaKeyEventFilterTimedEntry* _tmp13_;
			gconstpointer _tmp14_;
			SkkKeyEvent* _tmp15_;
			_tmp10_ = self->priv->pending;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, 0);
			entry = (SkkNicolaKeyEventFilterTimedEntry*) _tmp11_;
			_vala_wait = skk_nicola_key_event_filter_get_next_wait (self, key, time);
			_tmp12_ = self->priv->pending;
			gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp12_);
			_tmp13_ = entry;
			_tmp14_ = _tmp13_->data;
			_tmp15_ = _g_object_ref0 ((SkkKeyEvent*) _tmp14_);
			result = _tmp15_;
			_skk_nicola_key_event_filter_timed_entry_unref0 (entry);
			if (wait) {
				*wait = _vala_wait;
			}
			return result;
		}
	} else {
		gboolean _tmp16_ = FALSE;
		GeeLinkedList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		_tmp17_ = self->priv->pending;
		_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		if (_tmp19_ > 0) {
			GeeLinkedList* _tmp20_;
			gpointer _tmp21_;
			SkkNicolaKeyEventFilterTimedEntry* _tmp22_;
			gconstpointer _tmp23_;
			_tmp20_ = self->priv->pending;
			_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, 0);
			_tmp22_ = (SkkNicolaKeyEventFilterTimedEntry*) _tmp21_;
			_tmp23_ = _tmp22_->data;
			_tmp16_ = skk_key_event_base_equal ((SkkKeyEvent*) _tmp23_, key);
			_skk_nicola_key_event_filter_timed_entry_unref0 (_tmp22_);
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			GeeLinkedList* _tmp24_;
			gpointer _tmp25_;
			SkkNicolaKeyEventFilterTimedEntry* _tmp26_;
			SkkKeyEvent* _tmp27_;
			_tmp24_ = self->priv->pending;
			_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, 0);
			_tmp26_ = (SkkNicolaKeyEventFilterTimedEntry*) _tmp25_;
			_tmp26_->time = time;
			_skk_nicola_key_event_filter_timed_entry_unref0 (_tmp26_);
			_vala_wait = skk_nicola_key_event_filter_get_next_wait (self, key, time);
			_tmp27_ = _g_object_ref0 (key);
			result = _tmp27_;
			if (wait) {
				*wait = _vala_wait;
			}
			return result;
		} else {
			GeeLinkedList* _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			GeeLinkedList* _tmp41_;
			SkkNicolaKeyEventFilterTimedEntry* _tmp42_;
			SkkNicolaKeyEventFilterTimedEntry* _tmp43_;
			_tmp28_ = self->priv->pending;
			_tmp29_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp28_);
			_tmp30_ = _tmp29_;
			if (_tmp30_ > 2) {
				GeeBidirListIterator* iter = NULL;
				GeeLinkedList* _tmp31_;
				GeeBidirListIterator* _tmp32_;
				GeeBidirListIterator* _tmp33_;
				_tmp31_ = self->priv->pending;
				_tmp32_ = gee_abstract_bidir_list_bidir_list_iterator ((GeeAbstractBidirList*) _tmp31_);
				iter = _tmp32_;
				_tmp33_ = iter;
				gee_bidir_iterator_last ((GeeBidirIterator*) _tmp33_);
				{
					gboolean _tmp34_ = FALSE;
					_tmp34_ = TRUE;
					while (TRUE) {
						GeeBidirListIterator* _tmp40_;
						if (!_tmp34_) {
							gboolean _tmp35_ = FALSE;
							GeeLinkedList* _tmp36_;
							gint _tmp37_;
							gint _tmp38_;
							_tmp36_ = self->priv->pending;
							_tmp37_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp36_);
							_tmp38_ = _tmp37_;
							if (_tmp38_ > 2) {
								GeeBidirListIterator* _tmp39_;
								_tmp39_ = iter;
								_tmp35_ = gee_bidir_iterator_previous ((GeeBidirIterator*) _tmp39_);
							} else {
								_tmp35_ = FALSE;
							}
							if (!_tmp35_) {
								break;
							}
						}
						_tmp34_ = FALSE;
						_tmp40_ = iter;
						gee_iterator_remove ((GeeIterator*) _tmp40_);
					}
				}
				_g_object_unref0 (iter);
			}
			_tmp41_ = self->priv->pending;
			_tmp42_ = skk_nicola_key_event_filter_timed_entry_new (SKK_TYPE_KEY_EVENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, key, time);
			_tmp43_ = _tmp42_;
			gee_abstract_list_insert ((GeeAbstractList*) _tmp41_, 0, _tmp43_);
			_skk_nicola_key_event_filter_timed_entry_unref0 (_tmp43_);
		}
	}
	_vala_wait = self->maxwait;
	result = NULL;
	if (wait) {
		*wait = _vala_wait;
	}
	return result;
}

static gint64
skk_nicola_key_event_filter_get_next_wait (SkkNicolaKeyEventFilter* self,
                                           SkkKeyEvent* key,
                                           gint64 time)
{
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeLinkedList* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	g_return_val_if_fail (key != NULL, 0LL);
	_tmp0_ = self->priv->pending;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		GeeBidirListIterator* iter = NULL;
		GeeLinkedList* _tmp3_;
		GeeBidirListIterator* _tmp4_;
		GeeBidirListIterator* _tmp5_;
		_tmp3_ = self->priv->pending;
		_tmp4_ = gee_abstract_bidir_list_bidir_list_iterator ((GeeAbstractBidirList*) _tmp3_);
		iter = _tmp4_;
		_tmp5_ = iter;
		gee_bidir_iterator_last ((GeeBidirIterator*) _tmp5_);
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				SkkNicolaKeyEventFilterTimedEntry* entry = NULL;
				GeeBidirListIterator* _tmp8_;
				gpointer _tmp9_;
				SkkNicolaKeyEventFilterTimedEntry* _tmp10_;
				if (!_tmp6_) {
					GeeBidirListIterator* _tmp7_;
					_tmp7_ = iter;
					if (!gee_bidir_iterator_previous ((GeeBidirIterator*) _tmp7_)) {
						break;
					}
				}
				_tmp6_ = FALSE;
				_tmp8_ = iter;
				_tmp9_ = gee_iterator_get ((GeeIterator*) _tmp8_);
				entry = (SkkNicolaKeyEventFilterTimedEntry*) _tmp9_;
				_tmp10_ = entry;
				if ((time - _tmp10_->time) > self->timeout) {
					GeeBidirListIterator* _tmp11_;
					_tmp11_ = iter;
					gee_iterator_remove ((GeeIterator*) _tmp11_);
				}
				_skk_nicola_key_event_filter_timed_entry_unref0 (entry);
			}
		}
		_g_object_unref0 (iter);
	}
	_tmp12_ = self->priv->pending;
	_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_ > 0) {
		GeeLinkedList* _tmp15_;
		gpointer _tmp16_;
		SkkNicolaKeyEventFilterTimedEntry* _tmp17_;
		gint64 _tmp18_;
		_tmp15_ = self->priv->pending;
		_tmp16_ = gee_linked_list_last (_tmp15_);
		_tmp17_ = (SkkNicolaKeyEventFilterTimedEntry*) _tmp16_;
		_tmp18_ = self->timeout - (time - _tmp17_->time);
		_skk_nicola_key_event_filter_timed_entry_unref0 (_tmp17_);
		result = _tmp18_;
		return result;
	} else {
		result = self->maxwait;
		return result;
	}
}

static SkkKeyEvent*
skk_nicola_key_event_filter_dispatch_single (SkkNicolaKeyEventFilter* self,
                                             gint64 time)
{
	SkkNicolaKeyEventFilterTimedEntry* entry = NULL;
	GeeLinkedList* _tmp0_;
	gpointer _tmp1_;
	SkkNicolaKeyEventFilterTimedEntry* _tmp2_;
	SkkKeyEvent* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pending;
	_tmp1_ = gee_queue_peek ((GeeQueue*) _tmp0_);
	entry = (SkkNicolaKeyEventFilterTimedEntry*) _tmp1_;
	_tmp2_ = entry;
	if ((time - _tmp2_->time) > self->timeout) {
		GeeLinkedList* _tmp3_;
		SkkNicolaKeyEventFilterTimedEntry* _tmp4_;
		gconstpointer _tmp5_;
		SkkKeyEvent* _tmp6_;
		_tmp3_ = self->priv->pending;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp3_);
		_tmp4_ = entry;
		_tmp5_ = _tmp4_->data;
		_tmp6_ = _g_object_ref0 ((SkkKeyEvent*) _tmp5_);
		result = _tmp6_;
		_skk_nicola_key_event_filter_timed_entry_unref0 (entry);
		return result;
	}
	result = NULL;
	_skk_nicola_key_event_filter_timed_entry_unref0 (entry);
	return result;
}

static void
skk_nicola_key_event_filter_apply_shift (SkkNicolaKeyEventFilter* self,
                                         SkkKeyEvent* s,
                                         SkkKeyEvent* c)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_return_if_fail (c != NULL);
	if (skk_nicola_key_event_filter_is_lshift (s)) {
		SkkModifierType _tmp0_;
		SkkModifierType _tmp1_;
		_tmp0_ = skk_key_event_get_modifiers (c);
		_tmp1_ = _tmp0_;
		skk_key_event_set_modifiers (c, _tmp1_ | SKK_MODIFIER_TYPE_LSHIFT_MASK);
	} else {
		if (skk_nicola_key_event_filter_is_rshift (s)) {
			SkkModifierType _tmp2_;
			SkkModifierType _tmp3_;
			_tmp2_ = skk_key_event_get_modifiers (c);
			_tmp3_ = _tmp2_;
			skk_key_event_set_modifiers (c, _tmp3_ | SKK_MODIFIER_TYPE_RSHIFT_MASK);
		}
	}
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static SkkKeyEvent*
skk_nicola_key_event_filter_dispatch (SkkNicolaKeyEventFilter* self,
                                      gint64 time)
{
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	SkkKeyEvent* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pending;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 3) {
		SkkNicolaKeyEventFilterTimedEntry* b = NULL;
		GeeLinkedList* _tmp3_;
		gpointer _tmp4_;
		SkkNicolaKeyEventFilterTimedEntry* s = NULL;
		GeeLinkedList* _tmp5_;
		gpointer _tmp6_;
		SkkNicolaKeyEventFilterTimedEntry* a = NULL;
		GeeLinkedList* _tmp7_;
		gpointer _tmp8_;
		gint64 t1 = 0LL;
		SkkNicolaKeyEventFilterTimedEntry* _tmp9_;
		SkkNicolaKeyEventFilterTimedEntry* _tmp10_;
		gint64 t2 = 0LL;
		SkkNicolaKeyEventFilterTimedEntry* _tmp11_;
		SkkNicolaKeyEventFilterTimedEntry* _tmp12_;
		_tmp3_ = self->priv->pending;
		_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, 0);
		b = (SkkNicolaKeyEventFilterTimedEntry*) _tmp4_;
		_tmp5_ = self->priv->pending;
		_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, 1);
		s = (SkkNicolaKeyEventFilterTimedEntry*) _tmp6_;
		_tmp7_ = self->priv->pending;
		_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, 2);
		a = (SkkNicolaKeyEventFilterTimedEntry*) _tmp8_;
		_tmp9_ = s;
		_tmp10_ = a;
		t1 = _tmp9_->time - _tmp10_->time;
		_tmp11_ = b;
		_tmp12_ = s;
		t2 = _tmp11_->time - _tmp12_->time;
		if (t1 <= t2) {
			GeeLinkedList* _tmp13_;
			GeeLinkedList* _tmp14_;
			SkkNicolaKeyEventFilterTimedEntry* _tmp15_;
			SkkKeyEvent* r = NULL;
			SkkKeyEvent* _tmp16_;
			SkkNicolaKeyEventFilterTimedEntry* _tmp17_;
			gconstpointer _tmp18_;
			SkkNicolaKeyEventFilterTimedEntry* _tmp19_;
			gconstpointer _tmp20_;
			SkkNicolaKeyEventFilterTimedEntry* _tmp21_;
			gconstpointer _tmp22_;
			_tmp13_ = self->priv->pending;
			gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp13_);
			_tmp14_ = self->priv->pending;
			_tmp15_ = b;
			gee_deque_offer_head ((GeeDeque*) _tmp14_, _tmp15_);
			_tmp16_ = skk_nicola_key_event_filter_dispatch_single (self, time);
			r = _tmp16_;
			_tmp17_ = s;
			_tmp18_ = _tmp17_->data;
			_tmp19_ = a;
			_tmp20_ = _tmp19_->data;
			skk_nicola_key_event_filter_apply_shift (self, (SkkKeyEvent*) _tmp18_, (SkkKeyEvent*) _tmp20_);
			_tmp21_ = a;
			_tmp22_ = _tmp21_->data;
			g_signal_emit_by_name ((SkkKeyEventFilter*) self, "forwarded", (SkkKeyEvent*) _tmp22_);
			result = r;
			_skk_nicola_key_event_filter_timed_entry_unref0 (a);
			_skk_nicola_key_event_filter_timed_entry_unref0 (s);
			_skk_nicola_key_event_filter_timed_entry_unref0 (b);
			return result;
		} else {
			GeeLinkedList* _tmp23_;
			SkkNicolaKeyEventFilterTimedEntry* _tmp24_;
			gconstpointer _tmp25_;
			SkkNicolaKeyEventFilterTimedEntry* _tmp26_;
			gconstpointer _tmp27_;
			SkkNicolaKeyEventFilterTimedEntry* _tmp28_;
			gconstpointer _tmp29_;
			SkkNicolaKeyEventFilterTimedEntry* _tmp30_;
			gconstpointer _tmp31_;
			SkkKeyEvent* _tmp32_;
			_tmp23_ = self->priv->pending;
			gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp23_);
			_tmp24_ = s;
			_tmp25_ = _tmp24_->data;
			_tmp26_ = b;
			_tmp27_ = _tmp26_->data;
			skk_nicola_key_event_filter_apply_shift (self, (SkkKeyEvent*) _tmp25_, (SkkKeyEvent*) _tmp27_);
			_tmp28_ = a;
			_tmp29_ = _tmp28_->data;
			g_signal_emit_by_name ((SkkKeyEventFilter*) self, "forwarded", (SkkKeyEvent*) _tmp29_);
			_tmp30_ = b;
			_tmp31_ = _tmp30_->data;
			_tmp32_ = _g_object_ref0 ((SkkKeyEvent*) _tmp31_);
			result = _tmp32_;
			_skk_nicola_key_event_filter_timed_entry_unref0 (a);
			_skk_nicola_key_event_filter_timed_entry_unref0 (s);
			_skk_nicola_key_event_filter_timed_entry_unref0 (b);
			return result;
		}
		_skk_nicola_key_event_filter_timed_entry_unref0 (a);
		_skk_nicola_key_event_filter_timed_entry_unref0 (s);
		_skk_nicola_key_event_filter_timed_entry_unref0 (b);
	} else {
		GeeLinkedList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		_tmp33_ = self->priv->pending;
		_tmp34_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		if (_tmp35_ == 2) {
			SkkNicolaKeyEventFilterTimedEntry* b = NULL;
			GeeLinkedList* _tmp36_;
			gpointer _tmp37_;
			SkkNicolaKeyEventFilterTimedEntry* a = NULL;
			GeeLinkedList* _tmp38_;
			gpointer _tmp39_;
			SkkNicolaKeyEventFilterTimedEntry* _tmp40_;
			SkkNicolaKeyEventFilterTimedEntry* _tmp41_;
			_tmp36_ = self->priv->pending;
			_tmp37_ = gee_abstract_list_get ((GeeAbstractList*) _tmp36_, 0);
			b = (SkkNicolaKeyEventFilterTimedEntry*) _tmp37_;
			_tmp38_ = self->priv->pending;
			_tmp39_ = gee_abstract_list_get ((GeeAbstractList*) _tmp38_, 1);
			a = (SkkNicolaKeyEventFilterTimedEntry*) _tmp39_;
			_tmp40_ = b;
			_tmp41_ = a;
			if ((_tmp40_->time - _tmp41_->time) > self->overlap) {
				GeeLinkedList* _tmp42_;
				GeeLinkedList* _tmp43_;
				SkkNicolaKeyEventFilterTimedEntry* _tmp44_;
				SkkKeyEvent* r = NULL;
				SkkKeyEvent* _tmp45_;
				SkkNicolaKeyEventFilterTimedEntry* _tmp46_;
				gconstpointer _tmp47_;
				_tmp42_ = self->priv->pending;
				gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp42_);
				_tmp43_ = self->priv->pending;
				_tmp44_ = b;
				gee_deque_offer_head ((GeeDeque*) _tmp43_, _tmp44_);
				_tmp45_ = skk_nicola_key_event_filter_dispatch_single (self, time);
				r = _tmp45_;
				_tmp46_ = a;
				_tmp47_ = _tmp46_->data;
				g_signal_emit_by_name ((SkkKeyEventFilter*) self, "forwarded", (SkkKeyEvent*) _tmp47_);
				result = r;
				_skk_nicola_key_event_filter_timed_entry_unref0 (a);
				_skk_nicola_key_event_filter_timed_entry_unref0 (b);
				return result;
			} else {
				gboolean _tmp48_ = FALSE;
				gboolean _tmp49_ = FALSE;
				SkkNicolaKeyEventFilterTimedEntry* _tmp50_;
				gconstpointer _tmp51_;
				_tmp50_ = a;
				_tmp51_ = _tmp50_->data;
				if (skk_nicola_key_event_filter_is_char ((SkkKeyEvent*) _tmp51_)) {
					SkkNicolaKeyEventFilterTimedEntry* _tmp52_;
					gconstpointer _tmp53_;
					_tmp52_ = b;
					_tmp53_ = _tmp52_->data;
					_tmp49_ = skk_nicola_key_event_filter_is_char ((SkkKeyEvent*) _tmp53_);
				} else {
					_tmp49_ = FALSE;
				}
				if (_tmp49_) {
					_tmp48_ = TRUE;
				} else {
					gboolean _tmp54_ = FALSE;
					SkkNicolaKeyEventFilterTimedEntry* _tmp55_;
					gconstpointer _tmp56_;
					_tmp55_ = a;
					_tmp56_ = _tmp55_->data;
					if (skk_nicola_key_event_filter_is_shift ((SkkKeyEvent*) _tmp56_)) {
						SkkNicolaKeyEventFilterTimedEntry* _tmp57_;
						gconstpointer _tmp58_;
						_tmp57_ = b;
						_tmp58_ = _tmp57_->data;
						_tmp54_ = skk_nicola_key_event_filter_is_shift ((SkkKeyEvent*) _tmp58_);
					} else {
						_tmp54_ = FALSE;
					}
					_tmp48_ = _tmp54_;
				}
				if (_tmp48_) {
					gchar* name = NULL;
					SkkNicolaKeyEventFilterTimedEntry* _tmp59_;
					gconstpointer _tmp60_;
					SkkNicolaKeyEventFilterTimedEntry* _tmp61_;
					gconstpointer _tmp62_;
					gchar* _tmp63_;
					const gchar* _tmp64_;
					gchar** _tmp65_;
					gint _tmp65__length1;
					_tmp59_ = b;
					_tmp60_ = _tmp59_->data;
					_tmp61_ = a;
					_tmp62_ = _tmp61_->data;
					_tmp63_ = skk_nicola_key_event_filter_get_special_double_name ((SkkKeyEvent*) _tmp60_, (SkkKeyEvent*) _tmp62_);
					name = _tmp63_;
					_tmp64_ = name;
					_tmp65_ = self->special_doubles;
					_tmp65__length1 = self->special_doubles_length1;
					if (_vala_string_array_contains (_tmp65_, _tmp65__length1, _tmp64_)) {
						GeeLinkedList* _tmp66_;
						const gchar* _tmp67_;
						SkkKeyEvent* _tmp68_;
						_tmp66_ = self->priv->pending;
						gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp66_);
						_tmp67_ = name;
						_tmp68_ = skk_key_event_new (_tmp67_, (gunichar) 0, SKK_MODIFIER_TYPE_NONE);
						result = _tmp68_;
						_g_free0 (name);
						_skk_nicola_key_event_filter_timed_entry_unref0 (a);
						_skk_nicola_key_event_filter_timed_entry_unref0 (b);
						return result;
					} else {
						GeeLinkedList* _tmp69_;
						GeeLinkedList* _tmp70_;
						SkkNicolaKeyEventFilterTimedEntry* _tmp71_;
						SkkKeyEvent* r = NULL;
						SkkKeyEvent* _tmp72_;
						SkkNicolaKeyEventFilterTimedEntry* _tmp73_;
						gconstpointer _tmp74_;
						_tmp69_ = self->priv->pending;
						gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp69_);
						_tmp70_ = self->priv->pending;
						_tmp71_ = b;
						gee_deque_offer_head ((GeeDeque*) _tmp70_, _tmp71_);
						_tmp72_ = skk_nicola_key_event_filter_dispatch_single (self, time);
						r = _tmp72_;
						_tmp73_ = a;
						_tmp74_ = _tmp73_->data;
						g_signal_emit_by_name ((SkkKeyEventFilter*) self, "forwarded", (SkkKeyEvent*) _tmp74_);
						result = r;
						_g_free0 (name);
						_skk_nicola_key_event_filter_timed_entry_unref0 (a);
						_skk_nicola_key_event_filter_timed_entry_unref0 (b);
						return result;
					}
					_g_free0 (name);
				} else {
					SkkNicolaKeyEventFilterTimedEntry* _tmp75_;
					_tmp75_ = a;
					if ((time - _tmp75_->time) > self->timeout) {
						GeeLinkedList* _tmp76_;
						SkkNicolaKeyEventFilterTimedEntry* _tmp77_;
						gconstpointer _tmp78_;
						_tmp76_ = self->priv->pending;
						gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp76_);
						_tmp77_ = b;
						_tmp78_ = _tmp77_->data;
						if (skk_nicola_key_event_filter_is_shift ((SkkKeyEvent*) _tmp78_)) {
							SkkNicolaKeyEventFilterTimedEntry* _tmp79_;
							gconstpointer _tmp80_;
							SkkNicolaKeyEventFilterTimedEntry* _tmp81_;
							gconstpointer _tmp82_;
							SkkNicolaKeyEventFilterTimedEntry* _tmp83_;
							gconstpointer _tmp84_;
							SkkKeyEvent* _tmp85_;
							_tmp79_ = b;
							_tmp80_ = _tmp79_->data;
							_tmp81_ = a;
							_tmp82_ = _tmp81_->data;
							skk_nicola_key_event_filter_apply_shift (self, (SkkKeyEvent*) _tmp80_, (SkkKeyEvent*) _tmp82_);
							_tmp83_ = a;
							_tmp84_ = _tmp83_->data;
							_tmp85_ = _g_object_ref0 ((SkkKeyEvent*) _tmp84_);
							result = _tmp85_;
							_skk_nicola_key_event_filter_timed_entry_unref0 (a);
							_skk_nicola_key_event_filter_timed_entry_unref0 (b);
							return result;
						} else {
							SkkNicolaKeyEventFilterTimedEntry* _tmp86_;
							gconstpointer _tmp87_;
							SkkNicolaKeyEventFilterTimedEntry* _tmp88_;
							gconstpointer _tmp89_;
							SkkNicolaKeyEventFilterTimedEntry* _tmp90_;
							gconstpointer _tmp91_;
							SkkKeyEvent* _tmp92_;
							_tmp86_ = a;
							_tmp87_ = _tmp86_->data;
							_tmp88_ = b;
							_tmp89_ = _tmp88_->data;
							skk_nicola_key_event_filter_apply_shift (self, (SkkKeyEvent*) _tmp87_, (SkkKeyEvent*) _tmp89_);
							_tmp90_ = b;
							_tmp91_ = _tmp90_->data;
							_tmp92_ = _g_object_ref0 ((SkkKeyEvent*) _tmp91_);
							result = _tmp92_;
							_skk_nicola_key_event_filter_timed_entry_unref0 (a);
							_skk_nicola_key_event_filter_timed_entry_unref0 (b);
							return result;
						}
					}
				}
			}
			_skk_nicola_key_event_filter_timed_entry_unref0 (a);
			_skk_nicola_key_event_filter_timed_entry_unref0 (b);
		} else {
			GeeLinkedList* _tmp93_;
			gint _tmp94_;
			gint _tmp95_;
			_tmp93_ = self->priv->pending;
			_tmp94_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp93_);
			_tmp95_ = _tmp94_;
			if (_tmp95_ == 1) {
				SkkKeyEvent* _tmp96_;
				_tmp96_ = skk_nicola_key_event_filter_dispatch_single (self, time);
				result = _tmp96_;
				return result;
			}
		}
	}
	result = NULL;
	return result;
}

static gboolean
skk_nicola_key_event_filter_timeout_func (SkkNicolaKeyEventFilter* self)
{
	gint64 time = 0LL;
	SkkGetTime _tmp0_;
	gpointer _tmp0__target;
	SkkKeyEvent* r = NULL;
	SkkKeyEvent* _tmp1_;
	SkkKeyEvent* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->get_time_func;
	_tmp0__target = self->get_time_func_target;
	time = _tmp0_ (_tmp0__target);
	_tmp1_ = skk_nicola_key_event_filter_dispatch (self, time);
	r = _tmp1_;
	_tmp2_ = r;
	if (_tmp2_ != NULL) {
		SkkKeyEvent* _tmp3_;
		_tmp3_ = r;
		g_signal_emit_by_name ((SkkKeyEventFilter*) self, "forwarded", _tmp3_);
	}
	result = FALSE;
	_g_object_unref0 (r);
	return result;
}

/**
         * {@inheritDoc}
         */
static gboolean
_skk_nicola_key_event_filter_timeout_func_gsource_func (gpointer self)
{
	gboolean result;
	result = skk_nicola_key_event_filter_timeout_func ((SkkNicolaKeyEventFilter*) self);
	return result;
}

static SkkKeyEvent*
skk_nicola_key_event_filter_real_filter_key_event (SkkKeyEventFilter* base,
                                                   SkkKeyEvent* key)
{
	SkkNicolaKeyEventFilter * self;
	SkkModifierType _tmp0_;
	SkkModifierType _tmp1_;
	SkkKeyEvent* output = NULL;
	gint64 time = 0LL;
	SkkModifierType _tmp2_;
	SkkModifierType _tmp3_;
	SkkKeyEvent* _tmp22_;
	SkkKeyEvent* result;
	self = (SkkNicolaKeyEventFilter*) base;
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = skk_key_event_get_modifiers (key);
	_tmp1_ = _tmp0_;
	skk_key_event_set_modifiers (key, _tmp1_ & (~SKK_MODIFIER_TYPE_SHIFT_MASK));
	output = NULL;
	_tmp2_ = skk_key_event_get_modifiers (key);
	_tmp3_ = _tmp2_;
	if ((_tmp3_ & SKK_MODIFIER_TYPE_USLEEP_MASK) != 0) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		SkkGetTime _tmp6_;
		gpointer _tmp6__target;
		_tmp4_ = skk_key_event_get_name (key);
		_tmp5_ = _tmp4_;
		g_usleep ((gulong) ((glong) atoi (_tmp5_)));
		_tmp6_ = self->get_time_func;
		_tmp6__target = self->get_time_func_target;
		time = _tmp6_ (_tmp6__target);
	} else {
		gboolean _tmp7_ = FALSE;
		SkkModifierType _tmp8_;
		SkkModifierType _tmp9_;
		_tmp8_ = skk_key_event_get_modifiers (key);
		_tmp9_ = _tmp8_;
		if ((_tmp9_ & (~SKK_MODIFIER_TYPE_RELEASE_MASK)) == 0) {
			gboolean _tmp10_ = FALSE;
			if (skk_nicola_key_event_filter_is_shift (key)) {
				_tmp10_ = TRUE;
			} else {
				gboolean _tmp11_ = FALSE;
				gunichar _tmp12_;
				gunichar _tmp13_;
				_tmp12_ = skk_key_event_get_code (key);
				_tmp13_ = _tmp12_;
				if (((gunichar) 0x20) <= _tmp13_) {
					gunichar _tmp14_;
					gunichar _tmp15_;
					_tmp14_ = skk_key_event_get_code (key);
					_tmp15_ = _tmp14_;
					_tmp11_ = _tmp15_ <= ((gunichar) 0x7E);
				} else {
					_tmp11_ = FALSE;
				}
				_tmp10_ = _tmp11_;
			}
			_tmp7_ = _tmp10_;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			SkkGetTime _tmp16_;
			gpointer _tmp16__target;
			gint64 wait = 0LL;
			gint64 _tmp17_ = 0LL;
			SkkKeyEvent* _tmp18_;
			_tmp16_ = self->get_time_func;
			_tmp16__target = self->get_time_func_target;
			time = _tmp16_ (_tmp16__target);
			_tmp18_ = skk_nicola_key_event_filter_queue (self, key, time, &_tmp17_);
			wait = _tmp17_;
			_g_object_unref0 (output);
			output = _tmp18_;
			if (wait > ((gint64) 0)) {
				if (self->priv->timeout_id > ((guint) 0)) {
					g_source_remove (self->priv->timeout_id);
				}
				self->priv->timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) wait, _skk_nicola_key_event_filter_timeout_func_gsource_func, g_object_ref (self), g_object_unref);
			}
		} else {
			SkkModifierType _tmp19_;
			SkkModifierType _tmp20_;
			_tmp19_ = skk_key_event_get_modifiers (key);
			_tmp20_ = _tmp19_;
			if ((_tmp20_ & SKK_MODIFIER_TYPE_RELEASE_MASK) == 0) {
				SkkKeyEvent* _tmp21_;
				_tmp21_ = _g_object_ref0 (key);
				result = _tmp21_;
				_g_object_unref0 (output);
				return result;
			}
			result = NULL;
			_g_object_unref0 (output);
			return result;
		}
	}
	_tmp22_ = output;
	if (_tmp22_ == NULL) {
		SkkKeyEvent* _tmp23_;
		_tmp23_ = skk_nicola_key_event_filter_dispatch (self, time);
		_g_object_unref0 (output);
		output = _tmp23_;
	}
	result = output;
	return result;
}

/**
         * {@inheritDoc}
         */
static void
skk_nicola_key_event_filter_real_reset (SkkKeyEventFilter* base)
{
	SkkNicolaKeyEventFilter * self;
	GeeLinkedList* _tmp0_;
	self = (SkkNicolaKeyEventFilter*) base;
	_tmp0_ = self->priv->pending;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
}

SkkNicolaKeyEventFilter*
skk_nicola_key_event_filter_construct (GType object_type)
{
	SkkNicolaKeyEventFilter * self = NULL;
	self = (SkkNicolaKeyEventFilter*) skk_key_event_filter_construct (object_type);
	return self;
}

SkkNicolaKeyEventFilter*
skk_nicola_key_event_filter_new (void)
{
	return skk_nicola_key_event_filter_construct (SKK_TYPE_NICOLA_KEY_EVENT_FILTER);
}

static inline gpointer
skk_nicola_key_event_filter_timed_entry_get_instance_private (SkkNicolaKeyEventFilterTimedEntry* self)
{
	return G_STRUCT_MEMBER_P (self, SkkNicolaKeyEventFilterTimedEntry_private_offset);
}

static SkkNicolaKeyEventFilterTimedEntry*
skk_nicola_key_event_filter_timed_entry_construct (GType object_type,
                                                   GType t_type,
                                                   GBoxedCopyFunc t_dup_func,
                                                   GDestroyNotify t_destroy_func,
                                                   gconstpointer data,
                                                   gint64 time)
{
	SkkNicolaKeyEventFilterTimedEntry* self = NULL;
	gpointer _tmp0_;
	self = (SkkNicolaKeyEventFilterTimedEntry*) g_type_create_instance (object_type);
	self->priv->t_type = t_type;
	self->priv->t_dup_func = t_dup_func;
	self->priv->t_destroy_func = t_destroy_func;
	_tmp0_ = ((data != NULL) && (t_dup_func != NULL)) ? t_dup_func ((gpointer) data) : ((gpointer) data);
	((self->data == NULL) || (t_destroy_func == NULL)) ? NULL : (self->data = (t_destroy_func (self->data), NULL));
	self->data = _tmp0_;
	self->time = time;
	return self;
}

static SkkNicolaKeyEventFilterTimedEntry*
skk_nicola_key_event_filter_timed_entry_new (GType t_type,
                                             GBoxedCopyFunc t_dup_func,
                                             GDestroyNotify t_destroy_func,
                                             gconstpointer data,
                                             gint64 time)
{
	return skk_nicola_key_event_filter_timed_entry_construct (SKK_NICOLA_KEY_EVENT_FILTER_TYPE_TIMED_ENTRY, t_type, t_dup_func, t_destroy_func, data, time);
}

static void
skk_nicola_key_event_filter_value_timed_entry_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
skk_nicola_key_event_filter_value_timed_entry_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		skk_nicola_key_event_filter_timed_entry_unref (value->data[0].v_pointer);
	}
}

static void
skk_nicola_key_event_filter_value_timed_entry_copy_value (const GValue* src_value,
                                                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = skk_nicola_key_event_filter_timed_entry_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
skk_nicola_key_event_filter_value_timed_entry_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
skk_nicola_key_event_filter_value_timed_entry_collect_value (GValue* value,
                                                             guint n_collect_values,
                                                             GTypeCValue* collect_values,
                                                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		SkkNicolaKeyEventFilterTimedEntry * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = skk_nicola_key_event_filter_timed_entry_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
skk_nicola_key_event_filter_value_timed_entry_lcopy_value (const GValue* value,
                                                           guint n_collect_values,
                                                           GTypeCValue* collect_values,
                                                           guint collect_flags)
{
	SkkNicolaKeyEventFilterTimedEntry ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = skk_nicola_key_event_filter_timed_entry_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
skk_nicola_key_event_filter_param_spec_timed_entry (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags)
{
	SkkNicolaKeyEventFilterParamSpecTimedEntry* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SKK_NICOLA_KEY_EVENT_FILTER_TYPE_TIMED_ENTRY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
skk_nicola_key_event_filter_value_get_timed_entry (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SKK_NICOLA_KEY_EVENT_FILTER_TYPE_TIMED_ENTRY), NULL);
	return value->data[0].v_pointer;
}

static void
skk_nicola_key_event_filter_value_set_timed_entry (GValue* value,
                                                   gpointer v_object)
{
	SkkNicolaKeyEventFilterTimedEntry * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SKK_NICOLA_KEY_EVENT_FILTER_TYPE_TIMED_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SKK_NICOLA_KEY_EVENT_FILTER_TYPE_TIMED_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		skk_nicola_key_event_filter_timed_entry_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		skk_nicola_key_event_filter_timed_entry_unref (old);
	}
}

static void
skk_nicola_key_event_filter_value_take_timed_entry (GValue* value,
                                                    gpointer v_object)
{
	SkkNicolaKeyEventFilterTimedEntry * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SKK_NICOLA_KEY_EVENT_FILTER_TYPE_TIMED_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SKK_NICOLA_KEY_EVENT_FILTER_TYPE_TIMED_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		skk_nicola_key_event_filter_timed_entry_unref (old);
	}
}

static void
skk_nicola_key_event_filter_timed_entry_class_init (SkkNicolaKeyEventFilterTimedEntryClass * klass,
                                                    gpointer klass_data)
{
	skk_nicola_key_event_filter_timed_entry_parent_class = g_type_class_peek_parent (klass);
	((SkkNicolaKeyEventFilterTimedEntryClass *) klass)->finalize = skk_nicola_key_event_filter_timed_entry_finalize;
	g_type_class_adjust_private_offset (klass, &SkkNicolaKeyEventFilterTimedEntry_private_offset);
}

static void
skk_nicola_key_event_filter_timed_entry_instance_init (SkkNicolaKeyEventFilterTimedEntry * self,
                                                       gpointer klass)
{
	self->priv = skk_nicola_key_event_filter_timed_entry_get_instance_private (self);
	self->ref_count = 1;
}

static void
skk_nicola_key_event_filter_timed_entry_finalize (SkkNicolaKeyEventFilterTimedEntry * obj)
{
	SkkNicolaKeyEventFilterTimedEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_NICOLA_KEY_EVENT_FILTER_TYPE_TIMED_ENTRY, SkkNicolaKeyEventFilterTimedEntry);
	g_signal_handlers_destroy (self);
	((self->data == NULL) || (self->priv->t_destroy_func == NULL)) ? NULL : (self->data = (self->priv->t_destroy_func (self->data), NULL));
}

static GType
skk_nicola_key_event_filter_timed_entry_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { skk_nicola_key_event_filter_value_timed_entry_init, skk_nicola_key_event_filter_value_timed_entry_free_value, skk_nicola_key_event_filter_value_timed_entry_copy_value, skk_nicola_key_event_filter_value_timed_entry_peek_pointer, "p", skk_nicola_key_event_filter_value_timed_entry_collect_value, "p", skk_nicola_key_event_filter_value_timed_entry_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SkkNicolaKeyEventFilterTimedEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_nicola_key_event_filter_timed_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkNicolaKeyEventFilterTimedEntry), 0, (GInstanceInitFunc) skk_nicola_key_event_filter_timed_entry_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType skk_nicola_key_event_filter_timed_entry_type_id;
	skk_nicola_key_event_filter_timed_entry_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SkkNicolaKeyEventFilterTimedEntry", &g_define_type_info, &g_define_type_fundamental_info, 0);
	SkkNicolaKeyEventFilterTimedEntry_private_offset = g_type_add_instance_private (skk_nicola_key_event_filter_timed_entry_type_id, sizeof (SkkNicolaKeyEventFilterTimedEntryPrivate));
	return skk_nicola_key_event_filter_timed_entry_type_id;
}

static GType
skk_nicola_key_event_filter_timed_entry_get_type (void)
{
	static volatile gsize skk_nicola_key_event_filter_timed_entry_type_id__once = 0;
	if (g_once_init_enter (&skk_nicola_key_event_filter_timed_entry_type_id__once)) {
		GType skk_nicola_key_event_filter_timed_entry_type_id;
		skk_nicola_key_event_filter_timed_entry_type_id = skk_nicola_key_event_filter_timed_entry_get_type_once ();
		g_once_init_leave (&skk_nicola_key_event_filter_timed_entry_type_id__once, skk_nicola_key_event_filter_timed_entry_type_id);
	}
	return skk_nicola_key_event_filter_timed_entry_type_id__once;
}

static gpointer
skk_nicola_key_event_filter_timed_entry_ref (gpointer instance)
{
	SkkNicolaKeyEventFilterTimedEntry * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
skk_nicola_key_event_filter_timed_entry_unref (gpointer instance)
{
	SkkNicolaKeyEventFilterTimedEntry * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SKK_NICOLA_KEY_EVENT_FILTER_TIMED_ENTRY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static gchar**
_vala_array_dup6 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static GObject *
skk_nicola_key_event_filter_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SkkNicolaKeyEventFilter * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	parent_class = G_OBJECT_CLASS (skk_nicola_key_event_filter_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_TYPE_NICOLA_KEY_EVENT_FILTER, SkkNicolaKeyEventFilter);
	_tmp0_ = _vala_array_dup6 (SKK_NICOLA_KEY_EVENT_FILTER_SPECIAL_DOUBLES, G_N_ELEMENTS (SKK_NICOLA_KEY_EVENT_FILTER_SPECIAL_DOUBLES));
	_tmp0__length1 = G_N_ELEMENTS (SKK_NICOLA_KEY_EVENT_FILTER_SPECIAL_DOUBLES);
	self->special_doubles = (_vala_array_free (self->special_doubles, self->special_doubles_length1, (GDestroyNotify) g_free), NULL);
	self->special_doubles = _tmp0_;
	self->special_doubles_length1 = _tmp0__length1;
	return obj;
}

static void
skk_nicola_key_event_filter_class_init (SkkNicolaKeyEventFilterClass * klass,
                                        gpointer klass_data)
{
	skk_nicola_key_event_filter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SkkNicolaKeyEventFilter_private_offset);
	((SkkKeyEventFilterClass *) klass)->filter_key_event = (SkkKeyEvent* (*) (SkkKeyEventFilter*, SkkKeyEvent*)) skk_nicola_key_event_filter_real_filter_key_event;
	((SkkKeyEventFilterClass *) klass)->reset = (void (*) (SkkKeyEventFilter*)) skk_nicola_key_event_filter_real_reset;
	G_OBJECT_CLASS (klass)->constructor = skk_nicola_key_event_filter_constructor;
	G_OBJECT_CLASS (klass)->finalize = skk_nicola_key_event_filter_finalize;
}

static void
skk_nicola_key_event_filter_instance_init (SkkNicolaKeyEventFilter * self,
                                           gpointer klass)
{
	GeeLinkedList* _tmp0_;
	self->priv = skk_nicola_key_event_filter_get_instance_private (self);
	self->get_time_func = _skk_nicola_key_event_filter_get_time_skk_get_time;
	self->get_time_func_target = NULL;
	self->get_time_func_target_destroy_notify = NULL;
	self->timeout = (gint64) 100000;
	self->overlap = (gint64) 50000;
	self->maxwait = (gint64) 10000000;
	_tmp0_ = gee_linked_list_new (SKK_NICOLA_KEY_EVENT_FILTER_TYPE_TIMED_ENTRY, (GBoxedCopyFunc) skk_nicola_key_event_filter_timed_entry_ref, (GDestroyNotify) skk_nicola_key_event_filter_timed_entry_unref, NULL, NULL, NULL);
	self->priv->pending = _tmp0_;
	self->priv->timeout_id = (guint) 0;
}

static void
skk_nicola_key_event_filter_finalize (GObject * obj)
{
	SkkNicolaKeyEventFilter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_TYPE_NICOLA_KEY_EVENT_FILTER, SkkNicolaKeyEventFilter);
	(self->get_time_func_target_destroy_notify == NULL) ? NULL : (self->get_time_func_target_destroy_notify (self->get_time_func_target), NULL);
	self->get_time_func = NULL;
	self->get_time_func_target = NULL;
	self->get_time_func_target_destroy_notify = NULL;
	self->special_doubles = (_vala_array_free (self->special_doubles, self->special_doubles_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->pending);
	G_OBJECT_CLASS (skk_nicola_key_event_filter_parent_class)->finalize (obj);
}

/**
     * Key event filter implementing NICOLA (thumb shift) input
     *
     * This class is rarely used in programs but specified as "filter"
     * property in rule metadata.
     *
     * @see Rule
     */
static GType
skk_nicola_key_event_filter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkNicolaKeyEventFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_nicola_key_event_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkNicolaKeyEventFilter), 0, (GInstanceInitFunc) skk_nicola_key_event_filter_instance_init, NULL };
	GType skk_nicola_key_event_filter_type_id;
	skk_nicola_key_event_filter_type_id = g_type_register_static (SKK_TYPE_KEY_EVENT_FILTER, "SkkNicolaKeyEventFilter", &g_define_type_info, 0);
	SkkNicolaKeyEventFilter_private_offset = g_type_add_instance_private (skk_nicola_key_event_filter_type_id, sizeof (SkkNicolaKeyEventFilterPrivate));
	return skk_nicola_key_event_filter_type_id;
}

GType
skk_nicola_key_event_filter_get_type (void)
{
	static volatile gsize skk_nicola_key_event_filter_type_id__once = 0;
	if (g_once_init_enter (&skk_nicola_key_event_filter_type_id__once)) {
		GType skk_nicola_key_event_filter_type_id;
		skk_nicola_key_event_filter_type_id = skk_nicola_key_event_filter_get_type_once ();
		g_once_init_leave (&skk_nicola_key_event_filter_type_id__once, skk_nicola_key_event_filter_type_id);
	}
	return skk_nicola_key_event_filter_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

