/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the AMDGPU target                          *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 116;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(AMDGPUInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(AMDGPUInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static AMDGPUInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static AMDGPUInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(6),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_p0s64,
  GILLT_p1s64,
  GILLT_p2s32,
  GILLT_p3s32,
  GILLT_p4s64,
  GILLT_p5s32,
  GILLT_p6s32,
  GILLT_s1,
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_v2s16,
  GILLT_v2s32,
  GILLT_v2s64,
  GILLT_v3s32,
  GILLT_v3s64,
  GILLT_v4s16,
  GILLT_v4s32,
  GILLT_v4s64,
  GILLT_v5s32,
  GILLT_v6s32,
  GILLT_v7s32,
  GILLT_v8s16,
  GILLT_v8s32,
  GILLT_v8s64,
  GILLT_v9s32,
  GILLT_v10s32,
  GILLT_v11s32,
  GILLT_v12s32,
  GILLT_v16s16,
  GILLT_v16s32,
  GILLT_v16s64,
  GILLT_v32s16,
  GILLT_v32s32,
};
const static size_t NumTypeObjects = 34;
const static LLT TypeObjects[] = {
  LLT::pointer(0, 64),
  LLT::pointer(1, 64),
  LLT::pointer(2, 32),
  LLT::pointer(3, 32),
  LLT::pointer(4, 64),
  LLT::pointer(5, 32),
  LLT::pointer(6, 32),
  LLT::scalar(1),
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(ElementCount::getFixed(2), 16),
  LLT::vector(ElementCount::getFixed(2), 32),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(3), 32),
  LLT::vector(ElementCount::getFixed(3), 64),
  LLT::vector(ElementCount::getFixed(4), 16),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(4), 64),
  LLT::vector(ElementCount::getFixed(5), 32),
  LLT::vector(ElementCount::getFixed(6), 32),
  LLT::vector(ElementCount::getFixed(7), 32),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(8), 32),
  LLT::vector(ElementCount::getFixed(8), 64),
  LLT::vector(ElementCount::getFixed(9), 32),
  LLT::vector(ElementCount::getFixed(10), 32),
  LLT::vector(ElementCount::getFixed(11), 32),
  LLT::vector(ElementCount::getFixed(12), 32),
  LLT::vector(ElementCount::getFixed(16), 16),
  LLT::vector(ElementCount::getFixed(16), 32),
  LLT::vector(ElementCount::getFixed(16), 64),
  LLT::vector(ElementCount::getFixed(32), 16),
  LLT::vector(ElementCount::getFixed(32), 32),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_FalsePredicateBit = 101,
  Feature_isGFX6Bit = 41,
  Feature_isGFX6GFX7Bit = 8,
  Feature_isGFX6GFX7GFX10Bit = 99,
  Feature_isGFX7OnlyBit = 72,
  Feature_isGFX7GFX8GFX9Bit = 36,
  Feature_isGFX6GFX7GFX8GFX9Bit = 57,
  Feature_isGFX6GFX7GFX8GFX9GFX10Bit = 112,
  Feature_isNotGFX12PlusBit = 19,
  Feature_isGFX8GFX9GFX10GFX11Bit = 20,
  Feature_isGFX7PlusBit = 12,
  Feature_isGFX8PlusBit = 4,
  Feature_isGFX8OnlyBit = 21,
  Feature_isGFX9PlusBit = 0,
  Feature_isNotGFX9PlusBit = 47,
  Feature_isGFX9OnlyBit = 50,
  Feature_isGFX90APlusBit = 32,
  Feature_isNotGFX90APlusBit = 22,
  Feature_isGFX908orGFX90ABit = 31,
  Feature_isGFX940PlusBit = 33,
  Feature_isGFX8GFX9Bit = 15,
  Feature_isGFX10OnlyBit = 53,
  Feature_isGFX10PlusBit = 5,
  Feature_isGFX9GFX10Bit = 48,
  Feature_isGFX11OnlyBit = 54,
  Feature_isGFX11PlusBit = 1,
  Feature_isGFX12OnlyBit = 55,
  Feature_isGFX12PlusBit = 3,
  Feature_HasFlatAddressSpaceBit = 74,
  Feature_HasFlatBufferGlobalAtomicFaddF64InstBit = 90,
  Feature_HasAtomicFMinFMaxF32GlobalInstsBit = 84,
  Feature_HasAtomicFMinFMaxF64GlobalInstsBit = 89,
  Feature_HasAtomicFMinFMaxF32FlatInstsBit = 80,
  Feature_HasAtomicFMinFMaxF64FlatInstsBit = 81,
  Feature_HasLdsAtomicAddF64Bit = 115,
  Feature_HasFlatGlobalInstsBit = 75,
  Feature_HasFlatScratchInstsBit = 78,
  Feature_HasD16LoadStoreBit = 83,
  Feature_HasFlatScratchSVSModeBit = 79,
  Feature_HasGFX10_BEncodingBit = 40,
  Feature_HasUnpackedD16VMemBit = 95,
  Feature_HasPackedD16VMemBit = 96,
  Feature_HasUnrestrictedSOffsetBit = 94,
  Feature_D16PreservesUnusedBitsBit = 76,
  Feature_LDSRequiresM0InitBit = 108,
  Feature_NotLDSRequiresM0InitBit = 109,
  Feature_HasExportInstsBit = 7,
  Feature_HasLDSFPAtomicAddF32Bit = 114,
  Feature_HasAddNoCarryInstsBit = 56,
  Feature_NotHasAddNoCarryInstsBit = 106,
  Feature_HasXNACKEnabledBit = 71,
  Feature_Has16BitInstsBit = 9,
  Feature_HasTrue16BitInstsBit = 11,
  Feature_NotHasTrue16BitInstsBit = 10,
  Feature_UseRealTrue16InstsBit = 13,
  Feature_UseFakeTrue16InstsBit = 14,
  Feature_HasVOP3PInstsBit = 65,
  Feature_HasMed3_16Bit = 107,
  Feature_HasMinMaxDenormModesBit = 100,
  Feature_NotHasMinMaxDenormModesBit = 102,
  Feature_HasPackedFP32OpsBit = 34,
  Feature_HasImageInstsBit = 6,
  Feature_HasIntClampBit = 62,
  Feature_HasMadMixInstsBit = 66,
  Feature_HasScalarStoresBit = 37,
  Feature_has16BankLDSBit = 42,
  Feature_has32BankLDSBit = 23,
  Feature_HasFmaMixInstsBit = 68,
  Feature_HasDLInstsBit = 16,
  Feature_HasFmacF64InstBit = 105,
  Feature_HasDot1InstsBit = 29,
  Feature_HasDot2InstsBit = 26,
  Feature_HasDot3InstsBit = 61,
  Feature_HasDot4InstsBit = 60,
  Feature_HasDot5InstsBit = 58,
  Feature_HasDot6InstsBit = 59,
  Feature_HasDot7InstsBit = 28,
  Feature_HasDot8InstsBit = 69,
  Feature_HasDot9InstsBit = 24,
  Feature_HasDot10InstsBit = 27,
  Feature_HasDot11InstsBit = 70,
  Feature_HasGetWaveIdInstBit = 39,
  Feature_HasMAIInstsBit = 30,
  Feature_HasSMemRealTimeBit = 38,
  Feature_HasSMemTimeInstBit = 35,
  Feature_HasShaderCyclesRegisterBit = 73,
  Feature_HasShaderCyclesHiLoRegistersBit = 45,
  Feature_HasFP8ConversionInstsBit = 52,
  Feature_HasMadMacF32InstsBit = 17,
  Feature_HasFmaLegacy32Bit = 18,
  Feature_HasAtomicDsPkAdd16InstsBit = 113,
  Feature_HasAtomicFlatPkAdd16InstsBit = 92,
  Feature_HasAtomicFaddRtnInstsBit = 87,
  Feature_HasAtomicFaddNoRtnInstsBit = 85,
  Feature_HasAtomicBufferGlobalPkAddF16NoRtnInstsBit = 86,
  Feature_HasAtomicBufferGlobalPkAddF16InstsBit = 88,
  Feature_HasAtomicGlobalPkAddBF16InstBit = 93,
  Feature_HasAtomicBufferPkAddBF16InstBit = 97,
  Feature_HasFlatAtomicFaddF32InstBit = 91,
  Feature_EnableLateCFGStructurizeBit = 46,
  Feature_EnableFlatScratchBit = 77,
  Feature_DisableFlatScratchBit = 98,
  Feature_HasUnalignedAccessModeBit = 110,
  Feature_HasMADIntraFwdBugBit = 64,
  Feature_HasNotMADIntraFwdBugBit = 63,
  Feature_HasSALUFloatInstsBit = 2,
  Feature_HasPseudoScalarTransBit = 25,
  Feature_HasGDSBit = 111,
  Feature_HasCvtFP8VOP1BugBit = 49,
  Feature_HasNoCvtFP8VOP1BugBit = 51,
  Feature_HasAtomicCSubNoRtnInstsBit = 82,
  Feature_FP16DenormalsBit = 104,
  Feature_FP64DenormalsBit = 103,
  Feature_NoFP32DenormalsBit = 67,
  Feature_isWave32Bit = 43,
  Feature_isWave64Bit = 44,
};

PredicateBitset AMDGPUInstructionSelector::
computeAvailableModuleFeatures(const AMDGPUSubtarget *Subtarget) const {
  PredicateBitset Features{};
  if (false)
    Features.set(Feature_FalsePredicateBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS)
    Features.set(Feature_isGFX6Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
    Features.set(Feature_isGFX6GFX7Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX6GFX7GFX10Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
    Features.set(Feature_isGFX7OnlyBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX7GFX8GFX9Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX6GFX7GFX8GFX9Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX6GFX7GFX8GFX9GFX10Bit);
  if (Subtarget->getGeneration() <= AMDGPUSubtarget::GFX11)
    Features.set(Feature_isNotGFX12PlusBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX11)
    Features.set(Feature_isGFX8GFX9GFX10GFX11Bit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::SEA_ISLANDS)
    Features.set(Feature_isGFX7PlusBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
    Features.set(Feature_isGFX8PlusBit);
  if (Subtarget->getGeneration() ==AMDGPUSubtarget::VOLCANIC_ISLANDS)
    Features.set(Feature_isGFX8OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX9PlusBit);
  if (Subtarget->getGeneration() < AMDGPUSubtarget::GFX9)
    Features.set(Feature_isNotGFX9PlusBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX9OnlyBit);
  if (Subtarget->hasGFX90AInsts())
    Features.set(Feature_isGFX90APlusBit);
  if (!Subtarget->hasGFX90AInsts())
    Features.set(Feature_isNotGFX90APlusBit);
  if (Subtarget->hasMAIInsts() && !Subtarget->hasGFX940Insts())
    Features.set(Feature_isGFX908orGFX90ABit);
  if (Subtarget->hasGFX940Insts())
    Features.set(Feature_isGFX940PlusBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX8GFX9Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX10OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX10PlusBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX9 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX9GFX10Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX11)
    Features.set(Feature_isGFX11OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX11)
    Features.set(Feature_isGFX11PlusBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX12)
    Features.set(Feature_isGFX12OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX12)
    Features.set(Feature_isGFX12PlusBit);
  if (Subtarget->hasFlatAddressSpace())
    Features.set(Feature_HasFlatAddressSpaceBit);
  if (Subtarget->hasFlatBufferGlobalAtomicFaddF64Inst())
    Features.set(Feature_HasFlatBufferGlobalAtomicFaddF64InstBit);
  if (Subtarget->hasAtomicFMinFMaxF32GlobalInsts())
    Features.set(Feature_HasAtomicFMinFMaxF32GlobalInstsBit);
  if (Subtarget->hasAtomicFMinFMaxF64GlobalInsts())
    Features.set(Feature_HasAtomicFMinFMaxF64GlobalInstsBit);
  if (Subtarget->hasAtomicFMinFMaxF32FlatInsts())
    Features.set(Feature_HasAtomicFMinFMaxF32FlatInstsBit);
  if (Subtarget->hasAtomicFMinFMaxF64FlatInsts())
    Features.set(Feature_HasAtomicFMinFMaxF64FlatInstsBit);
  if (Subtarget->hasLdsAtomicAddF64())
    Features.set(Feature_HasLdsAtomicAddF64Bit);
  if (Subtarget->hasFlatGlobalInsts())
    Features.set(Feature_HasFlatGlobalInstsBit);
  if (Subtarget->hasFlatScratchInsts())
    Features.set(Feature_HasFlatScratchInstsBit);
  if (Subtarget->hasD16LoadStore())
    Features.set(Feature_HasD16LoadStoreBit);
  if (Subtarget->hasFlatScratchSVSMode())
    Features.set(Feature_HasFlatScratchSVSModeBit);
  if (Subtarget->hasGFX10_BEncoding())
    Features.set(Feature_HasGFX10_BEncodingBit);
  if (Subtarget->hasUnpackedD16VMem())
    Features.set(Feature_HasUnpackedD16VMemBit);
  if (!Subtarget->hasUnpackedD16VMem())
    Features.set(Feature_HasPackedD16VMemBit);
  if (!Subtarget->hasRestrictedSOffset())
    Features.set(Feature_HasUnrestrictedSOffsetBit);
  if (Subtarget->d16PreservesUnusedBits())
    Features.set(Feature_D16PreservesUnusedBitsBit);
  if (Subtarget->ldsRequiresM0Init())
    Features.set(Feature_LDSRequiresM0InitBit);
  if (!Subtarget->ldsRequiresM0Init())
    Features.set(Feature_NotLDSRequiresM0InitBit);
  if (Subtarget->hasExportInsts())
    Features.set(Feature_HasExportInstsBit);
  if (Subtarget->hasLDSFPAtomicAddF32())
    Features.set(Feature_HasLDSFPAtomicAddF32Bit);
  if (Subtarget->hasAddNoCarry())
    Features.set(Feature_HasAddNoCarryInstsBit);
  if (!Subtarget->hasAddNoCarry())
    Features.set(Feature_NotHasAddNoCarryInstsBit);
  if (Subtarget->isXNACKEnabled())
    Features.set(Feature_HasXNACKEnabledBit);
  if (Subtarget->has16BitInsts())
    Features.set(Feature_Has16BitInstsBit);
  if (Subtarget->hasTrue16BitInsts())
    Features.set(Feature_HasTrue16BitInstsBit);
  if (!Subtarget->hasTrue16BitInsts())
    Features.set(Feature_NotHasTrue16BitInstsBit);
  if (Subtarget->useRealTrue16Insts())
    Features.set(Feature_UseRealTrue16InstsBit);
  if (Subtarget->hasTrue16BitInsts() && !Subtarget->useRealTrue16Insts())
    Features.set(Feature_UseFakeTrue16InstsBit);
  if (Subtarget->hasVOP3PInsts())
    Features.set(Feature_HasVOP3PInstsBit);
  if (Subtarget->hasMed3_16())
    Features.set(Feature_HasMed3_16Bit);
  if (Subtarget->supportsMinMaxDenormModes())
    Features.set(Feature_HasMinMaxDenormModesBit);
  if (!Subtarget->supportsMinMaxDenormModes())
    Features.set(Feature_NotHasMinMaxDenormModesBit);
  if (Subtarget->hasPackedFP32Ops())
    Features.set(Feature_HasPackedFP32OpsBit);
  if (Subtarget->hasImageInsts())
    Features.set(Feature_HasImageInstsBit);
  if (Subtarget->hasIntClamp())
    Features.set(Feature_HasIntClampBit);
  if (Subtarget->hasMadMixInsts())
    Features.set(Feature_HasMadMixInstsBit);
  if (Subtarget->hasScalarStores())
    Features.set(Feature_HasScalarStoresBit);
  if (Subtarget->getLDSBankCount() == 16)
    Features.set(Feature_has16BankLDSBit);
  if (Subtarget->getLDSBankCount() == 32)
    Features.set(Feature_has32BankLDSBit);
  if (Subtarget->hasFmaMixInsts())
    Features.set(Feature_HasFmaMixInstsBit);
  if (Subtarget->hasDLInsts())
    Features.set(Feature_HasDLInstsBit);
  if (Subtarget->hasFmacF64Inst())
    Features.set(Feature_HasFmacF64InstBit);
  if (Subtarget->hasDot1Insts())
    Features.set(Feature_HasDot1InstsBit);
  if (Subtarget->hasDot2Insts())
    Features.set(Feature_HasDot2InstsBit);
  if (Subtarget->hasDot3Insts())
    Features.set(Feature_HasDot3InstsBit);
  if (Subtarget->hasDot4Insts())
    Features.set(Feature_HasDot4InstsBit);
  if (Subtarget->hasDot5Insts())
    Features.set(Feature_HasDot5InstsBit);
  if (Subtarget->hasDot6Insts())
    Features.set(Feature_HasDot6InstsBit);
  if (Subtarget->hasDot7Insts())
    Features.set(Feature_HasDot7InstsBit);
  if (Subtarget->hasDot8Insts())
    Features.set(Feature_HasDot8InstsBit);
  if (Subtarget->hasDot9Insts())
    Features.set(Feature_HasDot9InstsBit);
  if (Subtarget->hasDot10Insts())
    Features.set(Feature_HasDot10InstsBit);
  if (Subtarget->hasDot11Insts())
    Features.set(Feature_HasDot11InstsBit);
  if (Subtarget->hasGetWaveIdInst())
    Features.set(Feature_HasGetWaveIdInstBit);
  if (Subtarget->hasMAIInsts())
    Features.set(Feature_HasMAIInstsBit);
  if (Subtarget->hasSMemRealTime())
    Features.set(Feature_HasSMemRealTimeBit);
  if (Subtarget->hasSMemTimeInst())
    Features.set(Feature_HasSMemTimeInstBit);
  if (Subtarget->hasShaderCyclesRegister())
    Features.set(Feature_HasShaderCyclesRegisterBit);
  if (Subtarget->hasShaderCyclesHiLoRegisters())
    Features.set(Feature_HasShaderCyclesHiLoRegistersBit);
  if (Subtarget->hasFP8ConversionInsts())
    Features.set(Feature_HasFP8ConversionInstsBit);
  if (Subtarget->hasMadMacF32Insts())
    Features.set(Feature_HasMadMacF32InstsBit);
  if (Subtarget->hasGFX10_3Insts())
    Features.set(Feature_HasFmaLegacy32Bit);
  if (Subtarget->hasAtomicDsPkAdd16Insts())
    Features.set(Feature_HasAtomicDsPkAdd16InstsBit);
  if (Subtarget->hasAtomicFlatPkAdd16Insts())
    Features.set(Feature_HasAtomicFlatPkAdd16InstsBit);
  if (Subtarget->hasAtomicFaddRtnInsts())
    Features.set(Feature_HasAtomicFaddRtnInstsBit);
  if (Subtarget->hasAtomicFaddNoRtnInsts())
    Features.set(Feature_HasAtomicFaddNoRtnInstsBit);
  if (Subtarget->hasAtomicBufferGlobalPkAddF16NoRtnInsts() || Subtarget->hasAtomicBufferGlobalPkAddF16Insts())
    Features.set(Feature_HasAtomicBufferGlobalPkAddF16NoRtnInstsBit);
  if (Subtarget->hasAtomicBufferGlobalPkAddF16Insts())
    Features.set(Feature_HasAtomicBufferGlobalPkAddF16InstsBit);
  if (Subtarget->hasAtomicGlobalPkAddBF16Inst())
    Features.set(Feature_HasAtomicGlobalPkAddBF16InstBit);
  if (Subtarget->hasAtomicBufferPkAddBF16Inst())
    Features.set(Feature_HasAtomicBufferPkAddBF16InstBit);
  if (Subtarget->hasFlatAtomicFaddF32Inst())
    Features.set(Feature_HasFlatAtomicFaddF32InstBit);
  if (EnableLateStructurizeCFG)
    Features.set(Feature_EnableLateCFGStructurizeBit);
  if (Subtarget->enableFlatScratch())
    Features.set(Feature_EnableFlatScratchBit);
  if (!Subtarget->enableFlatScratch())
    Features.set(Feature_DisableFlatScratchBit);
  if (Subtarget->hasUnalignedAccessMode())
    Features.set(Feature_HasUnalignedAccessModeBit);
  if (Subtarget->hasMADIntraFwdBug())
    Features.set(Feature_HasMADIntraFwdBugBit);
  if (!Subtarget->hasMADIntraFwdBug())
    Features.set(Feature_HasNotMADIntraFwdBugBit);
  if (Subtarget->hasSALUFloatInsts())
    Features.set(Feature_HasSALUFloatInstsBit);
  if (Subtarget->hasPseudoScalarTrans())
    Features.set(Feature_HasPseudoScalarTransBit);
  if (Subtarget->hasGDS())
    Features.set(Feature_HasGDSBit);
  if (Subtarget->hasCvtFP8VOP1Bug())
    Features.set(Feature_HasCvtFP8VOP1BugBit);
  if (!Subtarget->hasCvtFP8VOP1Bug())
    Features.set(Feature_HasNoCvtFP8VOP1BugBit);
  if (Subtarget->hasAtomicCSubNoRtnInsts())
    Features.set(Feature_HasAtomicCSubNoRtnInstsBit);
  if (Subtarget->getWavefrontSize() == 32)
    Features.set(Feature_isWave32Bit);
  if (Subtarget->getWavefrontSize() == 64)
    Features.set(Feature_isWave64Bit);
  return Features;
}

void AMDGPUInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const AMDGPUSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset AMDGPUInstructionSelector::
computeAvailableFunctionFeatures(const AMDGPUSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  if (MF->getInfo<SIMachineFunctionInfo>()->getMode().FP64FP16Denormals != DenormalMode::getPreserveSign())
    Features.set(Feature_FP16DenormalsBit);
  if (MF->getInfo<SIMachineFunctionInfo>()->getMode().FP64FP16Denormals != DenormalMode::getPreserveSign())
    Features.set(Feature_FP64DenormalsBit);
  if (MF->getInfo<SIMachineFunctionInfo>()->getMode().FP32Denormals == DenormalMode::getPreserveSign())
    Features.set(Feature_NoFP32DenormalsBit);
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_DisableFlatScratch,
  GIFBS_EnableLateCFGStructurize,
  GIFBS_Has16BitInsts,
  GIFBS_HasAddNoCarryInsts,
  GIFBS_HasAtomicBufferGlobalPkAddF16Insts,
  GIFBS_HasAtomicBufferGlobalPkAddF16NoRtnInsts,
  GIFBS_HasAtomicBufferPkAddBF16Inst,
  GIFBS_HasAtomicCSubNoRtnInsts,
  GIFBS_HasAtomicFMinFMaxF32GlobalInsts,
  GIFBS_HasAtomicFMinFMaxF64GlobalInsts,
  GIFBS_HasAtomicFaddNoRtnInsts,
  GIFBS_HasAtomicFaddRtnInsts,
  GIFBS_HasAtomicFlatPkAdd16Insts,
  GIFBS_HasAtomicGlobalPkAddBF16Inst,
  GIFBS_HasD16LoadStore,
  GIFBS_HasDLInsts,
  GIFBS_HasDot10Insts,
  GIFBS_HasDot1Insts,
  GIFBS_HasDot2Insts,
  GIFBS_HasDot3Insts,
  GIFBS_HasDot4Insts,
  GIFBS_HasDot5Insts,
  GIFBS_HasDot6Insts,
  GIFBS_HasDot7Insts,
  GIFBS_HasDot8Insts,
  GIFBS_HasDot9Insts,
  GIFBS_HasFlatAddressSpace,
  GIFBS_HasFlatAtomicFaddF32Inst,
  GIFBS_HasFlatBufferGlobalAtomicFaddF64Inst,
  GIFBS_HasFlatGlobalInsts,
  GIFBS_HasFmaLegacy32,
  GIFBS_HasFmaMixInsts,
  GIFBS_HasFmacF64Inst,
  GIFBS_HasGDS,
  GIFBS_HasGFX10_BEncoding,
  GIFBS_HasGetWaveIdInst,
  GIFBS_HasIntClamp,
  GIFBS_HasLdsAtomicAddF64,
  GIFBS_HasMAIInsts,
  GIFBS_HasMadMacF32Insts,
  GIFBS_HasMed3_16,
  GIFBS_HasMinMaxDenormModes,
  GIFBS_HasPackedD16VMem,
  GIFBS_HasPackedFP32Ops,
  GIFBS_HasPseudoScalarTrans,
  GIFBS_HasSALUFloatInsts,
  GIFBS_HasSMemRealTime,
  GIFBS_HasSMemTimeInst,
  GIFBS_HasShaderCyclesHiLoRegisters,
  GIFBS_HasShaderCyclesRegister,
  GIFBS_HasTrue16BitInsts,
  GIFBS_HasUnpackedD16VMem,
  GIFBS_HasUnrestrictedSOffset,
  GIFBS_HasVOP3PInsts,
  GIFBS_HasXNACKEnabled,
  GIFBS_LDSRequiresM0Init,
  GIFBS_NotHasAddNoCarryInsts,
  GIFBS_NotHasTrue16BitInsts,
  GIFBS_NotLDSRequiresM0Init,
  GIFBS_UseFakeTrue16Insts,
  GIFBS_UseRealTrue16Insts,
  GIFBS_isGFX10Only,
  GIFBS_isGFX10Plus,
  GIFBS_isGFX11Only,
  GIFBS_isGFX11Plus,
  GIFBS_isGFX12Only,
  GIFBS_isGFX12Plus,
  GIFBS_isGFX6,
  GIFBS_isGFX6GFX7,
  GIFBS_isGFX6GFX7GFX8GFX9,
  GIFBS_isGFX7GFX8GFX9,
  GIFBS_isGFX7Only,
  GIFBS_isGFX7Plus,
  GIFBS_isGFX8GFX9,
  GIFBS_isGFX8GFX9GFX10GFX11,
  GIFBS_isGFX8Plus,
  GIFBS_isGFX908orGFX90A,
  GIFBS_isGFX90APlus,
  GIFBS_isGFX940Plus,
  GIFBS_isGFX9GFX10,
  GIFBS_isGFX9Only,
  GIFBS_isGFX9Plus,
  GIFBS_isNotGFX12Plus,
  GIFBS_isNotGFX90APlus,
  GIFBS_isNotGFX9Plus,
  GIFBS_isWave32,
  GIFBS_isWave64,
  GIFBS_DisableFlatScratch_HasD16LoadStore,
  GIFBS_DisableFlatScratch_HasUnrestrictedSOffset,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts,
  GIFBS_FP16Denormals_NotHasMinMaxDenormModes,
  GIFBS_FalsePredicate_NotHasMinMaxDenormModes,
  GIFBS_Has16BitInsts_HasIntClamp,
  GIFBS_Has16BitInsts_HasTrue16BitInsts,
  GIFBS_Has16BitInsts_NotHasTrue16BitInsts,
  GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9,
  GIFBS_Has16BitInsts_isGFX8GFX9,
  GIFBS_Has16BitInsts_isGFX8Only,
  GIFBS_Has16BitInsts_isNotGFX90APlus,
  GIFBS_HasAddNoCarryInsts_HasIntClamp,
  GIFBS_HasAtomicBufferGlobalPkAddF16Insts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicBufferGlobalPkAddF16NoRtnInsts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicBufferPkAddBF16Inst_HasUnrestrictedSOffset,
  GIFBS_HasAtomicCSubNoRtnInsts_isGFX12Plus,
  GIFBS_HasAtomicDsPkAdd16Insts_HasGDS,
  GIFBS_HasAtomicDsPkAdd16Insts_LDSRequiresM0Init,
  GIFBS_HasAtomicDsPkAdd16Insts_NotLDSRequiresM0Init,
  GIFBS_HasAtomicFMinFMaxF32FlatInsts_HasFlatAddressSpace,
  GIFBS_HasAtomicFMinFMaxF32FlatInsts_HasFlatGlobalInsts,
  GIFBS_HasAtomicFMinFMaxF32GlobalInsts_HasFlatGlobalInsts,
  GIFBS_HasAtomicFMinFMaxF32GlobalInsts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicFMinFMaxF64FlatInsts_HasFlatAddressSpace,
  GIFBS_HasAtomicFMinFMaxF64FlatInsts_HasFlatGlobalInsts,
  GIFBS_HasAtomicFMinFMaxF64GlobalInsts_HasFlatGlobalInsts,
  GIFBS_HasAtomicFMinFMaxF64GlobalInsts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicFaddNoRtnInsts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicFaddRtnInsts_HasUnrestrictedSOffset,
  GIFBS_HasCvtFP8VOP1Bug_isGFX9Only,
  GIFBS_HasDot11Insts_isGFX12Plus,
  GIFBS_HasExportInsts_isGFX12Plus,
  GIFBS_HasFP8ConversionInsts_isGFX12Plus,
  GIFBS_HasFP8ConversionInsts_isGFX940Plus,
  GIFBS_HasFP8ConversionInsts_isGFX9Plus,
  GIFBS_HasFlatAddressSpace_isGFX12Plus,
  GIFBS_HasFlatBufferGlobalAtomicFaddF64Inst_HasUnrestrictedSOffset,
  GIFBS_HasFlatGlobalInsts_isGFX12Plus,
  GIFBS_HasGDS_HasLDSFPAtomicAddF32,
  GIFBS_HasGDS_isGFX11Plus,
  GIFBS_HasGDS_isGFX6GFX7GFX8GFX9GFX10,
  GIFBS_HasImageInsts_isGFX12Plus,
  GIFBS_HasLDSFPAtomicAddF32_LDSRequiresM0Init,
  GIFBS_HasLDSFPAtomicAddF32_NotLDSRequiresM0Init,
  GIFBS_HasMADIntraFwdBug_isGFX11Only,
  GIFBS_HasMadMacF32Insts_NoFP32Denormals,
  GIFBS_HasMadMixInsts_NoFP32Denormals,
  GIFBS_HasMinMaxDenormModes_isGFX12Plus,
  GIFBS_HasMinMaxDenormModes_isNotGFX12Plus,
  GIFBS_HasNoCvtFP8VOP1Bug_isGFX9Only,
  GIFBS_HasNotMADIntraFwdBug_isGFX9Plus,
  GIFBS_HasPackedD16VMem_HasUnrestrictedSOffset,
  GIFBS_HasScalarStores_isGFX8Plus,
  GIFBS_HasTrue16BitInsts_isGFX10Plus,
  GIFBS_HasUnalignedAccessMode_LDSRequiresM0Init,
  GIFBS_HasUnalignedAccessMode_NotLDSRequiresM0Init,
  GIFBS_HasXNACKEnabled_isGFX7Only,
  GIFBS_HasXNACKEnabled_isGFX9Plus,
  GIFBS_HasXNACKEnabled_isNotGFX9Plus,
  GIFBS_LDSRequiresM0Init_isGFX6GFX7GFX8GFX9GFX10,
  GIFBS_LDSRequiresM0Init_isGFX7Plus,
  GIFBS_NotHasTrue16BitInsts_isGFX10Plus,
  GIFBS_NotLDSRequiresM0Init_isGFX6GFX7GFX8GFX9GFX10,
  GIFBS_NotLDSRequiresM0Init_isGFX7Plus,
  GIFBS_has16BankLDS_isNotGFX90APlus,
  GIFBS_has32BankLDS_isNotGFX90APlus,
  GIFBS_isGFX11Only_isWave32,
  GIFBS_isGFX11Only_isWave64,
  GIFBS_isGFX12Plus_isWave32,
  GIFBS_isGFX12Plus_isWave64,
  GIFBS_DisableFlatScratch_HasD16LoadStore_HasUnrestrictedSOffset,
  GIFBS_EnableFlatScratch_HasD16LoadStore_HasFlatScratchInsts,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode,
  GIFBS_FP64Denormals_NotHasMinMaxDenormModes_isGFX12Plus,
  GIFBS_FP64Denormals_NotHasMinMaxDenormModes_isNotGFX12Plus,
  GIFBS_Has16BitInsts_HasMinMaxDenormModes_HasTrue16BitInsts,
  GIFBS_Has16BitInsts_HasMinMaxDenormModes_NotHasTrue16BitInsts,
  GIFBS_Has16BitInsts_has32BankLDS_isNotGFX90APlus,
  GIFBS_HasMadMacF32Insts_NoFP32Denormals_isGFX6GFX7GFX10,
  GIFBS_EnableFlatScratch_HasD16LoadStore_HasFlatScratchInsts_HasFlatScratchSVSMode,
  GIFBS_FP16Denormals_Has16BitInsts_HasTrue16BitInsts_NotHasMinMaxDenormModes,
  GIFBS_FP16Denormals_Has16BitInsts_NotHasMinMaxDenormModes_NotHasTrue16BitInsts,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_DisableFlatScratchBit, },
  {Feature_EnableLateCFGStructurizeBit, },
  {Feature_Has16BitInstsBit, },
  {Feature_HasAddNoCarryInstsBit, },
  {Feature_HasAtomicBufferGlobalPkAddF16InstsBit, },
  {Feature_HasAtomicBufferGlobalPkAddF16NoRtnInstsBit, },
  {Feature_HasAtomicBufferPkAddBF16InstBit, },
  {Feature_HasAtomicCSubNoRtnInstsBit, },
  {Feature_HasAtomicFMinFMaxF32GlobalInstsBit, },
  {Feature_HasAtomicFMinFMaxF64GlobalInstsBit, },
  {Feature_HasAtomicFaddNoRtnInstsBit, },
  {Feature_HasAtomicFaddRtnInstsBit, },
  {Feature_HasAtomicFlatPkAdd16InstsBit, },
  {Feature_HasAtomicGlobalPkAddBF16InstBit, },
  {Feature_HasD16LoadStoreBit, },
  {Feature_HasDLInstsBit, },
  {Feature_HasDot10InstsBit, },
  {Feature_HasDot1InstsBit, },
  {Feature_HasDot2InstsBit, },
  {Feature_HasDot3InstsBit, },
  {Feature_HasDot4InstsBit, },
  {Feature_HasDot5InstsBit, },
  {Feature_HasDot6InstsBit, },
  {Feature_HasDot7InstsBit, },
  {Feature_HasDot8InstsBit, },
  {Feature_HasDot9InstsBit, },
  {Feature_HasFlatAddressSpaceBit, },
  {Feature_HasFlatAtomicFaddF32InstBit, },
  {Feature_HasFlatBufferGlobalAtomicFaddF64InstBit, },
  {Feature_HasFlatGlobalInstsBit, },
  {Feature_HasFmaLegacy32Bit, },
  {Feature_HasFmaMixInstsBit, },
  {Feature_HasFmacF64InstBit, },
  {Feature_HasGDSBit, },
  {Feature_HasGFX10_BEncodingBit, },
  {Feature_HasGetWaveIdInstBit, },
  {Feature_HasIntClampBit, },
  {Feature_HasLdsAtomicAddF64Bit, },
  {Feature_HasMAIInstsBit, },
  {Feature_HasMadMacF32InstsBit, },
  {Feature_HasMed3_16Bit, },
  {Feature_HasMinMaxDenormModesBit, },
  {Feature_HasPackedD16VMemBit, },
  {Feature_HasPackedFP32OpsBit, },
  {Feature_HasPseudoScalarTransBit, },
  {Feature_HasSALUFloatInstsBit, },
  {Feature_HasSMemRealTimeBit, },
  {Feature_HasSMemTimeInstBit, },
  {Feature_HasShaderCyclesHiLoRegistersBit, },
  {Feature_HasShaderCyclesRegisterBit, },
  {Feature_HasTrue16BitInstsBit, },
  {Feature_HasUnpackedD16VMemBit, },
  {Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasVOP3PInstsBit, },
  {Feature_HasXNACKEnabledBit, },
  {Feature_LDSRequiresM0InitBit, },
  {Feature_NotHasAddNoCarryInstsBit, },
  {Feature_NotHasTrue16BitInstsBit, },
  {Feature_NotLDSRequiresM0InitBit, },
  {Feature_UseFakeTrue16InstsBit, },
  {Feature_UseRealTrue16InstsBit, },
  {Feature_isGFX10OnlyBit, },
  {Feature_isGFX10PlusBit, },
  {Feature_isGFX11OnlyBit, },
  {Feature_isGFX11PlusBit, },
  {Feature_isGFX12OnlyBit, },
  {Feature_isGFX12PlusBit, },
  {Feature_isGFX6Bit, },
  {Feature_isGFX6GFX7Bit, },
  {Feature_isGFX6GFX7GFX8GFX9Bit, },
  {Feature_isGFX7GFX8GFX9Bit, },
  {Feature_isGFX7OnlyBit, },
  {Feature_isGFX7PlusBit, },
  {Feature_isGFX8GFX9Bit, },
  {Feature_isGFX8GFX9GFX10GFX11Bit, },
  {Feature_isGFX8PlusBit, },
  {Feature_isGFX908orGFX90ABit, },
  {Feature_isGFX90APlusBit, },
  {Feature_isGFX940PlusBit, },
  {Feature_isGFX9GFX10Bit, },
  {Feature_isGFX9OnlyBit, },
  {Feature_isGFX9PlusBit, },
  {Feature_isNotGFX12PlusBit, },
  {Feature_isNotGFX90APlusBit, },
  {Feature_isNotGFX9PlusBit, },
  {Feature_isWave32Bit, },
  {Feature_isWave64Bit, },
  {Feature_DisableFlatScratchBit, Feature_HasD16LoadStoreBit, },
  {Feature_DisableFlatScratchBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, },
  {Feature_FP16DenormalsBit, Feature_NotHasMinMaxDenormModesBit, },
  {Feature_FalsePredicateBit, Feature_NotHasMinMaxDenormModesBit, },
  {Feature_Has16BitInstsBit, Feature_HasIntClampBit, },
  {Feature_Has16BitInstsBit, Feature_HasTrue16BitInstsBit, },
  {Feature_Has16BitInstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_Has16BitInstsBit, Feature_isGFX6GFX7GFX8GFX9Bit, },
  {Feature_Has16BitInstsBit, Feature_isGFX8GFX9Bit, },
  {Feature_Has16BitInstsBit, Feature_isGFX8OnlyBit, },
  {Feature_Has16BitInstsBit, Feature_isNotGFX90APlusBit, },
  {Feature_HasAddNoCarryInstsBit, Feature_HasIntClampBit, },
  {Feature_HasAtomicBufferGlobalPkAddF16InstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicBufferGlobalPkAddF16NoRtnInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicBufferPkAddBF16InstBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicCSubNoRtnInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasAtomicDsPkAdd16InstsBit, Feature_HasGDSBit, },
  {Feature_HasAtomicDsPkAdd16InstsBit, Feature_LDSRequiresM0InitBit, },
  {Feature_HasAtomicDsPkAdd16InstsBit, Feature_NotLDSRequiresM0InitBit, },
  {Feature_HasAtomicFMinFMaxF32FlatInstsBit, Feature_HasFlatAddressSpaceBit, },
  {Feature_HasAtomicFMinFMaxF32FlatInstsBit, Feature_HasFlatGlobalInstsBit, },
  {Feature_HasAtomicFMinFMaxF32GlobalInstsBit, Feature_HasFlatGlobalInstsBit, },
  {Feature_HasAtomicFMinFMaxF32GlobalInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicFMinFMaxF64FlatInstsBit, Feature_HasFlatAddressSpaceBit, },
  {Feature_HasAtomicFMinFMaxF64FlatInstsBit, Feature_HasFlatGlobalInstsBit, },
  {Feature_HasAtomicFMinFMaxF64GlobalInstsBit, Feature_HasFlatGlobalInstsBit, },
  {Feature_HasAtomicFMinFMaxF64GlobalInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicFaddNoRtnInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicFaddRtnInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasCvtFP8VOP1BugBit, Feature_isGFX9OnlyBit, },
  {Feature_HasDot11InstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasExportInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_isGFX940PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_isGFX9PlusBit, },
  {Feature_HasFlatAddressSpaceBit, Feature_isGFX12PlusBit, },
  {Feature_HasFlatBufferGlobalAtomicFaddF64InstBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasFlatGlobalInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasGDSBit, Feature_HasLDSFPAtomicAddF32Bit, },
  {Feature_HasGDSBit, Feature_isGFX11PlusBit, },
  {Feature_HasGDSBit, Feature_isGFX6GFX7GFX8GFX9GFX10Bit, },
  {Feature_HasImageInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasLDSFPAtomicAddF32Bit, Feature_LDSRequiresM0InitBit, },
  {Feature_HasLDSFPAtomicAddF32Bit, Feature_NotLDSRequiresM0InitBit, },
  {Feature_HasMADIntraFwdBugBit, Feature_isGFX11OnlyBit, },
  {Feature_HasMadMacF32InstsBit, Feature_NoFP32DenormalsBit, },
  {Feature_HasMadMixInstsBit, Feature_NoFP32DenormalsBit, },
  {Feature_HasMinMaxDenormModesBit, Feature_isGFX12PlusBit, },
  {Feature_HasMinMaxDenormModesBit, Feature_isNotGFX12PlusBit, },
  {Feature_HasNoCvtFP8VOP1BugBit, Feature_isGFX9OnlyBit, },
  {Feature_HasNotMADIntraFwdBugBit, Feature_isGFX9PlusBit, },
  {Feature_HasPackedD16VMemBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasScalarStoresBit, Feature_isGFX8PlusBit, },
  {Feature_HasTrue16BitInstsBit, Feature_isGFX10PlusBit, },
  {Feature_HasUnalignedAccessModeBit, Feature_LDSRequiresM0InitBit, },
  {Feature_HasUnalignedAccessModeBit, Feature_NotLDSRequiresM0InitBit, },
  {Feature_HasXNACKEnabledBit, Feature_isGFX7OnlyBit, },
  {Feature_HasXNACKEnabledBit, Feature_isGFX9PlusBit, },
  {Feature_HasXNACKEnabledBit, Feature_isNotGFX9PlusBit, },
  {Feature_LDSRequiresM0InitBit, Feature_isGFX6GFX7GFX8GFX9GFX10Bit, },
  {Feature_LDSRequiresM0InitBit, Feature_isGFX7PlusBit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_isGFX10PlusBit, },
  {Feature_NotLDSRequiresM0InitBit, Feature_isGFX6GFX7GFX8GFX9GFX10Bit, },
  {Feature_NotLDSRequiresM0InitBit, Feature_isGFX7PlusBit, },
  {Feature_has16BankLDSBit, Feature_isNotGFX90APlusBit, },
  {Feature_has32BankLDSBit, Feature_isNotGFX90APlusBit, },
  {Feature_isGFX11OnlyBit, Feature_isWave32Bit, },
  {Feature_isGFX11OnlyBit, Feature_isWave64Bit, },
  {Feature_isGFX12PlusBit, Feature_isWave32Bit, },
  {Feature_isGFX12PlusBit, Feature_isWave64Bit, },
  {Feature_DisableFlatScratchBit, Feature_HasD16LoadStoreBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_EnableFlatScratchBit, Feature_HasD16LoadStoreBit, Feature_HasFlatScratchInstsBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_HasFlatScratchSVSModeBit, },
  {Feature_FP64DenormalsBit, Feature_NotHasMinMaxDenormModesBit, Feature_isGFX12PlusBit, },
  {Feature_FP64DenormalsBit, Feature_NotHasMinMaxDenormModesBit, Feature_isNotGFX12PlusBit, },
  {Feature_Has16BitInstsBit, Feature_HasMinMaxDenormModesBit, Feature_HasTrue16BitInstsBit, },
  {Feature_Has16BitInstsBit, Feature_HasMinMaxDenormModesBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_Has16BitInstsBit, Feature_has32BankLDSBit, Feature_isNotGFX90APlusBit, },
  {Feature_HasMadMacF32InstsBit, Feature_NoFP32DenormalsBit, Feature_isGFX6GFX7GFX10Bit, },
  {Feature_EnableFlatScratchBit, Feature_HasD16LoadStoreBit, Feature_HasFlatScratchInstsBit, Feature_HasFlatScratchSVSModeBit, },
  {Feature_FP16DenormalsBit, Feature_Has16BitInstsBit, Feature_HasTrue16BitInstsBit, Feature_NotHasMinMaxDenormModesBit, },
  {Feature_FP16DenormalsBit, Feature_Has16BitInstsBit, Feature_NotHasMinMaxDenormModesBit, Feature_NotHasTrue16BitInstsBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
  GICP_gi_buf_soffset,
  GICP_gi_ds_128bit_8byte_aligned,
  GICP_gi_ds_1addr_1offset,
  GICP_gi_ds_64bit_4byte_aligned,
  GICP_gi_flat_offset,
  GICP_gi_flat_scratch_offset,
  GICP_gi_flat_scratch_saddr,
  GICP_gi_flat_scratch_svaddr,
  GICP_gi_global_offset,
  GICP_gi_global_saddr,
  GICP_gi_mubuf_addr64,
  GICP_gi_mubuf_offset,
  GICP_gi_mubuf_scratch_offen,
  GICP_gi_mubuf_scratch_offset,
  GICP_gi_smrd_buffer_imm,
  GICP_gi_smrd_buffer_imm32,
  GICP_gi_smrd_buffer_sgpr_imm,
  GICP_gi_smrd_imm,
  GICP_gi_smrd_imm32,
  GICP_gi_smrd_sgpr,
  GICP_gi_smrd_sgpr_imm,
  GICP_gi_swmmacindex16,
  GICP_gi_swmmacindex8,
  GICP_gi_vcsrc,
  GICP_gi_vinterpmods,
  GICP_gi_vinterpmods_hi,
  GICP_gi_vop3_mad_mix_mods,
  GICP_gi_vop3_mad_mix_mods_ext,
  GICP_gi_vop3_no_mods,
  GICP_gi_vop3mods,
  GICP_gi_vop3mods0,
  GICP_gi_vop3modsnoncanonicalizing,
  GICP_gi_vop3omods,
  GICP_gi_vop3opsel,
  GICP_gi_vop3opselmods,
  GICP_gi_vop3pmods,
  GICP_gi_vop3pmodsdot,
  GICP_gi_vop3pmodsneg,
  GICP_gi_vsrc0,
  GICP_gi_wmmamods,
  GICP_gi_wmmamodsf16Neg,
  GICP_gi_wmmamodsf16NegAbs,
  GICP_gi_wmmaopselvop3pmods,
  GICP_gi_wmmavisrc,
};
// See constructor for table contents

AMDGPUInstructionSelector::ComplexMatcherMemFn
AMDGPUInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
  &AMDGPUInstructionSelector::selectBUFSOffset, // gi_buf_soffset
  &AMDGPUInstructionSelector::selectDS128Bit8ByteAligned, // gi_ds_128bit_8byte_aligned
  &AMDGPUInstructionSelector::selectDS1Addr1Offset, // gi_ds_1addr_1offset
  &AMDGPUInstructionSelector::selectDS64Bit4ByteAligned, // gi_ds_64bit_4byte_aligned
  &AMDGPUInstructionSelector::selectFlatOffset, // gi_flat_offset
  &AMDGPUInstructionSelector::selectScratchOffset, // gi_flat_scratch_offset
  &AMDGPUInstructionSelector::selectScratchSAddr, // gi_flat_scratch_saddr
  &AMDGPUInstructionSelector::selectScratchSVAddr, // gi_flat_scratch_svaddr
  &AMDGPUInstructionSelector::selectGlobalOffset, // gi_global_offset
  &AMDGPUInstructionSelector::selectGlobalSAddr, // gi_global_saddr
  &AMDGPUInstructionSelector::selectMUBUFAddr64, // gi_mubuf_addr64
  &AMDGPUInstructionSelector::selectMUBUFOffset, // gi_mubuf_offset
  &AMDGPUInstructionSelector::selectMUBUFScratchOffen, // gi_mubuf_scratch_offen
  &AMDGPUInstructionSelector::selectMUBUFScratchOffset, // gi_mubuf_scratch_offset
  &AMDGPUInstructionSelector::selectSMRDBufferImm, // gi_smrd_buffer_imm
  &AMDGPUInstructionSelector::selectSMRDBufferImm32, // gi_smrd_buffer_imm32
  &AMDGPUInstructionSelector::selectSMRDBufferSgprImm, // gi_smrd_buffer_sgpr_imm
  &AMDGPUInstructionSelector::selectSmrdImm, // gi_smrd_imm
  &AMDGPUInstructionSelector::selectSmrdImm32, // gi_smrd_imm32
  &AMDGPUInstructionSelector::selectSmrdSgpr, // gi_smrd_sgpr
  &AMDGPUInstructionSelector::selectSmrdSgprImm, // gi_smrd_sgpr_imm
  &AMDGPUInstructionSelector::selectSWMMACIndex16, // gi_swmmacindex16
  &AMDGPUInstructionSelector::selectSWMMACIndex8, // gi_swmmacindex8
  &AMDGPUInstructionSelector::selectVCSRC, // gi_vcsrc
  &AMDGPUInstructionSelector::selectVINTERPMods, // gi_vinterpmods
  &AMDGPUInstructionSelector::selectVINTERPModsHi, // gi_vinterpmods_hi
  &AMDGPUInstructionSelector::selectVOP3PMadMixMods, // gi_vop3_mad_mix_mods
  &AMDGPUInstructionSelector::selectVOP3PMadMixModsExt, // gi_vop3_mad_mix_mods_ext
  &AMDGPUInstructionSelector::selectVOP3NoMods, // gi_vop3_no_mods
  &AMDGPUInstructionSelector::selectVOP3Mods, // gi_vop3mods
  &AMDGPUInstructionSelector::selectVOP3Mods0, // gi_vop3mods0
  &AMDGPUInstructionSelector::selectVOP3ModsNonCanonicalizing, // gi_vop3modsnoncanonicalizing
  &AMDGPUInstructionSelector::selectVOP3OMods, // gi_vop3omods
  &AMDGPUInstructionSelector::selectVOP3OpSelMods, // gi_vop3opsel
  &AMDGPUInstructionSelector::selectVOP3OpSelMods, // gi_vop3opselmods
  &AMDGPUInstructionSelector::selectVOP3PMods, // gi_vop3pmods
  &AMDGPUInstructionSelector::selectVOP3PModsDOT, // gi_vop3pmodsdot
  &AMDGPUInstructionSelector::selectVOP3PModsNeg, // gi_vop3pmodsneg
  &AMDGPUInstructionSelector::selectVSRC0, // gi_vsrc0
  &AMDGPUInstructionSelector::selectWMMAModsF32NegAbs, // gi_wmmamods
  &AMDGPUInstructionSelector::selectWMMAModsF16Neg, // gi_wmmamodsf16Neg
  &AMDGPUInstructionSelector::selectWMMAModsF16NegAbs, // gi_wmmamodsf16NegAbs
  &AMDGPUInstructionSelector::selectWMMAOpSelVOP3PMods, // gi_wmmaopselvop3pmods
  &AMDGPUInstructionSelector::selectWMMAVISrc, // gi_wmmavisrc
};

// PatFrag predicates.
enum {
  GICXXPred_MI_Predicate_aligned_smrd_load = GICXXPred_Invalid + 1,
  GICXXPred_MI_Predicate_anonymous_18476,
  GICXXPred_MI_Predicate_anonymous_18479,
  GICXXPred_MI_Predicate_anonymous_18480,
  GICXXPred_MI_Predicate_anonymous_18481,
  GICXXPred_MI_Predicate_anonymous_18482,
  GICXXPred_MI_Predicate_anonymous_18483,
  GICXXPred_MI_Predicate_anonymous_18486,
  GICXXPred_MI_Predicate_anonymous_18487,
  GICXXPred_MI_Predicate_anonymous_18488,
  GICXXPred_MI_Predicate_anonymous_18489,
  GICXXPred_MI_Predicate_anonymous_18490,
  GICXXPred_MI_Predicate_anonymous_18491,
  GICXXPred_MI_Predicate_anonymous_18492,
  GICXXPred_MI_Predicate_anonymous_18493,
  GICXXPred_MI_Predicate_anonymous_18494,
  GICXXPred_MI_Predicate_anonymous_18495,
  GICXXPred_MI_Predicate_anonymous_18496,
  GICXXPred_MI_Predicate_anonymous_18497,
  GICXXPred_MI_Predicate_anonymous_18498,
  GICXXPred_MI_Predicate_anonymous_18499,
  GICXXPred_MI_Predicate_anonymous_18500,
  GICXXPred_MI_Predicate_anonymous_18501,
  GICXXPred_MI_Predicate_anonymous_18502,
  GICXXPred_MI_Predicate_anonymous_18503,
  GICXXPred_MI_Predicate_anonymous_18504,
  GICXXPred_MI_Predicate_anonymous_18505,
  GICXXPred_MI_Predicate_anonymous_18506,
  GICXXPred_MI_Predicate_anonymous_18507,
  GICXXPred_MI_Predicate_anonymous_18508,
  GICXXPred_MI_Predicate_anonymous_18509,
  GICXXPred_MI_Predicate_anonymous_18510,
  GICXXPred_MI_Predicate_anonymous_18511,
  GICXXPred_MI_Predicate_anonymous_18512,
  GICXXPred_MI_Predicate_anonymous_18513,
  GICXXPred_MI_Predicate_anonymous_18514,
  GICXXPred_MI_Predicate_anonymous_18515,
  GICXXPred_MI_Predicate_anonymous_18516,
  GICXXPred_MI_Predicate_anonymous_18517,
  GICXXPred_MI_Predicate_anonymous_18518,
  GICXXPred_MI_Predicate_anonymous_18519,
  GICXXPred_MI_Predicate_anonymous_18520,
  GICXXPred_MI_Predicate_anonymous_18521,
  GICXXPred_MI_Predicate_anonymous_18522,
  GICXXPred_MI_Predicate_anonymous_18523,
  GICXXPred_MI_Predicate_anonymous_18524,
  GICXXPred_MI_Predicate_anonymous_18525,
  GICXXPred_MI_Predicate_anonymous_18526,
  GICXXPred_MI_Predicate_anonymous_18527,
  GICXXPred_MI_Predicate_anonymous_18534,
  GICXXPred_MI_Predicate_anonymous_18546,
  GICXXPred_MI_Predicate_anonymous_22135,
  GICXXPred_MI_Predicate_anonymous_23233,
  GICXXPred_MI_Predicate_anonymous_23235,
  GICXXPred_MI_Predicate_anonymous_23237,
  GICXXPred_MI_Predicate_anonymous_23239,
  GICXXPred_MI_Predicate_anonymous_23241,
  GICXXPred_MI_Predicate_anonymous_23245,
  GICXXPred_MI_Predicate_anonymous_23247,
  GICXXPred_MI_Predicate_anonymous_23249,
  GICXXPred_MI_Predicate_anonymous_23251,
  GICXXPred_MI_Predicate_anonymous_23253,
  GICXXPred_MI_Predicate_anonymous_23412,
  GICXXPred_MI_Predicate_anonymous_23414,
  GICXXPred_MI_Predicate_anonymous_23638,
  GICXXPred_MI_Predicate_anonymous_23648,
  GICXXPred_MI_Predicate_anonymous_23651,
  GICXXPred_MI_Predicate_anonymous_23739,
  GICXXPred_MI_Predicate_anonymous_24022,
  GICXXPred_MI_Predicate_anonymous_24025,
  GICXXPred_MI_Predicate_anonymous_24028,
  GICXXPred_MI_Predicate_anonymous_24030,
  GICXXPred_MI_Predicate_anonymous_24033,
  GICXXPred_MI_Predicate_anonymous_24035,
  GICXXPred_MI_Predicate_anonymous_24038,
  GICXXPred_MI_Predicate_anonymous_24041,
  GICXXPred_MI_Predicate_anonymous_24045,
  GICXXPred_MI_Predicate_anonymous_24053,
  GICXXPred_MI_Predicate_anonymous_24088,
  GICXXPred_MI_Predicate_anonymous_24193,
  GICXXPred_MI_Predicate_anonymous_24196,
  GICXXPred_MI_Predicate_anonymous_24198,
  GICXXPred_MI_Predicate_anonymous_24200,
  GICXXPred_MI_Predicate_anonymous_24202,
  GICXXPred_MI_Predicate_anonymous_24204,
  GICXXPred_MI_Predicate_anonymous_24206,
  GICXXPred_MI_Predicate_anonymous_25064,
  GICXXPred_MI_Predicate_anonymous_25066,
  GICXXPred_MI_Predicate_anonymous_25070,
  GICXXPred_MI_Predicate_anonymous_25072,
  GICXXPred_MI_Predicate_anonymous_25074,
  GICXXPred_MI_Predicate_anonymous_25076,
  GICXXPred_MI_Predicate_anonymous_25080,
  GICXXPred_MI_Predicate_anonymous_25082,
  GICXXPred_MI_Predicate_anonymous_25084,
  GICXXPred_MI_Predicate_anonymous_25086,
  GICXXPred_MI_Predicate_anonymous_25088,
  GICXXPred_MI_Predicate_anonymous_25090,
  GICXXPred_MI_Predicate_anonymous_25092,
  GICXXPred_MI_Predicate_anonymous_25094,
  GICXXPred_MI_Predicate_anonymous_25098,
  GICXXPred_MI_Predicate_anonymous_25100,
  GICXXPred_MI_Predicate_anonymous_25102,
  GICXXPred_MI_Predicate_anonymous_25104,
  GICXXPred_MI_Predicate_anonymous_25108,
  GICXXPred_MI_Predicate_anonymous_25110,
  GICXXPred_MI_Predicate_anonymous_25114,
  GICXXPred_MI_Predicate_anonymous_25116,
  GICXXPred_MI_Predicate_anonymous_25118,
  GICXXPred_MI_Predicate_anonymous_25120,
  GICXXPred_MI_Predicate_anonymous_25124,
  GICXXPred_MI_Predicate_anonymous_25126,
  GICXXPred_MI_Predicate_anonymous_25128,
  GICXXPred_MI_Predicate_anonymous_25130,
  GICXXPred_MI_Predicate_anonymous_25132,
  GICXXPred_MI_Predicate_anonymous_25134,
  GICXXPred_MI_Predicate_anonymous_25136,
  GICXXPred_MI_Predicate_anonymous_25138,
  GICXXPred_MI_Predicate_anonymous_25142,
  GICXXPred_MI_Predicate_anonymous_25144,
  GICXXPred_MI_Predicate_anonymous_25146,
  GICXXPred_MI_Predicate_anonymous_25148,
  GICXXPred_MI_Predicate_anonymous_25152,
  GICXXPred_MI_Predicate_anonymous_25154,
  GICXXPred_MI_Predicate_anonymous_25156,
  GICXXPred_MI_Predicate_anonymous_25158,
  GICXXPred_MI_Predicate_anonymous_25162,
  GICXXPred_MI_Predicate_anonymous_25164,
  GICXXPred_MI_Predicate_anonymous_25168,
  GICXXPred_MI_Predicate_anonymous_25170,
  GICXXPred_MI_Predicate_anonymous_25172,
  GICXXPred_MI_Predicate_anonymous_25174,
  GICXXPred_MI_Predicate_anonymous_25176,
  GICXXPred_MI_Predicate_anonymous_25178,
  GICXXPred_MI_Predicate_anonymous_25180,
  GICXXPred_MI_Predicate_anonymous_25182,
  GICXXPred_MI_Predicate_anonymous_25186,
  GICXXPred_MI_Predicate_anonymous_25188,
  GICXXPred_MI_Predicate_anonymous_25190,
  GICXXPred_MI_Predicate_anonymous_25192,
  GICXXPred_MI_Predicate_anonymous_25196,
  GICXXPred_MI_Predicate_anonymous_25198,
  GICXXPred_MI_Predicate_anonymous_25200,
  GICXXPred_MI_Predicate_anonymous_25202,
  GICXXPred_MI_Predicate_anonymous_25204,
  GICXXPred_MI_Predicate_anonymous_25206,
  GICXXPred_MI_Predicate_anonymous_25210,
  GICXXPred_MI_Predicate_anonymous_25212,
  GICXXPred_MI_Predicate_anonymous_25214,
  GICXXPred_MI_Predicate_anonymous_25216,
  GICXXPred_MI_Predicate_anonymous_25218,
  GICXXPred_MI_Predicate_anonymous_25220,
  GICXXPred_MI_Predicate_anonymous_25222,
  GICXXPred_MI_Predicate_anonymous_25224,
  GICXXPred_MI_Predicate_anonymous_25226,
  GICXXPred_MI_Predicate_anonymous_25228,
  GICXXPred_MI_Predicate_anonymous_25232,
  GICXXPred_MI_Predicate_anonymous_25234,
  GICXXPred_MI_Predicate_anonymous_25236,
  GICXXPred_MI_Predicate_anonymous_25238,
  GICXXPred_MI_Predicate_anonymous_25240,
  GICXXPred_MI_Predicate_anonymous_25242,
  GICXXPred_MI_Predicate_anonymous_25244,
  GICXXPred_MI_Predicate_anonymous_25246,
  GICXXPred_MI_Predicate_anonymous_35622,
  GICXXPred_MI_Predicate_anonymous_35929,
  GICXXPred_MI_Predicate_anonymous_35931,
  GICXXPred_MI_Predicate_anonymous_35965,
  GICXXPred_MI_Predicate_anonymous_36140,
  GICXXPred_MI_Predicate_anonymous_36143,
  GICXXPred_MI_Predicate_anonymous_36148,
  GICXXPred_MI_Predicate_anonymous_36152,
  GICXXPred_MI_Predicate_anonymous_36198,
  GICXXPred_MI_Predicate_anonymous_36200,
  GICXXPred_MI_Predicate_anonymous_36239,
  GICXXPred_MI_Predicate_anonymous_36262,
  GICXXPred_MI_Predicate_anonymous_36264,
  GICXXPred_MI_Predicate_anonymous_36272,
  GICXXPred_MI_Predicate_anonymous_36274,
  GICXXPred_MI_Predicate_anonymous_36291,
  GICXXPred_MI_Predicate_anonymous_36293,
  GICXXPred_MI_Predicate_anonymous_36295,
  GICXXPred_MI_Predicate_anonymous_36297,
  GICXXPred_MI_Predicate_anonymous_36299,
  GICXXPred_MI_Predicate_csh_mask_16,
  GICXXPred_MI_Predicate_csh_mask_32,
  GICXXPred_MI_Predicate_csh_mask_64,
  GICXXPred_MI_Predicate_fmaxnum_like_nnan,
  GICXXPred_MI_Predicate_fminnum_like_nnan,
  GICXXPred_MI_Predicate_is_canonicalized,
  GICXXPred_MI_Predicate_load_align_less_than_4_local,
  GICXXPred_MI_Predicate_load_align_less_than_4_local_m0,
  GICXXPred_MI_Predicate_shl1_add,
  GICXXPred_MI_Predicate_shl2_add,
  GICXXPred_MI_Predicate_shl3_add,
  GICXXPred_MI_Predicate_shl4_add,
  GICXXPred_MI_Predicate_shl_0_to_4,
  GICXXPred_MI_Predicate_smrd_extloadi8,
  GICXXPred_MI_Predicate_smrd_extloadi16,
  GICXXPred_MI_Predicate_smrd_load,
  GICXXPred_MI_Predicate_smrd_prefetch,
  GICXXPred_MI_Predicate_smrd_sextloadi8,
  GICXXPred_MI_Predicate_smrd_sextloadi16,
  GICXXPred_MI_Predicate_smrd_zextloadi8,
  GICXXPred_MI_Predicate_smrd_zextloadi16,
  GICXXPred_MI_Predicate_store_align_less_than_4_local,
  GICXXPred_MI_Predicate_store_align_less_than_4_local_m0,
};
bool AMDGPUInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_aligned_smrd_load: {
    
      auto &Ld = cast<GLoad>(MI);
      TypeSize Size = Ld.getMMO().getSize().getValue();
      return Size <= 4 || Ld.getMMO().getAlign().value() >= Size;
      
    llvm_unreachable("aligned_smrd_load should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_18476: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18479: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18480: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18481: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18482: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18483: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18486: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18487: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18488: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18489: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18490: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18491: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18492: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18493: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18494: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18495: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18496: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18497: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18498: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18499: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18500: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18501: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18502: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18503: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18504: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18505: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18506: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18507: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18508: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18509: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18510: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18511: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18512: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18513: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18514: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18515: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18516: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18517: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18518: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18519: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18520: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18521: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18522: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18523: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18524: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18525: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18526: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18527: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18534: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18546: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_22135: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23233: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23235: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23237: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23239: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23241: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23245: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23247: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23249: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23251: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23253: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23412: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23414: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23638: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23648: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23651: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23739: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_24022: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24022 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24025: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24025 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24028: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24028 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24030: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24030 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24033: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24033 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24035: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24035 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24038: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24038 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24041: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24041 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24045: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24045 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24053: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24053 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24088: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24088 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24193: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_24196: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_24198: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_24200: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_24202: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_24204: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_24206: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_25064: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25066: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25070: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25072: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25074: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25076: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25080: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25082: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25084: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25086: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25088: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25090: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25092: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25094: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25098: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25100: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25102: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25104: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25108: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25110: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25114: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25116: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25118: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25120: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25124: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25126: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25128: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25130: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25132: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25134: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25136: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25138: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25142: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25144: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25146: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25148: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25152: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25154: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25156: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25158: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25162: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25164: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25168: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25170: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25172: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25174: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25176: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25178: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25180: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25182: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25186: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25188: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25190: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25192: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25196: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25198: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25200: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25202: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25204: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25206: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25210: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25212: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25214: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25216: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25218: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25220: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25222: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25224: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25226: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25228: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25232: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25234: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25236: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25238: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25240: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25242: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25244: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25246: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_35622: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_35929: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_35931: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_35965: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36140: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36143: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36148: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36152: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36198: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36200: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36239: {
    
        const SITargetLowering *TLI = static_cast<const SITargetLowering *>(
          MF.getSubtarget().getTargetLowering());
    
        return TLI->isCanonicalized(MI.getOperand(1).getReg(), MF) &&
          TLI->isCanonicalized(MI.getOperand(2).getReg(), MF);
      
    llvm_unreachable("anonymous_36239 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_36262: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36264: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36272: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36274: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36291: {
    
        const SITargetLowering *TLI = static_cast<const SITargetLowering *>(
          MF.getSubtarget().getTargetLowering());
    
        return TLI->isCanonicalized(MI.getOperand(1).getReg(), MF);
      
    llvm_unreachable("anonymous_36291 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_36293: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36295: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36297: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36299: {
    return true;
  }
  case GICXXPred_MI_Predicate_csh_mask_16: {
     return isUnneededShiftMask(MI, 4); 
  }
  case GICXXPred_MI_Predicate_csh_mask_32: {
     return isUnneededShiftMask(MI, 5); 
  }
  case GICXXPred_MI_Predicate_csh_mask_64: {
     return isUnneededShiftMask(MI, 6); 
  }
  case GICXXPred_MI_Predicate_fmaxnum_like_nnan: {
    
        return isKnownNeverNaN(MI.getOperand(0).getReg(), MRI);
      
  }
  case GICXXPred_MI_Predicate_fminnum_like_nnan: {
    
        return isKnownNeverNaN(MI.getOperand(0).getReg(), MRI);
      
  }
  case GICXXPred_MI_Predicate_is_canonicalized: {
    
        const SITargetLowering *TLI = static_cast<const SITargetLowering *>(
            MF.getSubtarget().getTargetLowering());
        const MachineOperand &Dst = MI.getOperand(0);
        assert(Dst.isDef());
        return TLI->isCanonicalized(Dst.getReg(), MF);
       
    llvm_unreachable("is_canonicalized should have returned");
  }
  case GICXXPred_MI_Predicate_load_align_less_than_4_local: {
    return (*MI.memoperands_begin())->getAlign() < 4;
  }
  case GICXXPred_MI_Predicate_load_align_less_than_4_local_m0: {
    return (*MI.memoperands_begin())->getAlign() < 4;
  }
  case GICXXPred_MI_Predicate_shl1_add: {
    return true;
  }
  case GICXXPred_MI_Predicate_shl2_add: {
    return true;
  }
  case GICXXPred_MI_Predicate_shl3_add: {
    return true;
  }
  case GICXXPred_MI_Predicate_shl4_add: {
    return true;
  }
  case GICXXPred_MI_Predicate_shl_0_to_4: {
    
        int64_t Imm = 0;
        if (!mi_match(MI.getOperand(2).getReg(), MRI, m_ICst(Imm)) &&
            !mi_match(MI.getOperand(2).getReg(), MRI, m_Copy(m_ICst(Imm))))
          return false;
        return (uint64_t)Imm <= 4;
      
    llvm_unreachable("shl_0_to_4 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_extloadi8: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_extloadi8 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_extloadi16: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_extloadi16 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_load: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_load should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_prefetch: {
    
        return isInstrUniform(MI);
      
  }
  case GICXXPred_MI_Predicate_smrd_sextloadi8: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_sextloadi8 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_sextloadi16: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_sextloadi16 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_zextloadi8: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_zextloadi8 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_zextloadi16: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_zextloadi16 should have returned");
  }
  case GICXXPred_MI_Predicate_store_align_less_than_4_local: {
    return (*MI.memoperands_begin())->getAlign() < 4;
  }
  case GICXXPred_MI_Predicate_store_align_less_than_4_local_m0: {
    return (*MI.memoperands_begin())->getAlign() < 4;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_IMMZeroBasedBitfieldMask = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_NegSubInlineConst32,
  GICXXPred_I64_Predicate_NegSubInlineIntConst16,
  GICXXPred_I64_Predicate_SIMM16bit,
  GICXXPred_I64_Predicate_ShiftAmt32Imm,
  GICXXPred_I64_Predicate_i32imm_one,
  GICXXPred_I64_Predicate_i32imm_zero,
  GICXXPred_I64_Predicate_i64imm_32bit,
};
bool AMDGPUInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_IMMZeroBasedBitfieldMask: {
    
      return isMask_32(Imm);
    
  }
  case GICXXPred_I64_Predicate_NegSubInlineConst32: {
    
      return Imm < -16 && Imm >= -64;
    
  }
  case GICXXPred_I64_Predicate_NegSubInlineIntConst16: {
    
      return Imm < -16 && Imm >= -64;
    
  }
  case GICXXPred_I64_Predicate_SIMM16bit: {
    return isInt<16>(Imm) || isUInt<16>(Imm);
  }
  case GICXXPred_I64_Predicate_ShiftAmt32Imm: {
    
      return Imm < 32;
    
  }
  case GICXXPred_I64_Predicate_i32imm_one: {
    
      return Imm == 1;
    
  }
  case GICXXPred_I64_Predicate_i32imm_zero: {
    
      return Imm == 0;
    
  }
  case GICXXPred_I64_Predicate_i64imm_32bit: {
    
      return (Imm & 0xffffffffULL) == static_cast<uint64_t>(Imm);
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APFloat_Predicate_InlineImmFP32 = GICXXPred_Invalid + 1,
  GICXXPred_APFloat_Predicate_InlineImmFP64,
  GICXXPred_APFloat_Predicate_fpimm_neg_pow2_prefer_ldexp_f64,
  GICXXPred_APFloat_Predicate_fpimm_pos_pow2_prefer_ldexp_f64,
};
bool AMDGPUInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APFloat_Predicate_InlineImmFP32: {
    
      return isInlineImmediate(Imm);
    
  }
  case GICXXPred_APFloat_Predicate_InlineImmFP64: {
    
      return isInlineImmediate(Imm);
    
  }
  case GICXXPred_APFloat_Predicate_fpimm_neg_pow2_prefer_ldexp_f64: {
    
        if (!Imm.isNegative())
          return false;
        int Exp = Imm.getExactLog2Abs();
        // Prefer leaving the FP inline immediates as they are.
        // 0.5, 1.0, 2.0, 4.0
    
        // For f64 ldexp is always better than materializing a 64-bit
        // constant.
        return Exp != INT_MIN && (Exp < -1 || Exp > 2);
      
    llvm_unreachable("fpimm_neg_pow2_prefer_ldexp_f64 should have returned");
  }
  case GICXXPred_APFloat_Predicate_fpimm_pos_pow2_prefer_ldexp_f64: {
    
        if (Imm.isNegative())
          return false;
    
        int Exp = Imm.getExactLog2Abs();
        // Prefer leaving the FP inline immediates as they are.
        // 0.5, 1.0, 2.0, 4.0
    
        // For f64 ldexp is always better than materializing a 64-bit
        // constant.
        return Exp != INT_MIN && (Exp < -1 || Exp > 2);
      
    llvm_unreachable("fpimm_pos_pow2_prefer_ldexp_f64 should have returned");
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APInt_Predicate_InlineImm64 = GICXXPred_Invalid + 1,
};
bool AMDGPUInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APInt_Predicate_InlineImm64: {
    
      return isInlineImmediate(Imm);
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AMDGPUInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("AMDGPUInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
  GICR_renderBitcastImm,
  GICR_renderExtractCPol,
  GICR_renderExtractCpolSetGLC,
  GICR_renderExtractSWZ,
  GICR_renderFPPow2ToExponent,
  GICR_renderFrameIndex,
  GICR_renderNegateImm,
  GICR_renderOpSelTImm,
  GICR_renderPopcntImm,
  GICR_renderTruncTImm,
};
AMDGPUInstructionSelector::CustomRendererFn
AMDGPUInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
  &AMDGPUInstructionSelector::renderBitcastImm,
  &AMDGPUInstructionSelector::renderExtractCPol,
  &AMDGPUInstructionSelector::renderExtractCpolSetGLC,
  &AMDGPUInstructionSelector::renderExtractSWZ,
  &AMDGPUInstructionSelector::renderFPPow2ToExponent,
  &AMDGPUInstructionSelector::renderFrameIndex,
  &AMDGPUInstructionSelector::renderNegateImm,
  &AMDGPUInstructionSelector::renderOpSelTImm,
  &AMDGPUInstructionSelector::renderPopcntImm,
  &AMDGPUInstructionSelector::renderTruncTImm,
};

bool AMDGPUInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool AMDGPUInstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("AMDGPUInstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *AMDGPUInstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(51), GIMT_Encode2(3656), /*)*//*default:*//*Label 168*/ GIMT_Encode4(585939),
    /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(14430),
    /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(18064),
    /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(18565), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_AND*//*Label 3*/ GIMT_Encode4(18851),
    /*TargetOpcode::G_OR*//*Label 4*/ GIMT_Encode4(19807),
    /*TargetOpcode::G_XOR*//*Label 5*/ GIMT_Encode4(34275), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FRAME_INDEX*//*Label 6*/ GIMT_Encode4(38639), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BUILD_VECTOR*//*Label 7*/ GIMT_Encode4(38691), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BITCAST*//*Label 8*/ GIMT_Encode4(41726), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 9*/ GIMT_Encode4(50199), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC_ROUNDEVEN*//*Label 10*/ GIMT_Encode4(50527),
    /*TargetOpcode::G_READCYCLECOUNTER*//*Label 11*/ GIMT_Encode4(50855),
    /*TargetOpcode::G_READSTEADYCOUNTER*//*Label 12*/ GIMT_Encode4(50995),
    /*TargetOpcode::G_LOAD*//*Label 13*/ GIMT_Encode4(51053),
    /*TargetOpcode::G_SEXTLOAD*//*Label 14*/ GIMT_Encode4(126442),
    /*TargetOpcode::G_ZEXTLOAD*//*Label 15*/ GIMT_Encode4(130408), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_STORE*//*Label 16*/ GIMT_Encode4(134250), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ATOMIC_CMPXCHG*//*Label 17*/ GIMT_Encode4(170156),
    /*TargetOpcode::G_ATOMICRMW_XCHG*//*Label 18*/ GIMT_Encode4(171282),
    /*TargetOpcode::G_ATOMICRMW_ADD*//*Label 19*/ GIMT_Encode4(173494),
    /*TargetOpcode::G_ATOMICRMW_SUB*//*Label 20*/ GIMT_Encode4(176006),
    /*TargetOpcode::G_ATOMICRMW_AND*//*Label 21*/ GIMT_Encode4(178518), GIMT_Encode4(0),
    /*TargetOpcode::G_ATOMICRMW_OR*//*Label 22*/ GIMT_Encode4(181030),
    /*TargetOpcode::G_ATOMICRMW_XOR*//*Label 23*/ GIMT_Encode4(183542),
    /*TargetOpcode::G_ATOMICRMW_MAX*//*Label 24*/ GIMT_Encode4(186054),
    /*TargetOpcode::G_ATOMICRMW_MIN*//*Label 25*/ GIMT_Encode4(188566),
    /*TargetOpcode::G_ATOMICRMW_UMAX*//*Label 26*/ GIMT_Encode4(191078),
    /*TargetOpcode::G_ATOMICRMW_UMIN*//*Label 27*/ GIMT_Encode4(193590),
    /*TargetOpcode::G_ATOMICRMW_FADD*//*Label 28*/ GIMT_Encode4(196102), GIMT_Encode4(0),
    /*TargetOpcode::G_ATOMICRMW_FMAX*//*Label 29*/ GIMT_Encode4(198961),
    /*TargetOpcode::G_ATOMICRMW_FMIN*//*Label 30*/ GIMT_Encode4(201607),
    /*TargetOpcode::G_ATOMICRMW_UINC_WRAP*//*Label 31*/ GIMT_Encode4(204253),
    /*TargetOpcode::G_ATOMICRMW_UDEC_WRAP*//*Label 32*/ GIMT_Encode4(206765),
    /*TargetOpcode::G_FENCE*//*Label 33*/ GIMT_Encode4(209277),
    /*TargetOpcode::G_PREFETCH*//*Label 34*/ GIMT_Encode4(209296),
    /*TargetOpcode::G_BRCOND*//*Label 35*/ GIMT_Encode4(209732), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC*//*Label 36*/ GIMT_Encode4(209760),
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 37*/ GIMT_Encode4(222900),
    /*TargetOpcode::G_INTRINSIC_CONVERGENT*//*Label 38*/ GIMT_Encode4(231242),
    /*TargetOpcode::G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS*//*Label 39*/ GIMT_Encode4(248434),
    /*TargetOpcode::G_ANYEXT*//*Label 40*/ GIMT_Encode4(249649),
    /*TargetOpcode::G_TRUNC*//*Label 41*/ GIMT_Encode4(249978),
    /*TargetOpcode::G_CONSTANT*//*Label 42*/ GIMT_Encode4(250103),
    /*TargetOpcode::G_FCONSTANT*//*Label 43*/ GIMT_Encode4(250210), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SEXT*//*Label 44*/ GIMT_Encode4(250297), GIMT_Encode4(0),
    /*TargetOpcode::G_ZEXT*//*Label 45*/ GIMT_Encode4(251088),
    /*TargetOpcode::G_SHL*//*Label 46*/ GIMT_Encode4(252676),
    /*TargetOpcode::G_LSHR*//*Label 47*/ GIMT_Encode4(253866),
    /*TargetOpcode::G_ASHR*//*Label 48*/ GIMT_Encode4(254818), GIMT_Encode4(0),
    /*TargetOpcode::G_FSHR*//*Label 49*/ GIMT_Encode4(255770),
    /*TargetOpcode::G_ROTR*//*Label 50*/ GIMT_Encode4(255815), GIMT_Encode4(0),
    /*TargetOpcode::G_ICMP*//*Label 51*/ GIMT_Encode4(255847),
    /*TargetOpcode::G_FCMP*//*Label 52*/ GIMT_Encode4(256869), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SELECT*//*Label 53*/ GIMT_Encode4(260164), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_UMULH*//*Label 54*/ GIMT_Encode4(260368),
    /*TargetOpcode::G_SMULH*//*Label 55*/ GIMT_Encode4(260477),
    /*TargetOpcode::G_UADDSAT*//*Label 56*/ GIMT_Encode4(260586),
    /*TargetOpcode::G_SADDSAT*//*Label 57*/ GIMT_Encode4(260852),
    /*TargetOpcode::G_USUBSAT*//*Label 58*/ GIMT_Encode4(261054),
    /*TargetOpcode::G_SSUBSAT*//*Label 59*/ GIMT_Encode4(261320), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FADD*//*Label 60*/ GIMT_Encode4(261522),
    /*TargetOpcode::G_FSUB*//*Label 61*/ GIMT_Encode4(262880),
    /*TargetOpcode::G_FMUL*//*Label 62*/ GIMT_Encode4(263244),
    /*TargetOpcode::G_FMA*//*Label 63*/ GIMT_Encode4(264630),
    /*TargetOpcode::G_FMAD*//*Label 64*/ GIMT_Encode4(266271), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FPOW*//*Label 65*/ GIMT_Encode4(267217), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FEXP2*//*Label 66*/ GIMT_Encode4(267335), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FLOG2*//*Label 67*/ GIMT_Encode4(267558), GIMT_Encode4(0),
    /*TargetOpcode::G_FLDEXP*//*Label 68*/ GIMT_Encode4(267781), GIMT_Encode4(0),
    /*TargetOpcode::G_FNEG*//*Label 69*/ GIMT_Encode4(268074),
    /*TargetOpcode::G_FPEXT*//*Label 70*/ GIMT_Encode4(269943),
    /*TargetOpcode::G_FPTRUNC*//*Label 71*/ GIMT_Encode4(270243),
    /*TargetOpcode::G_FPTOSI*//*Label 72*/ GIMT_Encode4(270881),
    /*TargetOpcode::G_FPTOUI*//*Label 73*/ GIMT_Encode4(271445),
    /*TargetOpcode::G_SITOFP*//*Label 74*/ GIMT_Encode4(272009),
    /*TargetOpcode::G_UITOFP*//*Label 75*/ GIMT_Encode4(272556),
    /*TargetOpcode::G_FABS*//*Label 76*/ GIMT_Encode4(273103),
    /*TargetOpcode::G_FCOPYSIGN*//*Label 77*/ GIMT_Encode4(273907),
    /*TargetOpcode::G_IS_FPCLASS*//*Label 78*/ GIMT_Encode4(274464),
    /*TargetOpcode::G_FCANONICALIZE*//*Label 79*/ GIMT_Encode4(274733),
    /*TargetOpcode::G_FMINNUM*//*Label 80*/ GIMT_Encode4(275933),
    /*TargetOpcode::G_FMAXNUM*//*Label 81*/ GIMT_Encode4(312272),
    /*TargetOpcode::G_FMINNUM_IEEE*//*Label 82*/ GIMT_Encode4(348611),
    /*TargetOpcode::G_FMAXNUM_IEEE*//*Label 83*/ GIMT_Encode4(384950),
    /*TargetOpcode::G_FMINIMUM*//*Label 84*/ GIMT_Encode4(421289),
    /*TargetOpcode::G_FMAXIMUM*//*Label 85*/ GIMT_Encode4(422759), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_GET_FPMODE*//*Label 86*/ GIMT_Encode4(424229), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_PTR_ADD*//*Label 87*/ GIMT_Encode4(424353), GIMT_Encode4(0),
    /*TargetOpcode::G_SMIN*//*Label 88*/ GIMT_Encode4(424430),
    /*TargetOpcode::G_SMAX*//*Label 89*/ GIMT_Encode4(427534),
    /*TargetOpcode::G_UMIN*//*Label 90*/ GIMT_Encode4(430800),
    /*TargetOpcode::G_UMAX*//*Label 91*/ GIMT_Encode4(433904),
    /*TargetOpcode::G_ABS*//*Label 92*/ GIMT_Encode4(437008), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BR*//*Label 93*/ GIMT_Encode4(437145), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_CTTZ_ZERO_UNDEF*//*Label 94*/ GIMT_Encode4(437179), GIMT_Encode4(0),
    /*TargetOpcode::G_CTLZ_ZERO_UNDEF*//*Label 95*/ GIMT_Encode4(437278),
    /*TargetOpcode::G_CTPOP*//*Label 96*/ GIMT_Encode4(437380),
    /*TargetOpcode::G_BSWAP*//*Label 97*/ GIMT_Encode4(437592),
    /*TargetOpcode::G_BITREVERSE*//*Label 98*/ GIMT_Encode4(438539),
    /*TargetOpcode::G_FCEIL*//*Label 99*/ GIMT_Encode4(438787), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FSQRT*//*Label 100*/ GIMT_Encode4(439115),
    /*TargetOpcode::G_FFLOOR*//*Label 101*/ GIMT_Encode4(439407), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FADD*//*Label 102*/ GIMT_Encode4(439921),
    /*TargetOpcode::G_STRICT_FSUB*//*Label 103*/ GIMT_Encode4(440883),
    /*TargetOpcode::G_STRICT_FMUL*//*Label 104*/ GIMT_Encode4(441247), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FMA*//*Label 105*/ GIMT_Encode4(442515), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FLDEXP*//*Label 106*/ GIMT_Encode4(443403), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*AMDGPU::G_AMDGPU_ATOMIC_CMPXCHG*//*Label 107*/ GIMT_Encode4(443696),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_ADD*//*Label 108*/ GIMT_Encode4(445976),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_AND*//*Label 109*/ GIMT_Encode4(448360),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_CMPSWAP*//*Label 110*/ GIMT_Encode4(450744),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_COND_SUB_U32*//*Label 111*/ GIMT_Encode4(455038),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_DEC*//*Label 112*/ GIMT_Encode4(455655),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_FADD*//*Label 113*/ GIMT_Encode4(458039),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_FMAX*//*Label 114*/ GIMT_Encode4(462865),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_FMIN*//*Label 115*/ GIMT_Encode4(466481),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_INC*//*Label 116*/ GIMT_Encode4(470097),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_OR*//*Label 117*/ GIMT_Encode4(472481),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SMAX*//*Label 118*/ GIMT_Encode4(474865),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SMIN*//*Label 119*/ GIMT_Encode4(477249),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SUB*//*Label 120*/ GIMT_Encode4(479633),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SWAP*//*Label 121*/ GIMT_Encode4(482017),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_UMAX*//*Label 122*/ GIMT_Encode4(485561),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_UMIN*//*Label 123*/ GIMT_Encode4(487945),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_XOR*//*Label 124*/ GIMT_Encode4(490329),
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD*//*Label 125*/ GIMT_Encode4(492713),
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_FORMAT*//*Label 126*/ GIMT_Encode4(508635),
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_FORMAT_D16*//*Label 127*/ GIMT_Encode4(513543),
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_FORMAT_TFE*//*Label 128*/ GIMT_Encode4(521288),
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SBYTE*//*Label 129*/ GIMT_Encode4(523808),
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SBYTE_TFE*//*Label 130*/ GIMT_Encode4(524414),
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SSHORT*//*Label 131*/ GIMT_Encode4(525020),
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SSHORT_TFE*//*Label 132*/ GIMT_Encode4(525626),
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_TFE*//*Label 133*/ GIMT_Encode4(526232),
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_UBYTE*//*Label 134*/ GIMT_Encode4(528752),
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_UBYTE_TFE*//*Label 135*/ GIMT_Encode4(529358),
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_USHORT*//*Label 136*/ GIMT_Encode4(529964),
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_USHORT_TFE*//*Label 137*/ GIMT_Encode4(530570),
    /*AMDGPU::G_AMDGPU_BUFFER_STORE*//*Label 138*/ GIMT_Encode4(531176),
    /*AMDGPU::G_AMDGPU_BUFFER_STORE_BYTE*//*Label 139*/ GIMT_Encode4(547042),
    /*AMDGPU::G_AMDGPU_BUFFER_STORE_FORMAT*//*Label 140*/ GIMT_Encode4(547644),
    /*AMDGPU::G_AMDGPU_BUFFER_STORE_FORMAT_D16*//*Label 141*/ GIMT_Encode4(553132),
    /*AMDGPU::G_AMDGPU_BUFFER_STORE_SHORT*//*Label 142*/ GIMT_Encode4(559397),
    /*AMDGPU::G_AMDGPU_CLAMP*//*Label 143*/ GIMT_Encode4(559999),
    /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE0*//*Label 144*/ GIMT_Encode4(560938),
    /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE1*//*Label 145*/ GIMT_Encode4(560983),
    /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE2*//*Label 146*/ GIMT_Encode4(561028),
    /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE3*//*Label 147*/ GIMT_Encode4(561073),
    /*AMDGPU::G_AMDGPU_CVT_PK_I16_I32*//*Label 148*/ GIMT_Encode4(561118),
    /*AMDGPU::G_AMDGPU_FFBH_U32*//*Label 149*/ GIMT_Encode4(561148),
    /*AMDGPU::G_AMDGPU_FFBL_B32*//*Label 150*/ GIMT_Encode4(561250),
    /*AMDGPU::G_AMDGPU_FMAX_LEGACY*//*Label 151*/ GIMT_Encode4(561349),
    /*AMDGPU::G_AMDGPU_FMED3*//*Label 152*/ GIMT_Encode4(561422),
    /*AMDGPU::G_AMDGPU_FMIN_LEGACY*//*Label 153*/ GIMT_Encode4(561618), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*AMDGPU::G_AMDGPU_RCP_IFLAG*//*Label 154*/ GIMT_Encode4(561691),
    /*AMDGPU::G_AMDGPU_SMED3*//*Label 155*/ GIMT_Encode4(561741),
    /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD*//*Label 156*/ GIMT_Encode4(561889),
    /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD_SBYTE*//*Label 157*/ GIMT_Encode4(564191),
    /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD_SSHORT*//*Label 158*/ GIMT_Encode4(564329),
    /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD_UBYTE*//*Label 159*/ GIMT_Encode4(564467),
    /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD_USHORT*//*Label 160*/ GIMT_Encode4(564605), GIMT_Encode4(0), GIMT_Encode4(0),
    /*AMDGPU::G_AMDGPU_TBUFFER_LOAD_FORMAT*//*Label 161*/ GIMT_Encode4(564743),
    /*AMDGPU::G_AMDGPU_TBUFFER_LOAD_FORMAT_D16*//*Label 162*/ GIMT_Encode4(570227),
    /*AMDGPU::G_AMDGPU_TBUFFER_STORE_FORMAT*//*Label 163*/ GIMT_Encode4(575656),
    /*AMDGPU::G_AMDGPU_TBUFFER_STORE_FORMAT_D16*//*Label 164*/ GIMT_Encode4(581124),
    /*AMDGPU::G_AMDGPU_UMED3*//*Label 165*/ GIMT_Encode4(585729), GIMT_Encode4(0),
    /*AMDGPU::G_FPTRUNC_ROUND_DOWNWARD*//*Label 166*/ GIMT_Encode4(585877),
    /*AMDGPU::G_FPTRUNC_ROUND_UPWARD*//*Label 167*/ GIMT_Encode4(585908),
    // Label 0: @14430
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(7), GIMT_Encode2(12), /*)*//*default:*//*Label 174*/ GIMT_Encode4(18063),
    /*GILLT_s1*//*Label 169*/ GIMT_Encode4(14461),
    /*GILLT_s16*//*Label 170*/ GIMT_Encode4(14580),
    /*GILLT_s32*//*Label 171*/ GIMT_Encode4(14853),
    /*GILLT_s64*//*Label 172*/ GIMT_Encode4(17586),
    /*GILLT_v2s16*//*Label 173*/ GIMT_Encode4(17793),
    // Label 169: @14461
    GIM_Try, /*On fail goto*//*Label 175*/ GIMT_Encode4(14579),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_Try, /*On fail goto*//*Label 176*/ GIMT_Encode4(14500), // Rule ID 7168 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i1] } i1:{ *:[i1] }:$src0, -1:{ *:[i1] })  =>  (S_NOT_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOT_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7168,
        GIR_EraseRootFromParent_Done,
      // Label 176: @14500
      GIM_Try, /*On fail goto*//*Label 177*/ GIMT_Encode4(14528), // Rule ID 7175 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i1] } i1:{ *:[i1] }:$src0, -1:{ *:[i1] })  =>  (S_NOT_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOT_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7175,
        GIR_EraseRootFromParent_Done,
      // Label 177: @14528
      GIM_Try, /*On fail goto*//*Label 178*/ GIMT_Encode4(14553), // Rule ID 7166 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        // (add:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_XOR_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B64),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7166,
        GIR_Done,
      // Label 178: @14553
      GIM_Try, /*On fail goto*//*Label 179*/ GIMT_Encode4(14578), // Rule ID 7173 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        // (add:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_XOR_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B32),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7173,
        GIR_Done,
      // Label 179: @14578
      GIM_Reject,
    // Label 175: @14579
    GIM_Reject,
    // Label 170: @14580
    GIM_Try, /*On fail goto*//*Label 180*/ GIMT_Encode4(14852),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      GIM_Try, /*On fail goto*//*Label 181*/ GIMT_Encode4(14634), // Rule ID 2166 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_isGFX8GFX9),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineIntConst16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>><<X:NegateImm>>:$src1)  =>  (V_SUB_U16_e64:{ *:[i16] } VSrc_b16:{ *:[i16] }:$src0, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>>:$src1))
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2166,
        GIR_EraseRootFromParent_Done,
      // Label 181: @14634
      GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(14682), // Rule ID 2269 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX10Plus),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineIntConst16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>><<X:NegateImm>>:$src1)  =>  (V_SUB_NC_U16_e64:{ *:[i16] } 0:{ *:[i32] }, VSrc_b16:{ *:[i16] }:$src0, 0:{ *:[i32] }, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>>:$src1), 0:{ *:[i1] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2269,
        GIR_EraseRootFromParent_Done,
      // Label 182: @14682
      GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(14728), // Rule ID 2204 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, i16:{ *:[i16] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2204,
        GIR_EraseRootFromParent_Done,
      // Label 183: @14728
      GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(14774), // Rule ID 8126 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i16] } i16:{ *:[i16] }:$src2, (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1))  =>  (V_MAD_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, i16:{ *:[i16] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8126,
        GIR_EraseRootFromParent_Done,
      // Label 184: @14774
      GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(14829), // Rule ID 940 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX10Plus),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
        // (add:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_ADD_NC_U16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_NC_U16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 940,
        GIR_EraseRootFromParent_Done,
      // Label 185: @14829
      GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(14851), // Rule ID 832 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX8GFX9),
        // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_ADD_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_U16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 832,
        GIR_EraseRootFromParent_Done,
      // Label 186: @14851
      GIM_Reject,
    // Label 180: @14852
    GIM_Reject,
    // Label 171: @14853
    GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(17585),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(14957), // Rule ID 2221 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:1:y
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_csh_mask_32),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:1:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24022),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:1:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_24023>>, i32:{ *:[i32] }:$src2:$pred:1:z)<<P:1:Predicate_anonymous_24022>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2221,
        GIR_EraseRootFromParent_Done,
      // Label 188: @14957
      GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(15050), // Rule ID 8129 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:1:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:1:y
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_csh_mask_32),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24022),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:1:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:1:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_24023>>)<<P:1:Predicate_anonymous_24022>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8129,
        GIR_EraseRootFromParent_Done,
      // Label 189: @15050
      GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(15115), // Rule ID 84 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl1_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 1:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl1_add>>  =>  (S_LSHL1_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL1_ADD_U32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 84,
        GIR_EraseRootFromParent_Done,
      // Label 190: @15115
      GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(15180), // Rule ID 85 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl2_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 2:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl2_add>>  =>  (S_LSHL2_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL2_ADD_U32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 85,
        GIR_EraseRootFromParent_Done,
      // Label 191: @15180
      GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(15245), // Rule ID 86 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl3_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 3:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl3_add>>  =>  (S_LSHL3_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL3_ADD_U32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 86,
        GIR_EraseRootFromParent_Done,
      // Label 192: @15245
      GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(15310), // Rule ID 87 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 4,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl4_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 4:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl4_add>>  =>  (S_LSHL4_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL4_ADD_U32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 87,
        GIR_EraseRootFromParent_Done,
      // Label 193: @15310
      GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(15375), // Rule ID 8046 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl1_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 1:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl1_add>>  =>  (S_LSHL1_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL1_ADD_U32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8046,
        GIR_EraseRootFromParent_Done,
      // Label 194: @15375
      GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(15440), // Rule ID 8047 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl2_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 2:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl2_add>>  =>  (S_LSHL2_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL2_ADD_U32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8047,
        GIR_EraseRootFromParent_Done,
      // Label 195: @15440
      GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(15505), // Rule ID 8048 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl3_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 3:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl3_add>>  =>  (S_LSHL3_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL3_ADD_U32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8048,
        GIR_EraseRootFromParent_Done,
      // Label 196: @15505
      GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(15570), // Rule ID 8049 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 4,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl4_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 4:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl4_add>>  =>  (S_LSHL4_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL4_ADD_U32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8049,
        GIR_EraseRootFromParent_Done,
      // Label 197: @15570
      GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(15735), // Rule ID 8139 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:11:z
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:11:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:11:y
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24053),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } VGPR_32:{ *:[i32] }:$src2:$pred:11:z, (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:11:x, i32:{ *:[i32] }:$src1:$pred:11:y)<<P:Predicate_anonymous_24054>>)<<P:11:Predicate_anonymous_24053>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        // GIR_Coverage, 8139,
        GIR_EraseRootFromParent_Done,
      // Label 198: @15735
      GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(15900), // Rule ID 8143 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:14:z
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:14:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:14:y
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24053),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } VGPR_32:{ *:[i32] }:$src2:$pred:14:z, (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:14:x, i32:{ *:[i32] }:$src1:$pred:14:y)<<P:Predicate_anonymous_24054>>)<<P:14:Predicate_anonymous_24053>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        // GIR_Coverage, 8143,
        GIR_EraseRootFromParent_Done,
      // Label 199: @15900
      GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(15965), // Rule ID 2224 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:3:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:3:y
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:3:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24028),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:3:x, i32:{ *:[i32] }:$src1:$pred:3:y)<<P:Predicate_anonymous_24026>>, i32:{ *:[i32] }:$src2:$pred:3:z)<<P:3:Predicate_anonymous_24028>>  =>  (V_ADD3_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD3_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2224,
        GIR_EraseRootFromParent_Done,
      // Label 200: @15965
      GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(16130), // Rule ID 2239 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:11:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:11:y
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:11:z
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24053),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:11:x, i32:{ *:[i32] }:$src1:$pred:11:y)<<P:Predicate_anonymous_24054>>, VGPR_32:{ *:[i32] }:$src2:$pred:11:z)<<P:11:Predicate_anonymous_24053>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        // GIR_Coverage, 2239,
        GIR_EraseRootFromParent_Done,
      // Label 201: @16130
      GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(16295), // Rule ID 2244 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:14:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:14:y
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:14:z
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24053),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:14:x, i32:{ *:[i32] }:$src1:$pred:14:y)<<P:Predicate_anonymous_24054>>, VGPR_32:{ *:[i32] }:$src2:$pred:14:z)<<P:14:Predicate_anonymous_24053>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        // GIR_Coverage, 2244,
        GIR_EraseRootFromParent_Done,
      // Label 202: @16295
      GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(16456), // Rule ID 2238 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:10:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:10:y
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:10:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24053),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:10:x, i32:{ *:[i32] }:$src1:$pred:10:y)<<P:Predicate_anonymous_24054>>, i32:{ *:[i32] }:$src2:$pred:10:z)<<P:10:Predicate_anonymous_24053>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } SReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::SReg_32_XEXEC_HI_and_SReg_32_XM0RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::SReg_32_XM0RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        // GIR_Coverage, 2238,
        GIR_EraseRootFromParent_Done,
      // Label 203: @16456
      GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(16617), // Rule ID 2243 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:13:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:13:y
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:13:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24053),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:13:x, i32:{ *:[i32] }:$src1:$pred:13:y)<<P:Predicate_anonymous_24054>>, i32:{ *:[i32] }:$src2:$pred:13:z)<<P:13:Predicate_anonymous_24053>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } SReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::SReg_32_XEXEC_HI_and_SReg_32_XM0RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::SReg_32_XM0RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        // GIR_Coverage, 2243,
        GIR_EraseRootFromParent_Done,
      // Label 204: @16617
      GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(16682), // Rule ID 2220 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:1:y
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:1:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24022),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, i32:{ *:[i32] }:$src1:$pred:1:y)<<P:Predicate_anonymous_24023>>, i32:{ *:[i32] }:$src2:$pred:1:z)<<P:1:Predicate_anonymous_24022>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2220,
        GIR_EraseRootFromParent_Done,
      // Label 205: @16682
      GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(16747), // Rule ID 2230 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:8:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:8:y
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:8:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24041),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:8:x, i32:{ *:[i32] }:$src1:$pred:8:y)<<P:Predicate_anonymous_24042>>, i32:{ *:[i32] }:$src2:$pred:8:z)<<P:8:Predicate_anonymous_24041>>  =>  (V_XAD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_XAD_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2230,
        GIR_EraseRootFromParent_Done,
      // Label 206: @16747
      GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(16812), // Rule ID 8130 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:3:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:3:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:3:y
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24028),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:3:z, (add:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:3:x, i32:{ *:[i32] }:$src1:$pred:3:y)<<P:Predicate_anonymous_24026>>)<<P:3:Predicate_anonymous_24028>>  =>  (V_ADD3_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD3_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8130,
        GIR_EraseRootFromParent_Done,
      // Label 207: @16812
      GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(16973), // Rule ID 8138 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:10:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:10:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:10:y
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24053),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:10:z, (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:10:x, i32:{ *:[i32] }:$src1:$pred:10:y)<<P:Predicate_anonymous_24054>>)<<P:10:Predicate_anonymous_24053>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } SReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::SReg_32_XEXEC_HI_and_SReg_32_XM0RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::SReg_32_XM0RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        // GIR_Coverage, 8138,
        GIR_EraseRootFromParent_Done,
      // Label 208: @16973
      GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(17134), // Rule ID 8142 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:13:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:13:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:13:y
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24053),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:13:z, (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:13:x, i32:{ *:[i32] }:$src1:$pred:13:y)<<P:Predicate_anonymous_24054>>)<<P:13:Predicate_anonymous_24053>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } SReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::SReg_32_XEXEC_HI_and_SReg_32_XM0RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::SReg_32_XM0RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        // GIR_Coverage, 8142,
        GIR_EraseRootFromParent_Done,
      // Label 209: @17134
      GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(17199), // Rule ID 8128 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:1:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:1:y
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24022),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:1:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, i32:{ *:[i32] }:$src1:$pred:1:y)<<P:Predicate_anonymous_24023>>)<<P:1:Predicate_anonymous_24022>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8128,
        GIR_EraseRootFromParent_Done,
      // Label 210: @17199
      GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(17264), // Rule ID 8135 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:8:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:8:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:8:y
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24041),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:8:z, (xor:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:8:x, i32:{ *:[i32] }:$src1:$pred:8:y)<<P:Predicate_anonymous_24042>>)<<P:8:Predicate_anonymous_24041>>  =>  (V_XAD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_XAD_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8135,
        GIR_EraseRootFromParent_Done,
      // Label 211: @17264
      GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(17308), // Rule ID 7294 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineConst32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18497),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>><<X:NegateImm>>:$src1)<<P:Predicate_anonymous_18497>>  =>  (S_SUB_I32:{ *:[i32] }:{ *:[i1] } SReg_32:{ *:[i32] }:$src0, (NegateImm:{ *:[i1 i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>>:$src1))
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_SUB_I32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7294,
        GIR_EraseRootFromParent_Done,
      // Label 212: @17308
      GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(17355), // Rule ID 7295 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAddNoCarryInsts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineConst32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23239),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>><<X:NegateImm>>:$src1)<<P:Predicate_anonymous_23239>>  =>  (V_SUB_U32_e64:{ *:[i32] } VS_32:{ *:[i32] }:$src0, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>>:$src1))
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7295,
        GIR_EraseRootFromParent_Done,
      // Label 213: @17355
      GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(17410), // Rule ID 7296 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasAddNoCarryInsts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineConst32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23239),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>><<X:NegateImm>>:$src1)<<P:Predicate_anonymous_23239>>  =>  (V_SUB_CO_U32_e64:{ *:[i32] }:{ *:[i1] } VS_32:{ *:[i32] }:$src0, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>>:$src1))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_CO_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7296,
        GIR_EraseRootFromParent_Done,
      // Label 214: @17410
      GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(17444), // Rule ID 45 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18497),
        // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_18497>>  =>  (S_ADD_I32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_ADD_I32),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 45,
        GIR_Done,
      // Label 215: @17444
      GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(17474), // Rule ID 2132 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAddNoCarryInsts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23239),
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_23239>>  =>  (V_ADD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2132,
        GIR_EraseRootFromParent_Done,
      // Label 216: @17474
      GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(17512), // Rule ID 2134 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX6GFX7GFX8GFX9),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23239),
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_23239>>  =>  (V_ADD_CO_U32_e64:{ *:[i32] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, 0:{ *:[i1] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_CO_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2134,
        GIR_EraseRootFromParent_Done,
      // Label 217: @17512
      GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(17548), // Rule ID 754 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CTPOP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (ctpop:{ *:[i32] } i32:{ *:[i32] }:$src0), i32:{ *:[i32] }:$src1)  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 754,
        GIR_EraseRootFromParent_Done,
      // Label 218: @17548
      GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(17584), // Rule ID 8061 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CTPOP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src1, (ctpop:{ *:[i32] } i32:{ *:[i32] }:$src0))  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8061,
        GIR_EraseRootFromParent_Done,
      // Label 219: @17584
      GIM_Reject,
    // Label 187: @17585
    GIM_Reject,
    // Label 172: @17586
    GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(17792),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(17666), // Rule ID 2232 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX940Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:9:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:9:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl_0_to_4),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:9:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24045),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (shl:{ *:[i64] } i64:{ *:[i64] }:$src0:$pred:9:x, i32:{ *:[i32] }:$src1:$pred:9:y)<<P:Predicate_shl_0_to_4>><<P:Predicate_anonymous_24046>>, i64:{ *:[i64] }:$src2:$pred:9:z)<<P:9:Predicate_anonymous_24045>>  =>  (V_LSHL_ADD_U64_e64:{ *:[i64] } VSrc_b64:{ *:[i64] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U64_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2232,
        GIR_EraseRootFromParent_Done,
      // Label 221: @17666
      GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(17735), // Rule ID 8136 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX940Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:9:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:9:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:9:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl_0_to_4),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24045),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } i64:{ *:[i64] }:$src2:$pred:9:z, (shl:{ *:[i64] } i64:{ *:[i64] }:$src0:$pred:9:x, i32:{ *:[i32] }:$src1:$pred:9:y)<<P:Predicate_shl_0_to_4>><<P:Predicate_anonymous_24046>>)<<P:9:Predicate_anonymous_24045>>  =>  (V_LSHL_ADD_U64_e64:{ *:[i64] } VSrc_b64:{ *:[i64] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U64_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8136,
        GIR_EraseRootFromParent_Done,
      // Label 222: @17735
      GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(17765), // Rule ID 1114 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23239),
        // (add:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_23239>>  =>  (V_ADD_U64_PSEUDO:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_U64_PSEUDO),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::VCC), GIMT_Encode2(RegState::Dead),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1114,
        GIR_Done,
      // Label 223: @17765
      GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(17791), // Rule ID 1116 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18497),
        // (add:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_18497>>  =>  (S_ADD_U64_PSEUDO:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_ADD_U64_PSEUDO),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1116,
        GIR_Done,
      // Label 224: @17791
      GIM_Reject,
    // Label 220: @17792
    GIM_Reject,
    // Label 173: @17793
    GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(18062),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(17904), // Rule ID 8113 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(2), GIMT_Encode2(GICP_gi_vop3pmods),
        // (add:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src2, i32:{ *:[i32] }:$src2_modifiers), (mul:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers)))  =>  (V_PK_MAD_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src2_modifiers, v2i16:{ *:[v2i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_MAD_U16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src0_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src0
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/1, // src1_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/0, // src1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src2_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8113,
        GIR_EraseRootFromParent_Done,
      // Label 226: @17904
      GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(18000), // Rule ID 954 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(2), GIMT_Encode2(GICP_gi_vop3pmods),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
        // (add:{ *:[v2i16] } (mul:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers)), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src2, i32:{ *:[i32] }:$src2_modifiers))  =>  (V_PK_MAD_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src2_modifiers, v2i16:{ *:[v2i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_MAD_U16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/1, // src2_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/0, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 954,
        GIR_EraseRootFromParent_Done,
      // Label 227: @18000
      GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(18061), // Rule ID 965 //
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
        // (add:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_PK_ADD_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_ADD_U16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 965,
        GIR_EraseRootFromParent_Done,
      // Label 228: @18061
      GIM_Reject,
    // Label 225: @18062
    GIM_Reject,
    // Label 174: @18063
    GIM_Reject,
    // Label 1: @18064
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(7), GIMT_Encode2(12), /*)*//*default:*//*Label 234*/ GIMT_Encode4(18564),
    /*GILLT_s1*//*Label 229*/ GIMT_Encode4(18095),
    /*GILLT_s16*//*Label 230*/ GIMT_Encode4(18214),
    /*GILLT_s32*//*Label 231*/ GIMT_Encode4(18308),
    /*GILLT_s64*//*Label 232*/ GIMT_Encode4(18423),
    /*GILLT_v2s16*//*Label 233*/ GIMT_Encode4(18492),
    // Label 229: @18095
    GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(18213),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(18134), // Rule ID 7169 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (sub:{ *:[i1] } i1:{ *:[i1] }:$src0, -1:{ *:[i1] })  =>  (S_NOT_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOT_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7169,
        GIR_EraseRootFromParent_Done,
      // Label 236: @18134
      GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(18162), // Rule ID 7176 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (sub:{ *:[i1] } i1:{ *:[i1] }:$src0, -1:{ *:[i1] })  =>  (S_NOT_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOT_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7176,
        GIR_EraseRootFromParent_Done,
      // Label 237: @18162
      GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(18187), // Rule ID 7167 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        // (sub:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_XOR_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B64),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7167,
        GIR_Done,
      // Label 238: @18187
      GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(18212), // Rule ID 7174 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        // (sub:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_XOR_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B32),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7174,
        GIR_Done,
      // Label 239: @18212
      GIM_Reject,
    // Label 235: @18213
    GIM_Reject,
    // Label 230: @18214
    GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(18307),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(18284), // Rule ID 941 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX10Plus),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
        // (sub:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_SUB_NC_U16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 941,
        GIR_EraseRootFromParent_Done,
      // Label 241: @18284
      GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(18306), // Rule ID 833 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX8GFX9),
        // (sub:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_SUB_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 833,
        GIR_EraseRootFromParent_Done,
      // Label 242: @18306
      GIM_Reject,
    // Label 240: @18307
    GIM_Reject,
    // Label 231: @18308
    GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(18422),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(18353), // Rule ID 46 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18498),
        // (sub:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_18498>>  =>  (S_SUB_I32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_SUB_I32),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 46,
        GIR_Done,
      // Label 244: @18353
      GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(18383), // Rule ID 2133 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAddNoCarryInsts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23241),
        // (sub:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_23241>>  =>  (V_SUB_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2133,
        GIR_EraseRootFromParent_Done,
      // Label 245: @18383
      GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(18421), // Rule ID 2135 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX6GFX7GFX8GFX9),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23241),
        // (sub:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_23241>>  =>  (V_SUB_CO_U32_e64:{ *:[i32] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, 0:{ *:[i1] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_CO_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2135,
        GIR_EraseRootFromParent_Done,
      // Label 246: @18421
      GIM_Reject,
    // Label 243: @18422
    GIM_Reject,
    // Label 232: @18423
    GIM_Try, /*On fail goto*//*Label 247*/ GIMT_Encode4(18491),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 248*/ GIMT_Encode4(18464), // Rule ID 1115 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23241),
        // (sub:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_23241>>  =>  (V_SUB_U64_PSEUDO:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U64_PSEUDO),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::VCC), GIMT_Encode2(RegState::Dead),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1115,
        GIR_Done,
      // Label 248: @18464
      GIM_Try, /*On fail goto*//*Label 249*/ GIMT_Encode4(18490), // Rule ID 1117 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18498),
        // (sub:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_18498>>  =>  (S_SUB_U64_PSEUDO:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_SUB_U64_PSEUDO),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1117,
        GIR_Done,
      // Label 249: @18490
      GIM_Reject,
    // Label 247: @18491
    GIM_Reject,
    // Label 233: @18492
    GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(18563), // Rule ID 973 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
      // (sub:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_PK_SUB_I16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_SUB_I16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 973,
      GIR_EraseRootFromParent_Done,
    // Label 250: @18563
    GIM_Reject,
    // Label 234: @18564
    GIM_Reject,
    // Label 2: @18565
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(8), GIMT_Encode2(12), /*)*//*default:*//*Label 255*/ GIMT_Encode4(18850),
    /*GILLT_s16*//*Label 251*/ GIMT_Encode4(18592),
    /*GILLT_s32*//*Label 252*/ GIMT_Encode4(18647),
    /*GILLT_s64*//*Label 253*/ GIMT_Encode4(18748),
    /*GILLT_v2s16*//*Label 254*/ GIMT_Encode4(18778),
    // Label 251: @18592
    GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(18646),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(18626), // Rule ID 807 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_NotHasTrue16BitInsts),
        // (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_MUL_LO_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U16_e64),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 807,
        GIR_Done,
      // Label 257: @18626
      GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(18645), // Rule ID 808 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTrue16BitInsts),
        // (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_MUL_LO_U16_t16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U16_t16_e64),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 808,
        GIR_Done,
      // Label 258: @18645
      GIM_Reject,
    // Label 256: @18646
    GIM_Reject,
    // Label 252: @18647
    GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(18747),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(18678), // Rule ID 83 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18505),
        // (mul:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_18505>>  =>  (S_MUL_I32:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_MUL_I32),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 83,
        GIR_Done,
      // Label 260: @18678
      GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(18712), // Rule ID 861 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23638),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3mods0),
        // (mul:{ *:[i32] } (VOP3Mods0:{ *:[i32] } i32:{ *:[i32] }:$src0), i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_23638>>  =>  (V_MUL_LO_U32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 861,
        GIR_EraseRootFromParent_Done,
      // Label 261: @18712
      GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(18746), // Rule ID 8101 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23638),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3mods0),
        // (mul:{ *:[i32] } i32:{ *:[i32] }:$src1, (VOP3Mods0:{ *:[i32] } i32:{ *:[i32] }:$src0))<<P:Predicate_anonymous_23638>>  =>  (V_MUL_LO_U32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8101,
        GIR_EraseRootFromParent_Done,
      // Label 262: @18746
      GIM_Reject,
    // Label 259: @18747
    GIM_Reject,
    // Label 253: @18748
    GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(18777), // Rule ID 53 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX12Plus),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18505),
      // (mul:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_18505>>  =>  (S_MUL_U64:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_MUL_U64),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 53,
      GIR_Done,
    // Label 263: @18777
    GIM_Reject,
    // Label 254: @18778
    GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(18849), // Rule ID 966 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
      // (mul:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_PK_MUL_LO_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_MUL_LO_U16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 966,
      GIR_EraseRootFromParent_Done,
    // Label 264: @18849
    GIM_Reject,
    // Label 255: @18850
    GIM_Reject,
    // Label 3: @18851
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(7), GIMT_Encode2(17), /*)*//*default:*//*Label 272*/ GIMT_Encode4(19806),
    /*GILLT_s1*//*Label 265*/ GIMT_Encode4(18902),
    /*GILLT_s16*//*Label 266*/ GIMT_Encode4(18965),
    /*GILLT_s32*//*Label 267*/ GIMT_Encode4(19123),
    /*GILLT_s64*//*Label 268*/ GIMT_Encode4(19284),
    /*GILLT_v2s16*//*Label 269*/ GIMT_Encode4(19409),
    /*GILLT_v2s32*//*Label 270*/ GIMT_Encode4(19560), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v4s16*//*Label 271*/ GIMT_Encode4(19683),
    // Label 265: @18902
    GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(18964),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(18938), // Rule ID 7163 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        // (and:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_AND_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_AND_B64),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7163,
        GIR_Done,
      // Label 274: @18938
      GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(18963), // Rule ID 7170 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        // (and:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_AND_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_AND_B32),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7170,
        GIR_Done,
      // Label 275: @18963
      GIM_Reject,
    // Label 273: @18964
    GIM_Reject,
    // Label 266: @18965
    GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(19122),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(19027), // Rule ID 8115 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18506),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i16] } (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] }), i16:{ *:[i16] }:$src0)<<P:Predicate_anonymous_18506>>  =>  (S_ANDN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8115,
        GIR_EraseRootFromParent_Done,
      // Label 277: @19027
      GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(19078), // Rule ID 1657 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18506),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] }))<<P:Predicate_anonymous_18506>>  =>  (S_ANDN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1657,
        GIR_EraseRootFromParent_Done,
      // Label 278: @19078
      GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(19098), // Rule ID 2160 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_AND_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B32_e64),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2160,
        GIR_Done,
      // Label 279: @19098
      GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(19121), // Rule ID 829 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX11Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_AND_B16_t16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B16_t16_e64),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 829,
        GIR_Done,
      // Label 280: @19121
      GIM_Reject,
    // Label 276: @19122
    GIM_Reject,
    // Label 267: @19123
    GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(19283),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(19185), // Rule ID 8042 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18506),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] }), i32:{ *:[i32] }:$src0)<<P:Predicate_anonymous_18506>>  =>  (S_ANDN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8042,
        GIR_EraseRootFromParent_Done,
      // Label 282: @19185
      GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(19236), // Rule ID 66 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18506),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } i32:{ *:[i32] }:$src0, (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] }))<<P:Predicate_anonymous_18506>>  =>  (S_ANDN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 66,
        GIR_EraseRootFromParent_Done,
      // Label 283: @19236
      GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(19262), // Rule ID 54 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18506),
        // (and:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_18506>>  =>  (S_AND_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_AND_B32),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54,
        GIR_Done,
      // Label 284: @19262
      GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(19282), // Rule ID 751 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (and:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_AND_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B32_e64),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 751,
        GIR_Done,
      // Label 285: @19282
      GIM_Reject,
    // Label 281: @19283
    GIM_Reject,
    // Label 268: @19284
    GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(19408),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18506),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
      GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(19346), // Rule ID 8043 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$src1, -1:{ *:[i64] }), i64:{ *:[i64] }:$src0)<<P:Predicate_anonymous_18506>>  =>  (S_ANDN2_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8043,
        GIR_EraseRootFromParent_Done,
      // Label 287: @19346
      GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(19389), // Rule ID 67 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } i64:{ *:[i64] }:$src0, (xor:{ *:[i64] } i64:{ *:[i64] }:$src1, -1:{ *:[i64] }))<<P:Predicate_anonymous_18506>>  =>  (S_ANDN2_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 67,
        GIR_EraseRootFromParent_Done,
      // Label 288: @19389
      GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(19407), // Rule ID 55 //
        // (and:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_18506>>  =>  (S_AND_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_AND_B64),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 55,
        GIR_Done,
      // Label 289: @19407
      GIM_Reject,
    // Label 286: @19408
    GIM_Reject,
    // Label 269: @19409
    GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(19559),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(19479), // Rule ID 8116 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18506),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v2i16] } (xor:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, immAllOnesV:{ *:[v2i16] }), v2i16:{ *:[v2i16] }:$src0)<<P:Predicate_anonymous_18506>>  =>  (S_ANDN2_B32:{ *:[v2i16] }:{ *:[i1] } SSrc_b32:{ *:[v2i16] }:$src0, SSrc_b32:{ *:[v2i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8116,
        GIR_EraseRootFromParent_Done,
      // Label 291: @19479
      GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(19538), // Rule ID 1658 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18506),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, (xor:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, immAllOnesV:{ *:[v2i16] }))<<P:Predicate_anonymous_18506>>  =>  (S_ANDN2_B32:{ *:[v2i16] }:{ *:[i1] } SSrc_b32:{ *:[v2i16] }:$src0, SSrc_b32:{ *:[v2i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1658,
        GIR_EraseRootFromParent_Done,
      // Label 292: @19538
      GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(19558), // Rule ID 2163 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (and:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1)  =>  (V_AND_B32_e64:{ *:[v2i16] } VSrc_b32:{ *:[v2i16] }:$src0, VSrc_b32:{ *:[v2i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B32_e64),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2163,
        GIR_Done,
      // Label 293: @19558
      GIM_Reject,
    // Label 290: @19559
    GIM_Reject,
    // Label 270: @19560
    GIM_Try, /*On fail goto*//*Label 294*/ GIMT_Encode4(19682),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18506),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
      GIM_Try, /*On fail goto*//*Label 295*/ GIMT_Encode4(19630), // Rule ID 8118 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v2i32] } (xor:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src1, immAllOnesV:{ *:[v2i32] }), v2i32:{ *:[v2i32] }:$src0)<<P:Predicate_anonymous_18506>>  =>  (S_ANDN2_B64:{ *:[v2i32] }:{ *:[i1] } SSrc_b64:{ *:[v2i32] }:$src0, SSrc_b64:{ *:[v2i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8118,
        GIR_EraseRootFromParent_Done,
      // Label 295: @19630
      GIM_Try, /*On fail goto*//*Label 296*/ GIMT_Encode4(19681), // Rule ID 1660 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src0, (xor:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src1, immAllOnesV:{ *:[v2i32] }))<<P:Predicate_anonymous_18506>>  =>  (S_ANDN2_B64:{ *:[v2i32] }:{ *:[i1] } SSrc_b64:{ *:[v2i32] }:$src0, SSrc_b64:{ *:[v2i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1660,
        GIR_EraseRootFromParent_Done,
      // Label 296: @19681
      GIM_Reject,
    // Label 294: @19682
    GIM_Reject,
    // Label 271: @19683
    GIM_Try, /*On fail goto*//*Label 297*/ GIMT_Encode4(19805),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18506),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
      GIM_Try, /*On fail goto*//*Label 298*/ GIMT_Encode4(19753), // Rule ID 8117 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v4i16] } (xor:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src1, immAllOnesV:{ *:[v4i16] }), v4i16:{ *:[v4i16] }:$src0)<<P:Predicate_anonymous_18506>>  =>  (S_ANDN2_B64:{ *:[v4i16] }:{ *:[i1] } SSrc_b64:{ *:[v4i16] }:$src0, SSrc_b64:{ *:[v4i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8117,
        GIR_EraseRootFromParent_Done,
      // Label 298: @19753
      GIM_Try, /*On fail goto*//*Label 299*/ GIMT_Encode4(19804), // Rule ID 1659 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src0, (xor:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src1, immAllOnesV:{ *:[v4i16] }))<<P:Predicate_anonymous_18506>>  =>  (S_ANDN2_B64:{ *:[v4i16] }:{ *:[i1] } SSrc_b64:{ *:[v4i16] }:$src0, SSrc_b64:{ *:[v4i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1659,
        GIR_EraseRootFromParent_Done,
      // Label 299: @19804
      GIM_Reject,
    // Label 297: @19805
    GIM_Reject,
    // Label 272: @19806
    GIM_Reject,
    // Label 4: @19807
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(7), GIMT_Encode2(17), /*)*//*default:*//*Label 307*/ GIMT_Encode4(34274),
    /*GILLT_s1*//*Label 300*/ GIMT_Encode4(19858),
    /*GILLT_s16*//*Label 301*/ GIMT_Encode4(19921),
    /*GILLT_s32*//*Label 302*/ GIMT_Encode4(20079),
    /*GILLT_s64*//*Label 303*/ GIMT_Encode4(24688),
    /*GILLT_v2s16*//*Label 304*/ GIMT_Encode4(33877),
    /*GILLT_v2s32*//*Label 305*/ GIMT_Encode4(34028), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v4s16*//*Label 306*/ GIMT_Encode4(34151),
    // Label 300: @19858
    GIM_Try, /*On fail goto*//*Label 308*/ GIMT_Encode4(19920),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_Try, /*On fail goto*//*Label 309*/ GIMT_Encode4(19894), // Rule ID 7164 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        // (or:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_OR_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_OR_B64),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7164,
        GIR_Done,
      // Label 309: @19894
      GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(19919), // Rule ID 7171 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        // (or:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_OR_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_OR_B32),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7171,
        GIR_Done,
      // Label 310: @19919
      GIM_Reject,
    // Label 308: @19920
    GIM_Reject,
    // Label 301: @19921
    GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(20078),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(19983), // Rule ID 8119 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18507),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i16] } (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] }), i16:{ *:[i16] }:$src0)<<P:Predicate_anonymous_18507>>  =>  (S_ORN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8119,
        GIR_EraseRootFromParent_Done,
      // Label 312: @19983
      GIM_Try, /*On fail goto*//*Label 313*/ GIMT_Encode4(20034), // Rule ID 1661 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18507),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] }))<<P:Predicate_anonymous_18507>>  =>  (S_ORN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1661,
        GIR_EraseRootFromParent_Done,
      // Label 313: @20034
      GIM_Try, /*On fail goto*//*Label 314*/ GIMT_Encode4(20054), // Rule ID 2161 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_OR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR_B32_e64),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2161,
        GIR_Done,
      // Label 314: @20054
      GIM_Try, /*On fail goto*//*Label 315*/ GIMT_Encode4(20077), // Rule ID 830 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX11Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_OR_B16_t16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR_B16_t16_e64),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 830,
        GIR_Done,
      // Label 315: @20077
      GIM_Reject,
    // Label 311: @20078
    GIM_Reject,
    // Label 302: @20079
    GIM_Try, /*On fail goto*//*Label 316*/ GIMT_Encode4(24687),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 317*/ GIMT_Encode4(20228), // Rule ID 10797 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_23251>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/3, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10797,
        GIR_EraseRootFromParent_Done,
      // Label 317: @20228
      GIM_Try, /*On fail goto*//*Label 318*/ GIMT_Encode4(20366), // Rule ID 10796 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_23251>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/3, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10796,
        GIR_EraseRootFromParent_Done,
      // Label 318: @20366
      GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(20504), // Rule ID 10795 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_23251>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/3, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10795,
        GIR_EraseRootFromParent_Done,
      // Label 319: @20504
      GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(20642), // Rule ID 10794 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })), (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_23251>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/3, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10794,
        GIR_EraseRootFromParent_Done,
      // Label 320: @20642
      GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(20780), // Rule ID 10791 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_23251>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10791,
        GIR_EraseRootFromParent_Done,
      // Label 321: @20780
      GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(20918), // Rule ID 10793 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_23251>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10793,
        GIR_EraseRootFromParent_Done,
      // Label 322: @20918
      GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(21056), // Rule ID 7082 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x), (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })))<<P:Predicate_anonymous_23251>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7082,
        GIR_EraseRootFromParent_Done,
      // Label 323: @21056
      GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(21194), // Rule ID 10792 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })))<<P:Predicate_anonymous_23251>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10792,
        GIR_EraseRootFromParent_Done,
      // Label 324: @21194
      GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(21287), // Rule ID 2227 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:5:y
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_csh_mask_32),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:5:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24033),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:5:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:5:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_24023>>, i32:{ *:[i32] }:$src2:$pred:5:z)<<P:5:Predicate_anonymous_24033>>  =>  (V_LSHL_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_OR_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2227,
        GIR_EraseRootFromParent_Done,
      // Label 325: @21287
      GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(21380), // Rule ID 8132 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:5:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:5:y
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_csh_mask_32),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24033),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:5:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:5:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:5:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_24023>>)<<P:5:Predicate_anonymous_24033>>  =>  (V_LSHL_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_OR_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8132,
        GIR_EraseRootFromParent_Done,
      // Label 326: @21380
      GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(21553), // Rule ID 10842 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_23251>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10842,
        GIR_EraseRootFromParent_Done,
      // Label 327: @21553
      GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(21726), // Rule ID 10843 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_23251>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10843,
        GIR_EraseRootFromParent_Done,
      // Label 328: @21726
      GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(21899), // Rule ID 10844 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_23251>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10844,
        GIR_EraseRootFromParent_Done,
      // Label 329: @21899
      GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(22072), // Rule ID 10845 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_23251>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10845,
        GIR_EraseRootFromParent_Done,
      // Label 330: @22072
      GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(22245), // Rule ID 10838 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_23251>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10838,
        GIR_EraseRootFromParent_Done,
      // Label 331: @22245
      GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(22418), // Rule ID 10839 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_23251>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10839,
        GIR_EraseRootFromParent_Done,
      // Label 332: @22418
      GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(22591), // Rule ID 10840 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_23251>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10840,
        GIR_EraseRootFromParent_Done,
      // Label 333: @22591
      GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(22764), // Rule ID 10841 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_23251>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10841,
        GIR_EraseRootFromParent_Done,
      // Label 334: @22764
      GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(22937), // Rule ID 10832 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_23251>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10832,
        GIR_EraseRootFromParent_Done,
      // Label 335: @22937
      GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(23110), // Rule ID 10833 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_23251>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10833,
        GIR_EraseRootFromParent_Done,
      // Label 336: @23110
      GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(23283), // Rule ID 10836 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_23251>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10836,
        GIR_EraseRootFromParent_Done,
      // Label 337: @23283
      GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(23456), // Rule ID 10837 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_23251>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10837,
        GIR_EraseRootFromParent_Done,
      // Label 338: @23456
      GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(23629), // Rule ID 7308 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)))<<P:Predicate_anonymous_23251>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7308,
        GIR_EraseRootFromParent_Done,
      // Label 339: @23629
      GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(23802), // Rule ID 10831 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)))<<P:Predicate_anonymous_23251>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10831,
        GIR_EraseRootFromParent_Done,
      // Label 340: @23802
      GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(23975), // Rule ID 10834 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)))<<P:Predicate_anonymous_23251>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10834,
        GIR_EraseRootFromParent_Done,
      // Label 341: @23975
      GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(24148), // Rule ID 10835 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)))<<P:Predicate_anonymous_23251>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10835,
        GIR_EraseRootFromParent_Done,
      // Label 342: @24148
      GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(24199), // Rule ID 8044 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18507),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] }), i32:{ *:[i32] }:$src0)<<P:Predicate_anonymous_18507>>  =>  (S_ORN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8044,
        GIR_EraseRootFromParent_Done,
      // Label 343: @24199
      GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(24250), // Rule ID 68 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18507),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src0, (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] }))<<P:Predicate_anonymous_18507>>  =>  (S_ORN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 68,
        GIR_EraseRootFromParent_Done,
      // Label 344: @24250
      GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(24315), // Rule ID 2228 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:6:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:6:y
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:6:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24035),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:6:x, i32:{ *:[i32] }:$src1:$pred:6:y)<<P:Predicate_anonymous_24036>>, i32:{ *:[i32] }:$src2:$pred:6:z)<<P:6:Predicate_anonymous_24035>>  =>  (V_AND_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_OR_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2228,
        GIR_EraseRootFromParent_Done,
      // Label 345: @24315
      GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(24380), // Rule ID 2229 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:7:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:7:y
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:7:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24038),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:7:x, i32:{ *:[i32] }:$src1:$pred:7:y)<<P:Predicate_anonymous_24039>>, i32:{ *:[i32] }:$src2:$pred:7:z)<<P:7:Predicate_anonymous_24038>>  =>  (V_OR3_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR3_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2229,
        GIR_EraseRootFromParent_Done,
      // Label 346: @24380
      GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(24445), // Rule ID 2226 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:5:y
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:5:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24033),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:5:x, i32:{ *:[i32] }:$src1:$pred:5:y)<<P:Predicate_anonymous_24023>>, i32:{ *:[i32] }:$src2:$pred:5:z)<<P:5:Predicate_anonymous_24033>>  =>  (V_LSHL_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_OR_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2226,
        GIR_EraseRootFromParent_Done,
      // Label 347: @24445
      GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(24510), // Rule ID 8133 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:6:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:6:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:6:y
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24035),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:6:z, (and:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:6:x, i32:{ *:[i32] }:$src1:$pred:6:y)<<P:Predicate_anonymous_24036>>)<<P:6:Predicate_anonymous_24035>>  =>  (V_AND_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_OR_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8133,
        GIR_EraseRootFromParent_Done,
      // Label 348: @24510
      GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(24575), // Rule ID 8134 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:7:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:7:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:7:y
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24038),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:7:z, (or:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:7:x, i32:{ *:[i32] }:$src1:$pred:7:y)<<P:Predicate_anonymous_24039>>)<<P:7:Predicate_anonymous_24038>>  =>  (V_OR3_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR3_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8134,
        GIR_EraseRootFromParent_Done,
      // Label 349: @24575
      GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(24640), // Rule ID 8131 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:5:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:5:y
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24033),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:5:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:5:x, i32:{ *:[i32] }:$src1:$pred:5:y)<<P:Predicate_anonymous_24023>>)<<P:5:Predicate_anonymous_24033>>  =>  (V_LSHL_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_OR_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8131,
        GIR_EraseRootFromParent_Done,
      // Label 350: @24640
      GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(24666), // Rule ID 56 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18507),
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_18507>>  =>  (S_OR_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_OR_B32),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 56,
        GIR_Done,
      // Label 351: @24666
      GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(24686), // Rule ID 752 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_OR_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR_B32_e64),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 752,
        GIR_Done,
      // Label 352: @24686
      GIM_Reject,
    // Label 316: @24687
    GIM_Reject,
    // Label 303: @24688
    GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(33876),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(25014), // Rule ID 10805 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] }), i64:{ *:[i64] }:$z), (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$y))<<P:Predicate_anonymous_23251>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/3, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/5,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/6,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/7,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/3, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10805,
        GIR_EraseRootFromParent_Done,
      // Label 354: @25014
      GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(25329), // Rule ID 10804 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] }), i64:{ *:[i64] }:$z), (and:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_23251>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/3, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/5,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/6,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/7,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/3, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10804,
        GIR_EraseRootFromParent_Done,
      // Label 355: @25329
      GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(25644), // Rule ID 10803 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$z, (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] })), (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$y))<<P:Predicate_anonymous_23251>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/3, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/5,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/6,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/7,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/3, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10803,
        GIR_EraseRootFromParent_Done,
      // Label 356: @25644
      GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(25959), // Rule ID 10802 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$z, (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] })), (and:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_23251>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/3, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/5,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/6,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/7,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/3, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10802,
        GIR_EraseRootFromParent_Done,
      // Label 357: @25959
      GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(26274), // Rule ID 10799 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$x), (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] }), i64:{ *:[i64] }:$z))<<P:Predicate_anonymous_23251>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/5,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/6,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/7,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10799,
        GIR_EraseRootFromParent_Done,
      // Label 358: @26274
      GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(26589), // Rule ID 10801 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$y), (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] }), i64:{ *:[i64] }:$z))<<P:Predicate_anonymous_23251>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/5,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/6,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/7,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10801,
        GIR_EraseRootFromParent_Done,
      // Label 359: @26589
      GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(26904), // Rule ID 7084 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$x), (and:{ *:[i64] } i64:{ *:[i64] }:$z, (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] })))<<P:Predicate_anonymous_23251>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/5,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/6,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/7,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 7084,
        GIR_EraseRootFromParent_Done,
      // Label 360: @26904
      GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(27219), // Rule ID 10800 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$y), (and:{ *:[i64] } i64:{ *:[i64] }:$z, (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] })))<<P:Predicate_anonymous_23251>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/5,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/6,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/7,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10800,
        GIR_EraseRootFromParent_Done,
      // Label 361: @27219
      GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(27627), // Rule ID 10857 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), i64:{ *:[i64] }:$y), (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z))<<P:Predicate_anonymous_23251>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/8,
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/9,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/7,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/10,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/11,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/4,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/6,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10857,
        GIR_EraseRootFromParent_Done,
      // Label 362: @27627
      GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(28035), // Rule ID 10858 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), i64:{ *:[i64] }:$y), (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_23251>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/8,
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/9,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/7,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/10,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/11,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/4,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/6,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10858,
        GIR_EraseRootFromParent_Done,
      // Label 363: @28035
      GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(28443), // Rule ID 10859 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), i64:{ *:[i64] }:$y), (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z))<<P:Predicate_anonymous_23251>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/8,
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/9,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/7,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/10,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/11,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/4,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/6,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10859,
        GIR_EraseRootFromParent_Done,
      // Label 364: @28443
      GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(28851), // Rule ID 10860 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), i64:{ *:[i64] }:$y), (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_23251>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/8,
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/9,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/7,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/10,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/11,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/4,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/6,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10860,
        GIR_EraseRootFromParent_Done,
      // Label 365: @28851
      GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(29259), // Rule ID 10853 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z)), (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z))<<P:Predicate_anonymous_23251>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/8,
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/9,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/7,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/10,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/11,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/4,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/6,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10853,
        GIR_EraseRootFromParent_Done,
      // Label 366: @29259
      GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(29667), // Rule ID 10854 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z)), (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_23251>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/8,
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/9,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/7,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/10,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/11,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/4,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/6,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10854,
        GIR_EraseRootFromParent_Done,
      // Label 367: @29667
      GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(30075), // Rule ID 10855 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x)), (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z))<<P:Predicate_anonymous_23251>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/8,
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/9,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/7,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/10,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/11,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/4,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/6,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10855,
        GIR_EraseRootFromParent_Done,
      // Label 368: @30075
      GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(30483), // Rule ID 10856 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x)), (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_23251>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/8,
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/9,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/7,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/10,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/11,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/4,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/6,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10856,
        GIR_EraseRootFromParent_Done,
      // Label 369: @30483
      GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(30891), // Rule ID 10847 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), i64:{ *:[i64] }:$y))<<P:Predicate_anonymous_23251>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/8,
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/9,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/7,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/10,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/11,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/4,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/6,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10847,
        GIR_EraseRootFromParent_Done,
      // Label 370: @30891
      GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(31299), // Rule ID 10848 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), i64:{ *:[i64] }:$y))<<P:Predicate_anonymous_23251>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/8,
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/9,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/7,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/10,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/11,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/4,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/6,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10848,
        GIR_EraseRootFromParent_Done,
      // Label 371: @31299
      GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(31707), // Rule ID 10851 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), i64:{ *:[i64] }:$y))<<P:Predicate_anonymous_23251>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/8,
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/9,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/7,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/10,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/11,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/4,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/6,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10851,
        GIR_EraseRootFromParent_Done,
      // Label 372: @31707
      GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(32115), // Rule ID 10852 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), i64:{ *:[i64] }:$y))<<P:Predicate_anonymous_23251>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/8,
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/9,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/7,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/10,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/11,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/4,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/6,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10852,
        GIR_EraseRootFromParent_Done,
      // Label 373: @32115
      GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(32523), // Rule ID 7309 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z)))<<P:Predicate_anonymous_23251>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/8,
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/9,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/7,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/10,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/11,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/4,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/6,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 7309,
        GIR_EraseRootFromParent_Done,
      // Label 374: @32523
      GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(32931), // Rule ID 10846 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x)))<<P:Predicate_anonymous_23251>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/8,
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/9,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/7,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/10,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/11,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/4,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/6,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10846,
        GIR_EraseRootFromParent_Done,
      // Label 375: @32931
      GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(33339), // Rule ID 10849 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z)))<<P:Predicate_anonymous_23251>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/8,
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/9,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/7,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/10,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/11,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/4,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/6,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10849,
        GIR_EraseRootFromParent_Done,
      // Label 376: @33339
      GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(33747), // Rule ID 10850 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23251),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x)))<<P:Predicate_anonymous_23251>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/8,
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/9,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/7,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/10,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/11,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/4,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/6,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10850,
        GIR_EraseRootFromParent_Done,
      // Label 377: @33747
      GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(33798), // Rule ID 8045 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18507),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$src1, -1:{ *:[i64] }), i64:{ *:[i64] }:$src0)<<P:Predicate_anonymous_18507>>  =>  (S_ORN2_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8045,
        GIR_EraseRootFromParent_Done,
      // Label 378: @33798
      GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(33849), // Rule ID 69 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18507),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } i64:{ *:[i64] }:$src0, (xor:{ *:[i64] } i64:{ *:[i64] }:$src1, -1:{ *:[i64] }))<<P:Predicate_anonymous_18507>>  =>  (S_ORN2_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 69,
        GIR_EraseRootFromParent_Done,
      // Label 379: @33849
      GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(33875), // Rule ID 57 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18507),
        // (or:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_18507>>  =>  (S_OR_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_OR_B64),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 57,
        GIR_Done,
      // Label 380: @33875
      GIM_Reject,
    // Label 353: @33876
    GIM_Reject,
    // Label 304: @33877
    GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(34027),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(33947), // Rule ID 8120 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18507),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v2i16] } (xor:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, immAllOnesV:{ *:[v2i16] }), v2i16:{ *:[v2i16] }:$src0)<<P:Predicate_anonymous_18507>>  =>  (S_ORN2_B32:{ *:[v2i16] }:{ *:[i1] } SSrc_b32:{ *:[v2i16] }:$src0, SSrc_b32:{ *:[v2i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8120,
        GIR_EraseRootFromParent_Done,
      // Label 382: @33947
      GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(34006), // Rule ID 1662 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18507),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, (xor:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, immAllOnesV:{ *:[v2i16] }))<<P:Predicate_anonymous_18507>>  =>  (S_ORN2_B32:{ *:[v2i16] }:{ *:[i1] } SSrc_b32:{ *:[v2i16] }:$src0, SSrc_b32:{ *:[v2i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1662,
        GIR_EraseRootFromParent_Done,
      // Label 383: @34006
      GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(34026), // Rule ID 2164 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (or:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1)  =>  (V_OR_B32_e64:{ *:[v2i16] } VSrc_b32:{ *:[v2i16] }:$src0, VSrc_b32:{ *:[v2i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR_B32_e64),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2164,
        GIR_Done,
      // Label 384: @34026
      GIM_Reject,
    // Label 381: @34027
    GIM_Reject,
    // Label 305: @34028
    GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(34150),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18507),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
      GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(34098), // Rule ID 8122 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v2i32] } (xor:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src1, immAllOnesV:{ *:[v2i32] }), v2i32:{ *:[v2i32] }:$src0)<<P:Predicate_anonymous_18507>>  =>  (S_ORN2_B64:{ *:[v2i32] }:{ *:[i1] } SSrc_b64:{ *:[v2i32] }:$src0, SSrc_b64:{ *:[v2i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8122,
        GIR_EraseRootFromParent_Done,
      // Label 386: @34098
      GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(34149), // Rule ID 1664 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src0, (xor:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src1, immAllOnesV:{ *:[v2i32] }))<<P:Predicate_anonymous_18507>>  =>  (S_ORN2_B64:{ *:[v2i32] }:{ *:[i1] } SSrc_b64:{ *:[v2i32] }:$src0, SSrc_b64:{ *:[v2i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1664,
        GIR_EraseRootFromParent_Done,
      // Label 387: @34149
      GIM_Reject,
    // Label 385: @34150
    GIM_Reject,
    // Label 306: @34151
    GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(34273),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18507),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
      GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(34221), // Rule ID 8121 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v4i16] } (xor:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src1, immAllOnesV:{ *:[v4i16] }), v4i16:{ *:[v4i16] }:$src0)<<P:Predicate_anonymous_18507>>  =>  (S_ORN2_B64:{ *:[v4i16] }:{ *:[i1] } SSrc_b64:{ *:[v4i16] }:$src0, SSrc_b64:{ *:[v4i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8121,
        GIR_EraseRootFromParent_Done,
      // Label 389: @34221
      GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(34272), // Rule ID 1663 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src0, (xor:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src1, immAllOnesV:{ *:[v4i16] }))<<P:Predicate_anonymous_18507>>  =>  (S_ORN2_B64:{ *:[v4i16] }:{ *:[i1] } SSrc_b64:{ *:[v4i16] }:$src0, SSrc_b64:{ *:[v4i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1663,
        GIR_EraseRootFromParent_Done,
      // Label 390: @34272
      GIM_Reject,
    // Label 388: @34273
    GIM_Reject,
    // Label 307: @34274
    GIM_Reject,
    // Label 5: @34275
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(7), GIMT_Encode2(12), /*)*//*default:*//*Label 396*/ GIMT_Encode4(38638),
    /*GILLT_s1*//*Label 391*/ GIMT_Encode4(34306),
    /*GILLT_s16*//*Label 392*/ GIMT_Encode4(34369),
    /*GILLT_s32*//*Label 393*/ GIMT_Encode4(34421),
    /*GILLT_s64*//*Label 394*/ GIMT_Encode4(35978),
    /*GILLT_v2s16*//*Label 395*/ GIMT_Encode4(38611),
    // Label 391: @34306
    GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(34368),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(34342), // Rule ID 7165 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        // (xor:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_XOR_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B64),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7165,
        GIR_Done,
      // Label 398: @34342
      GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(34367), // Rule ID 7172 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        // (xor:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_XOR_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B32),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7172,
        GIR_Done,
      // Label 399: @34367
      GIM_Reject,
    // Label 397: @34368
    GIM_Reject,
    // Label 392: @34369
    GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(34420),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      GIM_Try, /*On fail goto*//*Label 401*/ GIMT_Encode4(34400), // Rule ID 2162 //
        // (xor:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2162,
        GIR_Done,
      // Label 401: @34400
      GIM_Try, /*On fail goto*//*Label 402*/ GIMT_Encode4(34419), // Rule ID 831 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX11Plus),
        // (xor:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_XOR_B16_t16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B16_t16_e64),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 831,
        GIR_Done,
      // Label 402: @34419
      GIM_Reject,
    // Label 400: @34420
    GIM_Reject,
    // Label 393: @34421
    GIM_Try, /*On fail goto*//*Label 403*/ GIMT_Encode4(35977),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 404*/ GIMT_Encode4(34487), // Rule ID 62 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18476),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_and_oneuse>>, -1:{ *:[i32] })<<P:Predicate_anonymous_18476>>  =>  (S_NAND_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NAND_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 62,
        GIR_EraseRootFromParent_Done,
      // Label 404: @34487
      GIM_Try, /*On fail goto*//*Label 405*/ GIMT_Encode4(34545), // Rule ID 64 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18476),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_or_oneuse>>, -1:{ *:[i32] })<<P:Predicate_anonymous_18476>>  =>  (S_NOR_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOR_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64,
        GIR_EraseRootFromParent_Done,
      // Label 405: @34545
      GIM_Try, /*On fail goto*//*Label 406*/ GIMT_Encode4(34603), // Rule ID 60 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18476),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_xor_oneuse>>, -1:{ *:[i32] })<<P:Predicate_anonymous_18476>>  =>  (S_XNOR_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_XNOR_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 60,
        GIR_EraseRootFromParent_Done,
      // Label 406: @34603
      GIM_Try, /*On fail goto*//*Label 407*/ GIMT_Encode4(34725), // Rule ID 10811 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[0] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23253),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$z)<<P:Predicate_anonymous_23253>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10811,
        GIR_EraseRootFromParent_Done,
      // Label 407: @34725
      GIM_Try, /*On fail goto*//*Label 408*/ GIMT_Encode4(34847), // Rule ID 10812 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[0] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23253),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$z)<<P:Predicate_anonymous_23253>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10812,
        GIR_EraseRootFromParent_Done,
      // Label 408: @34847
      GIM_Try, /*On fail goto*//*Label 409*/ GIMT_Encode4(34969), // Rule ID 10809 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[0] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23253),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, (xor:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$z)), i32:{ *:[i32] }:$z)<<P:Predicate_anonymous_23253>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10809,
        GIR_EraseRootFromParent_Done,
      // Label 409: @34969
      GIM_Try, /*On fail goto*//*Label 410*/ GIMT_Encode4(35091), // Rule ID 10810 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[0] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23253),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, (xor:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)), i32:{ *:[i32] }:$z)<<P:Predicate_anonymous_23253>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10810,
        GIR_EraseRootFromParent_Done,
      // Label 410: @35091
      GIM_Try, /*On fail goto*//*Label 411*/ GIMT_Encode4(35212), // Rule ID 10808 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23253),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$z, (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_23253>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10808,
        GIR_EraseRootFromParent_Done,
      // Label 411: @35212
      GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(35333), // Rule ID 10807 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        // MIs[2] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23253),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$z, (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_23253>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10807,
        GIR_EraseRootFromParent_Done,
      // Label 412: @35333
      GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(35454), // Rule ID 10806 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23253),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$z, (and:{ *:[i32] } i32:{ *:[i32] }:$x, (xor:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)))<<P:Predicate_anonymous_23253>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10806,
        GIR_EraseRootFromParent_Done,
      // Label 413: @35454
      GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(35575), // Rule ID 7085 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        // MIs[2] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23253),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$z, (and:{ *:[i32] } i32:{ *:[i32] }:$x, (xor:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$z)))<<P:Predicate_anonymous_23253>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // z
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7085,
        GIR_EraseRootFromParent_Done,
      // Label 414: @35575
      GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(35607), // Rule ID 0 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18476),
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$src0, -1:{ *:[i32] })<<P:Predicate_anonymous_18476>>  =>  (S_NOT_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOT_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 0,
        GIR_EraseRootFromParent_Done,
      // Label 415: @35607
      GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(35636), // Rule ID 7177 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23253),
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$src0, -1:{ *:[i32] })<<P:Predicate_anonymous_23253>>  =>  (V_NOT_B32_e32:{ *:[i32] } ?:{ *:[i32] }:$src0)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_NOT_B32_e32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7177,
        GIR_EraseRootFromParent_Done,
      // Label 416: @35636
      GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(35704), // Rule ID 2248 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX10Plus),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:16:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:16:y
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:16:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24088),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:16:x, i32:{ *:[i32] }:$src1:$pred:16:y)<<P:Predicate_anonymous_24042>>, i32:{ *:[i32] }:$src2:$pred:16:z)<<P:16:Predicate_anonymous_24088>>  =>  (V_XOR3_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR3_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2248,
        GIR_EraseRootFromParent_Done,
      // Label 417: @35704
      GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(35772), // Rule ID 8146 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX10Plus),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:16:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:16:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:16:y
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24088),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:16:z, (xor:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:16:x, i32:{ *:[i32] }:$src1:$pred:16:y)<<P:Predicate_anonymous_24042>>)<<P:16:Predicate_anonymous_24088>>  =>  (V_XOR3_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR3_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8146,
        GIR_EraseRootFromParent_Done,
      // Label 418: @35772
      GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(35801), // Rule ID 58 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18508),
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_18508>>  =>  (S_XOR_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B32),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 58,
        GIR_Done,
      // Label 419: @35801
      GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(35851), // Rule ID 8078 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDLInsts),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src0, -1:{ *:[i32] }), i32:{ *:[i32] }:$src1)  =>  (V_XNOR_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_XNOR_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8078,
        GIR_EraseRootFromParent_Done,
      // Label 420: @35851
      GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(35903), // Rule ID 834 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDLInsts),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), -1:{ *:[i32] })  =>  (V_XNOR_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_XNOR_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 834,
        GIR_EraseRootFromParent_Done,
      // Label 421: @35903
      GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(35953), // Rule ID 8079 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDLInsts),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, (xor:{ *:[i32] } i32:{ *:[i32] }:$src0, -1:{ *:[i32] }))  =>  (V_XNOR_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_XNOR_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8079,
        GIR_EraseRootFromParent_Done,
      // Label 422: @35953
      GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(35976), // Rule ID 753 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_XOR_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 753,
        GIR_Done,
      // Label 423: @35976
      GIM_Reject,
    // Label 403: @35977
    GIM_Reject,
    // Label 394: @35978
    GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(38610),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(36044), // Rule ID 63 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18476),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_and_oneuse>>, -1:{ *:[i64] })<<P:Predicate_anonymous_18476>>  =>  (S_NAND_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NAND_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 63,
        GIR_EraseRootFromParent_Done,
      // Label 425: @36044
      GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(36102), // Rule ID 65 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18476),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_or_oneuse>>, -1:{ *:[i64] })<<P:Predicate_anonymous_18476>>  =>  (S_NOR_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOR_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65,
        GIR_EraseRootFromParent_Done,
      // Label 426: @36102
      GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(36160), // Rule ID 61 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18476),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_xor_oneuse>>, -1:{ *:[i64] })<<P:Predicate_anonymous_18476>>  =>  (S_XNOR_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_XNOR_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 61,
        GIR_EraseRootFromParent_Done,
      // Label 427: @36160
      GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(36459), // Rule ID 10818 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[0] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23253),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[i64] } (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$z), i64:{ *:[i64] }:$x), i64:{ *:[i64] }:$z)<<P:Predicate_anonymous_23253>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/5,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/6,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/7,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10818,
        GIR_EraseRootFromParent_Done,
      // Label 428: @36459
      GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(36758), // Rule ID 10819 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[0] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23253),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[i64] } (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$y), i64:{ *:[i64] }:$x), i64:{ *:[i64] }:$z)<<P:Predicate_anonymous_23253>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/5,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/6,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/7,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10819,
        GIR_EraseRootFromParent_Done,
      // Label 429: @36758
      GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(37057), // Rule ID 10816 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[0] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23253),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, (xor:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$z)), i64:{ *:[i64] }:$z)<<P:Predicate_anonymous_23253>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/5,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/6,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/7,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10816,
        GIR_EraseRootFromParent_Done,
      // Label 430: @37057
      GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(37356), // Rule ID 10817 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[0] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23253),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, (xor:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$y)), i64:{ *:[i64] }:$z)<<P:Predicate_anonymous_23253>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/5,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/6,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/7,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10817,
        GIR_EraseRootFromParent_Done,
      // Label 431: @37356
      GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(37654), // Rule ID 10815 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23253),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$z, (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$y), i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_23253>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/5,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/6,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/7,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10815,
        GIR_EraseRootFromParent_Done,
      // Label 432: @37654
      GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(37952), // Rule ID 10814 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        // MIs[2] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23253),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$z, (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$z), i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_23253>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/5,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/6,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/7,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10814,
        GIR_EraseRootFromParent_Done,
      // Label 433: @37952
      GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(38250), // Rule ID 10813 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23253),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$z, (and:{ *:[i64] } i64:{ *:[i64] }:$x, (xor:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$y)))<<P:Predicate_anonymous_23253>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/5,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/6,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/7,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10813,
        GIR_EraseRootFromParent_Done,
      // Label 434: @38250
      GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(38548), // Rule ID 7086 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        // MIs[2] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23253),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$z, (and:{ *:[i64] } i64:{ *:[i64] }:$x, (xor:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$z)))<<P:Predicate_anonymous_23253>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/5,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/6,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/7,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 7086,
        GIR_EraseRootFromParent_Done,
      // Label 435: @38548
      GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(38580), // Rule ID 1 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18476),
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$src0, -1:{ *:[i64] })<<P:Predicate_anonymous_18476>>  =>  (S_NOT_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOT_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1,
        GIR_EraseRootFromParent_Done,
      // Label 436: @38580
      GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(38609), // Rule ID 59 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_18508),
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_18508>>  =>  (S_XOR_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B64),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 59,
        GIR_Done,
      // Label 437: @38609
      GIM_Reject,
    // Label 424: @38610
    GIM_Reject,
    // Label 395: @38611
    GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(38637), // Rule ID 2165 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      // (xor:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1)  =>  (V_XOR_B32_e64:{ *:[v2i16] } VSrc_b32:{ *:[v2i16] }:$src0, VSrc_b32:{ *:[v2i16] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2165,
      GIR_Done,
    // Label 438: @38637
    GIM_Reject,
    // Label 396: @38638
    GIM_Reject,
    // Label 6: @38639
    GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(38690),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_p5s32,
      GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(38668), // Rule ID 7067 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // MIs[0] fi
        // No operand predicates
        // (frameindex:{ *:[i32] }):$fi  =>  (V_MOV_B32_e32:{ *:[i32] } (frameindex_to_targetframeindex:{ *:[i32] } ?:{ *:[i32] }:$fi))
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MOV_B32_e32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/0, /*Renderer*/GIMT_Encode2(GICR_renderFrameIndex), // fi
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7067,
        GIR_EraseRootFromParent_Done,
      // Label 440: @38668
      GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(38689), // Rule ID 7068 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        // MIs[0] fi
        // No operand predicates
        // (frameindex:{ *:[i32] }):$fi  =>  (S_MOV_B32:{ *:[i32] } (frameindex_to_targetframeindex:{ *:[i32] } ?:{ *:[i32] }:$fi))
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_MOV_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/0, /*Renderer*/GIMT_Encode2(GICR_renderFrameIndex), // fi
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7068,
        GIR_EraseRootFromParent_Done,
      // Label 441: @38689
      GIM_Reject,
    // Label 439: @38690
    GIM_Reject,
    // Label 7: @38691
    GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(41725),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(39186),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(38840), // Rule ID 2317 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFmaMixInsts),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AMDGPU::G_AMDGPU_CLAMP),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_FPTRUNC),
          GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
          GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
          GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_FMA),
          GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
          GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
          GIM_CheckType, /*MI*/3, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckIsSafeToFold, /*NumInsns*/3,
          GIM_CheckComplexPattern, /*MI*/3, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3_mad_mix_mods),
          GIM_CheckComplexPattern, /*MI*/3, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3_mad_mix_mods),
          GIM_CheckComplexPattern, /*MI*/3, /*Op*/3, /*Renderer*/GIMT_Encode2(2), GIMT_Encode2(GICP_gi_vop3_mad_mix_mods),
          // (build_vector:{ *:[v2f16] } f16:{ *:[f16] }:$elt0, (AMDGPUclamp:{ *:[f16] } (fpround:{ *:[f16] } (fma:{ *:[f32] } (VOP3PMadMixMods:{ *:[f32] } f16:{ *:[f16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMadMixMods:{ *:[f32] } f16:{ *:[f16] }:$src1, i32:{ *:[i32] }:$src1_modifiers), (VOP3PMadMixMods:{ *:[f32] } f16:{ *:[f16] }:$src2, i32:{ *:[i32] }:$src2_modifiers)))))  =>  (V_FMA_MIXHI_F16:{ *:[v2f16] } ?:{ *:[i32] }:$src0_modifiers, ?:{ *:[f16] }:$src0, ?:{ *:[i32] }:$src1_modifiers, ?:{ *:[f16] }:$src1, ?:{ *:[i32] }:$src2_modifiers, ?:{ *:[f16] }:$src2, 1:{ *:[i1] }, VGPR_32:{ *:[f16] }:$elt0)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_FMA_MIXHI_F16),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/1, // src2_modifiers
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/0, // src2
          GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
          GIR_RootToRootCopy, /*OpIdx*/1, // elt0
          GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
          GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 2317,
          GIR_EraseRootFromParent_Done,
        // Label 444: @38840
        GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(38963), // Rule ID 2308 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMadMixInsts_NoFP32Denormals),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AMDGPU::G_AMDGPU_CLAMP),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_FPTRUNC),
          GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
          GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
          GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_FMAD),
          GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
          GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
          GIM_CheckType, /*MI*/3, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckIsSafeToFold, /*NumInsns*/3,
          GIM_CheckComplexPattern, /*MI*/3, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3_mad_mix_mods),
          GIM_CheckComplexPattern, /*MI*/3, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3_mad_mix_mods),
          GIM_CheckComplexPattern, /*MI*/3, /*Op*/3, /*Renderer*/GIMT_Encode2(2), GIMT_Encode2(GICP_gi_vop3_mad_mix_mods),
          // (build_vector:{ *:[v2f16] } f16:{ *:[f16] }:$elt0, (AMDGPUclamp:{ *:[f16] } (fpround:{ *:[f16] } (fmad:{ *:[f32] } (VOP3PMadMixMods:{ *:[f32] } f16:{ *:[f16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMadMixMods:{ *:[f32] } f16:{ *:[f16] }:$src1, i32:{ *:[i32] }:$src1_modifiers), (VOP3PMadMixMods:{ *:[f32] } f16:{ *:[f16] }:$src2, i32:{ *:[i32] }:$src2_modifiers)))))  =>  (V_MAD_MIXHI_F16:{ *:[v2f16] } ?:{ *:[i32] }:$src0_modifiers, ?:{ *:[f16] }:$src0, ?:{ *:[i32] }:$src1_modifiers, ?:{ *:[f16] }:$src1, ?:{ *:[i32] }:$src2_modifiers, ?:{ *:[f16] }:$src2, 1:{ *:[i1] }, VGPR_32:{ *:[f16] }:$elt0)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_MIXHI_F16),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/1, // src2_modifiers
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/0, // src2
          GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
          GIR_RootToRootCopy, /*OpIdx*/1, // elt0
          GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
          GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 2308,
          GIR_EraseRootFromParent_Done,
        // Label 445: @38963
        GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(39074), // Rule ID 2316 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFmaMixInsts),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FPTRUNC),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_FMA),
          GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
          GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
          GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckIsSafeToFold, /*NumInsns*/2,
          GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3_mad_mix_mods),
          GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3_mad_mix_mods),
          GIM_CheckComplexPattern, /*MI*/2, /*Op*/3, /*Renderer*/GIMT_Encode2(2), GIMT_Encode2(GICP_gi_vop3_mad_mix_mods),
          // (build_vector:{ *:[v2f16] } f16:{ *:[f16] }:$elt0, (fpround:{ *:[f16] } (fma:{ *:[f32] } (VOP3PMadMixMods:{ *:[f32] } f16:{ *:[f16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMadMixMods:{ *:[f32] } f16:{ *:[f16] }:$src1, i32:{ *:[i32] }:$src1_modifiers), (VOP3PMadMixMods:{ *:[f32] } f16:{ *:[f16] }:$src2, i32:{ *:[i32] }:$src2_modifiers))))  =>  (V_FMA_MIXHI_F16:{ *:[v2f16] } ?:{ *:[i32] }:$src0_modifiers, ?:{ *:[f16] }:$src0, ?:{ *:[i32] }:$src1_modifiers, ?:{ *:[f16] }:$src1, ?:{ *:[i32] }:$src2_modifiers, ?:{ *:[f16] }:$src2, 0:{ *:[i1] }, VGPR_32:{ *:[f16] }:$elt0)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_FMA_MIXHI_F16),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/1, // src2_modifiers
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/0, // src2
          GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
          GIR_RootToRootCopy, /*OpIdx*/1, // elt0
          GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
          GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 2316,
          GIR_EraseRootFromParent_Done,
        // Label 446: @39074
        GIM_Try, /*On fail goto*//*Label 447*/ GIMT_Encode4(39185), // Rule ID 2307 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMadMixInsts_NoFP32Denormals),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FPTRUNC),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_FMAD),
          GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
          GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
          GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckIsSafeToFold, /*NumInsns*/2,
          GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3_mad_mix_mods),
          GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3_mad_mix_mods),
          GIM_CheckComplexPattern, /*MI*/2, /*Op*/3, /*Renderer*/GIMT_Encode2(2), GIMT_Encode2(GICP_gi_vop3_mad_mix_mods),
          // (build_vector:{ *:[v2f16] } f16:{ *:[f16] }:$elt0, (fpround:{ *:[f16] } (fmad:{ *:[f32] } (VOP3PMadMixMods:{ *:[f32] } f16:{ *:[f16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMadMixMods:{ *:[f32] } f16:{ *:[f16] }:$src1, i32:{ *:[i32] }:$src1_modifiers), (VOP3PMadMixMods:{ *:[f32] } f16:{ *:[f16] }:$src2, i32:{ *:[i32] }:$src2_modifiers))))  =>  (V_MAD_MIXHI_F16:{ *:[v2f16] } ?:{ *:[i32] }:$src0_modifiers, ?:{ *:[f16] }:$src0, ?:{ *:[i32] }:$src1_modifiers, ?:{ *:[f16] }:$src1, ?:{ *:[i32] }:$src2_modifiers, ?:{ *:[f16] }:$src2, 0:{ *:[i1] }, VGPR_32:{ *:[f16] }:$elt0)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_MIXHI_F16),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/1, // src2_modifiers
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/0, // src2
          GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
          GIR_RootToRootCopy, /*OpIdx*/1, // elt0
          GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
          GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 2307,
          GIR_EraseRootFromParent_Done,
        // Label 447: @39185
        GIM_Reject,
      // Label 443: @39186
      GIM_Try, /*On fail goto*//*Label 448*/ GIMT_Encode4(39500),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36200),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_Try, /*On fail goto*//*Label 449*/ GIMT_Encode4(39349), // Rule ID 7271 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVOP3PInsts),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BITCAST),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_TRUNC),
          GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
          GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
          GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
          GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
          GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
          GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
          GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
          GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BITCAST),
          GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s16,
          GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
          GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_TRUNC),
          GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
          GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
          GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
          GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
          GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/6, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
          GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
          GIM_CheckIsSafeToFold, /*NumInsns*/6,
          // (build_vector:{ *:[v2f16] } (bitconvert:{ *:[f16] } (trunc:{ *:[i16] } (srl:{ *:[i32] } VGPR_32:{ *:[i32] }:$a, 16:{ *:[i32] }))), (bitconvert:{ *:[f16] } (trunc:{ *:[i16] } (srl:{ *:[i32] } VGPR_32:{ *:[i32] }:$b, 16:{ *:[i32] }))))<<P:Predicate_anonymous_36200>>  =>  (V_PERM_B32_e64:{ *:[v2f16] } VGPR_32:{ *:[i32] }:$b, VGPR_32:{ *:[i32] }:$a, (S_MOV_B32:{ *:[i16] } 117834498:{ *:[i32] }))
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::S_MOV_B32),
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
          GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(117834498),
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PERM_B32_e64),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // b
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // a
          GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 7271,
          GIR_EraseRootFromParent_Done,
        // Label 449: @39349
        GIM_Try, /*On fail goto*//*Label 450*/ GIMT_Encode4(39499), // Rule ID 7277 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVOP3PInsts),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BITCAST),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_TRUNC),
          GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
          GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
          GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
          GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
          GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
          GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
          GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
          GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BITCAST),
          GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s16,
          GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
          GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_TRUNC),
          GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
          GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
          GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
          GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
          GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/6, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
          GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
          GIM_CheckIsSafeToFold, /*NumInsns*/6,
          // (build_vector:{ *:[v2bf16] } (bitconvert:{ *:[bf16] } (trunc:{ *:[i16] } (srl:{ *:[i32] } VGPR_32:{ *:[i32] }:$a, 16:{ *:[i32] }))), (bitconvert:{ *:[bf16] } (trunc:{ *:[i16] } (srl:{ *:[i32] } VGPR_32:{ *:[i32] }:$b, 16:{ *:[i32] }))))<<P:Predicate_anonymous_36200>>  =>  (V_PERM_B32_e64:{ *:[v2bf16] } VGPR_32:{ *:[i32] }:$b, VGPR_32:{ *:[i32] }:$a, (S_MOV_B32:{ *:[i16] } 117834498:{ *:[i32] }))
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::S_MOV_B32),
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
          GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(117834498),
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PERM_B32_e64),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // b
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // a
          GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 7277,
          GIR_EraseRootFromParent_Done,
        // Label 450: @39499
        GIM_Reject,
      // Label 448: @39500
      GIM_Try, /*On fail goto*//*Label 451*/ GIMT_Encode4(39611), // Rule ID 7259 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVOP3PInsts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36198),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (build_vector:{ *:[v2i16] } (trunc:{ *:[i16] } (srl:{ *:[i32] } SReg_32:{ *:[i32] }:$src0, 16:{ *:[i32] })<<P:Predicate_srl_oneuse>>), (trunc:{ *:[i16] } (srl:{ *:[i32] } SReg_32:{ *:[i32] }:$src1, 16:{ *:[i32] })<<P:Predicate_srl_oneuse>>))<<P:Predicate_anonymous_36198>>  =>  (S_PACK_HH_B32_B16:{ *:[v2i16] } SReg_32:{ *:[i32] }:$src0, SReg_32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_PACK_HH_B32_B16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7259,
        GIR_EraseRootFromParent_Done,
      // Label 451: @39611
      GIM_Try, /*On fail goto*//*Label 452*/ GIMT_Encode4(39674), // Rule ID 7278 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVOP3PInsts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36239),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3mods),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3mods),
        // (build_vector:{ *:[v2f16] } (VOP3Mods:{ *:[f16] } VGPR_32:{ *:[f16] }:$src0, i32:{ *:[i32] }:$src0_mods), (VOP3Mods:{ *:[f16] } VGPR_32:{ *:[f16] }:$src1, i32:{ *:[i32] }:$src1_mods))<<P:Predicate_anonymous_36239>>  =>  (V_PACK_B32_F16_e64:{ *:[v2f16] } ?:{ *:[i32] }:$src0_mods, VGPR_32:{ *:[f16] }:$src0, ?:{ *:[i32] }:$src1_mods, VGPR_32:{ *:[f16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PACK_B32_F16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_mods
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_mods
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7278,
        GIR_EraseRootFromParent_Done,
      // Label 452: @39674
      GIM_Try, /*On fail goto*//*Label 453*/ GIMT_Encode4(39876),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_Try, /*On fail goto*//*Label 454*/ GIMT_Encode4(39779), // Rule ID 2311 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMadMixInsts_NoFP32Denormals),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FPTRUNC),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_FMUL),
          GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
          GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
          GIM_CheckIsSafeToFold, /*NumInsns*/2,
          GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3_mad_mix_mods),
          GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3_mad_mix_mods),
          // (build_vector:{ *:[v2f16] } f16:{ *:[f16] }:$elt0, (fpround:{ *:[f16] } (fmul:{ *:[f32] } (VOP3PMadMixMods:{ *:[f32] } f32:{ *:[f32] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMadMixMods:{ *:[f32] } f32:{ *:[f32] }:$src1, i32:{ *:[i32] }:$src1_modifiers))))  =>  (V_MAD_MIXHI_F16:{ *:[v2f16] } ?:{ *:[i32] }:$src0_modifiers, ?:{ *:[f32] }:$src0, ?:{ *:[i32] }:$src1_modifiers, ?:{ *:[f32] }:$src1, 0:{ *:[i32] }, 0:{ *:[i32] }, 0:{ *:[i1] }, VGPR_32:{ *:[f16] }:$elt0)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_MIXHI_F16),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
          GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
          GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
          GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
          GIR_RootToRootCopy, /*OpIdx*/1, // elt0
          GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
          GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 2311,
          GIR_EraseRootFromParent_Done,
        // Label 454: @39779
        GIM_Try, /*On fail goto*//*Label 455*/ GIMT_Encode4(39875), // Rule ID 2320 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFmaMixInsts),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FPTRUNC),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_FMUL),
          GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
          GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
          GIM_CheckIsSafeToFold, /*NumInsns*/2,
          GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3_mad_mix_mods),
          GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3_mad_mix_mods),
          // (build_vector:{ *:[v2f16] } f16:{ *:[f16] }:$elt0, (fpround:{ *:[f16] } (fmul:{ *:[f32] } (VOP3PMadMixMods:{ *:[f32] } f32:{ *:[f32] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMadMixMods:{ *:[f32] } f32:{ *:[f32] }:$src1, i32:{ *:[i32] }:$src1_modifiers))))  =>  (V_FMA_MIXHI_F16:{ *:[v2f16] } ?:{ *:[i32] }:$src0_modifiers, ?:{ *:[f32] }:$src0, ?:{ *:[i32] }:$src1_modifiers, ?:{ *:[f32] }:$src1, 0:{ *:[i32] }, 0:{ *:[i32] }, 0:{ *:[i1] }, VGPR_32:{ *:[f16] }:$elt0)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_FMA_MIXHI_F16),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
          GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
          GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
          GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
          GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
          GIR_RootToRootCopy, /*OpIdx*/1, // elt0
          GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
          GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 2320,
          GIR_EraseRootFromParent_Done,
        // Label 455: @39875
        GIM_Reject,
      // Label 453: @39876
      GIM_Try, /*On fail goto*//*Label 456*/ GIMT_Encode4(40380),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36200),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_Try, /*On fail goto*//*Label 457*/ GIMT_Encode4(40015), // Rule ID 7265 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVOP3PInsts),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
          GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
          GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
          GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
          GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
          GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_TRUNC),
          GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
          GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
          GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
          GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
          GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
          GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
          GIM_CheckIsSafeToFold, /*NumInsns*/4,
          // (build_vector:{ *:[v2i16] } (trunc:{ *:[i16] } (srl:{ *:[i32] } VGPR_32:{ *:[i32] }:$a, 16:{ *:[i32] })), (trunc:{ *:[i16] } (srl:{ *:[i32] } VGPR_32:{ *:[i32] }:$b, 16:{ *:[i32] })))<<P:Predicate_anonymous_36200>>  =>  (V_PERM_B32_e64:{ *:[v2i16] } VGPR_32:{ *:[i32] }:$b, VGPR_32:{ *:[i32] }:$a, (S_MOV_B32:{ *:[i16] } 117834498:{ *:[i32] }))
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::S_MOV_B32),
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
          GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(117834498),
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PERM_B32_e64),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // b
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // a
          GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 7265,
          GIR_EraseRootFromParent_Done,
        // Label 457: @40015
        GIM_Try, /*On fail goto*//*Label 458*/ GIMT_Encode4(40094), // Rule ID 7270 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVOP3PInsts),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BITCAST),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_TRUNC),
          GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
          GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
          GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
          GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
          GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
          GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/3,
          // (build_vector:{ *:[v2f16] } (bitconvert:{ *:[f16] } (trunc:{ *:[i16] } (srl:{ *:[i32] } VGPR_32:{ *:[i32] }:$a, 16:{ *:[i32] }))), VGPR_32:{ *:[f16] }:$b)<<P:Predicate_anonymous_36200>>  =>  (V_ALIGNBIT_B32_e64:{ *:[v2f16] } VGPR_32:{ *:[f16] }:$b, VGPR_32:{ *:[i32] }:$a, 16:{ *:[i32] })
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ALIGNBIT_B32_e64),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
          GIR_RootToRootCopy, /*OpIdx*/2, // b
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // a
          GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 7270,
          GIR_EraseRootFromParent_Done,
        // Label 458: @40094
        GIM_Try, /*On fail goto*//*Label 459*/ GIMT_Encode4(40173), // Rule ID 7276 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVOP3PInsts),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BITCAST),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_TRUNC),
          GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
          GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
          GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
          GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
          GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
          GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/3,
          // (build_vector:{ *:[v2bf16] } (bitconvert:{ *:[bf16] } (trunc:{ *:[i16] } (srl:{ *:[i32] } VGPR_32:{ *:[i32] }:$a, 16:{ *:[i32] }))), VGPR_32:{ *:[bf16] }:$b)<<P:Predicate_anonymous_36200>>  =>  (V_ALIGNBIT_B32_e64:{ *:[v2bf16] } VGPR_32:{ *:[bf16] }:$b, VGPR_32:{ *:[i32] }:$a, 16:{ *:[i32] })
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ALIGNBIT_B32_e64),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
          GIR_RootToRootCopy, /*OpIdx*/2, // b
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // a
          GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 7276,
          GIR_EraseRootFromParent_Done,
        // Label 459: @40173
        GIM_Try, /*On fail goto*//*Label 460*/ GIMT_Encode4(40276), // Rule ID 7269 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVOP3PInsts),
          GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BITCAST),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_TRUNC),
          GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
          GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
          GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
          GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
          GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
          GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
          GIM_CheckIsSafeToFold, /*NumInsns*/3,
          // (build_vector:{ *:[v2f16] } VGPR_32:{ *:[f16] }:$a, (bitconvert:{ *:[f16] } (trunc:{ *:[i16] } (srl:{ *:[i32] } VGPR_32:{ *:[i32] }:$b, 16:{ *:[i32] }))))<<P:Predicate_anonymous_36200>>  =>  (V_BFI_B32_e64:{ *:[v2f16] } (S_MOV_B32:{ *:[i16] } 65535:{ *:[i32] }), VGPR_32:{ *:[f16] }:$a, VGPR_32:{ *:[i32] }:$b)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::S_MOV_B32),
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
          GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(65535),
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
          GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
          GIR_RootToRootCopy, /*OpIdx*/1, // a
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // b
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 7269,
          GIR_EraseRootFromParent_Done,
        // Label 460: @40276
        GIM_Try, /*On fail goto*//*Label 461*/ GIMT_Encode4(40379), // Rule ID 7275 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVOP3PInsts),
          GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BITCAST),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_TRUNC),
          GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
          GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
          GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
          GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
          GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
          GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
          GIM_CheckIsSafeToFold, /*NumInsns*/3,
          // (build_vector:{ *:[v2bf16] } VGPR_32:{ *:[bf16] }:$a, (bitconvert:{ *:[bf16] } (trunc:{ *:[i16] } (srl:{ *:[i32] } VGPR_32:{ *:[i32] }:$b, 16:{ *:[i32] }))))<<P:Predicate_anonymous_36200>>  =>  (V_BFI_B32_e64:{ *:[v2bf16] } (S_MOV_B32:{ *:[i16] } 65535:{ *:[i32] }), VGPR_32:{ *:[bf16] }:$a, VGPR_32:{ *:[i32] }:$b)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::S_MOV_B32),
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
          GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(65535),
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
          GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
          GIR_RootToRootCopy, /*OpIdx*/1, // a
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // b
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 7275,
          GIR_EraseRootFromParent_Done,
        // Label 461: @40379
        GIM_Reject,
      // Label 456: @40380
      GIM_Try, /*On fail goto*//*Label 462*/ GIMT_Encode4(40454), // Rule ID 7258 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVOP3PInsts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36198),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (build_vector:{ *:[v2i16] } SReg_32:{ *:[i16] }:$src0, (trunc:{ *:[i16] } (srl:{ *:[i32] } SReg_32:{ *:[i32] }:$src1, 16:{ *:[i32] })<<P:Predicate_srl_oneuse>>))<<P:Predicate_anonymous_36198>>  =>  (S_PACK_LH_B32_B16:{ *:[v2i16] } SReg_32:{ *:[i16] }:$src0, SReg_32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_PACK_LH_B32_B16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7258,
        GIR_EraseRootFromParent_Done,
      // Label 462: @40454
      GIM_Try, /*On fail goto*//*Label 463*/ GIMT_Encode4(40529), // Rule ID 7264 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVOP3PInsts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36200),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (build_vector:{ *:[v2i16] } (trunc:{ *:[i16] } (srl:{ *:[i32] } VGPR_32:{ *:[i32] }:$a, 16:{ *:[i32] })), VGPR_32:{ *:[i16] }:$b)<<P:Predicate_anonymous_36200>>  =>  (V_ALIGNBIT_B32_e64:{ *:[v2i16] } VGPR_32:{ *:[i16] }:$b, VGPR_32:{ *:[i32] }:$a, 16:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ALIGNBIT_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // b
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // a
        GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7264,
        GIR_EraseRootFromParent_Done,
      // Label 463: @40529
      GIM_Try, /*On fail goto*//*Label 464*/ GIMT_Encode4(40599), // Rule ID 7279 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX11Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (build_vector:{ *:[v2i16] } (trunc:{ *:[i16] } (srl:{ *:[i32] } SReg_32:{ *:[i32] }:$src0, 16:{ *:[i32] })<<P:Predicate_srl_oneuse>>), SReg_32:{ *:[i16] }:$src1)  =>  (S_PACK_HL_B32_B16:{ *:[v2i16] } SReg_32:{ *:[i32] }:$src0, SReg_32:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_PACK_HL_B32_B16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7279,
        GIR_EraseRootFromParent_Done,
      // Label 464: @40599
      GIM_Try, /*On fail goto*//*Label 465*/ GIMT_Encode4(40698), // Rule ID 7263 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVOP3PInsts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36200),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (build_vector:{ *:[v2i16] } VGPR_32:{ *:[i16] }:$a, (trunc:{ *:[i16] } (srl:{ *:[i32] } VGPR_32:{ *:[i32] }:$b, 16:{ *:[i32] })))<<P:Predicate_anonymous_36200>>  =>  (V_BFI_B32_e64:{ *:[v2i16] } (S_MOV_B32:{ *:[i16] } 65535:{ *:[i32] }), VGPR_32:{ *:[i16] }:$a, VGPR_32:{ *:[i32] }:$b)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::S_MOV_B32),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(65535),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // b
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7263,
        GIR_EraseRootFromParent_Done,
      // Label 465: @40698
      GIM_Try, /*On fail goto*//*Label 466*/ GIMT_Encode4(40734), // Rule ID 7239 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36198),
        // (build_vector:{ *:[v2i16] } 0:{ *:[i16] }, SReg_32:{ *:[i16] }:$src1)<<P:Predicate_anonymous_36198>>  =>  (S_LSHL_B32:{ *:[v2i16] }:{ *:[i1] } SReg_32:{ *:[i16] }:$src1, 16:{ *:[i16] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7239,
        GIR_EraseRootFromParent_Done,
      // Label 466: @40734
      GIM_Try, /*On fail goto*//*Label 467*/ GIMT_Encode4(40767), // Rule ID 7240 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36200),
        // (build_vector:{ *:[v2i16] } 0:{ *:[i16] }, VGPR_32:{ *:[i16] }:$src1)<<P:Predicate_anonymous_36200>>  =>  (V_LSHLREV_B32_e64:{ *:[v2i16] } 16:{ *:[i16] }, VGPR_32:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHLREV_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7240,
        GIR_EraseRootFromParent_Done,
      // Label 467: @40767
      GIM_Try, /*On fail goto*//*Label 468*/ GIMT_Encode4(40827), // Rule ID 7241 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36198),
        // (build_vector:{ *:[v2i16] } SReg_32:{ *:[i16] }:$src1, 0:{ *:[i16] })<<P:Predicate_anonymous_36198>>  =>  (S_AND_B32:{ *:[v2i16] }:{ *:[i1] } (S_MOV_B32:{ *:[i1] } 65535:{ *:[i32] }), SReg_32:{ *:[i16] }:$src1)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::S_MOV_B32),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(65535),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_AND_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7241,
        GIR_EraseRootFromParent_Done,
      // Label 468: @40827
      GIM_Try, /*On fail goto*//*Label 469*/ GIMT_Encode4(40884), // Rule ID 7242 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36200),
        // (build_vector:{ *:[v2i16] } VGPR_32:{ *:[i16] }:$src1, 0:{ *:[i16] })<<P:Predicate_anonymous_36200>>  =>  (V_AND_B32_e64:{ *:[v2i16] } (V_MOV_B32_e32:{ *:[i32] } 65535:{ *:[i32] }), VGPR_32:{ *:[i16] }:$src1)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MOV_B32_e32),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(65535),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7242,
        GIR_EraseRootFromParent_Done,
      // Label 469: @40884
      GIM_Try, /*On fail goto*//*Label 470*/ GIMT_Encode4(40926), // Rule ID 7247 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36198),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (build_vector:{ *:[v2i16] } (undef:{ *:[i16] }), SReg_32:{ *:[i16] }:$src1)<<P:Predicate_anonymous_36198>>  =>  (S_LSHL_B32:{ *:[v2i16] }:{ *:[i1] } SReg_32:{ *:[i16] }:$src1, 16:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7247,
        GIR_EraseRootFromParent_Done,
      // Label 470: @40926
      GIM_Try, /*On fail goto*//*Label 471*/ GIMT_Encode4(40965), // Rule ID 7248 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36200),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (build_vector:{ *:[v2i16] } (undef:{ *:[i16] }), VGPR_32:{ *:[i16] }:$src1)<<P:Predicate_anonymous_36200>>  =>  (V_LSHLREV_B32_e64:{ *:[v2i16] } 16:{ *:[i32] }, VGPR_32:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHLREV_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7248,
        GIR_EraseRootFromParent_Done,
      // Label 471: @40965
      GIM_Try, /*On fail goto*//*Label 472*/ GIMT_Encode4(41007), // Rule ID 7251 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36198),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (build_vector:{ *:[v2f16] } (undef:{ *:[f16] }), SReg_32:{ *:[f16] }:$src1)<<P:Predicate_anonymous_36198>>  =>  (S_LSHL_B32:{ *:[v2f16] }:{ *:[i1] } SReg_32:{ *:[f16] }:$src1, 16:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7251,
        GIR_EraseRootFromParent_Done,
      // Label 472: @41007
      GIM_Try, /*On fail goto*//*Label 473*/ GIMT_Encode4(41046), // Rule ID 7252 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36200),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (build_vector:{ *:[v2f16] } (undef:{ *:[f16] }), VGPR_32:{ *:[f16] }:$src1)<<P:Predicate_anonymous_36200>>  =>  (V_LSHLREV_B32_e64:{ *:[v2f16] } 16:{ *:[i32] }, VGPR_32:{ *:[f16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHLREV_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7252,
        GIR_EraseRootFromParent_Done,
      // Label 473: @41046
      GIM_Try, /*On fail goto*//*Label 474*/ GIMT_Encode4(41088), // Rule ID 7255 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36198),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (build_vector:{ *:[v2bf16] } (undef:{ *:[bf16] }), SReg_32:{ *:[bf16] }:$src1)<<P:Predicate_anonymous_36198>>  =>  (S_LSHL_B32:{ *:[v2bf16] }:{ *:[i1] } SReg_32:{ *:[bf16] }:$src1, 16:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7255,
        GIR_EraseRootFromParent_Done,
      // Label 474: @41088
      GIM_Try, /*On fail goto*//*Label 475*/ GIMT_Encode4(41127), // Rule ID 7256 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36200),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (build_vector:{ *:[v2bf16] } (undef:{ *:[bf16] }), VGPR_32:{ *:[bf16] }:$src1)<<P:Predicate_anonymous_36200>>  =>  (V_LSHLREV_B32_e64:{ *:[v2bf16] } 16:{ *:[i32] }, VGPR_32:{ *:[bf16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHLREV_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7256,
        GIR_EraseRootFromParent_Done,
      // Label 475: @41127
      GIM_Try, /*On fail goto*//*Label 476*/ GIMT_Encode4(41167), // Rule ID 7245 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36198),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (build_vector:{ *:[v2i16] } SReg_32:{ *:[i16] }:$src0, (undef:{ *:[i16] }))<<P:Predicate_anonymous_36198>>  =>  (COPY_TO_REGCLASS:{ *:[v2i16] } SReg_32:{ *:[i16] }:$src0, SReg_32:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        // GIR_Coverage, 7245,
        GIR_EraseRootFromParent_Done,
      // Label 476: @41167
      GIM_Try, /*On fail goto*//*Label 477*/ GIMT_Encode4(41207), // Rule ID 7246 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36200),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (build_vector:{ *:[v2i16] } VGPR_32:{ *:[i16] }:$src0, (undef:{ *:[i16] }))<<P:Predicate_anonymous_36200>>  =>  (COPY_TO_REGCLASS:{ *:[v2i16] } VGPR_32:{ *:[i16] }:$src0, VGPR_32:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 7246,
        GIR_EraseRootFromParent_Done,
      // Label 477: @41207
      GIM_Try, /*On fail goto*//*Label 478*/ GIMT_Encode4(41247), // Rule ID 7249 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36198),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (build_vector:{ *:[v2f16] } SReg_32:{ *:[f16] }:$src0, (undef:{ *:[f16] }))<<P:Predicate_anonymous_36198>>  =>  (COPY_TO_REGCLASS:{ *:[v2f16] } SReg_32:{ *:[f16] }:$src0, SReg_32:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        // GIR_Coverage, 7249,
        GIR_EraseRootFromParent_Done,
      // Label 478: @41247
      GIM_Try, /*On fail goto*//*Label 479*/ GIMT_Encode4(41287), // Rule ID 7250 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36200),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (build_vector:{ *:[v2f16] } VGPR_32:{ *:[f16] }:$src0, (undef:{ *:[f16] }))<<P:Predicate_anonymous_36200>>  =>  (COPY_TO_REGCLASS:{ *:[v2f16] } VGPR_32:{ *:[f16] }:$src0, VGPR_32:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 7250,
        GIR_EraseRootFromParent_Done,
      // Label 479: @41287
      GIM_Try, /*On fail goto*//*Label 480*/ GIMT_Encode4(41327), // Rule ID 7253 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36198),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (build_vector:{ *:[v2bf16] } SReg_32:{ *:[bf16] }:$src0, (undef:{ *:[bf16] }))<<P:Predicate_anonymous_36198>>  =>  (COPY_TO_REGCLASS:{ *:[v2bf16] } SReg_32:{ *:[bf16] }:$src0, SReg_32:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        // GIR_Coverage, 7253,
        GIR_EraseRootFromParent_Done,
      // Label 480: @41327
      GIM_Try, /*On fail goto*//*Label 481*/ GIMT_Encode4(41445),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36200),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_Try, /*On fail goto*//*Label 482*/ GIMT_Encode4(41372), // Rule ID 7254 //
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (build_vector:{ *:[v2bf16] } VGPR_32:{ *:[bf16] }:$src0, (undef:{ *:[bf16] }))<<P:Predicate_anonymous_36200>>  =>  (COPY_TO_REGCLASS:{ *:[v2bf16] } VGPR_32:{ *:[bf16] }:$src0, VGPR_32:{ *:[i32] })
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/1, // src0
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
          // GIR_Coverage, 7254,
          GIR_EraseRootFromParent_Done,
        // Label 482: @41372
        GIM_Try, /*On fail goto*//*Label 483*/ GIMT_Encode4(41444), // Rule ID 7257 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVOP3PInsts),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
          // (build_vector:{ *:[v2i16] } VGPR_32:{ *:[i16] }:$src0, VGPR_32:{ *:[i16] }:$src1)<<P:Predicate_anonymous_36200>>  =>  (V_LSHL_OR_B32_e64:{ *:[v2i16] } ?:{ *:[i16] }:$src1, 16:{ *:[i32] }, (V_AND_B32_e64:{ *:[i32] } (V_MOV_B32_e32:{ *:[i32] } 65535:{ *:[i32] }), ?:{ *:[i16] }:$src0))
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AMDGPU::V_MOV_B32_e32),
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
          GIR_AddImm, /*InsnID*/2, /*Imm*/GIMT_Encode8(65535),
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B32_e64),
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
          GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src0
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_OR_B32_e64),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src1
          GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
          GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 7257,
          GIR_EraseRootFromParent_Done,
        // Label 483: @41444
        GIM_Reject,
      // Label 481: @41445
      GIM_Try, /*On fail goto*//*Label 484*/ GIMT_Encode4(41476), // Rule ID 7260 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVOP3PInsts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36198),
        // (build_vector:{ *:[v2i16] } SReg_32:{ *:[i16] }:$src0, SReg_32:{ *:[i16] }:$src1)<<P:Predicate_anonymous_36198>>  =>  (S_PACK_LL_B32_B16:{ *:[v2i16] } SReg_32:{ *:[i16] }:$src0, SReg_32:{ *:[i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_PACK_LL_B32_B16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7260,
        GIR_Done,
      // Label 484: @41476
      GIM_Try, /*On fail goto*//*Label 485*/ GIMT_Encode4(41538), // Rule ID 7261 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVOP3PInsts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36200),
        // (build_vector:{ *:[v2i16] } VGPR_32:{ *:[i16] }:$a, VGPR_32:{ *:[i16] }:$b)<<P:Predicate_anonymous_36200>>  =>  (V_PERM_B32_e64:{ *:[v2i16] } VGPR_32:{ *:[i16] }:$b, VGPR_32:{ *:[i16] }:$a, (S_MOV_B32:{ *:[i16] } 84148480:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::S_MOV_B32),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(84148480),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PERM_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // b
        GIR_RootToRootCopy, /*OpIdx*/1, // a
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7261,
        GIR_EraseRootFromParent_Done,
      // Label 485: @41538
      GIM_Try, /*On fail goto*//*Label 486*/ GIMT_Encode4(41569), // Rule ID 7266 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVOP3PInsts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36198),
        // (build_vector:{ *:[v2f16] } SReg_32:{ *:[f16] }:$src0, SReg_32:{ *:[f16] }:$src1)<<P:Predicate_anonymous_36198>>  =>  (S_PACK_LL_B32_B16:{ *:[v2f16] } SReg_32:{ *:[f16] }:$src0, SReg_32:{ *:[f16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_PACK_LL_B32_B16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7266,
        GIR_Done,
      // Label 486: @41569
      GIM_Try, /*On fail goto*//*Label 487*/ GIMT_Encode4(41631), // Rule ID 7267 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVOP3PInsts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36200),
        // (build_vector:{ *:[v2f16] } VGPR_32:{ *:[f16] }:$a, VGPR_32:{ *:[f16] }:$b)<<P:Predicate_anonymous_36200>>  =>  (V_PERM_B32_e64:{ *:[v2f16] } VGPR_32:{ *:[f16] }:$b, VGPR_32:{ *:[f16] }:$a, (S_MOV_B32:{ *:[i16] } 84148480:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::S_MOV_B32),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(84148480),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PERM_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // b
        GIR_RootToRootCopy, /*OpIdx*/1, // a
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7267,
        GIR_EraseRootFromParent_Done,
      // Label 487: @41631
      GIM_Try, /*On fail goto*//*Label 488*/ GIMT_Encode4(41662), // Rule ID 7272 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVOP3PInsts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36198),
        // (build_vector:{ *:[v2bf16] } SReg_32:{ *:[bf16] }:$src0, SReg_32:{ *:[bf16] }:$src1)<<P:Predicate_anonymous_36198>>  =>  (S_PACK_LL_B32_B16:{ *:[v2bf16] } SReg_32:{ *:[bf16] }:$src0, SReg_32:{ *:[bf16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_PACK_LL_B32_B16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7272,
        GIR_Done,
      // Label 488: @41662
      GIM_Try, /*On fail goto*//*Label 489*/ GIMT_Encode4(41724), // Rule ID 7273 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVOP3PInsts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_36200),
        // (build_vector:{ *:[v2bf16] } VGPR_32:{ *:[bf16] }:$a, VGPR_32:{ *:[bf16] }:$b)<<P:Predicate_anonymous_36200>>  =>  (V_PERM_B32_e64:{ *:[v2bf16] } VGPR_32:{ *:[bf16] }:$b, VGPR_32:{ *:[bf16] }:$a, (S_MOV_B32:{ *:[i16] } 84148480:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::S_MOV_B32),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(84148480),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PERM_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // b
        GIR_RootToRootCopy, /*OpIdx*/1, // a
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7273,
        GIR_EraseRootFromParent_Done,
      // Label 489: @41724
      GIM_Reject,
    // Label 442: @41725
    GIM_Reject,
    // Label 8: @41726
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(8), GIMT_Encode2(34), /*)*//*default:*//*Label 516*/ GIMT_Encode4(50198),
    /*GILLT_s16*//*Label 490*/ GIMT_Encode4(41841),
    /*GILLT_s32*//*Label 491*/ GIMT_Encode4(42163),
    /*GILLT_s64*//*Label 492*/ GIMT_Encode4(42512),
    /*GILLT_v2s16*//*Label 493*/ GIMT_Encode4(42861),
    /*GILLT_v2s32*//*Label 494*/ GIMT_Encode4(43384),
    /*GILLT_v2s64*//*Label 495*/ GIMT_Encode4(43762),
    /*GILLT_v3s32*//*Label 496*/ GIMT_Encode4(44169),
    /*GILLT_v3s64*//*Label 497*/ GIMT_Encode4(44223),
    /*GILLT_v4s16*//*Label 498*/ GIMT_Encode4(44398),
    /*GILLT_v4s32*//*Label 499*/ GIMT_Encode4(44921),
    /*GILLT_v4s64*//*Label 500*/ GIMT_Encode4(45328),
    /*GILLT_v5s32*//*Label 501*/ GIMT_Encode4(45677),
    /*GILLT_v6s32*//*Label 502*/ GIMT_Encode4(45791),
    /*GILLT_v7s32*//*Label 503*/ GIMT_Encode4(46024),
    /*GILLT_v8s16*//*Label 504*/ GIMT_Encode4(46138),
    /*GILLT_v8s32*//*Label 505*/ GIMT_Encode4(46951),
    /*GILLT_v8s64*//*Label 506*/ GIMT_Encode4(47358),
    /*GILLT_v9s32*//*Label 507*/ GIMT_Encode4(47649),
    /*GILLT_v10s32*//*Label 508*/ GIMT_Encode4(47763),
    /*GILLT_v11s32*//*Label 509*/ GIMT_Encode4(47877),
    /*GILLT_v12s32*//*Label 510*/ GIMT_Encode4(47991),
    /*GILLT_v16s16*//*Label 511*/ GIMT_Encode4(48105),
    /*GILLT_v16s32*//*Label 512*/ GIMT_Encode4(48802),
    /*GILLT_v16s64*//*Label 513*/ GIMT_Encode4(49209),
    /*GILLT_v32s16*//*Label 514*/ GIMT_Encode4(49384),
    /*GILLT_v32s32*//*Label 515*/ GIMT_Encode4(50023),
    // Label 490: @41841
    GIM_Try, /*On fail goto*//*Label 517*/ GIMT_Encode4(42162),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_Try, /*On fail goto*//*Label 518*/ GIMT_Encode4(41875), // Rule ID 6712 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (bitconvert:{ *:[i16] } VGPR_32:{ *:[f16] }:$src0)  =>  VGPR_32:{ *:[i16] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 6712,
        GIR_EraseRootFromParent_Done,
      // Label 518: @41875
      GIM_Try, /*On fail goto*//*Label 519*/ GIMT_Encode4(41901), // Rule ID 6713 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (bitconvert:{ *:[f16] } VGPR_32:{ *:[i16] }:$src0)  =>  VGPR_32:{ *:[f16] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 6713,
        GIR_EraseRootFromParent_Done,
      // Label 519: @41901
      GIM_Try, /*On fail goto*//*Label 520*/ GIMT_Encode4(41927), // Rule ID 6714 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (bitconvert:{ *:[f16] } VGPR_32:{ *:[bf16] }:$src0)  =>  VGPR_32:{ *:[f16] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 6714,
        GIR_EraseRootFromParent_Done,
      // Label 520: @41927
      GIM_Try, /*On fail goto*//*Label 521*/ GIMT_Encode4(41953), // Rule ID 6715 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (bitconvert:{ *:[bf16] } VGPR_32:{ *:[f16] }:$src0)  =>  VGPR_32:{ *:[bf16] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 6715,
        GIR_EraseRootFromParent_Done,
      // Label 521: @41953
      GIM_Try, /*On fail goto*//*Label 522*/ GIMT_Encode4(41979), // Rule ID 6716 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        // (bitconvert:{ *:[i16] } SReg_32:{ *:[f16] }:$src0)  =>  SReg_32:{ *:[i16] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        // GIR_Coverage, 6716,
        GIR_EraseRootFromParent_Done,
      // Label 522: @41979
      GIM_Try, /*On fail goto*//*Label 523*/ GIMT_Encode4(42005), // Rule ID 6717 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        // (bitconvert:{ *:[f16] } SReg_32:{ *:[i16] }:$src0)  =>  SReg_32:{ *:[f16] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        // GIR_Coverage, 6717,
        GIR_EraseRootFromParent_Done,
      // Label 523: @42005
      GIM_Try, /*On fail goto*//*Label 524*/ GIMT_Encode4(42031), // Rule ID 6718 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        // (bitconvert:{ *:[f16] } SReg_32:{ *:[bf16] }:$src0)  =>  SReg_32:{ *:[f16] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        // GIR_Coverage, 6718,
        GIR_EraseRootFromParent_Done,
      // Label 524: @42031
      GIM_Try, /*On fail goto*//*Label 525*/ GIMT_Encode4(42057), // Rule ID 6719 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        // (bitconvert:{ *:[bf16] } SReg_32:{ *:[f16] }:$src0)  =>  SReg_32:{ *:[bf16] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        // GIR_Coverage, 6719,
        GIR_EraseRootFromParent_Done,
      // Label 525: @42057
      GIM_Try, /*On fail goto*//*Label 526*/ GIMT_Encode4(42083), // Rule ID 6720 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (bitconvert:{ *:[i16] } VGPR_32:{ *:[bf16] }:$src0)  =>  VGPR_32:{ *:[i16] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 6720,
        GIR_EraseRootFromParent_Done,
      // Label 526: @42083
      GIM_Try, /*On fail goto*//*Label 527*/ GIMT_Encode4(42109), // Rule ID 6721 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (bitconvert:{ *:[bf16] } VGPR_32:{ *:[i16] }:$src0)  =>  VGPR_32:{ *:[bf16] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 6721,
        GIR_EraseRootFromParent_Done,
      // Label 527: @42109
      GIM_Try, /*On fail goto*//*Label 528*/ GIMT_Encode4(42135), // Rule ID 6722 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        // (bitconvert:{ *:[i16] } SReg_32:{ *:[bf16] }:$src0)  =>  SReg_32:{ *:[i16] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        // GIR_Coverage, 6722,
        GIR_EraseRootFromParent_Done,
      // Label 528: @42135
      GIM_Try, /*On fail goto*//*Label 529*/ GIMT_Encode4(42161), // Rule ID 6723 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        // (bitconvert:{ *:[bf16] } SReg_32:{ *:[i16] }:$src0)  =>  SReg_32:{ *:[bf16] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        // GIR_Coverage, 6723,
        GIR_EraseRootFromParent_Done,
      // Label 529: @42161
      GIM_Reject,
    // Label 517: @42162
    GIM_Reject,
    // Label 491: @42163
    GIM_Try, /*On fail goto*//*Label 530*/ GIMT_Encode4(42192), // Rule ID 6724 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      // (bitconvert:{ *:[i32] } VGPR_32:{ *:[f32] }:$src0)  =>  VGPR_32:{ *:[i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      // GIR_Coverage, 6724,
      GIR_EraseRootFromParent_Done,
    // Label 530: @42192
    GIM_Try, /*On fail goto*//*Label 531*/ GIMT_Encode4(42221), // Rule ID 6725 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      // (bitconvert:{ *:[f32] } VGPR_32:{ *:[i32] }:$src0)  =>  VGPR_32:{ *:[f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      // GIR_Coverage, 6725,
      GIR_EraseRootFromParent_Done,
    // Label 531: @42221
    GIM_Try, /*On fail goto*//*Label 532*/ GIMT_Encode4(42250), // Rule ID 6726 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // (bitconvert:{ *:[i32] } SReg_32:{ *:[f32] }:$src0)  =>  SReg_32:{ *:[i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // GIR_Coverage, 6726,
      GIR_EraseRootFromParent_Done,
    // Label 532: @42250
    GIM_Try, /*On fail goto*//*Label 533*/ GIMT_Encode4(42279), // Rule ID 6727 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // (bitconvert:{ *:[f32] } SReg_32:{ *:[i32] }:$src0)  =>  SReg_32:{ *:[f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // GIR_Coverage, 6727,
      GIR_EraseRootFromParent_Done,
    // Label 533: @42279
    GIM_Try, /*On fail goto*//*Label 534*/ GIMT_Encode4(42308), // Rule ID 6729 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // (bitconvert:{ *:[i32] } SReg_32:{ *:[v2i16] }:$src0)  =>  SReg_32:{ *:[i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // GIR_Coverage, 6729,
      GIR_EraseRootFromParent_Done,
    // Label 534: @42308
    GIM_Try, /*On fail goto*//*Label 535*/ GIMT_Encode4(42337), // Rule ID 6731 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // (bitconvert:{ *:[i32] } SReg_32:{ *:[v2f16] }:$src0)  =>  SReg_32:{ *:[i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // GIR_Coverage, 6731,
      GIR_EraseRootFromParent_Done,
    // Label 535: @42337
    GIM_Try, /*On fail goto*//*Label 536*/ GIMT_Encode4(42366), // Rule ID 6735 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // (bitconvert:{ *:[f32] } SReg_32:{ *:[v2f16] }:$src0)  =>  SReg_32:{ *:[f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // GIR_Coverage, 6735,
      GIR_EraseRootFromParent_Done,
    // Label 536: @42366
    GIM_Try, /*On fail goto*//*Label 537*/ GIMT_Encode4(42395), // Rule ID 6737 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // (bitconvert:{ *:[f32] } SReg_32:{ *:[v2i16] }:$src0)  =>  SReg_32:{ *:[f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // GIR_Coverage, 6737,
      GIR_EraseRootFromParent_Done,
    // Label 537: @42395
    GIM_Try, /*On fail goto*//*Label 538*/ GIMT_Encode4(42424), // Rule ID 6739 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // (bitconvert:{ *:[i32] } SReg_32:{ *:[v2bf16] }:$src0)  =>  SReg_32:{ *:[i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // GIR_Coverage, 6739,
      GIR_EraseRootFromParent_Done,
    // Label 538: @42424
    GIM_Try, /*On fail goto*//*Label 539*/ GIMT_Encode4(42453), // Rule ID 6741 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      // (bitconvert:{ *:[i32] } VGPR_32:{ *:[v2bf16] }:$src0)  =>  VGPR_32:{ *:[i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      // GIR_Coverage, 6741,
      GIR_EraseRootFromParent_Done,
    // Label 539: @42453
    GIM_Try, /*On fail goto*//*Label 540*/ GIMT_Encode4(42482), // Rule ID 6750 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      // (bitconvert:{ *:[f32] } VGPR_32:{ *:[v2bf16] }:$src0)  =>  VGPR_32:{ *:[f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      // GIR_Coverage, 6750,
      GIR_EraseRootFromParent_Done,
    // Label 540: @42482
    GIM_Try, /*On fail goto*//*Label 541*/ GIMT_Encode4(42511), // Rule ID 6752 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // (bitconvert:{ *:[f32] } SReg_32:{ *:[v2bf16] }:$src0)  =>  SReg_32:{ *:[f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // GIR_Coverage, 6752,
      GIR_EraseRootFromParent_Done,
    // Label 541: @42511
    GIM_Reject,
    // Label 492: @42512
    GIM_Try, /*On fail goto*//*Label 542*/ GIMT_Encode4(42541), // Rule ID 6754 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[i64] } VReg_64:{ *:[f64] }:$src0)  =>  VReg_64:{ *:[i64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6754,
      GIR_EraseRootFromParent_Done,
    // Label 542: @42541
    GIM_Try, /*On fail goto*//*Label 543*/ GIMT_Encode4(42570), // Rule ID 6755 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[f64] } VReg_64:{ *:[i64] }:$src0)  =>  VReg_64:{ *:[f64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6755,
      GIR_EraseRootFromParent_Done,
    // Label 543: @42570
    GIM_Try, /*On fail goto*//*Label 544*/ GIMT_Encode4(42599), // Rule ID 6758 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[i64] } VReg_64:{ *:[v2i32] }:$src0)  =>  VReg_64:{ *:[i64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6758,
      GIR_EraseRootFromParent_Done,
    // Label 544: @42599
    GIM_Try, /*On fail goto*//*Label 545*/ GIMT_Encode4(42628), // Rule ID 6760 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[i64] } VReg_64:{ *:[v2f32] }:$src0)  =>  VReg_64:{ *:[i64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6760,
      GIR_EraseRootFromParent_Done,
    // Label 545: @42628
    GIM_Try, /*On fail goto*//*Label 546*/ GIMT_Encode4(42657), // Rule ID 6762 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[f64] } VReg_64:{ *:[v2f32] }:$src0)  =>  VReg_64:{ *:[f64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6762,
      GIR_EraseRootFromParent_Done,
    // Label 546: @42657
    GIM_Try, /*On fail goto*//*Label 547*/ GIMT_Encode4(42686), // Rule ID 6764 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[f64] } VReg_64:{ *:[v2i32] }:$src0)  =>  VReg_64:{ *:[f64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6764,
      GIR_EraseRootFromParent_Done,
    // Label 547: @42686
    GIM_Try, /*On fail goto*//*Label 548*/ GIMT_Encode4(42715), // Rule ID 6771 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[i64] } VReg_64:{ *:[v4bf16] }:$src0)  =>  VReg_64:{ *:[i64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6771,
      GIR_EraseRootFromParent_Done,
    // Label 548: @42715
    GIM_Try, /*On fail goto*//*Label 549*/ GIMT_Encode4(42744), // Rule ID 6779 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[f64] } VReg_64:{ *:[v4bf16] }:$src0)  =>  VReg_64:{ *:[f64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6779,
      GIR_EraseRootFromParent_Done,
    // Label 549: @42744
    GIM_Try, /*On fail goto*//*Label 550*/ GIMT_Encode4(42773), // Rule ID 6791 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[f64] } VReg_64:{ *:[v4i16] }:$src0)  =>  VReg_64:{ *:[f64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6791,
      GIR_EraseRootFromParent_Done,
    // Label 550: @42773
    GIM_Try, /*On fail goto*//*Label 551*/ GIMT_Encode4(42802), // Rule ID 6792 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[f64] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[f64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6792,
      GIR_EraseRootFromParent_Done,
    // Label 551: @42802
    GIM_Try, /*On fail goto*//*Label 552*/ GIMT_Encode4(42831), // Rule ID 6795 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[i64] } VReg_64:{ *:[v4i16] }:$src0)  =>  VReg_64:{ *:[i64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6795,
      GIR_EraseRootFromParent_Done,
    // Label 552: @42831
    GIM_Try, /*On fail goto*//*Label 553*/ GIMT_Encode4(42860), // Rule ID 6796 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[i64] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[i64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6796,
      GIR_EraseRootFromParent_Done,
    // Label 553: @42860
    GIM_Reject,
    // Label 493: @42861
    GIM_Try, /*On fail goto*//*Label 554*/ GIMT_Encode4(42890), // Rule ID 6728 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // (bitconvert:{ *:[v2i16] } SReg_32:{ *:[i32] }:$src0)  =>  SReg_32:{ *:[v2i16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // GIR_Coverage, 6728,
      GIR_EraseRootFromParent_Done,
    // Label 554: @42890
    GIM_Try, /*On fail goto*//*Label 555*/ GIMT_Encode4(42919), // Rule ID 6730 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // (bitconvert:{ *:[v2f16] } SReg_32:{ *:[i32] }:$src0)  =>  SReg_32:{ *:[v2f16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // GIR_Coverage, 6730,
      GIR_EraseRootFromParent_Done,
    // Label 555: @42919
    GIM_Try, /*On fail goto*//*Label 556*/ GIMT_Encode4(42948), // Rule ID 6732 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // (bitconvert:{ *:[v2i16] } SReg_32:{ *:[v2f16] }:$src0)  =>  SReg_32:{ *:[v2i16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // GIR_Coverage, 6732,
      GIR_EraseRootFromParent_Done,
    // Label 556: @42948
    GIM_Try, /*On fail goto*//*Label 557*/ GIMT_Encode4(42977), // Rule ID 6733 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // (bitconvert:{ *:[v2f16] } SReg_32:{ *:[v2i16] }:$src0)  =>  SReg_32:{ *:[v2f16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // GIR_Coverage, 6733,
      GIR_EraseRootFromParent_Done,
    // Label 557: @42977
    GIM_Try, /*On fail goto*//*Label 558*/ GIMT_Encode4(43006), // Rule ID 6734 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // (bitconvert:{ *:[v2f16] } SReg_32:{ *:[f32] }:$src0)  =>  SReg_32:{ *:[v2f16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // GIR_Coverage, 6734,
      GIR_EraseRootFromParent_Done,
    // Label 558: @43006
    GIM_Try, /*On fail goto*//*Label 559*/ GIMT_Encode4(43035), // Rule ID 6736 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // (bitconvert:{ *:[v2i16] } SReg_32:{ *:[f32] }:$src0)  =>  SReg_32:{ *:[v2i16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // GIR_Coverage, 6736,
      GIR_EraseRootFromParent_Done,
    // Label 559: @43035
    GIM_Try, /*On fail goto*//*Label 560*/ GIMT_Encode4(43064), // Rule ID 6738 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // (bitconvert:{ *:[v2bf16] } SReg_32:{ *:[i32] }:$src0)  =>  SReg_32:{ *:[v2bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // GIR_Coverage, 6738,
      GIR_EraseRootFromParent_Done,
    // Label 560: @43064
    GIM_Try, /*On fail goto*//*Label 561*/ GIMT_Encode4(43093), // Rule ID 6740 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      // (bitconvert:{ *:[v2bf16] } VGPR_32:{ *:[i32] }:$src0)  =>  VGPR_32:{ *:[v2bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      // GIR_Coverage, 6740,
      GIR_EraseRootFromParent_Done,
    // Label 561: @43093
    GIM_Try, /*On fail goto*//*Label 562*/ GIMT_Encode4(43122), // Rule ID 6742 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // (bitconvert:{ *:[v2bf16] } SReg_32:{ *:[v2i16] }:$src0)  =>  SReg_32:{ *:[v2bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // GIR_Coverage, 6742,
      GIR_EraseRootFromParent_Done,
    // Label 562: @43122
    GIM_Try, /*On fail goto*//*Label 563*/ GIMT_Encode4(43151), // Rule ID 6743 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // (bitconvert:{ *:[v2i16] } SReg_32:{ *:[v2bf16] }:$src0)  =>  SReg_32:{ *:[v2i16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // GIR_Coverage, 6743,
      GIR_EraseRootFromParent_Done,
    // Label 563: @43151
    GIM_Try, /*On fail goto*//*Label 564*/ GIMT_Encode4(43180), // Rule ID 6744 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      // (bitconvert:{ *:[v2bf16] } VGPR_32:{ *:[v2i16] }:$src0)  =>  VGPR_32:{ *:[v2bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      // GIR_Coverage, 6744,
      GIR_EraseRootFromParent_Done,
    // Label 564: @43180
    GIM_Try, /*On fail goto*//*Label 565*/ GIMT_Encode4(43209), // Rule ID 6745 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      // (bitconvert:{ *:[v2i16] } VGPR_32:{ *:[v2bf16] }:$src0)  =>  VGPR_32:{ *:[v2i16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      // GIR_Coverage, 6745,
      GIR_EraseRootFromParent_Done,
    // Label 565: @43209
    GIM_Try, /*On fail goto*//*Label 566*/ GIMT_Encode4(43238), // Rule ID 6746 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // (bitconvert:{ *:[v2bf16] } SReg_32:{ *:[v2f16] }:$src0)  =>  SReg_32:{ *:[v2bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // GIR_Coverage, 6746,
      GIR_EraseRootFromParent_Done,
    // Label 566: @43238
    GIM_Try, /*On fail goto*//*Label 567*/ GIMT_Encode4(43267), // Rule ID 6747 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // (bitconvert:{ *:[v2f16] } SReg_32:{ *:[v2bf16] }:$src0)  =>  SReg_32:{ *:[v2f16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // GIR_Coverage, 6747,
      GIR_EraseRootFromParent_Done,
    // Label 567: @43267
    GIM_Try, /*On fail goto*//*Label 568*/ GIMT_Encode4(43296), // Rule ID 6748 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      // (bitconvert:{ *:[v2bf16] } VGPR_32:{ *:[v2f16] }:$src0)  =>  VGPR_32:{ *:[v2bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      // GIR_Coverage, 6748,
      GIR_EraseRootFromParent_Done,
    // Label 568: @43296
    GIM_Try, /*On fail goto*//*Label 569*/ GIMT_Encode4(43325), // Rule ID 6749 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      // (bitconvert:{ *:[v2f16] } VGPR_32:{ *:[v2bf16] }:$src0)  =>  VGPR_32:{ *:[v2f16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      // GIR_Coverage, 6749,
      GIR_EraseRootFromParent_Done,
    // Label 569: @43325
    GIM_Try, /*On fail goto*//*Label 570*/ GIMT_Encode4(43354), // Rule ID 6751 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      // (bitconvert:{ *:[v2bf16] } VGPR_32:{ *:[f32] }:$src0)  =>  VGPR_32:{ *:[v2bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      // GIR_Coverage, 6751,
      GIR_EraseRootFromParent_Done,
    // Label 570: @43354
    GIM_Try, /*On fail goto*//*Label 571*/ GIMT_Encode4(43383), // Rule ID 6753 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // (bitconvert:{ *:[v2bf16] } SReg_32:{ *:[f32] }:$src0)  =>  SReg_32:{ *:[v2bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_32RegClassID),
      // GIR_Coverage, 6753,
      GIR_EraseRootFromParent_Done,
    // Label 571: @43383
    GIM_Reject,
    // Label 494: @43384
    GIM_Try, /*On fail goto*//*Label 572*/ GIMT_Encode4(43413), // Rule ID 6756 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[v2f32] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6756,
      GIR_EraseRootFromParent_Done,
    // Label 572: @43413
    GIM_Try, /*On fail goto*//*Label 573*/ GIMT_Encode4(43442), // Rule ID 6757 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v2f32] } VReg_64:{ *:[v2i32] }:$src0)  =>  VReg_64:{ *:[v2f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6757,
      GIR_EraseRootFromParent_Done,
    // Label 573: @43442
    GIM_Try, /*On fail goto*//*Label 574*/ GIMT_Encode4(43471), // Rule ID 6759 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[i64] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6759,
      GIR_EraseRootFromParent_Done,
    // Label 574: @43471
    GIM_Try, /*On fail goto*//*Label 575*/ GIMT_Encode4(43500), // Rule ID 6761 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v2f32] } VReg_64:{ *:[i64] }:$src0)  =>  VReg_64:{ *:[v2f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6761,
      GIR_EraseRootFromParent_Done,
    // Label 575: @43500
    GIM_Try, /*On fail goto*//*Label 576*/ GIMT_Encode4(43529), // Rule ID 6763 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v2f32] } VReg_64:{ *:[f64] }:$src0)  =>  VReg_64:{ *:[v2f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6763,
      GIR_EraseRootFromParent_Done,
    // Label 576: @43529
    GIM_Try, /*On fail goto*//*Label 577*/ GIMT_Encode4(43558), // Rule ID 6765 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[f64] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6765,
      GIR_EraseRootFromParent_Done,
    // Label 577: @43558
    GIM_Try, /*On fail goto*//*Label 578*/ GIMT_Encode4(43587), // Rule ID 6769 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[v4bf16] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6769,
      GIR_EraseRootFromParent_Done,
    // Label 578: @43587
    GIM_Try, /*On fail goto*//*Label 579*/ GIMT_Encode4(43616), // Rule ID 6777 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v2f32] } VReg_64:{ *:[v4bf16] }:$src0)  =>  VReg_64:{ *:[v2f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6777,
      GIR_EraseRootFromParent_Done,
    // Label 579: @43616
    GIM_Try, /*On fail goto*//*Label 580*/ GIMT_Encode4(43645), // Rule ID 6780 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6780,
      GIR_EraseRootFromParent_Done,
    // Label 580: @43645
    GIM_Try, /*On fail goto*//*Label 581*/ GIMT_Encode4(43674), // Rule ID 6782 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6782,
      GIR_EraseRootFromParent_Done,
    // Label 581: @43674
    GIM_Try, /*On fail goto*//*Label 582*/ GIMT_Encode4(43703), // Rule ID 6783 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[v4i16] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6783,
      GIR_EraseRootFromParent_Done,
    // Label 582: @43703
    GIM_Try, /*On fail goto*//*Label 583*/ GIMT_Encode4(43732), // Rule ID 6785 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v2f32] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[v2f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6785,
      GIR_EraseRootFromParent_Done,
    // Label 583: @43732
    GIM_Try, /*On fail goto*//*Label 584*/ GIMT_Encode4(43761), // Rule ID 6787 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v2f32] } VReg_64:{ *:[v4i16] }:$src0)  =>  VReg_64:{ *:[v2f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6787,
      GIR_EraseRootFromParent_Done,
    // Label 584: @43761
    GIM_Reject,
    // Label 495: @43762
    GIM_Try, /*On fail goto*//*Label 585*/ GIMT_Encode4(43791), // Rule ID 6801 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // (bitconvert:{ *:[v2i64] } SReg_128:{ *:[v4i32] }:$src0)  =>  SReg_128:{ *:[v2i64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // GIR_Coverage, 6801,
      GIR_EraseRootFromParent_Done,
    // Label 585: @43791
    GIM_Try, /*On fail goto*//*Label 586*/ GIMT_Encode4(43820), // Rule ID 6803 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v2f64] } VReg_128:{ *:[v4f32] }:$src0)  =>  VReg_128:{ *:[v2f64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6803,
      GIR_EraseRootFromParent_Done,
    // Label 586: @43820
    GIM_Try, /*On fail goto*//*Label 587*/ GIMT_Encode4(43849), // Rule ID 6804 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v2f64] } VReg_128:{ *:[v4i32] }:$src0)  =>  VReg_128:{ *:[v2f64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6804,
      GIR_EraseRootFromParent_Done,
    // Label 587: @43849
    GIM_Try, /*On fail goto*//*Label 588*/ GIMT_Encode4(43878), // Rule ID 6807 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v2i64] } VReg_128:{ *:[v2f64] }:$src0)  =>  VReg_128:{ *:[v2i64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6807,
      GIR_EraseRootFromParent_Done,
    // Label 588: @43878
    GIM_Try, /*On fail goto*//*Label 589*/ GIMT_Encode4(43907), // Rule ID 6808 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v2f64] } VReg_128:{ *:[v2i64] }:$src0)  =>  VReg_128:{ *:[v2f64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6808,
      GIR_EraseRootFromParent_Done,
    // Label 589: @43907
    GIM_Try, /*On fail goto*//*Label 590*/ GIMT_Encode4(43936), // Rule ID 6810 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v2i64] } VReg_128:{ *:[v4f32] }:$src0)  =>  VReg_128:{ *:[v2i64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6810,
      GIR_EraseRootFromParent_Done,
    // Label 590: @43936
    GIM_Try, /*On fail goto*//*Label 591*/ GIMT_Encode4(43965), // Rule ID 6827 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // (bitconvert:{ *:[v2i64] } SReg_128:{ *:[v8i16] }:$src0)  =>  SReg_128:{ *:[v2i64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // GIR_Coverage, 6827,
      GIR_EraseRootFromParent_Done,
    // Label 591: @43965
    GIM_Try, /*On fail goto*//*Label 592*/ GIMT_Encode4(43994), // Rule ID 6828 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // (bitconvert:{ *:[v2f64] } SReg_128:{ *:[v8i16] }:$src0)  =>  SReg_128:{ *:[v2f64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // GIR_Coverage, 6828,
      GIR_EraseRootFromParent_Done,
    // Label 592: @43994
    GIM_Try, /*On fail goto*//*Label 593*/ GIMT_Encode4(44023), // Rule ID 6829 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // (bitconvert:{ *:[v2i64] } SReg_128:{ *:[v8f16] }:$src0)  =>  SReg_128:{ *:[v2i64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // GIR_Coverage, 6829,
      GIR_EraseRootFromParent_Done,
    // Label 593: @44023
    GIM_Try, /*On fail goto*//*Label 594*/ GIMT_Encode4(44052), // Rule ID 6830 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // (bitconvert:{ *:[v2f64] } SReg_128:{ *:[v8f16] }:$src0)  =>  SReg_128:{ *:[v2f64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // GIR_Coverage, 6830,
      GIR_EraseRootFromParent_Done,
    // Label 594: @44052
    GIM_Try, /*On fail goto*//*Label 595*/ GIMT_Encode4(44081), // Rule ID 6847 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // (bitconvert:{ *:[v2f64] } SReg_128:{ *:[v8bf16] }:$src0)  =>  SReg_128:{ *:[v2f64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // GIR_Coverage, 6847,
      GIR_EraseRootFromParent_Done,
    // Label 595: @44081
    GIM_Try, /*On fail goto*//*Label 596*/ GIMT_Encode4(44110), // Rule ID 6849 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v2f64] } VReg_128:{ *:[v8bf16] }:$src0)  =>  VReg_128:{ *:[v2f64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6849,
      GIR_EraseRootFromParent_Done,
    // Label 596: @44110
    GIM_Try, /*On fail goto*//*Label 597*/ GIMT_Encode4(44139), // Rule ID 6851 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // (bitconvert:{ *:[v2i64] } SReg_128:{ *:[v8bf16] }:$src0)  =>  SReg_128:{ *:[v2i64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // GIR_Coverage, 6851,
      GIR_EraseRootFromParent_Done,
    // Label 597: @44139
    GIM_Try, /*On fail goto*//*Label 598*/ GIMT_Encode4(44168), // Rule ID 6853 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v2i64] } VReg_128:{ *:[v8bf16] }:$src0)  =>  VReg_128:{ *:[v2i64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6853,
      GIR_EraseRootFromParent_Done,
    // Label 598: @44168
    GIM_Reject,
    // Label 496: @44169
    GIM_Try, /*On fail goto*//*Label 599*/ GIMT_Encode4(44222),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v3s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SGPR_96RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SGPR_96RegClassID),
      GIM_Try, /*On fail goto*//*Label 600*/ GIMT_Encode4(44203), // Rule ID 6799 //
        // (bitconvert:{ *:[v3i32] } SGPR_96:{ *:[v3f32] }:$src0)  =>  SGPR_96:{ *:[v3i32] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SGPR_96RegClassID),
        // GIR_Coverage, 6799,
        GIR_EraseRootFromParent_Done,
      // Label 600: @44203
      GIM_Try, /*On fail goto*//*Label 601*/ GIMT_Encode4(44221), // Rule ID 6800 //
        // (bitconvert:{ *:[v3f32] } SGPR_96:{ *:[v3i32] }:$src0)  =>  SGPR_96:{ *:[v3f32] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SGPR_96RegClassID),
        // GIR_Coverage, 6800,
        GIR_EraseRootFromParent_Done,
      // Label 601: @44221
      GIM_Reject,
    // Label 599: @44222
    GIM_Reject,
    // Label 497: @44223
    GIM_Try, /*On fail goto*//*Label 602*/ GIMT_Encode4(44252), // Rule ID 6863 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v3s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      // (bitconvert:{ *:[v3i64] } VReg_192:{ *:[v3f64] }:$src0)  =>  VReg_192:{ *:[v3i64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      // GIR_Coverage, 6863,
      GIR_EraseRootFromParent_Done,
    // Label 602: @44252
    GIM_Try, /*On fail goto*//*Label 603*/ GIMT_Encode4(44281), // Rule ID 6864 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v3s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      // (bitconvert:{ *:[v3f64] } VReg_192:{ *:[v3i64] }:$src0)  =>  VReg_192:{ *:[v3f64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      // GIR_Coverage, 6864,
      GIR_EraseRootFromParent_Done,
    // Label 603: @44281
    GIM_Try, /*On fail goto*//*Label 604*/ GIMT_Encode4(44310), // Rule ID 6865 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v6s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      // (bitconvert:{ *:[v3i64] } VReg_192:{ *:[v6i32] }:$src0)  =>  VReg_192:{ *:[v3i64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      // GIR_Coverage, 6865,
      GIR_EraseRootFromParent_Done,
    // Label 604: @44310
    GIM_Try, /*On fail goto*//*Label 605*/ GIMT_Encode4(44339), // Rule ID 6866 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v6s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      // (bitconvert:{ *:[v3i64] } VReg_192:{ *:[v6f32] }:$src0)  =>  VReg_192:{ *:[v3i64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      // GIR_Coverage, 6866,
      GIR_EraseRootFromParent_Done,
    // Label 605: @44339
    GIM_Try, /*On fail goto*//*Label 606*/ GIMT_Encode4(44368), // Rule ID 6867 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v6s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      // (bitconvert:{ *:[v3f64] } VReg_192:{ *:[v6i32] }:$src0)  =>  VReg_192:{ *:[v3f64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      // GIR_Coverage, 6867,
      GIR_EraseRootFromParent_Done,
    // Label 606: @44368
    GIM_Try, /*On fail goto*//*Label 607*/ GIMT_Encode4(44397), // Rule ID 6868 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v6s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      // (bitconvert:{ *:[v3f64] } VReg_192:{ *:[v6f32] }:$src0)  =>  VReg_192:{ *:[v3f64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      // GIR_Coverage, 6868,
      GIR_EraseRootFromParent_Done,
    // Label 607: @44397
    GIM_Reject,
    // Label 498: @44398
    GIM_Try, /*On fail goto*//*Label 608*/ GIMT_Encode4(44427), // Rule ID 6766 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v4i16] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[v4i16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6766,
      GIR_EraseRootFromParent_Done,
    // Label 608: @44427
    GIM_Try, /*On fail goto*//*Label 609*/ GIMT_Encode4(44456), // Rule ID 6767 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v4f16] } VReg_64:{ *:[v4i16] }:$src0)  =>  VReg_64:{ *:[v4f16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6767,
      GIR_EraseRootFromParent_Done,
    // Label 609: @44456
    GIM_Try, /*On fail goto*//*Label 610*/ GIMT_Encode4(44485), // Rule ID 6768 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v4bf16] } VReg_64:{ *:[v2i32] }:$src0)  =>  VReg_64:{ *:[v4bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6768,
      GIR_EraseRootFromParent_Done,
    // Label 610: @44485
    GIM_Try, /*On fail goto*//*Label 611*/ GIMT_Encode4(44514), // Rule ID 6770 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v4bf16] } VReg_64:{ *:[i64] }:$src0)  =>  VReg_64:{ *:[v4bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6770,
      GIR_EraseRootFromParent_Done,
    // Label 611: @44514
    GIM_Try, /*On fail goto*//*Label 612*/ GIMT_Encode4(44543), // Rule ID 6772 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v4bf16] } VReg_64:{ *:[v4i16] }:$src0)  =>  VReg_64:{ *:[v4bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6772,
      GIR_EraseRootFromParent_Done,
    // Label 612: @44543
    GIM_Try, /*On fail goto*//*Label 613*/ GIMT_Encode4(44572), // Rule ID 6773 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v4i16] } VReg_64:{ *:[v4bf16] }:$src0)  =>  VReg_64:{ *:[v4i16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6773,
      GIR_EraseRootFromParent_Done,
    // Label 613: @44572
    GIM_Try, /*On fail goto*//*Label 614*/ GIMT_Encode4(44601), // Rule ID 6774 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v4bf16] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[v4bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6774,
      GIR_EraseRootFromParent_Done,
    // Label 614: @44601
    GIM_Try, /*On fail goto*//*Label 615*/ GIMT_Encode4(44630), // Rule ID 6775 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v4f16] } VReg_64:{ *:[v4bf16] }:$src0)  =>  VReg_64:{ *:[v4f16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6775,
      GIR_EraseRootFromParent_Done,
    // Label 615: @44630
    GIM_Try, /*On fail goto*//*Label 616*/ GIMT_Encode4(44659), // Rule ID 6776 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v4bf16] } VReg_64:{ *:[v2f32] }:$src0)  =>  VReg_64:{ *:[v4bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6776,
      GIR_EraseRootFromParent_Done,
    // Label 616: @44659
    GIM_Try, /*On fail goto*//*Label 617*/ GIMT_Encode4(44688), // Rule ID 6778 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v4bf16] } VReg_64:{ *:[f64] }:$src0)  =>  VReg_64:{ *:[v4bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6778,
      GIR_EraseRootFromParent_Done,
    // Label 617: @44688
    GIM_Try, /*On fail goto*//*Label 618*/ GIMT_Encode4(44717), // Rule ID 6781 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v4f16] } VReg_64:{ *:[v2i32] }:$src0)  =>  VReg_64:{ *:[v4f16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6781,
      GIR_EraseRootFromParent_Done,
    // Label 618: @44717
    GIM_Try, /*On fail goto*//*Label 619*/ GIMT_Encode4(44746), // Rule ID 6784 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v4i16] } VReg_64:{ *:[v2i32] }:$src0)  =>  VReg_64:{ *:[v4i16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6784,
      GIR_EraseRootFromParent_Done,
    // Label 619: @44746
    GIM_Try, /*On fail goto*//*Label 620*/ GIMT_Encode4(44775), // Rule ID 6786 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v4f16] } VReg_64:{ *:[v2f32] }:$src0)  =>  VReg_64:{ *:[v4f16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6786,
      GIR_EraseRootFromParent_Done,
    // Label 620: @44775
    GIM_Try, /*On fail goto*//*Label 621*/ GIMT_Encode4(44804), // Rule ID 6788 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v4i16] } VReg_64:{ *:[v2f32] }:$src0)  =>  VReg_64:{ *:[v4i16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6788,
      GIR_EraseRootFromParent_Done,
    // Label 621: @44804
    GIM_Try, /*On fail goto*//*Label 622*/ GIMT_Encode4(44833), // Rule ID 6789 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v4i16] } VReg_64:{ *:[f64] }:$src0)  =>  VReg_64:{ *:[v4i16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6789,
      GIR_EraseRootFromParent_Done,
    // Label 622: @44833
    GIM_Try, /*On fail goto*//*Label 623*/ GIMT_Encode4(44862), // Rule ID 6790 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v4f16] } VReg_64:{ *:[f64] }:$src0)  =>  VReg_64:{ *:[v4f16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6790,
      GIR_EraseRootFromParent_Done,
    // Label 623: @44862
    GIM_Try, /*On fail goto*//*Label 624*/ GIMT_Encode4(44891), // Rule ID 6793 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v4i16] } VReg_64:{ *:[i64] }:$src0)  =>  VReg_64:{ *:[v4i16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6793,
      GIR_EraseRootFromParent_Done,
    // Label 624: @44891
    GIM_Try, /*On fail goto*//*Label 625*/ GIMT_Encode4(44920), // Rule ID 6794 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // (bitconvert:{ *:[v4f16] } VReg_64:{ *:[i64] }:$src0)  =>  VReg_64:{ *:[v4f16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
      // GIR_Coverage, 6794,
      GIR_EraseRootFromParent_Done,
    // Label 625: @44920
    GIM_Reject,
    // Label 499: @44921
    GIM_Try, /*On fail goto*//*Label 626*/ GIMT_Encode4(44950), // Rule ID 6797 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v4i32] } VReg_128:{ *:[v4f32] }:$src0)  =>  VReg_128:{ *:[v4i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6797,
      GIR_EraseRootFromParent_Done,
    // Label 626: @44950
    GIM_Try, /*On fail goto*//*Label 627*/ GIMT_Encode4(44979), // Rule ID 6798 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v4f32] } VReg_128:{ *:[v4i32] }:$src0)  =>  VReg_128:{ *:[v4f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6798,
      GIR_EraseRootFromParent_Done,
    // Label 627: @44979
    GIM_Try, /*On fail goto*//*Label 628*/ GIMT_Encode4(45008), // Rule ID 6802 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // (bitconvert:{ *:[v4i32] } SReg_128:{ *:[v2i64] }:$src0)  =>  SReg_128:{ *:[v4i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // GIR_Coverage, 6802,
      GIR_EraseRootFromParent_Done,
    // Label 628: @45008
    GIM_Try, /*On fail goto*//*Label 629*/ GIMT_Encode4(45037), // Rule ID 6805 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v4f32] } VReg_128:{ *:[v2f64] }:$src0)  =>  VReg_128:{ *:[v4f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6805,
      GIR_EraseRootFromParent_Done,
    // Label 629: @45037
    GIM_Try, /*On fail goto*//*Label 630*/ GIMT_Encode4(45066), // Rule ID 6806 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v4i32] } VReg_128:{ *:[v2f64] }:$src0)  =>  VReg_128:{ *:[v4i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6806,
      GIR_EraseRootFromParent_Done,
    // Label 630: @45066
    GIM_Try, /*On fail goto*//*Label 631*/ GIMT_Encode4(45095), // Rule ID 6809 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v4f32] } VReg_128:{ *:[v2i64] }:$src0)  =>  VReg_128:{ *:[v4f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6809,
      GIR_EraseRootFromParent_Done,
    // Label 631: @45095
    GIM_Try, /*On fail goto*//*Label 632*/ GIMT_Encode4(45124), // Rule ID 6812 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // (bitconvert:{ *:[v4i32] } SReg_128:{ *:[v8i16] }:$src0)  =>  SReg_128:{ *:[v4i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // GIR_Coverage, 6812,
      GIR_EraseRootFromParent_Done,
    // Label 632: @45124
    GIM_Try, /*On fail goto*//*Label 633*/ GIMT_Encode4(45153), // Rule ID 6815 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v4f32] } VReg_128:{ *:[v8f16] }:$src0)  =>  VReg_128:{ *:[v4f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6815,
      GIR_EraseRootFromParent_Done,
    // Label 633: @45153
    GIM_Try, /*On fail goto*//*Label 634*/ GIMT_Encode4(45182), // Rule ID 6816 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v4i32] } VReg_128:{ *:[v8f16] }:$src0)  =>  VReg_128:{ *:[v4i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6816,
      GIR_EraseRootFromParent_Done,
    // Label 634: @45182
    GIM_Try, /*On fail goto*//*Label 635*/ GIMT_Encode4(45211), // Rule ID 6819 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v4f32] } VReg_128:{ *:[v8i16] }:$src0)  =>  VReg_128:{ *:[v4f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6819,
      GIR_EraseRootFromParent_Done,
    // Label 635: @45211
    GIM_Try, /*On fail goto*//*Label 636*/ GIMT_Encode4(45240), // Rule ID 6831 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // (bitconvert:{ *:[v4i32] } SReg_128:{ *:[v8bf16] }:$src0)  =>  SReg_128:{ *:[v4i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // GIR_Coverage, 6831,
      GIR_EraseRootFromParent_Done,
    // Label 636: @45240
    GIM_Try, /*On fail goto*//*Label 637*/ GIMT_Encode4(45269), // Rule ID 6833 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v4i32] } VReg_128:{ *:[v8bf16] }:$src0)  =>  VReg_128:{ *:[v4i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6833,
      GIR_EraseRootFromParent_Done,
    // Label 637: @45269
    GIM_Try, /*On fail goto*//*Label 638*/ GIMT_Encode4(45298), // Rule ID 6835 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // (bitconvert:{ *:[v4f32] } SReg_128:{ *:[v8bf16] }:$src0)  =>  SReg_128:{ *:[v4f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // GIR_Coverage, 6835,
      GIR_EraseRootFromParent_Done,
    // Label 638: @45298
    GIM_Try, /*On fail goto*//*Label 639*/ GIMT_Encode4(45327), // Rule ID 6837 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v4f32] } VReg_128:{ *:[v8bf16] }:$src0)  =>  VReg_128:{ *:[v4f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6837,
      GIR_EraseRootFromParent_Done,
    // Label 639: @45327
    GIM_Reject,
    // Label 500: @45328
    GIM_Try, /*On fail goto*//*Label 640*/ GIMT_Encode4(45357), // Rule ID 6881 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v4i64] } VReg_256:{ *:[v4f64] }:$src0)  =>  VReg_256:{ *:[v4i64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6881,
      GIR_EraseRootFromParent_Done,
    // Label 640: @45357
    GIM_Try, /*On fail goto*//*Label 641*/ GIMT_Encode4(45386), // Rule ID 6882 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v4f64] } VReg_256:{ *:[v4i64] }:$src0)  =>  VReg_256:{ *:[v4f64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6882,
      GIR_EraseRootFromParent_Done,
    // Label 641: @45386
    GIM_Try, /*On fail goto*//*Label 642*/ GIMT_Encode4(45415), // Rule ID 6883 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v4i64] } VReg_256:{ *:[v8i32] }:$src0)  =>  VReg_256:{ *:[v4i64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6883,
      GIR_EraseRootFromParent_Done,
    // Label 642: @45415
    GIM_Try, /*On fail goto*//*Label 643*/ GIMT_Encode4(45444), // Rule ID 6884 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v4i64] } VReg_256:{ *:[v8f32] }:$src0)  =>  VReg_256:{ *:[v4i64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6884,
      GIR_EraseRootFromParent_Done,
    // Label 643: @45444
    GIM_Try, /*On fail goto*//*Label 644*/ GIMT_Encode4(45473), // Rule ID 6885 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v4f64] } VReg_256:{ *:[v8i32] }:$src0)  =>  VReg_256:{ *:[v4f64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6885,
      GIR_EraseRootFromParent_Done,
    // Label 644: @45473
    GIM_Try, /*On fail goto*//*Label 645*/ GIMT_Encode4(45502), // Rule ID 6886 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v4f64] } VReg_256:{ *:[v8f32] }:$src0)  =>  VReg_256:{ *:[v4f64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6886,
      GIR_EraseRootFromParent_Done,
    // Label 645: @45502
    GIM_Try, /*On fail goto*//*Label 646*/ GIMT_Encode4(45531), // Rule ID 6907 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v4i64] } VReg_256:{ *:[v16f16] }:$src0)  =>  VReg_256:{ *:[v4i64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6907,
      GIR_EraseRootFromParent_Done,
    // Label 646: @45531
    GIM_Try, /*On fail goto*//*Label 647*/ GIMT_Encode4(45560), // Rule ID 6908 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v4i64] } VReg_256:{ *:[v16i16] }:$src0)  =>  VReg_256:{ *:[v4i64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6908,
      GIR_EraseRootFromParent_Done,
    // Label 647: @45560
    GIM_Try, /*On fail goto*//*Label 648*/ GIMT_Encode4(45589), // Rule ID 6909 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v4f64] } VReg_256:{ *:[v16f16] }:$src0)  =>  VReg_256:{ *:[v4f64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6909,
      GIR_EraseRootFromParent_Done,
    // Label 648: @45589
    GIM_Try, /*On fail goto*//*Label 649*/ GIMT_Encode4(45618), // Rule ID 6910 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v4f64] } VReg_256:{ *:[v16i16] }:$src0)  =>  VReg_256:{ *:[v4f64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6910,
      GIR_EraseRootFromParent_Done,
    // Label 649: @45618
    GIM_Try, /*On fail goto*//*Label 650*/ GIMT_Encode4(45647), // Rule ID 6915 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v4i64] } VReg_256:{ *:[v16bf16] }:$src0)  =>  VReg_256:{ *:[v4i64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6915,
      GIR_EraseRootFromParent_Done,
    // Label 650: @45647
    GIM_Try, /*On fail goto*//*Label 651*/ GIMT_Encode4(45676), // Rule ID 6917 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v4f64] } VReg_256:{ *:[v16bf16] }:$src0)  =>  VReg_256:{ *:[v4f64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6917,
      GIR_EraseRootFromParent_Done,
    // Label 651: @45676
    GIM_Reject,
    // Label 501: @45677
    GIM_Try, /*On fail goto*//*Label 652*/ GIMT_Encode4(45790),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v5s32,
      GIM_Try, /*On fail goto*//*Label 653*/ GIMT_Encode4(45711), // Rule ID 6855 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_160RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_160RegClassID),
        // (bitconvert:{ *:[v5i32] } SReg_160:{ *:[v5f32] }:$src0)  =>  SReg_160:{ *:[v5i32] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_160RegClassID),
        // GIR_Coverage, 6855,
        GIR_EraseRootFromParent_Done,
      // Label 653: @45711
      GIM_Try, /*On fail goto*//*Label 654*/ GIMT_Encode4(45737), // Rule ID 6856 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_160RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_160RegClassID),
        // (bitconvert:{ *:[v5f32] } SReg_160:{ *:[v5i32] }:$src0)  =>  SReg_160:{ *:[v5f32] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_160RegClassID),
        // GIR_Coverage, 6856,
        GIR_EraseRootFromParent_Done,
      // Label 654: @45737
      GIM_Try, /*On fail goto*//*Label 655*/ GIMT_Encode4(45763), // Rule ID 6857 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_160RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_160RegClassID),
        // (bitconvert:{ *:[v5i32] } VReg_160:{ *:[v5f32] }:$src0)  =>  VReg_160:{ *:[v5i32] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_160RegClassID),
        // GIR_Coverage, 6857,
        GIR_EraseRootFromParent_Done,
      // Label 655: @45763
      GIM_Try, /*On fail goto*//*Label 656*/ GIMT_Encode4(45789), // Rule ID 6858 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_160RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_160RegClassID),
        // (bitconvert:{ *:[v5f32] } VReg_160:{ *:[v5i32] }:$src0)  =>  VReg_160:{ *:[v5f32] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_160RegClassID),
        // GIR_Coverage, 6858,
        GIR_EraseRootFromParent_Done,
      // Label 656: @45789
      GIM_Reject,
    // Label 652: @45790
    GIM_Reject,
    // Label 502: @45791
    GIM_Try, /*On fail goto*//*Label 657*/ GIMT_Encode4(45820), // Rule ID 6859 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v6s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_192RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_192RegClassID),
      // (bitconvert:{ *:[v6i32] } SReg_192:{ *:[v6f32] }:$src0)  =>  SReg_192:{ *:[v6i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_192RegClassID),
      // GIR_Coverage, 6859,
      GIR_EraseRootFromParent_Done,
    // Label 657: @45820
    GIM_Try, /*On fail goto*//*Label 658*/ GIMT_Encode4(45849), // Rule ID 6860 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v6s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_192RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_192RegClassID),
      // (bitconvert:{ *:[v6f32] } SReg_192:{ *:[v6i32] }:$src0)  =>  SReg_192:{ *:[v6f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_192RegClassID),
      // GIR_Coverage, 6860,
      GIR_EraseRootFromParent_Done,
    // Label 658: @45849
    GIM_Try, /*On fail goto*//*Label 659*/ GIMT_Encode4(45878), // Rule ID 6861 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v6s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      // (bitconvert:{ *:[v6i32] } VReg_192:{ *:[v6f32] }:$src0)  =>  VReg_192:{ *:[v6i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      // GIR_Coverage, 6861,
      GIR_EraseRootFromParent_Done,
    // Label 659: @45878
    GIM_Try, /*On fail goto*//*Label 660*/ GIMT_Encode4(45907), // Rule ID 6862 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v6s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      // (bitconvert:{ *:[v6f32] } VReg_192:{ *:[v6i32] }:$src0)  =>  VReg_192:{ *:[v6f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      // GIR_Coverage, 6862,
      GIR_EraseRootFromParent_Done,
    // Label 660: @45907
    GIM_Try, /*On fail goto*//*Label 661*/ GIMT_Encode4(45936), // Rule ID 6869 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v3s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      // (bitconvert:{ *:[v6i32] } VReg_192:{ *:[v3i64] }:$src0)  =>  VReg_192:{ *:[v6i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      // GIR_Coverage, 6869,
      GIR_EraseRootFromParent_Done,
    // Label 661: @45936
    GIM_Try, /*On fail goto*//*Label 662*/ GIMT_Encode4(45965), // Rule ID 6870 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v3s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      // (bitconvert:{ *:[v6f32] } VReg_192:{ *:[v3i64] }:$src0)  =>  VReg_192:{ *:[v6f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      // GIR_Coverage, 6870,
      GIR_EraseRootFromParent_Done,
    // Label 662: @45965
    GIM_Try, /*On fail goto*//*Label 663*/ GIMT_Encode4(45994), // Rule ID 6871 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v3s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      // (bitconvert:{ *:[v6i32] } VReg_192:{ *:[v3f64] }:$src0)  =>  VReg_192:{ *:[v6i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      // GIR_Coverage, 6871,
      GIR_EraseRootFromParent_Done,
    // Label 663: @45994
    GIM_Try, /*On fail goto*//*Label 664*/ GIMT_Encode4(46023), // Rule ID 6872 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v3s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      // (bitconvert:{ *:[v6f32] } VReg_192:{ *:[v3f64] }:$src0)  =>  VReg_192:{ *:[v6f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_192RegClassID),
      // GIR_Coverage, 6872,
      GIR_EraseRootFromParent_Done,
    // Label 664: @46023
    GIM_Reject,
    // Label 503: @46024
    GIM_Try, /*On fail goto*//*Label 665*/ GIMT_Encode4(46137),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v7s32,
      GIM_Try, /*On fail goto*//*Label 666*/ GIMT_Encode4(46058), // Rule ID 6873 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_224RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_224RegClassID),
        // (bitconvert:{ *:[v7i32] } SReg_224:{ *:[v7f32] }:$src0)  =>  SReg_224:{ *:[v7i32] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_224RegClassID),
        // GIR_Coverage, 6873,
        GIR_EraseRootFromParent_Done,
      // Label 666: @46058
      GIM_Try, /*On fail goto*//*Label 667*/ GIMT_Encode4(46084), // Rule ID 6874 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_224RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_224RegClassID),
        // (bitconvert:{ *:[v7f32] } SReg_224:{ *:[v7i32] }:$src0)  =>  SReg_224:{ *:[v7f32] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_224RegClassID),
        // GIR_Coverage, 6874,
        GIR_EraseRootFromParent_Done,
      // Label 667: @46084
      GIM_Try, /*On fail goto*//*Label 668*/ GIMT_Encode4(46110), // Rule ID 6875 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_224RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_224RegClassID),
        // (bitconvert:{ *:[v7i32] } VReg_224:{ *:[v7f32] }:$src0)  =>  VReg_224:{ *:[v7i32] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_224RegClassID),
        // GIR_Coverage, 6875,
        GIR_EraseRootFromParent_Done,
      // Label 668: @46110
      GIM_Try, /*On fail goto*//*Label 669*/ GIMT_Encode4(46136), // Rule ID 6876 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_224RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_224RegClassID),
        // (bitconvert:{ *:[v7f32] } VReg_224:{ *:[v7i32] }:$src0)  =>  VReg_224:{ *:[v7f32] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_224RegClassID),
        // GIR_Coverage, 6876,
        GIR_EraseRootFromParent_Done,
      // Label 669: @46136
      GIM_Reject,
    // Label 665: @46137
    GIM_Reject,
    // Label 504: @46138
    GIM_Try, /*On fail goto*//*Label 670*/ GIMT_Encode4(46167), // Rule ID 6811 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // (bitconvert:{ *:[v8i16] } SReg_128:{ *:[v4i32] }:$src0)  =>  SReg_128:{ *:[v8i16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // GIR_Coverage, 6811,
      GIR_EraseRootFromParent_Done,
    // Label 670: @46167
    GIM_Try, /*On fail goto*//*Label 671*/ GIMT_Encode4(46196), // Rule ID 6813 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v8f16] } VReg_128:{ *:[v4f32] }:$src0)  =>  VReg_128:{ *:[v8f16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6813,
      GIR_EraseRootFromParent_Done,
    // Label 671: @46196
    GIM_Try, /*On fail goto*//*Label 672*/ GIMT_Encode4(46225), // Rule ID 6814 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v8f16] } VReg_128:{ *:[v4i32] }:$src0)  =>  VReg_128:{ *:[v8f16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6814,
      GIR_EraseRootFromParent_Done,
    // Label 672: @46225
    GIM_Try, /*On fail goto*//*Label 673*/ GIMT_Encode4(46254), // Rule ID 6817 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v8i16] } VReg_128:{ *:[v8f16] }:$src0)  =>  VReg_128:{ *:[v8i16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6817,
      GIR_EraseRootFromParent_Done,
    // Label 673: @46254
    GIM_Try, /*On fail goto*//*Label 674*/ GIMT_Encode4(46283), // Rule ID 6818 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v8f16] } VReg_128:{ *:[v8i16] }:$src0)  =>  VReg_128:{ *:[v8f16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6818,
      GIR_EraseRootFromParent_Done,
    // Label 674: @46283
    GIM_Try, /*On fail goto*//*Label 675*/ GIMT_Encode4(46312), // Rule ID 6820 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v8i16] } VReg_128:{ *:[v4f32] }:$src0)  =>  VReg_128:{ *:[v8i16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6820,
      GIR_EraseRootFromParent_Done,
    // Label 675: @46312
    GIM_Try, /*On fail goto*//*Label 676*/ GIMT_Encode4(46341), // Rule ID 6821 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // (bitconvert:{ *:[v8i16] } SReg_128:{ *:[v8f16] }:$src0)  =>  SReg_128:{ *:[v8i16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // GIR_Coverage, 6821,
      GIR_EraseRootFromParent_Done,
    // Label 676: @46341
    GIM_Try, /*On fail goto*//*Label 677*/ GIMT_Encode4(46370), // Rule ID 6822 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // (bitconvert:{ *:[v8i16] } SReg_128:{ *:[v2i64] }:$src0)  =>  SReg_128:{ *:[v8i16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // GIR_Coverage, 6822,
      GIR_EraseRootFromParent_Done,
    // Label 677: @46370
    GIM_Try, /*On fail goto*//*Label 678*/ GIMT_Encode4(46399), // Rule ID 6823 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // (bitconvert:{ *:[v8i16] } SReg_128:{ *:[v2f64] }:$src0)  =>  SReg_128:{ *:[v8i16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // GIR_Coverage, 6823,
      GIR_EraseRootFromParent_Done,
    // Label 678: @46399
    GIM_Try, /*On fail goto*//*Label 679*/ GIMT_Encode4(46428), // Rule ID 6824 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // (bitconvert:{ *:[v8f16] } SReg_128:{ *:[v2i64] }:$src0)  =>  SReg_128:{ *:[v8f16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // GIR_Coverage, 6824,
      GIR_EraseRootFromParent_Done,
    // Label 679: @46428
    GIM_Try, /*On fail goto*//*Label 680*/ GIMT_Encode4(46457), // Rule ID 6825 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // (bitconvert:{ *:[v8f16] } SReg_128:{ *:[v2f64] }:$src0)  =>  SReg_128:{ *:[v8f16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // GIR_Coverage, 6825,
      GIR_EraseRootFromParent_Done,
    // Label 680: @46457
    GIM_Try, /*On fail goto*//*Label 681*/ GIMT_Encode4(46486), // Rule ID 6826 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // (bitconvert:{ *:[v8f16] } SReg_128:{ *:[v8i16] }:$src0)  =>  SReg_128:{ *:[v8f16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // GIR_Coverage, 6826,
      GIR_EraseRootFromParent_Done,
    // Label 681: @46486
    GIM_Try, /*On fail goto*//*Label 682*/ GIMT_Encode4(46515), // Rule ID 6832 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // (bitconvert:{ *:[v8bf16] } SReg_128:{ *:[v4i32] }:$src0)  =>  SReg_128:{ *:[v8bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // GIR_Coverage, 6832,
      GIR_EraseRootFromParent_Done,
    // Label 682: @46515
    GIM_Try, /*On fail goto*//*Label 683*/ GIMT_Encode4(46544), // Rule ID 6834 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v8bf16] } VReg_128:{ *:[v4i32] }:$src0)  =>  VReg_128:{ *:[v8bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6834,
      GIR_EraseRootFromParent_Done,
    // Label 683: @46544
    GIM_Try, /*On fail goto*//*Label 684*/ GIMT_Encode4(46573), // Rule ID 6836 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // (bitconvert:{ *:[v8bf16] } SReg_128:{ *:[v4f32] }:$src0)  =>  SReg_128:{ *:[v8bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // GIR_Coverage, 6836,
      GIR_EraseRootFromParent_Done,
    // Label 684: @46573
    GIM_Try, /*On fail goto*//*Label 685*/ GIMT_Encode4(46602), // Rule ID 6838 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v8bf16] } VReg_128:{ *:[v4f32] }:$src0)  =>  VReg_128:{ *:[v8bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6838,
      GIR_EraseRootFromParent_Done,
    // Label 685: @46602
    GIM_Try, /*On fail goto*//*Label 686*/ GIMT_Encode4(46631), // Rule ID 6839 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // (bitconvert:{ *:[v8i16] } SReg_128:{ *:[v8bf16] }:$src0)  =>  SReg_128:{ *:[v8i16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // GIR_Coverage, 6839,
      GIR_EraseRootFromParent_Done,
    // Label 686: @46631
    GIM_Try, /*On fail goto*//*Label 687*/ GIMT_Encode4(46660), // Rule ID 6840 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // (bitconvert:{ *:[v8bf16] } SReg_128:{ *:[v8i16] }:$src0)  =>  SReg_128:{ *:[v8bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // GIR_Coverage, 6840,
      GIR_EraseRootFromParent_Done,
    // Label 687: @46660
    GIM_Try, /*On fail goto*//*Label 688*/ GIMT_Encode4(46689), // Rule ID 6841 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v8i16] } VReg_128:{ *:[v8bf16] }:$src0)  =>  VReg_128:{ *:[v8i16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6841,
      GIR_EraseRootFromParent_Done,
    // Label 688: @46689
    GIM_Try, /*On fail goto*//*Label 689*/ GIMT_Encode4(46718), // Rule ID 6842 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v8bf16] } VReg_128:{ *:[v8i16] }:$src0)  =>  VReg_128:{ *:[v8bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6842,
      GIR_EraseRootFromParent_Done,
    // Label 689: @46718
    GIM_Try, /*On fail goto*//*Label 690*/ GIMT_Encode4(46747), // Rule ID 6843 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // (bitconvert:{ *:[v8f16] } SReg_128:{ *:[v8bf16] }:$src0)  =>  SReg_128:{ *:[v8f16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // GIR_Coverage, 6843,
      GIR_EraseRootFromParent_Done,
    // Label 690: @46747
    GIM_Try, /*On fail goto*//*Label 691*/ GIMT_Encode4(46776), // Rule ID 6844 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // (bitconvert:{ *:[v8bf16] } SReg_128:{ *:[v8f16] }:$src0)  =>  SReg_128:{ *:[v8bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // GIR_Coverage, 6844,
      GIR_EraseRootFromParent_Done,
    // Label 691: @46776
    GIM_Try, /*On fail goto*//*Label 692*/ GIMT_Encode4(46805), // Rule ID 6845 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v8f16] } VReg_128:{ *:[v8bf16] }:$src0)  =>  VReg_128:{ *:[v8f16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6845,
      GIR_EraseRootFromParent_Done,
    // Label 692: @46805
    GIM_Try, /*On fail goto*//*Label 693*/ GIMT_Encode4(46834), // Rule ID 6846 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v8bf16] } VReg_128:{ *:[v8f16] }:$src0)  =>  VReg_128:{ *:[v8bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6846,
      GIR_EraseRootFromParent_Done,
    // Label 693: @46834
    GIM_Try, /*On fail goto*//*Label 694*/ GIMT_Encode4(46863), // Rule ID 6848 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // (bitconvert:{ *:[v8bf16] } SReg_128:{ *:[v2f64] }:$src0)  =>  SReg_128:{ *:[v8bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // GIR_Coverage, 6848,
      GIR_EraseRootFromParent_Done,
    // Label 694: @46863
    GIM_Try, /*On fail goto*//*Label 695*/ GIMT_Encode4(46892), // Rule ID 6850 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v8bf16] } VReg_128:{ *:[v2f64] }:$src0)  =>  VReg_128:{ *:[v8bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6850,
      GIR_EraseRootFromParent_Done,
    // Label 695: @46892
    GIM_Try, /*On fail goto*//*Label 696*/ GIMT_Encode4(46921), // Rule ID 6852 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // (bitconvert:{ *:[v8bf16] } SReg_128:{ *:[v2i64] }:$src0)  =>  SReg_128:{ *:[v8bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_128RegClassID),
      // GIR_Coverage, 6852,
      GIR_EraseRootFromParent_Done,
    // Label 696: @46921
    GIM_Try, /*On fail goto*//*Label 697*/ GIMT_Encode4(46950), // Rule ID 6854 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // (bitconvert:{ *:[v8bf16] } VReg_128:{ *:[v2i64] }:$src0)  =>  VReg_128:{ *:[v8bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_128RegClassID),
      // GIR_Coverage, 6854,
      GIR_EraseRootFromParent_Done,
    // Label 697: @46950
    GIM_Reject,
    // Label 505: @46951
    GIM_Try, /*On fail goto*//*Label 698*/ GIMT_Encode4(46980), // Rule ID 6877 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_256RegClassID),
      // (bitconvert:{ *:[v8i32] } SReg_256:{ *:[v8f32] }:$src0)  =>  SReg_256:{ *:[v8i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_256RegClassID),
      // GIR_Coverage, 6877,
      GIR_EraseRootFromParent_Done,
    // Label 698: @46980
    GIM_Try, /*On fail goto*//*Label 699*/ GIMT_Encode4(47009), // Rule ID 6878 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_256RegClassID),
      // (bitconvert:{ *:[v8f32] } SReg_256:{ *:[v8i32] }:$src0)  =>  SReg_256:{ *:[v8f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_256RegClassID),
      // GIR_Coverage, 6878,
      GIR_EraseRootFromParent_Done,
    // Label 699: @47009
    GIM_Try, /*On fail goto*//*Label 700*/ GIMT_Encode4(47038), // Rule ID 6879 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v8i32] } VReg_256:{ *:[v8f32] }:$src0)  =>  VReg_256:{ *:[v8i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6879,
      GIR_EraseRootFromParent_Done,
    // Label 700: @47038
    GIM_Try, /*On fail goto*//*Label 701*/ GIMT_Encode4(47067), // Rule ID 6880 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v8f32] } VReg_256:{ *:[v8i32] }:$src0)  =>  VReg_256:{ *:[v8f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6880,
      GIR_EraseRootFromParent_Done,
    // Label 701: @47067
    GIM_Try, /*On fail goto*//*Label 702*/ GIMT_Encode4(47096), // Rule ID 6887 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v8i32] } VReg_256:{ *:[v4i64] }:$src0)  =>  VReg_256:{ *:[v8i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6887,
      GIR_EraseRootFromParent_Done,
    // Label 702: @47096
    GIM_Try, /*On fail goto*//*Label 703*/ GIMT_Encode4(47125), // Rule ID 6888 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v8f32] } VReg_256:{ *:[v4i64] }:$src0)  =>  VReg_256:{ *:[v8f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6888,
      GIR_EraseRootFromParent_Done,
    // Label 703: @47125
    GIM_Try, /*On fail goto*//*Label 704*/ GIMT_Encode4(47154), // Rule ID 6889 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v8i32] } VReg_256:{ *:[v4f64] }:$src0)  =>  VReg_256:{ *:[v8i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6889,
      GIR_EraseRootFromParent_Done,
    // Label 704: @47154
    GIM_Try, /*On fail goto*//*Label 705*/ GIMT_Encode4(47183), // Rule ID 6890 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v8f32] } VReg_256:{ *:[v4f64] }:$src0)  =>  VReg_256:{ *:[v8f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6890,
      GIR_EraseRootFromParent_Done,
    // Label 705: @47183
    GIM_Try, /*On fail goto*//*Label 706*/ GIMT_Encode4(47212), // Rule ID 6899 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v8i32] } VReg_256:{ *:[v16f16] }:$src0)  =>  VReg_256:{ *:[v8i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6899,
      GIR_EraseRootFromParent_Done,
    // Label 706: @47212
    GIM_Try, /*On fail goto*//*Label 707*/ GIMT_Encode4(47241), // Rule ID 6900 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v8i32] } VReg_256:{ *:[v16i16] }:$src0)  =>  VReg_256:{ *:[v8i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6900,
      GIR_EraseRootFromParent_Done,
    // Label 707: @47241
    GIM_Try, /*On fail goto*//*Label 708*/ GIMT_Encode4(47270), // Rule ID 6901 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v8f32] } VReg_256:{ *:[v16f16] }:$src0)  =>  VReg_256:{ *:[v8f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6901,
      GIR_EraseRootFromParent_Done,
    // Label 708: @47270
    GIM_Try, /*On fail goto*//*Label 709*/ GIMT_Encode4(47299), // Rule ID 6902 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v8f32] } VReg_256:{ *:[v16i16] }:$src0)  =>  VReg_256:{ *:[v8f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6902,
      GIR_EraseRootFromParent_Done,
    // Label 709: @47299
    GIM_Try, /*On fail goto*//*Label 710*/ GIMT_Encode4(47328), // Rule ID 6911 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v8i32] } VReg_256:{ *:[v16bf16] }:$src0)  =>  VReg_256:{ *:[v8i32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6911,
      GIR_EraseRootFromParent_Done,
    // Label 710: @47328
    GIM_Try, /*On fail goto*//*Label 711*/ GIMT_Encode4(47357), // Rule ID 6913 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v8f32] } VReg_256:{ *:[v16bf16] }:$src0)  =>  VReg_256:{ *:[v8f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6913,
      GIR_EraseRootFromParent_Done,
    // Label 711: @47357
    GIM_Reject,
    // Label 506: @47358
    GIM_Try, /*On fail goto*//*Label 712*/ GIMT_Encode4(47387), // Rule ID 6955 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_512RegClassID),
      // (bitconvert:{ *:[v8i64] } VReg_512:{ *:[v8f64] }:$src0)  =>  VReg_512:{ *:[v8i64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_512RegClassID),
      // GIR_Coverage, 6955,
      GIR_EraseRootFromParent_Done,
    // Label 712: @47387
    GIM_Try, /*On fail goto*//*Label 713*/ GIMT_Encode4(47416), // Rule ID 6956 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_512RegClassID),
      // (bitconvert:{ *:[v8f64] } VReg_512:{ *:[v8i64] }:$src0)  =>  VReg_512:{ *:[v8f64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_512RegClassID),
      // GIR_Coverage, 6956,
      GIR_EraseRootFromParent_Done,
    // Label 713: @47416
    GIM_Try, /*On fail goto*//*Label 714*/ GIMT_Encode4(47445), // Rule ID 6957 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_512RegClassID),
      // (bitconvert:{ *:[v8i64] } VReg_512:{ *:[v16i32] }:$src0)  =>  VReg_512:{ *:[v8i64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_512RegClassID),
      // GIR_Coverage, 6957,
      GIR_EraseRootFromParent_Done,
    // Label 714: @47445
    GIM_Try, /*On fail goto*//*Label 715*/ GIMT_Encode4(47474), // Rule ID 6958 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_512RegClassID),
      // (bitconvert:{ *:[v8f64] } VReg_512:{ *:[v16i32] }:$src0)  =>  VReg_512:{ *:[v8f64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_512RegClassID),
      // GIR_Coverage, 6958,
      GIR_EraseRootFromParent_Done,
    // Label 715: @47474
    GIM_Try, /*On fail goto*//*Label 716*/ GIMT_Encode4(47503), // Rule ID 6961 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_512RegClassID),
      // (bitconvert:{ *:[v8i64] } VReg_512:{ *:[v16f32] }:$src0)  =>  VReg_512:{ *:[v8i64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_512RegClassID),
      // GIR_Coverage, 6961,
      GIR_EraseRootFromParent_Done,
    // Label 716: @47503
    GIM_Try, /*On fail goto*//*Label 717*/ GIMT_Encode4(47532), // Rule ID 6962 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_512RegClassID),
      // (bitconvert:{ *:[v8f64] } VReg_512:{ *:[v16f32] }:$src0)  =>  VReg_512:{ *:[v8f64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_512RegClassID),
      // GIR_Coverage, 6962,
      GIR_EraseRootFromParent_Done,
    // Label 717: @47532
    GIM_Try, /*On fail goto*//*Label 718*/ GIMT_Encode4(47561), // Rule ID 6982 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_512RegClassID),
      // (bitconvert:{ *:[v8f64] } VReg_512:{ *:[v32bf16] }:$src0)  =>  VReg_512:{ *:[v8f64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_512RegClassID),
      // GIR_Coverage, 6982,
      GIR_EraseRootFromParent_Done,
    // Label 718: @47561
    GIM_Try, /*On fail goto*//*Label 719*/ GIMT_Encode4(47590), // Rule ID 6984 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_512RegClassID),
      // (bitconvert:{ *:[v8f64] } SReg_512:{ *:[v32bf16] }:$src0)  =>  SReg_512:{ *:[v8f64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_512RegClassID),
      // GIR_Coverage, 6984,
      GIR_EraseRootFromParent_Done,
    // Label 719: @47590
    GIM_Try, /*On fail goto*//*Label 720*/ GIMT_Encode4(47619), // Rule ID 6986 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_512RegClassID),
      // (bitconvert:{ *:[v8i64] } VReg_512:{ *:[v32bf16] }:$src0)  =>  VReg_512:{ *:[v8i64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_512RegClassID),
      // GIR_Coverage, 6986,
      GIR_EraseRootFromParent_Done,
    // Label 720: @47619
    GIM_Try, /*On fail goto*//*Label 721*/ GIMT_Encode4(47648), // Rule ID 6988 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_512RegClassID),
      // (bitconvert:{ *:[v8i64] } SReg_512:{ *:[v32bf16] }:$src0)  =>  SReg_512:{ *:[v8i64] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_512RegClassID),
      // GIR_Coverage, 6988,
      GIR_EraseRootFromParent_Done,
    // Label 721: @47648
    GIM_Reject,
    // Label 507: @47649
    GIM_Try, /*On fail goto*//*Label 722*/ GIMT_Encode4(47762),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v9s32,
      GIM_Try, /*On fail goto*//*Label 723*/ GIMT_Encode4(47683), // Rule ID 6927 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_288RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_288RegClassID),
        // (bitconvert:{ *:[v9i32] } SReg_288:{ *:[v9f32] }:$src0)  =>  SReg_288:{ *:[v9i32] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_288RegClassID),
        // GIR_Coverage, 6927,
        GIR_EraseRootFromParent_Done,
      // Label 723: @47683
      GIM_Try, /*On fail goto*//*Label 724*/ GIMT_Encode4(47709), // Rule ID 6928 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_288RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_288RegClassID),
        // (bitconvert:{ *:[v9f32] } SReg_288:{ *:[v9i32] }:$src0)  =>  SReg_288:{ *:[v9f32] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_288RegClassID),
        // GIR_Coverage, 6928,
        GIR_EraseRootFromParent_Done,
      // Label 724: @47709
      GIM_Try, /*On fail goto*//*Label 725*/ GIMT_Encode4(47735), // Rule ID 6929 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_288RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_288RegClassID),
        // (bitconvert:{ *:[v9i32] } VReg_288:{ *:[v9f32] }:$src0)  =>  VReg_288:{ *:[v9i32] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_288RegClassID),
        // GIR_Coverage, 6929,
        GIR_EraseRootFromParent_Done,
      // Label 725: @47735
      GIM_Try, /*On fail goto*//*Label 726*/ GIMT_Encode4(47761), // Rule ID 6930 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_288RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_288RegClassID),
        // (bitconvert:{ *:[v9f32] } VReg_288:{ *:[v9i32] }:$src0)  =>  VReg_288:{ *:[v9f32] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_288RegClassID),
        // GIR_Coverage, 6930,
        GIR_EraseRootFromParent_Done,
      // Label 726: @47761
      GIM_Reject,
    // Label 722: @47762
    GIM_Reject,
    // Label 508: @47763
    GIM_Try, /*On fail goto*//*Label 727*/ GIMT_Encode4(47876),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v10s32,
      GIM_Try, /*On fail goto*//*Label 728*/ GIMT_Encode4(47797), // Rule ID 6931 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_320RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_320RegClassID),
        // (bitconvert:{ *:[v10i32] } SReg_320:{ *:[v10f32] }:$src0)  =>  SReg_320:{ *:[v10i32] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_320RegClassID),
        // GIR_Coverage, 6931,
        GIR_EraseRootFromParent_Done,
      // Label 728: @47797
      GIM_Try, /*On fail goto*//*Label 729*/ GIMT_Encode4(47823), // Rule ID 6932 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_320RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_320RegClassID),
        // (bitconvert:{ *:[v10f32] } SReg_320:{ *:[v10i32] }:$src0)  =>  SReg_320:{ *:[v10f32] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_320RegClassID),
        // GIR_Coverage, 6932,
        GIR_EraseRootFromParent_Done,
      // Label 729: @47823
      GIM_Try, /*On fail goto*//*Label 730*/ GIMT_Encode4(47849), // Rule ID 6933 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_320RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_320RegClassID),
        // (bitconvert:{ *:[v10i32] } VReg_320:{ *:[v10f32] }:$src0)  =>  VReg_320:{ *:[v10i32] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_320RegClassID),
        // GIR_Coverage, 6933,
        GIR_EraseRootFromParent_Done,
      // Label 730: @47849
      GIM_Try, /*On fail goto*//*Label 731*/ GIMT_Encode4(47875), // Rule ID 6934 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_320RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_320RegClassID),
        // (bitconvert:{ *:[v10f32] } VReg_320:{ *:[v10i32] }:$src0)  =>  VReg_320:{ *:[v10f32] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_320RegClassID),
        // GIR_Coverage, 6934,
        GIR_EraseRootFromParent_Done,
      // Label 731: @47875
      GIM_Reject,
    // Label 727: @47876
    GIM_Reject,
    // Label 509: @47877
    GIM_Try, /*On fail goto*//*Label 732*/ GIMT_Encode4(47990),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v11s32,
      GIM_Try, /*On fail goto*//*Label 733*/ GIMT_Encode4(47911), // Rule ID 6935 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_352RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_352RegClassID),
        // (bitconvert:{ *:[v11i32] } SReg_352:{ *:[v11f32] }:$src0)  =>  SReg_352:{ *:[v11i32] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_352RegClassID),
        // GIR_Coverage, 6935,
        GIR_EraseRootFromParent_Done,
      // Label 733: @47911
      GIM_Try, /*On fail goto*//*Label 734*/ GIMT_Encode4(47937), // Rule ID 6936 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_352RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_352RegClassID),
        // (bitconvert:{ *:[v11f32] } SReg_352:{ *:[v11i32] }:$src0)  =>  SReg_352:{ *:[v11f32] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_352RegClassID),
        // GIR_Coverage, 6936,
        GIR_EraseRootFromParent_Done,
      // Label 734: @47937
      GIM_Try, /*On fail goto*//*Label 735*/ GIMT_Encode4(47963), // Rule ID 6937 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_352RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_352RegClassID),
        // (bitconvert:{ *:[v11i32] } VReg_352:{ *:[v11f32] }:$src0)  =>  VReg_352:{ *:[v11i32] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_352RegClassID),
        // GIR_Coverage, 6937,
        GIR_EraseRootFromParent_Done,
      // Label 735: @47963
      GIM_Try, /*On fail goto*//*Label 736*/ GIMT_Encode4(47989), // Rule ID 6938 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_352RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_352RegClassID),
        // (bitconvert:{ *:[v11f32] } VReg_352:{ *:[v11i32] }:$src0)  =>  VReg_352:{ *:[v11f32] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_352RegClassID),
        // GIR_Coverage, 6938,
        GIR_EraseRootFromParent_Done,
      // Label 736: @47989
      GIM_Reject,
    // Label 732: @47990
    GIM_Reject,
    // Label 510: @47991
    GIM_Try, /*On fail goto*//*Label 737*/ GIMT_Encode4(48104),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v12s32,
      GIM_Try, /*On fail goto*//*Label 738*/ GIMT_Encode4(48025), // Rule ID 6939 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_384RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_384RegClassID),
        // (bitconvert:{ *:[v12i32] } SReg_384:{ *:[v12f32] }:$src0)  =>  SReg_384:{ *:[v12i32] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_384RegClassID),
        // GIR_Coverage, 6939,
        GIR_EraseRootFromParent_Done,
      // Label 738: @48025
      GIM_Try, /*On fail goto*//*Label 739*/ GIMT_Encode4(48051), // Rule ID 6940 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_384RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_384RegClassID),
        // (bitconvert:{ *:[v12f32] } SReg_384:{ *:[v12i32] }:$src0)  =>  SReg_384:{ *:[v12f32] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_384RegClassID),
        // GIR_Coverage, 6940,
        GIR_EraseRootFromParent_Done,
      // Label 739: @48051
      GIM_Try, /*On fail goto*//*Label 740*/ GIMT_Encode4(48077), // Rule ID 6941 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_384RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_384RegClassID),
        // (bitconvert:{ *:[v12i32] } VReg_384:{ *:[v12f32] }:$src0)  =>  VReg_384:{ *:[v12i32] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_384RegClassID),
        // GIR_Coverage, 6941,
        GIR_EraseRootFromParent_Done,
      // Label 740: @48077
      GIM_Try, /*On fail goto*//*Label 741*/ GIMT_Encode4(48103), // Rule ID 6942 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_384RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_384RegClassID),
        // (bitconvert:{ *:[v12f32] } VReg_384:{ *:[v12i32] }:$src0)  =>  VReg_384:{ *:[v12f32] }:$src0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // dst
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_384RegClassID),
        // GIR_Coverage, 6942,
        GIR_EraseRootFromParent_Done,
      // Label 741: @48103
      GIM_Reject,
    // Label 737: @48104
    GIM_Reject,
    // Label 511: @48105
    GIM_Try, /*On fail goto*//*Label 742*/ GIMT_Encode4(48134), // Rule ID 6891 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_256RegClassID),
      // (bitconvert:{ *:[v16i16] } SReg_256:{ *:[v16f16] }:$src0)  =>  SReg_256:{ *:[v16i16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_256RegClassID),
      // GIR_Coverage, 6891,
      GIR_EraseRootFromParent_Done,
    // Label 742: @48134
    GIM_Try, /*On fail goto*//*Label 743*/ GIMT_Encode4(48163), // Rule ID 6892 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_256RegClassID),
      // (bitconvert:{ *:[v16f16] } SReg_256:{ *:[v16i16] }:$src0)  =>  SReg_256:{ *:[v16f16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_256RegClassID),
      // GIR_Coverage, 6892,
      GIR_EraseRootFromParent_Done,
    // Label 743: @48163
    GIM_Try, /*On fail goto*//*Label 744*/ GIMT_Encode4(48192), // Rule ID 6893 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v16i16] } VReg_256:{ *:[v16f16] }:$src0)  =>  VReg_256:{ *:[v16i16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6893,
      GIR_EraseRootFromParent_Done,
    // Label 744: @48192
    GIM_Try, /*On fail goto*//*Label 745*/ GIMT_Encode4(48221), // Rule ID 6894 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v16f16] } VReg_256:{ *:[v16i16] }:$src0)  =>  VReg_256:{ *:[v16f16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6894,
      GIR_EraseRootFromParent_Done,
    // Label 745: @48221
    GIM_Try, /*On fail goto*//*Label 746*/ GIMT_Encode4(48250), // Rule ID 6895 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v16f16] } VReg_256:{ *:[v8i32] }:$src0)  =>  VReg_256:{ *:[v16f16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6895,
      GIR_EraseRootFromParent_Done,
    // Label 746: @48250
    GIM_Try, /*On fail goto*//*Label 747*/ GIMT_Encode4(48279), // Rule ID 6896 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v16i16] } VReg_256:{ *:[v8i32] }:$src0)  =>  VReg_256:{ *:[v16i16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6896,
      GIR_EraseRootFromParent_Done,
    // Label 747: @48279
    GIM_Try, /*On fail goto*//*Label 748*/ GIMT_Encode4(48308), // Rule ID 6897 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v16f16] } VReg_256:{ *:[v8f32] }:$src0)  =>  VReg_256:{ *:[v16f16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6897,
      GIR_EraseRootFromParent_Done,
    // Label 748: @48308
    GIM_Try, /*On fail goto*//*Label 749*/ GIMT_Encode4(48337), // Rule ID 6898 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v16i16] } VReg_256:{ *:[v8f32] }:$src0)  =>  VReg_256:{ *:[v16i16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6898,
      GIR_EraseRootFromParent_Done,
    // Label 749: @48337
    GIM_Try, /*On fail goto*//*Label 750*/ GIMT_Encode4(48366), // Rule ID 6903 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v16f16] } VReg_256:{ *:[v4i64] }:$src0)  =>  VReg_256:{ *:[v16f16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6903,
      GIR_EraseRootFromParent_Done,
    // Label 750: @48366
    GIM_Try, /*On fail goto*//*Label 751*/ GIMT_Encode4(48395), // Rule ID 6904 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v16i16] } VReg_256:{ *:[v4i64] }:$src0)  =>  VReg_256:{ *:[v16i16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6904,
      GIR_EraseRootFromParent_Done,
    // Label 751: @48395
    GIM_Try, /*On fail goto*//*Label 752*/ GIMT_Encode4(48424), // Rule ID 6905 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v16f16] } VReg_256:{ *:[v4f64] }:$src0)  =>  VReg_256:{ *:[v16f16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6905,
      GIR_EraseRootFromParent_Done,
    // Label 752: @48424
    GIM_Try, /*On fail goto*//*Label 753*/ GIMT_Encode4(48453), // Rule ID 6906 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v16i16] } VReg_256:{ *:[v4f64] }:$src0)  =>  VReg_256:{ *:[v16i16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6906,
      GIR_EraseRootFromParent_Done,
    // Label 753: @48453
    GIM_Try, /*On fail goto*//*Label 754*/ GIMT_Encode4(48482), // Rule ID 6912 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v16bf16] } VReg_256:{ *:[v8i32] }:$src0)  =>  VReg_256:{ *:[v16bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6912,
      GIR_EraseRootFromParent_Done,
    // Label 754: @48482
    GIM_Try, /*On fail goto*//*Label 755*/ GIMT_Encode4(48511), // Rule ID 6914 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v16bf16] } VReg_256:{ *:[v8f32] }:$src0)  =>  VReg_256:{ *:[v16bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6914,
      GIR_EraseRootFromParent_Done,
    // Label 755: @48511
    GIM_Try, /*On fail goto*//*Label 756*/ GIMT_Encode4(48540), // Rule ID 6916 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v16bf16] } VReg_256:{ *:[v4i64] }:$src0)  =>  VReg_256:{ *:[v16bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6916,
      GIR_EraseRootFromParent_Done,
    // Label 756: @48540
    GIM_Try, /*On fail goto*//*Label 757*/ GIMT_Encode4(48569), // Rule ID 6918 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v16bf16] } VReg_256:{ *:[v4f64] }:$src0)  =>  VReg_256:{ *:[v16bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6918,
      GIR_EraseRootFromParent_Done,
    // Label 757: @48569
    GIM_Try, /*On fail goto*//*Label 758*/ GIMT_Encode4(48598), // Rule ID 6919 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_256RegClassID),
      // (bitconvert:{ *:[v16i16] } SReg_256:{ *:[v16bf16] }:$src0)  =>  SReg_256:{ *:[v16i16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_256RegClassID),
      // GIR_Coverage, 6919,
      GIR_EraseRootFromParent_Done,
    // Label 758: @48598
    GIM_Try, /*On fail goto*//*Label 759*/ GIMT_Encode4(48627), // Rule ID 6920 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_256RegClassID),
      // (bitconvert:{ *:[v16bf16] } SReg_256:{ *:[v16i16] }:$src0)  =>  SReg_256:{ *:[v16bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_256RegClassID),
      // GIR_Coverage, 6920,
      GIR_EraseRootFromParent_Done,
    // Label 759: @48627
    GIM_Try, /*On fail goto*//*Label 760*/ GIMT_Encode4(48656), // Rule ID 6921 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v16i16] } VReg_256:{ *:[v16bf16] }:$src0)  =>  VReg_256:{ *:[v16i16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6921,
      GIR_EraseRootFromParent_Done,
    // Label 760: @48656
    GIM_Try, /*On fail goto*//*Label 761*/ GIMT_Encode4(48685), // Rule ID 6922 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v16bf16] } VReg_256:{ *:[v16i16] }:$src0)  =>  VReg_256:{ *:[v16bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6922,
      GIR_EraseRootFromParent_Done,
    // Label 761: @48685
    GIM_Try, /*On fail goto*//*Label 762*/ GIMT_Encode4(48714), // Rule ID 6923 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_256RegClassID),
      // (bitconvert:{ *:[v16f16] } SReg_256:{ *:[v16bf16] }:$src0)  =>  SReg_256:{ *:[v16f16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_256RegClassID),
      // GIR_Coverage, 6923,
      GIR_EraseRootFromParent_Done,
    // Label 762: @48714
    GIM_Try, /*On fail goto*//*Label 763*/ GIMT_Encode4(48743), // Rule ID 6924 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_256RegClassID),
      // (bitconvert:{ *:[v16bf16] } SReg_256:{ *:[v16f16] }:$src0)  =>  SReg_256:{ *:[v16bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_256RegClassID),
      // GIR_Coverage, 6924,
      GIR_EraseRootFromParent_Done,
    // Label 763: @48743
    GIM_Try, /*On fail goto*//*Label 764*/ GIMT_Encode4(48772), // Rule ID 6925 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v16f16] } VReg_256:{ *:[v16bf16] }:$src0)  =>  VReg_256:{ *:[v16f16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6925,
      GIR_EraseRootFromParent_Done,
    // Label 764: @48772
    GIM_Try, /*On fail goto*//*Label 765*/ GIMT_Encode4(48801), // Rule ID 6926 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // (bitconvert:{ *:[v16bf16] } VReg_256:{ *:[v16f16] }:$src0)  =>  VReg_256:{ *:[v16bf16] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_256RegClassID),
      // GIR_Coverage, 6926,
      GIR_EraseRootFromParent_Done,
    // Label 765: @48801
    GIM_Reject,
    // Label 512: @48802
    GIM_Try, /*On fail goto*//*Label 766*/ GIMT_Encode4(48831), // Rule ID 6947 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VReg_512RegClassID),
      // (bitconvert:{ *:[v16f32] } VReg_512:{ *:[v32f16] }:$src0)  =>  VReg_512:{ *:[v16f32] }:$src0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src0
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_512RegClassID),
