// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolFunction = sync.Pool{
		New: func() any {
			return &otlpprofiles.Function{}
		},
	}
)

func NewOrigFunction() *otlpprofiles.Function {
	if !UseProtoPooling.IsEnabled() {
		return &otlpprofiles.Function{}
	}
	return protoPoolFunction.Get().(*otlpprofiles.Function)
}

func DeleteOrigFunction(orig *otlpprofiles.Function, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	orig.Reset()
	if nullable {
		protoPoolFunction.Put(orig)
	}
}

func CopyOrigFunction(dest, src *otlpprofiles.Function) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	dest.NameStrindex = src.NameStrindex
	dest.SystemNameStrindex = src.SystemNameStrindex
	dest.FilenameStrindex = src.FilenameStrindex
	dest.StartLine = src.StartLine
}

func GenTestOrigFunction() *otlpprofiles.Function {
	orig := NewOrigFunction()
	orig.NameStrindex = int32(13)
	orig.SystemNameStrindex = int32(13)
	orig.FilenameStrindex = int32(13)
	orig.StartLine = int64(13)
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigFunction(orig *otlpprofiles.Function, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.NameStrindex != int32(0) {
		dest.WriteObjectField("nameStrindex")
		dest.WriteInt32(orig.NameStrindex)
	}
	if orig.SystemNameStrindex != int32(0) {
		dest.WriteObjectField("systemNameStrindex")
		dest.WriteInt32(orig.SystemNameStrindex)
	}
	if orig.FilenameStrindex != int32(0) {
		dest.WriteObjectField("filenameStrindex")
		dest.WriteInt32(orig.FilenameStrindex)
	}
	if orig.StartLine != int64(0) {
		dest.WriteObjectField("startLine")
		dest.WriteInt64(orig.StartLine)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigFunction unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigFunction(orig *otlpprofiles.Function, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "nameStrindex", "name_strindex":
			orig.NameStrindex = iter.ReadInt32()
		case "systemNameStrindex", "system_name_strindex":
			orig.SystemNameStrindex = iter.ReadInt32()
		case "filenameStrindex", "filename_strindex":
			orig.FilenameStrindex = iter.ReadInt32()
		case "startLine", "start_line":
			orig.StartLine = iter.ReadInt64()
		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigFunction(orig *otlpprofiles.Function) int {
	var n int
	var l int
	_ = l
	if orig.NameStrindex != 0 {
		n += 1 + proto.Sov(uint64(orig.NameStrindex))
	}
	if orig.SystemNameStrindex != 0 {
		n += 1 + proto.Sov(uint64(orig.SystemNameStrindex))
	}
	if orig.FilenameStrindex != 0 {
		n += 1 + proto.Sov(uint64(orig.FilenameStrindex))
	}
	if orig.StartLine != 0 {
		n += 1 + proto.Sov(uint64(orig.StartLine))
	}
	return n
}

func MarshalProtoOrigFunction(orig *otlpprofiles.Function, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.NameStrindex != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.NameStrindex))
		pos--
		buf[pos] = 0x8
	}
	if orig.SystemNameStrindex != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.SystemNameStrindex))
		pos--
		buf[pos] = 0x10
	}
	if orig.FilenameStrindex != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.FilenameStrindex))
		pos--
		buf[pos] = 0x18
	}
	if orig.StartLine != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.StartLine))
		pos--
		buf[pos] = 0x20
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigFunction(orig *otlpprofiles.Function, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field NameStrindex", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.NameStrindex = int32(num)

		case 2:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field SystemNameStrindex", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.SystemNameStrindex = int32(num)

		case 3:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field FilenameStrindex", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.FilenameStrindex = int32(num)

		case 4:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field StartLine", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.StartLine = int64(num)
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
