// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: scheduler.proto

package schedulerpb

import (
	context "context"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type JobKey struct {
	Id    string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Epoch int64  `protobuf:"varint,2,opt,name=epoch,proto3" json:"epoch,omitempty"`
}

func (m *JobKey) Reset()      { *m = JobKey{} }
func (*JobKey) ProtoMessage() {}
func (*JobKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b3fc28395a6d9c5, []int{0}
}
func (m *JobKey) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *JobKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_JobKey.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *JobKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobKey.Merge(m, src)
}
func (m *JobKey) XXX_Size() int {
	return m.Size()
}
func (m *JobKey) XXX_DiscardUnknown() {
	xxx_messageInfo_JobKey.DiscardUnknown(m)
}

var xxx_messageInfo_JobKey proto.InternalMessageInfo

func (m *JobKey) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *JobKey) GetEpoch() int64 {
	if m != nil {
		return m.Epoch
	}
	return 0
}

type JobSpec struct {
	Topic       string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	Partition   int32  `protobuf:"varint,2,opt,name=partition,proto3" json:"partition,omitempty"`
	StartOffset int64  `protobuf:"varint,3,opt,name=start_offset,json=startOffset,proto3" json:"start_offset,omitempty"`
	EndOffset   int64  `protobuf:"varint,4,opt,name=end_offset,json=endOffset,proto3" json:"end_offset,omitempty"`
}

func (m *JobSpec) Reset()      { *m = JobSpec{} }
func (*JobSpec) ProtoMessage() {}
func (*JobSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b3fc28395a6d9c5, []int{1}
}
func (m *JobSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *JobSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_JobSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *JobSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobSpec.Merge(m, src)
}
func (m *JobSpec) XXX_Size() int {
	return m.Size()
}
func (m *JobSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_JobSpec.DiscardUnknown(m)
}

var xxx_messageInfo_JobSpec proto.InternalMessageInfo

func (m *JobSpec) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

func (m *JobSpec) GetPartition() int32 {
	if m != nil {
		return m.Partition
	}
	return 0
}

func (m *JobSpec) GetStartOffset() int64 {
	if m != nil {
		return m.StartOffset
	}
	return 0
}

func (m *JobSpec) GetEndOffset() int64 {
	if m != nil {
		return m.EndOffset
	}
	return 0
}

type AssignJobRequest struct {
	WorkerId string `protobuf:"bytes,1,opt,name=worker_id,json=workerId,proto3" json:"worker_id,omitempty"`
}

func (m *AssignJobRequest) Reset()      { *m = AssignJobRequest{} }
func (*AssignJobRequest) ProtoMessage() {}
func (*AssignJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b3fc28395a6d9c5, []int{2}
}
func (m *AssignJobRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AssignJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AssignJobRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AssignJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AssignJobRequest.Merge(m, src)
}
func (m *AssignJobRequest) XXX_Size() int {
	return m.Size()
}
func (m *AssignJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AssignJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AssignJobRequest proto.InternalMessageInfo

func (m *AssignJobRequest) GetWorkerId() string {
	if m != nil {
		return m.WorkerId
	}
	return ""
}

type AssignJobResponse struct {
	Key  *JobKey  `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Spec *JobSpec `protobuf:"bytes,2,opt,name=spec,proto3" json:"spec,omitempty"`
}

func (m *AssignJobResponse) Reset()      { *m = AssignJobResponse{} }
func (*AssignJobResponse) ProtoMessage() {}
func (*AssignJobResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b3fc28395a6d9c5, []int{3}
}
func (m *AssignJobResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AssignJobResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AssignJobResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AssignJobResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AssignJobResponse.Merge(m, src)
}
func (m *AssignJobResponse) XXX_Size() int {
	return m.Size()
}
func (m *AssignJobResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AssignJobResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AssignJobResponse proto.InternalMessageInfo

func (m *AssignJobResponse) GetKey() *JobKey {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *AssignJobResponse) GetSpec() *JobSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

type UpdateJobRequest struct {
	Key      *JobKey  `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	WorkerId string   `protobuf:"bytes,2,opt,name=worker_id,json=workerId,proto3" json:"worker_id,omitempty"`
	Spec     *JobSpec `protobuf:"bytes,3,opt,name=spec,proto3" json:"spec,omitempty"`
	Complete bool     `protobuf:"varint,4,opt,name=complete,proto3" json:"complete,omitempty"`
}

func (m *UpdateJobRequest) Reset()      { *m = UpdateJobRequest{} }
func (*UpdateJobRequest) ProtoMessage() {}
func (*UpdateJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b3fc28395a6d9c5, []int{4}
}
func (m *UpdateJobRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateJobRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateJobRequest.Merge(m, src)
}
func (m *UpdateJobRequest) XXX_Size() int {
	return m.Size()
}
func (m *UpdateJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateJobRequest proto.InternalMessageInfo

func (m *UpdateJobRequest) GetKey() *JobKey {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *UpdateJobRequest) GetWorkerId() string {
	if m != nil {
		return m.WorkerId
	}
	return ""
}

func (m *UpdateJobRequest) GetSpec() *JobSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *UpdateJobRequest) GetComplete() bool {
	if m != nil {
		return m.Complete
	}
	return false
}

type UpdateJobResponse struct {
}

func (m *UpdateJobResponse) Reset()      { *m = UpdateJobResponse{} }
func (*UpdateJobResponse) ProtoMessage() {}
func (*UpdateJobResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b3fc28395a6d9c5, []int{5}
}
func (m *UpdateJobResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateJobResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateJobResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateJobResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateJobResponse.Merge(m, src)
}
func (m *UpdateJobResponse) XXX_Size() int {
	return m.Size()
}
func (m *UpdateJobResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateJobResponse.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateJobResponse proto.InternalMessageInfo

func init() {
	proto.RegisterType((*JobKey)(nil), "schedulerpb.JobKey")
	proto.RegisterType((*JobSpec)(nil), "schedulerpb.JobSpec")
	proto.RegisterType((*AssignJobRequest)(nil), "schedulerpb.AssignJobRequest")
	proto.RegisterType((*AssignJobResponse)(nil), "schedulerpb.AssignJobResponse")
	proto.RegisterType((*UpdateJobRequest)(nil), "schedulerpb.UpdateJobRequest")
	proto.RegisterType((*UpdateJobResponse)(nil), "schedulerpb.UpdateJobResponse")
}

func init() { proto.RegisterFile("scheduler.proto", fileDescriptor_2b3fc28395a6d9c5) }

var fileDescriptor_2b3fc28395a6d9c5 = []byte{
	// 433 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x92, 0xc1, 0x6e, 0xd3, 0x40,
	0x10, 0x86, 0xbd, 0x76, 0x5b, 0xe2, 0x31, 0x82, 0x76, 0x1b, 0xa4, 0x28, 0xd0, 0x55, 0xb1, 0x84,
	0x94, 0x93, 0x2b, 0x05, 0x5e, 0x80, 0xdc, 0x30, 0x07, 0x24, 0x57, 0x9c, 0xab, 0xd8, 0x3b, 0x4d,
	0xad, 0x18, 0xef, 0xe2, 0xdd, 0x08, 0xf5, 0x04, 0x8f, 0xc0, 0x03, 0xf0, 0x00, 0xdc, 0x78, 0x0d,
	0x8e, 0x39, 0xf6, 0x48, 0x9c, 0x0b, 0xc7, 0x3c, 0x02, 0xf2, 0x3a, 0x31, 0x8e, 0x11, 0x82, 0x9b,
	0xe7, 0x9f, 0x7f, 0x66, 0xfe, 0xfd, 0x64, 0x78, 0xa8, 0x92, 0x1b, 0xe4, 0x8b, 0x0c, 0x8b, 0x40,
	0x16, 0x42, 0x0b, 0xea, 0x35, 0x82, 0x8c, 0x87, 0xfd, 0x99, 0x98, 0x09, 0xa3, 0x5f, 0x54, 0x5f,
	0xb5, 0xc5, 0x0f, 0xe0, 0x28, 0x14, 0xf1, 0x6b, 0xbc, 0xa5, 0x0f, 0xc0, 0x4e, 0xf9, 0x80, 0x9c,
	0x93, 0x91, 0x1b, 0xd9, 0x29, 0xa7, 0x7d, 0x38, 0x44, 0x29, 0x92, 0x9b, 0x81, 0x7d, 0x4e, 0x46,
	0x4e, 0x54, 0x17, 0xfe, 0x47, 0xb8, 0x17, 0x8a, 0xf8, 0x52, 0x62, 0x52, 0x19, 0xb4, 0x90, 0x69,
	0xb2, 0x9d, 0xa9, 0x0b, 0xfa, 0x04, 0x5c, 0x39, 0x2d, 0x74, 0xaa, 0x53, 0x91, 0x9b, 0xd1, 0xc3,
	0xe8, 0xb7, 0x40, 0x9f, 0xc2, 0x7d, 0xa5, 0xa7, 0x85, 0xbe, 0x12, 0xd7, 0xd7, 0x0a, 0xf5, 0xc0,
	0x31, 0xbb, 0x3d, 0xa3, 0xbd, 0x31, 0x12, 0x3d, 0x03, 0xc0, 0x9c, 0xef, 0x0c, 0x07, 0xc6, 0xe0,
	0x62, 0xce, 0xeb, 0xb6, 0x7f, 0x01, 0xc7, 0x2f, 0x95, 0x4a, 0x67, 0x79, 0x28, 0xe2, 0x08, 0xdf,
	0x2f, 0x50, 0x69, 0xfa, 0x18, 0xdc, 0x0f, 0xa2, 0x98, 0x63, 0x71, 0xd5, 0xbc, 0xa0, 0x57, 0x0b,
	0xaf, 0xb8, 0xcf, 0xe1, 0xa4, 0x35, 0xa0, 0xa4, 0xc8, 0x15, 0xd2, 0x67, 0xe0, 0xcc, 0xf1, 0xd6,
	0x78, 0xbd, 0xf1, 0x69, 0xd0, 0xe2, 0x14, 0xd4, 0x38, 0xa2, 0xaa, 0x4f, 0x47, 0x70, 0xa0, 0x24,
	0x26, 0xe6, 0x1d, 0xde, 0xb8, 0xdf, 0xf5, 0x55, 0x18, 0x22, 0xe3, 0xf0, 0xbf, 0x10, 0x38, 0x7e,
	0x2b, 0xf9, 0x54, 0x63, 0x2b, 0xd7, 0x7f, 0x5e, 0xd9, 0x8b, 0x6f, 0xef, 0xc7, 0x6f, 0x22, 0x38,
	0xff, 0x8a, 0x40, 0x87, 0xd0, 0x4b, 0xc4, 0x3b, 0x99, 0xa1, 0x46, 0x83, 0xad, 0x17, 0x35, 0xb5,
	0x7f, 0x0a, 0x27, 0xad, 0x74, 0x35, 0x84, 0xf1, 0x37, 0x02, 0x8f, 0x26, 0x99, 0x48, 0xe6, 0x93,
	0x45, 0x9a, 0x71, 0x2c, 0x2e, 0x77, 0xab, 0x69, 0x08, 0x6e, 0xc3, 0x8c, 0x9e, 0xed, 0xdd, 0xec,
	0xc2, 0x1f, 0xb2, 0xbf, 0xb5, 0xb7, 0xa8, 0x43, 0x70, 0x9b, 0xd3, 0x9d, 0x5d, 0x5d, 0x60, 0x9d,
	0x5d, 0x7f, 0x24, 0x9e, 0xbc, 0x58, 0xae, 0x98, 0x75, 0xb7, 0x62, 0xd6, 0x66, 0xc5, 0xc8, 0xa7,
	0x92, 0x91, 0xaf, 0x25, 0x23, 0xdf, 0x4b, 0x46, 0x96, 0x25, 0x23, 0x3f, 0x4a, 0x46, 0x7e, 0x96,
	0xcc, 0xda, 0x94, 0x8c, 0x7c, 0x5e, 0x33, 0x6b, 0xb9, 0x66, 0xd6, 0xdd, 0x9a, 0x59, 0xf1, 0x91,
	0xf9, 0xd5, 0x9f, 0xff, 0x0a, 0x00, 0x00, 0xff, 0xff, 0x3d, 0xa0, 0x63, 0x35, 0x20, 0x03, 0x00,
	0x00,
}

func (this *JobKey) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*JobKey)
	if !ok {
		that2, ok := that.(JobKey)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Id != that1.Id {
		return false
	}
	if this.Epoch != that1.Epoch {
		return false
	}
	return true
}
func (this *JobSpec) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*JobSpec)
	if !ok {
		that2, ok := that.(JobSpec)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Topic != that1.Topic {
		return false
	}
	if this.Partition != that1.Partition {
		return false
	}
	if this.StartOffset != that1.StartOffset {
		return false
	}
	if this.EndOffset != that1.EndOffset {
		return false
	}
	return true
}
func (this *AssignJobRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AssignJobRequest)
	if !ok {
		that2, ok := that.(AssignJobRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.WorkerId != that1.WorkerId {
		return false
	}
	return true
}
func (this *AssignJobResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AssignJobResponse)
	if !ok {
		that2, ok := that.(AssignJobResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Key.Equal(that1.Key) {
		return false
	}
	if !this.Spec.Equal(that1.Spec) {
		return false
	}
	return true
}
func (this *UpdateJobRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*UpdateJobRequest)
	if !ok {
		that2, ok := that.(UpdateJobRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Key.Equal(that1.Key) {
		return false
	}
	if this.WorkerId != that1.WorkerId {
		return false
	}
	if !this.Spec.Equal(that1.Spec) {
		return false
	}
	if this.Complete != that1.Complete {
		return false
	}
	return true
}
func (this *UpdateJobResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*UpdateJobResponse)
	if !ok {
		that2, ok := that.(UpdateJobResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *JobKey) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&schedulerpb.JobKey{")
	s = append(s, "Id: "+fmt.Sprintf("%#v", this.Id)+",\n")
	s = append(s, "Epoch: "+fmt.Sprintf("%#v", this.Epoch)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *JobSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&schedulerpb.JobSpec{")
	s = append(s, "Topic: "+fmt.Sprintf("%#v", this.Topic)+",\n")
	s = append(s, "Partition: "+fmt.Sprintf("%#v", this.Partition)+",\n")
	s = append(s, "StartOffset: "+fmt.Sprintf("%#v", this.StartOffset)+",\n")
	s = append(s, "EndOffset: "+fmt.Sprintf("%#v", this.EndOffset)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AssignJobRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&schedulerpb.AssignJobRequest{")
	s = append(s, "WorkerId: "+fmt.Sprintf("%#v", this.WorkerId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AssignJobResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&schedulerpb.AssignJobResponse{")
	if this.Key != nil {
		s = append(s, "Key: "+fmt.Sprintf("%#v", this.Key)+",\n")
	}
	if this.Spec != nil {
		s = append(s, "Spec: "+fmt.Sprintf("%#v", this.Spec)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *UpdateJobRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&schedulerpb.UpdateJobRequest{")
	if this.Key != nil {
		s = append(s, "Key: "+fmt.Sprintf("%#v", this.Key)+",\n")
	}
	s = append(s, "WorkerId: "+fmt.Sprintf("%#v", this.WorkerId)+",\n")
	if this.Spec != nil {
		s = append(s, "Spec: "+fmt.Sprintf("%#v", this.Spec)+",\n")
	}
	s = append(s, "Complete: "+fmt.Sprintf("%#v", this.Complete)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *UpdateJobResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&schedulerpb.UpdateJobResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringScheduler(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// BlockBuilderSchedulerClient is the client API for BlockBuilderScheduler service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BlockBuilderSchedulerClient interface {
	AssignJob(ctx context.Context, in *AssignJobRequest, opts ...grpc.CallOption) (*AssignJobResponse, error)
	UpdateJob(ctx context.Context, in *UpdateJobRequest, opts ...grpc.CallOption) (*UpdateJobResponse, error)
}

type blockBuilderSchedulerClient struct {
	cc *grpc.ClientConn
}

func NewBlockBuilderSchedulerClient(cc *grpc.ClientConn) BlockBuilderSchedulerClient {
	return &blockBuilderSchedulerClient{cc}
}

func (c *blockBuilderSchedulerClient) AssignJob(ctx context.Context, in *AssignJobRequest, opts ...grpc.CallOption) (*AssignJobResponse, error) {
	out := new(AssignJobResponse)
	err := c.cc.Invoke(ctx, "/schedulerpb.BlockBuilderScheduler/AssignJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *blockBuilderSchedulerClient) UpdateJob(ctx context.Context, in *UpdateJobRequest, opts ...grpc.CallOption) (*UpdateJobResponse, error) {
	out := new(UpdateJobResponse)
	err := c.cc.Invoke(ctx, "/schedulerpb.BlockBuilderScheduler/UpdateJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BlockBuilderSchedulerServer is the server API for BlockBuilderScheduler service.
type BlockBuilderSchedulerServer interface {
	AssignJob(context.Context, *AssignJobRequest) (*AssignJobResponse, error)
	UpdateJob(context.Context, *UpdateJobRequest) (*UpdateJobResponse, error)
}

// UnimplementedBlockBuilderSchedulerServer can be embedded to have forward compatible implementations.
type UnimplementedBlockBuilderSchedulerServer struct {
}

func (*UnimplementedBlockBuilderSchedulerServer) AssignJob(ctx context.Context, req *AssignJobRequest) (*AssignJobResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AssignJob not implemented")
}
func (*UnimplementedBlockBuilderSchedulerServer) UpdateJob(ctx context.Context, req *UpdateJobRequest) (*UpdateJobResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateJob not implemented")
}

func RegisterBlockBuilderSchedulerServer(s *grpc.Server, srv BlockBuilderSchedulerServer) {
	s.RegisterService(&_BlockBuilderScheduler_serviceDesc, srv)
}

func _BlockBuilderScheduler_AssignJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AssignJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BlockBuilderSchedulerServer).AssignJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/schedulerpb.BlockBuilderScheduler/AssignJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BlockBuilderSchedulerServer).AssignJob(ctx, req.(*AssignJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BlockBuilderScheduler_UpdateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BlockBuilderSchedulerServer).UpdateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/schedulerpb.BlockBuilderScheduler/UpdateJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BlockBuilderSchedulerServer).UpdateJob(ctx, req.(*UpdateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BlockBuilderScheduler_serviceDesc = grpc.ServiceDesc{
	ServiceName: "schedulerpb.BlockBuilderScheduler",
	HandlerType: (*BlockBuilderSchedulerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AssignJob",
			Handler:    _BlockBuilderScheduler_AssignJob_Handler,
		},
		{
			MethodName: "UpdateJob",
			Handler:    _BlockBuilderScheduler_UpdateJob_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "scheduler.proto",
}

func (m *JobKey) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JobKey) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *JobKey) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Epoch != 0 {
		i = encodeVarintScheduler(dAtA, i, uint64(m.Epoch))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintScheduler(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *JobSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JobSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *JobSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.EndOffset != 0 {
		i = encodeVarintScheduler(dAtA, i, uint64(m.EndOffset))
		i--
		dAtA[i] = 0x20
	}
	if m.StartOffset != 0 {
		i = encodeVarintScheduler(dAtA, i, uint64(m.StartOffset))
		i--
		dAtA[i] = 0x18
	}
	if m.Partition != 0 {
		i = encodeVarintScheduler(dAtA, i, uint64(m.Partition))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Topic) > 0 {
		i -= len(m.Topic)
		copy(dAtA[i:], m.Topic)
		i = encodeVarintScheduler(dAtA, i, uint64(len(m.Topic)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AssignJobRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AssignJobRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AssignJobRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.WorkerId) > 0 {
		i -= len(m.WorkerId)
		copy(dAtA[i:], m.WorkerId)
		i = encodeVarintScheduler(dAtA, i, uint64(len(m.WorkerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AssignJobResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AssignJobResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AssignJobResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Spec != nil {
		{
			size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintScheduler(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Key != nil {
		{
			size, err := m.Key.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintScheduler(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *UpdateJobRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateJobRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateJobRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Complete {
		i--
		if m.Complete {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.Spec != nil {
		{
			size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintScheduler(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.WorkerId) > 0 {
		i -= len(m.WorkerId)
		copy(dAtA[i:], m.WorkerId)
		i = encodeVarintScheduler(dAtA, i, uint64(len(m.WorkerId)))
		i--
		dAtA[i] = 0x12
	}
	if m.Key != nil {
		{
			size, err := m.Key.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintScheduler(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *UpdateJobResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateJobResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateJobResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func encodeVarintScheduler(dAtA []byte, offset int, v uint64) int {
	offset -= sovScheduler(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *JobKey) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.Epoch != 0 {
		n += 1 + sovScheduler(uint64(m.Epoch))
	}
	return n
}

func (m *JobSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Topic)
	if l > 0 {
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.Partition != 0 {
		n += 1 + sovScheduler(uint64(m.Partition))
	}
	if m.StartOffset != 0 {
		n += 1 + sovScheduler(uint64(m.StartOffset))
	}
	if m.EndOffset != 0 {
		n += 1 + sovScheduler(uint64(m.EndOffset))
	}
	return n
}

func (m *AssignJobRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.WorkerId)
	if l > 0 {
		n += 1 + l + sovScheduler(uint64(l))
	}
	return n
}

func (m *AssignJobResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Key != nil {
		l = m.Key.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.Spec != nil {
		l = m.Spec.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	return n
}

func (m *UpdateJobRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Key != nil {
		l = m.Key.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	l = len(m.WorkerId)
	if l > 0 {
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.Spec != nil {
		l = m.Spec.Size()
		n += 1 + l + sovScheduler(uint64(l))
	}
	if m.Complete {
		n += 2
	}
	return n
}

func (m *UpdateJobResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func sovScheduler(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozScheduler(x uint64) (n int) {
	return sovScheduler(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *JobKey) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&JobKey{`,
		`Id:` + fmt.Sprintf("%v", this.Id) + `,`,
		`Epoch:` + fmt.Sprintf("%v", this.Epoch) + `,`,
		`}`,
	}, "")
	return s
}
func (this *JobSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&JobSpec{`,
		`Topic:` + fmt.Sprintf("%v", this.Topic) + `,`,
		`Partition:` + fmt.Sprintf("%v", this.Partition) + `,`,
		`StartOffset:` + fmt.Sprintf("%v", this.StartOffset) + `,`,
		`EndOffset:` + fmt.Sprintf("%v", this.EndOffset) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AssignJobRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AssignJobRequest{`,
		`WorkerId:` + fmt.Sprintf("%v", this.WorkerId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AssignJobResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AssignJobResponse{`,
		`Key:` + strings.Replace(this.Key.String(), "JobKey", "JobKey", 1) + `,`,
		`Spec:` + strings.Replace(this.Spec.String(), "JobSpec", "JobSpec", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateJobRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateJobRequest{`,
		`Key:` + strings.Replace(this.Key.String(), "JobKey", "JobKey", 1) + `,`,
		`WorkerId:` + fmt.Sprintf("%v", this.WorkerId) + `,`,
		`Spec:` + strings.Replace(this.Spec.String(), "JobSpec", "JobSpec", 1) + `,`,
		`Complete:` + fmt.Sprintf("%v", this.Complete) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateJobResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateJobResponse{`,
		`}`,
	}, "")
	return s
}
func valueToStringScheduler(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *JobKey) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JobKey: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JobKey: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthScheduler
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Epoch", wireType)
			}
			m.Epoch = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Epoch |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JobSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JobSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JobSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Topic", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthScheduler
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Topic = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Partition", wireType)
			}
			m.Partition = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Partition |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartOffset", wireType)
			}
			m.StartOffset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartOffset |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndOffset", wireType)
			}
			m.EndOffset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndOffset |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AssignJobRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AssignJobRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AssignJobRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthScheduler
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AssignJobResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AssignJobResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AssignJobResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthScheduler
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Key == nil {
				m.Key = &JobKey{}
			}
			if err := m.Key.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthScheduler
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Spec == nil {
				m.Spec = &JobSpec{}
			}
			if err := m.Spec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateJobRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateJobRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateJobRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthScheduler
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Key == nil {
				m.Key = &JobKey{}
			}
			if err := m.Key.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthScheduler
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthScheduler
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Spec == nil {
				m.Spec = &JobSpec{}
			}
			if err := m.Spec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Complete", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Complete = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateJobResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateJobResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateJobResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipScheduler(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthScheduler
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupScheduler
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthScheduler
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthScheduler        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowScheduler          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupScheduler = fmt.Errorf("proto: unexpected end of group")
)
