/* SlingshotView.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SlingshotView.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2019-2025 elementary, Inc. (https://elementary.io)
 *                         2011-2012 Giulio Collura
 */

#include "slingshot.h"
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gee.h>
#include <granite.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef enum  {
	SLINGSHOT_SLINGSHOT_VIEW_MODALITY_NORMAL_VIEW = 0,
	SLINGSHOT_SLINGSHOT_VIEW_MODALITY_CATEGORY_VIEW = 1,
	SLINGSHOT_SLINGSHOT_VIEW_MODALITY_SEARCH_VIEW
} SlingshotSlingshotViewModality;

#define SLINGSHOT_SLINGSHOT_VIEW_TYPE_MODALITY (slingshot_slingshot_view_modality_get_type ())
enum  {
	SLINGSHOT_SLINGSHOT_VIEW_0_PROPERTY,
	SLINGSHOT_SLINGSHOT_VIEW_NUM_PROPERTIES
};
static GParamSpec* slingshot_slingshot_view_properties[SLINGSHOT_SLINGSHOT_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _SlingshotSlingshotViewSearchData SlingshotSlingshotViewSearchData;
enum  {
	SLINGSHOT_SLINGSHOT_VIEW_CLOSE_INDICATOR_SIGNAL,
	SLINGSHOT_SLINGSHOT_VIEW_NUM_SIGNALS
};
static guint slingshot_slingshot_view_signals[SLINGSHOT_SLINGSHOT_VIEW_NUM_SIGNALS] = {0};

struct _SlingshotSlingshotViewPrivate {
	SlingshotBackendSynapseSearch* synapse;
	GtkRevealer* view_selector_revealer;
	SlingshotSlingshotViewModality modality;
	SlingshotWidgetsGrid* grid_view;
	SlingshotWidgetsSearchView* search_view;
	SlingshotWidgetsCategoryView* category_view;
	GtkEventControllerKey* key_controller;
	GtkEventControllerKey* search_key_controller;
};

struct _Block1Data {
	int _ref_count_;
	SlingshotSlingshotView* self;
	gchar* sender_name;
	GVariant* parameters;
};

struct _Block2Data {
	int _ref_count_;
	SlingshotSlingshotView* self;
	GeeList* matches;
	gchar* text;
	gpointer _async_data_;
};

struct _SlingshotSlingshotViewSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SlingshotSlingshotView* self;
	gchar* text;
	SynapseSearchMatch* search_match;
	SynapseMatch* target;
	Block2Data* _data2_;
	gchar* stripped;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	SlingshotBackendSynapseSearch* _tmp2_;
	GeeList* _tmp3_;
	SlingshotBackendSynapseSearch* _tmp4_;
	GeeList* _tmp5_;
};

static gint SlingshotSlingshotView_private_offset;
static gpointer slingshot_slingshot_view_parent_class = NULL;
static GSettings* slingshot_slingshot_view__settings;
static GSettings* slingshot_slingshot_view__settings = NULL;
static SlingshotUnityClientIface * slingshot_slingshot_view_slingshot_unity_client_parent_iface = NULL;

static GType slingshot_slingshot_view_modality_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void slingshot_slingshot_view_real_update_launcher_entry (SlingshotUnityClient* base,
                                                          const gchar* sender_name,
                                                          GVariant* parameters,
                                                          gboolean is_retry);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean ___lambda69_ (Block1Data* _data1_);
static gboolean ____lambda69__gsource_func (gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
static void slingshot_slingshot_view_real_remove_launcher_entry (SlingshotUnityClient* base,
                                                          const gchar* sender_name);
static void slingshot_slingshot_view_search_entry_activated (SlingshotSlingshotView* self);
static gboolean slingshot_slingshot_view_on_search_view_key_press (SlingshotSlingshotView* self,
                                                            guint keyval,
                                                            guint keycode,
                                                            GdkModifierType state);
static gboolean slingshot_slingshot_view_on_key_press (SlingshotSlingshotView* self,
                                                guint keyval,
                                                guint keycode,
                                                GdkModifierType state);
static GSettings* slingshot_slingshot_view_get_settings (void);
static void slingshot_slingshot_view_set_modality (SlingshotSlingshotView* self,
                                            SlingshotSlingshotViewModality new_modality);
static void slingshot_slingshot_view_search_data_free (gpointer _data);
static void slingshot_slingshot_view_search (SlingshotSlingshotView* self,
                                      const gchar* text,
                                      SynapseSearchMatch* search_match,
                                      SynapseMatch* target,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static void slingshot_slingshot_view_search_finish (SlingshotSlingshotView* self,
                                             GAsyncResult* _res_);
static gboolean slingshot_slingshot_view_search_co (SlingshotSlingshotViewSearchData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean ___lambda70_ (SlingshotSlingshotView* self);
static gboolean ____lambda70__gsource_func (gpointer self);
static void slingshot_slingshot_view_search_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static gboolean __lambda71_ (Block2Data* _data2_);
static gboolean ___lambda71__gsource_func (gpointer self);
static void slingshot_slingshot_view_set_settings (GSettings* value);
static GObject * slingshot_slingshot_view_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void _slingshot_slingshot_view___lambda72_ (SlingshotSlingshotView* self);
static void __slingshot_slingshot_view___lambda72__g_settings_changed (GSettings* _sender,
                                                                const gchar* key,
                                                                gpointer self);
static void _slingshot_slingshot_view___lambda73_ (SlingshotSlingshotView* self,
                                            SynapseSearchMatch* match,
                                            SynapseMatch* target);
static void __slingshot_slingshot_view___lambda73__slingshot_widgets_search_view_start_search (SlingshotWidgetsSearchView* _sender,
                                                                                        SynapseSearchMatch* search_match,
                                                                                        SynapseMatch* target,
                                                                                        gpointer self);
static gboolean _slingshot_slingshot_view___lambda74_ (SlingshotSlingshotView* self,
                                                GdkEventKey* event);
static gboolean __slingshot_slingshot_view___lambda74__gtk_widget_key_press_event (GtkWidget* _sender,
                                                                            GdkEventKey* event,
                                                                            gpointer self);
static gboolean _slingshot_slingshot_view_on_key_press_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                      guint keyval,
                                                                                      guint keycode,
                                                                                      GdkModifierType state,
                                                                                      gpointer self);
static gboolean _slingshot_slingshot_view_on_search_view_key_press_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                                  guint keyval,
                                                                                                  guint keycode,
                                                                                                  GdkModifierType state,
                                                                                                  gpointer self);
static void _slingshot_slingshot_view___lambda75_ (SlingshotSlingshotView* self);
static void __slingshot_slingshot_view___lambda75__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                             gpointer self);
static void _slingshot_slingshot_view_search_entry_activated_gtk_entry_activate (GtkEntry* _sender,
                                                                          gpointer self);
static void _slingshot_slingshot_view___lambda76_ (SlingshotSlingshotView* self);
static void __slingshot_slingshot_view___lambda76__slingshot_widgets_grid_app_launched (SlingshotWidgetsGrid* _sender,
                                                                                 gpointer self);
static void _slingshot_slingshot_view___lambda77_ (SlingshotSlingshotView* self);
static void __slingshot_slingshot_view___lambda77__slingshot_widgets_search_view_app_launched (SlingshotWidgetsSearchView* _sender,
                                                                                        gpointer self);
static void _slingshot_slingshot_view___lambda78_ (SlingshotSlingshotView* self);
static void __slingshot_slingshot_view___lambda78__slingshot_backend_app_system_changed (SlingshotBackendAppSystem* _sender,
                                                                                  gpointer self);
static void slingshot_slingshot_view_finalize (GObject * obj);
static GType slingshot_slingshot_view_get_type_once (void);
static void _vala_slingshot_slingshot_view_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_slingshot_slingshot_view_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
slingshot_slingshot_view_get_instance_private (SlingshotSlingshotView* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotSlingshotView_private_offset);
}

static GType
slingshot_slingshot_view_modality_get_type_once (void)
{
	static const GEnumValue values[] = {{SLINGSHOT_SLINGSHOT_VIEW_MODALITY_NORMAL_VIEW, "SLINGSHOT_SLINGSHOT_VIEW_MODALITY_NORMAL_VIEW", "normal-view"}, {SLINGSHOT_SLINGSHOT_VIEW_MODALITY_CATEGORY_VIEW, "SLINGSHOT_SLINGSHOT_VIEW_MODALITY_CATEGORY_VIEW", "category-view"}, {SLINGSHOT_SLINGSHOT_VIEW_MODALITY_SEARCH_VIEW, "SLINGSHOT_SLINGSHOT_VIEW_MODALITY_SEARCH_VIEW", "search-view"}, {0, NULL, NULL}};
	GType slingshot_slingshot_view_modality_type_id;
	slingshot_slingshot_view_modality_type_id = g_enum_register_static ("SlingshotSlingshotViewModality", values);
	return slingshot_slingshot_view_modality_type_id;
}

static GType
slingshot_slingshot_view_modality_get_type (void)
{
	static volatile gsize slingshot_slingshot_view_modality_type_id__once = 0;
	if (g_once_init_enter (&slingshot_slingshot_view_modality_type_id__once)) {
		GType slingshot_slingshot_view_modality_type_id;
		slingshot_slingshot_view_modality_type_id = slingshot_slingshot_view_modality_get_type_once ();
		g_once_init_leave (&slingshot_slingshot_view_modality_type_id__once, slingshot_slingshot_view_modality_type_id);
	}
	return slingshot_slingshot_view_modality_type_id__once;
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		SlingshotSlingshotView* self;
		self = _data1_->self;
		_g_free0 (_data1_->sender_name);
		_g_variant_unref0 (_data1_->parameters);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
___lambda69_ (Block1Data* _data1_)
{
	SlingshotSlingshotView* self;
	gboolean result;
	self = _data1_->self;
	slingshot_unity_client_update_launcher_entry ((SlingshotUnityClient*) self, _data1_->sender_name, _data1_->parameters, TRUE);
	result = FALSE;
	return result;
}

static gboolean
____lambda69__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda69_ (self);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
slingshot_slingshot_view_real_update_launcher_entry (SlingshotUnityClient* base,
                                                     const gchar* sender_name,
                                                     GVariant* parameters,
                                                     gboolean is_retry)
{
	SlingshotSlingshotView * self;
	Block1Data* _data1_;
	gchar* _tmp0_;
	GVariant* _tmp1_;
	gchar* app_uri = NULL;
	GVariantIter* prop_iter = NULL;
	gchar* _tmp2_ = NULL;
	GVariantIter* _tmp3_ = NULL;
	SlingshotBackendAppSystem* _tmp4_;
	GSList* _tmp5_;
	self = (SlingshotSlingshotView*) base;
	g_return_if_fail (sender_name != NULL);
	g_return_if_fail (parameters != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_strdup (sender_name);
	_g_free0 (_data1_->sender_name);
	_data1_->sender_name = _tmp0_;
	_tmp1_ = _g_variant_ref0 (parameters);
	_g_variant_unref0 (_data1_->parameters);
	_data1_->parameters = _tmp1_;
	if (!is_retry) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda69__gsource_func, block1_data_ref (_data1_), block1_data_unref);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	g_variant_get (_data1_->parameters, "(sa{sv})", &_tmp2_, &_tmp3_, NULL);
	_g_free0 (app_uri);
	app_uri = _tmp2_;
	_g_variant_iter_free0 (prop_iter);
	prop_iter = _tmp3_;
	_tmp4_ = self->app_system;
	_tmp5_ = slingshot_backend_app_system_get_apps_by_name (_tmp4_);
	{
		GSList* app_collection = NULL;
		GSList* app_it = NULL;
		app_collection = _tmp5_;
		for (app_it = app_collection; app_it != NULL; app_it = app_it->next) {
			SlingshotBackendApp* _tmp6_;
			SlingshotBackendApp* app = NULL;
			_tmp6_ = _g_object_ref0 ((SlingshotBackendApp*) app_it->data);
			app = _tmp6_;
			{
				const gchar* _tmp7_;
				SlingshotBackendApp* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gboolean _tmp13_;
				_tmp7_ = app_uri;
				_tmp8_ = app;
				_tmp9_ = slingshot_backend_app_get_desktop_id (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strconcat ("application://", _tmp10_, NULL);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strcmp0 (_tmp7_, _tmp12_) == 0;
				_g_free0 (_tmp12_);
				if (_tmp13_) {
					SlingshotBackendApp* _tmp14_;
					GVariantIter* _tmp15_;
					_tmp14_ = app;
					_tmp15_ = prop_iter;
					slingshot_backend_app_perform_unity_update (_tmp14_, _data1_->sender_name, _tmp15_);
				}
				_g_object_unref0 (app);
			}
		}
		(app_collection == NULL) ? NULL : (app_collection = (_g_slist_free__g_object_unref0_ (app_collection), NULL));
	}
	_g_variant_iter_free0 (prop_iter);
	_g_free0 (app_uri);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
slingshot_slingshot_view_real_remove_launcher_entry (SlingshotUnityClient* base,
                                                     const gchar* sender_name)
{
	SlingshotSlingshotView * self;
	SlingshotBackendAppSystem* _tmp0_;
	GSList* _tmp1_;
	self = (SlingshotSlingshotView*) base;
	g_return_if_fail (sender_name != NULL);
	_tmp0_ = self->app_system;
	_tmp1_ = slingshot_backend_app_system_get_apps_by_name (_tmp0_);
	{
		GSList* app_collection = NULL;
		GSList* app_it = NULL;
		app_collection = _tmp1_;
		for (app_it = app_collection; app_it != NULL; app_it = app_it->next) {
			SlingshotBackendApp* _tmp2_;
			SlingshotBackendApp* app = NULL;
			_tmp2_ = _g_object_ref0 ((SlingshotBackendApp*) app_it->data);
			app = _tmp2_;
			{
				SlingshotBackendApp* _tmp3_;
				_tmp3_ = app;
				slingshot_backend_app_remove_launcher_entry (_tmp3_, sender_name);
				_g_object_unref0 (app);
			}
		}
		(app_collection == NULL) ? NULL : (app_collection = (_g_slist_free__g_object_unref0_ (app_collection), NULL));
	}
}

static void
slingshot_slingshot_view_search_entry_activated (SlingshotSlingshotView* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->modality == SLINGSHOT_SLINGSHOT_VIEW_MODALITY_SEARCH_VIEW) {
		SlingshotWidgetsSearchView* _tmp0_;
		_tmp0_ = self->priv->search_view;
		slingshot_widgets_search_view_activate_selection (_tmp0_);
	}
}

static gboolean
slingshot_slingshot_view_on_search_view_key_press (SlingshotSlingshotView* self,
                                                   guint keyval,
                                                   guint keycode,
                                                   GdkModifierType state)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	switch (keyval) {
		case GDK_KEY_Down:
		{
			GtkSearchEntry* _tmp0_;
			_tmp0_ = self->search_entry;
			g_signal_emit_by_name ((GtkWidget*) _tmp0_, "move-focus", GTK_DIR_TAB_FORWARD);
			result = GDK_EVENT_STOP;
			return result;
		}
		case GDK_KEY_Escape:
		{
			GtkSearchEntry* _tmp1_;
			const gchar* _tmp2_;
			const gchar* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			_tmp1_ = self->search_entry;
			_tmp2_ = gtk_entry_get_text ((GtkEntry*) _tmp1_);
			_tmp3_ = _tmp2_;
			_tmp4_ = strlen (_tmp3_);
			_tmp5_ = _tmp4_;
			if (_tmp5_ > 0) {
				GtkSearchEntry* _tmp6_;
				_tmp6_ = self->search_entry;
				gtk_entry_set_text ((GtkEntry*) _tmp6_, "");
			} else {
				g_signal_emit (self, slingshot_slingshot_view_signals[SLINGSHOT_SLINGSHOT_VIEW_CLOSE_INDICATOR_SIGNAL], 0);
			}
			result = GDK_EVENT_STOP;
			return result;
		}
		default:
		break;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
slingshot_slingshot_view_on_key_press (SlingshotSlingshotView* self,
                                       guint keyval,
                                       guint keycode,
                                       GdkModifierType state)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((state & GDK_CONTROL_MASK) != 0) {
		switch (keyval) {
			case GDK_KEY_1:
			{
				GSettings* _tmp0_;
				GSettings* _tmp1_;
				_tmp0_ = slingshot_slingshot_view_get_settings ();
				_tmp1_ = _tmp0_;
				g_settings_set_string (_tmp1_, "view-mode", "grid");
				result = GDK_EVENT_STOP;
				return result;
			}
			case GDK_KEY_2:
			{
				GSettings* _tmp2_;
				GSettings* _tmp3_;
				_tmp2_ = slingshot_slingshot_view_get_settings ();
				_tmp3_ = _tmp2_;
				g_settings_set_string (_tmp3_, "view-mode", "category");
				result = GDK_EVENT_STOP;
				return result;
			}
			default:
			break;
		}
	}
	if ((state & GDK_MOD1_MASK) != 0) {
		switch (keyval) {
			case GDK_KEY_F4:
			{
				g_signal_emit (self, slingshot_slingshot_view_signals[SLINGSHOT_SLINGSHOT_VIEW_CLOSE_INDICATOR_SIGNAL], 0);
				result = GDK_EVENT_STOP;
				return result;
			}
			case GDK_KEY_0:
			case GDK_KEY_1:
			case GDK_KEY_2:
			case GDK_KEY_3:
			case GDK_KEY_4:
			case GDK_KEY_5:
			case GDK_KEY_6:
			case GDK_KEY_7:
			case GDK_KEY_8:
			case GDK_KEY_9:
			{
				if (self->priv->modality == SLINGSHOT_SLINGSHOT_VIEW_MODALITY_NORMAL_VIEW) {
					gchar* key = NULL;
					const gchar* _tmp4_;
					gchar* _tmp5_;
					gint page = 0;
					const gchar* _tmp6_;
					gboolean _tmp7_ = FALSE;
					_tmp4_ = gdk_keyval_name (keyval);
					_tmp5_ = string_replace (_tmp4_, "KP_", "");
					key = _tmp5_;
					_tmp6_ = key;
					page = atoi (_tmp6_);
					if (page < 0) {
						_tmp7_ = TRUE;
					} else {
						_tmp7_ = page == 9;
					}
					if (_tmp7_) {
						SlingshotWidgetsGrid* _tmp8_;
						_tmp8_ = self->priv->grid_view;
						slingshot_widgets_grid_go_to_last (_tmp8_);
					} else {
						SlingshotWidgetsGrid* _tmp9_;
						_tmp9_ = self->priv->grid_view;
						slingshot_widgets_grid_go_to_number (_tmp9_, page);
					}
					_g_free0 (key);
				}
				result = GDK_EVENT_STOP;
				return result;
			}
			default:
			break;
		}
	}
	switch (keyval) {
		case GDK_KEY_Page_Up:
		{
			if (self->priv->modality == SLINGSHOT_SLINGSHOT_VIEW_MODALITY_NORMAL_VIEW) {
				SlingshotWidgetsGrid* _tmp10_;
				_tmp10_ = self->priv->grid_view;
				slingshot_widgets_grid_go_to_previous (_tmp10_);
			} else {
				if (self->priv->modality == SLINGSHOT_SLINGSHOT_VIEW_MODALITY_CATEGORY_VIEW) {
					SlingshotWidgetsCategoryView* _tmp11_;
					_tmp11_ = self->priv->category_view;
					slingshot_widgets_category_view_page_up (_tmp11_);
				}
			}
			break;
		}
		case GDK_KEY_Page_Down:
		{
			if (self->priv->modality == SLINGSHOT_SLINGSHOT_VIEW_MODALITY_NORMAL_VIEW) {
				SlingshotWidgetsGrid* _tmp12_;
				_tmp12_ = self->priv->grid_view;
				slingshot_widgets_grid_go_to_next (_tmp12_);
			} else {
				if (self->priv->modality == SLINGSHOT_SLINGSHOT_VIEW_MODALITY_CATEGORY_VIEW) {
					SlingshotWidgetsCategoryView* _tmp13_;
					_tmp13_ = self->priv->category_view;
					slingshot_widgets_category_view_page_down (_tmp13_);
				}
			}
			break;
		}
		case GDK_KEY_End:
		{
			if (self->priv->modality == SLINGSHOT_SLINGSHOT_VIEW_MODALITY_NORMAL_VIEW) {
				SlingshotWidgetsGrid* _tmp14_;
				_tmp14_ = self->priv->grid_view;
				slingshot_widgets_grid_go_to_last (_tmp14_);
			}
			break;
		}
		default:
		break;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

void
slingshot_slingshot_view_show_slingshot (SlingshotSlingshotView* self)
{
	GtkSearchEntry* _tmp0_;
	GtkSearchEntry* _tmp1_;
	GtkRevealer* _tmp2_;
	GtkStack* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GtkRevealer* _tmp6_;
	GtkStack* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->search_entry;
	gtk_entry_set_text ((GtkEntry*) _tmp0_, "");
	_tmp1_ = self->search_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->view_selector_revealer;
	gtk_revealer_set_transition_type (_tmp2_, GTK_REVEALER_TRANSITION_TYPE_NONE);
	_tmp3_ = self->stack;
	gtk_stack_set_transition_type (_tmp3_, GTK_STACK_TRANSITION_TYPE_NONE);
	_tmp4_ = slingshot_slingshot_view_get_settings ();
	_tmp5_ = _tmp4_;
	slingshot_slingshot_view_set_modality (self, (SlingshotSlingshotViewModality) g_settings_get_enum (_tmp5_, "view-mode"));
	_tmp6_ = self->priv->view_selector_revealer;
	gtk_revealer_set_transition_type (_tmp6_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_RIGHT);
	_tmp7_ = self->stack;
	gtk_stack_set_transition_type (_tmp7_, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
}

static void
slingshot_slingshot_view_set_modality (SlingshotSlingshotView* self,
                                       SlingshotSlingshotViewModality new_modality)
{
	g_return_if_fail (self != NULL);
	self->priv->modality = new_modality;
	switch (self->priv->modality) {
		case SLINGSHOT_SLINGSHOT_VIEW_MODALITY_NORMAL_VIEW:
		{
			GtkRevealer* _tmp0_;
			GtkStack* _tmp1_;
			_tmp0_ = self->priv->view_selector_revealer;
			gtk_revealer_set_reveal_child (_tmp0_, TRUE);
			_tmp1_ = self->stack;
			gtk_stack_set_visible_child_name (_tmp1_, "normal");
			break;
		}
		case SLINGSHOT_SLINGSHOT_VIEW_MODALITY_CATEGORY_VIEW:
		{
			GtkRevealer* _tmp2_;
			GtkStack* _tmp3_;
			_tmp2_ = self->priv->view_selector_revealer;
			gtk_revealer_set_reveal_child (_tmp2_, TRUE);
			_tmp3_ = self->stack;
			gtk_stack_set_visible_child_name (_tmp3_, "category");
			break;
		}
		case SLINGSHOT_SLINGSHOT_VIEW_MODALITY_SEARCH_VIEW:
		{
			GtkRevealer* _tmp4_;
			GtkStack* _tmp5_;
			_tmp4_ = self->priv->view_selector_revealer;
			gtk_revealer_set_reveal_child (_tmp4_, FALSE);
			_tmp5_ = self->stack;
			gtk_stack_set_visible_child_name (_tmp5_, "search");
			break;
		}
		default:
		break;
	}
}

static void
slingshot_slingshot_view_search_data_free (gpointer _data)
{
	SlingshotSlingshotViewSearchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->search_match);
	_g_object_unref0 (_data_->target);
	_g_object_unref0 (_data_->self);
	g_slice_free (SlingshotSlingshotViewSearchData, _data_);
}

static void
slingshot_slingshot_view_search (SlingshotSlingshotView* self,
                                 const gchar* text,
                                 SynapseSearchMatch* search_match,
                                 SynapseMatch* target,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	SlingshotSlingshotViewSearchData* _data_;
	SlingshotSlingshotView* _tmp0_;
	gchar* _tmp1_;
	SynapseSearchMatch* _tmp2_;
	SynapseMatch* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_data_ = g_slice_new0 (SlingshotSlingshotViewSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, slingshot_slingshot_view_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (text);
	_g_free0 (_data_->text);
	_data_->text = _tmp1_;
	_tmp2_ = _g_object_ref0 (search_match);
	_g_object_unref0 (_data_->search_match);
	_data_->search_match = _tmp2_;
	_tmp3_ = _g_object_ref0 (target);
	_g_object_unref0 (_data_->target);
	_data_->target = _tmp3_;
	slingshot_slingshot_view_search_co (_data_);
}

static void
slingshot_slingshot_view_search_finish (SlingshotSlingshotView* self,
                                        GAsyncResult* _res_)
{
	SlingshotSlingshotViewSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		SlingshotSlingshotView* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->matches);
		_g_free0 (_data2_->text);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
___lambda70_ (SlingshotSlingshotView* self)
{
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean result;
	_tmp0_ = self->search_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_strip (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "") == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		GSettings* _tmp6_;
		GSettings* _tmp7_;
		_tmp6_ = slingshot_slingshot_view_get_settings ();
		_tmp7_ = _tmp6_;
		slingshot_slingshot_view_set_modality (self, (SlingshotSlingshotViewModality) g_settings_get_enum (_tmp7_, "view-mode"));
	}
	result = FALSE;
	return result;
}

static gboolean
____lambda70__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda70_ ((SlingshotSlingshotView*) self);
	return result;
}

static void
slingshot_slingshot_view_search_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	SlingshotSlingshotViewSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	slingshot_slingshot_view_search_co (_data_);
}

static gboolean
__lambda71_ (Block2Data* _data2_)
{
	SlingshotSlingshotView* self;
	SlingshotWidgetsSearchView* _tmp0_;
	GeeList* _tmp1_;
	gboolean result;
	self = _data2_->self;
	_tmp0_ = self->priv->search_view;
	_tmp1_ = _data2_->matches;
	slingshot_widgets_search_view_set_results (_tmp0_, _tmp1_, _data2_->text);
	result = FALSE;
	return result;
}

static gboolean
___lambda71__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda71_ (self);
	return result;
}

static gboolean
slingshot_slingshot_view_search_co (SlingshotSlingshotViewSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = g_object_ref (_data_->self);
	_g_free0 (_data_->_data2_->text);
	_data_->_data2_->text = _data_->text;
	_data_->_data2_->_async_data_ = _data_;
	_data_->_tmp0_ = string_strip (_data_->_data2_->text);
	_data_->stripped = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->stripped;
	if (g_strcmp0 (_data_->_tmp1_, "") == 0) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda70__gsource_func, g_object_ref (_data_->self), g_object_unref);
		_g_free0 (_data_->stripped);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->self->priv->modality != SLINGSHOT_SLINGSHOT_VIEW_MODALITY_SEARCH_VIEW) {
		slingshot_slingshot_view_set_modality (_data_->self, SLINGSHOT_SLINGSHOT_VIEW_MODALITY_SEARCH_VIEW);
	}
	if (_data_->search_match != NULL) {
		synapse_search_match_set_search_source (_data_->search_match, _data_->target);
		_data_->_tmp2_ = _data_->self->priv->synapse;
		_data_->_state_ = 1;
		slingshot_backend_synapse_search_search (_data_->_tmp2_, _data_->_data2_->text, (SynapseSearchProvider*) _data_->search_match, slingshot_slingshot_view_search_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = slingshot_backend_synapse_search_search_finish (_data_->_tmp2_, _data_->_res_);
		_g_object_unref0 (_data_->_data2_->matches);
		_data_->_data2_->matches = _data_->_tmp3_;
	} else {
		_data_->_tmp4_ = _data_->self->priv->synapse;
		_data_->_state_ = 2;
		slingshot_backend_synapse_search_search (_data_->_tmp4_, _data_->_data2_->text, NULL, slingshot_slingshot_view_search_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp5_ = slingshot_backend_synapse_search_search_finish (_data_->_tmp4_, _data_->_res_);
		_g_object_unref0 (_data_->_data2_->matches);
		_data_->_data2_->matches = _data_->_tmp5_;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda71__gsource_func, block2_data_ref (_data_->_data2_), block2_data_unref);
	_g_free0 (_data_->stripped);
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

SlingshotSlingshotView*
slingshot_slingshot_view_construct (GType object_type)
{
	SlingshotSlingshotView * self = NULL;
	self = (SlingshotSlingshotView*) g_object_new (object_type, NULL);
	return self;
}

SlingshotSlingshotView*
slingshot_slingshot_view_new (void)
{
	return slingshot_slingshot_view_construct (SLINGSHOT_TYPE_SLINGSHOT_VIEW);
}

static GSettings*
slingshot_slingshot_view_get_settings (void)
{
	GSettings* result;
	GSettings* _tmp0_;
	_tmp0_ = slingshot_slingshot_view__settings;
	result = _tmp0_;
	return result;
}

static void
slingshot_slingshot_view_set_settings (GSettings* value)
{
	GSettings* _tmp0_;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (slingshot_slingshot_view__settings);
	slingshot_slingshot_view__settings = _tmp0_;
}

static void
_slingshot_slingshot_view___lambda72_ (SlingshotSlingshotView* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	_tmp0_ = slingshot_slingshot_view_get_settings ();
	_tmp1_ = _tmp0_;
	slingshot_slingshot_view_set_modality (self, (SlingshotSlingshotViewModality) g_settings_get_enum (_tmp1_, "view-mode"));
}

static void
__slingshot_slingshot_view___lambda72__g_settings_changed (GSettings* _sender,
                                                           const gchar* key,
                                                           gpointer self)
{
	_slingshot_slingshot_view___lambda72_ ((SlingshotSlingshotView*) self);
}

static void
_slingshot_slingshot_view___lambda73_ (SlingshotSlingshotView* self,
                                       SynapseSearchMatch* match,
                                       SynapseMatch* target)
{
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (match != NULL);
	_tmp0_ = self->search_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	slingshot_slingshot_view_search (self, _tmp2_, match, target, NULL, NULL);
}

static void
__slingshot_slingshot_view___lambda73__slingshot_widgets_search_view_start_search (SlingshotWidgetsSearchView* _sender,
                                                                                   SynapseSearchMatch* search_match,
                                                                                   SynapseMatch* target,
                                                                                   gpointer self)
{
	_slingshot_slingshot_view___lambda73_ ((SlingshotSlingshotView*) self, search_match, target);
}

static gboolean
_slingshot_slingshot_view___lambda74_ (SlingshotSlingshotView* self,
                                       GdkEventKey* event)
{
	gboolean search_handles_event = FALSE;
	GtkSearchEntry* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->search_entry;
	search_handles_event = gtk_search_entry_handle_event (_tmp0_, (GdkEvent*) event);
	if (search_handles_event) {
		GtkSearchEntry* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->search_entry;
		g_object_get ((GtkWidget*) _tmp2_, "has-focus", &_tmp3_, NULL);
		_tmp4_ = _tmp3_;
		_tmp1_ = !_tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GtkSearchEntry* _tmp5_;
		GtkSearchEntry* _tmp6_;
		_tmp5_ = self->search_entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp5_);
		_tmp6_ = self->search_entry;
		g_signal_emit_by_name ((GtkEntry*) _tmp6_, "move-cursor", GTK_MOVEMENT_BUFFER_ENDS, 0, FALSE);
	}
	result = search_handles_event;
	return result;
}

static gboolean
__slingshot_slingshot_view___lambda74__gtk_widget_key_press_event (GtkWidget* _sender,
                                                                   GdkEventKey* event,
                                                                   gpointer self)
{
	gboolean result;
	result = _slingshot_slingshot_view___lambda74_ ((SlingshotSlingshotView*) self, event);
	return result;
}

static gboolean
_slingshot_slingshot_view_on_key_press_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                             guint keyval,
                                                                             guint keycode,
                                                                             GdkModifierType state,
                                                                             gpointer self)
{
	gboolean result;
	result = slingshot_slingshot_view_on_key_press ((SlingshotSlingshotView*) self, keyval, keycode, state);
	return result;
}

static gboolean
_slingshot_slingshot_view_on_search_view_key_press_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                         guint keyval,
                                                                                         guint keycode,
                                                                                         GdkModifierType state,
                                                                                         gpointer self)
{
	gboolean result;
	result = slingshot_slingshot_view_on_search_view_key_press ((SlingshotSlingshotView*) self, keyval, keycode, state);
	return result;
}

static void
_slingshot_slingshot_view___lambda75_ (SlingshotSlingshotView* self)
{
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	if (self->priv->modality != SLINGSHOT_SLINGSHOT_VIEW_MODALITY_SEARCH_VIEW) {
		slingshot_slingshot_view_set_modality (self, SLINGSHOT_SLINGSHOT_VIEW_MODALITY_SEARCH_VIEW);
	}
	_tmp0_ = self->search_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	slingshot_slingshot_view_search (self, _tmp2_, NULL, NULL, NULL, NULL);
}

static void
__slingshot_slingshot_view___lambda75__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                        gpointer self)
{
	_slingshot_slingshot_view___lambda75_ ((SlingshotSlingshotView*) self);
}

static void
_slingshot_slingshot_view_search_entry_activated_gtk_entry_activate (GtkEntry* _sender,
                                                                     gpointer self)
{
	slingshot_slingshot_view_search_entry_activated ((SlingshotSlingshotView*) self);
}

static void
_slingshot_slingshot_view___lambda76_ (SlingshotSlingshotView* self)
{
	g_signal_emit (self, slingshot_slingshot_view_signals[SLINGSHOT_SLINGSHOT_VIEW_CLOSE_INDICATOR_SIGNAL], 0);
}

static void
__slingshot_slingshot_view___lambda76__slingshot_widgets_grid_app_launched (SlingshotWidgetsGrid* _sender,
                                                                            gpointer self)
{
	_slingshot_slingshot_view___lambda76_ ((SlingshotSlingshotView*) self);
}

static void
_slingshot_slingshot_view___lambda77_ (SlingshotSlingshotView* self)
{
	g_signal_emit (self, slingshot_slingshot_view_signals[SLINGSHOT_SLINGSHOT_VIEW_CLOSE_INDICATOR_SIGNAL], 0);
}

static void
__slingshot_slingshot_view___lambda77__slingshot_widgets_search_view_app_launched (SlingshotWidgetsSearchView* _sender,
                                                                                   gpointer self)
{
	_slingshot_slingshot_view___lambda77_ ((SlingshotSlingshotView*) self);
}

static void
_slingshot_slingshot_view___lambda78_ (SlingshotSlingshotView* self)
{
	SlingshotWidgetsGrid* _tmp0_;
	SlingshotBackendAppSystem* _tmp1_;
	SlingshotWidgetsCategoryView* _tmp2_;
	_tmp0_ = self->priv->grid_view;
	_tmp1_ = self->app_system;
	slingshot_widgets_grid_populate (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->category_view;
	slingshot_widgets_category_view_setup_sidebar (_tmp2_);
}

static void
__slingshot_slingshot_view___lambda78__slingshot_backend_app_system_changed (SlingshotBackendAppSystem* _sender,
                                                                             gpointer self)
{
	_slingshot_slingshot_view___lambda78_ ((SlingshotSlingshotView*) self);
}

static GObject *
slingshot_slingshot_view_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SlingshotSlingshotView * self;
	SlingshotBackendAppSystem* _tmp0_;
	SlingshotBackendSynapseSearch* _tmp1_;
	GtkToggleButton* grid_view_btn = NULL;
	gchar* _tmp2_;
	GVariant* _tmp3_;
	GtkImage* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar* _tmp8_;
	GtkToggleButton* _tmp9_ = NULL;
	GtkToggleButton* _tmp10_;
	GtkToggleButton* category_view_btn = NULL;
	gchar* _tmp11_;
	GVariant* _tmp12_;
	GtkImage* _tmp13_;
	gchar* _tmp14_;
	gchar** _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar* _tmp17_;
	GtkToggleButton* _tmp18_ = NULL;
	GtkToggleButton* _tmp19_;
	GtkBox* view_selector = NULL;
	GtkBox* _tmp20_ = NULL;
	GtkBox* _tmp21_;
	GtkToggleButton* _tmp22_;
	GtkBox* _tmp23_;
	GtkToggleButton* _tmp24_;
	GtkBox* _tmp25_;
	GtkStyleContext* _tmp26_;
	GtkBox* _tmp27_;
	GtkWidget* _tmp28_;
	GtkRevealer* _tmp29_ = NULL;
	gchar* _tmp30_;
	GtkSearchEntry* _tmp31_ = NULL;
	GtkBox* top_box = NULL;
	GtkBox* _tmp32_ = NULL;
	GtkBox* _tmp33_;
	GtkRevealer* _tmp34_;
	GtkBox* _tmp35_;
	GtkSearchEntry* _tmp36_;
	SlingshotWidgetsGrid* _tmp37_;
	SlingshotWidgetsCategoryView* _tmp38_;
	SlingshotWidgetsSearchView* _tmp39_;
	GtkStack* _tmp40_ = NULL;
	GtkStack* _tmp41_;
	SlingshotWidgetsGrid* _tmp42_;
	GtkStack* _tmp43_;
	SlingshotWidgetsCategoryView* _tmp44_;
	GtkStack* _tmp45_;
	SlingshotWidgetsSearchView* _tmp46_;
	GtkBox* container = NULL;
	GtkBox* _tmp47_ = NULL;
	GtkBox* _tmp48_;
	GtkBox* _tmp49_;
	GtkBox* _tmp50_;
	GtkStack* _tmp51_;
	SlingshotWidgetsGrid* _tmp52_;
	SlingshotBackendAppSystem* _tmp53_;
	GtkBox* _tmp54_;
	GAction* category_action = NULL;
	GSettings* _tmp55_;
	GSettings* _tmp56_;
	GAction* _tmp57_;
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp58_;
	GSimpleActionGroup* _tmp59_;
	GAction* _tmp60_;
	GSimpleActionGroup* _tmp61_;
	GSettings* _tmp62_;
	GSettings* _tmp63_;
	SlingshotWidgetsSearchView* _tmp64_;
	GtkEventControllerKey* _tmp65_;
	GtkEventControllerKey* _tmp66_;
	GtkSearchEntry* _tmp67_;
	GtkEventControllerKey* _tmp68_;
	GtkEventControllerKey* _tmp69_;
	GtkSearchEntry* _tmp70_;
	GtkSearchEntry* _tmp71_;
	SlingshotWidgetsGrid* _tmp72_;
	SlingshotWidgetsSearchView* _tmp73_;
	SlingshotBackendAppSystem* _tmp74_;
	GSettings* _tmp75_;
	GSettings* _tmp76_;
	parent_class = G_OBJECT_CLASS (slingshot_slingshot_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_TYPE_SLINGSHOT_VIEW, SlingshotSlingshotView);
	_tmp0_ = slingshot_backend_app_system_new ();
	_g_object_unref0 (self->app_system);
	self->app_system = _tmp0_;
	_tmp1_ = slingshot_backend_synapse_search_new ();
	_g_object_unref0 (self->priv->synapse);
	self->priv->synapse = _tmp1_;
	_tmp2_ = g_strdup ("view.view-mode");
	_tmp3_ = g_variant_new_string ("grid");
	g_variant_ref_sink (_tmp3_);
	_tmp4_ = (GtkImage*) gtk_image_new_from_icon_name ("view-grid-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp4_);
	_tmp5_ = g_strdup ("<Ctrl>1");
	_tmp6_ = g_new0 (gchar*, 1 + 1);
	_tmp6_[0] = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 1;
	_tmp8_ = granite_markup_accel_tooltip (_tmp7_, (gint) 1, _ ("View as Grid"));
	_tmp9_ = (GtkToggleButton*) gtk_toggle_button_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp9_, _tmp2_);
	_g_free0 (_tmp2_);
	g_object_set ((GtkActionable*) _tmp9_, "action-target", _tmp3_, NULL);
	_g_variant_unref0 (_tmp3_);
	gtk_button_set_image ((GtkButton*) _tmp9_, (GtkWidget*) _tmp4_);
	_g_object_unref0 (_tmp4_);
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp9_, _tmp8_);
	_g_free0 (_tmp8_);
	g_object_ref_sink (_tmp9_);
	_tmp10_ = _tmp9_;
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	grid_view_btn = _tmp10_;
	_tmp11_ = g_strdup ("view.view-mode");
	_tmp12_ = g_variant_new_string ("category");
	g_variant_ref_sink (_tmp12_);
	_tmp13_ = (GtkImage*) gtk_image_new_from_icon_name ("view-filter-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp13_);
	_tmp14_ = g_strdup ("<Ctrl>2");
	_tmp15_ = g_new0 (gchar*, 1 + 1);
	_tmp15_[0] = _tmp14_;
	_tmp16_ = _tmp15_;
	_tmp16__length1 = 1;
	_tmp17_ = granite_markup_accel_tooltip (_tmp16_, (gint) 1, _ ("View by Category"));
	_tmp18_ = (GtkToggleButton*) gtk_toggle_button_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp18_, _tmp11_);
	_g_free0 (_tmp11_);
	g_object_set ((GtkActionable*) _tmp18_, "action-target", _tmp12_, NULL);
	_g_variant_unref0 (_tmp12_);
	gtk_button_set_image ((GtkButton*) _tmp18_, (GtkWidget*) _tmp13_);
	_g_object_unref0 (_tmp13_);
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp18_, _tmp17_);
	_g_free0 (_tmp17_);
	g_object_ref_sink (_tmp18_);
	_tmp19_ = _tmp18_;
	_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
	category_view_btn = _tmp19_;
	_tmp20_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp20_, 12);
	g_object_ref_sink (_tmp20_);
	view_selector = _tmp20_;
	_tmp21_ = view_selector;
	_tmp22_ = grid_view_btn;
	gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = view_selector;
	_tmp24_ = category_view_btn;
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = view_selector;
	_tmp26_ = gtk_widget_get_style_context ((GtkWidget*) _tmp25_);
	gtk_style_context_add_class (_tmp26_, GTK_STYLE_CLASS_LINKED);
	_tmp27_ = view_selector;
	_tmp28_ = _g_object_ref0 ((GtkWidget*) _tmp27_);
	_tmp29_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_set ((GtkContainer*) _tmp29_, "child", _tmp28_, NULL);
	_g_object_unref0 (_tmp28_);
	gtk_revealer_set_transition_type (_tmp29_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_RIGHT);
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->view_selector_revealer);
	self->priv->view_selector_revealer = _tmp29_;
	_tmp30_ = g_strdup (_ ("Search Apps"));
	_tmp31_ = (GtkSearchEntry*) gtk_search_entry_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp31_, TRUE);
	gtk_entry_set_placeholder_text ((GtkEntry*) _tmp31_, _tmp30_);
	_g_free0 (_tmp30_);
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->search_entry);
	self->search_entry = _tmp31_;
	_tmp32_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp32_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp32_, 12);
	g_object_ref_sink (_tmp32_);
	top_box = _tmp32_;
	_tmp33_ = top_box;
	_tmp34_ = self->priv->view_selector_revealer;
	gtk_container_add ((GtkContainer*) _tmp33_, (GtkWidget*) _tmp34_);
	_tmp35_ = top_box;
	_tmp36_ = self->search_entry;
	gtk_container_add ((GtkContainer*) _tmp35_, (GtkWidget*) _tmp36_);
	_tmp37_ = slingshot_widgets_grid_new ();
	g_object_ref_sink (_tmp37_);
	_g_object_unref0 (self->priv->grid_view);
	self->priv->grid_view = _tmp37_;
	_tmp38_ = slingshot_widgets_category_view_new (self);
	g_object_ref_sink (_tmp38_);
	_g_object_unref0 (self->priv->category_view);
	self->priv->category_view = _tmp38_;
	_tmp39_ = slingshot_widgets_search_view_new ();
	g_object_ref_sink (_tmp39_);
	_g_object_unref0 (self->priv->search_view);
	self->priv->search_view = _tmp39_;
	_tmp40_ = (GtkStack*) gtk_stack_new ();
	gtk_stack_set_transition_duration (_tmp40_, (guint) GRANITE_TRANSITION_DURATION_IN_PLACE);
	gtk_stack_set_transition_type (_tmp40_, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
	g_object_ref_sink (_tmp40_);
	_g_object_unref0 (self->stack);
	self->stack = _tmp40_;
	_tmp41_ = self->stack;
	_tmp42_ = self->priv->grid_view;
	gtk_stack_add_named (_tmp41_, (GtkWidget*) _tmp42_, "normal");
	_tmp43_ = self->stack;
	_tmp44_ = self->priv->category_view;
	gtk_stack_add_named (_tmp43_, (GtkWidget*) _tmp44_, "category");
	_tmp45_ = self->stack;
	_tmp46_ = self->priv->search_view;
	gtk_stack_add_named (_tmp45_, (GtkWidget*) _tmp46_, "search");
	_tmp47_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 12);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp47_, 12);
	g_object_ref_sink (_tmp47_);
	container = _tmp47_;
	_tmp48_ = container;
	_tmp49_ = top_box;
	gtk_container_add ((GtkContainer*) _tmp48_, (GtkWidget*) _tmp49_);
	_tmp50_ = container;
	_tmp51_ = self->stack;
	gtk_container_add ((GtkContainer*) _tmp50_, (GtkWidget*) _tmp51_);
	_tmp52_ = self->priv->grid_view;
	_tmp53_ = self->app_system;
	slingshot_widgets_grid_populate (_tmp52_, _tmp53_);
	_tmp54_ = container;
	g_object_set ((GtkContainer*) self, "child", (GtkWidget*) _tmp54_, NULL);
	_tmp55_ = slingshot_slingshot_view_get_settings ();
	_tmp56_ = _tmp55_;
	_tmp57_ = g_settings_create_action (_tmp56_, "view-mode");
	category_action = _tmp57_;
	_tmp58_ = g_simple_action_group_new ();
	action_group = _tmp58_;
	_tmp59_ = action_group;
	_tmp60_ = category_action;
	g_action_map_add_action ((GActionMap*) _tmp59_, _tmp60_);
	_tmp61_ = action_group;
	gtk_widget_insert_action_group ((GtkWidget*) self, "view", (GActionGroup*) _tmp61_);
	_tmp62_ = slingshot_slingshot_view_get_settings ();
	_tmp63_ = _tmp62_;
	g_signal_connect_object (_tmp63_, "changed::view-mode", (GCallback) __slingshot_slingshot_view___lambda72__g_settings_changed, self, 0);
	_tmp64_ = self->priv->search_view;
	g_signal_connect_object (_tmp64_, "start-search", (GCallback) __slingshot_slingshot_view___lambda73__slingshot_widgets_search_view_start_search, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "key-press-event", (GCallback) __slingshot_slingshot_view___lambda74__gtk_widget_key_press_event, self, 0);
	_tmp65_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) self);
	_g_object_unref0 (self->priv->key_controller);
	self->priv->key_controller = _tmp65_;
	_tmp66_ = self->priv->key_controller;
	g_signal_connect_object (_tmp66_, "key-pressed", (GCallback) _slingshot_slingshot_view_on_key_press_gtk_event_controller_key_key_pressed, self, 0);
	_tmp67_ = self->search_entry;
	_tmp68_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) _tmp67_);
	_g_object_unref0 (self->priv->search_key_controller);
	self->priv->search_key_controller = _tmp68_;
	_tmp69_ = self->priv->search_key_controller;
	g_signal_connect_object (_tmp69_, "key-pressed", (GCallback) _slingshot_slingshot_view_on_search_view_key_press_gtk_event_controller_key_key_pressed, self, 0);
	_tmp70_ = self->search_entry;
	g_signal_connect_object (_tmp70_, "search-changed", (GCallback) __slingshot_slingshot_view___lambda75__gtk_search_entry_search_changed, self, 0);
	_tmp71_ = self->search_entry;
	g_signal_connect_object ((GtkEntry*) _tmp71_, "activate", (GCallback) _slingshot_slingshot_view_search_entry_activated_gtk_entry_activate, self, 0);
	_tmp72_ = self->priv->grid_view;
	g_signal_connect_object (_tmp72_, "app-launched", (GCallback) __slingshot_slingshot_view___lambda76__slingshot_widgets_grid_app_launched, self, 0);
	_tmp73_ = self->priv->search_view;
	g_signal_connect_object (_tmp73_, "app-launched", (GCallback) __slingshot_slingshot_view___lambda77__slingshot_widgets_search_view_app_launched, self, 0);
	_tmp74_ = self->app_system;
	g_signal_connect_object (_tmp74_, "changed", (GCallback) __slingshot_slingshot_view___lambda78__slingshot_backend_app_system_changed, self, 0);
	_tmp75_ = slingshot_slingshot_view_get_settings ();
	_tmp76_ = _tmp75_;
	if (g_settings_get_boolean (_tmp76_, "use-category")) {
		GSettings* _tmp77_;
		GSettings* _tmp78_;
		GSettings* _tmp79_;
		GSettings* _tmp80_;
		_tmp77_ = slingshot_slingshot_view_get_settings ();
		_tmp78_ = _tmp77_;
		g_settings_set_boolean (_tmp78_, "use-category", FALSE);
		_tmp79_ = slingshot_slingshot_view_get_settings ();
		_tmp80_ = _tmp79_;
		g_settings_set_string (_tmp80_, "view-mode", "category");
	}
	_g_object_unref0 (action_group);
	_g_object_unref0 (category_action);
	_g_object_unref0 (container);
	_g_object_unref0 (top_box);
	_g_object_unref0 (view_selector);
	_g_object_unref0 (category_view_btn);
	_g_object_unref0 (grid_view_btn);
	return obj;
}

static void
slingshot_slingshot_view_class_init (SlingshotSlingshotViewClass * klass,
                                     gpointer klass_data)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	slingshot_slingshot_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotSlingshotView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_slingshot_slingshot_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_slingshot_slingshot_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = slingshot_slingshot_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = slingshot_slingshot_view_finalize;
	slingshot_slingshot_view_signals[SLINGSHOT_SLINGSHOT_VIEW_CLOSE_INDICATOR_SIGNAL] = g_signal_new ("close-indicator", SLINGSHOT_TYPE_SLINGSHOT_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = g_settings_new ("io.elementary.desktop.wingpanel.applications-menu");
	_tmp1_ = _tmp0_;
	slingshot_slingshot_view_set_settings (_tmp1_);
	_g_object_unref0 (_tmp1_);
}

static void
slingshot_slingshot_view_slingshot_unity_client_interface_init (SlingshotUnityClientIface * iface,
                                                                gpointer iface_data)
{
	slingshot_slingshot_view_slingshot_unity_client_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_launcher_entry = (void (*) (SlingshotUnityClient*, const gchar*, GVariant*, gboolean)) slingshot_slingshot_view_real_update_launcher_entry;
	iface->remove_launcher_entry = (void (*) (SlingshotUnityClient*, const gchar*)) slingshot_slingshot_view_real_remove_launcher_entry;
}

static void
slingshot_slingshot_view_instance_init (SlingshotSlingshotView * self,
                                        gpointer klass)
{
	self->priv = slingshot_slingshot_view_get_instance_private (self);
}

static void
slingshot_slingshot_view_finalize (GObject * obj)
{
	SlingshotSlingshotView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_TYPE_SLINGSHOT_VIEW, SlingshotSlingshotView);
	_g_object_unref0 (self->app_system);
	_g_object_unref0 (self->search_entry);
	_g_object_unref0 (self->stack);
	_g_object_unref0 (self->priv->synapse);
	_g_object_unref0 (self->priv->view_selector_revealer);
	_g_object_unref0 (self->priv->grid_view);
	_g_object_unref0 (self->priv->search_view);
	_g_object_unref0 (self->priv->category_view);
	_g_object_unref0 (self->priv->key_controller);
	_g_object_unref0 (self->priv->search_key_controller);
	G_OBJECT_CLASS (slingshot_slingshot_view_parent_class)->finalize (obj);
}

static GType
slingshot_slingshot_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotSlingshotViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_slingshot_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotSlingshotView), 0, (GInstanceInitFunc) slingshot_slingshot_view_instance_init, NULL };
	static const GInterfaceInfo slingshot_unity_client_info = { (GInterfaceInitFunc) slingshot_slingshot_view_slingshot_unity_client_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType slingshot_slingshot_view_type_id;
	slingshot_slingshot_view_type_id = g_type_register_static (gtk_bin_get_type (), "SlingshotSlingshotView", &g_define_type_info, 0);
	g_type_add_interface_static (slingshot_slingshot_view_type_id, SLINGSHOT_TYPE_UNITY_CLIENT, &slingshot_unity_client_info);
	SlingshotSlingshotView_private_offset = g_type_add_instance_private (slingshot_slingshot_view_type_id, sizeof (SlingshotSlingshotViewPrivate));
	return slingshot_slingshot_view_type_id;
}

GType
slingshot_slingshot_view_get_type (void)
{
	static volatile gsize slingshot_slingshot_view_type_id__once = 0;
	if (g_once_init_enter (&slingshot_slingshot_view_type_id__once)) {
		GType slingshot_slingshot_view_type_id;
		slingshot_slingshot_view_type_id = slingshot_slingshot_view_get_type_once ();
		g_once_init_leave (&slingshot_slingshot_view_type_id__once, slingshot_slingshot_view_type_id);
	}
	return slingshot_slingshot_view_type_id__once;
}

static void
_vala_slingshot_slingshot_view_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	SlingshotSlingshotView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_TYPE_SLINGSHOT_VIEW, SlingshotSlingshotView);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_slingshot_slingshot_view_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	SlingshotSlingshotView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_TYPE_SLINGSHOT_VIEW, SlingshotSlingshotView);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

