/* SourcePopover.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SourcePopover.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2013-2025 elementary, Inc. (https://elementary.io)
 *
 * Authored by: Corentin Noël <corentin@elementaryos.org>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <granite.h>
#include <gio/gio.h>
#include <libedataserver/libedataserver.h>
#include "elementary-calendar.h"
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CALENDAR_WIDGETS_TYPE_SOURCE_POPOVER (calendar_widgets_source_popover_get_type ())
#define CALENDAR_WIDGETS_SOURCE_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALENDAR_WIDGETS_TYPE_SOURCE_POPOVER, CalendarWidgetsSourcePopover))
#define CALENDAR_WIDGETS_SOURCE_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALENDAR_WIDGETS_TYPE_SOURCE_POPOVER, CalendarWidgetsSourcePopoverClass))
#define CALENDAR_WIDGETS_IS_SOURCE_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALENDAR_WIDGETS_TYPE_SOURCE_POPOVER))
#define CALENDAR_WIDGETS_IS_SOURCE_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALENDAR_WIDGETS_TYPE_SOURCE_POPOVER))
#define CALENDAR_WIDGETS_SOURCE_POPOVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALENDAR_WIDGETS_TYPE_SOURCE_POPOVER, CalendarWidgetsSourcePopoverClass))

typedef struct _CalendarWidgetsSourcePopover CalendarWidgetsSourcePopover;
typedef struct _CalendarWidgetsSourcePopoverClass CalendarWidgetsSourcePopoverClass;
typedef struct _CalendarWidgetsSourcePopoverPrivate CalendarWidgetsSourcePopoverPrivate;

#define CALENDAR_TYPE_SOURCE_ROW (calendar_source_row_get_type ())
#define CALENDAR_SOURCE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALENDAR_TYPE_SOURCE_ROW, CalendarSourceRow))
#define CALENDAR_SOURCE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALENDAR_TYPE_SOURCE_ROW, CalendarSourceRowClass))
#define CALENDAR_IS_SOURCE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALENDAR_TYPE_SOURCE_ROW))
#define CALENDAR_IS_SOURCE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALENDAR_TYPE_SOURCE_ROW))
#define CALENDAR_SOURCE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALENDAR_TYPE_SOURCE_ROW, CalendarSourceRowClass))

typedef struct _CalendarSourceRow CalendarSourceRow;
typedef struct _CalendarSourceRowClass CalendarSourceRowClass;

#define MAYA_VIEW_TYPE_SOURCE_DIALOG (maya_view_source_dialog_get_type ())
#define MAYA_VIEW_SOURCE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_SOURCE_DIALOG, MayaViewSourceDialog))
#define MAYA_VIEW_SOURCE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_SOURCE_DIALOG, MayaViewSourceDialogClass))
#define MAYA_VIEW_IS_SOURCE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_SOURCE_DIALOG))
#define MAYA_VIEW_IS_SOURCE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_SOURCE_DIALOG))
#define MAYA_VIEW_SOURCE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_SOURCE_DIALOG, MayaViewSourceDialogClass))

typedef struct _MayaViewSourceDialog MayaViewSourceDialog;
typedef struct _MayaViewSourceDialogClass MayaViewSourceDialogClass;
enum  {
	CALENDAR_WIDGETS_SOURCE_POPOVER_0_PROPERTY,
	CALENDAR_WIDGETS_SOURCE_POPOVER_NUM_PROPERTIES
};
static GParamSpec* calendar_widgets_source_popover_properties[CALENDAR_WIDGETS_SOURCE_POPOVER_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _CalendarWidgetsSourcePopoverPopulateData CalendarWidgetsSourcePopoverPopulateData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block32Data Block32Data;

#define MAYA_VIEW_TYPE_IMPORT_DIALOG (maya_view_import_dialog_get_type ())
#define MAYA_VIEW_IMPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_IMPORT_DIALOG, MayaViewImportDialog))
#define MAYA_VIEW_IMPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_IMPORT_DIALOG, MayaViewImportDialogClass))
#define MAYA_VIEW_IS_IMPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_IMPORT_DIALOG))
#define MAYA_VIEW_IS_IMPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_IMPORT_DIALOG))
#define MAYA_VIEW_IMPORT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_IMPORT_DIALOG, MayaViewImportDialogClass))

typedef struct _MayaViewImportDialog MayaViewImportDialog;
typedef struct _MayaViewImportDialogClass MayaViewImportDialogClass;

struct _CalendarWidgetsSourcePopover {
	GtkPopover parent_instance;
	CalendarWidgetsSourcePopoverPrivate * priv;
};

struct _CalendarWidgetsSourcePopoverClass {
	GtkPopoverClass parent_class;
};

struct _CalendarWidgetsSourcePopoverPrivate {
	GHashTable* src_map;
	MayaViewSourceDialog* src_dialog;
	GtkListBox* calendar_box;
};

struct _CalendarWidgetsSourcePopoverPopulateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	CalendarWidgetsSourcePopover* self;
	ESourceRegistry* registry;
	ESourceRegistry* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	GError* _error_;
	GError* _tmp3_;
	const gchar* _tmp4_;
	GError* _inner_error0_;
};

struct _Block32Data {
	int _ref_count_;
	CalendarWidgetsSourcePopover* self;
	GtkFileChooserNative* file_chooser;
};

static gint CalendarWidgetsSourcePopover_private_offset;
static gpointer calendar_widgets_source_popover_parent_class = NULL;

VALA_EXTERN GType calendar_widgets_source_popover_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CalendarWidgetsSourcePopover, g_object_unref)
VALA_EXTERN GType calendar_source_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CalendarSourceRow, g_object_unref)
VALA_EXTERN GType maya_view_source_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewSourceDialog, g_object_unref)
static void calendar_widgets_source_popover_populate_data_free (gpointer _data);
static void calendar_widgets_source_popover_populate (CalendarWidgetsSourcePopover* self,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static void calendar_widgets_source_popover_populate_finish (CalendarWidgetsSourcePopover* self,
                                                      GAsyncResult* _res_);
static gboolean calendar_widgets_source_popover_populate_co (CalendarWidgetsSourcePopoverPopulateData* _data_);
static void calendar_widgets_source_popover_populate_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static void calendar_widgets_source_popover_source_removed (CalendarWidgetsSourcePopover* self,
                                                     ESource* source);
static void _calendar_widgets_source_popover_source_removed_e_source_registry_source_removed (ESourceRegistry* _sender,
                                                                                       ESource* source,
                                                                                       gpointer self);
static void calendar_widgets_source_popover_source_disabled (CalendarWidgetsSourcePopover* self,
                                                      ESource* source);
static void _calendar_widgets_source_popover_source_disabled_e_source_registry_source_disabled (ESourceRegistry* _sender,
                                                                                         ESource* source,
                                                                                         gpointer self);
static void calendar_widgets_source_popover_add_source_to_view (CalendarWidgetsSourcePopover* self,
                                                         ESource* source);
static void _calendar_widgets_source_popover_add_source_to_view_e_source_registry_source_enabled (ESourceRegistry* _sender,
                                                                                           ESource* source,
                                                                                           gpointer self);
static void _calendar_widgets_source_popover_add_source_to_view_e_source_registry_source_added (ESourceRegistry* _sender,
                                                                                         ESource* source,
                                                                                         gpointer self);
static void ___lambda165_ (CalendarWidgetsSourcePopover* self,
                    ESource* source);
static void ____lambda165__gfunc (gconstpointer data,
                           gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void calendar_widgets_source_popover_header_update_func (CalendarWidgetsSourcePopover* self,
                                                         GtkListBoxRow* row,
                                                         GtkListBoxRow* before);
VALA_EXTERN const gchar* calendar_source_row_get_location (CalendarSourceRow* self);
VALA_EXTERN void calendar_source_row_source_has_changed (CalendarSourceRow* self);
VALA_EXTERN CalendarSourceRow* calendar_source_row_new (ESource* source);
VALA_EXTERN CalendarSourceRow* calendar_source_row_construct (GType object_type,
                                                  ESource* source);
static void calendar_widgets_source_popover_edit_source (CalendarWidgetsSourcePopover* self,
                                                  ESource* source);
static void _calendar_widgets_source_popover_edit_source_calendar_source_row_edit_request (CalendarSourceRow* _sender,
                                                                                    ESource* source,
                                                                                    gpointer self);
static void calendar_widgets_source_popover_remove_source (CalendarWidgetsSourcePopover* self,
                                                    ESource* source);
static void _calendar_widgets_source_popover_remove_source_calendar_source_row_remove_request (CalendarSourceRow* _sender,
                                                                                        ESource* source,
                                                                                        gpointer self);
VALA_EXTERN void calendar_source_row_show_calendar_removed (CalendarSourceRow* self);
VALA_EXTERN MayaViewSourceDialog* maya_view_source_dialog_new (void);
VALA_EXTERN MayaViewSourceDialog* maya_view_source_dialog_construct (GType object_type);
static void ___lambda164_ (CalendarWidgetsSourcePopover* self);
static void ____lambda164__maya_view_source_dialog_go_back (MayaViewSourceDialog* _sender,
                                                     gpointer self);
VALA_EXTERN void maya_view_source_dialog_set_source (MayaViewSourceDialog* self,
                                         ESource* source);
VALA_EXTERN CalendarWidgetsSourcePopover* calendar_widgets_source_popover_new (void);
VALA_EXTERN CalendarWidgetsSourcePopover* calendar_widgets_source_popover_construct (GType object_type);
static GObject * calendar_widgets_source_popover_constructor (GType type,
                                                       guint n_construct_properties,
                                                       GObjectConstructParam * construct_properties);
static void _calendar_widgets_source_popover_header_update_func_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                                          GtkListBoxRow* before,
                                                                                          gpointer self);
static gint _calendar_widgets_source_popover___lambda166_ (CalendarWidgetsSourcePopover* self,
                                                    GtkListBoxRow* child1,
                                                    GtkListBoxRow* child2);
VALA_EXTERN const gchar* calendar_source_row_get_label (CalendarSourceRow* self);
static gint __calendar_widgets_source_popover___lambda166__gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                            GtkListBoxRow* row2,
                                                                            gpointer self);
static void _g_free0_ (gpointer var);
static gboolean _calendar_widgets_source_popover___lambda167_ (CalendarWidgetsSourcePopover* self);
static gboolean __calendar_widgets_source_popover___lambda167__gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                         GdkEventButton* event,
                                                                                         gpointer self);
static gboolean _calendar_widgets_source_popover___lambda168_ (CalendarWidgetsSourcePopover* self);
static Block32Data* block32_data_ref (Block32Data* _data32_);
static void block32_data_unref (void * _userdata_);
static void __lambda169_ (Block32Data* _data32_,
                   gint response_id);
static void _vala_array_add1 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
VALA_EXTERN GType maya_view_import_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewImportDialog, g_object_unref)
VALA_EXTERN MayaViewImportDialog* maya_view_import_dialog_new (GFile** files,
                                                   gint files_length1);
VALA_EXTERN MayaViewImportDialog* maya_view_import_dialog_construct (GType object_type,
                                                         GFile** files,
                                                         gint files_length1);
static void ___lambda169__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                               gint response_id,
                                               gpointer self);
static gboolean __calendar_widgets_source_popover___lambda168__gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                         GdkEventButton* event,
                                                                                         gpointer self);
static void _calendar_widgets_source_popover___lambda171_ (CalendarWidgetsSourcePopover* self);
static void __calendar_widgets_source_popover___lambda171__gtk_button_clicked (GtkButton* _sender,
                                                                        gpointer self);
static void calendar_widgets_source_popover_finalize (GObject * obj);
static GType calendar_widgets_source_popover_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
calendar_widgets_source_popover_get_instance_private (CalendarWidgetsSourcePopover* self)
{
	return G_STRUCT_MEMBER_P (self, CalendarWidgetsSourcePopover_private_offset);
}

static void
calendar_widgets_source_popover_populate_data_free (gpointer _data)
{
	CalendarWidgetsSourcePopoverPopulateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (CalendarWidgetsSourcePopoverPopulateData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
calendar_widgets_source_popover_populate (CalendarWidgetsSourcePopover* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	CalendarWidgetsSourcePopoverPopulateData* _data_;
	CalendarWidgetsSourcePopover* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (CalendarWidgetsSourcePopoverPopulateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, calendar_widgets_source_popover_populate_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	calendar_widgets_source_popover_populate_co (_data_);
}

static void
calendar_widgets_source_popover_populate_finish (CalendarWidgetsSourcePopover* self,
                                                 GAsyncResult* _res_)
{
	CalendarWidgetsSourcePopoverPopulateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
calendar_widgets_source_popover_populate_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	CalendarWidgetsSourcePopoverPopulateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	calendar_widgets_source_popover_populate_co (_data_);
}

static void
_calendar_widgets_source_popover_source_removed_e_source_registry_source_removed (ESourceRegistry* _sender,
                                                                                  ESource* source,
                                                                                  gpointer self)
{
	calendar_widgets_source_popover_source_removed ((CalendarWidgetsSourcePopover*) self, source);
}

static void
_calendar_widgets_source_popover_source_disabled_e_source_registry_source_disabled (ESourceRegistry* _sender,
                                                                                    ESource* source,
                                                                                    gpointer self)
{
	calendar_widgets_source_popover_source_disabled ((CalendarWidgetsSourcePopover*) self, source);
}

static void
_calendar_widgets_source_popover_add_source_to_view_e_source_registry_source_enabled (ESourceRegistry* _sender,
                                                                                      ESource* source,
                                                                                      gpointer self)
{
	calendar_widgets_source_popover_add_source_to_view ((CalendarWidgetsSourcePopover*) self, source);
}

static void
_calendar_widgets_source_popover_add_source_to_view_e_source_registry_source_added (ESourceRegistry* _sender,
                                                                                    ESource* source,
                                                                                    gpointer self)
{
	calendar_widgets_source_popover_add_source_to_view ((CalendarWidgetsSourcePopover*) self, source);
}

static void
___lambda165_ (CalendarWidgetsSourcePopover* self,
               ESource* source)
{
	g_return_if_fail (source != NULL);
	calendar_widgets_source_popover_add_source_to_view (self, source);
}

static void
____lambda165__gfunc (gconstpointer data,
                      gpointer self)
{
	___lambda165_ ((CalendarWidgetsSourcePopover*) self, (ESource*) data);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
calendar_widgets_source_popover_populate_co (CalendarWidgetsSourcePopoverPopulateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		e_source_registry_new (NULL, calendar_widgets_source_popover_populate_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = e_source_registry_new_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->registry = _data_->_tmp0_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_signal_connect_object (_data_->registry, "source-removed", (GCallback) _calendar_widgets_source_popover_source_removed_e_source_registry_source_removed, _data_->self, 0);
		g_signal_connect_object (_data_->registry, "source-disabled", (GCallback) _calendar_widgets_source_popover_source_disabled_e_source_registry_source_disabled, _data_->self, 0);
		g_signal_connect_object (_data_->registry, "source-enabled", (GCallback) _calendar_widgets_source_popover_add_source_to_view_e_source_registry_source_enabled, _data_->self, 0);
		g_signal_connect_object (_data_->registry, "source-added", (GCallback) _calendar_widgets_source_popover_add_source_to_view_e_source_registry_source_added, _data_->self, 0);
		_data_->_tmp1_ = e_source_registry_list_sources (_data_->registry, E_SOURCE_EXTENSION_CALENDAR);
		_data_->_tmp2_ = _data_->_tmp1_;
		g_list_foreach (_data_->_tmp2_, ____lambda165__gfunc, _data_->self);
		(_data_->_tmp2_ == NULL) ? NULL : (_data_->_tmp2_ = (_g_list_free__g_object_unref0_ (_data_->_tmp2_), NULL));
		_g_object_unref0 (_data_->registry);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = _data_->_error_;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		g_critical ("SourcePopover.vala:133: %s", _data_->_tmp4_);
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
calendar_widgets_source_popover_header_update_func (CalendarWidgetsSourcePopover* self,
                                                    GtkListBoxRow* row,
                                                    GtkListBoxRow* before)
{
	gchar* row_location = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GraniteHeaderLabel* header = NULL;
	const gchar* _tmp8_;
	GraniteHeaderLabel* _tmp9_;
	GraniteHeaderLabel* _tmp10_;
	GraniteHeaderLabel* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = calendar_source_row_get_location (G_TYPE_CHECK_INSTANCE_CAST (row, CALENDAR_TYPE_SOURCE_ROW, CalendarSourceRow));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	row_location = _tmp2_;
	if (before != NULL) {
		gchar* before_row_location = NULL;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp3_ = calendar_source_row_get_location (G_TYPE_CHECK_INSTANCE_CAST (before, CALENDAR_TYPE_SOURCE_ROW, CalendarSourceRow));
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup (_tmp4_);
		before_row_location = _tmp5_;
		_tmp6_ = before_row_location;
		_tmp7_ = row_location;
		if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
			gtk_list_box_row_set_header (row, NULL);
			_g_free0 (before_row_location);
			_g_free0 (row_location);
			return;
		}
		_g_free0 (before_row_location);
	}
	_tmp8_ = row_location;
	_tmp9_ = granite_header_label_new (_tmp8_);
	g_object_ref_sink (_tmp9_);
	header = _tmp9_;
	_tmp10_ = header;
	gtk_list_box_row_set_header (row, (GtkWidget*) _tmp10_);
	_tmp11_ = header;
	gtk_widget_show_all ((GtkWidget*) _tmp11_);
	_g_object_unref0 (header);
	_g_free0 (row_location);
}

static void
calendar_widgets_source_popover_source_removed (CalendarWidgetsSourcePopover* self,
                                                ESource* source)
{
	CalendarSourceRow* source_item = NULL;
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gconstpointer _tmp3_;
	CalendarSourceRow* _tmp4_;
	CalendarSourceRow* _tmp5_;
	GHashTable* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->src_map;
	_tmp1_ = e_source_dup_uid (source);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_hash_table_lookup (_tmp0_, _tmp2_);
	_tmp4_ = _g_object_ref0 ((CalendarSourceRow*) _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	source_item = _tmp5_;
	gtk_widget_hide ((GtkWidget*) source_item);
	_tmp6_ = self->priv->src_map;
	_tmp7_ = e_source_dup_uid (source);
	_tmp8_ = _tmp7_;
	g_hash_table_remove (_tmp6_, _tmp8_);
	_g_free0 (_tmp8_);
	gtk_widget_destroy ((GtkWidget*) source_item);
	_g_object_unref0 (source_item);
}

static void
calendar_widgets_source_popover_source_disabled (CalendarWidgetsSourcePopover* self,
                                                 ESource* source)
{
	CalendarSourceRow* source_item = NULL;
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gconstpointer _tmp3_;
	CalendarSourceRow* _tmp4_;
	CalendarSourceRow* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->src_map;
	_tmp1_ = e_source_dup_uid (source);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_hash_table_lookup (_tmp0_, _tmp2_);
	_tmp4_ = _g_object_ref0 ((CalendarSourceRow*) _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	source_item = _tmp5_;
	calendar_source_row_source_has_changed (source_item);
	_g_object_unref0 (source_item);
}

static void
_calendar_widgets_source_popover_edit_source_calendar_source_row_edit_request (CalendarSourceRow* _sender,
                                                                               ESource* source,
                                                                               gpointer self)
{
	calendar_widgets_source_popover_edit_source ((CalendarWidgetsSourcePopover*) self, source);
}

static void
_calendar_widgets_source_popover_remove_source_calendar_source_row_remove_request (CalendarSourceRow* _sender,
                                                                                   ESource* source,
                                                                                   gpointer self)
{
	calendar_widgets_source_popover_remove_source ((CalendarWidgetsSourcePopover*) self, source);
}

static void
calendar_widgets_source_popover_add_source_to_view (CalendarWidgetsSourcePopover* self,
                                                    ESource* source)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GHashTable* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	CalendarSourceRow* source_item = NULL;
	CalendarSourceRow* _tmp6_;
	CalendarSourceRow* _tmp7_;
	CalendarSourceRow* _tmp8_;
	GtkListBox* _tmp9_;
	CalendarSourceRow* _tmp10_;
	GtkListBox* _tmp11_;
	GHashTable* _tmp12_;
	gchar* _tmp13_;
	CalendarSourceRow* _tmp14_;
	CalendarSourceRow* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = e_source_get_enabled (source);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == FALSE) {
		return;
	}
	_tmp2_ = self->priv->src_map;
	_tmp3_ = e_source_dup_uid (source);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_hash_table_contains (_tmp2_, _tmp4_);
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		return;
	}
	_tmp6_ = calendar_source_row_new (source);
	g_object_ref_sink (_tmp6_);
	source_item = _tmp6_;
	_tmp7_ = source_item;
	g_signal_connect_object (_tmp7_, "edit-request", (GCallback) _calendar_widgets_source_popover_edit_source_calendar_source_row_edit_request, self, 0);
	_tmp8_ = source_item;
	g_signal_connect_object (_tmp8_, "remove-request", (GCallback) _calendar_widgets_source_popover_remove_source_calendar_source_row_remove_request, self, 0);
	_tmp9_ = self->priv->calendar_box;
	_tmp10_ = source_item;
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->calendar_box;
	gtk_widget_show_all ((GtkWidget*) _tmp11_);
	_tmp12_ = self->priv->src_map;
	_tmp13_ = e_source_dup_uid (source);
	_tmp14_ = source_item;
	_tmp15_ = _g_object_ref0 (_tmp14_);
	g_hash_table_insert (_tmp12_, _tmp13_, _tmp15_);
	_g_object_unref0 (source_item);
}

static void
calendar_widgets_source_popover_remove_source (CalendarWidgetsSourcePopover* self,
                                               ESource* source)
{
	CalendarEventStore* _tmp0_;
	CalendarEventStore* _tmp1_;
	CalendarSourceRow* source_item = NULL;
	GHashTable* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gconstpointer _tmp5_;
	CalendarSourceRow* _tmp6_;
	CalendarSourceRow* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = calendar_event_store_get_default ();
	_tmp1_ = _tmp0_;
	calendar_event_store_trash_calendar (_tmp1_, source);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->src_map;
	_tmp3_ = e_source_dup_uid (source);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_hash_table_lookup (_tmp2_, _tmp4_);
	_tmp6_ = _g_object_ref0 ((CalendarSourceRow*) _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp4_);
	source_item = _tmp7_;
	calendar_source_row_show_calendar_removed (source_item);
	_g_object_unref0 (source_item);
}

static void
___lambda164_ (CalendarWidgetsSourcePopover* self)
{
	MayaViewSourceDialog* _tmp0_;
	_tmp0_ = self->priv->src_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}

static void
____lambda164__maya_view_source_dialog_go_back (MayaViewSourceDialog* _sender,
                                                gpointer self)
{
	___lambda164_ ((CalendarWidgetsSourcePopover*) self);
}

static void
calendar_widgets_source_popover_edit_source (CalendarWidgetsSourcePopover* self,
                                             ESource* source)
{
	MayaViewSourceDialog* _tmp0_;
	MayaViewSourceDialog* _tmp7_;
	MayaViewSourceDialog* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->src_dialog;
	if (_tmp0_ == NULL) {
		GApplication* _tmp1_;
		GtkWindow* _tmp2_;
		GtkWindow* _tmp3_;
		GtkWindow* _tmp4_;
		MayaViewSourceDialog* _tmp5_ = NULL;
		MayaViewSourceDialog* _tmp6_;
		_tmp1_ = g_application_get_default ();
		_tmp2_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_application_get_type (), GtkApplication));
		_tmp3_ = _tmp2_;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_tmp5_ = maya_view_source_dialog_new ();
		gtk_window_set_modal ((GtkWindow*) _tmp5_, TRUE);
		gtk_window_set_transient_for ((GtkWindow*) _tmp5_, _tmp4_);
		_g_object_unref0 (_tmp4_);
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (self->priv->src_dialog);
		self->priv->src_dialog = _tmp5_;
		_tmp6_ = self->priv->src_dialog;
		g_signal_connect_object (_tmp6_, "go-back", (GCallback) ____lambda164__maya_view_source_dialog_go_back, self, 0);
	}
	gtk_popover_popdown ((GtkPopover*) self);
	_tmp7_ = self->priv->src_dialog;
	maya_view_source_dialog_set_source (_tmp7_, source);
	_tmp8_ = self->priv->src_dialog;
	gtk_window_present ((GtkWindow*) _tmp8_);
}

CalendarWidgetsSourcePopover*
calendar_widgets_source_popover_construct (GType object_type)
{
	CalendarWidgetsSourcePopover * self = NULL;
	self = (CalendarWidgetsSourcePopover*) g_object_new (object_type, NULL);
	return self;
}

CalendarWidgetsSourcePopover*
calendar_widgets_source_popover_new (void)
{
	return calendar_widgets_source_popover_construct (CALENDAR_WIDGETS_TYPE_SOURCE_POPOVER);
}

static void
_calendar_widgets_source_popover_header_update_func_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                                     GtkListBoxRow* before,
                                                                                     gpointer self)
{
	calendar_widgets_source_popover_header_update_func ((CalendarWidgetsSourcePopover*) self, row, before);
}

static gint
_calendar_widgets_source_popover___lambda166_ (CalendarWidgetsSourcePopover* self,
                                               GtkListBoxRow* child1,
                                               GtkListBoxRow* child2)
{
	gint comparison = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint result;
	g_return_val_if_fail (child1 != NULL, 0);
	g_return_val_if_fail (child2 != NULL, 0);
	_tmp0_ = calendar_source_row_get_location (G_TYPE_CHECK_INSTANCE_CAST (child1, CALENDAR_TYPE_SOURCE_ROW, CalendarSourceRow));
	_tmp1_ = _tmp0_;
	_tmp2_ = calendar_source_row_get_location (G_TYPE_CHECK_INSTANCE_CAST (child2, CALENDAR_TYPE_SOURCE_ROW, CalendarSourceRow));
	_tmp3_ = _tmp2_;
	comparison = g_utf8_collate (_tmp1_, _tmp3_);
	if (comparison == 0) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp4_ = calendar_source_row_get_label (G_TYPE_CHECK_INSTANCE_CAST (child1, CALENDAR_TYPE_SOURCE_ROW, CalendarSourceRow));
		_tmp5_ = _tmp4_;
		_tmp6_ = calendar_source_row_get_label (G_TYPE_CHECK_INSTANCE_CAST (child2, CALENDAR_TYPE_SOURCE_ROW, CalendarSourceRow));
		_tmp7_ = _tmp6_;
		result = g_utf8_collate (_tmp5_, _tmp7_);
		return result;
	} else {
		result = comparison;
		return result;
	}
}

static gint
__calendar_widgets_source_popover___lambda166__gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                       GtkListBoxRow* row2,
                                                                       gpointer self)
{
	gint result;
	result = _calendar_widgets_source_popover___lambda166_ ((CalendarWidgetsSourcePopover*) self, row1, row2);
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static gboolean
_calendar_widgets_source_popover___lambda167_ (CalendarWidgetsSourcePopover* self)
{
	gboolean result;
	calendar_widgets_source_popover_edit_source (self, NULL);
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
__calendar_widgets_source_popover___lambda167__gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                GdkEventButton* event,
                                                                                gpointer self)
{
	gboolean result;
	result = _calendar_widgets_source_popover___lambda167_ ((CalendarWidgetsSourcePopover*) self);
	return result;
}

static Block32Data*
block32_data_ref (Block32Data* _data32_)
{
	g_atomic_int_inc (&_data32_->_ref_count_);
	return _data32_;
}

static void
block32_data_unref (void * _userdata_)
{
	Block32Data* _data32_;
	_data32_ = (Block32Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data32_->_ref_count_)) {
		CalendarWidgetsSourcePopover* self;
		self = _data32_->self;
		_g_object_unref0 (_data32_->file_chooser);
		_g_object_unref0 (self);
		g_slice_free (Block32Data, _data32_);
	}
}

static void
_vala_array_add1 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
__lambda169_ (Block32Data* _data32_,
              gint response_id)
{
	CalendarWidgetsSourcePopover* self;
	GFile** files = NULL;
	gint files_length1;
	gint _files_size_;
	GFile** _tmp4_;
	gint _tmp4__length1;
	self = _data32_->self;
	files = NULL;
	files_length1 = 0;
	_files_size_ = files_length1;
	if (response_id == ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserNative* _tmp0_;
		GSList* _tmp1_;
		_tmp0_ = _data32_->file_chooser;
		_tmp1_ = gtk_file_chooser_get_files ((GtkFileChooser*) _tmp0_);
		{
			GSList* selected_file_collection = NULL;
			GSList* selected_file_it = NULL;
			selected_file_collection = _tmp1_;
			for (selected_file_it = selected_file_collection; selected_file_it != NULL; selected_file_it = selected_file_it->next) {
				GFile* selected_file = NULL;
				selected_file = (GFile*) selected_file_it->data;
				{
					GFile* _tmp2_;
					GFile* _tmp3_;
					_tmp2_ = selected_file;
					_tmp3_ = _g_object_ref0 (_tmp2_);
					_vala_array_add1 (&files, &files_length1, &_files_size_, _tmp3_);
				}
			}
			(selected_file_collection == NULL) ? NULL : (selected_file_collection = (_g_slist_free__g_object_unref0_ (selected_file_collection), NULL));
		}
	}
	_tmp4_ = files;
	_tmp4__length1 = files_length1;
	if (_tmp4_ != NULL) {
		MayaViewImportDialog* dialog = NULL;
		GFile** _tmp5_;
		gint _tmp5__length1;
		MayaViewImportDialog* _tmp6_;
		MayaViewImportDialog* _tmp7_;
		_tmp5_ = files;
		_tmp5__length1 = files_length1;
		_tmp6_ = maya_view_import_dialog_new (_tmp5_, _tmp5__length1);
		g_object_ref_sink (_tmp6_);
		dialog = _tmp6_;
		_tmp7_ = dialog;
		gtk_widget_show_all ((GtkWidget*) _tmp7_);
		_g_object_unref0 (dialog);
	}
	files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
}

static void
___lambda169__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                          gint response_id,
                                          gpointer self)
{
	__lambda169_ (self, response_id);
}

static gboolean
_calendar_widgets_source_popover___lambda168_ (CalendarWidgetsSourcePopover* self)
{
	Block32Data* _data32_;
	GtkFileFilter* ics_filter = NULL;
	GtkFileFilter* _tmp0_;
	GtkFileFilter* _tmp1_;
	GtkFileChooserNative* _tmp2_;
	GtkFileChooserNative* _tmp3_;
	GtkFileChooserNative* _tmp4_;
	GtkFileChooserNative* _tmp5_;
	GtkFileFilter* _tmp6_;
	GtkFileChooserNative* _tmp7_;
	GtkFileChooserNative* _tmp8_;
	gboolean result;
	_data32_ = g_slice_new0 (Block32Data);
	_data32_->_ref_count_ = 1;
	_data32_->self = g_object_ref (self);
	_tmp0_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp0_);
	ics_filter = _tmp0_;
	_tmp1_ = ics_filter;
	gtk_file_filter_add_mime_type (_tmp1_, "application/ics");
	_tmp2_ = gtk_file_chooser_native_new (_ ("Select ICS File to Import"), NULL, GTK_FILE_CHOOSER_ACTION_OPEN, _ ("Open"), _ ("Cancel"));
	_data32_->file_chooser = _tmp2_;
	_tmp3_ = _data32_->file_chooser;
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp3_, TRUE);
	_tmp4_ = _data32_->file_chooser;
	gtk_file_chooser_set_select_multiple ((GtkFileChooser*) _tmp4_, TRUE);
	_tmp5_ = _data32_->file_chooser;
	_tmp6_ = ics_filter;
	gtk_file_chooser_set_filter ((GtkFileChooser*) _tmp5_, _tmp6_);
	_tmp7_ = _data32_->file_chooser;
	gtk_native_dialog_show ((GtkNativeDialog*) _tmp7_);
	gtk_popover_popdown ((GtkPopover*) self);
	_tmp8_ = _data32_->file_chooser;
	g_signal_connect_data ((GtkNativeDialog*) _tmp8_, "response", (GCallback) ___lambda169__gtk_native_dialog_response, block32_data_ref (_data32_), (GClosureNotify) block32_data_unref, 0);
	result = GDK_EVENT_STOP;
	_g_object_unref0 (ics_filter);
	block32_data_unref (_data32_);
	_data32_ = NULL;
	return result;
}

static gboolean
__calendar_widgets_source_popover___lambda168__gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                GdkEventButton* event,
                                                                                gpointer self)
{
	gboolean result;
	result = _calendar_widgets_source_popover___lambda168_ ((CalendarWidgetsSourcePopover*) self);
	return result;
}

static void
_calendar_widgets_source_popover___lambda171_ (CalendarWidgetsSourcePopover* self)
{
	GError* _inner_error0_ = NULL;
	{
		g_app_info_launch_default_for_uri ("settings://accounts/online", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("SourcePopover.vala:115: Failed to open account settings: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__calendar_widgets_source_popover___lambda171__gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self)
{
	_calendar_widgets_source_popover___lambda171_ ((CalendarWidgetsSourcePopover*) self);
}

static GObject *
calendar_widgets_source_popover_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	CalendarWidgetsSourcePopover * self;
	GtkListBox* _tmp0_ = NULL;
	GtkListBox* _tmp1_;
	GtkListBox* _tmp2_;
	GtkScrolledWindow* scroll = NULL;
	GtkListBox* _tmp3_;
	GtkWidget* _tmp4_;
	GtkScrolledWindow* _tmp5_ = NULL;
	GHashFunc _tmp6_;
	GEqualFunc _tmp7_;
	GHashTable* _tmp8_;
	GtkSeparator* separator = NULL;
	GtkSeparator* _tmp9_ = NULL;
	GtkModelButton* add_calendar_button = NULL;
	gchar* _tmp10_;
	GtkModelButton* _tmp11_ = NULL;
	GtkModelButton* import_calendar_button = NULL;
	gchar* _tmp12_;
	GtkModelButton* _tmp13_ = NULL;
	GtkModelButton* accounts_button = NULL;
	gchar* _tmp14_;
	GtkModelButton* _tmp15_ = NULL;
	GtkBox* main_box = NULL;
	GtkBox* _tmp16_ = NULL;
	GtkBox* _tmp17_;
	GtkScrolledWindow* _tmp18_;
	GtkBox* _tmp19_;
	GtkSeparator* _tmp20_;
	GtkBox* _tmp21_;
	GtkModelButton* _tmp22_;
	GtkBox* _tmp23_;
	GtkModelButton* _tmp24_;
	GtkBox* _tmp25_;
	GtkModelButton* _tmp26_;
	GtkBox* _tmp27_;
	GtkBox* _tmp28_;
	GtkModelButton* _tmp29_;
	GtkModelButton* _tmp30_;
	GtkModelButton* _tmp31_;
	parent_class = G_OBJECT_CLASS (calendar_widgets_source_popover_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALENDAR_WIDGETS_TYPE_SOURCE_POPOVER, CalendarWidgetsSourcePopover);
	_tmp0_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_selection_mode (_tmp0_, GTK_SELECTION_BROWSE);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->calendar_box);
	self->priv->calendar_box = _tmp0_;
	_tmp1_ = self->priv->calendar_box;
	gtk_list_box_set_header_func (_tmp1_, _calendar_widgets_source_popover_header_update_func_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_tmp2_ = self->priv->calendar_box;
	gtk_list_box_set_sort_func (_tmp2_, __calendar_widgets_source_popover___lambda166__gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp3_ = self->priv->calendar_box;
	_tmp4_ = _g_object_ref0 ((GtkWidget*) _tmp3_);
	_tmp5_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_set ((GtkContainer*) _tmp5_, "child", _tmp4_, NULL);
	_g_object_unref0 (_tmp4_);
	g_object_set (_tmp5_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	gtk_scrolled_window_set_max_content_height (_tmp5_, 300);
	gtk_scrolled_window_set_propagate_natural_height (_tmp5_, TRUE);
	g_object_ref_sink (_tmp5_);
	scroll = _tmp5_;
	_tmp6_ = g_str_hash;
	_tmp7_ = g_str_equal;
	_tmp8_ = g_hash_table_new_full (_tmp6_, _tmp7_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->src_map);
	self->priv->src_map = _tmp8_;
	_tmp9_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp9_, 3);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp9_, 3);
	g_object_ref_sink (_tmp9_);
	separator = _tmp9_;
	_tmp10_ = g_strdup (_ ("Add New Calendar…"));
	_tmp11_ = (GtkModelButton*) gtk_model_button_new ();
	g_object_set (_tmp11_, "text", _tmp10_, NULL);
	_g_free0 (_tmp10_);
	g_object_ref_sink (_tmp11_);
	add_calendar_button = _tmp11_;
	_tmp12_ = g_strdup (_ ("Import iCalendar File…"));
	_tmp13_ = (GtkModelButton*) gtk_model_button_new ();
	g_object_set (_tmp13_, "text", _tmp12_, NULL);
	_g_free0 (_tmp12_);
	g_object_ref_sink (_tmp13_);
	import_calendar_button = _tmp13_;
	_tmp14_ = g_strdup (_ ("Online Accounts Settings…"));
	_tmp15_ = (GtkModelButton*) gtk_model_button_new ();
	g_object_set (_tmp15_, "text", _tmp14_, NULL);
	_g_free0 (_tmp14_);
	g_object_ref_sink (_tmp15_);
	accounts_button = _tmp15_;
	_tmp16_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp16_, 3);
	g_object_ref_sink (_tmp16_);
	main_box = _tmp16_;
	_tmp17_ = main_box;
	_tmp18_ = scroll;
	gtk_container_add ((GtkContainer*) _tmp17_, (GtkWidget*) _tmp18_);
	_tmp19_ = main_box;
	_tmp20_ = separator;
	gtk_container_add ((GtkContainer*) _tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = main_box;
	_tmp22_ = add_calendar_button;
	gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = main_box;
	_tmp24_ = import_calendar_button;
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = main_box;
	_tmp26_ = accounts_button;
	gtk_container_add ((GtkContainer*) _tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = main_box;
	gtk_widget_show_all ((GtkWidget*) _tmp27_);
	_tmp28_ = main_box;
	g_object_set ((GtkContainer*) self, "child", (GtkWidget*) _tmp28_, NULL);
	calendar_widgets_source_popover_populate (self, NULL, NULL);
	_tmp29_ = add_calendar_button;
	g_signal_connect_object ((GtkWidget*) _tmp29_, "button-release-event", (GCallback) __calendar_widgets_source_popover___lambda167__gtk_widget_button_release_event, self, 0);
	_tmp30_ = import_calendar_button;
	g_signal_connect_object ((GtkWidget*) _tmp30_, "button-release-event", (GCallback) __calendar_widgets_source_popover___lambda168__gtk_widget_button_release_event, self, 0);
	_tmp31_ = accounts_button;
	g_signal_connect_object ((GtkButton*) _tmp31_, "clicked", (GCallback) __calendar_widgets_source_popover___lambda171__gtk_button_clicked, self, 0);
	_g_object_unref0 (main_box);
	_g_object_unref0 (accounts_button);
	_g_object_unref0 (import_calendar_button);
	_g_object_unref0 (add_calendar_button);
	_g_object_unref0 (separator);
	_g_object_unref0 (scroll);
	return obj;
}

static void
calendar_widgets_source_popover_class_init (CalendarWidgetsSourcePopoverClass * klass,
                                            gpointer klass_data)
{
	calendar_widgets_source_popover_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CalendarWidgetsSourcePopover_private_offset);
	G_OBJECT_CLASS (klass)->constructor = calendar_widgets_source_popover_constructor;
	G_OBJECT_CLASS (klass)->finalize = calendar_widgets_source_popover_finalize;
}

static void
calendar_widgets_source_popover_instance_init (CalendarWidgetsSourcePopover * self,
                                               gpointer klass)
{
	self->priv = calendar_widgets_source_popover_get_instance_private (self);
	self->priv->src_dialog = NULL;
}

static void
calendar_widgets_source_popover_finalize (GObject * obj)
{
	CalendarWidgetsSourcePopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALENDAR_WIDGETS_TYPE_SOURCE_POPOVER, CalendarWidgetsSourcePopover);
	_g_hash_table_unref0 (self->priv->src_map);
	_g_object_unref0 (self->priv->src_dialog);
	_g_object_unref0 (self->priv->calendar_box);
	G_OBJECT_CLASS (calendar_widgets_source_popover_parent_class)->finalize (obj);
}

static GType
calendar_widgets_source_popover_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CalendarWidgetsSourcePopoverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) calendar_widgets_source_popover_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CalendarWidgetsSourcePopover), 0, (GInstanceInitFunc) calendar_widgets_source_popover_instance_init, NULL };
	GType calendar_widgets_source_popover_type_id;
	calendar_widgets_source_popover_type_id = g_type_register_static (gtk_popover_get_type (), "CalendarWidgetsSourcePopover", &g_define_type_info, 0);
	CalendarWidgetsSourcePopover_private_offset = g_type_add_instance_private (calendar_widgets_source_popover_type_id, sizeof (CalendarWidgetsSourcePopoverPrivate));
	return calendar_widgets_source_popover_type_id;
}

GType
calendar_widgets_source_popover_get_type (void)
{
	static volatile gsize calendar_widgets_source_popover_type_id__once = 0;
	if (g_once_init_enter (&calendar_widgets_source_popover_type_id__once)) {
		GType calendar_widgets_source_popover_type_id;
		calendar_widgets_source_popover_type_id = calendar_widgets_source_popover_get_type_once ();
		g_once_init_leave (&calendar_widgets_source_popover_type_id__once, calendar_widgets_source_popover_type_id);
	}
	return calendar_widgets_source_popover_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

