/* Renamer.c generated by valac 0.56.18, the Vala compiler
 * generated from Renamer.vala, do not modify */

/*
 * Copyright (C) 2010-2017  Vartan Belavejian
 * Copyright (C) 2019-2022  elementary LLC. <https://elementary.io>
 *
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  Authors:
 *  Vartan Belavejian <https://github.com/VartanBelavejian>
 *  Jeremy Wootten <jeremywootten@gmail.com>
 *
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gtk/gtk.h>
#include "pantheon-files-core.h"
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FILES_TYPE_RENAMER (files_renamer_get_type ())
#define FILES_RENAMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_RENAMER, FilesRenamer))
#define FILES_RENAMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_RENAMER, FilesRenamerClass))
#define FILES_IS_RENAMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_RENAMER))
#define FILES_IS_RENAMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_RENAMER))
#define FILES_RENAMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_RENAMER, FilesRenamerClass))

typedef struct _FilesRenamer FilesRenamer;
typedef struct _FilesRenamerClass FilesRenamerClass;
typedef struct _FilesRenamerPrivate FilesRenamerPrivate;

#define FILES_TYPE_RENAMER_MODIFIER (files_renamer_modifier_get_type ())
#define FILES_RENAMER_MODIFIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_RENAMER_MODIFIER, FilesRenamerModifier))
#define FILES_RENAMER_MODIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_RENAMER_MODIFIER, FilesRenamerModifierClass))
#define FILES_IS_RENAMER_MODIFIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_RENAMER_MODIFIER))
#define FILES_IS_RENAMER_MODIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_RENAMER_MODIFIER))
#define FILES_RENAMER_MODIFIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_RENAMER_MODIFIER, FilesRenamerModifierClass))

typedef struct _FilesRenamerModifier FilesRenamerModifier;
typedef struct _FilesRenamerModifierClass FilesRenamerModifierClass;
enum  {
	FILES_RENAMER_0_PROPERTY,
	FILES_RENAMER_CAN_RENAME_PROPERTY,
	FILES_RENAMER_DIRECTORY_PROPERTY,
	FILES_RENAMER_MODIFIER_CHAIN_PROPERTY,
	FILES_RENAMER_LISTBOX_PROPERTY,
	FILES_RENAMER_SORTBY_PROPERTY,
	FILES_RENAMER_NUM_PROPERTIES
};
static GParamSpec* files_renamer_properties[FILES_RENAMER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FILES_TYPE_RENAMER_LIST_ROW (files_renamer_list_row_get_type ())
#define FILES_RENAMER_LIST_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_RENAMER_LIST_ROW, FilesRenamerListRow))
#define FILES_RENAMER_LIST_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_RENAMER_LIST_ROW, FilesRenamerListRowClass))
#define FILES_IS_RENAMER_LIST_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_RENAMER_LIST_ROW))
#define FILES_IS_RENAMER_LIST_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_RENAMER_LIST_ROW))
#define FILES_RENAMER_LIST_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_RENAMER_LIST_ROW, FilesRenamerListRowClass))

typedef struct _FilesRenamerListRow FilesRenamerListRow;
typedef struct _FilesRenamerListRowClass FilesRenamerListRowClass;
typedef struct _Block10Data Block10Data;
typedef struct _Block11Data Block11Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block12Data Block12Data;

struct _FilesRenamer {
	GObject parent_instance;
	FilesRenamerPrivate * priv;
};

struct _FilesRenamerClass {
	GObjectClass parent_class;
};

struct _FilesRenamerPrivate {
	gboolean _can_rename;
	gchar* _directory;
	GeeArrayList* _modifier_chain;
	GtkListBox* _listbox;
	FilesSortBy _sortby;
	guint update_timeout_id;
	gboolean updating;
};

struct _Block10Data {
	int _ref_count_;
	FilesRenamer* self;
	gchar* custom_basename;
	gchar* replacement_text;
};

struct _Block11Data {
	int _ref_count_;
	FilesRenamer* self;
	gchar* previous_final_name;
	gboolean has_invalid;
	gchar* custom_basename;
	gchar* replacement_text;
};

struct _Block12Data {
	int _ref_count_;
	Block11Data * _data11_;
	FilesRenamerModifier* mod;
	guint index;
	gint incr;
};

static gint FilesRenamer_private_offset;
static gpointer files_renamer_parent_class = NULL;

VALA_EXTERN GType files_renamer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesRenamer, g_object_unref)
VALA_EXTERN GType files_renamer_modifier_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesRenamerModifier, g_object_unref)
VALA_EXTERN void files_renamer_add_files (FilesRenamer* self,
                              GList* files);
VALA_EXTERN const gchar* files_renamer_get_directory (FilesRenamer* self);
static void files_renamer_set_directory (FilesRenamer* self,
                                  const gchar* value);
VALA_EXTERN GType files_renamer_list_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesRenamerListRow, g_object_unref)
VALA_EXTERN FilesRenamerListRow* files_renamer_list_row_new (FilesFile* file);
VALA_EXTERN FilesRenamerListRow* files_renamer_list_row_construct (GType object_type,
                                                       FilesFile* file);
VALA_EXTERN GtkListBox* files_renamer_get_listbox (FilesRenamer* self);
VALA_EXTERN void files_renamer_list_row_set_new_name (FilesRenamerListRow* self,
                                          const gchar* value);
VALA_EXTERN void files_renamer_rename_files (FilesRenamer* self);
static void __lambda90_ (FilesRenamer* self,
                  GtkWidget* child);
VALA_EXTERN const gchar* files_renamer_list_row_get_new_name (FilesRenamerListRow* self);
VALA_EXTERN FilesFile* files_renamer_list_row_get_file (FilesRenamerListRow* self);
static void ___lambda91_ (FilesRenamer* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda91__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void ___lambda90__gfunc (gconstpointer data,
                         gpointer self);
static gchar* files_renamer_strip_extension (FilesRenamer* self,
                                      const gchar* filename,
                                      gchar** extension);
static gboolean files_renamer_invalid_name (FilesRenamer* self,
                                     const gchar* new_name,
                                     FilesFile* old_file);
VALA_EXTERN void files_renamer_schedule_update (FilesRenamer* self,
                                    const gchar* custom_basename,
                                    const gchar* replacement_text);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static gboolean __lambda92_ (Block10Data* _data10_);
static void files_renamer_update_new_filenames (FilesRenamer* self,
                                         const gchar* custom_basename,
                                         const gchar* replacement_text);
static gboolean ___lambda92__gsource_func (gpointer self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static void __lambda93_ (Block11Data* _data11_,
                  GtkWidget* child);
VALA_EXTERN const gchar* files_renamer_list_row_get_old_name (FilesRenamerListRow* self);
VALA_EXTERN void files_renamer_list_row_set_extension (FilesRenamerListRow* self,
                                           const gchar* value);
static void ___lambda93__gfunc (gconstpointer data,
                         gpointer self);
VALA_EXTERN GeeArrayList* files_renamer_get_modifier_chain (FilesRenamer* self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
VALA_EXTERN gboolean files_renamer_modifier_get_is_reversed (FilesRenamerModifier* self);
static void ____lambda94_ (Block12Data* _data12_,
                    GtkWidget* child);
VALA_EXTERN gchar* files_renamer_modifier_rename (FilesRenamerModifier* self,
                                      const gchar* input,
                                      guint index,
                                      FilesFile* file);
static void _____lambda94__gfunc (gconstpointer data,
                           gpointer self);
static void __lambda95_ (Block11Data* _data11_,
                  GtkWidget* child);
VALA_EXTERN const gchar* files_renamer_list_row_get_extension (FilesRenamerListRow* self);
VALA_EXTERN void files_renamer_list_row_set_status (FilesRenamerListRow* self,
                                        FilesRenameStatus value);
static void ___lambda95__gfunc (gconstpointer data,
                         gpointer self);
VALA_EXTERN void files_renamer_set_can_rename (FilesRenamer* self,
                                   gboolean value);
static gint files_renamer_sort_func (FilesRenamer* self,
                              GtkListBoxRow* row1,
                              GtkListBoxRow* row2);
VALA_EXTERN FilesSortBy files_renamer_get_sortby (FilesRenamer* self);
VALA_EXTERN FilesRenamer* files_renamer_new (void);
VALA_EXTERN FilesRenamer* files_renamer_construct (GType object_type);
VALA_EXTERN gboolean files_renamer_get_can_rename (FilesRenamer* self);
static void files_renamer_set_modifier_chain (FilesRenamer* self,
                                       GeeArrayList* value);
static void files_renamer_set_listbox (FilesRenamer* self,
                                GtkListBox* value);
VALA_EXTERN void files_renamer_set_sortby (FilesRenamer* self,
                               FilesSortBy value);
static GObject * files_renamer_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
static gint _files_renamer_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                      GtkListBoxRow* row2,
                                                      gpointer self);
static void _gtk_list_box_invalidate_sort_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self);
static void files_renamer_finalize (GObject * obj);
static GType files_renamer_get_type_once (void);
static void _vala_files_renamer_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_files_renamer_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);

static inline gpointer
files_renamer_get_instance_private (FilesRenamer* self)
{
	return G_STRUCT_MEMBER_P (self, FilesRenamer_private_offset);
}

void
files_renamer_add_files (FilesRenamer* self,
                         GList* files)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	if (files == NULL) {
		return;
	}
	_tmp0_ = self->priv->_directory;
	if (g_strcmp0 (_tmp0_, "") == 0) {
		GList* _tmp1_;
		gconstpointer _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp1_ = g_list_first (files);
		_tmp2_ = _tmp1_->data;
		_tmp3_ = files_file_get_location ((FilesFile*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_get_path (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_path_get_dirname (_tmp6_);
		_tmp8_ = _tmp7_;
		files_renamer_set_directory (self, _tmp8_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
	}
	{
		GList* f_collection = NULL;
		GList* f_it = NULL;
		f_collection = files;
		for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
			FilesFile* f = NULL;
			f = (FilesFile*) f_it->data;
			{
				gchar* path = NULL;
				FilesFile* _tmp9_;
				GFile* _tmp10_;
				GFile* _tmp11_;
				gchar* _tmp12_;
				gchar* dir = NULL;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				_tmp9_ = f;
				_tmp10_ = files_file_get_location (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_file_get_path (_tmp11_);
				path = _tmp12_;
				_tmp13_ = path;
				_tmp14_ = g_path_get_dirname (_tmp13_);
				dir = _tmp14_;
				_tmp15_ = dir;
				_tmp16_ = self->priv->_directory;
				if (g_strcmp0 (_tmp15_, _tmp16_) == 0) {
					FilesFile* _tmp17_;
					FilesRenamerListRow* row = NULL;
					FilesFile* _tmp18_;
					FilesRenamerListRow* _tmp19_;
					GtkListBox* _tmp20_;
					FilesRenamerListRow* _tmp21_;
					FilesRenamerListRow* _tmp22_;
					const gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					_tmp17_ = f;
					files_file_ensure_query_info (_tmp17_);
					_tmp18_ = f;
					_tmp19_ = files_renamer_list_row_new (_tmp18_);
					g_object_ref_sink (_tmp19_);
					row = _tmp19_;
					_tmp20_ = self->priv->_listbox;
					_tmp21_ = row;
					gtk_container_add ((GtkContainer*) _tmp20_, (GtkWidget*) _tmp21_);
					_tmp22_ = row;
					_tmp23_ = path;
					_tmp24_ = g_path_get_basename (_tmp23_);
					_tmp25_ = _tmp24_;
					files_renamer_list_row_set_new_name (_tmp22_, _tmp25_);
					_g_free0 (_tmp25_);
					_g_object_unref0 (row);
				}
				_g_free0 (dir);
				_g_free0 (path);
			}
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
___lambda91_ (FilesRenamer* self,
              GObject* obj,
              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		GFile* _tmp0_;
		GFile* _tmp1_;
		_tmp0_ = files_file_utils_set_file_display_name_finish (res, &_inner_error0_);
		_tmp1_ = _tmp0_;
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda91__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda91_ ((FilesRenamer*) self, source_object, res);
	g_object_unref (self);
}

static void
__lambda90_ (FilesRenamer* self,
             GtkWidget* child)
{
	FilesRenamerListRow* row = NULL;
	FilesRenamerListRow* _tmp0_;
	const gchar* output_name = NULL;
	FilesRenamerListRow* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	FilesFile* file = NULL;
	FilesRenamerListRow* _tmp4_;
	FilesFile* _tmp5_;
	FilesFile* _tmp6_;
	FilesFile* _tmp7_;
	gboolean _tmp8_ = FALSE;
	FilesFile* _tmp9_;
	g_return_if_fail (child != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (child, FILES_TYPE_RENAMER_LIST_ROW, FilesRenamerListRow));
	row = _tmp0_;
	_tmp1_ = row;
	_tmp2_ = files_renamer_list_row_get_new_name (_tmp1_);
	_tmp3_ = _tmp2_;
	output_name = _tmp3_;
	_tmp4_ = row;
	_tmp5_ = files_renamer_list_row_get_file (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	file = _tmp7_;
	_tmp9_ = file;
	if (_tmp9_ != NULL) {
		FilesFile* _tmp10_;
		GFile* _tmp11_;
		GFile* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp10_ = file;
		_tmp11_ = files_file_get_location (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_file_get_basename (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = output_name;
		_tmp8_ = g_strcmp0 (_tmp14_, _tmp15_) != 0;
		_g_free0 (_tmp14_);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		FilesFile* _tmp16_;
		GFile* _tmp17_;
		GFile* _tmp18_;
		const gchar* _tmp19_;
		_tmp16_ = file;
		_tmp17_ = files_file_get_location (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = output_name;
		files_file_utils_set_file_display_name (_tmp18_, _tmp19_, NULL, ____lambda91__gasync_ready_callback, g_object_ref (self));
	}
	_g_object_unref0 (file);
	_g_object_unref0 (row);
}

static void
___lambda90__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda90_ ((FilesRenamer*) self, (GtkWidget*) data);
}

void
files_renamer_rename_files (FilesRenamer* self)
{
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_listbox;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	_tmp2_ = _tmp1_;
	g_list_foreach (_tmp2_, ___lambda90__gfunc, self);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (g_list_free (_tmp2_), NULL));
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gchar*
files_renamer_strip_extension (FilesRenamer* self,
                               const gchar* filename,
                               gchar** extension)
{
	gchar* _vala_extension = NULL;
	gint extension_pos = 0;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	extension_pos = string_last_index_of_char (filename, (gunichar) '.', 0);
	_tmp1_ = strlen (filename);
	_tmp2_ = _tmp1_;
	if (_tmp2_ < 4) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp3_;
		gint _tmp4_;
		_tmp3_ = strlen (filename);
		_tmp4_ = _tmp3_;
		_tmp0_ = extension_pos < (_tmp4_ - 4);
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = g_strdup ("");
		_g_free0 (_vala_extension);
		_vala_extension = _tmp5_;
		_tmp6_ = g_strdup (filename);
		result = _tmp6_;
		if (extension) {
			*extension = _vala_extension;
		} else {
			_g_free0 (_vala_extension);
		}
		return result;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp7_ = strlen (filename);
		_tmp8_ = _tmp7_;
		_tmp9_ = string_slice (filename, (glong) extension_pos, (glong) _tmp8_);
		_g_free0 (_vala_extension);
		_vala_extension = _tmp9_;
		_tmp10_ = string_slice (filename, (glong) 0, (glong) extension_pos);
		result = _tmp10_;
		if (extension) {
			*extension = _vala_extension;
		} else {
			_g_free0 (_vala_extension);
		}
		return result;
	}
}

static gboolean
files_renamer_invalid_name (FilesRenamer* self,
                            const gchar* new_name,
                            FilesFile* old_file)
{
	GFile* new_file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (new_name != NULL, FALSE);
	g_return_val_if_fail (old_file != NULL, FALSE);
	_tmp0_ = files_file_get_location (old_file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_parent (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_get_path (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_build_filename (_tmp5_, new_name, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_file_new_for_path (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	new_file = _tmp9_;
	_tmp11_ = files_file_get_location (old_file);
	_tmp12_ = _tmp11_;
	_tmp13_ = new_file;
	if (!g_file_equal (_tmp12_, _tmp13_)) {
		GFile* _tmp14_;
		_tmp14_ = new_file;
		_tmp10_ = g_file_query_exists (_tmp14_, NULL);
	} else {
		_tmp10_ = FALSE;
	}
	result = _tmp10_;
	_g_object_unref0 (new_file);
	return result;
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		FilesRenamer* self;
		self = _data10_->self;
		_g_free0 (_data10_->custom_basename);
		_g_free0 (_data10_->replacement_text);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static gboolean
__lambda92_ (Block10Data* _data10_)
{
	FilesRenamer* self;
	gboolean result;
	self = _data10_->self;
	if (self->priv->updating) {
		result = G_SOURCE_CONTINUE;
		return result;
	}
	self->priv->update_timeout_id = (guint) 0;
	files_renamer_update_new_filenames (self, _data10_->custom_basename, _data10_->replacement_text);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda92__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda92_ (self);
	return result;
}

void
files_renamer_schedule_update (FilesRenamer* self,
                               const gchar* custom_basename,
                               const gchar* replacement_text)
{
	Block10Data* _data10_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = g_strdup (custom_basename);
	_g_free0 (_data10_->custom_basename);
	_data10_->custom_basename = _tmp0_;
	_tmp1_ = g_strdup (replacement_text);
	_g_free0 (_data10_->replacement_text);
	_data10_->replacement_text = _tmp1_;
	if (self->priv->update_timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->update_timeout_id);
	}
	self->priv->update_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, ___lambda92__gsource_func, block10_data_ref (_data10_), block10_data_unref);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		FilesRenamer* self;
		self = _data11_->self;
		_g_free0 (_data11_->previous_final_name);
		_g_free0 (_data11_->custom_basename);
		_g_free0 (_data11_->replacement_text);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
__lambda93_ (Block11Data* _data11_,
             GtkWidget* child)
{
	FilesRenamer* self;
	FilesRenamerListRow* row = NULL;
	FilesRenamerListRow* _tmp0_;
	gchar* input_name = NULL;
	gchar* _tmp1_;
	gchar* extension = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	FilesRenamerListRow* _tmp16_;
	const gchar* _tmp17_;
	self = _data11_->self;
	g_return_if_fail (child != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (child, FILES_TYPE_RENAMER_LIST_ROW, FilesRenamerListRow));
	row = _tmp0_;
	_tmp1_ = g_strdup ("");
	input_name = _tmp1_;
	_tmp2_ = g_strdup ("");
	extension = _tmp2_;
	if (_data11_->custom_basename != NULL) {
		_tmp3_ = _data11_->replacement_text == NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (_data11_->custom_basename);
		_g_free0 (input_name);
		input_name = _tmp4_;
	} else {
		FilesRenamerListRow* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		FilesRenamerListRow* _tmp10_;
		const gchar* _tmp11_;
		_tmp5_ = row;
		_tmp6_ = files_renamer_list_row_get_old_name (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp9_ = files_renamer_strip_extension (self, _tmp7_, &_tmp8_);
		_g_free0 (extension);
		extension = _tmp8_;
		_g_free0 (input_name);
		input_name = _tmp9_;
		_tmp10_ = row;
		_tmp11_ = extension;
		files_renamer_list_row_set_extension (_tmp10_, _tmp11_);
	}
	if (_data11_->replacement_text != NULL) {
		_tmp13_ = _data11_->custom_basename != NULL;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		_tmp12_ = g_strcmp0 (_data11_->custom_basename, "") != 0;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp14_ = input_name;
		_tmp15_ = string_replace (_tmp14_, _data11_->custom_basename, _data11_->replacement_text);
		_g_free0 (input_name);
		input_name = _tmp15_;
	}
	_tmp16_ = row;
	_tmp17_ = input_name;
	files_renamer_list_row_set_new_name (_tmp16_, _tmp17_);
	_g_free0 (extension);
	_g_free0 (input_name);
	_g_object_unref0 (row);
}

static void
___lambda93__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda93_ (self, (GtkWidget*) data);
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		FilesRenamer* self;
		self = _data12_->_data11_->self;
		_g_object_unref0 (_data12_->mod);
		block11_data_unref (_data12_->_data11_);
		_data12_->_data11_ = NULL;
		g_slice_free (Block12Data, _data12_);
	}
}

static void
____lambda94_ (Block12Data* _data12_,
               GtkWidget* child)
{
	Block11Data* _data11_;
	FilesRenamer* self;
	FilesRenamerListRow* row = NULL;
	FilesRenamerListRow* _tmp0_;
	FilesRenamerModifier* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	FilesFile* _tmp4_;
	FilesFile* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	_data11_ = _data12_->_data11_;
	self = _data11_->self;
	g_return_if_fail (child != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (child, FILES_TYPE_RENAMER_LIST_ROW, FilesRenamerListRow));
	row = _tmp0_;
	_tmp1_ = _data12_->mod;
	_tmp2_ = files_renamer_list_row_get_new_name (row);
	_tmp3_ = _tmp2_;
	_tmp4_ = files_renamer_list_row_get_file (row);
	_tmp5_ = _tmp4_;
	_tmp6_ = files_renamer_modifier_rename (_tmp1_, _tmp3_, _data12_->index, _tmp5_);
	_tmp7_ = _tmp6_;
	files_renamer_list_row_set_new_name (row, _tmp7_);
	_g_free0 (_tmp7_);
	_data12_->index += (guint) _data12_->incr;
	_g_object_unref0 (row);
}

static void
_____lambda94__gfunc (gconstpointer data,
                      gpointer self)
{
	____lambda94_ (self, (GtkWidget*) data);
}

static void
__lambda95_ (Block11Data* _data11_,
             GtkWidget* child)
{
	FilesRenamer* self;
	FilesRenamerListRow* row = NULL;
	FilesRenamerListRow* _tmp0_;
	FilesRenamerListRow* _tmp1_;
	FilesRenamerListRow* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	FilesRenamerListRow* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	FilesRenamerListRow* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	FilesRenamerListRow* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	self = _data11_->self;
	g_return_if_fail (child != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (child, FILES_TYPE_RENAMER_LIST_ROW, FilesRenamerListRow));
	row = _tmp0_;
	_tmp1_ = row;
	_tmp2_ = row;
	_tmp3_ = files_renamer_list_row_get_new_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = row;
	_tmp6_ = files_renamer_list_row_get_extension (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp4_, _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	files_renamer_list_row_set_new_name (_tmp1_, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp11_ = row;
	_tmp12_ = files_renamer_list_row_get_new_name (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _data11_->previous_final_name;
	if (g_strcmp0 (_tmp13_, _tmp14_) == 0) {
		_tmp10_ = TRUE;
	} else {
		FilesRenamerListRow* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		FilesRenamerListRow* _tmp18_;
		FilesFile* _tmp19_;
		FilesFile* _tmp20_;
		_tmp15_ = row;
		_tmp16_ = files_renamer_list_row_get_new_name (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = row;
		_tmp19_ = files_renamer_list_row_get_file (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp10_ = files_renamer_invalid_name (self, _tmp17_, _tmp20_);
	}
	if (_tmp10_) {
		FilesRenamerListRow* _tmp21_;
		_tmp21_ = row;
		files_renamer_list_row_set_status (_tmp21_, FILES_RENAME_STATUS_INVALID);
		_data11_->has_invalid = TRUE;
	} else {
		FilesRenamerListRow* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		FilesRenamerListRow* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		_tmp22_ = row;
		_tmp23_ = files_renamer_list_row_get_new_name (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = row;
		_tmp26_ = files_renamer_list_row_get_old_name (_tmp25_);
		_tmp27_ = _tmp26_;
		if (g_strcmp0 (_tmp24_, _tmp27_) == 0) {
			FilesRenamerListRow* _tmp28_;
			_tmp28_ = row;
			files_renamer_list_row_set_status (_tmp28_, FILES_RENAME_STATUS_IGNORED);
		} else {
			FilesRenamerListRow* _tmp29_;
			_tmp29_ = row;
			files_renamer_list_row_set_status (_tmp29_, FILES_RENAME_STATUS_VALID);
		}
	}
	_tmp30_ = row;
	_tmp31_ = files_renamer_list_row_get_new_name (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = g_strdup (_tmp32_);
	_g_free0 (_data11_->previous_final_name);
	_data11_->previous_final_name = _tmp33_;
	_g_object_unref0 (row);
}

static void
___lambda95__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda95_ (self, (GtkWidget*) data);
}

static void
files_renamer_update_new_filenames (FilesRenamer* self,
                                    const gchar* custom_basename,
                                    const gchar* replacement_text)
{
	Block11Data* _data11_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkListBox* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	guint n_children = 0U;
	GtkListBox* _tmp6_;
	GList* _tmp7_;
	GList* _tmp8_;
	guint _tmp9_;
	GtkListBox* _tmp29_;
	GList* _tmp30_;
	GList* _tmp31_;
	g_return_if_fail (self != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_tmp0_ = g_strdup (custom_basename);
	_g_free0 (_data11_->custom_basename);
	_data11_->custom_basename = _tmp0_;
	_tmp1_ = g_strdup (replacement_text);
	_g_free0 (_data11_->replacement_text);
	_data11_->replacement_text = _tmp1_;
	self->priv->updating = TRUE;
	_tmp2_ = g_strdup ("");
	_data11_->previous_final_name = _tmp2_;
	_data11_->has_invalid = FALSE;
	_tmp3_ = self->priv->_listbox;
	_tmp4_ = gtk_container_get_children ((GtkContainer*) _tmp3_);
	_tmp5_ = _tmp4_;
	g_list_foreach (_tmp5_, ___lambda93__gfunc, _data11_);
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (g_list_free (_tmp5_), NULL));
	_tmp6_ = self->priv->_listbox;
	_tmp7_ = gtk_container_get_children ((GtkContainer*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_list_length (_tmp8_);
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (g_list_free (_tmp8_), NULL));
	n_children = _tmp9_;
	{
		GeeArrayList* _mod_list = NULL;
		GeeArrayList* _tmp10_;
		gint _mod_size = 0;
		GeeArrayList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _mod_index = 0;
		_tmp10_ = self->priv->_modifier_chain;
		_mod_list = _tmp10_;
		_tmp11_ = _mod_list;
		_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_mod_size = _tmp13_;
		_mod_index = -1;
		while (TRUE) {
			Block12Data* _data12_;
			gint _tmp14_;
			gint _tmp15_;
			GeeArrayList* _tmp16_;
			gpointer _tmp17_;
			guint _tmp18_ = 0U;
			FilesRenamerModifier* _tmp19_;
			gboolean _tmp20_;
			gboolean _tmp21_;
			gint _tmp22_ = 0;
			FilesRenamerModifier* _tmp23_;
			gboolean _tmp24_;
			gboolean _tmp25_;
			GtkListBox* _tmp26_;
			GList* _tmp27_;
			GList* _tmp28_;
			_data12_ = g_slice_new0 (Block12Data);
			_data12_->_ref_count_ = 1;
			_data12_->_data11_ = block11_data_ref (_data11_);
			_mod_index = _mod_index + 1;
			_tmp14_ = _mod_index;
			_tmp15_ = _mod_size;
			if (!(_tmp14_ < _tmp15_)) {
				block12_data_unref (_data12_);
				_data12_ = NULL;
				break;
			}
			_tmp16_ = _mod_list;
			_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _mod_index);
			_data12_->mod = (FilesRenamerModifier*) _tmp17_;
			_tmp19_ = _data12_->mod;
			_tmp20_ = files_renamer_modifier_get_is_reversed (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp21_) {
				_tmp18_ = n_children - 1;
			} else {
				_tmp18_ = (guint) 0;
			}
			_data12_->index = _tmp18_;
			_tmp23_ = _data12_->mod;
			_tmp24_ = files_renamer_modifier_get_is_reversed (_tmp23_);
			_tmp25_ = _tmp24_;
			if (_tmp25_) {
				_tmp22_ = -1;
			} else {
				_tmp22_ = 1;
			}
			_data12_->incr = _tmp22_;
			_tmp26_ = self->priv->_listbox;
			_tmp27_ = gtk_container_get_children ((GtkContainer*) _tmp26_);
			_tmp28_ = _tmp27_;
			g_list_foreach (_tmp28_, _____lambda94__gfunc, _data12_);
			(_tmp28_ == NULL) ? NULL : (_tmp28_ = (g_list_free (_tmp28_), NULL));
			block12_data_unref (_data12_);
			_data12_ = NULL;
		}
	}
	_tmp29_ = self->priv->_listbox;
	_tmp30_ = gtk_container_get_children ((GtkContainer*) _tmp29_);
	_tmp31_ = _tmp30_;
	g_list_foreach (_tmp31_, ___lambda95__gfunc, _data11_);
	(_tmp31_ == NULL) ? NULL : (_tmp31_ = (g_list_free (_tmp31_), NULL));
	files_renamer_set_can_rename (self, !_data11_->has_invalid);
	self->priv->updating = FALSE;
	block11_data_unref (_data11_);
	_data11_ = NULL;
}

static gint
files_renamer_sort_func (FilesRenamer* self,
                         GtkListBoxRow* row1,
                         GtkListBoxRow* row2)
{
	FilesFile* file1 = NULL;
	FilesFile* _tmp0_;
	FilesFile* _tmp1_;
	FilesFile* _tmp2_;
	FilesFile* file2 = NULL;
	FilesFile* _tmp3_;
	FilesFile* _tmp4_;
	FilesFile* _tmp5_;
	FilesSortBy _tmp6_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = files_renamer_list_row_get_file (G_TYPE_CHECK_INSTANCE_CAST (row1, FILES_TYPE_RENAMER_LIST_ROW, FilesRenamerListRow));
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	file1 = _tmp2_;
	_tmp3_ = files_renamer_list_row_get_file (G_TYPE_CHECK_INSTANCE_CAST (row2, FILES_TYPE_RENAMER_LIST_ROW, FilesRenamerListRow));
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	file2 = _tmp5_;
	_tmp6_ = self->priv->_sortby;
	switch (_tmp6_) {
		case FILES_SORT_BY_CREATED:
		{
			FilesFile* _tmp7_;
			FilesFile* _tmp8_;
			_tmp7_ = file1;
			_tmp8_ = file2;
			result = files_file_compare_files_by_created (_tmp7_, _tmp8_);
			_g_object_unref0 (file2);
			_g_object_unref0 (file1);
			return result;
		}
		case FILES_SORT_BY_MODIFIED:
		{
			FilesFile* _tmp9_;
			FilesFile* _tmp10_;
			_tmp9_ = file1;
			_tmp10_ = file2;
			result = files_file_compare_files_by_time (_tmp9_, _tmp10_);
			_g_object_unref0 (file2);
			_g_object_unref0 (file1);
			return result;
		}
		case FILES_SORT_BY_SIZE:
		{
			FilesFile* _tmp11_;
			FilesFile* _tmp12_;
			_tmp11_ = file1;
			_tmp12_ = file2;
			result = files_file_compare_files_by_size (_tmp11_, _tmp12_);
			_g_object_unref0 (file2);
			_g_object_unref0 (file1);
			return result;
		}
		default:
		{
			FilesFile* _tmp13_;
			FilesFile* _tmp14_;
			_tmp13_ = file1;
			_tmp14_ = file2;
			result = files_file_compare_by_display_name (_tmp13_, _tmp14_);
			_g_object_unref0 (file2);
			_g_object_unref0 (file1);
			return result;
		}
	}
}

FilesRenamer*
files_renamer_construct (GType object_type)
{
	FilesRenamer * self = NULL;
	self = (FilesRenamer*) g_object_new (object_type, NULL);
	return self;
}

FilesRenamer*
files_renamer_new (void)
{
	return files_renamer_construct (FILES_TYPE_RENAMER);
}

gboolean
files_renamer_get_can_rename (FilesRenamer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_can_rename;
	return result;
}

void
files_renamer_set_can_rename (FilesRenamer* self,
                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_get_can_rename (self);
	if (old_value != value) {
		self->priv->_can_rename = value;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_properties[FILES_RENAMER_CAN_RENAME_PROPERTY]);
	}
}

const gchar*
files_renamer_get_directory (FilesRenamer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_directory;
	result = _tmp0_;
	return result;
}

static void
files_renamer_set_directory (FilesRenamer* self,
                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_get_directory (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_directory);
		self->priv->_directory = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_properties[FILES_RENAMER_DIRECTORY_PROPERTY]);
	}
}

GeeArrayList*
files_renamer_get_modifier_chain (FilesRenamer* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_modifier_chain;
	result = _tmp0_;
	return result;
}

static void
files_renamer_set_modifier_chain (FilesRenamer* self,
                                  GeeArrayList* value)
{
	GeeArrayList* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_get_modifier_chain (self);
	if (old_value != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_modifier_chain);
		self->priv->_modifier_chain = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_properties[FILES_RENAMER_MODIFIER_CHAIN_PROPERTY]);
	}
}

GtkListBox*
files_renamer_get_listbox (FilesRenamer* self)
{
	GtkListBox* result;
	GtkListBox* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_listbox;
	result = _tmp0_;
	return result;
}

static void
files_renamer_set_listbox (FilesRenamer* self,
                           GtkListBox* value)
{
	GtkListBox* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_get_listbox (self);
	if (old_value != value) {
		GtkListBox* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_listbox);
		self->priv->_listbox = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_properties[FILES_RENAMER_LISTBOX_PROPERTY]);
	}
}

FilesSortBy
files_renamer_get_sortby (FilesRenamer* self)
{
	FilesSortBy result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_sortby;
	return result;
}

void
files_renamer_set_sortby (FilesRenamer* self,
                          FilesSortBy value)
{
	FilesSortBy old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_get_sortby (self);
	if (old_value != value) {
		self->priv->_sortby = value;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_properties[FILES_RENAMER_SORTBY_PROPERTY]);
	}
}

static gint
_files_renamer_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                 GtkListBoxRow* row2,
                                                 gpointer self)
{
	gint result;
	result = files_renamer_sort_func ((FilesRenamer*) self, row1, row2);
	return result;
}

static void
_gtk_list_box_invalidate_sort_g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self)
{
	gtk_list_box_invalidate_sort ((GtkListBox*) self);
}

static GObject *
files_renamer_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FilesRenamer * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GtkListBox* _tmp2_ = NULL;
	GtkListBox* _tmp3_;
	GtkListBox* _tmp4_;
	GtkListBox* _tmp5_;
	GtkListBox* _tmp6_;
	GtkListBox* _tmp7_;
	parent_class = G_OBJECT_CLASS (files_renamer_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_RENAMER, FilesRenamer);
	_tmp0_ = gee_array_list_new (FILES_TYPE_RENAMER_MODIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	files_renamer_set_modifier_chain (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_can_focus ((GtkWidget*) _tmp2_, FALSE);
	gtk_list_box_set_selection_mode (_tmp2_, GTK_SELECTION_NONE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp2_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp2_, TRUE);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	files_renamer_set_listbox (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->_listbox;
	gtk_list_box_set_sort_func (_tmp4_, _files_renamer_sort_func_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp5_ = self->priv->_listbox;
	gtk_list_box_invalidate_sort (_tmp5_);
	_tmp6_ = self->priv->_listbox;
	gtk_widget_show_all ((GtkWidget*) _tmp6_);
	_tmp7_ = self->priv->_listbox;
	g_signal_connect_object ((GObject*) self, "notify::sortby", (GCallback) _gtk_list_box_invalidate_sort_g_object_notify, _tmp7_, 0);
	return obj;
}

static void
files_renamer_class_init (FilesRenamerClass * klass,
                          gpointer klass_data)
{
	files_renamer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesRenamer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_files_renamer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_renamer_set_property;
	G_OBJECT_CLASS (klass)->constructor = files_renamer_constructor;
	G_OBJECT_CLASS (klass)->finalize = files_renamer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_CAN_RENAME_PROPERTY, files_renamer_properties[FILES_RENAMER_CAN_RENAME_PROPERTY] = g_param_spec_boolean ("can-rename", "can-rename", "can-rename", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_DIRECTORY_PROPERTY, files_renamer_properties[FILES_RENAMER_DIRECTORY_PROPERTY] = g_param_spec_string ("directory", "directory", "directory", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_MODIFIER_CHAIN_PROPERTY, files_renamer_properties[FILES_RENAMER_MODIFIER_CHAIN_PROPERTY] = g_param_spec_object ("modifier-chain", "modifier-chain", "modifier-chain", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_LISTBOX_PROPERTY, files_renamer_properties[FILES_RENAMER_LISTBOX_PROPERTY] = g_param_spec_object ("listbox", "listbox", "listbox", gtk_list_box_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_SORTBY_PROPERTY, files_renamer_properties[FILES_RENAMER_SORTBY_PROPERTY] = g_param_spec_enum ("sortby", "sortby", "sortby", FILES_TYPE_SORT_BY, FILES_SORT_BY_NAME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
files_renamer_instance_init (FilesRenamer * self,
                             gpointer klass)
{
	gchar* _tmp0_;
	self->priv = files_renamer_get_instance_private (self);
	self->priv->_can_rename = FALSE;
	_tmp0_ = g_strdup ("");
	self->priv->_directory = _tmp0_;
	self->priv->_sortby = FILES_SORT_BY_NAME;
	self->priv->update_timeout_id = (guint) 0;
	self->priv->updating = FALSE;
}

static void
files_renamer_finalize (GObject * obj)
{
	FilesRenamer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_RENAMER, FilesRenamer);
	_g_free0 (self->priv->_directory);
	_g_object_unref0 (self->priv->_modifier_chain);
	_g_object_unref0 (self->priv->_listbox);
	G_OBJECT_CLASS (files_renamer_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_renamer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesRenamerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_renamer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesRenamer), 0, (GInstanceInitFunc) files_renamer_instance_init, NULL };
	GType files_renamer_type_id;
	files_renamer_type_id = g_type_register_static (G_TYPE_OBJECT, "FilesRenamer", &g_define_type_info, 0);
	FilesRenamer_private_offset = g_type_add_instance_private (files_renamer_type_id, sizeof (FilesRenamerPrivate));
	return files_renamer_type_id;
}

GType
files_renamer_get_type (void)
{
	static volatile gsize files_renamer_type_id__once = 0;
	if (g_once_init_enter (&files_renamer_type_id__once)) {
		GType files_renamer_type_id;
		files_renamer_type_id = files_renamer_get_type_once ();
		g_once_init_leave (&files_renamer_type_id__once, files_renamer_type_id);
	}
	return files_renamer_type_id__once;
}

static void
_vala_files_renamer_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	FilesRenamer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_RENAMER, FilesRenamer);
	switch (property_id) {
		case FILES_RENAMER_CAN_RENAME_PROPERTY:
		g_value_set_boolean (value, files_renamer_get_can_rename (self));
		break;
		case FILES_RENAMER_DIRECTORY_PROPERTY:
		g_value_set_string (value, files_renamer_get_directory (self));
		break;
		case FILES_RENAMER_MODIFIER_CHAIN_PROPERTY:
		g_value_set_object (value, files_renamer_get_modifier_chain (self));
		break;
		case FILES_RENAMER_LISTBOX_PROPERTY:
		g_value_set_object (value, files_renamer_get_listbox (self));
		break;
		case FILES_RENAMER_SORTBY_PROPERTY:
		g_value_set_enum (value, files_renamer_get_sortby (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_renamer_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	FilesRenamer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_RENAMER, FilesRenamer);
	switch (property_id) {
		case FILES_RENAMER_CAN_RENAME_PROPERTY:
		files_renamer_set_can_rename (self, g_value_get_boolean (value));
		break;
		case FILES_RENAMER_DIRECTORY_PROPERTY:
		files_renamer_set_directory (self, g_value_get_string (value));
		break;
		case FILES_RENAMER_MODIFIER_CHAIN_PROPERTY:
		files_renamer_set_modifier_chain (self, g_value_get_object (value));
		break;
		case FILES_RENAMER_LISTBOX_PROPERTY:
		files_renamer_set_listbox (self, g_value_get_object (value));
		break;
		case FILES_RENAMER_SORTBY_PROPERTY:
		files_renamer_set_sortby (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

