/* VolumeRow.c generated by valac 0.56.18, the Vala compiler
 * generated from VolumeRow.vala, do not modify */

/* DeviceRow.vala
 *
 * Copyright 2021 elementary LLC. <https://elementary.io>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * Authors : Jeremy Wootten <jeremywootten@gmail.com>
 */
/* Most of the storage rows will be volumes associated with a drive.  However some devices (e.g. MP3 players may appear as a volume without a drive */

#include <gtk/gtk.h>
#include "pantheon-files-core.h"
#include <glib-object.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <granite.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SIDEBAR_TYPE_BOOKMARK_ROW (sidebar_bookmark_row_get_type ())
#define SIDEBAR_BOOKMARK_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRow))
#define SIDEBAR_BOOKMARK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRowClass))
#define SIDEBAR_IS_BOOKMARK_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_BOOKMARK_ROW))
#define SIDEBAR_IS_BOOKMARK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_BOOKMARK_ROW))
#define SIDEBAR_BOOKMARK_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRowClass))

typedef struct _SidebarBookmarkRow SidebarBookmarkRow;
typedef struct _SidebarBookmarkRowClass SidebarBookmarkRowClass;
typedef struct _SidebarBookmarkRowPrivate SidebarBookmarkRowPrivate;

#define SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW (sidebar_abstract_mountable_row_get_type ())
#define SIDEBAR_ABSTRACT_MOUNTABLE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRow))
#define SIDEBAR_ABSTRACT_MOUNTABLE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRowClass))
#define SIDEBAR_IS_ABSTRACT_MOUNTABLE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW))
#define SIDEBAR_IS_ABSTRACT_MOUNTABLE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW))
#define SIDEBAR_ABSTRACT_MOUNTABLE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRowClass))

typedef struct _SidebarAbstractMountableRow SidebarAbstractMountableRow;
typedef struct _SidebarAbstractMountableRowClass SidebarAbstractMountableRowClass;
typedef struct _SidebarAbstractMountableRowPrivate SidebarAbstractMountableRowPrivate;

#define SIDEBAR_TYPE_VOLUME_ROW (sidebar_volume_row_get_type ())
#define SIDEBAR_VOLUME_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_VOLUME_ROW, SidebarVolumeRow))
#define SIDEBAR_VOLUME_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_VOLUME_ROW, SidebarVolumeRowClass))
#define SIDEBAR_IS_VOLUME_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_VOLUME_ROW))
#define SIDEBAR_IS_VOLUME_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_VOLUME_ROW))
#define SIDEBAR_VOLUME_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_VOLUME_ROW, SidebarVolumeRowClass))

typedef struct _SidebarVolumeRow SidebarVolumeRow;
typedef struct _SidebarVolumeRowClass SidebarVolumeRowClass;
typedef struct _SidebarVolumeRowPrivate SidebarVolumeRowPrivate;
enum  {
	SIDEBAR_VOLUME_ROW_0_PROPERTY,
	SIDEBAR_VOLUME_ROW_VOLUME_PROPERTY,
	SIDEBAR_VOLUME_ROW_DRIVE_NAME_PROPERTY,
	SIDEBAR_VOLUME_ROW_IS_MOUNTED_PROPERTY,
	SIDEBAR_VOLUME_ROW_CAN_UNMOUNT_PROPERTY,
	SIDEBAR_VOLUME_ROW_CAN_EJECT_PROPERTY,
	SIDEBAR_VOLUME_ROW_NUM_PROPERTIES
};
static GParamSpec* sidebar_volume_row_properties[SIDEBAR_VOLUME_ROW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	MOUNTABLE_TYPE_VOLUMELESS_MOUNT,
	MOUNTABLE_TYPE_VOLUME,
	MOUNTABLE_TYPE_EMPTY_DRIVE
} MountableType;

#define TYPE_MOUNTABLE_TYPE (mountable_type_get_type ())
typedef struct _Block66Data Block66Data;
typedef struct _SidebarVolumeRowGetFilesystemSpaceData SidebarVolumeRowGetFilesystemSpaceData;

#define FILES_VIEW_TYPE_ABSTRACT_PROPERTIES_DIALOG (files_view_abstract_properties_dialog_get_type ())
#define FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_TYPE_ABSTRACT_PROPERTIES_DIALOG, FilesViewAbstractPropertiesDialog))
#define FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_TYPE_ABSTRACT_PROPERTIES_DIALOG, FilesViewAbstractPropertiesDialogClass))
#define FILES_VIEW_IS_ABSTRACT_PROPERTIES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_TYPE_ABSTRACT_PROPERTIES_DIALOG))
#define FILES_VIEW_IS_ABSTRACT_PROPERTIES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_TYPE_ABSTRACT_PROPERTIES_DIALOG))
#define FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_TYPE_ABSTRACT_PROPERTIES_DIALOG, FilesViewAbstractPropertiesDialogClass))

typedef struct _FilesViewAbstractPropertiesDialog FilesViewAbstractPropertiesDialog;
typedef struct _FilesViewAbstractPropertiesDialogClass FilesViewAbstractPropertiesDialogClass;

#define FILES_VIEW_TYPE_VOLUME_PROPERTIES_WINDOW (files_view_volume_properties_window_get_type ())
#define FILES_VIEW_VOLUME_PROPERTIES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_TYPE_VOLUME_PROPERTIES_WINDOW, FilesViewVolumePropertiesWindow))
#define FILES_VIEW_VOLUME_PROPERTIES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_TYPE_VOLUME_PROPERTIES_WINDOW, FilesViewVolumePropertiesWindowClass))
#define FILES_VIEW_IS_VOLUME_PROPERTIES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_TYPE_VOLUME_PROPERTIES_WINDOW))
#define FILES_VIEW_IS_VOLUME_PROPERTIES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_TYPE_VOLUME_PROPERTIES_WINDOW))
#define FILES_VIEW_VOLUME_PROPERTIES_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_TYPE_VOLUME_PROPERTIES_WINDOW, FilesViewVolumePropertiesWindowClass))

typedef struct _FilesViewVolumePropertiesWindow FilesViewVolumePropertiesWindow;
typedef struct _FilesViewVolumePropertiesWindowClass FilesViewVolumePropertiesWindowClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SidebarBookmarkRow {
	GtkListBoxRow parent_instance;
	SidebarBookmarkRowPrivate * priv;
	GtkGrid* content_grid;
	GtkGrid* icon_label_grid;
	GtkStack* label_stack;
	GtkEntry* editable;
	GtkLabel* label;
	GtkRevealer* drop_revealer;
	FilesFile* target_file;
};

struct _SidebarBookmarkRowClass {
	GtkListBoxRowClass parent_class;
	gboolean (*on_key_press_event) (SidebarBookmarkRow* self, guint keyval, guint keycode, GdkModifierType state);
	void (*on_button_release_event) (SidebarBookmarkRow* self, gint n_press, gdouble x, gdouble y);
	void (*popup_context_menu) (SidebarBookmarkRow* self);
};

struct _SidebarAbstractMountableRow {
	SidebarBookmarkRow parent_instance;
	SidebarAbstractMountableRowPrivate * priv;
	gboolean valid;
};

struct _SidebarAbstractMountableRowClass {
	SidebarBookmarkRowClass parent_class;
	void (*update_free_space) (SidebarAbstractMountableRow* self);
	void (*add_mountable_tooltip) (SidebarAbstractMountableRow* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_mountable_tooltip_finish) (SidebarAbstractMountableRow* self, GAsyncResult* _res_);
	void (*on_mount_removed) (SidebarAbstractMountableRow* self, GMount* removed_mount);
	void (*on_mount_added) (SidebarAbstractMountableRow* self, GMount* added_mount);
	void (*show_mount_info) (SidebarAbstractMountableRow* self);
	void (*get_filesystem_space) (SidebarAbstractMountableRow* self, GCancellable* update_cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*get_filesystem_space_finish) (SidebarAbstractMountableRow* self, GAsyncResult* _res_);
	gboolean (*get_is_mounted) (SidebarAbstractMountableRow* self);
	gboolean (*get_can_unmount) (SidebarAbstractMountableRow* self);
	gboolean (*get_can_eject) (SidebarAbstractMountableRow* self);
};

struct _SidebarVolumeRow {
	SidebarAbstractMountableRow parent_instance;
	SidebarVolumeRowPrivate * priv;
};

struct _SidebarVolumeRowClass {
	SidebarAbstractMountableRowClass parent_class;
};

struct _SidebarVolumeRowPrivate {
	GVolume* _volume;
};

struct _Block66Data {
	int _ref_count_;
	SidebarVolumeRow* self;
	gboolean open;
	FilesOpenFlag flag;
};

struct _SidebarVolumeRowGetFilesystemSpaceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SidebarVolumeRow* self;
	GCancellable* update_cancellable;
	gboolean result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GVolume* _tmp2_;
	GMount* _tmp3_;
	GMount* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	gboolean _tmp7_;
};

static gint SidebarVolumeRow_private_offset;
static gpointer sidebar_volume_row_parent_class = NULL;
VALA_EXTERN GVolumeMonitor* sidebar_abstract_mountable_row_volume_monitor;
static SidebarSidebarItemInterfaceIface * sidebar_volume_row_sidebar_sidebar_item_interface_parent_iface = NULL;

VALA_EXTERN GType sidebar_bookmark_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarBookmarkRow, g_object_unref)
VALA_EXTERN GType sidebar_abstract_mountable_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarAbstractMountableRow, g_object_unref)
VALA_EXTERN GType sidebar_volume_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarVolumeRow, g_object_unref)
VALA_EXTERN void sidebar_abstract_mountable_row_on_mount_added (SidebarAbstractMountableRow* self,
                                                    GMount* added_mount);
VALA_EXTERN void sidebar_abstract_mountable_row_on_mount_removed (SidebarAbstractMountableRow* self,
                                                      GMount* removed_mount);
VALA_EXTERN void sidebar_abstract_mountable_row_get_filesystem_space (SidebarAbstractMountableRow* self,
                                                          GCancellable* update_cancellable,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
VALA_EXTERN gboolean sidebar_abstract_mountable_row_get_filesystem_space_finish (SidebarAbstractMountableRow* self,
                                                                     GAsyncResult* _res_);
VALA_EXTERN void sidebar_abstract_mountable_row_show_mount_info (SidebarAbstractMountableRow* self);
VALA_EXTERN gboolean sidebar_abstract_mountable_row_get_is_mounted (SidebarAbstractMountableRow* self);
VALA_EXTERN gboolean sidebar_abstract_mountable_row_get_can_unmount (SidebarAbstractMountableRow* self);
VALA_EXTERN gboolean sidebar_abstract_mountable_row_get_can_eject (SidebarAbstractMountableRow* self);
VALA_EXTERN SidebarVolumeRow* sidebar_volume_row_new (const gchar* name,
                                          const gchar* uri,
                                          GIcon* gicon,
                                          SidebarSidebarListInterface* list,
                                          gboolean pinned,
                                          gboolean permanent,
                                          const gchar* _uuid,
                                          GVolume* _volume);
VALA_EXTERN SidebarVolumeRow* sidebar_volume_row_construct (GType object_type,
                                                const gchar* name,
                                                const gchar* uri,
                                                GIcon* gicon,
                                                SidebarSidebarListInterface* list,
                                                gboolean pinned,
                                                gboolean permanent,
                                                const gchar* _uuid,
                                                GVolume* _volume);
VALA_EXTERN GDrive* sidebar_abstract_mountable_row_get_drive (SidebarAbstractMountableRow* self);
VALA_EXTERN GVolume* sidebar_volume_row_get_volume (SidebarVolumeRow* self);
VALA_EXTERN void sidebar_abstract_mountable_row_set_sort_key (SidebarAbstractMountableRow* self,
                                                  const gchar* value);
VALA_EXTERN const gchar* sidebar_abstract_mountable_row_get_sort_key (SidebarAbstractMountableRow* self);
VALA_EXTERN GType mountable_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* sidebar_volume_row_get_drive_name (SidebarVolumeRow* self);
VALA_EXTERN GMount* sidebar_abstract_mountable_row_get_mount (SidebarAbstractMountableRow* self);
static void sidebar_volume_row_real_activated (SidebarSidebarItemInterface* base,
                                        FilesOpenFlag flag);
VALA_EXTERN gboolean sidebar_abstract_mountable_row_get_working (SidebarAbstractMountableRow* self);
static void sidebar_volume_row_mount_volume (SidebarVolumeRow* self,
                                      gboolean open,
                                      FilesOpenFlag flag);
static void sidebar_volume_row_on_volume_removed (SidebarVolumeRow* self,
                                           GVolume* removed_volume);
static void sidebar_volume_row_real_on_mount_added (SidebarAbstractMountableRow* base,
                                             GMount* added_mount);
VALA_EXTERN void sidebar_abstract_mountable_row_set_mount (SidebarAbstractMountableRow* self,
                                               GMount* value);
VALA_EXTERN void sidebar_abstract_mountable_row_update_visibilities (SidebarAbstractMountableRow* self);
static void sidebar_volume_row_real_on_mount_removed (SidebarAbstractMountableRow* base,
                                               GMount* removed_mount);
static void sidebar_volume_row_real_add_extra_menu_items (SidebarSidebarItemInterface* base,
                                                   GMenu* menu);
VALA_EXTERN void sidebar_abstract_mountable_row_add_extra_menu_items_for_mount (SidebarAbstractMountableRow* self,
                                                                    GMount* mount,
                                                                    GMenu* menu);
VALA_EXTERN void sidebar_volume_row_add_extra_menu_items_for_drive (SidebarVolumeRow* self,
                                                        GDrive* drive,
                                                        GMenu* menu);
static Block66Data* block66_data_ref (Block66Data* _data66_);
static void block66_data_unref (void * _userdata_);
VALA_EXTERN void sidebar_abstract_mountable_row_set_working (SidebarAbstractMountableRow* self,
                                                 gboolean value);
static void __lambda180_ (Block66Data* _data66_,
                   GObject* obj,
                   GAsyncResult* res);
VALA_EXTERN void sidebar_abstract_mountable_row_set_uuid (SidebarAbstractMountableRow* self,
                                              const gchar* value);
VALA_EXTERN void sidebar_abstract_mountable_row_add_mountable_tooltip (SidebarAbstractMountableRow* self,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
VALA_EXTERN void sidebar_abstract_mountable_row_add_mountable_tooltip_finish (SidebarAbstractMountableRow* self,
                                                                  GAsyncResult* _res_);
static void ___lambda180__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void sidebar_volume_row_real_get_filesystem_space_data_free (gpointer _data);
static void sidebar_volume_row_real_get_filesystem_space (SidebarAbstractMountableRow* base,
                                                   GCancellable* update_cancellable,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static gboolean sidebar_volume_row_real_get_filesystem_space_co (SidebarVolumeRowGetFilesystemSpaceData* _data_);
VALA_EXTERN void sidebar_abstract_mountable_row_get_filesystem_space_for_root (SidebarAbstractMountableRow* self,
                                                                   GFile* root,
                                                                   GCancellable* update_cancellable,
                                                                   GAsyncReadyCallback _callback_,
                                                                   gpointer _user_data_);
VALA_EXTERN gboolean sidebar_abstract_mountable_row_get_filesystem_space_for_root_finish (SidebarAbstractMountableRow* self,
                                                                              GAsyncResult* _res_);
static void sidebar_volume_row_get_filesystem_space_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void sidebar_volume_row_open_volume_property_window (SidebarVolumeRow* self);
VALA_EXTERN GtkWindow* files_get_active_window (void);
VALA_EXTERN FilesViewVolumePropertiesWindow* files_view_volume_properties_window_new (GMount* mount,
                                                                          GtkWindow* parent);
VALA_EXTERN FilesViewVolumePropertiesWindow* files_view_volume_properties_window_construct (GType object_type,
                                                                                GMount* mount,
                                                                                GtkWindow* parent);
VALA_EXTERN GType files_view_abstract_properties_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewAbstractPropertiesDialog, g_object_unref)
VALA_EXTERN GType files_view_volume_properties_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewVolumePropertiesWindow, g_object_unref)
static void sidebar_volume_row_real_show_mount_info (SidebarAbstractMountableRow* base);
static void ___lambda181_ (SidebarVolumeRow* self,
                    GObject* obj,
                    GAsyncResult* res);
static void ____lambda181__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void sidebar_volume_row_set_volume (SidebarVolumeRow* self,
                                    GVolume* value);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static GObject * sidebar_volume_row_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void _sidebar_volume_row_on_volume_removed_g_volume_monitor_volume_removed (GVolumeMonitor* _sender,
                                                                            GVolume* volume,
                                                                            gpointer self);
static void _sidebar_volume_row___lambda182_ (SidebarVolumeRow* self);
static void __sidebar_volume_row___lambda182__g_simple_action_activate (GSimpleAction* _sender,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void sidebar_volume_row_finalize (GObject * obj);
static GType sidebar_volume_row_get_type_once (void);
static void _vala_sidebar_volume_row_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_sidebar_volume_row_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
sidebar_volume_row_get_instance_private (SidebarVolumeRow* self)
{
	return G_STRUCT_MEMBER_P (self, SidebarVolumeRow_private_offset);
}

SidebarVolumeRow*
sidebar_volume_row_construct (GType object_type,
                              const gchar* name,
                              const gchar* uri,
                              GIcon* gicon,
                              SidebarSidebarListInterface* list,
                              gboolean pinned,
                              gboolean permanent,
                              const gchar* _uuid,
                              GVolume* _volume)
{
	SidebarVolumeRow * self = NULL;
	GMount* _tmp0_;
	GMount* _tmp1_;
	GDrive* _tmp2_;
	GDrive* _tmp3_;
	const gchar* _tmp4_ = NULL;
	GDrive* _tmp5_;
	GDrive* _tmp6_;
	gchar* drive_sort_key = NULL;
	gchar* _tmp10_;
	gchar* volume_id = NULL;
	GVolume* _tmp11_;
	gchar* _tmp12_;
	gchar* volume_sort_key = NULL;
	GVolume* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_ = NULL;
	const gchar* _tmp27_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	gboolean _tmp40_ = FALSE;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gboolean _tmp44_;
	GMount* _tmp55_;
	GMount* _tmp56_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (gicon != NULL, NULL);
	g_return_val_if_fail (list != NULL, NULL);
	g_return_val_if_fail (_volume != NULL, NULL);
	_tmp0_ = g_volume_get_mount (_volume);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_volume_get_drive (_volume);
	_tmp3_ = _tmp2_;
	self = (SidebarVolumeRow*) g_object_new (object_type, "custom-name", name, "uri", uri, "gicon", gicon, "list", list, "pinned", TRUE, "permanent", permanent, "uuid", _uuid, "volume", _volume, "mount", _tmp1_, "drive", _tmp3_, NULL);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	_tmp5_ = sidebar_abstract_mountable_row_get_drive ((SidebarAbstractMountableRow*) self);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != NULL) {
		GDrive* _tmp7_;
		GDrive* _tmp8_;
		const gchar* _tmp9_;
		_tmp7_ = sidebar_abstract_mountable_row_get_drive ((SidebarAbstractMountableRow*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_drive_get_sort_key (_tmp8_);
		_tmp4_ = _tmp9_;
	} else {
		_tmp4_ = NULL;
	}
	_tmp10_ = g_strdup (_tmp4_);
	drive_sort_key = _tmp10_;
	_tmp11_ = self->priv->_volume;
	_tmp12_ = g_volume_get_identifier (_tmp11_, G_VOLUME_IDENTIFIER_KIND_UNIX_DEVICE);
	volume_id = _tmp12_;
	_tmp13_ = self->priv->_volume;
	_tmp14_ = g_volume_get_sort_key (_tmp13_);
	_tmp15_ = g_strdup (_tmp14_);
	volume_sort_key = _tmp15_;
	_tmp17_ = drive_sort_key;
	if (_tmp17_ != NULL) {
		const gchar* _tmp18_;
		_tmp18_ = drive_sort_key;
		_tmp16_ = _tmp18_;
	} else {
		_tmp16_ = "";
	}
	sidebar_abstract_mountable_row_set_sort_key ((SidebarAbstractMountableRow*) self, _tmp16_);
	_tmp20_ = volume_id;
	if (_tmp20_ != NULL) {
		const gchar* _tmp21_;
		_tmp21_ = volume_id;
		_tmp19_ = _tmp21_;
	} else {
		_tmp19_ = "";
	}
	_tmp22_ = sidebar_abstract_mountable_row_get_sort_key ((SidebarAbstractMountableRow*) self);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat (_tmp23_, _tmp19_, NULL);
	_tmp25_ = _tmp24_;
	sidebar_abstract_mountable_row_set_sort_key ((SidebarAbstractMountableRow*) self, _tmp25_);
	_g_free0 (_tmp25_);
	_tmp27_ = volume_sort_key;
	if (_tmp27_ != NULL) {
		const gchar* _tmp28_;
		_tmp28_ = volume_sort_key;
		_tmp26_ = _tmp28_;
	} else {
		_tmp26_ = "";
	}
	_tmp29_ = sidebar_abstract_mountable_row_get_sort_key ((SidebarAbstractMountableRow*) self);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strconcat (_tmp30_, _tmp26_, NULL);
	_tmp32_ = _tmp31_;
	sidebar_abstract_mountable_row_set_sort_key ((SidebarAbstractMountableRow*) self, _tmp32_);
	_g_free0 (_tmp32_);
	_tmp33_ = sidebar_abstract_mountable_row_get_sort_key ((SidebarAbstractMountableRow*) self);
	_tmp34_ = _tmp33_;
	_tmp35_ = strlen (_tmp34_);
	_tmp36_ = _tmp35_;
	if (_tmp36_ == 0) {
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		_tmp37_ = g_enum_to_string (TYPE_MOUNTABLE_TYPE, MOUNTABLE_TYPE_VOLUME);
		_tmp38_ = g_strconcat (_tmp37_, name, NULL);
		_tmp39_ = _tmp38_;
		sidebar_abstract_mountable_row_set_sort_key ((SidebarAbstractMountableRow*) self, _tmp39_);
		_g_free0 (_tmp39_);
		_g_free0 (_tmp37_);
	}
	_tmp41_ = sidebar_volume_row_get_drive_name (self);
	_tmp42_ = _tmp41_;
	_tmp43_ = _tmp42_;
	_tmp44_ = _tmp43_ != NULL;
	_g_free0 (_tmp43_);
	if (_tmp44_) {
		gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		_tmp45_ = sidebar_volume_row_get_drive_name (self);
		_tmp46_ = _tmp45_;
		_tmp47_ = _tmp46_;
		_tmp40_ = g_strcmp0 (_tmp47_, "") != 0;
		_g_free0 (_tmp47_);
	} else {
		_tmp40_ = FALSE;
	}
	if (_tmp40_) {
		const gchar* _tmp48_;
		const gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		_tmp48_ = sidebar_sidebar_item_interface_get_custom_name ((SidebarSidebarItemInterface*) self);
		_tmp49_ = _tmp48_;
		_tmp50_ = sidebar_volume_row_get_drive_name (self);
		_tmp51_ = _tmp50_;
		_tmp52_ = _tmp51_;
		_tmp53_ = g_strdup_printf (_ ("%s (%s)"), _tmp49_, _tmp52_);
		_tmp54_ = _tmp53_;
		sidebar_sidebar_item_interface_set_custom_name ((SidebarSidebarItemInterface*) self, _tmp54_);
		_g_free0 (_tmp54_);
		_g_free0 (_tmp52_);
	}
	_tmp55_ = sidebar_abstract_mountable_row_get_mount ((SidebarAbstractMountableRow*) self);
	_tmp56_ = _tmp55_;
	if (_tmp56_ == NULL) {
		_g_object_unref0 (((SidebarBookmarkRow*) self)->target_file);
		((SidebarBookmarkRow*) self)->target_file = NULL;
	}
	_g_free0 (volume_sort_key);
	_g_free0 (volume_id);
	_g_free0 (drive_sort_key);
	return self;
}

SidebarVolumeRow*
sidebar_volume_row_new (const gchar* name,
                        const gchar* uri,
                        GIcon* gicon,
                        SidebarSidebarListInterface* list,
                        gboolean pinned,
                        gboolean permanent,
                        const gchar* _uuid,
                        GVolume* _volume)
{
	return sidebar_volume_row_construct (SIDEBAR_TYPE_VOLUME_ROW, name, uri, gicon, list, pinned, permanent, _uuid, _volume);
}

static void
sidebar_volume_row_real_activated (SidebarSidebarItemInterface* base,
                                   FilesOpenFlag flag)
{
	SidebarVolumeRow * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = (SidebarVolumeRow*) base;
	_tmp0_ = sidebar_abstract_mountable_row_get_working ((SidebarAbstractMountableRow*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = sidebar_abstract_mountable_row_get_is_mounted ((SidebarAbstractMountableRow*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		SidebarSidebarListInterface* _tmp4_;
		SidebarSidebarListInterface* _tmp5_;
		_tmp4_ = sidebar_sidebar_item_interface_get_list ((SidebarSidebarItemInterface*) self);
		_tmp5_ = _tmp4_;
		sidebar_sidebar_list_interface_open_item (_tmp5_, (SidebarSidebarItemInterface*) self, flag);
		return;
	}
	sidebar_volume_row_mount_volume (self, TRUE, flag);
}

static void
sidebar_volume_row_on_volume_removed (SidebarVolumeRow* self,
                                      GVolume* removed_volume)
{
	GVolume* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (removed_volume != NULL);
	if (!((SidebarAbstractMountableRow*) self)->valid) {
		return;
	}
	_tmp0_ = self->priv->_volume;
	if (_tmp0_ == removed_volume) {
		SidebarSidebarListInterface* _tmp1_;
		SidebarSidebarListInterface* _tmp2_;
		guint32 _tmp3_;
		guint32 _tmp4_;
		((SidebarAbstractMountableRow*) self)->valid = FALSE;
		_tmp1_ = sidebar_sidebar_item_interface_get_list ((SidebarSidebarItemInterface*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = sidebar_sidebar_item_interface_get_id ((SidebarSidebarItemInterface*) self);
		_tmp4_ = _tmp3_;
		sidebar_sidebar_list_interface_remove_item_by_id (_tmp2_, _tmp4_);
	}
}

static void
sidebar_volume_row_real_on_mount_added (SidebarAbstractMountableRow* base,
                                        GMount* added_mount)
{
	SidebarVolumeRow * self;
	GVolume* _tmp0_;
	GMount* _tmp1_;
	GMount* _tmp2_;
	gboolean _tmp3_;
	self = (SidebarVolumeRow*) base;
	g_return_if_fail (added_mount != NULL);
	_tmp0_ = self->priv->_volume;
	_tmp1_ = g_volume_get_mount (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = added_mount == _tmp2_;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		GVolume* _tmp4_;
		GMount* _tmp5_;
		GMount* _tmp6_;
		GMount* _tmp7_;
		GMount* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
		FilesFile* _tmp11_;
		FilesFile* _tmp12_;
		_tmp4_ = self->priv->_volume;
		_tmp5_ = g_volume_get_mount (_tmp4_);
		_tmp6_ = _tmp5_;
		sidebar_abstract_mountable_row_set_mount ((SidebarAbstractMountableRow*) self, _tmp6_);
		_g_object_unref0 (_tmp6_);
		_tmp7_ = sidebar_abstract_mountable_row_get_mount ((SidebarAbstractMountableRow*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_mount_get_root (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = files_file_get (_tmp10_);
		_g_object_unref0 (((SidebarBookmarkRow*) self)->target_file);
		((SidebarBookmarkRow*) self)->target_file = _tmp11_;
		_g_object_unref0 (_tmp10_);
		_tmp12_ = ((SidebarBookmarkRow*) self)->target_file;
		files_file_ensure_query_info (_tmp12_);
		sidebar_abstract_mountable_row_update_visibilities ((SidebarAbstractMountableRow*) self);
	}
}

static void
sidebar_volume_row_real_on_mount_removed (SidebarAbstractMountableRow* base,
                                          GMount* removed_mount)
{
	SidebarVolumeRow * self;
	GVolume* _tmp0_;
	GMount* _tmp1_;
	GMount* _tmp2_;
	gboolean _tmp3_;
	self = (SidebarVolumeRow*) base;
	g_return_if_fail (removed_mount != NULL);
	_tmp0_ = self->priv->_volume;
	_tmp1_ = g_volume_get_mount (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ == NULL;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		sidebar_abstract_mountable_row_set_mount ((SidebarAbstractMountableRow*) self, NULL);
		_g_object_unref0 (((SidebarBookmarkRow*) self)->target_file);
		((SidebarBookmarkRow*) self)->target_file = NULL;
		sidebar_abstract_mountable_row_update_visibilities ((SidebarAbstractMountableRow*) self);
	}
}

static void
sidebar_volume_row_real_add_extra_menu_items (SidebarSidebarItemInterface* base,
                                              GMenu* menu)
{
	SidebarVolumeRow * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GVolume* _tmp2_;
	GMount* _tmp3_;
	GMount* _tmp4_;
	GVolume* _tmp5_;
	GDrive* _tmp6_;
	GDrive* _tmp7_;
	self = (SidebarVolumeRow*) base;
	g_return_if_fail (menu != NULL);
	_tmp0_ = sidebar_abstract_mountable_row_get_working ((SidebarAbstractMountableRow*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->_volume;
	_tmp3_ = g_volume_get_mount (_tmp2_);
	_tmp4_ = _tmp3_;
	sidebar_abstract_mountable_row_add_extra_menu_items_for_mount ((SidebarAbstractMountableRow*) self, _tmp4_, menu);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = self->priv->_volume;
	_tmp6_ = g_volume_get_drive (_tmp5_);
	_tmp7_ = _tmp6_;
	sidebar_volume_row_add_extra_menu_items_for_drive (self, _tmp7_, menu);
	_g_object_unref0 (_tmp7_);
}

static Block66Data*
block66_data_ref (Block66Data* _data66_)
{
	g_atomic_int_inc (&_data66_->_ref_count_);
	return _data66_;
}

static void
block66_data_unref (void * _userdata_)
{
	Block66Data* _data66_;
	_data66_ = (Block66Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data66_->_ref_count_)) {
		SidebarVolumeRow* self;
		self = _data66_->self;
		_g_object_unref0 (self);
		g_slice_free (Block66Data, _data66_);
	}
}

static void
__lambda180_ (Block66Data* _data66_,
              GObject* obj,
              GAsyncResult* res)
{
	SidebarVolumeRow* self;
	GMount* mount = NULL;
	GVolume* _tmp0_;
	GMount* _tmp1_;
	GMount* _tmp2_;
	self = _data66_->self;
	g_return_if_fail (res != NULL);
	marlin_file_operations_mount_volume_full_finish (res);
	_tmp0_ = self->priv->_volume;
	_tmp1_ = g_volume_get_mount (_tmp0_);
	mount = _tmp1_;
	_tmp2_ = mount;
	if (_tmp2_ != NULL) {
		GMount* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GVolume* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gboolean _tmp11_;
		_tmp3_ = mount;
		_tmp4_ = g_mount_get_default_location (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_file_get_uri (_tmp5_);
		_tmp7_ = _tmp6_;
		sidebar_sidebar_item_interface_set_uri ((SidebarSidebarItemInterface*) self, _tmp7_);
		_g_free0 (_tmp7_);
		_g_object_unref0 (_tmp5_);
		_tmp8_ = self->priv->_volume;
		_tmp9_ = g_volume_get_uuid (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_ == NULL;
		_g_free0 (_tmp10_);
		if (_tmp11_) {
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			_tmp12_ = sidebar_sidebar_item_interface_get_uri ((SidebarSidebarItemInterface*) self);
			_tmp13_ = _tmp12_;
			sidebar_abstract_mountable_row_set_uuid ((SidebarAbstractMountableRow*) self, _tmp13_);
		}
		if (_data66_->open) {
			SidebarSidebarListInterface* _tmp14_;
			SidebarSidebarListInterface* _tmp15_;
			_tmp14_ = sidebar_sidebar_item_interface_get_list ((SidebarSidebarItemInterface*) self);
			_tmp15_ = _tmp14_;
			sidebar_sidebar_list_interface_open_item (_tmp15_, (SidebarSidebarItemInterface*) self, _data66_->flag);
		}
	}
	sidebar_abstract_mountable_row_set_working ((SidebarAbstractMountableRow*) self, FALSE);
	sidebar_abstract_mountable_row_add_mountable_tooltip ((SidebarAbstractMountableRow*) self, NULL, NULL);
	_g_object_unref0 (mount);
}

static void
___lambda180__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda180_ (self, source_object, res);
	block66_data_unref (self);
}

static void
sidebar_volume_row_mount_volume (SidebarVolumeRow* self,
                                 gboolean open,
                                 FilesOpenFlag flag)
{
	Block66Data* _data66_;
	GVolume* _tmp0_;
	g_return_if_fail (self != NULL);
	_data66_ = g_slice_new0 (Block66Data);
	_data66_->_ref_count_ = 1;
	_data66_->self = g_object_ref (self);
	_data66_->open = open;
	_data66_->flag = flag;
	sidebar_abstract_mountable_row_set_working ((SidebarAbstractMountableRow*) self, TRUE);
	_tmp0_ = self->priv->_volume;
	marlin_file_operations_mount_volume_full (_tmp0_, NULL, ___lambda180__gasync_ready_callback, block66_data_ref (_data66_));
	block66_data_unref (_data66_);
	_data66_ = NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

void
sidebar_volume_row_add_extra_menu_items_for_drive (SidebarVolumeRow* self,
                                                   GDrive* drive,
                                                   GMenu* menu)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GMenu* menu_section = NULL;
	GMenu* _tmp2_;
	gchar* sort_key = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	GMenu* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	if (drive == NULL) {
		return;
	}
	_tmp0_ = sidebar_abstract_mountable_row_get_is_mounted ((SidebarAbstractMountableRow*) self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		g_menu_append (menu, _ ("Mount"), "volume.mount");
	}
	_tmp2_ = g_menu_new ();
	menu_section = _tmp2_;
	_tmp3_ = g_drive_get_sort_key (drive);
	_tmp4_ = g_strdup (_tmp3_);
	sort_key = _tmp4_;
	_tmp6_ = sort_key;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		_tmp7_ = sort_key;
		_tmp5_ = string_contains (_tmp7_, "hotplug");
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GMenu* _tmp8_;
		_tmp8_ = menu_section;
		g_menu_append (_tmp8_, _ ("Safely Remove"), "mountable.safely-remove");
	} else {
		gboolean _tmp9_ = FALSE;
		GMount* _tmp10_;
		GMount* _tmp11_;
		_tmp10_ = sidebar_abstract_mountable_row_get_mount ((SidebarAbstractMountableRow*) self);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == NULL) {
			_tmp9_ = g_drive_can_eject (drive);
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			GMenu* _tmp12_;
			_tmp12_ = menu_section;
			g_menu_append (_tmp12_, _ ("Eject Media"), "mountable.eject");
		}
	}
	_tmp13_ = menu_section;
	g_menu_append_section (menu, NULL, (GMenuModel*) _tmp13_);
	_g_free0 (sort_key);
	_g_object_unref0 (menu_section);
}

static void
sidebar_volume_row_real_get_filesystem_space_data_free (gpointer _data)
{
	SidebarVolumeRowGetFilesystemSpaceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->update_cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SidebarVolumeRowGetFilesystemSpaceData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
sidebar_volume_row_real_get_filesystem_space (SidebarAbstractMountableRow* base,
                                              GCancellable* update_cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	SidebarVolumeRow * self;
	SidebarVolumeRowGetFilesystemSpaceData* _data_;
	SidebarVolumeRow* _tmp0_;
	GCancellable* _tmp1_;
	self = (SidebarVolumeRow*) base;
	_data_ = g_slice_new0 (SidebarVolumeRowGetFilesystemSpaceData);
	_data_->_async_result = g_task_new (G_OBJECT (self), update_cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sidebar_volume_row_real_get_filesystem_space_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (update_cancellable);
	_g_object_unref0 (_data_->update_cancellable);
	_data_->update_cancellable = _tmp1_;
	sidebar_volume_row_real_get_filesystem_space_co (_data_);
}

static gboolean
sidebar_volume_row_get_filesystem_space_finish (SidebarAbstractMountableRow* base,
                                                GAsyncResult* _res_)
{
	gboolean result;
	SidebarVolumeRowGetFilesystemSpaceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
sidebar_volume_row_get_filesystem_space_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	SidebarVolumeRowGetFilesystemSpaceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	sidebar_volume_row_real_get_filesystem_space_co (_data_);
}

static gboolean
sidebar_volume_row_real_get_filesystem_space_co (SidebarVolumeRowGetFilesystemSpaceData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = sidebar_abstract_mountable_row_get_is_mounted ((SidebarAbstractMountableRow*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_data_->_tmp1_) {
		_data_->_tmp2_ = _data_->self->priv->_volume;
		_data_->_tmp3_ = g_volume_get_mount (_data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = g_mount_get_root (_data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_state_ = 1;
		sidebar_abstract_mountable_row_get_filesystem_space_for_root ((SidebarAbstractMountableRow*) _data_->self, _data_->_tmp6_, _data_->update_cancellable, sidebar_volume_row_get_filesystem_space_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp7_ = sidebar_abstract_mountable_row_get_filesystem_space_for_root_finish ((SidebarAbstractMountableRow*) _data_->self, _data_->_res_);
		_g_object_unref0 (_data_->_tmp6_);
		_g_object_unref0 (_data_->_tmp4_);
		_data_->result = _data_->_tmp7_;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

static void
sidebar_volume_row_open_volume_property_window (SidebarVolumeRow* self)
{
	GVolume* _tmp0_;
	GMount* _tmp1_;
	GMount* _tmp2_;
	GtkWindow* _tmp3_;
	GtkWindow* _tmp4_;
	FilesViewVolumePropertiesWindow* _tmp5_;
	FilesViewVolumePropertiesWindow* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_volume;
	_tmp1_ = g_volume_get_mount (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = files_get_active_window ();
	_tmp4_ = _tmp3_;
	_tmp5_ = files_view_volume_properties_window_new (_tmp2_, _tmp4_);
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
}

static void
___lambda181_ (SidebarVolumeRow* self,
               GObject* obj,
               GAsyncResult* res)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (res != NULL);
	marlin_file_operations_mount_volume_full_finish (res);
	sidebar_abstract_mountable_row_set_working ((SidebarAbstractMountableRow*) self, FALSE);
	_tmp0_ = sidebar_abstract_mountable_row_get_is_mounted ((SidebarAbstractMountableRow*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		sidebar_volume_row_open_volume_property_window (self);
	}
}

static void
____lambda181__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda181_ ((SidebarVolumeRow*) self, source_object, res);
	g_object_unref (self);
}

static void
sidebar_volume_row_real_show_mount_info (SidebarAbstractMountableRow* base)
{
	SidebarVolumeRow * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = (SidebarVolumeRow*) base;
	_tmp0_ = sidebar_abstract_mountable_row_get_working ((SidebarAbstractMountableRow*) self);
	_tmp1_ = _tmp0_;
	_vala_return_if_fail (!_tmp1_, "!working");
	_tmp2_ = sidebar_abstract_mountable_row_get_is_mounted ((SidebarAbstractMountableRow*) self);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		GVolume* _tmp4_;
		sidebar_abstract_mountable_row_set_working ((SidebarAbstractMountableRow*) self, TRUE);
		_tmp4_ = self->priv->_volume;
		marlin_file_operations_mount_volume_full (_tmp4_, NULL, ____lambda181__gasync_ready_callback, g_object_ref (self));
	} else {
		sidebar_volume_row_open_volume_property_window (self);
	}
}

GVolume*
sidebar_volume_row_get_volume (SidebarVolumeRow* self)
{
	GVolume* result;
	GVolume* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_volume;
	result = _tmp0_;
	return result;
}

static void
sidebar_volume_row_set_volume (SidebarVolumeRow* self,
                               GVolume* value)
{
	GVolume* old_value;
	g_return_if_fail (self != NULL);
	old_value = sidebar_volume_row_get_volume (self);
	if (old_value != value) {
		GVolume* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_volume);
		self->priv->_volume = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sidebar_volume_row_properties[SIDEBAR_VOLUME_ROW_VOLUME_PROPERTY]);
	}
}

gchar*
sidebar_volume_row_get_drive_name (SidebarVolumeRow* self)
{
	gchar* result;
	gchar* _tmp0_ = NULL;
	GDrive* _tmp1_;
	GDrive* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = sidebar_abstract_mountable_row_get_drive ((SidebarAbstractMountableRow*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		GDrive* _tmp3_;
		GDrive* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = sidebar_abstract_mountable_row_get_drive ((SidebarAbstractMountableRow*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_drive_get_name (_tmp4_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	} else {
		_g_free0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

static gboolean
sidebar_volume_row_real_get_is_mounted (SidebarAbstractMountableRow* base)
{
	gboolean result;
	SidebarVolumeRow* self;
	GVolume* _tmp0_;
	GMount* _tmp1_;
	GMount* _tmp2_;
	gboolean _tmp3_;
	self = (SidebarVolumeRow*) base;
	_tmp0_ = self->priv->_volume;
	_tmp1_ = g_volume_get_mount (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_object_unref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static gboolean
sidebar_volume_row_real_get_can_unmount (SidebarAbstractMountableRow* base)
{
	gboolean result;
	SidebarVolumeRow* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = (SidebarVolumeRow*) base;
	_tmp1_ = sidebar_abstract_mountable_row_get_is_mounted ((SidebarAbstractMountableRow*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GVolume* _tmp3_;
		GMount* _tmp4_;
		GMount* _tmp5_;
		_tmp3_ = self->priv->_volume;
		_tmp4_ = g_volume_get_mount (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = g_mount_can_unmount (_tmp5_);
		_g_object_unref0 (_tmp5_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
sidebar_volume_row_real_get_can_eject (SidebarAbstractMountableRow* base)
{
	gboolean result;
	SidebarVolumeRow* self;
	gboolean _tmp0_ = FALSE;
	GDrive* _tmp1_;
	GDrive* _tmp2_;
	gboolean should_eject = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_;
	gboolean _tmp10_;
	self = (SidebarVolumeRow*) base;
	_tmp1_ = sidebar_abstract_mountable_row_get_drive ((SidebarAbstractMountableRow*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		GDrive* _tmp3_;
		GDrive* _tmp4_;
		GList* _tmp5_;
		GList* _tmp6_;
		_tmp3_ = sidebar_abstract_mountable_row_get_drive ((SidebarAbstractMountableRow*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_drive_get_volumes (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = g_list_length (_tmp6_) == ((guint) 1);
		(_tmp6_ == NULL) ? NULL : (_tmp6_ = (_g_list_free__g_object_unref0_ (_tmp6_), NULL));
	} else {
		_tmp0_ = TRUE;
	}
	should_eject = _tmp0_;
	_tmp9_ = sidebar_abstract_mountable_row_get_is_mounted ((SidebarAbstractMountableRow*) self);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		GVolume* _tmp11_;
		GMount* _tmp12_;
		GMount* _tmp13_;
		_tmp11_ = self->priv->_volume;
		_tmp12_ = g_volume_get_mount (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp8_ = g_mount_can_eject (_tmp13_);
		_g_object_unref0 (_tmp13_);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		_tmp7_ = should_eject;
	} else {
		_tmp7_ = FALSE;
	}
	result = _tmp7_;
	return result;
}

static void
_sidebar_volume_row_on_volume_removed_g_volume_monitor_volume_removed (GVolumeMonitor* _sender,
                                                                       GVolume* volume,
                                                                       gpointer self)
{
	sidebar_volume_row_on_volume_removed ((SidebarVolumeRow*) self, volume);
}

static void
_sidebar_volume_row___lambda182_ (SidebarVolumeRow* self)
{
	sidebar_volume_row_mount_volume (self, FALSE, FILES_OPEN_FLAG_DEFAULT);
}

static void
__sidebar_volume_row___lambda182__g_simple_action_activate (GSimpleAction* _sender,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	_sidebar_volume_row___lambda182_ ((SidebarVolumeRow*) self);
}

static GObject *
sidebar_volume_row_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SidebarVolumeRow * self;
	GVolumeMonitor* _tmp0_;
	GSimpleAction* mount_action = NULL;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp3_;
	GSimpleActionGroup* _tmp4_;
	GSimpleAction* _tmp5_;
	GSimpleActionGroup* _tmp6_;
	parent_class = G_OBJECT_CLASS (sidebar_volume_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDEBAR_TYPE_VOLUME_ROW, SidebarVolumeRow);
	_tmp0_ = sidebar_abstract_mountable_row_volume_monitor;
	g_signal_connect_object (_tmp0_, "volume-removed", (GCallback) _sidebar_volume_row_on_volume_removed_g_volume_monitor_volume_removed, self, 0);
	_tmp1_ = g_simple_action_new ("mount", NULL);
	mount_action = _tmp1_;
	_tmp2_ = mount_action;
	g_signal_connect_object (_tmp2_, "activate", (GCallback) __sidebar_volume_row___lambda182__g_simple_action_activate, self, 0);
	_tmp3_ = g_simple_action_group_new ();
	action_group = _tmp3_;
	_tmp4_ = action_group;
	_tmp5_ = mount_action;
	g_action_map_add_action ((GActionMap*) _tmp4_, (GAction*) _tmp5_);
	_tmp6_ = action_group;
	gtk_widget_insert_action_group ((GtkWidget*) self, "volume", (GActionGroup*) _tmp6_);
	_g_object_unref0 (action_group);
	_g_object_unref0 (mount_action);
	return obj;
}

static void
sidebar_volume_row_class_init (SidebarVolumeRowClass * klass,
                               gpointer klass_data)
{
	sidebar_volume_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SidebarVolumeRow_private_offset);
	((SidebarAbstractMountableRowClass *) klass)->on_mount_added = (void (*) (SidebarAbstractMountableRow*, GMount*)) sidebar_volume_row_real_on_mount_added;
	((SidebarAbstractMountableRowClass *) klass)->on_mount_removed = (void (*) (SidebarAbstractMountableRow*, GMount*)) sidebar_volume_row_real_on_mount_removed;
	((SidebarAbstractMountableRowClass *) klass)->get_filesystem_space = (void (*) (SidebarAbstractMountableRow*, GCancellable*, GAsyncReadyCallback, gpointer)) sidebar_volume_row_real_get_filesystem_space;
	((SidebarAbstractMountableRowClass *) klass)->get_filesystem_space_finish = (gboolean (*) (SidebarAbstractMountableRow*, GAsyncResult*)) sidebar_volume_row_get_filesystem_space_finish;
	((SidebarAbstractMountableRowClass *) klass)->show_mount_info = (void (*) (SidebarAbstractMountableRow*)) sidebar_volume_row_real_show_mount_info;
	SIDEBAR_ABSTRACT_MOUNTABLE_ROW_CLASS (klass)->get_is_mounted = (gboolean (*) (SidebarAbstractMountableRow*)) sidebar_volume_row_real_get_is_mounted;
	SIDEBAR_ABSTRACT_MOUNTABLE_ROW_CLASS (klass)->get_can_unmount = (gboolean (*) (SidebarAbstractMountableRow*)) sidebar_volume_row_real_get_can_unmount;
	SIDEBAR_ABSTRACT_MOUNTABLE_ROW_CLASS (klass)->get_can_eject = (gboolean (*) (SidebarAbstractMountableRow*)) sidebar_volume_row_real_get_can_eject;
	G_OBJECT_CLASS (klass)->get_property = _vala_sidebar_volume_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sidebar_volume_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = sidebar_volume_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = sidebar_volume_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_VOLUME_ROW_VOLUME_PROPERTY, sidebar_volume_row_properties[SIDEBAR_VOLUME_ROW_VOLUME_PROPERTY] = g_param_spec_object ("volume", "volume", "volume", g_volume_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_VOLUME_ROW_DRIVE_NAME_PROPERTY, sidebar_volume_row_properties[SIDEBAR_VOLUME_ROW_DRIVE_NAME_PROPERTY] = g_param_spec_string ("drive-name", "drive-name", "drive-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_VOLUME_ROW_IS_MOUNTED_PROPERTY, sidebar_volume_row_properties[SIDEBAR_VOLUME_ROW_IS_MOUNTED_PROPERTY] = g_param_spec_boolean ("is-mounted", "is-mounted", "is-mounted", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_VOLUME_ROW_CAN_UNMOUNT_PROPERTY, sidebar_volume_row_properties[SIDEBAR_VOLUME_ROW_CAN_UNMOUNT_PROPERTY] = g_param_spec_boolean ("can-unmount", "can-unmount", "can-unmount", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_VOLUME_ROW_CAN_EJECT_PROPERTY, sidebar_volume_row_properties[SIDEBAR_VOLUME_ROW_CAN_EJECT_PROPERTY] = g_param_spec_boolean ("can-eject", "can-eject", "can-eject", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
sidebar_volume_row_sidebar_sidebar_item_interface_interface_init (SidebarSidebarItemInterfaceIface * iface,
                                                                  gpointer iface_data)
{
	sidebar_volume_row_sidebar_sidebar_item_interface_parent_iface = g_type_interface_peek_parent (iface);
	iface->activated = (void (*) (SidebarSidebarItemInterface*, FilesOpenFlag)) sidebar_volume_row_real_activated;
	iface->add_extra_menu_items = (void (*) (SidebarSidebarItemInterface*, GMenu*)) sidebar_volume_row_real_add_extra_menu_items;
}

static void
sidebar_volume_row_instance_init (SidebarVolumeRow * self,
                                  gpointer klass)
{
	self->priv = sidebar_volume_row_get_instance_private (self);
}

static void
sidebar_volume_row_finalize (GObject * obj)
{
	SidebarVolumeRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDEBAR_TYPE_VOLUME_ROW, SidebarVolumeRow);
	_g_object_unref0 (self->priv->_volume);
	G_OBJECT_CLASS (sidebar_volume_row_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
sidebar_volume_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SidebarVolumeRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sidebar_volume_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SidebarVolumeRow), 0, (GInstanceInitFunc) sidebar_volume_row_instance_init, NULL };
	static const GInterfaceInfo sidebar_sidebar_item_interface_info = { (GInterfaceInitFunc) sidebar_volume_row_sidebar_sidebar_item_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType sidebar_volume_row_type_id;
	sidebar_volume_row_type_id = g_type_register_static (SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, "SidebarVolumeRow", &g_define_type_info, 0);
	g_type_add_interface_static (sidebar_volume_row_type_id, SIDEBAR_TYPE_SIDEBAR_ITEM_INTERFACE, &sidebar_sidebar_item_interface_info);
	SidebarVolumeRow_private_offset = g_type_add_instance_private (sidebar_volume_row_type_id, sizeof (SidebarVolumeRowPrivate));
	return sidebar_volume_row_type_id;
}

GType
sidebar_volume_row_get_type (void)
{
	static volatile gsize sidebar_volume_row_type_id__once = 0;
	if (g_once_init_enter (&sidebar_volume_row_type_id__once)) {
		GType sidebar_volume_row_type_id;
		sidebar_volume_row_type_id = sidebar_volume_row_get_type_once ();
		g_once_init_leave (&sidebar_volume_row_type_id__once, sidebar_volume_row_type_id);
	}
	return sidebar_volume_row_type_id__once;
}

static void
_vala_sidebar_volume_row_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	SidebarVolumeRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SIDEBAR_TYPE_VOLUME_ROW, SidebarVolumeRow);
	switch (property_id) {
		case SIDEBAR_VOLUME_ROW_VOLUME_PROPERTY:
		g_value_set_object (value, sidebar_volume_row_get_volume (self));
		break;
		case SIDEBAR_VOLUME_ROW_DRIVE_NAME_PROPERTY:
		g_value_take_string (value, sidebar_volume_row_get_drive_name (self));
		break;
		case SIDEBAR_VOLUME_ROW_IS_MOUNTED_PROPERTY:
		g_value_set_boolean (value, sidebar_abstract_mountable_row_get_is_mounted ((SidebarAbstractMountableRow*) self));
		break;
		case SIDEBAR_VOLUME_ROW_CAN_UNMOUNT_PROPERTY:
		g_value_set_boolean (value, sidebar_abstract_mountable_row_get_can_unmount ((SidebarAbstractMountableRow*) self));
		break;
		case SIDEBAR_VOLUME_ROW_CAN_EJECT_PROPERTY:
		g_value_set_boolean (value, sidebar_abstract_mountable_row_get_can_eject ((SidebarAbstractMountableRow*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sidebar_volume_row_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	SidebarVolumeRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SIDEBAR_TYPE_VOLUME_ROW, SidebarVolumeRow);
	switch (property_id) {
		case SIDEBAR_VOLUME_ROW_VOLUME_PROPERTY:
		sidebar_volume_row_set_volume (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

