/* Permissions.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Permissions.vala, do not modify */

/*
* Copyright (c) 2016-2018 elementary LLC. <https://elementary.io>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1335 USA.
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	PERMISSIONS_TYPE_USER,
	PERMISSIONS_TYPE_GROUP,
	PERMISSIONS_TYPE_OTHER
} PermissionsType;

#define PERMISSIONS_TYPE_TYPE (permissions_type_get_type ())
typedef enum  {
	PERMISSIONS_VALUE_READ,
	PERMISSIONS_VALUE_WRITE,
	PERMISSIONS_VALUE_EXE
} PermissionsValue;

#define PERMISSIONS_TYPE_VALUE (permissions_value_get_type ())
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

VALA_EXTERN GType permissions_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* permissions_type_to_string (PermissionsType self);
VALA_EXTERN GType permissions_value_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean permissions_is_chmod_code (const gchar* str);

gchar*
permissions_type_to_string (PermissionsType self)
{
	gchar* result;
	switch (self) {
		case PERMISSIONS_TYPE_USER:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Owner"));
			result = _tmp0_;
			return result;
		}
		case PERMISSIONS_TYPE_GROUP:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Group"));
			result = _tmp1_;
			return result;
		}
		default:
		case PERMISSIONS_TYPE_OTHER:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Everyone"));
			result = _tmp2_;
			return result;
		}
	}
}

 G_GNUC_NO_INLINE static GType
permissions_type_get_type_once (void)
{
	static const GEnumValue values[] = {{PERMISSIONS_TYPE_USER, "PERMISSIONS_TYPE_USER", "user"}, {PERMISSIONS_TYPE_GROUP, "PERMISSIONS_TYPE_GROUP", "group"}, {PERMISSIONS_TYPE_OTHER, "PERMISSIONS_TYPE_OTHER", "other"}, {0, NULL, NULL}};
	GType permissions_type_type_id;
	permissions_type_type_id = g_enum_register_static ("PermissionsType", values);
	return permissions_type_type_id;
}

GType
permissions_type_get_type (void)
{
	static volatile gsize permissions_type_type_id__once = 0;
	if (g_once_init_enter (&permissions_type_type_id__once)) {
		GType permissions_type_type_id;
		permissions_type_type_id = permissions_type_get_type_once ();
		g_once_init_leave (&permissions_type_type_id__once, permissions_type_type_id);
	}
	return permissions_type_type_id__once;
}

 G_GNUC_NO_INLINE static GType
permissions_value_get_type_once (void)
{
	static const GEnumValue values[] = {{PERMISSIONS_VALUE_READ, "PERMISSIONS_VALUE_READ", "read"}, {PERMISSIONS_VALUE_WRITE, "PERMISSIONS_VALUE_WRITE", "write"}, {PERMISSIONS_VALUE_EXE, "PERMISSIONS_VALUE_EXE", "exe"}, {0, NULL, NULL}};
	GType permissions_value_type_id;
	permissions_value_type_id = g_enum_register_static ("PermissionsValue", values);
	return permissions_value_type_id;
}

GType
permissions_value_get_type (void)
{
	static volatile gsize permissions_value_type_id__once = 0;
	if (g_once_init_enter (&permissions_value_type_id__once)) {
		GType permissions_value_type_id;
		permissions_value_type_id = permissions_value_get_type_once ();
		g_once_init_leave (&permissions_value_type_id__once, permissions_value_type_id);
	}
	return permissions_value_type_id__once;
}

gboolean
permissions_is_chmod_code (const gchar* str)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	{
		GRegex* regex = NULL;
		GRegex* _tmp0_;
		_tmp0_ = g_regex_new ("^[0-7]{3}$", 0, 0, &_inner_error0_);
		regex = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp1_ = FALSE;
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp1_;
		}
		if (g_regex_match (regex, str, 0, NULL)) {
			result = TRUE;
			_g_regex_unref0 (regex);
			return result;
		}
		_g_regex_unref0 (regex);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp2_;
	}
	result = FALSE;
	return result;
}

