/* Utils.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Utils.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2017 elementary LLC. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: David Hewitt <davidmhewitt@gmail.com>
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <camel/camel.h>
#include <libedataserver/libedataserver.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAIL_TYPE_UTILS (mail_utils_get_type ())
#define MAIL_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_UTILS, MailUtils))
#define MAIL_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_UTILS, MailUtilsClass))
#define MAIL_IS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_UTILS))
#define MAIL_IS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_UTILS))
#define MAIL_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_UTILS, MailUtilsClass))

typedef struct _MailUtils MailUtils;
typedef struct _MailUtilsClass MailUtilsClass;
typedef struct _MailUtilsPrivate MailUtilsPrivate;
typedef gboolean (*MailUtilsAcceptAddress) (const gchar* address, gpointer user_data);

#define MAIL_BACKEND_TYPE_SESSION (mail_backend_session_get_type ())
#define MAIL_BACKEND_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_BACKEND_TYPE_SESSION, MailBackendSession))
#define MAIL_BACKEND_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_BACKEND_TYPE_SESSION, MailBackendSessionClass))
#define MAIL_BACKEND_IS_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_BACKEND_TYPE_SESSION))
#define MAIL_BACKEND_IS_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_BACKEND_TYPE_SESSION))
#define MAIL_BACKEND_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_BACKEND_TYPE_SESSION, MailBackendSessionClass))

typedef struct _MailBackendSession MailBackendSession;
typedef struct _MailBackendSessionClass MailBackendSessionClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _MailParamSpecUtils MailParamSpecUtils;

struct _MailUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MailUtilsPrivate * priv;
};

struct _MailUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (MailUtils *self);
};

struct _MailParamSpecUtils {
	GParamSpec parent_instance;
};

static gpointer mail_utils_parent_class = NULL;

VALA_EXTERN gpointer mail_utils_ref (gpointer instance);
VALA_EXTERN void mail_utils_unref (gpointer instance);
VALA_EXTERN GParamSpec* mail_param_spec_utils (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void mail_value_set_utils (GValue* value,
                           gpointer v_object);
VALA_EXTERN void mail_value_take_utils (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer mail_value_get_utils (const GValue* value);
VALA_EXTERN GType mail_utils_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailUtils, mail_utils_unref)
VALA_EXTERN gchar* mail_utils_get_reply_addresses (const gchar* raw_addresses,
                                       MailUtilsAcceptAddress should_add,
                                       gpointer should_add_target);
VALA_EXTERN GType mail_backend_session_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailBackendSession, g_object_unref)
VALA_EXTERN MailBackendSession* mail_backend_session_get_default (void);
VALA_EXTERN GeeArrayList* mail_backend_session_get_own_addresses (MailBackendSession* self);
VALA_EXTERN gchar* mail_utils_escape_html_tags (const gchar* input);
VALA_EXTERN gchar* mail_utils_strip_folder_full_name (const gchar* service_uid,
                                          const gchar* folder_uri);
VALA_EXTERN CamelFolderInfoFlags mail_utils_get_full_folder_info_flags (CamelService* service,
                                                            CamelFolderInfo* folderinfo);
VALA_EXTERN gchar* mail_utils_build_folder_uri (const gchar* service_uid,
                                    const gchar* folder_name);
VALA_EXTERN ESource* mail_backend_session_ref_source (MailBackendSession* self,
                                          const gchar* source_uid);
VALA_EXTERN MailUtils* mail_utils_new (void);
VALA_EXTERN MailUtils* mail_utils_construct (GType object_type);
static void mail_utils_finalize (MailUtils * obj);
static GType mail_utils_get_type_once (void);

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gchar*
mail_utils_get_reply_addresses (const gchar* raw_addresses,
                                MailUtilsAcceptAddress should_add,
                                gpointer should_add_target)
{
	GeeArrayList* own_addresses = NULL;
	MailBackendSession* _tmp0_;
	GeeArrayList* _tmp1_;
	gchar* output = NULL;
	gchar* _tmp2_;
	GeeArrayList* added_addresses = NULL;
	GeeArrayList* _tmp3_;
	CamelInternetAddress* addresses = NULL;
	CamelInternetAddress* _tmp4_;
	CamelInternetAddress* _tmp5_;
	CamelInternetAddress* _tmp6_;
	gchar* result;
	g_return_val_if_fail (raw_addresses != NULL, NULL);
	_tmp0_ = mail_backend_session_get_default ();
	_tmp1_ = mail_backend_session_get_own_addresses (_tmp0_);
	own_addresses = _tmp1_;
	_tmp2_ = g_strdup ("");
	output = _tmp2_;
	_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	added_addresses = _tmp3_;
	_tmp4_ = camel_internet_address_new ();
	addresses = _tmp4_;
	_tmp5_ = addresses;
	camel_address_decode ((CamelAddress*) _tmp5_, raw_addresses);
	_tmp6_ = addresses;
	g_object_ref ((GObject*) _tmp6_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				CamelInternetAddress* _tmp9_;
				const gchar* _address = NULL;
				CamelInternetAddress* _tmp10_;
				const gchar* _tmp11_ = NULL;
				const gchar* _tmp12_;
				gchar* address = NULL;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gboolean is_own_address = FALSE;
				gboolean _tmp25_ = FALSE;
				gboolean _tmp26_ = FALSE;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = addresses;
				if (!(i < camel_address_length ((CamelAddress*) _tmp9_))) {
					break;
				}
				_tmp10_ = addresses;
				camel_internet_address_get (_tmp10_, i, NULL, &_tmp11_);
				_address = _tmp11_;
				_tmp12_ = _address;
				if (_tmp12_ == NULL) {
					continue;
				}
				_tmp13_ = _address;
				_tmp14_ = g_utf8_casefold (_tmp13_, (gssize) -1);
				address = _tmp14_;
				is_own_address = FALSE;
				{
					GeeArrayList* _own_address_list = NULL;
					GeeArrayList* _tmp15_;
					gint _own_address_size = 0;
					GeeArrayList* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					gint _own_address_index = 0;
					_tmp15_ = own_addresses;
					_own_address_list = _tmp15_;
					_tmp16_ = _own_address_list;
					_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
					_tmp18_ = _tmp17_;
					_own_address_size = _tmp18_;
					_own_address_index = -1;
					while (TRUE) {
						gint _tmp19_;
						gint _tmp20_;
						gchar* own_address = NULL;
						GeeArrayList* _tmp21_;
						gpointer _tmp22_;
						const gchar* _tmp23_;
						const gchar* _tmp24_;
						_own_address_index = _own_address_index + 1;
						_tmp19_ = _own_address_index;
						_tmp20_ = _own_address_size;
						if (!(_tmp19_ < _tmp20_)) {
							break;
						}
						_tmp21_ = _own_address_list;
						_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _own_address_index);
						own_address = (gchar*) _tmp22_;
						_tmp23_ = address;
						_tmp24_ = own_address;
						if (string_contains (_tmp23_, _tmp24_)) {
							is_own_address = TRUE;
							_g_free0 (own_address);
							break;
						}
						_g_free0 (own_address);
					}
				}
				if (!is_own_address) {
					const gchar* _tmp27_;
					_tmp27_ = address;
					_tmp26_ = should_add (_tmp27_, should_add_target);
				} else {
					_tmp26_ = FALSE;
				}
				if (_tmp26_) {
					GeeArrayList* _tmp28_;
					const gchar* _tmp29_;
					_tmp28_ = added_addresses;
					_tmp29_ = address;
					_tmp25_ = !gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp28_, _tmp29_);
				} else {
					_tmp25_ = FALSE;
				}
				if (_tmp25_) {
					GeeArrayList* _tmp30_;
					const gchar* _tmp31_;
					const gchar* _tmp32_;
					gint _tmp33_;
					gint _tmp34_;
					_tmp30_ = added_addresses;
					_tmp31_ = address;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, _tmp31_);
					_tmp32_ = output;
					_tmp33_ = strlen (_tmp32_);
					_tmp34_ = _tmp33_;
					if (_tmp34_ > 0) {
						const gchar* _tmp35_;
						const gchar* _tmp36_;
						gchar* _tmp37_;
						gchar* _tmp38_;
						gchar* _tmp39_;
						_tmp35_ = output;
						_tmp36_ = address;
						_tmp37_ = g_strdup_printf (", %s", _tmp36_);
						_tmp38_ = _tmp37_;
						_tmp39_ = g_strconcat (_tmp35_, _tmp38_, NULL);
						_g_free0 (output);
						output = _tmp39_;
						_g_free0 (_tmp38_);
					} else {
						const gchar* _tmp40_;
						const gchar* _tmp41_;
						gchar* _tmp42_;
						_tmp40_ = output;
						_tmp41_ = address;
						_tmp42_ = g_strconcat (_tmp40_, _tmp41_, NULL);
						_g_free0 (output);
						output = _tmp42_;
					}
				}
				_g_free0 (address);
			}
		}
	}
	result = output;
	_g_object_unref0 (addresses);
	_g_object_unref0 (added_addresses);
	_g_object_unref0 (own_addresses);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
mail_utils_escape_html_tags (const gchar* input)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = string_replace (input, "<", "&lt;");
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (_tmp1_, ">", "&gt;");
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

gchar*
mail_utils_strip_folder_full_name (const gchar* service_uid,
                                   const gchar* folder_uri)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	g_return_val_if_fail (service_uid != NULL, NULL);
	if (folder_uri != NULL) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = string_strip (folder_uri);
		_tmp2_ = _tmp1_;
		_tmp0_ = g_strcmp0 (_tmp2_, "") != 0;
		_g_free0 (_tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = g_strdup_printf ("folder://%s/", service_uid);
		_tmp4_ = _tmp3_;
		_tmp5_ = string_replace (folder_uri, _tmp4_, "");
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		result = _tmp6_;
		return result;
	}
	result = NULL;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

CamelFolderInfoFlags
mail_utils_get_full_folder_info_flags (CamelService* service,
                                       CamelFolderInfo* folderinfo)
{
	CamelFolderInfoFlags full_flags = 0U;
	gchar* folder_uri = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	MailBackendSession* session = NULL;
	MailBackendSession* _tmp4_;
	MailBackendSession* _tmp5_;
	ESource* service_source = NULL;
	MailBackendSession* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	ESource* _tmp9_;
	gboolean _tmp10_ = FALSE;
	ESource* _tmp11_;
	CamelFolderInfoFlags result;
	g_return_val_if_fail (service != NULL, 0U);
	g_return_val_if_fail (folderinfo != NULL, 0U);
	full_flags = folderinfo->flags;
	_tmp0_ = camel_service_get_uid (service);
	_tmp1_ = _tmp0_;
	_tmp2_ = folderinfo->full_name;
	_tmp3_ = mail_utils_build_folder_uri (_tmp1_, _tmp2_);
	folder_uri = _tmp3_;
	_tmp4_ = mail_backend_session_get_default ();
	_tmp5_ = _g_object_ref0 (_tmp4_);
	session = _tmp5_;
	_tmp6_ = session;
	_tmp7_ = camel_service_get_uid (service);
	_tmp8_ = _tmp7_;
	_tmp9_ = mail_backend_session_ref_source (_tmp6_, _tmp8_);
	service_source = _tmp9_;
	_tmp11_ = service_source;
	if (_tmp11_ != NULL) {
		ESource* _tmp12_;
		_tmp12_ = service_source;
		_tmp10_ = e_source_has_extension (_tmp12_, E_SOURCE_EXTENSION_MAIL_ACCOUNT);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		ESourceMailAccount* mail_account_extension = NULL;
		ESource* _tmp13_;
		ESourceExtension* _tmp14_;
		ESourceMailAccount* _tmp15_;
		ESourceMailAccount* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gboolean _tmp20_;
		gchar* identity_uid = NULL;
		ESourceMailAccount* _tmp21_;
		gchar* _tmp22_;
		ESource* identity_source = NULL;
		MailBackendSession* _tmp23_;
		const gchar* _tmp24_;
		ESource* _tmp25_;
		ESource* _tmp26_;
		_tmp13_ = service_source;
		_tmp14_ = e_source_get_extension (_tmp13_, E_SOURCE_EXTENSION_MAIL_ACCOUNT);
		_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, e_source_mail_account_get_type (), ESourceMailAccount));
		mail_account_extension = _tmp15_;
		_tmp16_ = mail_account_extension;
		_tmp17_ = e_source_mail_account_dup_archive_folder (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = folder_uri;
		_tmp20_ = g_strcmp0 (_tmp18_, _tmp19_) == 0;
		_g_free0 (_tmp18_);
		if (_tmp20_) {
			full_flags = full_flags | CAMEL_FOLDER_TYPE_ARCHIVE;
		}
		_tmp21_ = mail_account_extension;
		_tmp22_ = e_source_mail_account_dup_identity_uid (_tmp21_);
		identity_uid = _tmp22_;
		_tmp23_ = session;
		_tmp24_ = identity_uid;
		_tmp25_ = mail_backend_session_ref_source (_tmp23_, _tmp24_);
		identity_source = _tmp25_;
		_tmp26_ = identity_source;
		if (_tmp26_ != NULL) {
			ESourceMailComposition* mail_composition_extension = NULL;
			ESource* _tmp27_;
			ESourceExtension* _tmp28_;
			ESourceMailComposition* _tmp29_;
			ESourceMailSubmission* mail_submission_extension = NULL;
			ESource* _tmp30_;
			ESourceExtension* _tmp31_;
			ESourceMailSubmission* _tmp32_;
			gboolean _tmp33_ = FALSE;
			ESourceMailComposition* _tmp34_;
			_tmp27_ = identity_source;
			_tmp28_ = e_source_get_extension (_tmp27_, E_SOURCE_EXTENSION_MAIL_COMPOSITION);
			_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, e_source_mail_composition_get_type (), ESourceMailComposition));
			mail_composition_extension = _tmp29_;
			_tmp30_ = identity_source;
			_tmp31_ = e_source_get_extension (_tmp30_, E_SOURCE_EXTENSION_MAIL_SUBMISSION);
			_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, e_source_mail_submission_get_type (), ESourceMailSubmission));
			mail_submission_extension = _tmp32_;
			_tmp34_ = mail_composition_extension;
			if (_tmp34_ != NULL) {
				ESourceMailComposition* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				const gchar* _tmp38_;
				_tmp35_ = mail_composition_extension;
				_tmp36_ = e_source_mail_composition_dup_drafts_folder (_tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = folder_uri;
				_tmp33_ = g_strcmp0 (_tmp37_, _tmp38_) == 0;
				_g_free0 (_tmp37_);
			} else {
				_tmp33_ = FALSE;
			}
			if (_tmp33_) {
				full_flags = full_flags | CAMEL_FOLDER_TYPE_DRAFTS;
			} else {
				gboolean _tmp39_ = FALSE;
				ESourceMailSubmission* _tmp40_;
				_tmp40_ = mail_submission_extension;
				if (_tmp40_ != NULL) {
					ESourceMailSubmission* _tmp41_;
					gchar* _tmp42_;
					gchar* _tmp43_;
					const gchar* _tmp44_;
					_tmp41_ = mail_submission_extension;
					_tmp42_ = e_source_mail_submission_dup_sent_folder (_tmp41_);
					_tmp43_ = _tmp42_;
					_tmp44_ = folder_uri;
					_tmp39_ = g_strcmp0 (_tmp43_, _tmp44_) == 0;
					_g_free0 (_tmp43_);
				} else {
					_tmp39_ = FALSE;
				}
				if (_tmp39_) {
					full_flags = full_flags | CAMEL_FOLDER_TYPE_SENT;
				}
			}
			_g_object_unref0 (mail_submission_extension);
			_g_object_unref0 (mail_composition_extension);
		}
		_g_object_unref0 (identity_source);
		_g_free0 (identity_uid);
		_g_object_unref0 (mail_account_extension);
	}
	result = full_flags;
	_g_object_unref0 (service_source);
	_g_object_unref0 (session);
	_g_free0 (folder_uri);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
mail_utils_build_folder_uri (const gchar* service_uid,
                             const gchar* folder_name)
{
	gchar* normed_folder_name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* encoded_service_uid = NULL;
	gchar* _tmp4_;
	gchar* encoded_normed_folder_name = NULL;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (service_uid != NULL, NULL);
	g_return_val_if_fail (folder_name != NULL, NULL);
	_tmp0_ = g_strdup (folder_name);
	normed_folder_name = _tmp0_;
	_tmp1_ = normed_folder_name;
	if (g_str_has_prefix (_tmp1_, "/")) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = normed_folder_name;
		_tmp3_ = string_substring (_tmp2_, (glong) 1, (glong) -1);
		_g_free0 (normed_folder_name);
		normed_folder_name = _tmp3_;
	}
	_tmp4_ = camel_url_encode (service_uid, ":;@/");
	encoded_service_uid = _tmp4_;
	_tmp5_ = normed_folder_name;
	_tmp6_ = camel_url_encode (_tmp5_, ":;@?#");
	encoded_normed_folder_name = _tmp6_;
	_tmp7_ = g_strdup_printf ("folder://%s/%s", encoded_service_uid, encoded_normed_folder_name);
	result = _tmp7_;
	_g_free0 (encoded_normed_folder_name);
	_g_free0 (encoded_service_uid);
	_g_free0 (normed_folder_name);
	return result;
}

MailUtils*
mail_utils_construct (GType object_type)
{
	MailUtils* self = NULL;
	self = (MailUtils*) g_type_create_instance (object_type);
	return self;
}

MailUtils*
mail_utils_new (void)
{
	return mail_utils_construct (MAIL_TYPE_UTILS);
}

static void
mail_value_utils_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
mail_value_utils_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		mail_utils_unref (value->data[0].v_pointer);
	}
}

static void
mail_value_utils_copy_value (const GValue* src_value,
                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = mail_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
mail_value_utils_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
mail_value_utils_collect_value (GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		MailUtils * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = mail_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
mail_value_utils_lcopy_value (const GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	MailUtils ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = mail_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
mail_param_spec_utils (const gchar* name,
                       const gchar* nick,
                       const gchar* blurb,
                       GType object_type,
                       GParamFlags flags)
{
	MailParamSpecUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, MAIL_TYPE_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
mail_value_get_utils (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, MAIL_TYPE_UTILS), NULL);
	return value->data[0].v_pointer;
}

void
mail_value_set_utils (GValue* value,
                      gpointer v_object)
{
	MailUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, MAIL_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, MAIL_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		mail_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		mail_utils_unref (old);
	}
}

void
mail_value_take_utils (GValue* value,
                       gpointer v_object)
{
	MailUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, MAIL_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, MAIL_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		mail_utils_unref (old);
	}
}

static void
mail_utils_class_init (MailUtilsClass * klass,
                       gpointer klass_data)
{
	mail_utils_parent_class = g_type_class_peek_parent (klass);
	((MailUtilsClass *) klass)->finalize = mail_utils_finalize;
}

static void
mail_utils_instance_init (MailUtils * self,
                          gpointer klass)
{
	self->ref_count = 1;
}

static void
mail_utils_finalize (MailUtils * obj)
{
	MailUtils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_UTILS, MailUtils);
	g_signal_handlers_destroy (self);
}

static GType
mail_utils_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { mail_value_utils_init, mail_value_utils_free_value, mail_value_utils_copy_value, mail_value_utils_peek_pointer, "p", mail_value_utils_collect_value, "p", mail_value_utils_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (MailUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailUtils), 0, (GInstanceInitFunc) mail_utils_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType mail_utils_type_id;
	mail_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MailUtils", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return mail_utils_type_id;
}

GType
mail_utils_get_type (void)
{
	static volatile gsize mail_utils_type_id__once = 0;
	if (g_once_init_enter (&mail_utils_type_id__once)) {
		GType mail_utils_type_id;
		mail_utils_type_id = mail_utils_get_type_once ();
		g_once_init_leave (&mail_utils_type_id__once, mail_utils_type_id);
	}
	return mail_utils_type_id__once;
}

gpointer
mail_utils_ref (gpointer instance)
{
	MailUtils * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
mail_utils_unref (gpointer instance)
{
	MailUtils * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MAIL_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

