/* DBus.c generated by valac 0.56.17, the Vala compiler
 * generated from DBus.vala, do not modify */

/*
 * Copyright 2019-2023 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <canberra.h>
#include <canberra-gtk.h>

#define NOTIFICATIONS_SERVER_X_CANONICAL_PRIVATE_SYNCHRONOUS "x-canonical-private-synchronous"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define NOTIFICATIONS_TYPE_SERVER (notifications_server_get_type ())
#define NOTIFICATIONS_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOTIFICATIONS_TYPE_SERVER, NotificationsServer))
#define NOTIFICATIONS_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOTIFICATIONS_TYPE_SERVER, NotificationsServerClass))
#define NOTIFICATIONS_IS_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOTIFICATIONS_TYPE_SERVER))
#define NOTIFICATIONS_IS_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOTIFICATIONS_TYPE_SERVER))
#define NOTIFICATIONS_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOTIFICATIONS_TYPE_SERVER, NotificationsServerClass))

typedef struct _NotificationsServer NotificationsServer;
typedef struct _NotificationsServerClass NotificationsServerClass;
typedef struct _NotificationsServerPrivate NotificationsServerPrivate;

#define NOTIFICATIONS_FDO_TYPE_ACTION_GROUP (notifications_fdo_action_group_get_type ())
#define NOTIFICATIONS_FDO_ACTION_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOTIFICATIONS_FDO_TYPE_ACTION_GROUP, NotificationsFdoActionGroup))
#define NOTIFICATIONS_FDO_ACTION_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOTIFICATIONS_FDO_TYPE_ACTION_GROUP, NotificationsFdoActionGroupClass))
#define NOTIFICATIONS_FDO_IS_ACTION_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOTIFICATIONS_FDO_TYPE_ACTION_GROUP))
#define NOTIFICATIONS_FDO_IS_ACTION_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOTIFICATIONS_FDO_TYPE_ACTION_GROUP))
#define NOTIFICATIONS_FDO_ACTION_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOTIFICATIONS_FDO_TYPE_ACTION_GROUP, NotificationsFdoActionGroupClass))

typedef struct _NotificationsFdoActionGroup NotificationsFdoActionGroup;
typedef struct _NotificationsFdoActionGroupClass NotificationsFdoActionGroupClass;

#define NOTIFICATIONS_TYPE_ABSTRACT_BUBBLE (notifications_abstract_bubble_get_type ())
#define NOTIFICATIONS_ABSTRACT_BUBBLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOTIFICATIONS_TYPE_ABSTRACT_BUBBLE, NotificationsAbstractBubble))
#define NOTIFICATIONS_ABSTRACT_BUBBLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOTIFICATIONS_TYPE_ABSTRACT_BUBBLE, NotificationsAbstractBubbleClass))
#define NOTIFICATIONS_IS_ABSTRACT_BUBBLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOTIFICATIONS_TYPE_ABSTRACT_BUBBLE))
#define NOTIFICATIONS_IS_ABSTRACT_BUBBLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOTIFICATIONS_TYPE_ABSTRACT_BUBBLE))
#define NOTIFICATIONS_ABSTRACT_BUBBLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOTIFICATIONS_TYPE_ABSTRACT_BUBBLE, NotificationsAbstractBubbleClass))

typedef struct _NotificationsAbstractBubble NotificationsAbstractBubble;
typedef struct _NotificationsAbstractBubbleClass NotificationsAbstractBubbleClass;

#define NOTIFICATIONS_TYPE_BUBBLE (notifications_bubble_get_type ())
#define NOTIFICATIONS_BUBBLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOTIFICATIONS_TYPE_BUBBLE, NotificationsBubble))
#define NOTIFICATIONS_BUBBLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOTIFICATIONS_TYPE_BUBBLE, NotificationsBubbleClass))
#define NOTIFICATIONS_IS_BUBBLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOTIFICATIONS_TYPE_BUBBLE))
#define NOTIFICATIONS_IS_BUBBLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOTIFICATIONS_TYPE_BUBBLE))
#define NOTIFICATIONS_BUBBLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOTIFICATIONS_TYPE_BUBBLE, NotificationsBubbleClass))

typedef struct _NotificationsBubble NotificationsBubble;
typedef struct _NotificationsBubbleClass NotificationsBubbleClass;

#define NOTIFICATIONS_TYPE_CONFIRMATION (notifications_confirmation_get_type ())
#define NOTIFICATIONS_CONFIRMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOTIFICATIONS_TYPE_CONFIRMATION, NotificationsConfirmation))
#define NOTIFICATIONS_CONFIRMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOTIFICATIONS_TYPE_CONFIRMATION, NotificationsConfirmationClass))
#define NOTIFICATIONS_IS_CONFIRMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOTIFICATIONS_TYPE_CONFIRMATION))
#define NOTIFICATIONS_IS_CONFIRMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOTIFICATIONS_TYPE_CONFIRMATION))
#define NOTIFICATIONS_CONFIRMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOTIFICATIONS_TYPE_CONFIRMATION, NotificationsConfirmationClass))

typedef struct _NotificationsConfirmation NotificationsConfirmation;
typedef struct _NotificationsConfirmationClass NotificationsConfirmationClass;
enum  {
	NOTIFICATIONS_SERVER_0_PROPERTY,
	NOTIFICATIONS_SERVER_NUM_PROPERTIES
};
static GParamSpec* notifications_server_properties[NOTIFICATIONS_SERVER_NUM_PROPERTIES];
typedef enum  {
	NOTIFICATIONS_SERVER_CLOSE_REASON_EXPIRED = 1,
	NOTIFICATIONS_SERVER_CLOSE_REASON_DISMISSED = 2,
	NOTIFICATIONS_SERVER_CLOSE_REASON_CLOSE_NOTIFICATION_CALL = 3,
	NOTIFICATIONS_SERVER_CLOSE_REASON_UNDEFINED = 4
} NotificationsServerCloseReason;

#define NOTIFICATIONS_SERVER_TYPE_CLOSE_REASON (notifications_server_close_reason_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;

#define NOTIFICATIONS_TYPE_NOTIFICATION (notifications_notification_get_type ())
#define NOTIFICATIONS_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOTIFICATIONS_TYPE_NOTIFICATION, NotificationsNotification))
#define NOTIFICATIONS_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOTIFICATIONS_TYPE_NOTIFICATION, NotificationsNotificationClass))
#define NOTIFICATIONS_IS_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOTIFICATIONS_TYPE_NOTIFICATION))
#define NOTIFICATIONS_IS_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOTIFICATIONS_TYPE_NOTIFICATION))
#define NOTIFICATIONS_NOTIFICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOTIFICATIONS_TYPE_NOTIFICATION, NotificationsNotificationClass))

typedef struct _NotificationsNotification NotificationsNotification;
typedef struct _NotificationsNotificationClass NotificationsNotificationClass;

#define NOTIFICATIONS_NOTIFICATION_TYPE_BUTTON (notifications_notification_button_get_type ())
typedef struct _NotificationsNotificationButton NotificationsNotificationButton;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _ca_proplist_destroy0(var) ((var == NULL) ? NULL : (var = (ca_proplist_destroy (var), NULL)))
enum  {
	NOTIFICATIONS_SERVER_ACTION_INVOKED_SIGNAL,
	NOTIFICATIONS_SERVER_NOTIFICATION_CLOSED_SIGNAL,
	NOTIFICATIONS_SERVER_NUM_SIGNALS
};
static guint notifications_server_signals[NOTIFICATIONS_SERVER_NUM_SIGNALS] = {0};
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _NotificationsServer {
	GObject parent_instance;
	NotificationsServerPrivate * priv;
};

struct _NotificationsServerClass {
	GObjectClass parent_class;
};

struct _NotificationsServerPrivate {
	guint32 id_counter;
	GDBusConnection* connection;
	NotificationsFdoActionGroup* action_group;
	GeeMap* bubbles;
	NotificationsConfirmation* confirmation;
	GSettings* settings;
	guint action_group_id;
	guint server_id;
};

struct _Block1Data {
	int _ref_count_;
	NotificationsServer* self;
	guint32 id;
};

struct _NotificationsNotificationButton {
	gchar* label;
	gchar* action_name;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	GSettings* app_settings;
};

static gint NotificationsServer_private_offset;
static gpointer notifications_server_parent_class = NULL;

VALA_EXTERN GType notifications_server_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotificationsServer, g_object_unref)
VALA_EXTERN guint notifications_server_register_object (void* object,
                                            GDBusConnection* connection,
                                            const gchar* path,
                                            GError** error);
VALA_EXTERN GType notifications_fdo_action_group_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotificationsFdoActionGroup, g_object_unref)
VALA_EXTERN GType notifications_abstract_bubble_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotificationsAbstractBubble, g_object_unref)
VALA_EXTERN GType notifications_bubble_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotificationsBubble, g_object_unref)
VALA_EXTERN GType notifications_confirmation_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotificationsConfirmation, g_object_unref)
VALA_EXTERN GType notifications_server_close_reason_get_type (void) G_GNUC_CONST ;
VALA_EXTERN NotificationsServer* notifications_server_new (GDBusConnection* connection,
                                               GError** error);
VALA_EXTERN NotificationsServer* notifications_server_construct (GType object_type,
                                                     GDBusConnection* connection,
                                                     GError** error);
VALA_EXTERN NotificationsFdoActionGroup* notifications_fdo_action_group_new (NotificationsServer* server);
VALA_EXTERN NotificationsFdoActionGroup* notifications_fdo_action_group_construct (GType object_type,
                                                                       NotificationsServer* server);
static void __lambda6_ (NotificationsServer* self,
                 guint32 id);
static void notifications_server_close_bubble (NotificationsServer* self,
                                        guint32 id);
static void ___lambda6__notifications_server_action_invoked (NotificationsServer* _sender,
                                                      guint32 id,
                                                      const gchar* action_key,
                                                      gpointer self);
static void __lambda7_ (NotificationsServer* self,
                 guint32 id);
static void ___lambda7__notifications_server_notification_closed (NotificationsServer* _sender,
                                                           guint32 id,
                                                           guint32 reason,
                                                           gpointer self);
VALA_EXTERN void notifications_fdo_action_group_remove_actions (NotificationsFdoActionGroup* self,
                                                    guint32 id);
VALA_EXTERN void notifications_server_close_notification (NotificationsServer* self,
                                              guint32 id,
                                              GError** error);
VALA_EXTERN gchar** notifications_server_get_capabilities (NotificationsServer* self,
                                               gint* result_length1,
                                               GError** error);
VALA_EXTERN void notifications_server_get_server_information (NotificationsServer* self,
                                                  gchar** name,
                                                  gchar** vendor,
                                                  gchar** version,
                                                  gchar** spec_version,
                                                  GError** error);
VALA_EXTERN guint32 notifications_server_notify (NotificationsServer* self,
                                     const gchar* app_name,
                                     guint32 replaces_id,
                                     const gchar* app_icon,
                                     const gchar* summary,
                                     const gchar* body,
                                     gchar** actions,
                                     gint actions_length1,
                                     GHashTable* hints,
                                     gint32 expire_timeout,
                                     const char* sender,
                                     GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void notifications_server_send_confirmation (NotificationsServer* self,
                                             const gchar* icon_name,
                                             GHashTable* hints);
VALA_EXTERN GType notifications_notification_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotificationsNotification, g_object_unref)
VALA_EXTERN NotificationsNotification* notifications_notification_new (const gchar* app_name,
                                                           const gchar* app_icon,
                                                           const gchar* summary,
                                                           const gchar* body,
                                                           GHashTable* hints);
VALA_EXTERN NotificationsNotification* notifications_notification_construct (GType object_type,
                                                                 const gchar* app_name,
                                                                 const gchar* app_icon,
                                                                 const gchar* summary,
                                                                 const gchar* body,
                                                                 GHashTable* hints);
VALA_EXTERN GType notifications_notification_button_get_type (void) G_GNUC_CONST ;
VALA_EXTERN NotificationsNotificationButton* notifications_notification_button_dup (const NotificationsNotificationButton* self);
VALA_EXTERN void notifications_notification_button_free (NotificationsNotificationButton* self);
VALA_EXTERN void notifications_notification_button_copy (const NotificationsNotificationButton* self,
                                             NotificationsNotificationButton* dest);
VALA_EXTERN void notifications_notification_button_destroy (NotificationsNotificationButton* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (NotificationsNotificationButton, notifications_notification_button_destroy)
static void _notifications_notification_button_free0_ (gpointer var);
VALA_EXTERN void notifications_notification_set_buttons (NotificationsNotification* self,
                                             GPtrArray* value);
VALA_EXTERN const gchar* notifications_fdo_action_group_add_action (NotificationsFdoActionGroup* self,
                                                        guint32 id,
                                                        const gchar* action);
VALA_EXTERN void notifications_notification_set_default_action_name (NotificationsNotification* self,
                                                         const gchar* value);
VALA_EXTERN GPtrArray* notifications_notification_get_buttons (NotificationsNotification* self);
VALA_EXTERN GNotificationPriority notifications_notification_get_priority (NotificationsNotification* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
VALA_EXTERN const gchar* notifications_notification_get_app_id (NotificationsNotification* self);
VALA_EXTERN void notifications_bubble_set_notification (NotificationsBubble* self,
                                            NotificationsNotification* value);
VALA_EXTERN NotificationsBubble* notifications_bubble_new (NotificationsNotification* notification);
VALA_EXTERN NotificationsBubble* notifications_bubble_construct (GType object_type,
                                                     NotificationsNotification* notification);
static void ______lambda9_ (Block2Data* _data2_);
static void _______lambda9__gtk_widget_destroy (GtkWidget* _sender,
                                         gpointer self);
static void ______lambda10_ (Block2Data* _data2_,
                      guint32 res);
static void _______lambda10__notifications_abstract_bubble_closed (NotificationsAbstractBubble* _sender,
                                                            guint32 reason,
                                                            gpointer self);
VALA_EXTERN void notifications_abstract_bubble_present (NotificationsAbstractBubble* self);
static const gchar* notifications_server_category_to_sound_name (const gchar* category);
static void notifications_server_send_sound (NotificationsServer* self,
                                      const gchar* sound_name);
VALA_EXTERN NotificationsConfirmation* notifications_confirmation_new (const gchar* icon_name,
                                                           gdouble progress);
VALA_EXTERN NotificationsConfirmation* notifications_confirmation_construct (GType object_type,
                                                                 const gchar* icon_name,
                                                                 gdouble progress);
static void ___lambda8_ (NotificationsServer* self);
static void ____lambda8__gtk_widget_destroy (GtkWidget* _sender,
                                      gpointer self);
VALA_EXTERN void notifications_confirmation_set_icon_name (NotificationsConfirmation* self,
                                               const gchar* value);
VALA_EXTERN void notifications_confirmation_set_progress (NotificationsConfirmation* self,
                                              gdouble value);
static void g_cclosure_user_marshal_VOID__UINT_STRING (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static void notifications_server_finalize (GObject * obj);
static GType notifications_server_get_type_once (void);
static void _dbus_notifications_server_close_notification (NotificationsServer* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation);
static void _dbus_notifications_server_get_capabilities (NotificationsServer* self,
                                                  GVariant* _parameters_,
                                                  GDBusMethodInvocation* invocation);
static void _dbus_notifications_server_get_server_information (NotificationsServer* self,
                                                        GVariant* _parameters_,
                                                        GDBusMethodInvocation* invocation);
static void _dbus_notifications_server_notify (NotificationsServer* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation);
static void notifications_server_dbus_interface_method_call (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* method_name,
                                                      GVariant* parameters,
                                                      GDBusMethodInvocation* invocation,
                                                      gpointer user_data);
static GVariant* notifications_server_dbus_interface_get_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GError** error,
                                                            gpointer user_data);
static gboolean notifications_server_dbus_interface_set_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GVariant* value,
                                                           GError** error,
                                                           gpointer user_data);
static void _dbus_notifications_server_action_invoked (GObject* _sender,
                                                guint32 id,
                                                const gchar* action_key,
                                                gpointer* _data);
static void _dbus_notifications_server_notification_closed (GObject* _sender,
                                                     guint32 id,
                                                     guint32 reason,
                                                     gpointer* _data);
static void _notifications_server_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _notifications_server_dbus_arg_info_close_notification_id = {-1, "id", "u", NULL};
static const GDBusArgInfo * const _notifications_server_dbus_arg_info_close_notification_in[] = {&_notifications_server_dbus_arg_info_close_notification_id, NULL};
static const GDBusArgInfo * const _notifications_server_dbus_arg_info_close_notification_out[] = {NULL};
static const GDBusMethodInfo _notifications_server_dbus_method_info_close_notification = {-1, "CloseNotification", (GDBusArgInfo **) (&_notifications_server_dbus_arg_info_close_notification_in), (GDBusArgInfo **) (&_notifications_server_dbus_arg_info_close_notification_out), NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_get_capabilities_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _notifications_server_dbus_arg_info_get_capabilities_in[] = {NULL};
static const GDBusArgInfo * const _notifications_server_dbus_arg_info_get_capabilities_out[] = {&_notifications_server_dbus_arg_info_get_capabilities_result, NULL};
static const GDBusMethodInfo _notifications_server_dbus_method_info_get_capabilities = {-1, "GetCapabilities", (GDBusArgInfo **) (&_notifications_server_dbus_arg_info_get_capabilities_in), (GDBusArgInfo **) (&_notifications_server_dbus_arg_info_get_capabilities_out), NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_get_server_information_name = {-1, "name", "s", NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_get_server_information_vendor = {-1, "vendor", "s", NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_get_server_information_version = {-1, "version", "s", NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_get_server_information_spec_version = {-1, "spec_version", "s", NULL};
static const GDBusArgInfo * const _notifications_server_dbus_arg_info_get_server_information_in[] = {NULL};
static const GDBusArgInfo * const _notifications_server_dbus_arg_info_get_server_information_out[] = {&_notifications_server_dbus_arg_info_get_server_information_name, &_notifications_server_dbus_arg_info_get_server_information_vendor, &_notifications_server_dbus_arg_info_get_server_information_version, &_notifications_server_dbus_arg_info_get_server_information_spec_version, NULL};
static const GDBusMethodInfo _notifications_server_dbus_method_info_get_server_information = {-1, "GetServerInformation", (GDBusArgInfo **) (&_notifications_server_dbus_arg_info_get_server_information_in), (GDBusArgInfo **) (&_notifications_server_dbus_arg_info_get_server_information_out), NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_notify_app_name = {-1, "app_name", "s", NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_notify_replaces_id = {-1, "replaces_id", "u", NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_notify_app_icon = {-1, "app_icon", "s", NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_notify_summary = {-1, "summary", "s", NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_notify_body = {-1, "body", "s", NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_notify_actions = {-1, "actions", "as", NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_notify_hints = {-1, "hints", "a{sv}", NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_notify_expire_timeout = {-1, "expire_timeout", "i", NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_notify_result = {-1, "result", "u", NULL};
static const GDBusArgInfo * const _notifications_server_dbus_arg_info_notify_in[] = {&_notifications_server_dbus_arg_info_notify_app_name, &_notifications_server_dbus_arg_info_notify_replaces_id, &_notifications_server_dbus_arg_info_notify_app_icon, &_notifications_server_dbus_arg_info_notify_summary, &_notifications_server_dbus_arg_info_notify_body, &_notifications_server_dbus_arg_info_notify_actions, &_notifications_server_dbus_arg_info_notify_hints, &_notifications_server_dbus_arg_info_notify_expire_timeout, NULL};
static const GDBusArgInfo * const _notifications_server_dbus_arg_info_notify_out[] = {&_notifications_server_dbus_arg_info_notify_result, NULL};
static const GDBusMethodInfo _notifications_server_dbus_method_info_notify = {-1, "Notify", (GDBusArgInfo **) (&_notifications_server_dbus_arg_info_notify_in), (GDBusArgInfo **) (&_notifications_server_dbus_arg_info_notify_out), NULL};
static const GDBusMethodInfo * const _notifications_server_dbus_method_info[] = {&_notifications_server_dbus_method_info_close_notification, &_notifications_server_dbus_method_info_get_capabilities, &_notifications_server_dbus_method_info_get_server_information, &_notifications_server_dbus_method_info_notify, NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_action_invoked_id = {-1, "id", "u", NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_action_invoked_action_key = {-1, "action_key", "s", NULL};
static const GDBusArgInfo * const _notifications_server_dbus_arg_info_action_invoked[] = {&_notifications_server_dbus_arg_info_action_invoked_id, &_notifications_server_dbus_arg_info_action_invoked_action_key, NULL};
static const GDBusSignalInfo _notifications_server_dbus_signal_info_action_invoked = {-1, "ActionInvoked", (GDBusArgInfo **) (&_notifications_server_dbus_arg_info_action_invoked), NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_notification_closed_id = {-1, "id", "u", NULL};
static const GDBusArgInfo _notifications_server_dbus_arg_info_notification_closed_reason = {-1, "reason", "u", NULL};
static const GDBusArgInfo * const _notifications_server_dbus_arg_info_notification_closed[] = {&_notifications_server_dbus_arg_info_notification_closed_id, &_notifications_server_dbus_arg_info_notification_closed_reason, NULL};
static const GDBusSignalInfo _notifications_server_dbus_signal_info_notification_closed = {-1, "NotificationClosed", (GDBusArgInfo **) (&_notifications_server_dbus_arg_info_notification_closed), NULL};
static const GDBusSignalInfo * const _notifications_server_dbus_signal_info[] = {&_notifications_server_dbus_signal_info_action_invoked, &_notifications_server_dbus_signal_info_notification_closed, NULL};
static const GDBusPropertyInfo * const _notifications_server_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _notifications_server_dbus_interface_info = {-1, "org.freedesktop.Notifications", (GDBusMethodInfo **) (&_notifications_server_dbus_method_info), (GDBusSignalInfo **) (&_notifications_server_dbus_signal_info), (GDBusPropertyInfo **) (&_notifications_server_dbus_property_info), NULL};
static const GDBusInterfaceVTable _notifications_server_dbus_interface_vtable = {notifications_server_dbus_interface_method_call, notifications_server_dbus_interface_get_property, notifications_server_dbus_interface_set_property};

static inline gpointer
notifications_server_get_instance_private (NotificationsServer* self)
{
	return G_STRUCT_MEMBER_P (self, NotificationsServer_private_offset);
}

static GType
notifications_server_close_reason_get_type_once (void)
{
	static const GEnumValue values[] = {{NOTIFICATIONS_SERVER_CLOSE_REASON_EXPIRED, "NOTIFICATIONS_SERVER_CLOSE_REASON_EXPIRED", "expired"}, {NOTIFICATIONS_SERVER_CLOSE_REASON_DISMISSED, "NOTIFICATIONS_SERVER_CLOSE_REASON_DISMISSED", "dismissed"}, {NOTIFICATIONS_SERVER_CLOSE_REASON_CLOSE_NOTIFICATION_CALL, "NOTIFICATIONS_SERVER_CLOSE_REASON_CLOSE_NOTIFICATION_CALL", "close-notification-call"}, {NOTIFICATIONS_SERVER_CLOSE_REASON_UNDEFINED, "NOTIFICATIONS_SERVER_CLOSE_REASON_UNDEFINED", "undefined"}, {0, NULL, NULL}};
	GType notifications_server_close_reason_type_id;
	notifications_server_close_reason_type_id = g_enum_register_static ("NotificationsServerCloseReason", values);
	return notifications_server_close_reason_type_id;
}

GType
notifications_server_close_reason_get_type (void)
{
	static volatile gsize notifications_server_close_reason_type_id__once = 0;
	if (g_once_init_enter (&notifications_server_close_reason_type_id__once)) {
		GType notifications_server_close_reason_type_id;
		notifications_server_close_reason_type_id = notifications_server_close_reason_get_type_once ();
		g_once_init_leave (&notifications_server_close_reason_type_id__once, notifications_server_close_reason_type_id);
	}
	return notifications_server_close_reason_type_id__once;
}

static void
__lambda6_ (NotificationsServer* self,
            guint32 id)
{
	notifications_server_close_bubble (self, id);
}

static void
___lambda6__notifications_server_action_invoked (NotificationsServer* _sender,
                                                 guint32 id,
                                                 const gchar* action_key,
                                                 gpointer self)
{
	__lambda6_ ((NotificationsServer*) self, id);
}

static void
__lambda7_ (NotificationsServer* self,
            guint32 id)
{
	notifications_server_close_bubble (self, id);
}

static void
___lambda7__notifications_server_notification_closed (NotificationsServer* _sender,
                                                      guint32 id,
                                                      guint32 reason,
                                                      gpointer self)
{
	__lambda7_ ((NotificationsServer*) self, id);
}

NotificationsServer*
notifications_server_construct (GType object_type,
                                GDBusConnection* connection,
                                GError** error)
{
	NotificationsServer * self = NULL;
	GSettings* _tmp0_;
	GeeHashMap* _tmp1_;
	NotificationsFdoActionGroup* _tmp2_;
	guint _tmp3_ = 0U;
	guint _tmp4_;
	guint _tmp5_ = 0U;
	NotificationsFdoActionGroup* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (connection != NULL, NULL);
	self = (NotificationsServer*) g_object_new (object_type, NULL);
	_tmp0_ = g_settings_new ("io.elementary.notifications");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, NOTIFICATIONS_TYPE_BUBBLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->bubbles);
	self->priv->bubbles = (GeeMap*) _tmp1_;
	_tmp2_ = notifications_fdo_action_group_new (self);
	_g_object_unref0 (self->priv->action_group);
	self->priv->action_group = _tmp2_;
	_tmp4_ = notifications_server_register_object (self, connection, "/org/freedesktop/Notifications", &_inner_error0_);
	_tmp3_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	self->priv->server_id = _tmp3_;
	_tmp6_ = self->priv->action_group;
	_tmp5_ = g_dbus_connection_export_action_group (connection, "/org/freedesktop/Notifications", (GActionGroup*) _tmp6_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	self->priv->action_group_id = _tmp5_;
	self->priv->connection = connection;
	g_signal_connect_object (self, "action-invoked", (GCallback) ___lambda6__notifications_server_action_invoked, self, 0);
	g_signal_connect_object (self, "notification-closed", (GCallback) ___lambda7__notifications_server_notification_closed, self, 0);
	return self;
}

NotificationsServer*
notifications_server_new (GDBusConnection* connection,
                          GError** error)
{
	return notifications_server_construct (NOTIFICATIONS_TYPE_SERVER, connection, error);
}

static void
notifications_server_close_bubble (NotificationsServer* self,
                                   guint32 id)
{
	NotificationsBubble* bubble = NULL;
	GeeMap* _tmp0_;
	gpointer _tmp1_ = NULL;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bubbles;
	_tmp2_ = gee_map_unset (_tmp0_, (gpointer) ((guintptr) id), &_tmp1_);
	_g_object_unref0 (bubble);
	bubble = (NotificationsBubble*) _tmp1_;
	if (_tmp2_) {
		NotificationsBubble* _tmp3_;
		NotificationsFdoActionGroup* _tmp5_;
		_tmp3_ = bubble;
		if (_tmp3_ != NULL) {
			NotificationsBubble* _tmp4_;
			_tmp4_ = bubble;
			gtk_window_close ((GtkWindow*) _tmp4_);
		}
		_tmp5_ = self->priv->action_group;
		notifications_fdo_action_group_remove_actions (_tmp5_, id);
	}
	_g_object_unref0 (bubble);
}

void
notifications_server_close_notification (NotificationsServer* self,
                                         guint32 id,
                                         GError** error)
{
	GeeMap* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bubbles;
	if (!gee_map_has_key (_tmp0_, (gpointer) ((guintptr) id))) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "");
		_inner_error0_ = _tmp1_;
		if ((_inner_error0_->domain == G_DBUS_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	g_signal_emit (self, notifications_server_signals[NOTIFICATIONS_SERVER_NOTIFICATION_CLOSED_SIGNAL], 0, id, (guint32) NOTIFICATIONS_SERVER_CLOSE_REASON_CLOSE_NOTIFICATION_CALL);
}

gchar**
notifications_server_get_capabilities (NotificationsServer* self,
                                       gint* result_length1,
                                       GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("actions");
	_tmp1_ = g_strdup ("body");
	_tmp2_ = g_strdup ("body-markup");
	_tmp3_ = g_strdup (NOTIFICATIONS_SERVER_X_CANONICAL_PRIVATE_SYNCHRONOUS);
	_tmp4_ = g_new0 (gchar*, 4 + 1);
	_tmp4_[0] = _tmp0_;
	_tmp4_[1] = _tmp1_;
	_tmp4_[2] = _tmp2_;
	_tmp4_[3] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 4;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	return result;
}

void
notifications_server_get_server_information (NotificationsServer* self,
                                             gchar** name,
                                             gchar** vendor,
                                             gchar** version,
                                             gchar** spec_version,
                                             GError** error)
{
	gchar* _vala_name = NULL;
	gchar* _vala_vendor = NULL;
	gchar* _vala_version = NULL;
	gchar* _vala_spec_version = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("io.elementary.notifications");
	_g_free0 (_vala_name);
	_vala_name = _tmp0_;
	_tmp1_ = g_strdup ("elementaryOS");
	_g_free0 (_vala_vendor);
	_vala_vendor = _tmp1_;
	_tmp2_ = g_strdup ("0.1");
	_g_free0 (_vala_version);
	_vala_version = _tmp2_;
	_tmp3_ = g_strdup ("1.2");
	_g_free0 (_vala_spec_version);
	_vala_spec_version = _tmp3_;
	if (name) {
		*name = _vala_name;
	} else {
		_g_free0 (_vala_name);
	}
	if (vendor) {
		*vendor = _vala_vendor;
	} else {
		_g_free0 (_vala_vendor);
	}
	if (version) {
		*version = _vala_version;
	} else {
		_g_free0 (_vala_version);
	}
	if (spec_version) {
		*spec_version = _vala_spec_version;
	} else {
		_g_free0 (_vala_spec_version);
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		NotificationsServer* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
_notifications_notification_button_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (notifications_notification_button_free (var), NULL));
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gpointer
_notifications_notification_button_dup0 (gpointer self)
{
	return self ? notifications_notification_button_dup (self) : NULL;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		NotificationsServer* self;
		self = _data2_->_data1_->self;
		_g_object_unref0 (_data2_->app_settings);
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}

static void
______lambda9_ (Block2Data* _data2_)
{
	Block1Data* _data1_;
	NotificationsServer* self;
	GeeMap* _tmp0_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	_tmp0_ = self->priv->bubbles;
	gee_map_set (_tmp0_, (gpointer) ((guintptr) _data1_->id), NULL);
}

static void
_______lambda9__gtk_widget_destroy (GtkWidget* _sender,
                                    gpointer self)
{
	______lambda9_ (self);
}

static void
______lambda10_ (Block2Data* _data2_,
                 guint32 res)
{
	Block1Data* _data1_;
	NotificationsServer* self;
	gboolean _tmp0_ = FALSE;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	if (res == ((guint32) NOTIFICATIONS_SERVER_CLOSE_REASON_EXPIRED)) {
		GSettings* _tmp1_;
		_tmp1_ = _data2_->app_settings;
		_tmp0_ = g_settings_get_boolean (_tmp1_, "remember");
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	g_signal_emit (self, notifications_server_signals[NOTIFICATIONS_SERVER_NOTIFICATION_CLOSED_SIGNAL], 0, _data1_->id, res);
}

static void
_______lambda10__notifications_abstract_bubble_closed (NotificationsAbstractBubble* _sender,
                                                       guint32 reason,
                                                       gpointer self)
{
	______lambda10_ (self, reason);
}

guint32
notifications_server_notify (NotificationsServer* self,
                             const gchar* app_name,
                             guint32 replaces_id,
                             const gchar* app_icon,
                             const gchar* summary,
                             const gchar* body,
                             gchar** actions,
                             gint actions_length1,
                             GHashTable* hints,
                             gint32 expire_timeout,
                             const char* sender,
                             GError** error)
{
	Block1Data* _data1_;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	guint32 _tmp11_ = 0U;
	GError* _inner_error0_ = NULL;
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (app_name != NULL, 0U);
	g_return_val_if_fail (app_icon != NULL, 0U);
	g_return_val_if_fail (summary != NULL, 0U);
	g_return_val_if_fail (body != NULL, 0U);
	g_return_val_if_fail (hints != NULL, 0U);
	g_return_val_if_fail (sender != NULL, 0U);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	if (g_hash_table_contains (hints, "desktop-entry")) {
		gconstpointer _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = g_hash_table_lookup (hints, "desktop-entry");
		_tmp6_ = g_variant_get_string ((GVariant*) _tmp5_, NULL);
		_tmp4_ = g_strcmp0 (_tmp6_, "gnome-power-panel") == 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = g_hash_table_contains (hints, "urgency");
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gconstpointer _tmp7_;
		_tmp7_ = g_hash_table_lookup (hints, "urgency");
		_tmp2_ = ((gint) g_variant_get_byte ((GVariant*) _tmp7_)) == 2;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = g_strcmp0 (app_icon, "") == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = expire_timeout == ((gint32) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GError* _tmp8_;
		g_debug ("DBus.vala:114: Blocked GSD notification");
		_tmp8_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "Notification Blocked");
		_inner_error0_ = _tmp8_;
		if ((_inner_error0_->domain == G_DBUS_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
			guint32 _tmp9_ = 0U;
			g_propagate_error (error, _inner_error0_);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return _tmp9_;
		} else {
			guint32 _tmp10_ = 0U;
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp10_;
		}
	}
	if (replaces_id != ((guint32) 0)) {
		_tmp11_ = replaces_id;
	} else {
		guint32 _tmp12_;
		self->priv->id_counter = self->priv->id_counter + 1;
		_tmp12_ = self->priv->id_counter;
		_tmp11_ = _tmp12_;
	}
	_data1_->id = _tmp11_;
	if (g_hash_table_contains (hints, NOTIFICATIONS_SERVER_X_CANONICAL_PRIVATE_SYNCHRONOUS)) {
		notifications_server_send_confirmation (self, app_icon, hints);
	} else {
		NotificationsNotification* notification = NULL;
		NotificationsNotification* _tmp13_;
		NotificationsNotification* _tmp14_;
		GPtrArray* _tmp15_;
		GPtrArray* _tmp16_;
		gboolean _tmp40_ = FALSE;
		GSettings* _tmp41_;
		_tmp13_ = notifications_notification_new (app_name, app_icon, summary, body, hints);
		notification = _tmp13_;
		_tmp14_ = notification;
		_tmp15_ = g_ptr_array_new_full ((guint) (actions_length1 / 2), _notifications_notification_button_free0_);
		_tmp16_ = _tmp15_;
		notifications_notification_set_buttons (_tmp14_, _tmp16_);
		_g_ptr_array_unref0 (_tmp16_);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp17_ = FALSE;
				_tmp17_ = TRUE;
				while (TRUE) {
					const gchar* _tmp18_;
					gchar* action_name = NULL;
					NotificationsFdoActionGroup* _tmp19_;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					const gchar* _tmp23_;
					gchar* label = NULL;
					const gchar* _tmp26_;
					gchar* _tmp27_;
					const gchar* _tmp28_;
					NotificationsNotification* _tmp30_;
					GPtrArray* _tmp31_;
					GPtrArray* _tmp32_;
					const gchar* _tmp33_;
					gchar* _tmp34_;
					const gchar* _tmp35_;
					gchar* _tmp36_;
					NotificationsNotificationButton _tmp37_ = {0};
					NotificationsNotificationButton _tmp38_;
					NotificationsNotificationButton* _tmp39_;
					if (!_tmp17_) {
						i += 2;
					}
					_tmp17_ = FALSE;
					if (!(i < actions_length1)) {
						break;
					}
					_tmp18_ = actions[i];
					if (g_strcmp0 (_tmp18_, "") == 0) {
						continue;
					}
					_tmp19_ = self->priv->action_group;
					_tmp20_ = actions[i];
					_tmp21_ = notifications_fdo_action_group_add_action (_tmp19_, _data1_->id, _tmp20_);
					_tmp22_ = g_strconcat ("fdo.", _tmp21_, NULL);
					action_name = _tmp22_;
					_tmp23_ = actions[i];
					if (g_strcmp0 (_tmp23_, "default") == 0) {
						NotificationsNotification* _tmp24_;
						const gchar* _tmp25_;
						_tmp24_ = notification;
						_tmp25_ = action_name;
						notifications_notification_set_default_action_name (_tmp24_, _tmp25_);
						_g_free0 (action_name);
						continue;
					}
					_tmp26_ = actions[i + 1];
					_tmp27_ = string_strip (_tmp26_);
					label = _tmp27_;
					_tmp28_ = label;
					if (g_strcmp0 (_tmp28_, "") == 0) {
						const gchar* _tmp29_;
						_tmp29_ = actions[i];
						g_warning ("DBus.vala:140: action '%s' sent without a label, skipping…", _tmp29_);
						_g_free0 (label);
						_g_free0 (action_name);
						continue;
					}
					_tmp30_ = notification;
					_tmp31_ = notifications_notification_get_buttons (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = label;
					_tmp34_ = g_strdup (_tmp33_);
					_tmp35_ = action_name;
					_tmp36_ = g_strdup (_tmp35_);
					_g_free0 (_tmp37_.label);
					_tmp37_.label = _tmp34_;
					_g_free0 (_tmp37_.action_name);
					_tmp37_.action_name = _tmp36_;
					_tmp38_ = _tmp37_;
					_tmp39_ = _notifications_notification_button_dup0 (&_tmp38_);
					g_ptr_array_add (_tmp32_, _tmp39_);
					notifications_notification_button_destroy (&_tmp38_);
					_g_free0 (label);
					_g_free0 (action_name);
				}
			}
		}
		_tmp41_ = self->priv->settings;
		if (!g_settings_get_boolean (_tmp41_, "do-not-disturb")) {
			_tmp40_ = TRUE;
		} else {
			NotificationsNotification* _tmp42_;
			GNotificationPriority _tmp43_;
			GNotificationPriority _tmp44_;
			_tmp42_ = notification;
			_tmp43_ = notifications_notification_get_priority (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp40_ = _tmp44_ == G_NOTIFICATION_PRIORITY_URGENT;
		}
		if (_tmp40_) {
			Block2Data* _data2_;
			GSettings* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			NotificationsNotification* _tmp49_;
			const gchar* _tmp50_;
			const gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			GSettings* _tmp54_;
			GSettings* _tmp55_;
			GSettings* _tmp56_;
			GSettings* _tmp83_;
			_data2_ = g_slice_new0 (Block2Data);
			_data2_->_ref_count_ = 1;
			_data2_->_data1_ = block1_data_ref (_data1_);
			_tmp45_ = self->priv->settings;
			g_object_get (_tmp45_, "path", &_tmp46_, NULL);
			_tmp47_ = _tmp46_;
			_tmp48_ = _tmp47_;
			_tmp49_ = notification;
			_tmp50_ = notifications_notification_get_app_id (_tmp49_);
			_tmp51_ = _tmp50_;
			_tmp52_ = g_strconcat (_tmp48_, "applications", "/", _tmp51_, "/", NULL);
			_tmp53_ = _tmp52_;
			_tmp54_ = g_settings_new_with_path ("io.elementary.notifications.applications", _tmp53_);
			_tmp55_ = _tmp54_;
			_g_free0 (_tmp53_);
			_g_free0 (_tmp48_);
			_data2_->app_settings = _tmp55_;
			_tmp56_ = _data2_->app_settings;
			if (g_settings_get_boolean (_tmp56_, "bubbles")) {
				gboolean _tmp57_ = FALSE;
				GeeMap* _tmp58_;
				GeeMap* _tmp80_;
				gpointer _tmp81_;
				NotificationsBubble* _tmp82_;
				_tmp58_ = self->priv->bubbles;
				if (gee_map_has_key (_tmp58_, (gpointer) ((guintptr) _data1_->id))) {
					GeeMap* _tmp59_;
					gpointer _tmp60_;
					NotificationsBubble* _tmp61_;
					_tmp59_ = self->priv->bubbles;
					_tmp60_ = gee_map_get (_tmp59_, (gpointer) ((guintptr) _data1_->id));
					_tmp61_ = (NotificationsBubble*) _tmp60_;
					_tmp57_ = _tmp61_ != NULL;
					_g_object_unref0 (_tmp61_);
				} else {
					_tmp57_ = FALSE;
				}
				if (_tmp57_) {
					GeeMap* _tmp62_;
					gpointer _tmp63_;
					NotificationsBubble* _tmp64_;
					NotificationsNotification* _tmp65_;
					_tmp62_ = self->priv->bubbles;
					_tmp63_ = gee_map_get (_tmp62_, (gpointer) ((guintptr) _data1_->id));
					_tmp64_ = (NotificationsBubble*) _tmp63_;
					_tmp65_ = notification;
					notifications_bubble_set_notification (_tmp64_, _tmp65_);
					_g_object_unref0 (_tmp64_);
				} else {
					GeeMap* _tmp66_;
					NotificationsNotification* _tmp67_;
					NotificationsBubble* _tmp68_;
					NotificationsBubble* _tmp69_;
					GeeMap* _tmp70_;
					gpointer _tmp71_;
					NotificationsBubble* _tmp72_;
					NotificationsFdoActionGroup* _tmp73_;
					GeeMap* _tmp74_;
					gpointer _tmp75_;
					NotificationsBubble* _tmp76_;
					GeeMap* _tmp77_;
					gpointer _tmp78_;
					NotificationsBubble* _tmp79_;
					_tmp66_ = self->priv->bubbles;
					_tmp67_ = notification;
					_tmp68_ = notifications_bubble_new (_tmp67_);
					g_object_ref_sink (_tmp68_);
					_tmp69_ = _tmp68_;
					gee_map_set (_tmp66_, (gpointer) ((guintptr) _data1_->id), _tmp69_);
					_g_object_unref0 (_tmp69_);
					_tmp70_ = self->priv->bubbles;
					_tmp71_ = gee_map_get (_tmp70_, (gpointer) ((guintptr) _data1_->id));
					_tmp72_ = (NotificationsBubble*) _tmp71_;
					_tmp73_ = self->priv->action_group;
					gtk_widget_insert_action_group ((GtkWidget*) _tmp72_, "fdo", (GActionGroup*) _tmp73_);
					_g_object_unref0 (_tmp72_);
					_tmp74_ = self->priv->bubbles;
					_tmp75_ = gee_map_get (_tmp74_, (gpointer) ((guintptr) _data1_->id));
					_tmp76_ = (NotificationsBubble*) _tmp75_;
					g_signal_connect_data ((GtkWidget*) _tmp76_, "destroy", (GCallback) _______lambda9__gtk_widget_destroy, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
					_g_object_unref0 (_tmp76_);
					_tmp77_ = self->priv->bubbles;
					_tmp78_ = gee_map_get (_tmp77_, (gpointer) ((guintptr) _data1_->id));
					_tmp79_ = (NotificationsBubble*) _tmp78_;
					g_signal_connect_data ((NotificationsAbstractBubble*) _tmp79_, "closed", (GCallback) _______lambda10__notifications_abstract_bubble_closed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
					_g_object_unref0 (_tmp79_);
				}
				_tmp80_ = self->priv->bubbles;
				_tmp81_ = gee_map_get (_tmp80_, (gpointer) ((guintptr) _data1_->id));
				_tmp82_ = (NotificationsBubble*) _tmp81_;
				notifications_abstract_bubble_present ((NotificationsAbstractBubble*) _tmp82_);
				_g_object_unref0 (_tmp82_);
			}
			_tmp83_ = _data2_->app_settings;
			if (g_settings_get_boolean (_tmp83_, "sounds")) {
				const gchar* _tmp84_ = NULL;
				NotificationsNotification* _tmp85_;
				GNotificationPriority _tmp86_;
				GNotificationPriority _tmp87_;
				gchar* sound = NULL;
				gchar* _tmp88_;
				gboolean _tmp89_ = FALSE;
				const gchar* _tmp96_;
				_tmp85_ = notification;
				_tmp86_ = notifications_notification_get_priority (_tmp85_);
				_tmp87_ = _tmp86_;
				if (_tmp87_ != G_NOTIFICATION_PRIORITY_URGENT) {
					_tmp84_ = "dialog-information";
				} else {
					_tmp84_ = "dialog-warning";
				}
				_tmp88_ = g_strdup (_tmp84_);
				sound = _tmp88_;
				if (g_hash_table_contains (hints, "category")) {
					gconstpointer _tmp90_;
					const GVariantType* _tmp91_;
					_tmp90_ = g_hash_table_lookup (hints, "category");
					_tmp91_ = G_VARIANT_TYPE_STRING;
					_tmp89_ = g_variant_is_of_type ((GVariant*) _tmp90_, _tmp91_);
				} else {
					_tmp89_ = FALSE;
				}
				if (_tmp89_) {
					gconstpointer _tmp92_;
					const gchar* _tmp93_;
					const gchar* _tmp94_;
					gchar* _tmp95_;
					_tmp92_ = g_hash_table_lookup (hints, "category");
					_tmp93_ = g_variant_get_string ((GVariant*) _tmp92_, NULL);
					_tmp94_ = notifications_server_category_to_sound_name (_tmp93_);
					_tmp95_ = g_strdup (_tmp94_);
					_g_free0 (sound);
					sound = _tmp95_;
				}
				_tmp96_ = sound;
				notifications_server_send_sound (self, _tmp96_);
				_g_free0 (sound);
			}
			block2_data_unref (_data2_);
			_data2_ = NULL;
		}
		_g_object_unref0 (notification);
	}
	result = _data1_->id;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static void
___lambda8_ (NotificationsServer* self)
{
	_g_object_unref0 (self->priv->confirmation);
	self->priv->confirmation = NULL;
}

static void
____lambda8__gtk_widget_destroy (GtkWidget* _sender,
                                 gpointer self)
{
	___lambda8_ ((NotificationsServer*) self);
}

static void
notifications_server_send_confirmation (NotificationsServer* self,
                                        const gchar* icon_name,
                                        GHashTable* hints)
{
	gdouble progress_value = 0.0;
	GVariant* val = NULL;
	gconstpointer _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	gchar* confirmation_type = NULL;
	gconstpointer _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	NotificationsConfirmation* _tmp8_;
	NotificationsConfirmation* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_name != NULL);
	g_return_if_fail (hints != NULL);
	_tmp0_ = g_hash_table_lookup (hints, "value");
	_tmp1_ = _g_variant_ref0 ((GVariant*) _tmp0_);
	val = _tmp1_;
	_tmp2_ = val;
	if (_tmp2_ != NULL) {
		GVariant* _tmp3_;
		_tmp3_ = val;
		progress_value = CLAMP (g_variant_get_int32 (_tmp3_), (gint32) 0, (gint32) 100) / 100.0;
	} else {
		progress_value = (gdouble) -1;
	}
	_tmp4_ = g_hash_table_lookup (hints, NOTIFICATIONS_SERVER_X_CANONICAL_PRIVATE_SYNCHRONOUS);
	_tmp5_ = g_variant_get_string ((GVariant*) _tmp4_, NULL);
	_tmp6_ = g_strdup (_tmp5_);
	confirmation_type = _tmp6_;
	_tmp7_ = confirmation_type;
	if (g_strcmp0 (_tmp7_, "indicator-sound") == 0) {
		notifications_server_send_sound (self, "audio-volume-change");
	}
	_tmp8_ = self->priv->confirmation;
	if (_tmp8_ == NULL) {
		NotificationsConfirmation* _tmp9_;
		NotificationsConfirmation* _tmp10_;
		_tmp9_ = notifications_confirmation_new (icon_name, progress_value);
		g_object_ref_sink (_tmp9_);
		_g_object_unref0 (self->priv->confirmation);
		self->priv->confirmation = _tmp9_;
		_tmp10_ = self->priv->confirmation;
		g_signal_connect_object ((GtkWidget*) _tmp10_, "destroy", (GCallback) ____lambda8__gtk_widget_destroy, self, 0);
	} else {
		NotificationsConfirmation* _tmp11_;
		NotificationsConfirmation* _tmp12_;
		_tmp11_ = self->priv->confirmation;
		notifications_confirmation_set_icon_name (_tmp11_, icon_name);
		_tmp12_ = self->priv->confirmation;
		notifications_confirmation_set_progress (_tmp12_, progress_value);
	}
	_tmp13_ = self->priv->confirmation;
	notifications_abstract_bubble_present ((NotificationsAbstractBubble*) _tmp13_);
	_g_free0 (confirmation_type);
	_g_variant_unref0 (val);
}

static void
notifications_server_send_sound (NotificationsServer* self,
                                 const gchar* sound_name)
{
	ca_proplist* props = NULL;
	ca_proplist* _tmp0_ = NULL;
	ca_proplist* _tmp1_;
	ca_proplist* _tmp2_;
	ca_context* _tmp3_;
	ca_proplist* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sound_name != NULL);
	if (g_strcmp0 (sound_name, "") == 0) {
		return;
	}
	ca_proplist_create (&_tmp0_);
	_ca_proplist_destroy0 (props);
	props = _tmp0_;
	_tmp1_ = props;
	ca_proplist_sets (_tmp1_, CA_PROP_CANBERRA_CACHE_CONTROL, "volatile");
	_tmp2_ = props;
	ca_proplist_sets (_tmp2_, CA_PROP_EVENT_ID, sound_name);
	_tmp3_ = ca_gtk_context_get ();
	_tmp4_ = props;
	ca_context_play_full (_tmp3_, (guint32) 0, _tmp4_, NULL, NULL);
	_ca_proplist_destroy0 (props);
}

static const gchar*
notifications_server_category_to_sound_name (const gchar* category)
{
	const gchar* sound = NULL;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	static GQuark _tmp1_label8 = 0;
	static GQuark _tmp1_label9 = 0;
	static GQuark _tmp1_label10 = 0;
	static GQuark _tmp1_label11 = 0;
	static GQuark _tmp1_label12 = 0;
	static GQuark _tmp1_label13 = 0;
	const gchar* _tmp3_;
	const gchar* result;
	g_return_val_if_fail (category != NULL, NULL);
	_tmp0_ = category;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("device.added")))) {
		switch (0) {
			default:
			{
				sound = "device-added";
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("device.removed")))) {
		switch (0) {
			default:
			{
				sound = "device-removed";
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("im")))) {
		switch (0) {
			default:
			{
				sound = "message";
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("im.received")))) {
		switch (0) {
			default:
			{
				sound = "message-new-instant";
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("network.connected")))) {
		switch (0) {
			default:
			{
				sound = "network-connectivity-established";
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("network.disconnected")))) {
		switch (0) {
			default:
			{
				sound = "network-connectivity-lost";
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("presence.online")))) {
		switch (0) {
			default:
			{
				sound = "service-login";
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("presence.offline")))) {
		switch (0) {
			default:
			{
				sound = "service-logout";
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label8) ? _tmp1_label8 : (_tmp1_label8 = g_quark_from_static_string ("x-gnome.music")))) {
		switch (0) {
			default:
			{
				sound = "";
				break;
			}
		}
	} else if (((((_tmp2_ == ((0 != _tmp1_label9) ? _tmp1_label9 : (_tmp1_label9 = g_quark_from_static_string ("device.error")))) || (_tmp2_ == ((0 != _tmp1_label10) ? _tmp1_label10 : (_tmp1_label10 = g_quark_from_static_string ("email.bounced"))))) || (_tmp2_ == ((0 != _tmp1_label11) ? _tmp1_label11 : (_tmp1_label11 = g_quark_from_static_string ("im.error"))))) || (_tmp2_ == ((0 != _tmp1_label12) ? _tmp1_label12 : (_tmp1_label12 = g_quark_from_static_string ("network.error"))))) || (_tmp2_ == ((0 != _tmp1_label13) ? _tmp1_label13 : (_tmp1_label13 = g_quark_from_static_string ("transfer.error"))))) {
		switch (0) {
			default:
			{
				sound = "dialog-error";
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				sound = "dialog-information";
				break;
			}
		}
	}
	_tmp3_ = sound;
	result = _tmp3_;
	return result;
}

static void
g_cclosure_user_marshal_VOID__UINT_STRING (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT_STRING) (gpointer data1, guint32 arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_string (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint32 arg_1, guint32 arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}

static void
notifications_server_class_init (NotificationsServerClass * klass,
                                 gpointer klass_data)
{
	notifications_server_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NotificationsServer_private_offset);
	G_OBJECT_CLASS (klass)->finalize = notifications_server_finalize;
	notifications_server_signals[NOTIFICATIONS_SERVER_ACTION_INVOKED_SIGNAL] = g_signal_new ("action-invoked", NOTIFICATIONS_TYPE_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_STRING, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_STRING);
	notifications_server_signals[NOTIFICATIONS_SERVER_NOTIFICATION_CLOSED_SIGNAL] = g_signal_new ("notification-closed", NOTIFICATIONS_TYPE_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
}

static void
notifications_server_instance_init (NotificationsServer * self,
                                    gpointer klass)
{
	self->priv = notifications_server_get_instance_private (self);
	self->priv->id_counter = (guint32) 0;
}

static void
notifications_server_finalize (GObject * obj)
{
	NotificationsServer * self;
	GDBusConnection* _tmp0_;
	GDBusConnection* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NOTIFICATIONS_TYPE_SERVER, NotificationsServer);
	_tmp0_ = self->priv->connection;
	g_dbus_connection_unexport_action_group (_tmp0_, self->priv->action_group_id);
	_tmp1_ = self->priv->connection;
	g_dbus_connection_unregister_object (_tmp1_, self->priv->server_id);
	_g_object_unref0 (self->priv->action_group);
	_g_object_unref0 (self->priv->bubbles);
	_g_object_unref0 (self->priv->confirmation);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (notifications_server_parent_class)->finalize (obj);
}

static GType
notifications_server_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NotificationsServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notifications_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotificationsServer), 0, (GInstanceInitFunc) notifications_server_instance_init, NULL };
	GType notifications_server_type_id;
	notifications_server_type_id = g_type_register_static (G_TYPE_OBJECT, "NotificationsServer", &g_define_type_info, 0);
	g_type_set_qdata (notifications_server_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) notifications_server_register_object);
	NotificationsServer_private_offset = g_type_add_instance_private (notifications_server_type_id, sizeof (NotificationsServerPrivate));
	return notifications_server_type_id;
}

GType
notifications_server_get_type (void)
{
	static volatile gsize notifications_server_type_id__once = 0;
	if (g_once_init_enter (&notifications_server_type_id__once)) {
		GType notifications_server_type_id;
		notifications_server_type_id = notifications_server_get_type_once ();
		g_once_init_leave (&notifications_server_type_id__once, notifications_server_type_id);
	}
	return notifications_server_type_id__once;
}

static void
_dbus_notifications_server_close_notification (NotificationsServer* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 id = 0U;
	GVariant* _tmp0_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_get_uint32 (_tmp0_);
	g_variant_unref (_tmp0_);
	notifications_server_close_notification (self, id, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_notifications_server_get_capabilities (NotificationsServer* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp1_;
	GVariantBuilder _tmp2_;
	gint _tmp3_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = notifications_server_get_capabilities (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp1_ = result;
	g_variant_builder_init (&_tmp2_, G_VARIANT_TYPE ("as"));
	for (_tmp3_ = 0; _tmp3_ < result_length1; _tmp3_++) {
		g_variant_builder_add_value (&_tmp2_, g_variant_new_string (*_tmp1_));
		_tmp1_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp2_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_notifications_server_get_server_information (NotificationsServer* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* name = NULL;
	gchar* vendor = NULL;
	gchar* version = NULL;
	gchar* spec_version = NULL;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	notifications_server_get_server_information (self, &name, &vendor, &version, &spec_version, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (name));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (vendor));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (version));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (spec_version));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_g_free0 (name);
	_g_free0 (vendor);
	_g_free0 (version);
	_g_free0 (spec_version);
}

static void
_dbus_notifications_server_notify (NotificationsServer* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* app_name = NULL;
	GVariant* _tmp4_;
	guint32 replaces_id = 0U;
	GVariant* _tmp5_;
	gchar* app_icon = NULL;
	GVariant* _tmp6_;
	gchar* summary = NULL;
	GVariant* _tmp7_;
	gchar* body = NULL;
	GVariant* _tmp8_;
	gchar** actions = NULL;
	gint actions_length1 = 0;
	GVariant* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length;
	gint _tmp10__size;
	gint _tmp10__length1;
	GVariantIter _tmp11_;
	GVariant* _tmp12_;
	GHashTable* hints = NULL;
	GVariant* _tmp13_;
	GHashTable* _tmp14_;
	GVariantIter _tmp15_;
	GVariant* _tmp16_;
	GVariant* _tmp17_;
	gint32 expire_timeout = 0;
	GVariant* _tmp18_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint32 result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	app_name = g_variant_dup_string (_tmp4_, NULL);
	g_variant_unref (_tmp4_);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	replaces_id = g_variant_get_uint32 (_tmp5_);
	g_variant_unref (_tmp5_);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	app_icon = g_variant_dup_string (_tmp6_, NULL);
	g_variant_unref (_tmp6_);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	summary = g_variant_dup_string (_tmp7_, NULL);
	g_variant_unref (_tmp7_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	body = g_variant_dup_string (_tmp8_, NULL);
	g_variant_unref (_tmp8_);
	_tmp9_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp10_ = g_new (gchar*, 5);
	_tmp10__length = 0;
	_tmp10__size = 4;
	_tmp10__length1 = 0;
	g_variant_iter_init (&_tmp11_, _tmp9_);
	for (; (_tmp12_ = g_variant_iter_next_value (&_tmp11_)) != NULL; _tmp10__length1++) {
		if (_tmp10__size == _tmp10__length) {
			_tmp10__size = 2 * _tmp10__size;
			_tmp10_ = g_renew (gchar*, _tmp10_, _tmp10__size + 1);
		}
		_tmp10_[_tmp10__length++] = g_variant_dup_string (_tmp12_, NULL);
		g_variant_unref (_tmp12_);
	}
	actions_length1 = _tmp10__length1;
	_tmp10_[_tmp10__length] = NULL;
	actions = _tmp10_;
	g_variant_unref (_tmp9_);
	_tmp13_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp14_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp15_, _tmp13_);
	while (g_variant_iter_loop (&_tmp15_, "{?*}", &_tmp16_, &_tmp17_)) {
		g_hash_table_insert (_tmp14_, g_variant_dup_string (_tmp16_, NULL), g_variant_get_variant (_tmp17_));
	}
	hints = _tmp14_;
	g_variant_unref (_tmp13_);
	_tmp18_ = g_variant_iter_next_value (&_arguments_iter);
	expire_timeout = g_variant_get_int32 (_tmp18_);
	g_variant_unref (_tmp18_);
	result = notifications_server_notify (self, app_name, replaces_id, app_icon, summary, body, actions, actions_length1, hints, expire_timeout, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (app_name);
	_g_free0 (app_icon);
	_g_free0 (summary);
	_g_free0 (body);
	actions = (_vala_array_free (actions, actions_length1, (GDestroyNotify) g_free), NULL);
	_g_hash_table_unref0 (hints);
	;
}

static void
notifications_server_dbus_interface_method_call (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* method_name,
                                                 GVariant* parameters,
                                                 GDBusMethodInvocation* invocation,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "CloseNotification") == 0) {
		_dbus_notifications_server_close_notification (object, parameters, invocation);
	} else if (strcmp (method_name, "GetCapabilities") == 0) {
		_dbus_notifications_server_get_capabilities (object, parameters, invocation);
	} else if (strcmp (method_name, "GetServerInformation") == 0) {
		_dbus_notifications_server_get_server_information (object, parameters, invocation);
	} else if (strcmp (method_name, "Notify") == 0) {
		_dbus_notifications_server_notify (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
notifications_server_dbus_interface_get_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GError** error,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
notifications_server_dbus_interface_set_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GVariant* value,
                                                  GError** error,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_notifications_server_action_invoked (GObject* _sender,
                                           guint32 id,
                                           const gchar* action_key,
                                           gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (action_key));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.Notifications", "ActionInvoked", _arguments, NULL);
}

static void
_dbus_notifications_server_notification_closed (GObject* _sender,
                                                guint32 id,
                                                guint32 reason,
                                                gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (reason));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.Notifications", "NotificationClosed", _arguments, NULL);
}

guint
notifications_server_register_object (gpointer object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_notifications_server_dbus_interface_info), &_notifications_server_dbus_interface_vtable, data, _notifications_server_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "action-invoked", (GCallback) _dbus_notifications_server_action_invoked, data);
	g_signal_connect (object, "notification-closed", (GCallback) _dbus_notifications_server_notification_closed, data);
	return result;
}

static void
_notifications_server_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_notifications_server_action_invoked, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_notifications_server_notification_closed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

