/* Notification.c generated by valac 0.56.17, the Vala compiler
 * generated from Notification.vala, do not modify */

/*
* Copyright 2020-2023 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
*/

#include <glib-object.h>
#include <gio/gdesktopappinfo.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#define NOTIFICATIONS_NOTIFICATION_OTHER_APP_ID "gala-other"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define NOTIFICATIONS_TYPE_NOTIFICATION (notifications_notification_get_type ())
#define NOTIFICATIONS_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOTIFICATIONS_TYPE_NOTIFICATION, NotificationsNotification))
#define NOTIFICATIONS_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOTIFICATIONS_TYPE_NOTIFICATION, NotificationsNotificationClass))
#define NOTIFICATIONS_IS_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOTIFICATIONS_TYPE_NOTIFICATION))
#define NOTIFICATIONS_IS_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOTIFICATIONS_TYPE_NOTIFICATION))
#define NOTIFICATIONS_NOTIFICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOTIFICATIONS_TYPE_NOTIFICATION, NotificationsNotificationClass))

typedef struct _NotificationsNotification NotificationsNotification;
typedef struct _NotificationsNotificationClass NotificationsNotificationClass;
typedef struct _NotificationsNotificationPrivate NotificationsNotificationPrivate;

#define NOTIFICATIONS_TYPE_MASKED_IMAGE (notifications_masked_image_get_type ())
#define NOTIFICATIONS_MASKED_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOTIFICATIONS_TYPE_MASKED_IMAGE, NotificationsMaskedImage))
#define NOTIFICATIONS_MASKED_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOTIFICATIONS_TYPE_MASKED_IMAGE, NotificationsMaskedImageClass))
#define NOTIFICATIONS_IS_MASKED_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOTIFICATIONS_TYPE_MASKED_IMAGE))
#define NOTIFICATIONS_IS_MASKED_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOTIFICATIONS_TYPE_MASKED_IMAGE))
#define NOTIFICATIONS_MASKED_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOTIFICATIONS_TYPE_MASKED_IMAGE, NotificationsMaskedImageClass))

typedef struct _NotificationsMaskedImage NotificationsMaskedImage;
typedef struct _NotificationsMaskedImageClass NotificationsMaskedImageClass;

#define NOTIFICATIONS_NOTIFICATION_TYPE_BUTTON (notifications_notification_button_get_type ())
typedef struct _NotificationsNotificationButton NotificationsNotificationButton;
enum  {
	NOTIFICATIONS_NOTIFICATION_0_PROPERTY,
	NOTIFICATIONS_NOTIFICATION_APP_INFO_PROPERTY,
	NOTIFICATIONS_NOTIFICATION_PRIORITY_PROPERTY,
	NOTIFICATIONS_NOTIFICATION_HINTS_PROPERTY,
	NOTIFICATIONS_NOTIFICATION_APP_ICON_PROPERTY,
	NOTIFICATIONS_NOTIFICATION_APP_ID_PROPERTY,
	NOTIFICATIONS_NOTIFICATION_APP_NAME_PROPERTY,
	NOTIFICATIONS_NOTIFICATION_BODY_PROPERTY,
	NOTIFICATIONS_NOTIFICATION_SUMMARY_PROPERTY,
	NOTIFICATIONS_NOTIFICATION_PRIMARY_ICON_PROPERTY,
	NOTIFICATIONS_NOTIFICATION_BADGE_ICON_PROPERTY,
	NOTIFICATIONS_NOTIFICATION_IMAGE_PROPERTY,
	NOTIFICATIONS_NOTIFICATION_DEFAULT_ACTION_NAME_PROPERTY,
	NOTIFICATIONS_NOTIFICATION_DEFAULT_ACTION_TARGET_PROPERTY,
	NOTIFICATIONS_NOTIFICATION_BUTTONS_PROPERTY,
	NOTIFICATIONS_NOTIFICATION_NUM_PROPERTIES
};
static GParamSpec* notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _NotificationsNotification {
	GObject parent_instance;
	NotificationsNotificationPrivate * priv;
};

struct _NotificationsNotificationClass {
	GObjectClass parent_class;
};

struct _NotificationsNotificationButton {
	gchar* label;
	gchar* action_name;
};

struct _NotificationsNotificationPrivate {
	GDesktopAppInfo* _app_info;
	GNotificationPriority _priority;
	GHashTable* _hints;
	gchar* _app_icon;
	gchar* _app_id;
	gchar* _app_name;
	gchar* _body;
	gchar* _summary;
	GIcon* _primary_icon;
	GIcon* _badge_icon;
	NotificationsMaskedImage* _image;
	gchar* _default_action_name;
	GVariant* _default_action_target;
	GPtrArray* _buttons;
};

static gint NotificationsNotification_private_offset;
static gpointer notifications_notification_parent_class = NULL;
static GRegex* notifications_notification_entity_regex;
static GRegex* notifications_notification_entity_regex = NULL;
static GRegex* notifications_notification_tag_regex;
static GRegex* notifications_notification_tag_regex = NULL;

VALA_EXTERN GType notifications_notification_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotificationsNotification, g_object_unref)
VALA_EXTERN GType notifications_masked_image_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotificationsMaskedImage, g_object_unref)
VALA_EXTERN GType notifications_notification_button_get_type (void) G_GNUC_CONST ;
VALA_EXTERN NotificationsNotificationButton* notifications_notification_button_dup (const NotificationsNotificationButton* self);
VALA_EXTERN void notifications_notification_button_free (NotificationsNotificationButton* self);
VALA_EXTERN void notifications_notification_button_copy (const NotificationsNotificationButton* self,
                                             NotificationsNotificationButton* dest);
VALA_EXTERN void notifications_notification_button_destroy (NotificationsNotificationButton* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (NotificationsNotificationButton, notifications_notification_button_destroy)
VALA_EXTERN NotificationsNotification* notifications_notification_new (const gchar* app_name,
                                                           const gchar* app_icon,
                                                           const gchar* summary,
                                                           const gchar* body,
                                                           GHashTable* hints);
VALA_EXTERN NotificationsNotification* notifications_notification_construct (GType object_type,
                                                                 const gchar* app_name,
                                                                 const gchar* app_icon,
                                                                 const gchar* summary,
                                                                 const gchar* body,
                                                                 GHashTable* hints);
static gchar* notifications_notification_fix_markup (NotificationsNotification* self,
                                              const gchar* markup);
static GdkPixbuf* notifications_notification_image_data_variant_to_pixbuf (NotificationsNotification* self,
                                                                    GVariant* img);
VALA_EXTERN GDesktopAppInfo* notifications_notification_get_app_info (NotificationsNotification* self);
static void notifications_notification_set_app_info (NotificationsNotification* self,
                                              GDesktopAppInfo* value);
VALA_EXTERN GNotificationPriority notifications_notification_get_priority (NotificationsNotification* self);
static void notifications_notification_set_priority (NotificationsNotification* self,
                                              GNotificationPriority value);
VALA_EXTERN GHashTable* notifications_notification_get_hints (NotificationsNotification* self);
static void notifications_notification_set_hints (NotificationsNotification* self,
                                           GHashTable* value);
VALA_EXTERN const gchar* notifications_notification_get_app_icon (NotificationsNotification* self);
static void notifications_notification_set_app_icon (NotificationsNotification* self,
                                              const gchar* value);
VALA_EXTERN const gchar* notifications_notification_get_app_id (NotificationsNotification* self);
static void notifications_notification_set_app_id (NotificationsNotification* self,
                                            const gchar* value);
VALA_EXTERN const gchar* notifications_notification_get_app_name (NotificationsNotification* self);
static void notifications_notification_set_app_name (NotificationsNotification* self,
                                              const gchar* value);
VALA_EXTERN const gchar* notifications_notification_get_body (NotificationsNotification* self);
VALA_EXTERN void notifications_notification_set_body (NotificationsNotification* self,
                                          const gchar* value);
VALA_EXTERN const gchar* notifications_notification_get_summary (NotificationsNotification* self);
VALA_EXTERN void notifications_notification_set_summary (NotificationsNotification* self,
                                             const gchar* value);
VALA_EXTERN GIcon* notifications_notification_get_primary_icon (NotificationsNotification* self);
VALA_EXTERN void notifications_notification_set_primary_icon (NotificationsNotification* self,
                                                  GIcon* value);
VALA_EXTERN GIcon* notifications_notification_get_badge_icon (NotificationsNotification* self);
VALA_EXTERN void notifications_notification_set_badge_icon (NotificationsNotification* self,
                                                GIcon* value);
VALA_EXTERN NotificationsMaskedImage* notifications_notification_get_image (NotificationsNotification* self);
VALA_EXTERN void notifications_notification_set_image (NotificationsNotification* self,
                                           NotificationsMaskedImage* value);
VALA_EXTERN const gchar* notifications_notification_get_default_action_name (NotificationsNotification* self);
VALA_EXTERN void notifications_notification_set_default_action_name (NotificationsNotification* self,
                                                         const gchar* value);
VALA_EXTERN GVariant* notifications_notification_get_default_action_target (NotificationsNotification* self);
VALA_EXTERN void notifications_notification_set_default_action_target (NotificationsNotification* self,
                                                           GVariant* value);
VALA_EXTERN GPtrArray* notifications_notification_get_buttons (NotificationsNotification* self);
VALA_EXTERN void notifications_notification_set_buttons (NotificationsNotification* self,
                                             GPtrArray* value);
static GObject * notifications_notification_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
VALA_EXTERN NotificationsMaskedImage* notifications_masked_image_new (GdkPixbuf* pixbuf);
VALA_EXTERN NotificationsMaskedImage* notifications_masked_image_construct (GType object_type,
                                                                GdkPixbuf* pixbuf);
static void notifications_notification_finalize (GObject * obj);
static GType notifications_notification_get_type_once (void);
static void _vala_notifications_notification_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_notifications_notification_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);

static inline gpointer
notifications_notification_get_instance_private (NotificationsNotification* self)
{
	return G_STRUCT_MEMBER_P (self, NotificationsNotification_private_offset);
}

NotificationsNotification*
notifications_notification_construct (GType object_type,
                                      const gchar* app_name,
                                      const gchar* app_icon,
                                      const gchar* summary,
                                      const gchar* body,
                                      GHashTable* hints)
{
	NotificationsNotification * self = NULL;
	g_return_val_if_fail (app_name != NULL, NULL);
	g_return_val_if_fail (app_icon != NULL, NULL);
	g_return_val_if_fail (summary != NULL, NULL);
	g_return_val_if_fail (body != NULL, NULL);
	g_return_val_if_fail (hints != NULL, NULL);
	self = (NotificationsNotification*) g_object_new (object_type, "app-name", app_name, "app-icon", app_icon, "summary", summary, "body", body, "hints", hints, NULL);
	return self;
}

NotificationsNotification*
notifications_notification_new (const gchar* app_name,
                                const gchar* app_icon,
                                const gchar* summary,
                                const gchar* body,
                                GHashTable* hints)
{
	return notifications_notification_construct (NOTIFICATIONS_TYPE_NOTIFICATION, app_name, app_icon, summary, body, hints);
}

/**
     * Copied from gnome-shell, fixes the mess of markup that is sent to us
     */
static gchar*
notifications_notification_fix_markup (NotificationsNotification* self,
                                       const gchar* markup)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (markup != NULL, NULL);
	_tmp0_ = g_strdup (markup);
	text = _tmp0_;
	{
		gchar* _tmp1_ = NULL;
		GRegex* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp2_ = notifications_notification_entity_regex;
		_tmp3_ = strlen (markup);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_replace (_tmp2_, markup, (gssize) _tmp4_, 0, "&amp;", 0, &_inner_error0_);
		_tmp1_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp1_;
		_tmp1_ = NULL;
		_g_free0 (text);
		text = _tmp6_;
		_tmp8_ = notifications_notification_tag_regex;
		_tmp9_ = text;
		_tmp10_ = text;
		_tmp11_ = strlen (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_regex_replace (_tmp8_, _tmp9_, (gssize) _tmp12_, 0, "&lt;", 0, &_inner_error0_);
		_tmp7_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			goto __catch0_g_error;
		}
		_tmp14_ = _tmp7_;
		_tmp7_ = NULL;
		_g_free0 (text);
		text = _tmp14_;
		_g_free0 (_tmp7_);
		_g_free0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		g_warning ("Notification.vala:175: Invalid regex: %s", _tmp16_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (text);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = text;
	return result;
}

static GdkPixbuf*
notifications_notification_image_data_variant_to_pixbuf (NotificationsNotification* self,
                                                         GVariant* img)
{
	const gchar* _tmp0_;
	gint width = 0;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	gint _tmp4_;
	gint height = 0;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	gint _tmp7_;
	gint rowstride = 0;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	gint _tmp10_;
	gboolean has_alpha = FALSE;
	GVariant* _tmp11_;
	GVariant* _tmp12_;
	gboolean _tmp13_;
	gint bits_per_sample = 0;
	GVariant* _tmp14_;
	GVariant* _tmp15_;
	gint _tmp16_;
	guint8* raw = NULL;
	GVariant* _tmp17_;
	GVariant* _tmp18_;
	void* _tmp19_;
	guint8* _tmp20_;
	gint _tmp20__length1;
	gint raw_length1;
	gint _raw_size_;
	GdkPixbuf* pixbuf = NULL;
	guint8* _tmp21_;
	gint _tmp21__length1;
	GdkPixbuf* _tmp22_;
	GdkPixbuf* _tmp23_;
	GdkPixbuf* _tmp24_;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (img != NULL, NULL);
	_tmp0_ = g_variant_get_type_string (img);
	if (g_strcmp0 (_tmp0_, "(iiibiiay)") != 0) {
		const gchar* _tmp1_;
		_tmp1_ = g_variant_get_type_string (img);
		g_warning ("Notification.vala:183: Invalid type string: %s", _tmp1_);
		result = NULL;
		return result;
	}
	_tmp2_ = g_variant_get_child_value (img, (gsize) 0);
	_tmp3_ = _tmp2_;
	_tmp4_ = (gint) g_variant_get_int32 (_tmp3_);
	_g_variant_unref0 (_tmp3_);
	width = _tmp4_;
	_tmp5_ = g_variant_get_child_value (img, (gsize) 1);
	_tmp6_ = _tmp5_;
	_tmp7_ = (gint) g_variant_get_int32 (_tmp6_);
	_g_variant_unref0 (_tmp6_);
	height = _tmp7_;
	_tmp8_ = g_variant_get_child_value (img, (gsize) 2);
	_tmp9_ = _tmp8_;
	_tmp10_ = (gint) g_variant_get_int32 (_tmp9_);
	_g_variant_unref0 (_tmp9_);
	rowstride = _tmp10_;
	_tmp11_ = g_variant_get_child_value (img, (gsize) 3);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_variant_get_boolean (_tmp12_);
	_g_variant_unref0 (_tmp12_);
	has_alpha = _tmp13_;
	_tmp14_ = g_variant_get_child_value (img, (gsize) 4);
	_tmp15_ = _tmp14_;
	_tmp16_ = (gint) g_variant_get_int32 (_tmp15_);
	_g_variant_unref0 (_tmp15_);
	bits_per_sample = _tmp16_;
	_tmp17_ = g_variant_get_child_value (img, (gsize) 6);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_variant_get_data (_tmp18_);
	_tmp20_ = (guint8*) _tmp19_;
	_tmp20__length1 = -1;
	_g_variant_unref0 (_tmp18_);
	raw = _tmp20_;
	raw_length1 = _tmp20__length1;
	_raw_size_ = raw_length1;
	_tmp21_ = raw;
	_tmp21__length1 = raw_length1;
	_tmp22_ = gdk_pixbuf_new_from_data (_tmp21_, GDK_COLORSPACE_RGB, has_alpha, bits_per_sample, width, height, rowstride, (GdkPixbufDestroyNotify) NULL, NULL);
	pixbuf = _tmp22_;
	_tmp23_ = pixbuf;
	_tmp24_ = gdk_pixbuf_copy (_tmp23_);
	result = _tmp24_;
	_g_object_unref0 (pixbuf);
	return result;
}

GDesktopAppInfo*
notifications_notification_get_app_info (NotificationsNotification* self)
{
	GDesktopAppInfo* result;
	GDesktopAppInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_info;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
notifications_notification_set_app_info (NotificationsNotification* self,
                                         GDesktopAppInfo* value)
{
	GDesktopAppInfo* old_value;
	g_return_if_fail (self != NULL);
	old_value = notifications_notification_get_app_info (self);
	if (old_value != value) {
		GDesktopAppInfo* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_app_info);
		self->priv->_app_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_APP_INFO_PROPERTY]);
	}
}

GNotificationPriority
notifications_notification_get_priority (NotificationsNotification* self)
{
	GNotificationPriority result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_priority;
	return result;
}

static void
notifications_notification_set_priority (NotificationsNotification* self,
                                         GNotificationPriority value)
{
	GNotificationPriority old_value;
	g_return_if_fail (self != NULL);
	old_value = notifications_notification_get_priority (self);
	if (old_value != value) {
		self->priv->_priority = value;
		g_object_notify_by_pspec ((GObject *) self, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_PRIORITY_PROPERTY]);
	}
}

GHashTable*
notifications_notification_get_hints (NotificationsNotification* self)
{
	GHashTable* result;
	GHashTable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hints;
	result = _tmp0_;
	return result;
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static void
notifications_notification_set_hints (NotificationsNotification* self,
                                      GHashTable* value)
{
	GHashTable* old_value;
	g_return_if_fail (self != NULL);
	old_value = notifications_notification_get_hints (self);
	if (old_value != value) {
		GHashTable* _tmp0_;
		_tmp0_ = _g_hash_table_ref0 (value);
		_g_hash_table_unref0 (self->priv->_hints);
		self->priv->_hints = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_HINTS_PROPERTY]);
	}
}

const gchar*
notifications_notification_get_app_icon (NotificationsNotification* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_icon;
	result = _tmp0_;
	return result;
}

static void
notifications_notification_set_app_icon (NotificationsNotification* self,
                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = notifications_notification_get_app_icon (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_app_icon);
		self->priv->_app_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_APP_ICON_PROPERTY]);
	}
}

const gchar*
notifications_notification_get_app_id (NotificationsNotification* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_id;
	result = _tmp0_;
	return result;
}

static void
notifications_notification_set_app_id (NotificationsNotification* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = notifications_notification_get_app_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_app_id);
		self->priv->_app_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_APP_ID_PROPERTY]);
	}
}

const gchar*
notifications_notification_get_app_name (NotificationsNotification* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_name;
	result = _tmp0_;
	return result;
}

static void
notifications_notification_set_app_name (NotificationsNotification* self,
                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = notifications_notification_get_app_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_app_name);
		self->priv->_app_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_APP_NAME_PROPERTY]);
	}
}

const gchar*
notifications_notification_get_body (NotificationsNotification* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}

void
notifications_notification_set_body (NotificationsNotification* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = notifications_notification_get_body (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_body);
		self->priv->_body = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_BODY_PROPERTY]);
	}
}

const gchar*
notifications_notification_get_summary (NotificationsNotification* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_summary;
	result = _tmp0_;
	return result;
}

void
notifications_notification_set_summary (NotificationsNotification* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = notifications_notification_get_summary (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_summary);
		self->priv->_summary = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_SUMMARY_PROPERTY]);
	}
}

GIcon*
notifications_notification_get_primary_icon (NotificationsNotification* self)
{
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_primary_icon;
	result = _tmp0_;
	return result;
}

void
notifications_notification_set_primary_icon (NotificationsNotification* self,
                                             GIcon* value)
{
	GIcon* old_value;
	g_return_if_fail (self != NULL);
	old_value = notifications_notification_get_primary_icon (self);
	if (old_value != value) {
		GIcon* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_primary_icon);
		self->priv->_primary_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_PRIMARY_ICON_PROPERTY]);
	}
}

GIcon*
notifications_notification_get_badge_icon (NotificationsNotification* self)
{
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_badge_icon;
	result = _tmp0_;
	return result;
}

void
notifications_notification_set_badge_icon (NotificationsNotification* self,
                                           GIcon* value)
{
	GIcon* old_value;
	g_return_if_fail (self != NULL);
	old_value = notifications_notification_get_badge_icon (self);
	if (old_value != value) {
		GIcon* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_badge_icon);
		self->priv->_badge_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_BADGE_ICON_PROPERTY]);
	}
}

NotificationsMaskedImage*
notifications_notification_get_image (NotificationsNotification* self)
{
	NotificationsMaskedImage* result;
	NotificationsMaskedImage* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_image;
	result = _tmp0_;
	return result;
}

void
notifications_notification_set_image (NotificationsNotification* self,
                                      NotificationsMaskedImage* value)
{
	NotificationsMaskedImage* old_value;
	g_return_if_fail (self != NULL);
	old_value = notifications_notification_get_image (self);
	if (old_value != value) {
		NotificationsMaskedImage* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_image);
		self->priv->_image = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_IMAGE_PROPERTY]);
	}
}

const gchar*
notifications_notification_get_default_action_name (NotificationsNotification* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_action_name;
	result = _tmp0_;
	return result;
}

void
notifications_notification_set_default_action_name (NotificationsNotification* self,
                                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = notifications_notification_get_default_action_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_default_action_name);
		self->priv->_default_action_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_DEFAULT_ACTION_NAME_PROPERTY]);
	}
}

GVariant*
notifications_notification_get_default_action_target (NotificationsNotification* self)
{
	GVariant* result;
	GVariant* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_action_target;
	result = _tmp0_;
	return result;
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

void
notifications_notification_set_default_action_target (NotificationsNotification* self,
                                                      GVariant* value)
{
	GVariant* old_value;
	g_return_if_fail (self != NULL);
	old_value = notifications_notification_get_default_action_target (self);
	if (old_value != value) {
		GVariant* _tmp0_;
		_tmp0_ = _g_variant_ref0 (value);
		_g_variant_unref0 (self->priv->_default_action_target);
		self->priv->_default_action_target = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_DEFAULT_ACTION_TARGET_PROPERTY]);
	}
}

GPtrArray*
notifications_notification_get_buttons (NotificationsNotification* self)
{
	GPtrArray* result;
	GPtrArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_buttons;
	result = _tmp0_;
	return result;
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

void
notifications_notification_set_buttons (NotificationsNotification* self,
                                        GPtrArray* value)
{
	GPtrArray* old_value;
	g_return_if_fail (self != NULL);
	old_value = notifications_notification_get_buttons (self);
	if (old_value != value) {
		GPtrArray* _tmp0_;
		_tmp0_ = _g_ptr_array_ref0 (value);
		_g_ptr_array_unref0 (self->priv->_buttons);
		self->priv->_buttons = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_BUTTONS_PROPERTY]);
	}
}

void
notifications_notification_button_copy (const NotificationsNotificationButton* self,
                                        NotificationsNotificationButton* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).label;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).label);
	(*dest).label = _tmp1_;
	_tmp2_ = (*self).action_name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).action_name);
	(*dest).action_name = _tmp3_;
}

void
notifications_notification_button_destroy (NotificationsNotificationButton* self)
{
	_g_free0 ((*self).label);
	_g_free0 ((*self).action_name);
}

NotificationsNotificationButton*
notifications_notification_button_dup (const NotificationsNotificationButton* self)
{
	NotificationsNotificationButton* dup;
	dup = g_new0 (NotificationsNotificationButton, 1);
	notifications_notification_button_copy (self, dup);
	return dup;
}

void
notifications_notification_button_free (NotificationsNotificationButton* self)
{
	notifications_notification_button_destroy (self);
	g_free (self);
}

static GType
notifications_notification_button_get_type_once (void)
{
	GType notifications_notification_button_type_id;
	notifications_notification_button_type_id = g_boxed_type_register_static ("NotificationsNotificationButton", (GBoxedCopyFunc) notifications_notification_button_dup, (GBoxedFreeFunc) notifications_notification_button_free);
	return notifications_notification_button_type_id;
}

GType
notifications_notification_button_get_type (void)
{
	static volatile gsize notifications_notification_button_type_id__once = 0;
	if (g_once_init_enter (&notifications_notification_button_type_id__once)) {
		GType notifications_notification_button_type_id;
		notifications_notification_button_type_id = notifications_notification_button_get_type_once ();
		g_once_init_leave (&notifications_notification_button_type_id__once, notifications_notification_button_type_id);
	}
	return notifications_notification_button_type_id__once;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static GObject *
notifications_notification_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NotificationsNotification * self;
	GVariant* variant = NULL;
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_;
	gboolean _tmp9_ = FALSE;
	GHashTable* _tmp10_;
	gboolean _tmp38_ = FALSE;
	const gchar* _tmp39_;
	gboolean _tmp53_ = FALSE;
	GHashTable* _tmp54_;
	gconstpointer _tmp55_;
	GVariant* _tmp56_;
	gboolean _tmp81_ = FALSE;
	gboolean _tmp82_ = FALSE;
	GHashTable* _tmp83_;
	gconstpointer _tmp84_;
	GVariant* _tmp85_;
	gboolean _tmp98_ = FALSE;
	NotificationsMaskedImage* _tmp99_;
	gboolean _tmp103_ = FALSE;
	const gchar* _tmp104_;
	const gchar* _tmp108_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (notifications_notification_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NOTIFICATIONS_TYPE_NOTIFICATION, NotificationsNotification);
	variant = NULL;
	_tmp1_ = self->priv->_hints;
	if (g_hash_table_contains (_tmp1_, "urgency")) {
		GHashTable* _tmp2_;
		gconstpointer _tmp3_;
		const GVariantType* _tmp4_;
		_tmp2_ = self->priv->_hints;
		_tmp3_ = g_hash_table_lookup (_tmp2_, "urgency");
		_tmp4_ = G_VARIANT_TYPE_BYTE;
		_tmp0_ = g_variant_is_of_type ((GVariant*) _tmp3_, _tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GHashTable* _tmp5_;
		gconstpointer _tmp6_;
		_tmp5_ = self->priv->_hints;
		_tmp6_ = g_hash_table_lookup (_tmp5_, "urgency");
		switch (g_variant_get_byte ((GVariant*) _tmp6_)) {
			case 0:
			{
				notifications_notification_set_priority (self, G_NOTIFICATION_PRIORITY_LOW);
				break;
			}
			case 1:
			{
				notifications_notification_set_priority (self, G_NOTIFICATION_PRIORITY_NORMAL);
				break;
			}
			case 2:
			{
				notifications_notification_set_priority (self, G_NOTIFICATION_PRIORITY_URGENT);
				break;
			}
			default:
			{
				GHashTable* _tmp7_;
				gconstpointer _tmp8_;
				_tmp7_ = self->priv->_hints;
				_tmp8_ = g_hash_table_lookup (_tmp7_, "urgency");
				g_warning ("Notification.vala:87: unknown urgency value: %i, ignoring", (gint) g_variant_get_byte ((GVariant*) _tmp8_));
				break;
			}
		}
	}
	_tmp10_ = self->priv->_hints;
	if (g_hash_table_contains (_tmp10_, "desktop-entry")) {
		GHashTable* _tmp11_;
		gconstpointer _tmp12_;
		const GVariantType* _tmp13_;
		_tmp11_ = self->priv->_hints;
		_tmp12_ = g_hash_table_lookup (_tmp11_, "desktop-entry");
		_tmp13_ = G_VARIANT_TYPE_STRING;
		_tmp9_ = g_variant_is_of_type ((GVariant*) _tmp12_, _tmp13_);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		GHashTable* _tmp14_;
		gconstpointer _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		GDesktopAppInfo* _tmp19_;
		GDesktopAppInfo* _tmp20_;
		gboolean _tmp21_ = FALSE;
		GDesktopAppInfo* _tmp22_;
		_tmp14_ = self->priv->_hints;
		_tmp15_ = g_hash_table_lookup (_tmp14_, "desktop-entry");
		_tmp16_ = g_variant_get_string ((GVariant*) _tmp15_, NULL);
		_tmp17_ = g_strdup_printf ("%s.desktop", _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_desktop_app_info_new (_tmp18_);
		_tmp20_ = _tmp19_;
		notifications_notification_set_app_info (self, _tmp20_);
		_g_object_unref0 (_tmp20_);
		_g_free0 (_tmp18_);
		_tmp22_ = self->priv->_app_info;
		if (_tmp22_ != NULL) {
			GDesktopAppInfo* _tmp23_;
			_tmp23_ = self->priv->_app_info;
			_tmp21_ = g_desktop_app_info_get_boolean (_tmp23_, "X-GNOME-UsesNotifications");
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			gchar* app_info_id = NULL;
			GDesktopAppInfo* _tmp24_;
			const gchar* _tmp25_;
			gchar* _tmp26_;
			const gchar* _tmp27_;
			_tmp24_ = self->priv->_app_info;
			_tmp25_ = g_app_info_get_id ((GAppInfo*) _tmp24_);
			_tmp26_ = g_strdup (_tmp25_);
			app_info_id = _tmp26_;
			_tmp27_ = app_info_id;
			if (_tmp27_ != NULL) {
				const gchar* _tmp28_;
				_tmp28_ = app_info_id;
				if (g_str_has_suffix (_tmp28_, ".desktop")) {
					const gchar* _tmp29_;
					const gchar* _tmp30_;
					gint _tmp31_;
					gint _tmp32_;
					gint _tmp33_;
					gint _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					_tmp29_ = app_info_id;
					_tmp30_ = app_info_id;
					_tmp31_ = strlen (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = strlen (".desktop");
					_tmp34_ = _tmp33_;
					_tmp35_ = string_substring (_tmp29_, (glong) 0, (glong) (_tmp32_ - _tmp34_));
					_tmp36_ = _tmp35_;
					notifications_notification_set_app_id (self, _tmp36_);
					_g_free0 (_tmp36_);
				} else {
					const gchar* _tmp37_;
					_tmp37_ = app_info_id;
					notifications_notification_set_app_id (self, _tmp37_);
				}
			}
			_g_free0 (app_info_id);
		}
	}
	_tmp39_ = self->priv->_app_icon;
	if (g_strcmp0 (_tmp39_, "") == 0) {
		GDesktopAppInfo* _tmp40_;
		_tmp40_ = self->priv->_app_info;
		_tmp38_ = _tmp40_ != NULL;
	} else {
		_tmp38_ = FALSE;
	}
	if (_tmp38_) {
		GDesktopAppInfo* _tmp41_;
		GIcon* _tmp42_;
		_tmp41_ = self->priv->_app_info;
		_tmp42_ = g_app_info_get_icon ((GAppInfo*) _tmp41_);
		notifications_notification_set_primary_icon (self, _tmp42_);
	} else {
		const gchar* _tmp43_;
		_tmp43_ = self->priv->_app_icon;
		if (string_contains (_tmp43_, "/")) {
			GFile* file = NULL;
			const gchar* _tmp44_;
			GFile* _tmp45_;
			GFile* _tmp46_;
			_tmp44_ = self->priv->_app_icon;
			_tmp45_ = g_file_new_for_uri (_tmp44_);
			file = _tmp45_;
			_tmp46_ = file;
			if (g_file_query_exists (_tmp46_, NULL)) {
				GFile* _tmp47_;
				GFileIcon* _tmp48_;
				GFileIcon* _tmp49_;
				_tmp47_ = file;
				_tmp48_ = (GFileIcon*) g_file_icon_new (_tmp47_);
				_tmp49_ = _tmp48_;
				notifications_notification_set_primary_icon (self, (GIcon*) _tmp49_);
				_g_object_unref0 (_tmp49_);
			}
			_g_object_unref0 (file);
		} else {
			const gchar* _tmp50_;
			GThemedIcon* _tmp51_;
			GThemedIcon* _tmp52_;
			_tmp50_ = self->priv->_app_icon;
			_tmp51_ = (GThemedIcon*) g_themed_icon_new (_tmp50_);
			_tmp52_ = _tmp51_;
			notifications_notification_set_primary_icon (self, (GIcon*) _tmp52_);
			_g_object_unref0 (_tmp52_);
		}
	}
	_tmp54_ = self->priv->_hints;
	_tmp55_ = g_hash_table_lookup (_tmp54_, "image-path");
	variant = (GVariant*) _tmp55_;
	_tmp56_ = variant;
	if (_tmp56_ != NULL) {
		_tmp53_ = TRUE;
	} else {
		GHashTable* _tmp57_;
		gconstpointer _tmp58_;
		GVariant* _tmp59_;
		_tmp57_ = self->priv->_hints;
		_tmp58_ = g_hash_table_lookup (_tmp57_, "image_path");
		variant = (GVariant*) _tmp58_;
		_tmp59_ = variant;
		_tmp53_ = _tmp59_ != NULL;
	}
	if (_tmp53_) {
		gchar* image_path = NULL;
		GVariant* _tmp60_;
		const gchar* _tmp61_;
		gchar* _tmp62_;
		gboolean _tmp63_ = FALSE;
		GtkIconTheme* _tmp64_;
		const gchar* _tmp65_;
		_tmp60_ = variant;
		_tmp61_ = g_variant_get_string (_tmp60_, NULL);
		_tmp62_ = g_strdup (_tmp61_);
		image_path = _tmp62_;
		_tmp64_ = gtk_icon_theme_get_default ();
		_tmp65_ = image_path;
		if (gtk_icon_theme_has_icon (_tmp64_, _tmp65_)) {
			const gchar* _tmp66_;
			const gchar* _tmp67_;
			_tmp66_ = image_path;
			_tmp67_ = self->priv->_app_icon;
			_tmp63_ = g_strcmp0 (_tmp66_, _tmp67_) != 0;
		} else {
			_tmp63_ = FALSE;
		}
		if (_tmp63_) {
			const gchar* _tmp68_;
			GThemedIcon* _tmp69_;
			GThemedIcon* _tmp70_;
			_tmp68_ = image_path;
			_tmp69_ = (GThemedIcon*) g_themed_icon_new (_tmp68_);
			_tmp70_ = _tmp69_;
			notifications_notification_set_badge_icon (self, (GIcon*) _tmp70_);
			_g_object_unref0 (_tmp70_);
		} else {
			gboolean _tmp71_ = FALSE;
			const gchar* _tmp72_;
			_tmp72_ = image_path;
			if (g_str_has_prefix (_tmp72_, "/")) {
				_tmp71_ = TRUE;
			} else {
				const gchar* _tmp73_;
				_tmp73_ = image_path;
				_tmp71_ = g_str_has_prefix (_tmp73_, "file://");
			}
			if (_tmp71_) {
				{
					GdkPixbuf* pixbuf = NULL;
					const gchar* _tmp74_;
					GdkPixbuf* _tmp75_;
					GdkPixbuf* _tmp76_;
					NotificationsMaskedImage* _tmp77_;
					NotificationsMaskedImage* _tmp78_;
					_tmp74_ = image_path;
					_tmp75_ = gdk_pixbuf_new_from_file (_tmp74_, &_inner_error0_);
					pixbuf = _tmp75_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp76_ = pixbuf;
					_tmp77_ = notifications_masked_image_new (_tmp76_);
					g_object_ref_sink (_tmp77_);
					_tmp78_ = _tmp77_;
					notifications_notification_set_image (self, _tmp78_);
					_g_object_unref0 (_tmp78_);
					_g_object_unref0 (pixbuf);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					GError* _tmp79_;
					const gchar* _tmp80_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp79_ = e;
					_tmp80_ = _tmp79_->message;
					g_critical ("Notification.vala:132: Unable to mask image: %s", _tmp80_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (image_path);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
				}
			}
		}
		_g_free0 (image_path);
	}
	_tmp83_ = self->priv->_hints;
	_tmp84_ = g_hash_table_lookup (_tmp83_, "image-data");
	variant = (GVariant*) _tmp84_;
	_tmp85_ = variant;
	if (_tmp85_ != NULL) {
		_tmp82_ = TRUE;
	} else {
		GHashTable* _tmp86_;
		gconstpointer _tmp87_;
		GVariant* _tmp88_;
		_tmp86_ = self->priv->_hints;
		_tmp87_ = g_hash_table_lookup (_tmp86_, "image_data");
		variant = (GVariant*) _tmp87_;
		_tmp88_ = variant;
		_tmp82_ = _tmp88_ != NULL;
	}
	if (_tmp82_) {
		_tmp81_ = TRUE;
	} else {
		GHashTable* _tmp89_;
		gconstpointer _tmp90_;
		GVariant* _tmp91_;
		_tmp89_ = self->priv->_hints;
		_tmp90_ = g_hash_table_lookup (_tmp89_, "icon_data");
		variant = (GVariant*) _tmp90_;
		_tmp91_ = variant;
		_tmp81_ = _tmp91_ != NULL;
	}
	if (_tmp81_) {
		GdkPixbuf* pixbuf = NULL;
		GVariant* _tmp92_;
		GdkPixbuf* _tmp93_;
		GdkPixbuf* _tmp94_;
		_tmp92_ = variant;
		_tmp93_ = notifications_notification_image_data_variant_to_pixbuf (self, _tmp92_);
		pixbuf = _tmp93_;
		_tmp94_ = pixbuf;
		if (_tmp94_ != NULL) {
			GdkPixbuf* _tmp95_;
			NotificationsMaskedImage* _tmp96_;
			NotificationsMaskedImage* _tmp97_;
			_tmp95_ = pixbuf;
			_tmp96_ = notifications_masked_image_new (_tmp95_);
			g_object_ref_sink (_tmp96_);
			_tmp97_ = _tmp96_;
			notifications_notification_set_image (self, _tmp97_);
			_g_object_unref0 (_tmp97_);
		}
		_g_object_unref0 (pixbuf);
	}
	_tmp99_ = self->priv->_image;
	if (_tmp99_ == NULL) {
		GIcon* _tmp100_;
		_tmp100_ = self->priv->_primary_icon;
		_tmp98_ = _tmp100_ == NULL;
	} else {
		_tmp98_ = FALSE;
	}
	if (_tmp98_) {
		GThemedIcon* _tmp101_;
		GThemedIcon* _tmp102_;
		_tmp101_ = (GThemedIcon*) g_themed_icon_new ("dialog-information");
		_tmp102_ = _tmp101_;
		notifications_notification_set_primary_icon (self, (GIcon*) _tmp102_);
		_g_object_unref0 (_tmp102_);
	}
	_tmp104_ = self->priv->_app_name;
	if (g_strcmp0 (_tmp104_, "") == 0) {
		GDesktopAppInfo* _tmp105_;
		_tmp105_ = self->priv->_app_info;
		_tmp103_ = _tmp105_ != NULL;
	} else {
		_tmp103_ = FALSE;
	}
	if (_tmp103_) {
		GDesktopAppInfo* _tmp106_;
		const gchar* _tmp107_;
		_tmp106_ = self->priv->_app_info;
		_tmp107_ = g_app_info_get_display_name ((GAppInfo*) _tmp106_);
		notifications_notification_set_app_name (self, _tmp107_);
	}
	_tmp108_ = self->priv->_body;
	if (g_strcmp0 (_tmp108_, "") == 0) {
		const gchar* _tmp109_;
		gchar* _tmp110_;
		gchar* _tmp111_;
		const gchar* _tmp112_;
		_tmp109_ = self->priv->_summary;
		_tmp110_ = notifications_notification_fix_markup (self, _tmp109_);
		_tmp111_ = _tmp110_;
		notifications_notification_set_body (self, _tmp111_);
		_g_free0 (_tmp111_);
		_tmp112_ = self->priv->_app_name;
		notifications_notification_set_summary (self, _tmp112_);
	} else {
		const gchar* _tmp113_;
		gchar* _tmp114_;
		gchar* _tmp115_;
		const gchar* _tmp116_;
		gchar* _tmp117_;
		gchar* _tmp118_;
		_tmp113_ = self->priv->_body;
		_tmp114_ = notifications_notification_fix_markup (self, _tmp113_);
		_tmp115_ = _tmp114_;
		notifications_notification_set_body (self, _tmp115_);
		_g_free0 (_tmp115_);
		_tmp116_ = self->priv->_summary;
		_tmp117_ = notifications_notification_fix_markup (self, _tmp116_);
		_tmp118_ = _tmp117_;
		notifications_notification_set_summary (self, _tmp118_);
		_g_free0 (_tmp118_);
	}
	return obj;
}

static void
notifications_notification_class_init (NotificationsNotificationClass * klass,
                                       gpointer klass_data)
{
	GError* _inner_error0_ = NULL;
	notifications_notification_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NotificationsNotification_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_notifications_notification_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_notifications_notification_set_property;
	G_OBJECT_CLASS (klass)->constructor = notifications_notification_constructor;
	G_OBJECT_CLASS (klass)->finalize = notifications_notification_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATIONS_NOTIFICATION_APP_INFO_PROPERTY, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_APP_INFO_PROPERTY] = g_param_spec_object ("app-info", "app-info", "app-info", G_TYPE_DESKTOP_APP_INFO, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATIONS_NOTIFICATION_PRIORITY_PROPERTY, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_PRIORITY_PROPERTY] = g_param_spec_enum ("priority", "priority", "priority", g_notification_priority_get_type (), G_NOTIFICATION_PRIORITY_NORMAL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATIONS_NOTIFICATION_HINTS_PROPERTY, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_HINTS_PROPERTY] = g_param_spec_boxed ("hints", "hints", "hints", G_TYPE_HASH_TABLE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATIONS_NOTIFICATION_APP_ICON_PROPERTY, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_APP_ICON_PROPERTY] = g_param_spec_string ("app-icon", "app-icon", "app-icon", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATIONS_NOTIFICATION_APP_ID_PROPERTY, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_APP_ID_PROPERTY] = g_param_spec_string ("app-id", "app-id", "app-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATIONS_NOTIFICATION_APP_NAME_PROPERTY, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_APP_NAME_PROPERTY] = g_param_spec_string ("app-name", "app-name", "app-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATIONS_NOTIFICATION_BODY_PROPERTY, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_BODY_PROPERTY] = g_param_spec_string ("body", "body", "body", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATIONS_NOTIFICATION_SUMMARY_PROPERTY, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_SUMMARY_PROPERTY] = g_param_spec_string ("summary", "summary", "summary", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATIONS_NOTIFICATION_PRIMARY_ICON_PROPERTY, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_PRIMARY_ICON_PROPERTY] = g_param_spec_object ("primary-icon", "primary-icon", "primary-icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATIONS_NOTIFICATION_BADGE_ICON_PROPERTY, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_BADGE_ICON_PROPERTY] = g_param_spec_object ("badge-icon", "badge-icon", "badge-icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATIONS_NOTIFICATION_IMAGE_PROPERTY, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_IMAGE_PROPERTY] = g_param_spec_object ("image", "image", "image", NOTIFICATIONS_TYPE_MASKED_IMAGE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATIONS_NOTIFICATION_DEFAULT_ACTION_NAME_PROPERTY, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_DEFAULT_ACTION_NAME_PROPERTY] = g_param_spec_string ("default-action-name", "default-action-name", "default-action-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATIONS_NOTIFICATION_DEFAULT_ACTION_TARGET_PROPERTY, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_DEFAULT_ACTION_TARGET_PROPERTY] = g_param_spec_variant ("default-action-target", "default-action-target", "default-action-target", G_VARIANT_TYPE_ANY, NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATIONS_NOTIFICATION_BUTTONS_PROPERTY, notifications_notification_properties[NOTIFICATIONS_NOTIFICATION_BUTTONS_PROPERTY] = g_param_spec_boxed ("buttons", "buttons", "buttons", G_TYPE_PTR_ARRAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_;
		GRegex* _tmp5_;
		_tmp1_ = g_regex_new ("&(?!amp;|quot;|apos;|lt;|gt;|nbsp;|#39)", 0, 0, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (notifications_notification_entity_regex);
		notifications_notification_entity_regex = _tmp2_;
		_tmp4_ = g_regex_new ("<(?!\\/?[biu]>)", 0, 0, &_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_regex_unref0 (notifications_notification_tag_regex);
		notifications_notification_tag_regex = _tmp5_;
		_g_regex_unref0 (_tmp3_);
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("Notification.vala:65: Invalid regex: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
}

static void
notifications_notification_instance_init (NotificationsNotification * self,
                                          gpointer klass)
{
	gchar* _tmp0_;
	self->priv = notifications_notification_get_instance_private (self);
	self->priv->_app_info = NULL;
	self->priv->_priority = G_NOTIFICATION_PRIORITY_NORMAL;
	_tmp0_ = g_strdup (NOTIFICATIONS_NOTIFICATION_OTHER_APP_ID);
	self->priv->_app_id = _tmp0_;
	self->priv->_primary_icon = NULL;
	self->priv->_badge_icon = NULL;
	self->priv->_image = NULL;
}

static void
notifications_notification_finalize (GObject * obj)
{
	NotificationsNotification * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NOTIFICATIONS_TYPE_NOTIFICATION, NotificationsNotification);
	_g_object_unref0 (self->priv->_app_info);
	_g_hash_table_unref0 (self->priv->_hints);
	_g_free0 (self->priv->_app_icon);
	_g_free0 (self->priv->_app_id);
	_g_free0 (self->priv->_app_name);
	_g_free0 (self->priv->_body);
	_g_free0 (self->priv->_summary);
	_g_object_unref0 (self->priv->_primary_icon);
	_g_object_unref0 (self->priv->_badge_icon);
	_g_object_unref0 (self->priv->_image);
	_g_free0 (self->priv->_default_action_name);
	_g_variant_unref0 (self->priv->_default_action_target);
	_g_ptr_array_unref0 (self->priv->_buttons);
	G_OBJECT_CLASS (notifications_notification_parent_class)->finalize (obj);
}

static GType
notifications_notification_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NotificationsNotificationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notifications_notification_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotificationsNotification), 0, (GInstanceInitFunc) notifications_notification_instance_init, NULL };
	GType notifications_notification_type_id;
	notifications_notification_type_id = g_type_register_static (G_TYPE_OBJECT, "NotificationsNotification", &g_define_type_info, 0);
	NotificationsNotification_private_offset = g_type_add_instance_private (notifications_notification_type_id, sizeof (NotificationsNotificationPrivate));
	return notifications_notification_type_id;
}

GType
notifications_notification_get_type (void)
{
	static volatile gsize notifications_notification_type_id__once = 0;
	if (g_once_init_enter (&notifications_notification_type_id__once)) {
		GType notifications_notification_type_id;
		notifications_notification_type_id = notifications_notification_get_type_once ();
		g_once_init_leave (&notifications_notification_type_id__once, notifications_notification_type_id);
	}
	return notifications_notification_type_id__once;
}

static void
_vala_notifications_notification_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	NotificationsNotification * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NOTIFICATIONS_TYPE_NOTIFICATION, NotificationsNotification);
	switch (property_id) {
		case NOTIFICATIONS_NOTIFICATION_APP_INFO_PROPERTY:
		g_value_set_object (value, notifications_notification_get_app_info (self));
		break;
		case NOTIFICATIONS_NOTIFICATION_PRIORITY_PROPERTY:
		g_value_set_enum (value, notifications_notification_get_priority (self));
		break;
		case NOTIFICATIONS_NOTIFICATION_HINTS_PROPERTY:
		g_value_set_boxed (value, notifications_notification_get_hints (self));
		break;
		case NOTIFICATIONS_NOTIFICATION_APP_ICON_PROPERTY:
		g_value_set_string (value, notifications_notification_get_app_icon (self));
		break;
		case NOTIFICATIONS_NOTIFICATION_APP_ID_PROPERTY:
		g_value_set_string (value, notifications_notification_get_app_id (self));
		break;
		case NOTIFICATIONS_NOTIFICATION_APP_NAME_PROPERTY:
		g_value_set_string (value, notifications_notification_get_app_name (self));
		break;
		case NOTIFICATIONS_NOTIFICATION_BODY_PROPERTY:
		g_value_set_string (value, notifications_notification_get_body (self));
		break;
		case NOTIFICATIONS_NOTIFICATION_SUMMARY_PROPERTY:
		g_value_set_string (value, notifications_notification_get_summary (self));
		break;
		case NOTIFICATIONS_NOTIFICATION_PRIMARY_ICON_PROPERTY:
		g_value_set_object (value, notifications_notification_get_primary_icon (self));
		break;
		case NOTIFICATIONS_NOTIFICATION_BADGE_ICON_PROPERTY:
		g_value_set_object (value, notifications_notification_get_badge_icon (self));
		break;
		case NOTIFICATIONS_NOTIFICATION_IMAGE_PROPERTY:
		g_value_set_object (value, notifications_notification_get_image (self));
		break;
		case NOTIFICATIONS_NOTIFICATION_DEFAULT_ACTION_NAME_PROPERTY:
		g_value_set_string (value, notifications_notification_get_default_action_name (self));
		break;
		case NOTIFICATIONS_NOTIFICATION_DEFAULT_ACTION_TARGET_PROPERTY:
		g_value_set_variant (value, notifications_notification_get_default_action_target (self));
		break;
		case NOTIFICATIONS_NOTIFICATION_BUTTONS_PROPERTY:
		g_value_set_boxed (value, notifications_notification_get_buttons (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_notifications_notification_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	NotificationsNotification * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NOTIFICATIONS_TYPE_NOTIFICATION, NotificationsNotification);
	switch (property_id) {
		case NOTIFICATIONS_NOTIFICATION_APP_INFO_PROPERTY:
		notifications_notification_set_app_info (self, g_value_get_object (value));
		break;
		case NOTIFICATIONS_NOTIFICATION_PRIORITY_PROPERTY:
		notifications_notification_set_priority (self, g_value_get_enum (value));
		break;
		case NOTIFICATIONS_NOTIFICATION_HINTS_PROPERTY:
		notifications_notification_set_hints (self, g_value_get_boxed (value));
		break;
		case NOTIFICATIONS_NOTIFICATION_APP_ICON_PROPERTY:
		notifications_notification_set_app_icon (self, g_value_get_string (value));
		break;
		case NOTIFICATIONS_NOTIFICATION_APP_ID_PROPERTY:
		notifications_notification_set_app_id (self, g_value_get_string (value));
		break;
		case NOTIFICATIONS_NOTIFICATION_APP_NAME_PROPERTY:
		notifications_notification_set_app_name (self, g_value_get_string (value));
		break;
		case NOTIFICATIONS_NOTIFICATION_BODY_PROPERTY:
		notifications_notification_set_body (self, g_value_get_string (value));
		break;
		case NOTIFICATIONS_NOTIFICATION_SUMMARY_PROPERTY:
		notifications_notification_set_summary (self, g_value_get_string (value));
		break;
		case NOTIFICATIONS_NOTIFICATION_PRIMARY_ICON_PROPERTY:
		notifications_notification_set_primary_icon (self, g_value_get_object (value));
		break;
		case NOTIFICATIONS_NOTIFICATION_BADGE_ICON_PROPERTY:
		notifications_notification_set_badge_icon (self, g_value_get_object (value));
		break;
		case NOTIFICATIONS_NOTIFICATION_IMAGE_PROPERTY:
		notifications_notification_set_image (self, g_value_get_object (value));
		break;
		case NOTIFICATIONS_NOTIFICATION_DEFAULT_ACTION_NAME_PROPERTY:
		notifications_notification_set_default_action_name (self, g_value_get_string (value));
		break;
		case NOTIFICATIONS_NOTIFICATION_DEFAULT_ACTION_TARGET_PROPERTY:
		notifications_notification_set_default_action_target (self, g_value_get_variant (value));
		break;
		case NOTIFICATIONS_NOTIFICATION_BUTTONS_PROPERTY:
		notifications_notification_set_buttons (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

