/* DataSource.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DataSource.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/
/**/
/* DataSource*/
/**/
/* A DataSource is an object that is unique throughout the system.  DataSources*/
/* commonly have external and/or persistent representations, hence they have a notion of being*/
/* destroyed (versus removed or freed).  Several DataViews may exist that reference a single*/
/* DataSource.  Note that DataSources MUST be destroyed (rather than simply removed) from their*/
/* SourceCollection, and that they MUST be destroyed via their SourceCollection (rather than*/
/* calling DataSource.destroy () directly.)*/
/**/
/* Destroying a DataSource indicates it should remove all secondary and tertiary structures (such*/
/* as thumbnails) and any records pointing to its backing store.  SourceCollection.destroy_marked ()*/
/* has a parameter indicating if the backing should be destroyed as well; that is when*/
/* internal_delete_backing () is called.*/
/**/
/* There are no provisions (currently) for a DataSource to be removed from its SourceCollection*/
/* without destroying its backing and/or secondary and tertiary structures.  DataSources are intended*/
/* to go to the grave with their SourceCollection otherwise.  If a need arises for a DataSource to*/
/* be peaceably removed from its SourceCollection, code will need to be written.  SourceSnapshots*/
/* may be one solution to this problem.*/
/**/
/* Some DataSources cannot be reconstituted (for example, if its backing file is deleted).  In*/
/* that case, dehydrate () should return null.  When reconstituted, it is the responsibility of the*/
/* implementation to ensure an exact clone is produced, minus any details that are not relevant or*/
/* exposed (such as a database ID).*/
/**/
/* If other DataSources refer to this DataSource, their state will *not* be*/
/* saved/restored.  This must be achieved via other means.  However, implementations *should**/
/* track when changes to external state would break the proxy and call notify_broken ();*/
/**/

#include "io.elementary.photos.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DATA_SOURCE_0_PROPERTY,
	DATA_SOURCE_NUM_PROPERTIES
};
static GParamSpec* data_source_properties[DATA_SOURCE_NUM_PROPERTIES];
#define _source_holding_tank_unref0(var) ((var == NULL) ? NULL : (var = (source_holding_tank_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _source_backlink_unref0(var) ((var == NULL) ? NULL : (var = (source_backlink_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	DATA_SOURCE_UNLINKED_SIGNAL,
	DATA_SOURCE_RELINKED_SIGNAL,
	DATA_SOURCE_DESTROYED_SIGNAL,
	DATA_SOURCE_NUM_SIGNALS
};
static guint data_source_signals[DATA_SOURCE_NUM_SIGNALS] = {0};
typedef struct _ParamSpecSourceSnapshot ParamSpecSourceSnapshot;
enum  {
	SOURCE_SNAPSHOT_BROKEN_SIGNAL,
	SOURCE_SNAPSHOT_NUM_SIGNALS
};
static guint source_snapshot_signals[SOURCE_SNAPSHOT_NUM_SIGNALS] = {0};
typedef struct _ParamSpecSourceBacklink ParamSpecSourceBacklink;
#define _source_snapshot_unref0(var) ((var == NULL) ? NULL : (var = (source_snapshot_unref (var), NULL)))
typedef struct _ParamSpecSourceProxy ParamSpecSourceProxy;
enum  {
	SOURCE_PROXY_RECONSTITUTED_SIGNAL,
	SOURCE_PROXY_DEHYDRATED_SIGNAL,
	SOURCE_PROXY_BROKEN_SIGNAL,
	SOURCE_PROXY_NUM_SIGNALS
};
static guint source_proxy_signals[SOURCE_PROXY_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DataSourcePrivate {
	DataView** subscribers;
	gint subscribers_length1;
	gint _subscribers_size_;
	SourceHoldingTank* holding_tank;
	SourceCollection* unlinked_from_collection;
	GeeHashMap* backlinks;
	gboolean in_contact;
	gboolean marked_for_destroy;
	gboolean is_destroyed;
};

struct _SourceSnapshotPrivate {
	gboolean snapshot_broken;
};

struct _ParamSpecSourceSnapshot {
	GParamSpec parent_instance;
};

struct _SourceBacklinkPrivate {
	gchar* _name;
	gchar* _value;
};

struct _ParamSpecSourceBacklink {
	GParamSpec parent_instance;
};

struct _SourceProxyPrivate {
	gint64 object_id;
	gchar* source_string;
	DataSource* source;
	SourceSnapshot* snapshot;
	SourceCollection* membership;
};

struct _ParamSpecSourceProxy {
	GParamSpec parent_instance;
};

static gint DataSource_private_offset;
static gpointer data_source_parent_class = NULL;
static gint SourceSnapshot_private_offset;
static gpointer source_snapshot_parent_class = NULL;
static gint SourceBacklink_private_offset;
static gpointer source_backlink_parent_class = NULL;
static gint SourceProxy_private_offset;
static gpointer source_proxy_parent_class = NULL;

static void data_source_real_notify_membership_changed (DataObject* base,
                                                 DataCollection* collection);
static void data_source_real_notify_held_in_tank (DataSource* self,
                                           SourceHoldingTank* holding_tank);
static void data_source_real_notify_altered (DataObject* base,
                                      Alteration* alteration);
static void data_source_real_notify_unlinking (DataSource* self,
                                        SourceCollection* collection);
static void data_source_real_notify_unlinked (DataSource* self);
static gchar* data_source_dehydrate_backlinks (DataSource* self);
static void data_source_real_notify_relinking (DataSource* self,
                                        SourceCollection* collection);
static void data_source_real_notify_relinked (DataSource* self);
static gchar* data_source_real_get_typename (DataSource* self);
static gint64 data_source_real_get_instance_id (DataSource* self);
static gchar* data_source_real_get_source_id (DataSource* self);
static void data_source_real_commit_backlinks (DataSource* self,
                                        SourceCollection* sources,
                                        const gchar* dehydrated);
static SourceSnapshot* data_source_real_save_snapshot (DataSource* self);
static gboolean data_source_real_internal_delete_backing (DataSource* self,
                                                   GError** error);
static gboolean data_source_real_equals (DataSource* self,
                                  DataSource* source);
static void data_source_real_destroy (DataSource* self);
static void _vala_array_add48 (DataView** * array,
                        gint* length,
                        gint* size,
                        DataView* value);
static void data_source_real_unlinked (DataSource* self,
                                SourceCollection* sources);
static void g_cclosure_user_marshal_VOID__DATA_COLLECTION (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data);
static void data_source_real_relinked (DataSource* self,
                                SourceCollection* sources);
static void data_source_real_destroyed (DataSource* self);
static void data_source_finalize (GObject * obj);
static GType data_source_get_type_once (void);
static void source_snapshot_real_notify_broken (SourceSnapshot* self);
static void source_snapshot_real_broken (SourceSnapshot* self);
static void source_snapshot_finalize (SourceSnapshot * obj);
static GType source_snapshot_get_type_once (void);
static gboolean source_backlink_validate_name_value (const gchar* name,
                                              const gchar* value);
static void source_backlink_finalize (SourceBacklink * obj);
static GType source_backlink_get_type_once (void);
static void source_proxy_drop_source (SourceProxy* self);
static void source_proxy_on_source_added (SourceProxy* self,
                                   GeeIterable* added);
static void _source_proxy_on_source_added_data_collection_items_added (DataCollection* _sender,
                                                                GeeIterable* added,
                                                                gpointer self);
static void source_proxy_on_snapshot_broken (SourceProxy* self);
static void _source_proxy_on_snapshot_broken_source_snapshot_broken (SourceSnapshot* _sender,
                                                              gpointer self);
static void source_proxy_set_source (SourceProxy* self,
                              DataSource* source);
static DataSource* source_proxy_real_reconstitute (SourceProxy* self,
                                            gint64 object_id,
                                            SourceSnapshot* snapshot);
static void source_proxy_real_notify_reconstituted (SourceProxy* self,
                                             DataSource* source);
static void source_proxy_real_notify_dehydrated (SourceProxy* self);
static void source_proxy_real_notify_broken (SourceProxy* self);
static void source_proxy_on_destroyed (SourceProxy* self);
static void _source_proxy_on_destroyed_data_source_destroyed (DataSource* _sender,
                                                       gpointer self);
static void source_proxy_real_reconstituted (SourceProxy* self,
                                      DataSource* source);
static void source_proxy_real_dehydrated (SourceProxy* self);
static void source_proxy_real_broken (SourceProxy* self);
static void source_proxy_finalize (SourceProxy * obj);
static GType source_proxy_get_type_once (void);
static GType proxyable_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
data_source_get_instance_private (DataSource* self)
{
	return G_STRUCT_MEMBER_P (self, DataSource_private_offset);
}

DataSource*
data_source_construct (GType object_type,
                       gint64 object_id)
{
	DataSource * self = NULL;
	self = (DataSource*) data_object_construct (object_type, object_id);
	return self;
}

static void
data_source_real_notify_membership_changed (DataObject* base,
                                            DataCollection* collection)
{
	DataSource * self;
	gboolean _tmp2_ = FALSE;
	self = (DataSource*) base;
	if (collection == NULL) {
		gboolean _tmp0_ = FALSE;
		if (self->priv->is_destroyed) {
			_tmp0_ = TRUE;
		} else {
			GeeHashMap* _tmp1_;
			_tmp1_ = self->priv->backlinks;
			_tmp0_ = _tmp1_ != NULL;
		}
		_vala_assert (_tmp0_, "is_destroyed || backlinks != null");
	} else {
		_vala_assert (!self->priv->is_destroyed, "!is_destroyed");
	}
	if (collection == NULL) {
		GeeHashMap* _tmp3_;
		_tmp3_ = self->priv->backlinks;
		_tmp2_ = _tmp3_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		data_source_notify_unlinked (self);
	}
	DATA_OBJECT_CLASS (data_source_parent_class)->notify_membership_changed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), collection);
}

static gpointer
_source_holding_tank_ref0 (gpointer self)
{
	return self ? source_holding_tank_ref (self) : NULL;
}

static void
data_source_real_notify_held_in_tank (DataSource* self,
                                      SourceHoldingTank* holding_tank)
{
	DataCollection* _tmp0_;
	DataCollection* _tmp1_;
	SourceHoldingTank* _tmp4_;
	_tmp0_ = data_object_get_membership ((DataObject*) self);
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_ == NULL, "get_membership () == null");
	_data_collection_unref0 (_tmp1_);
	if (holding_tank != NULL) {
		SourceHoldingTank* _tmp2_;
		_tmp2_ = self->priv->holding_tank;
		_vala_assert (_tmp2_ == NULL, "this.holding_tank == null");
	} else {
		SourceHoldingTank* _tmp3_;
		_tmp3_ = self->priv->holding_tank;
		_vala_assert (_tmp3_ != NULL, "this.holding_tank != null");
	}
	_tmp4_ = _source_holding_tank_ref0 (holding_tank);
	_source_holding_tank_unref0 (self->priv->holding_tank);
	self->priv->holding_tank = _tmp4_;
}

void
data_source_notify_held_in_tank (DataSource* self,
                                 SourceHoldingTank* holding_tank)
{
	DataSourceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = DATA_SOURCE_GET_CLASS (self);
	if (_klass_->notify_held_in_tank) {
		_klass_->notify_held_in_tank (self, holding_tank);
	}
}

static void
data_source_real_notify_altered (DataObject* base,
                                 Alteration* alteration)
{
	DataSource * self;
	SourceHoldingTank* _tmp0_;
	self = (DataSource*) base;
	g_return_if_fail (alteration != NULL);
	_tmp0_ = self->priv->holding_tank;
	if (_tmp0_ != NULL) {
		SourceHoldingTank* _tmp1_;
		_tmp1_ = self->priv->holding_tank;
		source_holding_tank_internal_notify_altered (_tmp1_, self, alteration);
	} else {
		data_source_contact_subscribers_alteration (self, alteration);
		DATA_OBJECT_CLASS (data_source_parent_class)->notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), alteration);
	}
}

static void
data_source_real_notify_unlinking (DataSource* self,
                                   SourceCollection* collection)
{
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp3_;
	g_return_if_fail (collection != NULL);
	_tmp1_ = self->priv->backlinks;
	if (_tmp1_ == NULL) {
		SourceCollection* _tmp2_;
		_tmp2_ = self->priv->unlinked_from_collection;
		_tmp0_ = _tmp2_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "backlinks == null && unlinked_from_collection == null");
	self->priv->unlinked_from_collection = collection;
	_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->backlinks);
	self->priv->backlinks = _tmp3_;
}

void
data_source_notify_unlinking (DataSource* self,
                              SourceCollection* collection)
{
	DataSourceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = DATA_SOURCE_GET_CLASS (self);
	if (_klass_->notify_unlinking) {
		_klass_->notify_unlinking (self, collection);
	}
}

static void
data_source_real_notify_unlinked (DataSource* self)
{
	gboolean _tmp0_ = FALSE;
	SourceCollection* _tmp1_;
	SourceCollection* _tmp3_;
	GeeHashMap* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	_tmp1_ = self->priv->unlinked_from_collection;
	if (_tmp1_ != NULL) {
		GeeHashMap* _tmp2_;
		_tmp2_ = self->priv->backlinks;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "unlinked_from_collection != null && backlinks != null");
	_tmp3_ = self->priv->unlinked_from_collection;
	g_signal_emit (self, data_source_signals[DATA_SOURCE_UNLINKED_SIGNAL], 0, _tmp3_);
	_tmp4_ = self->priv->backlinks;
	_tmp5_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ > 0) {
		SourceCollection* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = self->priv->unlinked_from_collection;
		_tmp8_ = data_source_dehydrate_backlinks (self);
		_tmp9_ = _tmp8_;
		data_source_commit_backlinks (self, _tmp7_, _tmp9_);
		_g_free0 (_tmp9_);
	}
}

void
data_source_notify_unlinked (DataSource* self)
{
	DataSourceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = DATA_SOURCE_GET_CLASS (self);
	if (_klass_->notify_unlinked) {
		_klass_->notify_unlinked (self);
	}
}

static void
data_source_real_notify_relinking (DataSource* self,
                                   SourceCollection* collection)
{
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_;
	g_return_if_fail (collection != NULL);
	_tmp1_ = self->priv->backlinks;
	if (_tmp1_ != NULL) {
		SourceCollection* _tmp2_;
		_tmp2_ = self->priv->unlinked_from_collection;
		_tmp0_ = _tmp2_ == collection;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "(backlinks != null) && (unlinked_from_collection == collection)");
}

void
data_source_notify_relinking (DataSource* self,
                              SourceCollection* collection)
{
	DataSourceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = DATA_SOURCE_GET_CLASS (self);
	if (_klass_->notify_relinking) {
		_klass_->notify_relinking (self, collection);
	}
}

static gpointer
_data_collection_ref0 (gpointer self)
{
	return self ? data_collection_ref (self) : NULL;
}

static void
data_source_real_notify_relinked (DataSource* self)
{
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_;
	SourceCollection* relinked_to = NULL;
	SourceCollection* _tmp3_;
	SourceCollection* _tmp4_;
	_tmp1_ = self->priv->backlinks;
	if (_tmp1_ != NULL) {
		SourceCollection* _tmp2_;
		_tmp2_ = self->priv->unlinked_from_collection;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "backlinks != null && unlinked_from_collection != null");
	_tmp3_ = self->priv->unlinked_from_collection;
	_tmp4_ = _data_collection_ref0 (_tmp3_);
	relinked_to = _tmp4_;
	_g_object_unref0 (self->priv->backlinks);
	self->priv->backlinks = NULL;
	self->priv->unlinked_from_collection = NULL;
	g_signal_emit (self, data_source_signals[DATA_SOURCE_RELINKED_SIGNAL], 0, relinked_to);
	data_source_commit_backlinks (self, NULL, NULL);
	_data_collection_unref0 (relinked_to);
}

void
data_source_notify_relinked (DataSource* self)
{
	DataSourceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = DATA_SOURCE_GET_CLASS (self);
	if (_klass_->notify_relinked) {
		_klass_->notify_relinked (self);
	}
}

static gchar*
data_source_real_get_typename (DataSource* self)
{
	g_critical ("Type `%s' does not implement abstract method `data_source_get_typename'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
data_source_get_typename (DataSource* self)
{
	DataSourceClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = DATA_SOURCE_GET_CLASS (self);
	if (_klass_->get_typename) {
		return _klass_->get_typename (self);
	}
	return NULL;
}

static gint64
data_source_real_get_instance_id (DataSource* self)
{
	gint64 _tmp0_ = 0LL;
	g_critical ("Type `%s' does not implement abstract method `data_source_get_instance_id'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gint64
data_source_get_instance_id (DataSource* self)
{
	DataSourceClass* _klass_;
	g_return_val_if_fail (self != NULL, 0LL);
	_klass_ = DATA_SOURCE_GET_CLASS (self);
	if (_klass_->get_instance_id) {
		return _klass_->get_instance_id (self);
	}
	return -1LL;
}

static gchar*
data_source_real_get_source_id (DataSource* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	_tmp0_ = data_source_get_typename (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%s-%016" G_GINT64_MODIFIER "x", _tmp1_, data_source_get_instance_id (self));
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gchar*
data_source_get_source_id (DataSource* self)
{
	DataSourceClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = DATA_SOURCE_GET_CLASS (self);
	if (_klass_->get_source_id) {
		return _klass_->get_source_id (self);
	}
	return NULL;
}

gboolean
data_source_has_backlink (DataSource* self,
                          SourceBacklink* backlink)
{
	GeeHashMap* _tmp0_;
	GeeList* values = NULL;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gpointer _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeList* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (backlink != NULL, FALSE);
	_tmp0_ = self->priv->backlinks;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->backlinks;
	_tmp2_ = source_backlink_get_name (backlink);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _tmp3_);
	values = (GeeList*) _tmp4_;
	_tmp6_ = values;
	if (_tmp6_ != NULL) {
		GeeList* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp7_ = values;
		_tmp8_ = source_backlink_get_value (backlink);
		_tmp9_ = _tmp8_;
		_tmp5_ = gee_collection_contains ((GeeCollection*) _tmp7_, _tmp9_);
	} else {
		_tmp5_ = FALSE;
	}
	result = _tmp5_;
	_g_object_unref0 (values);
	return result;
}

GeeList*
data_source_get_backlinks (DataSource* self,
                           const gchar* name)
{
	GeeHashMap* _tmp0_;
	GeeList* values = NULL;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeList* _tmp4_;
	GeeList* backlinks = NULL;
	GeeArrayList* _tmp8_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->backlinks;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->backlinks;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, name);
	values = (GeeList*) _tmp2_;
	_tmp4_ = values;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = values;
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ == 0;
	}
	if (_tmp3_) {
		result = NULL;
		_g_object_unref0 (values);
		return result;
	}
	_tmp8_ = gee_array_list_new (TYPE_SOURCE_BACKLINK, (GBoxedCopyFunc) source_backlink_ref, (GDestroyNotify) source_backlink_unref, NULL, NULL, NULL);
	backlinks = (GeeList*) _tmp8_;
	{
		GeeList* _value_list = NULL;
		GeeList* _tmp9_;
		gint _value_size = 0;
		GeeList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _value_index = 0;
		_tmp9_ = values;
		_value_list = _tmp9_;
		_tmp10_ = _value_list;
		_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_value_size = _tmp12_;
		_value_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			gchar* value = NULL;
			GeeList* _tmp15_;
			gpointer _tmp16_;
			GeeList* _tmp17_;
			const gchar* _tmp18_;
			SourceBacklink* _tmp19_;
			SourceBacklink* _tmp20_;
			_value_index = _value_index + 1;
			_tmp13_ = _value_index;
			_tmp14_ = _value_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _value_list;
			_tmp16_ = gee_list_get (_tmp15_, _value_index);
			value = (gchar*) _tmp16_;
			_tmp17_ = backlinks;
			_tmp18_ = value;
			_tmp19_ = source_backlink_new (name, _tmp18_);
			_tmp20_ = _tmp19_;
			gee_collection_add ((GeeCollection*) _tmp17_, _tmp20_);
			_source_backlink_unref0 (_tmp20_);
			_g_free0 (value);
		}
	}
	result = backlinks;
	_g_object_unref0 (values);
	return result;
}

void
data_source_set_backlink (DataSource* self,
                          SourceBacklink* backlink)
{
	GeeHashMap* _tmp0_;
	GeeList* values = NULL;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gpointer _tmp4_;
	GeeList* _tmp5_;
	GeeList* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	SourceCollection* sources = NULL;
	DataCollection* _tmp14_;
	SourceCollection* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backlink != NULL);
	_tmp0_ = self->priv->backlinks;
	_vala_assert (_tmp0_ != NULL, "backlinks != null");
	_tmp1_ = self->priv->backlinks;
	_tmp2_ = source_backlink_get_name (backlink);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _tmp3_);
	values = (GeeList*) _tmp4_;
	_tmp5_ = values;
	if (_tmp5_ == NULL) {
		GeeArrayList* _tmp6_;
		GeeHashMap* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		GeeList* _tmp10_;
		_tmp6_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		_g_object_unref0 (values);
		values = (GeeList*) _tmp6_;
		_tmp7_ = self->priv->backlinks;
		_tmp8_ = source_backlink_get_name (backlink);
		_tmp9_ = _tmp8_;
		_tmp10_ = values;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp7_, _tmp9_, _tmp10_);
	}
	_tmp11_ = values;
	_tmp12_ = source_backlink_get_value (backlink);
	_tmp13_ = _tmp12_;
	gee_collection_add ((GeeCollection*) _tmp11_, _tmp13_);
	_tmp14_ = data_object_get_membership ((DataObject*) self);
	sources = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_SOURCE_COLLECTION, SourceCollection);
	_tmp15_ = sources;
	if (_tmp15_ != NULL) {
		SourceCollection* _tmp16_;
		_tmp16_ = sources;
		source_collection_internal_backlink_set (_tmp16_, self, backlink);
	}
	_data_collection_unref0 (sources);
	_g_object_unref0 (values);
}

gboolean
data_source_remove_backlink (DataSource* self,
                             SourceBacklink* backlink)
{
	GeeHashMap* _tmp0_;
	GeeList* values = NULL;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gpointer _tmp4_;
	GeeList* _tmp5_;
	gint original_size = 0;
	GeeList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GeeIterator* iter = NULL;
	GeeList* _tmp9_;
	GeeIterator* _tmp10_;
	GeeList* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	SourceCollection* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	SourceCollection* sources = NULL;
	DataCollection* _tmp28_;
	SourceCollection* _tmp29_;
	GeeList* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (backlink != NULL, FALSE);
	_tmp0_ = self->priv->backlinks;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->backlinks;
	_tmp2_ = source_backlink_get_name (backlink);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _tmp3_);
	values = (GeeList*) _tmp4_;
	_tmp5_ = values;
	if (_tmp5_ == NULL) {
		result = FALSE;
		_g_object_unref0 (values);
		return result;
	}
	_tmp6_ = values;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	original_size = _tmp8_;
	_vala_assert (original_size > 0, "original_size > 0");
	_tmp9_ = values;
	_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
	iter = _tmp10_;
	while (TRUE) {
		GeeIterator* _tmp11_;
		GeeIterator* _tmp12_;
		gpointer _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gboolean _tmp17_;
		_tmp11_ = iter;
		if (!gee_iterator_next (_tmp11_)) {
			break;
		}
		_tmp12_ = iter;
		_tmp13_ = gee_iterator_get (_tmp12_);
		_tmp14_ = (gchar*) _tmp13_;
		_tmp15_ = source_backlink_get_value (backlink);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strcmp0 (_tmp14_, _tmp16_) == 0;
		_g_free0 (_tmp14_);
		if (_tmp17_) {
			GeeIterator* _tmp18_;
			_tmp18_ = iter;
			gee_iterator_remove (_tmp18_);
		}
	}
	_tmp19_ = values;
	_tmp20_ = gee_collection_get_size ((GeeCollection*) _tmp19_);
	_tmp21_ = _tmp20_;
	if (_tmp21_ == 0) {
		GeeHashMap* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		_tmp22_ = self->priv->backlinks;
		_tmp23_ = source_backlink_get_name (backlink);
		_tmp24_ = _tmp23_;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp22_, _tmp24_, NULL);
	}
	_tmp25_ = self->priv->unlinked_from_collection;
	_tmp26_ = data_source_dehydrate_backlinks (self);
	_tmp27_ = _tmp26_;
	data_source_commit_backlinks (self, _tmp25_, _tmp27_);
	_g_free0 (_tmp27_);
	_tmp28_ = data_object_get_membership ((DataObject*) self);
	sources = G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, TYPE_SOURCE_COLLECTION, SourceCollection);
	_tmp29_ = sources;
	if (_tmp29_ != NULL) {
		SourceCollection* _tmp30_;
		_tmp30_ = sources;
		source_collection_internal_backlink_removed (_tmp30_, self, backlink);
	}
	_tmp31_ = values;
	_tmp32_ = gee_collection_get_size ((GeeCollection*) _tmp31_);
	_tmp33_ = _tmp32_;
	result = _tmp33_ != original_size;
	_data_collection_unref0 (sources);
	_g_object_unref0 (iter);
	_g_object_unref0 (values);
	return result;
}

static void
data_source_real_commit_backlinks (DataSource* self,
                                   SourceCollection* sources,
                                   const gchar* dehydrated)
{
	gboolean _tmp0_ = FALSE;
	if (sources != NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = dehydrated != NULL;
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = data_object_to_string ((DataObject*) self);
		_tmp2_ = _tmp1_;
		g_warning ("DataSource.vala:263: No implementation to commit link state for %s", _tmp2_);
		_g_free0 (_tmp2_);
	}
}

void
data_source_commit_backlinks (DataSource* self,
                              SourceCollection* sources,
                              const gchar* dehydrated)
{
	DataSourceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = DATA_SOURCE_GET_CLASS (self);
	if (_klass_->commit_backlinks) {
		_klass_->commit_backlinks (self, sources, dehydrated);
	}
}

static gchar*
data_source_dehydrate_backlinks (DataSource* self)
{
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_;
	GString* builder = NULL;
	GString* _tmp5_;
	const gchar* _tmp46_ = NULL;
	GString* _tmp47_;
	const gchar* _tmp48_;
	gint _tmp49_;
	gint _tmp50_;
	gchar* _tmp53_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->backlinks;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GeeHashMap* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->backlinks;
		_tmp3_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == 0;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp5_ = g_string_new ("");
	builder = _tmp5_;
	{
		GeeIterator* _name_it = NULL;
		GeeHashMap* _tmp6_;
		GeeSet* _tmp7_;
		GeeSet* _tmp8_;
		GeeSet* _tmp9_;
		GeeIterator* _tmp10_;
		GeeIterator* _tmp11_;
		_tmp6_ = self->priv->backlinks;
		_tmp7_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp9_);
		_name_it = _tmp11_;
		while (TRUE) {
			GeeIterator* _tmp12_;
			gchar* name = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			GeeList* values = NULL;
			GeeHashMap* _tmp15_;
			const gchar* _tmp16_;
			gpointer _tmp17_;
			gboolean _tmp18_ = FALSE;
			GeeList* _tmp19_;
			gchar* value_field = NULL;
			gchar* _tmp23_;
			const gchar* _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			_tmp12_ = _name_it;
			if (!gee_iterator_next (_tmp12_)) {
				break;
			}
			_tmp13_ = _name_it;
			_tmp14_ = gee_iterator_get (_tmp13_);
			name = (gchar*) _tmp14_;
			_tmp15_ = self->priv->backlinks;
			_tmp16_ = name;
			_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, _tmp16_);
			values = (GeeList*) _tmp17_;
			_tmp19_ = values;
			if (_tmp19_ == NULL) {
				_tmp18_ = TRUE;
			} else {
				GeeList* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				_tmp20_ = values;
				_tmp21_ = gee_collection_get_size ((GeeCollection*) _tmp20_);
				_tmp22_ = _tmp21_;
				_tmp18_ = _tmp22_ == 0;
			}
			if (_tmp18_) {
				_g_object_unref0 (values);
				_g_free0 (name);
				continue;
			}
			_tmp23_ = g_strdup ("");
			value_field = _tmp23_;
			{
				GeeList* _value_list = NULL;
				GeeList* _tmp24_;
				gint _value_size = 0;
				GeeList* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				gint _value_index = 0;
				_tmp24_ = values;
				_value_list = _tmp24_;
				_tmp25_ = _value_list;
				_tmp26_ = gee_collection_get_size ((GeeCollection*) _tmp25_);
				_tmp27_ = _tmp26_;
				_value_size = _tmp27_;
				_value_index = -1;
				while (TRUE) {
					gint _tmp28_;
					gint _tmp29_;
					gchar* value = NULL;
					GeeList* _tmp30_;
					gpointer _tmp31_;
					const gchar* _tmp32_;
					_value_index = _value_index + 1;
					_tmp28_ = _value_index;
					_tmp29_ = _value_size;
					if (!(_tmp28_ < _tmp29_)) {
						break;
					}
					_tmp30_ = _value_list;
					_tmp31_ = gee_list_get (_tmp30_, _value_index);
					value = (gchar*) _tmp31_;
					_tmp32_ = value;
					if (!is_string_empty (_tmp32_)) {
						const gchar* _tmp33_;
						const gchar* _tmp34_;
						gchar* _tmp35_;
						gchar* _tmp36_;
						gchar* _tmp37_;
						_tmp33_ = value_field;
						_tmp34_ = value;
						_tmp35_ = g_strconcat (_tmp34_, "|", NULL);
						_tmp36_ = _tmp35_;
						_tmp37_ = g_strconcat (_tmp33_, _tmp36_, NULL);
						_g_free0 (value_field);
						value_field = _tmp37_;
						_g_free0 (_tmp36_);
					}
					_g_free0 (value);
				}
			}
			_tmp38_ = value_field;
			_tmp39_ = strlen (_tmp38_);
			_tmp40_ = _tmp39_;
			if (_tmp40_ > 0) {
				GString* _tmp41_;
				const gchar* _tmp42_;
				const gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				_tmp41_ = builder;
				_tmp42_ = name;
				_tmp43_ = value_field;
				_tmp44_ = g_strdup_printf ("%s=%s\n", _tmp42_, _tmp43_);
				_tmp45_ = _tmp44_;
				g_string_append (_tmp41_, _tmp45_);
				_g_free0 (_tmp45_);
			}
			_g_free0 (value_field);
			_g_object_unref0 (values);
			_g_free0 (name);
		}
		_g_object_unref0 (_name_it);
	}
	_tmp47_ = builder;
	_tmp48_ = _tmp47_->str;
	_tmp49_ = strlen (_tmp48_);
	_tmp50_ = _tmp49_;
	if (_tmp50_ > 0) {
		GString* _tmp51_;
		const gchar* _tmp52_;
		_tmp51_ = builder;
		_tmp52_ = _tmp51_->str;
		_tmp46_ = _tmp52_;
	} else {
		_tmp46_ = NULL;
	}
	_tmp53_ = g_strdup (_tmp46_);
	result = _tmp53_;
	_g_string_free0 (builder);
	return result;
}

void
data_source_rehydrate_backlinks (DataSource* self,
                                 SourceCollection* unlinked_from,
                                 const gchar* dehydrated)
{
	GeeHashMap* _tmp0_;
	gchar** lines = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint lines_length1;
	gint _lines_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (unlinked_from != NULL);
	self->priv->unlinked_from_collection = unlinked_from;
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->backlinks);
	self->priv->backlinks = _tmp0_;
	if (dehydrated == NULL) {
		return;
	}
	_tmp2_ = _tmp1_ = g_strsplit (dehydrated, "\n", 0);
	lines = _tmp2_;
	lines_length1 = _vala_array_length (_tmp1_);
	_lines_size_ = lines_length1;
	_tmp3_ = lines;
	_tmp3__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp3_;
		line_collection_length1 = _tmp3__length1;
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp4_;
			gchar* line = NULL;
			_tmp4_ = g_strdup (line_collection[line_it]);
			line = _tmp4_;
			{
				const gchar* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				gchar** tokens = NULL;
				const gchar* _tmp8_;
				gchar** _tmp9_;
				gchar** _tmp10_;
				gint tokens_length1;
				gint _tokens_size_;
				gchar** _tmp11_;
				gint _tmp11__length1;
				gchar** decoded_values = NULL;
				gchar** _tmp15_;
				gint _tmp15__length1;
				const gchar* _tmp16_;
				gchar** _tmp17_;
				gchar** _tmp18_;
				gint decoded_values_length1;
				gint _decoded_values_size_;
				GeeList* values = NULL;
				GeeArrayList* _tmp19_;
				gchar** _tmp20_;
				gint _tmp20__length1;
				GeeList* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				_tmp5_ = line;
				_tmp6_ = strlen (_tmp5_);
				_tmp7_ = _tmp6_;
				if (_tmp7_ == 0) {
					_g_free0 (line);
					continue;
				}
				_tmp8_ = line;
				_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, "=", 2);
				tokens = _tmp10_;
				tokens_length1 = _vala_array_length (_tmp9_);
				_tokens_size_ = tokens_length1;
				_tmp11_ = tokens;
				_tmp11__length1 = tokens_length1;
				if (_tmp11__length1 < 2) {
					const gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp12_ = line;
					_tmp13_ = data_object_to_string ((DataObject*) self);
					_tmp14_ = _tmp13_;
					g_warning ("DataSource.vala:305: Unable to rehydrate \"%s\" for %s: name and value" \
" not present", _tmp12_, _tmp14_);
					_g_free0 (_tmp14_);
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					continue;
				}
				_tmp15_ = tokens;
				_tmp15__length1 = tokens_length1;
				_tmp16_ = _tmp15_[1];
				_tmp18_ = _tmp17_ = g_strsplit (_tmp16_, "|", 0);
				decoded_values = _tmp18_;
				decoded_values_length1 = _vala_array_length (_tmp17_);
				_decoded_values_size_ = decoded_values_length1;
				_tmp19_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
				values = (GeeList*) _tmp19_;
				_tmp20_ = decoded_values;
				_tmp20__length1 = decoded_values_length1;
				{
					gchar** value_collection = NULL;
					gint value_collection_length1 = 0;
					gint _value_collection_size_ = 0;
					gint value_it = 0;
					value_collection = _tmp20_;
					value_collection_length1 = _tmp20__length1;
					for (value_it = 0; value_it < value_collection_length1; value_it = value_it + 1) {
						gchar* _tmp21_;
						gchar* value = NULL;
						_tmp21_ = g_strdup (value_collection[value_it]);
						value = _tmp21_;
						{
							gboolean _tmp22_ = FALSE;
							const gchar* _tmp23_;
							_tmp23_ = value;
							if (_tmp23_ != NULL) {
								const gchar* _tmp24_;
								gint _tmp25_;
								gint _tmp26_;
								_tmp24_ = value;
								_tmp25_ = strlen (_tmp24_);
								_tmp26_ = _tmp25_;
								_tmp22_ = _tmp26_ > 0;
							} else {
								_tmp22_ = FALSE;
							}
							if (_tmp22_) {
								GeeList* _tmp27_;
								const gchar* _tmp28_;
								_tmp27_ = values;
								_tmp28_ = value;
								gee_collection_add ((GeeCollection*) _tmp27_, _tmp28_);
							}
							_g_free0 (value);
						}
					}
				}
				_tmp29_ = values;
				_tmp30_ = gee_collection_get_size ((GeeCollection*) _tmp29_);
				_tmp31_ = _tmp30_;
				if (_tmp31_ > 0) {
					GeeHashMap* _tmp32_;
					gchar** _tmp33_;
					gint _tmp33__length1;
					const gchar* _tmp34_;
					GeeList* _tmp35_;
					_tmp32_ = self->priv->backlinks;
					_tmp33_ = tokens;
					_tmp33__length1 = tokens_length1;
					_tmp34_ = _tmp33_[0];
					_tmp35_ = values;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp32_, _tmp34_, _tmp35_);
				}
				_g_object_unref0 (values);
				decoded_values = (_vala_array_free (decoded_values, decoded_values_length1, (GDestroyNotify) g_free), NULL);
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
	}
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
}

static SourceSnapshot*
data_source_real_save_snapshot (DataSource* self)
{
	SourceSnapshot* result;
	result = NULL;
	return result;
}

SourceSnapshot*
data_source_save_snapshot (DataSource* self)
{
	DataSourceClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = DATA_SOURCE_GET_CLASS (self);
	if (_klass_->save_snapshot) {
		return _klass_->save_snapshot (self);
	}
	return NULL;
}

void
data_source_internal_mark_for_destroy (DataSource* self)
{
	g_return_if_fail (self != NULL);
	self->priv->marked_for_destroy = TRUE;
}

static gboolean
data_source_real_internal_delete_backing (DataSource* self,
                                          GError** error)
{
	gboolean result;
	result = TRUE;
	return result;
}

gboolean
data_source_internal_delete_backing (DataSource* self,
                                     GError** error)
{
	DataSourceClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = DATA_SOURCE_GET_CLASS (self);
	if (_klass_->internal_delete_backing) {
		return _klass_->internal_delete_backing (self, error);
	}
	return FALSE;
}

static gboolean
data_source_real_equals (DataSource* self,
                         DataSource* source)
{
	gboolean result;
	result = self == source;
	return result;
}

gboolean
data_source_equals (DataSource* self,
                    DataSource* source)
{
	DataSourceClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = DATA_SOURCE_GET_CLASS (self);
	if (_klass_->equals) {
		return _klass_->equals (self, source);
	}
	return FALSE;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
data_source_real_destroy (DataSource* self)
{
	_vala_assert (self->priv->marked_for_destroy, "marked_for_destroy");
	self->priv->is_destroyed = TRUE;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				DataView** _tmp2_;
				gint _tmp2__length1;
				DataView** _tmp3_;
				gint _tmp3__length1;
				DataView* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = ctr;
					ctr = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->subscribers;
				_tmp2__length1 = self->priv->subscribers_length1;
				if (!(ctr < _tmp2__length1)) {
					break;
				}
				_tmp3_ = self->priv->subscribers;
				_tmp3__length1 = self->priv->subscribers_length1;
				_tmp4_ = _tmp3_[ctr];
				if (_tmp4_ != NULL) {
					DataView* view = NULL;
					DataView** _tmp5_;
					gint _tmp5__length1;
					DataView* _tmp6_;
					DataView* _tmp7_;
					DataView** _tmp8_;
					gint _tmp8__length1;
					DataView* _tmp9_;
					_tmp5_ = self->priv->subscribers;
					_tmp5__length1 = self->priv->subscribers_length1;
					_tmp6_ = _tmp5_[ctr];
					_tmp7_ = _g_object_ref0 (_tmp6_);
					view = _tmp7_;
					_tmp8_ = self->priv->subscribers;
					_tmp8__length1 = self->priv->subscribers_length1;
					_g_object_unref0 (_tmp8_[ctr]);
					_tmp8_[ctr] = NULL;
					_tmp9_ = view;
					data_view_notify_unsubscribed (_tmp9_, self);
					_g_object_unref0 (view);
				}
			}
		}
	}
	g_signal_emit (self, data_source_signals[DATA_SOURCE_DESTROYED_SIGNAL], 0);
}

void
data_source_destroy (DataSource* self)
{
	DataSourceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = DATA_SOURCE_GET_CLASS (self);
	if (_klass_->destroy) {
		_klass_->destroy (self);
	}
}

gboolean
data_source_destroy_orphan (DataSource* self,
                            gboolean delete_backing)
{
	gboolean ret = FALSE;
	SourceCollection* _tmp8_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	ret = TRUE;
	if (delete_backing) {
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = data_source_internal_delete_backing (self, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			ret = _tmp0_;
			if (!ret) {
				gchar* _tmp1_;
				gchar* _tmp2_;
				_tmp1_ = data_object_to_string ((DataObject*) self);
				_tmp2_ = _tmp1_;
				g_warning ("DataSource.vala:385: Unable to delete backing for %s", _tmp2_);
				_g_free0 (_tmp2_);
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			gchar* _tmp3_;
			gchar* _tmp4_;
			GError* _tmp5_;
			const gchar* _tmp6_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = data_object_to_string ((DataObject*) self);
			_tmp4_ = _tmp3_;
			_tmp5_ = err;
			_tmp6_ = _tmp5_->message;
			g_warning ("DataSource.vala:388: Unable to delete backing for %s: %s", _tmp4_, _tmp6_);
			_g_free0 (_tmp4_);
			ret = FALSE;
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp7_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp7_;
		}
	}
	data_source_internal_mark_for_destroy (self);
	data_source_destroy (self);
	_tmp8_ = self->priv->unlinked_from_collection;
	if (_tmp8_ != NULL) {
		SourceCollection* _tmp9_;
		_tmp9_ = self->priv->unlinked_from_collection;
		source_collection_notify_unlinked_destroyed (_tmp9_, self);
	}
	result = ret;
	return result;
}

static void
_vala_array_add48 (DataView** * array,
                   gint* length,
                   gint* size,
                   DataView* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (DataView*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
data_source_internal_subscribe (DataSource* self,
                                DataView* view)
{
	DataView* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	_vala_assert (!self->priv->in_contact, "!in_contact");
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				DataView** _tmp2_;
				gint _tmp2__length1;
				DataView** _tmp3_;
				gint _tmp3__length1;
				DataView* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = ctr;
					ctr = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->subscribers;
				_tmp2__length1 = self->priv->subscribers_length1;
				if (!(ctr < _tmp2__length1)) {
					break;
				}
				_tmp3_ = self->priv->subscribers;
				_tmp3__length1 = self->priv->subscribers_length1;
				_tmp4_ = _tmp3_[ctr];
				if (_tmp4_ == NULL) {
					DataView** _tmp5_;
					gint _tmp5__length1;
					DataView* _tmp6_;
					_tmp5_ = self->priv->subscribers;
					_tmp5__length1 = self->priv->subscribers_length1;
					_tmp6_ = _g_object_ref0 (view);
					_g_object_unref0 (_tmp5_[ctr]);
					_tmp5_[ctr] = _tmp6_;
					return;
				}
			}
		}
	}
	_tmp7_ = _g_object_ref0 (view);
	_vala_array_add48 (&self->priv->subscribers, &self->priv->subscribers_length1, &self->priv->_subscribers_size_, _tmp7_);
}

void
data_source_internal_unsubscribe (DataSource* self,
                                  DataView* view)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	_vala_assert (!self->priv->in_contact, "!in_contact");
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				DataView** _tmp2_;
				gint _tmp2__length1;
				DataView** _tmp3_;
				gint _tmp3__length1;
				DataView* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = ctr;
					ctr = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->subscribers;
				_tmp2__length1 = self->priv->subscribers_length1;
				if (!(ctr < _tmp2__length1)) {
					break;
				}
				_tmp3_ = self->priv->subscribers;
				_tmp3__length1 = self->priv->subscribers_length1;
				_tmp4_ = _tmp3_[ctr];
				if (_tmp4_ == view) {
					DataView** _tmp5_;
					gint _tmp5__length1;
					_tmp5_ = self->priv->subscribers;
					_tmp5__length1 = self->priv->subscribers_length1;
					_g_object_unref0 (_tmp5_[ctr]);
					_tmp5_[ctr] = NULL;
					return;
				}
			}
		}
	}
}

void
data_source_contact_subscribers (DataSource* self,
                                 DataSourceContactSubscriber contact_subscriber,
                                 gpointer contact_subscriber_target)
{
	g_return_if_fail (self != NULL);
	_vala_assert (!self->priv->in_contact, "!in_contact");
	self->priv->in_contact = TRUE;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				DataView** _tmp2_;
				gint _tmp2__length1;
				DataView** _tmp3_;
				gint _tmp3__length1;
				DataView* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = ctr;
					ctr = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->subscribers;
				_tmp2__length1 = self->priv->subscribers_length1;
				if (!(ctr < _tmp2__length1)) {
					break;
				}
				_tmp3_ = self->priv->subscribers;
				_tmp3__length1 = self->priv->subscribers_length1;
				_tmp4_ = _tmp3_[ctr];
				if (_tmp4_ != NULL) {
					DataView** _tmp5_;
					gint _tmp5__length1;
					DataView* _tmp6_;
					_tmp5_ = self->priv->subscribers;
					_tmp5__length1 = self->priv->subscribers_length1;
					_tmp6_ = _tmp5_[ctr];
					contact_subscriber (_tmp6_, contact_subscriber_target);
				}
			}
		}
	}
	self->priv->in_contact = FALSE;
}

void
data_source_contact_subscribers_alteration (DataSource* self,
                                            Alteration* alteration)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (alteration != NULL);
	_vala_assert (!self->priv->in_contact, "!in_contact");
	self->priv->in_contact = TRUE;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				DataView** _tmp2_;
				gint _tmp2__length1;
				DataView** _tmp3_;
				gint _tmp3__length1;
				DataView* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = ctr;
					ctr = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->subscribers;
				_tmp2__length1 = self->priv->subscribers_length1;
				if (!(ctr < _tmp2__length1)) {
					break;
				}
				_tmp3_ = self->priv->subscribers;
				_tmp3__length1 = self->priv->subscribers_length1;
				_tmp4_ = _tmp3_[ctr];
				if (_tmp4_ != NULL) {
					DataView** _tmp5_;
					gint _tmp5__length1;
					DataView* _tmp6_;
					_tmp5_ = self->priv->subscribers;
					_tmp5__length1 = self->priv->subscribers_length1;
					_tmp6_ = _tmp5_[ctr];
					data_object_notify_altered ((DataObject*) _tmp6_, alteration);
				}
			}
		}
	}
	self->priv->in_contact = FALSE;
}

static void
data_source_real_unlinked (DataSource* self,
                           SourceCollection* sources)
{
	g_return_if_fail (sources != NULL);
}

static void
g_cclosure_user_marshal_VOID__DATA_COLLECTION (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__DATA_COLLECTION) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__DATA_COLLECTION callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__DATA_COLLECTION) (marshal_data ? marshal_data : cc->callback);
	callback (data1, value_get_data_collection (param_values + 1), data2);
}

static void
data_source_real_relinked (DataSource* self,
                           SourceCollection* sources)
{
	g_return_if_fail (sources != NULL);
}

static void
data_source_real_destroyed (DataSource* self)
{
}

static void
data_source_class_init (DataSourceClass * klass,
                        gpointer klass_data)
{
	data_source_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DataSource_private_offset);
	((DataObjectClass *) klass)->notify_membership_changed = (void (*) (DataObject*, DataCollection*)) data_source_real_notify_membership_changed;
	((DataSourceClass *) klass)->notify_held_in_tank = (void (*) (DataSource*, SourceHoldingTank*)) data_source_real_notify_held_in_tank;
	((DataObjectClass *) klass)->notify_altered = (void (*) (DataObject*, Alteration*)) data_source_real_notify_altered;
	((DataSourceClass *) klass)->notify_unlinking = (void (*) (DataSource*, SourceCollection*)) data_source_real_notify_unlinking;
	((DataSourceClass *) klass)->notify_unlinked = (void (*) (DataSource*)) data_source_real_notify_unlinked;
	((DataSourceClass *) klass)->notify_relinking = (void (*) (DataSource*, SourceCollection*)) data_source_real_notify_relinking;
	((DataSourceClass *) klass)->notify_relinked = (void (*) (DataSource*)) data_source_real_notify_relinked;
	((DataSourceClass *) klass)->get_typename = (gchar* (*) (DataSource*)) data_source_real_get_typename;
	((DataSourceClass *) klass)->get_instance_id = (gint64 (*) (DataSource*)) data_source_real_get_instance_id;
	((DataSourceClass *) klass)->get_source_id = (gchar* (*) (DataSource*)) data_source_real_get_source_id;
	((DataSourceClass *) klass)->commit_backlinks = (void (*) (DataSource*, SourceCollection*, const gchar*)) data_source_real_commit_backlinks;
	((DataSourceClass *) klass)->save_snapshot = (SourceSnapshot* (*) (DataSource*)) data_source_real_save_snapshot;
	((DataSourceClass *) klass)->internal_delete_backing = (gboolean (*) (DataSource*, GError**)) data_source_real_internal_delete_backing;
	((DataSourceClass *) klass)->equals = (gboolean (*) (DataSource*, DataSource*)) data_source_real_equals;
	((DataSourceClass *) klass)->destroy = (void (*) (DataSource*)) data_source_real_destroy;
	((DataSourceClass *) klass)->unlinked = data_source_real_unlinked;
	((DataSourceClass *) klass)->relinked = data_source_real_relinked;
	((DataSourceClass *) klass)->destroyed = data_source_real_destroyed;
	G_OBJECT_CLASS (klass)->finalize = data_source_finalize;
	data_source_signals[DATA_SOURCE_UNLINKED_SIGNAL] = g_signal_new ("unlinked", TYPE_DATA_SOURCE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataSourceClass, unlinked), NULL, NULL, g_cclosure_user_marshal_VOID__DATA_COLLECTION, G_TYPE_NONE, 1, TYPE_SOURCE_COLLECTION);
	data_source_signals[DATA_SOURCE_RELINKED_SIGNAL] = g_signal_new ("relinked", TYPE_DATA_SOURCE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataSourceClass, relinked), NULL, NULL, g_cclosure_user_marshal_VOID__DATA_COLLECTION, G_TYPE_NONE, 1, TYPE_SOURCE_COLLECTION);
	data_source_signals[DATA_SOURCE_DESTROYED_SIGNAL] = g_signal_new ("destroyed", TYPE_DATA_SOURCE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataSourceClass, destroyed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
data_source_instance_init (DataSource * self,
                           gpointer klass)
{
	DataView** _tmp0_;
	self->priv = data_source_get_instance_private (self);
	_tmp0_ = g_new0 (DataView*, 4 + 1);
	self->priv->subscribers = _tmp0_;
	self->priv->subscribers_length1 = 4;
	self->priv->_subscribers_size_ = self->priv->subscribers_length1;
	self->priv->holding_tank = NULL;
	self->priv->unlinked_from_collection = NULL;
	self->priv->backlinks = NULL;
	self->priv->in_contact = FALSE;
	self->priv->marked_for_destroy = FALSE;
	self->priv->is_destroyed = FALSE;
}

static void
data_source_finalize (GObject * obj)
{
	DataSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DATA_SOURCE, DataSource);
	self->priv->subscribers = (_vala_array_free (self->priv->subscribers, self->priv->subscribers_length1, (GDestroyNotify) g_object_unref), NULL);
	_source_holding_tank_unref0 (self->priv->holding_tank);
	_g_object_unref0 (self->priv->backlinks);
	G_OBJECT_CLASS (data_source_parent_class)->finalize (obj);
}

static GType
data_source_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DataSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) data_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DataSource), 0, (GInstanceInitFunc) data_source_instance_init, NULL };
	GType data_source_type_id;
	data_source_type_id = g_type_register_static (TYPE_DATA_OBJECT, "DataSource", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	DataSource_private_offset = g_type_add_instance_private (data_source_type_id, sizeof (DataSourcePrivate));
	return data_source_type_id;
}

GType
data_source_get_type (void)
{
	static volatile gsize data_source_type_id__once = 0;
	if (g_once_init_enter (&data_source_type_id__once)) {
		GType data_source_type_id;
		data_source_type_id = data_source_get_type_once ();
		g_once_init_leave (&data_source_type_id__once, data_source_type_id);
	}
	return data_source_type_id__once;
}

static inline gpointer
source_snapshot_get_instance_private (SourceSnapshot* self)
{
	return G_STRUCT_MEMBER_P (self, SourceSnapshot_private_offset);
}

static void
source_snapshot_real_notify_broken (SourceSnapshot* self)
{
	self->priv->snapshot_broken = TRUE;
	g_signal_emit (self, source_snapshot_signals[SOURCE_SNAPSHOT_BROKEN_SIGNAL], 0);
}

void
source_snapshot_notify_broken (SourceSnapshot* self)
{
	SourceSnapshotClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SOURCE_SNAPSHOT_GET_CLASS (self);
	if (_klass_->notify_broken) {
		_klass_->notify_broken (self);
	}
}

gboolean
source_snapshot_is_broken (SourceSnapshot* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->snapshot_broken;
	return result;
}

SourceSnapshot*
source_snapshot_construct (GType object_type)
{
	SourceSnapshot* self = NULL;
	self = (SourceSnapshot*) g_type_create_instance (object_type);
	return self;
}

static void
source_snapshot_real_broken (SourceSnapshot* self)
{
}

static void
value_source_snapshot_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_source_snapshot_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		source_snapshot_unref (value->data[0].v_pointer);
	}
}

static void
value_source_snapshot_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = source_snapshot_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_source_snapshot_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_source_snapshot_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		SourceSnapshot * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = source_snapshot_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_source_snapshot_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	SourceSnapshot ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = source_snapshot_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_source_snapshot (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	ParamSpecSourceSnapshot* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SOURCE_SNAPSHOT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_source_snapshot (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_SNAPSHOT), NULL);
	return value->data[0].v_pointer;
}

void
value_set_source_snapshot (GValue* value,
                           gpointer v_object)
{
	SourceSnapshot * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_SNAPSHOT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SOURCE_SNAPSHOT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		source_snapshot_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		source_snapshot_unref (old);
	}
}

void
value_take_source_snapshot (GValue* value,
                            gpointer v_object)
{
	SourceSnapshot * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_SNAPSHOT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SOURCE_SNAPSHOT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		source_snapshot_unref (old);
	}
}

static void
source_snapshot_class_init (SourceSnapshotClass * klass,
                            gpointer klass_data)
{
	source_snapshot_parent_class = g_type_class_peek_parent (klass);
	((SourceSnapshotClass *) klass)->finalize = source_snapshot_finalize;
	g_type_class_adjust_private_offset (klass, &SourceSnapshot_private_offset);
	((SourceSnapshotClass *) klass)->notify_broken = (void (*) (SourceSnapshot*)) source_snapshot_real_notify_broken;
	((SourceSnapshotClass *) klass)->broken = source_snapshot_real_broken;
	source_snapshot_signals[SOURCE_SNAPSHOT_BROKEN_SIGNAL] = g_signal_new ("broken", TYPE_SOURCE_SNAPSHOT, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceSnapshotClass, broken), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
source_snapshot_instance_init (SourceSnapshot * self,
                               gpointer klass)
{
	self->priv = source_snapshot_get_instance_private (self);
	self->priv->snapshot_broken = FALSE;
	self->ref_count = 1;
}

static void
source_snapshot_finalize (SourceSnapshot * obj)
{
	SourceSnapshot * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SOURCE_SNAPSHOT, SourceSnapshot);
	g_signal_handlers_destroy (self);
}

static GType
source_snapshot_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_source_snapshot_init, value_source_snapshot_free_value, value_source_snapshot_copy_value, value_source_snapshot_peek_pointer, "p", value_source_snapshot_collect_value, "p", value_source_snapshot_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SourceSnapshotClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) source_snapshot_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SourceSnapshot), 0, (GInstanceInitFunc) source_snapshot_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType source_snapshot_type_id;
	source_snapshot_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SourceSnapshot", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	SourceSnapshot_private_offset = g_type_add_instance_private (source_snapshot_type_id, sizeof (SourceSnapshotPrivate));
	return source_snapshot_type_id;
}

GType
source_snapshot_get_type (void)
{
	static volatile gsize source_snapshot_type_id__once = 0;
	if (g_once_init_enter (&source_snapshot_type_id__once)) {
		GType source_snapshot_type_id;
		source_snapshot_type_id = source_snapshot_get_type_once ();
		g_once_init_leave (&source_snapshot_type_id__once, source_snapshot_type_id);
	}
	return source_snapshot_type_id__once;
}

gpointer
source_snapshot_ref (gpointer instance)
{
	SourceSnapshot * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
source_snapshot_unref (gpointer instance)
{
	SourceSnapshot * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SOURCE_SNAPSHOT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
source_backlink_get_instance_private (SourceBacklink* self)
{
	return G_STRUCT_MEMBER_P (self, SourceBacklink_private_offset);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

SourceBacklink*
source_backlink_construct (GType object_type,
                           const gchar* name,
                           const gchar* value)
{
	SourceBacklink* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	self = (SourceBacklink*) g_type_create_instance (object_type);
	_vala_assert (source_backlink_validate_name_value (name, value), "validate_name_value (name, value)");
	_tmp0_ = string_strip (name);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
	_tmp1_ = string_strip (value);
	_g_free0 (self->priv->_value);
	self->priv->_value = _tmp1_;
	return self;
}

SourceBacklink*
source_backlink_new (const gchar* name,
                     const gchar* value)
{
	return source_backlink_construct (TYPE_SOURCE_BACKLINK, name, value);
}

SourceBacklink*
source_backlink_construct_from_source (GType object_type,
                                       DataSource* source)
{
	SourceBacklink* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_val_if_fail (source != NULL, NULL);
	self = (SourceBacklink*) g_type_create_instance (object_type);
	_tmp0_ = data_source_get_typename (source);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_strip (_tmp1_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp2_;
	_g_free0 (_tmp1_);
	_tmp3_ = g_strdup_printf ("%" G_GINT64_FORMAT, data_source_get_instance_id (source));
	_tmp4_ = _tmp3_;
	_tmp5_ = string_strip (_tmp4_);
	_g_free0 (self->priv->_value);
	self->priv->_value = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp6_ = self->priv->_name;
	_tmp7_ = self->priv->_value;
	_vala_assert (source_backlink_validate_name_value (_tmp6_, _tmp7_), "validate_name_value (_name, _value)");
	return self;
}

SourceBacklink*
source_backlink_new_from_source (DataSource* source)
{
	return source_backlink_construct_from_source (TYPE_SOURCE_BACKLINK, source);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
source_backlink_validate_name_value (const gchar* name,
                                     const gchar* value)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (name != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	if (!string_contains (name, "=")) {
		_tmp1_ = !string_contains (name, "|");
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !string_contains (value, "|");
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gchar*
source_backlink_to_string (SourceBacklink* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = source_backlink_get_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = source_backlink_get_value (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("Backlink %s=%s", _tmp1_, _tmp3_);
	result = _tmp4_;
	return result;
}

guint
source_backlink_hash_func (SourceBacklink* backlink)
{
	GHashFunc _tmp0_;
	const gchar* _tmp1_;
	GHashFunc _tmp2_;
	const gchar* _tmp3_;
	guint result;
	_tmp0_ = g_str_hash;
	_tmp1_ = backlink->priv->_name;
	_tmp2_ = g_str_hash;
	_tmp3_ = backlink->priv->_value;
	result = _tmp0_ (_tmp1_) ^ _tmp2_ (_tmp3_);
	return result;
}

gboolean
source_backlink_equal_func (SourceBacklink* alink,
                            SourceBacklink* blink)
{
	gboolean _tmp0_ = FALSE;
	GEqualFunc _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean result;
	_tmp1_ = g_str_equal;
	_tmp2_ = alink->priv->_name;
	_tmp3_ = blink->priv->_name;
	if (_tmp1_ (_tmp2_, _tmp3_)) {
		GEqualFunc _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = g_str_equal;
		_tmp5_ = alink->priv->_value;
		_tmp6_ = blink->priv->_value;
		_tmp0_ = _tmp4_ (_tmp5_, _tmp6_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

const gchar*
source_backlink_get_name (SourceBacklink* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

const gchar*
source_backlink_get_value (SourceBacklink* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value;
	result = _tmp0_;
	return result;
}

const gchar*
source_backlink_get_typename (SourceBacklink* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
	g_return_val_if_fail (str != NULL, 0LL);
	result = g_ascii_strtoll (str, NULL, _base);
	return result;
}

gint64
source_backlink_get_instance_id (SourceBacklink* self)
{
	gint64 result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_value;
	result = int64_parse (_tmp0_, (guint) 0);
	return result;
}

static void
value_source_backlink_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_source_backlink_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		source_backlink_unref (value->data[0].v_pointer);
	}
}

static void
value_source_backlink_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = source_backlink_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_source_backlink_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_source_backlink_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		SourceBacklink * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = source_backlink_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_source_backlink_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	SourceBacklink ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = source_backlink_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_source_backlink (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	ParamSpecSourceBacklink* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SOURCE_BACKLINK), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_source_backlink (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_BACKLINK), NULL);
	return value->data[0].v_pointer;
}

void
value_set_source_backlink (GValue* value,
                           gpointer v_object)
{
	SourceBacklink * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_BACKLINK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SOURCE_BACKLINK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		source_backlink_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		source_backlink_unref (old);
	}
}

void
value_take_source_backlink (GValue* value,
                            gpointer v_object)
{
	SourceBacklink * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_BACKLINK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SOURCE_BACKLINK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		source_backlink_unref (old);
	}
}

static void
source_backlink_class_init (SourceBacklinkClass * klass,
                            gpointer klass_data)
{
	source_backlink_parent_class = g_type_class_peek_parent (klass);
	((SourceBacklinkClass *) klass)->finalize = source_backlink_finalize;
	g_type_class_adjust_private_offset (klass, &SourceBacklink_private_offset);
}

static void
source_backlink_instance_init (SourceBacklink * self,
                               gpointer klass)
{
	self->priv = source_backlink_get_instance_private (self);
	self->ref_count = 1;
}

static void
source_backlink_finalize (SourceBacklink * obj)
{
	SourceBacklink * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SOURCE_BACKLINK, SourceBacklink);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_value);
}

static GType
source_backlink_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_source_backlink_init, value_source_backlink_free_value, value_source_backlink_copy_value, value_source_backlink_peek_pointer, "p", value_source_backlink_collect_value, "p", value_source_backlink_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SourceBacklinkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) source_backlink_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SourceBacklink), 0, (GInstanceInitFunc) source_backlink_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType source_backlink_type_id;
	source_backlink_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SourceBacklink", &g_define_type_info, &g_define_type_fundamental_info, 0);
	SourceBacklink_private_offset = g_type_add_instance_private (source_backlink_type_id, sizeof (SourceBacklinkPrivate));
	return source_backlink_type_id;
}

GType
source_backlink_get_type (void)
{
	static volatile gsize source_backlink_type_id__once = 0;
	if (g_once_init_enter (&source_backlink_type_id__once)) {
		GType source_backlink_type_id;
		source_backlink_type_id = source_backlink_get_type_once ();
		g_once_init_leave (&source_backlink_type_id__once, source_backlink_type_id);
	}
	return source_backlink_type_id__once;
}

gpointer
source_backlink_ref (gpointer instance)
{
	SourceBacklink * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
source_backlink_unref (gpointer instance)
{
	SourceBacklink * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SOURCE_BACKLINK_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
source_proxy_get_instance_private (SourceProxy* self)
{
	return G_STRUCT_MEMBER_P (self, SourceProxy_private_offset);
}

static void
_source_proxy_on_source_added_data_collection_items_added (DataCollection* _sender,
                                                           GeeIterable* added,
                                                           gpointer self)
{
	source_proxy_on_source_added ((SourceProxy*) self, added);
}

static void
_source_proxy_on_snapshot_broken_source_snapshot_broken (SourceSnapshot* _sender,
                                                         gpointer self)
{
	source_proxy_on_snapshot_broken ((SourceProxy*) self);
}

SourceProxy*
source_proxy_construct (GType object_type,
                        DataSource* source)
{
	SourceProxy* self = NULL;
	gchar* _tmp0_;
	SourceSnapshot* _tmp1_;
	SourceSnapshot* _tmp2_;
	SourceSnapshot* _tmp3_;
	DataCollection* _tmp4_;
	SourceCollection* _tmp5_;
	SourceCollection* _tmp6_;
	g_return_val_if_fail (source != NULL, NULL);
	self = (SourceProxy*) g_type_create_instance (object_type);
	self->priv->object_id = data_object_get_object_id ((DataObject*) source);
	_tmp0_ = data_object_to_string ((DataObject*) source);
	_g_free0 (self->priv->source_string);
	self->priv->source_string = _tmp0_;
	_tmp1_ = data_source_save_snapshot (source);
	_source_snapshot_unref0 (self->priv->snapshot);
	self->priv->snapshot = _tmp1_;
	_tmp2_ = self->priv->snapshot;
	_vala_assert (_tmp2_ != NULL, "snapshot != null");
	_tmp3_ = self->priv->snapshot;
	g_signal_connect (_tmp3_, "broken", (GCallback) _source_proxy_on_snapshot_broken_source_snapshot_broken, self);
	source_proxy_set_source (self, source);
	_tmp4_ = data_object_get_membership ((DataObject*) source);
	_data_collection_unref0 (self->priv->membership);
	self->priv->membership = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_SOURCE_COLLECTION, SourceCollection);
	_tmp5_ = self->priv->membership;
	_vala_assert (_tmp5_ != NULL, "membership != null");
	_tmp6_ = self->priv->membership;
	g_signal_connect ((DataCollection*) _tmp6_, "items-added", (GCallback) _source_proxy_on_source_added_data_collection_items_added, self);
	return self;
}

static DataSource*
source_proxy_real_reconstitute (SourceProxy* self,
                                gint64 object_id,
                                SourceSnapshot* snapshot)
{
	g_critical ("Type `%s' does not implement abstract method `source_proxy_reconstitute'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

DataSource*
source_proxy_reconstitute (SourceProxy* self,
                           gint64 object_id,
                           SourceSnapshot* snapshot)
{
	SourceProxyClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = SOURCE_PROXY_GET_CLASS (self);
	if (_klass_->reconstitute) {
		return _klass_->reconstitute (self, object_id, snapshot);
	}
	return NULL;
}

static void
source_proxy_real_notify_reconstituted (SourceProxy* self,
                                        DataSource* source)
{
	g_return_if_fail (source != NULL);
	g_signal_emit (self, source_proxy_signals[SOURCE_PROXY_RECONSTITUTED_SIGNAL], 0, source);
}

void
source_proxy_notify_reconstituted (SourceProxy* self,
                                   DataSource* source)
{
	SourceProxyClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SOURCE_PROXY_GET_CLASS (self);
	if (_klass_->notify_reconstituted) {
		_klass_->notify_reconstituted (self, source);
	}
}

static void
source_proxy_real_notify_dehydrated (SourceProxy* self)
{
	g_signal_emit (self, source_proxy_signals[SOURCE_PROXY_DEHYDRATED_SIGNAL], 0);
}

void
source_proxy_notify_dehydrated (SourceProxy* self)
{
	SourceProxyClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SOURCE_PROXY_GET_CLASS (self);
	if (_klass_->notify_dehydrated) {
		_klass_->notify_dehydrated (self);
	}
}

static void
source_proxy_real_notify_broken (SourceProxy* self)
{
	g_signal_emit (self, source_proxy_signals[SOURCE_PROXY_BROKEN_SIGNAL], 0);
}

void
source_proxy_notify_broken (SourceProxy* self)
{
	SourceProxyClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SOURCE_PROXY_GET_CLASS (self);
	if (_klass_->notify_broken) {
		_klass_->notify_broken (self);
	}
}

static void
source_proxy_on_snapshot_broken (SourceProxy* self)
{
	g_return_if_fail (self != NULL);
	source_proxy_drop_source (self);
	source_proxy_notify_broken (self);
}

static void
_source_proxy_on_destroyed_data_source_destroyed (DataSource* _sender,
                                                  gpointer self)
{
	source_proxy_on_destroyed ((SourceProxy*) self);
}

static void
source_proxy_set_source (SourceProxy* self,
                         DataSource* source)
{
	DataSource* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	source_proxy_drop_source (self);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (self->priv->source);
	self->priv->source = _tmp0_;
	g_signal_connect (source, "destroyed", (GCallback) _source_proxy_on_destroyed_data_source_destroyed, self);
}

static void
source_proxy_drop_source (SourceProxy* self)
{
	DataSource* _tmp0_;
	DataSource* _tmp1_;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->source;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->source;
	g_signal_parse_name ("destroyed", TYPE_DATA_SOURCE, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _source_proxy_on_destroyed_data_source_destroyed, self);
	_g_object_unref0 (self->priv->source);
	self->priv->source = NULL;
}

DataSource*
source_proxy_get_source (SourceProxy* self)
{
	SourceSnapshot* _tmp0_;
	DataSource* _tmp1_;
	DataSource* new_source = NULL;
	SourceSnapshot* _tmp4_;
	DataSource* _tmp5_;
	DataSource* _tmp6_;
	DataSource* _tmp7_;
	DataSource* _tmp10_;
	DataSource* _tmp12_;
	SourceCollection* _tmp13_;
	DataSource* _tmp14_;
	DataSource* _tmp15_;
	DataSource* _tmp16_;
	DataSource* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->snapshot;
	if (source_snapshot_is_broken (_tmp0_)) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->source;
	if (_tmp1_ != NULL) {
		DataSource* _tmp2_;
		DataSource* _tmp3_;
		_tmp2_ = self->priv->source;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->priv->snapshot;
	_tmp5_ = source_proxy_reconstitute (self, self->priv->object_id, _tmp4_);
	new_source = _tmp5_;
	_tmp6_ = self->priv->source;
	_tmp7_ = new_source;
	if (_tmp6_ != _tmp7_) {
		DataSource* _tmp8_;
		DataSource* _tmp9_;
		_tmp8_ = new_source;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_g_object_unref0 (self->priv->source);
		self->priv->source = _tmp9_;
	}
	_tmp10_ = self->priv->source;
	if (self->priv->object_id != data_object_get_object_id ((DataObject*) _tmp10_)) {
		DataSource* _tmp11_;
		_tmp11_ = new_source;
		self->priv->object_id = data_object_get_object_id ((DataObject*) _tmp11_);
	}
	_tmp12_ = self->priv->source;
	_vala_assert (data_object_get_object_id ((DataObject*) _tmp12_) == self->priv->object_id, "source.get_object_id () == object_id");
	_tmp13_ = self->priv->membership;
	_tmp14_ = self->priv->source;
	_vala_assert (data_collection_contains ((DataCollection*) _tmp13_, (DataObject*) _tmp14_), "membership.contains (source)");
	_tmp15_ = self->priv->source;
	_tmp16_ = _g_object_ref0 (_tmp15_);
	result = _tmp16_;
	_g_object_unref0 (new_source);
	return result;
}

static void
source_proxy_on_destroyed (SourceProxy* self)
{
	DataSource* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->source;
	_vala_assert (_tmp0_ != NULL, "source != null");
	source_proxy_drop_source (self);
	source_proxy_notify_dehydrated (self);
}

static void
source_proxy_on_source_added (SourceProxy* self,
                              GeeIterable* added)
{
	DataSource* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (added != NULL);
	_tmp0_ = self->priv->source;
	if (_tmp0_ != NULL) {
		return;
	}
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator (added);
		_object_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			DataObject* object = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			DataObject* _tmp5_;
			DataObject* _tmp6_;
			DataObject* _tmp7_;
			_tmp2_ = _object_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _object_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			object = (DataObject*) _tmp4_;
			_tmp5_ = object;
			if (data_object_get_object_id (_tmp5_) != self->priv->object_id) {
				_g_object_unref0 (object);
				continue;
			}
			_tmp6_ = object;
			source_proxy_set_source (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_DATA_SOURCE, DataSource));
			_tmp7_ = object;
			source_proxy_notify_reconstituted (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_SOURCE, DataSource));
			_g_object_unref0 (object);
			break;
		}
		_g_object_unref0 (_object_it);
	}
}

static void
source_proxy_real_reconstituted (SourceProxy* self,
                                 DataSource* source)
{
	g_return_if_fail (source != NULL);
}

static void
source_proxy_real_dehydrated (SourceProxy* self)
{
}

static void
source_proxy_real_broken (SourceProxy* self)
{
}

static void
value_source_proxy_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_source_proxy_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		source_proxy_unref (value->data[0].v_pointer);
	}
}

static void
value_source_proxy_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = source_proxy_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_source_proxy_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_source_proxy_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		SourceProxy * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = source_proxy_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_source_proxy_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	SourceProxy ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = source_proxy_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_source_proxy (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	ParamSpecSourceProxy* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SOURCE_PROXY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_source_proxy (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_PROXY), NULL);
	return value->data[0].v_pointer;
}

void
value_set_source_proxy (GValue* value,
                        gpointer v_object)
{
	SourceProxy * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_PROXY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SOURCE_PROXY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		source_proxy_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		source_proxy_unref (old);
	}
}

void
value_take_source_proxy (GValue* value,
                         gpointer v_object)
{
	SourceProxy * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_PROXY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SOURCE_PROXY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		source_proxy_unref (old);
	}
}

static void
source_proxy_class_init (SourceProxyClass * klass,
                         gpointer klass_data)
{
	source_proxy_parent_class = g_type_class_peek_parent (klass);
	((SourceProxyClass *) klass)->finalize = source_proxy_finalize;
	g_type_class_adjust_private_offset (klass, &SourceProxy_private_offset);
	((SourceProxyClass *) klass)->reconstitute = (DataSource* (*) (SourceProxy*, gint64, SourceSnapshot*)) source_proxy_real_reconstitute;
	((SourceProxyClass *) klass)->notify_reconstituted = (void (*) (SourceProxy*, DataSource*)) source_proxy_real_notify_reconstituted;
	((SourceProxyClass *) klass)->notify_dehydrated = (void (*) (SourceProxy*)) source_proxy_real_notify_dehydrated;
	((SourceProxyClass *) klass)->notify_broken = (void (*) (SourceProxy*)) source_proxy_real_notify_broken;
	((SourceProxyClass *) klass)->reconstituted = source_proxy_real_reconstituted;
	((SourceProxyClass *) klass)->dehydrated = source_proxy_real_dehydrated;
	((SourceProxyClass *) klass)->broken = source_proxy_real_broken;
	source_proxy_signals[SOURCE_PROXY_RECONSTITUTED_SIGNAL] = g_signal_new ("reconstituted", TYPE_SOURCE_PROXY, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceProxyClass, reconstituted), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_DATA_SOURCE);
	source_proxy_signals[SOURCE_PROXY_DEHYDRATED_SIGNAL] = g_signal_new ("dehydrated", TYPE_SOURCE_PROXY, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceProxyClass, dehydrated), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	source_proxy_signals[SOURCE_PROXY_BROKEN_SIGNAL] = g_signal_new ("broken", TYPE_SOURCE_PROXY, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceProxyClass, broken), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
source_proxy_instance_init (SourceProxy * self,
                            gpointer klass)
{
	self->priv = source_proxy_get_instance_private (self);
	self->ref_count = 1;
}

static void
source_proxy_finalize (SourceProxy * obj)
{
	SourceProxy * self;
	SourceCollection* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SOURCE_PROXY, SourceProxy);
	g_signal_handlers_destroy (self);
	source_proxy_drop_source (self);
	_tmp0_ = self->priv->membership;
	g_signal_parse_name ("items-added", TYPE_DATA_COLLECTION, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DataCollection*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _source_proxy_on_source_added_data_collection_items_added, self);
	_g_free0 (self->priv->source_string);
	_g_object_unref0 (self->priv->source);
	_source_snapshot_unref0 (self->priv->snapshot);
	_data_collection_unref0 (self->priv->membership);
}

static GType
source_proxy_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_source_proxy_init, value_source_proxy_free_value, value_source_proxy_copy_value, value_source_proxy_peek_pointer, "p", value_source_proxy_collect_value, "p", value_source_proxy_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SourceProxyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) source_proxy_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SourceProxy), 0, (GInstanceInitFunc) source_proxy_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType source_proxy_type_id;
	source_proxy_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SourceProxy", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	SourceProxy_private_offset = g_type_add_instance_private (source_proxy_type_id, sizeof (SourceProxyPrivate));
	return source_proxy_type_id;
}

GType
source_proxy_get_type (void)
{
	static volatile gsize source_proxy_type_id__once = 0;
	if (g_once_init_enter (&source_proxy_type_id__once)) {
		GType source_proxy_type_id;
		source_proxy_type_id = source_proxy_get_type_once ();
		g_once_init_leave (&source_proxy_type_id__once, source_proxy_type_id);
	}
	return source_proxy_type_id__once;
}

gpointer
source_proxy_ref (gpointer instance)
{
	SourceProxy * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
source_proxy_unref (gpointer instance)
{
	SourceProxy * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SOURCE_PROXY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

SourceProxy*
proxyable_get_proxy (Proxyable* self)
{
	ProxyableIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = PROXYABLE_GET_INTERFACE (self);
	if (_iface_->get_proxy) {
		return _iface_->get_proxy (self);
	}
	return NULL;
}

static void
proxyable_default_init (ProxyableIface * iface,
                        gpointer iface_data)
{
}

static GType
proxyable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ProxyableIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) proxyable_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType proxyable_type_id;
	proxyable_type_id = g_type_register_static (G_TYPE_INTERFACE, "Proxyable", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (proxyable_type_id, G_TYPE_OBJECT);
	return proxyable_type_id;
}

GType
proxyable_get_type (void)
{
	static volatile gsize proxyable_type_id__once = 0;
	if (g_once_init_enter (&proxyable_type_id__once)) {
		GType proxyable_type_id;
		proxyable_type_id = proxyable_get_type_once ();
		g_once_init_leave (&proxyable_type_id__once, proxyable_type_id);
	}
	return proxyable_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

