/* CropTool.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from CropTool.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*               2016-2018 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include "io.elementary.photos.h"
#include <glib-object.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>

#define EDITING_TOOLS_CROP_TOOL_CROP_INIT_X_PCT 0.15
#define EDITING_TOOLS_CROP_TOOL_CROP_INIT_Y_PCT 0.15
#define EDITING_TOOLS_CROP_TOOL_CROP_MIN_SIZE 8
#define EDITING_TOOLS_CROP_TOOL_CROP_EXTERIOR_SATURATION 0.00f
#define EDITING_TOOLS_CROP_TOOL_CROP_EXTERIOR_RED_SHIFT -32
#define EDITING_TOOLS_CROP_TOOL_CROP_EXTERIOR_GREEN_SHIFT -32
#define EDITING_TOOLS_CROP_TOOL_CROP_EXTERIOR_BLUE_SHIFT -32
#define EDITING_TOOLS_CROP_TOOL_CROP_EXTERIOR_ALPHA_SHIFT 0
#define EDITING_TOOLS_CROP_TOOL_ANY_ASPECT_RATIO (-1.0f)
#define EDITING_TOOLS_CROP_TOOL_SCREEN_ASPECT_RATIO (-2.0f)
#define EDITING_TOOLS_CROP_TOOL_ORIGINAL_ASPECT_RATIO (-3.0f)
#define EDITING_TOOLS_CROP_TOOL_CUSTOM_ASPECT_RATIO (-4.0f)
#define EDITING_TOOLS_CROP_TOOL_COMPUTE_FROM_BASIS (-5.0f)
#define EDITING_TOOLS_CROP_TOOL_SEPARATOR (-6.0f)
#define EDITING_TOOLS_CROP_TOOL_MIN_ASPECT_RATIO (1.0f / 64.0f)
#define EDITING_TOOLS_CROP_TOOL_MAX_ASPECT_RATIO 64.0f
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define EDITING_TOOLS_CROP_TOOL_TYPE_CROP_TOOL_WINDOW (editing_tools_crop_tool_crop_tool_window_get_type ())
#define EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDITING_TOOLS_CROP_TOOL_TYPE_CROP_TOOL_WINDOW, EditingToolsCropToolCropToolWindow))
#define EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDITING_TOOLS_CROP_TOOL_TYPE_CROP_TOOL_WINDOW, EditingToolsCropToolCropToolWindowClass))
#define EDITING_TOOLS_CROP_TOOL_IS_CROP_TOOL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDITING_TOOLS_CROP_TOOL_TYPE_CROP_TOOL_WINDOW))
#define EDITING_TOOLS_CROP_TOOL_IS_CROP_TOOL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDITING_TOOLS_CROP_TOOL_TYPE_CROP_TOOL_WINDOW))
#define EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDITING_TOOLS_CROP_TOOL_TYPE_CROP_TOOL_WINDOW, EditingToolsCropToolCropToolWindowClass))

typedef struct _EditingToolsCropToolCropToolWindow EditingToolsCropToolCropToolWindow;
typedef struct _EditingToolsCropToolCropToolWindowClass EditingToolsCropToolCropToolWindowClass;

#define EDITING_TOOLS_CROP_TOOL_TYPE_CONSTRAINT_DESCRIPTION (editing_tools_crop_tool_constraint_description_get_type ())
#define EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDITING_TOOLS_CROP_TOOL_TYPE_CONSTRAINT_DESCRIPTION, EditingToolsCropToolConstraintDescription))
#define EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDITING_TOOLS_CROP_TOOL_TYPE_CONSTRAINT_DESCRIPTION, EditingToolsCropToolConstraintDescriptionClass))
#define EDITING_TOOLS_CROP_TOOL_IS_CONSTRAINT_DESCRIPTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDITING_TOOLS_CROP_TOOL_TYPE_CONSTRAINT_DESCRIPTION))
#define EDITING_TOOLS_CROP_TOOL_IS_CONSTRAINT_DESCRIPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDITING_TOOLS_CROP_TOOL_TYPE_CONSTRAINT_DESCRIPTION))
#define EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDITING_TOOLS_CROP_TOOL_TYPE_CONSTRAINT_DESCRIPTION, EditingToolsCropToolConstraintDescriptionClass))

typedef struct _EditingToolsCropToolConstraintDescription EditingToolsCropToolConstraintDescription;
typedef struct _EditingToolsCropToolConstraintDescriptionClass EditingToolsCropToolConstraintDescriptionClass;
typedef enum  {
	EDITING_TOOLS_CROP_TOOL_RETICLE_ORIENTATION_LANDSCAPE,
	EDITING_TOOLS_CROP_TOOL_RETICLE_ORIENTATION_PORTRAIT
} EditingToolsCropToolReticleOrientation;

#define EDITING_TOOLS_CROP_TOOL_TYPE_RETICLE_ORIENTATION (editing_tools_crop_tool_reticle_orientation_get_type ())
typedef enum  {
	EDITING_TOOLS_CROP_TOOL_CONSTRAINT_MODE_NORMAL,
	EDITING_TOOLS_CROP_TOOL_CONSTRAINT_MODE_CUSTOM
} EditingToolsCropToolConstraintMode;

#define EDITING_TOOLS_CROP_TOOL_TYPE_CONSTRAINT_MODE (editing_tools_crop_tool_constraint_mode_get_type ())
enum  {
	EDITING_TOOLS_CROP_TOOL_0_PROPERTY,
	EDITING_TOOLS_CROP_TOOL_NUM_PROPERTIES
};
static GParamSpec* editing_tools_crop_tool_properties[EDITING_TOOLS_CROP_TOOL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _EditingToolsCropToolConstraintDescriptionPrivate EditingToolsCropToolConstraintDescriptionPrivate;
enum  {
	EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_0_PROPERTY,
	EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_NAME_PROPERTY,
	EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_BASIS_WIDTH_PROPERTY,
	EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_BASIS_HEIGHT_PROPERTY,
	EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_IS_PIVOTABLE_PROPERTY,
	EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_ASPECT_RATIO_PROPERTY,
	EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_NUM_PROPERTIES
};
static GParamSpec* editing_tools_crop_tool_constraint_description_properties[EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_NUM_PROPERTIES];
typedef struct _EditingToolsCropToolCropToolWindowPrivate EditingToolsCropToolCropToolWindowPrivate;
enum  {
	EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_0_PROPERTY,
	EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CROP_BUTTON_PROPERTY,
	EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CANCEL_BUTTON_PROPERTY,
	EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CONSTRAINT_COMBO_PROPERTY,
	EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_PIVOT_RETICLE_BUTTON_PROPERTY,
	EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CUSTOM_WIDTH_ENTRY_PROPERTY,
	EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CUSTOM_HEIGHT_ENTRY_PROPERTY,
	EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CUSTOM_ASPECT_REVEALER_PROPERTY,
	EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_MOST_RECENTLY_EDITED_PROPERTY,
	EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_NUM_PROPERTIES
};
static GParamSpec* editing_tools_crop_tool_crop_tool_window_properties[EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _EditingToolsCropToolPrivate {
	EditingToolsCropToolCropToolWindow* crop_tool_window;
	GdkCursorType current_cursor_type;
	BoxLocation in_manipulation;
	cairo_t* wide_black_ctx;
	cairo_t* wide_white_ctx;
	cairo_t* thin_white_ctx;
	cairo_t* text_ctx;
	cairo_surface_t* crop_surface;
	Box scaled_crop;
	gint last_grab_x;
	gint last_grab_y;
	EditingToolsCropToolConstraintDescription** constraints;
	gint constraints_length1;
	gint _constraints_size_;
	GtkListStore* constraint_list;
	EditingToolsCropToolReticleOrientation reticle_orientation;
	EditingToolsCropToolConstraintMode constraint_mode;
	gboolean entry_insert_in_progress;
	gfloat custom_aspect_ratio;
	gint custom_width;
	gint custom_height;
	gint custom_init_width;
	gint custom_init_height;
	gint scale_factor;
	gfloat pre_aspect_ratio;
	GSettings* crop_settings;
};

struct _EditingToolsCropToolConstraintDescription {
	GObject parent_instance;
	EditingToolsCropToolConstraintDescriptionPrivate * priv;
};

struct _EditingToolsCropToolConstraintDescriptionClass {
	GObjectClass parent_class;
};

struct _EditingToolsCropToolConstraintDescriptionPrivate {
	gchar* _name;
	gint _basis_width;
	gint _basis_height;
	gboolean _is_pivotable;
	gfloat _aspect_ratio;
};

struct _EditingToolsCropToolCropToolWindow {
	EditingToolsEditingToolWindow parent_instance;
	EditingToolsCropToolCropToolWindowPrivate * priv;
};

struct _EditingToolsCropToolCropToolWindowClass {
	EditingToolsEditingToolWindowClass parent_class;
};

struct _EditingToolsCropToolCropToolWindowPrivate {
	GtkButton* _crop_button;
	GtkButton* _cancel_button;
	GtkComboBox* _constraint_combo;
	GtkButton* _pivot_reticle_button;
	GtkEntry* _custom_width_entry;
	GtkEntry* _custom_height_entry;
	GtkRevealer* _custom_aspect_revealer;
	GtkEntry* _most_recently_edited;
};

static gint EditingToolsCropTool_private_offset;
static gpointer editing_tools_crop_tool_parent_class = NULL;
static gint EditingToolsCropToolConstraintDescription_private_offset;
static gpointer editing_tools_crop_tool_constraint_description_parent_class = NULL;
static gint EditingToolsCropToolCropToolWindow_private_offset;
static gpointer editing_tools_crop_tool_crop_tool_window_parent_class = NULL;

static GType editing_tools_crop_tool_crop_tool_window_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType editing_tools_crop_tool_constraint_description_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType editing_tools_crop_tool_reticle_orientation_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType editing_tools_crop_tool_constraint_mode_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static EditingToolsCropToolReticleOrientation editing_tools_crop_tool_reticle_orientation_toggle (EditingToolsCropToolReticleOrientation self);
static EditingToolsCropToolConstraintDescription** editing_tools_crop_tool_create_constraints (gint* result_length1);
static GtkListStore* editing_tools_crop_tool_create_constraint_list (EditingToolsCropToolConstraintDescription** constraint_data,
                                                              gint constraint_data_length1);
static EditingToolsCropTool* editing_tools_crop_tool_new (void);
static EditingToolsCropTool* editing_tools_crop_tool_construct (GType object_type);
static EditingToolsCropToolConstraintDescription* editing_tools_crop_tool_constraint_description_new (const gchar* new_name,
                                                                                               gint new_basis_width,
                                                                                               gint new_basis_height,
                                                                                               gboolean new_pivotable,
                                                                                               gfloat new_aspect_ratio);
static EditingToolsCropToolConstraintDescription* editing_tools_crop_tool_constraint_description_construct (GType object_type,
                                                                                                     const gchar* new_name,
                                                                                                     gint new_basis_width,
                                                                                                     gint new_basis_height,
                                                                                                     gboolean new_pivotable,
                                                                                                     gfloat new_aspect_ratio);
static void _vala_array_add51 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add52 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add53 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add54 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add55 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add56 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add57 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add58 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add59 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add60 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add61 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add62 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add63 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add64 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add65 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add66 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add67 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add68 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add69 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add70 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add71 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add72 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add73 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add74 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add75 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add76 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add77 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add78 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static void _vala_array_add79 (EditingToolsCropToolConstraintDescription** * array,
                        gint* length,
                        gint* size,
                        EditingToolsCropToolConstraintDescription* value);
static const gchar* editing_tools_crop_tool_constraint_description_get_name (EditingToolsCropToolConstraintDescription* self);
static void editing_tools_crop_tool_update_pivot_button_state (EditingToolsCropTool* self);
static GtkButton* editing_tools_crop_tool_crop_tool_window_get_pivot_reticle_button (EditingToolsCropToolCropToolWindow* self);
static EditingToolsCropToolConstraintDescription* editing_tools_crop_tool_get_selected_constraint (EditingToolsCropTool* self);
static gboolean editing_tools_crop_tool_constraint_description_get_is_pivotable (EditingToolsCropToolConstraintDescription* self);
static GtkComboBox* editing_tools_crop_tool_crop_tool_window_get_constraint_combo (EditingToolsCropToolCropToolWindow* self);
static gfloat editing_tools_crop_tool_constraint_description_get_aspect_ratio (EditingToolsCropToolConstraintDescription* self);
static void editing_tools_crop_tool_constraint_description_set_basis_width (EditingToolsCropToolConstraintDescription* self,
                                                                     gint value);
static void editing_tools_crop_tool_constraint_description_set_basis_height (EditingToolsCropToolConstraintDescription* self,
                                                                      gint value);
static gboolean editing_tools_crop_tool_on_custom_entry_focus_out (EditingToolsCropTool* self,
                                                            GdkEventFocus* event);
static GtkEntry* editing_tools_crop_tool_crop_tool_window_get_custom_width_entry (EditingToolsCropToolCropToolWindow* self);
static GtkEntry* editing_tools_crop_tool_crop_tool_window_get_custom_height_entry (EditingToolsCropToolCropToolWindow* self);
static GtkEntry* editing_tools_crop_tool_crop_tool_window_get_most_recently_edited (EditingToolsCropToolCropToolWindow* self);
static void editing_tools_crop_tool_constrain_crop (EditingToolsCropTool* self,
                                             Box* crop,
                                             Box* result);
static void editing_tools_crop_tool_crop_resized (EditingToolsCropTool* self,
                                           Box* new_crop);
static void editing_tools_crop_tool_on_width_insert_text (EditingToolsCropTool* self,
                                                   const gchar* text,
                                                   gint length,
                                                   gint* position);
static void editing_tools_crop_tool_on_entry_insert_text (EditingToolsCropTool* self,
                                                   GtkEntry* sender,
                                                   const gchar* text,
                                                   gint length,
                                                   gint* position);
static void editing_tools_crop_tool_on_height_insert_text (EditingToolsCropTool* self,
                                                    const gchar* text,
                                                    gint length,
                                                    gint* position);
static gfloat editing_tools_crop_tool_get_constraint_aspect_ratio (EditingToolsCropTool* self);
static void editing_tools_crop_tool_constraint_changed (EditingToolsCropTool* self);
static void editing_tools_crop_tool_set_custom_constraint_mode (EditingToolsCropTool* self);
static GtkRevealer* editing_tools_crop_tool_crop_tool_window_get_custom_aspect_revealer (EditingToolsCropToolCropToolWindow* self);
static void editing_tools_crop_tool_get_photo_dimensions (EditingToolsCropTool* self,
                                                   Dimensions* result);
VALA_EXTERN void clamp_inside_rotated_image (Box* src,
                                 gint img_w,
                                 gint img_h,
                                 gdouble angle_deg,
                                 gboolean preserve_geom,
                                 Box* result);
static EditingToolsCropToolConstraintDescription* editing_tools_crop_tool_get_last_constraint (EditingToolsCropTool* self,
                                                                                        gint* index);
static void editing_tools_crop_tool_real_activate (EditingToolsEditingTool* base,
                                            EditingToolsPhotoCanvas* canvas);
static void editing_tools_crop_tool_bind_canvas_handlers (EditingToolsCropTool* self,
                                                   EditingToolsPhotoCanvas* canvas);
static void editing_tools_crop_tool_prepare_ctx (EditingToolsCropTool* self,
                                          cairo_t* ctx,
                                          Dimensions* dim);
static EditingToolsCropToolCropToolWindow* editing_tools_crop_tool_crop_tool_window_new (GtkWindow* container);
static EditingToolsCropToolCropToolWindow* editing_tools_crop_tool_crop_tool_window_construct (GType object_type,
                                                                                        GtkWindow* container);
static gboolean editing_tools_crop_tool_constraint_description_is_separator (EditingToolsCropToolConstraintDescription* self);
static void editing_tools_crop_tool_bind_window_handlers (EditingToolsCropTool* self);
static void _editing_tools_crop_tool_prepare_ctx_editing_tools_photo_canvas_new_surface (EditingToolsPhotoCanvas* _sender,
                                                                                  cairo_t* ctx,
                                                                                  Dimensions* dim,
                                                                                  gpointer self);
static void editing_tools_crop_tool_on_resized_pixbuf (EditingToolsCropTool* self,
                                                Dimensions* old_dim,
                                                GdkPixbuf* scaled,
                                                GdkRectangle* scaled_position);
static void _editing_tools_crop_tool_on_resized_pixbuf_editing_tools_photo_canvas_resized_scaled_pixbuf (EditingToolsPhotoCanvas* _sender,
                                                                                                  Dimensions* old_dim,
                                                                                                  GdkPixbuf* scaled,
                                                                                                  GdkRectangle* scaled_position,
                                                                                                  gpointer self);
static void editing_tools_crop_tool_unbind_canvas_handlers (EditingToolsCropTool* self,
                                                     EditingToolsPhotoCanvas* canvas);
static GtkButton* editing_tools_crop_tool_crop_tool_window_get_crop_button (EditingToolsCropToolCropToolWindow* self);
static void editing_tools_crop_tool_on_crop_ok (EditingToolsCropTool* self);
static void _editing_tools_crop_tool_on_crop_ok_gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self);
static GtkButton* editing_tools_crop_tool_crop_tool_window_get_cancel_button (EditingToolsCropToolCropToolWindow* self);
static void _editing_tools_editing_tool_notify_cancel_gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self);
static void _editing_tools_crop_tool_constraint_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                        gpointer self);
static void editing_tools_crop_tool_on_pivot_button_clicked (EditingToolsCropTool* self);
static void _editing_tools_crop_tool_on_pivot_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                          gpointer self);
static gboolean _editing_tools_crop_tool_on_custom_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                                        GdkEventFocus* event,
                                                                                        gpointer self);
static void _editing_tools_crop_tool_on_width_insert_text_gtk_editable_insert_text (GtkEditable* _sender,
                                                                             const gchar* new_text,
                                                                             gint new_text_length,
                                                                             gint* position,
                                                                             gpointer self);
static void _editing_tools_crop_tool_on_height_insert_text_gtk_editable_insert_text (GtkEditable* _sender,
                                                                              const gchar* new_text,
                                                                              gint new_text_length,
                                                                              gint* position,
                                                                              gpointer self);
static void editing_tools_crop_tool_unbind_window_handlers (EditingToolsCropTool* self);
static void editing_tools_crop_tool_real_deactivate (EditingToolsEditingTool* base);
static EditingToolsEditingToolWindow* editing_tools_crop_tool_real_get_tool_window (EditingToolsEditingTool* base);
static GdkPixbuf* editing_tools_crop_tool_real_get_display_pixbuf (EditingToolsEditingTool* base,
                                                            Scaling* scaling,
                                                            Photo* photo,
                                                            Dimensions* max_dim,
                                                            GError** error);
VALA_EXTERN void set_source_color_from_string (cairo_t* ctx,
                                   const gchar* spec);
static void editing_tools_crop_tool_real_on_left_click (EditingToolsEditingTool* base,
                                                 gint x,
                                                 gint y);
static void editing_tools_crop_tool_real_on_left_released (EditingToolsEditingTool* base,
                                                    gint x,
                                                    gint y);
static void editing_tools_crop_tool_update_cursor (EditingToolsCropTool* self,
                                            gint x,
                                            gint y);
static void editing_tools_crop_tool_real_on_motion (EditingToolsEditingTool* base,
                                             gint x,
                                             gint y,
                                             GdkModifierType mask);
static gboolean editing_tools_crop_tool_on_canvas_manipulation (EditingToolsCropTool* self,
                                                         gint x,
                                                         gint y);
static void editing_tools_crop_tool_real_paint (EditingToolsEditingTool* base,
                                         cairo_t* default_ctx);
static void editing_tools_crop_tool_paint_crop_tool (EditingToolsCropTool* self,
                                              Box* crop);
static gint editing_tools_crop_tool_eval_radial_line (EditingToolsCropTool* self,
                                               gdouble center_x,
                                               gdouble center_y,
                                               gdouble bounds_x,
                                               gdouble bounds_y,
                                               gdouble user_x);
static gboolean _box_equal (const Box * s1,
                     const Box * s2);
static void editing_tools_crop_tool_crop_moved (EditingToolsCropTool* self,
                                         Box* new_crop);
static void editing_tools_crop_tool_set_area_alpha (EditingToolsCropTool* self,
                                             Box* area,
                                             gdouble alpha);
static gint editing_tools_crop_tool_constraint_description_get_basis_width (EditingToolsCropToolConstraintDescription* self);
static gint editing_tools_crop_tool_constraint_description_get_basis_height (EditingToolsCropToolConstraintDescription* self);
static void editing_tools_crop_tool_constraint_description_set_aspect_ratio (EditingToolsCropToolConstraintDescription* self,
                                                                      gfloat value);
static void editing_tools_crop_tool_constraint_description_set_name (EditingToolsCropToolConstraintDescription* self,
                                                              const gchar* value);
static void editing_tools_crop_tool_constraint_description_set_is_pivotable (EditingToolsCropToolConstraintDescription* self,
                                                                      gboolean value);
static void editing_tools_crop_tool_constraint_description_finalize (GObject * obj);
static GType editing_tools_crop_tool_constraint_description_get_type_once (void);
static void _vala_editing_tools_crop_tool_constraint_description_get_property (GObject * object,
                                                                        guint property_id,
                                                                        GValue * value,
                                                                        GParamSpec * pspec);
static void _vala_editing_tools_crop_tool_constraint_description_set_property (GObject * object,
                                                                        guint property_id,
                                                                        const GValue * value,
                                                                        GParamSpec * pspec);
static gboolean editing_tools_crop_tool_crop_tool_window_constraint_combo_separator_func (GtkTreeModel* model,
                                                                                   GtkTreeIter* iter);
static void editing_tools_crop_tool_crop_tool_window_set_crop_button (EditingToolsCropToolCropToolWindow* self,
                                                               GtkButton* value);
static void editing_tools_crop_tool_crop_tool_window_set_cancel_button (EditingToolsCropToolCropToolWindow* self,
                                                                 GtkButton* value);
static void editing_tools_crop_tool_crop_tool_window_set_constraint_combo (EditingToolsCropToolCropToolWindow* self,
                                                                    GtkComboBox* value);
static void editing_tools_crop_tool_crop_tool_window_set_pivot_reticle_button (EditingToolsCropToolCropToolWindow* self,
                                                                        GtkButton* value);
static void editing_tools_crop_tool_crop_tool_window_set_custom_width_entry (EditingToolsCropToolCropToolWindow* self,
                                                                      GtkEntry* value);
static void editing_tools_crop_tool_crop_tool_window_set_custom_height_entry (EditingToolsCropToolCropToolWindow* self,
                                                                       GtkEntry* value);
static void editing_tools_crop_tool_crop_tool_window_set_custom_aspect_revealer (EditingToolsCropToolCropToolWindow* self,
                                                                          GtkRevealer* value);
static void editing_tools_crop_tool_crop_tool_window_set_most_recently_edited (EditingToolsCropToolCropToolWindow* self,
                                                                        GtkEntry* value);
static GObject * editing_tools_crop_tool_crop_tool_window_constructor (GType type,
                                                                guint n_construct_properties,
                                                                GObjectConstructParam * construct_properties);
static gboolean _editing_tools_crop_tool_crop_tool_window_constraint_combo_separator_func_gtk_tree_view_row_separator_func (GtkTreeModel* model,
                                                                                                                     GtkTreeIter* iter,
                                                                                                                     gpointer self);
static gboolean _editing_tools_crop_tool_crop_tool_window___lambda48_ (EditingToolsCropToolCropToolWindow* self);
static gboolean __editing_tools_crop_tool_crop_tool_window___lambda48__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                                            GdkEventFocus* event,
                                                                                            gpointer self);
static gboolean _editing_tools_crop_tool_crop_tool_window___lambda49_ (EditingToolsCropToolCropToolWindow* self);
static gboolean __editing_tools_crop_tool_crop_tool_window___lambda49__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                                            GdkEventFocus* event,
                                                                                            gpointer self);
static void editing_tools_crop_tool_crop_tool_window_finalize (GObject * obj);
static GType editing_tools_crop_tool_crop_tool_window_get_type_once (void);
static void _vala_editing_tools_crop_tool_crop_tool_window_get_property (GObject * object,
                                                                  guint property_id,
                                                                  GValue * value,
                                                                  GParamSpec * pspec);
static void _vala_editing_tools_crop_tool_crop_tool_window_set_property (GObject * object,
                                                                  guint property_id,
                                                                  const GValue * value,
                                                                  GParamSpec * pspec);
static GObject * editing_tools_crop_tool_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void editing_tools_crop_tool_finalize (GObject * obj);
static GType editing_tools_crop_tool_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
editing_tools_crop_tool_get_instance_private (EditingToolsCropTool* self)
{
	return G_STRUCT_MEMBER_P (self, EditingToolsCropTool_private_offset);
}

static EditingToolsCropToolReticleOrientation
editing_tools_crop_tool_reticle_orientation_toggle (EditingToolsCropToolReticleOrientation self)
{
	EditingToolsCropToolReticleOrientation _tmp0_ = 0;
	EditingToolsCropToolReticleOrientation result;
	if (self == EDITING_TOOLS_CROP_TOOL_RETICLE_ORIENTATION_LANDSCAPE) {
		_tmp0_ = EDITING_TOOLS_CROP_TOOL_RETICLE_ORIENTATION_PORTRAIT;
	} else {
		_tmp0_ = EDITING_TOOLS_CROP_TOOL_RETICLE_ORIENTATION_LANDSCAPE;
	}
	result = _tmp0_;
	return result;
}

static GType
editing_tools_crop_tool_reticle_orientation_get_type_once (void)
{
	static const GEnumValue values[] = {{EDITING_TOOLS_CROP_TOOL_RETICLE_ORIENTATION_LANDSCAPE, "EDITING_TOOLS_CROP_TOOL_RETICLE_ORIENTATION_LANDSCAPE", "landscape"}, {EDITING_TOOLS_CROP_TOOL_RETICLE_ORIENTATION_PORTRAIT, "EDITING_TOOLS_CROP_TOOL_RETICLE_ORIENTATION_PORTRAIT", "portrait"}, {0, NULL, NULL}};
	GType editing_tools_crop_tool_reticle_orientation_type_id;
	editing_tools_crop_tool_reticle_orientation_type_id = g_enum_register_static ("EditingToolsCropToolReticleOrientation", values);
	return editing_tools_crop_tool_reticle_orientation_type_id;
}

static GType
editing_tools_crop_tool_reticle_orientation_get_type (void)
{
	static volatile gsize editing_tools_crop_tool_reticle_orientation_type_id__once = 0;
	if (g_once_init_enter (&editing_tools_crop_tool_reticle_orientation_type_id__once)) {
		GType editing_tools_crop_tool_reticle_orientation_type_id;
		editing_tools_crop_tool_reticle_orientation_type_id = editing_tools_crop_tool_reticle_orientation_get_type_once ();
		g_once_init_leave (&editing_tools_crop_tool_reticle_orientation_type_id__once, editing_tools_crop_tool_reticle_orientation_type_id);
	}
	return editing_tools_crop_tool_reticle_orientation_type_id__once;
}

static GType
editing_tools_crop_tool_constraint_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{EDITING_TOOLS_CROP_TOOL_CONSTRAINT_MODE_NORMAL, "EDITING_TOOLS_CROP_TOOL_CONSTRAINT_MODE_NORMAL", "normal"}, {EDITING_TOOLS_CROP_TOOL_CONSTRAINT_MODE_CUSTOM, "EDITING_TOOLS_CROP_TOOL_CONSTRAINT_MODE_CUSTOM", "custom"}, {0, NULL, NULL}};
	GType editing_tools_crop_tool_constraint_mode_type_id;
	editing_tools_crop_tool_constraint_mode_type_id = g_enum_register_static ("EditingToolsCropToolConstraintMode", values);
	return editing_tools_crop_tool_constraint_mode_type_id;
}

static GType
editing_tools_crop_tool_constraint_mode_get_type (void)
{
	static volatile gsize editing_tools_crop_tool_constraint_mode_type_id__once = 0;
	if (g_once_init_enter (&editing_tools_crop_tool_constraint_mode_type_id__once)) {
		GType editing_tools_crop_tool_constraint_mode_type_id;
		editing_tools_crop_tool_constraint_mode_type_id = editing_tools_crop_tool_constraint_mode_get_type_once ();
		g_once_init_leave (&editing_tools_crop_tool_constraint_mode_type_id__once, editing_tools_crop_tool_constraint_mode_type_id);
	}
	return editing_tools_crop_tool_constraint_mode_type_id__once;
}

static EditingToolsCropTool*
editing_tools_crop_tool_construct (GType object_type)
{
	EditingToolsCropTool * self = NULL;
	self = (EditingToolsCropTool*) g_object_new (object_type, "name", "CropTool", NULL);
	return self;
}

static EditingToolsCropTool*
editing_tools_crop_tool_new (void)
{
	return editing_tools_crop_tool_construct (EDITING_TOOLS_TYPE_CROP_TOOL);
}

EditingToolsCropTool*
editing_tools_crop_tool_factory (void)
{
	EditingToolsCropTool* _tmp0_;
	EditingToolsCropTool* result;
	_tmp0_ = editing_tools_crop_tool_new ();
	result = _tmp0_;
	return result;
}

gboolean
editing_tools_crop_tool_is_available (Photo* photo,
                                      Scaling* scaling)
{
	Dimensions dim = {0};
	Dimensions _tmp0_ = {0};
	Dimensions _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	Dimensions _tmp3_;
	gboolean result;
	g_return_val_if_fail (photo != NULL, FALSE);
	g_return_val_if_fail (scaling != NULL, FALSE);
	photo_get_original_dimensions (photo, &_tmp0_);
	scaling_get_scaled_dimensions (scaling, &_tmp0_, &_tmp1_);
	dim = _tmp1_;
	_tmp3_ = dim;
	if (_tmp3_.width > EDITING_TOOLS_CROP_TOOL_CROP_MIN_SIZE) {
		Dimensions _tmp4_;
		_tmp4_ = dim;
		_tmp2_ = _tmp4_.height > EDITING_TOOLS_CROP_TOOL_CROP_MIN_SIZE;
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	return result;
}

static void
_vala_array_add51 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add52 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add53 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add54 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add55 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add56 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add57 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add58 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add59 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add60 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add61 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add62 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add63 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add64 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add65 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add66 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add67 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add68 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add69 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add70 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add71 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add72 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add73 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add74 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add75 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add76 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add77 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add78 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add79 (EditingToolsCropToolConstraintDescription** * array,
                   gint* length,
                   gint* size,
                   EditingToolsCropToolConstraintDescription* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (EditingToolsCropToolConstraintDescription*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static EditingToolsCropToolConstraintDescription**
editing_tools_crop_tool_create_constraints (gint* result_length1)
{
	EditingToolsCropToolConstraintDescription** _result_ = NULL;
	EditingToolsCropToolConstraintDescription** _tmp0_;
	gint _result__length1;
	gint __result__size_;
	EditingToolsCropToolConstraintDescription* _tmp1_;
	EditingToolsCropToolConstraintDescription* _tmp2_;
	EditingToolsCropToolConstraintDescription* _tmp3_;
	EditingToolsCropToolConstraintDescription* _tmp4_;
	EditingToolsCropToolConstraintDescription* _tmp5_;
	EditingToolsCropToolConstraintDescription* _tmp6_;
	EditingToolsCropToolConstraintDescription* _tmp7_;
	EditingToolsCropToolConstraintDescription* _tmp8_;
	EditingToolsCropToolConstraintDescription* _tmp9_;
	EditingToolsCropToolConstraintDescription* _tmp10_;
	EditingToolsCropToolConstraintDescription* _tmp11_;
	EditingToolsCropToolConstraintDescription* _tmp12_;
	EditingToolsCropToolConstraintDescription* _tmp13_;
	EditingToolsCropToolConstraintDescription* _tmp14_;
	EditingToolsCropToolConstraintDescription* _tmp15_;
	EditingToolsCropToolConstraintDescription* _tmp16_;
	EditingToolsCropToolConstraintDescription* _tmp17_;
	EditingToolsCropToolConstraintDescription* _tmp18_;
	EditingToolsCropToolConstraintDescription* _tmp19_;
	EditingToolsCropToolConstraintDescription* _tmp20_;
	EditingToolsCropToolConstraintDescription* _tmp21_;
	EditingToolsCropToolConstraintDescription* _tmp22_;
	EditingToolsCropToolConstraintDescription* _tmp23_;
	EditingToolsCropToolConstraintDescription* _tmp24_;
	EditingToolsCropToolConstraintDescription* _tmp25_;
	EditingToolsCropToolConstraintDescription* _tmp26_;
	EditingToolsCropToolConstraintDescription* _tmp27_;
	EditingToolsCropToolConstraintDescription* _tmp28_;
	EditingToolsCropToolConstraintDescription* _tmp29_;
	EditingToolsCropToolConstraintDescription** _tmp30_;
	gint _tmp30__length1;
	EditingToolsCropToolConstraintDescription** result;
	_tmp0_ = g_new0 (EditingToolsCropToolConstraintDescription*, 0 + 1);
	_result_ = _tmp0_;
	_result__length1 = 0;
	__result__size_ = _result__length1;
	_tmp1_ = editing_tools_crop_tool_constraint_description_new (_ ("Unconstrained"), 0, 0, FALSE, EDITING_TOOLS_CROP_TOOL_ANY_ASPECT_RATIO);
	_vala_array_add51 (&_result_, &_result__length1, &__result__size_, _tmp1_);
	_tmp2_ = editing_tools_crop_tool_constraint_description_new (_ ("Square"), 1, 1, FALSE, EDITING_TOOLS_CROP_TOOL_COMPUTE_FROM_BASIS);
	_vala_array_add52 (&_result_, &_result__length1, &__result__size_, _tmp2_);
	_tmp3_ = editing_tools_crop_tool_constraint_description_new (_ ("Screen"), 0, 0, TRUE, EDITING_TOOLS_CROP_TOOL_SCREEN_ASPECT_RATIO);
	_vala_array_add53 (&_result_, &_result__length1, &__result__size_, _tmp3_);
	_tmp4_ = editing_tools_crop_tool_constraint_description_new (_ ("Original Size"), 0, 0, TRUE, EDITING_TOOLS_CROP_TOOL_ORIGINAL_ASPECT_RATIO);
	_vala_array_add54 (&_result_, &_result__length1, &__result__size_, _tmp4_);
	_tmp5_ = editing_tools_crop_tool_constraint_description_new (_ ("-"), 0, 0, FALSE, EDITING_TOOLS_CROP_TOOL_SEPARATOR);
	_vala_array_add55 (&_result_, &_result__length1, &__result__size_, _tmp5_);
	_tmp6_ = editing_tools_crop_tool_constraint_description_new (_ ("SD Video (4 : 3)"), 4, 3, TRUE, EDITING_TOOLS_CROP_TOOL_COMPUTE_FROM_BASIS);
	_vala_array_add56 (&_result_, &_result__length1, &__result__size_, _tmp6_);
	_tmp7_ = editing_tools_crop_tool_constraint_description_new (_ ("HD Video (16 : 9)"), 16, 9, TRUE, EDITING_TOOLS_CROP_TOOL_COMPUTE_FROM_BASIS);
	_vala_array_add57 (&_result_, &_result__length1, &__result__size_, _tmp7_);
	_tmp8_ = editing_tools_crop_tool_constraint_description_new (_ ("-"), 0, 0, FALSE, EDITING_TOOLS_CROP_TOOL_SEPARATOR);
	_vala_array_add58 (&_result_, &_result__length1, &__result__size_, _tmp8_);
	_tmp9_ = editing_tools_crop_tool_constraint_description_new (_ ("Wallet (2 x 3 in.)"), 3, 2, TRUE, EDITING_TOOLS_CROP_TOOL_COMPUTE_FROM_BASIS);
	_vala_array_add59 (&_result_, &_result__length1, &__result__size_, _tmp9_);
	_tmp10_ = editing_tools_crop_tool_constraint_description_new (_ ("Notecard (3 x 5 in.)"), 5, 3, TRUE, EDITING_TOOLS_CROP_TOOL_COMPUTE_FROM_BASIS);
	_vala_array_add60 (&_result_, &_result__length1, &__result__size_, _tmp10_);
	_tmp11_ = editing_tools_crop_tool_constraint_description_new (_ ("4 x 6 in."), 6, 4, TRUE, EDITING_TOOLS_CROP_TOOL_COMPUTE_FROM_BASIS);
	_vala_array_add61 (&_result_, &_result__length1, &__result__size_, _tmp11_);
	_tmp12_ = editing_tools_crop_tool_constraint_description_new (_ ("5 x 7 in."), 7, 5, TRUE, EDITING_TOOLS_CROP_TOOL_COMPUTE_FROM_BASIS);
	_vala_array_add62 (&_result_, &_result__length1, &__result__size_, _tmp12_);
	_tmp13_ = editing_tools_crop_tool_constraint_description_new (_ ("8 x 10 in."), 10, 8, TRUE, EDITING_TOOLS_CROP_TOOL_COMPUTE_FROM_BASIS);
	_vala_array_add63 (&_result_, &_result__length1, &__result__size_, _tmp13_);
	_tmp14_ = editing_tools_crop_tool_constraint_description_new (_ ("Letter (8.5 x 11 in.)"), 85, 110, TRUE, EDITING_TOOLS_CROP_TOOL_COMPUTE_FROM_BASIS);
	_vala_array_add64 (&_result_, &_result__length1, &__result__size_, _tmp14_);
	_tmp15_ = editing_tools_crop_tool_constraint_description_new (_ ("11 x 14 in."), 14, 11, TRUE, EDITING_TOOLS_CROP_TOOL_COMPUTE_FROM_BASIS);
	_vala_array_add65 (&_result_, &_result__length1, &__result__size_, _tmp15_);
	_tmp16_ = editing_tools_crop_tool_constraint_description_new (_ ("Tabloid (11 x 17 in.)"), 17, 11, TRUE, EDITING_TOOLS_CROP_TOOL_COMPUTE_FROM_BASIS);
	_vala_array_add66 (&_result_, &_result__length1, &__result__size_, _tmp16_);
	_tmp17_ = editing_tools_crop_tool_constraint_description_new (_ ("16 x 20 in."), 20, 16, TRUE, EDITING_TOOLS_CROP_TOOL_COMPUTE_FROM_BASIS);
	_vala_array_add67 (&_result_, &_result__length1, &__result__size_, _tmp17_);
	_tmp18_ = editing_tools_crop_tool_constraint_description_new (_ ("-"), 0, 0, FALSE, EDITING_TOOLS_CROP_TOOL_SEPARATOR);
	_vala_array_add68 (&_result_, &_result__length1, &__result__size_, _tmp18_);
	_tmp19_ = editing_tools_crop_tool_constraint_description_new (_ ("Metric Wallet (9 x 13 cm)"), 13, 9, TRUE, EDITING_TOOLS_CROP_TOOL_COMPUTE_FROM_BASIS);
	_vala_array_add69 (&_result_, &_result__length1, &__result__size_, _tmp19_);
	_tmp20_ = editing_tools_crop_tool_constraint_description_new (_ ("Postcard (10 x 15 cm)"), 15, 10, TRUE, EDITING_TOOLS_CROP_TOOL_COMPUTE_FROM_BASIS);
	_vala_array_add70 (&_result_, &_result__length1, &__result__size_, _tmp20_);
	_tmp21_ = editing_tools_crop_tool_constraint_description_new (_ ("13 x 18 cm"), 18, 13, TRUE, EDITING_TOOLS_CROP_TOOL_COMPUTE_FROM_BASIS);
	_vala_array_add71 (&_result_, &_result__length1, &__result__size_, _tmp21_);
	_tmp22_ = editing_tools_crop_tool_constraint_description_new (_ ("18 x 24 cm"), 24, 18, TRUE, EDITING_TOOLS_CROP_TOOL_COMPUTE_FROM_BASIS);
	_vala_array_add72 (&_result_, &_result__length1, &__result__size_, _tmp22_);
	_tmp23_ = editing_tools_crop_tool_constraint_description_new (_ ("A4 (210 x 297 mm)"), 210, 297, TRUE, EDITING_TOOLS_CROP_TOOL_COMPUTE_FROM_BASIS);
	_vala_array_add73 (&_result_, &_result__length1, &__result__size_, _tmp23_);
	_tmp24_ = editing_tools_crop_tool_constraint_description_new (_ ("20 x 30 cm"), 30, 20, TRUE, EDITING_TOOLS_CROP_TOOL_COMPUTE_FROM_BASIS);
	_vala_array_add74 (&_result_, &_result__length1, &__result__size_, _tmp24_);
	_tmp25_ = editing_tools_crop_tool_constraint_description_new (_ ("24 x 40 cm"), 40, 24, TRUE, EDITING_TOOLS_CROP_TOOL_COMPUTE_FROM_BASIS);
	_vala_array_add75 (&_result_, &_result__length1, &__result__size_, _tmp25_);
	_tmp26_ = editing_tools_crop_tool_constraint_description_new (_ ("30 x 40 cm"), 40, 30, TRUE, EDITING_TOOLS_CROP_TOOL_COMPUTE_FROM_BASIS);
	_vala_array_add76 (&_result_, &_result__length1, &__result__size_, _tmp26_);
	_tmp27_ = editing_tools_crop_tool_constraint_description_new (_ ("A3 (297 x 420 mm)"), 420, 297, TRUE, EDITING_TOOLS_CROP_TOOL_COMPUTE_FROM_BASIS);
	_vala_array_add77 (&_result_, &_result__length1, &__result__size_, _tmp27_);
	_tmp28_ = editing_tools_crop_tool_constraint_description_new (_ ("-"), 0, 0, FALSE, EDITING_TOOLS_CROP_TOOL_SEPARATOR);
	_vala_array_add78 (&_result_, &_result__length1, &__result__size_, _tmp28_);
	_tmp29_ = editing_tools_crop_tool_constraint_description_new (_ ("Custom"), 0, 0, TRUE, EDITING_TOOLS_CROP_TOOL_CUSTOM_ASPECT_RATIO);
	_vala_array_add79 (&_result_, &_result__length1, &__result__size_, _tmp29_);
	_tmp30_ = _result_;
	_tmp30__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp30__length1;
	}
	result = _tmp30_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkListStore*
editing_tools_crop_tool_create_constraint_list (EditingToolsCropToolConstraintDescription** constraint_data,
                                                gint constraint_data_length1)
{
	GtkListStore* _result_ = NULL;
	GtkListStore* _tmp0_;
	GtkTreeIter iter = {0};
	GtkListStore* result;
	_tmp0_ = gtk_list_store_new (1, G_TYPE_STRING, G_TYPE_STRING, -1);
	_result_ = _tmp0_;
	{
		EditingToolsCropToolConstraintDescription** constraint_collection = NULL;
		gint constraint_collection_length1 = 0;
		gint _constraint_collection_size_ = 0;
		gint constraint_it = 0;
		constraint_collection = constraint_data;
		constraint_collection_length1 = constraint_data_length1;
		for (constraint_it = 0; constraint_it < constraint_collection_length1; constraint_it = constraint_it + 1) {
			EditingToolsCropToolConstraintDescription* _tmp1_;
			EditingToolsCropToolConstraintDescription* constraint = NULL;
			_tmp1_ = _g_object_ref0 (constraint_collection[constraint_it]);
			constraint = _tmp1_;
			{
				GtkListStore* _tmp2_;
				GtkTreeIter _tmp3_ = {0};
				GtkListStore* _tmp4_;
				GtkTreeIter _tmp5_;
				EditingToolsCropToolConstraintDescription* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				GValue _tmp9_ = {0};
				_tmp2_ = _result_;
				gtk_list_store_append (_tmp2_, &_tmp3_);
				iter = _tmp3_;
				_tmp4_ = _result_;
				_tmp5_ = iter;
				_tmp6_ = constraint;
				_tmp7_ = editing_tools_crop_tool_constraint_description_get_name (_tmp6_);
				_tmp8_ = _tmp7_;
				g_value_init (&_tmp9_, G_TYPE_STRING);
				g_value_set_string (&_tmp9_, _tmp8_);
				gtk_list_store_set_value (_tmp4_, &_tmp5_, 0, &_tmp9_);
				G_IS_VALUE (&_tmp9_) ? (g_value_unset (&_tmp9_), NULL) : NULL;
				_g_object_unref0 (constraint);
			}
		}
	}
	result = _result_;
	return result;
}

static void
editing_tools_crop_tool_update_pivot_button_state (EditingToolsCropTool* self)
{
	EditingToolsCropToolCropToolWindow* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	EditingToolsCropToolConstraintDescription* _tmp3_;
	EditingToolsCropToolConstraintDescription* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->crop_tool_window;
	_tmp1_ = editing_tools_crop_tool_crop_tool_window_get_pivot_reticle_button (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = editing_tools_crop_tool_get_selected_constraint (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = editing_tools_crop_tool_constraint_description_get_is_pivotable (_tmp4_);
	_tmp6_ = _tmp5_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, _tmp6_);
	_g_object_unref0 (_tmp4_);
}

static EditingToolsCropToolConstraintDescription*
editing_tools_crop_tool_get_selected_constraint (EditingToolsCropTool* self)
{
	EditingToolsCropToolConstraintDescription* _result_ = NULL;
	EditingToolsCropToolConstraintDescription** _tmp0_;
	gint _tmp0__length1;
	EditingToolsCropToolCropToolWindow* _tmp1_;
	GtkComboBox* _tmp2_;
	GtkComboBox* _tmp3_;
	EditingToolsCropToolConstraintDescription* _tmp4_;
	EditingToolsCropToolConstraintDescription* _tmp5_;
	EditingToolsCropToolConstraintDescription* _tmp6_;
	gfloat _tmp7_;
	gfloat _tmp8_;
	EditingToolsCropToolConstraintDescription* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->constraints;
	_tmp0__length1 = self->priv->constraints_length1;
	_tmp1_ = self->priv->crop_tool_window;
	_tmp2_ = editing_tools_crop_tool_crop_tool_window_get_constraint_combo (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp0_[gtk_combo_box_get_active (_tmp3_)];
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_result_ = _tmp5_;
	_tmp6_ = _result_;
	_tmp7_ = editing_tools_crop_tool_constraint_description_get_aspect_ratio (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == EDITING_TOOLS_CROP_TOOL_ORIGINAL_ASPECT_RATIO) {
		EditingToolsCropToolConstraintDescription* _tmp9_;
		EditingToolsPhotoCanvas* _tmp10_;
		GdkRectangle _tmp11_ = {0};
		GdkRectangle _tmp12_;
		EditingToolsCropToolConstraintDescription* _tmp13_;
		EditingToolsPhotoCanvas* _tmp14_;
		GdkRectangle _tmp15_ = {0};
		GdkRectangle _tmp16_;
		_tmp9_ = _result_;
		_tmp10_ = ((EditingToolsEditingTool*) self)->canvas;
		editing_tools_photo_canvas_get_scaled_position (_tmp10_, &_tmp11_);
		_tmp12_ = _tmp11_;
		editing_tools_crop_tool_constraint_description_set_basis_width (_tmp9_, _tmp12_.width);
		_tmp13_ = _result_;
		_tmp14_ = ((EditingToolsEditingTool*) self)->canvas;
		editing_tools_photo_canvas_get_scaled_position (_tmp14_, &_tmp15_);
		_tmp16_ = _tmp15_;
		editing_tools_crop_tool_constraint_description_set_basis_height (_tmp13_, _tmp16_.height);
	} else {
		EditingToolsCropToolConstraintDescription* _tmp17_;
		gfloat _tmp18_;
		gfloat _tmp19_;
		_tmp17_ = _result_;
		_tmp18_ = editing_tools_crop_tool_constraint_description_get_aspect_ratio (_tmp17_);
		_tmp19_ = _tmp18_;
		if (_tmp19_ == EDITING_TOOLS_CROP_TOOL_SCREEN_ASPECT_RATIO) {
			Dimensions dimensions = {0};
			AppWindow* _tmp20_;
			AppWindow* _tmp21_;
			Dimensions _tmp22_ = {0};
			Dimensions _tmp23_;
			EditingToolsCropToolConstraintDescription* _tmp24_;
			Dimensions _tmp25_;
			EditingToolsCropToolConstraintDescription* _tmp26_;
			Dimensions _tmp27_;
			_tmp20_ = app_window_get_instance ();
			_tmp21_ = _tmp20_;
			scaling_get_screen_dimensions ((GtkWindow*) _tmp21_, &_tmp22_);
			_tmp23_ = _tmp22_;
			_g_object_unref0 (_tmp21_);
			dimensions = _tmp23_;
			_tmp24_ = _result_;
			_tmp25_ = dimensions;
			editing_tools_crop_tool_constraint_description_set_basis_width (_tmp24_, _tmp25_.width);
			_tmp26_ = _result_;
			_tmp27_ = dimensions;
			editing_tools_crop_tool_constraint_description_set_basis_height (_tmp26_, _tmp27_.height);
		}
	}
	result = _result_;
	return result;
}

static gboolean
editing_tools_crop_tool_on_custom_entry_focus_out (EditingToolsCropTool* self,
                                                   GdkEventFocus* event)
{
	gint width = 0;
	EditingToolsCropToolCropToolWindow* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint height = 0;
	EditingToolsCropToolCropToolWindow* _tmp5_;
	GtkEntry* _tmp6_;
	GtkEntry* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gboolean _tmp20_ = FALSE;
	Box new_crop = {0};
	Box _tmp53_;
	Box _tmp54_ = {0};
	Box _tmp55_;
	Box _tmp56_;
	EditingToolsPhotoCanvas* _tmp57_;
	Box _tmp58_;
	EditingToolsPhotoCanvas* _tmp59_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->crop_tool_window;
	_tmp1_ = editing_tools_crop_tool_crop_tool_window_get_custom_width_entry (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_entry_get_text (_tmp2_);
	_tmp4_ = _tmp3_;
	width = atoi (_tmp4_);
	_tmp5_ = self->priv->crop_tool_window;
	_tmp6_ = editing_tools_crop_tool_crop_tool_window_get_custom_height_entry (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = gtk_entry_get_text (_tmp7_);
	_tmp9_ = _tmp8_;
	height = atoi (_tmp9_);
	if (width < 1) {
		EditingToolsCropToolCropToolWindow* _tmp10_;
		GtkEntry* _tmp11_;
		GtkEntry* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		width = 1;
		_tmp10_ = self->priv->crop_tool_window;
		_tmp11_ = editing_tools_crop_tool_crop_tool_window_get_custom_width_entry (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strdup_printf ("%d", width);
		_tmp14_ = _tmp13_;
		gtk_entry_set_text (_tmp12_, _tmp14_);
		_g_free0 (_tmp14_);
	}
	if (height < 1) {
		EditingToolsCropToolCropToolWindow* _tmp15_;
		GtkEntry* _tmp16_;
		GtkEntry* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		height = 1;
		_tmp15_ = self->priv->crop_tool_window;
		_tmp16_ = editing_tools_crop_tool_crop_tool_window_get_custom_height_entry (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strdup_printf ("%d", height);
		_tmp19_ = _tmp18_;
		gtk_entry_set_text (_tmp17_, _tmp19_);
		_g_free0 (_tmp19_);
	}
	if (width == self->priv->custom_width) {
		_tmp20_ = height == self->priv->custom_height;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		result = FALSE;
		return result;
	}
	self->priv->custom_aspect_ratio = ((gfloat) width) / ((gfloat) height);
	if (self->priv->custom_aspect_ratio < EDITING_TOOLS_CROP_TOOL_MIN_ASPECT_RATIO) {
		EditingToolsCropToolCropToolWindow* _tmp21_;
		GtkEntry* _tmp22_;
		GtkEntry* _tmp23_;
		EditingToolsCropToolCropToolWindow* _tmp24_;
		GtkEntry* _tmp25_;
		GtkEntry* _tmp26_;
		_tmp21_ = self->priv->crop_tool_window;
		_tmp22_ = editing_tools_crop_tool_crop_tool_window_get_most_recently_edited (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = self->priv->crop_tool_window;
		_tmp25_ = editing_tools_crop_tool_crop_tool_window_get_custom_height_entry (_tmp24_);
		_tmp26_ = _tmp25_;
		if (_tmp23_ == _tmp26_) {
			EditingToolsCropToolCropToolWindow* _tmp27_;
			GtkEntry* _tmp28_;
			GtkEntry* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			height = (gint) (width / EDITING_TOOLS_CROP_TOOL_MIN_ASPECT_RATIO);
			_tmp27_ = self->priv->crop_tool_window;
			_tmp28_ = editing_tools_crop_tool_crop_tool_window_get_custom_height_entry (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = g_strdup_printf ("%d", height);
			_tmp31_ = _tmp30_;
			gtk_entry_set_text (_tmp29_, _tmp31_);
			_g_free0 (_tmp31_);
		} else {
			EditingToolsCropToolCropToolWindow* _tmp32_;
			GtkEntry* _tmp33_;
			GtkEntry* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			width = (gint) (height * EDITING_TOOLS_CROP_TOOL_MIN_ASPECT_RATIO);
			_tmp32_ = self->priv->crop_tool_window;
			_tmp33_ = editing_tools_crop_tool_crop_tool_window_get_custom_width_entry (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = g_strdup_printf ("%d", width);
			_tmp36_ = _tmp35_;
			gtk_entry_set_text (_tmp34_, _tmp36_);
			_g_free0 (_tmp36_);
		}
	} else {
		if (self->priv->custom_aspect_ratio > EDITING_TOOLS_CROP_TOOL_MAX_ASPECT_RATIO) {
			EditingToolsCropToolCropToolWindow* _tmp37_;
			GtkEntry* _tmp38_;
			GtkEntry* _tmp39_;
			EditingToolsCropToolCropToolWindow* _tmp40_;
			GtkEntry* _tmp41_;
			GtkEntry* _tmp42_;
			_tmp37_ = self->priv->crop_tool_window;
			_tmp38_ = editing_tools_crop_tool_crop_tool_window_get_most_recently_edited (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = self->priv->crop_tool_window;
			_tmp41_ = editing_tools_crop_tool_crop_tool_window_get_custom_height_entry (_tmp40_);
			_tmp42_ = _tmp41_;
			if (_tmp39_ == _tmp42_) {
				EditingToolsCropToolCropToolWindow* _tmp43_;
				GtkEntry* _tmp44_;
				GtkEntry* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				height = (gint) (width / EDITING_TOOLS_CROP_TOOL_MAX_ASPECT_RATIO);
				_tmp43_ = self->priv->crop_tool_window;
				_tmp44_ = editing_tools_crop_tool_crop_tool_window_get_custom_height_entry (_tmp43_);
				_tmp45_ = _tmp44_;
				_tmp46_ = g_strdup_printf ("%d", height);
				_tmp47_ = _tmp46_;
				gtk_entry_set_text (_tmp45_, _tmp47_);
				_g_free0 (_tmp47_);
			} else {
				EditingToolsCropToolCropToolWindow* _tmp48_;
				GtkEntry* _tmp49_;
				GtkEntry* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				width = (gint) (height * EDITING_TOOLS_CROP_TOOL_MAX_ASPECT_RATIO);
				_tmp48_ = self->priv->crop_tool_window;
				_tmp49_ = editing_tools_crop_tool_crop_tool_window_get_custom_width_entry (_tmp48_);
				_tmp50_ = _tmp49_;
				_tmp51_ = g_strdup_printf ("%d", width);
				_tmp52_ = _tmp51_;
				gtk_entry_set_text (_tmp50_, _tmp52_);
				_g_free0 (_tmp52_);
			}
		}
	}
	self->priv->custom_aspect_ratio = ((gfloat) width) / ((gfloat) height);
	_tmp53_ = self->priv->scaled_crop;
	editing_tools_crop_tool_constrain_crop (self, &_tmp53_, &_tmp54_);
	new_crop = _tmp54_;
	_tmp55_ = new_crop;
	editing_tools_crop_tool_crop_resized (self, &_tmp55_);
	_tmp56_ = new_crop;
	self->priv->scaled_crop = _tmp56_;
	_tmp57_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp58_ = new_crop;
	editing_tools_photo_canvas_invalidate_area (_tmp57_, &_tmp58_);
	_tmp59_ = ((EditingToolsEditingTool*) self)->canvas;
	editing_tools_photo_canvas_repaint (_tmp59_);
	self->priv->custom_width = width;
	self->priv->custom_height = height;
	result = FALSE;
	return result;
}

static void
editing_tools_crop_tool_on_width_insert_text (EditingToolsCropTool* self,
                                              const gchar* text,
                                              gint length,
                                              gint* position)
{
	EditingToolsCropToolCropToolWindow* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->crop_tool_window;
	_tmp1_ = editing_tools_crop_tool_crop_tool_window_get_custom_width_entry (_tmp0_);
	_tmp2_ = _tmp1_;
	editing_tools_crop_tool_on_entry_insert_text (self, _tmp2_, text, length, position);
}

static void
editing_tools_crop_tool_on_height_insert_text (EditingToolsCropTool* self,
                                               const gchar* text,
                                               gint length,
                                               gint* position)
{
	EditingToolsCropToolCropToolWindow* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->crop_tool_window;
	_tmp1_ = editing_tools_crop_tool_crop_tool_window_get_custom_height_entry (_tmp0_);
	_tmp2_ = _tmp1_;
	editing_tools_crop_tool_on_entry_insert_text (self, _tmp2_, text, length, position);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static void
editing_tools_crop_tool_on_entry_insert_text (EditingToolsCropTool* self,
                                              GtkEntry* sender,
                                              const gchar* text,
                                              gint length,
                                              gint* position)
{
	gchar* new_text = NULL;
	gchar* _tmp2_;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (text != NULL);
	if (self->priv->entry_insert_in_progress) {
		return;
	}
	self->priv->entry_insert_in_progress = TRUE;
	if (length == -1) {
		gint _tmp0_;
		gint _tmp1_;
		_tmp0_ = strlen (text);
		_tmp1_ = _tmp0_;
		length = (gint) _tmp1_;
	}
	_tmp2_ = g_strdup ("");
	new_text = _tmp2_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = ctr;
					ctr = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(ctr < length)) {
					break;
				}
				if (g_ascii_isdigit (string_get (text, (glong) ctr))) {
					const gchar* _tmp5_;
					gchar* _tmp6_;
					gchar* _tmp7_;
					gchar* _tmp8_;
					_tmp5_ = new_text;
					_tmp6_ = g_strdup_printf ("%c", (gchar) string_get (text, (glong) ctr));
					_tmp7_ = _tmp6_;
					_tmp8_ = g_strconcat (_tmp5_, _tmp7_, NULL);
					_g_free0 (new_text);
					new_text = _tmp8_;
					_g_free0 (_tmp7_);
				}
			}
		}
	}
	_tmp9_ = new_text;
	_tmp10_ = strlen (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ > 0) {
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		_tmp12_ = new_text;
		_tmp13_ = new_text;
		_tmp14_ = strlen (_tmp13_);
		_tmp15_ = _tmp14_;
		g_signal_emit_by_name ((GtkEditable*) sender, "insert-text", _tmp12_, (gint) _tmp15_, position);
	}
	g_signal_stop_emission_by_name (sender, "insert-text");
	self->priv->entry_insert_in_progress = FALSE;
	_g_free0 (new_text);
}

static gfloat
editing_tools_crop_tool_get_constraint_aspect_ratio (EditingToolsCropTool* self)
{
	gfloat _result_ = 0.0F;
	EditingToolsCropToolConstraintDescription* _tmp0_;
	EditingToolsCropToolConstraintDescription* _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	gfloat _tmp4_;
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	_tmp0_ = editing_tools_crop_tool_get_selected_constraint (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = editing_tools_crop_tool_constraint_description_get_aspect_ratio (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	_result_ = _tmp4_;
	if (_result_ == EDITING_TOOLS_CROP_TOOL_ORIGINAL_ASPECT_RATIO) {
		EditingToolsPhotoCanvas* _tmp5_;
		GdkRectangle _tmp6_ = {0};
		GdkRectangle _tmp7_;
		EditingToolsPhotoCanvas* _tmp8_;
		GdkRectangle _tmp9_ = {0};
		GdkRectangle _tmp10_;
		_tmp5_ = ((EditingToolsEditingTool*) self)->canvas;
		editing_tools_photo_canvas_get_scaled_position (_tmp5_, &_tmp6_);
		_tmp7_ = _tmp6_;
		_tmp8_ = ((EditingToolsEditingTool*) self)->canvas;
		editing_tools_photo_canvas_get_scaled_position (_tmp8_, &_tmp9_);
		_tmp10_ = _tmp9_;
		_result_ = ((gfloat) _tmp7_.width) / ((gfloat) _tmp10_.height);
	} else {
		if (_result_ == EDITING_TOOLS_CROP_TOOL_SCREEN_ASPECT_RATIO) {
			Dimensions dimensions = {0};
			AppWindow* _tmp11_;
			AppWindow* _tmp12_;
			Dimensions _tmp13_ = {0};
			Dimensions _tmp14_;
			Dimensions _tmp15_;
			Dimensions _tmp16_;
			_tmp11_ = app_window_get_instance ();
			_tmp12_ = _tmp11_;
			scaling_get_screen_dimensions ((GtkWindow*) _tmp12_, &_tmp13_);
			_tmp14_ = _tmp13_;
			_g_object_unref0 (_tmp12_);
			dimensions = _tmp14_;
			_tmp15_ = dimensions;
			_tmp16_ = dimensions;
			_result_ = ((gfloat) _tmp15_.width) / ((gfloat) _tmp16_.height);
		} else {
			if (_result_ == EDITING_TOOLS_CROP_TOOL_CUSTOM_ASPECT_RATIO) {
				_result_ = self->priv->custom_aspect_ratio;
			}
		}
	}
	if (self->priv->reticle_orientation == EDITING_TOOLS_CROP_TOOL_RETICLE_ORIENTATION_PORTRAIT) {
		_result_ = 1.0f / _result_;
	}
	result = _result_;
	return result;
}

static void
editing_tools_crop_tool_constraint_changed (EditingToolsCropTool* self)
{
	EditingToolsCropToolConstraintDescription* selected_constraint = NULL;
	EditingToolsCropToolConstraintDescription* _tmp0_;
	EditingToolsCropToolConstraintDescription* _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	EditingToolsCropToolConstraintDescription* _tmp12_;
	EditingToolsCropToolConstraintDescription* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = editing_tools_crop_tool_get_selected_constraint (self);
	selected_constraint = _tmp0_;
	_tmp1_ = selected_constraint;
	_tmp2_ = editing_tools_crop_tool_constraint_description_get_aspect_ratio (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == EDITING_TOOLS_CROP_TOOL_CUSTOM_ASPECT_RATIO) {
		editing_tools_crop_tool_set_custom_constraint_mode (self);
	} else {
		EditingToolsCropToolConstraintDescription* _tmp7_;
		gfloat _tmp8_;
		gfloat _tmp9_;
		if (self->priv->constraint_mode != EDITING_TOOLS_CROP_TOOL_CONSTRAINT_MODE_NORMAL) {
			EditingToolsCropToolCropToolWindow* _tmp4_;
			GtkRevealer* _tmp5_;
			GtkRevealer* _tmp6_;
			_tmp4_ = self->priv->crop_tool_window;
			_tmp5_ = editing_tools_crop_tool_crop_tool_window_get_custom_aspect_revealer (_tmp4_);
			_tmp6_ = _tmp5_;
			gtk_revealer_set_reveal_child (_tmp6_, FALSE);
			self->priv->constraint_mode = EDITING_TOOLS_CROP_TOOL_CONSTRAINT_MODE_NORMAL;
		}
		_tmp7_ = selected_constraint;
		_tmp8_ = editing_tools_crop_tool_constraint_description_get_aspect_ratio (_tmp7_);
		_tmp9_ = _tmp8_;
		if (_tmp9_ != EDITING_TOOLS_CROP_TOOL_ANY_ASPECT_RATIO) {
			GSettings* _tmp10_;
			GSettings* _tmp11_;
			_tmp10_ = self->priv->crop_settings;
			self->priv->custom_init_width = g_settings_get_int (_tmp10_, "last-crop-width");
			_tmp11_ = self->priv->crop_settings;
			self->priv->custom_init_height = g_settings_get_int (_tmp11_, "last-crop-height");
			self->priv->custom_aspect_ratio = ((gfloat) self->priv->custom_init_width) / ((gfloat) self->priv->custom_init_height);
		}
	}
	editing_tools_crop_tool_update_pivot_button_state (self);
	_tmp12_ = editing_tools_crop_tool_get_selected_constraint (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = editing_tools_crop_tool_constraint_description_get_is_pivotable (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = !_tmp15_;
	_g_object_unref0 (_tmp13_);
	if (_tmp16_) {
		self->priv->reticle_orientation = EDITING_TOOLS_CROP_TOOL_RETICLE_ORIENTATION_LANDSCAPE;
	}
	if (editing_tools_crop_tool_get_constraint_aspect_ratio (self) != self->priv->pre_aspect_ratio) {
		Box new_crop = {0};
		Box _tmp17_;
		Box _tmp18_ = {0};
		Box _tmp19_;
		Box _tmp20_;
		EditingToolsPhotoCanvas* _tmp21_;
		Box _tmp22_;
		EditingToolsPhotoCanvas* _tmp23_;
		_tmp17_ = self->priv->scaled_crop;
		editing_tools_crop_tool_constrain_crop (self, &_tmp17_, &_tmp18_);
		new_crop = _tmp18_;
		_tmp19_ = new_crop;
		editing_tools_crop_tool_crop_resized (self, &_tmp19_);
		_tmp20_ = new_crop;
		self->priv->scaled_crop = _tmp20_;
		_tmp21_ = ((EditingToolsEditingTool*) self)->canvas;
		_tmp22_ = new_crop;
		editing_tools_photo_canvas_invalidate_area (_tmp21_, &_tmp22_);
		_tmp23_ = ((EditingToolsEditingTool*) self)->canvas;
		editing_tools_photo_canvas_repaint (_tmp23_);
		self->priv->pre_aspect_ratio = editing_tools_crop_tool_get_constraint_aspect_ratio (self);
	}
	_g_object_unref0 (selected_constraint);
}

static void
editing_tools_crop_tool_set_custom_constraint_mode (EditingToolsCropTool* self)
{
	EditingToolsCropToolCropToolWindow* _tmp0_;
	GtkRevealer* _tmp1_;
	GtkRevealer* _tmp2_;
	g_return_if_fail (self != NULL);
	if (self->priv->constraint_mode == EDITING_TOOLS_CROP_TOOL_CONSTRAINT_MODE_CUSTOM) {
		return;
	}
	_tmp0_ = self->priv->crop_tool_window;
	_tmp1_ = editing_tools_crop_tool_crop_tool_window_get_custom_aspect_revealer (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_revealer_set_reveal_child (_tmp2_, TRUE);
	if (self->priv->reticle_orientation == EDITING_TOOLS_CROP_TOOL_RETICLE_ORIENTATION_LANDSCAPE) {
		EditingToolsCropToolCropToolWindow* _tmp3_;
		GtkEntry* _tmp4_;
		GtkEntry* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		EditingToolsCropToolCropToolWindow* _tmp8_;
		GtkEntry* _tmp9_;
		GtkEntry* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp3_ = self->priv->crop_tool_window;
		_tmp4_ = editing_tools_crop_tool_crop_tool_window_get_custom_width_entry (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf ("%d", self->priv->custom_init_width);
		_tmp7_ = _tmp6_;
		gtk_entry_set_text (_tmp5_, _tmp7_);
		_g_free0 (_tmp7_);
		_tmp8_ = self->priv->crop_tool_window;
		_tmp9_ = editing_tools_crop_tool_crop_tool_window_get_custom_height_entry (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup_printf ("%d", self->priv->custom_init_height);
		_tmp12_ = _tmp11_;
		gtk_entry_set_text (_tmp10_, _tmp12_);
		_g_free0 (_tmp12_);
	} else {
		EditingToolsCropToolCropToolWindow* _tmp13_;
		GtkEntry* _tmp14_;
		GtkEntry* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		EditingToolsCropToolCropToolWindow* _tmp18_;
		GtkEntry* _tmp19_;
		GtkEntry* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp13_ = self->priv->crop_tool_window;
		_tmp14_ = editing_tools_crop_tool_crop_tool_window_get_custom_width_entry (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup_printf ("%d", self->priv->custom_init_height);
		_tmp17_ = _tmp16_;
		gtk_entry_set_text (_tmp15_, _tmp17_);
		_g_free0 (_tmp17_);
		_tmp18_ = self->priv->crop_tool_window;
		_tmp19_ = editing_tools_crop_tool_crop_tool_window_get_custom_height_entry (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strdup_printf ("%d", self->priv->custom_init_width);
		_tmp22_ = _tmp21_;
		gtk_entry_set_text (_tmp20_, _tmp22_);
		_g_free0 (_tmp22_);
	}
	self->priv->custom_aspect_ratio = ((gfloat) self->priv->custom_init_width) / ((gfloat) self->priv->custom_init_height);
	self->priv->constraint_mode = EDITING_TOOLS_CROP_TOOL_CONSTRAINT_MODE_CUSTOM;
}

static void
editing_tools_crop_tool_constrain_crop (EditingToolsCropTool* self,
                                        Box* crop,
                                        Box* result)
{
	gfloat user_aspect_ratio = 0.0F;
	gfloat old_area = 0.0F;
	Dimensions image_size = {0};
	Dimensions _tmp1_ = {0};
	gdouble angle = 0.0;
	EditingToolsPhotoCanvas* _tmp2_;
	Photo* _tmp3_;
	Photo* _tmp4_;
	gdouble _tmp5_ = 0.0;
	Box _tmp6_;
	Dimensions _tmp7_;
	Dimensions _tmp8_;
	Box _tmp9_ = {0};
	Box _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (crop != NULL);
	user_aspect_ratio = editing_tools_crop_tool_get_constraint_aspect_ratio (self);
	if (user_aspect_ratio == EDITING_TOOLS_CROP_TOOL_ANY_ASPECT_RATIO) {
		Box _tmp0_;
		_tmp0_ = *crop;
		*result = _tmp0_;
		return;
	}
	old_area = (gfloat) (box_get_width (crop) * box_get_height (crop));
	box_adjust_height (crop, (gint) sqrt ((gdouble) (old_area / user_aspect_ratio)));
	box_adjust_width (crop, (gint) sqrt ((gdouble) (old_area * user_aspect_ratio)));
	editing_tools_crop_tool_get_photo_dimensions (self, &_tmp1_);
	image_size = _tmp1_;
	_tmp2_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp3_ = editing_tools_photo_canvas_get_photo (_tmp2_);
	_tmp4_ = _tmp3_;
	photo_get_straighten (_tmp4_, &_tmp5_);
	angle = _tmp5_;
	_tmp6_ = *crop;
	_tmp7_ = image_size;
	_tmp8_ = image_size;
	clamp_inside_rotated_image (&_tmp6_, _tmp7_.width, _tmp8_.height, angle, FALSE, &_tmp9_);
	*crop = _tmp9_;
	if (((gfloat) box_get_width (crop)) >= (box_get_height (crop) * user_aspect_ratio)) {
		box_adjust_width (crop, (gint) (box_get_height (crop) * user_aspect_ratio));
	} else {
		box_adjust_height (crop, (gint) (box_get_width (crop) / user_aspect_ratio));
	}
	_tmp10_ = *crop;
	*result = _tmp10_;
	return;
}

static EditingToolsCropToolConstraintDescription*
editing_tools_crop_tool_get_last_constraint (EditingToolsCropTool* self,
                                             gint* index)
{
	gint _vala_index = 0;
	GSettings* _tmp0_;
	EditingToolsCropToolConstraintDescription* _tmp1_ = NULL;
	EditingToolsCropToolConstraintDescription** _tmp2_;
	gint _tmp2__length1;
	EditingToolsCropToolConstraintDescription* _tmp5_;
	EditingToolsCropToolConstraintDescription* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->crop_settings;
	_vala_index = g_settings_get_int (_tmp0_, "last-crop-menu-choice");
	_tmp2_ = self->priv->constraints;
	_tmp2__length1 = self->priv->constraints_length1;
	if (_vala_index < _tmp2__length1) {
		EditingToolsCropToolConstraintDescription** _tmp3_;
		gint _tmp3__length1;
		EditingToolsCropToolConstraintDescription* _tmp4_;
		_tmp3_ = self->priv->constraints;
		_tmp3__length1 = self->priv->constraints_length1;
		_tmp4_ = _tmp3_[_vala_index];
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = NULL;
	}
	_tmp5_ = _g_object_ref0 (_tmp1_);
	result = _tmp5_;
	if (index) {
		*index = _vala_index;
	}
	return result;
}

static void
editing_tools_crop_tool_real_activate (EditingToolsEditingTool* base,
                                       EditingToolsPhotoCanvas* canvas)
{
	EditingToolsCropTool * self;
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	cairo_t* _tmp4_;
	cairo_t* _tmp5_;
	Dimensions _tmp6_ = {0};
	Dimensions _tmp7_;
	cairo_surface_t* _tmp8_;
	GdkRectangle _tmp9_ = {0};
	GdkRectangle _tmp10_;
	GdkRectangle _tmp11_ = {0};
	GdkRectangle _tmp12_;
	cairo_surface_t* _tmp13_;
	cairo_t* ctx = NULL;
	cairo_surface_t* _tmp14_;
	cairo_t* _tmp15_;
	cairo_t* _tmp16_;
	cairo_t* _tmp17_;
	GtkWindow* _tmp18_;
	GtkWindow* _tmp19_;
	EditingToolsCropToolCropToolWindow* _tmp20_;
	EditingToolsCropToolCropToolWindow* _tmp21_;
	GtkComboBox* _tmp22_;
	GtkComboBox* _tmp23_;
	GtkListStore* _tmp24_;
	Photo* _tmp25_;
	Photo* _tmp26_;
	Dimensions uncropped_dim = {0};
	Photo* _tmp35_;
	Photo* _tmp36_;
	Dimensions _tmp37_ = {0};
	Box crop = {0};
	Photo* _tmp38_;
	Photo* _tmp39_;
	Box _tmp40_ = {0};
	gboolean _tmp41_;
	Dimensions _tmp46_;
	GdkRectangle _tmp47_ = {0};
	GdkRectangle _tmp48_;
	Dimensions _tmp49_ = {0};
	Box _tmp50_ = {0};
	GSettings* _tmp51_;
	GSettings* _tmp52_;
	EditingToolsCropToolCropToolWindow* _tmp53_;
	EditingToolsCropToolCropToolWindow* _tmp54_;
	Photo* _tmp55_;
	Photo* _tmp56_;
	Box new_crop = {0};
	Box _tmp65_;
	Box _tmp66_ = {0};
	Box _tmp67_;
	Box _tmp68_;
	Box _tmp69_;
	self = (EditingToolsCropTool*) base;
	g_return_if_fail (canvas != NULL);
	_tmp0_ = editing_tools_photo_canvas_get_container (canvas);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_widget_get_scale_factor ((GtkWidget*) _tmp1_);
	_tmp3_ = _tmp2_;
	self->priv->scale_factor = _tmp3_;
	editing_tools_crop_tool_bind_canvas_handlers (self, canvas);
	_tmp4_ = editing_tools_photo_canvas_get_default_ctx (canvas);
	_tmp5_ = _tmp4_;
	editing_tools_photo_canvas_get_surface_dim (canvas, &_tmp6_);
	_tmp7_ = _tmp6_;
	editing_tools_crop_tool_prepare_ctx (self, _tmp5_, &_tmp7_);
	_tmp8_ = self->priv->crop_surface;
	if (_tmp8_ != NULL) {
		_cairo_surface_destroy0 (self->priv->crop_surface);
		self->priv->crop_surface = NULL;
	}
	editing_tools_photo_canvas_get_scaled_position (canvas, &_tmp9_);
	_tmp10_ = _tmp9_;
	editing_tools_photo_canvas_get_scaled_position (canvas, &_tmp11_);
	_tmp12_ = _tmp11_;
	_tmp13_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _tmp10_.width, _tmp12_.height);
	_cairo_surface_destroy0 (self->priv->crop_surface);
	self->priv->crop_surface = _tmp13_;
	_tmp14_ = self->priv->crop_surface;
	_tmp15_ = cairo_create (_tmp14_);
	ctx = _tmp15_;
	_tmp16_ = ctx;
	cairo_set_source_rgba (_tmp16_, 0.0, 0.0, 0.0, 1.0);
	_tmp17_ = ctx;
	cairo_paint (_tmp17_);
	_tmp18_ = editing_tools_photo_canvas_get_container (canvas);
	_tmp19_ = _tmp18_;
	_tmp20_ = editing_tools_crop_tool_crop_tool_window_new (_tmp19_);
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->crop_tool_window);
	self->priv->crop_tool_window = _tmp20_;
	_tmp21_ = self->priv->crop_tool_window;
	_tmp22_ = editing_tools_crop_tool_crop_tool_window_get_constraint_combo (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = self->priv->constraint_list;
	gtk_combo_box_set_model (_tmp23_, (GtkTreeModel*) _tmp24_);
	_tmp25_ = editing_tools_photo_canvas_get_photo (canvas);
	_tmp26_ = _tmp25_;
	if (!photo_has_crop (_tmp26_)) {
		gint index = 0;
		EditingToolsCropToolConstraintDescription* desc = NULL;
		gint _tmp27_ = 0;
		EditingToolsCropToolConstraintDescription* _tmp28_;
		gboolean _tmp29_ = FALSE;
		EditingToolsCropToolConstraintDescription* _tmp30_;
		_tmp28_ = editing_tools_crop_tool_get_last_constraint (self, &_tmp27_);
		index = _tmp27_;
		desc = _tmp28_;
		_tmp30_ = desc;
		if (_tmp30_ != NULL) {
			EditingToolsCropToolConstraintDescription* _tmp31_;
			_tmp31_ = desc;
			_tmp29_ = !editing_tools_crop_tool_constraint_description_is_separator (_tmp31_);
		} else {
			_tmp29_ = FALSE;
		}
		if (_tmp29_) {
			EditingToolsCropToolCropToolWindow* _tmp32_;
			GtkComboBox* _tmp33_;
			GtkComboBox* _tmp34_;
			_tmp32_ = self->priv->crop_tool_window;
			_tmp33_ = editing_tools_crop_tool_crop_tool_window_get_constraint_combo (_tmp32_);
			_tmp34_ = _tmp33_;
			gtk_combo_box_set_active (_tmp34_, index);
		}
		_g_object_unref0 (desc);
	}
	editing_tools_crop_tool_update_pivot_button_state (self);
	self->priv->reticle_orientation = EDITING_TOOLS_CROP_TOOL_RETICLE_ORIENTATION_LANDSCAPE;
	editing_tools_crop_tool_bind_window_handlers (self);
	_tmp35_ = editing_tools_photo_canvas_get_photo (canvas);
	_tmp36_ = _tmp35_;
	media_source_get_dimensions ((MediaSource*) _tmp36_, PHOTO_EXCEPTION_CROP, &_tmp37_);
	uncropped_dim = _tmp37_;
	_tmp38_ = editing_tools_photo_canvas_get_photo (canvas);
	_tmp39_ = _tmp38_;
	_tmp41_ = photo_get_crop (_tmp39_, &_tmp40_, PHOTO_EXCEPTION_NONE);
	crop = _tmp40_;
	if (!_tmp41_) {
		gint xofs = 0;
		Dimensions _tmp42_;
		gint yofs = 0;
		Dimensions _tmp43_;
		Dimensions _tmp44_;
		Dimensions _tmp45_;
		_tmp42_ = uncropped_dim;
		xofs = (gint) (_tmp42_.width * EDITING_TOOLS_CROP_TOOL_CROP_INIT_X_PCT);
		_tmp43_ = uncropped_dim;
		yofs = (gint) (_tmp43_.height * EDITING_TOOLS_CROP_TOOL_CROP_INIT_Y_PCT);
		_tmp44_ = uncropped_dim;
		_tmp45_ = uncropped_dim;
		box_init (&crop, xofs, yofs, _tmp44_.width - xofs, _tmp45_.height - yofs);
	}
	_tmp46_ = uncropped_dim;
	editing_tools_photo_canvas_get_scaled_position (canvas, &_tmp47_);
	_tmp48_ = _tmp47_;
	dimensions_for_rectangle (&_tmp48_, &_tmp49_);
	box_get_scaled_similar (&crop, &_tmp46_, &_tmp49_, &_tmp50_);
	self->priv->scaled_crop = _tmp50_;
	_tmp51_ = self->priv->crop_settings;
	self->priv->custom_width = g_settings_get_int (_tmp51_, "last-crop-width");
	_tmp52_ = self->priv->crop_settings;
	self->priv->custom_height = g_settings_get_int (_tmp52_, "last-crop-height");
	self->priv->custom_init_width = self->priv->custom_width;
	self->priv->custom_init_height = self->priv->custom_height;
	self->priv->pre_aspect_ratio = ((gfloat) self->priv->custom_init_width) / ((gfloat) self->priv->custom_init_height);
	self->priv->constraint_mode = EDITING_TOOLS_CROP_TOOL_CONSTRAINT_MODE_NORMAL;
	EDITING_TOOLS_EDITING_TOOL_CLASS (editing_tools_crop_tool_parent_class)->activate (G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool), canvas);
	_tmp53_ = self->priv->crop_tool_window;
	gtk_widget_show_all ((GtkWidget*) _tmp53_);
	_tmp54_ = self->priv->crop_tool_window;
	gtk_widget_hide ((GtkWidget*) _tmp54_);
	_tmp55_ = editing_tools_photo_canvas_get_photo (canvas);
	_tmp56_ = _tmp55_;
	if (!photo_has_crop (_tmp56_)) {
		EditingToolsCropToolConstraintDescription* desc = NULL;
		EditingToolsCropToolConstraintDescription* _tmp57_;
		gboolean _tmp58_ = FALSE;
		gboolean _tmp59_ = FALSE;
		EditingToolsCropToolConstraintDescription* _tmp60_;
		_tmp57_ = editing_tools_crop_tool_get_last_constraint (self, NULL);
		desc = _tmp57_;
		_tmp60_ = desc;
		if (_tmp60_ != NULL) {
			EditingToolsCropToolConstraintDescription* _tmp61_;
			_tmp61_ = desc;
			_tmp59_ = !editing_tools_crop_tool_constraint_description_is_separator (_tmp61_);
		} else {
			_tmp59_ = FALSE;
		}
		if (_tmp59_) {
			EditingToolsCropToolConstraintDescription* _tmp62_;
			gfloat _tmp63_;
			gfloat _tmp64_;
			_tmp62_ = desc;
			_tmp63_ = editing_tools_crop_tool_constraint_description_get_aspect_ratio (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp58_ = _tmp64_ == EDITING_TOOLS_CROP_TOOL_CUSTOM_ASPECT_RATIO;
		} else {
			_tmp58_ = FALSE;
		}
		if (_tmp58_) {
			editing_tools_crop_tool_set_custom_constraint_mode (self);
		}
		_g_object_unref0 (desc);
	}
	_tmp65_ = self->priv->scaled_crop;
	editing_tools_crop_tool_constrain_crop (self, &_tmp65_, &_tmp66_);
	new_crop = _tmp66_;
	_tmp67_ = new_crop;
	editing_tools_crop_tool_crop_resized (self, &_tmp67_);
	_tmp68_ = new_crop;
	self->priv->scaled_crop = _tmp68_;
	_tmp69_ = new_crop;
	editing_tools_photo_canvas_invalidate_area (canvas, &_tmp69_);
	editing_tools_photo_canvas_repaint (canvas);
	self->priv->pre_aspect_ratio = editing_tools_crop_tool_get_constraint_aspect_ratio (self);
	_cairo_destroy0 (ctx);
}

static void
_editing_tools_crop_tool_prepare_ctx_editing_tools_photo_canvas_new_surface (EditingToolsPhotoCanvas* _sender,
                                                                             cairo_t* ctx,
                                                                             Dimensions* dim,
                                                                             gpointer self)
{
	editing_tools_crop_tool_prepare_ctx ((EditingToolsCropTool*) self, ctx, dim);
}

static void
_editing_tools_crop_tool_on_resized_pixbuf_editing_tools_photo_canvas_resized_scaled_pixbuf (EditingToolsPhotoCanvas* _sender,
                                                                                             Dimensions* old_dim,
                                                                                             GdkPixbuf* scaled,
                                                                                             GdkRectangle* scaled_position,
                                                                                             gpointer self)
{
	editing_tools_crop_tool_on_resized_pixbuf ((EditingToolsCropTool*) self, old_dim, scaled, scaled_position);
}

static void
editing_tools_crop_tool_bind_canvas_handlers (EditingToolsCropTool* self,
                                              EditingToolsPhotoCanvas* canvas)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (canvas != NULL);
	g_signal_connect_object (canvas, "new-surface", (GCallback) _editing_tools_crop_tool_prepare_ctx_editing_tools_photo_canvas_new_surface, self, 0);
	g_signal_connect_object (canvas, "resized-scaled-pixbuf", (GCallback) _editing_tools_crop_tool_on_resized_pixbuf_editing_tools_photo_canvas_resized_scaled_pixbuf, self, 0);
}

static void
editing_tools_crop_tool_unbind_canvas_handlers (EditingToolsCropTool* self,
                                                EditingToolsPhotoCanvas* canvas)
{
	guint _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (canvas != NULL);
	g_signal_parse_name ("new-surface", EDITING_TOOLS_TYPE_PHOTO_CANVAS, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (canvas, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _editing_tools_crop_tool_prepare_ctx_editing_tools_photo_canvas_new_surface, self);
	g_signal_parse_name ("resized-scaled-pixbuf", EDITING_TOOLS_TYPE_PHOTO_CANVAS, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (canvas, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _editing_tools_crop_tool_on_resized_pixbuf_editing_tools_photo_canvas_resized_scaled_pixbuf, self);
}

static void
_editing_tools_crop_tool_on_crop_ok_gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self)
{
	editing_tools_crop_tool_on_crop_ok ((EditingToolsCropTool*) self);
}

static void
_editing_tools_editing_tool_notify_cancel_gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self)
{
	editing_tools_editing_tool_notify_cancel ((EditingToolsEditingTool*) self);
}

static void
_editing_tools_crop_tool_constraint_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                   gpointer self)
{
	editing_tools_crop_tool_constraint_changed ((EditingToolsCropTool*) self);
}

static void
_editing_tools_crop_tool_on_pivot_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                     gpointer self)
{
	editing_tools_crop_tool_on_pivot_button_clicked ((EditingToolsCropTool*) self);
}

static gboolean
_editing_tools_crop_tool_on_custom_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                               GdkEventFocus* event,
                                                                               gpointer self)
{
	gboolean result;
	result = editing_tools_crop_tool_on_custom_entry_focus_out ((EditingToolsCropTool*) self, event);
	return result;
}

static void
_editing_tools_crop_tool_on_width_insert_text_gtk_editable_insert_text (GtkEditable* _sender,
                                                                        const gchar* new_text,
                                                                        gint new_text_length,
                                                                        gint* position,
                                                                        gpointer self)
{
	editing_tools_crop_tool_on_width_insert_text ((EditingToolsCropTool*) self, new_text, new_text_length, position);
}

static void
_editing_tools_crop_tool_on_height_insert_text_gtk_editable_insert_text (GtkEditable* _sender,
                                                                         const gchar* new_text,
                                                                         gint new_text_length,
                                                                         gint* position,
                                                                         gpointer self)
{
	editing_tools_crop_tool_on_height_insert_text ((EditingToolsCropTool*) self, new_text, new_text_length, position);
}

static void
editing_tools_crop_tool_bind_window_handlers (EditingToolsCropTool* self)
{
	EditingToolsCropToolCropToolWindow* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	EditingToolsCropToolCropToolWindow* _tmp3_;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	EditingToolsCropToolCropToolWindow* _tmp6_;
	GtkComboBox* _tmp7_;
	GtkComboBox* _tmp8_;
	EditingToolsCropToolCropToolWindow* _tmp9_;
	GtkButton* _tmp10_;
	GtkButton* _tmp11_;
	EditingToolsCropToolCropToolWindow* _tmp12_;
	GtkEntry* _tmp13_;
	GtkEntry* _tmp14_;
	EditingToolsCropToolCropToolWindow* _tmp15_;
	GtkEntry* _tmp16_;
	GtkEntry* _tmp17_;
	EditingToolsCropToolCropToolWindow* _tmp18_;
	GtkEntry* _tmp19_;
	GtkEntry* _tmp20_;
	EditingToolsCropToolCropToolWindow* _tmp21_;
	GtkEntry* _tmp22_;
	GtkEntry* _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->crop_tool_window;
	_tmp1_ = editing_tools_crop_tool_crop_tool_window_get_crop_button (_tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_connect_object (_tmp2_, "clicked", (GCallback) _editing_tools_crop_tool_on_crop_ok_gtk_button_clicked, self, 0);
	_tmp3_ = self->priv->crop_tool_window;
	_tmp4_ = editing_tools_crop_tool_crop_tool_window_get_cancel_button (_tmp3_);
	_tmp5_ = _tmp4_;
	g_signal_connect_object (_tmp5_, "clicked", (GCallback) _editing_tools_editing_tool_notify_cancel_gtk_button_clicked, (EditingToolsEditingTool*) self, 0);
	_tmp6_ = self->priv->crop_tool_window;
	_tmp7_ = editing_tools_crop_tool_crop_tool_window_get_constraint_combo (_tmp6_);
	_tmp8_ = _tmp7_;
	g_signal_connect_object (_tmp8_, "changed", (GCallback) _editing_tools_crop_tool_constraint_changed_gtk_combo_box_changed, self, 0);
	_tmp9_ = self->priv->crop_tool_window;
	_tmp10_ = editing_tools_crop_tool_crop_tool_window_get_pivot_reticle_button (_tmp9_);
	_tmp11_ = _tmp10_;
	g_signal_connect_object (_tmp11_, "clicked", (GCallback) _editing_tools_crop_tool_on_pivot_button_clicked_gtk_button_clicked, self, 0);
	_tmp12_ = self->priv->crop_tool_window;
	_tmp13_ = editing_tools_crop_tool_crop_tool_window_get_custom_width_entry (_tmp12_);
	_tmp14_ = _tmp13_;
	g_signal_connect_object ((GtkWidget*) _tmp14_, "focus-out-event", (GCallback) _editing_tools_crop_tool_on_custom_entry_focus_out_gtk_widget_focus_out_event, self, 0);
	_tmp15_ = self->priv->crop_tool_window;
	_tmp16_ = editing_tools_crop_tool_crop_tool_window_get_custom_height_entry (_tmp15_);
	_tmp17_ = _tmp16_;
	g_signal_connect_object ((GtkWidget*) _tmp17_, "focus-out-event", (GCallback) _editing_tools_crop_tool_on_custom_entry_focus_out_gtk_widget_focus_out_event, self, 0);
	_tmp18_ = self->priv->crop_tool_window;
	_tmp19_ = editing_tools_crop_tool_crop_tool_window_get_custom_width_entry (_tmp18_);
	_tmp20_ = _tmp19_;
	g_signal_connect_object ((GtkEditable*) _tmp20_, "insert-text", (GCallback) _editing_tools_crop_tool_on_width_insert_text_gtk_editable_insert_text, self, 0);
	_tmp21_ = self->priv->crop_tool_window;
	_tmp22_ = editing_tools_crop_tool_crop_tool_window_get_custom_height_entry (_tmp21_);
	_tmp23_ = _tmp22_;
	g_signal_connect_object ((GtkEditable*) _tmp23_, "insert-text", (GCallback) _editing_tools_crop_tool_on_height_insert_text_gtk_editable_insert_text, self, 0);
}

static void
editing_tools_crop_tool_unbind_window_handlers (EditingToolsCropTool* self)
{
	EditingToolsCropToolCropToolWindow* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	guint _tmp3_;
	EditingToolsCropToolCropToolWindow* _tmp4_;
	GtkButton* _tmp5_;
	GtkButton* _tmp6_;
	guint _tmp7_;
	EditingToolsCropToolCropToolWindow* _tmp8_;
	GtkComboBox* _tmp9_;
	GtkComboBox* _tmp10_;
	guint _tmp11_;
	EditingToolsCropToolCropToolWindow* _tmp12_;
	GtkButton* _tmp13_;
	GtkButton* _tmp14_;
	guint _tmp15_;
	EditingToolsCropToolCropToolWindow* _tmp16_;
	GtkEntry* _tmp17_;
	GtkEntry* _tmp18_;
	guint _tmp19_;
	EditingToolsCropToolCropToolWindow* _tmp20_;
	GtkEntry* _tmp21_;
	GtkEntry* _tmp22_;
	guint _tmp23_;
	EditingToolsCropToolCropToolWindow* _tmp24_;
	GtkEntry* _tmp25_;
	GtkEntry* _tmp26_;
	guint _tmp27_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->crop_tool_window;
	_tmp1_ = editing_tools_crop_tool_crop_tool_window_get_crop_button (_tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_parse_name ("clicked", gtk_button_get_type (), &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _editing_tools_crop_tool_on_crop_ok_gtk_button_clicked, self);
	_tmp4_ = self->priv->crop_tool_window;
	_tmp5_ = editing_tools_crop_tool_crop_tool_window_get_cancel_button (_tmp4_);
	_tmp6_ = _tmp5_;
	g_signal_parse_name ("clicked", gtk_button_get_type (), &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _editing_tools_editing_tool_notify_cancel_gtk_button_clicked, (EditingToolsEditingTool*) self);
	_tmp8_ = self->priv->crop_tool_window;
	_tmp9_ = editing_tools_crop_tool_crop_tool_window_get_constraint_combo (_tmp8_);
	_tmp10_ = _tmp9_;
	g_signal_parse_name ("changed", gtk_combo_box_get_type (), &_tmp11_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _editing_tools_crop_tool_constraint_changed_gtk_combo_box_changed, self);
	_tmp12_ = self->priv->crop_tool_window;
	_tmp13_ = editing_tools_crop_tool_crop_tool_window_get_pivot_reticle_button (_tmp12_);
	_tmp14_ = _tmp13_;
	g_signal_parse_name ("clicked", gtk_button_get_type (), &_tmp15_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp14_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp15_, 0, NULL, (GCallback) _editing_tools_crop_tool_on_pivot_button_clicked_gtk_button_clicked, self);
	_tmp16_ = self->priv->crop_tool_window;
	_tmp17_ = editing_tools_crop_tool_crop_tool_window_get_custom_width_entry (_tmp16_);
	_tmp18_ = _tmp17_;
	g_signal_parse_name ("focus-out-event", gtk_widget_get_type (), &_tmp19_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp18_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp19_, 0, NULL, (GCallback) _editing_tools_crop_tool_on_custom_entry_focus_out_gtk_widget_focus_out_event, self);
	_tmp20_ = self->priv->crop_tool_window;
	_tmp21_ = editing_tools_crop_tool_crop_tool_window_get_custom_height_entry (_tmp20_);
	_tmp22_ = _tmp21_;
	g_signal_parse_name ("focus-out-event", gtk_widget_get_type (), &_tmp23_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp22_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp23_, 0, NULL, (GCallback) _editing_tools_crop_tool_on_custom_entry_focus_out_gtk_widget_focus_out_event, self);
	_tmp24_ = self->priv->crop_tool_window;
	_tmp25_ = editing_tools_crop_tool_crop_tool_window_get_custom_width_entry (_tmp24_);
	_tmp26_ = _tmp25_;
	g_signal_parse_name ("insert-text", gtk_editable_get_type (), &_tmp27_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkEditable*) _tmp26_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp27_, 0, NULL, (GCallback) _editing_tools_crop_tool_on_width_insert_text_gtk_editable_insert_text, self);
}

static void
editing_tools_crop_tool_on_pivot_button_clicked (EditingToolsCropTool* self)
{
	EditingToolsCropToolConstraintDescription* _tmp0_;
	EditingToolsCropToolConstraintDescription* _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = editing_tools_crop_tool_get_selected_constraint (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = editing_tools_crop_tool_constraint_description_get_aspect_ratio (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ == EDITING_TOOLS_CROP_TOOL_CUSTOM_ASPECT_RATIO;
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		gchar* width_text = NULL;
		EditingToolsCropToolCropToolWindow* _tmp5_;
		GtkEntry* _tmp6_;
		GtkEntry* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* height_text = NULL;
		EditingToolsCropToolCropToolWindow* _tmp10_;
		GtkEntry* _tmp11_;
		GtkEntry* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		EditingToolsCropToolCropToolWindow* _tmp15_;
		GtkEntry* _tmp16_;
		GtkEntry* _tmp17_;
		const gchar* _tmp18_;
		EditingToolsCropToolCropToolWindow* _tmp19_;
		GtkEntry* _tmp20_;
		GtkEntry* _tmp21_;
		const gchar* _tmp22_;
		gint temp = 0;
		_tmp5_ = self->priv->crop_tool_window;
		_tmp6_ = editing_tools_crop_tool_crop_tool_window_get_custom_width_entry (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = gtk_entry_get_text (_tmp7_);
		_tmp9_ = g_strdup (_tmp8_);
		width_text = _tmp9_;
		_tmp10_ = self->priv->crop_tool_window;
		_tmp11_ = editing_tools_crop_tool_crop_tool_window_get_custom_height_entry (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = gtk_entry_get_text (_tmp12_);
		_tmp14_ = g_strdup (_tmp13_);
		height_text = _tmp14_;
		_tmp15_ = self->priv->crop_tool_window;
		_tmp16_ = editing_tools_crop_tool_crop_tool_window_get_custom_width_entry (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = height_text;
		gtk_entry_set_text (_tmp17_, _tmp18_);
		_tmp19_ = self->priv->crop_tool_window;
		_tmp20_ = editing_tools_crop_tool_crop_tool_window_get_custom_height_entry (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = width_text;
		gtk_entry_set_text (_tmp21_, _tmp22_);
		temp = self->priv->custom_width;
		self->priv->custom_width = self->priv->custom_height;
		self->priv->custom_height = temp;
		_g_free0 (height_text);
		_g_free0 (width_text);
	}
	self->priv->reticle_orientation = editing_tools_crop_tool_reticle_orientation_toggle (self->priv->reticle_orientation);
	editing_tools_crop_tool_constraint_changed (self);
}

static void
editing_tools_crop_tool_real_deactivate (EditingToolsEditingTool* base)
{
	EditingToolsCropTool * self;
	EditingToolsPhotoCanvas* _tmp0_;
	EditingToolsCropToolCropToolWindow* _tmp2_;
	EditingToolsPhotoCanvas* _tmp5_;
	self = (EditingToolsCropTool*) base;
	_tmp0_ = ((EditingToolsEditingTool*) self)->canvas;
	if (_tmp0_ != NULL) {
		EditingToolsPhotoCanvas* _tmp1_;
		_tmp1_ = ((EditingToolsEditingTool*) self)->canvas;
		editing_tools_crop_tool_unbind_canvas_handlers (self, _tmp1_);
	}
	_tmp2_ = self->priv->crop_tool_window;
	if (_tmp2_ != NULL) {
		EditingToolsCropToolCropToolWindow* _tmp3_;
		EditingToolsCropToolCropToolWindow* _tmp4_;
		editing_tools_crop_tool_unbind_window_handlers (self);
		_tmp3_ = self->priv->crop_tool_window;
		gtk_widget_hide ((GtkWidget*) _tmp3_);
		_tmp4_ = self->priv->crop_tool_window;
		gtk_widget_destroy ((GtkWidget*) _tmp4_);
		_g_object_unref0 (self->priv->crop_tool_window);
		self->priv->crop_tool_window = NULL;
	}
	_tmp5_ = ((EditingToolsEditingTool*) self)->canvas;
	if (_tmp5_ != NULL) {
		EditingToolsPhotoCanvas* _tmp6_;
		GdkWindow* _tmp7_;
		GdkWindow* _tmp8_;
		GdkDisplay* _tmp9_;
		GdkCursor* _tmp10_;
		GdkCursor* _tmp11_;
		_tmp6_ = ((EditingToolsEditingTool*) self)->canvas;
		_tmp7_ = editing_tools_photo_canvas_get_drawing_window (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = gdk_display_get_default ();
		_tmp10_ = gdk_cursor_new_for_display (_tmp9_, GDK_LEFT_PTR);
		_tmp11_ = _tmp10_;
		gdk_window_set_cursor (_tmp8_, _tmp11_);
		_g_object_unref0 (_tmp11_);
	}
	_cairo_surface_destroy0 (self->priv->crop_surface);
	self->priv->crop_surface = NULL;
	EDITING_TOOLS_EDITING_TOOL_CLASS (editing_tools_crop_tool_parent_class)->deactivate (G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool));
}

static EditingToolsEditingToolWindow*
editing_tools_crop_tool_real_get_tool_window (EditingToolsEditingTool* base)
{
	EditingToolsCropTool * self;
	EditingToolsCropToolCropToolWindow* _tmp0_;
	EditingToolsEditingToolWindow* _tmp1_;
	EditingToolsEditingToolWindow* result;
	self = (EditingToolsCropTool*) base;
	_tmp0_ = self->priv->crop_tool_window;
	_tmp1_ = _g_object_ref0 ((EditingToolsEditingToolWindow*) _tmp0_);
	result = _tmp1_;
	return result;
}

static GdkPixbuf*
editing_tools_crop_tool_real_get_display_pixbuf (EditingToolsEditingTool* base,
                                                 Scaling* scaling,
                                                 Photo* photo,
                                                 Dimensions* max_dim,
                                                 GError** error)
{
	EditingToolsCropTool * self;
	Dimensions _vala_max_dim = {0};
	Dimensions _tmp0_ = {0};
	GdkPixbuf* _tmp1_ = NULL;
	Scaling _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = (EditingToolsCropTool*) base;
	g_return_val_if_fail (scaling != NULL, NULL);
	g_return_val_if_fail (photo != NULL, NULL);
	media_source_get_dimensions ((MediaSource*) photo, PHOTO_EXCEPTION_CROP, &_tmp0_);
	_vala_max_dim = _tmp0_;
	_tmp2_ = *scaling;
	_tmp3_ = photo_get_pixbuf_with_options (photo, &_tmp2_, PHOTO_EXCEPTION_CROP, BACKING_FETCH_MODE_BASELINE, &_inner_error0_);
	_tmp1_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp4_ = _tmp1_;
	_tmp1_ = NULL;
	result = _tmp4_;
	_g_object_unref0 (_tmp1_);
	if (max_dim) {
		*max_dim = _vala_max_dim;
	}
	return result;
}

static void
editing_tools_crop_tool_prepare_ctx (EditingToolsCropTool* self,
                                     cairo_t* ctx,
                                     Dimensions* dim)
{
	cairo_surface_t* _tmp0_;
	cairo_t* _tmp1_;
	cairo_t* _tmp2_;
	cairo_t* _tmp3_;
	cairo_surface_t* _tmp4_;
	cairo_t* _tmp5_;
	cairo_t* _tmp6_;
	cairo_t* _tmp7_;
	cairo_surface_t* _tmp8_;
	cairo_t* _tmp9_;
	cairo_t* _tmp10_;
	cairo_t* _tmp11_;
	cairo_surface_t* _tmp12_;
	cairo_t* _tmp13_;
	cairo_t* _tmp14_;
	cairo_t* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (dim != NULL);
	_tmp0_ = cairo_get_target (ctx);
	_tmp1_ = cairo_create (_tmp0_);
	_cairo_destroy0 (self->priv->wide_black_ctx);
	self->priv->wide_black_ctx = _tmp1_;
	_tmp2_ = self->priv->wide_black_ctx;
	set_source_color_from_string (_tmp2_, "#000");
	_tmp3_ = self->priv->wide_black_ctx;
	cairo_set_line_width (_tmp3_, (gdouble) (1 * self->priv->scale_factor));
	_tmp4_ = cairo_get_target (ctx);
	_tmp5_ = cairo_create (_tmp4_);
	_cairo_destroy0 (self->priv->wide_white_ctx);
	self->priv->wide_white_ctx = _tmp5_;
	_tmp6_ = self->priv->wide_white_ctx;
	set_source_color_from_string (_tmp6_, "#FFF");
	_tmp7_ = self->priv->wide_white_ctx;
	cairo_set_line_width (_tmp7_, (gdouble) (1 * self->priv->scale_factor));
	_tmp8_ = cairo_get_target (ctx);
	_tmp9_ = cairo_create (_tmp8_);
	_cairo_destroy0 (self->priv->thin_white_ctx);
	self->priv->thin_white_ctx = _tmp9_;
	_tmp10_ = self->priv->thin_white_ctx;
	set_source_color_from_string (_tmp10_, "#FFF");
	_tmp11_ = self->priv->thin_white_ctx;
	cairo_set_line_width (_tmp11_, 0.5 * self->priv->scale_factor);
	_tmp12_ = cairo_get_target (ctx);
	_tmp13_ = cairo_create (_tmp12_);
	_cairo_destroy0 (self->priv->text_ctx);
	self->priv->text_ctx = _tmp13_;
	_tmp14_ = self->priv->text_ctx;
	cairo_select_font_face (_tmp14_, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_NORMAL);
	_tmp15_ = self->priv->text_ctx;
	cairo_set_font_size (_tmp15_, 10.0 * self->priv->scale_factor);
}

static void
editing_tools_crop_tool_on_resized_pixbuf (EditingToolsCropTool* self,
                                           Dimensions* old_dim,
                                           GdkPixbuf* scaled,
                                           GdkRectangle* scaled_position)
{
	Dimensions new_dim = {0};
	Dimensions _tmp0_ = {0};
	Dimensions uncropped_dim = {0};
	EditingToolsPhotoCanvas* _tmp1_;
	Photo* _tmp2_;
	Photo* _tmp3_;
	Dimensions _tmp4_ = {0};
	Box crop = {0};
	Dimensions _tmp5_;
	Dimensions _tmp6_;
	Box _tmp7_ = {0};
	Dimensions _tmp8_;
	Dimensions _tmp9_;
	Box _tmp10_ = {0};
	cairo_surface_t* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	cairo_surface_t* _tmp16_;
	cairo_t* ctx = NULL;
	cairo_surface_t* _tmp17_;
	cairo_t* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_dim != NULL);
	g_return_if_fail (scaled != NULL);
	g_return_if_fail (scaled_position != NULL);
	dimensions_for_pixbuf (scaled, &_tmp0_);
	new_dim = _tmp0_;
	_tmp1_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp2_ = editing_tools_photo_canvas_get_photo (_tmp1_);
	_tmp3_ = _tmp2_;
	media_source_get_dimensions ((MediaSource*) _tmp3_, PHOTO_EXCEPTION_CROP, &_tmp4_);
	uncropped_dim = _tmp4_;
	_tmp5_ = *old_dim;
	_tmp6_ = uncropped_dim;
	box_get_scaled_similar (&self->priv->scaled_crop, &_tmp5_, &_tmp6_, &_tmp7_);
	crop = _tmp7_;
	_tmp8_ = uncropped_dim;
	_tmp9_ = new_dim;
	box_get_scaled_similar (&crop, &_tmp8_, &_tmp9_, &_tmp10_);
	self->priv->scaled_crop = _tmp10_;
	_tmp11_ = self->priv->crop_surface;
	if (_tmp11_ != NULL) {
		_cairo_surface_destroy0 (self->priv->crop_surface);
		self->priv->crop_surface = NULL;
	}
	_tmp12_ = gdk_pixbuf_get_width (scaled);
	_tmp13_ = _tmp12_;
	_tmp14_ = gdk_pixbuf_get_height (scaled);
	_tmp15_ = _tmp14_;
	_tmp16_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _tmp13_, _tmp15_);
	_cairo_surface_destroy0 (self->priv->crop_surface);
	self->priv->crop_surface = _tmp16_;
	_tmp17_ = self->priv->crop_surface;
	_tmp18_ = cairo_create (_tmp17_);
	ctx = _tmp18_;
	cairo_set_source_rgba (ctx, 0.0, 0.0, 0.0, 1.0);
	cairo_paint (ctx);
	_cairo_destroy0 (ctx);
}

static void
editing_tools_crop_tool_real_on_left_click (EditingToolsEditingTool* base,
                                            gint x,
                                            gint y)
{
	EditingToolsCropTool * self;
	GdkRectangle scaled_pixbuf_pos = {0};
	EditingToolsPhotoCanvas* _tmp0_;
	GdkRectangle _tmp1_ = {0};
	GdkRectangle _tmp2_;
	Box offset_scaled_crop = {0};
	GdkRectangle _tmp3_;
	GdkRectangle _tmp4_;
	Box _tmp5_ = {0};
	GdkRectangle _tmp6_;
	GdkRectangle _tmp7_;
	EditingToolsPhotoCanvas* _tmp8_;
	self = (EditingToolsCropTool*) base;
	x = x * self->priv->scale_factor;
	y = y * self->priv->scale_factor;
	_tmp0_ = ((EditingToolsEditingTool*) self)->canvas;
	editing_tools_photo_canvas_get_scaled_position (_tmp0_, &_tmp1_);
	_tmp2_ = _tmp1_;
	scaled_pixbuf_pos = _tmp2_;
	_tmp3_ = scaled_pixbuf_pos;
	_tmp4_ = scaled_pixbuf_pos;
	box_get_offset (&self->priv->scaled_crop, _tmp3_.x, _tmp4_.y, &_tmp5_);
	offset_scaled_crop = _tmp5_;
	self->priv->in_manipulation = box_approx_location (&offset_scaled_crop, x, y);
	_tmp6_ = scaled_pixbuf_pos;
	x = x - _tmp6_.x;
	self->priv->last_grab_x = x;
	_tmp7_ = scaled_pixbuf_pos;
	y = y - _tmp7_.y;
	self->priv->last_grab_y = y;
	_tmp8_ = ((EditingToolsEditingTool*) self)->canvas;
	editing_tools_photo_canvas_repaint (_tmp8_);
}

static void
editing_tools_crop_tool_real_on_left_released (EditingToolsEditingTool* base,
                                               gint x,
                                               gint y)
{
	EditingToolsCropTool * self;
	EditingToolsPhotoCanvas* _tmp0_;
	self = (EditingToolsCropTool*) base;
	x = x * self->priv->scale_factor;
	y = y * self->priv->scale_factor;
	if (self->priv->in_manipulation == BOX_LOCATION_OUTSIDE) {
		return;
	}
	self->priv->in_manipulation = BOX_LOCATION_OUTSIDE;
	self->priv->last_grab_x = -1;
	self->priv->last_grab_y = -1;
	editing_tools_crop_tool_update_cursor (self, x, y);
	_tmp0_ = ((EditingToolsEditingTool*) self)->canvas;
	editing_tools_photo_canvas_repaint (_tmp0_);
}

static void
editing_tools_crop_tool_real_on_motion (EditingToolsEditingTool* base,
                                        gint x,
                                        gint y,
                                        GdkModifierType mask)
{
	EditingToolsCropTool * self;
	EditingToolsPhotoCanvas* _tmp0_;
	self = (EditingToolsCropTool*) base;
	x = x * self->priv->scale_factor;
	y = y * self->priv->scale_factor;
	if (self->priv->in_manipulation != BOX_LOCATION_OUTSIDE) {
		editing_tools_crop_tool_on_canvas_manipulation (self, x, y);
	}
	editing_tools_crop_tool_update_cursor (self, x, y);
	_tmp0_ = ((EditingToolsEditingTool*) self)->canvas;
	editing_tools_photo_canvas_repaint (_tmp0_);
}

static void
editing_tools_crop_tool_real_paint (EditingToolsEditingTool* base,
                                    cairo_t* default_ctx)
{
	EditingToolsCropTool * self;
	gint w = 0;
	EditingToolsPhotoCanvas* _tmp0_;
	GdkWindow* _tmp1_;
	GdkWindow* _tmp2_;
	gint h = 0;
	EditingToolsPhotoCanvas* _tmp3_;
	GdkWindow* _tmp4_;
	GdkWindow* _tmp5_;
	EditingToolsPhotoCanvas* _tmp6_;
	GtkStyleContext* _tmp7_;
	cairo_t* ctx = NULL;
	cairo_surface_t* _tmp8_;
	cairo_t* _tmp9_;
	Box _tmp10_;
	Box _tmp11_;
	EditingToolsPhotoCanvas* _tmp12_;
	cairo_surface_t* _tmp13_;
	Box _tmp14_;
	self = (EditingToolsCropTool*) base;
	g_return_if_fail (default_ctx != NULL);
	_tmp0_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp1_ = editing_tools_photo_canvas_get_drawing_window (_tmp0_);
	_tmp2_ = _tmp1_;
	w = gdk_window_get_width (_tmp2_) * self->priv->scale_factor;
	_tmp3_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp4_ = editing_tools_photo_canvas_get_drawing_window (_tmp3_);
	_tmp5_ = _tmp4_;
	h = gdk_window_get_height (_tmp5_) * self->priv->scale_factor;
	_tmp6_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp7_ = editing_tools_photo_canvas_get_style_context (_tmp6_);
	gtk_render_background (_tmp7_, default_ctx, (gdouble) 0, (gdouble) 0, (gdouble) w, (gdouble) h);
	_tmp8_ = self->priv->crop_surface;
	_tmp9_ = cairo_create (_tmp8_);
	ctx = _tmp9_;
	cairo_set_operator (ctx, CAIRO_OPERATOR_SOURCE);
	cairo_set_source_rgba (ctx, 0.0, 0.0, 0.0, 0.5);
	cairo_paint (ctx);
	cairo_set_source_rgba (ctx, 0.0, 0.0, 0.0, 0.0);
	_tmp10_ = self->priv->scaled_crop;
	_tmp11_ = self->priv->scaled_crop;
	cairo_rectangle (ctx, (gdouble) _tmp10_.left, (gdouble) _tmp11_.top, (gdouble) box_get_width (&self->priv->scaled_crop), (gdouble) box_get_height (&self->priv->scaled_crop));
	cairo_fill (ctx);
	_tmp12_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp13_ = self->priv->crop_surface;
	editing_tools_photo_canvas_paint_surface (_tmp12_, _tmp13_, TRUE);
	_tmp14_ = self->priv->scaled_crop;
	editing_tools_crop_tool_paint_crop_tool (self, &_tmp14_);
	_cairo_destroy0 (ctx);
}

static void
editing_tools_crop_tool_on_crop_ok (EditingToolsCropTool* self)
{
	GSettings* _tmp0_;
	EditingToolsCropToolCropToolWindow* _tmp1_;
	GtkComboBox* _tmp2_;
	GtkComboBox* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	Box crop = {0};
	EditingToolsPhotoCanvas* _tmp6_;
	GdkRectangle _tmp7_ = {0};
	GdkRectangle _tmp8_;
	Dimensions _tmp9_ = {0};
	EditingToolsPhotoCanvas* _tmp10_;
	Photo* _tmp11_;
	Photo* _tmp12_;
	Dimensions _tmp13_ = {0};
	Box _tmp14_ = {0};
	GdkPixbuf* cropped = NULL;
	EditingToolsPhotoCanvas* _tmp15_;
	GdkPixbuf* _tmp16_;
	GdkPixbuf* _tmp17_;
	Box _tmp18_;
	Box _tmp19_;
	GdkPixbuf* _tmp20_;
	EditingToolsPhotoCanvas* _tmp21_;
	Photo* _tmp22_;
	Photo* _tmp23_;
	Box _tmp24_;
	CropCommand* _tmp25_;
	CropCommand* _tmp26_;
	Dimensions _tmp27_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->crop_settings;
	_tmp1_ = self->priv->crop_tool_window;
	_tmp2_ = editing_tools_crop_tool_crop_tool_window_get_constraint_combo (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_int (_tmp0_, "last-crop-menu-choice", gtk_combo_box_get_active (_tmp3_));
	_tmp4_ = self->priv->crop_settings;
	g_settings_set_int (_tmp4_, "last-crop-width", self->priv->custom_width);
	_tmp5_ = self->priv->crop_settings;
	g_settings_set_int (_tmp5_, "last-crop-height", self->priv->custom_height);
	_tmp6_ = ((EditingToolsEditingTool*) self)->canvas;
	editing_tools_photo_canvas_get_scaled_position (_tmp6_, &_tmp7_);
	_tmp8_ = _tmp7_;
	dimensions_for_rectangle (&_tmp8_, &_tmp9_);
	_tmp10_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp11_ = editing_tools_photo_canvas_get_photo (_tmp10_);
	_tmp12_ = _tmp11_;
	media_source_get_dimensions ((MediaSource*) _tmp12_, PHOTO_EXCEPTION_CROP, &_tmp13_);
	box_get_scaled_similar (&self->priv->scaled_crop, &_tmp9_, &_tmp13_, &_tmp14_);
	crop = _tmp14_;
	_tmp15_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp16_ = editing_tools_photo_canvas_get_scaled_pixbuf (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = self->priv->scaled_crop;
	_tmp19_ = self->priv->scaled_crop;
	_tmp20_ = gdk_pixbuf_new_subpixbuf (_tmp17_, _tmp18_.left, _tmp19_.top, box_get_width (&self->priv->scaled_crop), box_get_height (&self->priv->scaled_crop));
	cropped = _tmp20_;
	_tmp21_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp22_ = editing_tools_photo_canvas_get_photo (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = crop;
	_tmp25_ = crop_command_new (_tmp23_, &_tmp24_, RESOURCES_CROP_LABEL, RESOURCES_CROP_TOOLTIP);
	_tmp26_ = _tmp25_;
	box_get_dimensions (&crop, &_tmp27_);
	g_signal_emit_by_name ((EditingToolsEditingTool*) self, "applied", (Command*) _tmp26_, cropped, &_tmp27_, TRUE);
	_g_object_unref0 (_tmp26_);
	_g_object_unref0 (cropped);
}

static void
editing_tools_crop_tool_update_cursor (EditingToolsCropTool* self,
                                       gint x,
                                       gint y)
{
	GdkRectangle scaled_pos = {0};
	EditingToolsPhotoCanvas* _tmp0_;
	GdkRectangle _tmp1_ = {0};
	GdkRectangle _tmp2_;
	Box offset_scaled_crop = {0};
	GdkRectangle _tmp3_;
	GdkRectangle _tmp4_;
	Box _tmp5_ = {0};
	GdkCursorType cursor_type = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((EditingToolsEditingTool*) self)->canvas;
	editing_tools_photo_canvas_get_scaled_position (_tmp0_, &_tmp1_);
	_tmp2_ = _tmp1_;
	scaled_pos = _tmp2_;
	_tmp3_ = scaled_pos;
	_tmp4_ = scaled_pos;
	box_get_offset (&self->priv->scaled_crop, _tmp3_.x, _tmp4_.y, &_tmp5_);
	offset_scaled_crop = _tmp5_;
	cursor_type = GDK_LEFT_PTR;
	switch (box_approx_location (&offset_scaled_crop, x, y)) {
		case BOX_LOCATION_LEFT_SIDE:
		{
			cursor_type = GDK_LEFT_SIDE;
			break;
		}
		case BOX_LOCATION_TOP_SIDE:
		{
			cursor_type = GDK_TOP_SIDE;
			break;
		}
		case BOX_LOCATION_RIGHT_SIDE:
		{
			cursor_type = GDK_RIGHT_SIDE;
			break;
		}
		case BOX_LOCATION_BOTTOM_SIDE:
		{
			cursor_type = GDK_BOTTOM_SIDE;
			break;
		}
		case BOX_LOCATION_TOP_LEFT:
		{
			cursor_type = GDK_TOP_LEFT_CORNER;
			break;
		}
		case BOX_LOCATION_BOTTOM_LEFT:
		{
			cursor_type = GDK_BOTTOM_LEFT_CORNER;
			break;
		}
		case BOX_LOCATION_TOP_RIGHT:
		{
			cursor_type = GDK_TOP_RIGHT_CORNER;
			break;
		}
		case BOX_LOCATION_BOTTOM_RIGHT:
		{
			cursor_type = GDK_BOTTOM_RIGHT_CORNER;
			break;
		}
		case BOX_LOCATION_INSIDE:
		{
			cursor_type = GDK_FLEUR;
			break;
		}
		default:
		{
			break;
		}
	}
	if (cursor_type != self->priv->current_cursor_type) {
		GdkCursor* cursor = NULL;
		GdkDisplay* _tmp6_;
		GdkCursor* _tmp7_;
		EditingToolsPhotoCanvas* _tmp8_;
		GdkWindow* _tmp9_;
		GdkWindow* _tmp10_;
		GdkCursor* _tmp11_;
		_tmp6_ = gdk_display_get_default ();
		_tmp7_ = gdk_cursor_new_for_display (_tmp6_, cursor_type);
		cursor = _tmp7_;
		_tmp8_ = ((EditingToolsEditingTool*) self)->canvas;
		_tmp9_ = editing_tools_photo_canvas_get_drawing_window (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = cursor;
		gdk_window_set_cursor (_tmp10_, _tmp11_);
		self->priv->current_cursor_type = cursor_type;
		_g_object_unref0 (cursor);
	}
}

static gint
editing_tools_crop_tool_eval_radial_line (EditingToolsCropTool* self,
                                          gdouble center_x,
                                          gdouble center_y,
                                          gdouble bounds_x,
                                          gdouble bounds_y,
                                          gdouble user_x)
{
	gdouble decision_slope = 0.0;
	gdouble decision_intercept = 0.0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	decision_slope = (bounds_y - center_y) / (bounds_x - center_x);
	decision_intercept = bounds_y - (decision_slope * bounds_x);
	result = (gint) ((decision_slope * user_x) + decision_intercept);
	return result;
}

static void
editing_tools_crop_tool_get_photo_dimensions (EditingToolsCropTool* self,
                                              Dimensions* result)
{
	Dimensions photo_dims = {0};
	EditingToolsPhotoCanvas* _tmp0_;
	Photo* _tmp1_;
	Photo* _tmp2_;
	Dimensions _tmp3_ = {0};
	Dimensions surface_dims = {0};
	EditingToolsPhotoCanvas* _tmp4_;
	Dimensions _tmp5_ = {0};
	Dimensions _tmp6_;
	gdouble scale_factor = 0.0;
	Dimensions _tmp7_;
	Dimensions _tmp8_;
	Dimensions _tmp9_;
	Dimensions _tmp10_;
	EditingToolsPhotoCanvas* _tmp11_;
	Photo* _tmp12_;
	Photo* _tmp13_;
	Dimensions _tmp14_ = {0};
	Dimensions _tmp15_;
	Dimensions _tmp16_;
	Dimensions _tmp17_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp1_ = editing_tools_photo_canvas_get_photo (_tmp0_);
	_tmp2_ = _tmp1_;
	media_source_get_dimensions ((MediaSource*) _tmp2_, PHOTO_EXCEPTION_CROP, &_tmp3_);
	photo_dims = _tmp3_;
	_tmp4_ = ((EditingToolsEditingTool*) self)->canvas;
	editing_tools_photo_canvas_get_surface_dim (_tmp4_, &_tmp5_);
	_tmp6_ = _tmp5_;
	surface_dims = _tmp6_;
	_tmp7_ = surface_dims;
	_tmp8_ = photo_dims;
	_tmp9_ = surface_dims;
	_tmp10_ = photo_dims;
	scale_factor = MIN (((gdouble) _tmp7_.width) / _tmp8_.width, ((gdouble) _tmp9_.height) / _tmp10_.height);
	scale_factor = MIN (scale_factor, 1.0);
	_tmp11_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp12_ = editing_tools_photo_canvas_get_photo (_tmp11_);
	_tmp13_ = _tmp12_;
	media_source_get_dimensions ((MediaSource*) _tmp13_, PHOTO_EXCEPTION_CROP | PHOTO_EXCEPTION_STRAIGHTEN, &_tmp14_);
	photo_dims = _tmp14_;
	_tmp15_ = photo_dims;
	_tmp16_ = photo_dims;
	_tmp17_.width = (gint) (_tmp15_.width * scale_factor);
	_tmp17_.height = (gint) (_tmp16_.height * scale_factor);
	*result = _tmp17_;
	return;
}

static gboolean
_box_equal (const Box * s1,
            const Box * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->left != s2->left) {
		return FALSE;
	}
	if (s1->top != s2->top) {
		return FALSE;
	}
	if (s1->right != s2->right) {
		return FALSE;
	}
	if (s1->bottom != s2->bottom) {
		return FALSE;
	}
	return TRUE;
}

static gboolean
editing_tools_crop_tool_on_canvas_manipulation (EditingToolsCropTool* self,
                                                gint x,
                                                gint y)
{
	GdkRectangle scaled_pos = {0};
	EditingToolsPhotoCanvas* _tmp0_;
	GdkRectangle _tmp1_ = {0};
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	GdkRectangle _tmp6_;
	gint left = 0;
	Box _tmp9_;
	gint top = 0;
	Box _tmp10_;
	gint right = 0;
	Box _tmp11_;
	gint bottom = 0;
	Box _tmp12_;
	gint center_x = 0;
	gint center_y = 0;
	gint width = 0;
	gint height = 0;
	Dimensions photo_dims = {0};
	Dimensions _tmp17_ = {0};
	gdouble angle = 0.0;
	EditingToolsPhotoCanvas* _tmp18_;
	Photo* _tmp19_;
	Photo* _tmp20_;
	gdouble _tmp21_ = 0.0;
	Box new_crop = {0};
	Box _tmp37_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = ((EditingToolsEditingTool*) self)->canvas;
	editing_tools_photo_canvas_get_scaled_position (_tmp0_, &_tmp1_);
	_tmp2_ = _tmp1_;
	scaled_pos = _tmp2_;
	_tmp3_ = scaled_pos;
	x = x - _tmp3_.x;
	if (x < 0) {
		x = 0;
	} else {
		GdkRectangle _tmp4_;
		_tmp4_ = scaled_pos;
		if (x >= _tmp4_.width) {
			GdkRectangle _tmp5_;
			_tmp5_ = scaled_pos;
			x = _tmp5_.width - 1;
		}
	}
	_tmp6_ = scaled_pos;
	y = y - _tmp6_.y;
	if (y < 0) {
		y = 0;
	} else {
		GdkRectangle _tmp7_;
		_tmp7_ = scaled_pos;
		if (y >= _tmp7_.height) {
			GdkRectangle _tmp8_;
			_tmp8_ = scaled_pos;
			y = _tmp8_.height - 1;
		}
	}
	_tmp9_ = self->priv->scaled_crop;
	left = _tmp9_.left;
	_tmp10_ = self->priv->scaled_crop;
	top = _tmp10_.top;
	_tmp11_ = self->priv->scaled_crop;
	right = _tmp11_.right;
	_tmp12_ = self->priv->scaled_crop;
	bottom = _tmp12_.bottom;
	center_x = (left + right) / 2;
	center_y = (top + bottom) / 2;
	switch (self->priv->in_manipulation) {
		case BOX_LOCATION_LEFT_SIDE:
		{
			left = x;
			if (editing_tools_crop_tool_get_constraint_aspect_ratio (self) != EDITING_TOOLS_CROP_TOOL_ANY_ASPECT_RATIO) {
				gfloat new_height = 0.0F;
				new_height = ((gfloat) (right - left)) / editing_tools_crop_tool_get_constraint_aspect_ratio (self);
				bottom = top + ((gint) new_height);
			}
			break;
		}
		case BOX_LOCATION_TOP_SIDE:
		{
			top = y;
			if (editing_tools_crop_tool_get_constraint_aspect_ratio (self) != EDITING_TOOLS_CROP_TOOL_ANY_ASPECT_RATIO) {
				gfloat new_width = 0.0F;
				new_width = ((gfloat) (bottom - top)) * editing_tools_crop_tool_get_constraint_aspect_ratio (self);
				right = left + ((gint) new_width);
			}
			break;
		}
		case BOX_LOCATION_RIGHT_SIDE:
		{
			right = x;
			if (editing_tools_crop_tool_get_constraint_aspect_ratio (self) != EDITING_TOOLS_CROP_TOOL_ANY_ASPECT_RATIO) {
				gfloat new_height = 0.0F;
				new_height = ((gfloat) (right - left)) / editing_tools_crop_tool_get_constraint_aspect_ratio (self);
				bottom = top + ((gint) new_height);
			}
			break;
		}
		case BOX_LOCATION_BOTTOM_SIDE:
		{
			bottom = y;
			if (editing_tools_crop_tool_get_constraint_aspect_ratio (self) != EDITING_TOOLS_CROP_TOOL_ANY_ASPECT_RATIO) {
				gfloat new_width = 0.0F;
				new_width = ((gfloat) (bottom - top)) * editing_tools_crop_tool_get_constraint_aspect_ratio (self);
				right = left + ((gint) new_width);
			}
			break;
		}
		case BOX_LOCATION_TOP_LEFT:
		{
			if (editing_tools_crop_tool_get_constraint_aspect_ratio (self) == EDITING_TOOLS_CROP_TOOL_ANY_ASPECT_RATIO) {
				top = y;
				left = x;
			} else {
				if (y < editing_tools_crop_tool_eval_radial_line (self, (gdouble) center_x, (gdouble) center_y, (gdouble) left, (gdouble) top, (gdouble) x)) {
					gfloat new_width = 0.0F;
					top = y;
					new_width = ((gfloat) (bottom - top)) * editing_tools_crop_tool_get_constraint_aspect_ratio (self);
					left = right - ((gint) new_width);
				} else {
					gfloat new_height = 0.0F;
					left = x;
					new_height = ((gfloat) (right - left)) / editing_tools_crop_tool_get_constraint_aspect_ratio (self);
					top = bottom - ((gint) new_height);
				}
			}
			break;
		}
		case BOX_LOCATION_BOTTOM_LEFT:
		{
			if (editing_tools_crop_tool_get_constraint_aspect_ratio (self) == EDITING_TOOLS_CROP_TOOL_ANY_ASPECT_RATIO) {
				bottom = y;
				left = x;
			} else {
				if (y < editing_tools_crop_tool_eval_radial_line (self, (gdouble) center_x, (gdouble) center_y, (gdouble) left, (gdouble) bottom, (gdouble) x)) {
					gfloat new_height = 0.0F;
					left = x;
					new_height = ((gfloat) (right - left)) / editing_tools_crop_tool_get_constraint_aspect_ratio (self);
					bottom = top + ((gint) new_height);
				} else {
					gfloat new_width = 0.0F;
					bottom = y;
					new_width = ((gfloat) (bottom - top)) * editing_tools_crop_tool_get_constraint_aspect_ratio (self);
					left = right - ((gint) new_width);
				}
			}
			break;
		}
		case BOX_LOCATION_TOP_RIGHT:
		{
			if (editing_tools_crop_tool_get_constraint_aspect_ratio (self) == EDITING_TOOLS_CROP_TOOL_ANY_ASPECT_RATIO) {
				top = y;
				right = x;
			} else {
				if (y < editing_tools_crop_tool_eval_radial_line (self, (gdouble) center_x, (gdouble) center_y, (gdouble) right, (gdouble) top, (gdouble) x)) {
					gfloat new_width = 0.0F;
					top = y;
					new_width = ((gfloat) (bottom - top)) * editing_tools_crop_tool_get_constraint_aspect_ratio (self);
					right = left + ((gint) new_width);
				} else {
					gfloat new_height = 0.0F;
					right = x;
					new_height = ((gfloat) (right - left)) / editing_tools_crop_tool_get_constraint_aspect_ratio (self);
					top = bottom - ((gint) new_height);
				}
			}
			break;
		}
		case BOX_LOCATION_BOTTOM_RIGHT:
		{
			if (editing_tools_crop_tool_get_constraint_aspect_ratio (self) == EDITING_TOOLS_CROP_TOOL_ANY_ASPECT_RATIO) {
				bottom = y;
				right = x;
			} else {
				if (y < editing_tools_crop_tool_eval_radial_line (self, (gdouble) center_x, (gdouble) center_y, (gdouble) right, (gdouble) bottom, (gdouble) x)) {
					gfloat new_height = 0.0F;
					right = x;
					new_height = ((gfloat) (right - left)) / editing_tools_crop_tool_get_constraint_aspect_ratio (self);
					bottom = top + ((gint) new_height);
				} else {
					gfloat new_width = 0.0F;
					bottom = y;
					new_width = ((gfloat) (bottom - top)) * editing_tools_crop_tool_get_constraint_aspect_ratio (self);
					right = left + ((gint) new_width);
				}
			}
			break;
		}
		case BOX_LOCATION_INSIDE:
		{
			gint delta_x = 0;
			gint delta_y = 0;
			gint width = 0;
			gint height = 0;
			GdkRectangle _tmp13_;
			GdkRectangle _tmp15_;
			gint adj_width = 0;
			gint adj_height = 0;
			_vala_assert (self->priv->last_grab_x >= 0, "last_grab_x >= 0");
			_vala_assert (self->priv->last_grab_y >= 0, "last_grab_y >= 0");
			delta_x = x - self->priv->last_grab_x;
			delta_y = y - self->priv->last_grab_y;
			self->priv->last_grab_x = x;
			self->priv->last_grab_y = y;
			width = (right - left) + 1;
			height = (bottom - top) + 1;
			left += delta_x;
			top += delta_y;
			right += delta_x;
			bottom += delta_y;
			if (left < 0) {
				left = 0;
			}
			if (top < 0) {
				top = 0;
			}
			_tmp13_ = scaled_pos;
			if (right >= _tmp13_.width) {
				GdkRectangle _tmp14_;
				_tmp14_ = scaled_pos;
				right = _tmp14_.width - 1;
			}
			_tmp15_ = scaled_pos;
			if (bottom >= _tmp15_.height) {
				GdkRectangle _tmp16_;
				_tmp16_ = scaled_pos;
				bottom = _tmp16_.height - 1;
			}
			adj_width = (right - left) + 1;
			adj_height = (bottom - top) + 1;
			if (adj_width != width) {
				if (delta_x < 0) {
					right = (left + width) - 1;
				} else {
					left = (right - width) + 1;
				}
			}
			if (adj_height != height) {
				if (delta_y < 0) {
					bottom = (top + height) - 1;
				} else {
					top = (bottom - height) + 1;
				}
			}
			break;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
	width = (right - left) + 1;
	height = (bottom - top) + 1;
	editing_tools_crop_tool_get_photo_dimensions (self, &_tmp17_);
	photo_dims = _tmp17_;
	_tmp18_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp19_ = editing_tools_photo_canvas_get_photo (_tmp18_);
	_tmp20_ = _tmp19_;
	photo_get_straighten (_tmp20_, &_tmp21_);
	angle = _tmp21_;
	if (editing_tools_crop_tool_get_constraint_aspect_ratio (self) == EDITING_TOOLS_CROP_TOOL_ANY_ASPECT_RATIO) {
		Box _tmp22_ = {0};
		Dimensions _tmp23_;
		Dimensions _tmp24_;
		Box _tmp25_ = {0};
		width = (right - left) + 1;
		height = (bottom - top) + 1;
		switch (self->priv->in_manipulation) {
			case BOX_LOCATION_LEFT_SIDE:
			case BOX_LOCATION_TOP_LEFT:
			case BOX_LOCATION_BOTTOM_LEFT:
			{
				if (width < EDITING_TOOLS_CROP_TOOL_CROP_MIN_SIZE) {
					left = right - EDITING_TOOLS_CROP_TOOL_CROP_MIN_SIZE;
				}
				break;
			}
			case BOX_LOCATION_RIGHT_SIDE:
			case BOX_LOCATION_TOP_RIGHT:
			case BOX_LOCATION_BOTTOM_RIGHT:
			{
				if (width < EDITING_TOOLS_CROP_TOOL_CROP_MIN_SIZE) {
					right = left + EDITING_TOOLS_CROP_TOOL_CROP_MIN_SIZE;
				}
				break;
			}
			default:
			{
				break;
			}
		}
		switch (self->priv->in_manipulation) {
			case BOX_LOCATION_TOP_SIDE:
			case BOX_LOCATION_TOP_LEFT:
			case BOX_LOCATION_TOP_RIGHT:
			{
				if (height < EDITING_TOOLS_CROP_TOOL_CROP_MIN_SIZE) {
					top = bottom - EDITING_TOOLS_CROP_TOOL_CROP_MIN_SIZE;
				}
				break;
			}
			case BOX_LOCATION_BOTTOM_SIDE:
			case BOX_LOCATION_BOTTOM_LEFT:
			case BOX_LOCATION_BOTTOM_RIGHT:
			{
				if (height < EDITING_TOOLS_CROP_TOOL_CROP_MIN_SIZE) {
					bottom = top + EDITING_TOOLS_CROP_TOOL_CROP_MIN_SIZE;
				}
				break;
			}
			default:
			{
				break;
			}
		}
		box_init (&_tmp22_, left, top, right, bottom);
		_tmp23_ = photo_dims;
		_tmp24_ = photo_dims;
		clamp_inside_rotated_image (&_tmp22_, _tmp23_.width, _tmp24_.height, angle, self->priv->in_manipulation == BOX_LOCATION_INSIDE, &_tmp25_);
		new_crop = _tmp25_;
	} else {
		Box adjusted = {0};
		Box _tmp26_;
		Dimensions _tmp27_;
		Dimensions _tmp28_;
		Box _tmp29_ = {0};
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		Box _tmp32_;
		Box _tmp33_;
		box_init (&new_crop, left, top, right, bottom);
		_tmp26_ = new_crop;
		_tmp27_ = photo_dims;
		_tmp28_ = photo_dims;
		clamp_inside_rotated_image (&_tmp26_, _tmp27_.width, _tmp28_.height, angle, self->priv->in_manipulation == BOX_LOCATION_INSIDE, &_tmp29_);
		adjusted = _tmp29_;
		_tmp32_ = adjusted;
		_tmp33_ = new_crop;
		if (_box_equal (&_tmp32_, &_tmp33_) != TRUE) {
			_tmp31_ = TRUE;
		} else {
			_tmp31_ = width < EDITING_TOOLS_CROP_TOOL_CROP_MIN_SIZE;
		}
		if (_tmp31_) {
			_tmp30_ = TRUE;
		} else {
			_tmp30_ = height < EDITING_TOOLS_CROP_TOOL_CROP_MIN_SIZE;
		}
		if (_tmp30_) {
			Box _tmp34_;
			_tmp34_ = self->priv->scaled_crop;
			new_crop = _tmp34_;
		}
	}
	if (self->priv->in_manipulation != BOX_LOCATION_INSIDE) {
		Box _tmp35_;
		_tmp35_ = new_crop;
		editing_tools_crop_tool_crop_resized (self, &_tmp35_);
	} else {
		Box _tmp36_;
		_tmp36_ = new_crop;
		editing_tools_crop_tool_crop_moved (self, &_tmp36_);
	}
	_tmp37_ = new_crop;
	self->priv->scaled_crop = _tmp37_;
	if (editing_tools_crop_tool_get_constraint_aspect_ratio (self) == EDITING_TOOLS_CROP_TOOL_ANY_ASPECT_RATIO) {
		self->priv->custom_init_width = box_get_width (&self->priv->scaled_crop);
		self->priv->custom_init_height = box_get_height (&self->priv->scaled_crop);
		self->priv->custom_aspect_ratio = ((gfloat) self->priv->custom_init_width) / ((gfloat) self->priv->custom_init_height);
	}
	result = FALSE;
	return result;
}

static void
editing_tools_crop_tool_crop_resized (EditingToolsCropTool* self,
                                      Box* new_crop)
{
	Box _tmp0_;
	EditingToolsPhotoCanvas* _tmp1_;
	Box _tmp2_;
	Box horizontal = {0};
	gboolean horizontal_enlarged = FALSE;
	Box vertical = {0};
	gboolean vertical_enlarged = FALSE;
	BoxComplements complements = 0;
	Box _tmp3_;
	Box _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	Box _tmp6_ = {0};
	gboolean _tmp7_ = FALSE;
	BoxComplements _tmp8_;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp12_ = FALSE;
	Box _tmp15_;
	EditingToolsPhotoCanvas* _tmp16_;
	Box _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_crop != NULL);
	_tmp0_ = *new_crop;
	if (box_equals (&self->priv->scaled_crop, &_tmp0_)) {
		return;
	}
	_tmp1_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp2_ = self->priv->scaled_crop;
	editing_tools_photo_canvas_invalidate_area (_tmp1_, &_tmp2_);
	_tmp3_ = *new_crop;
	_tmp8_ = box_resized_complements (&self->priv->scaled_crop, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_);
	horizontal = _tmp4_;
	horizontal_enlarged = _tmp5_;
	vertical = _tmp6_;
	vertical_enlarged = _tmp7_;
	complements = _tmp8_;
	_vala_assert (complements != BOX_COMPLEMENTS_NONE, "complements != BoxComplements.NONE");
	if (complements == BOX_COMPLEMENTS_HORIZONTAL) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = complements == BOX_COMPLEMENTS_BOTH;
	}
	if (_tmp9_) {
		gdouble _tmp10_ = 0.0;
		Box _tmp11_;
		if (horizontal_enlarged) {
			_tmp10_ = 0.0;
		} else {
			_tmp10_ = 0.5;
		}
		_tmp11_ = horizontal;
		editing_tools_crop_tool_set_area_alpha (self, &_tmp11_, _tmp10_);
	}
	if (complements == BOX_COMPLEMENTS_VERTICAL) {
		_tmp12_ = TRUE;
	} else {
		_tmp12_ = complements == BOX_COMPLEMENTS_BOTH;
	}
	if (_tmp12_) {
		gdouble _tmp13_ = 0.0;
		Box _tmp14_;
		if (vertical_enlarged) {
			_tmp13_ = 0.0;
		} else {
			_tmp13_ = 0.5;
		}
		_tmp14_ = vertical;
		editing_tools_crop_tool_set_area_alpha (self, &_tmp14_, _tmp13_);
	}
	_tmp15_ = *new_crop;
	editing_tools_crop_tool_paint_crop_tool (self, &_tmp15_);
	_tmp16_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp17_ = *new_crop;
	editing_tools_photo_canvas_invalidate_area (_tmp16_, &_tmp17_);
}

static void
editing_tools_crop_tool_crop_moved (EditingToolsCropTool* self,
                                    Box* new_crop)
{
	Box _tmp0_;
	EditingToolsPhotoCanvas* _tmp1_;
	Box _tmp2_;
	Box _tmp3_;
	Box _tmp4_;
	Box _tmp5_;
	EditingToolsPhotoCanvas* _tmp6_;
	Box _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_crop != NULL);
	_tmp0_ = *new_crop;
	if (box_equals (&self->priv->scaled_crop, &_tmp0_)) {
		return;
	}
	_tmp1_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp2_ = self->priv->scaled_crop;
	editing_tools_photo_canvas_invalidate_area (_tmp1_, &_tmp2_);
	_tmp3_ = self->priv->scaled_crop;
	editing_tools_crop_tool_set_area_alpha (self, &_tmp3_, 0.5);
	_tmp4_ = *new_crop;
	editing_tools_crop_tool_set_area_alpha (self, &_tmp4_, 0.0);
	_tmp5_ = *new_crop;
	editing_tools_crop_tool_paint_crop_tool (self, &_tmp5_);
	_tmp6_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp7_ = *new_crop;
	editing_tools_photo_canvas_invalidate_area (_tmp6_, &_tmp7_);
}

static void
editing_tools_crop_tool_set_area_alpha (EditingToolsCropTool* self,
                                        Box* area,
                                        gdouble alpha)
{
	cairo_t* ctx = NULL;
	cairo_surface_t* _tmp0_;
	cairo_t* _tmp1_;
	Box _tmp2_;
	Box _tmp3_;
	EditingToolsPhotoCanvas* _tmp4_;
	cairo_surface_t* _tmp5_;
	Box _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (area != NULL);
	_tmp0_ = self->priv->crop_surface;
	_tmp1_ = cairo_create (_tmp0_);
	ctx = _tmp1_;
	cairo_set_operator (ctx, CAIRO_OPERATOR_SOURCE);
	cairo_set_source_rgba (ctx, 0.0, 0.0, 0.0, alpha);
	_tmp2_ = *area;
	_tmp3_ = *area;
	cairo_rectangle (ctx, (gdouble) _tmp2_.left, (gdouble) _tmp3_.top, (gdouble) box_get_width (area), (gdouble) box_get_height (area));
	cairo_fill (ctx);
	_tmp4_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp5_ = self->priv->crop_surface;
	_tmp6_ = *area;
	editing_tools_photo_canvas_paint_surface_area (_tmp4_, _tmp5_, &_tmp6_, TRUE);
	_cairo_destroy0 (ctx);
}

static void
editing_tools_crop_tool_paint_crop_tool (EditingToolsCropTool* self,
                                         Box* crop)
{
	EditingToolsPhotoCanvas* _tmp38_;
	cairo_t* _tmp39_;
	Box _tmp40_;
	EditingToolsPhotoCanvas* _tmp41_;
	cairo_t* _tmp42_;
	Box _tmp43_ = {0};
	EditingToolsPhotoCanvas* _tmp44_;
	cairo_t* _tmp45_;
	Box _tmp46_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (crop != NULL);
	if (self->priv->in_manipulation != BOX_LOCATION_OUTSIDE) {
		gint one_third_x = 0;
		gint one_third_y = 0;
		EditingToolsPhotoCanvas* _tmp0_;
		cairo_t* _tmp1_;
		Box _tmp2_;
		Box _tmp3_;
		EditingToolsPhotoCanvas* _tmp4_;
		cairo_t* _tmp5_;
		Box _tmp6_;
		Box _tmp7_;
		EditingToolsPhotoCanvas* _tmp8_;
		cairo_t* _tmp9_;
		Box _tmp10_;
		Box _tmp11_;
		EditingToolsPhotoCanvas* _tmp12_;
		cairo_t* _tmp13_;
		Box _tmp14_;
		Box _tmp15_;
		Box adj_crop = {0};
		EditingToolsPhotoCanvas* _tmp16_;
		GdkRectangle _tmp17_ = {0};
		GdkRectangle _tmp18_;
		Dimensions _tmp19_ = {0};
		EditingToolsPhotoCanvas* _tmp20_;
		Photo* _tmp21_;
		Photo* _tmp22_;
		Dimensions _tmp23_ = {0};
		Box _tmp24_ = {0};
		gchar* text = NULL;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gint x = 0;
		Box _tmp33_;
		gint y = 0;
		Box _tmp34_;
		EditingToolsPhotoCanvas* _tmp35_;
		cairo_t* _tmp36_;
		const gchar* _tmp37_;
		one_third_x = box_get_width (crop) / 3;
		one_third_y = box_get_height (crop) / 3;
		_tmp0_ = ((EditingToolsEditingTool*) self)->canvas;
		_tmp1_ = self->priv->thin_white_ctx;
		_tmp2_ = *crop;
		_tmp3_ = *crop;
		editing_tools_photo_canvas_draw_horizontal_line (_tmp0_, _tmp1_, _tmp2_.left, _tmp3_.top + one_third_y, box_get_width (crop), TRUE);
		_tmp4_ = ((EditingToolsEditingTool*) self)->canvas;
		_tmp5_ = self->priv->thin_white_ctx;
		_tmp6_ = *crop;
		_tmp7_ = *crop;
		editing_tools_photo_canvas_draw_horizontal_line (_tmp4_, _tmp5_, _tmp6_.left, _tmp7_.top + (one_third_y * 2), box_get_width (crop), TRUE);
		_tmp8_ = ((EditingToolsEditingTool*) self)->canvas;
		_tmp9_ = self->priv->thin_white_ctx;
		_tmp10_ = *crop;
		_tmp11_ = *crop;
		editing_tools_photo_canvas_draw_vertical_line (_tmp8_, _tmp9_, _tmp10_.left + one_third_x, _tmp11_.top, box_get_height (crop), TRUE);
		_tmp12_ = ((EditingToolsEditingTool*) self)->canvas;
		_tmp13_ = self->priv->thin_white_ctx;
		_tmp14_ = *crop;
		_tmp15_ = *crop;
		editing_tools_photo_canvas_draw_vertical_line (_tmp12_, _tmp13_, _tmp14_.left + (one_third_x * 2), _tmp15_.top, box_get_height (crop), TRUE);
		_tmp16_ = ((EditingToolsEditingTool*) self)->canvas;
		editing_tools_photo_canvas_get_scaled_position (_tmp16_, &_tmp17_);
		_tmp18_ = _tmp17_;
		dimensions_for_rectangle (&_tmp18_, &_tmp19_);
		_tmp20_ = ((EditingToolsEditingTool*) self)->canvas;
		_tmp21_ = editing_tools_photo_canvas_get_photo (_tmp20_);
		_tmp22_ = _tmp21_;
		media_source_get_dimensions ((MediaSource*) _tmp22_, PHOTO_EXCEPTION_CROP, &_tmp23_);
		box_get_scaled_similar (&self->priv->scaled_crop, &_tmp19_, &_tmp23_, &_tmp24_);
		adj_crop = _tmp24_;
		_tmp25_ = g_strdup_printf ("%i", box_get_width (&adj_crop));
		_tmp26_ = _tmp25_;
		_tmp27_ = g_strconcat (_tmp26_, "x", NULL);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_strdup_printf ("%i", box_get_height (&adj_crop));
		_tmp30_ = _tmp29_;
		_tmp31_ = g_strconcat (_tmp28_, _tmp30_, NULL);
		_tmp32_ = _tmp31_;
		_g_free0 (_tmp30_);
		_g_free0 (_tmp28_);
		_g_free0 (_tmp26_);
		text = _tmp32_;
		_tmp33_ = *crop;
		x = _tmp33_.left + (box_get_width (crop) / 2);
		_tmp34_ = *crop;
		y = _tmp34_.top + (box_get_height (crop) / 2);
		_tmp35_ = ((EditingToolsEditingTool*) self)->canvas;
		_tmp36_ = self->priv->text_ctx;
		_tmp37_ = text;
		editing_tools_photo_canvas_draw_text (_tmp35_, _tmp36_, _tmp37_, x, y, TRUE);
		_g_free0 (text);
	}
	_tmp38_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp39_ = self->priv->wide_black_ctx;
	_tmp40_ = *crop;
	editing_tools_photo_canvas_draw_box (_tmp38_, _tmp39_, &_tmp40_);
	_tmp41_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp42_ = self->priv->wide_white_ctx;
	box_get_reduced (crop, 1, &_tmp43_);
	editing_tools_photo_canvas_draw_box (_tmp41_, _tmp42_, &_tmp43_);
	_tmp44_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp45_ = self->priv->wide_white_ctx;
	box_get_reduced (crop, 2, &_tmp46_);
	editing_tools_photo_canvas_draw_box (_tmp44_, _tmp45_, &_tmp46_);
}

static inline gpointer
editing_tools_crop_tool_constraint_description_get_instance_private (EditingToolsCropToolConstraintDescription* self)
{
	return G_STRUCT_MEMBER_P (self, EditingToolsCropToolConstraintDescription_private_offset);
}

static EditingToolsCropToolConstraintDescription*
editing_tools_crop_tool_constraint_description_construct (GType object_type,
                                                          const gchar* new_name,
                                                          gint new_basis_width,
                                                          gint new_basis_height,
                                                          gboolean new_pivotable,
                                                          gfloat new_aspect_ratio)
{
	EditingToolsCropToolConstraintDescription * self = NULL;
	gfloat _tmp0_;
	g_return_val_if_fail (new_name != NULL, NULL);
	self = (EditingToolsCropToolConstraintDescription*) g_object_new (object_type, "name", new_name, "basis-width", new_basis_width, "basis-height", new_basis_height, "is-pivotable", new_pivotable, "aspect-ratio", new_aspect_ratio, NULL);
	_tmp0_ = self->priv->_aspect_ratio;
	if (_tmp0_ == EDITING_TOOLS_CROP_TOOL_COMPUTE_FROM_BASIS) {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = self->priv->_basis_width;
		_tmp2_ = self->priv->_basis_height;
		editing_tools_crop_tool_constraint_description_set_aspect_ratio (self, ((gfloat) _tmp1_) / ((gfloat) _tmp2_));
	} else {
		editing_tools_crop_tool_constraint_description_set_aspect_ratio (self, new_aspect_ratio);
	}
	return self;
}

static EditingToolsCropToolConstraintDescription*
editing_tools_crop_tool_constraint_description_new (const gchar* new_name,
                                                    gint new_basis_width,
                                                    gint new_basis_height,
                                                    gboolean new_pivotable,
                                                    gfloat new_aspect_ratio)
{
	return editing_tools_crop_tool_constraint_description_construct (EDITING_TOOLS_CROP_TOOL_TYPE_CONSTRAINT_DESCRIPTION, new_name, new_basis_width, new_basis_height, new_pivotable, new_aspect_ratio);
}

static gboolean
editing_tools_crop_tool_constraint_description_is_separator (EditingToolsCropToolConstraintDescription* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_is_pivotable;
	if (!_tmp1_) {
		gfloat _tmp2_;
		_tmp2_ = self->priv->_aspect_ratio;
		_tmp0_ = _tmp2_ == EDITING_TOOLS_CROP_TOOL_SEPARATOR;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static const gchar*
editing_tools_crop_tool_constraint_description_get_name (EditingToolsCropToolConstraintDescription* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
editing_tools_crop_tool_constraint_description_set_name (EditingToolsCropToolConstraintDescription* self,
                                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = editing_tools_crop_tool_constraint_description_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, editing_tools_crop_tool_constraint_description_properties[EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_NAME_PROPERTY]);
	}
}

static gint
editing_tools_crop_tool_constraint_description_get_basis_width (EditingToolsCropToolConstraintDescription* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_basis_width;
	return result;
}

static void
editing_tools_crop_tool_constraint_description_set_basis_width (EditingToolsCropToolConstraintDescription* self,
                                                                gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = editing_tools_crop_tool_constraint_description_get_basis_width (self);
	if (old_value != value) {
		self->priv->_basis_width = value;
		g_object_notify_by_pspec ((GObject *) self, editing_tools_crop_tool_constraint_description_properties[EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_BASIS_WIDTH_PROPERTY]);
	}
}

static gint
editing_tools_crop_tool_constraint_description_get_basis_height (EditingToolsCropToolConstraintDescription* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_basis_height;
	return result;
}

static void
editing_tools_crop_tool_constraint_description_set_basis_height (EditingToolsCropToolConstraintDescription* self,
                                                                 gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = editing_tools_crop_tool_constraint_description_get_basis_height (self);
	if (old_value != value) {
		self->priv->_basis_height = value;
		g_object_notify_by_pspec ((GObject *) self, editing_tools_crop_tool_constraint_description_properties[EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_BASIS_HEIGHT_PROPERTY]);
	}
}

static gboolean
editing_tools_crop_tool_constraint_description_get_is_pivotable (EditingToolsCropToolConstraintDescription* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_pivotable;
	return result;
}

static void
editing_tools_crop_tool_constraint_description_set_is_pivotable (EditingToolsCropToolConstraintDescription* self,
                                                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = editing_tools_crop_tool_constraint_description_get_is_pivotable (self);
	if (old_value != value) {
		self->priv->_is_pivotable = value;
		g_object_notify_by_pspec ((GObject *) self, editing_tools_crop_tool_constraint_description_properties[EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_IS_PIVOTABLE_PROPERTY]);
	}
}

static gfloat
editing_tools_crop_tool_constraint_description_get_aspect_ratio (EditingToolsCropToolConstraintDescription* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_aspect_ratio;
	return result;
}

static void
editing_tools_crop_tool_constraint_description_set_aspect_ratio (EditingToolsCropToolConstraintDescription* self,
                                                                 gfloat value)
{
	gfloat old_value;
	g_return_if_fail (self != NULL);
	old_value = editing_tools_crop_tool_constraint_description_get_aspect_ratio (self);
	if (old_value != value) {
		self->priv->_aspect_ratio = value;
		g_object_notify_by_pspec ((GObject *) self, editing_tools_crop_tool_constraint_description_properties[EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_ASPECT_RATIO_PROPERTY]);
	}
}

static void
editing_tools_crop_tool_constraint_description_class_init (EditingToolsCropToolConstraintDescriptionClass * klass,
                                                           gpointer klass_data)
{
	editing_tools_crop_tool_constraint_description_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &EditingToolsCropToolConstraintDescription_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_editing_tools_crop_tool_constraint_description_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_editing_tools_crop_tool_constraint_description_set_property;
	G_OBJECT_CLASS (klass)->finalize = editing_tools_crop_tool_constraint_description_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_NAME_PROPERTY, editing_tools_crop_tool_constraint_description_properties[EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_BASIS_WIDTH_PROPERTY, editing_tools_crop_tool_constraint_description_properties[EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_BASIS_WIDTH_PROPERTY] = g_param_spec_int ("basis-width", "basis-width", "basis-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_BASIS_HEIGHT_PROPERTY, editing_tools_crop_tool_constraint_description_properties[EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_BASIS_HEIGHT_PROPERTY] = g_param_spec_int ("basis-height", "basis-height", "basis-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_IS_PIVOTABLE_PROPERTY, editing_tools_crop_tool_constraint_description_properties[EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_IS_PIVOTABLE_PROPERTY] = g_param_spec_boolean ("is-pivotable", "is-pivotable", "is-pivotable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_ASPECT_RATIO_PROPERTY, editing_tools_crop_tool_constraint_description_properties[EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_ASPECT_RATIO_PROPERTY] = g_param_spec_float ("aspect-ratio", "aspect-ratio", "aspect-ratio", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
editing_tools_crop_tool_constraint_description_instance_init (EditingToolsCropToolConstraintDescription * self,
                                                              gpointer klass)
{
	self->priv = editing_tools_crop_tool_constraint_description_get_instance_private (self);
}

static void
editing_tools_crop_tool_constraint_description_finalize (GObject * obj)
{
	EditingToolsCropToolConstraintDescription * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EDITING_TOOLS_CROP_TOOL_TYPE_CONSTRAINT_DESCRIPTION, EditingToolsCropToolConstraintDescription);
	_g_free0 (self->priv->_name);
	G_OBJECT_CLASS (editing_tools_crop_tool_constraint_description_parent_class)->finalize (obj);
}

static GType
editing_tools_crop_tool_constraint_description_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EditingToolsCropToolConstraintDescriptionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) editing_tools_crop_tool_constraint_description_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EditingToolsCropToolConstraintDescription), 0, (GInstanceInitFunc) editing_tools_crop_tool_constraint_description_instance_init, NULL };
	GType editing_tools_crop_tool_constraint_description_type_id;
	editing_tools_crop_tool_constraint_description_type_id = g_type_register_static (G_TYPE_OBJECT, "EditingToolsCropToolConstraintDescription", &g_define_type_info, 0);
	EditingToolsCropToolConstraintDescription_private_offset = g_type_add_instance_private (editing_tools_crop_tool_constraint_description_type_id, sizeof (EditingToolsCropToolConstraintDescriptionPrivate));
	return editing_tools_crop_tool_constraint_description_type_id;
}

static GType
editing_tools_crop_tool_constraint_description_get_type (void)
{
	static volatile gsize editing_tools_crop_tool_constraint_description_type_id__once = 0;
	if (g_once_init_enter (&editing_tools_crop_tool_constraint_description_type_id__once)) {
		GType editing_tools_crop_tool_constraint_description_type_id;
		editing_tools_crop_tool_constraint_description_type_id = editing_tools_crop_tool_constraint_description_get_type_once ();
		g_once_init_leave (&editing_tools_crop_tool_constraint_description_type_id__once, editing_tools_crop_tool_constraint_description_type_id);
	}
	return editing_tools_crop_tool_constraint_description_type_id__once;
}

static void
_vala_editing_tools_crop_tool_constraint_description_get_property (GObject * object,
                                                                   guint property_id,
                                                                   GValue * value,
                                                                   GParamSpec * pspec)
{
	EditingToolsCropToolConstraintDescription * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, EDITING_TOOLS_CROP_TOOL_TYPE_CONSTRAINT_DESCRIPTION, EditingToolsCropToolConstraintDescription);
	switch (property_id) {
		case EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_NAME_PROPERTY:
		g_value_set_string (value, editing_tools_crop_tool_constraint_description_get_name (self));
		break;
		case EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_BASIS_WIDTH_PROPERTY:
		g_value_set_int (value, editing_tools_crop_tool_constraint_description_get_basis_width (self));
		break;
		case EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_BASIS_HEIGHT_PROPERTY:
		g_value_set_int (value, editing_tools_crop_tool_constraint_description_get_basis_height (self));
		break;
		case EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_IS_PIVOTABLE_PROPERTY:
		g_value_set_boolean (value, editing_tools_crop_tool_constraint_description_get_is_pivotable (self));
		break;
		case EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_ASPECT_RATIO_PROPERTY:
		g_value_set_float (value, editing_tools_crop_tool_constraint_description_get_aspect_ratio (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_editing_tools_crop_tool_constraint_description_set_property (GObject * object,
                                                                   guint property_id,
                                                                   const GValue * value,
                                                                   GParamSpec * pspec)
{
	EditingToolsCropToolConstraintDescription * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, EDITING_TOOLS_CROP_TOOL_TYPE_CONSTRAINT_DESCRIPTION, EditingToolsCropToolConstraintDescription);
	switch (property_id) {
		case EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_NAME_PROPERTY:
		editing_tools_crop_tool_constraint_description_set_name (self, g_value_get_string (value));
		break;
		case EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_BASIS_WIDTH_PROPERTY:
		editing_tools_crop_tool_constraint_description_set_basis_width (self, g_value_get_int (value));
		break;
		case EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_BASIS_HEIGHT_PROPERTY:
		editing_tools_crop_tool_constraint_description_set_basis_height (self, g_value_get_int (value));
		break;
		case EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_IS_PIVOTABLE_PROPERTY:
		editing_tools_crop_tool_constraint_description_set_is_pivotable (self, g_value_get_boolean (value));
		break;
		case EDITING_TOOLS_CROP_TOOL_CONSTRAINT_DESCRIPTION_ASPECT_RATIO_PROPERTY:
		editing_tools_crop_tool_constraint_description_set_aspect_ratio (self, g_value_get_float (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
editing_tools_crop_tool_crop_tool_window_get_instance_private (EditingToolsCropToolCropToolWindow* self)
{
	return G_STRUCT_MEMBER_P (self, EditingToolsCropToolCropToolWindow_private_offset);
}

static EditingToolsCropToolCropToolWindow*
editing_tools_crop_tool_crop_tool_window_construct (GType object_type,
                                                    GtkWindow* container)
{
	EditingToolsCropToolCropToolWindow * self = NULL;
	g_return_val_if_fail (container != NULL, NULL);
	self = (EditingToolsCropToolCropToolWindow*) g_object_new (object_type, "transient-for", container, NULL);
	return self;
}

static EditingToolsCropToolCropToolWindow*
editing_tools_crop_tool_crop_tool_window_new (GtkWindow* container)
{
	return editing_tools_crop_tool_crop_tool_window_construct (EDITING_TOOLS_CROP_TOOL_TYPE_CROP_TOOL_WINDOW, container);
}

static gboolean
editing_tools_crop_tool_crop_tool_window_constraint_combo_separator_func (GtkTreeModel* model,
                                                                          GtkTreeIter* iter)
{
	GValue val = {0};
	GtkTreeIter _tmp0_;
	GValue _tmp1_ = {0};
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	gtk_tree_model_get_value (model, &_tmp0_, 0, &_tmp1_);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	val = _tmp1_;
	_tmp2_ = g_value_dup_string (&val);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "-") == 0;
	_g_free0 (_tmp3_);
	result = _tmp4_;
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	return result;
}

static GtkButton*
editing_tools_crop_tool_crop_tool_window_get_crop_button (EditingToolsCropToolCropToolWindow* self)
{
	GtkButton* result;
	GtkButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_crop_button;
	result = _tmp0_;
	return result;
}

static void
editing_tools_crop_tool_crop_tool_window_set_crop_button (EditingToolsCropToolCropToolWindow* self,
                                                          GtkButton* value)
{
	GtkButton* old_value;
	g_return_if_fail (self != NULL);
	old_value = editing_tools_crop_tool_crop_tool_window_get_crop_button (self);
	if (old_value != value) {
		GtkButton* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_crop_button);
		self->priv->_crop_button = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, editing_tools_crop_tool_crop_tool_window_properties[EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CROP_BUTTON_PROPERTY]);
	}
}

static GtkButton*
editing_tools_crop_tool_crop_tool_window_get_cancel_button (EditingToolsCropToolCropToolWindow* self)
{
	GtkButton* result;
	GtkButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_cancel_button;
	result = _tmp0_;
	return result;
}

static void
editing_tools_crop_tool_crop_tool_window_set_cancel_button (EditingToolsCropToolCropToolWindow* self,
                                                            GtkButton* value)
{
	GtkButton* old_value;
	g_return_if_fail (self != NULL);
	old_value = editing_tools_crop_tool_crop_tool_window_get_cancel_button (self);
	if (old_value != value) {
		GtkButton* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_cancel_button);
		self->priv->_cancel_button = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, editing_tools_crop_tool_crop_tool_window_properties[EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CANCEL_BUTTON_PROPERTY]);
	}
}

static GtkComboBox*
editing_tools_crop_tool_crop_tool_window_get_constraint_combo (EditingToolsCropToolCropToolWindow* self)
{
	GtkComboBox* result;
	GtkComboBox* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_constraint_combo;
	result = _tmp0_;
	return result;
}

static void
editing_tools_crop_tool_crop_tool_window_set_constraint_combo (EditingToolsCropToolCropToolWindow* self,
                                                               GtkComboBox* value)
{
	GtkComboBox* old_value;
	g_return_if_fail (self != NULL);
	old_value = editing_tools_crop_tool_crop_tool_window_get_constraint_combo (self);
	if (old_value != value) {
		GtkComboBox* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_constraint_combo);
		self->priv->_constraint_combo = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, editing_tools_crop_tool_crop_tool_window_properties[EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CONSTRAINT_COMBO_PROPERTY]);
	}
}

static GtkButton*
editing_tools_crop_tool_crop_tool_window_get_pivot_reticle_button (EditingToolsCropToolCropToolWindow* self)
{
	GtkButton* result;
	GtkButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pivot_reticle_button;
	result = _tmp0_;
	return result;
}

static void
editing_tools_crop_tool_crop_tool_window_set_pivot_reticle_button (EditingToolsCropToolCropToolWindow* self,
                                                                   GtkButton* value)
{
	GtkButton* old_value;
	g_return_if_fail (self != NULL);
	old_value = editing_tools_crop_tool_crop_tool_window_get_pivot_reticle_button (self);
	if (old_value != value) {
		GtkButton* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_pivot_reticle_button);
		self->priv->_pivot_reticle_button = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, editing_tools_crop_tool_crop_tool_window_properties[EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_PIVOT_RETICLE_BUTTON_PROPERTY]);
	}
}

static GtkEntry*
editing_tools_crop_tool_crop_tool_window_get_custom_width_entry (EditingToolsCropToolCropToolWindow* self)
{
	GtkEntry* result;
	GtkEntry* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_custom_width_entry;
	result = _tmp0_;
	return result;
}

static void
editing_tools_crop_tool_crop_tool_window_set_custom_width_entry (EditingToolsCropToolCropToolWindow* self,
                                                                 GtkEntry* value)
{
	GtkEntry* old_value;
	g_return_if_fail (self != NULL);
	old_value = editing_tools_crop_tool_crop_tool_window_get_custom_width_entry (self);
	if (old_value != value) {
		GtkEntry* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_custom_width_entry);
		self->priv->_custom_width_entry = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, editing_tools_crop_tool_crop_tool_window_properties[EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CUSTOM_WIDTH_ENTRY_PROPERTY]);
	}
}

static GtkEntry*
editing_tools_crop_tool_crop_tool_window_get_custom_height_entry (EditingToolsCropToolCropToolWindow* self)
{
	GtkEntry* result;
	GtkEntry* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_custom_height_entry;
	result = _tmp0_;
	return result;
}

static void
editing_tools_crop_tool_crop_tool_window_set_custom_height_entry (EditingToolsCropToolCropToolWindow* self,
                                                                  GtkEntry* value)
{
	GtkEntry* old_value;
	g_return_if_fail (self != NULL);
	old_value = editing_tools_crop_tool_crop_tool_window_get_custom_height_entry (self);
	if (old_value != value) {
		GtkEntry* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_custom_height_entry);
		self->priv->_custom_height_entry = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, editing_tools_crop_tool_crop_tool_window_properties[EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CUSTOM_HEIGHT_ENTRY_PROPERTY]);
	}
}

static GtkRevealer*
editing_tools_crop_tool_crop_tool_window_get_custom_aspect_revealer (EditingToolsCropToolCropToolWindow* self)
{
	GtkRevealer* result;
	GtkRevealer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_custom_aspect_revealer;
	result = _tmp0_;
	return result;
}

static void
editing_tools_crop_tool_crop_tool_window_set_custom_aspect_revealer (EditingToolsCropToolCropToolWindow* self,
                                                                     GtkRevealer* value)
{
	GtkRevealer* old_value;
	g_return_if_fail (self != NULL);
	old_value = editing_tools_crop_tool_crop_tool_window_get_custom_aspect_revealer (self);
	if (old_value != value) {
		GtkRevealer* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_custom_aspect_revealer);
		self->priv->_custom_aspect_revealer = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, editing_tools_crop_tool_crop_tool_window_properties[EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CUSTOM_ASPECT_REVEALER_PROPERTY]);
	}
}

static GtkEntry*
editing_tools_crop_tool_crop_tool_window_get_most_recently_edited (EditingToolsCropToolCropToolWindow* self)
{
	GtkEntry* result;
	GtkEntry* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_most_recently_edited;
	result = _tmp0_;
	return result;
}

static void
editing_tools_crop_tool_crop_tool_window_set_most_recently_edited (EditingToolsCropToolCropToolWindow* self,
                                                                   GtkEntry* value)
{
	GtkEntry* old_value;
	g_return_if_fail (self != NULL);
	old_value = editing_tools_crop_tool_crop_tool_window_get_most_recently_edited (self);
	if (old_value != value) {
		GtkEntry* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_most_recently_edited);
		self->priv->_most_recently_edited = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, editing_tools_crop_tool_crop_tool_window_properties[EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_MOST_RECENTLY_EDITED_PROPERTY]);
	}
}

static gboolean
_editing_tools_crop_tool_crop_tool_window_constraint_combo_separator_func_gtk_tree_view_row_separator_func (GtkTreeModel* model,
                                                                                                            GtkTreeIter* iter,
                                                                                                            gpointer self)
{
	gboolean result;
	result = editing_tools_crop_tool_crop_tool_window_constraint_combo_separator_func (model, iter);
	return result;
}

static gboolean
_editing_tools_crop_tool_crop_tool_window___lambda48_ (EditingToolsCropToolCropToolWindow* self)
{
	GtkEntry* _tmp0_;
	_tmp0_ = self->priv->_custom_width_entry;
	editing_tools_crop_tool_crop_tool_window_set_most_recently_edited (self, _tmp0_);
}

static gboolean
__editing_tools_crop_tool_crop_tool_window___lambda48__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                                   GdkEventFocus* event,
                                                                                   gpointer self)
{
	gboolean result;
	result = _editing_tools_crop_tool_crop_tool_window___lambda48_ ((EditingToolsCropToolCropToolWindow*) self);
	return result;
}

static gboolean
_editing_tools_crop_tool_crop_tool_window___lambda49_ (EditingToolsCropToolCropToolWindow* self)
{
	GtkEntry* _tmp0_;
	_tmp0_ = self->priv->_custom_height_entry;
	editing_tools_crop_tool_crop_tool_window_set_most_recently_edited (self, _tmp0_);
}

static gboolean
__editing_tools_crop_tool_crop_tool_window___lambda49__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                                   GdkEventFocus* event,
                                                                                   gpointer self)
{
	gboolean result;
	result = _editing_tools_crop_tool_crop_tool_window___lambda49_ ((EditingToolsCropToolCropToolWindow*) self);
	return result;
}

static GObject *
editing_tools_crop_tool_crop_tool_window_constructor (GType type,
                                                      guint n_construct_properties,
                                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	EditingToolsCropToolCropToolWindow * self;
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_ = NULL;
	GtkButton* _tmp3_;
	GtkCellRendererText* combo_text_renderer = NULL;
	GtkCellRendererText* _tmp4_;
	GtkComboBox* _tmp5_;
	GtkComboBox* _tmp6_;
	GtkComboBox* _tmp7_;
	GtkCellRendererText* _tmp8_;
	GtkComboBox* _tmp9_;
	GtkCellRendererText* _tmp10_;
	GtkComboBox* _tmp11_;
	GtkComboBox* _tmp12_;
	gchar* _tmp13_;
	GtkButton* _tmp14_ = NULL;
	GtkButton* _tmp15_;
	GtkEntry* _tmp16_ = NULL;
	GtkEntry* _tmp17_;
	GtkEntry* _tmp18_ = NULL;
	GtkEntry* _tmp19_;
	GtkGrid* custom_aspect_grid = NULL;
	GtkGrid* _tmp20_ = NULL;
	GtkGrid* _tmp21_;
	GtkEntry* _tmp22_;
	GtkGrid* _tmp23_;
	GtkLabel* _tmp24_;
	GtkLabel* _tmp25_;
	GtkGrid* _tmp26_;
	GtkEntry* _tmp27_;
	GtkRevealer* _tmp28_ = NULL;
	GtkRevealer* _tmp29_;
	GtkRevealer* _tmp30_;
	GtkGrid* _tmp31_;
	GtkSizeGroup* response_sizegroup = NULL;
	GtkSizeGroup* _tmp32_;
	GtkSizeGroup* _tmp33_;
	GtkButton* _tmp34_;
	GtkSizeGroup* _tmp35_;
	GtkButton* _tmp36_;
	GtkGrid* layout = NULL;
	GtkGrid* _tmp37_;
	GtkGrid* _tmp38_;
	GtkGrid* _tmp39_;
	GtkComboBox* _tmp40_;
	GtkGrid* _tmp41_;
	GtkRevealer* _tmp42_;
	GtkGrid* _tmp43_;
	GtkButton* _tmp44_;
	GtkGrid* _tmp45_;
	GtkButton* _tmp46_;
	GtkGrid* _tmp47_;
	GtkButton* _tmp48_;
	GtkGrid* _tmp49_;
	GtkGrid* _tmp50_;
	GtkGrid* _tmp51_;
	GtkButton* _tmp52_;
	GtkEntry* _tmp53_;
	GtkEntry* _tmp54_;
	parent_class = G_OBJECT_CLASS (editing_tools_crop_tool_crop_tool_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EDITING_TOOLS_CROP_TOOL_TYPE_CROP_TOOL_WINDOW, EditingToolsCropToolCropToolWindow);
	_tmp0_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Cancel"));
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	editing_tools_crop_tool_crop_tool_window_set_cancel_button (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = (GtkButton*) gtk_button_new_with_label (RESOURCES_CROP_LABEL);
	gtk_widget_set_can_default ((GtkWidget*) _tmp2_, TRUE);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	editing_tools_crop_tool_crop_tool_window_set_crop_button (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp4_);
	combo_text_renderer = _tmp4_;
	_tmp5_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	editing_tools_crop_tool_crop_tool_window_set_constraint_combo (self, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->priv->_constraint_combo;
	_tmp8_ = combo_text_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp7_, (GtkCellRenderer*) _tmp8_, TRUE);
	_tmp9_ = self->priv->_constraint_combo;
	_tmp10_ = combo_text_renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp9_, (GtkCellRenderer*) _tmp10_, "text", 0);
	_tmp11_ = self->priv->_constraint_combo;
	gtk_combo_box_set_row_separator_func (_tmp11_, _editing_tools_crop_tool_crop_tool_window_constraint_combo_separator_func_gtk_tree_view_row_separator_func, NULL, NULL);
	_tmp12_ = self->priv->_constraint_combo;
	gtk_combo_box_set_active (_tmp12_, 0);
	_tmp13_ = g_strdup (_ ("Pivot the crop rectangle between portrait and landscape orientations"));
	_tmp14_ = (GtkButton*) gtk_button_new_from_icon_name ("object-rotate-right-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp14_, _tmp13_);
	_g_free0 (_tmp13_);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp14_, 18);
	g_object_ref_sink (_tmp14_);
	_tmp15_ = _tmp14_;
	editing_tools_crop_tool_crop_tool_window_set_pivot_reticle_button (self, _tmp15_);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = (GtkEntry*) gtk_entry_new ();
	gtk_entry_set_activates_default (_tmp16_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp16_, TRUE);
	gtk_entry_set_width_chars (_tmp16_, 4);
	g_object_set (_tmp16_, "xalign", 0.5f, NULL);
	g_object_ref_sink (_tmp16_);
	_tmp17_ = _tmp16_;
	editing_tools_crop_tool_crop_tool_window_set_custom_width_entry (self, _tmp17_);
	_g_object_unref0 (_tmp17_);
	_tmp18_ = (GtkEntry*) gtk_entry_new ();
	gtk_entry_set_activates_default (_tmp18_, TRUE);
	gtk_entry_set_width_chars (_tmp18_, 4);
	g_object_set (_tmp18_, "xalign", 0.5f, NULL);
	g_object_ref_sink (_tmp18_);
	_tmp19_ = _tmp18_;
	editing_tools_crop_tool_crop_tool_window_set_custom_height_entry (self, _tmp19_);
	_g_object_unref0 (_tmp19_);
	_tmp20_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp20_, 3);
	g_object_ref_sink (_tmp20_);
	custom_aspect_grid = _tmp20_;
	_tmp21_ = custom_aspect_grid;
	_tmp22_ = self->priv->_custom_width_entry;
	gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = custom_aspect_grid;
	_tmp24_ = (GtkLabel*) gtk_label_new (":");
	g_object_ref_sink (_tmp24_);
	_tmp25_ = _tmp24_;
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp25_);
	_g_object_unref0 (_tmp25_);
	_tmp26_ = custom_aspect_grid;
	_tmp27_ = self->priv->_custom_height_entry;
	gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
	_tmp28_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_transition_type (_tmp28_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_RIGHT);
	g_object_ref_sink (_tmp28_);
	_tmp29_ = _tmp28_;
	editing_tools_crop_tool_crop_tool_window_set_custom_aspect_revealer (self, _tmp29_);
	_g_object_unref0 (_tmp29_);
	_tmp30_ = self->priv->_custom_aspect_revealer;
	_tmp31_ = custom_aspect_grid;
	gtk_container_add ((GtkContainer*) _tmp30_, (GtkWidget*) _tmp31_);
	_tmp32_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	response_sizegroup = _tmp32_;
	_tmp33_ = response_sizegroup;
	_tmp34_ = self->priv->_cancel_button;
	gtk_size_group_add_widget (_tmp33_, (GtkWidget*) _tmp34_);
	_tmp35_ = response_sizegroup;
	_tmp36_ = self->priv->_crop_button;
	gtk_size_group_add_widget (_tmp35_, (GtkWidget*) _tmp36_);
	_tmp37_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp37_);
	layout = _tmp37_;
	_tmp38_ = layout;
	gtk_grid_set_column_spacing (_tmp38_, 6);
	_tmp39_ = layout;
	_tmp40_ = self->priv->_constraint_combo;
	gtk_container_add ((GtkContainer*) _tmp39_, (GtkWidget*) _tmp40_);
	_tmp41_ = layout;
	_tmp42_ = self->priv->_custom_aspect_revealer;
	gtk_container_add ((GtkContainer*) _tmp41_, (GtkWidget*) _tmp42_);
	_tmp43_ = layout;
	_tmp44_ = self->priv->_pivot_reticle_button;
	gtk_container_add ((GtkContainer*) _tmp43_, (GtkWidget*) _tmp44_);
	_tmp45_ = layout;
	_tmp46_ = self->priv->_cancel_button;
	gtk_container_add ((GtkContainer*) _tmp45_, (GtkWidget*) _tmp46_);
	_tmp47_ = layout;
	_tmp48_ = self->priv->_crop_button;
	gtk_container_add ((GtkContainer*) _tmp47_, (GtkWidget*) _tmp48_);
	_tmp49_ = editing_tools_editing_tool_window_get_content_area ((EditingToolsEditingToolWindow*) self);
	_tmp50_ = _tmp49_;
	_tmp51_ = layout;
	gtk_container_add ((GtkContainer*) _tmp50_, (GtkWidget*) _tmp51_);
	_tmp52_ = self->priv->_crop_button;
	g_object_set ((GtkWidget*) _tmp52_, "has-default", TRUE, NULL);
	_tmp53_ = self->priv->_custom_width_entry;
	g_signal_connect_object ((GtkWidget*) _tmp53_, "focus-out-event", (GCallback) __editing_tools_crop_tool_crop_tool_window___lambda48__gtk_widget_focus_out_event, self, 0);
	_tmp54_ = self->priv->_custom_height_entry;
	g_signal_connect_object ((GtkWidget*) _tmp54_, "focus-out-event", (GCallback) __editing_tools_crop_tool_crop_tool_window___lambda49__gtk_widget_focus_out_event, self, 0);
	_g_object_unref0 (layout);
	_g_object_unref0 (response_sizegroup);
	_g_object_unref0 (custom_aspect_grid);
	_g_object_unref0 (combo_text_renderer);
	return obj;
}

static void
editing_tools_crop_tool_crop_tool_window_class_init (EditingToolsCropToolCropToolWindowClass * klass,
                                                     gpointer klass_data)
{
	editing_tools_crop_tool_crop_tool_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &EditingToolsCropToolCropToolWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_editing_tools_crop_tool_crop_tool_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_editing_tools_crop_tool_crop_tool_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = editing_tools_crop_tool_crop_tool_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = editing_tools_crop_tool_crop_tool_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CROP_BUTTON_PROPERTY, editing_tools_crop_tool_crop_tool_window_properties[EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CROP_BUTTON_PROPERTY] = g_param_spec_object ("crop-button", "crop-button", "crop-button", gtk_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CANCEL_BUTTON_PROPERTY, editing_tools_crop_tool_crop_tool_window_properties[EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CANCEL_BUTTON_PROPERTY] = g_param_spec_object ("cancel-button", "cancel-button", "cancel-button", gtk_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CONSTRAINT_COMBO_PROPERTY, editing_tools_crop_tool_crop_tool_window_properties[EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CONSTRAINT_COMBO_PROPERTY] = g_param_spec_object ("constraint-combo", "constraint-combo", "constraint-combo", gtk_combo_box_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_PIVOT_RETICLE_BUTTON_PROPERTY, editing_tools_crop_tool_crop_tool_window_properties[EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_PIVOT_RETICLE_BUTTON_PROPERTY] = g_param_spec_object ("pivot-reticle-button", "pivot-reticle-button", "pivot-reticle-button", gtk_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CUSTOM_WIDTH_ENTRY_PROPERTY, editing_tools_crop_tool_crop_tool_window_properties[EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CUSTOM_WIDTH_ENTRY_PROPERTY] = g_param_spec_object ("custom-width-entry", "custom-width-entry", "custom-width-entry", gtk_entry_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CUSTOM_HEIGHT_ENTRY_PROPERTY, editing_tools_crop_tool_crop_tool_window_properties[EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CUSTOM_HEIGHT_ENTRY_PROPERTY] = g_param_spec_object ("custom-height-entry", "custom-height-entry", "custom-height-entry", gtk_entry_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CUSTOM_ASPECT_REVEALER_PROPERTY, editing_tools_crop_tool_crop_tool_window_properties[EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CUSTOM_ASPECT_REVEALER_PROPERTY] = g_param_spec_object ("custom-aspect-revealer", "custom-aspect-revealer", "custom-aspect-revealer", gtk_revealer_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_MOST_RECENTLY_EDITED_PROPERTY, editing_tools_crop_tool_crop_tool_window_properties[EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_MOST_RECENTLY_EDITED_PROPERTY] = g_param_spec_object ("most-recently-edited", "most-recently-edited", "most-recently-edited", gtk_entry_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
editing_tools_crop_tool_crop_tool_window_instance_init (EditingToolsCropToolCropToolWindow * self,
                                                        gpointer klass)
{
	self->priv = editing_tools_crop_tool_crop_tool_window_get_instance_private (self);
	self->priv->_most_recently_edited = NULL;
}

static void
editing_tools_crop_tool_crop_tool_window_finalize (GObject * obj)
{
	EditingToolsCropToolCropToolWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EDITING_TOOLS_CROP_TOOL_TYPE_CROP_TOOL_WINDOW, EditingToolsCropToolCropToolWindow);
	_g_object_unref0 (self->priv->_crop_button);
	_g_object_unref0 (self->priv->_cancel_button);
	_g_object_unref0 (self->priv->_constraint_combo);
	_g_object_unref0 (self->priv->_pivot_reticle_button);
	_g_object_unref0 (self->priv->_custom_width_entry);
	_g_object_unref0 (self->priv->_custom_height_entry);
	_g_object_unref0 (self->priv->_custom_aspect_revealer);
	_g_object_unref0 (self->priv->_most_recently_edited);
	G_OBJECT_CLASS (editing_tools_crop_tool_crop_tool_window_parent_class)->finalize (obj);
}

static GType
editing_tools_crop_tool_crop_tool_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EditingToolsCropToolCropToolWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) editing_tools_crop_tool_crop_tool_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EditingToolsCropToolCropToolWindow), 0, (GInstanceInitFunc) editing_tools_crop_tool_crop_tool_window_instance_init, NULL };
	GType editing_tools_crop_tool_crop_tool_window_type_id;
	editing_tools_crop_tool_crop_tool_window_type_id = g_type_register_static (EDITING_TOOLS_TYPE_EDITING_TOOL_WINDOW, "EditingToolsCropToolCropToolWindow", &g_define_type_info, 0);
	EditingToolsCropToolCropToolWindow_private_offset = g_type_add_instance_private (editing_tools_crop_tool_crop_tool_window_type_id, sizeof (EditingToolsCropToolCropToolWindowPrivate));
	return editing_tools_crop_tool_crop_tool_window_type_id;
}

static GType
editing_tools_crop_tool_crop_tool_window_get_type (void)
{
	static volatile gsize editing_tools_crop_tool_crop_tool_window_type_id__once = 0;
	if (g_once_init_enter (&editing_tools_crop_tool_crop_tool_window_type_id__once)) {
		GType editing_tools_crop_tool_crop_tool_window_type_id;
		editing_tools_crop_tool_crop_tool_window_type_id = editing_tools_crop_tool_crop_tool_window_get_type_once ();
		g_once_init_leave (&editing_tools_crop_tool_crop_tool_window_type_id__once, editing_tools_crop_tool_crop_tool_window_type_id);
	}
	return editing_tools_crop_tool_crop_tool_window_type_id__once;
}

static void
_vala_editing_tools_crop_tool_crop_tool_window_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec)
{
	EditingToolsCropToolCropToolWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, EDITING_TOOLS_CROP_TOOL_TYPE_CROP_TOOL_WINDOW, EditingToolsCropToolCropToolWindow);
	switch (property_id) {
		case EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CROP_BUTTON_PROPERTY:
		g_value_set_object (value, editing_tools_crop_tool_crop_tool_window_get_crop_button (self));
		break;
		case EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CANCEL_BUTTON_PROPERTY:
		g_value_set_object (value, editing_tools_crop_tool_crop_tool_window_get_cancel_button (self));
		break;
		case EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CONSTRAINT_COMBO_PROPERTY:
		g_value_set_object (value, editing_tools_crop_tool_crop_tool_window_get_constraint_combo (self));
		break;
		case EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_PIVOT_RETICLE_BUTTON_PROPERTY:
		g_value_set_object (value, editing_tools_crop_tool_crop_tool_window_get_pivot_reticle_button (self));
		break;
		case EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CUSTOM_WIDTH_ENTRY_PROPERTY:
		g_value_set_object (value, editing_tools_crop_tool_crop_tool_window_get_custom_width_entry (self));
		break;
		case EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CUSTOM_HEIGHT_ENTRY_PROPERTY:
		g_value_set_object (value, editing_tools_crop_tool_crop_tool_window_get_custom_height_entry (self));
		break;
		case EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CUSTOM_ASPECT_REVEALER_PROPERTY:
		g_value_set_object (value, editing_tools_crop_tool_crop_tool_window_get_custom_aspect_revealer (self));
		break;
		case EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_MOST_RECENTLY_EDITED_PROPERTY:
		g_value_set_object (value, editing_tools_crop_tool_crop_tool_window_get_most_recently_edited (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_editing_tools_crop_tool_crop_tool_window_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec)
{
	EditingToolsCropToolCropToolWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, EDITING_TOOLS_CROP_TOOL_TYPE_CROP_TOOL_WINDOW, EditingToolsCropToolCropToolWindow);
	switch (property_id) {
		case EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CROP_BUTTON_PROPERTY:
		editing_tools_crop_tool_crop_tool_window_set_crop_button (self, g_value_get_object (value));
		break;
		case EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CANCEL_BUTTON_PROPERTY:
		editing_tools_crop_tool_crop_tool_window_set_cancel_button (self, g_value_get_object (value));
		break;
		case EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CONSTRAINT_COMBO_PROPERTY:
		editing_tools_crop_tool_crop_tool_window_set_constraint_combo (self, g_value_get_object (value));
		break;
		case EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_PIVOT_RETICLE_BUTTON_PROPERTY:
		editing_tools_crop_tool_crop_tool_window_set_pivot_reticle_button (self, g_value_get_object (value));
		break;
		case EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CUSTOM_WIDTH_ENTRY_PROPERTY:
		editing_tools_crop_tool_crop_tool_window_set_custom_width_entry (self, g_value_get_object (value));
		break;
		case EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CUSTOM_HEIGHT_ENTRY_PROPERTY:
		editing_tools_crop_tool_crop_tool_window_set_custom_height_entry (self, g_value_get_object (value));
		break;
		case EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_CUSTOM_ASPECT_REVEALER_PROPERTY:
		editing_tools_crop_tool_crop_tool_window_set_custom_aspect_revealer (self, g_value_get_object (value));
		break;
		case EDITING_TOOLS_CROP_TOOL_CROP_TOOL_WINDOW_MOST_RECENTLY_EDITED_PROPERTY:
		editing_tools_crop_tool_crop_tool_window_set_most_recently_edited (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GObject *
editing_tools_crop_tool_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	EditingToolsCropTool * self;
	GSettings* _tmp0_;
	parent_class = G_OBJECT_CLASS (editing_tools_crop_tool_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EDITING_TOOLS_TYPE_CROP_TOOL, EditingToolsCropTool);
	_tmp0_ = g_settings_new (GSETTINGS_CONFIGURATION_ENGINE_CROP_SCHEMA_NAME);
	_g_object_unref0 (self->priv->crop_settings);
	self->priv->crop_settings = _tmp0_;
	return obj;
}

static void
editing_tools_crop_tool_class_init (EditingToolsCropToolClass * klass,
                                    gpointer klass_data)
{
	editing_tools_crop_tool_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &EditingToolsCropTool_private_offset);
	((EditingToolsEditingToolClass *) klass)->activate = (void (*) (EditingToolsEditingTool*, EditingToolsPhotoCanvas*)) editing_tools_crop_tool_real_activate;
	((EditingToolsEditingToolClass *) klass)->deactivate = (void (*) (EditingToolsEditingTool*)) editing_tools_crop_tool_real_deactivate;
	((EditingToolsEditingToolClass *) klass)->get_tool_window = (EditingToolsEditingToolWindow* (*) (EditingToolsEditingTool*)) editing_tools_crop_tool_real_get_tool_window;
	((EditingToolsEditingToolClass *) klass)->get_display_pixbuf = (GdkPixbuf* (*) (EditingToolsEditingTool*, Scaling*, Photo*, Dimensions*, GError**)) editing_tools_crop_tool_real_get_display_pixbuf;
	((EditingToolsEditingToolClass *) klass)->on_left_click = (void (*) (EditingToolsEditingTool*, gint, gint)) editing_tools_crop_tool_real_on_left_click;
	((EditingToolsEditingToolClass *) klass)->on_left_released = (void (*) (EditingToolsEditingTool*, gint, gint)) editing_tools_crop_tool_real_on_left_released;
	((EditingToolsEditingToolClass *) klass)->on_motion = (void (*) (EditingToolsEditingTool*, gint, gint, GdkModifierType)) editing_tools_crop_tool_real_on_motion;
	((EditingToolsEditingToolClass *) klass)->paint = (void (*) (EditingToolsEditingTool*, cairo_t*)) editing_tools_crop_tool_real_paint;
	G_OBJECT_CLASS (klass)->constructor = editing_tools_crop_tool_constructor;
	G_OBJECT_CLASS (klass)->finalize = editing_tools_crop_tool_finalize;
}

static void
editing_tools_crop_tool_instance_init (EditingToolsCropTool * self,
                                       gpointer klass)
{
	gint _tmp0_ = 0;
	EditingToolsCropToolConstraintDescription** _tmp1_;
	gint _tmp2_ = 0;
	EditingToolsCropToolConstraintDescription** _tmp3_;
	EditingToolsCropToolConstraintDescription** _tmp4_;
	gint _tmp4__length1;
	GtkListStore* _tmp5_;
	self->priv = editing_tools_crop_tool_get_instance_private (self);
	self->priv->crop_tool_window = NULL;
	self->priv->current_cursor_type = GDK_LEFT_PTR;
	self->priv->in_manipulation = BOX_LOCATION_OUTSIDE;
	self->priv->wide_black_ctx = NULL;
	self->priv->wide_white_ctx = NULL;
	self->priv->thin_white_ctx = NULL;
	self->priv->text_ctx = NULL;
	self->priv->crop_surface = NULL;
	self->priv->last_grab_x = -1;
	self->priv->last_grab_y = -1;
	_tmp1_ = editing_tools_crop_tool_create_constraints (&_tmp0_);
	self->priv->constraints = _tmp1_;
	self->priv->constraints_length1 = _tmp0_;
	self->priv->_constraints_size_ = self->priv->constraints_length1;
	_tmp3_ = editing_tools_crop_tool_create_constraints (&_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	_tmp5_ = editing_tools_crop_tool_create_constraint_list (_tmp4_, (gint) _tmp2_);
	self->priv->constraint_list = _tmp5_;
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->reticle_orientation = EDITING_TOOLS_CROP_TOOL_RETICLE_ORIENTATION_LANDSCAPE;
	self->priv->constraint_mode = EDITING_TOOLS_CROP_TOOL_CONSTRAINT_MODE_NORMAL;
	self->priv->entry_insert_in_progress = FALSE;
	self->priv->custom_aspect_ratio = 1.0f;
	self->priv->custom_width = -1;
	self->priv->custom_height = -1;
	self->priv->custom_init_width = -1;
	self->priv->custom_init_height = -1;
	self->priv->scale_factor = 1;
	self->priv->pre_aspect_ratio = EDITING_TOOLS_CROP_TOOL_ANY_ASPECT_RATIO;
}

static void
editing_tools_crop_tool_finalize (GObject * obj)
{
	EditingToolsCropTool * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EDITING_TOOLS_TYPE_CROP_TOOL, EditingToolsCropTool);
	_g_object_unref0 (self->priv->crop_tool_window);
	_cairo_destroy0 (self->priv->wide_black_ctx);
	_cairo_destroy0 (self->priv->wide_white_ctx);
	_cairo_destroy0 (self->priv->thin_white_ctx);
	_cairo_destroy0 (self->priv->text_ctx);
	_cairo_surface_destroy0 (self->priv->crop_surface);
	self->priv->constraints = (_vala_array_free (self->priv->constraints, self->priv->constraints_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->constraint_list);
	_g_object_unref0 (self->priv->crop_settings);
	G_OBJECT_CLASS (editing_tools_crop_tool_parent_class)->finalize (obj);
}

static GType
editing_tools_crop_tool_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EditingToolsCropToolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) editing_tools_crop_tool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EditingToolsCropTool), 0, (GInstanceInitFunc) editing_tools_crop_tool_instance_init, NULL };
	GType editing_tools_crop_tool_type_id;
	editing_tools_crop_tool_type_id = g_type_register_static (EDITING_TOOLS_TYPE_EDITING_TOOL, "EditingToolsCropTool", &g_define_type_info, 0);
	EditingToolsCropTool_private_offset = g_type_add_instance_private (editing_tools_crop_tool_type_id, sizeof (EditingToolsCropToolPrivate));
	return editing_tools_crop_tool_type_id;
}

GType
editing_tools_crop_tool_get_type (void)
{
	static volatile gsize editing_tools_crop_tool_type_id__once = 0;
	if (g_once_init_enter (&editing_tools_crop_tool_type_id__once)) {
		GType editing_tools_crop_tool_type_id;
		editing_tools_crop_tool_type_id = editing_tools_crop_tool_get_type_once ();
		g_once_init_leave (&editing_tools_crop_tool_type_id__once, editing_tools_crop_tool_type_id);
	}
	return editing_tools_crop_tool_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

