/* SaveDialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SaveDialog.vala, do not modify */

/*
* Copyright (c) 2014–2016 Fabio Zaramella <ffabio.96.x@gmail.com>
*               2017–2022 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License version 3 as published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Artem Anufrij <artem.anufrij@live.de>
*              Fabio Zaramella <ffabio.96.x@gmail.com>
*/

#include <granite-7.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>

#define SCREENSHOT_APPLICATION_SAVE_FOLDER _ ("Screenshots")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SCREENSHOT_TYPE_SAVE_DIALOG (screenshot_save_dialog_get_type ())
#define SCREENSHOT_SAVE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCREENSHOT_TYPE_SAVE_DIALOG, ScreenshotSaveDialog))
#define SCREENSHOT_SAVE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCREENSHOT_TYPE_SAVE_DIALOG, ScreenshotSaveDialogClass))
#define SCREENSHOT_IS_SAVE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCREENSHOT_TYPE_SAVE_DIALOG))
#define SCREENSHOT_IS_SAVE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCREENSHOT_TYPE_SAVE_DIALOG))
#define SCREENSHOT_SAVE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCREENSHOT_TYPE_SAVE_DIALOG, ScreenshotSaveDialogClass))

typedef struct _ScreenshotSaveDialog ScreenshotSaveDialog;
typedef struct _ScreenshotSaveDialogClass ScreenshotSaveDialogClass;
typedef struct _ScreenshotSaveDialogPrivate ScreenshotSaveDialogPrivate;
enum  {
	SCREENSHOT_SAVE_DIALOG_0_PROPERTY,
	SCREENSHOT_SAVE_DIALOG_PIXBUF_PROPERTY,
	SCREENSHOT_SAVE_DIALOG_SETTINGS_PROPERTY,
	SCREENSHOT_SAVE_DIALOG_NUM_PROPERTIES
};
static GParamSpec* screenshot_save_dialog_properties[SCREENSHOT_SAVE_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	SCREENSHOT_SAVE_DIALOG_SAVE_RESPONSE_SIGNAL,
	SCREENSHOT_SAVE_DIALOG_NUM_SIGNALS
};
static guint screenshot_save_dialog_signals[SCREENSHOT_SAVE_DIALOG_NUM_SIGNALS] = {0};

struct _ScreenshotSaveDialog {
	GraniteDialog parent_instance;
	ScreenshotSaveDialogPrivate * priv;
};

struct _ScreenshotSaveDialogClass {
	GraniteDialogClass parent_class;
};

struct _ScreenshotSaveDialogPrivate {
	GdkPixbuf* _pixbuf;
	GSettings* _settings;
	GtkLabel* folder_name;
	GtkImage* folder_image;
};

struct _Block2Data {
	int _ref_count_;
	ScreenshotSaveDialog* self;
	GdkClipboard* clipboard;
	GdkTexture* texture;
};

struct _Block3Data {
	int _ref_count_;
	ScreenshotSaveDialog* self;
	gchar* folder_dir;
	gchar* file_name;
	GraniteValidatedEntry* name_entry;
	GtkLabel* validation_label;
	GtkRevealer* name_message_revealer;
	GtkComboBoxText* format_cmb;
	GtkButton* save_btn;
};

struct _Block4Data {
	int _ref_count_;
	Block3Data * _data3_;
	GtkFileDialog* location_dialog;
};

static gint ScreenshotSaveDialog_private_offset;
static gpointer screenshot_save_dialog_parent_class = NULL;

VALA_EXTERN GType screenshot_save_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScreenshotSaveDialog, g_object_unref)
VALA_EXTERN ScreenshotSaveDialog* screenshot_save_dialog_new (GdkPixbuf* pixbuf,
                                                  GSettings* settings);
VALA_EXTERN ScreenshotSaveDialog* screenshot_save_dialog_construct (GType object_type,
                                                        GdkPixbuf* pixbuf,
                                                        GSettings* settings);
static void screenshot_save_dialog_update_location_button (ScreenshotSaveDialog* self,
                                                    const gchar* folder_dir);
static void screenshot_save_dialog_on_clipboard_changed (ScreenshotSaveDialog* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
VALA_EXTERN GdkPixbuf* screenshot_save_dialog_get_pixbuf (ScreenshotSaveDialog* self);
static void __lambda6_ (Block2Data* _data2_,
                 GObject* obj,
                 GAsyncResult* res);
VALA_EXTERN void screenshot_save_dialog_hide_destroy (ScreenshotSaveDialog* self);
static void ___lambda6__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void __lambda7_ (ScreenshotSaveDialog* self);
static void ___lambda7__gsource_once_func (gpointer self);
static void screenshot_save_dialog_set_pixbuf (ScreenshotSaveDialog* self,
                                        GdkPixbuf* value);
VALA_EXTERN GSettings* screenshot_save_dialog_get_settings (ScreenshotSaveDialog* self);
static void screenshot_save_dialog_set_settings (ScreenshotSaveDialog* self,
                                          GSettings* value);
static void g_cclosure_user_marshal_VOID__BOOLEAN_STRING_STRING_STRING (GClosure * closure,
                                                                 GValue * return_value,
                                                                 guint n_param_values,
                                                                 const GValue * param_values,
                                                                 gpointer invocation_hint,
                                                                 gpointer marshal_data);
static GObject * screenshot_save_dialog_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
VALA_EXTERN void screenshot_application_create_dir_if_missing (const gchar* path);
static void _screenshot_save_dialog___lambda8_ (Block3Data* _data3_);
static void __screenshot_save_dialog___lambda8__gtk_editable_changed (GtkEditable* _sender,
                                                               gpointer self);
static void _screenshot_save_dialog___lambda9_ (Block3Data* _data3_);
static void __screenshot_save_dialog___lambda9__gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self);
static void _screenshot_save_dialog___lambda10_ (ScreenshotSaveDialog* self);
static void _screenshot_save_dialog_on_clipboard_changed_gdk_clipboard_changed (GdkClipboard* _sender,
                                                                         gpointer self);
static void __screenshot_save_dialog___lambda10__gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self);
static void _screenshot_save_dialog___lambda11_ (Block3Data* _data3_);
static void __screenshot_save_dialog___lambda11__gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self);
static void _screenshot_save_dialog___lambda12_ (Block3Data* _data3_);
static void __screenshot_save_dialog___lambda12__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                 gpointer self);
static void _screenshot_save_dialog___lambda13_ (Block3Data* _data3_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda14_ (Block4Data* _data4_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda14__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void __screenshot_save_dialog___lambda13__gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self);
static void screenshot_save_dialog_finalize (GObject * obj);
static GType screenshot_save_dialog_get_type_once (void);
static void _vala_screenshot_save_dialog_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_screenshot_save_dialog_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
screenshot_save_dialog_get_instance_private (ScreenshotSaveDialog* self)
{
	return G_STRUCT_MEMBER_P (self, ScreenshotSaveDialog_private_offset);
}

ScreenshotSaveDialog*
screenshot_save_dialog_construct (GType object_type,
                                  GdkPixbuf* pixbuf,
                                  GSettings* settings)
{
	ScreenshotSaveDialog * self = NULL;
	g_return_val_if_fail (pixbuf != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	self = (ScreenshotSaveDialog*) g_object_new (object_type, "deletable", FALSE, "modal", TRUE, "pixbuf", pixbuf, "settings", settings, "title", _ ("Screenshot"), NULL);
	return self;
}

ScreenshotSaveDialog*
screenshot_save_dialog_new (GdkPixbuf* pixbuf,
                            GSettings* settings)
{
	return screenshot_save_dialog_construct (SCREENSHOT_TYPE_SAVE_DIALOG, pixbuf, settings);
}

static void
screenshot_save_dialog_update_location_button (ScreenshotSaveDialog* self,
                                               const gchar* folder_dir)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (folder_dir != NULL);
	_tmp0_ = g_file_new_for_path (folder_dir);
	file = _tmp0_;
	{
		GFileInfo* info = NULL;
		GFileInfo* _tmp1_;
		GtkLabel* _tmp2_;
		const gchar* _tmp3_;
		GtkImage* _tmp4_;
		GIcon* _tmp5_;
		_tmp1_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME "," G_FILE_ATTRIBUTE_STANDARD_ICON, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		info = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = self->priv->folder_name;
		_tmp3_ = g_file_info_get_display_name (info);
		gtk_label_set_label (_tmp2_, _tmp3_);
		_tmp4_ = self->priv->folder_image;
		_tmp5_ = g_file_info_get_icon (info);
		g_object_set (_tmp4_, "gicon", _tmp5_, NULL);
		_g_object_unref0 (info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GtkLabel* _tmp6_;
		GtkImage* _tmp7_;
		GThemedIcon* _tmp8_;
		GThemedIcon* _tmp9_;
		g_clear_error (&_inner_error0_);
		_tmp6_ = self->priv->folder_name;
		gtk_label_set_label (_tmp6_, folder_dir);
		_tmp7_ = self->priv->folder_image;
		_tmp8_ = (GThemedIcon*) g_themed_icon_new ("folder");
		_tmp9_ = _tmp8_;
		g_object_set (_tmp7_, "gicon", (GIcon*) _tmp9_, NULL);
		_g_object_unref0 (_tmp9_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ScreenshotSaveDialog* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->texture);
		_g_object_unref0 (_data2_->clipboard);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda6_ (Block2Data* _data2_,
            GObject* obj,
            GAsyncResult* res)
{
	ScreenshotSaveDialog* self;
	GdkTexture* _texture = NULL;
	GdkTexture* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GError* _inner_error0_ = NULL;
	self = _data2_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = gdk_clipboard_read_texture_finish (_data2_->clipboard, res, &_inner_error0_);
	_texture = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (_texture != NULL) {
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp3_ = gdk_texture_get_height (_texture);
		_tmp4_ = _tmp3_;
		_tmp5_ = gdk_texture_get_height (_data2_->texture);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp4_ == _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp7_ = gdk_texture_get_width (_texture);
		_tmp8_ = _tmp7_;
		_tmp9_ = gdk_texture_get_width (_data2_->texture);
		_tmp10_ = _tmp9_;
		_tmp1_ = _tmp8_ == _tmp10_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		screenshot_save_dialog_hide_destroy (self);
	}
	_g_object_unref0 (_texture);
}

static void
___lambda6__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda6_ (self, source_object, res);
	block2_data_unref (self);
}

static void
screenshot_save_dialog_on_clipboard_changed (ScreenshotSaveDialog* self)
{
	Block2Data* _data2_;
	GdkDisplay* _tmp0_;
	GdkClipboard* _tmp1_;
	GdkClipboard* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkTexture* _tmp4_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gdk_display_get_clipboard (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data2_->clipboard = _tmp2_;
	_tmp3_ = self->priv->_pixbuf;
	_tmp4_ = gdk_texture_new_for_pixbuf (_tmp3_);
	_data2_->texture = _tmp4_;
	gdk_clipboard_read_texture_async (_data2_->clipboard, NULL, ___lambda6__gasync_ready_callback, block2_data_ref (_data2_));
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
__lambda7_ (ScreenshotSaveDialog* self)
{
	g_signal_emit_by_name ((GtkDialog*) self, "close");
}

static void
___lambda7__gsource_once_func (gpointer self)
{
	__lambda7_ ((ScreenshotSaveDialog*) self);
}

void
screenshot_save_dialog_hide_destroy (ScreenshotSaveDialog* self)
{
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	g_timeout_add_once ((guint) 500, ___lambda7__gsource_once_func, self);
}

GdkPixbuf*
screenshot_save_dialog_get_pixbuf (ScreenshotSaveDialog* self)
{
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pixbuf;
	result = _tmp0_;
	return result;
}

static void
screenshot_save_dialog_set_pixbuf (ScreenshotSaveDialog* self,
                                   GdkPixbuf* value)
{
	GdkPixbuf* old_value;
	g_return_if_fail (self != NULL);
	old_value = screenshot_save_dialog_get_pixbuf (self);
	if (old_value != value) {
		GdkPixbuf* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_pixbuf);
		self->priv->_pixbuf = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, screenshot_save_dialog_properties[SCREENSHOT_SAVE_DIALOG_PIXBUF_PROPERTY]);
	}
}

GSettings*
screenshot_save_dialog_get_settings (ScreenshotSaveDialog* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}

static void
screenshot_save_dialog_set_settings (ScreenshotSaveDialog* self,
                                     GSettings* value)
{
	GSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = screenshot_save_dialog_get_settings (self);
	if (old_value != value) {
		GSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, screenshot_save_dialog_properties[SCREENSHOT_SAVE_DIALOG_SETTINGS_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__BOOLEAN_STRING_STRING_STRING (GClosure * closure,
                                                            GValue * return_value,
                                                            guint n_param_values,
                                                            const GValue * param_values,
                                                            gpointer invocation_hint,
                                                            gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__BOOLEAN_STRING_STRING_STRING) (gpointer data1, gboolean arg_1, const char* arg_2, const char* arg_3, const char* arg_4, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_STRING_STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_STRING_STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), g_value_get_string (param_values + 4), data2);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		ScreenshotSaveDialog* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->save_btn);
		_g_object_unref0 (_data3_->format_cmb);
		_g_object_unref0 (_data3_->name_message_revealer);
		_g_object_unref0 (_data3_->validation_label);
		_g_object_unref0 (_data3_->name_entry);
		_g_free0 (_data3_->file_name);
		_g_free0 (_data3_->folder_dir);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
_screenshot_save_dialog___lambda8_ (Block3Data* _data3_)
{
	ScreenshotSaveDialog* self;
	GraniteValidatedEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GtkRevealer* _tmp13_;
	GraniteValidatedEntry* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	GtkButton* _tmp17_;
	GraniteValidatedEntry* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	self = _data3_->self;
	_tmp0_ = _data3_->name_entry;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		GtkLabel* _tmp5_;
		GraniteValidatedEntry* _tmp6_;
		_tmp5_ = _data3_->validation_label;
		gtk_label_set_label (_tmp5_, _ ("Filename can't be blank"));
		_tmp6_ = _data3_->name_entry;
		granite_validated_entry_set_is_valid (_tmp6_, FALSE);
	} else {
		GraniteValidatedEntry* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp7_ = _data3_->name_entry;
		_tmp8_ = gtk_editable_get_text ((GtkEditable*) _tmp7_);
		_tmp9_ = _tmp8_;
		if (string_contains (_tmp9_, "/")) {
			GtkLabel* _tmp10_;
			GraniteValidatedEntry* _tmp11_;
			_tmp10_ = _data3_->validation_label;
			gtk_label_set_label (_tmp10_, _ ("Filename can't contain “/”"));
			_tmp11_ = _data3_->name_entry;
			granite_validated_entry_set_is_valid (_tmp11_, FALSE);
		} else {
			GraniteValidatedEntry* _tmp12_;
			_tmp12_ = _data3_->name_entry;
			granite_validated_entry_set_is_valid (_tmp12_, TRUE);
		}
	}
	_tmp13_ = _data3_->name_message_revealer;
	_tmp14_ = _data3_->name_entry;
	_tmp15_ = granite_validated_entry_get_is_valid (_tmp14_);
	_tmp16_ = _tmp15_;
	gtk_revealer_set_reveal_child (_tmp13_, !_tmp16_);
	_tmp17_ = _data3_->save_btn;
	_tmp18_ = _data3_->name_entry;
	_tmp19_ = granite_validated_entry_get_is_valid (_tmp18_);
	_tmp20_ = _tmp19_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp17_, _tmp20_);
}

static void
__screenshot_save_dialog___lambda8__gtk_editable_changed (GtkEditable* _sender,
                                                          gpointer self)
{
	_screenshot_save_dialog___lambda8_ (self);
}

static void
_screenshot_save_dialog___lambda9_ (Block3Data* _data3_)
{
	ScreenshotSaveDialog* self;
	const gchar* _tmp0_;
	GraniteValidatedEntry* _tmp1_;
	const gchar* _tmp2_;
	GtkComboBoxText* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self = _data3_->self;
	_tmp0_ = _data3_->folder_dir;
	_tmp1_ = _data3_->name_entry;
	_tmp2_ = gtk_editable_get_text ((GtkEditable*) _tmp1_);
	_tmp3_ = _data3_->format_cmb;
	_tmp4_ = gtk_combo_box_text_get_active_text (_tmp3_);
	_tmp5_ = _tmp4_;
	g_signal_emit (self, screenshot_save_dialog_signals[SCREENSHOT_SAVE_DIALOG_SAVE_RESPONSE_SIGNAL], 0, TRUE, _tmp0_, _tmp2_, _tmp5_);
	_g_free0 (_tmp5_);
}

static void
__screenshot_save_dialog___lambda9__gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self)
{
	_screenshot_save_dialog___lambda9_ (self);
}

static void
_screenshot_save_dialog_on_clipboard_changed_gdk_clipboard_changed (GdkClipboard* _sender,
                                                                    gpointer self)
{
	screenshot_save_dialog_on_clipboard_changed ((ScreenshotSaveDialog*) self);
}

static void
_screenshot_save_dialog___lambda10_ (ScreenshotSaveDialog* self)
{
	GdkClipboard* clipboard = NULL;
	GdkDisplay* _tmp0_;
	GdkClipboard* _tmp1_;
	GdkClipboard* _tmp2_;
	GdkClipboard* _tmp3_;
	GdkClipboard* _tmp4_;
	GdkPixbuf* _tmp5_;
	GdkTexture* _tmp6_;
	GdkTexture* _tmp7_;
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gdk_display_get_clipboard (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	clipboard = _tmp2_;
	_tmp3_ = clipboard;
	g_signal_connect_object (_tmp3_, "changed", (GCallback) _screenshot_save_dialog_on_clipboard_changed_gdk_clipboard_changed, self, 0);
	_tmp4_ = clipboard;
	_tmp5_ = self->priv->_pixbuf;
	_tmp6_ = gdk_texture_new_for_pixbuf (_tmp5_);
	_tmp7_ = _tmp6_;
	gdk_clipboard_set_texture (_tmp4_, _tmp7_);
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (clipboard);
}

static void
__screenshot_save_dialog___lambda10__gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self)
{
	_screenshot_save_dialog___lambda10_ ((ScreenshotSaveDialog*) self);
}

static void
_screenshot_save_dialog___lambda11_ (Block3Data* _data3_)
{
	ScreenshotSaveDialog* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GtkComboBoxText* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	self = _data3_->self;
	_tmp0_ = _data3_->folder_dir;
	_tmp1_ = _data3_->file_name;
	_tmp2_ = _data3_->format_cmb;
	_tmp3_ = gtk_combo_box_text_get_active_text (_tmp2_);
	_tmp4_ = _tmp3_;
	g_signal_emit (self, screenshot_save_dialog_signals[SCREENSHOT_SAVE_DIALOG_SAVE_RESPONSE_SIGNAL], 0, FALSE, _tmp0_, _tmp1_, _tmp4_);
	_g_free0 (_tmp4_);
}

static void
__screenshot_save_dialog___lambda11__gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self)
{
	_screenshot_save_dialog___lambda11_ (self);
}

static void
_screenshot_save_dialog___lambda12_ (Block3Data* _data3_)
{
	ScreenshotSaveDialog* self;
	GSettings* _tmp0_;
	GtkComboBoxText* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self = _data3_->self;
	_tmp0_ = self->priv->_settings;
	_tmp1_ = _data3_->format_cmb;
	_tmp2_ = gtk_combo_box_text_get_active_text (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_string (_tmp0_, "format", _tmp3_);
	_g_free0 (_tmp3_);
}

static void
__screenshot_save_dialog___lambda12__gtk_combo_box_changed (GtkComboBox* _sender,
                                                            gpointer self)
{
	_screenshot_save_dialog___lambda12_ (self);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		ScreenshotSaveDialog* self;
		self = _data4_->_data3_->self;
		_g_object_unref0 (_data4_->location_dialog);
		block3_data_unref (_data4_->_data3_);
		_data4_->_data3_ = NULL;
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda14_ (Block4Data* _data4_,
             GObject* obj,
             GAsyncResult* res)
{
	Block3Data* _data3_;
	ScreenshotSaveDialog* self;
	GError* _inner_error0_ = NULL;
	_data3_ = _data4_->_data3_;
	self = _data3_->self;
	g_return_if_fail (res != NULL);
	{
		GFile* folder = NULL;
		GtkFileDialog* _tmp0_;
		GFile* _tmp1_;
		GFile* _tmp2_;
		gchar* _tmp3_;
		GSettings* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp0_ = _data4_->location_dialog;
		_tmp1_ = gtk_file_dialog_select_folder_finish (_tmp0_, res, &_inner_error0_);
		folder = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = folder;
		_tmp3_ = g_file_get_path (_tmp2_);
		_g_free0 (_data3_->folder_dir);
		_data3_->folder_dir = _tmp3_;
		_tmp4_ = self->priv->_settings;
		_tmp5_ = _data3_->folder_dir;
		g_settings_set_string (_tmp4_, "folder-dir", _tmp5_);
		_tmp6_ = _data3_->folder_dir;
		screenshot_save_dialog_update_location_button (self, _tmp6_);
		_g_object_unref0 (folder);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = err;
		_tmp8_ = _tmp7_->message;
		g_warning ("SaveDialog.vala:233: Failed to select screenshots folder: %s", _tmp8_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda14__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda14_ (self, source_object, res);
	block4_data_unref (self);
}

static void
_screenshot_save_dialog___lambda13_ (Block3Data* _data3_)
{
	ScreenshotSaveDialog* self;
	Block4Data* _data4_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GtkFileDialog* _tmp4_ = NULL;
	GtkFileDialog* _tmp5_;
	self = _data3_->self;
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->_data3_ = block3_data_ref (_data3_);
	_tmp0_ = g_strdup (_ ("Select Screenshots Folder…"));
	_tmp1_ = g_strdup (_ ("Select"));
	_tmp2_ = _data3_->folder_dir;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	_tmp4_ = gtk_file_dialog_new ();
	gtk_file_dialog_set_title (_tmp4_, _tmp0_);
	_g_free0 (_tmp0_);
	gtk_file_dialog_set_accept_label (_tmp4_, _tmp1_);
	_g_free0 (_tmp1_);
	gtk_file_dialog_set_initial_folder (_tmp4_, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_data4_->location_dialog = _tmp4_;
	_tmp5_ = _data4_->location_dialog;
	gtk_file_dialog_select_folder (_tmp5_, (GtkWindow*) self, NULL, ___lambda14__gasync_ready_callback, block4_data_ref (_data4_));
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
__screenshot_save_dialog___lambda13__gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self)
{
	_screenshot_save_dialog___lambda13_ (self);
}

static GObject *
screenshot_save_dialog_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScreenshotSaveDialog * self;
	Block3Data* _data3_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* folder_from_settings = NULL;
	GSettings* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp15_;
	GtkDragSource* drag_source = NULL;
	GdkPixbuf* _tmp16_;
	GValue _tmp17_ = {0};
	GdkContentProvider* _tmp18_;
	GtkDragSource* _tmp19_ = NULL;
	GtkDragSource* _tmp20_;
	GtkDragSource* _tmp21_;
	GdkDisplay* _tmp22_;
	GtkIconTheme* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GtkIconPaintable* _tmp26_;
	GtkIconPaintable* _tmp27_;
	GtkPicture* preview = NULL;
	GdkPixbuf* _tmp28_;
	GdkTexture* _tmp29_;
	GdkTexture* _tmp30_;
	GtkPicture* _tmp31_ = NULL;
	GtkPicture* _tmp32_;
	GtkPicture* _tmp33_;
	GtkPicture* _tmp34_;
	GtkPicture* _tmp35_;
	GtkPicture* _tmp36_;
	GtkDragSource* _tmp37_;
	GtkEventController* _tmp38_;
	GraniteHeaderLabel* dialog_label = NULL;
	GraniteHeaderLabel* _tmp39_;
	gchar* date_time = NULL;
	GDateTime* _tmp40_;
	GDateTime* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	GraniteHeaderLabel* name_label = NULL;
	GraniteHeaderLabel* _tmp54_;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	GraniteValidatedEntry* _tmp57_ = NULL;
	GraniteValidatedEntry* _tmp58_;
	GtkLabel* _tmp59_ = NULL;
	GtkLabel* _tmp60_;
	GtkLabel* _tmp61_;
	GtkLabel* _tmp62_;
	GtkWidget* _tmp63_;
	GtkRevealer* _tmp64_ = NULL;
	GraniteHeaderLabel* format_label = NULL;
	GraniteHeaderLabel* _tmp65_;
	GtkComboBoxText* _tmp66_;
	GtkComboBoxText* _tmp67_;
	GtkComboBoxText* _tmp68_;
	GtkComboBoxText* _tmp69_;
	GtkComboBoxText* _tmp70_;
	GSettings* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	GQuark _tmp75_ = 0U;
	static GQuark _tmp74_label0 = 0;
	static GQuark _tmp74_label1 = 0;
	static GQuark _tmp74_label2 = 0;
	static GQuark _tmp74_label3 = 0;
	GraniteHeaderLabel* location_label = NULL;
	GraniteHeaderLabel* _tmp80_ = NULL;
	GtkLabel* _tmp81_ = NULL;
	GtkImage* _tmp82_;
	const gchar* _tmp83_;
	GtkImage* arrow = NULL;
	GtkImage* _tmp84_;
	GtkBox* location_button_indicator = NULL;
	GtkBox* _tmp85_;
	GtkBox* _tmp86_;
	GtkImage* _tmp87_;
	GtkBox* _tmp88_;
	GtkLabel* _tmp89_;
	GtkBox* _tmp90_;
	GtkImage* _tmp91_;
	GtkButton* location_button = NULL;
	GtkBox* _tmp92_;
	GtkWidget* _tmp93_;
	GtkButton* _tmp94_ = NULL;
	GtkBox* content = NULL;
	GtkBox* _tmp95_;
	GtkBox* _tmp96_;
	GtkBox* _tmp97_;
	GraniteHeaderLabel* _tmp98_;
	GtkBox* _tmp99_;
	GtkPicture* _tmp100_;
	GtkBox* _tmp101_;
	GraniteHeaderLabel* _tmp102_;
	GtkBox* _tmp103_;
	GraniteValidatedEntry* _tmp104_;
	GtkBox* _tmp105_;
	GtkRevealer* _tmp106_;
	GtkBox* _tmp107_;
	GraniteHeaderLabel* _tmp108_;
	GtkBox* _tmp109_;
	GtkComboBoxText* _tmp110_;
	GtkBox* _tmp111_;
	GraniteHeaderLabel* _tmp112_;
	GtkBox* _tmp113_;
	GtkButton* _tmp114_;
	GtkButton* clipboard_btn = NULL;
	GtkWidget* _tmp115_;
	GtkButton* _tmp116_;
	GtkButton* retry_btn = NULL;
	GtkWidget* _tmp117_;
	GtkButton* _tmp118_;
	GtkWidget* _tmp119_;
	GtkButton* _tmp120_;
	GtkButton* _tmp121_;
	GtkButton* _tmp122_;
	GraniteValidatedEntry* _tmp123_;
	GtkButton* _tmp124_;
	GtkButton* _tmp125_;
	GtkButton* _tmp126_;
	GtkComboBoxText* _tmp127_;
	GtkButton* _tmp128_;
	parent_class = G_OBJECT_CLASS (screenshot_save_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCREENSHOT_TYPE_SAVE_DIALOG, ScreenshotSaveDialog);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
	_tmp1_ = g_strdup_printf ("%c", (gint) G_DIR_SEPARATOR);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp0_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, SCREENSHOT_APPLICATION_SAVE_FOLDER, NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_data3_->folder_dir = _tmp6_;
	_tmp7_ = self->priv->_settings;
	_tmp8_ = g_settings_get_string (_tmp7_, "folder-dir");
	folder_from_settings = _tmp8_;
	_tmp10_ = folder_from_settings;
	_tmp11_ = _data3_->folder_dir;
	if (g_strcmp0 (_tmp10_, _tmp11_) != 0) {
		const gchar* _tmp12_;
		_tmp12_ = folder_from_settings;
		_tmp9_ = g_strcmp0 (_tmp12_, "") != 0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp13_ = folder_from_settings;
		_tmp14_ = g_strdup (_tmp13_);
		_g_free0 (_data3_->folder_dir);
		_data3_->folder_dir = _tmp14_;
	}
	_tmp15_ = _data3_->folder_dir;
	screenshot_application_create_dir_if_missing (_tmp15_);
	_tmp16_ = self->priv->_pixbuf;
	g_value_init (&_tmp17_, gdk_pixbuf_get_type ());
	g_value_set_object (&_tmp17_, _tmp16_);
	_tmp18_ = gdk_content_provider_new_for_value (&_tmp17_);
	_tmp19_ = gtk_drag_source_new ();
	gtk_drag_source_set_actions (_tmp19_, GDK_ACTION_COPY);
	gtk_drag_source_set_content (_tmp19_, _tmp18_);
	_g_object_unref0 (_tmp18_);
	_tmp20_ = _tmp19_;
	G_IS_VALUE (&_tmp17_) ? (g_value_unset (&_tmp17_), NULL) : NULL;
	drag_source = _tmp20_;
	_tmp21_ = drag_source;
	_tmp22_ = gdk_display_get_default ();
	_tmp23_ = gtk_icon_theme_get_for_display (_tmp22_);
	_tmp24_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = gtk_icon_theme_lookup_icon (_tmp23_, "image-x-generic", NULL, 32, _tmp25_, GTK_TEXT_DIR_NONE, GTK_ICON_LOOKUP_PRELOAD);
	_tmp27_ = _tmp26_;
	gtk_drag_source_set_icon (_tmp21_, (GdkPaintable*) _tmp27_, 0, 0);
	_g_object_unref0 (_tmp27_);
	_tmp28_ = self->priv->_pixbuf;
	_tmp29_ = gdk_texture_new_for_pixbuf (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = (GtkPicture*) gtk_picture_new_for_paintable ((GdkPaintable*) _tmp30_);
	g_object_set ((GtkWidget*) _tmp31_, "height-request", 128, NULL);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp31_, 18);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp31_, 18);
	g_object_ref_sink (_tmp31_);
	_tmp32_ = _tmp31_;
	_g_object_unref0 (_tmp30_);
	preview = _tmp32_;
	_tmp33_ = preview;
	gtk_widget_add_css_class ((GtkWidget*) _tmp33_, GRANITE_STYLE_CLASS_CARD);
	_tmp34_ = preview;
	gtk_widget_add_css_class ((GtkWidget*) _tmp34_, GRANITE_STYLE_CLASS_CHECKERBOARD);
	_tmp35_ = preview;
	gtk_widget_add_css_class ((GtkWidget*) _tmp35_, GRANITE_STYLE_CLASS_ROUNDED);
	_tmp36_ = preview;
	_tmp37_ = drag_source;
	_tmp38_ = _g_object_ref0 ((GtkEventController*) _tmp37_);
	gtk_widget_add_controller ((GtkWidget*) _tmp36_, _tmp38_);
	_tmp39_ = granite_header_label_new (_ ("Save Image as…"));
	g_object_ref_sink (_tmp39_);
	dialog_label = _tmp39_;
	_tmp40_ = g_date_time_new_now_local ();
	_tmp41_ = _tmp40_;
	_tmp42_ = g_date_time_format (_tmp41_, "%Y-%m-%d %H.%M.%S");
	_tmp43_ = _tmp42_;
	_g_date_time_unref0 (_tmp41_);
	date_time = _tmp43_;
	_tmp44_ = date_time;
	_tmp45_ = g_strdup_printf (_ ("Screenshot from %s"), _tmp44_);
	_data3_->file_name = _tmp45_;
	_tmp46_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp47_ = _tmp46_;
	if (_tmp47_ > 1) {
		const gchar* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		_tmp48_ = _data3_->file_name;
		_tmp49_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
		_tmp50_ = _tmp49_;
		_tmp51_ = g_strdup_printf ("@%ix", _tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = g_strconcat (_tmp48_, _tmp52_, NULL);
		_g_free0 (_data3_->file_name);
		_data3_->file_name = _tmp53_;
		_g_free0 (_tmp52_);
	}
	_tmp54_ = granite_header_label_new (_ ("Name"));
	g_object_ref_sink (_tmp54_);
	name_label = _tmp54_;
	_tmp55_ = _data3_->file_name;
	_tmp56_ = g_strdup (_tmp55_);
	_tmp57_ = granite_validated_entry_new ();
	gtk_entry_set_activates_default ((GtkEntry*) _tmp57_, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp57_, TRUE);
	gtk_editable_set_text ((GtkEditable*) _tmp57_, _tmp56_);
	_g_free0 (_tmp56_);
	g_object_ref_sink (_tmp57_);
	_data3_->name_entry = _tmp57_;
	_tmp58_ = _data3_->name_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp58_);
	_tmp59_ = (GtkLabel*) gtk_label_new ("");
	gtk_widget_set_halign ((GtkWidget*) _tmp59_, GTK_ALIGN_END);
	gtk_label_set_justify (_tmp59_, GTK_JUSTIFY_RIGHT);
	gtk_label_set_max_width_chars (_tmp59_, 55);
	gtk_label_set_wrap (_tmp59_, TRUE);
	gtk_label_set_xalign (_tmp59_, (gfloat) 1);
	g_object_ref_sink (_tmp59_);
	_data3_->validation_label = _tmp59_;
	_tmp60_ = _data3_->validation_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp60_, GRANITE_STYLE_CLASS_SMALL_LABEL);
	_tmp61_ = _data3_->validation_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp61_, GRANITE_STYLE_CLASS_ERROR);
	_tmp62_ = _data3_->validation_label;
	_tmp63_ = _g_object_ref0 ((GtkWidget*) _tmp62_);
	_tmp64_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_child (_tmp64_, _tmp63_);
	_g_object_unref0 (_tmp63_);
	gtk_revealer_set_transition_type (_tmp64_, GTK_REVEALER_TRANSITION_TYPE_CROSSFADE);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp64_, 3);
	g_object_ref_sink (_tmp64_);
	_data3_->name_message_revealer = _tmp64_;
	_tmp65_ = granite_header_label_new (_ ("File Type"));
	g_object_ref_sink (_tmp65_);
	format_label = _tmp65_;
	_tmp66_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp66_);
	_data3_->format_cmb = _tmp66_;
	_tmp67_ = _data3_->format_cmb;
	gtk_combo_box_text_append_text (_tmp67_, "png");
	_tmp68_ = _data3_->format_cmb;
	gtk_combo_box_text_append_text (_tmp68_, "jpeg");
	_tmp69_ = _data3_->format_cmb;
	gtk_combo_box_text_append_text (_tmp69_, "bmp");
	_tmp70_ = _data3_->format_cmb;
	gtk_combo_box_text_append_text (_tmp70_, "tiff");
	_tmp71_ = self->priv->_settings;
	_tmp72_ = g_settings_get_string (_tmp71_, "format");
	_tmp73_ = _tmp72_;
	_tmp75_ = (NULL == _tmp73_) ? 0 : g_quark_from_string (_tmp73_);
	g_free (_tmp73_);
	if (_tmp75_ == ((0 != _tmp74_label0) ? _tmp74_label0 : (_tmp74_label0 = g_quark_from_static_string ("png")))) {
		switch (0) {
			default:
			{
				GtkComboBoxText* _tmp76_;
				_tmp76_ = _data3_->format_cmb;
				gtk_combo_box_set_active ((GtkComboBox*) _tmp76_, 0);
				break;
			}
		}
	} else if (_tmp75_ == ((0 != _tmp74_label1) ? _tmp74_label1 : (_tmp74_label1 = g_quark_from_static_string ("jpeg")))) {
		switch (0) {
			default:
			{
				GtkComboBoxText* _tmp77_;
				_tmp77_ = _data3_->format_cmb;
				gtk_combo_box_set_active ((GtkComboBox*) _tmp77_, 1);
				break;
			}
		}
	} else if (_tmp75_ == ((0 != _tmp74_label2) ? _tmp74_label2 : (_tmp74_label2 = g_quark_from_static_string ("bmp")))) {
		switch (0) {
			default:
			{
				GtkComboBoxText* _tmp78_;
				_tmp78_ = _data3_->format_cmb;
				gtk_combo_box_set_active ((GtkComboBox*) _tmp78_, 2);
				break;
			}
		}
	} else if (_tmp75_ == ((0 != _tmp74_label3) ? _tmp74_label3 : (_tmp74_label3 = g_quark_from_static_string ("tiff")))) {
		switch (0) {
			default:
			{
				GtkComboBoxText* _tmp79_;
				_tmp79_ = _data3_->format_cmb;
				gtk_combo_box_set_active ((GtkComboBox*) _tmp79_, 3);
				break;
			}
		}
	}
	_tmp80_ = granite_header_label_new (_ ("Folder"));
	gtk_widget_set_margin_top ((GtkWidget*) _tmp80_, 18);
	g_object_ref_sink (_tmp80_);
	location_label = _tmp80_;
	_tmp81_ = (GtkLabel*) gtk_label_new ("");
	gtk_widget_set_halign ((GtkWidget*) _tmp81_, GTK_ALIGN_START);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp81_, TRUE);
	g_object_ref_sink (_tmp81_);
	_g_object_unref0 (self->priv->folder_name);
	self->priv->folder_name = _tmp81_;
	_tmp82_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp82_);
	_g_object_unref0 (self->priv->folder_image);
	self->priv->folder_image = _tmp82_;
	_tmp83_ = _data3_->folder_dir;
	screenshot_save_dialog_update_location_button (self, _tmp83_);
	_tmp84_ = (GtkImage*) gtk_image_new_from_icon_name ("view-more-horizontal-symbolic");
	g_object_ref_sink (_tmp84_);
	arrow = _tmp84_;
	_tmp85_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 3);
	g_object_ref_sink (_tmp85_);
	location_button_indicator = _tmp85_;
	_tmp86_ = location_button_indicator;
	_tmp87_ = self->priv->folder_image;
	gtk_box_append (_tmp86_, (GtkWidget*) _tmp87_);
	_tmp88_ = location_button_indicator;
	_tmp89_ = self->priv->folder_name;
	gtk_box_append (_tmp88_, (GtkWidget*) _tmp89_);
	_tmp90_ = location_button_indicator;
	_tmp91_ = arrow;
	gtk_box_append (_tmp90_, (GtkWidget*) _tmp91_);
	_tmp92_ = location_button_indicator;
	_tmp93_ = _g_object_ref0 ((GtkWidget*) _tmp92_);
	_tmp94_ = (GtkButton*) gtk_button_new ();
	gtk_button_set_child (_tmp94_, _tmp93_);
	_g_object_unref0 (_tmp93_);
	g_object_ref_sink (_tmp94_);
	location_button = _tmp94_;
	g_object_set ((GtkWindow*) self, "default-width", 500, NULL);
	g_object_set ((GtkWindow*) self, "default-height", 500, NULL);
	_tmp95_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp96_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp95_, gtk_box_get_type ()) ? ((GtkBox*) _tmp95_) : NULL);
	content = _tmp96_;
	_tmp97_ = content;
	_tmp98_ = dialog_label;
	gtk_box_append (_tmp97_, (GtkWidget*) _tmp98_);
	_tmp99_ = content;
	_tmp100_ = preview;
	gtk_box_append (_tmp99_, (GtkWidget*) _tmp100_);
	_tmp101_ = content;
	_tmp102_ = name_label;
	gtk_box_append (_tmp101_, (GtkWidget*) _tmp102_);
	_tmp103_ = content;
	_tmp104_ = _data3_->name_entry;
	gtk_box_append (_tmp103_, (GtkWidget*) _tmp104_);
	_tmp105_ = content;
	_tmp106_ = _data3_->name_message_revealer;
	gtk_box_append (_tmp105_, (GtkWidget*) _tmp106_);
	_tmp107_ = content;
	_tmp108_ = format_label;
	gtk_box_append (_tmp107_, (GtkWidget*) _tmp108_);
	_tmp109_ = content;
	_tmp110_ = _data3_->format_cmb;
	gtk_box_append (_tmp109_, (GtkWidget*) _tmp110_);
	_tmp111_ = content;
	_tmp112_ = location_label;
	gtk_box_append (_tmp111_, (GtkWidget*) _tmp112_);
	_tmp113_ = content;
	_tmp114_ = location_button;
	gtk_box_append (_tmp113_, (GtkWidget*) _tmp114_);
	_tmp115_ = granite_dialog_add_button ((GraniteDialog*) self, _ ("Copy to Clipboard"), 0);
	_tmp116_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp115_, gtk_button_get_type (), GtkButton));
	clipboard_btn = _tmp116_;
	_tmp117_ = granite_dialog_add_button ((GraniteDialog*) self, _ ("Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp118_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp117_, gtk_button_get_type (), GtkButton));
	retry_btn = _tmp118_;
	_tmp119_ = granite_dialog_add_button ((GraniteDialog*) self, _ ("Save"), (gint) GTK_RESPONSE_APPLY);
	_tmp120_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp119_, gtk_button_get_type (), GtkButton));
	_data3_->save_btn = _tmp120_;
	_tmp121_ = _data3_->save_btn;
	gtk_widget_set_receives_default ((GtkWidget*) _tmp121_, TRUE);
	_tmp122_ = _data3_->save_btn;
	gtk_widget_add_css_class ((GtkWidget*) _tmp122_, GRANITE_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp123_ = _data3_->name_entry;
	g_signal_connect_data ((GtkEditable*) _tmp123_, "changed", (GCallback) __screenshot_save_dialog___lambda8__gtk_editable_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp124_ = _data3_->save_btn;
	g_signal_connect_data (_tmp124_, "clicked", (GCallback) __screenshot_save_dialog___lambda9__gtk_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp125_ = clipboard_btn;
	g_signal_connect_object (_tmp125_, "clicked", (GCallback) __screenshot_save_dialog___lambda10__gtk_button_clicked, self, 0);
	_tmp126_ = retry_btn;
	g_signal_connect_data (_tmp126_, "clicked", (GCallback) __screenshot_save_dialog___lambda11__gtk_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp127_ = _data3_->format_cmb;
	g_signal_connect_data ((GtkComboBox*) _tmp127_, "changed", (GCallback) __screenshot_save_dialog___lambda12__gtk_combo_box_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp128_ = location_button;
	g_signal_connect_data (_tmp128_, "clicked", (GCallback) __screenshot_save_dialog___lambda13__gtk_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_g_object_unref0 (retry_btn);
	_g_object_unref0 (clipboard_btn);
	_g_object_unref0 (content);
	_g_object_unref0 (location_button);
	_g_object_unref0 (location_button_indicator);
	_g_object_unref0 (arrow);
	_g_object_unref0 (location_label);
	_g_object_unref0 (format_label);
	_g_object_unref0 (name_label);
	_g_free0 (date_time);
	_g_object_unref0 (dialog_label);
	_g_object_unref0 (preview);
	_g_object_unref0 (drag_source);
	_g_free0 (folder_from_settings);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return obj;
}

static void
screenshot_save_dialog_class_init (ScreenshotSaveDialogClass * klass,
                                   gpointer klass_data)
{
	screenshot_save_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScreenshotSaveDialog_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_screenshot_save_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_screenshot_save_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = screenshot_save_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = screenshot_save_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCREENSHOT_SAVE_DIALOG_PIXBUF_PROPERTY, screenshot_save_dialog_properties[SCREENSHOT_SAVE_DIALOG_PIXBUF_PROPERTY] = g_param_spec_object ("pixbuf", "pixbuf", "pixbuf", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCREENSHOT_SAVE_DIALOG_SETTINGS_PROPERTY, screenshot_save_dialog_properties[SCREENSHOT_SAVE_DIALOG_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	screenshot_save_dialog_signals[SCREENSHOT_SAVE_DIALOG_SAVE_RESPONSE_SIGNAL] = g_signal_new ("save-response", SCREENSHOT_TYPE_SAVE_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_STRING_STRING_STRING, G_TYPE_NONE, 4, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
}

static void
screenshot_save_dialog_instance_init (ScreenshotSaveDialog * self,
                                      gpointer klass)
{
	self->priv = screenshot_save_dialog_get_instance_private (self);
}

static void
screenshot_save_dialog_finalize (GObject * obj)
{
	ScreenshotSaveDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCREENSHOT_TYPE_SAVE_DIALOG, ScreenshotSaveDialog);
	_g_object_unref0 (self->priv->_pixbuf);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->folder_name);
	_g_object_unref0 (self->priv->folder_image);
	G_OBJECT_CLASS (screenshot_save_dialog_parent_class)->finalize (obj);
}

static GType
screenshot_save_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScreenshotSaveDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) screenshot_save_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScreenshotSaveDialog), 0, (GInstanceInitFunc) screenshot_save_dialog_instance_init, NULL };
	GType screenshot_save_dialog_type_id;
	screenshot_save_dialog_type_id = g_type_register_static (GRANITE_TYPE_DIALOG, "ScreenshotSaveDialog", &g_define_type_info, 0);
	ScreenshotSaveDialog_private_offset = g_type_add_instance_private (screenshot_save_dialog_type_id, sizeof (ScreenshotSaveDialogPrivate));
	return screenshot_save_dialog_type_id;
}

GType
screenshot_save_dialog_get_type (void)
{
	static volatile gsize screenshot_save_dialog_type_id__once = 0;
	if (g_once_init_enter (&screenshot_save_dialog_type_id__once)) {
		GType screenshot_save_dialog_type_id;
		screenshot_save_dialog_type_id = screenshot_save_dialog_get_type_once ();
		g_once_init_leave (&screenshot_save_dialog_type_id__once, screenshot_save_dialog_type_id);
	}
	return screenshot_save_dialog_type_id__once;
}

static void
_vala_screenshot_save_dialog_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	ScreenshotSaveDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCREENSHOT_TYPE_SAVE_DIALOG, ScreenshotSaveDialog);
	switch (property_id) {
		case SCREENSHOT_SAVE_DIALOG_PIXBUF_PROPERTY:
		g_value_set_object (value, screenshot_save_dialog_get_pixbuf (self));
		break;
		case SCREENSHOT_SAVE_DIALOG_SETTINGS_PROPERTY:
		g_value_set_object (value, screenshot_save_dialog_get_settings (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_screenshot_save_dialog_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	ScreenshotSaveDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCREENSHOT_TYPE_SAVE_DIALOG, ScreenshotSaveDialog);
	switch (property_id) {
		case SCREENSHOT_SAVE_DIALOG_PIXBUF_PROPERTY:
		screenshot_save_dialog_set_pixbuf (self, g_value_get_object (value));
		break;
		case SCREENSHOT_SAVE_DIALOG_SETTINGS_PROPERTY:
		screenshot_save_dialog_set_settings (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

