/* ColorPreferencesDialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ColorPreferencesDialog.vala, do not modify */

/*
* Copyright 2022 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License version 3, as published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include <granite.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>

#define TERMINAL_THEMES_PALETTE_SIZE 19
#define TERMINAL_THEMES_CUSTOM "custom"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TERMINAL_DIALOGS_TYPE_COLOR_PREFERENCES (terminal_dialogs_color_preferences_get_type ())
#define TERMINAL_DIALOGS_COLOR_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TERMINAL_DIALOGS_TYPE_COLOR_PREFERENCES, TerminalDialogsColorPreferences))
#define TERMINAL_DIALOGS_COLOR_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TERMINAL_DIALOGS_TYPE_COLOR_PREFERENCES, TerminalDialogsColorPreferencesClass))
#define TERMINAL_DIALOGS_IS_COLOR_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TERMINAL_DIALOGS_TYPE_COLOR_PREFERENCES))
#define TERMINAL_DIALOGS_IS_COLOR_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TERMINAL_DIALOGS_TYPE_COLOR_PREFERENCES))
#define TERMINAL_DIALOGS_COLOR_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TERMINAL_DIALOGS_TYPE_COLOR_PREFERENCES, TerminalDialogsColorPreferencesClass))

typedef struct _TerminalDialogsColorPreferences TerminalDialogsColorPreferences;
typedef struct _TerminalDialogsColorPreferencesClass TerminalDialogsColorPreferencesClass;
typedef struct _TerminalDialogsColorPreferencesPrivate TerminalDialogsColorPreferencesPrivate;
enum  {
	TERMINAL_DIALOGS_COLOR_PREFERENCES_0_PROPERTY,
	TERMINAL_DIALOGS_COLOR_PREFERENCES_NUM_PROPERTIES
};
static GParamSpec* terminal_dialogs_color_preferences_properties[TERMINAL_DIALOGS_COLOR_PREFERENCES_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;

struct _TerminalDialogsColorPreferences {
	GraniteDialog parent_instance;
	TerminalDialogsColorPreferencesPrivate * priv;
};

struct _TerminalDialogsColorPreferencesClass {
	GraniteDialogClass parent_class;
};

struct _TerminalDialogsColorPreferencesPrivate {
	GtkColorButton* black_button;
	GtkColorButton* red_button;
	GtkColorButton* green_button;
	GtkColorButton* yellow_button;
	GtkColorButton* blue_button;
	GtkColorButton* magenta_button;
	GtkColorButton* cyan_button;
	GtkColorButton* light_gray_button;
	GtkColorButton* dark_gray_button;
	GtkColorButton* light_red_button;
	GtkColorButton* light_green_button;
	GtkColorButton* light_yellow_button;
	GtkColorButton* light_blue_button;
	GtkColorButton* light_magenta_button;
	GtkColorButton* light_cyan_button;
	GtkColorButton* white_button;
	GtkColorButton* background_button;
	GtkColorButton* foreground_button;
	GtkColorButton* cursor_button;
};

struct _Block1Data {
	int _ref_count_;
	TerminalDialogsColorPreferences* self;
	GtkLabel* contrast_top_label;
	GtkLabel* contrast_bottom_label;
	GtkImage* contrast_image;
};

static gint TerminalDialogsColorPreferences_private_offset;
static gpointer terminal_dialogs_color_preferences_parent_class = NULL;
VALA_EXTERN GSettings* terminal_application_settings;

VALA_EXTERN GType terminal_dialogs_color_preferences_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TerminalDialogsColorPreferences, g_object_unref)
VALA_EXTERN TerminalDialogsColorPreferences* terminal_dialogs_color_preferences_new (GtkWindow* parent);
VALA_EXTERN TerminalDialogsColorPreferences* terminal_dialogs_color_preferences_construct (GType object_type,
                                                                               GtkWindow* parent);
static void terminal_dialogs_color_preferences_update_palette_settings (TerminalDialogsColorPreferences* self);
static void terminal_dialogs_color_preferences_update_buttons_from_settings (TerminalDialogsColorPreferences* self);
static void terminal_dialogs_color_preferences_update_contrast (TerminalDialogsColorPreferences* self,
                                                         GtkImage* contrast_image);
static gdouble terminal_dialogs_color_preferences_get_contrast_ratio (TerminalDialogsColorPreferences* self,
                                                               GdkRGBA* foreground,
                                                               GdkRGBA* background);
static gdouble terminal_dialogs_color_preferences_get_luminance (TerminalDialogsColorPreferences* self,
                                                          GdkRGBA* color);
static gdouble terminal_dialogs_color_preferences_sanitize_color (TerminalDialogsColorPreferences* self,
                                                           gdouble color);
static GtkLabel* terminal_dialogs_color_preferences_settings_label (TerminalDialogsColorPreferences* self,
                                                             const gchar* text);
static GObject * terminal_dialogs_color_preferences_constructor (GType type,
                                                          guint n_construct_properties,
                                                          GObjectConstructParam * construct_properties);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _gtk_widget_destroy_gtk_button_clicked (GtkButton* _sender,
                                             gpointer self);
static void _terminal_dialogs_color_preferences_update_palette_settings_gtk_color_button_color_set (GtkColorButton* _sender,
                                                                                             gpointer self);
static void _terminal_dialogs_color_preferences___lambda47_ (TerminalDialogsColorPreferences* self);
static void __terminal_dialogs_color_preferences___lambda47__gtk_button_clicked (GtkButton* _sender,
                                                                          gpointer self);
static void _terminal_dialogs_color_preferences___lambda48_ (Block1Data* _data1_);
static void __terminal_dialogs_color_preferences___lambda48__gtk_color_button_color_set (GtkColorButton* _sender,
                                                                                  gpointer self);
static void _terminal_dialogs_color_preferences___lambda49_ (Block1Data* _data1_);
static void __terminal_dialogs_color_preferences___lambda49__gtk_color_button_color_set (GtkColorButton* _sender,
                                                                                  gpointer self);
static void _terminal_dialogs_color_preferences___lambda50_ (TerminalDialogsColorPreferences* self);
static void __terminal_dialogs_color_preferences___lambda50__gtk_color_button_color_set (GtkColorButton* _sender,
                                                                                  gpointer self);
static void _terminal_dialogs_color_preferences___lambda51_ (Block1Data* _data1_,
                                                      GtkStateFlags previous_flags);
static void __terminal_dialogs_color_preferences___lambda51__gtk_widget_state_flags_changed (GtkWidget* _sender,
                                                                                      GtkStateFlags previous_state_flags,
                                                                                      gpointer self);
static void _gtk_widget_show_all_gtk_widget_show (GtkWidget* _sender,
                                           gpointer self);
static void terminal_dialogs_color_preferences_finalize (GObject * obj);
static GType terminal_dialogs_color_preferences_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
terminal_dialogs_color_preferences_get_instance_private (TerminalDialogsColorPreferences* self)
{
	return G_STRUCT_MEMBER_P (self, TerminalDialogsColorPreferences_private_offset);
}

TerminalDialogsColorPreferences*
terminal_dialogs_color_preferences_construct (GType object_type,
                                              GtkWindow* parent)
{
	TerminalDialogsColorPreferences * self = NULL;
	self = (TerminalDialogsColorPreferences*) g_object_new (object_type, "transient-for", parent, NULL);
	return self;
}

TerminalDialogsColorPreferences*
terminal_dialogs_color_preferences_new (GtkWindow* parent)
{
	return terminal_dialogs_color_preferences_construct (TERMINAL_DIALOGS_TYPE_COLOR_PREFERENCES, parent);
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
terminal_dialogs_color_preferences_update_palette_settings (TerminalDialogsColorPreferences* self)
{
	gchar** colors = NULL;
	GtkColorButton* _tmp0_;
	GdkRGBA _tmp1_ = {0};
	GdkRGBA _tmp2_;
	gchar* _tmp3_;
	GtkColorButton* _tmp4_;
	GdkRGBA _tmp5_ = {0};
	GdkRGBA _tmp6_;
	gchar* _tmp7_;
	GtkColorButton* _tmp8_;
	GdkRGBA _tmp9_ = {0};
	GdkRGBA _tmp10_;
	gchar* _tmp11_;
	GtkColorButton* _tmp12_;
	GdkRGBA _tmp13_ = {0};
	GdkRGBA _tmp14_;
	gchar* _tmp15_;
	GtkColorButton* _tmp16_;
	GdkRGBA _tmp17_ = {0};
	GdkRGBA _tmp18_;
	gchar* _tmp19_;
	GtkColorButton* _tmp20_;
	GdkRGBA _tmp21_ = {0};
	GdkRGBA _tmp22_;
	gchar* _tmp23_;
	GtkColorButton* _tmp24_;
	GdkRGBA _tmp25_ = {0};
	GdkRGBA _tmp26_;
	gchar* _tmp27_;
	GtkColorButton* _tmp28_;
	GdkRGBA _tmp29_ = {0};
	GdkRGBA _tmp30_;
	gchar* _tmp31_;
	GtkColorButton* _tmp32_;
	GdkRGBA _tmp33_ = {0};
	GdkRGBA _tmp34_;
	gchar* _tmp35_;
	GtkColorButton* _tmp36_;
	GdkRGBA _tmp37_ = {0};
	GdkRGBA _tmp38_;
	gchar* _tmp39_;
	GtkColorButton* _tmp40_;
	GdkRGBA _tmp41_ = {0};
	GdkRGBA _tmp42_;
	gchar* _tmp43_;
	GtkColorButton* _tmp44_;
	GdkRGBA _tmp45_ = {0};
	GdkRGBA _tmp46_;
	gchar* _tmp47_;
	GtkColorButton* _tmp48_;
	GdkRGBA _tmp49_ = {0};
	GdkRGBA _tmp50_;
	gchar* _tmp51_;
	GtkColorButton* _tmp52_;
	GdkRGBA _tmp53_ = {0};
	GdkRGBA _tmp54_;
	gchar* _tmp55_;
	GtkColorButton* _tmp56_;
	GdkRGBA _tmp57_ = {0};
	GdkRGBA _tmp58_;
	gchar* _tmp59_;
	GtkColorButton* _tmp60_;
	GdkRGBA _tmp61_ = {0};
	GdkRGBA _tmp62_;
	gchar* _tmp63_;
	gchar** _tmp64_;
	gint colors_length1;
	gint _colors_size_;
	GSettings* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->black_button;
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp0_, &_tmp1_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gdk_rgba_to_string (&_tmp2_);
	_tmp4_ = self->priv->red_button;
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp4_, &_tmp5_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gdk_rgba_to_string (&_tmp6_);
	_tmp8_ = self->priv->green_button;
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp8_, &_tmp9_);
	_tmp10_ = _tmp9_;
	_tmp11_ = gdk_rgba_to_string (&_tmp10_);
	_tmp12_ = self->priv->yellow_button;
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp12_, &_tmp13_);
	_tmp14_ = _tmp13_;
	_tmp15_ = gdk_rgba_to_string (&_tmp14_);
	_tmp16_ = self->priv->blue_button;
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp16_, &_tmp17_);
	_tmp18_ = _tmp17_;
	_tmp19_ = gdk_rgba_to_string (&_tmp18_);
	_tmp20_ = self->priv->magenta_button;
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp20_, &_tmp21_);
	_tmp22_ = _tmp21_;
	_tmp23_ = gdk_rgba_to_string (&_tmp22_);
	_tmp24_ = self->priv->cyan_button;
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp24_, &_tmp25_);
	_tmp26_ = _tmp25_;
	_tmp27_ = gdk_rgba_to_string (&_tmp26_);
	_tmp28_ = self->priv->light_gray_button;
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp28_, &_tmp29_);
	_tmp30_ = _tmp29_;
	_tmp31_ = gdk_rgba_to_string (&_tmp30_);
	_tmp32_ = self->priv->dark_gray_button;
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp32_, &_tmp33_);
	_tmp34_ = _tmp33_;
	_tmp35_ = gdk_rgba_to_string (&_tmp34_);
	_tmp36_ = self->priv->light_red_button;
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp36_, &_tmp37_);
	_tmp38_ = _tmp37_;
	_tmp39_ = gdk_rgba_to_string (&_tmp38_);
	_tmp40_ = self->priv->light_green_button;
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp40_, &_tmp41_);
	_tmp42_ = _tmp41_;
	_tmp43_ = gdk_rgba_to_string (&_tmp42_);
	_tmp44_ = self->priv->light_yellow_button;
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp44_, &_tmp45_);
	_tmp46_ = _tmp45_;
	_tmp47_ = gdk_rgba_to_string (&_tmp46_);
	_tmp48_ = self->priv->light_blue_button;
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp48_, &_tmp49_);
	_tmp50_ = _tmp49_;
	_tmp51_ = gdk_rgba_to_string (&_tmp50_);
	_tmp52_ = self->priv->light_magenta_button;
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp52_, &_tmp53_);
	_tmp54_ = _tmp53_;
	_tmp55_ = gdk_rgba_to_string (&_tmp54_);
	_tmp56_ = self->priv->light_cyan_button;
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp56_, &_tmp57_);
	_tmp58_ = _tmp57_;
	_tmp59_ = gdk_rgba_to_string (&_tmp58_);
	_tmp60_ = self->priv->white_button;
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp60_, &_tmp61_);
	_tmp62_ = _tmp61_;
	_tmp63_ = gdk_rgba_to_string (&_tmp62_);
	_tmp64_ = g_new0 (gchar*, 16 + 1);
	_tmp64_[0] = _tmp3_;
	_tmp64_[1] = _tmp7_;
	_tmp64_[2] = _tmp11_;
	_tmp64_[3] = _tmp15_;
	_tmp64_[4] = _tmp19_;
	_tmp64_[5] = _tmp23_;
	_tmp64_[6] = _tmp27_;
	_tmp64_[7] = _tmp31_;
	_tmp64_[8] = _tmp35_;
	_tmp64_[9] = _tmp39_;
	_tmp64_[10] = _tmp43_;
	_tmp64_[11] = _tmp47_;
	_tmp64_[12] = _tmp51_;
	_tmp64_[13] = _tmp55_;
	_tmp64_[14] = _tmp59_;
	_tmp64_[15] = _tmp63_;
	colors = _tmp64_;
	colors_length1 = 16;
	_colors_size_ = colors_length1;
	_tmp65_ = terminal_application_settings;
	_tmp66_ = _vala_g_strjoinv (":", colors, (gint) colors_length1);
	_tmp67_ = _tmp66_;
	g_settings_set_string (_tmp65_, "palette", _tmp67_);
	_g_free0 (_tmp67_);
	colors = (_vala_array_free (colors, colors_length1, (GDestroyNotify) g_free), NULL);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
terminal_dialogs_color_preferences_update_buttons_from_settings (TerminalDialogsColorPreferences* self)
{
	GdkRGBA* color_palette = NULL;
	GdkRGBA* _tmp0_;
	gint color_palette_length1;
	gint _color_palette_size_;
	gchar* palette = NULL;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* background = NULL;
	GSettings* _tmp3_;
	gchar* _tmp4_;
	gchar* foreground = NULL;
	GSettings* _tmp5_;
	gchar* _tmp6_;
	gchar* cursor = NULL;
	GSettings* _tmp7_;
	gchar* _tmp8_;
	gchar** input_palette = NULL;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gchar** _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gint input_palette_length1;
	gint _input_palette_size_;
	GtkColorButton* _tmp28_;
	GdkRGBA* _tmp29_;
	gint _tmp29__length1;
	GdkRGBA _tmp30_;
	GtkColorButton* _tmp31_;
	GdkRGBA* _tmp32_;
	gint _tmp32__length1;
	GdkRGBA _tmp33_;
	GtkColorButton* _tmp34_;
	GdkRGBA* _tmp35_;
	gint _tmp35__length1;
	GdkRGBA _tmp36_;
	GtkColorButton* _tmp37_;
	GdkRGBA* _tmp38_;
	gint _tmp38__length1;
	GdkRGBA _tmp39_;
	GtkColorButton* _tmp40_;
	GdkRGBA* _tmp41_;
	gint _tmp41__length1;
	GdkRGBA _tmp42_;
	GtkColorButton* _tmp43_;
	GdkRGBA* _tmp44_;
	gint _tmp44__length1;
	GdkRGBA _tmp45_;
	GtkColorButton* _tmp46_;
	GdkRGBA* _tmp47_;
	gint _tmp47__length1;
	GdkRGBA _tmp48_;
	GtkColorButton* _tmp49_;
	GdkRGBA* _tmp50_;
	gint _tmp50__length1;
	GdkRGBA _tmp51_;
	GtkColorButton* _tmp52_;
	GdkRGBA* _tmp53_;
	gint _tmp53__length1;
	GdkRGBA _tmp54_;
	GtkColorButton* _tmp55_;
	GdkRGBA* _tmp56_;
	gint _tmp56__length1;
	GdkRGBA _tmp57_;
	GtkColorButton* _tmp58_;
	GdkRGBA* _tmp59_;
	gint _tmp59__length1;
	GdkRGBA _tmp60_;
	GtkColorButton* _tmp61_;
	GdkRGBA* _tmp62_;
	gint _tmp62__length1;
	GdkRGBA _tmp63_;
	GtkColorButton* _tmp64_;
	GdkRGBA* _tmp65_;
	gint _tmp65__length1;
	GdkRGBA _tmp66_;
	GtkColorButton* _tmp67_;
	GdkRGBA* _tmp68_;
	gint _tmp68__length1;
	GdkRGBA _tmp69_;
	GtkColorButton* _tmp70_;
	GdkRGBA* _tmp71_;
	gint _tmp71__length1;
	GdkRGBA _tmp72_;
	GtkColorButton* _tmp73_;
	GdkRGBA* _tmp74_;
	gint _tmp74__length1;
	GdkRGBA _tmp75_;
	GtkColorButton* _tmp76_;
	GdkRGBA* _tmp77_;
	gint _tmp77__length1;
	GdkRGBA _tmp78_;
	GtkColorButton* _tmp79_;
	GdkRGBA* _tmp80_;
	gint _tmp80__length1;
	GdkRGBA _tmp81_;
	GtkColorButton* _tmp82_;
	GdkRGBA* _tmp83_;
	gint _tmp83__length1;
	GdkRGBA _tmp84_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (GdkRGBA, TERMINAL_THEMES_PALETTE_SIZE);
	color_palette = _tmp0_;
	color_palette_length1 = TERMINAL_THEMES_PALETTE_SIZE;
	_color_palette_size_ = color_palette_length1;
	_tmp1_ = terminal_application_settings;
	_tmp2_ = g_settings_get_string (_tmp1_, "palette");
	palette = _tmp2_;
	_tmp3_ = terminal_application_settings;
	_tmp4_ = g_settings_get_string (_tmp3_, "background");
	background = _tmp4_;
	_tmp5_ = terminal_application_settings;
	_tmp6_ = g_settings_get_string (_tmp5_, "foreground");
	foreground = _tmp6_;
	_tmp7_ = terminal_application_settings;
	_tmp8_ = g_settings_get_string (_tmp7_, "cursor-color");
	cursor = _tmp8_;
	_tmp9_ = palette;
	_tmp10_ = string_to_string (_tmp9_);
	_tmp11_ = background;
	_tmp12_ = string_to_string (_tmp11_);
	_tmp13_ = foreground;
	_tmp14_ = string_to_string (_tmp13_);
	_tmp15_ = cursor;
	_tmp16_ = string_to_string (_tmp15_);
	_tmp17_ = g_strconcat (_tmp10_, ":", _tmp12_, ":", _tmp14_, ":", _tmp16_, NULL);
	_tmp18_ = _tmp17_;
	_tmp20_ = _tmp19_ = g_strsplit (_tmp18_, ":", 0);
	_tmp21_ = _tmp20_;
	_tmp21__length1 = _vala_array_length (_tmp19_);
	_g_free0 (_tmp18_);
	input_palette = _tmp21_;
	input_palette_length1 = _tmp21__length1;
	_input_palette_size_ = input_palette_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp22_ = FALSE;
			_tmp22_ = TRUE;
			while (TRUE) {
				gchar** _tmp24_;
				gint _tmp24__length1;
				GdkRGBA* _tmp25_;
				gint _tmp25__length1;
				gchar** _tmp26_;
				gint _tmp26__length1;
				const gchar* _tmp27_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				_tmp24_ = input_palette;
				_tmp24__length1 = input_palette_length1;
				if (!(i < _tmp24__length1)) {
					break;
				}
				_tmp25_ = color_palette;
				_tmp25__length1 = color_palette_length1;
				_tmp26_ = input_palette;
				_tmp26__length1 = input_palette_length1;
				_tmp27_ = _tmp26_[i];
				if (!gdk_rgba_parse (&_tmp25_[i], _tmp27_)) {
					g_warning ("ColorPreferencesDialog.vala:279: Found invalid color in one of the col" \
"or palette settings");
					input_palette = (_vala_array_free (input_palette, input_palette_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (cursor);
					_g_free0 (foreground);
					_g_free0 (background);
					_g_free0 (palette);
					color_palette = (g_free (color_palette), NULL);
					return;
				}
			}
		}
	}
	_tmp28_ = self->priv->black_button;
	_tmp29_ = color_palette;
	_tmp29__length1 = color_palette_length1;
	_tmp30_ = _tmp29_[0];
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp28_, &_tmp30_);
	_tmp31_ = self->priv->red_button;
	_tmp32_ = color_palette;
	_tmp32__length1 = color_palette_length1;
	_tmp33_ = _tmp32_[1];
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp31_, &_tmp33_);
	_tmp34_ = self->priv->green_button;
	_tmp35_ = color_palette;
	_tmp35__length1 = color_palette_length1;
	_tmp36_ = _tmp35_[2];
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp34_, &_tmp36_);
	_tmp37_ = self->priv->yellow_button;
	_tmp38_ = color_palette;
	_tmp38__length1 = color_palette_length1;
	_tmp39_ = _tmp38_[3];
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp37_, &_tmp39_);
	_tmp40_ = self->priv->blue_button;
	_tmp41_ = color_palette;
	_tmp41__length1 = color_palette_length1;
	_tmp42_ = _tmp41_[4];
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp40_, &_tmp42_);
	_tmp43_ = self->priv->magenta_button;
	_tmp44_ = color_palette;
	_tmp44__length1 = color_palette_length1;
	_tmp45_ = _tmp44_[5];
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp43_, &_tmp45_);
	_tmp46_ = self->priv->cyan_button;
	_tmp47_ = color_palette;
	_tmp47__length1 = color_palette_length1;
	_tmp48_ = _tmp47_[6];
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp46_, &_tmp48_);
	_tmp49_ = self->priv->light_gray_button;
	_tmp50_ = color_palette;
	_tmp50__length1 = color_palette_length1;
	_tmp51_ = _tmp50_[7];
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp49_, &_tmp51_);
	_tmp52_ = self->priv->dark_gray_button;
	_tmp53_ = color_palette;
	_tmp53__length1 = color_palette_length1;
	_tmp54_ = _tmp53_[8];
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp52_, &_tmp54_);
	_tmp55_ = self->priv->light_red_button;
	_tmp56_ = color_palette;
	_tmp56__length1 = color_palette_length1;
	_tmp57_ = _tmp56_[9];
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp55_, &_tmp57_);
	_tmp58_ = self->priv->light_green_button;
	_tmp59_ = color_palette;
	_tmp59__length1 = color_palette_length1;
	_tmp60_ = _tmp59_[10];
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp58_, &_tmp60_);
	_tmp61_ = self->priv->light_yellow_button;
	_tmp62_ = color_palette;
	_tmp62__length1 = color_palette_length1;
	_tmp63_ = _tmp62_[11];
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp61_, &_tmp63_);
	_tmp64_ = self->priv->light_blue_button;
	_tmp65_ = color_palette;
	_tmp65__length1 = color_palette_length1;
	_tmp66_ = _tmp65_[12];
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp64_, &_tmp66_);
	_tmp67_ = self->priv->light_magenta_button;
	_tmp68_ = color_palette;
	_tmp68__length1 = color_palette_length1;
	_tmp69_ = _tmp68_[13];
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp67_, &_tmp69_);
	_tmp70_ = self->priv->light_cyan_button;
	_tmp71_ = color_palette;
	_tmp71__length1 = color_palette_length1;
	_tmp72_ = _tmp71_[14];
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp70_, &_tmp72_);
	_tmp73_ = self->priv->white_button;
	_tmp74_ = color_palette;
	_tmp74__length1 = color_palette_length1;
	_tmp75_ = _tmp74_[15];
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp73_, &_tmp75_);
	_tmp76_ = self->priv->background_button;
	_tmp77_ = color_palette;
	_tmp77__length1 = color_palette_length1;
	_tmp78_ = _tmp77_[16];
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp76_, &_tmp78_);
	_tmp79_ = self->priv->foreground_button;
	_tmp80_ = color_palette;
	_tmp80__length1 = color_palette_length1;
	_tmp81_ = _tmp80_[17];
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp79_, &_tmp81_);
	_tmp82_ = self->priv->cursor_button;
	_tmp83_ = color_palette;
	_tmp83__length1 = color_palette_length1;
	_tmp84_ = _tmp83_[18];
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp82_, &_tmp84_);
	input_palette = (_vala_array_free (input_palette, input_palette_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (cursor);
	_g_free0 (foreground);
	_g_free0 (background);
	_g_free0 (palette);
	color_palette = (g_free (color_palette), NULL);
}

static void
terminal_dialogs_color_preferences_update_contrast (TerminalDialogsColorPreferences* self,
                                                    GtkImage* contrast_image)
{
	gdouble contrast_ratio = 0.0;
	GtkColorButton* _tmp0_;
	GdkRGBA _tmp1_ = {0};
	GdkRGBA _tmp2_;
	GtkColorButton* _tmp3_;
	GdkRGBA _tmp4_ = {0};
	GdkRGBA _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contrast_image != NULL);
	_tmp0_ = self->priv->foreground_button;
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp0_, &_tmp1_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->background_button;
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp3_, &_tmp4_);
	_tmp5_ = _tmp4_;
	contrast_ratio = terminal_dialogs_color_preferences_get_contrast_ratio (self, &_tmp2_, &_tmp5_);
	if (contrast_ratio < ((gdouble) 3)) {
		g_object_set (contrast_image, "icon-name", "dialog-warning", NULL);
		gtk_widget_set_tooltip_text ((GtkWidget*) contrast_image, _ ("Contrast is very low"));
	} else {
		if (contrast_ratio < 4.5) {
			g_object_set (contrast_image, "icon-name", "dialog-warning", NULL);
			gtk_widget_set_tooltip_text ((GtkWidget*) contrast_image, _ ("Contrast is low"));
		} else {
			if (contrast_ratio < ((gdouble) 7)) {
				g_object_set (contrast_image, "icon-name", "process-completed", NULL);
				gtk_widget_set_tooltip_text ((GtkWidget*) contrast_image, _ ("Contrast is good"));
			} else {
				g_object_set (contrast_image, "icon-name", "process-completed", NULL);
				gtk_widget_set_tooltip_text ((GtkWidget*) contrast_image, _ ("Contrast is high"));
			}
		}
	}
}

static gdouble
terminal_dialogs_color_preferences_get_contrast_ratio (TerminalDialogsColorPreferences* self,
                                                       GdkRGBA* foreground,
                                                       GdkRGBA* background)
{
	gdouble foreground_luminance = 0.0;
	GdkRGBA _tmp0_;
	gdouble background_luminance = 0.0;
	GdkRGBA _tmp1_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (foreground != NULL, 0.0);
	g_return_val_if_fail (background != NULL, 0.0);
	_tmp0_ = *foreground;
	foreground_luminance = terminal_dialogs_color_preferences_get_luminance (self, &_tmp0_);
	_tmp1_ = *background;
	background_luminance = terminal_dialogs_color_preferences_get_luminance (self, &_tmp1_);
	if (background_luminance > foreground_luminance) {
		result = (background_luminance + 0.05) / (foreground_luminance + 0.05);
		return result;
	} else {
		result = (foreground_luminance + 0.05) / (background_luminance + 0.05);
		return result;
	}
}

static gdouble
terminal_dialogs_color_preferences_get_luminance (TerminalDialogsColorPreferences* self,
                                                  GdkRGBA* color)
{
	gdouble red = 0.0;
	GdkRGBA _tmp0_;
	gdouble green = 0.0;
	GdkRGBA _tmp1_;
	gdouble blue = 0.0;
	GdkRGBA _tmp2_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (color != NULL, 0.0);
	_tmp0_ = *color;
	red = terminal_dialogs_color_preferences_sanitize_color (self, _tmp0_.red) * 0.2126;
	_tmp1_ = *color;
	green = terminal_dialogs_color_preferences_sanitize_color (self, _tmp1_.green) * 0.7152;
	_tmp2_ = *color;
	blue = terminal_dialogs_color_preferences_sanitize_color (self, _tmp2_.blue) * 0.0722;
	result = (red + green) + blue;
	return result;
}

static gdouble
terminal_dialogs_color_preferences_sanitize_color (TerminalDialogsColorPreferences* self,
                                                   gdouble color)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	if (color <= 0.03928) {
		color = color / 12.92;
	} else {
		color = pow ((color + 0.055) / 1.055, 2.4);
	}
	result = color;
	return result;
}

static GtkLabel*
terminal_dialogs_color_preferences_settings_label (TerminalDialogsColorPreferences* self,
                                                   const gchar* text)
{
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (text);
	gtk_widget_set_halign ((GtkWidget*) _tmp0_, GTK_ALIGN_END);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp0_, 12);
	g_object_ref_sink (_tmp0_);
	result = _tmp0_;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		TerminalDialogsColorPreferences* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->contrast_image);
		_g_object_unref0 (_data1_->contrast_bottom_label);
		_g_object_unref0 (_data1_->contrast_top_label);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_gtk_widget_destroy_gtk_button_clicked (GtkButton* _sender,
                                        gpointer self)
{
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
_terminal_dialogs_color_preferences_update_palette_settings_gtk_color_button_color_set (GtkColorButton* _sender,
                                                                                        gpointer self)
{
	terminal_dialogs_color_preferences_update_palette_settings ((TerminalDialogsColorPreferences*) self);
}

static void
_terminal_dialogs_color_preferences___lambda47_ (TerminalDialogsColorPreferences* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	_tmp0_ = terminal_application_settings;
	g_settings_reset (_tmp0_, "palette");
	_tmp1_ = terminal_application_settings;
	g_settings_reset (_tmp1_, "background");
	_tmp2_ = terminal_application_settings;
	g_settings_reset (_tmp2_, "foreground");
	_tmp3_ = terminal_application_settings;
	g_settings_reset (_tmp3_, "cursor-color");
	terminal_dialogs_color_preferences_update_buttons_from_settings (self);
}

static void
__terminal_dialogs_color_preferences___lambda47__gtk_button_clicked (GtkButton* _sender,
                                                                     gpointer self)
{
	_terminal_dialogs_color_preferences___lambda47_ ((TerminalDialogsColorPreferences*) self);
}

static void
_terminal_dialogs_color_preferences___lambda48_ (Block1Data* _data1_)
{
	TerminalDialogsColorPreferences* self;
	GSettings* _tmp0_;
	GtkColorButton* _tmp1_;
	GdkRGBA _tmp2_ = {0};
	GdkRGBA _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkImage* _tmp6_;
	self = _data1_->self;
	_tmp0_ = terminal_application_settings;
	_tmp1_ = self->priv->background_button;
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp1_, &_tmp2_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gdk_rgba_to_string (&_tmp3_);
	_tmp5_ = _tmp4_;
	g_settings_set_string (_tmp0_, "background", _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = _data1_->contrast_image;
	terminal_dialogs_color_preferences_update_contrast (self, _tmp6_);
}

static void
__terminal_dialogs_color_preferences___lambda48__gtk_color_button_color_set (GtkColorButton* _sender,
                                                                             gpointer self)
{
	_terminal_dialogs_color_preferences___lambda48_ (self);
}

static void
_terminal_dialogs_color_preferences___lambda49_ (Block1Data* _data1_)
{
	TerminalDialogsColorPreferences* self;
	GSettings* _tmp0_;
	GtkColorButton* _tmp1_;
	GdkRGBA _tmp2_ = {0};
	GdkRGBA _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkImage* _tmp6_;
	self = _data1_->self;
	_tmp0_ = terminal_application_settings;
	_tmp1_ = self->priv->foreground_button;
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp1_, &_tmp2_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gdk_rgba_to_string (&_tmp3_);
	_tmp5_ = _tmp4_;
	g_settings_set_string (_tmp0_, "foreground", _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = _data1_->contrast_image;
	terminal_dialogs_color_preferences_update_contrast (self, _tmp6_);
}

static void
__terminal_dialogs_color_preferences___lambda49__gtk_color_button_color_set (GtkColorButton* _sender,
                                                                             gpointer self)
{
	_terminal_dialogs_color_preferences___lambda49_ (self);
}

static void
_terminal_dialogs_color_preferences___lambda50_ (TerminalDialogsColorPreferences* self)
{
	GSettings* _tmp0_;
	GtkColorButton* _tmp1_;
	GdkRGBA _tmp2_ = {0};
	GdkRGBA _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	_tmp0_ = terminal_application_settings;
	_tmp1_ = self->priv->cursor_button;
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp1_, &_tmp2_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gdk_rgba_to_string (&_tmp3_);
	_tmp5_ = _tmp4_;
	g_settings_set_string (_tmp0_, "cursor-color", _tmp5_);
	_g_free0 (_tmp5_);
}

static void
__terminal_dialogs_color_preferences___lambda50__gtk_color_button_color_set (GtkColorButton* _sender,
                                                                             gpointer self)
{
	_terminal_dialogs_color_preferences___lambda50_ ((TerminalDialogsColorPreferences*) self);
}

static void
_terminal_dialogs_color_preferences___lambda51_ (Block1Data* _data1_,
                                                 GtkStateFlags previous_flags)
{
	TerminalDialogsColorPreferences* self;
	GtkStateFlags state_flags = 0U;
	const gchar* _tmp0_ = NULL;
	GtkLabel* _tmp1_;
	const gchar* _tmp2_ = NULL;
	GtkLabel* _tmp3_;
	self = _data1_->self;
	state_flags = gtk_widget_get_state_flags ((GtkWidget*) self);
	if ((state_flags & GTK_STATE_FLAG_DIR_LTR) == GTK_STATE_FLAG_DIR_LTR) {
		_tmp0_ = "┐";
	} else {
		_tmp0_ = "┌";
	}
	_tmp1_ = _data1_->contrast_top_label;
	gtk_label_set_label (_tmp1_, _tmp0_);
	if ((state_flags & GTK_STATE_FLAG_DIR_LTR) == GTK_STATE_FLAG_DIR_LTR) {
		_tmp2_ = "┘";
	} else {
		_tmp2_ = "└";
	}
	_tmp3_ = _data1_->contrast_bottom_label;
	gtk_label_set_label (_tmp3_, _tmp2_);
}

static void
__terminal_dialogs_color_preferences___lambda51__gtk_widget_state_flags_changed (GtkWidget* _sender,
                                                                                 GtkStateFlags previous_state_flags,
                                                                                 gpointer self)
{
	_terminal_dialogs_color_preferences___lambda51_ (self, previous_state_flags);
}

static void
_gtk_widget_show_all_gtk_widget_show (GtkWidget* _sender,
                                      gpointer self)
{
	gtk_widget_show_all ((GtkWidget*) self);
}

static GObject *
terminal_dialogs_color_preferences_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TerminalDialogsColorPreferences * self;
	Block1Data* _data1_;
	GtkLabel* window_theme_label = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GraniteModeSwitch* window_theme_switch = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GraniteModeSwitch* _tmp4_ = NULL;
	GSettings* _tmp5_;
	GraniteModeSwitch* _tmp6_;
	GtkLabel* palette_header = NULL;
	GtkLabel* _tmp7_ = NULL;
	GtkLabel* _tmp8_;
	GtkStyleContext* _tmp9_;
	GtkButton* default_button = NULL;
	gchar* _tmp10_;
	GtkButton* _tmp11_ = NULL;
	GtkLabel* black_color_label = NULL;
	GtkLabel* _tmp12_;
	GtkLabel* red_color_label = NULL;
	GtkLabel* _tmp13_;
	GtkLabel* green_color_label = NULL;
	GtkLabel* _tmp14_;
	GtkLabel* yellow_color_label = NULL;
	GtkLabel* _tmp15_;
	GtkLabel* blue_color_label = NULL;
	GtkLabel* _tmp16_;
	GtkLabel* magenta_color_label = NULL;
	GtkLabel* _tmp17_;
	GtkLabel* cyan_color_label = NULL;
	GtkLabel* _tmp18_;
	GtkLabel* dark_gray_color_label = NULL;
	GtkLabel* _tmp19_;
	GtkLabel* white_color_label = NULL;
	GtkLabel* _tmp20_;
	GtkLabel* light_red_color_label = NULL;
	GtkLabel* _tmp21_;
	GtkLabel* light_green_color_label = NULL;
	GtkLabel* _tmp22_;
	GtkLabel* light_yellow_color_label = NULL;
	GtkLabel* _tmp23_;
	GtkLabel* light_blue_color_label = NULL;
	GtkLabel* _tmp24_;
	GtkLabel* light_magenta_color_label = NULL;
	GtkLabel* _tmp25_;
	GtkLabel* light_cyan_color_label = NULL;
	GtkLabel* _tmp26_;
	GtkLabel* light_gray_color_label = NULL;
	GtkLabel* _tmp27_;
	GtkLabel* background_label = NULL;
	GtkLabel* _tmp28_;
	GtkLabel* foreground_label = NULL;
	GtkLabel* _tmp29_;
	GtkLabel* cursor_label = NULL;
	GtkLabel* _tmp30_;
	GtkColorButton* _tmp31_;
	GtkColorButton* _tmp32_;
	GtkColorButton* _tmp33_;
	GtkColorButton* _tmp34_;
	GtkColorButton* _tmp35_;
	GtkColorButton* _tmp36_;
	GtkColorButton* _tmp37_;
	GtkColorButton* _tmp38_;
	GtkColorButton* _tmp39_;
	GtkColorButton* _tmp40_;
	GtkColorButton* _tmp41_;
	GtkColorButton* _tmp42_;
	GtkColorButton* _tmp43_;
	GtkColorButton* _tmp44_;
	GtkColorButton* _tmp45_;
	GtkColorButton* _tmp46_;
	GtkColorButton* _tmp47_ = NULL;
	GtkColorButton* _tmp48_;
	GtkColorButton* _tmp49_ = NULL;
	GtkLabel* _tmp50_;
	GtkLabel* _tmp51_;
	GtkImage* _tmp52_;
	GtkGrid* contrast_grid = NULL;
	GtkGrid* _tmp53_ = NULL;
	GtkGrid* _tmp54_;
	GtkLabel* _tmp55_;
	GtkGrid* _tmp56_;
	GtkImage* _tmp57_;
	GtkGrid* _tmp58_;
	GtkLabel* _tmp59_;
	GtkGrid* colors_grid = NULL;
	GtkGrid* _tmp60_ = NULL;
	GtkGrid* _tmp61_;
	GtkLabel* _tmp62_;
	GtkGrid* _tmp63_;
	GraniteModeSwitch* _tmp64_;
	GtkGrid* _tmp65_;
	GtkLabel* _tmp66_;
	GtkGrid* _tmp67_;
	GtkButton* _tmp68_;
	GtkGrid* _tmp69_;
	GtkLabel* _tmp70_;
	GtkGrid* _tmp71_;
	GtkColorButton* _tmp72_;
	GtkGrid* _tmp73_;
	GtkLabel* _tmp74_;
	GtkGrid* _tmp75_;
	GtkColorButton* _tmp76_;
	GtkGrid* _tmp77_;
	GtkGrid* _tmp78_;
	GtkGrid* _tmp79_;
	GtkLabel* _tmp80_;
	GtkGrid* _tmp81_;
	GtkColorButton* _tmp82_;
	GtkGrid* _tmp83_;
	GtkLabel* _tmp84_;
	GtkGrid* _tmp85_;
	GtkColorButton* _tmp86_;
	GtkGrid* _tmp87_;
	GtkLabel* _tmp88_;
	GtkGrid* _tmp89_;
	GtkColorButton* _tmp90_;
	GtkGrid* _tmp91_;
	GtkLabel* _tmp92_;
	GtkGrid* _tmp93_;
	GtkColorButton* _tmp94_;
	GtkGrid* _tmp95_;
	GtkLabel* _tmp96_;
	GtkGrid* _tmp97_;
	GtkColorButton* _tmp98_;
	GtkGrid* _tmp99_;
	GtkLabel* _tmp100_;
	GtkGrid* _tmp101_;
	GtkColorButton* _tmp102_;
	GtkGrid* _tmp103_;
	GtkLabel* _tmp104_;
	GtkGrid* _tmp105_;
	GtkColorButton* _tmp106_;
	GtkGrid* _tmp107_;
	GtkLabel* _tmp108_;
	GtkGrid* _tmp109_;
	GtkColorButton* _tmp110_;
	GtkGrid* _tmp111_;
	GtkLabel* _tmp112_;
	GtkGrid* _tmp113_;
	GtkColorButton* _tmp114_;
	GtkGrid* _tmp115_;
	GtkLabel* _tmp116_;
	GtkGrid* _tmp117_;
	GtkColorButton* _tmp118_;
	GtkGrid* _tmp119_;
	GtkLabel* _tmp120_;
	GtkGrid* _tmp121_;
	GtkColorButton* _tmp122_;
	GtkGrid* _tmp123_;
	GtkLabel* _tmp124_;
	GtkGrid* _tmp125_;
	GtkColorButton* _tmp126_;
	GtkGrid* _tmp127_;
	GtkLabel* _tmp128_;
	GtkGrid* _tmp129_;
	GtkColorButton* _tmp130_;
	GtkGrid* _tmp131_;
	GtkLabel* _tmp132_;
	GtkGrid* _tmp133_;
	GtkColorButton* _tmp134_;
	GtkGrid* _tmp135_;
	GtkLabel* _tmp136_;
	GtkGrid* _tmp137_;
	GtkColorButton* _tmp138_;
	GtkGrid* _tmp139_;
	GtkLabel* _tmp140_;
	GtkGrid* _tmp141_;
	GtkColorButton* _tmp142_;
	GtkGrid* _tmp143_;
	GtkLabel* _tmp144_;
	GtkGrid* _tmp145_;
	GtkColorButton* _tmp146_;
	GtkImage* _tmp147_;
	GtkBox* _tmp148_;
	GtkGrid* _tmp149_;
	GtkButton* close_button = NULL;
	GtkWidget* _tmp150_;
	GtkButton* _tmp151_;
	GtkButton* _tmp152_;
	GSettings* _tmp153_;
	GtkColorButton* _tmp154_;
	GtkColorButton* _tmp155_;
	GtkColorButton* _tmp156_;
	GtkColorButton* _tmp157_;
	GtkColorButton* _tmp158_;
	GtkColorButton* _tmp159_;
	GtkColorButton* _tmp160_;
	GtkColorButton* _tmp161_;
	GtkColorButton* _tmp162_;
	GtkColorButton* _tmp163_;
	GtkColorButton* _tmp164_;
	GtkColorButton* _tmp165_;
	GtkColorButton* _tmp166_;
	GtkColorButton* _tmp167_;
	GtkColorButton* _tmp168_;
	GtkColorButton* _tmp169_;
	GtkButton* _tmp170_;
	GtkColorButton* _tmp171_;
	GtkColorButton* _tmp172_;
	GtkColorButton* _tmp173_;
	GtkLabel* _tmp174_;
	GtkWidget* _tmp175_;
	parent_class = G_OBJECT_CLASS (terminal_dialogs_color_preferences_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TERMINAL_DIALOGS_TYPE_COLOR_PREFERENCES, TerminalDialogsColorPreferences);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	gtk_window_set_title ((GtkWindow*) self, _ ("Color Preferences"));
	_tmp0_ = terminal_dialogs_color_preferences_settings_label (self, _ ("Window style:"));
	window_theme_label = _tmp0_;
	_tmp1_ = window_theme_label;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp1_, 12);
	_tmp2_ = g_strdup (_ ("Light"));
	_tmp3_ = g_strdup (_ ("Dark"));
	_tmp4_ = granite_mode_switch_new_from_icon_name ("display-brightness-symbolic", "weather-clear-night-symbolic");
	granite_mode_switch_set_primary_icon_tooltip_text (_tmp4_, _tmp2_);
	_g_free0 (_tmp2_);
	granite_mode_switch_set_secondary_icon_tooltip_text (_tmp4_, _tmp3_);
	_g_free0 (_tmp3_);
	g_object_ref_sink (_tmp4_);
	window_theme_switch = _tmp4_;
	_tmp5_ = terminal_application_settings;
	_tmp6_ = window_theme_switch;
	g_settings_bind (_tmp5_, "prefer-dark-style", (GObject*) _tmp6_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp7_ = (GtkLabel*) gtk_label_new (_ ("Color Palette"));
	gtk_widget_set_margin_top ((GtkWidget*) _tmp7_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp7_, 12);
	g_object_ref_sink (_tmp7_);
	palette_header = _tmp7_;
	_tmp8_ = palette_header;
	_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) _tmp8_);
	gtk_style_context_add_class (_tmp9_, GRANITE_STYLE_CLASS_PRIMARY_LABEL);
	_tmp10_ = g_strdup (_ ("Reset to default"));
	_tmp11_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-clear-all-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	gtk_widget_set_halign ((GtkWidget*) _tmp11_, GTK_ALIGN_END);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp11_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp11_, 6);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp11_, _tmp10_);
	_g_free0 (_tmp10_);
	g_object_ref_sink (_tmp11_);
	default_button = _tmp11_;
	_tmp12_ = terminal_dialogs_color_preferences_settings_label (self, _ ("Black:"));
	black_color_label = _tmp12_;
	_tmp13_ = terminal_dialogs_color_preferences_settings_label (self, _ ("Red:"));
	red_color_label = _tmp13_;
	_tmp14_ = terminal_dialogs_color_preferences_settings_label (self, _ ("Green:"));
	green_color_label = _tmp14_;
	_tmp15_ = terminal_dialogs_color_preferences_settings_label (self, _ ("Yellow:"));
	yellow_color_label = _tmp15_;
	_tmp16_ = terminal_dialogs_color_preferences_settings_label (self, _ ("Blue:"));
	blue_color_label = _tmp16_;
	_tmp17_ = terminal_dialogs_color_preferences_settings_label (self, _ ("Magenta:"));
	magenta_color_label = _tmp17_;
	_tmp18_ = terminal_dialogs_color_preferences_settings_label (self, _ ("Cyan:"));
	cyan_color_label = _tmp18_;
	_tmp19_ = terminal_dialogs_color_preferences_settings_label (self, _ ("Gray:"));
	dark_gray_color_label = _tmp19_;
	_tmp20_ = terminal_dialogs_color_preferences_settings_label (self, _ ("White:"));
	white_color_label = _tmp20_;
	_tmp21_ = terminal_dialogs_color_preferences_settings_label (self, _ ("Light Red:"));
	light_red_color_label = _tmp21_;
	_tmp22_ = terminal_dialogs_color_preferences_settings_label (self, _ ("Light Green:"));
	light_green_color_label = _tmp22_;
	_tmp23_ = terminal_dialogs_color_preferences_settings_label (self, _ ("Light Yellow:"));
	light_yellow_color_label = _tmp23_;
	_tmp24_ = terminal_dialogs_color_preferences_settings_label (self, _ ("Light Blue:"));
	light_blue_color_label = _tmp24_;
	_tmp25_ = terminal_dialogs_color_preferences_settings_label (self, _ ("Light Magenta:"));
	light_magenta_color_label = _tmp25_;
	_tmp26_ = terminal_dialogs_color_preferences_settings_label (self, _ ("Light Cyan:"));
	light_cyan_color_label = _tmp26_;
	_tmp27_ = terminal_dialogs_color_preferences_settings_label (self, _ ("Light Gray:"));
	light_gray_color_label = _tmp27_;
	_tmp28_ = terminal_dialogs_color_preferences_settings_label (self, _ ("Background:"));
	background_label = _tmp28_;
	_tmp29_ = terminal_dialogs_color_preferences_settings_label (self, _ ("Foreground:"));
	foreground_label = _tmp29_;
	_tmp30_ = terminal_dialogs_color_preferences_settings_label (self, _ ("Cursor:"));
	cursor_label = _tmp30_;
	_tmp31_ = (GtkColorButton*) gtk_color_button_new ();
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->black_button);
	self->priv->black_button = _tmp31_;
	_tmp32_ = (GtkColorButton*) gtk_color_button_new ();
	g_object_ref_sink (_tmp32_);
	_g_object_unref0 (self->priv->red_button);
	self->priv->red_button = _tmp32_;
	_tmp33_ = (GtkColorButton*) gtk_color_button_new ();
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->priv->green_button);
	self->priv->green_button = _tmp33_;
	_tmp34_ = (GtkColorButton*) gtk_color_button_new ();
	g_object_ref_sink (_tmp34_);
	_g_object_unref0 (self->priv->yellow_button);
	self->priv->yellow_button = _tmp34_;
	_tmp35_ = (GtkColorButton*) gtk_color_button_new ();
	g_object_ref_sink (_tmp35_);
	_g_object_unref0 (self->priv->blue_button);
	self->priv->blue_button = _tmp35_;
	_tmp36_ = (GtkColorButton*) gtk_color_button_new ();
	g_object_ref_sink (_tmp36_);
	_g_object_unref0 (self->priv->magenta_button);
	self->priv->magenta_button = _tmp36_;
	_tmp37_ = (GtkColorButton*) gtk_color_button_new ();
	g_object_ref_sink (_tmp37_);
	_g_object_unref0 (self->priv->cyan_button);
	self->priv->cyan_button = _tmp37_;
	_tmp38_ = (GtkColorButton*) gtk_color_button_new ();
	g_object_ref_sink (_tmp38_);
	_g_object_unref0 (self->priv->light_gray_button);
	self->priv->light_gray_button = _tmp38_;
	_tmp39_ = (GtkColorButton*) gtk_color_button_new ();
	g_object_ref_sink (_tmp39_);
	_g_object_unref0 (self->priv->dark_gray_button);
	self->priv->dark_gray_button = _tmp39_;
	_tmp40_ = (GtkColorButton*) gtk_color_button_new ();
	g_object_ref_sink (_tmp40_);
	_g_object_unref0 (self->priv->light_red_button);
	self->priv->light_red_button = _tmp40_;
	_tmp41_ = (GtkColorButton*) gtk_color_button_new ();
	g_object_ref_sink (_tmp41_);
	_g_object_unref0 (self->priv->light_green_button);
	self->priv->light_green_button = _tmp41_;
	_tmp42_ = (GtkColorButton*) gtk_color_button_new ();
	g_object_ref_sink (_tmp42_);
	_g_object_unref0 (self->priv->light_yellow_button);
	self->priv->light_yellow_button = _tmp42_;
	_tmp43_ = (GtkColorButton*) gtk_color_button_new ();
	g_object_ref_sink (_tmp43_);
	_g_object_unref0 (self->priv->light_blue_button);
	self->priv->light_blue_button = _tmp43_;
	_tmp44_ = (GtkColorButton*) gtk_color_button_new ();
	g_object_ref_sink (_tmp44_);
	_g_object_unref0 (self->priv->light_magenta_button);
	self->priv->light_magenta_button = _tmp44_;
	_tmp45_ = (GtkColorButton*) gtk_color_button_new ();
	g_object_ref_sink (_tmp45_);
	_g_object_unref0 (self->priv->light_cyan_button);
	self->priv->light_cyan_button = _tmp45_;
	_tmp46_ = (GtkColorButton*) gtk_color_button_new ();
	g_object_ref_sink (_tmp46_);
	_g_object_unref0 (self->priv->white_button);
	self->priv->white_button = _tmp46_;
	_tmp47_ = (GtkColorButton*) gtk_color_button_new ();
	gtk_color_button_set_use_alpha (_tmp47_, TRUE);
	g_object_ref_sink (_tmp47_);
	_g_object_unref0 (self->priv->background_button);
	self->priv->background_button = _tmp47_;
	_tmp48_ = (GtkColorButton*) gtk_color_button_new ();
	g_object_ref_sink (_tmp48_);
	_g_object_unref0 (self->priv->foreground_button);
	self->priv->foreground_button = _tmp48_;
	_tmp49_ = (GtkColorButton*) gtk_color_button_new ();
	gtk_color_button_set_use_alpha (_tmp49_, TRUE);
	g_object_ref_sink (_tmp49_);
	_g_object_unref0 (self->priv->cursor_button);
	self->priv->cursor_button = _tmp49_;
	_tmp50_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp50_);
	_data1_->contrast_top_label = _tmp50_;
	_tmp51_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp51_);
	_data1_->contrast_bottom_label = _tmp51_;
	_tmp52_ = (GtkImage*) gtk_image_new_from_icon_name ("process-completed", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp52_);
	_data1_->contrast_image = _tmp52_;
	_tmp53_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_row_spacing (_tmp53_, 3);
	g_object_ref_sink (_tmp53_);
	contrast_grid = _tmp53_;
	_tmp54_ = contrast_grid;
	_tmp55_ = _data1_->contrast_top_label;
	gtk_grid_attach (_tmp54_, (GtkWidget*) _tmp55_, 0, 0, 1, 1);
	_tmp56_ = contrast_grid;
	_tmp57_ = _data1_->contrast_image;
	gtk_grid_attach (_tmp56_, (GtkWidget*) _tmp57_, 0, 1, 1, 1);
	_tmp58_ = contrast_grid;
	_tmp59_ = _data1_->contrast_bottom_label;
	gtk_grid_attach (_tmp58_, (GtkWidget*) _tmp59_, 0, 2, 1, 1);
	_tmp60_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp60_, 12);
	gtk_grid_set_row_spacing (_tmp60_, 6);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp60_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp60_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp60_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp60_, 12);
	gtk_widget_set_halign ((GtkWidget*) _tmp60_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp60_);
	colors_grid = _tmp60_;
	_tmp61_ = colors_grid;
	_tmp62_ = window_theme_label;
	gtk_grid_attach (_tmp61_, (GtkWidget*) _tmp62_, 0, 1, 1, 1);
	_tmp63_ = colors_grid;
	_tmp64_ = window_theme_switch;
	gtk_grid_attach (_tmp63_, (GtkWidget*) _tmp64_, 1, 1, 2, 1);
	_tmp65_ = colors_grid;
	_tmp66_ = palette_header;
	gtk_grid_attach (_tmp65_, (GtkWidget*) _tmp66_, 0, 2, 1, 1);
	_tmp67_ = colors_grid;
	_tmp68_ = default_button;
	gtk_grid_attach (_tmp67_, (GtkWidget*) _tmp68_, 3, 2, 1, 1);
	_tmp69_ = colors_grid;
	_tmp70_ = background_label;
	gtk_grid_attach (_tmp69_, (GtkWidget*) _tmp70_, 0, 4, 1, 1);
	_tmp71_ = colors_grid;
	_tmp72_ = self->priv->background_button;
	gtk_grid_attach (_tmp71_, (GtkWidget*) _tmp72_, 1, 4, 1, 1);
	_tmp73_ = colors_grid;
	_tmp74_ = foreground_label;
	gtk_grid_attach (_tmp73_, (GtkWidget*) _tmp74_, 0, 5, 1, 1);
	_tmp75_ = colors_grid;
	_tmp76_ = self->priv->foreground_button;
	gtk_grid_attach (_tmp75_, (GtkWidget*) _tmp76_, 1, 5, 1, 1);
	_tmp77_ = colors_grid;
	_tmp78_ = contrast_grid;
	gtk_grid_attach (_tmp77_, (GtkWidget*) _tmp78_, 2, 4, 1, 2);
	_tmp79_ = colors_grid;
	_tmp80_ = cursor_label;
	gtk_grid_attach (_tmp79_, (GtkWidget*) _tmp80_, 0, 6, 1, 1);
	_tmp81_ = colors_grid;
	_tmp82_ = self->priv->cursor_button;
	gtk_grid_attach (_tmp81_, (GtkWidget*) _tmp82_, 1, 6, 1, 1);
	_tmp83_ = colors_grid;
	_tmp84_ = black_color_label;
	gtk_grid_attach (_tmp83_, (GtkWidget*) _tmp84_, 0, 8, 1, 1);
	_tmp85_ = colors_grid;
	_tmp86_ = self->priv->black_button;
	gtk_grid_attach (_tmp85_, (GtkWidget*) _tmp86_, 1, 8, 1, 1);
	_tmp87_ = colors_grid;
	_tmp88_ = dark_gray_color_label;
	gtk_grid_attach (_tmp87_, (GtkWidget*) _tmp88_, 2, 8, 1, 1);
	_tmp89_ = colors_grid;
	_tmp90_ = self->priv->dark_gray_button;
	gtk_grid_attach (_tmp89_, (GtkWidget*) _tmp90_, 3, 8, 1, 1);
	_tmp91_ = colors_grid;
	_tmp92_ = red_color_label;
	gtk_grid_attach (_tmp91_, (GtkWidget*) _tmp92_, 0, 9, 1, 1);
	_tmp93_ = colors_grid;
	_tmp94_ = self->priv->red_button;
	gtk_grid_attach (_tmp93_, (GtkWidget*) _tmp94_, 1, 9, 1, 1);
	_tmp95_ = colors_grid;
	_tmp96_ = light_red_color_label;
	gtk_grid_attach (_tmp95_, (GtkWidget*) _tmp96_, 2, 9, 1, 1);
	_tmp97_ = colors_grid;
	_tmp98_ = self->priv->light_red_button;
	gtk_grid_attach (_tmp97_, (GtkWidget*) _tmp98_, 3, 9, 1, 1);
	_tmp99_ = colors_grid;
	_tmp100_ = green_color_label;
	gtk_grid_attach (_tmp99_, (GtkWidget*) _tmp100_, 0, 10, 1, 1);
	_tmp101_ = colors_grid;
	_tmp102_ = self->priv->green_button;
	gtk_grid_attach (_tmp101_, (GtkWidget*) _tmp102_, 1, 10, 1, 1);
	_tmp103_ = colors_grid;
	_tmp104_ = light_green_color_label;
	gtk_grid_attach (_tmp103_, (GtkWidget*) _tmp104_, 2, 10, 1, 1);
	_tmp105_ = colors_grid;
	_tmp106_ = self->priv->light_green_button;
	gtk_grid_attach (_tmp105_, (GtkWidget*) _tmp106_, 3, 10, 1, 1);
	_tmp107_ = colors_grid;
	_tmp108_ = yellow_color_label;
	gtk_grid_attach (_tmp107_, (GtkWidget*) _tmp108_, 0, 11, 1, 1);
	_tmp109_ = colors_grid;
	_tmp110_ = self->priv->yellow_button;
	gtk_grid_attach (_tmp109_, (GtkWidget*) _tmp110_, 1, 11, 1, 1);
	_tmp111_ = colors_grid;
	_tmp112_ = light_yellow_color_label;
	gtk_grid_attach (_tmp111_, (GtkWidget*) _tmp112_, 2, 11, 1, 1);
	_tmp113_ = colors_grid;
	_tmp114_ = self->priv->light_yellow_button;
	gtk_grid_attach (_tmp113_, (GtkWidget*) _tmp114_, 3, 11, 1, 1);
	_tmp115_ = colors_grid;
	_tmp116_ = blue_color_label;
	gtk_grid_attach (_tmp115_, (GtkWidget*) _tmp116_, 0, 12, 1, 1);
	_tmp117_ = colors_grid;
	_tmp118_ = self->priv->blue_button;
	gtk_grid_attach (_tmp117_, (GtkWidget*) _tmp118_, 1, 12, 1, 1);
	_tmp119_ = colors_grid;
	_tmp120_ = light_blue_color_label;
	gtk_grid_attach (_tmp119_, (GtkWidget*) _tmp120_, 2, 12, 1, 1);
	_tmp121_ = colors_grid;
	_tmp122_ = self->priv->light_blue_button;
	gtk_grid_attach (_tmp121_, (GtkWidget*) _tmp122_, 3, 12, 1, 1);
	_tmp123_ = colors_grid;
	_tmp124_ = magenta_color_label;
	gtk_grid_attach (_tmp123_, (GtkWidget*) _tmp124_, 0, 13, 1, 1);
	_tmp125_ = colors_grid;
	_tmp126_ = self->priv->magenta_button;
	gtk_grid_attach (_tmp125_, (GtkWidget*) _tmp126_, 1, 13, 1, 1);
	_tmp127_ = colors_grid;
	_tmp128_ = light_magenta_color_label;
	gtk_grid_attach (_tmp127_, (GtkWidget*) _tmp128_, 2, 13, 1, 1);
	_tmp129_ = colors_grid;
	_tmp130_ = self->priv->light_magenta_button;
	gtk_grid_attach (_tmp129_, (GtkWidget*) _tmp130_, 3, 13, 1, 1);
	_tmp131_ = colors_grid;
	_tmp132_ = cyan_color_label;
	gtk_grid_attach (_tmp131_, (GtkWidget*) _tmp132_, 0, 14, 1, 1);
	_tmp133_ = colors_grid;
	_tmp134_ = self->priv->cyan_button;
	gtk_grid_attach (_tmp133_, (GtkWidget*) _tmp134_, 1, 14, 1, 1);
	_tmp135_ = colors_grid;
	_tmp136_ = light_cyan_color_label;
	gtk_grid_attach (_tmp135_, (GtkWidget*) _tmp136_, 2, 14, 1, 1);
	_tmp137_ = colors_grid;
	_tmp138_ = self->priv->light_cyan_button;
	gtk_grid_attach (_tmp137_, (GtkWidget*) _tmp138_, 3, 14, 1, 1);
	_tmp139_ = colors_grid;
	_tmp140_ = light_gray_color_label;
	gtk_grid_attach (_tmp139_, (GtkWidget*) _tmp140_, 0, 15, 1, 1);
	_tmp141_ = colors_grid;
	_tmp142_ = self->priv->light_gray_button;
	gtk_grid_attach (_tmp141_, (GtkWidget*) _tmp142_, 1, 15, 1, 1);
	_tmp143_ = colors_grid;
	_tmp144_ = white_color_label;
	gtk_grid_attach (_tmp143_, (GtkWidget*) _tmp144_, 2, 15, 1, 1);
	_tmp145_ = colors_grid;
	_tmp146_ = self->priv->white_button;
	gtk_grid_attach (_tmp145_, (GtkWidget*) _tmp146_, 3, 15, 1, 1);
	terminal_dialogs_color_preferences_update_buttons_from_settings (self);
	_tmp147_ = _data1_->contrast_image;
	terminal_dialogs_color_preferences_update_contrast (self, _tmp147_);
	_tmp148_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp149_ = colors_grid;
	gtk_container_add ((GtkContainer*) _tmp148_, (GtkWidget*) _tmp149_);
	_tmp150_ = gtk_dialog_add_button ((GtkDialog*) self, _ ("Close"), (gint) GTK_RESPONSE_CLOSE);
	_tmp151_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp150_, gtk_button_get_type (), GtkButton));
	close_button = _tmp151_;
	_tmp152_ = close_button;
	g_signal_connect_object (_tmp152_, "clicked", (GCallback) _gtk_widget_destroy_gtk_button_clicked, (GtkWidget*) self, 0);
	_tmp153_ = terminal_application_settings;
	g_settings_set_string (_tmp153_, "theme", TERMINAL_THEMES_CUSTOM);
	_tmp154_ = self->priv->black_button;
	g_signal_connect_object (_tmp154_, "color-set", (GCallback) _terminal_dialogs_color_preferences_update_palette_settings_gtk_color_button_color_set, self, 0);
	_tmp155_ = self->priv->red_button;
	g_signal_connect_object (_tmp155_, "color-set", (GCallback) _terminal_dialogs_color_preferences_update_palette_settings_gtk_color_button_color_set, self, 0);
	_tmp156_ = self->priv->green_button;
	g_signal_connect_object (_tmp156_, "color-set", (GCallback) _terminal_dialogs_color_preferences_update_palette_settings_gtk_color_button_color_set, self, 0);
	_tmp157_ = self->priv->yellow_button;
	g_signal_connect_object (_tmp157_, "color-set", (GCallback) _terminal_dialogs_color_preferences_update_palette_settings_gtk_color_button_color_set, self, 0);
	_tmp158_ = self->priv->blue_button;
	g_signal_connect_object (_tmp158_, "color-set", (GCallback) _terminal_dialogs_color_preferences_update_palette_settings_gtk_color_button_color_set, self, 0);
	_tmp159_ = self->priv->magenta_button;
	g_signal_connect_object (_tmp159_, "color-set", (GCallback) _terminal_dialogs_color_preferences_update_palette_settings_gtk_color_button_color_set, self, 0);
	_tmp160_ = self->priv->cyan_button;
	g_signal_connect_object (_tmp160_, "color-set", (GCallback) _terminal_dialogs_color_preferences_update_palette_settings_gtk_color_button_color_set, self, 0);
	_tmp161_ = self->priv->light_gray_button;
	g_signal_connect_object (_tmp161_, "color-set", (GCallback) _terminal_dialogs_color_preferences_update_palette_settings_gtk_color_button_color_set, self, 0);
	_tmp162_ = self->priv->dark_gray_button;
	g_signal_connect_object (_tmp162_, "color-set", (GCallback) _terminal_dialogs_color_preferences_update_palette_settings_gtk_color_button_color_set, self, 0);
	_tmp163_ = self->priv->light_red_button;
	g_signal_connect_object (_tmp163_, "color-set", (GCallback) _terminal_dialogs_color_preferences_update_palette_settings_gtk_color_button_color_set, self, 0);
	_tmp164_ = self->priv->light_green_button;
	g_signal_connect_object (_tmp164_, "color-set", (GCallback) _terminal_dialogs_color_preferences_update_palette_settings_gtk_color_button_color_set, self, 0);
	_tmp165_ = self->priv->light_yellow_button;
	g_signal_connect_object (_tmp165_, "color-set", (GCallback) _terminal_dialogs_color_preferences_update_palette_settings_gtk_color_button_color_set, self, 0);
	_tmp166_ = self->priv->light_blue_button;
	g_signal_connect_object (_tmp166_, "color-set", (GCallback) _terminal_dialogs_color_preferences_update_palette_settings_gtk_color_button_color_set, self, 0);
	_tmp167_ = self->priv->light_magenta_button;
	g_signal_connect_object (_tmp167_, "color-set", (GCallback) _terminal_dialogs_color_preferences_update_palette_settings_gtk_color_button_color_set, self, 0);
	_tmp168_ = self->priv->light_cyan_button;
	g_signal_connect_object (_tmp168_, "color-set", (GCallback) _terminal_dialogs_color_preferences_update_palette_settings_gtk_color_button_color_set, self, 0);
	_tmp169_ = self->priv->white_button;
	g_signal_connect_object (_tmp169_, "color-set", (GCallback) _terminal_dialogs_color_preferences_update_palette_settings_gtk_color_button_color_set, self, 0);
	_tmp170_ = default_button;
	g_signal_connect_object (_tmp170_, "clicked", (GCallback) __terminal_dialogs_color_preferences___lambda47__gtk_button_clicked, self, 0);
	_tmp171_ = self->priv->background_button;
	g_signal_connect_data (_tmp171_, "color-set", (GCallback) __terminal_dialogs_color_preferences___lambda48__gtk_color_button_color_set, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp172_ = self->priv->foreground_button;
	g_signal_connect_data (_tmp172_, "color-set", (GCallback) __terminal_dialogs_color_preferences___lambda49__gtk_color_button_color_set, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp173_ = self->priv->cursor_button;
	g_signal_connect_object (_tmp173_, "color-set", (GCallback) __terminal_dialogs_color_preferences___lambda50__gtk_color_button_color_set, self, 0);
	_tmp174_ = _data1_->contrast_top_label;
	g_signal_connect_data ((GtkWidget*) _tmp174_, "state-flags-changed", (GCallback) __terminal_dialogs_color_preferences___lambda51__gtk_widget_state_flags_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp175_ = gtk_bin_get_child ((GtkBin*) self);
	g_signal_connect_object ((GtkWidget*) self, "show", (GCallback) _gtk_widget_show_all_gtk_widget_show, _tmp175_, 0);
	_g_object_unref0 (close_button);
	_g_object_unref0 (colors_grid);
	_g_object_unref0 (contrast_grid);
	_g_object_unref0 (cursor_label);
	_g_object_unref0 (foreground_label);
	_g_object_unref0 (background_label);
	_g_object_unref0 (light_gray_color_label);
	_g_object_unref0 (light_cyan_color_label);
	_g_object_unref0 (light_magenta_color_label);
	_g_object_unref0 (light_blue_color_label);
	_g_object_unref0 (light_yellow_color_label);
	_g_object_unref0 (light_green_color_label);
	_g_object_unref0 (light_red_color_label);
	_g_object_unref0 (white_color_label);
	_g_object_unref0 (dark_gray_color_label);
	_g_object_unref0 (cyan_color_label);
	_g_object_unref0 (magenta_color_label);
	_g_object_unref0 (blue_color_label);
	_g_object_unref0 (yellow_color_label);
	_g_object_unref0 (green_color_label);
	_g_object_unref0 (red_color_label);
	_g_object_unref0 (black_color_label);
	_g_object_unref0 (default_button);
	_g_object_unref0 (palette_header);
	_g_object_unref0 (window_theme_switch);
	_g_object_unref0 (window_theme_label);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return obj;
}

static void
terminal_dialogs_color_preferences_class_init (TerminalDialogsColorPreferencesClass * klass,
                                               gpointer klass_data)
{
	terminal_dialogs_color_preferences_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TerminalDialogsColorPreferences_private_offset);
	G_OBJECT_CLASS (klass)->constructor = terminal_dialogs_color_preferences_constructor;
	G_OBJECT_CLASS (klass)->finalize = terminal_dialogs_color_preferences_finalize;
}

static void
terminal_dialogs_color_preferences_instance_init (TerminalDialogsColorPreferences * self,
                                                  gpointer klass)
{
	self->priv = terminal_dialogs_color_preferences_get_instance_private (self);
}

static void
terminal_dialogs_color_preferences_finalize (GObject * obj)
{
	TerminalDialogsColorPreferences * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TERMINAL_DIALOGS_TYPE_COLOR_PREFERENCES, TerminalDialogsColorPreferences);
	_g_object_unref0 (self->priv->black_button);
	_g_object_unref0 (self->priv->red_button);
	_g_object_unref0 (self->priv->green_button);
	_g_object_unref0 (self->priv->yellow_button);
	_g_object_unref0 (self->priv->blue_button);
	_g_object_unref0 (self->priv->magenta_button);
	_g_object_unref0 (self->priv->cyan_button);
	_g_object_unref0 (self->priv->light_gray_button);
	_g_object_unref0 (self->priv->dark_gray_button);
	_g_object_unref0 (self->priv->light_red_button);
	_g_object_unref0 (self->priv->light_green_button);
	_g_object_unref0 (self->priv->light_yellow_button);
	_g_object_unref0 (self->priv->light_blue_button);
	_g_object_unref0 (self->priv->light_magenta_button);
	_g_object_unref0 (self->priv->light_cyan_button);
	_g_object_unref0 (self->priv->white_button);
	_g_object_unref0 (self->priv->background_button);
	_g_object_unref0 (self->priv->foreground_button);
	_g_object_unref0 (self->priv->cursor_button);
	G_OBJECT_CLASS (terminal_dialogs_color_preferences_parent_class)->finalize (obj);
}

static GType
terminal_dialogs_color_preferences_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TerminalDialogsColorPreferencesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) terminal_dialogs_color_preferences_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TerminalDialogsColorPreferences), 0, (GInstanceInitFunc) terminal_dialogs_color_preferences_instance_init, NULL };
	GType terminal_dialogs_color_preferences_type_id;
	terminal_dialogs_color_preferences_type_id = g_type_register_static (GRANITE_TYPE_DIALOG, "TerminalDialogsColorPreferences", &g_define_type_info, 0);
	TerminalDialogsColorPreferences_private_offset = g_type_add_instance_private (terminal_dialogs_color_preferences_type_id, sizeof (TerminalDialogsColorPreferencesPrivate));
	return terminal_dialogs_color_preferences_type_id;
}

GType
terminal_dialogs_color_preferences_get_type (void)
{
	static volatile gsize terminal_dialogs_color_preferences_type_id__once = 0;
	if (g_once_init_enter (&terminal_dialogs_color_preferences_type_id__once)) {
		GType terminal_dialogs_color_preferences_type_id;
		terminal_dialogs_color_preferences_type_id = terminal_dialogs_color_preferences_get_type_once ();
		g_once_init_leave (&terminal_dialogs_color_preferences_type_id__once, terminal_dialogs_color_preferences_type_id);
	}
	return terminal_dialogs_color_preferences_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

