/* LibraryItem.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from LibraryItem.vala, do not modify */

/*-
 * Copyright 2016-2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Artem Anufrij <artem.anufrij@live.de>
 *
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <granite-7.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>

#define AUDIENCE_SERVICES_POSTER_WIDTH 300
#define AUDIENCE_SERVICES_POSTER_HEIGHT ((gint) ((AUDIENCE_SERVICES_POSTER_WIDTH * 9) / 16))
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define AUDIENCE_TYPE_LIBRARY_ITEM (audience_library_item_get_type ())
#define AUDIENCE_LIBRARY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem))
#define AUDIENCE_LIBRARY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItemClass))
#define AUDIENCE_IS_LIBRARY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_LIBRARY_ITEM))
#define AUDIENCE_IS_LIBRARY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_LIBRARY_ITEM))
#define AUDIENCE_LIBRARY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItemClass))

typedef struct _AudienceLibraryItem AudienceLibraryItem;
typedef struct _AudienceLibraryItemClass AudienceLibraryItemClass;
typedef struct _AudienceLibraryItemPrivate AudienceLibraryItemPrivate;
typedef enum  {
	AUDIENCE_LIBRARY_ITEM_STYLE_THUMBNAIL,
	AUDIENCE_LIBRARY_ITEM_STYLE_ROW
} AudienceLibraryItemStyle;

#define AUDIENCE_LIBRARY_ITEM_TYPE_STYLE (audience_library_item_style_get_type ())

#define AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM (audience_objects_media_item_get_type ())
#define AUDIENCE_OBJECTS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItem))
#define AUDIENCE_OBJECTS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItemClass))
#define AUDIENCE_OBJECTS_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM))
#define AUDIENCE_OBJECTS_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM))
#define AUDIENCE_OBJECTS_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItemClass))

typedef struct _AudienceObjectsMediaItem AudienceObjectsMediaItem;
typedef struct _AudienceObjectsMediaItemClass AudienceObjectsMediaItemClass;
enum  {
	AUDIENCE_LIBRARY_ITEM_0_PROPERTY,
	AUDIENCE_LIBRARY_ITEM_STYLE_PROPERTY,
	AUDIENCE_LIBRARY_ITEM_NUM_PROPERTIES
};
static GParamSpec* audience_library_item_properties[AUDIENCE_LIBRARY_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block13Data Block13Data;
#define _g_free0(var) (var = (g_free (var), NULL))

#define AUDIENCE_TYPE_APP (audience_app_get_type ())
#define AUDIENCE_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_APP, AudienceApp))
#define AUDIENCE_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_APP, AudienceAppClass))
#define AUDIENCE_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_APP))
#define AUDIENCE_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_APP))
#define AUDIENCE_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_APP, AudienceAppClass))

typedef struct _AudienceApp AudienceApp;
typedef struct _AudienceAppClass AudienceAppClass;
typedef struct _AudienceAppPrivate AudienceAppPrivate;

#define AUDIENCE_TYPE_WINDOW (audience_window_get_type ())
#define AUDIENCE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_WINDOW, AudienceWindow))
#define AUDIENCE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_WINDOW, AudienceWindowClass))
#define AUDIENCE_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_WINDOW))
#define AUDIENCE_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_WINDOW))
#define AUDIENCE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_WINDOW, AudienceWindowClass))

typedef struct _AudienceWindow AudienceWindow;
typedef struct _AudienceWindowClass AudienceWindowClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _AudienceLibraryItemSetNewCoverData AudienceLibraryItemSetNewCoverData;
typedef struct _Block14Data Block14Data;

struct _AudienceLibraryItem {
	GtkBox parent_instance;
	AudienceLibraryItemPrivate * priv;
};

struct _AudienceLibraryItemClass {
	GtkBoxClass parent_class;
};

struct _AudienceLibraryItemPrivate {
	AudienceLibraryItemStyle _style;
	GtkLabel* title_label;
	GtkPicture* poster;
	GtkStack* spinner_stack;
	AudienceObjectsMediaItem* item;
};

struct _Block13Data {
	int _ref_count_;
	AudienceLibraryItem* self;
	AudienceObjectsMediaItem* item;
};

struct _AudienceApp {
	GtkApplication parent_instance;
	AudienceAppPrivate * priv;
	AudienceWindow* mainwindow;
	GVolumeMonitor* monitor;
};

struct _AudienceAppClass {
	GtkApplicationClass parent_class;
};

struct _AudienceLibraryItemSetNewCoverData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AudienceLibraryItem* self;
	GtkFileFilter* image_filter;
	GtkFileFilter* _tmp0_;
	GListStore* filters;
	GListStore* _tmp1_;
	GtkFileDialog* file_dialog;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GListModel* _tmp4_;
	GtkFileDialog* _tmp5_;
	GFile* cover;
	AudienceApp* _tmp6_;
	AudienceApp* _tmp7_;
	AudienceWindow* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	AudienceObjectsMediaItem* _tmp11_;
	GError* err;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GError* _inner_error0_;
};

struct _Block14Data {
	int _ref_count_;
	AudienceLibraryItem* self;
	GtkPopover* context_menu;
};

static gint AudienceLibraryItem_private_offset;
static gpointer audience_library_item_parent_class = NULL;

VALA_EXTERN GType audience_library_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceLibraryItem, g_object_unref)
VALA_EXTERN GType audience_library_item_style_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType audience_objects_media_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceObjectsMediaItem, g_object_unref)
VALA_EXTERN AudienceLibraryItem* audience_library_item_new (AudienceLibraryItemStyle style);
VALA_EXTERN AudienceLibraryItem* audience_library_item_construct (GType object_type,
                                                      AudienceLibraryItemStyle style);
VALA_EXTERN void audience_library_item_bind (AudienceLibraryItem* self,
                                 AudienceObjectsMediaItem* item);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
VALA_EXTERN const gchar* audience_objects_media_item_get_title (AudienceObjectsMediaItem* self);
VALA_EXTERN AudienceLibraryItemStyle audience_library_item_get_style (AudienceLibraryItem* self);
static void ___lambda32_ (Block13Data* _data13_);
VALA_EXTERN GdkPixbuf* audience_objects_media_item_get_poster (AudienceObjectsMediaItem* self);
static void ____lambda32__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void audience_library_item_poster_visibility (AudienceLibraryItem* self);
static void audience_library_item_set_new_cover_data_free (gpointer _data);
static void audience_library_item_set_new_cover (AudienceLibraryItem* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static void audience_library_item_set_new_cover_finish (AudienceLibraryItem* self,
                                                 GAsyncResult* _res_);
static gboolean audience_library_item_set_new_cover_co (AudienceLibraryItemSetNewCoverData* _data_);
VALA_EXTERN GType audience_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceApp, g_object_unref)
VALA_EXTERN AudienceApp* audience_app_get_instance (void);
VALA_EXTERN GType audience_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceWindow, g_object_unref)
static void audience_library_item_set_new_cover_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
VALA_EXTERN void audience_objects_media_item_set_custom_poster (AudienceObjectsMediaItem* self,
                                                    GFile* new_poster_file,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
VALA_EXTERN void audience_objects_media_item_set_custom_poster_finish (AudienceObjectsMediaItem* self,
                                                           GAsyncResult* _res_);
static void audience_library_item_set_style (AudienceLibraryItem* self,
                                      AudienceLibraryItemStyle value);
static GObject * audience_library_item_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static void _audience_library_item____lambda33_ (Block14Data* _data14_);
static void __audience_library_item____lambda33__gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self);
static void _audience_library_item_poster_visibility_gtk_widget_map (GtkWidget* _sender,
                                                              gpointer self);
static void _audience_library_item_poster_visibility_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self);
static void _audience_library_item___lambda34_ (Block14Data* _data14_);
VALA_EXTERN void audience_objects_media_item_trash (AudienceObjectsMediaItem* self);
static void __audience_library_item___lambda34__gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self);
static void _audience_library_item___lambda35_ (Block14Data* _data14_,
                                         gint n_press,
                                         gdouble x,
                                         gdouble y);
static void __audience_library_item___lambda35__gtk_gesture_click_released (GtkGestureClick* _sender,
                                                                     gint n_press,
                                                                     gdouble x,
                                                                     gdouble y,
                                                                     gpointer self);
static void audience_library_item_finalize (GObject * obj);
static GType audience_library_item_get_type_once (void);
static void _vala_audience_library_item_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_audience_library_item_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
audience_library_item_get_instance_private (AudienceLibraryItem* self)
{
	return G_STRUCT_MEMBER_P (self, AudienceLibraryItem_private_offset);
}

static GType
audience_library_item_style_get_type_once (void)
{
	static const GEnumValue values[] = {{AUDIENCE_LIBRARY_ITEM_STYLE_THUMBNAIL, "AUDIENCE_LIBRARY_ITEM_STYLE_THUMBNAIL", "thumbnail"}, {AUDIENCE_LIBRARY_ITEM_STYLE_ROW, "AUDIENCE_LIBRARY_ITEM_STYLE_ROW", "row"}, {0, NULL, NULL}};
	GType audience_library_item_style_type_id;
	audience_library_item_style_type_id = g_enum_register_static ("AudienceLibraryItemStyle", values);
	return audience_library_item_style_type_id;
}

GType
audience_library_item_style_get_type (void)
{
	static volatile gsize audience_library_item_style_type_id__once = 0;
	if (g_once_init_enter (&audience_library_item_style_type_id__once)) {
		GType audience_library_item_style_type_id;
		audience_library_item_style_type_id = audience_library_item_style_get_type_once ();
		g_once_init_leave (&audience_library_item_style_type_id__once, audience_library_item_style_type_id);
	}
	return audience_library_item_style_type_id__once;
}

AudienceLibraryItem*
audience_library_item_construct (GType object_type,
                                 AudienceLibraryItemStyle style)
{
	AudienceLibraryItem * self = NULL;
	self = (AudienceLibraryItem*) g_object_new (object_type, "style", style, NULL);
	return self;
}

AudienceLibraryItem*
audience_library_item_new (AudienceLibraryItemStyle style)
{
	return audience_library_item_construct (AUDIENCE_TYPE_LIBRARY_ITEM, style);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		AudienceLibraryItem* self;
		self = _data13_->self;
		_g_object_unref0 (_data13_->item);
		_g_object_unref0 (self);
		g_slice_free (Block13Data, _data13_);
	}
}

static void
___lambda32_ (Block13Data* _data13_)
{
	AudienceLibraryItem* self;
	GtkPicture* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	self = _data13_->self;
	_tmp0_ = self->priv->poster;
	_tmp1_ = audience_objects_media_item_get_poster (_data13_->item);
	_tmp2_ = _tmp1_;
	gtk_picture_set_pixbuf (_tmp0_, _tmp2_);
}

static void
____lambda32__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda32_ (self);
}

void
audience_library_item_bind (AudienceLibraryItem* self,
                            AudienceObjectsMediaItem* item)
{
	Block13Data* _data13_;
	AudienceObjectsMediaItem* _tmp0_;
	AudienceObjectsMediaItem* _tmp1_;
	GtkLabel* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	AudienceLibraryItemStyle _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (item);
	_g_object_unref0 (_data13_->item);
	_data13_->item = _tmp0_;
	_tmp1_ = _g_object_ref0 (_data13_->item);
	_g_object_unref0 (self->priv->item);
	self->priv->item = _tmp1_;
	_tmp2_ = self->priv->title_label;
	_tmp3_ = audience_objects_media_item_get_title (_data13_->item);
	_tmp4_ = _tmp3_;
	gtk_label_set_label (_tmp2_, _tmp4_);
	_tmp5_ = self->priv->_style;
	if (_tmp5_ == AUDIENCE_LIBRARY_ITEM_STYLE_THUMBNAIL) {
		GtkPicture* _tmp6_;
		GdkPixbuf* _tmp7_;
		GdkPixbuf* _tmp8_;
		g_signal_connect_data ((GObject*) _data13_->item, "notify::poster", (GCallback) ____lambda32__g_object_notify, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
		_tmp6_ = self->priv->poster;
		_tmp7_ = audience_objects_media_item_get_poster (_data13_->item);
		_tmp8_ = _tmp7_;
		gtk_picture_set_pixbuf (_tmp6_, _tmp8_);
	}
	block13_data_unref (_data13_);
	_data13_ = NULL;
}

static void
audience_library_item_poster_visibility (AudienceLibraryItem* self)
{
	GtkPicture* _tmp0_;
	GdkPaintable* _tmp1_;
	GdkPaintable* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->poster;
	_tmp1_ = gtk_picture_get_paintable (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		GtkStack* _tmp3_;
		_tmp3_ = self->priv->spinner_stack;
		gtk_stack_set_visible_child_name (_tmp3_, "poster");
	} else {
		GtkStack* _tmp4_;
		_tmp4_ = self->priv->spinner_stack;
		gtk_stack_set_visible_child_name (_tmp4_, "spinner");
	}
}

static void
audience_library_item_set_new_cover_data_free (gpointer _data)
{
	AudienceLibraryItemSetNewCoverData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AudienceLibraryItemSetNewCoverData, _data_);
}

static void
audience_library_item_set_new_cover (AudienceLibraryItem* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	AudienceLibraryItemSetNewCoverData* _data_;
	AudienceLibraryItem* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AudienceLibraryItemSetNewCoverData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, audience_library_item_set_new_cover_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	audience_library_item_set_new_cover_co (_data_);
}

static void
audience_library_item_set_new_cover_finish (AudienceLibraryItem* self,
                                            GAsyncResult* _res_)
{
	AudienceLibraryItemSetNewCoverData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
audience_library_item_set_new_cover_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	AudienceLibraryItemSetNewCoverData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	audience_library_item_set_new_cover_co (_data_);
}

static gboolean
audience_library_item_set_new_cover_co (AudienceLibraryItemSetNewCoverData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gtk_file_filter_new ();
	_data_->image_filter = _data_->_tmp0_;
	gtk_file_filter_set_name (_data_->image_filter, _ ("Image files"));
	gtk_file_filter_add_mime_type (_data_->image_filter, "image/*");
	_data_->_tmp1_ = g_list_store_new (gtk_file_filter_get_type ());
	_data_->filters = _data_->_tmp1_;
	g_list_store_append (_data_->filters, (GObject*) _data_->image_filter);
	_data_->_tmp2_ = g_strdup (_ ("Open"));
	_data_->_tmp3_ = g_strdup (_ ("_Open"));
	_data_->_tmp4_ = _g_object_ref0 ((GListModel*) _data_->filters);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = gtk_file_dialog_new ();
	gtk_file_dialog_set_title (_data_->_tmp5_, _data_->_tmp2_);
	_g_free0 (_data_->_tmp2_);
	gtk_file_dialog_set_accept_label (_data_->_tmp5_, _data_->_tmp3_);
	_g_free0 (_data_->_tmp3_);
	gtk_file_dialog_set_filters (_data_->_tmp5_, _data_->_tmp4_);
	_g_object_unref0 (_data_->_tmp4_);
	_data_->file_dialog = _data_->_tmp5_;
	{
		_data_->_tmp6_ = audience_app_get_instance ();
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = _data_->_tmp7_->mainwindow;
		_data_->_state_ = 1;
		gtk_file_dialog_open (_data_->file_dialog, (GtkWindow*) _data_->_tmp8_, NULL, audience_library_item_set_new_cover_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp9_ = gtk_file_dialog_open_finish (_data_->file_dialog, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp10_ = _data_->_tmp9_;
		_g_object_unref0 (_data_->_tmp7_);
		_data_->cover = _data_->_tmp10_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp11_ = _data_->self->priv->item;
		_data_->_state_ = 2;
		audience_objects_media_item_set_custom_poster (_data_->_tmp11_, _data_->cover, audience_library_item_set_new_cover_ready, _data_);
		return FALSE;
		_state_2:
		audience_objects_media_item_set_custom_poster_finish (_data_->_tmp11_, _data_->_res_);
		_g_object_unref0 (_data_->cover);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp12_ = _data_->err;
		_data_->_tmp13_ = _data_->_tmp12_->message;
		g_warning ("LibraryItem.vala:185: Failed to select new cover: %s", _data_->_tmp13_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->file_dialog);
		_g_object_unref0 (_data_->filters);
		_g_object_unref0 (_data_->image_filter);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->file_dialog);
	_g_object_unref0 (_data_->filters);
	_g_object_unref0 (_data_->image_filter);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

AudienceLibraryItemStyle
audience_library_item_get_style (AudienceLibraryItem* self)
{
	AudienceLibraryItemStyle result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_style;
	return result;
}

static void
audience_library_item_set_style (AudienceLibraryItem* self,
                                 AudienceLibraryItemStyle value)
{
	AudienceLibraryItemStyle old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_library_item_get_style (self);
	if (old_value != value) {
		self->priv->_style = value;
		g_object_notify_by_pspec ((GObject *) self, audience_library_item_properties[AUDIENCE_LIBRARY_ITEM_STYLE_PROPERTY]);
	}
}

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		AudienceLibraryItem* self;
		self = _data14_->self;
		_g_object_unref0 (_data14_->context_menu);
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}

static void
_audience_library_item____lambda33_ (Block14Data* _data14_)
{
	AudienceLibraryItem* self;
	GtkPopover* _tmp0_;
	self = _data14_->self;
	_tmp0_ = _data14_->context_menu;
	gtk_popover_popdown (_tmp0_);
	audience_library_item_set_new_cover (self, NULL, NULL);
}

static void
__audience_library_item____lambda33__gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self)
{
	_audience_library_item____lambda33_ (self);
}

static void
_audience_library_item_poster_visibility_gtk_widget_map (GtkWidget* _sender,
                                                         gpointer self)
{
	audience_library_item_poster_visibility ((AudienceLibraryItem*) self);
}

static void
_audience_library_item_poster_visibility_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self)
{
	audience_library_item_poster_visibility ((AudienceLibraryItem*) self);
}

static void
_audience_library_item___lambda34_ (Block14Data* _data14_)
{
	AudienceLibraryItem* self;
	GtkPopover* _tmp0_;
	AudienceObjectsMediaItem* _tmp1_;
	self = _data14_->self;
	_tmp0_ = _data14_->context_menu;
	gtk_popover_popdown (_tmp0_);
	_tmp1_ = self->priv->item;
	audience_objects_media_item_trash (_tmp1_);
}

static void
__audience_library_item___lambda34__gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self)
{
	_audience_library_item___lambda34_ (self);
}

static void
_audience_library_item___lambda35_ (Block14Data* _data14_,
                                    gint n_press,
                                    gdouble x,
                                    gdouble y)
{
	AudienceLibraryItem* self;
	GtkPopover* _tmp0_;
	GdkRectangle _tmp1_ = {0};
	GtkPopover* _tmp2_;
	self = _data14_->self;
	_tmp0_ = _data14_->context_menu;
	memset (&_tmp1_, 0, sizeof (GdkRectangle));
	_tmp1_.x = (gint) x;
	_tmp1_.y = (gint) y;
	g_object_set (_tmp0_, "pointing-to", &_tmp1_, NULL);
	_tmp2_ = _data14_->context_menu;
	gtk_popover_popup (_tmp2_);
}

static void
__audience_library_item___lambda35__gtk_gesture_click_released (GtkGestureClick* _sender,
                                                                gint n_press,
                                                                gdouble x,
                                                                gdouble y,
                                                                gpointer self)
{
	_audience_library_item___lambda35_ (self, n_press, x, y);
}

static GObject *
audience_library_item_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AudienceLibraryItem * self;
	Block14Data* _data14_;
	GtkButton* move_to_trash = NULL;
	GtkLabel* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkButton* _tmp2_;
	GtkBox* context_menu_box = NULL;
	GtkBox* _tmp3_;
	GtkBox* _tmp4_;
	GtkButton* _tmp5_;
	GtkBox* _tmp6_;
	GtkWidget* _tmp7_;
	GtkPopover* _tmp8_ = NULL;
	GtkPopover* _tmp9_;
	GtkPopover* _tmp10_;
	GtkLabel* _tmp11_;
	AudienceLibraryItemStyle _tmp12_;
	GtkButton* _tmp40_;
	GtkGestureClick* gesture_click = NULL;
	GtkGestureClick* _tmp41_ = NULL;
	GtkGestureClick* _tmp42_;
	GtkEventController* _tmp43_;
	GtkGestureClick* _tmp44_;
	parent_class = G_OBJECT_CLASS (audience_library_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem);
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->self = g_object_ref (self);
	_tmp0_ = (GtkLabel*) gtk_label_new (_ ("Move to Trash"));
	gtk_widget_set_halign ((GtkWidget*) _tmp0_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = (GtkButton*) gtk_button_new ();
	gtk_button_set_child (_tmp1_, (GtkWidget*) _tmp0_);
	_g_object_unref0 (_tmp0_);
	g_object_ref_sink (_tmp1_);
	move_to_trash = _tmp1_;
	_tmp2_ = move_to_trash;
	gtk_widget_add_css_class ((GtkWidget*) _tmp2_, GRANITE_STYLE_CLASS_MENUITEM);
	_tmp3_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp3_);
	context_menu_box = _tmp3_;
	_tmp4_ = context_menu_box;
	_tmp5_ = move_to_trash;
	gtk_box_append (_tmp4_, (GtkWidget*) _tmp5_);
	_tmp6_ = context_menu_box;
	_tmp7_ = _g_object_ref0 ((GtkWidget*) _tmp6_);
	_tmp8_ = (GtkPopover*) gtk_popover_new ();
	gtk_popover_set_child (_tmp8_, _tmp7_);
	_g_object_unref0 (_tmp7_);
	gtk_widget_set_halign ((GtkWidget*) _tmp8_, GTK_ALIGN_START);
	gtk_popover_set_has_arrow (_tmp8_, FALSE);
	gtk_popover_set_position (_tmp8_, GTK_POS_BOTTOM);
	g_object_ref_sink (_tmp8_);
	_data14_->context_menu = _tmp8_;
	_tmp9_ = _data14_->context_menu;
	gtk_widget_add_css_class ((GtkWidget*) _tmp9_, GRANITE_STYLE_CLASS_MENU);
	_tmp10_ = _data14_->context_menu;
	gtk_widget_set_parent ((GtkWidget*) _tmp10_, (GtkWidget*) self);
	_tmp11_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->title_label);
	self->priv->title_label = _tmp11_;
	_tmp12_ = self->priv->_style;
	if (_tmp12_ == AUDIENCE_LIBRARY_ITEM_STYLE_THUMBNAIL) {
		GtkLabel* _tmp13_;
		GtkLabel* _tmp14_;
		GtkLabel* _tmp15_;
		GtkLabel* _tmp16_;
		GtkButton* new_cover = NULL;
		GtkLabel* _tmp17_ = NULL;
		GtkButton* _tmp18_ = NULL;
		GtkButton* _tmp19_;
		GtkBox* _tmp20_;
		GtkSeparator* _tmp21_;
		GtkSeparator* _tmp22_;
		GtkBox* _tmp23_;
		GtkButton* _tmp24_;
		GtkPicture* _tmp25_ = NULL;
		GtkSpinner* spinner = NULL;
		GtkSpinner* _tmp26_ = NULL;
		GtkStack* _tmp27_ = NULL;
		GtkStack* _tmp28_;
		GtkStack* _tmp29_;
		GtkStack* _tmp30_;
		GtkSpinner* _tmp31_;
		GtkStack* _tmp32_;
		GtkPicture* _tmp33_;
		GtkStack* _tmp34_;
		GtkLabel* _tmp35_;
		GtkButton* _tmp36_;
		GtkPicture* _tmp37_;
		_tmp13_ = self->priv->title_label;
		gtk_label_set_ellipsize (_tmp13_, PANGO_ELLIPSIZE_END);
		_tmp14_ = self->priv->title_label;
		gtk_label_set_wrap (_tmp14_, TRUE);
		_tmp15_ = self->priv->title_label;
		gtk_label_set_max_width_chars (_tmp15_, 0);
		_tmp16_ = self->priv->title_label;
		gtk_label_set_justify (_tmp16_, GTK_JUSTIFY_CENTER);
		_tmp17_ = (GtkLabel*) gtk_label_new (_ ("Set Artwork"));
		gtk_widget_set_halign ((GtkWidget*) _tmp17_, GTK_ALIGN_START);
		g_object_ref_sink (_tmp17_);
		_tmp18_ = (GtkButton*) gtk_button_new ();
		gtk_button_set_child (_tmp18_, (GtkWidget*) _tmp17_);
		_g_object_unref0 (_tmp17_);
		g_object_ref_sink (_tmp18_);
		new_cover = _tmp18_;
		_tmp19_ = new_cover;
		gtk_widget_add_css_class ((GtkWidget*) _tmp19_, GRANITE_STYLE_CLASS_MENUITEM);
		_tmp20_ = context_menu_box;
		_tmp21_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
		g_object_ref_sink (_tmp21_);
		_tmp22_ = _tmp21_;
		gtk_box_append (_tmp20_, (GtkWidget*) _tmp22_);
		_g_object_unref0 (_tmp22_);
		_tmp23_ = context_menu_box;
		_tmp24_ = new_cover;
		gtk_box_append (_tmp23_, (GtkWidget*) _tmp24_);
		_tmp25_ = (GtkPicture*) gtk_picture_new ();
		gtk_picture_set_content_fit (_tmp25_, GTK_CONTENT_FIT_COVER);
		gtk_widget_set_hexpand ((GtkWidget*) _tmp25_, TRUE);
		gtk_widget_set_vexpand ((GtkWidget*) _tmp25_, TRUE);
		g_object_ref_sink (_tmp25_);
		_g_object_unref0 (self->priv->poster);
		self->priv->poster = _tmp25_;
		_tmp26_ = (GtkSpinner*) gtk_spinner_new ();
		gtk_spinner_set_spinning (_tmp26_, TRUE);
		gtk_widget_set_hexpand ((GtkWidget*) _tmp26_, TRUE);
		gtk_widget_set_vexpand ((GtkWidget*) _tmp26_, TRUE);
		gtk_widget_set_halign ((GtkWidget*) _tmp26_, GTK_ALIGN_CENTER);
		gtk_widget_set_valign ((GtkWidget*) _tmp26_, GTK_ALIGN_CENTER);
		g_object_set ((GtkWidget*) _tmp26_, "height-request", 32, NULL);
		g_object_set ((GtkWidget*) _tmp26_, "width-request", 32, NULL);
		g_object_ref_sink (_tmp26_);
		spinner = _tmp26_;
		_tmp27_ = (GtkStack*) gtk_stack_new ();
		g_object_set ((GtkWidget*) _tmp27_, "height-request", AUDIENCE_SERVICES_POSTER_HEIGHT, NULL);
		g_object_set ((GtkWidget*) _tmp27_, "width-request", AUDIENCE_SERVICES_POSTER_WIDTH, NULL);
		gtk_widget_set_halign ((GtkWidget*) _tmp27_, GTK_ALIGN_CENTER);
		gtk_widget_set_valign ((GtkWidget*) _tmp27_, GTK_ALIGN_CENTER);
		gtk_widget_set_overflow ((GtkWidget*) _tmp27_, GTK_OVERFLOW_HIDDEN);
		g_object_ref_sink (_tmp27_);
		_g_object_unref0 (self->priv->spinner_stack);
		self->priv->spinner_stack = _tmp27_;
		_tmp28_ = self->priv->spinner_stack;
		gtk_widget_add_css_class ((GtkWidget*) _tmp28_, GRANITE_STYLE_CLASS_CARD);
		_tmp29_ = self->priv->spinner_stack;
		gtk_widget_add_css_class ((GtkWidget*) _tmp29_, GRANITE_STYLE_CLASS_ROUNDED);
		_tmp30_ = self->priv->spinner_stack;
		_tmp31_ = spinner;
		gtk_stack_add_named (_tmp30_, (GtkWidget*) _tmp31_, "spinner");
		_tmp32_ = self->priv->spinner_stack;
		_tmp33_ = self->priv->poster;
		gtk_stack_add_named (_tmp32_, (GtkWidget*) _tmp33_, "poster");
		_tmp34_ = self->priv->spinner_stack;
		gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp34_);
		_tmp35_ = self->priv->title_label;
		gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp35_);
		_tmp36_ = new_cover;
		g_signal_connect_data (_tmp36_, "clicked", (GCallback) __audience_library_item____lambda33__gtk_button_clicked, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
		g_signal_connect_object ((GtkWidget*) self, "map", (GCallback) _audience_library_item_poster_visibility_gtk_widget_map, self, 0);
		_tmp37_ = self->priv->poster;
		g_signal_connect_object ((GObject*) _tmp37_, "notify::paintable", (GCallback) _audience_library_item_poster_visibility_g_object_notify, self, 0);
		_g_object_unref0 (spinner);
		_g_object_unref0 (new_cover);
	} else {
		GtkLabel* _tmp38_;
		GtkLabel* _tmp39_;
		_tmp38_ = self->priv->title_label;
		gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp38_);
		_tmp39_ = self->priv->title_label;
		gtk_widget_set_halign ((GtkWidget*) _tmp39_, GTK_ALIGN_START);
	}
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	gtk_box_set_spacing ((GtkBox*) self, 12);
	gtk_widget_set_hexpand ((GtkWidget*) self, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) self, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) self, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 12);
	gtk_widget_set_margin_start ((GtkWidget*) self, 12);
	gtk_widget_set_margin_end ((GtkWidget*) self, 12);
	_tmp40_ = move_to_trash;
	g_signal_connect_data (_tmp40_, "clicked", (GCallback) __audience_library_item___lambda34__gtk_button_clicked, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
	_tmp41_ = (GtkGestureClick*) gtk_gesture_click_new ();
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp41_, (guint) GDK_BUTTON_SECONDARY);
	gesture_click = _tmp41_;
	_tmp42_ = gesture_click;
	_tmp43_ = _g_object_ref0 ((GtkEventController*) _tmp42_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp43_);
	_tmp44_ = gesture_click;
	g_signal_connect_data (_tmp44_, "released", (GCallback) __audience_library_item___lambda35__gtk_gesture_click_released, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
	_g_object_unref0 (gesture_click);
	_g_object_unref0 (context_menu_box);
	_g_object_unref0 (move_to_trash);
	block14_data_unref (_data14_);
	_data14_ = NULL;
	return obj;
}

static void
audience_library_item_class_init (AudienceLibraryItemClass * klass,
                                  gpointer klass_data)
{
	audience_library_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AudienceLibraryItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_audience_library_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_audience_library_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = audience_library_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = audience_library_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_LIBRARY_ITEM_STYLE_PROPERTY, audience_library_item_properties[AUDIENCE_LIBRARY_ITEM_STYLE_PROPERTY] = g_param_spec_enum ("style", "style", "style", AUDIENCE_LIBRARY_ITEM_TYPE_STYLE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
audience_library_item_instance_init (AudienceLibraryItem * self,
                                     gpointer klass)
{
	self->priv = audience_library_item_get_instance_private (self);
}

static void
audience_library_item_finalize (GObject * obj)
{
	AudienceLibraryItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem);
	_g_object_unref0 (self->priv->title_label);
	_g_object_unref0 (self->priv->poster);
	_g_object_unref0 (self->priv->spinner_stack);
	_g_object_unref0 (self->priv->item);
	G_OBJECT_CLASS (audience_library_item_parent_class)->finalize (obj);
}

static GType
audience_library_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AudienceLibraryItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) audience_library_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AudienceLibraryItem), 0, (GInstanceInitFunc) audience_library_item_instance_init, NULL };
	GType audience_library_item_type_id;
	audience_library_item_type_id = g_type_register_static (gtk_box_get_type (), "AudienceLibraryItem", &g_define_type_info, 0);
	AudienceLibraryItem_private_offset = g_type_add_instance_private (audience_library_item_type_id, sizeof (AudienceLibraryItemPrivate));
	return audience_library_item_type_id;
}

GType
audience_library_item_get_type (void)
{
	static volatile gsize audience_library_item_type_id__once = 0;
	if (g_once_init_enter (&audience_library_item_type_id__once)) {
		GType audience_library_item_type_id;
		audience_library_item_type_id = audience_library_item_get_type_once ();
		g_once_init_leave (&audience_library_item_type_id__once, audience_library_item_type_id);
	}
	return audience_library_item_type_id__once;
}

static void
_vala_audience_library_item_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	AudienceLibraryItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem);
	switch (property_id) {
		case AUDIENCE_LIBRARY_ITEM_STYLE_PROPERTY:
		g_value_set_enum (value, audience_library_item_get_style (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_audience_library_item_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	AudienceLibraryItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem);
	switch (property_id) {
		case AUDIENCE_LIBRARY_ITEM_STYLE_PROPERTY:
		audience_library_item_set_style (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

