#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkMPIPixelView_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMPIPixelTT_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParallelTimer_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPLineIntegralConvolution2D_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPPainterCommunicator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPPixelTransfer_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPSurfaceLICComposite_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPSurfaceLICInterface_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkRenderingParallelLICCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkMPIPixelView_Init(csi);
  vtkMPIPixelTT_Init(csi);
  vtkParallelTimer_Init(csi);
  vtkPLineIntegralConvolution2D_Init(csi);
  vtkPPainterCommunicator_Init(csi);
  vtkPPixelTransfer_Init(csi);
  vtkPSurfaceLICComposite_Init(csi);
  vtkPSurfaceLICInterface_Init(csi);
}
