#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkCMLMoleculeReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGaussianCubeReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGaussianCubeReader2_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMoleculeReaderBase_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPDBReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkVASPAnimationReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkVASPTessellationReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkXYZMolReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkXYZMolReader2_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkIOChemistryCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkCMLMoleculeReader_Init(csi);
  vtkGaussianCubeReader_Init(csi);
  vtkGaussianCubeReader2_Init(csi);
  vtkMoleculeReaderBase_Init(csi);
  vtkPDBReader_Init(csi);
  vtkVASPAnimationReader_Init(csi);
  vtkVASPTessellationReader_Init(csi);
  vtkXYZMolReader_Init(csi);
  vtkXYZMolReader2_Init(csi);
}
