#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkAnimationPlayer_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCameraInterpolator2_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCompositeAnimationPlayer_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVAnimationCue_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVBooleanKeyFrame_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVCameraAnimationCue_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVCameraCueManipulator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVCameraKeyFrame_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVCompositeKeyFrame_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVCueManipulator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVExponentialKeyFrame_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVKeyFrame_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVKeyFrameAnimationCue_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVKeyFrameAnimationCueForProxies_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVKeyFrameCueManipulator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVRampKeyFrame_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVRepresentationAnimationHelper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVSinusoidKeyFrame_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSIXMLAnimationWriterRepresentationProperty_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSMAnimationFrameWindowDomain_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSMAnimationScene_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSMAnimationSceneGeometryWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSMAnimationSceneWebWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSMAnimationSceneProxy_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSMAnimationSceneWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSMSaveAnimationExtractsProxy_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSMSaveAnimationProxy_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSequenceAnimationPlayer_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTimestepsAnimationPlayer_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkXMLPVAnimationWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPythonAnimationCue_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkRemotingAnimationCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkAnimationPlayer_Init(csi);
  vtkCameraInterpolator2_Init(csi);
  vtkCompositeAnimationPlayer_Init(csi);
  vtkPVAnimationCue_Init(csi);
  vtkPVBooleanKeyFrame_Init(csi);
  vtkPVCameraAnimationCue_Init(csi);
  vtkPVCameraCueManipulator_Init(csi);
  vtkPVCameraKeyFrame_Init(csi);
  vtkPVCompositeKeyFrame_Init(csi);
  vtkPVCueManipulator_Init(csi);
  vtkPVExponentialKeyFrame_Init(csi);
  vtkPVKeyFrame_Init(csi);
  vtkPVKeyFrameAnimationCue_Init(csi);
  vtkPVKeyFrameAnimationCueForProxies_Init(csi);
  vtkPVKeyFrameCueManipulator_Init(csi);
  vtkPVRampKeyFrame_Init(csi);
  vtkPVRepresentationAnimationHelper_Init(csi);
  vtkPVSinusoidKeyFrame_Init(csi);
  vtkSIXMLAnimationWriterRepresentationProperty_Init(csi);
  vtkSMAnimationFrameWindowDomain_Init(csi);
  vtkSMAnimationScene_Init(csi);
  vtkSMAnimationSceneGeometryWriter_Init(csi);
  vtkSMAnimationSceneWebWriter_Init(csi);
  vtkSMAnimationSceneProxy_Init(csi);
  vtkSMAnimationSceneWriter_Init(csi);
  vtkSMSaveAnimationExtractsProxy_Init(csi);
  vtkSMSaveAnimationProxy_Init(csi);
  vtkSequenceAnimationPlayer_Init(csi);
  vtkTimestepsAnimationPlayer_Init(csi);
  vtkXMLPVAnimationWriter_Init(csi);
  vtkPythonAnimationCue_Init(csi);
}
