// python wrapper for vtkProcessModuleConfiguration
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkLogger.h"
#include "vtkProcessModule.h"
#include "vtkProcessModuleConfiguration.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkProcessModuleConfiguration(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkProcessModuleConfiguration_ClassNew(); }


static PyObject *
PyvtkProcessModuleConfiguration_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkProcessModuleConfiguration::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModuleConfiguration_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModuleConfiguration *op = static_cast<vtkProcessModuleConfiguration *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkProcessModuleConfiguration::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModuleConfiguration_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkProcessModuleConfiguration *tempr = vtkProcessModuleConfiguration::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModuleConfiguration_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModuleConfiguration *op = static_cast<vtkProcessModuleConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkProcessModuleConfiguration *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkProcessModuleConfiguration::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModuleConfiguration_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkProcessModuleConfiguration::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModuleConfiguration_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModuleConfiguration *op = static_cast<vtkProcessModuleConfiguration *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkProcessModuleConfiguration::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModuleConfiguration_GetInstance(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetInstance");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkProcessModuleConfiguration *tempr = vtkProcessModuleConfiguration::GetInstance();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModuleConfiguration_GetForceMPIInit(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceMPIInit");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModuleConfiguration *op = static_cast<vtkProcessModuleConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetForceMPIInit() :
      op->vtkProcessModuleConfiguration::GetForceMPIInit());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModuleConfiguration_GetForceNoMPIInit(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceNoMPIInit");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModuleConfiguration *op = static_cast<vtkProcessModuleConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetForceNoMPIInit() :
      op->vtkProcessModuleConfiguration::GetForceNoMPIInit());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModuleConfiguration_GetUseMPISSend(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseMPISSend");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModuleConfiguration *op = static_cast<vtkProcessModuleConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseMPISSend() :
      op->vtkProcessModuleConfiguration::GetUseMPISSend());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModuleConfiguration_GetSymmetricMPIMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSymmetricMPIMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModuleConfiguration *op = static_cast<vtkProcessModuleConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetSymmetricMPIMode() :
      op->vtkProcessModuleConfiguration::GetSymmetricMPIMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModuleConfiguration_SetSymmetricMPIMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSymmetricMPIMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModuleConfiguration *op = static_cast<vtkProcessModuleConfiguration *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSymmetricMPIMode(temp0);
    }
    else
    {
      op->vtkProcessModuleConfiguration::SetSymmetricMPIMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModuleConfiguration_GetVirtualEnvironmentPath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVirtualEnvironmentPath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModuleConfiguration *op = static_cast<vtkProcessModuleConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetVirtualEnvironmentPath() :
      op->vtkProcessModuleConfiguration::GetVirtualEnvironmentPath());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModuleConfiguration_GetLogStdErrVerbosity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLogStdErrVerbosity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModuleConfiguration *op = static_cast<vtkProcessModuleConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkLogger::Verbosity tempr = (ap.IsBound() ?
      op->GetLogStdErrVerbosity() :
      op->vtkProcessModuleConfiguration::GetLogStdErrVerbosity());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildEnumValue(tempr, "vtkLogger.Verbosity");
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModuleConfiguration_GetCSLogFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCSLogFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModuleConfiguration *op = static_cast<vtkProcessModuleConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetCSLogFileName() :
      op->vtkProcessModuleConfiguration::GetCSLogFileName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModuleConfiguration_GetEnableStackTrace(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnableStackTrace");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModuleConfiguration *op = static_cast<vtkProcessModuleConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEnableStackTrace() :
      op->vtkProcessModuleConfiguration::GetEnableStackTrace());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModuleConfiguration_PopulateOptions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PopulateOptions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModuleConfiguration *op = static_cast<vtkProcessModuleConfiguration *>(vp);

  vtkCLIOptions *temp0 = nullptr;
  vtkProcessModule::ProcessTypes temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkCLIOptions") &&
      ap.GetEnumValue(temp1, "vtkProcessModule.ProcessTypes"))
  {
    bool tempr = (ap.IsBound() ?
      op->PopulateOptions(temp0, temp1) :
      op->vtkProcessModuleConfiguration::PopulateOptions(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModuleConfiguration_GetRankAnnotatedFileName(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetRankAnnotatedFileName");

  std::string temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    std::string tempr = vtkProcessModuleConfiguration::GetRankAnnotatedFileName(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkProcessModuleConfiguration_Methods[] = {
  {"IsTypeOf", PyvtkProcessModuleConfiguration_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkProcessModuleConfiguration_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkProcessModuleConfiguration_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkProcessModuleConfiguration\nC++: static vtkProcessModuleConfiguration *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkProcessModuleConfiguration_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkProcessModuleConfiguration\nC++: vtkProcessModuleConfiguration *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkProcessModuleConfiguration_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkProcessModuleConfiguration_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetInstance", PyvtkProcessModuleConfiguration_GetInstance, METH_VARARGS,
   "GetInstance() -> vtkProcessModuleConfiguration\nC++: static vtkProcessModuleConfiguration *GetInstance()\n\nProvides access to the singleton.\n"},
  {"GetForceMPIInit", PyvtkProcessModuleConfiguration_GetForceMPIInit, METH_VARARGS,
   "GetForceMPIInit(self) -> bool\nC++: virtual bool GetForceMPIInit()\n\nGet whether to call `MPI_Init()` on this process irrespective of\nwhether MPI is needed on this process.\n"},
  {"GetForceNoMPIInit", PyvtkProcessModuleConfiguration_GetForceNoMPIInit, METH_VARARGS,
   "GetForceNoMPIInit(self) -> bool\nC++: virtual bool GetForceNoMPIInit()\n\nGet whether to not call `MPI_Init()` on this process irrespective\nof whether MPI is needed on this process.\n"},
  {"GetUseMPISSend", PyvtkProcessModuleConfiguration_GetUseMPISSend, METH_VARARGS,
   "GetUseMPISSend(self) -> bool\nC++: virtual bool GetUseMPISSend()\n\nFlag indicating whether to use synchronous send (SSend) for MPI\ncommunication.\n"},
  {"GetSymmetricMPIMode", PyvtkProcessModuleConfiguration_GetSymmetricMPIMode, METH_VARARGS,
   "GetSymmetricMPIMode(self) -> bool\nC++: virtual bool GetSymmetricMPIMode()\n\nGet whether to use symmetric MPI mode. In this mode is only\nsupported in \"batch\". In that case, all processes, including the\nsatellites, execute the Python script locally.\n"},
  {"SetSymmetricMPIMode", PyvtkProcessModuleConfiguration_SetSymmetricMPIMode, METH_VARARGS,
   "SetSymmetricMPIMode(self, _arg:bool) -> None\nC++: virtual void SetSymmetricMPIMode(bool _arg)\n\nIdeally, this method should not be public. However, we are\nkeeping it public to avoid changing to much code at this time.\n"},
  {"GetVirtualEnvironmentPath", PyvtkProcessModuleConfiguration_GetVirtualEnvironmentPath, METH_VARARGS,
   "GetVirtualEnvironmentPath(self) -> str\nC++: virtual std::string GetVirtualEnvironmentPath()\n\nGet the virtual environment path to set up for Python.\n"},
  {"GetLogStdErrVerbosity", PyvtkProcessModuleConfiguration_GetLogStdErrVerbosity, METH_VARARGS,
   "GetLogStdErrVerbosity(self) -> vtkLogger.Verbosity\nC++: virtual vtkLogger::Verbosity GetLogStdErrVerbosity()\n\nGet the verbosity level to use for reporting log messages on\n`stderr`. In other words, all messages at the chosen level and\nhigher are posted to `stderr`. Default is\n`vtkLogger::VERBOSITY_INVALID`.\n"},
  {"GetCSLogFileName", PyvtkProcessModuleConfiguration_GetCSLogFileName, METH_VARARGS,
   "GetCSLogFileName(self) -> str\nC++: std::string GetCSLogFileName()\n\nGet the filename to use to generate client-server-stream logs, if\nany. If running in a distributed mode, the filename is\nautomatically changed to include current rank index.\n"},
  {"GetEnableStackTrace", PyvtkProcessModuleConfiguration_GetEnableStackTrace, METH_VARARGS,
   "GetEnableStackTrace(self) -> bool\nC++: virtual bool GetEnableStackTrace()\n\nGet whether to generate a stack trace after a crash. This is\ncurrently only supported on POSIX systems.\n"},
  {"PopulateOptions", PyvtkProcessModuleConfiguration_PopulateOptions, METH_VARARGS,
   "PopulateOptions(self, options:vtkCLIOptions,\n    processType:vtkProcessModule.ProcessTypes) -> bool\nC++: bool PopulateOptions(vtkCLIOptions *options,\n    vtkProcessModule::ProcessTypes processType)\n\nPopulate command line options. `processType` indicates which type\nof ParaView process the options are being setup for. That may\naffect available options.\n"},
  {"GetRankAnnotatedFileName", PyvtkProcessModuleConfiguration_GetRankAnnotatedFileName, METH_VARARGS,
   "GetRankAnnotatedFileName(fname:str) -> str\nC++: static std::string GetRankAnnotatedFileName(\n    const std::string &fname)\n\nA helper function to add a rank number to the filename, if\nneeded. This is useful to create a separate log file per rank,\nfor example, when executing in parallel. If number of ranks is 1,\nthe filename is unchanged.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkProcessModuleConfiguration_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("symmetric_mpi_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkProcessModuleConfiguration_GetSymmetricMPIMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkProcessModuleConfiguration_SetSymmetricMPIMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkProcessModuleConfiguration_SetSymmetricMPIMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSymmetricMPIMode/SetSymmetricMPIMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("instance"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkProcessModuleConfiguration_GetInstance(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetInstance\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("force_mpi_init"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkProcessModuleConfiguration_GetForceMPIInit(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetForceMPIInit\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("force_no_mpi_init"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkProcessModuleConfiguration_GetForceNoMPIInit(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetForceNoMPIInit\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_mpis_send"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkProcessModuleConfiguration_GetUseMPISSend(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetUseMPISSend\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("virtual_environment_path"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkProcessModuleConfiguration_GetVirtualEnvironmentPath(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetVirtualEnvironmentPath\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("log_std_err_verbosity"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkProcessModuleConfiguration_GetLogStdErrVerbosity(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetLogStdErrVerbosity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cs_log_file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkProcessModuleConfiguration_GetCSLogFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetCSLogFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_stack_trace"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkProcessModuleConfiguration_GetEnableStackTrace(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetEnableStackTrace\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkProcessModuleConfiguration_Doc =
  "vtkProcessModuleConfiguration - runtime configuration for\nvtkProcessModule\n\n"
  "Superclass: vtkObject\n\n"
  "vtkProcessModuleConfiguration is a singleton that maintains runtime\n"
  "configuration options that affect how vtkProcessModule is\n"
  "initialized.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkProcessModuleConfiguration_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkProcessModuleConfiguration", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkProcessModuleConfiguration_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkProcessModuleConfiguration_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkProcessModuleConfiguration_Type, PyvtkProcessModuleConfiguration_Methods,
    "vtkProcessModuleConfiguration",
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkProcessModuleConfiguration_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkProcessModuleConfiguration(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkProcessModuleConfiguration_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkProcessModuleConfiguration", o) != 0)
  {
    Py_DECREF(o);
  }

}

