#ifndef HEXAGON_FUNC_TABLE_H
#define HEXAGON_FUNC_TABLE_H

const SemanticInsn opcode_genptr[XX_LAST_OPCODE] = {
    [J2_jump] = generate_J2_jump,
    [J2_jumpr] = generate_J2_jumpr,
    [J2_jumprh] = generate_J2_jumprh,
    [J2_jumpt] = generate_J2_jumpt,
    [J2_jumpf] = generate_J2_jumpf,
    [J2_jumptpt] = generate_J2_jumptpt,
    [J2_jumpfpt] = generate_J2_jumpfpt,
    [J2_jumprt] = generate_J2_jumprt,
    [J2_jumprf] = generate_J2_jumprf,
    [J2_jumprtpt] = generate_J2_jumprtpt,
    [J2_jumprfpt] = generate_J2_jumprfpt,
    [J2_jumptnew] = generate_J2_jumptnew,
    [J2_jumpfnew] = generate_J2_jumpfnew,
    [J2_jumptnewpt] = generate_J2_jumptnewpt,
    [J2_jumpfnewpt] = generate_J2_jumpfnewpt,
    [J2_jumprtnew] = generate_J2_jumprtnew,
    [J2_jumprfnew] = generate_J2_jumprfnew,
    [J2_jumprtnewpt] = generate_J2_jumprtnewpt,
    [J2_jumprfnewpt] = generate_J2_jumprfnewpt,
    [J4_hintjumpr] = generate_J4_hintjumpr,
    [J2_jumprz] = generate_J2_jumprz,
    [J2_jumprnz] = generate_J2_jumprnz,
    [J2_jumprzpt] = generate_J2_jumprzpt,
    [J2_jumprnzpt] = generate_J2_jumprnzpt,
    [J2_jumprgtez] = generate_J2_jumprgtez,
    [J2_jumprgtezpt] = generate_J2_jumprgtezpt,
    [J2_jumprltez] = generate_J2_jumprltez,
    [J2_jumprltezpt] = generate_J2_jumprltezpt,
    [J4_cmpeqi_tp0_jump_nt] = generate_J4_cmpeqi_tp0_jump_nt,
    [J4_cmpeqi_fp0_jump_nt] = generate_J4_cmpeqi_fp0_jump_nt,
    [J4_cmpeqi_tp0_jump_t] = generate_J4_cmpeqi_tp0_jump_t,
    [J4_cmpeqi_fp0_jump_t] = generate_J4_cmpeqi_fp0_jump_t,
    [J4_cmpeqi_tp1_jump_nt] = generate_J4_cmpeqi_tp1_jump_nt,
    [J4_cmpeqi_fp1_jump_nt] = generate_J4_cmpeqi_fp1_jump_nt,
    [J4_cmpeqi_tp1_jump_t] = generate_J4_cmpeqi_tp1_jump_t,
    [J4_cmpeqi_fp1_jump_t] = generate_J4_cmpeqi_fp1_jump_t,
    [J4_cmpgti_tp0_jump_nt] = generate_J4_cmpgti_tp0_jump_nt,
    [J4_cmpgti_fp0_jump_nt] = generate_J4_cmpgti_fp0_jump_nt,
    [J4_cmpgti_tp0_jump_t] = generate_J4_cmpgti_tp0_jump_t,
    [J4_cmpgti_fp0_jump_t] = generate_J4_cmpgti_fp0_jump_t,
    [J4_cmpgti_tp1_jump_nt] = generate_J4_cmpgti_tp1_jump_nt,
    [J4_cmpgti_fp1_jump_nt] = generate_J4_cmpgti_fp1_jump_nt,
    [J4_cmpgti_tp1_jump_t] = generate_J4_cmpgti_tp1_jump_t,
    [J4_cmpgti_fp1_jump_t] = generate_J4_cmpgti_fp1_jump_t,
    [J4_cmpgtui_tp0_jump_nt] = generate_J4_cmpgtui_tp0_jump_nt,
    [J4_cmpgtui_fp0_jump_nt] = generate_J4_cmpgtui_fp0_jump_nt,
    [J4_cmpgtui_tp0_jump_t] = generate_J4_cmpgtui_tp0_jump_t,
    [J4_cmpgtui_fp0_jump_t] = generate_J4_cmpgtui_fp0_jump_t,
    [J4_cmpgtui_tp1_jump_nt] = generate_J4_cmpgtui_tp1_jump_nt,
    [J4_cmpgtui_fp1_jump_nt] = generate_J4_cmpgtui_fp1_jump_nt,
    [J4_cmpgtui_tp1_jump_t] = generate_J4_cmpgtui_tp1_jump_t,
    [J4_cmpgtui_fp1_jump_t] = generate_J4_cmpgtui_fp1_jump_t,
    [J4_cmpeqn1_tp0_jump_nt] = generate_J4_cmpeqn1_tp0_jump_nt,
    [J4_cmpeqn1_fp0_jump_nt] = generate_J4_cmpeqn1_fp0_jump_nt,
    [J4_cmpeqn1_tp0_jump_t] = generate_J4_cmpeqn1_tp0_jump_t,
    [J4_cmpeqn1_fp0_jump_t] = generate_J4_cmpeqn1_fp0_jump_t,
    [J4_cmpeqn1_tp1_jump_nt] = generate_J4_cmpeqn1_tp1_jump_nt,
    [J4_cmpeqn1_fp1_jump_nt] = generate_J4_cmpeqn1_fp1_jump_nt,
    [J4_cmpeqn1_tp1_jump_t] = generate_J4_cmpeqn1_tp1_jump_t,
    [J4_cmpeqn1_fp1_jump_t] = generate_J4_cmpeqn1_fp1_jump_t,
    [J4_cmpgtn1_tp0_jump_nt] = generate_J4_cmpgtn1_tp0_jump_nt,
    [J4_cmpgtn1_fp0_jump_nt] = generate_J4_cmpgtn1_fp0_jump_nt,
    [J4_cmpgtn1_tp0_jump_t] = generate_J4_cmpgtn1_tp0_jump_t,
    [J4_cmpgtn1_fp0_jump_t] = generate_J4_cmpgtn1_fp0_jump_t,
    [J4_cmpgtn1_tp1_jump_nt] = generate_J4_cmpgtn1_tp1_jump_nt,
    [J4_cmpgtn1_fp1_jump_nt] = generate_J4_cmpgtn1_fp1_jump_nt,
    [J4_cmpgtn1_tp1_jump_t] = generate_J4_cmpgtn1_tp1_jump_t,
    [J4_cmpgtn1_fp1_jump_t] = generate_J4_cmpgtn1_fp1_jump_t,
    [J4_tstbit0_tp0_jump_nt] = generate_J4_tstbit0_tp0_jump_nt,
    [J4_tstbit0_fp0_jump_nt] = generate_J4_tstbit0_fp0_jump_nt,
    [J4_tstbit0_tp0_jump_t] = generate_J4_tstbit0_tp0_jump_t,
    [J4_tstbit0_fp0_jump_t] = generate_J4_tstbit0_fp0_jump_t,
    [J4_tstbit0_tp1_jump_nt] = generate_J4_tstbit0_tp1_jump_nt,
    [J4_tstbit0_fp1_jump_nt] = generate_J4_tstbit0_fp1_jump_nt,
    [J4_tstbit0_tp1_jump_t] = generate_J4_tstbit0_tp1_jump_t,
    [J4_tstbit0_fp1_jump_t] = generate_J4_tstbit0_fp1_jump_t,
    [J4_cmpeq_tp0_jump_nt] = generate_J4_cmpeq_tp0_jump_nt,
    [J4_cmpeq_fp0_jump_nt] = generate_J4_cmpeq_fp0_jump_nt,
    [J4_cmpeq_tp0_jump_t] = generate_J4_cmpeq_tp0_jump_t,
    [J4_cmpeq_fp0_jump_t] = generate_J4_cmpeq_fp0_jump_t,
    [J4_cmpeq_tp1_jump_nt] = generate_J4_cmpeq_tp1_jump_nt,
    [J4_cmpeq_fp1_jump_nt] = generate_J4_cmpeq_fp1_jump_nt,
    [J4_cmpeq_tp1_jump_t] = generate_J4_cmpeq_tp1_jump_t,
    [J4_cmpeq_fp1_jump_t] = generate_J4_cmpeq_fp1_jump_t,
    [J4_cmpgt_tp0_jump_nt] = generate_J4_cmpgt_tp0_jump_nt,
    [J4_cmpgt_fp0_jump_nt] = generate_J4_cmpgt_fp0_jump_nt,
    [J4_cmpgt_tp0_jump_t] = generate_J4_cmpgt_tp0_jump_t,
    [J4_cmpgt_fp0_jump_t] = generate_J4_cmpgt_fp0_jump_t,
    [J4_cmpgt_tp1_jump_nt] = generate_J4_cmpgt_tp1_jump_nt,
    [J4_cmpgt_fp1_jump_nt] = generate_J4_cmpgt_fp1_jump_nt,
    [J4_cmpgt_tp1_jump_t] = generate_J4_cmpgt_tp1_jump_t,
    [J4_cmpgt_fp1_jump_t] = generate_J4_cmpgt_fp1_jump_t,
    [J4_cmpgtu_tp0_jump_nt] = generate_J4_cmpgtu_tp0_jump_nt,
    [J4_cmpgtu_fp0_jump_nt] = generate_J4_cmpgtu_fp0_jump_nt,
    [J4_cmpgtu_tp0_jump_t] = generate_J4_cmpgtu_tp0_jump_t,
    [J4_cmpgtu_fp0_jump_t] = generate_J4_cmpgtu_fp0_jump_t,
    [J4_cmpgtu_tp1_jump_nt] = generate_J4_cmpgtu_tp1_jump_nt,
    [J4_cmpgtu_fp1_jump_nt] = generate_J4_cmpgtu_fp1_jump_nt,
    [J4_cmpgtu_tp1_jump_t] = generate_J4_cmpgtu_tp1_jump_t,
    [J4_cmpgtu_fp1_jump_t] = generate_J4_cmpgtu_fp1_jump_t,
    [J4_jumpseti] = generate_J4_jumpseti,
    [J4_jumpsetr] = generate_J4_jumpsetr,
    [J4_cmpeqi_t_jumpnv_t] = generate_J4_cmpeqi_t_jumpnv_t,
    [J4_cmpeqi_t_jumpnv_nt] = generate_J4_cmpeqi_t_jumpnv_nt,
    [J4_cmpeqi_f_jumpnv_t] = generate_J4_cmpeqi_f_jumpnv_t,
    [J4_cmpeqi_f_jumpnv_nt] = generate_J4_cmpeqi_f_jumpnv_nt,
    [J4_cmpgti_t_jumpnv_t] = generate_J4_cmpgti_t_jumpnv_t,
    [J4_cmpgti_t_jumpnv_nt] = generate_J4_cmpgti_t_jumpnv_nt,
    [J4_cmpgti_f_jumpnv_t] = generate_J4_cmpgti_f_jumpnv_t,
    [J4_cmpgti_f_jumpnv_nt] = generate_J4_cmpgti_f_jumpnv_nt,
    [J4_cmpgtui_t_jumpnv_t] = generate_J4_cmpgtui_t_jumpnv_t,
    [J4_cmpgtui_t_jumpnv_nt] = generate_J4_cmpgtui_t_jumpnv_nt,
    [J4_cmpgtui_f_jumpnv_t] = generate_J4_cmpgtui_f_jumpnv_t,
    [J4_cmpgtui_f_jumpnv_nt] = generate_J4_cmpgtui_f_jumpnv_nt,
    [J4_cmpeqn1_t_jumpnv_t] = generate_J4_cmpeqn1_t_jumpnv_t,
    [J4_cmpeqn1_t_jumpnv_nt] = generate_J4_cmpeqn1_t_jumpnv_nt,
    [J4_cmpeqn1_f_jumpnv_t] = generate_J4_cmpeqn1_f_jumpnv_t,
    [J4_cmpeqn1_f_jumpnv_nt] = generate_J4_cmpeqn1_f_jumpnv_nt,
    [J4_cmpgtn1_t_jumpnv_t] = generate_J4_cmpgtn1_t_jumpnv_t,
    [J4_cmpgtn1_t_jumpnv_nt] = generate_J4_cmpgtn1_t_jumpnv_nt,
    [J4_cmpgtn1_f_jumpnv_t] = generate_J4_cmpgtn1_f_jumpnv_t,
    [J4_cmpgtn1_f_jumpnv_nt] = generate_J4_cmpgtn1_f_jumpnv_nt,
    [J4_tstbit0_t_jumpnv_t] = generate_J4_tstbit0_t_jumpnv_t,
    [J4_tstbit0_t_jumpnv_nt] = generate_J4_tstbit0_t_jumpnv_nt,
    [J4_tstbit0_f_jumpnv_t] = generate_J4_tstbit0_f_jumpnv_t,
    [J4_tstbit0_f_jumpnv_nt] = generate_J4_tstbit0_f_jumpnv_nt,
    [J4_cmpeq_t_jumpnv_t] = generate_J4_cmpeq_t_jumpnv_t,
    [J4_cmpeq_t_jumpnv_nt] = generate_J4_cmpeq_t_jumpnv_nt,
    [J4_cmpgt_t_jumpnv_t] = generate_J4_cmpgt_t_jumpnv_t,
    [J4_cmpgt_t_jumpnv_nt] = generate_J4_cmpgt_t_jumpnv_nt,
    [J4_cmpgtu_t_jumpnv_t] = generate_J4_cmpgtu_t_jumpnv_t,
    [J4_cmpgtu_t_jumpnv_nt] = generate_J4_cmpgtu_t_jumpnv_nt,
    [J4_cmplt_t_jumpnv_t] = generate_J4_cmplt_t_jumpnv_t,
    [J4_cmplt_t_jumpnv_nt] = generate_J4_cmplt_t_jumpnv_nt,
    [J4_cmpltu_t_jumpnv_t] = generate_J4_cmpltu_t_jumpnv_t,
    [J4_cmpltu_t_jumpnv_nt] = generate_J4_cmpltu_t_jumpnv_nt,
    [J4_cmpeq_f_jumpnv_t] = generate_J4_cmpeq_f_jumpnv_t,
    [J4_cmpeq_f_jumpnv_nt] = generate_J4_cmpeq_f_jumpnv_nt,
    [J4_cmpgt_f_jumpnv_t] = generate_J4_cmpgt_f_jumpnv_t,
    [J4_cmpgt_f_jumpnv_nt] = generate_J4_cmpgt_f_jumpnv_nt,
    [J4_cmpgtu_f_jumpnv_t] = generate_J4_cmpgtu_f_jumpnv_t,
    [J4_cmpgtu_f_jumpnv_nt] = generate_J4_cmpgtu_f_jumpnv_nt,
    [J4_cmplt_f_jumpnv_t] = generate_J4_cmplt_f_jumpnv_t,
    [J4_cmplt_f_jumpnv_nt] = generate_J4_cmplt_f_jumpnv_nt,
    [J4_cmpltu_f_jumpnv_t] = generate_J4_cmpltu_f_jumpnv_t,
    [J4_cmpltu_f_jumpnv_nt] = generate_J4_cmpltu_f_jumpnv_nt,
    [J2_call] = generate_J2_call,
    [J2_callt] = generate_J2_callt,
    [J2_callf] = generate_J2_callf,
    [J2_callr] = generate_J2_callr,
    [J2_callrt] = generate_J2_callrt,
    [J2_callrf] = generate_J2_callrf,
    [J2_callrh] = generate_J2_callrh,
    [J2_loop0r] = generate_J2_loop0r,
    [J2_loop1r] = generate_J2_loop1r,
    [J2_loop0i] = generate_J2_loop0i,
    [J2_loop1i] = generate_J2_loop1i,
    [J2_ploop1sr] = generate_J2_ploop1sr,
    [J2_ploop1si] = generate_J2_ploop1si,
    [J2_ploop2sr] = generate_J2_ploop2sr,
    [J2_ploop2si] = generate_J2_ploop2si,
    [J2_ploop3sr] = generate_J2_ploop3sr,
    [J2_ploop3si] = generate_J2_ploop3si,
    [J2_endloop01] = generate_J2_endloop01,
    [J2_endloop0] = generate_J2_endloop0,
    [J2_endloop1] = generate_J2_endloop1,
    [L2_loadrub_io] = generate_L2_loadrub_io,
    [L4_loadrub_ur] = generate_L4_loadrub_ur,
    [L4_loadrub_ap] = generate_L4_loadrub_ap,
    [L2_loadrub_pr] = generate_L2_loadrub_pr,
    [L2_loadrub_pbr] = generate_L2_loadrub_pbr,
    [L2_loadrub_pi] = generate_L2_loadrub_pi,
    [L2_loadrub_pci] = generate_L2_loadrub_pci,
    [L2_loadrub_pcr] = generate_L2_loadrub_pcr,
    [L2_loadrb_io] = generate_L2_loadrb_io,
    [L4_loadrb_ur] = generate_L4_loadrb_ur,
    [L4_loadrb_ap] = generate_L4_loadrb_ap,
    [L2_loadrb_pr] = generate_L2_loadrb_pr,
    [L2_loadrb_pbr] = generate_L2_loadrb_pbr,
    [L2_loadrb_pi] = generate_L2_loadrb_pi,
    [L2_loadrb_pci] = generate_L2_loadrb_pci,
    [L2_loadrb_pcr] = generate_L2_loadrb_pcr,
    [L2_loadruh_io] = generate_L2_loadruh_io,
    [L4_loadruh_ur] = generate_L4_loadruh_ur,
    [L4_loadruh_ap] = generate_L4_loadruh_ap,
    [L2_loadruh_pr] = generate_L2_loadruh_pr,
    [L2_loadruh_pbr] = generate_L2_loadruh_pbr,
    [L2_loadruh_pi] = generate_L2_loadruh_pi,
    [L2_loadruh_pci] = generate_L2_loadruh_pci,
    [L2_loadruh_pcr] = generate_L2_loadruh_pcr,
    [L2_loadrh_io] = generate_L2_loadrh_io,
    [L4_loadrh_ur] = generate_L4_loadrh_ur,
    [L4_loadrh_ap] = generate_L4_loadrh_ap,
    [L2_loadrh_pr] = generate_L2_loadrh_pr,
    [L2_loadrh_pbr] = generate_L2_loadrh_pbr,
    [L2_loadrh_pi] = generate_L2_loadrh_pi,
    [L2_loadrh_pci] = generate_L2_loadrh_pci,
    [L2_loadrh_pcr] = generate_L2_loadrh_pcr,
    [L2_loadri_io] = generate_L2_loadri_io,
    [L4_loadri_ur] = generate_L4_loadri_ur,
    [L4_loadri_ap] = generate_L4_loadri_ap,
    [L2_loadri_pr] = generate_L2_loadri_pr,
    [L2_loadri_pbr] = generate_L2_loadri_pbr,
    [L2_loadri_pi] = generate_L2_loadri_pi,
    [L2_loadri_pci] = generate_L2_loadri_pci,
    [L2_loadri_pcr] = generate_L2_loadri_pcr,
    [L2_loadrd_io] = generate_L2_loadrd_io,
    [L4_loadrd_ur] = generate_L4_loadrd_ur,
    [L4_loadrd_ap] = generate_L4_loadrd_ap,
    [L2_loadrd_pr] = generate_L2_loadrd_pr,
    [L2_loadrd_pbr] = generate_L2_loadrd_pbr,
    [L2_loadrd_pi] = generate_L2_loadrd_pi,
    [L2_loadrd_pci] = generate_L2_loadrd_pci,
    [L2_loadrd_pcr] = generate_L2_loadrd_pcr,
    [L2_loadbzw2_io] = generate_L2_loadbzw2_io,
    [L4_loadbzw2_ur] = generate_L4_loadbzw2_ur,
    [L4_loadbzw2_ap] = generate_L4_loadbzw2_ap,
    [L2_loadbzw2_pr] = generate_L2_loadbzw2_pr,
    [L2_loadbzw2_pbr] = generate_L2_loadbzw2_pbr,
    [L2_loadbzw2_pi] = generate_L2_loadbzw2_pi,
    [L2_loadbzw2_pci] = generate_L2_loadbzw2_pci,
    [L2_loadbzw2_pcr] = generate_L2_loadbzw2_pcr,
    [L2_loadbzw4_io] = generate_L2_loadbzw4_io,
    [L4_loadbzw4_ur] = generate_L4_loadbzw4_ur,
    [L4_loadbzw4_ap] = generate_L4_loadbzw4_ap,
    [L2_loadbzw4_pr] = generate_L2_loadbzw4_pr,
    [L2_loadbzw4_pbr] = generate_L2_loadbzw4_pbr,
    [L2_loadbzw4_pi] = generate_L2_loadbzw4_pi,
    [L2_loadbzw4_pci] = generate_L2_loadbzw4_pci,
    [L2_loadbzw4_pcr] = generate_L2_loadbzw4_pcr,
    [L2_loadbsw2_io] = generate_L2_loadbsw2_io,
    [L4_loadbsw2_ur] = generate_L4_loadbsw2_ur,
    [L4_loadbsw2_ap] = generate_L4_loadbsw2_ap,
    [L2_loadbsw2_pr] = generate_L2_loadbsw2_pr,
    [L2_loadbsw2_pbr] = generate_L2_loadbsw2_pbr,
    [L2_loadbsw2_pi] = generate_L2_loadbsw2_pi,
    [L2_loadbsw2_pci] = generate_L2_loadbsw2_pci,
    [L2_loadbsw2_pcr] = generate_L2_loadbsw2_pcr,
    [L2_loadbsw4_io] = generate_L2_loadbsw4_io,
    [L4_loadbsw4_ur] = generate_L4_loadbsw4_ur,
    [L4_loadbsw4_ap] = generate_L4_loadbsw4_ap,
    [L2_loadbsw4_pr] = generate_L2_loadbsw4_pr,
    [L2_loadbsw4_pbr] = generate_L2_loadbsw4_pbr,
    [L2_loadbsw4_pi] = generate_L2_loadbsw4_pi,
    [L2_loadbsw4_pci] = generate_L2_loadbsw4_pci,
    [L2_loadbsw4_pcr] = generate_L2_loadbsw4_pcr,
    [L2_loadalignh_io] = generate_L2_loadalignh_io,
    [L4_loadalignh_ur] = generate_L4_loadalignh_ur,
    [L4_loadalignh_ap] = generate_L4_loadalignh_ap,
    [L2_loadalignh_pr] = generate_L2_loadalignh_pr,
    [L2_loadalignh_pbr] = generate_L2_loadalignh_pbr,
    [L2_loadalignh_pi] = generate_L2_loadalignh_pi,
    [L2_loadalignh_pci] = generate_L2_loadalignh_pci,
    [L2_loadalignh_pcr] = generate_L2_loadalignh_pcr,
    [L2_loadalignb_io] = generate_L2_loadalignb_io,
    [L4_loadalignb_ur] = generate_L4_loadalignb_ur,
    [L4_loadalignb_ap] = generate_L4_loadalignb_ap,
    [L2_loadalignb_pr] = generate_L2_loadalignb_pr,
    [L2_loadalignb_pbr] = generate_L2_loadalignb_pbr,
    [L2_loadalignb_pi] = generate_L2_loadalignb_pi,
    [L2_loadalignb_pci] = generate_L2_loadalignb_pci,
    [L2_loadalignb_pcr] = generate_L2_loadalignb_pcr,
    [S2_storerb_io] = generate_S2_storerb_io,
    [S2_storerb_pi] = generate_S2_storerb_pi,
    [S4_storerb_ap] = generate_S4_storerb_ap,
    [S2_storerb_pr] = generate_S2_storerb_pr,
    [S4_storerb_ur] = generate_S4_storerb_ur,
    [S2_storerb_pbr] = generate_S2_storerb_pbr,
    [S2_storerb_pci] = generate_S2_storerb_pci,
    [S2_storerb_pcr] = generate_S2_storerb_pcr,
    [S2_storerh_io] = generate_S2_storerh_io,
    [S2_storerh_pi] = generate_S2_storerh_pi,
    [S4_storerh_ap] = generate_S4_storerh_ap,
    [S2_storerh_pr] = generate_S2_storerh_pr,
    [S4_storerh_ur] = generate_S4_storerh_ur,
    [S2_storerh_pbr] = generate_S2_storerh_pbr,
    [S2_storerh_pci] = generate_S2_storerh_pci,
    [S2_storerh_pcr] = generate_S2_storerh_pcr,
    [S2_storerf_io] = generate_S2_storerf_io,
    [S2_storerf_pi] = generate_S2_storerf_pi,
    [S4_storerf_ap] = generate_S4_storerf_ap,
    [S2_storerf_pr] = generate_S2_storerf_pr,
    [S4_storerf_ur] = generate_S4_storerf_ur,
    [S2_storerf_pbr] = generate_S2_storerf_pbr,
    [S2_storerf_pci] = generate_S2_storerf_pci,
    [S2_storerf_pcr] = generate_S2_storerf_pcr,
    [S2_storeri_io] = generate_S2_storeri_io,
    [S2_storeri_pi] = generate_S2_storeri_pi,
    [S4_storeri_ap] = generate_S4_storeri_ap,
    [S2_storeri_pr] = generate_S2_storeri_pr,
    [S4_storeri_ur] = generate_S4_storeri_ur,
    [S2_storeri_pbr] = generate_S2_storeri_pbr,
    [S2_storeri_pci] = generate_S2_storeri_pci,
    [S2_storeri_pcr] = generate_S2_storeri_pcr,
    [S2_storerd_io] = generate_S2_storerd_io,
    [S2_storerd_pi] = generate_S2_storerd_pi,
    [S4_storerd_ap] = generate_S4_storerd_ap,
    [S2_storerd_pr] = generate_S2_storerd_pr,
    [S4_storerd_ur] = generate_S4_storerd_ur,
    [S2_storerd_pbr] = generate_S2_storerd_pbr,
    [S2_storerd_pci] = generate_S2_storerd_pci,
    [S2_storerd_pcr] = generate_S2_storerd_pcr,
    [S2_storerinew_io] = generate_S2_storerinew_io,
    [S2_storerinew_pi] = generate_S2_storerinew_pi,
    [S4_storerinew_ap] = generate_S4_storerinew_ap,
    [S2_storerinew_pr] = generate_S2_storerinew_pr,
    [S4_storerinew_ur] = generate_S4_storerinew_ur,
    [S2_storerinew_pbr] = generate_S2_storerinew_pbr,
    [S2_storerinew_pci] = generate_S2_storerinew_pci,
    [S2_storerinew_pcr] = generate_S2_storerinew_pcr,
    [S2_storerbnew_io] = generate_S2_storerbnew_io,
    [S2_storerbnew_pi] = generate_S2_storerbnew_pi,
    [S4_storerbnew_ap] = generate_S4_storerbnew_ap,
    [S2_storerbnew_pr] = generate_S2_storerbnew_pr,
    [S4_storerbnew_ur] = generate_S4_storerbnew_ur,
    [S2_storerbnew_pbr] = generate_S2_storerbnew_pbr,
    [S2_storerbnew_pci] = generate_S2_storerbnew_pci,
    [S2_storerbnew_pcr] = generate_S2_storerbnew_pcr,
    [S2_storerhnew_io] = generate_S2_storerhnew_io,
    [S2_storerhnew_pi] = generate_S2_storerhnew_pi,
    [S4_storerhnew_ap] = generate_S4_storerhnew_ap,
    [S2_storerhnew_pr] = generate_S2_storerhnew_pr,
    [S4_storerhnew_ur] = generate_S4_storerhnew_ur,
    [S2_storerhnew_pbr] = generate_S2_storerhnew_pbr,
    [S2_storerhnew_pci] = generate_S2_storerhnew_pci,
    [S2_storerhnew_pcr] = generate_S2_storerhnew_pcr,
    [S2_allocframe] = generate_S2_allocframe,
    [L2_loadw_aq] = generate_L2_loadw_aq,
    [L4_loadd_aq] = generate_L4_loadd_aq,
    [R6_release_at_vi] = generate_R6_release_at_vi,
    [R6_release_st_vi] = generate_R6_release_st_vi,
    [S2_storew_rl_at_vi] = generate_S2_storew_rl_at_vi,
    [S4_stored_rl_at_vi] = generate_S4_stored_rl_at_vi,
    [S2_storew_rl_st_vi] = generate_S2_storew_rl_st_vi,
    [S4_stored_rl_st_vi] = generate_S4_stored_rl_st_vi,
    [L2_deallocframe] = generate_L2_deallocframe,
    [L4_return] = generate_L4_return,
    [L4_return_t] = generate_L4_return_t,
    [L4_return_f] = generate_L4_return_f,
    [L4_return_tnew_pt] = generate_L4_return_tnew_pt,
    [L4_return_fnew_pt] = generate_L4_return_fnew_pt,
    [L4_return_tnew_pnt] = generate_L4_return_tnew_pnt,
    [L4_return_fnew_pnt] = generate_L4_return_fnew_pnt,
    [L2_loadw_locked] = generate_L2_loadw_locked,
    [S2_storew_locked] = generate_S2_storew_locked,
    [L4_loadd_locked] = generate_L4_loadd_locked,
    [S4_stored_locked] = generate_S4_stored_locked,
    [L4_loadrub_rr] = generate_L4_loadrub_rr,
    [L2_ploadrubt_io] = generate_L2_ploadrubt_io,
    [L2_ploadrubt_pi] = generate_L2_ploadrubt_pi,
    [L2_ploadrubf_io] = generate_L2_ploadrubf_io,
    [L2_ploadrubf_pi] = generate_L2_ploadrubf_pi,
    [L2_ploadrubtnew_io] = generate_L2_ploadrubtnew_io,
    [L2_ploadrubfnew_io] = generate_L2_ploadrubfnew_io,
    [L4_ploadrubt_rr] = generate_L4_ploadrubt_rr,
    [L4_ploadrubf_rr] = generate_L4_ploadrubf_rr,
    [L4_ploadrubtnew_rr] = generate_L4_ploadrubtnew_rr,
    [L4_ploadrubfnew_rr] = generate_L4_ploadrubfnew_rr,
    [L2_ploadrubtnew_pi] = generate_L2_ploadrubtnew_pi,
    [L2_ploadrubfnew_pi] = generate_L2_ploadrubfnew_pi,
    [L4_ploadrubt_abs] = generate_L4_ploadrubt_abs,
    [L4_ploadrubf_abs] = generate_L4_ploadrubf_abs,
    [L4_ploadrubtnew_abs] = generate_L4_ploadrubtnew_abs,
    [L4_ploadrubfnew_abs] = generate_L4_ploadrubfnew_abs,
    [L4_loadrb_rr] = generate_L4_loadrb_rr,
    [L2_ploadrbt_io] = generate_L2_ploadrbt_io,
    [L2_ploadrbt_pi] = generate_L2_ploadrbt_pi,
    [L2_ploadrbf_io] = generate_L2_ploadrbf_io,
    [L2_ploadrbf_pi] = generate_L2_ploadrbf_pi,
    [L2_ploadrbtnew_io] = generate_L2_ploadrbtnew_io,
    [L2_ploadrbfnew_io] = generate_L2_ploadrbfnew_io,
    [L4_ploadrbt_rr] = generate_L4_ploadrbt_rr,
    [L4_ploadrbf_rr] = generate_L4_ploadrbf_rr,
    [L4_ploadrbtnew_rr] = generate_L4_ploadrbtnew_rr,
    [L4_ploadrbfnew_rr] = generate_L4_ploadrbfnew_rr,
    [L2_ploadrbtnew_pi] = generate_L2_ploadrbtnew_pi,
    [L2_ploadrbfnew_pi] = generate_L2_ploadrbfnew_pi,
    [L4_ploadrbt_abs] = generate_L4_ploadrbt_abs,
    [L4_ploadrbf_abs] = generate_L4_ploadrbf_abs,
    [L4_ploadrbtnew_abs] = generate_L4_ploadrbtnew_abs,
    [L4_ploadrbfnew_abs] = generate_L4_ploadrbfnew_abs,
    [L4_loadruh_rr] = generate_L4_loadruh_rr,
    [L2_ploadruht_io] = generate_L2_ploadruht_io,
    [L2_ploadruht_pi] = generate_L2_ploadruht_pi,
    [L2_ploadruhf_io] = generate_L2_ploadruhf_io,
    [L2_ploadruhf_pi] = generate_L2_ploadruhf_pi,
    [L2_ploadruhtnew_io] = generate_L2_ploadruhtnew_io,
    [L2_ploadruhfnew_io] = generate_L2_ploadruhfnew_io,
    [L4_ploadruht_rr] = generate_L4_ploadruht_rr,
    [L4_ploadruhf_rr] = generate_L4_ploadruhf_rr,
    [L4_ploadruhtnew_rr] = generate_L4_ploadruhtnew_rr,
    [L4_ploadruhfnew_rr] = generate_L4_ploadruhfnew_rr,
    [L2_ploadruhtnew_pi] = generate_L2_ploadruhtnew_pi,
    [L2_ploadruhfnew_pi] = generate_L2_ploadruhfnew_pi,
    [L4_ploadruht_abs] = generate_L4_ploadruht_abs,
    [L4_ploadruhf_abs] = generate_L4_ploadruhf_abs,
    [L4_ploadruhtnew_abs] = generate_L4_ploadruhtnew_abs,
    [L4_ploadruhfnew_abs] = generate_L4_ploadruhfnew_abs,
    [L4_loadrh_rr] = generate_L4_loadrh_rr,
    [L2_ploadrht_io] = generate_L2_ploadrht_io,
    [L2_ploadrht_pi] = generate_L2_ploadrht_pi,
    [L2_ploadrhf_io] = generate_L2_ploadrhf_io,
    [L2_ploadrhf_pi] = generate_L2_ploadrhf_pi,
    [L2_ploadrhtnew_io] = generate_L2_ploadrhtnew_io,
    [L2_ploadrhfnew_io] = generate_L2_ploadrhfnew_io,
    [L4_ploadrht_rr] = generate_L4_ploadrht_rr,
    [L4_ploadrhf_rr] = generate_L4_ploadrhf_rr,
    [L4_ploadrhtnew_rr] = generate_L4_ploadrhtnew_rr,
    [L4_ploadrhfnew_rr] = generate_L4_ploadrhfnew_rr,
    [L2_ploadrhtnew_pi] = generate_L2_ploadrhtnew_pi,
    [L2_ploadrhfnew_pi] = generate_L2_ploadrhfnew_pi,
    [L4_ploadrht_abs] = generate_L4_ploadrht_abs,
    [L4_ploadrhf_abs] = generate_L4_ploadrhf_abs,
    [L4_ploadrhtnew_abs] = generate_L4_ploadrhtnew_abs,
    [L4_ploadrhfnew_abs] = generate_L4_ploadrhfnew_abs,
    [L4_loadri_rr] = generate_L4_loadri_rr,
    [L2_ploadrit_io] = generate_L2_ploadrit_io,
    [L2_ploadrit_pi] = generate_L2_ploadrit_pi,
    [L2_ploadrif_io] = generate_L2_ploadrif_io,
    [L2_ploadrif_pi] = generate_L2_ploadrif_pi,
    [L2_ploadritnew_io] = generate_L2_ploadritnew_io,
    [L2_ploadrifnew_io] = generate_L2_ploadrifnew_io,
    [L4_ploadrit_rr] = generate_L4_ploadrit_rr,
    [L4_ploadrif_rr] = generate_L4_ploadrif_rr,
    [L4_ploadritnew_rr] = generate_L4_ploadritnew_rr,
    [L4_ploadrifnew_rr] = generate_L4_ploadrifnew_rr,
    [L2_ploadritnew_pi] = generate_L2_ploadritnew_pi,
    [L2_ploadrifnew_pi] = generate_L2_ploadrifnew_pi,
    [L4_ploadrit_abs] = generate_L4_ploadrit_abs,
    [L4_ploadrif_abs] = generate_L4_ploadrif_abs,
    [L4_ploadritnew_abs] = generate_L4_ploadritnew_abs,
    [L4_ploadrifnew_abs] = generate_L4_ploadrifnew_abs,
    [L4_loadrd_rr] = generate_L4_loadrd_rr,
    [L2_ploadrdt_io] = generate_L2_ploadrdt_io,
    [L2_ploadrdt_pi] = generate_L2_ploadrdt_pi,
    [L2_ploadrdf_io] = generate_L2_ploadrdf_io,
    [L2_ploadrdf_pi] = generate_L2_ploadrdf_pi,
    [L2_ploadrdtnew_io] = generate_L2_ploadrdtnew_io,
    [L2_ploadrdfnew_io] = generate_L2_ploadrdfnew_io,
    [L4_ploadrdt_rr] = generate_L4_ploadrdt_rr,
    [L4_ploadrdf_rr] = generate_L4_ploadrdf_rr,
    [L4_ploadrdtnew_rr] = generate_L4_ploadrdtnew_rr,
    [L4_ploadrdfnew_rr] = generate_L4_ploadrdfnew_rr,
    [L2_ploadrdtnew_pi] = generate_L2_ploadrdtnew_pi,
    [L2_ploadrdfnew_pi] = generate_L2_ploadrdfnew_pi,
    [L4_ploadrdt_abs] = generate_L4_ploadrdt_abs,
    [L4_ploadrdf_abs] = generate_L4_ploadrdf_abs,
    [L4_ploadrdtnew_abs] = generate_L4_ploadrdtnew_abs,
    [L4_ploadrdfnew_abs] = generate_L4_ploadrdfnew_abs,
    [S4_storerb_rr] = generate_S4_storerb_rr,
    [S2_pstorerbt_io] = generate_S2_pstorerbt_io,
    [S2_pstorerbt_pi] = generate_S2_pstorerbt_pi,
    [S2_pstorerbf_io] = generate_S2_pstorerbf_io,
    [S2_pstorerbf_pi] = generate_S2_pstorerbf_pi,
    [S4_pstorerbt_rr] = generate_S4_pstorerbt_rr,
    [S4_pstorerbf_rr] = generate_S4_pstorerbf_rr,
    [S4_pstorerbtnew_io] = generate_S4_pstorerbtnew_io,
    [S4_pstorerbfnew_io] = generate_S4_pstorerbfnew_io,
    [S4_pstorerbtnew_rr] = generate_S4_pstorerbtnew_rr,
    [S4_pstorerbfnew_rr] = generate_S4_pstorerbfnew_rr,
    [S2_pstorerbtnew_pi] = generate_S2_pstorerbtnew_pi,
    [S2_pstorerbfnew_pi] = generate_S2_pstorerbfnew_pi,
    [S4_pstorerbt_abs] = generate_S4_pstorerbt_abs,
    [S4_pstorerbf_abs] = generate_S4_pstorerbf_abs,
    [S4_pstorerbtnew_abs] = generate_S4_pstorerbtnew_abs,
    [S4_pstorerbfnew_abs] = generate_S4_pstorerbfnew_abs,
    [S4_storerh_rr] = generate_S4_storerh_rr,
    [S2_pstorerht_io] = generate_S2_pstorerht_io,
    [S2_pstorerht_pi] = generate_S2_pstorerht_pi,
    [S2_pstorerhf_io] = generate_S2_pstorerhf_io,
    [S2_pstorerhf_pi] = generate_S2_pstorerhf_pi,
    [S4_pstorerht_rr] = generate_S4_pstorerht_rr,
    [S4_pstorerhf_rr] = generate_S4_pstorerhf_rr,
    [S4_pstorerhtnew_io] = generate_S4_pstorerhtnew_io,
    [S4_pstorerhfnew_io] = generate_S4_pstorerhfnew_io,
    [S4_pstorerhtnew_rr] = generate_S4_pstorerhtnew_rr,
    [S4_pstorerhfnew_rr] = generate_S4_pstorerhfnew_rr,
    [S2_pstorerhtnew_pi] = generate_S2_pstorerhtnew_pi,
    [S2_pstorerhfnew_pi] = generate_S2_pstorerhfnew_pi,
    [S4_pstorerht_abs] = generate_S4_pstorerht_abs,
    [S4_pstorerhf_abs] = generate_S4_pstorerhf_abs,
    [S4_pstorerhtnew_abs] = generate_S4_pstorerhtnew_abs,
    [S4_pstorerhfnew_abs] = generate_S4_pstorerhfnew_abs,
    [S4_storerf_rr] = generate_S4_storerf_rr,
    [S2_pstorerft_io] = generate_S2_pstorerft_io,
    [S2_pstorerft_pi] = generate_S2_pstorerft_pi,
    [S2_pstorerff_io] = generate_S2_pstorerff_io,
    [S2_pstorerff_pi] = generate_S2_pstorerff_pi,
    [S4_pstorerft_rr] = generate_S4_pstorerft_rr,
    [S4_pstorerff_rr] = generate_S4_pstorerff_rr,
    [S4_pstorerftnew_io] = generate_S4_pstorerftnew_io,
    [S4_pstorerffnew_io] = generate_S4_pstorerffnew_io,
    [S4_pstorerftnew_rr] = generate_S4_pstorerftnew_rr,
    [S4_pstorerffnew_rr] = generate_S4_pstorerffnew_rr,
    [S2_pstorerftnew_pi] = generate_S2_pstorerftnew_pi,
    [S2_pstorerffnew_pi] = generate_S2_pstorerffnew_pi,
    [S4_pstorerft_abs] = generate_S4_pstorerft_abs,
    [S4_pstorerff_abs] = generate_S4_pstorerff_abs,
    [S4_pstorerftnew_abs] = generate_S4_pstorerftnew_abs,
    [S4_pstorerffnew_abs] = generate_S4_pstorerffnew_abs,
    [S4_storeri_rr] = generate_S4_storeri_rr,
    [S2_pstorerit_io] = generate_S2_pstorerit_io,
    [S2_pstorerit_pi] = generate_S2_pstorerit_pi,
    [S2_pstorerif_io] = generate_S2_pstorerif_io,
    [S2_pstorerif_pi] = generate_S2_pstorerif_pi,
    [S4_pstorerit_rr] = generate_S4_pstorerit_rr,
    [S4_pstorerif_rr] = generate_S4_pstorerif_rr,
    [S4_pstoreritnew_io] = generate_S4_pstoreritnew_io,
    [S4_pstorerifnew_io] = generate_S4_pstorerifnew_io,
    [S4_pstoreritnew_rr] = generate_S4_pstoreritnew_rr,
    [S4_pstorerifnew_rr] = generate_S4_pstorerifnew_rr,
    [S2_pstoreritnew_pi] = generate_S2_pstoreritnew_pi,
    [S2_pstorerifnew_pi] = generate_S2_pstorerifnew_pi,
    [S4_pstorerit_abs] = generate_S4_pstorerit_abs,
    [S4_pstorerif_abs] = generate_S4_pstorerif_abs,
    [S4_pstoreritnew_abs] = generate_S4_pstoreritnew_abs,
    [S4_pstorerifnew_abs] = generate_S4_pstorerifnew_abs,
    [S4_storerd_rr] = generate_S4_storerd_rr,
    [S2_pstorerdt_io] = generate_S2_pstorerdt_io,
    [S2_pstorerdt_pi] = generate_S2_pstorerdt_pi,
    [S2_pstorerdf_io] = generate_S2_pstorerdf_io,
    [S2_pstorerdf_pi] = generate_S2_pstorerdf_pi,
    [S4_pstorerdt_rr] = generate_S4_pstorerdt_rr,
    [S4_pstorerdf_rr] = generate_S4_pstorerdf_rr,
    [S4_pstorerdtnew_io] = generate_S4_pstorerdtnew_io,
    [S4_pstorerdfnew_io] = generate_S4_pstorerdfnew_io,
    [S4_pstorerdtnew_rr] = generate_S4_pstorerdtnew_rr,
    [S4_pstorerdfnew_rr] = generate_S4_pstorerdfnew_rr,
    [S2_pstorerdtnew_pi] = generate_S2_pstorerdtnew_pi,
    [S2_pstorerdfnew_pi] = generate_S2_pstorerdfnew_pi,
    [S4_pstorerdt_abs] = generate_S4_pstorerdt_abs,
    [S4_pstorerdf_abs] = generate_S4_pstorerdf_abs,
    [S4_pstorerdtnew_abs] = generate_S4_pstorerdtnew_abs,
    [S4_pstorerdfnew_abs] = generate_S4_pstorerdfnew_abs,
    [S4_storerinew_rr] = generate_S4_storerinew_rr,
    [S2_pstorerinewt_io] = generate_S2_pstorerinewt_io,
    [S2_pstorerinewt_pi] = generate_S2_pstorerinewt_pi,
    [S2_pstorerinewf_io] = generate_S2_pstorerinewf_io,
    [S2_pstorerinewf_pi] = generate_S2_pstorerinewf_pi,
    [S4_pstorerinewt_rr] = generate_S4_pstorerinewt_rr,
    [S4_pstorerinewf_rr] = generate_S4_pstorerinewf_rr,
    [S4_pstorerinewtnew_io] = generate_S4_pstorerinewtnew_io,
    [S4_pstorerinewfnew_io] = generate_S4_pstorerinewfnew_io,
    [S4_pstorerinewtnew_rr] = generate_S4_pstorerinewtnew_rr,
    [S4_pstorerinewfnew_rr] = generate_S4_pstorerinewfnew_rr,
    [S2_pstorerinewtnew_pi] = generate_S2_pstorerinewtnew_pi,
    [S2_pstorerinewfnew_pi] = generate_S2_pstorerinewfnew_pi,
    [S4_pstorerinewt_abs] = generate_S4_pstorerinewt_abs,
    [S4_pstorerinewf_abs] = generate_S4_pstorerinewf_abs,
    [S4_pstorerinewtnew_abs] = generate_S4_pstorerinewtnew_abs,
    [S4_pstorerinewfnew_abs] = generate_S4_pstorerinewfnew_abs,
    [S4_storerbnew_rr] = generate_S4_storerbnew_rr,
    [S2_pstorerbnewt_io] = generate_S2_pstorerbnewt_io,
    [S2_pstorerbnewt_pi] = generate_S2_pstorerbnewt_pi,
    [S2_pstorerbnewf_io] = generate_S2_pstorerbnewf_io,
    [S2_pstorerbnewf_pi] = generate_S2_pstorerbnewf_pi,
    [S4_pstorerbnewt_rr] = generate_S4_pstorerbnewt_rr,
    [S4_pstorerbnewf_rr] = generate_S4_pstorerbnewf_rr,
    [S4_pstorerbnewtnew_io] = generate_S4_pstorerbnewtnew_io,
    [S4_pstorerbnewfnew_io] = generate_S4_pstorerbnewfnew_io,
    [S4_pstorerbnewtnew_rr] = generate_S4_pstorerbnewtnew_rr,
    [S4_pstorerbnewfnew_rr] = generate_S4_pstorerbnewfnew_rr,
    [S2_pstorerbnewtnew_pi] = generate_S2_pstorerbnewtnew_pi,
    [S2_pstorerbnewfnew_pi] = generate_S2_pstorerbnewfnew_pi,
    [S4_pstorerbnewt_abs] = generate_S4_pstorerbnewt_abs,
    [S4_pstorerbnewf_abs] = generate_S4_pstorerbnewf_abs,
    [S4_pstorerbnewtnew_abs] = generate_S4_pstorerbnewtnew_abs,
    [S4_pstorerbnewfnew_abs] = generate_S4_pstorerbnewfnew_abs,
    [S4_storerhnew_rr] = generate_S4_storerhnew_rr,
    [S2_pstorerhnewt_io] = generate_S2_pstorerhnewt_io,
    [S2_pstorerhnewt_pi] = generate_S2_pstorerhnewt_pi,
    [S2_pstorerhnewf_io] = generate_S2_pstorerhnewf_io,
    [S2_pstorerhnewf_pi] = generate_S2_pstorerhnewf_pi,
    [S4_pstorerhnewt_rr] = generate_S4_pstorerhnewt_rr,
    [S4_pstorerhnewf_rr] = generate_S4_pstorerhnewf_rr,
    [S4_pstorerhnewtnew_io] = generate_S4_pstorerhnewtnew_io,
    [S4_pstorerhnewfnew_io] = generate_S4_pstorerhnewfnew_io,
    [S4_pstorerhnewtnew_rr] = generate_S4_pstorerhnewtnew_rr,
    [S4_pstorerhnewfnew_rr] = generate_S4_pstorerhnewfnew_rr,
    [S2_pstorerhnewtnew_pi] = generate_S2_pstorerhnewtnew_pi,
    [S2_pstorerhnewfnew_pi] = generate_S2_pstorerhnewfnew_pi,
    [S4_pstorerhnewt_abs] = generate_S4_pstorerhnewt_abs,
    [S4_pstorerhnewf_abs] = generate_S4_pstorerhnewf_abs,
    [S4_pstorerhnewtnew_abs] = generate_S4_pstorerhnewtnew_abs,
    [S4_pstorerhnewfnew_abs] = generate_S4_pstorerhnewfnew_abs,
    [L4_add_memopw_io] = generate_L4_add_memopw_io,
    [L4_add_memopb_io] = generate_L4_add_memopb_io,
    [L4_add_memoph_io] = generate_L4_add_memoph_io,
    [L4_sub_memopw_io] = generate_L4_sub_memopw_io,
    [L4_sub_memopb_io] = generate_L4_sub_memopb_io,
    [L4_sub_memoph_io] = generate_L4_sub_memoph_io,
    [L4_and_memopw_io] = generate_L4_and_memopw_io,
    [L4_and_memopb_io] = generate_L4_and_memopb_io,
    [L4_and_memoph_io] = generate_L4_and_memoph_io,
    [L4_or_memopw_io] = generate_L4_or_memopw_io,
    [L4_or_memopb_io] = generate_L4_or_memopb_io,
    [L4_or_memoph_io] = generate_L4_or_memoph_io,
    [L4_iadd_memopw_io] = generate_L4_iadd_memopw_io,
    [L4_iadd_memopb_io] = generate_L4_iadd_memopb_io,
    [L4_iadd_memoph_io] = generate_L4_iadd_memoph_io,
    [L4_isub_memopw_io] = generate_L4_isub_memopw_io,
    [L4_isub_memopb_io] = generate_L4_isub_memopb_io,
    [L4_isub_memoph_io] = generate_L4_isub_memoph_io,
    [L4_iand_memopw_io] = generate_L4_iand_memopw_io,
    [L4_iand_memopb_io] = generate_L4_iand_memopb_io,
    [L4_iand_memoph_io] = generate_L4_iand_memoph_io,
    [L4_ior_memopw_io] = generate_L4_ior_memopw_io,
    [L4_ior_memopb_io] = generate_L4_ior_memopb_io,
    [L4_ior_memoph_io] = generate_L4_ior_memoph_io,
    [S4_storeirbt_io] = generate_S4_storeirbt_io,
    [S4_storeirbf_io] = generate_S4_storeirbf_io,
    [S4_storeirbtnew_io] = generate_S4_storeirbtnew_io,
    [S4_storeirbfnew_io] = generate_S4_storeirbfnew_io,
    [S4_storeirht_io] = generate_S4_storeirht_io,
    [S4_storeirhf_io] = generate_S4_storeirhf_io,
    [S4_storeirhtnew_io] = generate_S4_storeirhtnew_io,
    [S4_storeirhfnew_io] = generate_S4_storeirhfnew_io,
    [S4_storeirit_io] = generate_S4_storeirit_io,
    [S4_storeirif_io] = generate_S4_storeirif_io,
    [S4_storeiritnew_io] = generate_S4_storeiritnew_io,
    [S4_storeirifnew_io] = generate_S4_storeirifnew_io,
    [S4_storeirb_io] = generate_S4_storeirb_io,
    [S4_storeirh_io] = generate_S4_storeirh_io,
    [S4_storeiri_io] = generate_S4_storeiri_io,
    [L2_loadrubgp] = generate_L2_loadrubgp,
    [L2_loadrbgp] = generate_L2_loadrbgp,
    [L2_loadruhgp] = generate_L2_loadruhgp,
    [L2_loadrhgp] = generate_L2_loadrhgp,
    [L2_loadrigp] = generate_L2_loadrigp,
    [L2_loadrdgp] = generate_L2_loadrdgp,
    [S2_storerbgp] = generate_S2_storerbgp,
    [S2_storerhgp] = generate_S2_storerhgp,
    [S2_storerfgp] = generate_S2_storerfgp,
    [S2_storerigp] = generate_S2_storerigp,
    [S2_storerdgp] = generate_S2_storerdgp,
    [S2_storerinewgp] = generate_S2_storerinewgp,
    [S2_storerbnewgp] = generate_S2_storerbnewgp,
    [S2_storerhnewgp] = generate_S2_storerhnewgp,
    [C2_cmpeq] = generate_C2_cmpeq,
    [C2_cmpgt] = generate_C2_cmpgt,
    [C2_cmpgtu] = generate_C2_cmpgtu,
    [C2_cmpeqp] = generate_C2_cmpeqp,
    [C2_cmpgtp] = generate_C2_cmpgtp,
    [C2_cmpgtup] = generate_C2_cmpgtup,
    [A4_rcmpeqi] = generate_A4_rcmpeqi,
    [A4_rcmpneqi] = generate_A4_rcmpneqi,
    [A4_rcmpeq] = generate_A4_rcmpeq,
    [A4_rcmpneq] = generate_A4_rcmpneq,
    [C2_bitsset] = generate_C2_bitsset,
    [C2_bitsclr] = generate_C2_bitsclr,
    [C4_nbitsset] = generate_C4_nbitsset,
    [C4_nbitsclr] = generate_C4_nbitsclr,
    [C2_cmpeqi] = generate_C2_cmpeqi,
    [C2_cmpgti] = generate_C2_cmpgti,
    [C2_cmpgtui] = generate_C2_cmpgtui,
    [C2_bitsclri] = generate_C2_bitsclri,
    [C4_nbitsclri] = generate_C4_nbitsclri,
    [C4_cmpneqi] = generate_C4_cmpneqi,
    [C4_cmpltei] = generate_C4_cmpltei,
    [C4_cmplteui] = generate_C4_cmplteui,
    [C4_cmpneq] = generate_C4_cmpneq,
    [C4_cmplte] = generate_C4_cmplte,
    [C4_cmplteu] = generate_C4_cmplteu,
    [C2_and] = generate_C2_and,
    [C2_or] = generate_C2_or,
    [C2_xor] = generate_C2_xor,
    [C2_andn] = generate_C2_andn,
    [C2_not] = generate_C2_not,
    [C2_orn] = generate_C2_orn,
    [C4_and_and] = generate_C4_and_and,
    [C4_and_or] = generate_C4_and_or,
    [C4_or_and] = generate_C4_or_and,
    [C4_or_or] = generate_C4_or_or,
    [C4_and_andn] = generate_C4_and_andn,
    [C4_and_orn] = generate_C4_and_orn,
    [C4_or_andn] = generate_C4_or_andn,
    [C4_or_orn] = generate_C4_or_orn,
    [C2_any8] = generate_C2_any8,
    [C2_all8] = generate_C2_all8,
    [C2_vitpack] = generate_C2_vitpack,
    [C2_mux] = generate_C2_mux,
    [C2_cmovenewit] = generate_C2_cmovenewit,
    [C2_cmovenewif] = generate_C2_cmovenewif,
    [C2_cmoveit] = generate_C2_cmoveit,
    [C2_cmoveif] = generate_C2_cmoveif,
    [C2_ccombinewnewt] = generate_C2_ccombinewnewt,
    [C2_ccombinewnewf] = generate_C2_ccombinewnewf,
    [C2_ccombinewt] = generate_C2_ccombinewt,
    [C2_ccombinewf] = generate_C2_ccombinewf,
    [C2_muxii] = generate_C2_muxii,
    [C2_muxir] = generate_C2_muxir,
    [C2_muxri] = generate_C2_muxri,
    [C2_vmux] = generate_C2_vmux,
    [C2_mask] = generate_C2_mask,
    [A2_vcmpbeq] = generate_A2_vcmpbeq,
    [A4_vcmpbeqi] = generate_A4_vcmpbeqi,
    [A4_vcmpbeq_any] = generate_A4_vcmpbeq_any,
    [A6_vcmpbeq_notany] = generate_A6_vcmpbeq_notany,
    [A2_vcmpbgtu] = generate_A2_vcmpbgtu,
    [A4_vcmpbgtui] = generate_A4_vcmpbgtui,
    [A4_vcmpbgt] = generate_A4_vcmpbgt,
    [A4_vcmpbgti] = generate_A4_vcmpbgti,
    [A4_cmpbeq] = generate_A4_cmpbeq,
    [A4_cmpbeqi] = generate_A4_cmpbeqi,
    [A4_cmpbgtu] = generate_A4_cmpbgtu,
    [A4_cmpbgtui] = generate_A4_cmpbgtui,
    [A4_cmpbgt] = generate_A4_cmpbgt,
    [A4_cmpbgti] = generate_A4_cmpbgti,
    [A2_vcmpheq] = generate_A2_vcmpheq,
    [A2_vcmphgt] = generate_A2_vcmphgt,
    [A2_vcmphgtu] = generate_A2_vcmphgtu,
    [A4_vcmpheqi] = generate_A4_vcmpheqi,
    [A4_vcmphgti] = generate_A4_vcmphgti,
    [A4_vcmphgtui] = generate_A4_vcmphgtui,
    [A4_cmpheq] = generate_A4_cmpheq,
    [A4_cmphgt] = generate_A4_cmphgt,
    [A4_cmphgtu] = generate_A4_cmphgtu,
    [A4_cmpheqi] = generate_A4_cmpheqi,
    [A4_cmphgti] = generate_A4_cmphgti,
    [A4_cmphgtui] = generate_A4_cmphgtui,
    [A2_vcmpweq] = generate_A2_vcmpweq,
    [A2_vcmpwgt] = generate_A2_vcmpwgt,
    [A2_vcmpwgtu] = generate_A2_vcmpwgtu,
    [A4_vcmpweqi] = generate_A4_vcmpweqi,
    [A4_vcmpwgti] = generate_A4_vcmpwgti,
    [A4_vcmpwgtui] = generate_A4_vcmpwgtui,
    [A4_boundscheck_hi] = generate_A4_boundscheck_hi,
    [A4_boundscheck_lo] = generate_A4_boundscheck_lo,
    [A4_tlbmatch] = generate_A4_tlbmatch,
    [C2_tfrpr] = generate_C2_tfrpr,
    [C2_tfrrp] = generate_C2_tfrrp,
    [C4_fastcorner9] = generate_C4_fastcorner9,
    [C4_fastcorner9_not] = generate_C4_fastcorner9_not,
    [M2_mpy_acc_hh_s0] = generate_M2_mpy_acc_hh_s0,
    [M2_mpy_acc_hh_s1] = generate_M2_mpy_acc_hh_s1,
    [M2_mpy_acc_hl_s0] = generate_M2_mpy_acc_hl_s0,
    [M2_mpy_acc_hl_s1] = generate_M2_mpy_acc_hl_s1,
    [M2_mpy_acc_lh_s0] = generate_M2_mpy_acc_lh_s0,
    [M2_mpy_acc_lh_s1] = generate_M2_mpy_acc_lh_s1,
    [M2_mpy_acc_ll_s0] = generate_M2_mpy_acc_ll_s0,
    [M2_mpy_acc_ll_s1] = generate_M2_mpy_acc_ll_s1,
    [M2_mpy_nac_hh_s0] = generate_M2_mpy_nac_hh_s0,
    [M2_mpy_nac_hh_s1] = generate_M2_mpy_nac_hh_s1,
    [M2_mpy_nac_hl_s0] = generate_M2_mpy_nac_hl_s0,
    [M2_mpy_nac_hl_s1] = generate_M2_mpy_nac_hl_s1,
    [M2_mpy_nac_lh_s0] = generate_M2_mpy_nac_lh_s0,
    [M2_mpy_nac_lh_s1] = generate_M2_mpy_nac_lh_s1,
    [M2_mpy_nac_ll_s0] = generate_M2_mpy_nac_ll_s0,
    [M2_mpy_nac_ll_s1] = generate_M2_mpy_nac_ll_s1,
    [M2_mpy_acc_sat_hh_s0] = generate_M2_mpy_acc_sat_hh_s0,
    [M2_mpy_acc_sat_hh_s1] = generate_M2_mpy_acc_sat_hh_s1,
    [M2_mpy_acc_sat_hl_s0] = generate_M2_mpy_acc_sat_hl_s0,
    [M2_mpy_acc_sat_hl_s1] = generate_M2_mpy_acc_sat_hl_s1,
    [M2_mpy_acc_sat_lh_s0] = generate_M2_mpy_acc_sat_lh_s0,
    [M2_mpy_acc_sat_lh_s1] = generate_M2_mpy_acc_sat_lh_s1,
    [M2_mpy_acc_sat_ll_s0] = generate_M2_mpy_acc_sat_ll_s0,
    [M2_mpy_acc_sat_ll_s1] = generate_M2_mpy_acc_sat_ll_s1,
    [M2_mpy_nac_sat_hh_s0] = generate_M2_mpy_nac_sat_hh_s0,
    [M2_mpy_nac_sat_hh_s1] = generate_M2_mpy_nac_sat_hh_s1,
    [M2_mpy_nac_sat_hl_s0] = generate_M2_mpy_nac_sat_hl_s0,
    [M2_mpy_nac_sat_hl_s1] = generate_M2_mpy_nac_sat_hl_s1,
    [M2_mpy_nac_sat_lh_s0] = generate_M2_mpy_nac_sat_lh_s0,
    [M2_mpy_nac_sat_lh_s1] = generate_M2_mpy_nac_sat_lh_s1,
    [M2_mpy_nac_sat_ll_s0] = generate_M2_mpy_nac_sat_ll_s0,
    [M2_mpy_nac_sat_ll_s1] = generate_M2_mpy_nac_sat_ll_s1,
    [M2_mpy_hh_s0] = generate_M2_mpy_hh_s0,
    [M2_mpy_hh_s1] = generate_M2_mpy_hh_s1,
    [M2_mpy_hl_s0] = generate_M2_mpy_hl_s0,
    [M2_mpy_hl_s1] = generate_M2_mpy_hl_s1,
    [M2_mpy_lh_s0] = generate_M2_mpy_lh_s0,
    [M2_mpy_lh_s1] = generate_M2_mpy_lh_s1,
    [M2_mpy_ll_s0] = generate_M2_mpy_ll_s0,
    [M2_mpy_ll_s1] = generate_M2_mpy_ll_s1,
    [M2_mpy_sat_hh_s0] = generate_M2_mpy_sat_hh_s0,
    [M2_mpy_sat_hh_s1] = generate_M2_mpy_sat_hh_s1,
    [M2_mpy_sat_hl_s0] = generate_M2_mpy_sat_hl_s0,
    [M2_mpy_sat_hl_s1] = generate_M2_mpy_sat_hl_s1,
    [M2_mpy_sat_lh_s0] = generate_M2_mpy_sat_lh_s0,
    [M2_mpy_sat_lh_s1] = generate_M2_mpy_sat_lh_s1,
    [M2_mpy_sat_ll_s0] = generate_M2_mpy_sat_ll_s0,
    [M2_mpy_sat_ll_s1] = generate_M2_mpy_sat_ll_s1,
    [M2_mpy_rnd_hh_s0] = generate_M2_mpy_rnd_hh_s0,
    [M2_mpy_rnd_hh_s1] = generate_M2_mpy_rnd_hh_s1,
    [M2_mpy_rnd_hl_s0] = generate_M2_mpy_rnd_hl_s0,
    [M2_mpy_rnd_hl_s1] = generate_M2_mpy_rnd_hl_s1,
    [M2_mpy_rnd_lh_s0] = generate_M2_mpy_rnd_lh_s0,
    [M2_mpy_rnd_lh_s1] = generate_M2_mpy_rnd_lh_s1,
    [M2_mpy_rnd_ll_s0] = generate_M2_mpy_rnd_ll_s0,
    [M2_mpy_rnd_ll_s1] = generate_M2_mpy_rnd_ll_s1,
    [M2_mpy_sat_rnd_hh_s0] = generate_M2_mpy_sat_rnd_hh_s0,
    [M2_mpy_sat_rnd_hh_s1] = generate_M2_mpy_sat_rnd_hh_s1,
    [M2_mpy_sat_rnd_hl_s0] = generate_M2_mpy_sat_rnd_hl_s0,
    [M2_mpy_sat_rnd_hl_s1] = generate_M2_mpy_sat_rnd_hl_s1,
    [M2_mpy_sat_rnd_lh_s0] = generate_M2_mpy_sat_rnd_lh_s0,
    [M2_mpy_sat_rnd_lh_s1] = generate_M2_mpy_sat_rnd_lh_s1,
    [M2_mpy_sat_rnd_ll_s0] = generate_M2_mpy_sat_rnd_ll_s0,
    [M2_mpy_sat_rnd_ll_s1] = generate_M2_mpy_sat_rnd_ll_s1,
    [M2_mpyd_acc_hh_s0] = generate_M2_mpyd_acc_hh_s0,
    [M2_mpyd_acc_hh_s1] = generate_M2_mpyd_acc_hh_s1,
    [M2_mpyd_acc_hl_s0] = generate_M2_mpyd_acc_hl_s0,
    [M2_mpyd_acc_hl_s1] = generate_M2_mpyd_acc_hl_s1,
    [M2_mpyd_acc_lh_s0] = generate_M2_mpyd_acc_lh_s0,
    [M2_mpyd_acc_lh_s1] = generate_M2_mpyd_acc_lh_s1,
    [M2_mpyd_acc_ll_s0] = generate_M2_mpyd_acc_ll_s0,
    [M2_mpyd_acc_ll_s1] = generate_M2_mpyd_acc_ll_s1,
    [M2_mpyd_nac_hh_s0] = generate_M2_mpyd_nac_hh_s0,
    [M2_mpyd_nac_hh_s1] = generate_M2_mpyd_nac_hh_s1,
    [M2_mpyd_nac_hl_s0] = generate_M2_mpyd_nac_hl_s0,
    [M2_mpyd_nac_hl_s1] = generate_M2_mpyd_nac_hl_s1,
    [M2_mpyd_nac_lh_s0] = generate_M2_mpyd_nac_lh_s0,
    [M2_mpyd_nac_lh_s1] = generate_M2_mpyd_nac_lh_s1,
    [M2_mpyd_nac_ll_s0] = generate_M2_mpyd_nac_ll_s0,
    [M2_mpyd_nac_ll_s1] = generate_M2_mpyd_nac_ll_s1,
    [M2_mpyd_hh_s0] = generate_M2_mpyd_hh_s0,
    [M2_mpyd_hh_s1] = generate_M2_mpyd_hh_s1,
    [M2_mpyd_hl_s0] = generate_M2_mpyd_hl_s0,
    [M2_mpyd_hl_s1] = generate_M2_mpyd_hl_s1,
    [M2_mpyd_lh_s0] = generate_M2_mpyd_lh_s0,
    [M2_mpyd_lh_s1] = generate_M2_mpyd_lh_s1,
    [M2_mpyd_ll_s0] = generate_M2_mpyd_ll_s0,
    [M2_mpyd_ll_s1] = generate_M2_mpyd_ll_s1,
    [M2_mpyd_rnd_hh_s0] = generate_M2_mpyd_rnd_hh_s0,
    [M2_mpyd_rnd_hh_s1] = generate_M2_mpyd_rnd_hh_s1,
    [M2_mpyd_rnd_hl_s0] = generate_M2_mpyd_rnd_hl_s0,
    [M2_mpyd_rnd_hl_s1] = generate_M2_mpyd_rnd_hl_s1,
    [M2_mpyd_rnd_lh_s0] = generate_M2_mpyd_rnd_lh_s0,
    [M2_mpyd_rnd_lh_s1] = generate_M2_mpyd_rnd_lh_s1,
    [M2_mpyd_rnd_ll_s0] = generate_M2_mpyd_rnd_ll_s0,
    [M2_mpyd_rnd_ll_s1] = generate_M2_mpyd_rnd_ll_s1,
    [M2_mpyu_acc_hh_s0] = generate_M2_mpyu_acc_hh_s0,
    [M2_mpyu_acc_hh_s1] = generate_M2_mpyu_acc_hh_s1,
    [M2_mpyu_acc_hl_s0] = generate_M2_mpyu_acc_hl_s0,
    [M2_mpyu_acc_hl_s1] = generate_M2_mpyu_acc_hl_s1,
    [M2_mpyu_acc_lh_s0] = generate_M2_mpyu_acc_lh_s0,
    [M2_mpyu_acc_lh_s1] = generate_M2_mpyu_acc_lh_s1,
    [M2_mpyu_acc_ll_s0] = generate_M2_mpyu_acc_ll_s0,
    [M2_mpyu_acc_ll_s1] = generate_M2_mpyu_acc_ll_s1,
    [M2_mpyu_nac_hh_s0] = generate_M2_mpyu_nac_hh_s0,
    [M2_mpyu_nac_hh_s1] = generate_M2_mpyu_nac_hh_s1,
    [M2_mpyu_nac_hl_s0] = generate_M2_mpyu_nac_hl_s0,
    [M2_mpyu_nac_hl_s1] = generate_M2_mpyu_nac_hl_s1,
    [M2_mpyu_nac_lh_s0] = generate_M2_mpyu_nac_lh_s0,
    [M2_mpyu_nac_lh_s1] = generate_M2_mpyu_nac_lh_s1,
    [M2_mpyu_nac_ll_s0] = generate_M2_mpyu_nac_ll_s0,
    [M2_mpyu_nac_ll_s1] = generate_M2_mpyu_nac_ll_s1,
    [M2_mpyu_hh_s0] = generate_M2_mpyu_hh_s0,
    [M2_mpyu_hh_s1] = generate_M2_mpyu_hh_s1,
    [M2_mpyu_hl_s0] = generate_M2_mpyu_hl_s0,
    [M2_mpyu_hl_s1] = generate_M2_mpyu_hl_s1,
    [M2_mpyu_lh_s0] = generate_M2_mpyu_lh_s0,
    [M2_mpyu_lh_s1] = generate_M2_mpyu_lh_s1,
    [M2_mpyu_ll_s0] = generate_M2_mpyu_ll_s0,
    [M2_mpyu_ll_s1] = generate_M2_mpyu_ll_s1,
    [M2_mpyud_acc_hh_s0] = generate_M2_mpyud_acc_hh_s0,
    [M2_mpyud_acc_hh_s1] = generate_M2_mpyud_acc_hh_s1,
    [M2_mpyud_acc_hl_s0] = generate_M2_mpyud_acc_hl_s0,
    [M2_mpyud_acc_hl_s1] = generate_M2_mpyud_acc_hl_s1,
    [M2_mpyud_acc_lh_s0] = generate_M2_mpyud_acc_lh_s0,
    [M2_mpyud_acc_lh_s1] = generate_M2_mpyud_acc_lh_s1,
    [M2_mpyud_acc_ll_s0] = generate_M2_mpyud_acc_ll_s0,
    [M2_mpyud_acc_ll_s1] = generate_M2_mpyud_acc_ll_s1,
    [M2_mpyud_nac_hh_s0] = generate_M2_mpyud_nac_hh_s0,
    [M2_mpyud_nac_hh_s1] = generate_M2_mpyud_nac_hh_s1,
    [M2_mpyud_nac_hl_s0] = generate_M2_mpyud_nac_hl_s0,
    [M2_mpyud_nac_hl_s1] = generate_M2_mpyud_nac_hl_s1,
    [M2_mpyud_nac_lh_s0] = generate_M2_mpyud_nac_lh_s0,
    [M2_mpyud_nac_lh_s1] = generate_M2_mpyud_nac_lh_s1,
    [M2_mpyud_nac_ll_s0] = generate_M2_mpyud_nac_ll_s0,
    [M2_mpyud_nac_ll_s1] = generate_M2_mpyud_nac_ll_s1,
    [M2_mpyud_hh_s0] = generate_M2_mpyud_hh_s0,
    [M2_mpyud_hh_s1] = generate_M2_mpyud_hh_s1,
    [M2_mpyud_hl_s0] = generate_M2_mpyud_hl_s0,
    [M2_mpyud_hl_s1] = generate_M2_mpyud_hl_s1,
    [M2_mpyud_lh_s0] = generate_M2_mpyud_lh_s0,
    [M2_mpyud_lh_s1] = generate_M2_mpyud_lh_s1,
    [M2_mpyud_ll_s0] = generate_M2_mpyud_ll_s0,
    [M2_mpyud_ll_s1] = generate_M2_mpyud_ll_s1,
    [M2_mpysip] = generate_M2_mpysip,
    [M2_mpysin] = generate_M2_mpysin,
    [M2_macsip] = generate_M2_macsip,
    [M2_macsin] = generate_M2_macsin,
    [M2_dpmpyss_s0] = generate_M2_dpmpyss_s0,
    [M2_dpmpyss_acc_s0] = generate_M2_dpmpyss_acc_s0,
    [M2_dpmpyss_nac_s0] = generate_M2_dpmpyss_nac_s0,
    [M2_dpmpyuu_s0] = generate_M2_dpmpyuu_s0,
    [M2_dpmpyuu_acc_s0] = generate_M2_dpmpyuu_acc_s0,
    [M2_dpmpyuu_nac_s0] = generate_M2_dpmpyuu_nac_s0,
    [M2_mpy_up] = generate_M2_mpy_up,
    [M2_mpy_up_s1] = generate_M2_mpy_up_s1,
    [M2_mpy_up_s1_sat] = generate_M2_mpy_up_s1_sat,
    [M2_mpyu_up] = generate_M2_mpyu_up,
    [M2_mpysu_up] = generate_M2_mpysu_up,
    [M2_dpmpyss_rnd_s0] = generate_M2_dpmpyss_rnd_s0,
    [M4_mac_up_s1_sat] = generate_M4_mac_up_s1_sat,
    [M4_nac_up_s1_sat] = generate_M4_nac_up_s1_sat,
    [M2_mpyi] = generate_M2_mpyi,
    [M2_maci] = generate_M2_maci,
    [M2_mnaci] = generate_M2_mnaci,
    [M2_acci] = generate_M2_acci,
    [M2_accii] = generate_M2_accii,
    [M2_nacci] = generate_M2_nacci,
    [M2_naccii] = generate_M2_naccii,
    [M2_subacc] = generate_M2_subacc,
    [M4_mpyrr_addr] = generate_M4_mpyrr_addr,
    [M4_mpyri_addr_u2] = generate_M4_mpyri_addr_u2,
    [M4_mpyri_addr] = generate_M4_mpyri_addr,
    [M4_mpyri_addi] = generate_M4_mpyri_addi,
    [M4_mpyrr_addi] = generate_M4_mpyrr_addi,
    [M2_vmpy2s_s0] = generate_M2_vmpy2s_s0,
    [M2_vmpy2s_s1] = generate_M2_vmpy2s_s1,
    [M2_vmac2s_s0] = generate_M2_vmac2s_s0,
    [M2_vmac2s_s1] = generate_M2_vmac2s_s1,
    [M2_vmpy2su_s0] = generate_M2_vmpy2su_s0,
    [M2_vmpy2su_s1] = generate_M2_vmpy2su_s1,
    [M2_vmac2su_s0] = generate_M2_vmac2su_s0,
    [M2_vmac2su_s1] = generate_M2_vmac2su_s1,
    [M2_vmpy2s_s0pack] = generate_M2_vmpy2s_s0pack,
    [M2_vmpy2s_s1pack] = generate_M2_vmpy2s_s1pack,
    [M2_vmac2] = generate_M2_vmac2,
    [M2_vmpy2es_s0] = generate_M2_vmpy2es_s0,
    [M2_vmpy2es_s1] = generate_M2_vmpy2es_s1,
    [M2_vmac2es_s0] = generate_M2_vmac2es_s0,
    [M2_vmac2es_s1] = generate_M2_vmac2es_s1,
    [M2_vmac2es] = generate_M2_vmac2es,
    [M2_vrmac_s0] = generate_M2_vrmac_s0,
    [M2_vrmpy_s0] = generate_M2_vrmpy_s0,
    [M2_vdmpyrs_s0] = generate_M2_vdmpyrs_s0,
    [M2_vdmpyrs_s1] = generate_M2_vdmpyrs_s1,
    [M5_vrmpybuu] = generate_M5_vrmpybuu,
    [M5_vrmacbuu] = generate_M5_vrmacbuu,
    [M5_vrmpybsu] = generate_M5_vrmpybsu,
    [M5_vrmacbsu] = generate_M5_vrmacbsu,
    [M5_vmpybuu] = generate_M5_vmpybuu,
    [M5_vmpybsu] = generate_M5_vmpybsu,
    [M5_vmacbuu] = generate_M5_vmacbuu,
    [M5_vmacbsu] = generate_M5_vmacbsu,
    [M5_vdmpybsu] = generate_M5_vdmpybsu,
    [M5_vdmacbsu] = generate_M5_vdmacbsu,
    [M2_vdmacs_s0] = generate_M2_vdmacs_s0,
    [M2_vdmacs_s1] = generate_M2_vdmacs_s1,
    [M2_vdmpys_s0] = generate_M2_vdmpys_s0,
    [M2_vdmpys_s1] = generate_M2_vdmpys_s1,
    [M2_cmpyrs_s0] = generate_M2_cmpyrs_s0,
    [M2_cmpyrs_s1] = generate_M2_cmpyrs_s1,
    [M2_cmpyrsc_s0] = generate_M2_cmpyrsc_s0,
    [M2_cmpyrsc_s1] = generate_M2_cmpyrsc_s1,
    [M2_cmacs_s0] = generate_M2_cmacs_s0,
    [M2_cmacs_s1] = generate_M2_cmacs_s1,
    [M2_cmacsc_s0] = generate_M2_cmacsc_s0,
    [M2_cmacsc_s1] = generate_M2_cmacsc_s1,
    [M2_cmpys_s0] = generate_M2_cmpys_s0,
    [M2_cmpys_s1] = generate_M2_cmpys_s1,
    [M2_cmpysc_s0] = generate_M2_cmpysc_s0,
    [M2_cmpysc_s1] = generate_M2_cmpysc_s1,
    [M2_cnacs_s0] = generate_M2_cnacs_s0,
    [M2_cnacs_s1] = generate_M2_cnacs_s1,
    [M2_cnacsc_s0] = generate_M2_cnacsc_s0,
    [M2_cnacsc_s1] = generate_M2_cnacsc_s1,
    [M2_vrcmpys_s1_h] = generate_M2_vrcmpys_s1_h,
    [M2_vrcmpys_s1_l] = generate_M2_vrcmpys_s1_l,
    [M2_vrcmpys_acc_s1_h] = generate_M2_vrcmpys_acc_s1_h,
    [M2_vrcmpys_acc_s1_l] = generate_M2_vrcmpys_acc_s1_l,
    [M2_vrcmpys_s1rp_h] = generate_M2_vrcmpys_s1rp_h,
    [M2_vrcmpys_s1rp_l] = generate_M2_vrcmpys_s1rp_l,
    [M2_mmacls_s0] = generate_M2_mmacls_s0,
    [M2_mmacls_s1] = generate_M2_mmacls_s1,
    [M2_mmachs_s0] = generate_M2_mmachs_s0,
    [M2_mmachs_s1] = generate_M2_mmachs_s1,
    [M2_mmpyl_s0] = generate_M2_mmpyl_s0,
    [M2_mmpyl_s1] = generate_M2_mmpyl_s1,
    [M2_mmpyh_s0] = generate_M2_mmpyh_s0,
    [M2_mmpyh_s1] = generate_M2_mmpyh_s1,
    [M2_mmacls_rs0] = generate_M2_mmacls_rs0,
    [M2_mmacls_rs1] = generate_M2_mmacls_rs1,
    [M2_mmachs_rs0] = generate_M2_mmachs_rs0,
    [M2_mmachs_rs1] = generate_M2_mmachs_rs1,
    [M2_mmpyl_rs0] = generate_M2_mmpyl_rs0,
    [M2_mmpyl_rs1] = generate_M2_mmpyl_rs1,
    [M2_mmpyh_rs0] = generate_M2_mmpyh_rs0,
    [M2_mmpyh_rs1] = generate_M2_mmpyh_rs1,
    [M4_vrmpyeh_s0] = generate_M4_vrmpyeh_s0,
    [M4_vrmpyeh_s1] = generate_M4_vrmpyeh_s1,
    [M4_vrmpyeh_acc_s0] = generate_M4_vrmpyeh_acc_s0,
    [M4_vrmpyeh_acc_s1] = generate_M4_vrmpyeh_acc_s1,
    [M4_vrmpyoh_s0] = generate_M4_vrmpyoh_s0,
    [M4_vrmpyoh_s1] = generate_M4_vrmpyoh_s1,
    [M4_vrmpyoh_acc_s0] = generate_M4_vrmpyoh_acc_s0,
    [M4_vrmpyoh_acc_s1] = generate_M4_vrmpyoh_acc_s1,
    [M2_hmmpyl_rs1] = generate_M2_hmmpyl_rs1,
    [M2_hmmpyh_rs1] = generate_M2_hmmpyh_rs1,
    [M2_hmmpyl_s1] = generate_M2_hmmpyl_s1,
    [M2_hmmpyh_s1] = generate_M2_hmmpyh_s1,
    [M2_mmaculs_s0] = generate_M2_mmaculs_s0,
    [M2_mmaculs_s1] = generate_M2_mmaculs_s1,
    [M2_mmacuhs_s0] = generate_M2_mmacuhs_s0,
    [M2_mmacuhs_s1] = generate_M2_mmacuhs_s1,
    [M2_mmpyul_s0] = generate_M2_mmpyul_s0,
    [M2_mmpyul_s1] = generate_M2_mmpyul_s1,
    [M2_mmpyuh_s0] = generate_M2_mmpyuh_s0,
    [M2_mmpyuh_s1] = generate_M2_mmpyuh_s1,
    [M2_mmaculs_rs0] = generate_M2_mmaculs_rs0,
    [M2_mmaculs_rs1] = generate_M2_mmaculs_rs1,
    [M2_mmacuhs_rs0] = generate_M2_mmacuhs_rs0,
    [M2_mmacuhs_rs1] = generate_M2_mmacuhs_rs1,
    [M2_mmpyul_rs0] = generate_M2_mmpyul_rs0,
    [M2_mmpyul_rs1] = generate_M2_mmpyul_rs1,
    [M2_mmpyuh_rs0] = generate_M2_mmpyuh_rs0,
    [M2_mmpyuh_rs1] = generate_M2_mmpyuh_rs1,
    [M2_vrcmaci_s0] = generate_M2_vrcmaci_s0,
    [M2_vrcmacr_s0] = generate_M2_vrcmacr_s0,
    [M2_vrcmaci_s0c] = generate_M2_vrcmaci_s0c,
    [M2_vrcmacr_s0c] = generate_M2_vrcmacr_s0c,
    [M2_cmaci_s0] = generate_M2_cmaci_s0,
    [M2_cmacr_s0] = generate_M2_cmacr_s0,
    [M2_vrcmpyi_s0] = generate_M2_vrcmpyi_s0,
    [M2_vrcmpyr_s0] = generate_M2_vrcmpyr_s0,
    [M2_vrcmpyi_s0c] = generate_M2_vrcmpyi_s0c,
    [M2_vrcmpyr_s0c] = generate_M2_vrcmpyr_s0c,
    [M2_cmpyi_s0] = generate_M2_cmpyi_s0,
    [M2_cmpyr_s0] = generate_M2_cmpyr_s0,
    [M4_cmpyi_wh] = generate_M4_cmpyi_wh,
    [M4_cmpyr_wh] = generate_M4_cmpyr_wh,
    [M4_cmpyi_whc] = generate_M4_cmpyi_whc,
    [M4_cmpyr_whc] = generate_M4_cmpyr_whc,
    [M2_vcmpy_s0_sat_i] = generate_M2_vcmpy_s0_sat_i,
    [M2_vcmpy_s0_sat_r] = generate_M2_vcmpy_s0_sat_r,
    [M2_vcmpy_s1_sat_i] = generate_M2_vcmpy_s1_sat_i,
    [M2_vcmpy_s1_sat_r] = generate_M2_vcmpy_s1_sat_r,
    [M2_vcmac_s0_sat_i] = generate_M2_vcmac_s0_sat_i,
    [M2_vcmac_s0_sat_r] = generate_M2_vcmac_s0_sat_r,
    [S2_vcrotate] = generate_S2_vcrotate,
    [S4_vrcrotate_acc] = generate_S4_vrcrotate_acc,
    [S4_vrcrotate] = generate_S4_vrcrotate,
    [S2_vcnegh] = generate_S2_vcnegh,
    [S2_vrcnegh] = generate_S2_vrcnegh,
    [M4_pmpyw] = generate_M4_pmpyw,
    [M4_vpmpyh] = generate_M4_vpmpyh,
    [M4_pmpyw_acc] = generate_M4_pmpyw_acc,
    [M4_vpmpyh_acc] = generate_M4_vpmpyh_acc,
    [M7_dcmpyrw] = generate_M7_dcmpyrw,
    [M7_dcmpyrw_acc] = generate_M7_dcmpyrw_acc,
    [M7_dcmpyrwc] = generate_M7_dcmpyrwc,
    [M7_dcmpyrwc_acc] = generate_M7_dcmpyrwc_acc,
    [M7_dcmpyiw] = generate_M7_dcmpyiw,
    [M7_dcmpyiw_acc] = generate_M7_dcmpyiw_acc,
    [M7_dcmpyiwc] = generate_M7_dcmpyiwc,
    [M7_dcmpyiwc_acc] = generate_M7_dcmpyiwc_acc,
    [M7_wcmpyrw] = generate_M7_wcmpyrw,
    [M7_wcmpyrwc] = generate_M7_wcmpyrwc,
    [M7_wcmpyiw] = generate_M7_wcmpyiw,
    [M7_wcmpyiwc] = generate_M7_wcmpyiwc,
    [M7_wcmpyrw_rnd] = generate_M7_wcmpyrw_rnd,
    [M7_wcmpyrwc_rnd] = generate_M7_wcmpyrwc_rnd,
    [M7_wcmpyiw_rnd] = generate_M7_wcmpyiw_rnd,
    [M7_wcmpyiwc_rnd] = generate_M7_wcmpyiwc_rnd,
    [A2_add] = generate_A2_add,
    [A2_sub] = generate_A2_sub,
    [A2_paddt] = generate_A2_paddt,
    [A2_paddf] = generate_A2_paddf,
    [A2_paddtnew] = generate_A2_paddtnew,
    [A2_paddfnew] = generate_A2_paddfnew,
    [A2_psubt] = generate_A2_psubt,
    [A2_psubf] = generate_A2_psubf,
    [A2_psubtnew] = generate_A2_psubtnew,
    [A2_psubfnew] = generate_A2_psubfnew,
    [A2_paddit] = generate_A2_paddit,
    [A2_paddif] = generate_A2_paddif,
    [A2_padditnew] = generate_A2_padditnew,
    [A2_paddifnew] = generate_A2_paddifnew,
    [A2_pxort] = generate_A2_pxort,
    [A2_pxorf] = generate_A2_pxorf,
    [A2_pxortnew] = generate_A2_pxortnew,
    [A2_pxorfnew] = generate_A2_pxorfnew,
    [A2_pandt] = generate_A2_pandt,
    [A2_pandf] = generate_A2_pandf,
    [A2_pandtnew] = generate_A2_pandtnew,
    [A2_pandfnew] = generate_A2_pandfnew,
    [A2_port] = generate_A2_port,
    [A2_porf] = generate_A2_porf,
    [A2_portnew] = generate_A2_portnew,
    [A2_porfnew] = generate_A2_porfnew,
    [A4_psxtbt] = generate_A4_psxtbt,
    [A4_psxtbf] = generate_A4_psxtbf,
    [A4_psxtbtnew] = generate_A4_psxtbtnew,
    [A4_psxtbfnew] = generate_A4_psxtbfnew,
    [A4_pzxtbt] = generate_A4_pzxtbt,
    [A4_pzxtbf] = generate_A4_pzxtbf,
    [A4_pzxtbtnew] = generate_A4_pzxtbtnew,
    [A4_pzxtbfnew] = generate_A4_pzxtbfnew,
    [A4_psxtht] = generate_A4_psxtht,
    [A4_psxthf] = generate_A4_psxthf,
    [A4_psxthtnew] = generate_A4_psxthtnew,
    [A4_psxthfnew] = generate_A4_psxthfnew,
    [A4_pzxtht] = generate_A4_pzxtht,
    [A4_pzxthf] = generate_A4_pzxthf,
    [A4_pzxthtnew] = generate_A4_pzxthtnew,
    [A4_pzxthfnew] = generate_A4_pzxthfnew,
    [A4_paslht] = generate_A4_paslht,
    [A4_paslhf] = generate_A4_paslhf,
    [A4_paslhtnew] = generate_A4_paslhtnew,
    [A4_paslhfnew] = generate_A4_paslhfnew,
    [A4_pasrht] = generate_A4_pasrht,
    [A4_pasrhf] = generate_A4_pasrhf,
    [A4_pasrhtnew] = generate_A4_pasrhtnew,
    [A4_pasrhfnew] = generate_A4_pasrhfnew,
    [A2_addsat] = generate_A2_addsat,
    [A2_subsat] = generate_A2_subsat,
    [A2_addi] = generate_A2_addi,
    [C4_addipc] = generate_C4_addipc,
    [A2_addh_l16_ll] = generate_A2_addh_l16_ll,
    [A2_addh_l16_hl] = generate_A2_addh_l16_hl,
    [A2_addh_l16_sat_ll] = generate_A2_addh_l16_sat_ll,
    [A2_addh_l16_sat_hl] = generate_A2_addh_l16_sat_hl,
    [A2_subh_l16_ll] = generate_A2_subh_l16_ll,
    [A2_subh_l16_hl] = generate_A2_subh_l16_hl,
    [A2_subh_l16_sat_ll] = generate_A2_subh_l16_sat_ll,
    [A2_subh_l16_sat_hl] = generate_A2_subh_l16_sat_hl,
    [A2_addh_h16_ll] = generate_A2_addh_h16_ll,
    [A2_addh_h16_lh] = generate_A2_addh_h16_lh,
    [A2_addh_h16_hl] = generate_A2_addh_h16_hl,
    [A2_addh_h16_hh] = generate_A2_addh_h16_hh,
    [A2_addh_h16_sat_ll] = generate_A2_addh_h16_sat_ll,
    [A2_addh_h16_sat_lh] = generate_A2_addh_h16_sat_lh,
    [A2_addh_h16_sat_hl] = generate_A2_addh_h16_sat_hl,
    [A2_addh_h16_sat_hh] = generate_A2_addh_h16_sat_hh,
    [A2_subh_h16_ll] = generate_A2_subh_h16_ll,
    [A2_subh_h16_lh] = generate_A2_subh_h16_lh,
    [A2_subh_h16_hl] = generate_A2_subh_h16_hl,
    [A2_subh_h16_hh] = generate_A2_subh_h16_hh,
    [A2_subh_h16_sat_ll] = generate_A2_subh_h16_sat_ll,
    [A2_subh_h16_sat_lh] = generate_A2_subh_h16_sat_lh,
    [A2_subh_h16_sat_hl] = generate_A2_subh_h16_sat_hl,
    [A2_subh_h16_sat_hh] = generate_A2_subh_h16_sat_hh,
    [A2_aslh] = generate_A2_aslh,
    [A2_asrh] = generate_A2_asrh,
    [A2_addp] = generate_A2_addp,
    [A2_addpsat] = generate_A2_addpsat,
    [A2_addspl] = generate_A2_addspl,
    [A2_addsph] = generate_A2_addsph,
    [A2_subp] = generate_A2_subp,
    [A4_addp_c] = generate_A4_addp_c,
    [A4_subp_c] = generate_A4_subp_c,
    [A2_negsat] = generate_A2_negsat,
    [A2_abs] = generate_A2_abs,
    [A2_abssat] = generate_A2_abssat,
    [A2_vconj] = generate_A2_vconj,
    [A2_negp] = generate_A2_negp,
    [A2_absp] = generate_A2_absp,
    [A2_max] = generate_A2_max,
    [A2_maxu] = generate_A2_maxu,
    [A2_min] = generate_A2_min,
    [A2_minu] = generate_A2_minu,
    [A2_maxp] = generate_A2_maxp,
    [A2_maxup] = generate_A2_maxup,
    [A2_minp] = generate_A2_minp,
    [A2_minup] = generate_A2_minup,
    [A2_nop] = generate_A2_nop,
    [A4_ext] = generate_A4_ext,
    [A2_tfr] = generate_A2_tfr,
    [A2_tfrsi] = generate_A2_tfrsi,
    [A2_sxtb] = generate_A2_sxtb,
    [A2_zxth] = generate_A2_zxth,
    [A2_sxth] = generate_A2_sxth,
    [A2_combinew] = generate_A2_combinew,
    [A4_combineri] = generate_A4_combineri,
    [A4_combineir] = generate_A4_combineir,
    [A2_combineii] = generate_A2_combineii,
    [A4_combineii] = generate_A4_combineii,
    [A2_combine_hh] = generate_A2_combine_hh,
    [A2_combine_hl] = generate_A2_combine_hl,
    [A2_combine_lh] = generate_A2_combine_lh,
    [A2_combine_ll] = generate_A2_combine_ll,
    [A2_tfril] = generate_A2_tfril,
    [A2_tfrih] = generate_A2_tfrih,
    [A2_tfrcrr] = generate_A2_tfrcrr,
    [A2_tfrrcr] = generate_A2_tfrrcr,
    [A4_tfrcpp] = generate_A4_tfrcpp,
    [A4_tfrpcp] = generate_A4_tfrpcp,
    [A2_and] = generate_A2_and,
    [A2_or] = generate_A2_or,
    [A2_xor] = generate_A2_xor,
    [M2_xor_xacc] = generate_M2_xor_xacc,
    [M4_xor_xacc] = generate_M4_xor_xacc,
    [A4_andn] = generate_A4_andn,
    [A4_orn] = generate_A4_orn,
    [A4_andnp] = generate_A4_andnp,
    [A4_ornp] = generate_A4_ornp,
    [S4_addaddi] = generate_S4_addaddi,
    [S4_subaddi] = generate_S4_subaddi,
    [M4_and_and] = generate_M4_and_and,
    [M4_and_andn] = generate_M4_and_andn,
    [M4_and_or] = generate_M4_and_or,
    [M4_and_xor] = generate_M4_and_xor,
    [M4_or_and] = generate_M4_or_and,
    [M4_or_andn] = generate_M4_or_andn,
    [M4_or_or] = generate_M4_or_or,
    [M4_or_xor] = generate_M4_or_xor,
    [S4_or_andix] = generate_S4_or_andix,
    [S4_or_andi] = generate_S4_or_andi,
    [S4_or_ori] = generate_S4_or_ori,
    [M4_xor_and] = generate_M4_xor_and,
    [M4_xor_or] = generate_M4_xor_or,
    [M4_xor_andn] = generate_M4_xor_andn,
    [A2_subri] = generate_A2_subri,
    [A2_andir] = generate_A2_andir,
    [A2_orir] = generate_A2_orir,
    [A2_andp] = generate_A2_andp,
    [A2_orp] = generate_A2_orp,
    [A2_xorp] = generate_A2_xorp,
    [A2_notp] = generate_A2_notp,
    [A2_sxtw] = generate_A2_sxtw,
    [A2_sat] = generate_A2_sat,
    [A2_roundsat] = generate_A2_roundsat,
    [A2_sath] = generate_A2_sath,
    [A2_satuh] = generate_A2_satuh,
    [A2_satub] = generate_A2_satub,
    [A2_satb] = generate_A2_satb,
    [A2_vaddub] = generate_A2_vaddub,
    [A2_vaddubs] = generate_A2_vaddubs,
    [A2_vaddh] = generate_A2_vaddh,
    [A2_vaddhs] = generate_A2_vaddhs,
    [A2_vadduhs] = generate_A2_vadduhs,
    [A5_vaddhubs] = generate_A5_vaddhubs,
    [A2_vaddw] = generate_A2_vaddw,
    [A2_vaddws] = generate_A2_vaddws,
    [S4_vxaddsubw] = generate_S4_vxaddsubw,
    [S4_vxsubaddw] = generate_S4_vxsubaddw,
    [S4_vxaddsubh] = generate_S4_vxaddsubh,
    [S4_vxsubaddh] = generate_S4_vxsubaddh,
    [S4_vxaddsubhr] = generate_S4_vxaddsubhr,
    [S4_vxsubaddhr] = generate_S4_vxsubaddhr,
    [A2_svavgh] = generate_A2_svavgh,
    [A2_svavghs] = generate_A2_svavghs,
    [A2_svnavgh] = generate_A2_svnavgh,
    [A2_svaddh] = generate_A2_svaddh,
    [A2_svaddhs] = generate_A2_svaddhs,
    [A2_svadduhs] = generate_A2_svadduhs,
    [A2_svsubh] = generate_A2_svsubh,
    [A2_svsubhs] = generate_A2_svsubhs,
    [A2_svsubuhs] = generate_A2_svsubuhs,
    [A2_vraddub] = generate_A2_vraddub,
    [A2_vraddub_acc] = generate_A2_vraddub_acc,
    [M2_vraddh] = generate_M2_vraddh,
    [M2_vradduh] = generate_M2_vradduh,
    [A2_vsubub] = generate_A2_vsubub,
    [A2_vsububs] = generate_A2_vsububs,
    [A2_vsubh] = generate_A2_vsubh,
    [A2_vsubhs] = generate_A2_vsubhs,
    [A2_vsubuhs] = generate_A2_vsubuhs,
    [A2_vsubw] = generate_A2_vsubw,
    [A2_vsubws] = generate_A2_vsubws,
    [A2_vabsh] = generate_A2_vabsh,
    [A2_vabshsat] = generate_A2_vabshsat,
    [A2_vabsw] = generate_A2_vabsw,
    [A2_vabswsat] = generate_A2_vabswsat,
    [M2_vabsdiffw] = generate_M2_vabsdiffw,
    [M2_vabsdiffh] = generate_M2_vabsdiffh,
    [M6_vabsdiffb] = generate_M6_vabsdiffb,
    [M6_vabsdiffub] = generate_M6_vabsdiffub,
    [A2_vrsadub] = generate_A2_vrsadub,
    [A2_vrsadub_acc] = generate_A2_vrsadub_acc,
    [A2_vavgub] = generate_A2_vavgub,
    [A2_vavguh] = generate_A2_vavguh,
    [A2_vavgh] = generate_A2_vavgh,
    [A2_vnavgh] = generate_A2_vnavgh,
    [A2_vavgw] = generate_A2_vavgw,
    [A2_vnavgw] = generate_A2_vnavgw,
    [A2_vavgwr] = generate_A2_vavgwr,
    [A2_vnavgwr] = generate_A2_vnavgwr,
    [A2_vavgwcr] = generate_A2_vavgwcr,
    [A2_vnavgwcr] = generate_A2_vnavgwcr,
    [A2_vavghcr] = generate_A2_vavghcr,
    [A2_vnavghcr] = generate_A2_vnavghcr,
    [A2_vavguw] = generate_A2_vavguw,
    [A2_vavguwr] = generate_A2_vavguwr,
    [A2_vavgubr] = generate_A2_vavgubr,
    [A2_vavguhr] = generate_A2_vavguhr,
    [A2_vavghr] = generate_A2_vavghr,
    [A2_vnavghr] = generate_A2_vnavghr,
    [A4_round_ri] = generate_A4_round_ri,
    [A4_round_rr] = generate_A4_round_rr,
    [A4_round_ri_sat] = generate_A4_round_ri_sat,
    [A4_round_rr_sat] = generate_A4_round_rr_sat,
    [A4_cround_ri] = generate_A4_cround_ri,
    [A4_cround_rr] = generate_A4_cround_rr,
    [A7_croundd_ri] = generate_A7_croundd_ri,
    [A7_croundd_rr] = generate_A7_croundd_rr,
    [A7_clip] = generate_A7_clip,
    [A7_vclip] = generate_A7_vclip,
    [A4_vrminh] = generate_A4_vrminh,
    [A4_vrmaxh] = generate_A4_vrmaxh,
    [A4_vrminuh] = generate_A4_vrminuh,
    [A4_vrmaxuh] = generate_A4_vrmaxuh,
    [A4_vrminw] = generate_A4_vrminw,
    [A4_vrmaxw] = generate_A4_vrmaxw,
    [A4_vrminuw] = generate_A4_vrminuw,
    [A4_vrmaxuw] = generate_A4_vrmaxuw,
    [A2_vminb] = generate_A2_vminb,
    [A2_vmaxb] = generate_A2_vmaxb,
    [A2_vminub] = generate_A2_vminub,
    [A2_vmaxub] = generate_A2_vmaxub,
    [A2_vminh] = generate_A2_vminh,
    [A2_vmaxh] = generate_A2_vmaxh,
    [A2_vminuh] = generate_A2_vminuh,
    [A2_vmaxuh] = generate_A2_vmaxuh,
    [A2_vminw] = generate_A2_vminw,
    [A2_vmaxw] = generate_A2_vmaxw,
    [A2_vminuw] = generate_A2_vminuw,
    [A2_vmaxuw] = generate_A2_vmaxuw,
    [A5_ACS] = generate_A5_ACS,
    [A6_vminub_RdP] = generate_A6_vminub_RdP,
    [A4_modwrapu] = generate_A4_modwrapu,
    [F2_sfadd] = generate_F2_sfadd,
    [F2_sfsub] = generate_F2_sfsub,
    [F2_sfmpy] = generate_F2_sfmpy,
    [F2_sffma] = generate_F2_sffma,
    [F2_sffma_sc] = generate_F2_sffma_sc,
    [F2_sffms] = generate_F2_sffms,
    [F2_sffma_lib] = generate_F2_sffma_lib,
    [F2_sffms_lib] = generate_F2_sffms_lib,
    [F2_sfcmpeq] = generate_F2_sfcmpeq,
    [F2_sfcmpgt] = generate_F2_sfcmpgt,
    [F2_sfcmpge] = generate_F2_sfcmpge,
    [F2_sfcmpuo] = generate_F2_sfcmpuo,
    [F2_sfmax] = generate_F2_sfmax,
    [F2_sfmin] = generate_F2_sfmin,
    [F2_sfclass] = generate_F2_sfclass,
    [F2_sfimm_p] = generate_F2_sfimm_p,
    [F2_sfimm_n] = generate_F2_sfimm_n,
    [F2_sfrecipa] = generate_F2_sfrecipa,
    [F2_sffixupn] = generate_F2_sffixupn,
    [F2_sffixupd] = generate_F2_sffixupd,
    [F2_sfinvsqrta] = generate_F2_sfinvsqrta,
    [F2_sffixupr] = generate_F2_sffixupr,
    [F2_dfadd] = generate_F2_dfadd,
    [F2_dfsub] = generate_F2_dfsub,
    [F2_dfmax] = generate_F2_dfmax,
    [F2_dfmin] = generate_F2_dfmin,
    [F2_dfmpyfix] = generate_F2_dfmpyfix,
    [F2_dfmpyll] = generate_F2_dfmpyll,
    [F2_dfmpylh] = generate_F2_dfmpylh,
    [F2_dfmpyhh] = generate_F2_dfmpyhh,
    [F2_dfcmpeq] = generate_F2_dfcmpeq,
    [F2_dfcmpgt] = generate_F2_dfcmpgt,
    [F2_dfcmpge] = generate_F2_dfcmpge,
    [F2_dfcmpuo] = generate_F2_dfcmpuo,
    [F2_dfclass] = generate_F2_dfclass,
    [F2_dfimm_p] = generate_F2_dfimm_p,
    [F2_dfimm_n] = generate_F2_dfimm_n,
    [F2_conv_sf2df] = generate_F2_conv_sf2df,
    [F2_conv_df2sf] = generate_F2_conv_df2sf,
    [F2_conv_uw2sf] = generate_F2_conv_uw2sf,
    [F2_conv_uw2df] = generate_F2_conv_uw2df,
    [F2_conv_w2sf] = generate_F2_conv_w2sf,
    [F2_conv_w2df] = generate_F2_conv_w2df,
    [F2_conv_ud2sf] = generate_F2_conv_ud2sf,
    [F2_conv_ud2df] = generate_F2_conv_ud2df,
    [F2_conv_d2sf] = generate_F2_conv_d2sf,
    [F2_conv_d2df] = generate_F2_conv_d2df,
    [F2_conv_sf2uw] = generate_F2_conv_sf2uw,
    [F2_conv_sf2w] = generate_F2_conv_sf2w,
    [F2_conv_sf2ud] = generate_F2_conv_sf2ud,
    [F2_conv_sf2d] = generate_F2_conv_sf2d,
    [F2_conv_df2uw] = generate_F2_conv_df2uw,
    [F2_conv_df2w] = generate_F2_conv_df2w,
    [F2_conv_df2ud] = generate_F2_conv_df2ud,
    [F2_conv_df2d] = generate_F2_conv_df2d,
    [F2_conv_sf2uw_chop] = generate_F2_conv_sf2uw_chop,
    [F2_conv_sf2w_chop] = generate_F2_conv_sf2w_chop,
    [F2_conv_sf2ud_chop] = generate_F2_conv_sf2ud_chop,
    [F2_conv_sf2d_chop] = generate_F2_conv_sf2d_chop,
    [F2_conv_df2uw_chop] = generate_F2_conv_df2uw_chop,
    [F2_conv_df2w_chop] = generate_F2_conv_df2w_chop,
    [F2_conv_df2ud_chop] = generate_F2_conv_df2ud_chop,
    [F2_conv_df2d_chop] = generate_F2_conv_df2d_chop,
    [S2_asr_r_r] = generate_S2_asr_r_r,
    [S2_asl_r_r] = generate_S2_asl_r_r,
    [S2_lsr_r_r] = generate_S2_lsr_r_r,
    [S2_lsl_r_r] = generate_S2_lsl_r_r,
    [S2_asr_r_p] = generate_S2_asr_r_p,
    [S2_asl_r_p] = generate_S2_asl_r_p,
    [S2_lsr_r_p] = generate_S2_lsr_r_p,
    [S2_lsl_r_p] = generate_S2_lsl_r_p,
    [S2_asr_r_r_acc] = generate_S2_asr_r_r_acc,
    [S2_asl_r_r_acc] = generate_S2_asl_r_r_acc,
    [S2_lsr_r_r_acc] = generate_S2_lsr_r_r_acc,
    [S2_lsl_r_r_acc] = generate_S2_lsl_r_r_acc,
    [S2_asr_r_p_acc] = generate_S2_asr_r_p_acc,
    [S2_asl_r_p_acc] = generate_S2_asl_r_p_acc,
    [S2_lsr_r_p_acc] = generate_S2_lsr_r_p_acc,
    [S2_lsl_r_p_acc] = generate_S2_lsl_r_p_acc,
    [S2_asr_r_r_nac] = generate_S2_asr_r_r_nac,
    [S2_asl_r_r_nac] = generate_S2_asl_r_r_nac,
    [S2_lsr_r_r_nac] = generate_S2_lsr_r_r_nac,
    [S2_lsl_r_r_nac] = generate_S2_lsl_r_r_nac,
    [S2_asr_r_p_nac] = generate_S2_asr_r_p_nac,
    [S2_asl_r_p_nac] = generate_S2_asl_r_p_nac,
    [S2_lsr_r_p_nac] = generate_S2_lsr_r_p_nac,
    [S2_lsl_r_p_nac] = generate_S2_lsl_r_p_nac,
    [S2_asr_r_r_and] = generate_S2_asr_r_r_and,
    [S2_asl_r_r_and] = generate_S2_asl_r_r_and,
    [S2_lsr_r_r_and] = generate_S2_lsr_r_r_and,
    [S2_lsl_r_r_and] = generate_S2_lsl_r_r_and,
    [S2_asr_r_r_or] = generate_S2_asr_r_r_or,
    [S2_asl_r_r_or] = generate_S2_asl_r_r_or,
    [S2_lsr_r_r_or] = generate_S2_lsr_r_r_or,
    [S2_lsl_r_r_or] = generate_S2_lsl_r_r_or,
    [S2_asr_r_p_and] = generate_S2_asr_r_p_and,
    [S2_asl_r_p_and] = generate_S2_asl_r_p_and,
    [S2_lsr_r_p_and] = generate_S2_lsr_r_p_and,
    [S2_lsl_r_p_and] = generate_S2_lsl_r_p_and,
    [S2_asr_r_p_or] = generate_S2_asr_r_p_or,
    [S2_asl_r_p_or] = generate_S2_asl_r_p_or,
    [S2_lsr_r_p_or] = generate_S2_lsr_r_p_or,
    [S2_lsl_r_p_or] = generate_S2_lsl_r_p_or,
    [S2_asr_r_p_xor] = generate_S2_asr_r_p_xor,
    [S2_asl_r_p_xor] = generate_S2_asl_r_p_xor,
    [S2_lsr_r_p_xor] = generate_S2_lsr_r_p_xor,
    [S2_lsl_r_p_xor] = generate_S2_lsl_r_p_xor,
    [S2_asr_r_r_sat] = generate_S2_asr_r_r_sat,
    [S2_asl_r_r_sat] = generate_S2_asl_r_r_sat,
    [S2_asr_i_r] = generate_S2_asr_i_r,
    [S2_lsr_i_r] = generate_S2_lsr_i_r,
    [S2_asl_i_r] = generate_S2_asl_i_r,
    [S6_rol_i_r] = generate_S6_rol_i_r,
    [S2_asr_i_p] = generate_S2_asr_i_p,
    [S2_lsr_i_p] = generate_S2_lsr_i_p,
    [S2_asl_i_p] = generate_S2_asl_i_p,
    [S6_rol_i_p] = generate_S6_rol_i_p,
    [S2_asr_i_r_acc] = generate_S2_asr_i_r_acc,
    [S2_lsr_i_r_acc] = generate_S2_lsr_i_r_acc,
    [S2_asl_i_r_acc] = generate_S2_asl_i_r_acc,
    [S6_rol_i_r_acc] = generate_S6_rol_i_r_acc,
    [S2_asr_i_p_acc] = generate_S2_asr_i_p_acc,
    [S2_lsr_i_p_acc] = generate_S2_lsr_i_p_acc,
    [S2_asl_i_p_acc] = generate_S2_asl_i_p_acc,
    [S6_rol_i_p_acc] = generate_S6_rol_i_p_acc,
    [S2_asr_i_r_nac] = generate_S2_asr_i_r_nac,
    [S2_lsr_i_r_nac] = generate_S2_lsr_i_r_nac,
    [S2_asl_i_r_nac] = generate_S2_asl_i_r_nac,
    [S6_rol_i_r_nac] = generate_S6_rol_i_r_nac,
    [S2_asr_i_p_nac] = generate_S2_asr_i_p_nac,
    [S2_lsr_i_p_nac] = generate_S2_lsr_i_p_nac,
    [S2_asl_i_p_nac] = generate_S2_asl_i_p_nac,
    [S6_rol_i_p_nac] = generate_S6_rol_i_p_nac,
    [S2_lsr_i_r_xacc] = generate_S2_lsr_i_r_xacc,
    [S2_asl_i_r_xacc] = generate_S2_asl_i_r_xacc,
    [S6_rol_i_r_xacc] = generate_S6_rol_i_r_xacc,
    [S2_lsr_i_p_xacc] = generate_S2_lsr_i_p_xacc,
    [S2_asl_i_p_xacc] = generate_S2_asl_i_p_xacc,
    [S6_rol_i_p_xacc] = generate_S6_rol_i_p_xacc,
    [S2_asr_i_r_and] = generate_S2_asr_i_r_and,
    [S2_lsr_i_r_and] = generate_S2_lsr_i_r_and,
    [S2_asl_i_r_and] = generate_S2_asl_i_r_and,
    [S6_rol_i_r_and] = generate_S6_rol_i_r_and,
    [S2_asr_i_r_or] = generate_S2_asr_i_r_or,
    [S2_lsr_i_r_or] = generate_S2_lsr_i_r_or,
    [S2_asl_i_r_or] = generate_S2_asl_i_r_or,
    [S6_rol_i_r_or] = generate_S6_rol_i_r_or,
    [S2_asr_i_p_and] = generate_S2_asr_i_p_and,
    [S2_lsr_i_p_and] = generate_S2_lsr_i_p_and,
    [S2_asl_i_p_and] = generate_S2_asl_i_p_and,
    [S6_rol_i_p_and] = generate_S6_rol_i_p_and,
    [S2_asr_i_p_or] = generate_S2_asr_i_p_or,
    [S2_lsr_i_p_or] = generate_S2_lsr_i_p_or,
    [S2_asl_i_p_or] = generate_S2_asl_i_p_or,
    [S6_rol_i_p_or] = generate_S6_rol_i_p_or,
    [S2_asl_i_r_sat] = generate_S2_asl_i_r_sat,
    [S2_asr_i_r_rnd] = generate_S2_asr_i_r_rnd,
    [S2_asr_i_p_rnd] = generate_S2_asr_i_p_rnd,
    [S4_lsli] = generate_S4_lsli,
    [S2_addasl_rrri] = generate_S2_addasl_rrri,
    [S4_andi_asl_ri] = generate_S4_andi_asl_ri,
    [S4_ori_asl_ri] = generate_S4_ori_asl_ri,
    [S4_addi_asl_ri] = generate_S4_addi_asl_ri,
    [S4_subi_asl_ri] = generate_S4_subi_asl_ri,
    [S4_andi_lsr_ri] = generate_S4_andi_lsr_ri,
    [S4_ori_lsr_ri] = generate_S4_ori_lsr_ri,
    [S4_addi_lsr_ri] = generate_S4_addi_lsr_ri,
    [S4_subi_lsr_ri] = generate_S4_subi_lsr_ri,
    [S2_valignib] = generate_S2_valignib,
    [S2_valignrb] = generate_S2_valignrb,
    [S2_vspliceib] = generate_S2_vspliceib,
    [S2_vsplicerb] = generate_S2_vsplicerb,
    [S2_vsplatrh] = generate_S2_vsplatrh,
    [S2_vsplatrb] = generate_S2_vsplatrb,
    [S6_vsplatrbp] = generate_S6_vsplatrbp,
    [S2_insert] = generate_S2_insert,
    [S2_tableidxb] = generate_S2_tableidxb,
    [S2_tableidxh] = generate_S2_tableidxh,
    [S2_tableidxw] = generate_S2_tableidxw,
    [S2_tableidxd] = generate_S2_tableidxd,
    [A4_bitspliti] = generate_A4_bitspliti,
    [A4_bitsplit] = generate_A4_bitsplit,
    [S4_extract] = generate_S4_extract,
    [S2_extractu] = generate_S2_extractu,
    [S2_insertp] = generate_S2_insertp,
    [S4_extractp] = generate_S4_extractp,
    [S2_extractup] = generate_S2_extractup,
    [S2_mask] = generate_S2_mask,
    [S2_insert_rp] = generate_S2_insert_rp,
    [S4_extract_rp] = generate_S4_extract_rp,
    [S2_extractu_rp] = generate_S2_extractu_rp,
    [S2_insertp_rp] = generate_S2_insertp_rp,
    [S4_extractp_rp] = generate_S4_extractp_rp,
    [S2_extractup_rp] = generate_S2_extractup_rp,
    [S2_tstbit_i] = generate_S2_tstbit_i,
    [S4_ntstbit_i] = generate_S4_ntstbit_i,
    [S2_setbit_i] = generate_S2_setbit_i,
    [S2_togglebit_i] = generate_S2_togglebit_i,
    [S2_clrbit_i] = generate_S2_clrbit_i,
    [S2_tstbit_r] = generate_S2_tstbit_r,
    [S4_ntstbit_r] = generate_S4_ntstbit_r,
    [S2_setbit_r] = generate_S2_setbit_r,
    [S2_togglebit_r] = generate_S2_togglebit_r,
    [S2_clrbit_r] = generate_S2_clrbit_r,
    [S2_asr_i_vh] = generate_S2_asr_i_vh,
    [S2_lsr_i_vh] = generate_S2_lsr_i_vh,
    [S2_asl_i_vh] = generate_S2_asl_i_vh,
    [S2_asr_r_vh] = generate_S2_asr_r_vh,
    [S5_asrhub_rnd_sat] = generate_S5_asrhub_rnd_sat,
    [S5_asrhub_sat] = generate_S5_asrhub_sat,
    [S5_vasrhrnd] = generate_S5_vasrhrnd,
    [S2_asl_r_vh] = generate_S2_asl_r_vh,
    [S2_lsr_r_vh] = generate_S2_lsr_r_vh,
    [S2_lsl_r_vh] = generate_S2_lsl_r_vh,
    [S2_asr_i_vw] = generate_S2_asr_i_vw,
    [S2_asr_i_svw_trun] = generate_S2_asr_i_svw_trun,
    [S2_asr_r_svw_trun] = generate_S2_asr_r_svw_trun,
    [S2_lsr_i_vw] = generate_S2_lsr_i_vw,
    [S2_asl_i_vw] = generate_S2_asl_i_vw,
    [S2_asr_r_vw] = generate_S2_asr_r_vw,
    [S2_asl_r_vw] = generate_S2_asl_r_vw,
    [S2_lsr_r_vw] = generate_S2_lsr_r_vw,
    [S2_lsl_r_vw] = generate_S2_lsl_r_vw,
    [S2_vrndpackwh] = generate_S2_vrndpackwh,
    [S2_vrndpackwhs] = generate_S2_vrndpackwhs,
    [S2_vsxtbh] = generate_S2_vsxtbh,
    [S2_vzxtbh] = generate_S2_vzxtbh,
    [S2_vsathub] = generate_S2_vsathub,
    [S2_svsathub] = generate_S2_svsathub,
    [S2_svsathb] = generate_S2_svsathb,
    [S2_vsathb] = generate_S2_vsathb,
    [S2_vtrunohb] = generate_S2_vtrunohb,
    [S2_vtrunewh] = generate_S2_vtrunewh,
    [S2_vtrunowh] = generate_S2_vtrunowh,
    [S2_vtrunehb] = generate_S2_vtrunehb,
    [S6_vtrunehb_ppp] = generate_S6_vtrunehb_ppp,
    [S6_vtrunohb_ppp] = generate_S6_vtrunohb_ppp,
    [S2_vsxthw] = generate_S2_vsxthw,
    [S2_vzxthw] = generate_S2_vzxthw,
    [S2_vsatwh] = generate_S2_vsatwh,
    [S2_vsatwuh] = generate_S2_vsatwuh,
    [S2_packhl] = generate_S2_packhl,
    [A2_swiz] = generate_A2_swiz,
    [S2_vsathub_nopack] = generate_S2_vsathub_nopack,
    [S2_vsathb_nopack] = generate_S2_vsathb_nopack,
    [S2_vsatwh_nopack] = generate_S2_vsatwh_nopack,
    [S2_vsatwuh_nopack] = generate_S2_vsatwuh_nopack,
    [S2_shuffob] = generate_S2_shuffob,
    [S2_shuffeb] = generate_S2_shuffeb,
    [S2_shuffoh] = generate_S2_shuffoh,
    [S2_shuffeh] = generate_S2_shuffeh,
    [S5_popcountp] = generate_S5_popcountp,
    [S4_parity] = generate_S4_parity,
    [S2_parityp] = generate_S2_parityp,
    [S2_lfsp] = generate_S2_lfsp,
    [S2_clbnorm] = generate_S2_clbnorm,
    [S4_clbaddi] = generate_S4_clbaddi,
    [S4_clbpnorm] = generate_S4_clbpnorm,
    [S4_clbpaddi] = generate_S4_clbpaddi,
    [S2_cabacdecbin] = generate_S2_cabacdecbin,
    [S2_clb] = generate_S2_clb,
    [S2_cl0] = generate_S2_cl0,
    [S2_cl1] = generate_S2_cl1,
    [S2_clbp] = generate_S2_clbp,
    [S2_cl0p] = generate_S2_cl0p,
    [S2_cl1p] = generate_S2_cl1p,
    [S2_brev] = generate_S2_brev,
    [S2_brevp] = generate_S2_brevp,
    [S2_ct0] = generate_S2_ct0,
    [S2_ct1] = generate_S2_ct1,
    [S2_ct0p] = generate_S2_ct0p,
    [S2_ct1p] = generate_S2_ct1p,
    [S2_interleave] = generate_S2_interleave,
    [S2_deinterleave] = generate_S2_deinterleave,
    [J2_trap0] = generate_J2_trap0,
    [J2_pause] = generate_J2_pause,
    [Y2_icinva] = generate_Y2_icinva,
    [Y2_isync] = generate_Y2_isync,
    [Y2_barrier] = generate_Y2_barrier,
    [Y2_syncht] = generate_Y2_syncht,
    [Y2_dcfetchbo] = generate_Y2_dcfetchbo,
    [Y2_dczeroa] = generate_Y2_dczeroa,
    [Y2_dccleana] = generate_Y2_dccleana,
    [Y2_dccleaninva] = generate_Y2_dccleaninva,
    [Y2_dcinva] = generate_Y2_dcinva,
    [Y4_l2fetch] = generate_Y4_l2fetch,
    [Y5_l2fetch] = generate_Y5_l2fetch,
    [SA1_addi] = generate_SA1_addi,
    [SA1_tfr] = generate_SA1_tfr,
    [SA1_seti] = generate_SA1_seti,
    [SA1_setin1] = generate_SA1_setin1,
    [SA1_clrtnew] = generate_SA1_clrtnew,
    [SA1_clrfnew] = generate_SA1_clrfnew,
    [SA1_clrt] = generate_SA1_clrt,
    [SA1_clrf] = generate_SA1_clrf,
    [SA1_addsp] = generate_SA1_addsp,
    [SA1_inc] = generate_SA1_inc,
    [SA1_dec] = generate_SA1_dec,
    [SA1_addrx] = generate_SA1_addrx,
    [SA1_zxtb] = generate_SA1_zxtb,
    [SA1_and1] = generate_SA1_and1,
    [SA1_sxtb] = generate_SA1_sxtb,
    [SA1_zxth] = generate_SA1_zxth,
    [SA1_sxth] = generate_SA1_sxth,
    [SA1_combinezr] = generate_SA1_combinezr,
    [SA1_combinerz] = generate_SA1_combinerz,
    [SA1_combine0i] = generate_SA1_combine0i,
    [SA1_combine1i] = generate_SA1_combine1i,
    [SA1_combine2i] = generate_SA1_combine2i,
    [SA1_combine3i] = generate_SA1_combine3i,
    [SA1_cmpeqi] = generate_SA1_cmpeqi,
    [SL1_loadri_io] = generate_SL1_loadri_io,
    [SL1_loadrub_io] = generate_SL1_loadrub_io,
    [SL2_loadrh_io] = generate_SL2_loadrh_io,
    [SL2_loadruh_io] = generate_SL2_loadruh_io,
    [SL2_loadrb_io] = generate_SL2_loadrb_io,
    [SL2_loadri_sp] = generate_SL2_loadri_sp,
    [SL2_loadrd_sp] = generate_SL2_loadrd_sp,
    [SL2_deallocframe] = generate_SL2_deallocframe,
    [SL2_return] = generate_SL2_return,
    [SL2_return_t] = generate_SL2_return_t,
    [SL2_return_f] = generate_SL2_return_f,
    [SL2_return_tnew] = generate_SL2_return_tnew,
    [SL2_return_fnew] = generate_SL2_return_fnew,
    [SL2_jumpr31] = generate_SL2_jumpr31,
    [SL2_jumpr31_t] = generate_SL2_jumpr31_t,
    [SL2_jumpr31_f] = generate_SL2_jumpr31_f,
    [SL2_jumpr31_tnew] = generate_SL2_jumpr31_tnew,
    [SL2_jumpr31_fnew] = generate_SL2_jumpr31_fnew,
    [SS1_storew_io] = generate_SS1_storew_io,
    [SS1_storeb_io] = generate_SS1_storeb_io,
    [SS2_storeh_io] = generate_SS2_storeh_io,
    [SS2_stored_sp] = generate_SS2_stored_sp,
    [SS2_storew_sp] = generate_SS2_storew_sp,
    [SS2_storewi0] = generate_SS2_storewi0,
    [SS2_storebi0] = generate_SS2_storebi0,
    [SS2_storewi1] = generate_SS2_storewi1,
    [SS2_storebi1] = generate_SS2_storebi1,
    [SS2_allocframe] = generate_SS2_allocframe,
    [V6_vL32b_pi] = generate_V6_vL32b_pi,
    [V6_vL32b_ai] = generate_V6_vL32b_ai,
    [V6_vL32b_ppu] = generate_V6_vL32b_ppu,
    [V6_vL32b_cur_pi] = generate_V6_vL32b_cur_pi,
    [V6_vL32b_cur_ai] = generate_V6_vL32b_cur_ai,
    [V6_vL32b_cur_ppu] = generate_V6_vL32b_cur_ppu,
    [V6_vL32b_tmp_pi] = generate_V6_vL32b_tmp_pi,
    [V6_vL32b_tmp_ai] = generate_V6_vL32b_tmp_ai,
    [V6_vL32b_tmp_ppu] = generate_V6_vL32b_tmp_ppu,
    [V6_vL32b_pred_pi] = generate_V6_vL32b_pred_pi,
    [V6_vL32b_pred_ai] = generate_V6_vL32b_pred_ai,
    [V6_vL32b_pred_ppu] = generate_V6_vL32b_pred_ppu,
    [V6_vL32b_npred_pi] = generate_V6_vL32b_npred_pi,
    [V6_vL32b_npred_ai] = generate_V6_vL32b_npred_ai,
    [V6_vL32b_npred_ppu] = generate_V6_vL32b_npred_ppu,
    [V6_vL32b_cur_pred_pi] = generate_V6_vL32b_cur_pred_pi,
    [V6_vL32b_cur_pred_ai] = generate_V6_vL32b_cur_pred_ai,
    [V6_vL32b_cur_pred_ppu] = generate_V6_vL32b_cur_pred_ppu,
    [V6_vL32b_cur_npred_pi] = generate_V6_vL32b_cur_npred_pi,
    [V6_vL32b_cur_npred_ai] = generate_V6_vL32b_cur_npred_ai,
    [V6_vL32b_cur_npred_ppu] = generate_V6_vL32b_cur_npred_ppu,
    [V6_vL32b_tmp_pred_pi] = generate_V6_vL32b_tmp_pred_pi,
    [V6_vL32b_tmp_pred_ai] = generate_V6_vL32b_tmp_pred_ai,
    [V6_vL32b_tmp_pred_ppu] = generate_V6_vL32b_tmp_pred_ppu,
    [V6_vL32b_tmp_npred_pi] = generate_V6_vL32b_tmp_npred_pi,
    [V6_vL32b_tmp_npred_ai] = generate_V6_vL32b_tmp_npred_ai,
    [V6_vL32b_tmp_npred_ppu] = generate_V6_vL32b_tmp_npred_ppu,
    [V6_vS32b_pi] = generate_V6_vS32b_pi,
    [V6_vS32b_ai] = generate_V6_vS32b_ai,
    [V6_vS32b_ppu] = generate_V6_vS32b_ppu,
    [V6_vS32b_pred_pi] = generate_V6_vS32b_pred_pi,
    [V6_vS32b_pred_ai] = generate_V6_vS32b_pred_ai,
    [V6_vS32b_pred_ppu] = generate_V6_vS32b_pred_ppu,
    [V6_vS32b_npred_pi] = generate_V6_vS32b_npred_pi,
    [V6_vS32b_npred_ai] = generate_V6_vS32b_npred_ai,
    [V6_vS32b_npred_ppu] = generate_V6_vS32b_npred_ppu,
    [V6_vS32b_qpred_pi] = generate_V6_vS32b_qpred_pi,
    [V6_vS32b_qpred_ai] = generate_V6_vS32b_qpred_ai,
    [V6_vS32b_qpred_ppu] = generate_V6_vS32b_qpred_ppu,
    [V6_vS32b_nqpred_pi] = generate_V6_vS32b_nqpred_pi,
    [V6_vS32b_nqpred_ai] = generate_V6_vS32b_nqpred_ai,
    [V6_vS32b_nqpred_ppu] = generate_V6_vS32b_nqpred_ppu,
    [V6_vL32Ub_pi] = generate_V6_vL32Ub_pi,
    [V6_vL32Ub_ai] = generate_V6_vL32Ub_ai,
    [V6_vL32Ub_ppu] = generate_V6_vL32Ub_ppu,
    [V6_vS32Ub_pi] = generate_V6_vS32Ub_pi,
    [V6_vS32Ub_ai] = generate_V6_vS32Ub_ai,
    [V6_vS32Ub_ppu] = generate_V6_vS32Ub_ppu,
    [V6_vS32Ub_pred_pi] = generate_V6_vS32Ub_pred_pi,
    [V6_vS32Ub_pred_ai] = generate_V6_vS32Ub_pred_ai,
    [V6_vS32Ub_pred_ppu] = generate_V6_vS32Ub_pred_ppu,
    [V6_vS32Ub_npred_pi] = generate_V6_vS32Ub_npred_pi,
    [V6_vS32Ub_npred_ai] = generate_V6_vS32Ub_npred_ai,
    [V6_vS32Ub_npred_ppu] = generate_V6_vS32Ub_npred_ppu,
    [V6_vS32b_new_pi] = generate_V6_vS32b_new_pi,
    [V6_vS32b_new_ai] = generate_V6_vS32b_new_ai,
    [V6_vS32b_new_ppu] = generate_V6_vS32b_new_ppu,
    [V6_vS32b_srls_pi] = generate_V6_vS32b_srls_pi,
    [V6_vS32b_srls_ai] = generate_V6_vS32b_srls_ai,
    [V6_vS32b_srls_ppu] = generate_V6_vS32b_srls_ppu,
    [V6_vS32b_new_pred_pi] = generate_V6_vS32b_new_pred_pi,
    [V6_vS32b_new_pred_ai] = generate_V6_vS32b_new_pred_ai,
    [V6_vS32b_new_pred_ppu] = generate_V6_vS32b_new_pred_ppu,
    [V6_vS32b_new_npred_pi] = generate_V6_vS32b_new_npred_pi,
    [V6_vS32b_new_npred_ai] = generate_V6_vS32b_new_npred_ai,
    [V6_vS32b_new_npred_ppu] = generate_V6_vS32b_new_npred_ppu,
    [V6_vS32b_nt_pi] = generate_V6_vS32b_nt_pi,
    [V6_vS32b_nt_ai] = generate_V6_vS32b_nt_ai,
    [V6_vS32b_nt_ppu] = generate_V6_vS32b_nt_ppu,
    [V6_vS32b_nt_pred_pi] = generate_V6_vS32b_nt_pred_pi,
    [V6_vS32b_nt_pred_ai] = generate_V6_vS32b_nt_pred_ai,
    [V6_vS32b_nt_pred_ppu] = generate_V6_vS32b_nt_pred_ppu,
    [V6_vS32b_nt_npred_pi] = generate_V6_vS32b_nt_npred_pi,
    [V6_vS32b_nt_npred_ai] = generate_V6_vS32b_nt_npred_ai,
    [V6_vS32b_nt_npred_ppu] = generate_V6_vS32b_nt_npred_ppu,
    [V6_vS32b_nt_new_pi] = generate_V6_vS32b_nt_new_pi,
    [V6_vS32b_nt_new_ai] = generate_V6_vS32b_nt_new_ai,
    [V6_vS32b_nt_new_ppu] = generate_V6_vS32b_nt_new_ppu,
    [V6_vS32b_nt_new_pred_pi] = generate_V6_vS32b_nt_new_pred_pi,
    [V6_vS32b_nt_new_pred_ai] = generate_V6_vS32b_nt_new_pred_ai,
    [V6_vS32b_nt_new_pred_ppu] = generate_V6_vS32b_nt_new_pred_ppu,
    [V6_vS32b_nt_new_npred_pi] = generate_V6_vS32b_nt_new_npred_pi,
    [V6_vS32b_nt_new_npred_ai] = generate_V6_vS32b_nt_new_npred_ai,
    [V6_vS32b_nt_new_npred_ppu] = generate_V6_vS32b_nt_new_npred_ppu,
    [V6_vS32b_nt_qpred_pi] = generate_V6_vS32b_nt_qpred_pi,
    [V6_vS32b_nt_qpred_ai] = generate_V6_vS32b_nt_qpred_ai,
    [V6_vS32b_nt_qpred_ppu] = generate_V6_vS32b_nt_qpred_ppu,
    [V6_vS32b_nt_nqpred_pi] = generate_V6_vS32b_nt_nqpred_pi,
    [V6_vS32b_nt_nqpred_ai] = generate_V6_vS32b_nt_nqpred_ai,
    [V6_vS32b_nt_nqpred_ppu] = generate_V6_vS32b_nt_nqpred_ppu,
    [V6_vL32b_nt_pi] = generate_V6_vL32b_nt_pi,
    [V6_vL32b_nt_ai] = generate_V6_vL32b_nt_ai,
    [V6_vL32b_nt_ppu] = generate_V6_vL32b_nt_ppu,
    [V6_vL32b_nt_cur_pi] = generate_V6_vL32b_nt_cur_pi,
    [V6_vL32b_nt_cur_ai] = generate_V6_vL32b_nt_cur_ai,
    [V6_vL32b_nt_cur_ppu] = generate_V6_vL32b_nt_cur_ppu,
    [V6_vL32b_nt_tmp_pi] = generate_V6_vL32b_nt_tmp_pi,
    [V6_vL32b_nt_tmp_ai] = generate_V6_vL32b_nt_tmp_ai,
    [V6_vL32b_nt_tmp_ppu] = generate_V6_vL32b_nt_tmp_ppu,
    [V6_vL32b_nt_pred_pi] = generate_V6_vL32b_nt_pred_pi,
    [V6_vL32b_nt_pred_ai] = generate_V6_vL32b_nt_pred_ai,
    [V6_vL32b_nt_pred_ppu] = generate_V6_vL32b_nt_pred_ppu,
    [V6_vL32b_nt_npred_pi] = generate_V6_vL32b_nt_npred_pi,
    [V6_vL32b_nt_npred_ai] = generate_V6_vL32b_nt_npred_ai,
    [V6_vL32b_nt_npred_ppu] = generate_V6_vL32b_nt_npred_ppu,
    [V6_vL32b_nt_cur_pred_pi] = generate_V6_vL32b_nt_cur_pred_pi,
    [V6_vL32b_nt_cur_pred_ai] = generate_V6_vL32b_nt_cur_pred_ai,
    [V6_vL32b_nt_cur_pred_ppu] = generate_V6_vL32b_nt_cur_pred_ppu,
    [V6_vL32b_nt_cur_npred_pi] = generate_V6_vL32b_nt_cur_npred_pi,
    [V6_vL32b_nt_cur_npred_ai] = generate_V6_vL32b_nt_cur_npred_ai,
    [V6_vL32b_nt_cur_npred_ppu] = generate_V6_vL32b_nt_cur_npred_ppu,
    [V6_vL32b_nt_tmp_pred_pi] = generate_V6_vL32b_nt_tmp_pred_pi,
    [V6_vL32b_nt_tmp_pred_ai] = generate_V6_vL32b_nt_tmp_pred_ai,
    [V6_vL32b_nt_tmp_pred_ppu] = generate_V6_vL32b_nt_tmp_pred_ppu,
    [V6_vL32b_nt_tmp_npred_pi] = generate_V6_vL32b_nt_tmp_npred_pi,
    [V6_vL32b_nt_tmp_npred_ai] = generate_V6_vL32b_nt_tmp_npred_ai,
    [V6_vL32b_nt_tmp_npred_ppu] = generate_V6_vL32b_nt_tmp_npred_ppu,
    [V6_valignb] = generate_V6_valignb,
    [V6_vlalignb] = generate_V6_vlalignb,
    [V6_valignbi] = generate_V6_valignbi,
    [V6_vlalignbi] = generate_V6_vlalignbi,
    [V6_vror] = generate_V6_vror,
    [V6_vunpackub] = generate_V6_vunpackub,
    [V6_vunpackb] = generate_V6_vunpackb,
    [V6_vunpackuh] = generate_V6_vunpackuh,
    [V6_vunpackh] = generate_V6_vunpackh,
    [V6_vunpackob] = generate_V6_vunpackob,
    [V6_vunpackoh] = generate_V6_vunpackoh,
    [V6_vpackeb] = generate_V6_vpackeb,
    [V6_vpackeh] = generate_V6_vpackeh,
    [V6_vpackob] = generate_V6_vpackob,
    [V6_vpackoh] = generate_V6_vpackoh,
    [V6_vpackhub_sat] = generate_V6_vpackhub_sat,
    [V6_vpackhb_sat] = generate_V6_vpackhb_sat,
    [V6_vpackwuh_sat] = generate_V6_vpackwuh_sat,
    [V6_vpackwh_sat] = generate_V6_vpackwh_sat,
    [V6_vzb] = generate_V6_vzb,
    [V6_vsb] = generate_V6_vsb,
    [V6_vzh] = generate_V6_vzh,
    [V6_vsh] = generate_V6_vsh,
    [V6_vdmpybus] = generate_V6_vdmpybus,
    [V6_vdmpybus_acc] = generate_V6_vdmpybus_acc,
    [V6_vdmpybus_dv] = generate_V6_vdmpybus_dv,
    [V6_vdmpybus_dv_acc] = generate_V6_vdmpybus_dv_acc,
    [V6_vdmpyhb] = generate_V6_vdmpyhb,
    [V6_vdmpyhb_acc] = generate_V6_vdmpyhb_acc,
    [V6_vdmpyhb_dv] = generate_V6_vdmpyhb_dv,
    [V6_vdmpyhb_dv_acc] = generate_V6_vdmpyhb_dv_acc,
    [V6_vdmpyhvsat] = generate_V6_vdmpyhvsat,
    [V6_vdmpyhvsat_acc] = generate_V6_vdmpyhvsat_acc,
    [V6_vdmpyhsat] = generate_V6_vdmpyhsat,
    [V6_vdmpyhsat_acc] = generate_V6_vdmpyhsat_acc,
    [V6_vdmpyhisat] = generate_V6_vdmpyhisat,
    [V6_vdmpyhisat_acc] = generate_V6_vdmpyhisat_acc,
    [V6_vdmpyhsusat] = generate_V6_vdmpyhsusat,
    [V6_vdmpyhsusat_acc] = generate_V6_vdmpyhsusat_acc,
    [V6_vdmpyhsuisat] = generate_V6_vdmpyhsuisat,
    [V6_vdmpyhsuisat_acc] = generate_V6_vdmpyhsuisat_acc,
    [V6_vtmpyb] = generate_V6_vtmpyb,
    [V6_vtmpyb_acc] = generate_V6_vtmpyb_acc,
    [V6_vtmpybus] = generate_V6_vtmpybus,
    [V6_vtmpybus_acc] = generate_V6_vtmpybus_acc,
    [V6_vtmpyhb] = generate_V6_vtmpyhb,
    [V6_vtmpyhb_acc] = generate_V6_vtmpyhb_acc,
    [V6_vrmpyub] = generate_V6_vrmpyub,
    [V6_vrmpyub_acc] = generate_V6_vrmpyub_acc,
    [V6_vrmpyubv] = generate_V6_vrmpyubv,
    [V6_vrmpyubv_acc] = generate_V6_vrmpyubv_acc,
    [V6_vrmpybv] = generate_V6_vrmpybv,
    [V6_vrmpybv_acc] = generate_V6_vrmpybv_acc,
    [V6_vrmpyubi] = generate_V6_vrmpyubi,
    [V6_vrmpyubi_acc] = generate_V6_vrmpyubi_acc,
    [V6_vrmpybus] = generate_V6_vrmpybus,
    [V6_vrmpybus_acc] = generate_V6_vrmpybus_acc,
    [V6_vrmpybusi] = generate_V6_vrmpybusi,
    [V6_vrmpybusi_acc] = generate_V6_vrmpybusi_acc,
    [V6_vrmpybusv] = generate_V6_vrmpybusv,
    [V6_vrmpybusv_acc] = generate_V6_vrmpybusv_acc,
    [V6_vdsaduh] = generate_V6_vdsaduh,
    [V6_vdsaduh_acc] = generate_V6_vdsaduh_acc,
    [V6_vrsadubi] = generate_V6_vrsadubi,
    [V6_vrsadubi_acc] = generate_V6_vrsadubi_acc,
    [V6_vasrw] = generate_V6_vasrw,
    [V6_vaslw] = generate_V6_vaslw,
    [V6_vlsrw] = generate_V6_vlsrw,
    [V6_vasrwv] = generate_V6_vasrwv,
    [V6_vaslwv] = generate_V6_vaslwv,
    [V6_vlsrwv] = generate_V6_vlsrwv,
    [V6_vasrh] = generate_V6_vasrh,
    [V6_vaslh] = generate_V6_vaslh,
    [V6_vlsrh] = generate_V6_vlsrh,
    [V6_vasrhv] = generate_V6_vasrhv,
    [V6_vaslhv] = generate_V6_vaslhv,
    [V6_vlsrhv] = generate_V6_vlsrhv,
    [V6_vlsrb] = generate_V6_vlsrb,
    [V6_vrotr] = generate_V6_vrotr,
    [V6_vasr_into] = generate_V6_vasr_into,
    [V6_vasrwh] = generate_V6_vasrwh,
    [V6_vasrwhsat] = generate_V6_vasrwhsat,
    [V6_vasrwhrndsat] = generate_V6_vasrwhrndsat,
    [V6_vasrwuhrndsat] = generate_V6_vasrwuhrndsat,
    [V6_vasrwuhsat] = generate_V6_vasrwuhsat,
    [V6_vasruwuhrndsat] = generate_V6_vasruwuhrndsat,
    [V6_vasruwuhsat] = generate_V6_vasruwuhsat,
    [V6_vasrhubsat] = generate_V6_vasrhubsat,
    [V6_vasrhubrndsat] = generate_V6_vasrhubrndsat,
    [V6_vasrhbsat] = generate_V6_vasrhbsat,
    [V6_vasrhbrndsat] = generate_V6_vasrhbrndsat,
    [V6_vasrvwuhsat] = generate_V6_vasrvwuhsat,
    [V6_vasrvwuhrndsat] = generate_V6_vasrvwuhrndsat,
    [V6_vasrvuhubsat] = generate_V6_vasrvuhubsat,
    [V6_vasrvuhubrndsat] = generate_V6_vasrvuhubrndsat,
    [V6_vasruhubsat] = generate_V6_vasruhubsat,
    [V6_vasruhubrndsat] = generate_V6_vasruhubrndsat,
    [V6_vroundwh] = generate_V6_vroundwh,
    [V6_vroundwuh] = generate_V6_vroundwuh,
    [V6_vrounduwuh] = generate_V6_vrounduwuh,
    [V6_vroundhb] = generate_V6_vroundhb,
    [V6_vroundhub] = generate_V6_vroundhub,
    [V6_vrounduhub] = generate_V6_vrounduhub,
    [V6_vaslw_acc] = generate_V6_vaslw_acc,
    [V6_vasrw_acc] = generate_V6_vasrw_acc,
    [V6_vaslh_acc] = generate_V6_vaslh_acc,
    [V6_vasrh_acc] = generate_V6_vasrh_acc,
    [V6_vaddb] = generate_V6_vaddb,
    [V6_vsubb] = generate_V6_vsubb,
    [V6_vaddb_dv] = generate_V6_vaddb_dv,
    [V6_vsubb_dv] = generate_V6_vsubb_dv,
    [V6_vaddh] = generate_V6_vaddh,
    [V6_vsubh] = generate_V6_vsubh,
    [V6_vaddh_dv] = generate_V6_vaddh_dv,
    [V6_vsubh_dv] = generate_V6_vsubh_dv,
    [V6_vaddw] = generate_V6_vaddw,
    [V6_vsubw] = generate_V6_vsubw,
    [V6_vaddw_dv] = generate_V6_vaddw_dv,
    [V6_vsubw_dv] = generate_V6_vsubw_dv,
    [V6_vaddubsat] = generate_V6_vaddubsat,
    [V6_vaddubsat_dv] = generate_V6_vaddubsat_dv,
    [V6_vsububsat] = generate_V6_vsububsat,
    [V6_vsububsat_dv] = generate_V6_vsububsat_dv,
    [V6_vadduhsat] = generate_V6_vadduhsat,
    [V6_vadduhsat_dv] = generate_V6_vadduhsat_dv,
    [V6_vsubuhsat] = generate_V6_vsubuhsat,
    [V6_vsubuhsat_dv] = generate_V6_vsubuhsat_dv,
    [V6_vadduwsat] = generate_V6_vadduwsat,
    [V6_vadduwsat_dv] = generate_V6_vadduwsat_dv,
    [V6_vsubuwsat] = generate_V6_vsubuwsat,
    [V6_vsubuwsat_dv] = generate_V6_vsubuwsat_dv,
    [V6_vaddbsat] = generate_V6_vaddbsat,
    [V6_vaddbsat_dv] = generate_V6_vaddbsat_dv,
    [V6_vsubbsat] = generate_V6_vsubbsat,
    [V6_vsubbsat_dv] = generate_V6_vsubbsat_dv,
    [V6_vaddhsat] = generate_V6_vaddhsat,
    [V6_vaddhsat_dv] = generate_V6_vaddhsat_dv,
    [V6_vsubhsat] = generate_V6_vsubhsat,
    [V6_vsubhsat_dv] = generate_V6_vsubhsat_dv,
    [V6_vaddwsat] = generate_V6_vaddwsat,
    [V6_vaddwsat_dv] = generate_V6_vaddwsat_dv,
    [V6_vsubwsat] = generate_V6_vsubwsat,
    [V6_vsubwsat_dv] = generate_V6_vsubwsat_dv,
    [V6_vavgub] = generate_V6_vavgub,
    [V6_vavgubrnd] = generate_V6_vavgubrnd,
    [V6_vavguh] = generate_V6_vavguh,
    [V6_vavguhrnd] = generate_V6_vavguhrnd,
    [V6_vavguw] = generate_V6_vavguw,
    [V6_vavguwrnd] = generate_V6_vavguwrnd,
    [V6_vavgb] = generate_V6_vavgb,
    [V6_vavgbrnd] = generate_V6_vavgbrnd,
    [V6_vnavgb] = generate_V6_vnavgb,
    [V6_vavgh] = generate_V6_vavgh,
    [V6_vavghrnd] = generate_V6_vavghrnd,
    [V6_vnavgh] = generate_V6_vnavgh,
    [V6_vavgw] = generate_V6_vavgw,
    [V6_vavgwrnd] = generate_V6_vavgwrnd,
    [V6_vnavgw] = generate_V6_vnavgw,
    [V6_vabsdiffub] = generate_V6_vabsdiffub,
    [V6_vabsdiffuh] = generate_V6_vabsdiffuh,
    [V6_vabsdiffh] = generate_V6_vabsdiffh,
    [V6_vabsdiffw] = generate_V6_vabsdiffw,
    [V6_vnavgub] = generate_V6_vnavgub,
    [V6_vaddcarrysat] = generate_V6_vaddcarrysat,
    [V6_vaddcarry] = generate_V6_vaddcarry,
    [V6_vsubcarry] = generate_V6_vsubcarry,
    [V6_vaddcarryo] = generate_V6_vaddcarryo,
    [V6_vsubcarryo] = generate_V6_vsubcarryo,
    [V6_vsatdw] = generate_V6_vsatdw,
    [V6_vaddububb_sat] = generate_V6_vaddububb_sat,
    [V6_vsubububb_sat] = generate_V6_vsubububb_sat,
    [V6_vaddubh] = generate_V6_vaddubh,
    [V6_vsububh] = generate_V6_vsububh,
    [V6_vaddhw] = generate_V6_vaddhw,
    [V6_vsubhw] = generate_V6_vsubhw,
    [V6_vadduhw] = generate_V6_vadduhw,
    [V6_vsubuhw] = generate_V6_vsubuhw,
    [V6_vaddhw_acc] = generate_V6_vaddhw_acc,
    [V6_vadduhw_acc] = generate_V6_vadduhw_acc,
    [V6_vaddubh_acc] = generate_V6_vaddubh_acc,
    [V6_vaddbq] = generate_V6_vaddbq,
    [V6_vsubbq] = generate_V6_vsubbq,
    [V6_vaddbnq] = generate_V6_vaddbnq,
    [V6_vsubbnq] = generate_V6_vsubbnq,
    [V6_vaddhq] = generate_V6_vaddhq,
    [V6_vsubhq] = generate_V6_vsubhq,
    [V6_vaddhnq] = generate_V6_vaddhnq,
    [V6_vsubhnq] = generate_V6_vsubhnq,
    [V6_vaddwq] = generate_V6_vaddwq,
    [V6_vsubwq] = generate_V6_vsubwq,
    [V6_vaddwnq] = generate_V6_vaddwnq,
    [V6_vsubwnq] = generate_V6_vsubwnq,
    [V6_vabsb] = generate_V6_vabsb,
    [V6_vabsb_sat] = generate_V6_vabsb_sat,
    [V6_vabsh] = generate_V6_vabsh,
    [V6_vabsh_sat] = generate_V6_vabsh_sat,
    [V6_vabsw] = generate_V6_vabsw,
    [V6_vabsw_sat] = generate_V6_vabsw_sat,
    [V6_vmpybv] = generate_V6_vmpybv,
    [V6_vmpybv_acc] = generate_V6_vmpybv_acc,
    [V6_vmpyubv] = generate_V6_vmpyubv,
    [V6_vmpyubv_acc] = generate_V6_vmpyubv_acc,
    [V6_vmpybusv] = generate_V6_vmpybusv,
    [V6_vmpybusv_acc] = generate_V6_vmpybusv_acc,
    [V6_vmpabusv] = generate_V6_vmpabusv,
    [V6_vmpabuuv] = generate_V6_vmpabuuv,
    [V6_vmpyhv] = generate_V6_vmpyhv,
    [V6_vmpyhv_acc] = generate_V6_vmpyhv_acc,
    [V6_vmpyuhv] = generate_V6_vmpyuhv,
    [V6_vmpyuhv_acc] = generate_V6_vmpyuhv_acc,
    [V6_vmpyhvsrs] = generate_V6_vmpyhvsrs,
    [V6_vmpyuhvs] = generate_V6_vmpyuhvs,
    [V6_vmpyhus] = generate_V6_vmpyhus,
    [V6_vmpyhus_acc] = generate_V6_vmpyhus_acc,
    [V6_vmpyih] = generate_V6_vmpyih,
    [V6_vmpyih_acc] = generate_V6_vmpyih_acc,
    [V6_vmpyewuh] = generate_V6_vmpyewuh,
    [V6_vmpyowh] = generate_V6_vmpyowh,
    [V6_vmpyowh_rnd] = generate_V6_vmpyowh_rnd,
    [V6_vmpyewuh_64] = generate_V6_vmpyewuh_64,
    [V6_vmpyowh_64_acc] = generate_V6_vmpyowh_64_acc,
    [V6_vmpyowh_sacc] = generate_V6_vmpyowh_sacc,
    [V6_vmpyowh_rnd_sacc] = generate_V6_vmpyowh_rnd_sacc,
    [V6_vmpyieoh] = generate_V6_vmpyieoh,
    [V6_vmpyiewuh] = generate_V6_vmpyiewuh,
    [V6_vmpyiowh] = generate_V6_vmpyiowh,
    [V6_vmpyiewh_acc] = generate_V6_vmpyiewh_acc,
    [V6_vmpyiewuh_acc] = generate_V6_vmpyiewuh_acc,
    [V6_vmpyub] = generate_V6_vmpyub,
    [V6_vmpyub_acc] = generate_V6_vmpyub_acc,
    [V6_vmpybus] = generate_V6_vmpybus,
    [V6_vmpybus_acc] = generate_V6_vmpybus_acc,
    [V6_vmpabus] = generate_V6_vmpabus,
    [V6_vmpabus_acc] = generate_V6_vmpabus_acc,
    [V6_vmpabuu] = generate_V6_vmpabuu,
    [V6_vmpabuu_acc] = generate_V6_vmpabuu_acc,
    [V6_vmpahb] = generate_V6_vmpahb,
    [V6_vmpahb_acc] = generate_V6_vmpahb_acc,
    [V6_vmpauhb] = generate_V6_vmpauhb,
    [V6_vmpauhb_acc] = generate_V6_vmpauhb_acc,
    [V6_vmpyh] = generate_V6_vmpyh,
    [V6_vmpyh_acc] = generate_V6_vmpyh_acc,
    [V6_vmpyhsat_acc] = generate_V6_vmpyhsat_acc,
    [V6_vmpyhss] = generate_V6_vmpyhss,
    [V6_vmpyhsrs] = generate_V6_vmpyhsrs,
    [V6_vmpyuh] = generate_V6_vmpyuh,
    [V6_vmpyuh_acc] = generate_V6_vmpyuh_acc,
    [V6_vmpyihb] = generate_V6_vmpyihb,
    [V6_vmpyihb_acc] = generate_V6_vmpyihb_acc,
    [V6_vmpyiwb] = generate_V6_vmpyiwb,
    [V6_vmpyiwb_acc] = generate_V6_vmpyiwb_acc,
    [V6_vmpyiwub] = generate_V6_vmpyiwub,
    [V6_vmpyiwub_acc] = generate_V6_vmpyiwub_acc,
    [V6_vmpyiwh] = generate_V6_vmpyiwh,
    [V6_vmpyiwh_acc] = generate_V6_vmpyiwh_acc,
    [V6_vand] = generate_V6_vand,
    [V6_vor] = generate_V6_vor,
    [V6_vxor] = generate_V6_vxor,
    [V6_vnot] = generate_V6_vnot,
    [V6_vandqrt] = generate_V6_vandqrt,
    [V6_vandqrt_acc] = generate_V6_vandqrt_acc,
    [V6_vandnqrt] = generate_V6_vandnqrt,
    [V6_vandnqrt_acc] = generate_V6_vandnqrt_acc,
    [V6_vandvrt] = generate_V6_vandvrt,
    [V6_vandvrt_acc] = generate_V6_vandvrt_acc,
    [V6_vandvqv] = generate_V6_vandvqv,
    [V6_vandvnqv] = generate_V6_vandvnqv,
    [V6_vgtw] = generate_V6_vgtw,
    [V6_vgtw_and] = generate_V6_vgtw_and,
    [V6_vgtw_or] = generate_V6_vgtw_or,
    [V6_vgtw_xor] = generate_V6_vgtw_xor,
    [V6_veqw] = generate_V6_veqw,
    [V6_veqw_and] = generate_V6_veqw_and,
    [V6_veqw_or] = generate_V6_veqw_or,
    [V6_veqw_xor] = generate_V6_veqw_xor,
    [V6_vgth] = generate_V6_vgth,
    [V6_vgth_and] = generate_V6_vgth_and,
    [V6_vgth_or] = generate_V6_vgth_or,
    [V6_vgth_xor] = generate_V6_vgth_xor,
    [V6_veqh] = generate_V6_veqh,
    [V6_veqh_and] = generate_V6_veqh_and,
    [V6_veqh_or] = generate_V6_veqh_or,
    [V6_veqh_xor] = generate_V6_veqh_xor,
    [V6_vgtb] = generate_V6_vgtb,
    [V6_vgtb_and] = generate_V6_vgtb_and,
    [V6_vgtb_or] = generate_V6_vgtb_or,
    [V6_vgtb_xor] = generate_V6_vgtb_xor,
    [V6_veqb] = generate_V6_veqb,
    [V6_veqb_and] = generate_V6_veqb_and,
    [V6_veqb_or] = generate_V6_veqb_or,
    [V6_veqb_xor] = generate_V6_veqb_xor,
    [V6_vgtuw] = generate_V6_vgtuw,
    [V6_vgtuw_and] = generate_V6_vgtuw_and,
    [V6_vgtuw_or] = generate_V6_vgtuw_or,
    [V6_vgtuw_xor] = generate_V6_vgtuw_xor,
    [V6_vgtuh] = generate_V6_vgtuh,
    [V6_vgtuh_and] = generate_V6_vgtuh_and,
    [V6_vgtuh_or] = generate_V6_vgtuh_or,
    [V6_vgtuh_xor] = generate_V6_vgtuh_xor,
    [V6_vgtub] = generate_V6_vgtub,
    [V6_vgtub_and] = generate_V6_vgtub_and,
    [V6_vgtub_or] = generate_V6_vgtub_or,
    [V6_vgtub_xor] = generate_V6_vgtub_xor,
    [V6_pred_scalar2] = generate_V6_pred_scalar2,
    [V6_pred_scalar2v2] = generate_V6_pred_scalar2v2,
    [V6_shuffeqw] = generate_V6_shuffeqw,
    [V6_shuffeqh] = generate_V6_shuffeqh,
    [V6_pred_or] = generate_V6_pred_or,
    [V6_pred_and] = generate_V6_pred_and,
    [V6_pred_xor] = generate_V6_pred_xor,
    [V6_pred_or_n] = generate_V6_pred_or_n,
    [V6_pred_and_n] = generate_V6_pred_and_n,
    [V6_pred_not] = generate_V6_pred_not,
    [V6_vcmov] = generate_V6_vcmov,
    [V6_vncmov] = generate_V6_vncmov,
    [V6_vccombine] = generate_V6_vccombine,
    [V6_vnccombine] = generate_V6_vnccombine,
    [V6_vmux] = generate_V6_vmux,
    [V6_vswap] = generate_V6_vswap,
    [V6_vmaxb] = generate_V6_vmaxb,
    [V6_vminb] = generate_V6_vminb,
    [V6_vmaxub] = generate_V6_vmaxub,
    [V6_vminub] = generate_V6_vminub,
    [V6_vmaxuh] = generate_V6_vmaxuh,
    [V6_vminuh] = generate_V6_vminuh,
    [V6_vmaxh] = generate_V6_vmaxh,
    [V6_vminh] = generate_V6_vminh,
    [V6_vmaxw] = generate_V6_vmaxw,
    [V6_vminw] = generate_V6_vminw,
    [V6_vsathub] = generate_V6_vsathub,
    [V6_vsatwh] = generate_V6_vsatwh,
    [V6_vsatuwuh] = generate_V6_vsatuwuh,
    [V6_vshuffeb] = generate_V6_vshuffeb,
    [V6_vshuffob] = generate_V6_vshuffob,
    [V6_vshufeh] = generate_V6_vshufeh,
    [V6_vshufoh] = generate_V6_vshufoh,
    [V6_vshuff] = generate_V6_vshuff,
    [V6_vshuffvdd] = generate_V6_vshuffvdd,
    [V6_vdeal] = generate_V6_vdeal,
    [V6_vdealvdd] = generate_V6_vdealvdd,
    [V6_vshufoeh] = generate_V6_vshufoeh,
    [V6_vshufoeb] = generate_V6_vshufoeb,
    [V6_vdealh] = generate_V6_vdealh,
    [V6_vdealb] = generate_V6_vdealb,
    [V6_vdealb4w] = generate_V6_vdealb4w,
    [V6_vshuffh] = generate_V6_vshuffh,
    [V6_vshuffb] = generate_V6_vshuffb,
    [V6_extractw] = generate_V6_extractw,
    [V6_vinsertwr] = generate_V6_vinsertwr,
    [V6_lvsplatw] = generate_V6_lvsplatw,
    [V6_lvsplath] = generate_V6_lvsplath,
    [V6_lvsplatb] = generate_V6_lvsplatb,
    [V6_vassign] = generate_V6_vassign,
    [V6_vcombine] = generate_V6_vcombine,
    [V6_vcombine_tmp] = generate_V6_vcombine_tmp,
    [V6_vassign_tmp] = generate_V6_vassign_tmp,
    [V6_vdelta] = generate_V6_vdelta,
    [V6_vrdelta] = generate_V6_vrdelta,
    [V6_vcl0w] = generate_V6_vcl0w,
    [V6_vcl0h] = generate_V6_vcl0h,
    [V6_vnormamtw] = generate_V6_vnormamtw,
    [V6_vnormamth] = generate_V6_vnormamth,
    [V6_vaddclbw] = generate_V6_vaddclbw,
    [V6_vaddclbh] = generate_V6_vaddclbh,
    [V6_vpopcounth] = generate_V6_vpopcounth,
    [V6_vhist] = generate_V6_vhist,
    [V6_vhistq] = generate_V6_vhistq,
    [V6_vwhist256] = generate_V6_vwhist256,
    [V6_vwhist256q] = generate_V6_vwhist256q,
    [V6_vwhist256_sat] = generate_V6_vwhist256_sat,
    [V6_vwhist256q_sat] = generate_V6_vwhist256q_sat,
    [V6_vwhist128] = generate_V6_vwhist128,
    [V6_vwhist128q] = generate_V6_vwhist128q,
    [V6_vwhist128m] = generate_V6_vwhist128m,
    [V6_vwhist128qm] = generate_V6_vwhist128qm,
    [V6_vlutvvb] = generate_V6_vlutvvb,
    [V6_vlutvvb_oracc] = generate_V6_vlutvvb_oracc,
    [V6_vlutvwh] = generate_V6_vlutvwh,
    [V6_vlutvwh_oracc] = generate_V6_vlutvwh_oracc,
    [V6_vlutvvbi] = generate_V6_vlutvvbi,
    [V6_vlutvvb_oracci] = generate_V6_vlutvvb_oracci,
    [V6_vlutvwhi] = generate_V6_vlutvwhi,
    [V6_vlutvwh_oracci] = generate_V6_vlutvwh_oracci,
    [V6_vlutvvb_nm] = generate_V6_vlutvvb_nm,
    [V6_vlutvwh_nm] = generate_V6_vlutvwh_nm,
    [V6_vmpahhsat] = generate_V6_vmpahhsat,
    [V6_vmpauhuhsat] = generate_V6_vmpauhuhsat,
    [V6_vmpsuhuhsat] = generate_V6_vmpsuhuhsat,
    [V6_vlut4] = generate_V6_vlut4,
    [V6_vmpyuhe] = generate_V6_vmpyuhe,
    [V6_vmpyuhe_acc] = generate_V6_vmpyuhe_acc,
    [V6_vgathermw] = generate_V6_vgathermw,
    [V6_vgathermh] = generate_V6_vgathermh,
    [V6_vgathermhw] = generate_V6_vgathermhw,
    [V6_vgathermwq] = generate_V6_vgathermwq,
    [V6_vgathermhq] = generate_V6_vgathermhq,
    [V6_vgathermhwq] = generate_V6_vgathermhwq,
    [V6_vscattermw] = generate_V6_vscattermw,
    [V6_vscattermh] = generate_V6_vscattermh,
    [V6_vscattermw_add] = generate_V6_vscattermw_add,
    [V6_vscattermh_add] = generate_V6_vscattermh_add,
    [V6_vscattermwq] = generate_V6_vscattermwq,
    [V6_vscattermhq] = generate_V6_vscattermhq,
    [V6_vscattermhw] = generate_V6_vscattermhw,
    [V6_v6mpyvubs10_vxx] = generate_V6_v6mpyvubs10_vxx,
    [V6_v6mpyhubs10_vxx] = generate_V6_v6mpyhubs10_vxx,
    [V6_v6mpyvubs10] = generate_V6_v6mpyvubs10,
    [V6_v6mpyhubs10] = generate_V6_v6mpyhubs10,
    [V6_vscattermhwq] = generate_V6_vscattermhwq,
    [V6_vscattermhw_add] = generate_V6_vscattermhw_add,
    [V6_vprefixqb] = generate_V6_vprefixqb,
    [V6_vprefixqh] = generate_V6_vprefixqh,
    [V6_vprefixqw] = generate_V6_vprefixqw,
};

#endif    /* HEXAGON_FUNC_TABLE_H */
