// components/autofill/content/common/mojom/autofill_driver.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_AUTOFILL_CONTENT_COMMON_MOJOM_AUTOFILL_DRIVER_MOJOM_H_
#define COMPONENTS_AUTOFILL_CONTENT_COMMON_MOJOM_AUTOFILL_DRIVER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/autofill/content/common/mojom/autofill_driver.mojom-features.h"  // IWYU pragma: export
#include "components/autofill/content/common/mojom/autofill_driver.mojom-shared.h"  // IWYU pragma: export
#include "components/autofill/content/common/mojom/autofill_driver.mojom-forward.h"  // IWYU pragma: export
#include "components/autofill/core/common/mojom/autofill_types.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/text_direction.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace autofill::mojom {

class AutofillDriverProxy;

template <typename ImplRefTraits>
class AutofillDriverStub;

class AutofillDriverRequestValidator;


class AutofillDriver
    : public AutofillDriverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AutofillDriverInterfaceBase;
  using Proxy_ = AutofillDriverProxy;

  template <typename ImplRefTraits>
  using Stub_ = AutofillDriverStub<ImplRefTraits>;

  using RequestValidator_ = AutofillDriverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kFormsSeenMinVersion = 0,
    kFormSubmittedMinVersion = 0,
    kCaretMovedInFormFieldMinVersion = 0,
    kTextFieldValueChangedMinVersion = 0,
    kDidEndTextFieldEditingMinVersion = 0,
    kTextFieldDidScrollMinVersion = 0,
    kSelectControlSelectionChangedMinVersion = 0,
    kSelectFieldOptionsDidChangeMinVersion = 0,
    kFocusOnFormFieldMinVersion = 0,
    kFocusOnNonFormFieldMinVersion = 0,
    kAskForValuesToFillMinVersion = 0,
    kHidePopupMinVersion = 0,
    kDidFillAutofillFormDataMinVersion = 0,
    kJavaScriptChangedAutofilledValueMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct FormsSeen_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FormSubmitted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CaretMovedInFormField_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TextFieldValueChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidEndTextFieldEditing_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TextFieldDidScroll_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SelectControlSelectionChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SelectFieldOptionsDidChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FocusOnFormField_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FocusOnNonFormField_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AskForValuesToFill_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HidePopup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidFillAutofillFormData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct JavaScriptChangedAutofilledValue_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AutofillDriver() = default;

  
  virtual void FormsSeen(const std::vector<::autofill::FormData>& updated_forms, const std::vector<::autofill::FormRendererId>& removed_forms) = 0;

  
  virtual void FormSubmitted(const ::autofill::FormData& form, ::autofill::mojom::SubmissionSource source) = 0;

  
  virtual void CaretMovedInFormField(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id, const ::gfx::Rect& caret_bounds) = 0;

  
  virtual void TextFieldValueChanged(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id, ::base::TimeTicks timestamp) = 0;

  
  virtual void DidEndTextFieldEditing() = 0;

  
  virtual void TextFieldDidScroll(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id) = 0;

  
  virtual void SelectControlSelectionChanged(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id) = 0;

  
  virtual void SelectFieldOptionsDidChange(const ::autofill::FormData& form) = 0;

  
  virtual void FocusOnFormField(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id) = 0;

  
  virtual void FocusOnNonFormField() = 0;

  
  virtual void AskForValuesToFill(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id, const ::gfx::Rect& caret_bounds, ::autofill::mojom::AutofillSuggestionTriggerSource trigger_source) = 0;

  
  virtual void HidePopup() = 0;

  
  virtual void DidFillAutofillFormData(const ::autofill::FormData& form, ::base::TimeTicks timestamp) = 0;

  
  virtual void JavaScriptChangedAutofilledValue(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id, const ::std::u16string& old_value, bool formatting_only) = 0;
};

class PasswordManagerDriverProxy;

template <typename ImplRefTraits>
class PasswordManagerDriverStub;

class PasswordManagerDriverRequestValidator;


class PasswordManagerDriver
    : public PasswordManagerDriverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PasswordManagerDriverInterfaceBase;
  using Proxy_ = PasswordManagerDriverProxy;

  template <typename ImplRefTraits>
  using Stub_ = PasswordManagerDriverStub<ImplRefTraits>;

  using RequestValidator_ = PasswordManagerDriverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kPasswordFormsParsedMinVersion = 0,
    kPasswordFormsRenderedMinVersion = 0,
    kPasswordFormSubmittedMinVersion = 0,
    kInformAboutUserInputMinVersion = 0,
    kDynamicFormSubmissionMinVersion = 0,
    kPasswordFormClearedMinVersion = 0,
    kRecordSavePasswordProgressMinVersion = 0,
    kUserModifiedPasswordFieldMinVersion = 0,
    kUserModifiedNonPasswordFieldMinVersion = 0,
    kShowPasswordSuggestionsMinVersion = 0,
    kCheckSafeBrowsingReputationMinVersion = 0,
    kFocusedInputChangedMinVersion = 0,
    kLogFirstFillingResultMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct PasswordFormsParsed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PasswordFormsRendered_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PasswordFormSubmitted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InformAboutUserInput_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DynamicFormSubmission_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PasswordFormCleared_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordSavePasswordProgress_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UserModifiedPasswordField_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UserModifiedNonPasswordField_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowPasswordSuggestions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CheckSafeBrowsingReputation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FocusedInputChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LogFirstFillingResult_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PasswordManagerDriver() = default;

  
  virtual void PasswordFormsParsed(const std::vector<::autofill::FormData>& forms_data) = 0;

  
  virtual void PasswordFormsRendered(const std::vector<::autofill::FormData>& visible_forms_data) = 0;

  
  virtual void PasswordFormSubmitted(const ::autofill::FormData& form_data) = 0;

  
  virtual void InformAboutUserInput(const ::autofill::FormData& form_data) = 0;

  
  virtual void DynamicFormSubmission(::autofill::mojom::SubmissionIndicatorEvent submission_indication_event) = 0;

  
  virtual void PasswordFormCleared(const ::autofill::FormData& form_data) = 0;

  
  virtual void RecordSavePasswordProgress(const std::string& log) = 0;

  
  virtual void UserModifiedPasswordField() = 0;

  
  virtual void UserModifiedNonPasswordField(::autofill::FieldRendererId renderer_id, const ::std::u16string& value, bool autocomplete_attribute_has_username, bool is_likely_otp) = 0;

  
  virtual void ShowPasswordSuggestions(const ::autofill::PasswordSuggestionRequest& request) = 0;

  
  virtual void CheckSafeBrowsingReputation(const ::GURL& form_action, const ::GURL& frame_url) = 0;

  
  virtual void FocusedInputChanged(::autofill::FieldRendererId focused_field_id, ::autofill::mojom::FocusedFieldType focused_field_type) = 0;

  
  virtual void LogFirstFillingResult(::autofill::FormRendererId form_renderer_id, int32_t result) = 0;
};

class PasswordGenerationDriverProxy;

template <typename ImplRefTraits>
class PasswordGenerationDriverStub;

class PasswordGenerationDriverRequestValidator;


class PasswordGenerationDriver
    : public PasswordGenerationDriverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PasswordGenerationDriverInterfaceBase;
  using Proxy_ = PasswordGenerationDriverProxy;

  template <typename ImplRefTraits>
  using Stub_ = PasswordGenerationDriverStub<ImplRefTraits>;

  using RequestValidator_ = PasswordGenerationDriverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAutomaticGenerationAvailableMinVersion = 0,
    kShowPasswordEditingPopupMinVersion = 0,
    kPasswordGenerationRejectedByTypingMinVersion = 0,
    kPresaveGeneratedPasswordMinVersion = 0,
    kPasswordNoLongerGeneratedMinVersion = 0,
    kFrameWasScrolledMinVersion = 0,
    kGenerationElementLostFocusMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AutomaticGenerationAvailable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowPasswordEditingPopup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PasswordGenerationRejectedByTyping_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PresaveGeneratedPassword_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PasswordNoLongerGenerated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FrameWasScrolled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GenerationElementLostFocus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PasswordGenerationDriver() = default;

  
  virtual void AutomaticGenerationAvailable(const ::autofill::password_generation::PasswordGenerationUIData& password_generation_ui_data) = 0;

  
  virtual void ShowPasswordEditingPopup(const ::gfx::RectF& bounds, const ::autofill::FormData& form_data, ::autofill::FieldRendererId field_renderer_id, const ::std::u16string& password_value) = 0;

  
  virtual void PasswordGenerationRejectedByTyping() = 0;

  
  virtual void PresaveGeneratedPassword(const ::autofill::FormData& form_data, const ::std::u16string& password_value) = 0;

  
  virtual void PasswordNoLongerGenerated(const ::autofill::FormData& form_data) = 0;

  
  virtual void FrameWasScrolled() = 0;

  
  virtual void GenerationElementLostFocus() = 0;
};



class  AutofillDriverProxy
    : public AutofillDriver {
 public:
  using InterfaceType = AutofillDriver;

  explicit AutofillDriverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void FormsSeen(const std::vector<::autofill::FormData>& updated_forms, const std::vector<::autofill::FormRendererId>& removed_forms) final;
  
  void FormSubmitted(const ::autofill::FormData& form, ::autofill::mojom::SubmissionSource source) final;
  
  void CaretMovedInFormField(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id, const ::gfx::Rect& caret_bounds) final;
  
  void TextFieldValueChanged(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id, ::base::TimeTicks timestamp) final;
  
  void DidEndTextFieldEditing() final;
  
  void TextFieldDidScroll(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id) final;
  
  void SelectControlSelectionChanged(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id) final;
  
  void SelectFieldOptionsDidChange(const ::autofill::FormData& form) final;
  
  void FocusOnFormField(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id) final;
  
  void FocusOnNonFormField() final;
  
  void AskForValuesToFill(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id, const ::gfx::Rect& caret_bounds, ::autofill::mojom::AutofillSuggestionTriggerSource trigger_source) final;
  
  void HidePopup() final;
  
  void DidFillAutofillFormData(const ::autofill::FormData& form, ::base::TimeTicks timestamp) final;
  
  void JavaScriptChangedAutofilledValue(const ::autofill::FormData& form, ::autofill::FieldRendererId field_id, const ::std::u16string& old_value, bool formatting_only) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PasswordManagerDriverProxy
    : public PasswordManagerDriver {
 public:
  using InterfaceType = PasswordManagerDriver;

  explicit PasswordManagerDriverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void PasswordFormsParsed(const std::vector<::autofill::FormData>& forms_data) final;
  
  void PasswordFormsRendered(const std::vector<::autofill::FormData>& visible_forms_data) final;
  
  void PasswordFormSubmitted(const ::autofill::FormData& form_data) final;
  
  void InformAboutUserInput(const ::autofill::FormData& form_data) final;
  
  void DynamicFormSubmission(::autofill::mojom::SubmissionIndicatorEvent submission_indication_event) final;
  
  void PasswordFormCleared(const ::autofill::FormData& form_data) final;
  
  void RecordSavePasswordProgress(const std::string& log) final;
  
  void UserModifiedPasswordField() final;
  
  void UserModifiedNonPasswordField(::autofill::FieldRendererId renderer_id, const ::std::u16string& value, bool autocomplete_attribute_has_username, bool is_likely_otp) final;
  
  void ShowPasswordSuggestions(const ::autofill::PasswordSuggestionRequest& request) final;
  
  void CheckSafeBrowsingReputation(const ::GURL& form_action, const ::GURL& frame_url) final;
  
  void FocusedInputChanged(::autofill::FieldRendererId focused_field_id, ::autofill::mojom::FocusedFieldType focused_field_type) final;
  
  void LogFirstFillingResult(::autofill::FormRendererId form_renderer_id, int32_t result) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PasswordGenerationDriverProxy
    : public PasswordGenerationDriver {
 public:
  using InterfaceType = PasswordGenerationDriver;

  explicit PasswordGenerationDriverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AutomaticGenerationAvailable(const ::autofill::password_generation::PasswordGenerationUIData& password_generation_ui_data) final;
  
  void ShowPasswordEditingPopup(const ::gfx::RectF& bounds, const ::autofill::FormData& form_data, ::autofill::FieldRendererId field_renderer_id, const ::std::u16string& password_value) final;
  
  void PasswordGenerationRejectedByTyping() final;
  
  void PresaveGeneratedPassword(const ::autofill::FormData& form_data, const ::std::u16string& password_value) final;
  
  void PasswordNoLongerGenerated(const ::autofill::FormData& form_data) final;
  
  void FrameWasScrolled() final;
  
  void GenerationElementLostFocus() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  AutofillDriverStubDispatch {
 public:
  static bool Accept(AutofillDriver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AutofillDriver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AutofillDriver>>
class AutofillDriverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AutofillDriverStub() = default;
  ~AutofillDriverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AutofillDriverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AutofillDriverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PasswordManagerDriverStubDispatch {
 public:
  static bool Accept(PasswordManagerDriver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PasswordManagerDriver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PasswordManagerDriver>>
class PasswordManagerDriverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PasswordManagerDriverStub() = default;
  ~PasswordManagerDriverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PasswordManagerDriverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PasswordManagerDriverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PasswordGenerationDriverStubDispatch {
 public:
  static bool Accept(PasswordGenerationDriver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PasswordGenerationDriver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PasswordGenerationDriver>>
class PasswordGenerationDriverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PasswordGenerationDriverStub() = default;
  ~PasswordGenerationDriverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PasswordGenerationDriverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PasswordGenerationDriverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AutofillDriverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PasswordManagerDriverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PasswordGenerationDriverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // autofill::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_AUTOFILL_CONTENT_COMMON_MOJOM_AUTOFILL_DRIVER_MOJOM_H_