// gpu/ipc/common/gpu_channel.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_GPU_CHANNEL_MOJOM_SHARED_H_
#define GPU_IPC_COMMON_GPU_CHANNEL_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/gpu_channel.mojom-shared-internal.h"
#include "gpu/ipc/common/capabilities.mojom-shared.h"
#include "gpu/ipc/common/context_result.mojom-shared.h"
#include "gpu/ipc/common/mailbox.mojom-shared.h"
#include "gpu/ipc/common/shared_image_metadata.mojom-shared.h"
#include "gpu/ipc/common/shared_image_pool_id.mojom-shared.h"
#include "gpu/ipc/common/shared_image_pool_client_interface.mojom-shared.h"
#include "gpu/ipc/common/surface_handle.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "gpu/ipc/common/vulkan_ycbcr_info.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/viz/public/mojom/compositing/shared_image_format.mojom-shared.h"
#include "skia/public/mojom/image_info.mojom-shared.h"
#include "skia/public/mojom/surface_origin.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"
#include "ui/gfx/mojom/gpu_fence_handle.mojom-shared.h"
#include "ui/gfx/mojom/native_handle_types.mojom-shared.h"
#include "ui/gfx/mojom/presentation_feedback.mojom-shared.h"
#include "ui/gl/mojom/gpu_preference.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "base/component_export.h"




namespace gpu::mojom {
class ContextCreationAttribsDataView;

class CreateCommandBufferParamsDataView;

class CommandBufferStateDataView;

class ScheduleImageDecodeParamsDataView;

using SwapBuffersCompleteParamsDataView = mojo::native::NativeStructDataView;

class DeferredRequestDataView;

class DeferredCommandBufferRequestDataView;

class AsyncFlushParamsDataView;

class SetDefaultFramebufferSharedImageParamsDataView;

class SharedImageInfoDataView;

class CreateSharedImageParamsDataView;

class CreateSharedImageWithDataParamsDataView;

class CreateSharedImageWithBufferParamsDataView;

class UpdateSharedImageParamsDataView;

class AddReferenceToSharedImageParamsDataView;

class CopyToGpuMemoryBufferParamsDataView;

class CreateSharedImagePoolParamsDataView;

class DestroySharedImagePoolParamsDataView;

class DeferredRequestParamsDataView;
class DeferredCommandBufferRequestParamsDataView;
class DeferredSharedImageRequestDataView;


}  // gpu::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gpu::mojom::ContextCreationAttribsDataView> {
  using Data = ::gpu::mojom::internal::ContextCreationAttribs_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::CreateCommandBufferParamsDataView> {
  using Data = ::gpu::mojom::internal::CreateCommandBufferParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::CommandBufferStateDataView> {
  using Data = ::gpu::mojom::internal::CommandBufferState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::ScheduleImageDecodeParamsDataView> {
  using Data = ::gpu::mojom::internal::ScheduleImageDecodeParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::DeferredRequestDataView> {
  using Data = ::gpu::mojom::internal::DeferredRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::DeferredCommandBufferRequestDataView> {
  using Data = ::gpu::mojom::internal::DeferredCommandBufferRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::AsyncFlushParamsDataView> {
  using Data = ::gpu::mojom::internal::AsyncFlushParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::SetDefaultFramebufferSharedImageParamsDataView> {
  using Data = ::gpu::mojom::internal::SetDefaultFramebufferSharedImageParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::SharedImageInfoDataView> {
  using Data = ::gpu::mojom::internal::SharedImageInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::CreateSharedImageParamsDataView> {
  using Data = ::gpu::mojom::internal::CreateSharedImageParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::CreateSharedImageWithDataParamsDataView> {
  using Data = ::gpu::mojom::internal::CreateSharedImageWithDataParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::CreateSharedImageWithBufferParamsDataView> {
  using Data = ::gpu::mojom::internal::CreateSharedImageWithBufferParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::UpdateSharedImageParamsDataView> {
  using Data = ::gpu::mojom::internal::UpdateSharedImageParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::AddReferenceToSharedImageParamsDataView> {
  using Data = ::gpu::mojom::internal::AddReferenceToSharedImageParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::CopyToGpuMemoryBufferParamsDataView> {
  using Data = ::gpu::mojom::internal::CopyToGpuMemoryBufferParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::CreateSharedImagePoolParamsDataView> {
  using Data = ::gpu::mojom::internal::CreateSharedImagePoolParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::DestroySharedImagePoolParamsDataView> {
  using Data = ::gpu::mojom::internal::DestroySharedImagePoolParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::DeferredRequestParamsDataView> {
  using Data = ::gpu::mojom::internal::DeferredRequestParams_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::gpu::mojom::DeferredCommandBufferRequestParamsDataView> {
  using Data = ::gpu::mojom::internal::DeferredCommandBufferRequestParams_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::gpu::mojom::DeferredSharedImageRequestDataView> {
  using Data = ::gpu::mojom::internal::DeferredSharedImageRequest_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace gpu::mojom {


enum class ContextType : int32_t {
  
  kWebGL1 = 0,
  
  kWebGL2 = 1,
  
  kOpenGLES2 = 2,
  
  kOpenGLES3 = 3,
  
  kOpenGLES31ForTesting = 4,
  
  kWebGPU = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) std::ostream& operator<<(std::ostream& os, ContextType value);
inline bool IsKnownEnumValue(ContextType value) {
  return internal::ContextType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ContextColorSpace : int32_t {
  
  kUnspecified = 0,
  
  kSRGB = 1,
  
  kDisplayP3 = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) std::ostream& operator<<(std::ostream& os, ContextColorSpace value);
inline bool IsKnownEnumValue(ContextColorSpace value) {
  return internal::ContextColorSpace_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SchedulingPriority : int32_t {
  
  kHigh = 0,
  
  kNormal = 1,
  
  kLow = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) std::ostream& operator<<(std::ostream& os, SchedulingPriority value);
inline bool IsKnownEnumValue(SchedulingPriority value) {
  return internal::SchedulingPriority_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
using Error = mojo::NativeEnum;
using ContextLostReason = mojo::NativeEnum;
// Interface base classes. They are used for type safety check.
class GpuChannelInterfaceBase {};

using GpuChannelPtrDataView =
    mojo::InterfacePtrDataView<GpuChannelInterfaceBase>;
using GpuChannelRequestDataView =
    mojo::InterfaceRequestDataView<GpuChannelInterfaceBase>;
using GpuChannelAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<GpuChannelInterfaceBase>;
using GpuChannelAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<GpuChannelInterfaceBase>;
class CommandBufferInterfaceBase {};

using CommandBufferPtrDataView =
    mojo::InterfacePtrDataView<CommandBufferInterfaceBase>;
using CommandBufferRequestDataView =
    mojo::InterfaceRequestDataView<CommandBufferInterfaceBase>;
using CommandBufferAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CommandBufferInterfaceBase>;
using CommandBufferAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CommandBufferInterfaceBase>;
class CommandBufferClientInterfaceBase {};

using CommandBufferClientPtrDataView =
    mojo::InterfacePtrDataView<CommandBufferClientInterfaceBase>;
using CommandBufferClientRequestDataView =
    mojo::InterfaceRequestDataView<CommandBufferClientInterfaceBase>;
using CommandBufferClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CommandBufferClientInterfaceBase>;
using CommandBufferClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CommandBufferClientInterfaceBase>;


class ContextCreationAttribsDataView {
 public:
  ContextCreationAttribsDataView() = default;

  ContextCreationAttribsDataView(
      internal::ContextCreationAttribs_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadGpuPreference(UserType* output) const {
    auto data_value = data_->gpu_preference;
    return mojo::internal::Deserialize<::gl::mojom::GpuPreference>(
        data_value, output);
  }
  ::gl::mojom::GpuPreference gpu_preference() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gl::mojom::GpuPreference>(data_->gpu_preference));
  }
  bool bind_generates_resource() const {
    return data_->bind_generates_resource;
  }
  bool fail_if_major_perf_caveat() const {
    return data_->fail_if_major_perf_caveat;
  }
  bool lose_context_when_out_of_memory() const {
    return data_->lose_context_when_out_of_memory;
  }
  bool enable_gles2_interface() const {
    return data_->enable_gles2_interface;
  }
  bool enable_grcontext() const {
    return data_->enable_grcontext;
  }
  bool enable_raster_interface() const {
    return data_->enable_raster_interface;
  }
  bool enable_oop_rasterization() const {
    return data_->enable_oop_rasterization;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadContextType(UserType* output) const {
    auto data_value = data_->context_type;
    return mojo::internal::Deserialize<::gpu::mojom::ContextType>(
        data_value, output);
  }
  ContextType context_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::ContextType>(data_->context_type));
  }
 private:
  internal::ContextCreationAttribs_Data* data_ = nullptr;
};


class CreateCommandBufferParamsDataView {
 public:
  CreateCommandBufferParamsDataView() = default;

  CreateCommandBufferParamsDataView(
      internal::CreateCommandBufferParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t share_group_id() const {
    return data_->share_group_id;
  }
  int32_t stream_id() const {
    return data_->stream_id;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStreamPriority(UserType* output) const {
    auto data_value = data_->stream_priority;
    return mojo::internal::Deserialize<::gpu::mojom::SchedulingPriority>(
        data_value, output);
  }
  SchedulingPriority stream_priority() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::SchedulingPriority>(data_->stream_priority));
  }
  inline void GetAttribsDataView(
      ContextCreationAttribsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAttribs(UserType* output) {
    
    auto* pointer = data_->attribs.Get();
    return mojo::internal::Deserialize<::gpu::mojom::ContextCreationAttribsDataView>(
        pointer, output, message_);
  }
  inline void GetActiveUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadActiveUrl(UserType* output) {
    
    auto* pointer = data_->active_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::CreateCommandBufferParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CommandBufferStateDataView {
 public:
  CommandBufferStateDataView() = default;

  CommandBufferStateDataView(
      internal::CommandBufferState_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t get_offset() const {
    return data_->get_offset;
  }
  int32_t token() const {
    return data_->token;
  }
  uint64_t release_count() const {
    return data_->release_count;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::gpu::mojom::Error>(
        data_value, output);
  }
  Error error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::Error>(data_->error));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadContextLostReason(UserType* output) const {
    auto data_value = data_->context_lost_reason;
    return mojo::internal::Deserialize<::gpu::mojom::ContextLostReason>(
        data_value, output);
  }
  ContextLostReason context_lost_reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::ContextLostReason>(data_->context_lost_reason));
  }
  uint32_t generation() const {
    return data_->generation;
  }
  uint32_t set_get_buffer_count() const {
    return data_->set_get_buffer_count;
  }
 private:
  internal::CommandBufferState_Data* data_ = nullptr;
};


class ScheduleImageDecodeParamsDataView {
 public:
  ScheduleImageDecodeParamsDataView() = default;

  ScheduleImageDecodeParamsDataView(
      internal::ScheduleImageDecodeParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEncodedDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEncodedData(UserType* output) {
    
    auto* pointer = data_->encoded_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetOutputSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputSize(UserType* output) {
    
    auto* pointer = data_->output_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  int32_t raster_decoder_route_id() const {
    return data_->raster_decoder_route_id;
  }
  uint32_t transfer_cache_entry_id() const {
    return data_->transfer_cache_entry_id;
  }
  int32_t discardable_handle_shm_id() const {
    return data_->discardable_handle_shm_id;
  }
  uint32_t discardable_handle_shm_offset() const {
    return data_->discardable_handle_shm_offset;
  }
  uint64_t discardable_handle_release_count() const {
    return data_->discardable_handle_release_count;
  }
  inline void GetTargetColorSpaceDataView(
      ::gfx::mojom::ColorSpaceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTargetColorSpace(UserType* output) {
    
    auto* pointer = data_->target_color_space.Get();
    return mojo::internal::Deserialize<::gfx::mojom::ColorSpaceDataView>(
        pointer, output, message_);
  }
  bool needs_mips() const {
    return data_->needs_mips;
  }
 private:
  internal::ScheduleImageDecodeParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DeferredRequestDataView {
 public:
  DeferredRequestDataView() = default;

  DeferredRequestDataView(
      internal::DeferredRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      DeferredRequestParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = !data_->params.is_null() ? &data_->params : nullptr;
    return mojo::internal::Deserialize<::gpu::mojom::DeferredRequestParamsDataView>(
        pointer, output, message_);
  }
  inline void GetSyncTokenFencesDataView(
      mojo::ArrayDataView<::gpu::mojom::SyncTokenDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSyncTokenFences(UserType* output) {
    
    auto* pointer = data_->sync_token_fences.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gpu::mojom::SyncTokenDataView>>(
        pointer, output, message_);
  }
  uint64_t release_count() const {
    return data_->release_count;
  }
 private:
  internal::DeferredRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DeferredCommandBufferRequestDataView {
 public:
  DeferredCommandBufferRequestDataView() = default;

  DeferredCommandBufferRequestDataView(
      internal::DeferredCommandBufferRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t routing_id() const {
    return data_->routing_id;
  }
  inline void GetParamsDataView(
      DeferredCommandBufferRequestParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = !data_->params.is_null() ? &data_->params : nullptr;
    return mojo::internal::Deserialize<::gpu::mojom::DeferredCommandBufferRequestParamsDataView>(
        pointer, output, message_);
  }
 private:
  internal::DeferredCommandBufferRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AsyncFlushParamsDataView {
 public:
  AsyncFlushParamsDataView() = default;

  AsyncFlushParamsDataView(
      internal::AsyncFlushParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t put_offset() const {
    return data_->put_offset;
  }
  uint32_t flush_id() const {
    return data_->flush_id;
  }
  inline void GetSyncTokenFencesDataView(
      mojo::ArrayDataView<::gpu::mojom::SyncTokenDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSyncTokenFences(UserType* output) {
    
    auto* pointer = data_->sync_token_fences.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gpu::mojom::SyncTokenDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AsyncFlushParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SetDefaultFramebufferSharedImageParamsDataView {
 public:
  SetDefaultFramebufferSharedImageParamsDataView() = default;

  SetDefaultFramebufferSharedImageParamsDataView(
      internal::SetDefaultFramebufferSharedImageParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMailboxDataView(
      ::gpu::mojom::MailboxDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMailbox(UserType* output) {
    
    auto* pointer = data_->mailbox.Get();
    return mojo::internal::Deserialize<::gpu::mojom::MailboxDataView>(
        pointer, output, message_);
  }
  uint32_t samples_count() const {
    return data_->samples_count;
  }
  bool preserve() const {
    return data_->preserve;
  }
  bool needs_depth() const {
    return data_->needs_depth;
  }
  bool needs_stencil() const {
    return data_->needs_stencil;
  }
 private:
  internal::SetDefaultFramebufferSharedImageParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SharedImageInfoDataView {
 public:
  SharedImageInfoDataView() = default;

  SharedImageInfoDataView(
      internal::SharedImageInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMetaDataView(
      ::gpu::mojom::SharedImageMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMeta(UserType* output) {
    
    auto* pointer = data_->meta.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SharedImageMetadataDataView>(
        pointer, output, message_);
  }
  inline void GetDebugLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDebugLabel(UserType* output) {
    
    auto* pointer = data_->debug_label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::SharedImageInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateSharedImageParamsDataView {
 public:
  CreateSharedImageParamsDataView() = default;

  CreateSharedImageParamsDataView(
      internal::CreateSharedImageParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMailboxDataView(
      ::gpu::mojom::MailboxDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMailbox(UserType* output) {
    
    auto* pointer = data_->mailbox.Get();
    return mojo::internal::Deserialize<::gpu::mojom::MailboxDataView>(
        pointer, output, message_);
  }
  inline void GetSiInfoDataView(
      SharedImageInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSiInfo(UserType* output) {
    
    auto* pointer = data_->si_info.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SharedImageInfoDataView>(
        pointer, output, message_);
  }
  inline void GetPoolIdDataView(
      ::gpu::mojom::SharedImagePoolIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPoolId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gpu::mojom::SharedImagePoolIdDataView, UserType>(),
    "Attempting to read the optional `pool_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPoolId` instead "
    "of `ReadPoolId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pool_id.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SharedImagePoolIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::CreateSharedImageParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateSharedImageWithDataParamsDataView {
 public:
  CreateSharedImageWithDataParamsDataView() = default;

  CreateSharedImageWithDataParamsDataView(
      internal::CreateSharedImageWithDataParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMailboxDataView(
      ::gpu::mojom::MailboxDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMailbox(UserType* output) {
    
    auto* pointer = data_->mailbox.Get();
    return mojo::internal::Deserialize<::gpu::mojom::MailboxDataView>(
        pointer, output, message_);
  }
  inline void GetSiInfoDataView(
      SharedImageInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSiInfo(UserType* output) {
    
    auto* pointer = data_->si_info.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SharedImageInfoDataView>(
        pointer, output, message_);
  }
  uint32_t pixel_data_offset() const {
    return data_->pixel_data_offset;
  }
  uint32_t pixel_data_size() const {
    return data_->pixel_data_size;
  }
  bool done_with_shm() const {
    return data_->done_with_shm;
  }
 private:
  internal::CreateSharedImageWithDataParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateSharedImageWithBufferParamsDataView {
 public:
  CreateSharedImageWithBufferParamsDataView() = default;

  CreateSharedImageWithBufferParamsDataView(
      internal::CreateSharedImageWithBufferParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMailboxDataView(
      ::gpu::mojom::MailboxDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMailbox(UserType* output) {
    
    auto* pointer = data_->mailbox.Get();
    return mojo::internal::Deserialize<::gpu::mojom::MailboxDataView>(
        pointer, output, message_);
  }
  inline void GetSiInfoDataView(
      SharedImageInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSiInfo(UserType* output) {
    
    auto* pointer = data_->si_info.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SharedImageInfoDataView>(
        pointer, output, message_);
  }
  inline void GetBufferHandleDataView(
      ::gfx::mojom::GpuMemoryBufferHandleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBufferHandle(UserType* output) {
    
    auto* pointer = data_->buffer_handle.Get();
    return mojo::internal::Deserialize<::gfx::mojom::GpuMemoryBufferHandleDataView>(
        pointer, output, message_);
  }
  inline void GetPoolIdDataView(
      ::gpu::mojom::SharedImagePoolIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPoolId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gpu::mojom::SharedImagePoolIdDataView, UserType>(),
    "Attempting to read the optional `pool_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPoolId` instead "
    "of `ReadPoolId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pool_id.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SharedImagePoolIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::CreateSharedImageWithBufferParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UpdateSharedImageParamsDataView {
 public:
  UpdateSharedImageParamsDataView() = default;

  UpdateSharedImageParamsDataView(
      internal::UpdateSharedImageParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMailboxDataView(
      ::gpu::mojom::MailboxDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMailbox(UserType* output) {
    
    auto* pointer = data_->mailbox.Get();
    return mojo::internal::Deserialize<::gpu::mojom::MailboxDataView>(
        pointer, output, message_);
  }
  inline void GetInFenceHandleDataView(
      ::gfx::mojom::GpuFenceHandleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInFenceHandle(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::GpuFenceHandleDataView, UserType>(),
    "Attempting to read the optional `in_fence_handle` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInFenceHandle` instead "
    "of `ReadInFenceHandle if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->in_fence_handle.Get();
    return mojo::internal::Deserialize<::gfx::mojom::GpuFenceHandleDataView>(
        pointer, output, message_);
  }
 private:
  internal::UpdateSharedImageParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AddReferenceToSharedImageParamsDataView {
 public:
  AddReferenceToSharedImageParamsDataView() = default;

  AddReferenceToSharedImageParamsDataView(
      internal::AddReferenceToSharedImageParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMailboxDataView(
      ::gpu::mojom::MailboxDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMailbox(UserType* output) {
    
    auto* pointer = data_->mailbox.Get();
    return mojo::internal::Deserialize<::gpu::mojom::MailboxDataView>(
        pointer, output, message_);
  }
 private:
  internal::AddReferenceToSharedImageParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CopyToGpuMemoryBufferParamsDataView {
 public:
  CopyToGpuMemoryBufferParamsDataView() = default;

  CopyToGpuMemoryBufferParamsDataView(
      internal::CopyToGpuMemoryBufferParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMailboxDataView(
      ::gpu::mojom::MailboxDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMailbox(UserType* output) {
    
    auto* pointer = data_->mailbox.Get();
    return mojo::internal::Deserialize<::gpu::mojom::MailboxDataView>(
        pointer, output, message_);
  }
 private:
  internal::CopyToGpuMemoryBufferParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateSharedImagePoolParamsDataView {
 public:
  CreateSharedImagePoolParamsDataView() = default;

  CreateSharedImagePoolParamsDataView(
      internal::CreateSharedImagePoolParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPoolIdDataView(
      ::gpu::mojom::SharedImagePoolIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPoolId(UserType* output) {
    
    auto* pointer = data_->pool_id.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SharedImagePoolIdDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeClientRemote() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::gpu::mojom::SharedImagePoolClientInterfaceInterfaceBase>>(
            &data_->client_remote, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::CreateSharedImagePoolParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DestroySharedImagePoolParamsDataView {
 public:
  DestroySharedImagePoolParamsDataView() = default;

  DestroySharedImagePoolParamsDataView(
      internal::DestroySharedImagePoolParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPoolIdDataView(
      ::gpu::mojom::SharedImagePoolIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPoolId(UserType* output) {
    
    auto* pointer = data_->pool_id.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SharedImagePoolIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::DestroySharedImagePoolParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DeferredRequestParamsDataView {
 public:
  using Tag = internal::DeferredRequestParams_Data::DeferredRequestParams_Tag;

  DeferredRequestParamsDataView() = default;

  DeferredRequestParamsDataView(
      internal::DeferredRequestParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_command_buffer_request() const { return data_->tag == Tag::kCommandBufferRequest; }
  inline void GetCommandBufferRequestDataView(
      DeferredCommandBufferRequestDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCommandBufferRequest(UserType* output) const {
    
    CHECK(is_command_buffer_request());
    return mojo::internal::Deserialize<::gpu::mojom::DeferredCommandBufferRequestDataView>(
        data_->data.f_command_buffer_request.Get(), output, message_);
  }
  bool is_shared_image_request() const { return data_->tag == Tag::kSharedImageRequest; }
  inline void GetSharedImageRequestDataView(
      DeferredSharedImageRequestDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSharedImageRequest(UserType* output) const {
    
    CHECK(is_shared_image_request());
    return mojo::internal::Deserialize<::gpu::mojom::DeferredSharedImageRequestDataView>(
        data_->data.f_shared_image_request.Get(), output, message_);
  }

 private:
  internal::DeferredRequestParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class DeferredCommandBufferRequestParamsDataView {
 public:
  using Tag = internal::DeferredCommandBufferRequestParams_Data::DeferredCommandBufferRequestParams_Tag;

  DeferredCommandBufferRequestParamsDataView() = default;

  DeferredCommandBufferRequestParamsDataView(
      internal::DeferredCommandBufferRequestParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_async_flush() const { return data_->tag == Tag::kAsyncFlush; }
  inline void GetAsyncFlushDataView(
      AsyncFlushParamsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadAsyncFlush(UserType* output) const {
    
    CHECK(is_async_flush());
    return mojo::internal::Deserialize<::gpu::mojom::AsyncFlushParamsDataView>(
        data_->data.f_async_flush.Get(), output, message_);
  }
  bool is_destroy_transfer_buffer() const { return data_->tag == Tag::kDestroyTransferBuffer; }
  int32_t destroy_transfer_buffer() const {
    CHECK(is_destroy_transfer_buffer());
    return data_->data.f_destroy_transfer_buffer;
  }
  bool is_set_default_framebuffer_shared_image() const { return data_->tag == Tag::kSetDefaultFramebufferSharedImage; }
  inline void GetSetDefaultFramebufferSharedImageDataView(
      SetDefaultFramebufferSharedImageParamsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSetDefaultFramebufferSharedImage(UserType* output) const {
    
    CHECK(is_set_default_framebuffer_shared_image());
    return mojo::internal::Deserialize<::gpu::mojom::SetDefaultFramebufferSharedImageParamsDataView>(
        data_->data.f_set_default_framebuffer_shared_image.Get(), output, message_);
  }

 private:
  internal::DeferredCommandBufferRequestParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class DeferredSharedImageRequestDataView {
 public:
  using Tag = internal::DeferredSharedImageRequest_Data::DeferredSharedImageRequest_Tag;

  DeferredSharedImageRequestDataView() = default;

  DeferredSharedImageRequestDataView(
      internal::DeferredSharedImageRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_nop() const { return data_->tag == Tag::kNop; }
  uint8_t nop() const {
    CHECK(is_nop());
    return data_->data.f_nop;
  }
  bool is_create_shared_image() const { return data_->tag == Tag::kCreateSharedImage; }
  inline void GetCreateSharedImageDataView(
      CreateSharedImageParamsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCreateSharedImage(UserType* output) const {
    
    CHECK(is_create_shared_image());
    return mojo::internal::Deserialize<::gpu::mojom::CreateSharedImageParamsDataView>(
        data_->data.f_create_shared_image.Get(), output, message_);
  }
  bool is_create_shared_image_with_data() const { return data_->tag == Tag::kCreateSharedImageWithData; }
  inline void GetCreateSharedImageWithDataDataView(
      CreateSharedImageWithDataParamsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCreateSharedImageWithData(UserType* output) const {
    
    CHECK(is_create_shared_image_with_data());
    return mojo::internal::Deserialize<::gpu::mojom::CreateSharedImageWithDataParamsDataView>(
        data_->data.f_create_shared_image_with_data.Get(), output, message_);
  }
  bool is_create_shared_image_with_buffer() const { return data_->tag == Tag::kCreateSharedImageWithBuffer; }
  inline void GetCreateSharedImageWithBufferDataView(
      CreateSharedImageWithBufferParamsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCreateSharedImageWithBuffer(UserType* output) const {
    
    CHECK(is_create_shared_image_with_buffer());
    return mojo::internal::Deserialize<::gpu::mojom::CreateSharedImageWithBufferParamsDataView>(
        data_->data.f_create_shared_image_with_buffer.Get(), output, message_);
  }
  bool is_register_upload_buffer() const { return data_->tag == Tag::kRegisterUploadBuffer; }
  inline void GetRegisterUploadBufferDataView(
      ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRegisterUploadBuffer(UserType* output) const {
    
    CHECK(is_register_upload_buffer());
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        data_->data.f_register_upload_buffer.Get(), output, message_);
  }
  bool is_update_shared_image() const { return data_->tag == Tag::kUpdateSharedImage; }
  inline void GetUpdateSharedImageDataView(
      UpdateSharedImageParamsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadUpdateSharedImage(UserType* output) const {
    
    CHECK(is_update_shared_image());
    return mojo::internal::Deserialize<::gpu::mojom::UpdateSharedImageParamsDataView>(
        data_->data.f_update_shared_image.Get(), output, message_);
  }
  bool is_copy_to_gpu_memory_buffer() const { return data_->tag == Tag::kCopyToGpuMemoryBuffer; }
  inline void GetCopyToGpuMemoryBufferDataView(
      CopyToGpuMemoryBufferParamsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCopyToGpuMemoryBuffer(UserType* output) const {
    
    CHECK(is_copy_to_gpu_memory_buffer());
    return mojo::internal::Deserialize<::gpu::mojom::CopyToGpuMemoryBufferParamsDataView>(
        data_->data.f_copy_to_gpu_memory_buffer.Get(), output, message_);
  }
  bool is_destroy_shared_image() const { return data_->tag == Tag::kDestroySharedImage; }
  inline void GetDestroySharedImageDataView(
      ::gpu::mojom::MailboxDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadDestroySharedImage(UserType* output) const {
    
    CHECK(is_destroy_shared_image());
    return mojo::internal::Deserialize<::gpu::mojom::MailboxDataView>(
        data_->data.f_destroy_shared_image.Get(), output, message_);
  }
  bool is_add_reference_to_shared_image() const { return data_->tag == Tag::kAddReferenceToSharedImage; }
  inline void GetAddReferenceToSharedImageDataView(
      AddReferenceToSharedImageParamsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadAddReferenceToSharedImage(UserType* output) const {
    
    CHECK(is_add_reference_to_shared_image());
    return mojo::internal::Deserialize<::gpu::mojom::AddReferenceToSharedImageParamsDataView>(
        data_->data.f_add_reference_to_shared_image.Get(), output, message_);
  }
  bool is_create_shared_image_pool() const { return data_->tag == Tag::kCreateSharedImagePool; }
  inline void GetCreateSharedImagePoolDataView(
      CreateSharedImagePoolParamsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCreateSharedImagePool(UserType* output) const {
    
    CHECK(is_create_shared_image_pool());
    return mojo::internal::Deserialize<::gpu::mojom::CreateSharedImagePoolParamsDataView>(
        data_->data.f_create_shared_image_pool.Get(), output, message_);
  }
  bool is_destroy_shared_image_pool() const { return data_->tag == Tag::kDestroySharedImagePool; }
  inline void GetDestroySharedImagePoolDataView(
      DestroySharedImagePoolParamsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadDestroySharedImagePool(UserType* output) const {
    
    CHECK(is_destroy_shared_image_pool());
    return mojo::internal::Deserialize<::gpu::mojom::DestroySharedImagePoolParamsDataView>(
        data_->data.f_destroy_shared_image_pool.Get(), output, message_);
  }

 private:
  internal::DeferredSharedImageRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // gpu::mojom

namespace std {

template <>
struct hash<::gpu::mojom::ContextType>
    : public mojo::internal::EnumHashImpl<::gpu::mojom::ContextType> {};

template <>
struct hash<::gpu::mojom::ContextColorSpace>
    : public mojo::internal::EnumHashImpl<::gpu::mojom::ContextColorSpace> {};

template <>
struct hash<::gpu::mojom::SchedulingPriority>
    : public mojo::internal::EnumHashImpl<::gpu::mojom::SchedulingPriority> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::ContextType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gpu::mojom::ContextType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gpu::mojom::ContextType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::ContextColorSpace, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gpu::mojom::ContextColorSpace, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gpu::mojom::ContextColorSpace>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::SchedulingPriority, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gpu::mojom::SchedulingPriority, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gpu::mojom::SchedulingPriority>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::ContextCreationAttribsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::ContextCreationAttribsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::ContextCreationAttribs_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::gl::mojom::GpuPreference>(
        Traits::gpu_preference(input), &fragment->gpu_preference);
    fragment->bind_generates_resource = Traits::bind_generates_resource(input);
    fragment->fail_if_major_perf_caveat = Traits::fail_if_major_perf_caveat(input);
    fragment->lose_context_when_out_of_memory = Traits::lose_context_when_out_of_memory(input);
    fragment->enable_gles2_interface = Traits::enable_gles2_interface(input);
    fragment->enable_grcontext = Traits::enable_grcontext(input);
    fragment->enable_raster_interface = Traits::enable_raster_interface(input);
    fragment->enable_oop_rasterization = Traits::enable_oop_rasterization(input);
    mojo::internal::Serialize<::gpu::mojom::ContextType>(
        Traits::context_type(input), &fragment->context_type);
  }

  static bool Deserialize(::gpu::mojom::internal::ContextCreationAttribs_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::ContextCreationAttribsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::CreateCommandBufferParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::CreateCommandBufferParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::CreateCommandBufferParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->share_group_id = Traits::share_group_id(input);
    fragment->stream_id = Traits::stream_id(input);
    mojo::internal::Serialize<::gpu::mojom::SchedulingPriority>(
        Traits::stream_priority(input), &fragment->stream_priority);
    decltype(Traits::attribs(input)) in_attribs = Traits::attribs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->attribs)::BaseType> attribs_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::ContextCreationAttribsDataView>(
        in_attribs, attribs_fragment);
    fragment->attribs.Set(
        attribs_fragment.is_null() ? nullptr : attribs_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->attribs.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null attribs in CreateCommandBufferParams struct");
    decltype(Traits::active_url(input)) in_active_url = Traits::active_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->active_url)::BaseType> active_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_active_url, active_url_fragment);
    fragment->active_url.Set(
        active_url_fragment.is_null() ? nullptr : active_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->active_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null active_url in CreateCommandBufferParams struct");
  }

  static bool Deserialize(::gpu::mojom::internal::CreateCommandBufferParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::CreateCommandBufferParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::CommandBufferStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::CommandBufferStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::CommandBufferState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->get_offset = Traits::get_offset(input);
    fragment->token = Traits::token(input);
    fragment->release_count = Traits::release_count(input);
    mojo::internal::Serialize<::gpu::mojom::Error>(
        Traits::error(input), &fragment->error);
    mojo::internal::Serialize<::gpu::mojom::ContextLostReason>(
        Traits::context_lost_reason(input), &fragment->context_lost_reason);
    fragment->generation = Traits::generation(input);
    fragment->set_get_buffer_count = Traits::set_get_buffer_count(input);
  }

  static bool Deserialize(::gpu::mojom::internal::CommandBufferState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::CommandBufferStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::ScheduleImageDecodeParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::ScheduleImageDecodeParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::ScheduleImageDecodeParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::encoded_data(input)) in_encoded_data = Traits::encoded_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->encoded_data)::BaseType>
        encoded_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& encoded_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_encoded_data, encoded_data_fragment, &encoded_data_validate_params);
    fragment->encoded_data.Set(
        encoded_data_fragment.is_null() ? nullptr : encoded_data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->encoded_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null encoded_data in ScheduleImageDecodeParams struct");
    decltype(Traits::output_size(input)) in_output_size = Traits::output_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_size)::BaseType> output_size_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_output_size, output_size_fragment);
    fragment->output_size.Set(
        output_size_fragment.is_null() ? nullptr : output_size_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->output_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null output_size in ScheduleImageDecodeParams struct");
    fragment->raster_decoder_route_id = Traits::raster_decoder_route_id(input);
    fragment->transfer_cache_entry_id = Traits::transfer_cache_entry_id(input);
    fragment->discardable_handle_shm_id = Traits::discardable_handle_shm_id(input);
    fragment->discardable_handle_shm_offset = Traits::discardable_handle_shm_offset(input);
    fragment->discardable_handle_release_count = Traits::discardable_handle_release_count(input);
    decltype(Traits::target_color_space(input)) in_target_color_space = Traits::target_color_space(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->target_color_space)::BaseType> target_color_space_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::ColorSpaceDataView>(
        in_target_color_space, target_color_space_fragment);
    fragment->target_color_space.Set(
        target_color_space_fragment.is_null() ? nullptr : target_color_space_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->target_color_space.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null target_color_space in ScheduleImageDecodeParams struct");
    fragment->needs_mips = Traits::needs_mips(input);
  }

  static bool Deserialize(::gpu::mojom::internal::ScheduleImageDecodeParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::ScheduleImageDecodeParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::DeferredRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::DeferredRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::DeferredRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::params(input)) in_params = Traits::params(input);
    mojo::internal::MessageFragment<decltype(fragment->params)>
        params_fragment(fragment.message());
    params_fragment.Claim(&fragment->params);
    mojo::internal::Serialize<::gpu::mojom::DeferredRequestParamsDataView>(
        in_params, params_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->params.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null params in DeferredRequest struct");
    decltype(Traits::sync_token_fences(input)) in_sync_token_fences = Traits::sync_token_fences(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sync_token_fences)::BaseType>
        sync_token_fences_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& sync_token_fences_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::SyncTokenDataView>>(
        in_sync_token_fences, sync_token_fences_fragment, &sync_token_fences_validate_params);
    fragment->sync_token_fences.Set(
        sync_token_fences_fragment.is_null() ? nullptr : sync_token_fences_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->sync_token_fences.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sync_token_fences in DeferredRequest struct");
    fragment->release_count = Traits::release_count(input);
  }

  static bool Deserialize(::gpu::mojom::internal::DeferredRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::DeferredRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::DeferredCommandBufferRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::DeferredCommandBufferRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::DeferredCommandBufferRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->routing_id = Traits::routing_id(input);
    decltype(Traits::params(input)) in_params = Traits::params(input);
    mojo::internal::MessageFragment<decltype(fragment->params)>
        params_fragment(fragment.message());
    params_fragment.Claim(&fragment->params);
    mojo::internal::Serialize<::gpu::mojom::DeferredCommandBufferRequestParamsDataView>(
        in_params, params_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->params.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null params in DeferredCommandBufferRequest struct");
  }

  static bool Deserialize(::gpu::mojom::internal::DeferredCommandBufferRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::DeferredCommandBufferRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::AsyncFlushParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::AsyncFlushParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::AsyncFlushParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->put_offset = Traits::put_offset(input);
    fragment->flush_id = Traits::flush_id(input);
    decltype(Traits::sync_token_fences(input)) in_sync_token_fences = Traits::sync_token_fences(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sync_token_fences)::BaseType>
        sync_token_fences_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& sync_token_fences_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::SyncTokenDataView>>(
        in_sync_token_fences, sync_token_fences_fragment, &sync_token_fences_validate_params);
    fragment->sync_token_fences.Set(
        sync_token_fences_fragment.is_null() ? nullptr : sync_token_fences_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->sync_token_fences.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sync_token_fences in AsyncFlushParams struct");
  }

  static bool Deserialize(::gpu::mojom::internal::AsyncFlushParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::AsyncFlushParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::SetDefaultFramebufferSharedImageParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::SetDefaultFramebufferSharedImageParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::SetDefaultFramebufferSharedImageParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::mailbox(input)) in_mailbox = Traits::mailbox(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mailbox)::BaseType> mailbox_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::MailboxDataView>(
        in_mailbox, mailbox_fragment);
    fragment->mailbox.Set(
        mailbox_fragment.is_null() ? nullptr : mailbox_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->mailbox.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mailbox in SetDefaultFramebufferSharedImageParams struct");
    fragment->samples_count = Traits::samples_count(input);
    fragment->preserve = Traits::preserve(input);
    fragment->needs_depth = Traits::needs_depth(input);
    fragment->needs_stencil = Traits::needs_stencil(input);
  }

  static bool Deserialize(::gpu::mojom::internal::SetDefaultFramebufferSharedImageParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::SetDefaultFramebufferSharedImageParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::SharedImageInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::SharedImageInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::SharedImageInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::meta(input)) in_meta = Traits::meta(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->meta)::BaseType> meta_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::SharedImageMetadataDataView>(
        in_meta, meta_fragment);
    fragment->meta.Set(
        meta_fragment.is_null() ? nullptr : meta_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->meta.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null meta in SharedImageInfo struct");
    decltype(Traits::debug_label(input)) in_debug_label = Traits::debug_label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->debug_label)::BaseType> debug_label_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_debug_label, debug_label_fragment);
    fragment->debug_label.Set(
        debug_label_fragment.is_null() ? nullptr : debug_label_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->debug_label.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null debug_label in SharedImageInfo struct");
  }

  static bool Deserialize(::gpu::mojom::internal::SharedImageInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::SharedImageInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::CreateSharedImageParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::CreateSharedImageParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::CreateSharedImageParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::mailbox(input)) in_mailbox = Traits::mailbox(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mailbox)::BaseType> mailbox_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::MailboxDataView>(
        in_mailbox, mailbox_fragment);
    fragment->mailbox.Set(
        mailbox_fragment.is_null() ? nullptr : mailbox_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->mailbox.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mailbox in CreateSharedImageParams struct");
    decltype(Traits::si_info(input)) in_si_info = Traits::si_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->si_info)::BaseType> si_info_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::SharedImageInfoDataView>(
        in_si_info, si_info_fragment);
    fragment->si_info.Set(
        si_info_fragment.is_null() ? nullptr : si_info_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->si_info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null si_info in CreateSharedImageParams struct");
    decltype(Traits::pool_id(input)) in_pool_id = Traits::pool_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pool_id)::BaseType> pool_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::SharedImagePoolIdDataView>(
        in_pool_id, pool_id_fragment);
    fragment->pool_id.Set(
        pool_id_fragment.is_null() ? nullptr : pool_id_fragment.data());
  }

  static bool Deserialize(::gpu::mojom::internal::CreateSharedImageParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::CreateSharedImageParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::CreateSharedImageWithDataParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::CreateSharedImageWithDataParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::CreateSharedImageWithDataParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::mailbox(input)) in_mailbox = Traits::mailbox(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mailbox)::BaseType> mailbox_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::MailboxDataView>(
        in_mailbox, mailbox_fragment);
    fragment->mailbox.Set(
        mailbox_fragment.is_null() ? nullptr : mailbox_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->mailbox.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mailbox in CreateSharedImageWithDataParams struct");
    decltype(Traits::si_info(input)) in_si_info = Traits::si_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->si_info)::BaseType> si_info_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::SharedImageInfoDataView>(
        in_si_info, si_info_fragment);
    fragment->si_info.Set(
        si_info_fragment.is_null() ? nullptr : si_info_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->si_info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null si_info in CreateSharedImageWithDataParams struct");
    fragment->pixel_data_offset = Traits::pixel_data_offset(input);
    fragment->pixel_data_size = Traits::pixel_data_size(input);
    fragment->done_with_shm = Traits::done_with_shm(input);
  }

  static bool Deserialize(::gpu::mojom::internal::CreateSharedImageWithDataParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::CreateSharedImageWithDataParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::CreateSharedImageWithBufferParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::CreateSharedImageWithBufferParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::CreateSharedImageWithBufferParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::mailbox(input)) in_mailbox = Traits::mailbox(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mailbox)::BaseType> mailbox_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::MailboxDataView>(
        in_mailbox, mailbox_fragment);
    fragment->mailbox.Set(
        mailbox_fragment.is_null() ? nullptr : mailbox_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->mailbox.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mailbox in CreateSharedImageWithBufferParams struct");
    decltype(Traits::si_info(input)) in_si_info = Traits::si_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->si_info)::BaseType> si_info_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::SharedImageInfoDataView>(
        in_si_info, si_info_fragment);
    fragment->si_info.Set(
        si_info_fragment.is_null() ? nullptr : si_info_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->si_info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null si_info in CreateSharedImageWithBufferParams struct");
    decltype(Traits::buffer_handle(input)) in_buffer_handle = Traits::buffer_handle(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->buffer_handle)::BaseType> buffer_handle_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferHandleDataView>(
        in_buffer_handle, buffer_handle_fragment);
    fragment->buffer_handle.Set(
        buffer_handle_fragment.is_null() ? nullptr : buffer_handle_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->buffer_handle.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null buffer_handle in CreateSharedImageWithBufferParams struct");
    decltype(Traits::pool_id(input)) in_pool_id = Traits::pool_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pool_id)::BaseType> pool_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::SharedImagePoolIdDataView>(
        in_pool_id, pool_id_fragment);
    fragment->pool_id.Set(
        pool_id_fragment.is_null() ? nullptr : pool_id_fragment.data());
  }

  static bool Deserialize(::gpu::mojom::internal::CreateSharedImageWithBufferParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::CreateSharedImageWithBufferParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::UpdateSharedImageParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::UpdateSharedImageParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::UpdateSharedImageParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::mailbox(input)) in_mailbox = Traits::mailbox(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mailbox)::BaseType> mailbox_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::MailboxDataView>(
        in_mailbox, mailbox_fragment);
    fragment->mailbox.Set(
        mailbox_fragment.is_null() ? nullptr : mailbox_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->mailbox.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mailbox in UpdateSharedImageParams struct");
    decltype(Traits::in_fence_handle(input)) in_in_fence_handle = Traits::in_fence_handle(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->in_fence_handle)::BaseType> in_fence_handle_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::GpuFenceHandleDataView>(
        in_in_fence_handle, in_fence_handle_fragment);
    fragment->in_fence_handle.Set(
        in_fence_handle_fragment.is_null() ? nullptr : in_fence_handle_fragment.data());
  }

  static bool Deserialize(::gpu::mojom::internal::UpdateSharedImageParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::UpdateSharedImageParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::AddReferenceToSharedImageParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::AddReferenceToSharedImageParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::AddReferenceToSharedImageParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::mailbox(input)) in_mailbox = Traits::mailbox(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mailbox)::BaseType> mailbox_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::MailboxDataView>(
        in_mailbox, mailbox_fragment);
    fragment->mailbox.Set(
        mailbox_fragment.is_null() ? nullptr : mailbox_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->mailbox.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mailbox in AddReferenceToSharedImageParams struct");
  }

  static bool Deserialize(::gpu::mojom::internal::AddReferenceToSharedImageParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::AddReferenceToSharedImageParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::CopyToGpuMemoryBufferParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::CopyToGpuMemoryBufferParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::CopyToGpuMemoryBufferParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::mailbox(input)) in_mailbox = Traits::mailbox(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mailbox)::BaseType> mailbox_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::MailboxDataView>(
        in_mailbox, mailbox_fragment);
    fragment->mailbox.Set(
        mailbox_fragment.is_null() ? nullptr : mailbox_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->mailbox.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mailbox in CopyToGpuMemoryBufferParams struct");
  }

  static bool Deserialize(::gpu::mojom::internal::CopyToGpuMemoryBufferParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::CopyToGpuMemoryBufferParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::CreateSharedImagePoolParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::CreateSharedImagePoolParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::CreateSharedImagePoolParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::pool_id(input)) in_pool_id = Traits::pool_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pool_id)::BaseType> pool_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::SharedImagePoolIdDataView>(
        in_pool_id, pool_id_fragment);
    fragment->pool_id.Set(
        pool_id_fragment.is_null() ? nullptr : pool_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->pool_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pool_id in CreateSharedImagePoolParams struct");
    decltype(Traits::client_remote(input)) in_client_remote = Traits::client_remote(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::gpu::mojom::SharedImagePoolClientInterfaceInterfaceBase>>(
        in_client_remote, &fragment->client_remote, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->client_remote),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid client_remote in CreateSharedImagePoolParams struct");
  }

  static bool Deserialize(::gpu::mojom::internal::CreateSharedImagePoolParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::CreateSharedImagePoolParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::DestroySharedImagePoolParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::DestroySharedImagePoolParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::DestroySharedImagePoolParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::pool_id(input)) in_pool_id = Traits::pool_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pool_id)::BaseType> pool_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::SharedImagePoolIdDataView>(
        in_pool_id, pool_id_fragment);
    fragment->pool_id.Set(
        pool_id_fragment.is_null() ? nullptr : pool_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->pool_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pool_id in DestroySharedImagePoolParams struct");
  }

  static bool Deserialize(::gpu::mojom::internal::DestroySharedImagePoolParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::DestroySharedImagePoolParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::DeferredRequestParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::gpu::mojom::DeferredRequestParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::gpu::mojom::internal::DeferredRequestParams_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::gpu::mojom::DeferredRequestParamsDataView::Tag::kCommandBufferRequest: {
        decltype(Traits::command_buffer_request(input))
            in_command_buffer_request = Traits::command_buffer_request(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_command_buffer_request)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::gpu::mojom::DeferredCommandBufferRequestDataView>(
            in_command_buffer_request, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null command_buffer_request in DeferredRequestParams union");
        fragment->data.f_command_buffer_request.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::gpu::mojom::DeferredRequestParamsDataView::Tag::kSharedImageRequest: {
        decltype(Traits::shared_image_request(input))
            in_shared_image_request = Traits::shared_image_request(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_shared_image_request)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::gpu::mojom::DeferredSharedImageRequestDataView>(
            in_shared_image_request, value_fragment, false);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null shared_image_request in DeferredRequestParams union");
        fragment->data.f_shared_image_request.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::gpu::mojom::internal::DeferredRequestParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::DeferredRequestParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::DeferredCommandBufferRequestParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::gpu::mojom::DeferredCommandBufferRequestParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::gpu::mojom::internal::DeferredCommandBufferRequestParams_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::gpu::mojom::DeferredCommandBufferRequestParamsDataView::Tag::kAsyncFlush: {
        decltype(Traits::async_flush(input))
            in_async_flush = Traits::async_flush(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_async_flush)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::gpu::mojom::AsyncFlushParamsDataView>(
            in_async_flush, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null async_flush in DeferredCommandBufferRequestParams union");
        fragment->data.f_async_flush.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::gpu::mojom::DeferredCommandBufferRequestParamsDataView::Tag::kDestroyTransferBuffer: {
        decltype(Traits::destroy_transfer_buffer(input))
            in_destroy_transfer_buffer = Traits::destroy_transfer_buffer(input);
        fragment->data.f_destroy_transfer_buffer = in_destroy_transfer_buffer;
        break;
      }
      case ::gpu::mojom::DeferredCommandBufferRequestParamsDataView::Tag::kSetDefaultFramebufferSharedImage: {
        decltype(Traits::set_default_framebuffer_shared_image(input))
            in_set_default_framebuffer_shared_image = Traits::set_default_framebuffer_shared_image(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_set_default_framebuffer_shared_image)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::gpu::mojom::SetDefaultFramebufferSharedImageParamsDataView>(
            in_set_default_framebuffer_shared_image, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null set_default_framebuffer_shared_image in DeferredCommandBufferRequestParams union");
        fragment->data.f_set_default_framebuffer_shared_image.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::gpu::mojom::internal::DeferredCommandBufferRequestParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::DeferredCommandBufferRequestParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::DeferredSharedImageRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::gpu::mojom::DeferredSharedImageRequestDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::gpu::mojom::internal::DeferredSharedImageRequest_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::gpu::mojom::DeferredSharedImageRequestDataView::Tag::kNop: {
        decltype(Traits::nop(input))
            in_nop = Traits::nop(input);
        fragment->data.f_nop = in_nop;
        break;
      }
      case ::gpu::mojom::DeferredSharedImageRequestDataView::Tag::kCreateSharedImage: {
        decltype(Traits::create_shared_image(input))
            in_create_shared_image = Traits::create_shared_image(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_create_shared_image)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::gpu::mojom::CreateSharedImageParamsDataView>(
            in_create_shared_image, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null create_shared_image in DeferredSharedImageRequest union");
        fragment->data.f_create_shared_image.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::gpu::mojom::DeferredSharedImageRequestDataView::Tag::kCreateSharedImageWithData: {
        decltype(Traits::create_shared_image_with_data(input))
            in_create_shared_image_with_data = Traits::create_shared_image_with_data(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_create_shared_image_with_data)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::gpu::mojom::CreateSharedImageWithDataParamsDataView>(
            in_create_shared_image_with_data, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null create_shared_image_with_data in DeferredSharedImageRequest union");
        fragment->data.f_create_shared_image_with_data.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::gpu::mojom::DeferredSharedImageRequestDataView::Tag::kCreateSharedImageWithBuffer: {
        decltype(Traits::create_shared_image_with_buffer(input))
            in_create_shared_image_with_buffer = Traits::create_shared_image_with_buffer(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_create_shared_image_with_buffer)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::gpu::mojom::CreateSharedImageWithBufferParamsDataView>(
            in_create_shared_image_with_buffer, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null create_shared_image_with_buffer in DeferredSharedImageRequest union");
        fragment->data.f_create_shared_image_with_buffer.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::gpu::mojom::DeferredSharedImageRequestDataView::Tag::kRegisterUploadBuffer: {
        decltype(Traits::register_upload_buffer(input))
            in_register_upload_buffer = Traits::register_upload_buffer(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_register_upload_buffer)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
            in_register_upload_buffer, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null register_upload_buffer in DeferredSharedImageRequest union");
        fragment->data.f_register_upload_buffer.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::gpu::mojom::DeferredSharedImageRequestDataView::Tag::kUpdateSharedImage: {
        decltype(Traits::update_shared_image(input))
            in_update_shared_image = Traits::update_shared_image(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_update_shared_image)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::gpu::mojom::UpdateSharedImageParamsDataView>(
            in_update_shared_image, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null update_shared_image in DeferredSharedImageRequest union");
        fragment->data.f_update_shared_image.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::gpu::mojom::DeferredSharedImageRequestDataView::Tag::kCopyToGpuMemoryBuffer: {
        decltype(Traits::copy_to_gpu_memory_buffer(input))
            in_copy_to_gpu_memory_buffer = Traits::copy_to_gpu_memory_buffer(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_copy_to_gpu_memory_buffer)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::gpu::mojom::CopyToGpuMemoryBufferParamsDataView>(
            in_copy_to_gpu_memory_buffer, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null copy_to_gpu_memory_buffer in DeferredSharedImageRequest union");
        fragment->data.f_copy_to_gpu_memory_buffer.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::gpu::mojom::DeferredSharedImageRequestDataView::Tag::kDestroySharedImage: {
        decltype(Traits::destroy_shared_image(input))
            in_destroy_shared_image = Traits::destroy_shared_image(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_destroy_shared_image)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::gpu::mojom::MailboxDataView>(
            in_destroy_shared_image, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null destroy_shared_image in DeferredSharedImageRequest union");
        fragment->data.f_destroy_shared_image.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::gpu::mojom::DeferredSharedImageRequestDataView::Tag::kAddReferenceToSharedImage: {
        decltype(Traits::add_reference_to_shared_image(input))
            in_add_reference_to_shared_image = Traits::add_reference_to_shared_image(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_add_reference_to_shared_image)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::gpu::mojom::AddReferenceToSharedImageParamsDataView>(
            in_add_reference_to_shared_image, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null add_reference_to_shared_image in DeferredSharedImageRequest union");
        fragment->data.f_add_reference_to_shared_image.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::gpu::mojom::DeferredSharedImageRequestDataView::Tag::kCreateSharedImagePool: {
        decltype(Traits::create_shared_image_pool(input))
            in_create_shared_image_pool = Traits::create_shared_image_pool(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_create_shared_image_pool)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::gpu::mojom::CreateSharedImagePoolParamsDataView>(
            in_create_shared_image_pool, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null create_shared_image_pool in DeferredSharedImageRequest union");
        fragment->data.f_create_shared_image_pool.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::gpu::mojom::DeferredSharedImageRequestDataView::Tag::kDestroySharedImagePool: {
        decltype(Traits::destroy_shared_image_pool(input))
            in_destroy_shared_image_pool = Traits::destroy_shared_image_pool(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_destroy_shared_image_pool)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::gpu::mojom::DestroySharedImagePoolParamsDataView>(
            in_destroy_shared_image_pool, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null destroy_shared_image_pool in DeferredSharedImageRequest union");
        fragment->data.f_destroy_shared_image_pool.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::gpu::mojom::internal::DeferredSharedImageRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::DeferredSharedImageRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gpu::mojom {



inline void CreateCommandBufferParamsDataView::GetAttribsDataView(
    ContextCreationAttribsDataView* output) {
  auto pointer = data_->attribs.Get();
  *output = ContextCreationAttribsDataView(pointer, message_);
}
inline void CreateCommandBufferParamsDataView::GetActiveUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->active_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}




inline void ScheduleImageDecodeParamsDataView::GetEncodedDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->encoded_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void ScheduleImageDecodeParamsDataView::GetOutputSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->output_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void ScheduleImageDecodeParamsDataView::GetTargetColorSpaceDataView(
    ::gfx::mojom::ColorSpaceDataView* output) {
  auto pointer = data_->target_color_space.Get();
  *output = ::gfx::mojom::ColorSpaceDataView(pointer, message_);
}


inline void DeferredRequestDataView::GetParamsDataView(
    DeferredRequestParamsDataView* output) {
  auto pointer = &data_->params;
  *output = DeferredRequestParamsDataView(pointer, message_);
}
inline void DeferredRequestDataView::GetSyncTokenFencesDataView(
    mojo::ArrayDataView<::gpu::mojom::SyncTokenDataView>* output) {
  auto pointer = data_->sync_token_fences.Get();
  *output = mojo::ArrayDataView<::gpu::mojom::SyncTokenDataView>(pointer, message_);
}


inline void DeferredCommandBufferRequestDataView::GetParamsDataView(
    DeferredCommandBufferRequestParamsDataView* output) {
  auto pointer = &data_->params;
  *output = DeferredCommandBufferRequestParamsDataView(pointer, message_);
}


inline void AsyncFlushParamsDataView::GetSyncTokenFencesDataView(
    mojo::ArrayDataView<::gpu::mojom::SyncTokenDataView>* output) {
  auto pointer = data_->sync_token_fences.Get();
  *output = mojo::ArrayDataView<::gpu::mojom::SyncTokenDataView>(pointer, message_);
}


inline void SetDefaultFramebufferSharedImageParamsDataView::GetMailboxDataView(
    ::gpu::mojom::MailboxDataView* output) {
  auto pointer = data_->mailbox.Get();
  *output = ::gpu::mojom::MailboxDataView(pointer, message_);
}


inline void SharedImageInfoDataView::GetMetaDataView(
    ::gpu::mojom::SharedImageMetadataDataView* output) {
  auto pointer = data_->meta.Get();
  *output = ::gpu::mojom::SharedImageMetadataDataView(pointer, message_);
}
inline void SharedImageInfoDataView::GetDebugLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->debug_label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void CreateSharedImageParamsDataView::GetMailboxDataView(
    ::gpu::mojom::MailboxDataView* output) {
  auto pointer = data_->mailbox.Get();
  *output = ::gpu::mojom::MailboxDataView(pointer, message_);
}
inline void CreateSharedImageParamsDataView::GetSiInfoDataView(
    SharedImageInfoDataView* output) {
  auto pointer = data_->si_info.Get();
  *output = SharedImageInfoDataView(pointer, message_);
}
inline void CreateSharedImageParamsDataView::GetPoolIdDataView(
    ::gpu::mojom::SharedImagePoolIdDataView* output) {
  auto pointer = data_->pool_id.Get();
  *output = ::gpu::mojom::SharedImagePoolIdDataView(pointer, message_);
}


inline void CreateSharedImageWithDataParamsDataView::GetMailboxDataView(
    ::gpu::mojom::MailboxDataView* output) {
  auto pointer = data_->mailbox.Get();
  *output = ::gpu::mojom::MailboxDataView(pointer, message_);
}
inline void CreateSharedImageWithDataParamsDataView::GetSiInfoDataView(
    SharedImageInfoDataView* output) {
  auto pointer = data_->si_info.Get();
  *output = SharedImageInfoDataView(pointer, message_);
}


inline void CreateSharedImageWithBufferParamsDataView::GetMailboxDataView(
    ::gpu::mojom::MailboxDataView* output) {
  auto pointer = data_->mailbox.Get();
  *output = ::gpu::mojom::MailboxDataView(pointer, message_);
}
inline void CreateSharedImageWithBufferParamsDataView::GetSiInfoDataView(
    SharedImageInfoDataView* output) {
  auto pointer = data_->si_info.Get();
  *output = SharedImageInfoDataView(pointer, message_);
}
inline void CreateSharedImageWithBufferParamsDataView::GetBufferHandleDataView(
    ::gfx::mojom::GpuMemoryBufferHandleDataView* output) {
  auto pointer = data_->buffer_handle.Get();
  *output = ::gfx::mojom::GpuMemoryBufferHandleDataView(pointer, message_);
}
inline void CreateSharedImageWithBufferParamsDataView::GetPoolIdDataView(
    ::gpu::mojom::SharedImagePoolIdDataView* output) {
  auto pointer = data_->pool_id.Get();
  *output = ::gpu::mojom::SharedImagePoolIdDataView(pointer, message_);
}


inline void UpdateSharedImageParamsDataView::GetMailboxDataView(
    ::gpu::mojom::MailboxDataView* output) {
  auto pointer = data_->mailbox.Get();
  *output = ::gpu::mojom::MailboxDataView(pointer, message_);
}
inline void UpdateSharedImageParamsDataView::GetInFenceHandleDataView(
    ::gfx::mojom::GpuFenceHandleDataView* output) {
  auto pointer = data_->in_fence_handle.Get();
  *output = ::gfx::mojom::GpuFenceHandleDataView(pointer, message_);
}


inline void AddReferenceToSharedImageParamsDataView::GetMailboxDataView(
    ::gpu::mojom::MailboxDataView* output) {
  auto pointer = data_->mailbox.Get();
  *output = ::gpu::mojom::MailboxDataView(pointer, message_);
}


inline void CopyToGpuMemoryBufferParamsDataView::GetMailboxDataView(
    ::gpu::mojom::MailboxDataView* output) {
  auto pointer = data_->mailbox.Get();
  *output = ::gpu::mojom::MailboxDataView(pointer, message_);
}


inline void CreateSharedImagePoolParamsDataView::GetPoolIdDataView(
    ::gpu::mojom::SharedImagePoolIdDataView* output) {
  auto pointer = data_->pool_id.Get();
  *output = ::gpu::mojom::SharedImagePoolIdDataView(pointer, message_);
}


inline void DestroySharedImagePoolParamsDataView::GetPoolIdDataView(
    ::gpu::mojom::SharedImagePoolIdDataView* output) {
  auto pointer = data_->pool_id.Get();
  *output = ::gpu::mojom::SharedImagePoolIdDataView(pointer, message_);
}


inline void DeferredRequestParamsDataView::GetCommandBufferRequestDataView(
    DeferredCommandBufferRequestDataView* output) const {
  CHECK(is_command_buffer_request());
  *output = DeferredCommandBufferRequestDataView(data_->data.f_command_buffer_request.Get(), message_);
}
inline void DeferredRequestParamsDataView::GetSharedImageRequestDataView(
    DeferredSharedImageRequestDataView* output) const {
  CHECK(is_shared_image_request());
  *output = DeferredSharedImageRequestDataView(data_->data.f_shared_image_request.Get(), message_);
}

inline void DeferredCommandBufferRequestParamsDataView::GetAsyncFlushDataView(
    AsyncFlushParamsDataView* output) const {
  CHECK(is_async_flush());
  *output = AsyncFlushParamsDataView(data_->data.f_async_flush.Get(), message_);
}
inline void DeferredCommandBufferRequestParamsDataView::GetSetDefaultFramebufferSharedImageDataView(
    SetDefaultFramebufferSharedImageParamsDataView* output) const {
  CHECK(is_set_default_framebuffer_shared_image());
  *output = SetDefaultFramebufferSharedImageParamsDataView(data_->data.f_set_default_framebuffer_shared_image.Get(), message_);
}

inline void DeferredSharedImageRequestDataView::GetCreateSharedImageDataView(
    CreateSharedImageParamsDataView* output) const {
  CHECK(is_create_shared_image());
  *output = CreateSharedImageParamsDataView(data_->data.f_create_shared_image.Get(), message_);
}
inline void DeferredSharedImageRequestDataView::GetCreateSharedImageWithDataDataView(
    CreateSharedImageWithDataParamsDataView* output) const {
  CHECK(is_create_shared_image_with_data());
  *output = CreateSharedImageWithDataParamsDataView(data_->data.f_create_shared_image_with_data.Get(), message_);
}
inline void DeferredSharedImageRequestDataView::GetCreateSharedImageWithBufferDataView(
    CreateSharedImageWithBufferParamsDataView* output) const {
  CHECK(is_create_shared_image_with_buffer());
  *output = CreateSharedImageWithBufferParamsDataView(data_->data.f_create_shared_image_with_buffer.Get(), message_);
}
inline void DeferredSharedImageRequestDataView::GetRegisterUploadBufferDataView(
    ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) const {
  CHECK(is_register_upload_buffer());
  *output = ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView(data_->data.f_register_upload_buffer.Get(), message_);
}
inline void DeferredSharedImageRequestDataView::GetUpdateSharedImageDataView(
    UpdateSharedImageParamsDataView* output) const {
  CHECK(is_update_shared_image());
  *output = UpdateSharedImageParamsDataView(data_->data.f_update_shared_image.Get(), message_);
}
inline void DeferredSharedImageRequestDataView::GetCopyToGpuMemoryBufferDataView(
    CopyToGpuMemoryBufferParamsDataView* output) const {
  CHECK(is_copy_to_gpu_memory_buffer());
  *output = CopyToGpuMemoryBufferParamsDataView(data_->data.f_copy_to_gpu_memory_buffer.Get(), message_);
}
inline void DeferredSharedImageRequestDataView::GetDestroySharedImageDataView(
    ::gpu::mojom::MailboxDataView* output) const {
  CHECK(is_destroy_shared_image());
  *output = ::gpu::mojom::MailboxDataView(data_->data.f_destroy_shared_image.Get(), message_);
}
inline void DeferredSharedImageRequestDataView::GetAddReferenceToSharedImageDataView(
    AddReferenceToSharedImageParamsDataView* output) const {
  CHECK(is_add_reference_to_shared_image());
  *output = AddReferenceToSharedImageParamsDataView(data_->data.f_add_reference_to_shared_image.Get(), message_);
}
inline void DeferredSharedImageRequestDataView::GetCreateSharedImagePoolDataView(
    CreateSharedImagePoolParamsDataView* output) const {
  CHECK(is_create_shared_image_pool());
  *output = CreateSharedImagePoolParamsDataView(data_->data.f_create_shared_image_pool.Get(), message_);
}
inline void DeferredSharedImageRequestDataView::GetDestroySharedImagePoolDataView(
    DestroySharedImagePoolParamsDataView* output) const {
  CHECK(is_destroy_shared_image_pool());
  *output = DestroySharedImagePoolParamsDataView(data_->data.f_destroy_shared_image_pool.Get(), message_);
}


}  // gpu::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) TraceFormatTraits<::gpu::mojom::ContextType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gpu::mojom::ContextType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) TraceFormatTraits<::gpu::mojom::ContextColorSpace> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gpu::mojom::ContextColorSpace value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) TraceFormatTraits<::gpu::mojom::SchedulingPriority> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gpu::mojom::SchedulingPriority value);
};

} // namespace perfetto

#endif  // GPU_IPC_COMMON_GPU_CHANNEL_MOJOM_SHARED_H_