// media/capture/mojom/video_effects_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/capture/mojom/video_effects_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/capture/mojom/video_effects_manager.mojom-params-data.h"
#include "media/capture/mojom/video_effects_manager.mojom-shared-message-ids.h"

#include "media/capture/mojom/video_effects_manager.mojom-import-headers.h"
#include "media/capture/mojom/video_effects_manager.mojom-test-utils.h"


namespace media::mojom {
ImageEnhancement::ImageEnhancement()
    : lighting() {}

ImageEnhancement::ImageEnhancement(
    bool lighting_in)
    : lighting(std::move(lighting_in)) {}

ImageEnhancement::~ImageEnhancement() = default;
size_t ImageEnhancement::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->lighting);
  return seed;
}

void ImageEnhancement::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lighting"), this->lighting,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ImageEnhancement::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Blur::Blur() {}

Blur::~Blur() = default;
size_t Blur::Hash(size_t seed) const {
  return seed;
}

void Blur::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool Blur::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Framing::Framing()
    : padding_ratios() {}

Framing::Framing(
    const ::gfx::InsetsF& padding_ratios_in)
    : padding_ratios(std::move(padding_ratios_in)) {}

Framing::~Framing() = default;

void Framing::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "padding_ratios"), this->padding_ratios,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::InsetsF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Framing::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoEffectsConfiguration::VideoEffectsConfiguration()
    : image_enhancement(),
      blur(),
      framing() {}

VideoEffectsConfiguration::VideoEffectsConfiguration(
    ImageEnhancementPtr image_enhancement_in,
    BlurPtr blur_in,
    FramingPtr framing_in)
    : image_enhancement(std::move(image_enhancement_in)),
      blur(std::move(blur_in)),
      framing(std::move(framing_in)) {}

VideoEffectsConfiguration::~VideoEffectsConfiguration() = default;

void VideoEffectsConfiguration::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_enhancement"), this->image_enhancement,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ImageEnhancementPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blur"), this->blur,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BlurPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "framing"), this->framing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FramingPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoEffectsConfiguration::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char VideoEffectsConfigurationObserver::Name_[] = "media.mojom.VideoEffectsConfigurationObserver";

VideoEffectsConfigurationObserver::IPCStableHashFunction VideoEffectsConfigurationObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::VideoEffectsConfigurationObserver>(message.name())) {
    case messages::VideoEffectsConfigurationObserver::kOnConfigurationChanged: {
      return &VideoEffectsConfigurationObserver::OnConfigurationChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* VideoEffectsConfigurationObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::VideoEffectsConfigurationObserver>(message.name())) {
      case messages::VideoEffectsConfigurationObserver::kOnConfigurationChanged:
            return "Receive media::mojom::VideoEffectsConfigurationObserver::OnConfigurationChanged";
    }
  } else {
    switch (static_cast<messages::VideoEffectsConfigurationObserver>(message.name())) {
      case messages::VideoEffectsConfigurationObserver::kOnConfigurationChanged:
            return "Receive reply media::mojom::VideoEffectsConfigurationObserver::OnConfigurationChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t VideoEffectsConfigurationObserver::OnConfigurationChanged_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::VideoEffectsConfigurationObserver::OnConfigurationChanged");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

VideoEffectsConfigurationObserverProxy::VideoEffectsConfigurationObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoEffectsConfigurationObserverProxy::OnConfigurationChanged(
    VideoEffectsConfigurationPtr in_configuration) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoEffectsConfigurationObserver::OnConfigurationChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("configuration"), in_configuration,
                        "<value of type VideoEffectsConfigurationPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEffectsConfigurationObserver::kOnConfigurationChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEffectsConfigurationObserver_OnConfigurationChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->configuration)::BaseType> configuration_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoEffectsConfigurationDataView>(
      in_configuration, configuration_fragment);
  params->configuration.Set(
      configuration_fragment.is_null() ? nullptr : configuration_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->configuration.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null configuration in VideoEffectsConfigurationObserver.OnConfigurationChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEffectsConfigurationObserver::Name_);
  message.set_method_name("OnConfigurationChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool VideoEffectsConfigurationObserverStubDispatch::Accept(
    VideoEffectsConfigurationObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::VideoEffectsConfigurationObserver>(message->header()->name)) {
    case messages::VideoEffectsConfigurationObserver::kOnConfigurationChanged: {
      DCHECK(message->is_serialized());
      internal::VideoEffectsConfigurationObserver_OnConfigurationChanged_Params_Data* params =
          reinterpret_cast<internal::VideoEffectsConfigurationObserver_OnConfigurationChanged_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for VideoEffectsConfigurationObserver.0
      bool success = true;
      VideoEffectsConfigurationPtr p_configuration{};
      VideoEffectsConfigurationObserver_OnConfigurationChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfiguration(&p_configuration))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEffectsConfigurationObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnConfigurationChanged(        
        std::move(p_configuration));
      return true;
    }
  }
  return false;
}

// static
bool VideoEffectsConfigurationObserverStubDispatch::AcceptWithResponder(
    VideoEffectsConfigurationObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::VideoEffectsConfigurationObserver>(message->header()->name)) {
    case messages::VideoEffectsConfigurationObserver::kOnConfigurationChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVideoEffectsConfigurationObserverValidationInfo[] = {
    {base::to_underlying(messages::VideoEffectsConfigurationObserver::kOnConfigurationChanged),
     { &internal::VideoEffectsConfigurationObserver_OnConfigurationChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool VideoEffectsConfigurationObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::VideoEffectsConfigurationObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kVideoEffectsConfigurationObserverValidationInfo);
}

const char ReadonlyVideoEffectsManager::Name_[] = "media.mojom.ReadonlyVideoEffectsManager";

ReadonlyVideoEffectsManager::IPCStableHashFunction ReadonlyVideoEffectsManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ReadonlyVideoEffectsManager>(message.name())) {
    case messages::ReadonlyVideoEffectsManager::kGetConfiguration: {
      return &ReadonlyVideoEffectsManager::GetConfiguration_Sym::IPCStableHash;
    }
    case messages::ReadonlyVideoEffectsManager::kAddObserver: {
      return &ReadonlyVideoEffectsManager::AddObserver_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ReadonlyVideoEffectsManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ReadonlyVideoEffectsManager>(message.name())) {
      case messages::ReadonlyVideoEffectsManager::kGetConfiguration:
            return "Receive media::mojom::ReadonlyVideoEffectsManager::GetConfiguration";
      case messages::ReadonlyVideoEffectsManager::kAddObserver:
            return "Receive media::mojom::ReadonlyVideoEffectsManager::AddObserver";
    }
  } else {
    switch (static_cast<messages::ReadonlyVideoEffectsManager>(message.name())) {
      case messages::ReadonlyVideoEffectsManager::kGetConfiguration:
            return "Receive reply media::mojom::ReadonlyVideoEffectsManager::GetConfiguration";
      case messages::ReadonlyVideoEffectsManager::kAddObserver:
            return "Receive reply media::mojom::ReadonlyVideoEffectsManager::AddObserver";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ReadonlyVideoEffectsManager::GetConfiguration_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::ReadonlyVideoEffectsManager::GetConfiguration");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ReadonlyVideoEffectsManager::AddObserver_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::ReadonlyVideoEffectsManager::AddObserver");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ReadonlyVideoEffectsManager_GetConfiguration_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ReadonlyVideoEffectsManager_GetConfiguration_ForwardToCallback(
      ReadonlyVideoEffectsManager::GetConfigurationCallback callback
      ) : callback_(std::move(callback)) {
  }

  ReadonlyVideoEffectsManager_GetConfiguration_ForwardToCallback(const ReadonlyVideoEffectsManager_GetConfiguration_ForwardToCallback&) = delete;
  ReadonlyVideoEffectsManager_GetConfiguration_ForwardToCallback& operator=(const ReadonlyVideoEffectsManager_GetConfiguration_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ReadonlyVideoEffectsManager::GetConfigurationCallback callback_;
};

ReadonlyVideoEffectsManagerProxy::ReadonlyVideoEffectsManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ReadonlyVideoEffectsManagerProxy::GetConfiguration(
    GetConfigurationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::ReadonlyVideoEffectsManager::GetConfiguration");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ReadonlyVideoEffectsManager::kGetConfiguration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::ReadonlyVideoEffectsManager_GetConfiguration_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ReadonlyVideoEffectsManager::Name_);
  message.set_method_name("GetConfiguration");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ReadonlyVideoEffectsManager_GetConfiguration_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ReadonlyVideoEffectsManagerProxy::AddObserver(
    ::mojo::PendingRemote<VideoEffectsConfigurationObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::ReadonlyVideoEffectsManager::AddObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<VideoEffectsConfigurationObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ReadonlyVideoEffectsManager::kAddObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::ReadonlyVideoEffectsManager_AddObserver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::VideoEffectsConfigurationObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid observer in ReadonlyVideoEffectsManager.AddObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ReadonlyVideoEffectsManager::Name_);
  message.set_method_name("AddObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class ReadonlyVideoEffectsManager_GetConfiguration_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ReadonlyVideoEffectsManager::GetConfigurationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ReadonlyVideoEffectsManager_GetConfiguration_ProxyToResponder> proxy(
        new ReadonlyVideoEffectsManager_GetConfiguration_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ReadonlyVideoEffectsManager_GetConfiguration_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ReadonlyVideoEffectsManager_GetConfiguration_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ReadonlyVideoEffectsManager_GetConfiguration_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ReadonlyVideoEffectsManager::GetConfigurationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      VideoEffectsConfigurationPtr in_configuration);
};

bool ReadonlyVideoEffectsManager_GetConfiguration_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ReadonlyVideoEffectsManager_GetConfiguration_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ReadonlyVideoEffectsManager_GetConfiguration_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for ReadonlyVideoEffectsManager.0
  bool success = true;
  VideoEffectsConfigurationPtr p_configuration{};
  ReadonlyVideoEffectsManager_GetConfiguration_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadConfiguration(&p_configuration))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ReadonlyVideoEffectsManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_configuration));
  return true;
}

void ReadonlyVideoEffectsManager_GetConfiguration_ProxyToResponder::Run(
    VideoEffectsConfigurationPtr in_configuration) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::ReadonlyVideoEffectsManager::GetConfiguration", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("configuration"), in_configuration,
                        "<value of type VideoEffectsConfigurationPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ReadonlyVideoEffectsManager::kGetConfiguration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::ReadonlyVideoEffectsManager_GetConfiguration_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->configuration)::BaseType> configuration_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoEffectsConfigurationDataView>(
      in_configuration, configuration_fragment);
  params->configuration.Set(
      configuration_fragment.is_null() ? nullptr : configuration_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->configuration.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null configuration in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ReadonlyVideoEffectsManager::Name_);
  message.set_method_name("GetConfiguration");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ReadonlyVideoEffectsManagerStubDispatch::Accept(
    ReadonlyVideoEffectsManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ReadonlyVideoEffectsManager>(message->header()->name)) {
    case messages::ReadonlyVideoEffectsManager::kGetConfiguration: {
      break;
    }
    case messages::ReadonlyVideoEffectsManager::kAddObserver: {
      DCHECK(message->is_serialized());
      internal::ReadonlyVideoEffectsManager_AddObserver_Params_Data* params =
          reinterpret_cast<internal::ReadonlyVideoEffectsManager_AddObserver_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ReadonlyVideoEffectsManager.1
      bool success = true;
      ::mojo::PendingRemote<VideoEffectsConfigurationObserver> p_observer{};
      ReadonlyVideoEffectsManager_AddObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ReadonlyVideoEffectsManager::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddObserver(        
        std::move(p_observer));
      return true;
    }
  }
  return false;
}

// static
bool ReadonlyVideoEffectsManagerStubDispatch::AcceptWithResponder(
    ReadonlyVideoEffectsManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ReadonlyVideoEffectsManager>(message->header()->name)) {
    case messages::ReadonlyVideoEffectsManager::kGetConfiguration: {
      internal::ReadonlyVideoEffectsManager_GetConfiguration_Params_Data* params =
          reinterpret_cast<
              internal::ReadonlyVideoEffectsManager_GetConfiguration_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for ReadonlyVideoEffectsManager.0
      bool success = true;
      ReadonlyVideoEffectsManager_GetConfiguration_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ReadonlyVideoEffectsManager::Name_, 0, false);
        return false;
      }
      ReadonlyVideoEffectsManager::GetConfigurationCallback callback =
          ReadonlyVideoEffectsManager_GetConfiguration_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetConfiguration(std::move(callback));
      return true;
    }
    case messages::ReadonlyVideoEffectsManager::kAddObserver: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kReadonlyVideoEffectsManagerValidationInfo[] = {
    {base::to_underlying(messages::ReadonlyVideoEffectsManager::kGetConfiguration),
     { &internal::ReadonlyVideoEffectsManager_GetConfiguration_Params_Data::Validate,
      &internal::ReadonlyVideoEffectsManager_GetConfiguration_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::ReadonlyVideoEffectsManager::kAddObserver),
     { &internal::ReadonlyVideoEffectsManager_AddObserver_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ReadonlyVideoEffectsManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::ReadonlyVideoEffectsManager::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kReadonlyVideoEffectsManagerValidationInfo);
}

bool ReadonlyVideoEffectsManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::ReadonlyVideoEffectsManager::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kReadonlyVideoEffectsManagerValidationInfo);

}


}  // media::mojom


namespace mojo {


// static
bool StructTraits<::media::mojom::ImageEnhancement::DataView, ::media::mojom::ImageEnhancementPtr>::Read(
    ::media::mojom::ImageEnhancement::DataView input,
    ::media::mojom::ImageEnhancementPtr* output) {
  bool success = true;
  ::media::mojom::ImageEnhancementPtr result(::media::mojom::ImageEnhancement::New());
  
      if (success)
        result->lighting = input.lighting();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::Blur::DataView, ::media::mojom::BlurPtr>::Read(
    ::media::mojom::Blur::DataView input,
    ::media::mojom::BlurPtr* output) {
  bool success = true;
  ::media::mojom::BlurPtr result(::media::mojom::Blur::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::Framing::DataView, ::media::mojom::FramingPtr>::Read(
    ::media::mojom::Framing::DataView input,
    ::media::mojom::FramingPtr* output) {
  bool success = true;
  ::media::mojom::FramingPtr result(::media::mojom::Framing::New());
  
      if (success && !input.ReadPaddingRatios(&result->padding_ratios))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::VideoEffectsConfiguration::DataView, ::media::mojom::VideoEffectsConfigurationPtr>::Read(
    ::media::mojom::VideoEffectsConfiguration::DataView input,
    ::media::mojom::VideoEffectsConfigurationPtr* output) {
  bool success = true;
  ::media::mojom::VideoEffectsConfigurationPtr result(::media::mojom::VideoEffectsConfiguration::New());
  
      if (success && !input.ReadImageEnhancement(&result->image_enhancement))
        success = false;
      if (success && !input.ReadBlur(&result->blur))
        success = false;
      if (success && !input.ReadFraming(&result->framing))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom {


void VideoEffectsConfigurationObserverInterceptorForTesting::OnConfigurationChanged(VideoEffectsConfigurationPtr configuration) {
  GetForwardingInterface()->OnConfigurationChanged(
    std::move(configuration)
    );
}
VideoEffectsConfigurationObserverAsyncWaiter::VideoEffectsConfigurationObserverAsyncWaiter(
    VideoEffectsConfigurationObserver* proxy) : proxy_(proxy) {}

VideoEffectsConfigurationObserverAsyncWaiter::~VideoEffectsConfigurationObserverAsyncWaiter() = default;




void ReadonlyVideoEffectsManagerInterceptorForTesting::GetConfiguration(GetConfigurationCallback callback) {
  GetForwardingInterface()->GetConfiguration(std::move(callback));
}
void ReadonlyVideoEffectsManagerInterceptorForTesting::AddObserver(::mojo::PendingRemote<VideoEffectsConfigurationObserver> observer) {
  GetForwardingInterface()->AddObserver(
    std::move(observer)
    );
}
ReadonlyVideoEffectsManagerAsyncWaiter::ReadonlyVideoEffectsManagerAsyncWaiter(
    ReadonlyVideoEffectsManager* proxy) : proxy_(proxy) {}

ReadonlyVideoEffectsManagerAsyncWaiter::~ReadonlyVideoEffectsManagerAsyncWaiter() = default;

void ReadonlyVideoEffectsManagerAsyncWaiter::GetConfiguration(
    VideoEffectsConfigurationPtr* out_configuration) {
  base::RunLoop loop;
  proxy_->GetConfiguration(
      base::BindOnce(
          [](base::RunLoop* loop,
             VideoEffectsConfigurationPtr* out_configuration
,
             VideoEffectsConfigurationPtr configuration) {*out_configuration = std::move(configuration);
            loop->Quit();
          },
          &loop,
          out_configuration));
  loop.Run();
}

VideoEffectsConfigurationPtr ReadonlyVideoEffectsManagerAsyncWaiter::GetConfiguration(
    ) {
  VideoEffectsConfigurationPtr async_wait_result;
  GetConfiguration(&async_wait_result);
  return async_wait_result;
}






}  // media::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif