// media/mojo/mojom/key_system_support.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_KEY_SYSTEM_SUPPORT_MOJOM_SHARED_H_
#define MEDIA_MOJO_MOJOM_KEY_SYSTEM_SUPPORT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/key_system_support.mojom-shared-internal.h"
#include "media/mojo/mojom/content_decryption_module.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"




namespace media::mojom {
class VideoCodecInfoDataView;

class CdmCapabilityDataView;

class KeySystemCapabilityDataView;



}  // media::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::VideoCodecInfoDataView> {
  using Data = ::media::mojom::internal::VideoCodecInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::CdmCapabilityDataView> {
  using Data = ::media::mojom::internal::CdmCapability_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::KeySystemCapabilityDataView> {
  using Data = ::media::mojom::internal::KeySystemCapability_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {


enum class CdmCapabilityQueryStatus : int32_t {
  
  kSuccess = 0,
  
  kUnknown = 1,
  
  kHardwareSecureCodecNotSupported = 2,
  
  kNoSupportedVideoCodec = 3,
  
  kNoSupportedEncryptionScheme = 4,
  
  kUnsupportedKeySystem = 5,
  
  kMediaFoundationCdmNotSupported = 6,
  
  kDisconnectionError = 7,
  
  kMediaFoundationGetCdmFactoryFailed = 8,
  
  kCreateDummyMediaFoundationCdmFailed = 9,
  
  kUnexpectedEmptyCapability = 10,
  kMinValue = 0,
  kMaxValue = 10,
};

 std::ostream& operator<<(std::ostream& os, CdmCapabilityQueryStatus value);
inline bool IsKnownEnumValue(CdmCapabilityQueryStatus value) {
  return internal::CdmCapabilityQueryStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class KeySystemSupportObserverInterfaceBase {};

using KeySystemSupportObserverPtrDataView =
    mojo::InterfacePtrDataView<KeySystemSupportObserverInterfaceBase>;
using KeySystemSupportObserverRequestDataView =
    mojo::InterfaceRequestDataView<KeySystemSupportObserverInterfaceBase>;
using KeySystemSupportObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<KeySystemSupportObserverInterfaceBase>;
using KeySystemSupportObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<KeySystemSupportObserverInterfaceBase>;
class KeySystemSupportInterfaceBase {};

using KeySystemSupportPtrDataView =
    mojo::InterfacePtrDataView<KeySystemSupportInterfaceBase>;
using KeySystemSupportRequestDataView =
    mojo::InterfaceRequestDataView<KeySystemSupportInterfaceBase>;
using KeySystemSupportAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<KeySystemSupportInterfaceBase>;
using KeySystemSupportAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<KeySystemSupportInterfaceBase>;


class VideoCodecInfoDataView {
 public:
  VideoCodecInfoDataView() = default;

  VideoCodecInfoDataView(
      internal::VideoCodecInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSupportedProfilesDataView(
      mojo::ArrayDataView<::media::mojom::VideoCodecProfile>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedProfiles(UserType* output) {
    
    auto* pointer = data_->supported_profiles.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::VideoCodecProfile>>(
        pointer, output, message_);
  }
  bool supports_clear_lead() const {
    return data_->supports_clear_lead;
  }
 private:
  internal::VideoCodecInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CdmCapabilityDataView {
 public:
  CdmCapabilityDataView() = default;

  CdmCapabilityDataView(
      internal::CdmCapability_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAudioCodecsDataView(
      mojo::ArrayDataView<::media::mojom::AudioCodec>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAudioCodecs(UserType* output) {
    
    auto* pointer = data_->audio_codecs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::AudioCodec>>(
        pointer, output, message_);
  }
  inline void GetVideoCodecsDataView(
      mojo::MapDataView<::media::mojom::VideoCodec, VideoCodecInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVideoCodecs(UserType* output) {
    
    auto* pointer = data_->video_codecs.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::media::mojom::VideoCodec, ::media::mojom::VideoCodecInfoDataView>>(
        pointer, output, message_);
  }
  inline void GetEncryptionSchemesDataView(
      mojo::ArrayDataView<::media::mojom::EncryptionScheme>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEncryptionSchemes(UserType* output) {
    
    auto* pointer = data_->encryption_schemes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::EncryptionScheme>>(
        pointer, output, message_);
  }
  inline void GetSessionTypesDataView(
      mojo::ArrayDataView<::media::mojom::CdmSessionType>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionTypes(UserType* output) {
    
    auto* pointer = data_->session_types.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::CdmSessionType>>(
        pointer, output, message_);
  }
 private:
  internal::CdmCapability_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class KeySystemCapabilityDataView {
 public:
  KeySystemCapabilityDataView() = default;

  KeySystemCapabilityDataView(
      internal::KeySystemCapability_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSwSecureCapabilityDataView(
      CdmCapabilityDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSwSecureCapability(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::CdmCapabilityDataView, UserType>(),
    "Attempting to read the optional `sw_secure_capability` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSwSecureCapability` instead "
    "of `ReadSwSecureCapability if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->sw_secure_capability.Get();
    return mojo::internal::Deserialize<::media::mojom::CdmCapabilityDataView>(
        pointer, output, message_);
  }
  inline void GetHwSecureCapabilityDataView(
      CdmCapabilityDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHwSecureCapability(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::CdmCapabilityDataView, UserType>(),
    "Attempting to read the optional `hw_secure_capability` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHwSecureCapability` instead "
    "of `ReadHwSecureCapability if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->hw_secure_capability.Get();
    return mojo::internal::Deserialize<::media::mojom::CdmCapabilityDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSwSecureCapabilityQueryStatus(UserType* output) const {
    if (!data_->sw_secure_capability_query_status_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::media::mojom::CdmCapabilityQueryStatus>(
        data_->sw_secure_capability_query_status_$value, &output->emplace());
  }
  std::optional<CdmCapabilityQueryStatus> sw_secure_capability_query_status() const {
    if (!data_->sw_secure_capability_query_status_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::CdmCapabilityQueryStatus>(data_->sw_secure_capability_query_status_$value));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadHwSecureCapabilityQueryStatus(UserType* output) const {
    if (!data_->hw_secure_capability_query_status_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::media::mojom::CdmCapabilityQueryStatus>(
        data_->hw_secure_capability_query_status_$value, &output->emplace());
  }
  std::optional<CdmCapabilityQueryStatus> hw_secure_capability_query_status() const {
    if (!data_->hw_secure_capability_query_status_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::CdmCapabilityQueryStatus>(data_->hw_secure_capability_query_status_$value));
  }
 private:
  internal::KeySystemCapability_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

namespace std {

template <>
struct hash<::media::mojom::CdmCapabilityQueryStatus>
    : public mojo::internal::EnumHashImpl<::media::mojom::CdmCapabilityQueryStatus> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::CdmCapabilityQueryStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::CdmCapabilityQueryStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::CdmCapabilityQueryStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoCodecInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoCodecInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoCodecInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::supported_profiles(input)) in_supported_profiles = Traits::supported_profiles(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->supported_profiles)::BaseType>
        supported_profiles_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& supported_profiles_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::VideoCodecProfile_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::VideoCodecProfile>>(
        in_supported_profiles, supported_profiles_fragment, &supported_profiles_validate_params);
    fragment->supported_profiles.Set(
        supported_profiles_fragment.is_null() ? nullptr : supported_profiles_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->supported_profiles.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null supported_profiles in VideoCodecInfo struct");
    fragment->supports_clear_lead = Traits::supports_clear_lead(input);
  }

  static bool Deserialize(::media::mojom::internal::VideoCodecInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoCodecInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::CdmCapabilityDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::CdmCapabilityDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::CdmCapability_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::audio_codecs(input)) in_audio_codecs = Traits::audio_codecs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->audio_codecs)::BaseType>
        audio_codecs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& audio_codecs_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::AudioCodec_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::AudioCodec>>(
        in_audio_codecs, audio_codecs_fragment, &audio_codecs_validate_params);
    fragment->audio_codecs.Set(
        audio_codecs_fragment.is_null() ? nullptr : audio_codecs_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->audio_codecs.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null audio_codecs in CdmCapability struct");
    decltype(Traits::video_codecs(input)) in_video_codecs = Traits::video_codecs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->video_codecs)::BaseType>
        video_codecs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& video_codecs_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::VideoCodec_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<::media::mojom::VideoCodec, ::media::mojom::VideoCodecInfoDataView>>(
        in_video_codecs, video_codecs_fragment, &video_codecs_validate_params);
    fragment->video_codecs.Set(
        video_codecs_fragment.is_null() ? nullptr : video_codecs_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->video_codecs.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null video_codecs in CdmCapability struct");
    decltype(Traits::encryption_schemes(input)) in_encryption_schemes = Traits::encryption_schemes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->encryption_schemes)::BaseType>
        encryption_schemes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& encryption_schemes_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::EncryptionScheme_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::EncryptionScheme>>(
        in_encryption_schemes, encryption_schemes_fragment, &encryption_schemes_validate_params);
    fragment->encryption_schemes.Set(
        encryption_schemes_fragment.is_null() ? nullptr : encryption_schemes_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->encryption_schemes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null encryption_schemes in CdmCapability struct");
    decltype(Traits::session_types(input)) in_session_types = Traits::session_types(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->session_types)::BaseType>
        session_types_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& session_types_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::CdmSessionType_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::CdmSessionType>>(
        in_session_types, session_types_fragment, &session_types_validate_params);
    fragment->session_types.Set(
        session_types_fragment.is_null() ? nullptr : session_types_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->session_types.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null session_types in CdmCapability struct");
  }

  static bool Deserialize(::media::mojom::internal::CdmCapability_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::CdmCapabilityDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::KeySystemCapabilityDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::KeySystemCapabilityDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::KeySystemCapability_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::sw_secure_capability(input)) in_sw_secure_capability = Traits::sw_secure_capability(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sw_secure_capability)::BaseType> sw_secure_capability_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::CdmCapabilityDataView>(
        in_sw_secure_capability, sw_secure_capability_fragment);
    fragment->sw_secure_capability.Set(
        sw_secure_capability_fragment.is_null() ? nullptr : sw_secure_capability_fragment.data());
    decltype(Traits::hw_secure_capability(input)) in_hw_secure_capability = Traits::hw_secure_capability(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hw_secure_capability)::BaseType> hw_secure_capability_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::CdmCapabilityDataView>(
        in_hw_secure_capability, hw_secure_capability_fragment);
    fragment->hw_secure_capability.Set(
        hw_secure_capability_fragment.is_null() ? nullptr : hw_secure_capability_fragment.data());
    fragment->sw_secure_capability_query_status_$flag = Traits::sw_secure_capability_query_status(input).has_value();
    if (Traits::sw_secure_capability_query_status(input).has_value()) {
      mojo::internal::Serialize<::media::mojom::CdmCapabilityQueryStatus>(
          Traits::sw_secure_capability_query_status(input).value(), &fragment->sw_secure_capability_query_status_$value);
    } else {
      fragment->sw_secure_capability_query_status_$value =
          static_cast<int32_t>(::media::mojom::CdmCapabilityQueryStatus::kMinValue);
    }
    fragment->hw_secure_capability_query_status_$flag = Traits::hw_secure_capability_query_status(input).has_value();
    if (Traits::hw_secure_capability_query_status(input).has_value()) {
      mojo::internal::Serialize<::media::mojom::CdmCapabilityQueryStatus>(
          Traits::hw_secure_capability_query_status(input).value(), &fragment->hw_secure_capability_query_status_$value);
    } else {
      fragment->hw_secure_capability_query_status_$value =
          static_cast<int32_t>(::media::mojom::CdmCapabilityQueryStatus::kMinValue);
    }
  }

  static bool Deserialize(::media::mojom::internal::KeySystemCapability_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::KeySystemCapabilityDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::mojom {

inline void VideoCodecInfoDataView::GetSupportedProfilesDataView(
    mojo::ArrayDataView<::media::mojom::VideoCodecProfile>* output) {
  auto pointer = data_->supported_profiles.Get();
  *output = mojo::ArrayDataView<::media::mojom::VideoCodecProfile>(pointer, message_);
}


inline void CdmCapabilityDataView::GetAudioCodecsDataView(
    mojo::ArrayDataView<::media::mojom::AudioCodec>* output) {
  auto pointer = data_->audio_codecs.Get();
  *output = mojo::ArrayDataView<::media::mojom::AudioCodec>(pointer, message_);
}
inline void CdmCapabilityDataView::GetVideoCodecsDataView(
    mojo::MapDataView<::media::mojom::VideoCodec, VideoCodecInfoDataView>* output) {
  auto pointer = data_->video_codecs.Get();
  *output = mojo::MapDataView<::media::mojom::VideoCodec, VideoCodecInfoDataView>(pointer, message_);
}
inline void CdmCapabilityDataView::GetEncryptionSchemesDataView(
    mojo::ArrayDataView<::media::mojom::EncryptionScheme>* output) {
  auto pointer = data_->encryption_schemes.Get();
  *output = mojo::ArrayDataView<::media::mojom::EncryptionScheme>(pointer, message_);
}
inline void CdmCapabilityDataView::GetSessionTypesDataView(
    mojo::ArrayDataView<::media::mojom::CdmSessionType>* output) {
  auto pointer = data_->session_types.Get();
  *output = mojo::ArrayDataView<::media::mojom::CdmSessionType>(pointer, message_);
}


inline void KeySystemCapabilityDataView::GetSwSecureCapabilityDataView(
    CdmCapabilityDataView* output) {
  auto pointer = data_->sw_secure_capability.Get();
  *output = CdmCapabilityDataView(pointer, message_);
}
inline void KeySystemCapabilityDataView::GetHwSecureCapabilityDataView(
    CdmCapabilityDataView* output) {
  auto pointer = data_->hw_secure_capability.Get();
  *output = CdmCapabilityDataView(pointer, message_);
}



}  // media::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::CdmCapabilityQueryStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::CdmCapabilityQueryStatus value);
};

} // namespace perfetto

#endif  // MEDIA_MOJO_MOJOM_KEY_SYSTEM_SUPPORT_MOJOM_SHARED_H_