// services/network/public/mojom/transferable_directory.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/transferable_directory.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/transferable_directory.mojom-params-data.h"
namespace network {
namespace mojom {

namespace internal {
// static
bool TransferableDirectory_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const TransferableDirectory_Data* object = static_cast<const TransferableDirectory_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case TransferableDirectory_Tag::kHandleForIpc: {

      if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
              object->data.f_handle_for_ipc, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateHandleOrInterface(object->data.f_handle_for_ipc,
                                                     validation_context)) {
        return false;
      }
      return true;
    }
    case TransferableDirectory_Tag::kPath: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_path, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_path, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in TransferableDirectory");
      return false;
    }
  }
}

}  // namespace internal
}  // namespace mojom
}  // namespace network