// services/viz/public/mojom/compositing/layer.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_MOJOM_BLINK_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/layer.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/layer.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/layer.mojom-blink-forward.h"  // IWYU pragma: export
#include "cc/mojom/element_id.mojom-blink.h"
#include "cc/mojom/layer_type.mojom-blink-forward.h"
#include "skia/public/mojom/skcolor4f.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "ui/gfx/mojom/transform.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace viz::mojom::blink {















class BLINK_PLATFORM_EXPORT Layer {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Layer, T>::value>;
  using DataView = LayerDataView;
  using Data_ = internal::Layer_Data;

  template <typename... Args>
  static LayerPtr New(Args&&... args) {
    return LayerPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LayerPtr From(const U& u) {
    return mojo::TypeConverter<LayerPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Layer>::Convert(*this);
  }


  Layer();

  Layer(
      int64_t id,
      ::cc::mojom::blink::LayerType type,
      const ::gfx::Size& bounds,
      bool contents_opaque,
      bool contents_opaque_for_text,
      bool is_drawable,
      const ::SkColor4f& background_color,
      const ::SkColor4f& safe_opaque_background_color,
      ::cc::mojom::blink::ElementIdPtr element_id,
      const ::gfx::Rect& update_rect,
      const ::gfx::Vector2dF& offset_to_transform_parent,
      int32_t transform_tree_index,
      int32_t clip_tree_index,
      int32_t effect_tree_index,
      int32_t scroll_tree_index);

Layer(const Layer&) = delete;
Layer& operator=(const Layer&) = delete;

  ~Layer();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LayerPtr>
  LayerPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Layer::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Layer::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Layer::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Layer::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Layer::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Layer_UnserializedMessageContext<
            UserType, Layer::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Layer::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Layer::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Layer_UnserializedMessageContext<
            UserType, Layer::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Layer::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t id;
  
  ::cc::mojom::blink::LayerType type;
  
  ::gfx::Size bounds;
  
  bool contents_opaque;
  
  bool contents_opaque_for_text;
  
  bool is_drawable;
  
  ::SkColor4f background_color;
  
  ::SkColor4f safe_opaque_background_color;
  
  ::cc::mojom::blink::ElementIdPtr element_id;
  
  ::gfx::Rect update_rect;
  
  ::gfx::Vector2dF offset_to_transform_parent;
  
  int32_t transform_tree_index;
  
  int32_t clip_tree_index;
  
  int32_t effect_tree_index;
  
  int32_t scroll_tree_index;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Layer::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Layer::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Layer::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Layer::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT AnchorPositionScrollData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AnchorPositionScrollData, T>::value>;
  using DataView = AnchorPositionScrollDataDataView;
  using Data_ = internal::AnchorPositionScrollData_Data;

  template <typename... Args>
  static AnchorPositionScrollDataPtr New(Args&&... args) {
    return AnchorPositionScrollDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AnchorPositionScrollDataPtr From(const U& u) {
    return mojo::TypeConverter<AnchorPositionScrollDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AnchorPositionScrollData>::Convert(*this);
  }


  AnchorPositionScrollData();

  AnchorPositionScrollData(
      WTF::Vector<::cc::mojom::blink::ElementIdPtr> adjustment_container_ids,
      const ::gfx::Vector2d& accumulated_scroll_origin,
      bool needs_scroll_adjustment_in_x,
      bool needs_scroll_adjustment_in_y);

AnchorPositionScrollData(const AnchorPositionScrollData&) = delete;
AnchorPositionScrollData& operator=(const AnchorPositionScrollData&) = delete;

  ~AnchorPositionScrollData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AnchorPositionScrollDataPtr>
  AnchorPositionScrollDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AnchorPositionScrollData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AnchorPositionScrollData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AnchorPositionScrollData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnchorPositionScrollData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AnchorPositionScrollData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AnchorPositionScrollData_UnserializedMessageContext<
            UserType, AnchorPositionScrollData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AnchorPositionScrollData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AnchorPositionScrollData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AnchorPositionScrollData_UnserializedMessageContext<
            UserType, AnchorPositionScrollData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AnchorPositionScrollData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WTF::Vector<::cc::mojom::blink::ElementIdPtr> adjustment_container_ids;
  
  ::gfx::Vector2d accumulated_scroll_origin;
  
  bool needs_scroll_adjustment_in_x;
  
  bool needs_scroll_adjustment_in_y;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AnchorPositionScrollData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AnchorPositionScrollData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AnchorPositionScrollData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AnchorPositionScrollData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT StickyPositionNodeData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StickyPositionNodeData, T>::value>;
  using DataView = StickyPositionNodeDataDataView;
  using Data_ = internal::StickyPositionNodeData_Data;

  template <typename... Args>
  static StickyPositionNodeDataPtr New(Args&&... args) {
    return StickyPositionNodeDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StickyPositionNodeDataPtr From(const U& u) {
    return mojo::TypeConverter<StickyPositionNodeDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StickyPositionNodeData>::Convert(*this);
  }


  StickyPositionNodeData();

  StickyPositionNodeData(
      int32_t scroll_ancestor,
      bool is_anchored_left,
      bool is_anchored_right,
      bool is_anchored_top,
      bool is_anchored_bottom,
      float left_offset,
      float right_offset,
      float top_offset,
      float bottom_offset,
      const ::gfx::RectF& constraint_box_rect,
      const ::gfx::RectF& scroll_container_relative_sticky_box_rect,
      const ::gfx::RectF& scroll_container_relative_containing_block_rect,
      int32_t nearest_node_shifting_sticky_box,
      int32_t nearest_node_shifting_containing_block,
      const ::gfx::Vector2dF& total_sticky_box_sticky_offset,
      const ::gfx::Vector2dF& total_containing_block_sticky_offset);


  ~StickyPositionNodeData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StickyPositionNodeDataPtr>
  StickyPositionNodeDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StickyPositionNodeData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, StickyPositionNodeData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, StickyPositionNodeData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StickyPositionNodeData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StickyPositionNodeData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StickyPositionNodeData_UnserializedMessageContext<
            UserType, StickyPositionNodeData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<StickyPositionNodeData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return StickyPositionNodeData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StickyPositionNodeData_UnserializedMessageContext<
            UserType, StickyPositionNodeData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StickyPositionNodeData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t scroll_ancestor;
  
  bool is_anchored_left;
  
  bool is_anchored_right;
  
  bool is_anchored_top;
  
  bool is_anchored_bottom;
  
  float left_offset;
  
  float right_offset;
  
  float top_offset;
  
  float bottom_offset;
  
  ::gfx::RectF constraint_box_rect;
  
  ::gfx::RectF scroll_container_relative_sticky_box_rect;
  
  ::gfx::RectF scroll_container_relative_containing_block_rect;
  
  int32_t nearest_node_shifting_sticky_box;
  
  int32_t nearest_node_shifting_containing_block;
  
  ::gfx::Vector2dF total_sticky_box_sticky_offset;
  
  ::gfx::Vector2dF total_containing_block_sticky_offset;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StickyPositionNodeData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StickyPositionNodeData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StickyPositionNodeData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StickyPositionNodeData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT TransformTreeUpdate {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TransformTreeUpdate, T>::value>;
  using DataView = TransformTreeUpdateDataView;
  using Data_ = internal::TransformTreeUpdate_Data;

  template <typename... Args>
  static TransformTreeUpdatePtr New(Args&&... args) {
    return TransformTreeUpdatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TransformTreeUpdatePtr From(const U& u) {
    return mojo::TypeConverter<TransformTreeUpdatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TransformTreeUpdate>::Convert(*this);
  }


  TransformTreeUpdate();

  TransformTreeUpdate(
      float page_scale_factor,
      float device_scale_factor,
      float device_transform_scale_factor,
      WTF::Vector<int32_t> nodes_affected_by_outer_viewport_bounds_delta,
      WTF::Vector<StickyPositionNodeDataPtr> sticky_position_data,
      WTF::Vector<AnchorPositionScrollDataPtr> anchor_position_scroll_data);

TransformTreeUpdate(const TransformTreeUpdate&) = delete;
TransformTreeUpdate& operator=(const TransformTreeUpdate&) = delete;

  ~TransformTreeUpdate();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TransformTreeUpdatePtr>
  TransformTreeUpdatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TransformTreeUpdate::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TransformTreeUpdate::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TransformTreeUpdate::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TransformTreeUpdate::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TransformTreeUpdate::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TransformTreeUpdate_UnserializedMessageContext<
            UserType, TransformTreeUpdate::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TransformTreeUpdate::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TransformTreeUpdate::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TransformTreeUpdate_UnserializedMessageContext<
            UserType, TransformTreeUpdate::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TransformTreeUpdate::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float page_scale_factor;
  
  float device_scale_factor;
  
  float device_transform_scale_factor;
  
  WTF::Vector<int32_t> nodes_affected_by_outer_viewport_bounds_delta;
  
  WTF::Vector<StickyPositionNodeDataPtr> sticky_position_data;
  
  WTF::Vector<AnchorPositionScrollDataPtr> anchor_position_scroll_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TransformTreeUpdate::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TransformTreeUpdate::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TransformTreeUpdate::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TransformTreeUpdate::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT TransformNode {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TransformNode, T>::value>;
  using DataView = TransformNodeDataView;
  using Data_ = internal::TransformNode_Data;

  template <typename... Args>
  static TransformNodePtr New(Args&&... args) {
    return TransformNodePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TransformNodePtr From(const U& u) {
    return mojo::TypeConverter<TransformNodePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TransformNode>::Convert(*this);
  }


  TransformNode();

  TransformNode(
      int32_t id,
      int32_t parent_id,
      int32_t parent_frame_id,
      ::cc::mojom::blink::ElementIdPtr element_id,
      const ::gfx::Transform& local,
      const ::gfx::Point3F& origin,
      const ::gfx::PointF& scroll_offset,
      const ::gfx::Vector2dF& snap_amount,
      std::optional<uint32_t> sticky_position_constraint_id,
      std::optional<uint32_t> anchor_position_scroll_data_id,
      int32_t sorting_context_id,
      bool has_potential_animation,
      bool is_currently_animating,
      bool flattens_inherited_transform,
      bool scrolls,
      bool should_undo_overscroll,
      bool should_be_snapped,
      bool moved_by_outer_viewport_bounds_delta_y,
      bool in_subtree_of_page_scale_layer,
      bool transform_changed,
      bool delegates_to_parent_for_backface,
      bool will_change_transform,
      ::cc::mojom::blink::ElementIdPtr visible_frame_element_id);

TransformNode(const TransformNode&) = delete;
TransformNode& operator=(const TransformNode&) = delete;

  ~TransformNode();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TransformNodePtr>
  TransformNodePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TransformNode::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TransformNode::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TransformNode::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TransformNode::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TransformNode::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TransformNode_UnserializedMessageContext<
            UserType, TransformNode::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TransformNode::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TransformNode::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TransformNode_UnserializedMessageContext<
            UserType, TransformNode::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TransformNode::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t id;
  
  int32_t parent_id;
  
  int32_t parent_frame_id;
  
  ::cc::mojom::blink::ElementIdPtr element_id;
  
  ::gfx::Transform local;
  
  ::gfx::Point3F origin;
  
  ::gfx::PointF scroll_offset;
  
  ::gfx::Vector2dF snap_amount;
  
  std::optional<uint32_t> sticky_position_constraint_id;
  
  std::optional<uint32_t> anchor_position_scroll_data_id;
  
  int32_t sorting_context_id;
  
  bool has_potential_animation;
  
  bool is_currently_animating;
  
  bool flattens_inherited_transform;
  
  bool scrolls;
  
  bool should_undo_overscroll;
  
  bool should_be_snapped;
  
  bool moved_by_outer_viewport_bounds_delta_y;
  
  bool in_subtree_of_page_scale_layer;
  
  bool transform_changed;
  
  bool delegates_to_parent_for_backface;
  
  bool will_change_transform;
  
  ::cc::mojom::blink::ElementIdPtr visible_frame_element_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TransformNode::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TransformNode::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TransformNode::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TransformNode::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT ClipNode {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ClipNode, T>::value>;
  using DataView = ClipNodeDataView;
  using Data_ = internal::ClipNode_Data;

  template <typename... Args>
  static ClipNodePtr New(Args&&... args) {
    return ClipNodePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ClipNodePtr From(const U& u) {
    return mojo::TypeConverter<ClipNodePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ClipNode>::Convert(*this);
  }


  ClipNode();

  ClipNode(
      int32_t id,
      int32_t parent_id,
      int32_t transform_id,
      const ::gfx::RectF& clip,
      int32_t pixel_moving_filter_id);


  ~ClipNode();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ClipNodePtr>
  ClipNodePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ClipNode::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ClipNode::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ClipNode::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClipNode::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ClipNode::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ClipNode_UnserializedMessageContext<
            UserType, ClipNode::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ClipNode::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ClipNode::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ClipNode_UnserializedMessageContext<
            UserType, ClipNode::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ClipNode::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t id;
  
  int32_t parent_id;
  
  int32_t transform_id;
  
  ::gfx::RectF clip;
  
  int32_t pixel_moving_filter_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ClipNode::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ClipNode::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ClipNode::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ClipNode::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT EffectNode {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EffectNode, T>::value>;
  using DataView = EffectNodeDataView;
  using Data_ = internal::EffectNode_Data;

  template <typename... Args>
  static EffectNodePtr New(Args&&... args) {
    return EffectNodePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EffectNodePtr From(const U& u) {
    return mojo::TypeConverter<EffectNodePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EffectNode>::Convert(*this);
  }


  EffectNode();

  EffectNode(
      int32_t id,
      int32_t parent_id,
      int32_t transform_id,
      int32_t clip_id,
      ::cc::mojom::blink::ElementIdPtr element_id,
      float opacity,
      bool has_render_surface,
      const ::gfx::Vector2dF& surface_contents_scale,
      uint32_t blend_mode,
      int32_t target_id);

EffectNode(const EffectNode&) = delete;
EffectNode& operator=(const EffectNode&) = delete;

  ~EffectNode();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EffectNodePtr>
  EffectNodePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EffectNode::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EffectNode::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EffectNode::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EffectNode::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EffectNode::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EffectNode_UnserializedMessageContext<
            UserType, EffectNode::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EffectNode::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EffectNode::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EffectNode_UnserializedMessageContext<
            UserType, EffectNode::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EffectNode::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t id;
  
  int32_t parent_id;
  
  int32_t transform_id;
  
  int32_t clip_id;
  
  ::cc::mojom::blink::ElementIdPtr element_id;
  
  float opacity;
  
  bool has_render_surface;
  
  ::gfx::Vector2dF surface_contents_scale;
  
  uint32_t blend_mode;
  
  int32_t target_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EffectNode::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EffectNode::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EffectNode::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EffectNode::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT ScrollNode {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScrollNode, T>::value>;
  using DataView = ScrollNodeDataView;
  using Data_ = internal::ScrollNode_Data;

  template <typename... Args>
  static ScrollNodePtr New(Args&&... args) {
    return ScrollNodePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScrollNodePtr From(const U& u) {
    return mojo::TypeConverter<ScrollNodePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScrollNode>::Convert(*this);
  }


  ScrollNode();

  ScrollNode(
      int32_t id,
      int32_t parent_id,
      int32_t transform_id,
      const ::gfx::Size& container_bounds,
      const ::gfx::Size& bounds,
      ::cc::mojom::blink::ElementIdPtr element_id,
      bool max_scroll_offset_affected_by_page_scale,
      bool scrolls_inner_viewport,
      bool scrolls_outer_viewport,
      bool prevent_viewport_scrolling_from_inner,
      bool user_scrollable_horizontal,
      bool user_scrollable_vertical,
      bool is_composited);

ScrollNode(const ScrollNode&) = delete;
ScrollNode& operator=(const ScrollNode&) = delete;

  ~ScrollNode();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScrollNodePtr>
  ScrollNodePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScrollNode::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ScrollNode::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ScrollNode::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollNode::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScrollNode::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScrollNode_UnserializedMessageContext<
            UserType, ScrollNode::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ScrollNode::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ScrollNode::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScrollNode_UnserializedMessageContext<
            UserType, ScrollNode::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScrollNode::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t id;
  
  int32_t parent_id;
  
  int32_t transform_id;
  
  ::gfx::Size container_bounds;
  
  ::gfx::Size bounds;
  
  ::cc::mojom::blink::ElementIdPtr element_id;
  
  bool max_scroll_offset_affected_by_page_scale;
  
  bool scrolls_inner_viewport;
  
  bool scrolls_outer_viewport;
  
  bool prevent_viewport_scrolling_from_inner;
  
  bool user_scrollable_horizontal;
  
  bool user_scrollable_vertical;
  
  bool is_composited;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScrollNode::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScrollNode::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScrollNode::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScrollNode::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
LayerPtr Layer::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(type),
      mojo::Clone(bounds),
      mojo::Clone(contents_opaque),
      mojo::Clone(contents_opaque_for_text),
      mojo::Clone(is_drawable),
      mojo::Clone(background_color),
      mojo::Clone(safe_opaque_background_color),
      mojo::Clone(element_id),
      mojo::Clone(update_rect),
      mojo::Clone(offset_to_transform_parent),
      mojo::Clone(transform_tree_index),
      mojo::Clone(clip_tree_index),
      mojo::Clone(effect_tree_index),
      mojo::Clone(scroll_tree_index)
  );
}

template <typename T, Layer::EnableIfSame<T>*>
bool Layer::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->bounds, other_struct.bounds))
    return false;
  if (!mojo::Equals(this->contents_opaque, other_struct.contents_opaque))
    return false;
  if (!mojo::Equals(this->contents_opaque_for_text, other_struct.contents_opaque_for_text))
    return false;
  if (!mojo::Equals(this->is_drawable, other_struct.is_drawable))
    return false;
  if (!mojo::Equals(this->background_color, other_struct.background_color))
    return false;
  if (!mojo::Equals(this->safe_opaque_background_color, other_struct.safe_opaque_background_color))
    return false;
  if (!mojo::Equals(this->element_id, other_struct.element_id))
    return false;
  if (!mojo::Equals(this->update_rect, other_struct.update_rect))
    return false;
  if (!mojo::Equals(this->offset_to_transform_parent, other_struct.offset_to_transform_parent))
    return false;
  if (!mojo::Equals(this->transform_tree_index, other_struct.transform_tree_index))
    return false;
  if (!mojo::Equals(this->clip_tree_index, other_struct.clip_tree_index))
    return false;
  if (!mojo::Equals(this->effect_tree_index, other_struct.effect_tree_index))
    return false;
  if (!mojo::Equals(this->scroll_tree_index, other_struct.scroll_tree_index))
    return false;
  return true;
}

template <typename T, Layer::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.bounds < rhs.bounds)
    return true;
  if (rhs.bounds < lhs.bounds)
    return false;
  if (lhs.contents_opaque < rhs.contents_opaque)
    return true;
  if (rhs.contents_opaque < lhs.contents_opaque)
    return false;
  if (lhs.contents_opaque_for_text < rhs.contents_opaque_for_text)
    return true;
  if (rhs.contents_opaque_for_text < lhs.contents_opaque_for_text)
    return false;
  if (lhs.is_drawable < rhs.is_drawable)
    return true;
  if (rhs.is_drawable < lhs.is_drawable)
    return false;
  if (lhs.background_color < rhs.background_color)
    return true;
  if (rhs.background_color < lhs.background_color)
    return false;
  if (lhs.safe_opaque_background_color < rhs.safe_opaque_background_color)
    return true;
  if (rhs.safe_opaque_background_color < lhs.safe_opaque_background_color)
    return false;
  if (lhs.element_id < rhs.element_id)
    return true;
  if (rhs.element_id < lhs.element_id)
    return false;
  if (lhs.update_rect < rhs.update_rect)
    return true;
  if (rhs.update_rect < lhs.update_rect)
    return false;
  if (lhs.offset_to_transform_parent < rhs.offset_to_transform_parent)
    return true;
  if (rhs.offset_to_transform_parent < lhs.offset_to_transform_parent)
    return false;
  if (lhs.transform_tree_index < rhs.transform_tree_index)
    return true;
  if (rhs.transform_tree_index < lhs.transform_tree_index)
    return false;
  if (lhs.clip_tree_index < rhs.clip_tree_index)
    return true;
  if (rhs.clip_tree_index < lhs.clip_tree_index)
    return false;
  if (lhs.effect_tree_index < rhs.effect_tree_index)
    return true;
  if (rhs.effect_tree_index < lhs.effect_tree_index)
    return false;
  if (lhs.scroll_tree_index < rhs.scroll_tree_index)
    return true;
  if (rhs.scroll_tree_index < lhs.scroll_tree_index)
    return false;
  return false;
}
template <typename StructPtrType>
AnchorPositionScrollDataPtr AnchorPositionScrollData::Clone() const {
  return New(
      mojo::Clone(adjustment_container_ids),
      mojo::Clone(accumulated_scroll_origin),
      mojo::Clone(needs_scroll_adjustment_in_x),
      mojo::Clone(needs_scroll_adjustment_in_y)
  );
}

template <typename T, AnchorPositionScrollData::EnableIfSame<T>*>
bool AnchorPositionScrollData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->adjustment_container_ids, other_struct.adjustment_container_ids))
    return false;
  if (!mojo::Equals(this->accumulated_scroll_origin, other_struct.accumulated_scroll_origin))
    return false;
  if (!mojo::Equals(this->needs_scroll_adjustment_in_x, other_struct.needs_scroll_adjustment_in_x))
    return false;
  if (!mojo::Equals(this->needs_scroll_adjustment_in_y, other_struct.needs_scroll_adjustment_in_y))
    return false;
  return true;
}

template <typename T, AnchorPositionScrollData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.adjustment_container_ids < rhs.adjustment_container_ids)
    return true;
  if (rhs.adjustment_container_ids < lhs.adjustment_container_ids)
    return false;
  if (lhs.accumulated_scroll_origin < rhs.accumulated_scroll_origin)
    return true;
  if (rhs.accumulated_scroll_origin < lhs.accumulated_scroll_origin)
    return false;
  if (lhs.needs_scroll_adjustment_in_x < rhs.needs_scroll_adjustment_in_x)
    return true;
  if (rhs.needs_scroll_adjustment_in_x < lhs.needs_scroll_adjustment_in_x)
    return false;
  if (lhs.needs_scroll_adjustment_in_y < rhs.needs_scroll_adjustment_in_y)
    return true;
  if (rhs.needs_scroll_adjustment_in_y < lhs.needs_scroll_adjustment_in_y)
    return false;
  return false;
}
template <typename StructPtrType>
StickyPositionNodeDataPtr StickyPositionNodeData::Clone() const {
  return New(
      mojo::Clone(scroll_ancestor),
      mojo::Clone(is_anchored_left),
      mojo::Clone(is_anchored_right),
      mojo::Clone(is_anchored_top),
      mojo::Clone(is_anchored_bottom),
      mojo::Clone(left_offset),
      mojo::Clone(right_offset),
      mojo::Clone(top_offset),
      mojo::Clone(bottom_offset),
      mojo::Clone(constraint_box_rect),
      mojo::Clone(scroll_container_relative_sticky_box_rect),
      mojo::Clone(scroll_container_relative_containing_block_rect),
      mojo::Clone(nearest_node_shifting_sticky_box),
      mojo::Clone(nearest_node_shifting_containing_block),
      mojo::Clone(total_sticky_box_sticky_offset),
      mojo::Clone(total_containing_block_sticky_offset)
  );
}

template <typename T, StickyPositionNodeData::EnableIfSame<T>*>
bool StickyPositionNodeData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scroll_ancestor, other_struct.scroll_ancestor))
    return false;
  if (!mojo::Equals(this->is_anchored_left, other_struct.is_anchored_left))
    return false;
  if (!mojo::Equals(this->is_anchored_right, other_struct.is_anchored_right))
    return false;
  if (!mojo::Equals(this->is_anchored_top, other_struct.is_anchored_top))
    return false;
  if (!mojo::Equals(this->is_anchored_bottom, other_struct.is_anchored_bottom))
    return false;
  if (!mojo::Equals(this->left_offset, other_struct.left_offset))
    return false;
  if (!mojo::Equals(this->right_offset, other_struct.right_offset))
    return false;
  if (!mojo::Equals(this->top_offset, other_struct.top_offset))
    return false;
  if (!mojo::Equals(this->bottom_offset, other_struct.bottom_offset))
    return false;
  if (!mojo::Equals(this->constraint_box_rect, other_struct.constraint_box_rect))
    return false;
  if (!mojo::Equals(this->scroll_container_relative_sticky_box_rect, other_struct.scroll_container_relative_sticky_box_rect))
    return false;
  if (!mojo::Equals(this->scroll_container_relative_containing_block_rect, other_struct.scroll_container_relative_containing_block_rect))
    return false;
  if (!mojo::Equals(this->nearest_node_shifting_sticky_box, other_struct.nearest_node_shifting_sticky_box))
    return false;
  if (!mojo::Equals(this->nearest_node_shifting_containing_block, other_struct.nearest_node_shifting_containing_block))
    return false;
  if (!mojo::Equals(this->total_sticky_box_sticky_offset, other_struct.total_sticky_box_sticky_offset))
    return false;
  if (!mojo::Equals(this->total_containing_block_sticky_offset, other_struct.total_containing_block_sticky_offset))
    return false;
  return true;
}

template <typename T, StickyPositionNodeData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.scroll_ancestor < rhs.scroll_ancestor)
    return true;
  if (rhs.scroll_ancestor < lhs.scroll_ancestor)
    return false;
  if (lhs.is_anchored_left < rhs.is_anchored_left)
    return true;
  if (rhs.is_anchored_left < lhs.is_anchored_left)
    return false;
  if (lhs.is_anchored_right < rhs.is_anchored_right)
    return true;
  if (rhs.is_anchored_right < lhs.is_anchored_right)
    return false;
  if (lhs.is_anchored_top < rhs.is_anchored_top)
    return true;
  if (rhs.is_anchored_top < lhs.is_anchored_top)
    return false;
  if (lhs.is_anchored_bottom < rhs.is_anchored_bottom)
    return true;
  if (rhs.is_anchored_bottom < lhs.is_anchored_bottom)
    return false;
  if (lhs.left_offset < rhs.left_offset)
    return true;
  if (rhs.left_offset < lhs.left_offset)
    return false;
  if (lhs.right_offset < rhs.right_offset)
    return true;
  if (rhs.right_offset < lhs.right_offset)
    return false;
  if (lhs.top_offset < rhs.top_offset)
    return true;
  if (rhs.top_offset < lhs.top_offset)
    return false;
  if (lhs.bottom_offset < rhs.bottom_offset)
    return true;
  if (rhs.bottom_offset < lhs.bottom_offset)
    return false;
  if (lhs.constraint_box_rect < rhs.constraint_box_rect)
    return true;
  if (rhs.constraint_box_rect < lhs.constraint_box_rect)
    return false;
  if (lhs.scroll_container_relative_sticky_box_rect < rhs.scroll_container_relative_sticky_box_rect)
    return true;
  if (rhs.scroll_container_relative_sticky_box_rect < lhs.scroll_container_relative_sticky_box_rect)
    return false;
  if (lhs.scroll_container_relative_containing_block_rect < rhs.scroll_container_relative_containing_block_rect)
    return true;
  if (rhs.scroll_container_relative_containing_block_rect < lhs.scroll_container_relative_containing_block_rect)
    return false;
  if (lhs.nearest_node_shifting_sticky_box < rhs.nearest_node_shifting_sticky_box)
    return true;
  if (rhs.nearest_node_shifting_sticky_box < lhs.nearest_node_shifting_sticky_box)
    return false;
  if (lhs.nearest_node_shifting_containing_block < rhs.nearest_node_shifting_containing_block)
    return true;
  if (rhs.nearest_node_shifting_containing_block < lhs.nearest_node_shifting_containing_block)
    return false;
  if (lhs.total_sticky_box_sticky_offset < rhs.total_sticky_box_sticky_offset)
    return true;
  if (rhs.total_sticky_box_sticky_offset < lhs.total_sticky_box_sticky_offset)
    return false;
  if (lhs.total_containing_block_sticky_offset < rhs.total_containing_block_sticky_offset)
    return true;
  if (rhs.total_containing_block_sticky_offset < lhs.total_containing_block_sticky_offset)
    return false;
  return false;
}
template <typename StructPtrType>
TransformTreeUpdatePtr TransformTreeUpdate::Clone() const {
  return New(
      mojo::Clone(page_scale_factor),
      mojo::Clone(device_scale_factor),
      mojo::Clone(device_transform_scale_factor),
      mojo::Clone(nodes_affected_by_outer_viewport_bounds_delta),
      mojo::Clone(sticky_position_data),
      mojo::Clone(anchor_position_scroll_data)
  );
}

template <typename T, TransformTreeUpdate::EnableIfSame<T>*>
bool TransformTreeUpdate::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->page_scale_factor, other_struct.page_scale_factor))
    return false;
  if (!mojo::Equals(this->device_scale_factor, other_struct.device_scale_factor))
    return false;
  if (!mojo::Equals(this->device_transform_scale_factor, other_struct.device_transform_scale_factor))
    return false;
  if (!mojo::Equals(this->nodes_affected_by_outer_viewport_bounds_delta, other_struct.nodes_affected_by_outer_viewport_bounds_delta))
    return false;
  if (!mojo::Equals(this->sticky_position_data, other_struct.sticky_position_data))
    return false;
  if (!mojo::Equals(this->anchor_position_scroll_data, other_struct.anchor_position_scroll_data))
    return false;
  return true;
}

template <typename T, TransformTreeUpdate::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.page_scale_factor < rhs.page_scale_factor)
    return true;
  if (rhs.page_scale_factor < lhs.page_scale_factor)
    return false;
  if (lhs.device_scale_factor < rhs.device_scale_factor)
    return true;
  if (rhs.device_scale_factor < lhs.device_scale_factor)
    return false;
  if (lhs.device_transform_scale_factor < rhs.device_transform_scale_factor)
    return true;
  if (rhs.device_transform_scale_factor < lhs.device_transform_scale_factor)
    return false;
  if (lhs.nodes_affected_by_outer_viewport_bounds_delta < rhs.nodes_affected_by_outer_viewport_bounds_delta)
    return true;
  if (rhs.nodes_affected_by_outer_viewport_bounds_delta < lhs.nodes_affected_by_outer_viewport_bounds_delta)
    return false;
  if (lhs.sticky_position_data < rhs.sticky_position_data)
    return true;
  if (rhs.sticky_position_data < lhs.sticky_position_data)
    return false;
  if (lhs.anchor_position_scroll_data < rhs.anchor_position_scroll_data)
    return true;
  if (rhs.anchor_position_scroll_data < lhs.anchor_position_scroll_data)
    return false;
  return false;
}
template <typename StructPtrType>
TransformNodePtr TransformNode::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(parent_id),
      mojo::Clone(parent_frame_id),
      mojo::Clone(element_id),
      mojo::Clone(local),
      mojo::Clone(origin),
      mojo::Clone(scroll_offset),
      mojo::Clone(snap_amount),
      mojo::Clone(sticky_position_constraint_id),
      mojo::Clone(anchor_position_scroll_data_id),
      mojo::Clone(sorting_context_id),
      mojo::Clone(has_potential_animation),
      mojo::Clone(is_currently_animating),
      mojo::Clone(flattens_inherited_transform),
      mojo::Clone(scrolls),
      mojo::Clone(should_undo_overscroll),
      mojo::Clone(should_be_snapped),
      mojo::Clone(moved_by_outer_viewport_bounds_delta_y),
      mojo::Clone(in_subtree_of_page_scale_layer),
      mojo::Clone(transform_changed),
      mojo::Clone(delegates_to_parent_for_backface),
      mojo::Clone(will_change_transform),
      mojo::Clone(visible_frame_element_id)
  );
}

template <typename T, TransformNode::EnableIfSame<T>*>
bool TransformNode::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->parent_id, other_struct.parent_id))
    return false;
  if (!mojo::Equals(this->parent_frame_id, other_struct.parent_frame_id))
    return false;
  if (!mojo::Equals(this->element_id, other_struct.element_id))
    return false;
  if (!mojo::Equals(this->local, other_struct.local))
    return false;
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->scroll_offset, other_struct.scroll_offset))
    return false;
  if (!mojo::Equals(this->snap_amount, other_struct.snap_amount))
    return false;
  if (!mojo::Equals(this->sticky_position_constraint_id, other_struct.sticky_position_constraint_id))
    return false;
  if (!mojo::Equals(this->anchor_position_scroll_data_id, other_struct.anchor_position_scroll_data_id))
    return false;
  if (!mojo::Equals(this->sorting_context_id, other_struct.sorting_context_id))
    return false;
  if (!mojo::Equals(this->has_potential_animation, other_struct.has_potential_animation))
    return false;
  if (!mojo::Equals(this->is_currently_animating, other_struct.is_currently_animating))
    return false;
  if (!mojo::Equals(this->flattens_inherited_transform, other_struct.flattens_inherited_transform))
    return false;
  if (!mojo::Equals(this->scrolls, other_struct.scrolls))
    return false;
  if (!mojo::Equals(this->should_undo_overscroll, other_struct.should_undo_overscroll))
    return false;
  if (!mojo::Equals(this->should_be_snapped, other_struct.should_be_snapped))
    return false;
  if (!mojo::Equals(this->moved_by_outer_viewport_bounds_delta_y, other_struct.moved_by_outer_viewport_bounds_delta_y))
    return false;
  if (!mojo::Equals(this->in_subtree_of_page_scale_layer, other_struct.in_subtree_of_page_scale_layer))
    return false;
  if (!mojo::Equals(this->transform_changed, other_struct.transform_changed))
    return false;
  if (!mojo::Equals(this->delegates_to_parent_for_backface, other_struct.delegates_to_parent_for_backface))
    return false;
  if (!mojo::Equals(this->will_change_transform, other_struct.will_change_transform))
    return false;
  if (!mojo::Equals(this->visible_frame_element_id, other_struct.visible_frame_element_id))
    return false;
  return true;
}

template <typename T, TransformNode::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.parent_id < rhs.parent_id)
    return true;
  if (rhs.parent_id < lhs.parent_id)
    return false;
  if (lhs.parent_frame_id < rhs.parent_frame_id)
    return true;
  if (rhs.parent_frame_id < lhs.parent_frame_id)
    return false;
  if (lhs.element_id < rhs.element_id)
    return true;
  if (rhs.element_id < lhs.element_id)
    return false;
  if (lhs.local < rhs.local)
    return true;
  if (rhs.local < lhs.local)
    return false;
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  if (lhs.scroll_offset < rhs.scroll_offset)
    return true;
  if (rhs.scroll_offset < lhs.scroll_offset)
    return false;
  if (lhs.snap_amount < rhs.snap_amount)
    return true;
  if (rhs.snap_amount < lhs.snap_amount)
    return false;
  if (lhs.sticky_position_constraint_id < rhs.sticky_position_constraint_id)
    return true;
  if (rhs.sticky_position_constraint_id < lhs.sticky_position_constraint_id)
    return false;
  if (lhs.anchor_position_scroll_data_id < rhs.anchor_position_scroll_data_id)
    return true;
  if (rhs.anchor_position_scroll_data_id < lhs.anchor_position_scroll_data_id)
    return false;
  if (lhs.sorting_context_id < rhs.sorting_context_id)
    return true;
  if (rhs.sorting_context_id < lhs.sorting_context_id)
    return false;
  if (lhs.has_potential_animation < rhs.has_potential_animation)
    return true;
  if (rhs.has_potential_animation < lhs.has_potential_animation)
    return false;
  if (lhs.is_currently_animating < rhs.is_currently_animating)
    return true;
  if (rhs.is_currently_animating < lhs.is_currently_animating)
    return false;
  if (lhs.flattens_inherited_transform < rhs.flattens_inherited_transform)
    return true;
  if (rhs.flattens_inherited_transform < lhs.flattens_inherited_transform)
    return false;
  if (lhs.scrolls < rhs.scrolls)
    return true;
  if (rhs.scrolls < lhs.scrolls)
    return false;
  if (lhs.should_undo_overscroll < rhs.should_undo_overscroll)
    return true;
  if (rhs.should_undo_overscroll < lhs.should_undo_overscroll)
    return false;
  if (lhs.should_be_snapped < rhs.should_be_snapped)
    return true;
  if (rhs.should_be_snapped < lhs.should_be_snapped)
    return false;
  if (lhs.moved_by_outer_viewport_bounds_delta_y < rhs.moved_by_outer_viewport_bounds_delta_y)
    return true;
  if (rhs.moved_by_outer_viewport_bounds_delta_y < lhs.moved_by_outer_viewport_bounds_delta_y)
    return false;
  if (lhs.in_subtree_of_page_scale_layer < rhs.in_subtree_of_page_scale_layer)
    return true;
  if (rhs.in_subtree_of_page_scale_layer < lhs.in_subtree_of_page_scale_layer)
    return false;
  if (lhs.transform_changed < rhs.transform_changed)
    return true;
  if (rhs.transform_changed < lhs.transform_changed)
    return false;
  if (lhs.delegates_to_parent_for_backface < rhs.delegates_to_parent_for_backface)
    return true;
  if (rhs.delegates_to_parent_for_backface < lhs.delegates_to_parent_for_backface)
    return false;
  if (lhs.will_change_transform < rhs.will_change_transform)
    return true;
  if (rhs.will_change_transform < lhs.will_change_transform)
    return false;
  if (lhs.visible_frame_element_id < rhs.visible_frame_element_id)
    return true;
  if (rhs.visible_frame_element_id < lhs.visible_frame_element_id)
    return false;
  return false;
}
template <typename StructPtrType>
ClipNodePtr ClipNode::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(parent_id),
      mojo::Clone(transform_id),
      mojo::Clone(clip),
      mojo::Clone(pixel_moving_filter_id)
  );
}

template <typename T, ClipNode::EnableIfSame<T>*>
bool ClipNode::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->parent_id, other_struct.parent_id))
    return false;
  if (!mojo::Equals(this->transform_id, other_struct.transform_id))
    return false;
  if (!mojo::Equals(this->clip, other_struct.clip))
    return false;
  if (!mojo::Equals(this->pixel_moving_filter_id, other_struct.pixel_moving_filter_id))
    return false;
  return true;
}

template <typename T, ClipNode::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.parent_id < rhs.parent_id)
    return true;
  if (rhs.parent_id < lhs.parent_id)
    return false;
  if (lhs.transform_id < rhs.transform_id)
    return true;
  if (rhs.transform_id < lhs.transform_id)
    return false;
  if (lhs.clip < rhs.clip)
    return true;
  if (rhs.clip < lhs.clip)
    return false;
  if (lhs.pixel_moving_filter_id < rhs.pixel_moving_filter_id)
    return true;
  if (rhs.pixel_moving_filter_id < lhs.pixel_moving_filter_id)
    return false;
  return false;
}
template <typename StructPtrType>
EffectNodePtr EffectNode::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(parent_id),
      mojo::Clone(transform_id),
      mojo::Clone(clip_id),
      mojo::Clone(element_id),
      mojo::Clone(opacity),
      mojo::Clone(has_render_surface),
      mojo::Clone(surface_contents_scale),
      mojo::Clone(blend_mode),
      mojo::Clone(target_id)
  );
}

template <typename T, EffectNode::EnableIfSame<T>*>
bool EffectNode::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->parent_id, other_struct.parent_id))
    return false;
  if (!mojo::Equals(this->transform_id, other_struct.transform_id))
    return false;
  if (!mojo::Equals(this->clip_id, other_struct.clip_id))
    return false;
  if (!mojo::Equals(this->element_id, other_struct.element_id))
    return false;
  if (!mojo::Equals(this->opacity, other_struct.opacity))
    return false;
  if (!mojo::Equals(this->has_render_surface, other_struct.has_render_surface))
    return false;
  if (!mojo::Equals(this->surface_contents_scale, other_struct.surface_contents_scale))
    return false;
  if (!mojo::Equals(this->blend_mode, other_struct.blend_mode))
    return false;
  if (!mojo::Equals(this->target_id, other_struct.target_id))
    return false;
  return true;
}

template <typename T, EffectNode::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.parent_id < rhs.parent_id)
    return true;
  if (rhs.parent_id < lhs.parent_id)
    return false;
  if (lhs.transform_id < rhs.transform_id)
    return true;
  if (rhs.transform_id < lhs.transform_id)
    return false;
  if (lhs.clip_id < rhs.clip_id)
    return true;
  if (rhs.clip_id < lhs.clip_id)
    return false;
  if (lhs.element_id < rhs.element_id)
    return true;
  if (rhs.element_id < lhs.element_id)
    return false;
  if (lhs.opacity < rhs.opacity)
    return true;
  if (rhs.opacity < lhs.opacity)
    return false;
  if (lhs.has_render_surface < rhs.has_render_surface)
    return true;
  if (rhs.has_render_surface < lhs.has_render_surface)
    return false;
  if (lhs.surface_contents_scale < rhs.surface_contents_scale)
    return true;
  if (rhs.surface_contents_scale < lhs.surface_contents_scale)
    return false;
  if (lhs.blend_mode < rhs.blend_mode)
    return true;
  if (rhs.blend_mode < lhs.blend_mode)
    return false;
  if (lhs.target_id < rhs.target_id)
    return true;
  if (rhs.target_id < lhs.target_id)
    return false;
  return false;
}
template <typename StructPtrType>
ScrollNodePtr ScrollNode::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(parent_id),
      mojo::Clone(transform_id),
      mojo::Clone(container_bounds),
      mojo::Clone(bounds),
      mojo::Clone(element_id),
      mojo::Clone(max_scroll_offset_affected_by_page_scale),
      mojo::Clone(scrolls_inner_viewport),
      mojo::Clone(scrolls_outer_viewport),
      mojo::Clone(prevent_viewport_scrolling_from_inner),
      mojo::Clone(user_scrollable_horizontal),
      mojo::Clone(user_scrollable_vertical),
      mojo::Clone(is_composited)
  );
}

template <typename T, ScrollNode::EnableIfSame<T>*>
bool ScrollNode::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->parent_id, other_struct.parent_id))
    return false;
  if (!mojo::Equals(this->transform_id, other_struct.transform_id))
    return false;
  if (!mojo::Equals(this->container_bounds, other_struct.container_bounds))
    return false;
  if (!mojo::Equals(this->bounds, other_struct.bounds))
    return false;
  if (!mojo::Equals(this->element_id, other_struct.element_id))
    return false;
  if (!mojo::Equals(this->max_scroll_offset_affected_by_page_scale, other_struct.max_scroll_offset_affected_by_page_scale))
    return false;
  if (!mojo::Equals(this->scrolls_inner_viewport, other_struct.scrolls_inner_viewport))
    return false;
  if (!mojo::Equals(this->scrolls_outer_viewport, other_struct.scrolls_outer_viewport))
    return false;
  if (!mojo::Equals(this->prevent_viewport_scrolling_from_inner, other_struct.prevent_viewport_scrolling_from_inner))
    return false;
  if (!mojo::Equals(this->user_scrollable_horizontal, other_struct.user_scrollable_horizontal))
    return false;
  if (!mojo::Equals(this->user_scrollable_vertical, other_struct.user_scrollable_vertical))
    return false;
  if (!mojo::Equals(this->is_composited, other_struct.is_composited))
    return false;
  return true;
}

template <typename T, ScrollNode::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.parent_id < rhs.parent_id)
    return true;
  if (rhs.parent_id < lhs.parent_id)
    return false;
  if (lhs.transform_id < rhs.transform_id)
    return true;
  if (rhs.transform_id < lhs.transform_id)
    return false;
  if (lhs.container_bounds < rhs.container_bounds)
    return true;
  if (rhs.container_bounds < lhs.container_bounds)
    return false;
  if (lhs.bounds < rhs.bounds)
    return true;
  if (rhs.bounds < lhs.bounds)
    return false;
  if (lhs.element_id < rhs.element_id)
    return true;
  if (rhs.element_id < lhs.element_id)
    return false;
  if (lhs.max_scroll_offset_affected_by_page_scale < rhs.max_scroll_offset_affected_by_page_scale)
    return true;
  if (rhs.max_scroll_offset_affected_by_page_scale < lhs.max_scroll_offset_affected_by_page_scale)
    return false;
  if (lhs.scrolls_inner_viewport < rhs.scrolls_inner_viewport)
    return true;
  if (rhs.scrolls_inner_viewport < lhs.scrolls_inner_viewport)
    return false;
  if (lhs.scrolls_outer_viewport < rhs.scrolls_outer_viewport)
    return true;
  if (rhs.scrolls_outer_viewport < lhs.scrolls_outer_viewport)
    return false;
  if (lhs.prevent_viewport_scrolling_from_inner < rhs.prevent_viewport_scrolling_from_inner)
    return true;
  if (rhs.prevent_viewport_scrolling_from_inner < lhs.prevent_viewport_scrolling_from_inner)
    return false;
  if (lhs.user_scrollable_horizontal < rhs.user_scrollable_horizontal)
    return true;
  if (rhs.user_scrollable_horizontal < lhs.user_scrollable_horizontal)
    return false;
  if (lhs.user_scrollable_vertical < rhs.user_scrollable_vertical)
    return true;
  if (rhs.user_scrollable_vertical < lhs.user_scrollable_vertical)
    return false;
  if (lhs.is_composited < rhs.is_composited)
    return true;
  if (rhs.is_composited < lhs.is_composited)
    return false;
  return false;
}


}  // viz::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::Layer::DataView,
                                         ::viz::mojom::blink::LayerPtr> {
  static bool IsNull(const ::viz::mojom::blink::LayerPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::LayerPtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::Layer::id) id(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->id;
  }

  static decltype(::viz::mojom::blink::Layer::type) type(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->type;
  }

  static const decltype(::viz::mojom::blink::Layer::bounds)& bounds(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->bounds;
  }

  static decltype(::viz::mojom::blink::Layer::contents_opaque) contents_opaque(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->contents_opaque;
  }

  static decltype(::viz::mojom::blink::Layer::contents_opaque_for_text) contents_opaque_for_text(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->contents_opaque_for_text;
  }

  static decltype(::viz::mojom::blink::Layer::is_drawable) is_drawable(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->is_drawable;
  }

  static const decltype(::viz::mojom::blink::Layer::background_color)& background_color(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->background_color;
  }

  static const decltype(::viz::mojom::blink::Layer::safe_opaque_background_color)& safe_opaque_background_color(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->safe_opaque_background_color;
  }

  static const decltype(::viz::mojom::blink::Layer::element_id)& element_id(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->element_id;
  }

  static const decltype(::viz::mojom::blink::Layer::update_rect)& update_rect(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->update_rect;
  }

  static const decltype(::viz::mojom::blink::Layer::offset_to_transform_parent)& offset_to_transform_parent(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->offset_to_transform_parent;
  }

  static decltype(::viz::mojom::blink::Layer::transform_tree_index) transform_tree_index(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->transform_tree_index;
  }

  static decltype(::viz::mojom::blink::Layer::clip_tree_index) clip_tree_index(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->clip_tree_index;
  }

  static decltype(::viz::mojom::blink::Layer::effect_tree_index) effect_tree_index(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->effect_tree_index;
  }

  static decltype(::viz::mojom::blink::Layer::scroll_tree_index) scroll_tree_index(
      const ::viz::mojom::blink::LayerPtr& input) {
    return input->scroll_tree_index;
  }

  static bool Read(::viz::mojom::blink::Layer::DataView input, ::viz::mojom::blink::LayerPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::AnchorPositionScrollData::DataView,
                                         ::viz::mojom::blink::AnchorPositionScrollDataPtr> {
  static bool IsNull(const ::viz::mojom::blink::AnchorPositionScrollDataPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::AnchorPositionScrollDataPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::AnchorPositionScrollData::adjustment_container_ids)& adjustment_container_ids(
      const ::viz::mojom::blink::AnchorPositionScrollDataPtr& input) {
    return input->adjustment_container_ids;
  }

  static const decltype(::viz::mojom::blink::AnchorPositionScrollData::accumulated_scroll_origin)& accumulated_scroll_origin(
      const ::viz::mojom::blink::AnchorPositionScrollDataPtr& input) {
    return input->accumulated_scroll_origin;
  }

  static decltype(::viz::mojom::blink::AnchorPositionScrollData::needs_scroll_adjustment_in_x) needs_scroll_adjustment_in_x(
      const ::viz::mojom::blink::AnchorPositionScrollDataPtr& input) {
    return input->needs_scroll_adjustment_in_x;
  }

  static decltype(::viz::mojom::blink::AnchorPositionScrollData::needs_scroll_adjustment_in_y) needs_scroll_adjustment_in_y(
      const ::viz::mojom::blink::AnchorPositionScrollDataPtr& input) {
    return input->needs_scroll_adjustment_in_y;
  }

  static bool Read(::viz::mojom::blink::AnchorPositionScrollData::DataView input, ::viz::mojom::blink::AnchorPositionScrollDataPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::StickyPositionNodeData::DataView,
                                         ::viz::mojom::blink::StickyPositionNodeDataPtr> {
  static bool IsNull(const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::StickyPositionNodeDataPtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::StickyPositionNodeData::scroll_ancestor) scroll_ancestor(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->scroll_ancestor;
  }

  static decltype(::viz::mojom::blink::StickyPositionNodeData::is_anchored_left) is_anchored_left(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->is_anchored_left;
  }

  static decltype(::viz::mojom::blink::StickyPositionNodeData::is_anchored_right) is_anchored_right(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->is_anchored_right;
  }

  static decltype(::viz::mojom::blink::StickyPositionNodeData::is_anchored_top) is_anchored_top(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->is_anchored_top;
  }

  static decltype(::viz::mojom::blink::StickyPositionNodeData::is_anchored_bottom) is_anchored_bottom(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->is_anchored_bottom;
  }

  static decltype(::viz::mojom::blink::StickyPositionNodeData::left_offset) left_offset(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->left_offset;
  }

  static decltype(::viz::mojom::blink::StickyPositionNodeData::right_offset) right_offset(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->right_offset;
  }

  static decltype(::viz::mojom::blink::StickyPositionNodeData::top_offset) top_offset(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->top_offset;
  }

  static decltype(::viz::mojom::blink::StickyPositionNodeData::bottom_offset) bottom_offset(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->bottom_offset;
  }

  static const decltype(::viz::mojom::blink::StickyPositionNodeData::constraint_box_rect)& constraint_box_rect(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->constraint_box_rect;
  }

  static const decltype(::viz::mojom::blink::StickyPositionNodeData::scroll_container_relative_sticky_box_rect)& scroll_container_relative_sticky_box_rect(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->scroll_container_relative_sticky_box_rect;
  }

  static const decltype(::viz::mojom::blink::StickyPositionNodeData::scroll_container_relative_containing_block_rect)& scroll_container_relative_containing_block_rect(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->scroll_container_relative_containing_block_rect;
  }

  static decltype(::viz::mojom::blink::StickyPositionNodeData::nearest_node_shifting_sticky_box) nearest_node_shifting_sticky_box(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->nearest_node_shifting_sticky_box;
  }

  static decltype(::viz::mojom::blink::StickyPositionNodeData::nearest_node_shifting_containing_block) nearest_node_shifting_containing_block(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->nearest_node_shifting_containing_block;
  }

  static const decltype(::viz::mojom::blink::StickyPositionNodeData::total_sticky_box_sticky_offset)& total_sticky_box_sticky_offset(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->total_sticky_box_sticky_offset;
  }

  static const decltype(::viz::mojom::blink::StickyPositionNodeData::total_containing_block_sticky_offset)& total_containing_block_sticky_offset(
      const ::viz::mojom::blink::StickyPositionNodeDataPtr& input) {
    return input->total_containing_block_sticky_offset;
  }

  static bool Read(::viz::mojom::blink::StickyPositionNodeData::DataView input, ::viz::mojom::blink::StickyPositionNodeDataPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::TransformTreeUpdate::DataView,
                                         ::viz::mojom::blink::TransformTreeUpdatePtr> {
  static bool IsNull(const ::viz::mojom::blink::TransformTreeUpdatePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::TransformTreeUpdatePtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::TransformTreeUpdate::page_scale_factor) page_scale_factor(
      const ::viz::mojom::blink::TransformTreeUpdatePtr& input) {
    return input->page_scale_factor;
  }

  static decltype(::viz::mojom::blink::TransformTreeUpdate::device_scale_factor) device_scale_factor(
      const ::viz::mojom::blink::TransformTreeUpdatePtr& input) {
    return input->device_scale_factor;
  }

  static decltype(::viz::mojom::blink::TransformTreeUpdate::device_transform_scale_factor) device_transform_scale_factor(
      const ::viz::mojom::blink::TransformTreeUpdatePtr& input) {
    return input->device_transform_scale_factor;
  }

  static const decltype(::viz::mojom::blink::TransformTreeUpdate::nodes_affected_by_outer_viewport_bounds_delta)& nodes_affected_by_outer_viewport_bounds_delta(
      const ::viz::mojom::blink::TransformTreeUpdatePtr& input) {
    return input->nodes_affected_by_outer_viewport_bounds_delta;
  }

  static const decltype(::viz::mojom::blink::TransformTreeUpdate::sticky_position_data)& sticky_position_data(
      const ::viz::mojom::blink::TransformTreeUpdatePtr& input) {
    return input->sticky_position_data;
  }

  static const decltype(::viz::mojom::blink::TransformTreeUpdate::anchor_position_scroll_data)& anchor_position_scroll_data(
      const ::viz::mojom::blink::TransformTreeUpdatePtr& input) {
    return input->anchor_position_scroll_data;
  }

  static bool Read(::viz::mojom::blink::TransformTreeUpdate::DataView input, ::viz::mojom::blink::TransformTreeUpdatePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::TransformNode::DataView,
                                         ::viz::mojom::blink::TransformNodePtr> {
  static bool IsNull(const ::viz::mojom::blink::TransformNodePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::TransformNodePtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::TransformNode::id) id(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->id;
  }

  static decltype(::viz::mojom::blink::TransformNode::parent_id) parent_id(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->parent_id;
  }

  static decltype(::viz::mojom::blink::TransformNode::parent_frame_id) parent_frame_id(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->parent_frame_id;
  }

  static const decltype(::viz::mojom::blink::TransformNode::element_id)& element_id(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->element_id;
  }

  static const decltype(::viz::mojom::blink::TransformNode::local)& local(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->local;
  }

  static const decltype(::viz::mojom::blink::TransformNode::origin)& origin(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->origin;
  }

  static const decltype(::viz::mojom::blink::TransformNode::scroll_offset)& scroll_offset(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->scroll_offset;
  }

  static const decltype(::viz::mojom::blink::TransformNode::snap_amount)& snap_amount(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->snap_amount;
  }

  static decltype(::viz::mojom::blink::TransformNode::sticky_position_constraint_id) sticky_position_constraint_id(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->sticky_position_constraint_id;
  }

  static decltype(::viz::mojom::blink::TransformNode::anchor_position_scroll_data_id) anchor_position_scroll_data_id(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->anchor_position_scroll_data_id;
  }

  static decltype(::viz::mojom::blink::TransformNode::sorting_context_id) sorting_context_id(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->sorting_context_id;
  }

  static decltype(::viz::mojom::blink::TransformNode::has_potential_animation) has_potential_animation(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->has_potential_animation;
  }

  static decltype(::viz::mojom::blink::TransformNode::is_currently_animating) is_currently_animating(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->is_currently_animating;
  }

  static decltype(::viz::mojom::blink::TransformNode::flattens_inherited_transform) flattens_inherited_transform(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->flattens_inherited_transform;
  }

  static decltype(::viz::mojom::blink::TransformNode::scrolls) scrolls(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->scrolls;
  }

  static decltype(::viz::mojom::blink::TransformNode::should_undo_overscroll) should_undo_overscroll(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->should_undo_overscroll;
  }

  static decltype(::viz::mojom::blink::TransformNode::should_be_snapped) should_be_snapped(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->should_be_snapped;
  }

  static decltype(::viz::mojom::blink::TransformNode::moved_by_outer_viewport_bounds_delta_y) moved_by_outer_viewport_bounds_delta_y(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->moved_by_outer_viewport_bounds_delta_y;
  }

  static decltype(::viz::mojom::blink::TransformNode::in_subtree_of_page_scale_layer) in_subtree_of_page_scale_layer(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->in_subtree_of_page_scale_layer;
  }

  static decltype(::viz::mojom::blink::TransformNode::transform_changed) transform_changed(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->transform_changed;
  }

  static decltype(::viz::mojom::blink::TransformNode::delegates_to_parent_for_backface) delegates_to_parent_for_backface(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->delegates_to_parent_for_backface;
  }

  static decltype(::viz::mojom::blink::TransformNode::will_change_transform) will_change_transform(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->will_change_transform;
  }

  static const decltype(::viz::mojom::blink::TransformNode::visible_frame_element_id)& visible_frame_element_id(
      const ::viz::mojom::blink::TransformNodePtr& input) {
    return input->visible_frame_element_id;
  }

  static bool Read(::viz::mojom::blink::TransformNode::DataView input, ::viz::mojom::blink::TransformNodePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::ClipNode::DataView,
                                         ::viz::mojom::blink::ClipNodePtr> {
  static bool IsNull(const ::viz::mojom::blink::ClipNodePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::ClipNodePtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::ClipNode::id) id(
      const ::viz::mojom::blink::ClipNodePtr& input) {
    return input->id;
  }

  static decltype(::viz::mojom::blink::ClipNode::parent_id) parent_id(
      const ::viz::mojom::blink::ClipNodePtr& input) {
    return input->parent_id;
  }

  static decltype(::viz::mojom::blink::ClipNode::transform_id) transform_id(
      const ::viz::mojom::blink::ClipNodePtr& input) {
    return input->transform_id;
  }

  static const decltype(::viz::mojom::blink::ClipNode::clip)& clip(
      const ::viz::mojom::blink::ClipNodePtr& input) {
    return input->clip;
  }

  static decltype(::viz::mojom::blink::ClipNode::pixel_moving_filter_id) pixel_moving_filter_id(
      const ::viz::mojom::blink::ClipNodePtr& input) {
    return input->pixel_moving_filter_id;
  }

  static bool Read(::viz::mojom::blink::ClipNode::DataView input, ::viz::mojom::blink::ClipNodePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::EffectNode::DataView,
                                         ::viz::mojom::blink::EffectNodePtr> {
  static bool IsNull(const ::viz::mojom::blink::EffectNodePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::EffectNodePtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::EffectNode::id) id(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->id;
  }

  static decltype(::viz::mojom::blink::EffectNode::parent_id) parent_id(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->parent_id;
  }

  static decltype(::viz::mojom::blink::EffectNode::transform_id) transform_id(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->transform_id;
  }

  static decltype(::viz::mojom::blink::EffectNode::clip_id) clip_id(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->clip_id;
  }

  static const decltype(::viz::mojom::blink::EffectNode::element_id)& element_id(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->element_id;
  }

  static decltype(::viz::mojom::blink::EffectNode::opacity) opacity(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->opacity;
  }

  static decltype(::viz::mojom::blink::EffectNode::has_render_surface) has_render_surface(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->has_render_surface;
  }

  static const decltype(::viz::mojom::blink::EffectNode::surface_contents_scale)& surface_contents_scale(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->surface_contents_scale;
  }

  static decltype(::viz::mojom::blink::EffectNode::blend_mode) blend_mode(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->blend_mode;
  }

  static decltype(::viz::mojom::blink::EffectNode::target_id) target_id(
      const ::viz::mojom::blink::EffectNodePtr& input) {
    return input->target_id;
  }

  static bool Read(::viz::mojom::blink::EffectNode::DataView input, ::viz::mojom::blink::EffectNodePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::ScrollNode::DataView,
                                         ::viz::mojom::blink::ScrollNodePtr> {
  static bool IsNull(const ::viz::mojom::blink::ScrollNodePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::ScrollNodePtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::ScrollNode::id) id(
      const ::viz::mojom::blink::ScrollNodePtr& input) {
    return input->id;
  }

  static decltype(::viz::mojom::blink::ScrollNode::parent_id) parent_id(
      const ::viz::mojom::blink::ScrollNodePtr& input) {
    return input->parent_id;
  }

  static decltype(::viz::mojom::blink::ScrollNode::transform_id) transform_id(
      const ::viz::mojom::blink::ScrollNodePtr& input) {
    return input->transform_id;
  }

  static const decltype(::viz::mojom::blink::ScrollNode::container_bounds)& container_bounds(
      const ::viz::mojom::blink::ScrollNodePtr& input) {
    return input->container_bounds;
  }

  static const decltype(::viz::mojom::blink::ScrollNode::bounds)& bounds(
      const ::viz::mojom::blink::ScrollNodePtr& input) {
    return input->bounds;
  }

  static const decltype(::viz::mojom::blink::ScrollNode::element_id)& element_id(
      const ::viz::mojom::blink::ScrollNodePtr& input) {
    return input->element_id;
  }

  static decltype(::viz::mojom::blink::ScrollNode::max_scroll_offset_affected_by_page_scale) max_scroll_offset_affected_by_page_scale(
      const ::viz::mojom::blink::ScrollNodePtr& input) {
    return input->max_scroll_offset_affected_by_page_scale;
  }

  static decltype(::viz::mojom::blink::ScrollNode::scrolls_inner_viewport) scrolls_inner_viewport(
      const ::viz::mojom::blink::ScrollNodePtr& input) {
    return input->scrolls_inner_viewport;
  }

  static decltype(::viz::mojom::blink::ScrollNode::scrolls_outer_viewport) scrolls_outer_viewport(
      const ::viz::mojom::blink::ScrollNodePtr& input) {
    return input->scrolls_outer_viewport;
  }

  static decltype(::viz::mojom::blink::ScrollNode::prevent_viewport_scrolling_from_inner) prevent_viewport_scrolling_from_inner(
      const ::viz::mojom::blink::ScrollNodePtr& input) {
    return input->prevent_viewport_scrolling_from_inner;
  }

  static decltype(::viz::mojom::blink::ScrollNode::user_scrollable_horizontal) user_scrollable_horizontal(
      const ::viz::mojom::blink::ScrollNodePtr& input) {
    return input->user_scrollable_horizontal;
  }

  static decltype(::viz::mojom::blink::ScrollNode::user_scrollable_vertical) user_scrollable_vertical(
      const ::viz::mojom::blink::ScrollNodePtr& input) {
    return input->user_scrollable_vertical;
  }

  static decltype(::viz::mojom::blink::ScrollNode::is_composited) is_composited(
      const ::viz::mojom::blink::ScrollNodePtr& input) {
    return input->is_composited;
  }

  static bool Read(::viz::mojom::blink::ScrollNode::DataView input, ::viz::mojom::blink::ScrollNodePtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_MOJOM_BLINK_H_