// services/viz/public/mojom/compositing/layer_context.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/public/mojom/compositing/layer_context.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/layer_context.mojom-params-data.h"
namespace viz {
namespace mojom {

namespace internal {


// static
bool LayerTreeUpdate_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 168, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LayerTreeUpdate_Data* object =
      static_cast<const LayerTreeUpdate_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_viewport, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_viewport, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->local_surface_id_from_parent, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->background_color, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->background_color, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->layers, 13, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& layers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->layers, validation_context,
                                         &layers_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& layer_order_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->layer_order, validation_context,
                                         &layer_order_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->transform_tree_update, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transform_nodes, 16, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& transform_nodes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->transform_nodes, validation_context,
                                         &transform_nodes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->clip_nodes, 17, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& clip_nodes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->clip_nodes, validation_context,
                                         &clip_nodes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->effect_nodes, 18, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& effect_nodes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->effect_nodes, validation_context,
                                         &effect_nodes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scroll_nodes, 19, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& scroll_nodes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->scroll_nodes, validation_context,
                                         &scroll_nodes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tilings, 24, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tilings_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tilings, validation_context,
                                         &tilings_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& animation_timelines_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->animation_timelines, validation_context,
                                         &animation_timelines_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& removed_animation_timelines_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->removed_animation_timelines, validation_context,
                                         &removed_animation_timelines_validate_params)) {
    return false;
  }

  return true;
}

LayerTreeUpdate_Data::LayerTreeUpdate_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PendingLayerContext_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PendingLayerContext_Data* object =
      static_cast<const PendingLayerContext_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PendingLayerContext_Data::PendingLayerContext_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LayerContext_SetVisible_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LayerContext_SetVisible_Params_Data* object =
      static_cast<const LayerContext_SetVisible_Params_Data*>(data);

  return true;
}

LayerContext_SetVisible_Params_Data::LayerContext_SetVisible_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LayerContext_UpdateDisplayTree_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LayerContext_UpdateDisplayTree_Params_Data* object =
      static_cast<const LayerContext_UpdateDisplayTree_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->update, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->update, validation_context))
    return false;

  return true;
}

LayerContext_UpdateDisplayTree_Params_Data::LayerContext_UpdateDisplayTree_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LayerContext_UpdateDisplayTiling_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LayerContext_UpdateDisplayTiling_Params_Data* object =
      static_cast<const LayerContext_UpdateDisplayTiling_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tiling, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tiling, validation_context))
    return false;

  return true;
}

LayerContext_UpdateDisplayTiling_Params_Data::LayerContext_UpdateDisplayTiling_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LayerContextClient_OnRequestCommitForFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LayerContextClient_OnRequestCommitForFrame_Params_Data* object =
      static_cast<const LayerContextClient_OnRequestCommitForFrame_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->args, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->args, validation_context))
    return false;

  return true;
}

LayerContextClient_OnRequestCommitForFrame_Params_Data::LayerContextClient_OnRequestCommitForFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace viz