// services/viz/public/mojom/compositing/shared_image_format.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/shared_image_format.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/shared_image_format.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/shared_image_format.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/shared_image_format.mojom-import-headers.h"
#include "services/viz/public/mojom/compositing/shared_image_format.mojom-test-utils.h"


namespace viz::mojom {
MultiplanarFormat::MultiplanarFormat()
    : plane_config(),
      subsampling(),
      channel_format(),
      prefers_external_sampler() {}

MultiplanarFormat::MultiplanarFormat(
    PlaneConfig plane_config_in,
    Subsampling subsampling_in,
    ChannelFormat channel_format_in,
    bool prefers_external_sampler_in)
    : plane_config(std::move(plane_config_in)),
      subsampling(std::move(subsampling_in)),
      channel_format(std::move(channel_format_in)),
      prefers_external_sampler(std::move(prefers_external_sampler_in)) {}

MultiplanarFormat::~MultiplanarFormat() = default;
size_t MultiplanarFormat::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->plane_config);
  seed = mojo::internal::Hash(seed, this->subsampling);
  seed = mojo::internal::Hash(seed, this->channel_format);
  seed = mojo::internal::Hash(seed, this->prefers_external_sampler);
  return seed;
}

void MultiplanarFormat::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "plane_config"), this->plane_config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PlaneConfig>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subsampling"), this->subsampling,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type Subsampling>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "channel_format"), this->channel_format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ChannelFormat>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prefers_external_sampler"), this->prefers_external_sampler,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MultiplanarFormat::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SharedImageFormat::SharedImageFormat() : tag_(Tag::kSingleplanarFormat) {
  data_.singleplanar_format = ::viz::mojom::SingleplanarFormat();
}

SharedImageFormat::~SharedImageFormat() {
  DestroyActive();
}


void SharedImageFormat::set_singleplanar_format(
    ::viz::mojom::SingleplanarFormat singleplanar_format) {
  if (tag_ != Tag::kSingleplanarFormat) {
    DestroyActive();
    tag_ = Tag::kSingleplanarFormat;
  }
  data_.singleplanar_format = singleplanar_format;
}
void SharedImageFormat::set_multiplanar_format(
    MultiplanarFormatPtr multiplanar_format) {
  if (tag_ == Tag::kMultiplanarFormat) {
    *(data_.multiplanar_format) = std::move(multiplanar_format);
  } else {
    DestroyActive();
    tag_ = Tag::kMultiplanarFormat;
    data_.multiplanar_format = new MultiplanarFormatPtr(
        std::move(multiplanar_format));
  }
}

void SharedImageFormat::DestroyActive() {
  switch (tag_) {

    case Tag::kSingleplanarFormat:

      break;
    case Tag::kMultiplanarFormat:

      delete data_.multiplanar_format;
      break;
  }
}

bool SharedImageFormat::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // viz::mojom


namespace mojo {


// static
bool StructTraits<::viz::mojom::MultiplanarFormat::DataView, ::viz::mojom::MultiplanarFormatPtr>::Read(
    ::viz::mojom::MultiplanarFormat::DataView input,
    ::viz::mojom::MultiplanarFormatPtr* output) {
  bool success = true;
  ::viz::mojom::MultiplanarFormatPtr result(::viz::mojom::MultiplanarFormat::New());
  
      if (success && !input.ReadPlaneConfig(&result->plane_config))
        success = false;
      if (success && !input.ReadSubsampling(&result->subsampling))
        success = false;
      if (success && !input.ReadChannelFormat(&result->channel_format))
        success = false;
      if (success)
        result->prefers_external_sampler = input.prefers_external_sampler();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::viz::mojom::SharedImageFormat::DataView, ::viz::mojom::SharedImageFormatPtr>::Read(
    ::viz::mojom::SharedImageFormat::DataView input,
    ::viz::mojom::SharedImageFormatPtr* output) {
  using UnionType = ::viz::mojom::SharedImageFormat;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSingleplanarFormat: {
      ::viz::mojom::SingleplanarFormat result_singleplanar_format;
      if (!input.ReadSingleplanarFormat(&result_singleplanar_format))
        return false;

      *output = UnionType::NewSingleplanarFormat(result_singleplanar_format);
      break;
    }
    case Tag::kMultiplanarFormat: {
      ::viz::mojom::MultiplanarFormatPtr result_multiplanar_format;
      if (!input.ReadMultiplanarFormat(&result_multiplanar_format))
        return false;

      *output = UnionType::NewMultiplanarFormat(
          std::move(result_multiplanar_format));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {




}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif