// third_party/blink/public/mojom/cache_storage/cache_storage.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* CacheStorageErrorToStringHelper(CacheStorageError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CacheStorageError::kSuccess:
      return "kSuccess";
    case CacheStorageError::kErrorExists:
      return "kErrorExists";
    case CacheStorageError::kErrorStorage:
      return "kErrorStorage";
    case CacheStorageError::kErrorNotFound:
      return "kErrorNotFound";
    case CacheStorageError::kErrorQuotaExceeded:
      return "kErrorQuotaExceeded";
    case CacheStorageError::kErrorCacheNameNotFound:
      return "kErrorCacheNameNotFound";
    case CacheStorageError::kErrorQueryTooLarge:
      return "kErrorQueryTooLarge";
    case CacheStorageError::kErrorNotImplemented:
      return "kErrorNotImplemented";
    case CacheStorageError::kErrorDuplicateOperation:
      return "kErrorDuplicateOperation";
    case CacheStorageError::kErrorCrossOriginResourcePolicy:
      return "kErrorCrossOriginResourcePolicy";
    default:
      return nullptr;
  }
}

std::string CacheStorageErrorToString(CacheStorageError value) {
  const char *str = CacheStorageErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CacheStorageError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CacheStorageError value) {
  return os << CacheStorageErrorToString(value);
}

NOINLINE static const char* OperationTypeToStringHelper(OperationType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case OperationType::kUndefined:
      return "kUndefined";
    case OperationType::kPut:
      return "kPut";
    case OperationType::kDelete:
      return "kDelete";
    default:
      return nullptr;
  }
}

std::string OperationTypeToString(OperationType value) {
  const char *str = OperationTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown OperationType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, OperationType value) {
  return os << OperationTypeToString(value);
}

namespace internal {
// static
bool OpenResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const OpenResult_Data* object = static_cast<const OpenResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case OpenResult_Tag::kStatus: {


      if (!::blink::mojom::internal::CacheStorageError_Data
            ::Validate(object->data.f_status, validation_context))
        return false;
      return true;
    }
    case OpenResult_Tag::kCache: {

      if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
              object->data.f_cache, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateHandleOrInterface(object->data.f_cache,
                                                     validation_context)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in OpenResult");
      return false;
    }
  }
}
// static
bool MatchResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const MatchResult_Data* object = static_cast<const MatchResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case MatchResult_Tag::kStatus: {


      if (!::blink::mojom::internal::CacheStorageError_Data
            ::Validate(object->data.f_status, validation_context))
        return false;
      return true;
    }
    case MatchResult_Tag::kResponse: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_response, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_response, validation_context))
        return false;
      return true;
    }
    case MatchResult_Tag::kEagerResponse: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_eager_response, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_eager_response, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in MatchResult");
      return false;
    }
  }
}
// static
bool MatchAllResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const MatchAllResult_Data* object = static_cast<const MatchAllResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case MatchAllResult_Tag::kStatus: {


      if (!::blink::mojom::internal::CacheStorageError_Data
            ::Validate(object->data.f_status, validation_context))
        return false;
      return true;
    }
    case MatchAllResult_Tag::kResponses: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_responses, 2, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& responses_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_responses, validation_context,
                                             &responses_validate_params)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in MatchAllResult");
      return false;
    }
  }
}
// static
bool GetAllMatchedEntriesResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const GetAllMatchedEntriesResult_Data* object = static_cast<const GetAllMatchedEntriesResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case GetAllMatchedEntriesResult_Tag::kStatus: {


      if (!::blink::mojom::internal::CacheStorageError_Data
            ::Validate(object->data.f_status, validation_context))
        return false;
      return true;
    }
    case GetAllMatchedEntriesResult_Tag::kEntries: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_entries, 2, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& entries_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_entries, validation_context,
                                             &entries_validate_params)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in GetAllMatchedEntriesResult");
      return false;
    }
  }
}
// static
bool CacheKeysResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const CacheKeysResult_Data* object = static_cast<const CacheKeysResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case CacheKeysResult_Tag::kStatus: {


      if (!::blink::mojom::internal::CacheStorageError_Data
            ::Validate(object->data.f_status, validation_context))
        return false;
      return true;
    }
    case CacheKeysResult_Tag::kKeys: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_keys, 2, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& keys_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_keys, validation_context,
                                             &keys_validate_params)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in CacheKeysResult");
      return false;
    }
  }
}


// static
bool CacheStorageVerboseError_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorageVerboseError_Data* object =
      static_cast<const CacheStorageVerboseError_Data*>(data);


  if (!::blink::mojom::internal::CacheStorageError_Data
        ::Validate(object->value, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

CacheStorageVerboseError_Data::CacheStorageVerboseError_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheQueryOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheQueryOptions_Data* object =
      static_cast<const CacheQueryOptions_Data*>(data);

  return true;
}

CacheQueryOptions_Data::CacheQueryOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MultiCacheQueryOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MultiCacheQueryOptions_Data* object =
      static_cast<const MultiCacheQueryOptions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query_options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->query_options, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->cache_name, validation_context))
    return false;

  return true;
}

MultiCacheQueryOptions_Data::MultiCacheQueryOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BatchOperation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BatchOperation_Data* object =
      static_cast<const BatchOperation_Data*>(data);


  if (!::blink::mojom::internal::OperationType_Data
        ::Validate(object->operation_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->response, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->match_options, validation_context))
    return false;

  return true;
}

BatchOperation_Data::BatchOperation_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EagerResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EagerResponse_Data* object =
      static_cast<const EagerResponse_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->pipe, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->pipe,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client_receiver, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

EagerResponse_Data::EagerResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheEntry_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheEntry_Data* object =
      static_cast<const CacheEntry_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response, validation_context))
    return false;

  return true;
}

CacheEntry_Data::CacheEntry_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageCache_Match_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorageCache_Match_Params_Data* object =
      static_cast<const CacheStorageCache_Match_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query_options, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->query_options, validation_context))
    return false;

  return true;
}

CacheStorageCache_Match_Params_Data::CacheStorageCache_Match_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageCache_Match_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorageCache_Match_ResponseParams_Data* object =
      static_cast<const CacheStorageCache_Match_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

CacheStorageCache_Match_ResponseParams_Data::CacheStorageCache_Match_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageCache_MatchAll_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorageCache_MatchAll_Params_Data* object =
      static_cast<const CacheStorageCache_MatchAll_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query_options, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->query_options, validation_context))
    return false;

  return true;
}

CacheStorageCache_MatchAll_Params_Data::CacheStorageCache_MatchAll_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageCache_MatchAll_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorageCache_MatchAll_ResponseParams_Data* object =
      static_cast<const CacheStorageCache_MatchAll_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

CacheStorageCache_MatchAll_ResponseParams_Data::CacheStorageCache_MatchAll_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageCache_GetAllMatchedEntries_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorageCache_GetAllMatchedEntries_Params_Data* object =
      static_cast<const CacheStorageCache_GetAllMatchedEntries_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query_options, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->query_options, validation_context))
    return false;

  return true;
}

CacheStorageCache_GetAllMatchedEntries_Params_Data::CacheStorageCache_GetAllMatchedEntries_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageCache_GetAllMatchedEntries_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorageCache_GetAllMatchedEntries_ResponseParams_Data* object =
      static_cast<const CacheStorageCache_GetAllMatchedEntries_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

CacheStorageCache_GetAllMatchedEntries_ResponseParams_Data::CacheStorageCache_GetAllMatchedEntries_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageCache_Keys_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorageCache_Keys_Params_Data* object =
      static_cast<const CacheStorageCache_Keys_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query_options, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->query_options, validation_context))
    return false;

  return true;
}

CacheStorageCache_Keys_Params_Data::CacheStorageCache_Keys_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageCache_Keys_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorageCache_Keys_ResponseParams_Data* object =
      static_cast<const CacheStorageCache_Keys_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

CacheStorageCache_Keys_ResponseParams_Data::CacheStorageCache_Keys_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageCache_Batch_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorageCache_Batch_Params_Data* object =
      static_cast<const CacheStorageCache_Batch_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->batch_operations, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& batch_operations_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->batch_operations, validation_context,
                                         &batch_operations_validate_params)) {
    return false;
  }

  return true;
}

CacheStorageCache_Batch_Params_Data::CacheStorageCache_Batch_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageCache_Batch_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorageCache_Batch_ResponseParams_Data* object =
      static_cast<const CacheStorageCache_Batch_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

CacheStorageCache_Batch_ResponseParams_Data::CacheStorageCache_Batch_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageCache_WriteSideData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorageCache_WriteSideData_Params_Data* object =
      static_cast<const CacheStorageCache_WriteSideData_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->expected_response_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->expected_response_time, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  return true;
}

CacheStorageCache_WriteSideData_Params_Data::CacheStorageCache_WriteSideData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorageCache_WriteSideData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorageCache_WriteSideData_ResponseParams_Data* object =
      static_cast<const CacheStorageCache_WriteSideData_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::CacheStorageError_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

CacheStorageCache_WriteSideData_ResponseParams_Data::CacheStorageCache_WriteSideData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorage_Has_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorage_Has_Params_Data* object =
      static_cast<const CacheStorage_Has_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cache_name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cache_name, validation_context))
    return false;

  return true;
}

CacheStorage_Has_Params_Data::CacheStorage_Has_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorage_Has_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorage_Has_ResponseParams_Data* object =
      static_cast<const CacheStorage_Has_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::CacheStorageError_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

CacheStorage_Has_ResponseParams_Data::CacheStorage_Has_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorage_Delete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorage_Delete_Params_Data* object =
      static_cast<const CacheStorage_Delete_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cache_name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cache_name, validation_context))
    return false;

  return true;
}

CacheStorage_Delete_Params_Data::CacheStorage_Delete_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorage_Delete_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorage_Delete_ResponseParams_Data* object =
      static_cast<const CacheStorage_Delete_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::CacheStorageError_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

CacheStorage_Delete_ResponseParams_Data::CacheStorage_Delete_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorage_Keys_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorage_Keys_Params_Data* object =
      static_cast<const CacheStorage_Keys_Params_Data*>(data);

  return true;
}

CacheStorage_Keys_Params_Data::CacheStorage_Keys_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorage_Keys_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorage_Keys_ResponseParams_Data* object =
      static_cast<const CacheStorage_Keys_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->keys, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->keys, validation_context,
                                         &keys_validate_params)) {
    return false;
  }

  return true;
}

CacheStorage_Keys_ResponseParams_Data::CacheStorage_Keys_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorage_Match_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorage_Match_Params_Data* object =
      static_cast<const CacheStorage_Match_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->match_options, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->match_options, validation_context))
    return false;

  return true;
}

CacheStorage_Match_Params_Data::CacheStorage_Match_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorage_Match_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorage_Match_ResponseParams_Data* object =
      static_cast<const CacheStorage_Match_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

CacheStorage_Match_ResponseParams_Data::CacheStorage_Match_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorage_Open_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorage_Open_Params_Data* object =
      static_cast<const CacheStorage_Open_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cache_name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cache_name, validation_context))
    return false;

  return true;
}

CacheStorage_Open_Params_Data::CacheStorage_Open_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CacheStorage_Open_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CacheStorage_Open_ResponseParams_Data* object =
      static_cast<const CacheStorage_Open_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

CacheStorage_Open_ResponseParams_Data::CacheStorage_Open_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::CacheStorageError>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::CacheStorageError value) {
  return std::move(context).WriteString(::blink::mojom::CacheStorageErrorToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::OperationType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::OperationType value) {
  return std::move(context).WriteString(::blink::mojom::OperationTypeToString(value));
}

} // namespace perfetto