// third_party/blink/public/mojom/push_messaging/push_messaging.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/push_messaging/push_messaging.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/push_messaging/push_messaging.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* PushErrorTypeToStringHelper(PushErrorType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PushErrorType::ABORT:
      return "ABORT";
    case PushErrorType::NETWORK:
      return "NETWORK";
    case PushErrorType::NONE:
      return "NONE";
    case PushErrorType::NOT_ALLOWED:
      return "NOT_ALLOWED";
    case PushErrorType::NOT_FOUND:
      return "NOT_FOUND";
    case PushErrorType::NOT_SUPPORTED:
      return "NOT_SUPPORTED";
    case PushErrorType::INVALID_STATE:
      return "INVALID_STATE";
    default:
      return nullptr;
  }
}

std::string PushErrorTypeToString(PushErrorType value) {
  const char *str = PushErrorTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PushErrorType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PushErrorType value) {
  return os << PushErrorTypeToString(value);
}

namespace internal {


// static
bool PushSubscriptionOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PushSubscriptionOptions_Data* object =
      static_cast<const PushSubscriptionOptions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->application_server_key, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& application_server_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->application_server_key, validation_context,
                                         &application_server_key_validate_params)) {
    return false;
  }

  return true;
}

PushSubscriptionOptions_Data::PushSubscriptionOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushSubscription_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PushSubscription_Data* object =
      static_cast<const PushSubscription_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->endpoint, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->endpoint, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->expirationTime, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->p256dh, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& p256dh_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->p256dh, validation_context,
                                         &p256dh_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->auth, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& auth_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->auth, validation_context,
                                         &auth_validate_params)) {
    return false;
  }

  return true;
}

PushSubscription_Data::PushSubscription_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushMessaging_Subscribe_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PushMessaging_Subscribe_Params_Data* object =
      static_cast<const PushMessaging_Subscribe_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

PushMessaging_Subscribe_Params_Data::PushMessaging_Subscribe_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushMessaging_Subscribe_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PushMessaging_Subscribe_ResponseParams_Data* object =
      static_cast<const PushMessaging_Subscribe_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::PushRegistrationStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->subscription, validation_context))
    return false;

  return true;
}

PushMessaging_Subscribe_ResponseParams_Data::PushMessaging_Subscribe_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushMessaging_Unsubscribe_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PushMessaging_Unsubscribe_Params_Data* object =
      static_cast<const PushMessaging_Unsubscribe_Params_Data*>(data);

  return true;
}

PushMessaging_Unsubscribe_Params_Data::PushMessaging_Unsubscribe_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushMessaging_Unsubscribe_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PushMessaging_Unsubscribe_ResponseParams_Data* object =
      static_cast<const PushMessaging_Unsubscribe_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::PushErrorType_Data
        ::Validate(object->error_type, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& error_message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_message, validation_context,
                                         &error_message_validate_params)) {
    return false;
  }

  return true;
}

PushMessaging_Unsubscribe_ResponseParams_Data::PushMessaging_Unsubscribe_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushMessaging_GetSubscription_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PushMessaging_GetSubscription_Params_Data* object =
      static_cast<const PushMessaging_GetSubscription_Params_Data*>(data);

  return true;
}

PushMessaging_GetSubscription_Params_Data::PushMessaging_GetSubscription_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushMessaging_GetSubscription_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PushMessaging_GetSubscription_ResponseParams_Data* object =
      static_cast<const PushMessaging_GetSubscription_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::PushGetRegistrationStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->subscription, validation_context))
    return false;

  return true;
}

PushMessaging_GetSubscription_ResponseParams_Data::PushMessaging_GetSubscription_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::PushErrorType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::PushErrorType value) {
  return std::move(context).WriteString(::blink::mojom::PushErrorTypeToString(value));
}

} // namespace perfetto