// ui/ozone/public/mojom/gesture_properties_service.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_OZONE_PUBLIC_MOJOM_GESTURE_PROPERTIES_SERVICE_MOJOM_SHARED_H_
#define UI_OZONE_PUBLIC_MOJOM_GESTURE_PROPERTIES_SERVICE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/ozone/public/mojom/gesture_properties_service.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace ui::ozone::mojom {
class GesturePropValueDataView;


}  // ui::ozone::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ui::ozone::mojom::GesturePropValueDataView> {
  using Data = ::ui::ozone::mojom::internal::GesturePropValue_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace ui::ozone::mojom {


enum class SetGesturePropErrorCode : int32_t {
  
  SUCCESS = 0,
  
  UNKNOWN_ERROR = 1,
  
  NOT_FOUND = 2,
  
  READ_ONLY = 3,
  
  TYPE_MISMATCH = 4,
  
  SIZE_MISMATCH = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, SetGesturePropErrorCode value);
inline bool IsKnownEnumValue(SetGesturePropErrorCode value) {
  return internal::SetGesturePropErrorCode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class GesturePropertiesServiceInterfaceBase {};

using GesturePropertiesServicePtrDataView =
    mojo::InterfacePtrDataView<GesturePropertiesServiceInterfaceBase>;
using GesturePropertiesServiceRequestDataView =
    mojo::InterfaceRequestDataView<GesturePropertiesServiceInterfaceBase>;
using GesturePropertiesServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<GesturePropertiesServiceInterfaceBase>;
using GesturePropertiesServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<GesturePropertiesServiceInterfaceBase>;


class GesturePropValueDataView {
 public:
  using Tag = internal::GesturePropValue_Data::GesturePropValue_Tag;

  GesturePropValueDataView() = default;

  GesturePropValueDataView(
      internal::GesturePropValue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_ints() const { return data_->tag == Tag::kInts; }
  inline void GetIntsDataView(
      mojo::ArrayDataView<int32_t>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadInts(UserType* output) const {
    
    CHECK(is_ints());
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        data_->data.f_ints.Get(), output, message_);
  }
  bool is_shorts() const { return data_->tag == Tag::kShorts; }
  inline void GetShortsDataView(
      mojo::ArrayDataView<int16_t>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadShorts(UserType* output) const {
    
    CHECK(is_shorts());
    return mojo::internal::Deserialize<mojo::ArrayDataView<int16_t>>(
        data_->data.f_shorts.Get(), output, message_);
  }
  bool is_bools() const { return data_->tag == Tag::kBools; }
  inline void GetBoolsDataView(
      mojo::ArrayDataView<bool>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadBools(UserType* output) const {
    
    CHECK(is_bools());
    return mojo::internal::Deserialize<mojo::ArrayDataView<bool>>(
        data_->data.f_bools.Get(), output, message_);
  }
  bool is_str() const { return data_->tag == Tag::kStr; }
  inline void GetStrDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadStr(UserType* output) const {
    
    CHECK(is_str());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_str.Get(), output, message_);
  }
  bool is_reals() const { return data_->tag == Tag::kReals; }
  inline void GetRealsDataView(
      mojo::ArrayDataView<double>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadReals(UserType* output) const {
    
    CHECK(is_reals());
    return mojo::internal::Deserialize<mojo::ArrayDataView<double>>(
        data_->data.f_reals.Get(), output, message_);
  }

 private:
  internal::GesturePropValue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // ui::ozone::mojom

namespace std {

template <>
struct hash<::ui::ozone::mojom::SetGesturePropErrorCode>
    : public mojo::internal::EnumHashImpl<::ui::ozone::mojom::SetGesturePropErrorCode> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::ozone::mojom::SetGesturePropErrorCode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ui::ozone::mojom::SetGesturePropErrorCode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ui::ozone::mojom::SetGesturePropErrorCode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::ozone::mojom::GesturePropValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::ui::ozone::mojom::GesturePropValueDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::ui::ozone::mojom::internal::GesturePropValue_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::ui::ozone::mojom::GesturePropValueDataView::Tag::kInts: {
        decltype(Traits::ints(input))
            in_ints = Traits::ints(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_ints)::BaseType>
            value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& ints_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
            in_ints, value_fragment, &ints_validate_params);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null ints in GesturePropValue union");
        fragment->data.f_ints.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::ui::ozone::mojom::GesturePropValueDataView::Tag::kShorts: {
        decltype(Traits::shorts(input))
            in_shorts = Traits::shorts(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_shorts)::BaseType>
            value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& shorts_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        mojo::internal::Serialize<mojo::ArrayDataView<int16_t>>(
            in_shorts, value_fragment, &shorts_validate_params);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null shorts in GesturePropValue union");
        fragment->data.f_shorts.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::ui::ozone::mojom::GesturePropValueDataView::Tag::kBools: {
        decltype(Traits::bools(input))
            in_bools = Traits::bools(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_bools)::BaseType>
            value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& bools_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        mojo::internal::Serialize<mojo::ArrayDataView<bool>>(
            in_bools, value_fragment, &bools_validate_params);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null bools in GesturePropValue union");
        fragment->data.f_bools.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::ui::ozone::mojom::GesturePropValueDataView::Tag::kStr: {
        decltype(Traits::str(input))
            in_str = Traits::str(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_str)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<mojo::StringDataView>(
            in_str, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null str in GesturePropValue union");
        fragment->data.f_str.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::ui::ozone::mojom::GesturePropValueDataView::Tag::kReals: {
        decltype(Traits::reals(input))
            in_reals = Traits::reals(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_reals)::BaseType>
            value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& reals_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        mojo::internal::Serialize<mojo::ArrayDataView<double>>(
            in_reals, value_fragment, &reals_validate_params);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null reals in GesturePropValue union");
        fragment->data.f_reals.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::ui::ozone::mojom::internal::GesturePropValue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::ui::ozone::mojom::GesturePropValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ui::ozone::mojom {

inline void GesturePropValueDataView::GetIntsDataView(
    mojo::ArrayDataView<int32_t>* output) const {
  CHECK(is_ints());
  *output = mojo::ArrayDataView<int32_t>(data_->data.f_ints.Get(), message_);
}
inline void GesturePropValueDataView::GetShortsDataView(
    mojo::ArrayDataView<int16_t>* output) const {
  CHECK(is_shorts());
  *output = mojo::ArrayDataView<int16_t>(data_->data.f_shorts.Get(), message_);
}
inline void GesturePropValueDataView::GetBoolsDataView(
    mojo::ArrayDataView<bool>* output) const {
  CHECK(is_bools());
  *output = mojo::ArrayDataView<bool>(data_->data.f_bools.Get(), message_);
}
inline void GesturePropValueDataView::GetStrDataView(
    mojo::StringDataView* output) const {
  CHECK(is_str());
  *output = mojo::StringDataView(data_->data.f_str.Get(), message_);
}
inline void GesturePropValueDataView::GetRealsDataView(
    mojo::ArrayDataView<double>* output) const {
  CHECK(is_reals());
  *output = mojo::ArrayDataView<double>(data_->data.f_reals.Get(), message_);
}


}  // ui::ozone::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::ui::ozone::mojom::SetGesturePropErrorCode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ui::ozone::mojom::SetGesturePropErrorCode value);
};

} // namespace perfetto

#endif  // UI_OZONE_PUBLIC_MOJOM_GESTURE_PROPERTIES_SERVICE_MOJOM_SHARED_H_