/* parser auto-generated by pidl */

#include "replace.h"
#include "bin/default/librpc/gen_ndr/ndr_clusapi.h"

#include "librpc/gen_ndr/ndr_winreg.h"
#include "librpc/gen_ndr/ndr_misc.h"
static enum ndr_err_code ndr_push_RPC_SECURITY_DESCRIPTOR(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct RPC_SECURITY_DESCRIPTOR *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->lpSecurityDescriptor));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cbInSecurityDescriptor));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cbOutSecurityDescriptor));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->lpSecurityDescriptor) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->cbInSecurityDescriptor));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->cbOutSecurityDescriptor));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->lpSecurityDescriptor, r->cbOutSecurityDescriptor));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_RPC_SECURITY_DESCRIPTOR(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct RPC_SECURITY_DESCRIPTOR *r)
{
	uint32_t _ptr_lpSecurityDescriptor;
	uint32_t size_lpSecurityDescriptor_1 = 0;
	uint32_t length_lpSecurityDescriptor_1 = 0;
	TALLOC_CTX *_mem_save_lpSecurityDescriptor_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpSecurityDescriptor));
		if (_ptr_lpSecurityDescriptor) {
			NDR_PULL_ALLOC(ndr, r->lpSecurityDescriptor);
		} else {
			r->lpSecurityDescriptor = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cbInSecurityDescriptor));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cbOutSecurityDescriptor));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->lpSecurityDescriptor) {
			_mem_save_lpSecurityDescriptor_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->lpSecurityDescriptor, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->lpSecurityDescriptor));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->lpSecurityDescriptor));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->lpSecurityDescriptor, &size_lpSecurityDescriptor_1));
			NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->lpSecurityDescriptor, &length_lpSecurityDescriptor_1));
			if (length_lpSecurityDescriptor_1 > size_lpSecurityDescriptor_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpSecurityDescriptor_1, length_lpSecurityDescriptor_1);
			}
			NDR_PULL_ALLOC_N(ndr, r->lpSecurityDescriptor, size_lpSecurityDescriptor_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->lpSecurityDescriptor, length_lpSecurityDescriptor_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpSecurityDescriptor_0, 0);
		}
		if (r->lpSecurityDescriptor) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->lpSecurityDescriptor, r->cbInSecurityDescriptor));
		}
		if (r->lpSecurityDescriptor) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->lpSecurityDescriptor, r->cbOutSecurityDescriptor));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_RPC_SECURITY_DESCRIPTOR(struct ndr_print *ndr, const char *name, const struct RPC_SECURITY_DESCRIPTOR *r)
{
	ndr_print_struct(ndr, name, "RPC_SECURITY_DESCRIPTOR");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "lpSecurityDescriptor", r->lpSecurityDescriptor);
	ndr->depth++;
	if (r->lpSecurityDescriptor) {
		ndr_print_array_uint8(ndr, "lpSecurityDescriptor", r->lpSecurityDescriptor, r->cbOutSecurityDescriptor);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "cbInSecurityDescriptor", r->cbInSecurityDescriptor);
	ndr_print_uint32(ndr, "cbOutSecurityDescriptor", r->cbOutSecurityDescriptor);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_RPC_SECURITY_ATTRIBUTES(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct RPC_SECURITY_ATTRIBUTES *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->nLength));
		NDR_CHECK(ndr_push_RPC_SECURITY_DESCRIPTOR(ndr, NDR_SCALARS, &r->RpcSecurityDescriptor));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->bInheritHandle));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_RPC_SECURITY_DESCRIPTOR(ndr, NDR_BUFFERS, &r->RpcSecurityDescriptor));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_RPC_SECURITY_ATTRIBUTES(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct RPC_SECURITY_ATTRIBUTES *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->nLength));
		NDR_CHECK(ndr_pull_RPC_SECURITY_DESCRIPTOR(ndr, NDR_SCALARS, &r->RpcSecurityDescriptor));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->bInheritHandle));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_RPC_SECURITY_DESCRIPTOR(ndr, NDR_BUFFERS, &r->RpcSecurityDescriptor));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_RPC_SECURITY_ATTRIBUTES(struct ndr_print *ndr, const char *name, const struct RPC_SECURITY_ATTRIBUTES *r)
{
	ndr_print_struct(ndr, name, "RPC_SECURITY_ATTRIBUTES");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "nLength", r->nLength);
	ndr_print_RPC_SECURITY_DESCRIPTOR(ndr, "RpcSecurityDescriptor", &r->RpcSecurityDescriptor);
	ndr_print_int32(ndr, "bInheritHandle", r->bInheritHandle);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_CLUSTER_OPERATIONAL_VERSION_INFO(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct CLUSTER_OPERATIONAL_VERSION_INFO *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 20));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwClusterHighestVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwClusterLowestVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwFlags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_CLUSTER_OPERATIONAL_VERSION_INFO(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct CLUSTER_OPERATIONAL_VERSION_INFO *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwSize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwClusterHighestVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwClusterLowestVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwFlags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CLUSTER_OPERATIONAL_VERSION_INFO(struct ndr_print *ndr, const char *name, const struct CLUSTER_OPERATIONAL_VERSION_INFO *r)
{
	ndr_print_struct(ndr, name, "CLUSTER_OPERATIONAL_VERSION_INFO");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwSize", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?20:r->dwSize);
	ndr_print_uint32(ndr, "dwClusterHighestVersion", r->dwClusterHighestVersion);
	ndr_print_uint32(ndr, "dwClusterLowestVersion", r->dwClusterLowestVersion);
	ndr_print_uint32(ndr, "dwFlags", r->dwFlags);
	ndr_print_uint32(ndr, "dwReserved", r->dwReserved);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_IDL_CLUSTER_SET_PASSWORD_STATUS(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct IDL_CLUSTER_SET_PASSWORD_STATUS *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->NodeId));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->SetAttempted));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ReturnStatus));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_IDL_CLUSTER_SET_PASSWORD_STATUS(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct IDL_CLUSTER_SET_PASSWORD_STATUS *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->NodeId));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->SetAttempted));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ReturnStatus));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_IDL_CLUSTER_SET_PASSWORD_STATUS(struct ndr_print *ndr, const char *name, const struct IDL_CLUSTER_SET_PASSWORD_STATUS *r)
{
	ndr_print_struct(ndr, name, "IDL_CLUSTER_SET_PASSWORD_STATUS");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "NodeId", r->NodeId);
	ndr_print_uint8(ndr, "SetAttempted", r->SetAttempted);
	ndr_print_uint32(ndr, "ReturnStatus", r->ReturnStatus);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_IDL_CLUSTER_SET_PASSWORD_FLAGS(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum IDL_CLUSTER_SET_PASSWORD_FLAGS r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_IDL_CLUSTER_SET_PASSWORD_FLAGS(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum IDL_CLUSTER_SET_PASSWORD_FLAGS *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_IDL_CLUSTER_SET_PASSWORD_FLAGS(struct ndr_print *ndr, const char *name, enum IDL_CLUSTER_SET_PASSWORD_FLAGS r)
{
	const char *val = NULL;

	switch (r) {
		case IDL_CLUSTER_SET_PASSWORD_IGNORE_DOWN_NODES: val = "IDL_CLUSTER_SET_PASSWORD_IGNORE_DOWN_NODES"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_CLUSTER_CREATE_GROUP_INFO_RPC(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct CLUSTER_CREATE_GROUP_INFO_RPC *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwGroupType));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_CLUSTER_CREATE_GROUP_INFO_RPC(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct CLUSTER_CREATE_GROUP_INFO_RPC *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwGroupType));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CLUSTER_CREATE_GROUP_INFO_RPC(struct ndr_print *ndr, const char *name, const struct CLUSTER_CREATE_GROUP_INFO_RPC *r)
{
	ndr_print_struct(ndr, name, "CLUSTER_CREATE_GROUP_INFO_RPC");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwVersion", r->dwVersion);
	ndr_print_uint32(ndr, "dwGroupType", r->dwGroupType);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_ClusterEnumType(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ClusterEnumType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ClusterEnumType(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CLUSTER_ENUM_NODE", CLUSTER_ENUM_NODE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CLUSTER_ENUM_RESTYPE", CLUSTER_ENUM_RESTYPE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CLUSTER_ENUM_RESOURCE", CLUSTER_ENUM_RESOURCE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CLUSTER_ENUM_GROUP", CLUSTER_ENUM_GROUP, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CLUSTER_ENUM_NETWORK", CLUSTER_ENUM_NETWORK, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CLUSTER_ENUM_NETINTERFACE", CLUSTER_ENUM_NETINTERFACE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CLUSTER_ENUM_INTERNAL_NETWORK", CLUSTER_ENUM_INTERNAL_NETWORK, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CLUSTER_ENUM_SHARED_VOLUME_RESOURCE", CLUSTER_ENUM_SHARED_VOLUME_RESOURCE, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_ENUM_ENTRY(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ENUM_ENTRY *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_ClusterEnumType(ndr, NDR_SCALARS, r->Type));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->Name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->Name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->Name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->Name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->Name, ndr_charset_length(r->Name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ENUM_ENTRY(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ENUM_ENTRY *r)
{
	uint32_t _ptr_Name;
	uint32_t size_Name_1 = 0;
	uint32_t length_Name_1 = 0;
	TALLOC_CTX *_mem_save_Name_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_ClusterEnumType(ndr, NDR_SCALARS, &r->Type));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Name));
		if (_ptr_Name) {
			NDR_PULL_ALLOC(ndr, r->Name);
		} else {
			r->Name = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->Name) {
			_mem_save_Name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->Name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->Name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->Name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->Name, &size_Name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->Name, &length_Name_1));
			if (length_Name_1 > size_Name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_Name_1, length_Name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_Name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->Name, length_Name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Name_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ENUM_ENTRY(struct ndr_print *ndr, const char *name, const struct ENUM_ENTRY *r)
{
	ndr_print_struct(ndr, name, "ENUM_ENTRY");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ClusterEnumType(ndr, "Type", r->Type);
	ndr_print_ptr(ndr, "Name", r->Name);
	ndr->depth++;
	if (r->Name) {
		ndr_print_string(ndr, "Name", r->Name);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_ENUM_LIST(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ENUM_LIST *r)
{
	uint32_t cntr_Entry_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->EntryCount));
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->EntryCount));
		for (cntr_Entry_0 = 0; cntr_Entry_0 < (r->EntryCount); cntr_Entry_0++) {
			NDR_CHECK(ndr_push_ENUM_ENTRY(ndr, NDR_SCALARS, &r->Entry[cntr_Entry_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_Entry_0 = 0; cntr_Entry_0 < (r->EntryCount); cntr_Entry_0++) {
			NDR_CHECK(ndr_push_ENUM_ENTRY(ndr, NDR_BUFFERS, &r->Entry[cntr_Entry_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ENUM_LIST(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ENUM_LIST *r)
{
	uint32_t size_Entry_0 = 0;
	uint32_t cntr_Entry_0;
	TALLOC_CTX *_mem_save_Entry_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->Entry));
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->EntryCount));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->Entry, &size_Entry_0));
		NDR_PULL_ALLOC_N(ndr, r->Entry, size_Entry_0);
		_mem_save_Entry_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->Entry, 0);
		for (cntr_Entry_0 = 0; cntr_Entry_0 < (size_Entry_0); cntr_Entry_0++) {
			NDR_CHECK(ndr_pull_ENUM_ENTRY(ndr, NDR_SCALARS, &r->Entry[cntr_Entry_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Entry_0, 0);
		if (r->Entry) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->Entry, r->EntryCount));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->Entry, &size_Entry_0));
		_mem_save_Entry_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->Entry, 0);
		for (cntr_Entry_0 = 0; cntr_Entry_0 < (size_Entry_0); cntr_Entry_0++) {
			NDR_CHECK(ndr_pull_ENUM_ENTRY(ndr, NDR_BUFFERS, &r->Entry[cntr_Entry_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Entry_0, 0);
		for (cntr_Entry_0 = 0; cntr_Entry_0 < (size_Entry_0); cntr_Entry_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ENUM_LIST(struct ndr_print *ndr, const char *name, const struct ENUM_LIST *r)
{
	uint32_t cntr_Entry_0;
	ndr_print_struct(ndr, name, "ENUM_LIST");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "EntryCount", r->EntryCount);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "Entry", (uint32_t)(r->EntryCount));
	ndr->depth++;
	for (cntr_Entry_0 = 0; cntr_Entry_0 < (r->EntryCount); cntr_Entry_0++) {
		ndr_print_ENUM_ENTRY(ndr, "Entry", &r->Entry[cntr_Entry_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_GROUP_ENUM_ENTRY(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct GROUP_ENUM_ENTRY *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->Name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->Id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwState));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->Owner));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwFlags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cbProperties));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->Properties));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cbRoProperties));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->RoProperties));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->Name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->Name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->Name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->Name, ndr_charset_length(r->Name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->Id) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->Id, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->Id, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->Id, ndr_charset_length(r->Id, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->Owner) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->Owner, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->Owner, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->Owner, ndr_charset_length(r->Owner, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->Properties) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->cbProperties));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->Properties, r->cbProperties));
		}
		if (r->RoProperties) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->cbRoProperties));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->RoProperties, r->cbRoProperties));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_GROUP_ENUM_ENTRY(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct GROUP_ENUM_ENTRY *r)
{
	uint32_t _ptr_Name;
	uint32_t size_Name_1 = 0;
	uint32_t length_Name_1 = 0;
	TALLOC_CTX *_mem_save_Name_0 = NULL;
	uint32_t _ptr_Id;
	uint32_t size_Id_1 = 0;
	uint32_t length_Id_1 = 0;
	TALLOC_CTX *_mem_save_Id_0 = NULL;
	uint32_t _ptr_Owner;
	uint32_t size_Owner_1 = 0;
	uint32_t length_Owner_1 = 0;
	TALLOC_CTX *_mem_save_Owner_0 = NULL;
	uint32_t _ptr_Properties;
	uint32_t size_Properties_1 = 0;
	TALLOC_CTX *_mem_save_Properties_0 = NULL;
	uint32_t _ptr_RoProperties;
	uint32_t size_RoProperties_1 = 0;
	TALLOC_CTX *_mem_save_RoProperties_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Name));
		if (_ptr_Name) {
			NDR_PULL_ALLOC(ndr, r->Name);
		} else {
			r->Name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Id));
		if (_ptr_Id) {
			NDR_PULL_ALLOC(ndr, r->Id);
		} else {
			r->Id = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwState));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Owner));
		if (_ptr_Owner) {
			NDR_PULL_ALLOC(ndr, r->Owner);
		} else {
			r->Owner = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwFlags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cbProperties));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Properties));
		if (_ptr_Properties) {
			NDR_PULL_ALLOC(ndr, r->Properties);
		} else {
			r->Properties = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cbRoProperties));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_RoProperties));
		if (_ptr_RoProperties) {
			NDR_PULL_ALLOC(ndr, r->RoProperties);
		} else {
			r->RoProperties = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->Name) {
			_mem_save_Name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->Name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->Name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->Name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->Name, &size_Name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->Name, &length_Name_1));
			if (length_Name_1 > size_Name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_Name_1, length_Name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_Name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->Name, length_Name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Name_0, 0);
		}
		if (r->Id) {
			_mem_save_Id_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->Id, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->Id));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->Id));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->Id, &size_Id_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->Id, &length_Id_1));
			if (length_Id_1 > size_Id_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_Id_1, length_Id_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_Id_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->Id, length_Id_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Id_0, 0);
		}
		if (r->Owner) {
			_mem_save_Owner_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->Owner, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->Owner));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->Owner));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->Owner, &size_Owner_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->Owner, &length_Owner_1));
			if (length_Owner_1 > size_Owner_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_Owner_1, length_Owner_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_Owner_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->Owner, length_Owner_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Owner_0, 0);
		}
		if (r->Properties) {
			_mem_save_Properties_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->Properties, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->Properties));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->Properties, &size_Properties_1));
			NDR_PULL_ALLOC_N(ndr, r->Properties, size_Properties_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->Properties, size_Properties_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Properties_0, 0);
		}
		if (r->RoProperties) {
			_mem_save_RoProperties_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->RoProperties, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->RoProperties));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->RoProperties, &size_RoProperties_1));
			NDR_PULL_ALLOC_N(ndr, r->RoProperties, size_RoProperties_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->RoProperties, size_RoProperties_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_RoProperties_0, 0);
		}
		if (r->Properties) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->Properties, r->cbProperties));
		}
		if (r->RoProperties) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->RoProperties, r->cbRoProperties));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_GROUP_ENUM_ENTRY(struct ndr_print *ndr, const char *name, const struct GROUP_ENUM_ENTRY *r)
{
	ndr_print_struct(ndr, name, "GROUP_ENUM_ENTRY");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "Name", r->Name);
	ndr->depth++;
	if (r->Name) {
		ndr_print_string(ndr, "Name", r->Name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "Id", r->Id);
	ndr->depth++;
	if (r->Id) {
		ndr_print_string(ndr, "Id", r->Id);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "dwState", r->dwState);
	ndr_print_ptr(ndr, "Owner", r->Owner);
	ndr->depth++;
	if (r->Owner) {
		ndr_print_string(ndr, "Owner", r->Owner);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "dwFlags", r->dwFlags);
	ndr_print_uint32(ndr, "cbProperties", r->cbProperties);
	ndr_print_ptr(ndr, "Properties", r->Properties);
	ndr->depth++;
	if (r->Properties) {
		ndr_print_array_uint8(ndr, "Properties", r->Properties, r->cbProperties);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "cbRoProperties", r->cbRoProperties);
	ndr_print_ptr(ndr, "RoProperties", r->RoProperties);
	ndr->depth++;
	if (r->RoProperties) {
		ndr_print_array_uint8(ndr, "RoProperties", r->RoProperties, r->cbRoProperties);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_RESOURCE_ENUM_ENTRY(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct RESOURCE_ENUM_ENTRY *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->Name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->Id));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->OwnerName));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->OwnerId));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cbProperties));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->Properties));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cbRoProperties));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->RoProperties));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->Name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->Name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->Name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->Name, ndr_charset_length(r->Name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->Id) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->Id, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->Id, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->Id, ndr_charset_length(r->Id, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->OwnerName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->OwnerName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->OwnerName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->OwnerName, ndr_charset_length(r->OwnerName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->OwnerId) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->OwnerId, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->OwnerId, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->OwnerId, ndr_charset_length(r->OwnerId, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->Properties) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->cbProperties));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->Properties, r->cbProperties));
		}
		if (r->RoProperties) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->cbRoProperties));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->RoProperties, r->cbRoProperties));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_RESOURCE_ENUM_ENTRY(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct RESOURCE_ENUM_ENTRY *r)
{
	uint32_t _ptr_Name;
	uint32_t size_Name_1 = 0;
	uint32_t length_Name_1 = 0;
	TALLOC_CTX *_mem_save_Name_0 = NULL;
	uint32_t _ptr_Id;
	uint32_t size_Id_1 = 0;
	uint32_t length_Id_1 = 0;
	TALLOC_CTX *_mem_save_Id_0 = NULL;
	uint32_t _ptr_OwnerName;
	uint32_t size_OwnerName_1 = 0;
	uint32_t length_OwnerName_1 = 0;
	TALLOC_CTX *_mem_save_OwnerName_0 = NULL;
	uint32_t _ptr_OwnerId;
	uint32_t size_OwnerId_1 = 0;
	uint32_t length_OwnerId_1 = 0;
	TALLOC_CTX *_mem_save_OwnerId_0 = NULL;
	uint32_t _ptr_Properties;
	uint32_t size_Properties_1 = 0;
	TALLOC_CTX *_mem_save_Properties_0 = NULL;
	uint32_t _ptr_RoProperties;
	uint32_t size_RoProperties_1 = 0;
	TALLOC_CTX *_mem_save_RoProperties_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Name));
		if (_ptr_Name) {
			NDR_PULL_ALLOC(ndr, r->Name);
		} else {
			r->Name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Id));
		if (_ptr_Id) {
			NDR_PULL_ALLOC(ndr, r->Id);
		} else {
			r->Id = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_OwnerName));
		if (_ptr_OwnerName) {
			NDR_PULL_ALLOC(ndr, r->OwnerName);
		} else {
			r->OwnerName = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_OwnerId));
		if (_ptr_OwnerId) {
			NDR_PULL_ALLOC(ndr, r->OwnerId);
		} else {
			r->OwnerId = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cbProperties));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Properties));
		if (_ptr_Properties) {
			NDR_PULL_ALLOC(ndr, r->Properties);
		} else {
			r->Properties = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cbRoProperties));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_RoProperties));
		if (_ptr_RoProperties) {
			NDR_PULL_ALLOC(ndr, r->RoProperties);
		} else {
			r->RoProperties = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->Name) {
			_mem_save_Name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->Name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->Name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->Name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->Name, &size_Name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->Name, &length_Name_1));
			if (length_Name_1 > size_Name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_Name_1, length_Name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_Name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->Name, length_Name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Name_0, 0);
		}
		if (r->Id) {
			_mem_save_Id_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->Id, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->Id));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->Id));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->Id, &size_Id_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->Id, &length_Id_1));
			if (length_Id_1 > size_Id_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_Id_1, length_Id_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_Id_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->Id, length_Id_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Id_0, 0);
		}
		if (r->OwnerName) {
			_mem_save_OwnerName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->OwnerName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->OwnerName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->OwnerName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->OwnerName, &size_OwnerName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->OwnerName, &length_OwnerName_1));
			if (length_OwnerName_1 > size_OwnerName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_OwnerName_1, length_OwnerName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_OwnerName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->OwnerName, length_OwnerName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_OwnerName_0, 0);
		}
		if (r->OwnerId) {
			_mem_save_OwnerId_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->OwnerId, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->OwnerId));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->OwnerId));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->OwnerId, &size_OwnerId_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->OwnerId, &length_OwnerId_1));
			if (length_OwnerId_1 > size_OwnerId_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_OwnerId_1, length_OwnerId_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_OwnerId_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->OwnerId, length_OwnerId_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_OwnerId_0, 0);
		}
		if (r->Properties) {
			_mem_save_Properties_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->Properties, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->Properties));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->Properties, &size_Properties_1));
			NDR_PULL_ALLOC_N(ndr, r->Properties, size_Properties_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->Properties, size_Properties_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Properties_0, 0);
		}
		if (r->RoProperties) {
			_mem_save_RoProperties_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->RoProperties, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->RoProperties));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->RoProperties, &size_RoProperties_1));
			NDR_PULL_ALLOC_N(ndr, r->RoProperties, size_RoProperties_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->RoProperties, size_RoProperties_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_RoProperties_0, 0);
		}
		if (r->Properties) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->Properties, r->cbProperties));
		}
		if (r->RoProperties) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->RoProperties, r->cbRoProperties));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_RESOURCE_ENUM_ENTRY(struct ndr_print *ndr, const char *name, const struct RESOURCE_ENUM_ENTRY *r)
{
	ndr_print_struct(ndr, name, "RESOURCE_ENUM_ENTRY");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "Name", r->Name);
	ndr->depth++;
	if (r->Name) {
		ndr_print_string(ndr, "Name", r->Name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "Id", r->Id);
	ndr->depth++;
	if (r->Id) {
		ndr_print_string(ndr, "Id", r->Id);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "OwnerName", r->OwnerName);
	ndr->depth++;
	if (r->OwnerName) {
		ndr_print_string(ndr, "OwnerName", r->OwnerName);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "OwnerId", r->OwnerId);
	ndr->depth++;
	if (r->OwnerId) {
		ndr_print_string(ndr, "OwnerId", r->OwnerId);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "cbProperties", r->cbProperties);
	ndr_print_ptr(ndr, "Properties", r->Properties);
	ndr->depth++;
	if (r->Properties) {
		ndr_print_array_uint8(ndr, "Properties", r->Properties, r->cbProperties);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "cbRoProperties", r->cbRoProperties);
	ndr_print_ptr(ndr, "RoProperties", r->RoProperties);
	ndr->depth++;
	if (r->RoProperties) {
		ndr_print_array_uint8(ndr, "RoProperties", r->RoProperties, r->cbRoProperties);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_GROUP_ENUM_LIST(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct GROUP_ENUM_LIST *r)
{
	uint32_t cntr_Entry_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->EntryCount));
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->EntryCount));
		for (cntr_Entry_0 = 0; cntr_Entry_0 < (r->EntryCount); cntr_Entry_0++) {
			NDR_CHECK(ndr_push_GROUP_ENUM_ENTRY(ndr, NDR_SCALARS, &r->Entry[cntr_Entry_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_Entry_0 = 0; cntr_Entry_0 < (r->EntryCount); cntr_Entry_0++) {
			NDR_CHECK(ndr_push_GROUP_ENUM_ENTRY(ndr, NDR_BUFFERS, &r->Entry[cntr_Entry_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_GROUP_ENUM_LIST(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct GROUP_ENUM_LIST *r)
{
	uint32_t size_Entry_0 = 0;
	uint32_t cntr_Entry_0;
	TALLOC_CTX *_mem_save_Entry_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->Entry));
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->EntryCount));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->Entry, &size_Entry_0));
		NDR_PULL_ALLOC_N(ndr, r->Entry, size_Entry_0);
		_mem_save_Entry_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->Entry, 0);
		for (cntr_Entry_0 = 0; cntr_Entry_0 < (size_Entry_0); cntr_Entry_0++) {
			NDR_CHECK(ndr_pull_GROUP_ENUM_ENTRY(ndr, NDR_SCALARS, &r->Entry[cntr_Entry_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Entry_0, 0);
		if (r->Entry) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->Entry, r->EntryCount));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->Entry, &size_Entry_0));
		_mem_save_Entry_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->Entry, 0);
		for (cntr_Entry_0 = 0; cntr_Entry_0 < (size_Entry_0); cntr_Entry_0++) {
			NDR_CHECK(ndr_pull_GROUP_ENUM_ENTRY(ndr, NDR_BUFFERS, &r->Entry[cntr_Entry_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Entry_0, 0);
		for (cntr_Entry_0 = 0; cntr_Entry_0 < (size_Entry_0); cntr_Entry_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_GROUP_ENUM_LIST(struct ndr_print *ndr, const char *name, const struct GROUP_ENUM_LIST *r)
{
	uint32_t cntr_Entry_0;
	ndr_print_struct(ndr, name, "GROUP_ENUM_LIST");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "EntryCount", r->EntryCount);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "Entry", (uint32_t)(r->EntryCount));
	ndr->depth++;
	for (cntr_Entry_0 = 0; cntr_Entry_0 < (r->EntryCount); cntr_Entry_0++) {
		ndr_print_GROUP_ENUM_ENTRY(ndr, "Entry", &r->Entry[cntr_Entry_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_RESOURCE_ENUM_LIST(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct RESOURCE_ENUM_LIST *r)
{
	uint32_t cntr_Entry_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->EntryCount));
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->EntryCount));
		for (cntr_Entry_0 = 0; cntr_Entry_0 < (r->EntryCount); cntr_Entry_0++) {
			NDR_CHECK(ndr_push_RESOURCE_ENUM_ENTRY(ndr, NDR_SCALARS, &r->Entry[cntr_Entry_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_Entry_0 = 0; cntr_Entry_0 < (r->EntryCount); cntr_Entry_0++) {
			NDR_CHECK(ndr_push_RESOURCE_ENUM_ENTRY(ndr, NDR_BUFFERS, &r->Entry[cntr_Entry_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_RESOURCE_ENUM_LIST(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct RESOURCE_ENUM_LIST *r)
{
	uint32_t size_Entry_0 = 0;
	uint32_t cntr_Entry_0;
	TALLOC_CTX *_mem_save_Entry_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->Entry));
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->EntryCount));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->Entry, &size_Entry_0));
		NDR_PULL_ALLOC_N(ndr, r->Entry, size_Entry_0);
		_mem_save_Entry_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->Entry, 0);
		for (cntr_Entry_0 = 0; cntr_Entry_0 < (size_Entry_0); cntr_Entry_0++) {
			NDR_CHECK(ndr_pull_RESOURCE_ENUM_ENTRY(ndr, NDR_SCALARS, &r->Entry[cntr_Entry_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Entry_0, 0);
		if (r->Entry) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->Entry, r->EntryCount));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->Entry, &size_Entry_0));
		_mem_save_Entry_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->Entry, 0);
		for (cntr_Entry_0 = 0; cntr_Entry_0 < (size_Entry_0); cntr_Entry_0++) {
			NDR_CHECK(ndr_pull_RESOURCE_ENUM_ENTRY(ndr, NDR_BUFFERS, &r->Entry[cntr_Entry_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Entry_0, 0);
		for (cntr_Entry_0 = 0; cntr_Entry_0 < (size_Entry_0); cntr_Entry_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_RESOURCE_ENUM_LIST(struct ndr_print *ndr, const char *name, const struct RESOURCE_ENUM_LIST *r)
{
	uint32_t cntr_Entry_0;
	ndr_print_struct(ndr, name, "RESOURCE_ENUM_LIST");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "EntryCount", r->EntryCount);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "Entry", (uint32_t)(r->EntryCount));
	ndr->depth++;
	for (cntr_Entry_0 = 0; cntr_Entry_0 < (r->EntryCount); cntr_Entry_0++) {
		ndr_print_RESOURCE_ENUM_ENTRY(ndr, "Entry", &r->Entry[cntr_Entry_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CreateResourceFlags(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum clusapi_CreateResourceFlags r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CreateResourceFlags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum clusapi_CreateResourceFlags *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CreateResourceFlags(struct ndr_print *ndr, const char *name, enum clusapi_CreateResourceFlags r)
{
	const char *val = NULL;

	switch (r) {
		case CLUSTER_RESOURCE_DEFAULT_MONITOR: val = "CLUSTER_RESOURCE_DEFAULT_MONITOR"; break;
		case CLUSTER_RESOURCE_SEPARATE_MONITOR: val = "CLUSTER_RESOURCE_SEPARATE_MONITOR"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_clusapi_ClusterResourceState(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum clusapi_ClusterResourceState r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_ClusterResourceState(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum clusapi_ClusterResourceState *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_ClusterResourceState(struct ndr_print *ndr, const char *name, enum clusapi_ClusterResourceState r)
{
	const char *val = NULL;

	switch (r) {
		case ClusterResourceInitializing: val = "ClusterResourceInitializing"; break;
		case ClusterResourceOnline: val = "ClusterResourceOnline"; break;
		case ClusterResourceOffline: val = "ClusterResourceOffline"; break;
		case ClusterResourceFailed: val = "ClusterResourceFailed"; break;
		case ClusterResourceOnlinePending: val = "ClusterResourceOnlinePending"; break;
		case ClusterResourceOfflinePending: val = "ClusterResourceOfflinePending"; break;
		case ClusterResourceStateUnknown: val = "ClusterResourceStateUnknown"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_clusapi_ClusterGroupState(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum clusapi_ClusterGroupState r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_ClusterGroupState(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum clusapi_ClusterGroupState *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_ClusterGroupState(struct ndr_print *ndr, const char *name, enum clusapi_ClusterGroupState r)
{
	const char *val = NULL;

	switch (r) {
		case ClusterGroupOnline: val = "ClusterGroupOnline"; break;
		case ClusterGroupOffline: val = "ClusterGroupOffline"; break;
		case ClusterGroupFailed: val = "ClusterGroupFailed"; break;
		case ClusterGroupPartialOnline: val = "ClusterGroupPartialOnline"; break;
		case ClusterGroupPending: val = "ClusterGroupPending"; break;
		case ClusterGroupStateUnknown: val = "ClusterGroupStateUnknown"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_ClusterGroupEnumType(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ClusterGroupEnumType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ClusterGroupEnumType(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CLUSTER_GROUP_ENUM_CONTAINS", CLUSTER_GROUP_ENUM_CONTAINS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CLUSTER_GROUP_ENUM_NODES", CLUSTER_GROUP_ENUM_NODES, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_ClusterNodeState(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum clusapi_ClusterNodeState r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_ClusterNodeState(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum clusapi_ClusterNodeState *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_ClusterNodeState(struct ndr_print *ndr, const char *name, enum clusapi_ClusterNodeState r)
{
	const char *val = NULL;

	switch (r) {
		case ClusterNodeUp: val = "ClusterNodeUp"; break;
		case ClusterNodeDown: val = "ClusterNodeDown"; break;
		case ClusterNodePaused: val = "ClusterNodePaused"; break;
		case ClusterNodeJoining: val = "ClusterNodeJoining"; break;
		case ClusterNodeStateUnknown: val = "ClusterNodeStateUnknown"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_clusapi_ResourceClass(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum clusapi_ResourceClass r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_ResourceClass(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum clusapi_ResourceClass *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_ResourceClass(struct ndr_print *ndr, const char *name, enum clusapi_ResourceClass r)
{
	const char *val = NULL;

	switch (r) {
		case CLUS_RESCLASS_UNKNOWN: val = "CLUS_RESCLASS_UNKNOWN"; break;
		case CLUS_RESCLASS_STORAGE: val = "CLUS_RESCLASS_STORAGE"; break;
		case CLUS_RESCLASS_NETWORK: val = "CLUS_RESCLASS_NETWORK"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_CLUS_RESOURCE_CLASS_INFO(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct CLUS_RESOURCE_CLASS_INFO *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_clusapi_ResourceClass(ndr, NDR_SCALARS, r->Class));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->SubClass));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_CLUS_RESOURCE_CLASS_INFO(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct CLUS_RESOURCE_CLASS_INFO *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_clusapi_ResourceClass(ndr, NDR_SCALARS, &r->Class));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->SubClass));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_CLUS_RESOURCE_CLASS_INFO(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct CLUS_RESOURCE_CLASS_INFO *r)
{
	ndr_print_CLUS_RESOURCE_CLASS_INFO(ndr, name, r);
}

_PUBLIC_ void ndr_print_CLUS_RESOURCE_CLASS_INFO(struct ndr_print *ndr, const char *name, const struct CLUS_RESOURCE_CLASS_INFO *r)
{
	ndr_print_struct(ndr, name, "CLUS_RESOURCE_CLASS_INFO");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_clusapi_ResourceClass(ndr, "Class", r->Class);
	ndr_print_uint32(ndr, "SubClass", r->SubClass);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_ResourceControlCode(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum clusapi_ResourceControlCode r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_ResourceControlCode(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum clusapi_ResourceControlCode *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_ResourceControlCode(struct ndr_print *ndr, const char *name, enum clusapi_ResourceControlCode r)
{
	const char *val = NULL;

	switch (r) {
		case CLUSCTL_RESOURCE_UNKNOWN: val = "CLUSCTL_RESOURCE_UNKNOWN"; break;
		case CLUSCTL_RESOURCE_GET_CHARACTERISTICS: val = "CLUSCTL_RESOURCE_GET_CHARACTERISTICS"; break;
		case CLUSCTL_RESOURCE_GET_FLAGS: val = "CLUSCTL_RESOURCE_GET_FLAGS"; break;
		case CLUSCTL_RESOURCE_GET_CLASS_INFO: val = "CLUSCTL_RESOURCE_GET_CLASS_INFO"; break;
		case CLUSCTL_RESOURCE_GET_REQUIRED_DEPENDENCIES: val = "CLUSCTL_RESOURCE_GET_REQUIRED_DEPENDENCIES"; break;
		case CLUSCTL_RESOURCE_GET_NAME: val = "CLUSCTL_RESOURCE_GET_NAME"; break;
		case CLUSCTL_RESOURCE_GET_RESOURCE_TYPE: val = "CLUSCTL_RESOURCE_GET_RESOURCE_TYPE"; break;
		case CLUSCTL_RESOURCE_GET_ID: val = "CLUSCTL_RESOURCE_GET_ID"; break;
		case CLUSCTL_RESOURCE_ENUM_COMMON_PROPERTIES: val = "CLUSCTL_RESOURCE_ENUM_COMMON_PROPERTIES"; break;
		case CLUSCTL_RESOURCE_GET_RO_COMMON_PROPERTIES: val = "CLUSCTL_RESOURCE_GET_RO_COMMON_PROPERTIES"; break;
		case CLUSCTL_RESOURCE_GET_COMMON_PROPERTIES: val = "CLUSCTL_RESOURCE_GET_COMMON_PROPERTIES"; break;
		case CLUSCTL_RESOURCE_SET_COMMON_PROPERTIES: val = "CLUSCTL_RESOURCE_SET_COMMON_PROPERTIES"; break;
		case CLUSCTL_RESOURCE_VALIDATE_COMMON_PROPERTIES: val = "CLUSCTL_RESOURCE_VALIDATE_COMMON_PROPERTIES"; break;
		case CLUSCTL_RESOURCE_GET_COMMON_PROPERTY_FMTS: val = "CLUSCTL_RESOURCE_GET_COMMON_PROPERTY_FMTS"; break;
		case CLUSCTL_RESOURCE_ENUM_PRIVATE_PROPERTIES: val = "CLUSCTL_RESOURCE_ENUM_PRIVATE_PROPERTIES"; break;
		case CLUSCTL_RESOURCE_GET_RO_PRIVATE_PROPERTIES: val = "CLUSCTL_RESOURCE_GET_RO_PRIVATE_PROPERTIES"; break;
		case CLUSCTL_RESOURCE_GET_PRIVATE_PROPERTIES: val = "CLUSCTL_RESOURCE_GET_PRIVATE_PROPERTIES"; break;
		case CLUSCTL_RESOURCE_SET_PRIVATE_PROPERTIES: val = "CLUSCTL_RESOURCE_SET_PRIVATE_PROPERTIES"; break;
		case CLUSCTL_RESOURCE_VALIDATE_PRIVATE_PROPERTIES: val = "CLUSCTL_RESOURCE_VALIDATE_PRIVATE_PROPERTIES"; break;
		case CLUSCTL_RESOURCE_GET_PRIVATE_PROPERTY_FMTS: val = "CLUSCTL_RESOURCE_GET_PRIVATE_PROPERTY_FMTS"; break;
		case CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT: val = "CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT"; break;
		case CLUSCTL_RESOURCE_DELETE_REGISTRY_CHECKPOINT: val = "CLUSCTL_RESOURCE_DELETE_REGISTRY_CHECKPOINT"; break;
		case CLUSCTL_RESOURCE_GET_REGISTRY_CHECKPOINTS: val = "CLUSCTL_RESOURCE_GET_REGISTRY_CHECKPOINTS"; break;
		case CLUSCTL_RESOURCE_ADD_CRYPTO_CHECKPOINT: val = "CLUSCTL_RESOURCE_ADD_CRYPTO_CHECKPOINT"; break;
		case CLUSCTL_RESOURCE_DELETE_CRYPTO_CHECKPOINT: val = "CLUSCTL_RESOURCE_DELETE_CRYPTO_CHECKPOINT"; break;
		case CLUSCTL_RESOURCE_GET_CRYPTO_CHECKPOINTS: val = "CLUSCTL_RESOURCE_GET_CRYPTO_CHECKPOINTS"; break;
		case CLUSCTL_RESOURCE_UPGRADE_DLL: val = "CLUSCTL_RESOURCE_UPGRADE_DLL"; break;
		case CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT_64BIT: val = "CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT_64BIT"; break;
		case CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT_32BIT: val = "CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT_32BIT"; break;
		case CLUSCTL_RESOURCE_GET_NETWORK_NAME: val = "CLUSCTL_RESOURCE_GET_NETWORK_NAME"; break;
		case CLUSCTL_RESOURCE_NETNAME_REGISTER_DNS_RECORDS: val = "CLUSCTL_RESOURCE_NETNAME_REGISTER_DNS_RECORDS"; break;
		case CLUSCTL_RESOURCE_GET_DNS_NAME: val = "CLUSCTL_RESOURCE_GET_DNS_NAME"; break;
		case CLUSCTL_RESOURCE_NETNAME_SET_PWD_INFO: val = "CLUSCTL_RESOURCE_NETNAME_SET_PWD_INFO"; break;
		case CLUSCTL_RESOURCE_NETNAME_DELETE_CO: val = "CLUSCTL_RESOURCE_NETNAME_DELETE_CO"; break;
		case CLUSCTL_RESOURCE_NETNAME_VALIDATE_VCO: val = "CLUSCTL_RESOURCE_NETNAME_VALIDATE_VCO"; break;
		case CLUSCTL_RESOURCE_NETNAME_RESET_VCO: val = "CLUSCTL_RESOURCE_NETNAME_RESET_VCO"; break;
		case CLUSCTL_RESOURCE_NETNAME_CREDS_UPDATED: val = "CLUSCTL_RESOURCE_NETNAME_CREDS_UPDATED"; break;
		case CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO: val = "CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO"; break;
		case CLUSCTL_RESOURCE_STORAGE_IS_PATH_VALID: val = "CLUSCTL_RESOURCE_STORAGE_IS_PATH_VALID"; break;
		case CLUSCTL_RESOURCE_IPADDRESS_RENEW_LEASE: val = "CLUSCTL_RESOURCE_IPADDRESS_RENEW_LEASE"; break;
		case CLUSCTL_RESOURCE_IPADDRESS_RELEASE_LEASE: val = "CLUSCTL_RESOURCE_IPADDRESS_RELEASE_LEASE"; break;
		case CLUSCTL_RESOURCE_QUERY_MAINTENANCE_MODE: val = "CLUSCTL_RESOURCE_QUERY_MAINTENANCE_MODE"; break;
		case CLUSCTL_RESOURCE_SET_MAINTENANCE_MODE: val = "CLUSCTL_RESOURCE_SET_MAINTENANCE_MODE"; break;
		case CLUSCTL_RESOURCE_STORAGE_SET_DRIVELETTER: val = "CLUSCTL_RESOURCE_STORAGE_SET_DRIVELETTER"; break;
		case CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO_EX: val = "CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO_EX"; break;
		case CLUSCTL_RESOURCE_STORAGE_GET_DIRTY: val = "CLUSCTL_RESOURCE_STORAGE_GET_DIRTY"; break;
		case CLUSCTL_RESOURCE_STORAGE_GET_MOUNTPOINTS: val = "CLUSCTL_RESOURCE_STORAGE_GET_MOUNTPOINTS"; break;
		case CLUSCTL_RESOURCE_STORAGE_GET_SHARED_VOLUME_INFO: val = "CLUSCTL_RESOURCE_STORAGE_GET_SHARED_VOLUME_INFO"; break;
		case CLUSCTL_RESOURCE_VM_START_MIGRATION: val = "CLUSCTL_RESOURCE_VM_START_MIGRATION"; break;
		case CLUSCTL_RESOURCE_VM_CANCEL_MIGRATION: val = "CLUSCTL_RESOURCE_VM_CANCEL_MIGRATION"; break;
		case CLUSCTL_RESOURCE_SET_CSV_MAINTENANCE_MODE: val = "CLUSCTL_RESOURCE_SET_CSV_MAINTENANCE_MODE"; break;
		case CLUSCTL_RESOURCE_ENABLE_SHARED_VOLUME_DIRECTIO: val = "CLUSCTL_RESOURCE_ENABLE_SHARED_VOLUME_DIRECTIO"; break;
		case CLUSCTL_RESOURCE_DISABLE_SHARED_VOLUME_DIRECTIO: val = "CLUSCTL_RESOURCE_DISABLE_SHARED_VOLUME_DIRECTIO"; break;
		case CLUSCTL_RESOURCE_SET_SHARED_VOLUME_BACKUP_MODE: val = "CLUSCTL_RESOURCE_SET_SHARED_VOLUME_BACKUP_MODE"; break;
		case CLUSCTL_RESOURCE_GET_RELATED_RESOURCE_NAMES: val = "CLUSCTL_RESOURCE_GET_RELATED_RESOURCE_NAMES"; break;
		case CLUSCTL_RESOURCE_POOL_GET_DRIVE_INFO: val = "CLUSCTL_RESOURCE_POOL_GET_DRIVE_INFO"; break;
		case CLUSCTL_RESOURCE_CLOUD_WITNESS_UPDATE_TOKEN: val = "CLUSCTL_RESOURCE_CLOUD_WITNESS_UPDATE_TOKEN"; break;
		case CLUSCTL_RESOURCE_NETNAME_CHECK_OU_PERMISSIONS: val = "CLUSCTL_RESOURCE_NETNAME_CHECK_OU_PERMISSIONS"; break;
		case CLUSCTL_RESOURCE_NETNAME_CHECK_AD_STATE: val = "CLUSCTL_RESOURCE_NETNAME_CHECK_AD_STATE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_clusapi_ResourceTypeControlCode(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum clusapi_ResourceTypeControlCode r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_ResourceTypeControlCode(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum clusapi_ResourceTypeControlCode *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_ResourceTypeControlCode(struct ndr_print *ndr, const char *name, enum clusapi_ResourceTypeControlCode r)
{
	const char *val = NULL;

	switch (r) {
		case CLUSCTL_RESOURCE_TYPE_UNKNOWN: val = "CLUSCTL_RESOURCE_TYPE_UNKNOWN"; break;
		case CLUSCTL_RESOURCE_TYPE_GET_CHARACTERISTICS: val = "CLUSCTL_RESOURCE_TYPE_GET_CHARACTERISTICS"; break;
		case CLUSCTL_RESOURCE_TYPE_GET_FLAGS: val = "CLUSCTL_RESOURCE_TYPE_GET_FLAGS"; break;
		case CLUSCTL_RESOURCE_TYPE_GET_CLASS_INFO: val = "CLUSCTL_RESOURCE_TYPE_GET_CLASS_INFO"; break;
		case CLUSCTL_RESOURCE_TYPE_GET_REQUIRED_DEPENDENCIES: val = "CLUSCTL_RESOURCE_TYPE_GET_REQUIRED_DEPENDENCIES"; break;
		case CLUSCTL_RESOURCE_TYPE_GET_ARB_TIMEOUT: val = "CLUSCTL_RESOURCE_TYPE_GET_ARB_TIMEOUT"; break;
		case CLUSCTL_RESOURCE_TYPE_ENUM_COMMON_PROPERTIES: val = "CLUSCTL_RESOURCE_TYPE_ENUM_COMMON_PROPERTIES"; break;
		case CLUSCTL_RESOURCE_TYPE_GET_RO_COMMON_PROPERTIES: val = "CLUSCTL_RESOURCE_TYPE_GET_RO_COMMON_PROPERTIES"; break;
		case CLUSCTL_RESOURCE_TYPE_GET_COMMON_PROPERTIES: val = "CLUSCTL_RESOURCE_TYPE_GET_COMMON_PROPERTIES"; break;
		case CLUSCTL_RESOURCE_TYPE_SET_COMMON_PROPERTIES: val = "CLUSCTL_RESOURCE_TYPE_SET_COMMON_PROPERTIES"; break;
		case CLUSCTL_RESOURCE_TYPE_VALIDATE_COMMON_PROPERTIES: val = "CLUSCTL_RESOURCE_TYPE_VALIDATE_COMMON_PROPERTIES"; break;
		case CLUSCTL_RESOURCE_TYPE_GET_COMMON_PROPERTY_FMTS: val = "CLUSCTL_RESOURCE_TYPE_GET_COMMON_PROPERTY_FMTS"; break;
		case CLUSCTL_RESOURCE_TYPE_GET_COMMON_RESOURCE_PROPERTY_FMTS: val = "CLUSCTL_RESOURCE_TYPE_GET_COMMON_RESOURCE_PROPERTY_FMTS"; break;
		case CLUSCTL_RESOURCE_TYPE_ENUM_PRIVATE_PROPERTIES: val = "CLUSCTL_RESOURCE_TYPE_ENUM_PRIVATE_PROPERTIES"; break;
		case CLUSCTL_RESOURCE_TYPE_GET_RO_PRIVATE_PROPERTIES: val = "CLUSCTL_RESOURCE_TYPE_GET_RO_PRIVATE_PROPERTIES"; break;
		case CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_PROPERTIES: val = "CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_PROPERTIES"; break;
		case CLUSCTL_RESOURCE_TYPE_SET_PRIVATE_PROPERTIES: val = "CLUSCTL_RESOURCE_TYPE_SET_PRIVATE_PROPERTIES"; break;
		case CLUSCTL_RESOURCE_TYPE_VALIDATE_PRIVATE_PROPERTIES: val = "CLUSCTL_RESOURCE_TYPE_VALIDATE_PRIVATE_PROPERTIES"; break;
		case CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_PROPERTY_FMTS: val = "CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_PROPERTY_FMTS"; break;
		case CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_RESOURCE_PROPERTY_FMTS: val = "CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_RESOURCE_PROPERTY_FMTS"; break;
		case CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS: val = "CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS"; break;
		case CLUSCTL_RESOURCE_TYPE_NETNAME_VALIDATE_NETNAME: val = "CLUSCTL_RESOURCE_TYPE_NETNAME_VALIDATE_NETNAME"; break;
		case CLUSCTL_RESOURCE_TYPE_VALIDATE_PATH: val = "CLUSCTL_RESOURCE_TYPE_VALIDATE_PATH"; break;
		case CLUSCTL_RESOURCE_TYPE_GEN_APP_VALIDATE_DIRECTORY: val = "CLUSCTL_RESOURCE_TYPE_GEN_APP_VALIDATE_DIRECTORY"; break;
		case CLUSCTL_RESOURCE_TYPE_STORAGE_GET_DRIVELETTERS: val = "CLUSCTL_RESOURCE_TYPE_STORAGE_GET_DRIVELETTERS"; break;
		case CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX: val = "CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX"; break;
		case CLUSCTL_RESOURCE_TYPE_STORAGE_REMAP_DRIVELETTER: val = "CLUSCTL_RESOURCE_TYPE_STORAGE_REMAP_DRIVELETTER"; break;
		case CLUSCTL_RESOURCE_TYPE_STORAGE_GET_DISKID: val = "CLUSCTL_RESOURCE_TYPE_STORAGE_GET_DISKID"; break;
		case CLUSCTL_RESOURCE_TYPE_STORAGE_IS_CLUSTERABLE: val = "CLUSCTL_RESOURCE_TYPE_STORAGE_IS_CLUSTERABLE"; break;
		case CLUSCTL_RESOURCE_TYPE_STORAGE_RELEASE_OWNERSHIP: val = "CLUSCTL_RESOURCE_TYPE_STORAGE_RELEASE_OWNERSHIP"; break;
		case CLUSCTL_RESOURCE_TYPE_STORAGE_IS_CSV_FILE: val = "CLUSCTL_RESOURCE_TYPE_STORAGE_IS_CSV_FILE"; break;
		case CLUSCTL_RESOURCE_TYPE_CLOUD_WITNESS_VALIDATE_CREDENTIALS: val = "CLUSCTL_RESOURCE_TYPE_CLOUD_WITNESS_VALIDATE_CREDENTIALS"; break;
		case CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_LOGDISKS: val = "CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_LOGDISKS"; break;
		case CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_TARGET_DATADISKS: val = "CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_TARGET_DATADISKS"; break;
		case CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_SOURCE_DATADISKS: val = "CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_SOURCE_DATADISKS"; break;
		case CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICA_VOLUMES: val = "CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICA_VOLUMES"; break;
		case CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_LOG_VOLUME: val = "CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_LOG_VOLUME"; break;
		case CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICATED_DISKS: val = "CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICATED_DISKS"; break;
		case CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_RESOURCE_GROUP: val = "CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_RESOURCE_GROUP"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_clusapi_GroupControlCode(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum clusapi_GroupControlCode r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GroupControlCode(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum clusapi_GroupControlCode *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GroupControlCode(struct ndr_print *ndr, const char *name, enum clusapi_GroupControlCode r)
{
	const char *val = NULL;

	switch (r) {
		case CLUSCTL_GROUP_UNKNOWN: val = "CLUSCTL_GROUP_UNKNOWN"; break;
		case CLUSCTL_GROUP_GET_CHARACTERISTICS: val = "CLUSCTL_GROUP_GET_CHARACTERISTICS"; break;
		case CLUSCTL_GROUP_GET_FLAGS: val = "CLUSCTL_GROUP_GET_FLAGS"; break;
		case CLUSCTL_GROUP_GET_NAME: val = "CLUSCTL_GROUP_GET_NAME"; break;
		case CLUSCTL_GROUP_GET_ID: val = "CLUSCTL_GROUP_GET_ID"; break;
		case CLUSCTL_GROUP_ENUM_COMMON_PROPERTIES: val = "CLUSCTL_GROUP_ENUM_COMMON_PROPERTIES"; break;
		case CLUSCTL_GROUP_GET_RO_COMMON_PROPERTIES: val = "CLUSCTL_GROUP_GET_RO_COMMON_PROPERTIES"; break;
		case CLUSCTL_GROUP_GET_COMMON_PROPERTIES: val = "CLUSCTL_GROUP_GET_COMMON_PROPERTIES"; break;
		case CLUSCTL_GROUP_SET_COMMON_PROPERTIES: val = "CLUSCTL_GROUP_SET_COMMON_PROPERTIES"; break;
		case CLUSCTL_GROUP_VALIDATE_COMMON_PROPERTIES: val = "CLUSCTL_GROUP_VALIDATE_COMMON_PROPERTIES"; break;
		case CLUSCTL_GROUP_GET_COMMON_PROPERTY_FMTS: val = "CLUSCTL_GROUP_GET_COMMON_PROPERTY_FMTS"; break;
		case CLUSCTL_GROUP_ENUM_PRIVATE_PROPERTIES: val = "CLUSCTL_GROUP_ENUM_PRIVATE_PROPERTIES"; break;
		case CLUSCTL_GROUP_GET_RO_PRIVATE_PROPERTIES: val = "CLUSCTL_GROUP_GET_RO_PRIVATE_PROPERTIES"; break;
		case CLUSCTL_GROUP_GET_PRIVATE_PROPERTIES: val = "CLUSCTL_GROUP_GET_PRIVATE_PROPERTIES"; break;
		case CLUSCTL_GROUP_SET_PRIVATE_PROPERTIES: val = "CLUSCTL_GROUP_SET_PRIVATE_PROPERTIES"; break;
		case CLUSCTL_GROUP_VALIDATE_PRIVATE_PROPERTIES: val = "CLUSCTL_GROUP_VALIDATE_PRIVATE_PROPERTIES"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_clusapi_NodeControlCode(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum clusapi_NodeControlCode r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_NodeControlCode(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum clusapi_NodeControlCode *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_NodeControlCode(struct ndr_print *ndr, const char *name, enum clusapi_NodeControlCode r)
{
	const char *val = NULL;

	switch (r) {
		case CLUSCTL_NODE_UNKNOWN: val = "CLUSCTL_NODE_UNKNOWN"; break;
		case CLUSCTL_NODE_GET_CHARACTERISTICS: val = "CLUSCTL_NODE_GET_CHARACTERISTICS"; break;
		case CLUSCTL_NODE_GET_FLAGS: val = "CLUSCTL_NODE_GET_FLAGS"; break;
		case CLUSCTL_NODE_GET_NAME: val = "CLUSCTL_NODE_GET_NAME"; break;
		case CLUSCTL_NODE_GET_ID: val = "CLUSCTL_NODE_GET_ID"; break;
		case CLUSCTL_NODE_GET_CLUSTER_SERVICE_ACCOUNT_NAME: val = "CLUSCTL_NODE_GET_CLUSTER_SERVICE_ACCOUNT_NAME"; break;
		case CLUSCTL_NODE_ENUM_COMMON_PROPERTIES: val = "CLUSCTL_NODE_ENUM_COMMON_PROPERTIES"; break;
		case CLUSCTL_NODE_GET_RO_COMMON_PROPERTIES: val = "CLUSCTL_NODE_GET_RO_COMMON_PROPERTIES"; break;
		case CLUSCTL_NODE_GET_COMMON_PROPERTIES: val = "CLUSCTL_NODE_GET_COMMON_PROPERTIES"; break;
		case CLUSCTL_NODE_SET_COMMON_PROPERTIES: val = "CLUSCTL_NODE_SET_COMMON_PROPERTIES"; break;
		case CLUSCTL_NODE_VALIDATE_COMMON_PROPERTIES: val = "CLUSCTL_NODE_VALIDATE_COMMON_PROPERTIES"; break;
		case CLUSCTL_NODE_ENUM_PRIVATE_PROPERTIES: val = "CLUSCTL_NODE_ENUM_PRIVATE_PROPERTIES"; break;
		case CLUSCTL_NODE_GET_RO_PRIVATE_PROPERTIES: val = "CLUSCTL_NODE_GET_RO_PRIVATE_PROPERTIES"; break;
		case CLUSCTL_NODE_GET_PRIVATE_PROPERTIES: val = "CLUSCTL_NODE_GET_PRIVATE_PROPERTIES"; break;
		case CLUSCTL_NODE_SET_PRIVATE_PROPERTIES: val = "CLUSCTL_NODE_SET_PRIVATE_PROPERTIES"; break;
		case CLUSCTL_NODE_VALIDATE_PRIVATE_PROPERTIES: val = "CLUSCTL_NODE_VALIDATE_PRIVATE_PROPERTIES"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_clusapi_ClusterNetworkState(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum clusapi_ClusterNetworkState r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_ClusterNetworkState(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum clusapi_ClusterNetworkState *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_ClusterNetworkState(struct ndr_print *ndr, const char *name, enum clusapi_ClusterNetworkState r)
{
	const char *val = NULL;

	switch (r) {
		case ClusterNetworkUnavailable: val = "ClusterNetworkUnavailable"; break;
		case ClusterNetworkDown: val = "ClusterNetworkDown"; break;
		case ClusterNetworkPartitioned: val = "ClusterNetworkPartitioned"; break;
		case ClusterNetworkUp: val = "ClusterNetworkUp"; break;
		case ClusterNetworkStateUnknown: val = "ClusterNetworkStateUnknown"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_clusapi_ClusterNetInterfaceState(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum clusapi_ClusterNetInterfaceState r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_ClusterNetInterfaceState(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum clusapi_ClusterNetInterfaceState *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_ClusterNetInterfaceState(struct ndr_print *ndr, const char *name, enum clusapi_ClusterNetInterfaceState r)
{
	const char *val = NULL;

	switch (r) {
		case ClusterNetInterfaceFailed: val = "ClusterNetInterfaceFailed"; break;
		case ClusterNetInterfaceUnreachable: val = "ClusterNetInterfaceUnreachable"; break;
		case ClusterNetInterfaceUnavailable: val = "ClusterNetInterfaceUnavailable"; break;
		case ClusterNetInterfaceUp: val = "ClusterNetInterfaceUp"; break;
		case ClusterNetInterfaceStateUnknown: val = "ClusterNetInterfaceStateUnknown"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_ClusterResTypeEnumType(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ClusterResTypeEnumType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ClusterResTypeEnumType(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CLUSTER_RESOURCE_TYPE_ENUM_NODES", CLUSTER_RESOURCE_TYPE_ENUM_NODES, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CLUSTER_RESOURCE_TYPE_ENUM_RESOURCES", CLUSTER_RESOURCE_TYPE_ENUM_RESOURCES, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_ClusterControlCode(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum clusapi_ClusterControlCode r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_ClusterControlCode(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum clusapi_ClusterControlCode *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_ClusterControlCode(struct ndr_print *ndr, const char *name, enum clusapi_ClusterControlCode r)
{
	const char *val = NULL;

	switch (r) {
		case CLUSCTL_CLUSTER_UNKNOWN: val = "CLUSCTL_CLUSTER_UNKNOWN"; break;
		case CLUSCTL_CLUSTER_GET_FQDN: val = "CLUSCTL_CLUSTER_GET_FQDN"; break;
		case CLUSCTL_CLUSTER_CHECK_VOTER_EVICT: val = "CLUSCTL_CLUSTER_CHECK_VOTER_EVICT"; break;
		case CLUSCTL_CLUSTER_CHECK_VOTER_DOWN: val = "CLUSCTL_CLUSTER_CHECK_VOTER_DOWN"; break;
		case CLUSCTL_CLUSTER_SHUTDOWN: val = "CLUSCTL_CLUSTER_SHUTDOWN"; break;
		case CLUSCTL_CLUSTER_ENUM_COMMON_PROPERTIES: val = "CLUSCTL_CLUSTER_ENUM_COMMON_PROPERTIES"; break;
		case CLUSCTL_CLUSTER_GET_RO_COMMON_PROPERTIES: val = "CLUSCTL_CLUSTER_GET_RO_COMMON_PROPERTIES"; break;
		case CLUSCTL_CLUSTER_GET_COMMON_PROPERTIES: val = "CLUSCTL_CLUSTER_GET_COMMON_PROPERTIES"; break;
		case CLUSCTL_CLUSTER_SET_COMMON_PROPERTIES: val = "CLUSCTL_CLUSTER_SET_COMMON_PROPERTIES"; break;
		case CLUSCTL_CLUSTER_VALIDATE_COMMON_PROPERTIES: val = "CLUSCTL_CLUSTER_VALIDATE_COMMON_PROPERTIES"; break;
		case CLUSCTL_CLUSTER_GET_COMMON_PROPERTY_FMTS: val = "CLUSCTL_CLUSTER_GET_COMMON_PROPERTY_FMTS"; break;
		case CLUSCTL_CLUSTER_ENUM_PRIVATE_PROPERTIES: val = "CLUSCTL_CLUSTER_ENUM_PRIVATE_PROPERTIES"; break;
		case CLUSCTL_CLUSTER_GET_RO_PRIVATE_PROPERTIES: val = "CLUSCTL_CLUSTER_GET_RO_PRIVATE_PROPERTIES"; break;
		case CLUSCTL_CLUSTER_GET_PRIVATE_PROPERTIES: val = "CLUSCTL_CLUSTER_GET_PRIVATE_PROPERTIES"; break;
		case CLUSCTL_CLUSTER_SET_PRIVATE_PROPERTIES: val = "CLUSCTL_CLUSTER_SET_PRIVATE_PROPERTIES"; break;
		case CLUSCTL_CLUSTER_VALIDATE_PRIVATE_PROPERTIES: val = "CLUSCTL_CLUSTER_VALIDATE_PRIVATE_PROPERTIES"; break;
		case CLUSCTL_CLUSTER_GET_SHARED_VOLUME_ID: val = "CLUSCTL_CLUSTER_GET_SHARED_VOLUME_ID"; break;
		case CLUSCTL_CLUSTER_UPGRADE_CLUSTER_VERSION: val = "CLUSCTL_CLUSTER_UPGRADE_CLUSTER_VERSION"; break;
		case CLUSCTL_CLUSTER_CLEAR_UPGRADE_IN_PROGRESS: val = "CLUSCTL_CLUSTER_CLEAR_UPGRADE_IN_PROGRESS"; break;
		case CLUSCTL_CLUSTER_IS_READY_FOR_UPGRADE: val = "CLUSCTL_CLUSTER_IS_READY_FOR_UPGRADE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_CLUSTER_PROPERTY_SYNTAX(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum CLUSTER_PROPERTY_SYNTAX r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_CLUSTER_PROPERTY_SYNTAX(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum CLUSTER_PROPERTY_SYNTAX *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CLUSTER_PROPERTY_SYNTAX(struct ndr_print *ndr, const char *name, enum CLUSTER_PROPERTY_SYNTAX r)
{
	const char *val = NULL;

	switch (r) {
		case CLUSPROP_SYNTAX_ENDMARK: val = "CLUSPROP_SYNTAX_ENDMARK"; break;
		case CLUSPROP_SYNTAX_NAME: val = "CLUSPROP_SYNTAX_NAME"; break;
		case CLUSPROP_SYNTAX_RESCLASS: val = "CLUSPROP_SYNTAX_RESCLASS"; break;
		case CLUSPROP_SYNTAX_LIST_VALUE_SZ: val = "CLUSPROP_SYNTAX_LIST_VALUE_SZ"; break;
		case CLUSPROP_SYNTAX_LIST_VALUE_EXPAND_SZ: val = "CLUSPROP_SYNTAX_LIST_VALUE_EXPAND_SZ"; break;
		case CLUSPROP_SYNTAX_LIST_VALUE_DWORD: val = "CLUSPROP_SYNTAX_LIST_VALUE_DWORD"; break;
		case CLUSPROP_SYNTAX_LIST_VALUE_BINARY: val = "CLUSPROP_SYNTAX_LIST_VALUE_BINARY"; break;
		case CLUSPROP_SYNTAX_LIST_VALUE_MULTI_SZ: val = "CLUSPROP_SYNTAX_LIST_VALUE_MULTI_SZ"; break;
		case CLUSPROP_SYNTAX_LIST_VALUE_LONG: val = "CLUSPROP_SYNTAX_LIST_VALUE_LONG"; break;
		case CLUSPROP_SYNTAX_LIST_VALUE_EXPANDED_SZ: val = "CLUSPROP_SYNTAX_LIST_VALUE_EXPANDED_SZ"; break;
		case CLUSPROP_SYNTAX_LIST_VALUE_SECURITY_DESCRIPTOR: val = "CLUSPROP_SYNTAX_LIST_VALUE_SECURITY_DESCRIPTOR"; break;
		case CLUSPROP_SYNTAX_LIST_VALUE_LARGE_INTEGER: val = "CLUSPROP_SYNTAX_LIST_VALUE_LARGE_INTEGER"; break;
		case CLUSPROP_SYNTAX_LIST_VALUE_ULARGE_INTEGER: val = "CLUSPROP_SYNTAX_LIST_VALUE_ULARGE_INTEGER"; break;
		case CLUSPROP_SYNTAX_LIST_VALUE_WORD: val = "CLUSPROP_SYNTAX_LIST_VALUE_WORD"; break;
		case CLUSPROP_SYNTAX_LIST_VALUE_FILETIME: val = "CLUSPROP_SYNTAX_LIST_VALUE_FILETIME"; break;
		case CLUSPROP_SYNTAX_DISK_SIGNATURE: val = "CLUSPROP_SYNTAX_DISK_SIGNATURE"; break;
		case CLUSPROP_SYNTAX_SCSI_ADDRESS: val = "CLUSPROP_SYNTAX_SCSI_ADDRESS"; break;
		case CLUSPROP_SYNTAX_DISK_NUMBER: val = "CLUSPROP_SYNTAX_DISK_NUMBER"; break;
		case CLUSPROP_SYNTAX_PARTITION_INFO: val = "CLUSPROP_SYNTAX_PARTITION_INFO"; break;
		case CLUSPROP_SYNTAX_DISK_SERIALNUMBER: val = "CLUSPROP_SYNTAX_DISK_SERIALNUMBER"; break;
		case CLUSPROP_SYNTAX_DISK_GUID: val = "CLUSPROP_SYNTAX_DISK_GUID"; break;
		case CLUSPROP_SYNTAX_DISK_SIZE: val = "CLUSPROP_SYNTAX_DISK_SIZE"; break;
		case CLUSPROP_SYNTAX_PARTITION_INFO_EX: val = "CLUSPROP_SYNTAX_PARTITION_INFO_EX"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_clusapi_propertyValues(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct clusapi_propertyValues *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_CLUSTER_PROPERTY_SYNTAX(ndr, NDR_SCALARS, r->Syntax));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->Size));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_push *_ndr_Buffer;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_Buffer, 0, r->Size));
				NDR_CHECK(ndr_push_DATA_BLOB(_ndr_Buffer, NDR_SCALARS, r->Buffer));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_Buffer, 0, r->Size));
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN4);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->Padding));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_propertyValues(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct clusapi_propertyValues *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_CLUSTER_PROPERTY_SYNTAX(ndr, NDR_SCALARS, &r->Syntax));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Size));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_pull *_ndr_Buffer;
				ssize_t sub_size = r->Size;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_Buffer, 0, sub_size));
				NDR_CHECK(ndr_pull_DATA_BLOB(_ndr_Buffer, NDR_SCALARS, &r->Buffer));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_Buffer, 0, sub_size));
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN4);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->Padding));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_propertyValues(struct ndr_print *ndr, const char *name, const struct clusapi_propertyValues *r)
{
	ndr_print_struct(ndr, name, "clusapi_propertyValues");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_CLUSTER_PROPERTY_SYNTAX(ndr, "Syntax", r->Syntax);
	ndr_print_uint32(ndr, "Size", r->Size);
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "Buffer", r->Buffer);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN4);
		ndr_print_DATA_BLOB(ndr, "Padding", r->Padding);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_propertyValue(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct clusapi_propertyValue *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_CLUSTER_PROPERTY_SYNTAX(ndr, NDR_SCALARS, CLUSPROP_SYNTAX_NAME));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, strlen_m_term(r->buffer) * 2));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->buffer));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->padding));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_clusapi_propertyValues(ndr, NDR_SCALARS, &r->PropertyValues));
		NDR_CHECK(ndr_push_CLUSTER_PROPERTY_SYNTAX(ndr, NDR_SCALARS, CLUSPROP_SYNTAX_ENDMARK));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_propertyValue(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct clusapi_propertyValue *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_CLUSTER_PROPERTY_SYNTAX(ndr, NDR_SCALARS, &r->syntax_name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->buffer));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->padding));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_clusapi_propertyValues(ndr, NDR_SCALARS, &r->PropertyValues));
		NDR_CHECK(ndr_pull_CLUSTER_PROPERTY_SYNTAX(ndr, NDR_SCALARS, &r->end_mark));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_propertyValue(struct ndr_print *ndr, const char *name, const struct clusapi_propertyValue *r)
{
	ndr_print_struct(ndr, name, "clusapi_propertyValue");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_CLUSTER_PROPERTY_SYNTAX(ndr, "syntax_name", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?CLUSPROP_SYNTAX_NAME:r->syntax_name);
	ndr_print_uint32(ndr, "size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?strlen_m_term(r->buffer) * 2:r->size);
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
		ndr_print_string(ndr, "buffer", r->buffer);
		ndr->flags = _flags_save_string;
	}
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN2);
		ndr_print_DATA_BLOB(ndr, "padding", r->padding);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr_print_clusapi_propertyValues(ndr, "PropertyValues", &r->PropertyValues);
	ndr_print_CLUSTER_PROPERTY_SYNTAX(ndr, "end_mark", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?CLUSPROP_SYNTAX_ENDMARK:r->end_mark);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_clusapi_PROPERTY_LIST(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct clusapi_PROPERTY_LIST *r)
{
	uint32_t cntr_propertyValues_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->propertyCount));
		for (cntr_propertyValues_0 = 0; cntr_propertyValues_0 < (r->propertyCount); cntr_propertyValues_0++) {
			NDR_CHECK(ndr_push_clusapi_propertyValue(ndr, NDR_SCALARS, &r->propertyValues[cntr_propertyValues_0]));
		}
		NDR_CHECK(ndr_push_CLUSTER_PROPERTY_SYNTAX(ndr, NDR_SCALARS, CLUSPROP_SYNTAX_ENDMARK));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_clusapi_PROPERTY_LIST(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct clusapi_PROPERTY_LIST *r)
{
	uint32_t size_propertyValues_0 = 0;
	uint32_t cntr_propertyValues_0;
	TALLOC_CTX *_mem_save_propertyValues_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->propertyCount));
		size_propertyValues_0 = r->propertyCount;
		NDR_PULL_ALLOC_N(ndr, r->propertyValues, size_propertyValues_0);
		_mem_save_propertyValues_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->propertyValues, 0);
		for (cntr_propertyValues_0 = 0; cntr_propertyValues_0 < (size_propertyValues_0); cntr_propertyValues_0++) {
			NDR_CHECK(ndr_pull_clusapi_propertyValue(ndr, NDR_SCALARS, &r->propertyValues[cntr_propertyValues_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_propertyValues_0, 0);
		NDR_CHECK(ndr_pull_CLUSTER_PROPERTY_SYNTAX(ndr, NDR_SCALARS, &r->end_mark));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_clusapi_PROPERTY_LIST(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct clusapi_PROPERTY_LIST *r)
{
	ndr_print_clusapi_PROPERTY_LIST(ndr, name, r);
}

_PUBLIC_ void ndr_print_clusapi_PROPERTY_LIST(struct ndr_print *ndr, const char *name, const struct clusapi_PROPERTY_LIST *r)
{
	uint32_t cntr_propertyValues_0;
	ndr_print_struct(ndr, name, "clusapi_PROPERTY_LIST");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "propertyCount", r->propertyCount);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "propertyValues", (uint32_t)(r->propertyCount));
	ndr->depth++;
	for (cntr_propertyValues_0 = 0; cntr_propertyValues_0 < (r->propertyCount); cntr_propertyValues_0++) {
		ndr_print_clusapi_propertyValue(ndr, "propertyValues", &r->propertyValues[cntr_propertyValues_0]);
	}
	ndr->depth--;
	ndr_print_CLUSTER_PROPERTY_SYNTAX(ndr, "end_mark", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?CLUSPROP_SYNTAX_ENDMARK:r->end_mark);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_DesiredAccessMask(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_DesiredAccessMask(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_DesiredAccessMask(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CLUSAPI_READ_ACCESS", CLUSAPI_READ_ACCESS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CLUSAPI_CHANGE_ACCESS", CLUSAPI_CHANGE_ACCESS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CLUSAPI_GENERIC_READ", CLUSAPI_GENERIC_READ, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CLUSAPI_GENERIC_WRITE", CLUSAPI_GENERIC_WRITE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CLUSAPI_GENERIC_EXECUTE", CLUSAPI_GENERIC_EXECUTE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CLUSAPI_GENERIC_ALL", CLUSAPI_GENERIC_ALL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CLUSAPI_MAXIMUM_ALLOWED", CLUSAPI_MAXIMUM_ALLOWED, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_NOTIFY_FILTER_AND_TYPE_RPC(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct NOTIFY_FILTER_AND_TYPE_RPC *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwObjectType));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->FilterFlags));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_NOTIFY_FILTER_AND_TYPE_RPC(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct NOTIFY_FILTER_AND_TYPE_RPC *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwObjectType));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->FilterFlags));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_NOTIFY_FILTER_AND_TYPE_RPC(struct ndr_print *ndr, const char *name, const struct NOTIFY_FILTER_AND_TYPE_RPC *r)
{
	ndr_print_struct(ndr, name, "NOTIFY_FILTER_AND_TYPE_RPC");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwObjectType", r->dwObjectType);
	ndr_print_hyper(ndr, "FilterFlags", r->FilterFlags);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_NOTIFICATION_DATA_RPC(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct NOTIFICATION_DATA_RPC *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_NOTIFY_FILTER_AND_TYPE_RPC(ndr, NDR_SCALARS, &r->FilterAndType));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->buffer));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwBufferSize));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->ObjectId));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->ParentId));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->Name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->Type));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->buffer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->dwBufferSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->buffer, r->dwBufferSize));
		}
		if (r->ObjectId) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->ObjectId, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->ObjectId, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->ObjectId, ndr_charset_length(r->ObjectId, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->ParentId) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->ParentId, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->ParentId, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->ParentId, ndr_charset_length(r->ParentId, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->Name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->Name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->Name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->Name, ndr_charset_length(r->Name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->Type) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->Type, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->Type, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->Type, ndr_charset_length(r->Type, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_NOTIFICATION_DATA_RPC(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct NOTIFICATION_DATA_RPC *r)
{
	uint32_t _ptr_buffer;
	uint32_t size_buffer_1 = 0;
	TALLOC_CTX *_mem_save_buffer_0 = NULL;
	uint32_t _ptr_ObjectId;
	uint32_t size_ObjectId_1 = 0;
	uint32_t length_ObjectId_1 = 0;
	TALLOC_CTX *_mem_save_ObjectId_0 = NULL;
	uint32_t _ptr_ParentId;
	uint32_t size_ParentId_1 = 0;
	uint32_t length_ParentId_1 = 0;
	TALLOC_CTX *_mem_save_ParentId_0 = NULL;
	uint32_t _ptr_Name;
	uint32_t size_Name_1 = 0;
	uint32_t length_Name_1 = 0;
	TALLOC_CTX *_mem_save_Name_0 = NULL;
	uint32_t _ptr_Type;
	uint32_t size_Type_1 = 0;
	uint32_t length_Type_1 = 0;
	TALLOC_CTX *_mem_save_Type_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_NOTIFY_FILTER_AND_TYPE_RPC(ndr, NDR_SCALARS, &r->FilterAndType));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_buffer));
		if (_ptr_buffer) {
			NDR_PULL_ALLOC(ndr, r->buffer);
		} else {
			r->buffer = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwBufferSize));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ObjectId));
		if (_ptr_ObjectId) {
			NDR_PULL_ALLOC(ndr, r->ObjectId);
		} else {
			r->ObjectId = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ParentId));
		if (_ptr_ParentId) {
			NDR_PULL_ALLOC(ndr, r->ParentId);
		} else {
			r->ParentId = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Name));
		if (_ptr_Name) {
			NDR_PULL_ALLOC(ndr, r->Name);
		} else {
			r->Name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Type));
		if (_ptr_Type) {
			NDR_PULL_ALLOC(ndr, r->Type);
		} else {
			r->Type = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->buffer) {
			_mem_save_buffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->buffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->buffer));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->buffer, &size_buffer_1));
			NDR_PULL_ALLOC_N(ndr, r->buffer, size_buffer_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->buffer, size_buffer_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_0, 0);
		}
		if (r->ObjectId) {
			_mem_save_ObjectId_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->ObjectId, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->ObjectId));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->ObjectId));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->ObjectId, &size_ObjectId_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->ObjectId, &length_ObjectId_1));
			if (length_ObjectId_1 > size_ObjectId_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_ObjectId_1, length_ObjectId_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_ObjectId_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->ObjectId, length_ObjectId_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ObjectId_0, 0);
		}
		if (r->ParentId) {
			_mem_save_ParentId_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->ParentId, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->ParentId));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->ParentId));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->ParentId, &size_ParentId_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->ParentId, &length_ParentId_1));
			if (length_ParentId_1 > size_ParentId_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_ParentId_1, length_ParentId_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_ParentId_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->ParentId, length_ParentId_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ParentId_0, 0);
		}
		if (r->Name) {
			_mem_save_Name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->Name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->Name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->Name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->Name, &size_Name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->Name, &length_Name_1));
			if (length_Name_1 > size_Name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_Name_1, length_Name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_Name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->Name, length_Name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Name_0, 0);
		}
		if (r->Type) {
			_mem_save_Type_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->Type, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->Type));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->Type));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->Type, &size_Type_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->Type, &length_Type_1));
			if (length_Type_1 > size_Type_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_Type_1, length_Type_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_Type_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->Type, length_Type_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Type_0, 0);
		}
		if (r->buffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->buffer, r->dwBufferSize));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_NOTIFICATION_DATA_RPC(struct ndr_print *ndr, const char *name, const struct NOTIFICATION_DATA_RPC *r)
{
	ndr_print_struct(ndr, name, "NOTIFICATION_DATA_RPC");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_NOTIFY_FILTER_AND_TYPE_RPC(ndr, "FilterAndType", &r->FilterAndType);
	ndr_print_ptr(ndr, "buffer", r->buffer);
	ndr->depth++;
	if (r->buffer) {
		ndr_print_array_uint8(ndr, "buffer", r->buffer, r->dwBufferSize);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "dwBufferSize", r->dwBufferSize);
	ndr_print_ptr(ndr, "ObjectId", r->ObjectId);
	ndr->depth++;
	if (r->ObjectId) {
		ndr_print_string(ndr, "ObjectId", r->ObjectId);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "ParentId", r->ParentId);
	ndr->depth++;
	if (r->ParentId) {
		ndr_print_string(ndr, "ParentId", r->ParentId);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "Name", r->Name);
	ndr->depth++;
	if (r->Name) {
		ndr_print_string(ndr, "Name", r->Name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "Type", r->Type);
	ndr->depth++;
	if (r->Type) {
		ndr_print_string(ndr, "Type", r->Type);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_NOTIFICATION_RPC(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct NOTIFICATION_RPC *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dwNotifyKey));
		NDR_CHECK(ndr_push_NOTIFICATION_DATA_RPC(ndr, NDR_SCALARS, &r->NotificationData));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->dwNotifyKey) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->dwNotifyKey));
		}
		NDR_CHECK(ndr_push_NOTIFICATION_DATA_RPC(ndr, NDR_BUFFERS, &r->NotificationData));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_NOTIFICATION_RPC(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct NOTIFICATION_RPC *r)
{
	uint32_t _ptr_dwNotifyKey;
	TALLOC_CTX *_mem_save_dwNotifyKey_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dwNotifyKey));
		if (_ptr_dwNotifyKey) {
			NDR_PULL_ALLOC(ndr, r->dwNotifyKey);
		} else {
			r->dwNotifyKey = NULL;
		}
		NDR_CHECK(ndr_pull_NOTIFICATION_DATA_RPC(ndr, NDR_SCALARS, &r->NotificationData));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->dwNotifyKey) {
			_mem_save_dwNotifyKey_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dwNotifyKey, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->dwNotifyKey));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dwNotifyKey_0, 0);
		}
		NDR_CHECK(ndr_pull_NOTIFICATION_DATA_RPC(ndr, NDR_BUFFERS, &r->NotificationData));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_NOTIFICATION_RPC(struct ndr_print *ndr, const char *name, const struct NOTIFICATION_RPC *r)
{
	ndr_print_struct(ndr, name, "NOTIFICATION_RPC");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "dwNotifyKey", r->dwNotifyKey);
	ndr->depth++;
	if (r->dwNotifyKey) {
		ndr_print_uint32(ndr, "dwNotifyKey", *r->dwNotifyKey);
	}
	ndr->depth--;
	ndr_print_NOTIFICATION_DATA_RPC(ndr, "NotificationData", &r->NotificationData);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_CLUSTER_DISKID(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct CLUSTER_DISKID *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->DiskIdType));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->DiskIdBlob, 16));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_CLUSTER_DISKID(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct CLUSTER_DISKID *r)
{
	uint32_t size_DiskIdBlob_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->DiskIdType));
		size_DiskIdBlob_0 = 16;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->DiskIdBlob, size_DiskIdBlob_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CLUSTER_DISKID(struct ndr_print *ndr, const char *name, const struct CLUSTER_DISKID *r)
{
	ndr_print_struct(ndr, name, "CLUSTER_DISKID");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "DiskIdType", r->DiskIdType);
	ndr_print_array_uint8(ndr, "DiskIdBlob", r->DiskIdBlob, 16);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_CLUSTER_MRR_NODE_RESPONSE(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct CLUSTER_MRR_NODE_RESPONSE *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszNodeName));
		NDR_CHECK(ndr_push_HRESULT(ndr, NDR_SCALARS, r->ResultCode));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ResultSize));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pResultData));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszNodeName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszNodeName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszNodeName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszNodeName, ndr_charset_length(r->pszNodeName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->pResultData) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->ResultSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->pResultData, r->ResultSize));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_CLUSTER_MRR_NODE_RESPONSE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct CLUSTER_MRR_NODE_RESPONSE *r)
{
	uint32_t _ptr_pszNodeName;
	uint32_t size_pszNodeName_1 = 0;
	uint32_t length_pszNodeName_1 = 0;
	TALLOC_CTX *_mem_save_pszNodeName_0 = NULL;
	uint32_t _ptr_pResultData;
	uint32_t size_pResultData_1 = 0;
	TALLOC_CTX *_mem_save_pResultData_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszNodeName));
		if (_ptr_pszNodeName) {
			NDR_PULL_ALLOC(ndr, r->pszNodeName);
		} else {
			r->pszNodeName = NULL;
		}
		NDR_CHECK(ndr_pull_HRESULT(ndr, NDR_SCALARS, &r->ResultCode));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ResultSize));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pResultData));
		if (_ptr_pResultData) {
			NDR_PULL_ALLOC(ndr, r->pResultData);
		} else {
			r->pResultData = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszNodeName) {
			_mem_save_pszNodeName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszNodeName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszNodeName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszNodeName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszNodeName, &size_pszNodeName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszNodeName, &length_pszNodeName_1));
			if (length_pszNodeName_1 > size_pszNodeName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszNodeName_1, length_pszNodeName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszNodeName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszNodeName, length_pszNodeName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszNodeName_0, 0);
		}
		if (r->pResultData) {
			_mem_save_pResultData_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pResultData, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pResultData));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->pResultData, &size_pResultData_1));
			NDR_PULL_ALLOC_N(ndr, r->pResultData, size_pResultData_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->pResultData, size_pResultData_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pResultData_0, 0);
		}
		if (r->pResultData) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->pResultData, r->ResultSize));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CLUSTER_MRR_NODE_RESPONSE(struct ndr_print *ndr, const char *name, const struct CLUSTER_MRR_NODE_RESPONSE *r)
{
	ndr_print_struct(ndr, name, "CLUSTER_MRR_NODE_RESPONSE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "pszNodeName", r->pszNodeName);
	ndr->depth++;
	if (r->pszNodeName) {
		ndr_print_string(ndr, "pszNodeName", r->pszNodeName);
	}
	ndr->depth--;
	ndr_print_HRESULT(ndr, "ResultCode", r->ResultCode);
	ndr_print_uint32(ndr, "ResultSize", r->ResultSize);
	ndr_print_ptr(ndr, "pResultData", r->pResultData);
	ndr->depth++;
	if (r->pResultData) {
		ndr_print_array_uint8(ndr, "pResultData", r->pResultData, r->ResultSize);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_CLUSTER_MRR_RESPONSE(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct CLUSTER_MRR_RESPONSE *r)
{
	uint32_t cntr_pNodes_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->NodeCount));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pNodes));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pNodes) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->NodeCount));
			for (cntr_pNodes_1 = 0; cntr_pNodes_1 < (r->NodeCount); cntr_pNodes_1++) {
				NDR_CHECK(ndr_push_CLUSTER_MRR_NODE_RESPONSE(ndr, NDR_SCALARS, &r->pNodes[cntr_pNodes_1]));
			}
			for (cntr_pNodes_1 = 0; cntr_pNodes_1 < (r->NodeCount); cntr_pNodes_1++) {
				NDR_CHECK(ndr_push_CLUSTER_MRR_NODE_RESPONSE(ndr, NDR_BUFFERS, &r->pNodes[cntr_pNodes_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_CLUSTER_MRR_RESPONSE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct CLUSTER_MRR_RESPONSE *r)
{
	uint32_t _ptr_pNodes;
	uint32_t size_pNodes_1 = 0;
	uint32_t cntr_pNodes_1;
	TALLOC_CTX *_mem_save_pNodes_0 = NULL;
	TALLOC_CTX *_mem_save_pNodes_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->NodeCount));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pNodes));
		if (_ptr_pNodes) {
			NDR_PULL_ALLOC(ndr, r->pNodes);
		} else {
			r->pNodes = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pNodes) {
			_mem_save_pNodes_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pNodes, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pNodes));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->pNodes, &size_pNodes_1));
			NDR_PULL_ALLOC_N(ndr, r->pNodes, size_pNodes_1);
			_mem_save_pNodes_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pNodes, 0);
			for (cntr_pNodes_1 = 0; cntr_pNodes_1 < (size_pNodes_1); cntr_pNodes_1++) {
				NDR_CHECK(ndr_pull_CLUSTER_MRR_NODE_RESPONSE(ndr, NDR_SCALARS, &r->pNodes[cntr_pNodes_1]));
			}
			for (cntr_pNodes_1 = 0; cntr_pNodes_1 < (size_pNodes_1); cntr_pNodes_1++) {
				NDR_CHECK(ndr_pull_CLUSTER_MRR_NODE_RESPONSE(ndr, NDR_BUFFERS, &r->pNodes[cntr_pNodes_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pNodes_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pNodes_0, 0);
		}
		if (r->pNodes) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->pNodes, r->NodeCount));
		}
		for (cntr_pNodes_1 = 0; cntr_pNodes_1 < (size_pNodes_1); cntr_pNodes_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CLUSTER_MRR_RESPONSE(struct ndr_print *ndr, const char *name, const struct CLUSTER_MRR_RESPONSE *r)
{
	uint32_t cntr_pNodes_1;
	ndr_print_struct(ndr, name, "CLUSTER_MRR_RESPONSE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "NodeCount", r->NodeCount);
	ndr_print_ptr(ndr, "pNodes", r->pNodes);
	ndr->depth++;
	if (r->pNodes) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "pNodes", (uint32_t)(r->NodeCount));
		ndr->depth++;
		for (cntr_pNodes_1 = 0; cntr_pNodes_1 < (r->NodeCount); cntr_pNodes_1++) {
			ndr_print_CLUSTER_MRR_NODE_RESPONSE(ndr, "pNodes", &r->pNodes[cntr_pNodes_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_NOTIFICATION_DATA_ASYNC_RPC(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct NOTIFICATION_DATA_ASYNC_RPC *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwNotifyKey));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwFilter));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->Name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->Name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->Name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->Name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->Name, ndr_charset_length(r->Name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_NOTIFICATION_DATA_ASYNC_RPC(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct NOTIFICATION_DATA_ASYNC_RPC *r)
{
	uint32_t _ptr_Name;
	uint32_t size_Name_1 = 0;
	uint32_t length_Name_1 = 0;
	TALLOC_CTX *_mem_save_Name_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwNotifyKey));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwFilter));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Name));
		if (_ptr_Name) {
			NDR_PULL_ALLOC(ndr, r->Name);
		} else {
			r->Name = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->Name) {
			_mem_save_Name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->Name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->Name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->Name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->Name, &size_Name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->Name, &length_Name_1));
			if (length_Name_1 > size_Name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_Name_1, length_Name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_Name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->Name, length_Name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Name_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_NOTIFICATION_DATA_ASYNC_RPC(struct ndr_print *ndr, const char *name, const struct NOTIFICATION_DATA_ASYNC_RPC *r)
{
	ndr_print_struct(ndr, name, "NOTIFICATION_DATA_ASYNC_RPC");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwNotifyKey", r->dwNotifyKey);
	ndr_print_uint32(ndr, "dwFilter", r->dwFilter);
	ndr_print_ptr(ndr, "Name", r->Name);
	ndr->depth++;
	if (r->Name) {
		ndr_print_string(ndr, "Name", r->Name);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_GroupSetControlCode(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum clusapi_GroupSetControlCode r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GroupSetControlCode(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum clusapi_GroupSetControlCode *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GroupSetControlCode(struct ndr_print *ndr, const char *name, enum clusapi_GroupSetControlCode r)
{
	const char *val = NULL;

	switch (r) {
		case CLUSCTL_GROUPSET_GET_ID: val = "CLUSCTL_GROUPSET_GET_ID"; break;
		case CLUSCTL_GROUPSET_GET_RO_COMMON_PROPERTIES: val = "CLUSCTL_GROUPSET_GET_RO_COMMON_PROPERTIES"; break;
		case CLUSCTL_GROUPSET_GET_COMMON_PROPERTIES: val = "CLUSCTL_GROUPSET_GET_COMMON_PROPERTIES"; break;
		case CLUSCTL_GROUPSET_GET_GROUPS: val = "CLUSCTL_GROUPSET_GET_GROUPS"; break;
		case CLUSCTL_GROUPSET_GET_PROVIDER_GROUPS: val = "CLUSCTL_GROUPSET_GET_PROVIDER_GROUPS"; break;
		case CLUSCTL_GROUPSET_GET_PROVIDER_GROUPSETS: val = "CLUSCTL_GROUPSET_GET_PROVIDER_GROUPSETS"; break;
		case CLUSCTL_GROUPSET_SET_COMMON_PROPERTIES: val = "CLUSCTL_GROUPSET_SET_COMMON_PROPERTIES"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_clusapi_OpenCluster(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_OpenCluster *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.Status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.Cluster == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.Status));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.Cluster));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_OpenCluster(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_OpenCluster *r)
{
	TALLOC_CTX *_mem_save_Status_0 = NULL;
	TALLOC_CTX *_mem_save_Cluster_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.Status);
		NDR_ZERO_STRUCTP(r->out.Status);
		NDR_PULL_ALLOC(ndr, r->out.Cluster);
		NDR_ZERO_STRUCTP(r->out.Cluster);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Status);
		}
		_mem_save_Status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.Status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Cluster);
		}
		_mem_save_Cluster_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Cluster, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.Cluster));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Cluster_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_OpenCluster(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_OpenCluster *r)
{
	ndr_print_struct(ndr, name, "clusapi_OpenCluster");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_OpenCluster");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_OpenCluster");
		ndr->depth++;
		ndr_print_ptr(ndr, "Status", r->out.Status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "Status", *r->out.Status);
		ndr->depth--;
		ndr_print_ptr(ndr, "Cluster", r->out.Cluster);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "Cluster", r->out.Cluster);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CloseCluster(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CloseCluster *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.Cluster == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.Cluster));
	}
	if (flags & NDR_OUT) {
		if (r->out.Cluster == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.Cluster));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CloseCluster(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CloseCluster *r)
{
	TALLOC_CTX *_mem_save_Cluster_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.Cluster);
		}
		_mem_save_Cluster_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.Cluster, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.Cluster));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Cluster_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.Cluster);
		*r->out.Cluster = *r->in.Cluster;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.Cluster == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.Cluster);
			NDR_ZERO_STRUCTP(r->in.Cluster);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Cluster);
		}
		_mem_save_Cluster_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Cluster, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.Cluster));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Cluster_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CloseCluster(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CloseCluster *r)
{
	ndr_print_struct(ndr, name, "clusapi_CloseCluster");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CloseCluster");
		ndr->depth++;
		ndr_print_ptr(ndr, "Cluster", r->in.Cluster);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "Cluster", r->in.Cluster);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CloseCluster");
		ndr->depth++;
		ndr_print_ptr(ndr, "Cluster", r->out.Cluster);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "Cluster", r->out.Cluster);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_SetClusterName(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_SetClusterName *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.NewClusterName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.NewClusterName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.NewClusterName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.NewClusterName, ndr_charset_length(r->in.NewClusterName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_SetClusterName(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_SetClusterName *r)
{
	uint32_t size_NewClusterName_1 = 0;
	uint32_t length_NewClusterName_1 = 0;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.NewClusterName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.NewClusterName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.NewClusterName, &size_NewClusterName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.NewClusterName, &length_NewClusterName_1));
		if (length_NewClusterName_1 > size_NewClusterName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_NewClusterName_1, length_NewClusterName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_NewClusterName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.NewClusterName, length_NewClusterName_1, sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_SetClusterName(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_SetClusterName *r)
{
	ndr_print_struct(ndr, name, "clusapi_SetClusterName");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_SetClusterName");
		ndr->depth++;
		ndr_print_ptr(ndr, "NewClusterName", r->in.NewClusterName);
		ndr->depth++;
		ndr_print_string(ndr, "NewClusterName", r->in.NewClusterName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_SetClusterName");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_GetClusterName(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_GetClusterName *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.ClusterName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.NodeName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ClusterName));
		if (*r->out.ClusterName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.ClusterName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.ClusterName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.ClusterName, ndr_charset_length(*r->out.ClusterName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.NodeName));
		if (*r->out.NodeName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.NodeName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.NodeName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.NodeName, ndr_charset_length(*r->out.NodeName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GetClusterName(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_GetClusterName *r)
{
	uint32_t _ptr_ClusterName;
	uint32_t size_ClusterName_2 = 0;
	uint32_t length_ClusterName_2 = 0;
	uint32_t _ptr_NodeName;
	uint32_t size_NodeName_2 = 0;
	uint32_t length_NodeName_2 = 0;
	TALLOC_CTX *_mem_save_ClusterName_0 = NULL;
	TALLOC_CTX *_mem_save_ClusterName_1 = NULL;
	TALLOC_CTX *_mem_save_NodeName_0 = NULL;
	TALLOC_CTX *_mem_save_NodeName_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.ClusterName);
		NDR_ZERO_STRUCTP(r->out.ClusterName);
		NDR_PULL_ALLOC(ndr, r->out.NodeName);
		NDR_ZERO_STRUCTP(r->out.NodeName);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ClusterName);
		}
		_mem_save_ClusterName_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ClusterName, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ClusterName));
		if (_ptr_ClusterName) {
			NDR_PULL_ALLOC(ndr, *r->out.ClusterName);
		} else {
			*r->out.ClusterName = NULL;
		}
		if (*r->out.ClusterName) {
			_mem_save_ClusterName_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ClusterName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.ClusterName));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.ClusterName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.ClusterName, &size_ClusterName_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.ClusterName, &length_ClusterName_2));
			if (length_ClusterName_2 > size_ClusterName_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_ClusterName_2, length_ClusterName_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_ClusterName_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.ClusterName, length_ClusterName_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ClusterName_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ClusterName_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.NodeName);
		}
		_mem_save_NodeName_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.NodeName, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_NodeName));
		if (_ptr_NodeName) {
			NDR_PULL_ALLOC(ndr, *r->out.NodeName);
		} else {
			*r->out.NodeName = NULL;
		}
		if (*r->out.NodeName) {
			_mem_save_NodeName_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.NodeName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.NodeName));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.NodeName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.NodeName, &size_NodeName_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.NodeName, &length_NodeName_2));
			if (length_NodeName_2 > size_NodeName_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_NodeName_2, length_NodeName_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_NodeName_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.NodeName, length_NodeName_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_NodeName_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_NodeName_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GetClusterName(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_GetClusterName *r)
{
	ndr_print_struct(ndr, name, "clusapi_GetClusterName");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_GetClusterName");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_GetClusterName");
		ndr->depth++;
		ndr_print_ptr(ndr, "ClusterName", r->out.ClusterName);
		ndr->depth++;
		ndr_print_ptr(ndr, "ClusterName", *r->out.ClusterName);
		ndr->depth++;
		if (*r->out.ClusterName) {
			ndr_print_string(ndr, "ClusterName", *r->out.ClusterName);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "NodeName", r->out.NodeName);
		ndr->depth++;
		ndr_print_ptr(ndr, "NodeName", *r->out.NodeName);
		ndr->depth++;
		if (*r->out.NodeName) {
			ndr_print_string(ndr, "NodeName", *r->out.NodeName);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_GetClusterVersion(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_GetClusterVersion *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.lpwMajorVersion == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpwMinorVersion == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpwBuildNumber == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpszVendorId == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpszCSDVersion == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->out.lpwMajorVersion));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->out.lpwMinorVersion));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->out.lpwBuildNumber));
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.lpszVendorId));
		if (*r->out.lpszVendorId) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.lpszVendorId, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.lpszVendorId, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.lpszVendorId, ndr_charset_length(*r->out.lpszVendorId, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.lpszCSDVersion));
		if (*r->out.lpszCSDVersion) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.lpszCSDVersion, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.lpszCSDVersion, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.lpszCSDVersion, ndr_charset_length(*r->out.lpszCSDVersion, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GetClusterVersion(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_GetClusterVersion *r)
{
	uint32_t _ptr_lpszVendorId;
	uint32_t size_lpszVendorId_2 = 0;
	uint32_t length_lpszVendorId_2 = 0;
	uint32_t _ptr_lpszCSDVersion;
	uint32_t size_lpszCSDVersion_2 = 0;
	uint32_t length_lpszCSDVersion_2 = 0;
	TALLOC_CTX *_mem_save_lpwMajorVersion_0 = NULL;
	TALLOC_CTX *_mem_save_lpwMinorVersion_0 = NULL;
	TALLOC_CTX *_mem_save_lpwBuildNumber_0 = NULL;
	TALLOC_CTX *_mem_save_lpszVendorId_0 = NULL;
	TALLOC_CTX *_mem_save_lpszVendorId_1 = NULL;
	TALLOC_CTX *_mem_save_lpszCSDVersion_0 = NULL;
	TALLOC_CTX *_mem_save_lpszCSDVersion_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.lpwMajorVersion);
		NDR_ZERO_STRUCTP(r->out.lpwMajorVersion);
		NDR_PULL_ALLOC(ndr, r->out.lpwMinorVersion);
		NDR_ZERO_STRUCTP(r->out.lpwMinorVersion);
		NDR_PULL_ALLOC(ndr, r->out.lpwBuildNumber);
		NDR_ZERO_STRUCTP(r->out.lpwBuildNumber);
		NDR_PULL_ALLOC(ndr, r->out.lpszVendorId);
		NDR_ZERO_STRUCTP(r->out.lpszVendorId);
		NDR_PULL_ALLOC(ndr, r->out.lpszCSDVersion);
		NDR_ZERO_STRUCTP(r->out.lpszCSDVersion);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpwMajorVersion);
		}
		_mem_save_lpwMajorVersion_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpwMajorVersion, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->out.lpwMajorVersion));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpwMajorVersion_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpwMinorVersion);
		}
		_mem_save_lpwMinorVersion_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpwMinorVersion, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->out.lpwMinorVersion));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpwMinorVersion_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpwBuildNumber);
		}
		_mem_save_lpwBuildNumber_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpwBuildNumber, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->out.lpwBuildNumber));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpwBuildNumber_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpszVendorId);
		}
		_mem_save_lpszVendorId_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpszVendorId, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpszVendorId));
		if (_ptr_lpszVendorId) {
			NDR_PULL_ALLOC(ndr, *r->out.lpszVendorId);
		} else {
			*r->out.lpszVendorId = NULL;
		}
		if (*r->out.lpszVendorId) {
			_mem_save_lpszVendorId_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.lpszVendorId, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.lpszVendorId));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.lpszVendorId));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.lpszVendorId, &size_lpszVendorId_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.lpszVendorId, &length_lpszVendorId_2));
			if (length_lpszVendorId_2 > size_lpszVendorId_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszVendorId_2, length_lpszVendorId_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszVendorId_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.lpszVendorId, length_lpszVendorId_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpszVendorId_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpszVendorId_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpszCSDVersion);
		}
		_mem_save_lpszCSDVersion_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpszCSDVersion, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpszCSDVersion));
		if (_ptr_lpszCSDVersion) {
			NDR_PULL_ALLOC(ndr, *r->out.lpszCSDVersion);
		} else {
			*r->out.lpszCSDVersion = NULL;
		}
		if (*r->out.lpszCSDVersion) {
			_mem_save_lpszCSDVersion_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.lpszCSDVersion, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.lpszCSDVersion));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.lpszCSDVersion));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.lpszCSDVersion, &size_lpszCSDVersion_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.lpszCSDVersion, &length_lpszCSDVersion_2));
			if (length_lpszCSDVersion_2 > size_lpszCSDVersion_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszCSDVersion_2, length_lpszCSDVersion_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszCSDVersion_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.lpszCSDVersion, length_lpszCSDVersion_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpszCSDVersion_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpszCSDVersion_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GetClusterVersion(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_GetClusterVersion *r)
{
	ndr_print_struct(ndr, name, "clusapi_GetClusterVersion");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_GetClusterVersion");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_GetClusterVersion");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpwMajorVersion", r->out.lpwMajorVersion);
		ndr->depth++;
		ndr_print_uint16(ndr, "lpwMajorVersion", *r->out.lpwMajorVersion);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpwMinorVersion", r->out.lpwMinorVersion);
		ndr->depth++;
		ndr_print_uint16(ndr, "lpwMinorVersion", *r->out.lpwMinorVersion);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpwBuildNumber", r->out.lpwBuildNumber);
		ndr->depth++;
		ndr_print_uint16(ndr, "lpwBuildNumber", *r->out.lpwBuildNumber);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpszVendorId", r->out.lpszVendorId);
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszVendorId", *r->out.lpszVendorId);
		ndr->depth++;
		if (*r->out.lpszVendorId) {
			ndr_print_string(ndr, "lpszVendorId", *r->out.lpszVendorId);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "lpszCSDVersion", r->out.lpszCSDVersion);
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszCSDVersion", *r->out.lpszCSDVersion);
		ndr->depth++;
		if (*r->out.lpszCSDVersion) {
			ndr_print_string(ndr, "lpszCSDVersion", *r->out.lpszCSDVersion);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_GetQuorumResource(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_GetQuorumResource *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.lpszResourceName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpszDeviceName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pdwMaxQuorumLogSize == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.lpszResourceName));
		if (*r->out.lpszResourceName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.lpszResourceName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.lpszResourceName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.lpszResourceName, ndr_charset_length(*r->out.lpszResourceName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.lpszDeviceName));
		if (*r->out.lpszDeviceName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.lpszDeviceName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.lpszDeviceName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.lpszDeviceName, ndr_charset_length(*r->out.lpszDeviceName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pdwMaxQuorumLogSize));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GetQuorumResource(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_GetQuorumResource *r)
{
	uint32_t _ptr_lpszResourceName;
	uint32_t size_lpszResourceName_2 = 0;
	uint32_t length_lpszResourceName_2 = 0;
	uint32_t _ptr_lpszDeviceName;
	uint32_t size_lpszDeviceName_2 = 0;
	uint32_t length_lpszDeviceName_2 = 0;
	TALLOC_CTX *_mem_save_lpszResourceName_0 = NULL;
	TALLOC_CTX *_mem_save_lpszResourceName_1 = NULL;
	TALLOC_CTX *_mem_save_lpszDeviceName_0 = NULL;
	TALLOC_CTX *_mem_save_lpszDeviceName_1 = NULL;
	TALLOC_CTX *_mem_save_pdwMaxQuorumLogSize_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.lpszResourceName);
		NDR_ZERO_STRUCTP(r->out.lpszResourceName);
		NDR_PULL_ALLOC(ndr, r->out.lpszDeviceName);
		NDR_ZERO_STRUCTP(r->out.lpszDeviceName);
		NDR_PULL_ALLOC(ndr, r->out.pdwMaxQuorumLogSize);
		NDR_ZERO_STRUCTP(r->out.pdwMaxQuorumLogSize);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpszResourceName);
		}
		_mem_save_lpszResourceName_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpszResourceName, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpszResourceName));
		if (_ptr_lpszResourceName) {
			NDR_PULL_ALLOC(ndr, *r->out.lpszResourceName);
		} else {
			*r->out.lpszResourceName = NULL;
		}
		if (*r->out.lpszResourceName) {
			_mem_save_lpszResourceName_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.lpszResourceName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.lpszResourceName));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.lpszResourceName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.lpszResourceName, &size_lpszResourceName_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.lpszResourceName, &length_lpszResourceName_2));
			if (length_lpszResourceName_2 > size_lpszResourceName_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszResourceName_2, length_lpszResourceName_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszResourceName_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.lpszResourceName, length_lpszResourceName_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpszResourceName_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpszResourceName_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpszDeviceName);
		}
		_mem_save_lpszDeviceName_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpszDeviceName, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpszDeviceName));
		if (_ptr_lpszDeviceName) {
			NDR_PULL_ALLOC(ndr, *r->out.lpszDeviceName);
		} else {
			*r->out.lpszDeviceName = NULL;
		}
		if (*r->out.lpszDeviceName) {
			_mem_save_lpszDeviceName_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.lpszDeviceName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.lpszDeviceName));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.lpszDeviceName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.lpszDeviceName, &size_lpszDeviceName_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.lpszDeviceName, &length_lpszDeviceName_2));
			if (length_lpszDeviceName_2 > size_lpszDeviceName_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszDeviceName_2, length_lpszDeviceName_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszDeviceName_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.lpszDeviceName, length_lpszDeviceName_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpszDeviceName_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpszDeviceName_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pdwMaxQuorumLogSize);
		}
		_mem_save_pdwMaxQuorumLogSize_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pdwMaxQuorumLogSize, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pdwMaxQuorumLogSize));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pdwMaxQuorumLogSize_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GetQuorumResource(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_GetQuorumResource *r)
{
	ndr_print_struct(ndr, name, "clusapi_GetQuorumResource");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_GetQuorumResource");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_GetQuorumResource");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszResourceName", r->out.lpszResourceName);
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszResourceName", *r->out.lpszResourceName);
		ndr->depth++;
		if (*r->out.lpszResourceName) {
			ndr_print_string(ndr, "lpszResourceName", *r->out.lpszResourceName);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "lpszDeviceName", r->out.lpszDeviceName);
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszDeviceName", *r->out.lpszDeviceName);
		ndr->depth++;
		if (*r->out.lpszDeviceName) {
			ndr_print_string(ndr, "lpszDeviceName", *r->out.lpszDeviceName);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "pdwMaxQuorumLogSize", r->out.pdwMaxQuorumLogSize);
		ndr->depth++;
		ndr_print_uint32(ndr, "pdwMaxQuorumLogSize", *r->out.pdwMaxQuorumLogSize);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_SetQuorumResource(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_SetQuorumResource *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszDeviceName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszDeviceName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszDeviceName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszDeviceName, ndr_charset_length(r->in.lpszDeviceName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwMaxQuorumLogSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_SetQuorumResource(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_SetQuorumResource *r)
{
	uint32_t size_lpszDeviceName_1 = 0;
	uint32_t length_lpszDeviceName_1 = 0;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszDeviceName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszDeviceName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszDeviceName, &size_lpszDeviceName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszDeviceName, &length_lpszDeviceName_1));
		if (length_lpszDeviceName_1 > size_lpszDeviceName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszDeviceName_1, length_lpszDeviceName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszDeviceName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszDeviceName, length_lpszDeviceName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwMaxQuorumLogSize));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_SetQuorumResource(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_SetQuorumResource *r)
{
	ndr_print_struct(ndr, name, "clusapi_SetQuorumResource");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_SetQuorumResource");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr_print_ptr(ndr, "lpszDeviceName", r->in.lpszDeviceName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszDeviceName", r->in.lpszDeviceName);
		ndr->depth--;
		ndr_print_uint32(ndr, "dwMaxQuorumLogSize", r->in.dwMaxQuorumLogSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_SetQuorumResource");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CreateEnum(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CreateEnum *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ClusterEnumType(ndr, NDR_SCALARS, r->in.dwType));
	}
	if (flags & NDR_OUT) {
		if (r->out.ReturnEnum == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ReturnEnum));
		if (*r->out.ReturnEnum) {
			NDR_CHECK(ndr_push_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ReturnEnum));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CreateEnum(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CreateEnum *r)
{
	uint32_t _ptr_ReturnEnum;
	TALLOC_CTX *_mem_save_ReturnEnum_0 = NULL;
	TALLOC_CTX *_mem_save_ReturnEnum_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ClusterEnumType(ndr, NDR_SCALARS, &r->in.dwType));
		NDR_PULL_ALLOC(ndr, r->out.ReturnEnum);
		NDR_ZERO_STRUCTP(r->out.ReturnEnum);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ReturnEnum);
		}
		_mem_save_ReturnEnum_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ReturnEnum, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ReturnEnum));
		if (_ptr_ReturnEnum) {
			NDR_PULL_ALLOC(ndr, *r->out.ReturnEnum);
		} else {
			*r->out.ReturnEnum = NULL;
		}
		if (*r->out.ReturnEnum) {
			_mem_save_ReturnEnum_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ReturnEnum, 0);
			NDR_CHECK(ndr_pull_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ReturnEnum));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReturnEnum_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReturnEnum_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CreateEnum(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CreateEnum *r)
{
	ndr_print_struct(ndr, name, "clusapi_CreateEnum");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CreateEnum");
		ndr->depth++;
		ndr_print_ClusterEnumType(ndr, "dwType", r->in.dwType);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CreateEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "ReturnEnum", r->out.ReturnEnum);
		ndr->depth++;
		ndr_print_ptr(ndr, "ReturnEnum", *r->out.ReturnEnum);
		ndr->depth++;
		if (*r->out.ReturnEnum) {
			ndr_print_ENUM_LIST(ndr, "ReturnEnum", *r->out.ReturnEnum);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_OpenResource(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_OpenResource *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszResourceName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszResourceName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszResourceName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszResourceName, ndr_charset_length(r->in.lpszResourceName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.Status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.hResource == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.Status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.hResource));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_OpenResource(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_OpenResource *r)
{
	uint32_t size_lpszResourceName_1 = 0;
	uint32_t length_lpszResourceName_1 = 0;
	TALLOC_CTX *_mem_save_Status_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	TALLOC_CTX *_mem_save_hResource_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszResourceName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszResourceName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszResourceName, &size_lpszResourceName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszResourceName, &length_lpszResourceName_1));
		if (length_lpszResourceName_1 > size_lpszResourceName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszResourceName_1, length_lpszResourceName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszResourceName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszResourceName, length_lpszResourceName_1, sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.Status);
		NDR_ZERO_STRUCTP(r->out.Status);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		NDR_PULL_ALLOC(ndr, r->out.hResource);
		NDR_ZERO_STRUCTP(r->out.hResource);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Status);
		}
		_mem_save_Status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.Status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.hResource);
		}
		_mem_save_hResource_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.hResource, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.hResource));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hResource_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_OpenResource(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_OpenResource *r)
{
	ndr_print_struct(ndr, name, "clusapi_OpenResource");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_OpenResource");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszResourceName", r->in.lpszResourceName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszResourceName", r->in.lpszResourceName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_OpenResource");
		ndr->depth++;
		ndr_print_ptr(ndr, "Status", r->out.Status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "Status", *r->out.Status);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_ptr(ndr, "hResource", r->out.hResource);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", r->out.hResource);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CreateResource(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CreateResource *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszResourceName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.lpszResourceType == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszResourceName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszResourceName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszResourceName, ndr_charset_length(r->in.lpszResourceName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszResourceType, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszResourceType, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszResourceType, ndr_charset_length(r->in.lpszResourceType, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_clusapi_CreateResourceFlags(ndr, NDR_SCALARS, r->in.dwFlags));
	}
	if (flags & NDR_OUT) {
		if (r->out.Status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.hResource == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.Status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.hResource));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CreateResource(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CreateResource *r)
{
	uint32_t size_lpszResourceName_1 = 0;
	uint32_t length_lpszResourceName_1 = 0;
	uint32_t size_lpszResourceType_1 = 0;
	uint32_t length_lpszResourceType_1 = 0;
	TALLOC_CTX *_mem_save_Status_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	TALLOC_CTX *_mem_save_hResource_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszResourceName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszResourceName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszResourceName, &size_lpszResourceName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszResourceName, &length_lpszResourceName_1));
		if (length_lpszResourceName_1 > size_lpszResourceName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszResourceName_1, length_lpszResourceName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszResourceName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszResourceName, length_lpszResourceName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszResourceType));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszResourceType));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszResourceType, &size_lpszResourceType_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszResourceType, &length_lpszResourceType_1));
		if (length_lpszResourceType_1 > size_lpszResourceType_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszResourceType_1, length_lpszResourceType_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszResourceType_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszResourceType, length_lpszResourceType_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_clusapi_CreateResourceFlags(ndr, NDR_SCALARS, &r->in.dwFlags));
		NDR_PULL_ALLOC(ndr, r->out.Status);
		NDR_ZERO_STRUCTP(r->out.Status);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		NDR_PULL_ALLOC(ndr, r->out.hResource);
		NDR_ZERO_STRUCTP(r->out.hResource);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Status);
		}
		_mem_save_Status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.Status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.hResource);
		}
		_mem_save_hResource_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.hResource, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.hResource));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hResource_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CreateResource(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CreateResource *r)
{
	ndr_print_struct(ndr, name, "clusapi_CreateResource");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CreateResource");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroup", &r->in.hGroup);
		ndr_print_ptr(ndr, "lpszResourceName", r->in.lpszResourceName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszResourceName", r->in.lpszResourceName);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpszResourceType", r->in.lpszResourceType);
		ndr->depth++;
		ndr_print_string(ndr, "lpszResourceType", r->in.lpszResourceType);
		ndr->depth--;
		ndr_print_clusapi_CreateResourceFlags(ndr, "dwFlags", r->in.dwFlags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CreateResource");
		ndr->depth++;
		ndr_print_ptr(ndr, "Status", r->out.Status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "Status", *r->out.Status);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_ptr(ndr, "hResource", r->out.hResource);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", r->out.hResource);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_DeleteResource(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_DeleteResource *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_DeleteResource(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_DeleteResource *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_DeleteResource(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_DeleteResource *r)
{
	ndr_print_struct(ndr, name, "clusapi_DeleteResource");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_DeleteResource");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_DeleteResource");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CloseResource(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CloseResource *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.Resource == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.Resource));
	}
	if (flags & NDR_OUT) {
		if (r->out.Resource == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.Resource));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CloseResource(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CloseResource *r)
{
	TALLOC_CTX *_mem_save_Resource_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.Resource);
		}
		_mem_save_Resource_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.Resource, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.Resource));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Resource_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.Resource);
		*r->out.Resource = *r->in.Resource;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.Resource == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.Resource);
			NDR_ZERO_STRUCTP(r->in.Resource);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Resource);
		}
		_mem_save_Resource_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Resource, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.Resource));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Resource_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CloseResource(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CloseResource *r)
{
	ndr_print_struct(ndr, name, "clusapi_CloseResource");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CloseResource");
		ndr->depth++;
		ndr_print_ptr(ndr, "Resource", r->in.Resource);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "Resource", r->in.Resource);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CloseResource");
		ndr->depth++;
		ndr_print_ptr(ndr, "Resource", r->out.Resource);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "Resource", r->out.Resource);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_GetResourceState(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_GetResourceState *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
	}
	if (flags & NDR_OUT) {
		if (r->out.State == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.NodeName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.GroupName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_clusapi_ClusterResourceState(ndr, NDR_SCALARS, *r->out.State));
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.NodeName));
		if (*r->out.NodeName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.NodeName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.NodeName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.NodeName, ndr_charset_length(*r->out.NodeName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.GroupName));
		if (*r->out.GroupName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.GroupName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.GroupName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.GroupName, ndr_charset_length(*r->out.GroupName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GetResourceState(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_GetResourceState *r)
{
	uint32_t _ptr_NodeName;
	uint32_t size_NodeName_2 = 0;
	uint32_t length_NodeName_2 = 0;
	uint32_t _ptr_GroupName;
	uint32_t size_GroupName_2 = 0;
	uint32_t length_GroupName_2 = 0;
	TALLOC_CTX *_mem_save_State_0 = NULL;
	TALLOC_CTX *_mem_save_NodeName_0 = NULL;
	TALLOC_CTX *_mem_save_NodeName_1 = NULL;
	TALLOC_CTX *_mem_save_GroupName_0 = NULL;
	TALLOC_CTX *_mem_save_GroupName_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_PULL_ALLOC(ndr, r->out.State);
		NDR_ZERO_STRUCTP(r->out.State);
		NDR_PULL_ALLOC(ndr, r->out.NodeName);
		NDR_ZERO_STRUCTP(r->out.NodeName);
		NDR_PULL_ALLOC(ndr, r->out.GroupName);
		NDR_ZERO_STRUCTP(r->out.GroupName);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.State);
		}
		_mem_save_State_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.State, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_clusapi_ClusterResourceState(ndr, NDR_SCALARS, r->out.State));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_State_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.NodeName);
		}
		_mem_save_NodeName_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.NodeName, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_NodeName));
		if (_ptr_NodeName) {
			NDR_PULL_ALLOC(ndr, *r->out.NodeName);
		} else {
			*r->out.NodeName = NULL;
		}
		if (*r->out.NodeName) {
			_mem_save_NodeName_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.NodeName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.NodeName));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.NodeName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.NodeName, &size_NodeName_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.NodeName, &length_NodeName_2));
			if (length_NodeName_2 > size_NodeName_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_NodeName_2, length_NodeName_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_NodeName_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.NodeName, length_NodeName_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_NodeName_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_NodeName_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.GroupName);
		}
		_mem_save_GroupName_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.GroupName, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_GroupName));
		if (_ptr_GroupName) {
			NDR_PULL_ALLOC(ndr, *r->out.GroupName);
		} else {
			*r->out.GroupName = NULL;
		}
		if (*r->out.GroupName) {
			_mem_save_GroupName_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.GroupName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.GroupName));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.GroupName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.GroupName, &size_GroupName_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.GroupName, &length_GroupName_2));
			if (length_GroupName_2 > size_GroupName_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_GroupName_2, length_GroupName_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_GroupName_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.GroupName, length_GroupName_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_GroupName_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_GroupName_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GetResourceState(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_GetResourceState *r)
{
	ndr_print_struct(ndr, name, "clusapi_GetResourceState");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_GetResourceState");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_GetResourceState");
		ndr->depth++;
		ndr_print_ptr(ndr, "State", r->out.State);
		ndr->depth++;
		ndr_print_clusapi_ClusterResourceState(ndr, "State", *r->out.State);
		ndr->depth--;
		ndr_print_ptr(ndr, "NodeName", r->out.NodeName);
		ndr->depth++;
		ndr_print_ptr(ndr, "NodeName", *r->out.NodeName);
		ndr->depth++;
		if (*r->out.NodeName) {
			ndr_print_string(ndr, "NodeName", *r->out.NodeName);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "GroupName", r->out.GroupName);
		ndr->depth++;
		ndr_print_ptr(ndr, "GroupName", *r->out.GroupName);
		ndr->depth++;
		if (*r->out.GroupName) {
			ndr_print_string(ndr, "GroupName", *r->out.GroupName);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_SetResourceName(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_SetResourceName *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszResourceName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszResourceName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszResourceName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszResourceName, ndr_charset_length(r->in.lpszResourceName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_SetResourceName(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_SetResourceName *r)
{
	uint32_t size_lpszResourceName_1 = 0;
	uint32_t length_lpszResourceName_1 = 0;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszResourceName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszResourceName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszResourceName, &size_lpszResourceName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszResourceName, &length_lpszResourceName_1));
		if (length_lpszResourceName_1 > size_lpszResourceName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszResourceName_1, length_lpszResourceName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszResourceName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszResourceName, length_lpszResourceName_1, sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_SetResourceName(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_SetResourceName *r)
{
	ndr_print_struct(ndr, name, "clusapi_SetResourceName");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_SetResourceName");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr_print_ptr(ndr, "lpszResourceName", r->in.lpszResourceName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszResourceName", r->in.lpszResourceName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_SetResourceName");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_GetResourceId(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_GetResourceId *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
	}
	if (flags & NDR_OUT) {
		if (r->out.pGuid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.pGuid));
		if (*r->out.pGuid) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.pGuid, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.pGuid, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.pGuid, ndr_charset_length(*r->out.pGuid, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GetResourceId(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_GetResourceId *r)
{
	uint32_t _ptr_pGuid;
	uint32_t size_pGuid_2 = 0;
	uint32_t length_pGuid_2 = 0;
	TALLOC_CTX *_mem_save_pGuid_0 = NULL;
	TALLOC_CTX *_mem_save_pGuid_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_PULL_ALLOC(ndr, r->out.pGuid);
		NDR_ZERO_STRUCTP(r->out.pGuid);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pGuid);
		}
		_mem_save_pGuid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pGuid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pGuid));
		if (_ptr_pGuid) {
			NDR_PULL_ALLOC(ndr, *r->out.pGuid);
		} else {
			*r->out.pGuid = NULL;
		}
		if (*r->out.pGuid) {
			_mem_save_pGuid_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.pGuid, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.pGuid));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.pGuid));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.pGuid, &size_pGuid_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.pGuid, &length_pGuid_2));
			if (length_pGuid_2 > size_pGuid_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pGuid_2, length_pGuid_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pGuid_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.pGuid, length_pGuid_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pGuid_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pGuid_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GetResourceId(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_GetResourceId *r)
{
	ndr_print_struct(ndr, name, "clusapi_GetResourceId");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_GetResourceId");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_GetResourceId");
		ndr->depth++;
		ndr_print_ptr(ndr, "pGuid", r->out.pGuid);
		ndr->depth++;
		ndr_print_ptr(ndr, "pGuid", *r->out.pGuid);
		ndr->depth++;
		if (*r->out.pGuid) {
			ndr_print_string(ndr, "pGuid", *r->out.pGuid);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_GetResourceType(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_GetResourceType *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpszResourceType == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.lpszResourceType));
		if (*r->out.lpszResourceType) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.lpszResourceType, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.lpszResourceType, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.lpszResourceType, ndr_charset_length(*r->out.lpszResourceType, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GetResourceType(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_GetResourceType *r)
{
	uint32_t _ptr_lpszResourceType;
	uint32_t size_lpszResourceType_2 = 0;
	uint32_t length_lpszResourceType_2 = 0;
	TALLOC_CTX *_mem_save_lpszResourceType_0 = NULL;
	TALLOC_CTX *_mem_save_lpszResourceType_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_PULL_ALLOC(ndr, r->out.lpszResourceType);
		NDR_ZERO_STRUCTP(r->out.lpszResourceType);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpszResourceType);
		}
		_mem_save_lpszResourceType_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpszResourceType, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpszResourceType));
		if (_ptr_lpszResourceType) {
			NDR_PULL_ALLOC(ndr, *r->out.lpszResourceType);
		} else {
			*r->out.lpszResourceType = NULL;
		}
		if (*r->out.lpszResourceType) {
			_mem_save_lpszResourceType_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.lpszResourceType, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.lpszResourceType));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.lpszResourceType));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.lpszResourceType, &size_lpszResourceType_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.lpszResourceType, &length_lpszResourceType_2));
			if (length_lpszResourceType_2 > size_lpszResourceType_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszResourceType_2, length_lpszResourceType_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszResourceType_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.lpszResourceType, length_lpszResourceType_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpszResourceType_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpszResourceType_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GetResourceType(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_GetResourceType *r)
{
	ndr_print_struct(ndr, name, "clusapi_GetResourceType");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_GetResourceType");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_GetResourceType");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszResourceType", r->out.lpszResourceType);
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszResourceType", *r->out.lpszResourceType);
		ndr->depth++;
		if (*r->out.lpszResourceType) {
			ndr_print_string(ndr, "lpszResourceType", *r->out.lpszResourceType);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_FailResource(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_FailResource *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_FailResource(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_FailResource *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_FailResource(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_FailResource *r)
{
	ndr_print_struct(ndr, name, "clusapi_FailResource");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_FailResource");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_FailResource");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_OnlineResource(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_OnlineResource *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_OnlineResource(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_OnlineResource *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_OnlineResource(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_OnlineResource *r)
{
	ndr_print_struct(ndr, name, "clusapi_OnlineResource");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_OnlineResource");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_OnlineResource");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_OfflineResource(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_OfflineResource *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_OfflineResource(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_OfflineResource *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_OfflineResource(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_OfflineResource *r)
{
	ndr_print_struct(ndr, name, "clusapi_OfflineResource");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_OfflineResource");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_OfflineResource");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_AddResourceDependency(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_AddResourceDependency *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hDependsOn));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_AddResourceDependency(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_AddResourceDependency *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hDependsOn));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_AddResourceDependency(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_AddResourceDependency *r)
{
	ndr_print_struct(ndr, name, "clusapi_AddResourceDependency");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_AddResourceDependency");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr_print_policy_handle(ndr, "hDependsOn", &r->in.hDependsOn);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_AddResourceDependency");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_RemoveResourceDependency(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_RemoveResourceDependency *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hDependsOn));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_RemoveResourceDependency(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_RemoveResourceDependency *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hDependsOn));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_RemoveResourceDependency(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_RemoveResourceDependency *r)
{
	ndr_print_struct(ndr, name, "clusapi_RemoveResourceDependency");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_RemoveResourceDependency");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr_print_policy_handle(ndr, "hDependsOn", &r->in.hDependsOn);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_RemoveResourceDependency");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CanResourceBeDependent(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CanResourceBeDependent *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResourceDependent));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CanResourceBeDependent(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CanResourceBeDependent *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResourceDependent));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CanResourceBeDependent(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CanResourceBeDependent *r)
{
	ndr_print_struct(ndr, name, "clusapi_CanResourceBeDependent");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CanResourceBeDependent");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr_print_policy_handle(ndr, "hResourceDependent", &r->in.hResourceDependent);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CanResourceBeDependent");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CreateResEnum(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CreateResEnum *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwType));
	}
	if (flags & NDR_OUT) {
		if (r->out.ReturnEnum == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ReturnEnum));
		if (*r->out.ReturnEnum) {
			NDR_CHECK(ndr_push_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ReturnEnum));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CreateResEnum(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CreateResEnum *r)
{
	uint32_t _ptr_ReturnEnum;
	TALLOC_CTX *_mem_save_ReturnEnum_0 = NULL;
	TALLOC_CTX *_mem_save_ReturnEnum_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwType));
		NDR_PULL_ALLOC(ndr, r->out.ReturnEnum);
		NDR_ZERO_STRUCTP(r->out.ReturnEnum);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ReturnEnum);
		}
		_mem_save_ReturnEnum_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ReturnEnum, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ReturnEnum));
		if (_ptr_ReturnEnum) {
			NDR_PULL_ALLOC(ndr, *r->out.ReturnEnum);
		} else {
			*r->out.ReturnEnum = NULL;
		}
		if (*r->out.ReturnEnum) {
			_mem_save_ReturnEnum_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ReturnEnum, 0);
			NDR_CHECK(ndr_pull_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ReturnEnum));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReturnEnum_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReturnEnum_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CreateResEnum(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CreateResEnum *r)
{
	ndr_print_struct(ndr, name, "clusapi_CreateResEnum");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CreateResEnum");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr_print_uint32(ndr, "dwType", r->in.dwType);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CreateResEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "ReturnEnum", r->out.ReturnEnum);
		ndr->depth++;
		ndr_print_ptr(ndr, "ReturnEnum", *r->out.ReturnEnum);
		ndr->depth++;
		if (*r->out.ReturnEnum) {
			ndr_print_ENUM_LIST(ndr, "ReturnEnum", *r->out.ReturnEnum);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_AddResourceNode(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_AddResourceNode *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_AddResourceNode(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_AddResourceNode *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_AddResourceNode(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_AddResourceNode *r)
{
	ndr_print_struct(ndr, name, "clusapi_AddResourceNode");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_AddResourceNode");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr_print_policy_handle(ndr, "hNode", &r->in.hNode);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_AddResourceNode");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_RemoveResourceNode(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_RemoveResourceNode *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_RemoveResourceNode(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_RemoveResourceNode *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_RemoveResourceNode(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_RemoveResourceNode *r)
{
	ndr_print_struct(ndr, name, "clusapi_RemoveResourceNode");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_RemoveResourceNode");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr_print_policy_handle(ndr, "hNode", &r->in.hNode);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_RemoveResourceNode");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_ChangeResourceGroup(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_ChangeResourceGroup *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_ChangeResourceGroup(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_ChangeResourceGroup *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_ChangeResourceGroup(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_ChangeResourceGroup *r)
{
	ndr_print_struct(ndr, name, "clusapi_ChangeResourceGroup");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_ChangeResourceGroup");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr_print_policy_handle(ndr, "hGroup", &r->in.hGroup);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_ChangeResourceGroup");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CreateResourceType(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CreateResourceType *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszTypeName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.lpszDisplayName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.lpszDllName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszTypeName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszTypeName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszTypeName, ndr_charset_length(r->in.lpszTypeName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszDisplayName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszDisplayName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszDisplayName, ndr_charset_length(r->in.lpszDisplayName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszDllName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszDllName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszDllName, ndr_charset_length(r->in.lpszDllName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwLooksAlive));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwIsAlive));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CreateResourceType(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CreateResourceType *r)
{
	uint32_t size_lpszTypeName_1 = 0;
	uint32_t length_lpszTypeName_1 = 0;
	uint32_t size_lpszDisplayName_1 = 0;
	uint32_t length_lpszDisplayName_1 = 0;
	uint32_t size_lpszDllName_1 = 0;
	uint32_t length_lpszDllName_1 = 0;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszTypeName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszTypeName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszTypeName, &size_lpszTypeName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszTypeName, &length_lpszTypeName_1));
		if (length_lpszTypeName_1 > size_lpszTypeName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszTypeName_1, length_lpszTypeName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszTypeName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszTypeName, length_lpszTypeName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszDisplayName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszDisplayName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszDisplayName, &size_lpszDisplayName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszDisplayName, &length_lpszDisplayName_1));
		if (length_lpszDisplayName_1 > size_lpszDisplayName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszDisplayName_1, length_lpszDisplayName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszDisplayName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszDisplayName, length_lpszDisplayName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszDllName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszDllName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszDllName, &size_lpszDllName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszDllName, &length_lpszDllName_1));
		if (length_lpszDllName_1 > size_lpszDllName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszDllName_1, length_lpszDllName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszDllName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszDllName, length_lpszDllName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwLooksAlive));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwIsAlive));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CreateResourceType(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CreateResourceType *r)
{
	ndr_print_struct(ndr, name, "clusapi_CreateResourceType");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CreateResourceType");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszTypeName", r->in.lpszTypeName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszTypeName", r->in.lpszTypeName);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpszDisplayName", r->in.lpszDisplayName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszDisplayName", r->in.lpszDisplayName);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpszDllName", r->in.lpszDllName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszDllName", r->in.lpszDllName);
		ndr->depth--;
		ndr_print_uint32(ndr, "dwLooksAlive", r->in.dwLooksAlive);
		ndr_print_uint32(ndr, "dwIsAlive", r->in.dwIsAlive);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CreateResourceType");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_DeleteResourceType(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_DeleteResourceType *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszTypeName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszTypeName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszTypeName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszTypeName, ndr_charset_length(r->in.lpszTypeName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_DeleteResourceType(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_DeleteResourceType *r)
{
	uint32_t size_lpszTypeName_1 = 0;
	uint32_t length_lpszTypeName_1 = 0;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszTypeName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszTypeName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszTypeName, &size_lpszTypeName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszTypeName, &length_lpszTypeName_1));
		if (length_lpszTypeName_1 > size_lpszTypeName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszTypeName_1, length_lpszTypeName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszTypeName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszTypeName, length_lpszTypeName_1, sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_DeleteResourceType(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_DeleteResourceType *r)
{
	ndr_print_struct(ndr, name, "clusapi_DeleteResourceType");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_DeleteResourceType");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszTypeName", r->in.lpszTypeName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszTypeName", r->in.lpszTypeName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_DeleteResourceType");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_GetRootKey(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_GetRootKey *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_winreg_AccessMask(ndr, NDR_SCALARS, r->in.samDesired));
	}
	if (flags & NDR_OUT) {
		if (r->out.Status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.phKey == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.Status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.phKey));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GetRootKey(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_GetRootKey *r)
{
	TALLOC_CTX *_mem_save_Status_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	TALLOC_CTX *_mem_save_phKey_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_winreg_AccessMask(ndr, NDR_SCALARS, &r->in.samDesired));
		NDR_PULL_ALLOC(ndr, r->out.Status);
		NDR_ZERO_STRUCTP(r->out.Status);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		NDR_PULL_ALLOC(ndr, r->out.phKey);
		NDR_ZERO_STRUCTP(r->out.phKey);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Status);
		}
		_mem_save_Status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.Status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.phKey);
		}
		_mem_save_phKey_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.phKey, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.phKey));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_phKey_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GetRootKey(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_GetRootKey *r)
{
	ndr_print_struct(ndr, name, "clusapi_GetRootKey");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_GetRootKey");
		ndr->depth++;
		ndr_print_winreg_AccessMask(ndr, "samDesired", r->in.samDesired);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_GetRootKey");
		ndr->depth++;
		ndr_print_ptr(ndr, "Status", r->out.Status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "Status", *r->out.Status);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_ptr(ndr, "phKey", r->out.phKey);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "phKey", r->out.phKey);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CreateKey(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CreateKey *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpSubKey == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpSubKey, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpSubKey, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpSubKey, ndr_charset_length(r->in.lpSubKey, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwOptions));
		NDR_CHECK(ndr_push_winreg_AccessMask(ndr, NDR_SCALARS, r->in.samDesired));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpSecurityAttributes));
		if (r->in.lpSecurityAttributes) {
			NDR_CHECK(ndr_push_RPC_SECURITY_ATTRIBUTES(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.lpSecurityAttributes));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.lpdwDisposition == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.Status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.phKey == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpdwDisposition));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.Status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.phKey));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CreateKey(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CreateKey *r)
{
	uint32_t size_lpSubKey_1 = 0;
	uint32_t length_lpSubKey_1 = 0;
	uint32_t _ptr_lpSecurityAttributes;
	TALLOC_CTX *_mem_save_lpSecurityAttributes_0 = NULL;
	TALLOC_CTX *_mem_save_lpdwDisposition_0 = NULL;
	TALLOC_CTX *_mem_save_Status_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	TALLOC_CTX *_mem_save_phKey_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpSubKey));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpSubKey));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpSubKey, &size_lpSubKey_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpSubKey, &length_lpSubKey_1));
		if (length_lpSubKey_1 > size_lpSubKey_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpSubKey_1, length_lpSubKey_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpSubKey_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpSubKey, length_lpSubKey_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwOptions));
		NDR_CHECK(ndr_pull_winreg_AccessMask(ndr, NDR_SCALARS, &r->in.samDesired));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpSecurityAttributes));
		if (_ptr_lpSecurityAttributes) {
			NDR_PULL_ALLOC(ndr, r->in.lpSecurityAttributes);
		} else {
			r->in.lpSecurityAttributes = NULL;
		}
		if (r->in.lpSecurityAttributes) {
			_mem_save_lpSecurityAttributes_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpSecurityAttributes, 0);
			NDR_CHECK(ndr_pull_RPC_SECURITY_ATTRIBUTES(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.lpSecurityAttributes));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpSecurityAttributes_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.lpdwDisposition);
		NDR_ZERO_STRUCTP(r->out.lpdwDisposition);
		NDR_PULL_ALLOC(ndr, r->out.Status);
		NDR_ZERO_STRUCTP(r->out.Status);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		NDR_PULL_ALLOC(ndr, r->out.phKey);
		NDR_ZERO_STRUCTP(r->out.phKey);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpdwDisposition);
		}
		_mem_save_lpdwDisposition_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpdwDisposition, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpdwDisposition));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpdwDisposition_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Status);
		}
		_mem_save_Status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.Status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.phKey);
		}
		_mem_save_phKey_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.phKey, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.phKey));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_phKey_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CreateKey(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CreateKey *r)
{
	ndr_print_struct(ndr, name, "clusapi_CreateKey");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CreateKey");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hKey", &r->in.hKey);
		ndr_print_ptr(ndr, "lpSubKey", r->in.lpSubKey);
		ndr->depth++;
		ndr_print_string(ndr, "lpSubKey", r->in.lpSubKey);
		ndr->depth--;
		ndr_print_uint32(ndr, "dwOptions", r->in.dwOptions);
		ndr_print_winreg_AccessMask(ndr, "samDesired", r->in.samDesired);
		ndr_print_ptr(ndr, "lpSecurityAttributes", r->in.lpSecurityAttributes);
		ndr->depth++;
		if (r->in.lpSecurityAttributes) {
			ndr_print_RPC_SECURITY_ATTRIBUTES(ndr, "lpSecurityAttributes", r->in.lpSecurityAttributes);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CreateKey");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpdwDisposition", r->out.lpdwDisposition);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpdwDisposition", *r->out.lpdwDisposition);
		ndr->depth--;
		ndr_print_ptr(ndr, "Status", r->out.Status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "Status", *r->out.Status);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_ptr(ndr, "phKey", r->out.phKey);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "phKey", r->out.phKey);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_OpenKey(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_OpenKey *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpSubKey == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpSubKey, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpSubKey, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpSubKey, ndr_charset_length(r->in.lpSubKey, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_winreg_AccessMask(ndr, NDR_SCALARS, r->in.samDesired));
	}
	if (flags & NDR_OUT) {
		if (r->out.Status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.phKey == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.Status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.phKey));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_OpenKey(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_OpenKey *r)
{
	uint32_t size_lpSubKey_1 = 0;
	uint32_t length_lpSubKey_1 = 0;
	TALLOC_CTX *_mem_save_Status_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	TALLOC_CTX *_mem_save_phKey_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpSubKey));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpSubKey));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpSubKey, &size_lpSubKey_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpSubKey, &length_lpSubKey_1));
		if (length_lpSubKey_1 > size_lpSubKey_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpSubKey_1, length_lpSubKey_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpSubKey_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpSubKey, length_lpSubKey_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_winreg_AccessMask(ndr, NDR_SCALARS, &r->in.samDesired));
		NDR_PULL_ALLOC(ndr, r->out.Status);
		NDR_ZERO_STRUCTP(r->out.Status);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		NDR_PULL_ALLOC(ndr, r->out.phKey);
		NDR_ZERO_STRUCTP(r->out.phKey);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Status);
		}
		_mem_save_Status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.Status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.phKey);
		}
		_mem_save_phKey_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.phKey, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.phKey));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_phKey_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_OpenKey(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_OpenKey *r)
{
	ndr_print_struct(ndr, name, "clusapi_OpenKey");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_OpenKey");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hKey", &r->in.hKey);
		ndr_print_ptr(ndr, "lpSubKey", r->in.lpSubKey);
		ndr->depth++;
		ndr_print_string(ndr, "lpSubKey", r->in.lpSubKey);
		ndr->depth--;
		ndr_print_winreg_AccessMask(ndr, "samDesired", r->in.samDesired);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_OpenKey");
		ndr->depth++;
		ndr_print_ptr(ndr, "Status", r->out.Status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "Status", *r->out.Status);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_ptr(ndr, "phKey", r->out.phKey);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "phKey", r->out.phKey);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_EnumKey(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_EnumKey *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwIndex));
	}
	if (flags & NDR_OUT) {
		if (r->out.KeyName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpftLastWriteTime == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.KeyName));
		if (*r->out.KeyName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.KeyName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.KeyName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.KeyName, ndr_charset_length(*r->out.KeyName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, *r->out.lpftLastWriteTime));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_EnumKey(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_EnumKey *r)
{
	uint32_t _ptr_KeyName;
	uint32_t size_KeyName_2 = 0;
	uint32_t length_KeyName_2 = 0;
	TALLOC_CTX *_mem_save_KeyName_0 = NULL;
	TALLOC_CTX *_mem_save_KeyName_1 = NULL;
	TALLOC_CTX *_mem_save_lpftLastWriteTime_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwIndex));
		NDR_PULL_ALLOC(ndr, r->out.KeyName);
		NDR_ZERO_STRUCTP(r->out.KeyName);
		NDR_PULL_ALLOC(ndr, r->out.lpftLastWriteTime);
		NDR_ZERO_STRUCTP(r->out.lpftLastWriteTime);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.KeyName);
		}
		_mem_save_KeyName_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.KeyName, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_KeyName));
		if (_ptr_KeyName) {
			NDR_PULL_ALLOC(ndr, *r->out.KeyName);
		} else {
			*r->out.KeyName = NULL;
		}
		if (*r->out.KeyName) {
			_mem_save_KeyName_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.KeyName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.KeyName));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.KeyName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.KeyName, &size_KeyName_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.KeyName, &length_KeyName_2));
			if (length_KeyName_2 > size_KeyName_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_KeyName_2, length_KeyName_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_KeyName_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.KeyName, length_KeyName_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_KeyName_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_KeyName_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpftLastWriteTime);
		}
		_mem_save_lpftLastWriteTime_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpftLastWriteTime, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, r->out.lpftLastWriteTime));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpftLastWriteTime_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_EnumKey(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_EnumKey *r)
{
	ndr_print_struct(ndr, name, "clusapi_EnumKey");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_EnumKey");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hKey", &r->in.hKey);
		ndr_print_uint32(ndr, "dwIndex", r->in.dwIndex);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_EnumKey");
		ndr->depth++;
		ndr_print_ptr(ndr, "KeyName", r->out.KeyName);
		ndr->depth++;
		ndr_print_ptr(ndr, "KeyName", *r->out.KeyName);
		ndr->depth++;
		if (*r->out.KeyName) {
			ndr_print_string(ndr, "KeyName", *r->out.KeyName);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "lpftLastWriteTime", r->out.lpftLastWriteTime);
		ndr->depth++;
		ndr_print_NTTIME(ndr, "lpftLastWriteTime", *r->out.lpftLastWriteTime);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_SetValue(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_SetValue *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpValueName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.lpData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpValueName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpValueName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpValueName, ndr_charset_length(r->in.lpValueName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_winreg_Type(ndr, NDR_SCALARS, r->in.dwType));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbData));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpData, r->in.cbData));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbData));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_SetValue(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_SetValue *r)
{
	uint32_t size_lpValueName_1 = 0;
	uint32_t length_lpValueName_1 = 0;
	uint32_t size_lpData_1 = 0;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpValueName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpValueName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpValueName, &size_lpValueName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpValueName, &length_lpValueName_1));
		if (length_lpValueName_1 > size_lpValueName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpValueName_1, length_lpValueName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpValueName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpValueName, length_lpValueName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_winreg_Type(ndr, NDR_SCALARS, &r->in.dwType));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpData));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpData, &size_lpData_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.lpData, size_lpData_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpData, size_lpData_1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbData));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.lpData) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpData, r->in.cbData));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_SetValue(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_SetValue *r)
{
	ndr_print_struct(ndr, name, "clusapi_SetValue");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_SetValue");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hKey", &r->in.hKey);
		ndr_print_ptr(ndr, "lpValueName", r->in.lpValueName);
		ndr->depth++;
		ndr_print_string(ndr, "lpValueName", r->in.lpValueName);
		ndr->depth--;
		ndr_print_winreg_Type(ndr, "dwType", r->in.dwType);
		ndr_print_ptr(ndr, "lpData", r->in.lpData);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpData", r->in.lpData, r->in.cbData);
		ndr->depth--;
		ndr_print_uint32(ndr, "cbData", r->in.cbData);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_SetValue");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_DeleteValue(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_DeleteValue *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpValueName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpValueName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpValueName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpValueName, ndr_charset_length(r->in.lpValueName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_DeleteValue(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_DeleteValue *r)
{
	uint32_t size_lpValueName_1 = 0;
	uint32_t length_lpValueName_1 = 0;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpValueName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpValueName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpValueName, &size_lpValueName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpValueName, &length_lpValueName_1));
		if (length_lpValueName_1 > size_lpValueName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpValueName_1, length_lpValueName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpValueName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpValueName, length_lpValueName_1, sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_DeleteValue(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_DeleteValue *r)
{
	ndr_print_struct(ndr, name, "clusapi_DeleteValue");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_DeleteValue");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hKey", &r->in.hKey);
		ndr_print_ptr(ndr, "lpValueName", r->in.lpValueName);
		ndr->depth++;
		ndr_print_string(ndr, "lpValueName", r->in.lpValueName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_DeleteValue");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_QueryValue(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_QueryValue *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpValueName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpValueName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpValueName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpValueName, ndr_charset_length(r->in.lpValueName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbData));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpValueType == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpcbRequired == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winreg_Type(ndr, NDR_SCALARS, *r->out.lpValueType));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbData));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.lpData, r->in.cbData));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpcbRequired));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_QueryValue(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_QueryValue *r)
{
	uint32_t size_lpValueName_1 = 0;
	uint32_t length_lpValueName_1 = 0;
	uint32_t size_lpData_1 = 0;
	TALLOC_CTX *_mem_save_lpValueType_0 = NULL;
	TALLOC_CTX *_mem_save_lpcbRequired_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpValueName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpValueName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpValueName, &size_lpValueName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpValueName, &length_lpValueName_1));
		if (length_lpValueName_1 > size_lpValueName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpValueName_1, length_lpValueName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpValueName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpValueName, length_lpValueName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbData));
		NDR_PULL_ALLOC(ndr, r->out.lpValueType);
		NDR_ZERO_STRUCTP(r->out.lpValueType);
		NDR_PULL_ALLOC_N(ndr, r->out.lpData, r->in.cbData);
		memset(r->out.lpData, 0, (r->in.cbData) * sizeof(*r->out.lpData));
		NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		NDR_ZERO_STRUCTP(r->out.lpcbRequired);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpValueType);
		}
		_mem_save_lpValueType_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpValueType, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winreg_Type(ndr, NDR_SCALARS, r->out.lpValueType));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpValueType_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.lpData));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.lpData, &size_lpData_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.lpData, size_lpData_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.lpData, size_lpData_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		}
		_mem_save_lpcbRequired_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpcbRequired, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpcbRequired));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpcbRequired_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.lpData) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.lpData, r->in.cbData));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_QueryValue(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_QueryValue *r)
{
	ndr_print_struct(ndr, name, "clusapi_QueryValue");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_QueryValue");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hKey", &r->in.hKey);
		ndr_print_ptr(ndr, "lpValueName", r->in.lpValueName);
		ndr->depth++;
		ndr_print_string(ndr, "lpValueName", r->in.lpValueName);
		ndr->depth--;
		ndr_print_uint32(ndr, "cbData", r->in.cbData);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_QueryValue");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpValueType", r->out.lpValueType);
		ndr->depth++;
		ndr_print_winreg_Type(ndr, "lpValueType", *r->out.lpValueType);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpData", r->out.lpData);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpData", r->out.lpData, r->in.cbData);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpcbRequired", r->out.lpcbRequired);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpcbRequired", *r->out.lpcbRequired);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_DeleteKey(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_DeleteKey *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpSubKey == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpSubKey, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpSubKey, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpSubKey, ndr_charset_length(r->in.lpSubKey, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_DeleteKey(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_DeleteKey *r)
{
	uint32_t size_lpSubKey_1 = 0;
	uint32_t length_lpSubKey_1 = 0;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpSubKey));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpSubKey));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpSubKey, &size_lpSubKey_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpSubKey, &length_lpSubKey_1));
		if (length_lpSubKey_1 > size_lpSubKey_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpSubKey_1, length_lpSubKey_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpSubKey_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpSubKey, length_lpSubKey_1, sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_DeleteKey(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_DeleteKey *r)
{
	ndr_print_struct(ndr, name, "clusapi_DeleteKey");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_DeleteKey");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hKey", &r->in.hKey);
		ndr_print_ptr(ndr, "lpSubKey", r->in.lpSubKey);
		ndr->depth++;
		ndr_print_string(ndr, "lpSubKey", r->in.lpSubKey);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_DeleteKey");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_EnumValue(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_EnumValue *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpcbData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwIndex));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.lpcbData));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpValueName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpType == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpcbData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.TotalSize == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.lpValueName));
		if (*r->out.lpValueName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.lpValueName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.lpValueName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.lpValueName, ndr_charset_length(*r->out.lpValueName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_winreg_Type(ndr, NDR_SCALARS, *r->out.lpType));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.lpcbData));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.lpData, *r->out.lpcbData));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpcbData));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.TotalSize));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_EnumValue(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_EnumValue *r)
{
	uint32_t _ptr_lpValueName;
	uint32_t size_lpValueName_2 = 0;
	uint32_t length_lpValueName_2 = 0;
	uint32_t size_lpData_1 = 0;
	TALLOC_CTX *_mem_save_lpValueName_0 = NULL;
	TALLOC_CTX *_mem_save_lpValueName_1 = NULL;
	TALLOC_CTX *_mem_save_lpType_0 = NULL;
	TALLOC_CTX *_mem_save_lpcbData_0 = NULL;
	TALLOC_CTX *_mem_save_TotalSize_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwIndex));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.lpcbData);
		}
		_mem_save_lpcbData_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.lpcbData, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.lpcbData));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpcbData_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.lpValueName);
		NDR_ZERO_STRUCTP(r->out.lpValueName);
		NDR_PULL_ALLOC(ndr, r->out.lpType);
		NDR_ZERO_STRUCTP(r->out.lpType);
		NDR_PULL_ALLOC_N(ndr, r->out.lpData, *r->in.lpcbData);
		memset(r->out.lpData, 0, (*r->in.lpcbData) * sizeof(*r->out.lpData));
		NDR_PULL_ALLOC(ndr, r->out.lpcbData);
		*r->out.lpcbData = *r->in.lpcbData;
		NDR_PULL_ALLOC(ndr, r->out.TotalSize);
		NDR_ZERO_STRUCTP(r->out.TotalSize);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.lpcbData == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.lpcbData);
			NDR_ZERO_STRUCTP(r->in.lpcbData);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpValueName);
		}
		_mem_save_lpValueName_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpValueName, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpValueName));
		if (_ptr_lpValueName) {
			NDR_PULL_ALLOC(ndr, *r->out.lpValueName);
		} else {
			*r->out.lpValueName = NULL;
		}
		if (*r->out.lpValueName) {
			_mem_save_lpValueName_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.lpValueName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.lpValueName));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.lpValueName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.lpValueName, &size_lpValueName_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.lpValueName, &length_lpValueName_2));
			if (length_lpValueName_2 > size_lpValueName_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpValueName_2, length_lpValueName_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpValueName_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.lpValueName, length_lpValueName_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpValueName_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpValueName_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpType);
		}
		_mem_save_lpType_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpType, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winreg_Type(ndr, NDR_SCALARS, r->out.lpType));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpType_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.lpData));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.lpData, &size_lpData_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.lpData, size_lpData_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.lpData, size_lpData_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpcbData);
		}
		_mem_save_lpcbData_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpcbData, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpcbData));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpcbData_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.TotalSize);
		}
		_mem_save_TotalSize_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.TotalSize, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.TotalSize));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_TotalSize_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.lpData) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.lpData, *r->out.lpcbData));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_EnumValue(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_EnumValue *r)
{
	ndr_print_struct(ndr, name, "clusapi_EnumValue");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_EnumValue");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hKey", &r->in.hKey);
		ndr_print_uint32(ndr, "dwIndex", r->in.dwIndex);
		ndr_print_ptr(ndr, "lpcbData", r->in.lpcbData);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpcbData", *r->in.lpcbData);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_EnumValue");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpValueName", r->out.lpValueName);
		ndr->depth++;
		ndr_print_ptr(ndr, "lpValueName", *r->out.lpValueName);
		ndr->depth++;
		if (*r->out.lpValueName) {
			ndr_print_string(ndr, "lpValueName", *r->out.lpValueName);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "lpType", r->out.lpType);
		ndr->depth++;
		ndr_print_winreg_Type(ndr, "lpType", *r->out.lpType);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpData", r->out.lpData);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpData", r->out.lpData, *r->out.lpcbData);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpcbData", r->out.lpcbData);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpcbData", *r->out.lpcbData);
		ndr->depth--;
		ndr_print_ptr(ndr, "TotalSize", r->out.TotalSize);
		ndr->depth++;
		ndr_print_uint32(ndr, "TotalSize", *r->out.TotalSize);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CloseKey(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CloseKey *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pKey == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.pKey));
	}
	if (flags & NDR_OUT) {
		if (r->out.pKey == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.pKey));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CloseKey(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CloseKey *r)
{
	TALLOC_CTX *_mem_save_pKey_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pKey);
		}
		_mem_save_pKey_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pKey, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.pKey));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pKey_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.pKey);
		*r->out.pKey = *r->in.pKey;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.pKey == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pKey);
			NDR_ZERO_STRUCTP(r->in.pKey);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pKey);
		}
		_mem_save_pKey_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pKey, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.pKey));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pKey_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CloseKey(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CloseKey *r)
{
	ndr_print_struct(ndr, name, "clusapi_CloseKey");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CloseKey");
		ndr->depth++;
		ndr_print_ptr(ndr, "pKey", r->in.pKey);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "pKey", r->in.pKey);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CloseKey");
		ndr->depth++;
		ndr_print_ptr(ndr, "pKey", r->out.pKey);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "pKey", r->out.pKey);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_QueryInfoKey(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_QueryInfoKey *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpcSubKeys == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpcbMaxSubKeyLen == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpcValues == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpcbMaxValueNameLen == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpcbMaxValueLen == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpcbSecurityDescriptor == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpftLastWriteTime == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpcSubKeys));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpcbMaxSubKeyLen));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpcValues));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpcbMaxValueNameLen));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpcbMaxValueLen));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpcbSecurityDescriptor));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, *r->out.lpftLastWriteTime));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_QueryInfoKey(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_QueryInfoKey *r)
{
	TALLOC_CTX *_mem_save_lpcSubKeys_0 = NULL;
	TALLOC_CTX *_mem_save_lpcbMaxSubKeyLen_0 = NULL;
	TALLOC_CTX *_mem_save_lpcValues_0 = NULL;
	TALLOC_CTX *_mem_save_lpcbMaxValueNameLen_0 = NULL;
	TALLOC_CTX *_mem_save_lpcbMaxValueLen_0 = NULL;
	TALLOC_CTX *_mem_save_lpcbSecurityDescriptor_0 = NULL;
	TALLOC_CTX *_mem_save_lpftLastWriteTime_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_PULL_ALLOC(ndr, r->out.lpcSubKeys);
		NDR_ZERO_STRUCTP(r->out.lpcSubKeys);
		NDR_PULL_ALLOC(ndr, r->out.lpcbMaxSubKeyLen);
		NDR_ZERO_STRUCTP(r->out.lpcbMaxSubKeyLen);
		NDR_PULL_ALLOC(ndr, r->out.lpcValues);
		NDR_ZERO_STRUCTP(r->out.lpcValues);
		NDR_PULL_ALLOC(ndr, r->out.lpcbMaxValueNameLen);
		NDR_ZERO_STRUCTP(r->out.lpcbMaxValueNameLen);
		NDR_PULL_ALLOC(ndr, r->out.lpcbMaxValueLen);
		NDR_ZERO_STRUCTP(r->out.lpcbMaxValueLen);
		NDR_PULL_ALLOC(ndr, r->out.lpcbSecurityDescriptor);
		NDR_ZERO_STRUCTP(r->out.lpcbSecurityDescriptor);
		NDR_PULL_ALLOC(ndr, r->out.lpftLastWriteTime);
		NDR_ZERO_STRUCTP(r->out.lpftLastWriteTime);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpcSubKeys);
		}
		_mem_save_lpcSubKeys_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpcSubKeys, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpcSubKeys));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpcSubKeys_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpcbMaxSubKeyLen);
		}
		_mem_save_lpcbMaxSubKeyLen_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpcbMaxSubKeyLen, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpcbMaxSubKeyLen));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpcbMaxSubKeyLen_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpcValues);
		}
		_mem_save_lpcValues_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpcValues, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpcValues));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpcValues_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpcbMaxValueNameLen);
		}
		_mem_save_lpcbMaxValueNameLen_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpcbMaxValueNameLen, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpcbMaxValueNameLen));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpcbMaxValueNameLen_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpcbMaxValueLen);
		}
		_mem_save_lpcbMaxValueLen_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpcbMaxValueLen, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpcbMaxValueLen));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpcbMaxValueLen_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpcbSecurityDescriptor);
		}
		_mem_save_lpcbSecurityDescriptor_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpcbSecurityDescriptor, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpcbSecurityDescriptor));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpcbSecurityDescriptor_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpftLastWriteTime);
		}
		_mem_save_lpftLastWriteTime_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpftLastWriteTime, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, r->out.lpftLastWriteTime));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpftLastWriteTime_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_QueryInfoKey(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_QueryInfoKey *r)
{
	ndr_print_struct(ndr, name, "clusapi_QueryInfoKey");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_QueryInfoKey");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hKey", &r->in.hKey);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_QueryInfoKey");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpcSubKeys", r->out.lpcSubKeys);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpcSubKeys", *r->out.lpcSubKeys);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpcbMaxSubKeyLen", r->out.lpcbMaxSubKeyLen);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpcbMaxSubKeyLen", *r->out.lpcbMaxSubKeyLen);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpcValues", r->out.lpcValues);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpcValues", *r->out.lpcValues);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpcbMaxValueNameLen", r->out.lpcbMaxValueNameLen);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpcbMaxValueNameLen", *r->out.lpcbMaxValueNameLen);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpcbMaxValueLen", r->out.lpcbMaxValueLen);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpcbMaxValueLen", *r->out.lpcbMaxValueLen);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpcbSecurityDescriptor", r->out.lpcbSecurityDescriptor);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpcbSecurityDescriptor", *r->out.lpcbSecurityDescriptor);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpftLastWriteTime", r->out.lpftLastWriteTime);
		ndr->depth++;
		ndr_print_NTTIME(ndr, "lpftLastWriteTime", *r->out.lpftLastWriteTime);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_SetKeySecurity(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_SetKeySecurity *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pRpcSecurityDescriptor == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.SecurityInformation));
		NDR_CHECK(ndr_push_RPC_SECURITY_DESCRIPTOR(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pRpcSecurityDescriptor));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_SetKeySecurity(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_SetKeySecurity *r)
{
	TALLOC_CTX *_mem_save_pRpcSecurityDescriptor_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.SecurityInformation));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pRpcSecurityDescriptor);
		}
		_mem_save_pRpcSecurityDescriptor_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pRpcSecurityDescriptor, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_RPC_SECURITY_DESCRIPTOR(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pRpcSecurityDescriptor));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pRpcSecurityDescriptor_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.pRpcSecurityDescriptor == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pRpcSecurityDescriptor);
			NDR_ZERO_STRUCTP(r->in.pRpcSecurityDescriptor);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_SetKeySecurity(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_SetKeySecurity *r)
{
	ndr_print_struct(ndr, name, "clusapi_SetKeySecurity");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_SetKeySecurity");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hKey", &r->in.hKey);
		ndr_print_uint32(ndr, "SecurityInformation", r->in.SecurityInformation);
		ndr_print_ptr(ndr, "pRpcSecurityDescriptor", r->in.pRpcSecurityDescriptor);
		ndr->depth++;
		ndr_print_RPC_SECURITY_DESCRIPTOR(ndr, "pRpcSecurityDescriptor", r->in.pRpcSecurityDescriptor);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_SetKeySecurity");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_GetKeySecurity(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_GetKeySecurity *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pRpcSecurityDescriptor == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.SecurityInformation));
		NDR_CHECK(ndr_push_RPC_SECURITY_DESCRIPTOR(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pRpcSecurityDescriptor));
	}
	if (flags & NDR_OUT) {
		if (r->out.pRpcSecurityDescriptor == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_RPC_SECURITY_DESCRIPTOR(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.pRpcSecurityDescriptor));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GetKeySecurity(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_GetKeySecurity *r)
{
	TALLOC_CTX *_mem_save_pRpcSecurityDescriptor_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.SecurityInformation));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pRpcSecurityDescriptor);
		}
		_mem_save_pRpcSecurityDescriptor_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pRpcSecurityDescriptor, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_RPC_SECURITY_DESCRIPTOR(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pRpcSecurityDescriptor));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pRpcSecurityDescriptor_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.pRpcSecurityDescriptor);
		*r->out.pRpcSecurityDescriptor = *r->in.pRpcSecurityDescriptor;
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.pRpcSecurityDescriptor == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pRpcSecurityDescriptor);
			NDR_ZERO_STRUCTP(r->in.pRpcSecurityDescriptor);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pRpcSecurityDescriptor);
		}
		_mem_save_pRpcSecurityDescriptor_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pRpcSecurityDescriptor, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_RPC_SECURITY_DESCRIPTOR(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.pRpcSecurityDescriptor));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pRpcSecurityDescriptor_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GetKeySecurity(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_GetKeySecurity *r)
{
	ndr_print_struct(ndr, name, "clusapi_GetKeySecurity");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_GetKeySecurity");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hKey", &r->in.hKey);
		ndr_print_uint32(ndr, "SecurityInformation", r->in.SecurityInformation);
		ndr_print_ptr(ndr, "pRpcSecurityDescriptor", r->in.pRpcSecurityDescriptor);
		ndr->depth++;
		ndr_print_RPC_SECURITY_DESCRIPTOR(ndr, "pRpcSecurityDescriptor", r->in.pRpcSecurityDescriptor);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_GetKeySecurity");
		ndr->depth++;
		ndr_print_ptr(ndr, "pRpcSecurityDescriptor", r->out.pRpcSecurityDescriptor);
		ndr->depth++;
		ndr_print_RPC_SECURITY_DESCRIPTOR(ndr, "pRpcSecurityDescriptor", r->out.pRpcSecurityDescriptor);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_OpenGroup(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_OpenGroup *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszGroupName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszGroupName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszGroupName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszGroupName, ndr_charset_length(r->in.lpszGroupName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.Status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.hGroup == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.Status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.hGroup));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_OpenGroup(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_OpenGroup *r)
{
	uint32_t size_lpszGroupName_1 = 0;
	uint32_t length_lpszGroupName_1 = 0;
	TALLOC_CTX *_mem_save_Status_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	TALLOC_CTX *_mem_save_hGroup_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszGroupName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszGroupName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszGroupName, &size_lpszGroupName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszGroupName, &length_lpszGroupName_1));
		if (length_lpszGroupName_1 > size_lpszGroupName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszGroupName_1, length_lpszGroupName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszGroupName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszGroupName, length_lpszGroupName_1, sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.Status);
		NDR_ZERO_STRUCTP(r->out.Status);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		NDR_PULL_ALLOC(ndr, r->out.hGroup);
		NDR_ZERO_STRUCTP(r->out.hGroup);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Status);
		}
		_mem_save_Status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.Status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.hGroup);
		}
		_mem_save_hGroup_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.hGroup, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.hGroup));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hGroup_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_OpenGroup(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_OpenGroup *r)
{
	ndr_print_struct(ndr, name, "clusapi_OpenGroup");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_OpenGroup");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszGroupName", r->in.lpszGroupName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszGroupName", r->in.lpszGroupName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_OpenGroup");
		ndr->depth++;
		ndr_print_ptr(ndr, "Status", r->out.Status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "Status", *r->out.Status);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_ptr(ndr, "hGroup", r->out.hGroup);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroup", r->out.hGroup);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CreateGroup(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CreateGroup *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszGroupName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszGroupName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszGroupName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszGroupName, ndr_charset_length(r->in.lpszGroupName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.Status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.hGroup == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.Status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.hGroup));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CreateGroup(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CreateGroup *r)
{
	uint32_t size_lpszGroupName_1 = 0;
	uint32_t length_lpszGroupName_1 = 0;
	TALLOC_CTX *_mem_save_Status_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	TALLOC_CTX *_mem_save_hGroup_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszGroupName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszGroupName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszGroupName, &size_lpszGroupName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszGroupName, &length_lpszGroupName_1));
		if (length_lpszGroupName_1 > size_lpszGroupName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszGroupName_1, length_lpszGroupName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszGroupName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszGroupName, length_lpszGroupName_1, sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.Status);
		NDR_ZERO_STRUCTP(r->out.Status);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		NDR_PULL_ALLOC(ndr, r->out.hGroup);
		NDR_ZERO_STRUCTP(r->out.hGroup);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Status);
		}
		_mem_save_Status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.Status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.hGroup);
		}
		_mem_save_hGroup_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.hGroup, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.hGroup));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hGroup_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CreateGroup(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CreateGroup *r)
{
	ndr_print_struct(ndr, name, "clusapi_CreateGroup");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CreateGroup");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszGroupName", r->in.lpszGroupName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszGroupName", r->in.lpszGroupName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CreateGroup");
		ndr->depth++;
		ndr_print_ptr(ndr, "Status", r->out.Status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "Status", *r->out.Status);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_ptr(ndr, "hGroup", r->out.hGroup);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroup", r->out.hGroup);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_DeleteGroup(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_DeleteGroup *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.Group));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->in.force));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_DeleteGroup(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_DeleteGroup *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.Group));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->in.force));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_DeleteGroup(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_DeleteGroup *r)
{
	ndr_print_struct(ndr, name, "clusapi_DeleteGroup");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_DeleteGroup");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "Group", &r->in.Group);
		ndr_print_uint8(ndr, "force", r->in.force);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_DeleteGroup");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CloseGroup(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CloseGroup *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.Group == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.Group));
	}
	if (flags & NDR_OUT) {
		if (r->out.Group == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.Group));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CloseGroup(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CloseGroup *r)
{
	TALLOC_CTX *_mem_save_Group_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.Group);
		}
		_mem_save_Group_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.Group, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.Group));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Group_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.Group);
		*r->out.Group = *r->in.Group;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.Group == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.Group);
			NDR_ZERO_STRUCTP(r->in.Group);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Group);
		}
		_mem_save_Group_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Group, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.Group));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Group_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CloseGroup(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CloseGroup *r)
{
	ndr_print_struct(ndr, name, "clusapi_CloseGroup");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CloseGroup");
		ndr->depth++;
		ndr_print_ptr(ndr, "Group", r->in.Group);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "Group", r->in.Group);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CloseGroup");
		ndr->depth++;
		ndr_print_ptr(ndr, "Group", r->out.Group);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "Group", r->out.Group);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_GetGroupState(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_GetGroupState *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
	}
	if (flags & NDR_OUT) {
		if (r->out.State == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.NodeName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_clusapi_ClusterGroupState(ndr, NDR_SCALARS, *r->out.State));
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.NodeName));
		if (*r->out.NodeName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.NodeName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.NodeName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.NodeName, ndr_charset_length(*r->out.NodeName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GetGroupState(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_GetGroupState *r)
{
	uint32_t _ptr_NodeName;
	uint32_t size_NodeName_2 = 0;
	uint32_t length_NodeName_2 = 0;
	TALLOC_CTX *_mem_save_State_0 = NULL;
	TALLOC_CTX *_mem_save_NodeName_0 = NULL;
	TALLOC_CTX *_mem_save_NodeName_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_PULL_ALLOC(ndr, r->out.State);
		NDR_ZERO_STRUCTP(r->out.State);
		NDR_PULL_ALLOC(ndr, r->out.NodeName);
		NDR_ZERO_STRUCTP(r->out.NodeName);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.State);
		}
		_mem_save_State_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.State, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_clusapi_ClusterGroupState(ndr, NDR_SCALARS, r->out.State));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_State_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.NodeName);
		}
		_mem_save_NodeName_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.NodeName, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_NodeName));
		if (_ptr_NodeName) {
			NDR_PULL_ALLOC(ndr, *r->out.NodeName);
		} else {
			*r->out.NodeName = NULL;
		}
		if (*r->out.NodeName) {
			_mem_save_NodeName_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.NodeName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.NodeName));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.NodeName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.NodeName, &size_NodeName_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.NodeName, &length_NodeName_2));
			if (length_NodeName_2 > size_NodeName_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_NodeName_2, length_NodeName_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_NodeName_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.NodeName, length_NodeName_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_NodeName_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_NodeName_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GetGroupState(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_GetGroupState *r)
{
	ndr_print_struct(ndr, name, "clusapi_GetGroupState");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_GetGroupState");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroup", &r->in.hGroup);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_GetGroupState");
		ndr->depth++;
		ndr_print_ptr(ndr, "State", r->out.State);
		ndr->depth++;
		ndr_print_clusapi_ClusterGroupState(ndr, "State", *r->out.State);
		ndr->depth--;
		ndr_print_ptr(ndr, "NodeName", r->out.NodeName);
		ndr->depth++;
		ndr_print_ptr(ndr, "NodeName", *r->out.NodeName);
		ndr->depth++;
		if (*r->out.NodeName) {
			ndr_print_string(ndr, "NodeName", *r->out.NodeName);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_SetGroupName(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_SetGroupName *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszGroupName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszGroupName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszGroupName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszGroupName, ndr_charset_length(r->in.lpszGroupName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_SetGroupName(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_SetGroupName *r)
{
	uint32_t size_lpszGroupName_1 = 0;
	uint32_t length_lpszGroupName_1 = 0;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszGroupName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszGroupName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszGroupName, &size_lpszGroupName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszGroupName, &length_lpszGroupName_1));
		if (length_lpszGroupName_1 > size_lpszGroupName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszGroupName_1, length_lpszGroupName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszGroupName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszGroupName, length_lpszGroupName_1, sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_SetGroupName(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_SetGroupName *r)
{
	ndr_print_struct(ndr, name, "clusapi_SetGroupName");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_SetGroupName");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroup", &r->in.hGroup);
		ndr_print_ptr(ndr, "lpszGroupName", r->in.lpszGroupName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszGroupName", r->in.lpszGroupName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_SetGroupName");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_GetGroupId(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_GetGroupId *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
	}
	if (flags & NDR_OUT) {
		if (r->out.pGuid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.pGuid));
		if (*r->out.pGuid) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.pGuid, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.pGuid, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.pGuid, ndr_charset_length(*r->out.pGuid, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GetGroupId(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_GetGroupId *r)
{
	uint32_t _ptr_pGuid;
	uint32_t size_pGuid_2 = 0;
	uint32_t length_pGuid_2 = 0;
	TALLOC_CTX *_mem_save_pGuid_0 = NULL;
	TALLOC_CTX *_mem_save_pGuid_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_PULL_ALLOC(ndr, r->out.pGuid);
		NDR_ZERO_STRUCTP(r->out.pGuid);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pGuid);
		}
		_mem_save_pGuid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pGuid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pGuid));
		if (_ptr_pGuid) {
			NDR_PULL_ALLOC(ndr, *r->out.pGuid);
		} else {
			*r->out.pGuid = NULL;
		}
		if (*r->out.pGuid) {
			_mem_save_pGuid_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.pGuid, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.pGuid));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.pGuid));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.pGuid, &size_pGuid_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.pGuid, &length_pGuid_2));
			if (length_pGuid_2 > size_pGuid_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pGuid_2, length_pGuid_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pGuid_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.pGuid, length_pGuid_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pGuid_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pGuid_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GetGroupId(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_GetGroupId *r)
{
	ndr_print_struct(ndr, name, "clusapi_GetGroupId");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_GetGroupId");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroup", &r->in.hGroup);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_GetGroupId");
		ndr->depth++;
		ndr_print_ptr(ndr, "pGuid", r->out.pGuid);
		ndr->depth++;
		ndr_print_ptr(ndr, "pGuid", *r->out.pGuid);
		ndr->depth++;
		if (*r->out.pGuid) {
			ndr_print_string(ndr, "pGuid", *r->out.pGuid);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_GetNodeId(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_GetNodeId *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
	}
	if (flags & NDR_OUT) {
		if (r->out.pGuid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.pGuid));
		if (*r->out.pGuid) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.pGuid, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.pGuid, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.pGuid, ndr_charset_length(*r->out.pGuid, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GetNodeId(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_GetNodeId *r)
{
	uint32_t _ptr_pGuid;
	uint32_t size_pGuid_2 = 0;
	uint32_t length_pGuid_2 = 0;
	TALLOC_CTX *_mem_save_pGuid_0 = NULL;
	TALLOC_CTX *_mem_save_pGuid_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_PULL_ALLOC(ndr, r->out.pGuid);
		NDR_ZERO_STRUCTP(r->out.pGuid);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pGuid);
		}
		_mem_save_pGuid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pGuid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pGuid));
		if (_ptr_pGuid) {
			NDR_PULL_ALLOC(ndr, *r->out.pGuid);
		} else {
			*r->out.pGuid = NULL;
		}
		if (*r->out.pGuid) {
			_mem_save_pGuid_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.pGuid, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.pGuid));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.pGuid));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.pGuid, &size_pGuid_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.pGuid, &length_pGuid_2));
			if (length_pGuid_2 > size_pGuid_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pGuid_2, length_pGuid_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pGuid_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.pGuid, length_pGuid_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pGuid_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pGuid_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GetNodeId(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_GetNodeId *r)
{
	ndr_print_struct(ndr, name, "clusapi_GetNodeId");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_GetNodeId");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNode", &r->in.hNode);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_GetNodeId");
		ndr->depth++;
		ndr_print_ptr(ndr, "pGuid", r->out.pGuid);
		ndr->depth++;
		ndr_print_ptr(ndr, "pGuid", *r->out.pGuid);
		ndr->depth++;
		if (*r->out.pGuid) {
			ndr_print_string(ndr, "pGuid", *r->out.pGuid);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_OnlineGroup(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_OnlineGroup *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_OnlineGroup(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_OnlineGroup *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_OnlineGroup(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_OnlineGroup *r)
{
	ndr_print_struct(ndr, name, "clusapi_OnlineGroup");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_OnlineGroup");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroup", &r->in.hGroup);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_OnlineGroup");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_OfflineGroup(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_OfflineGroup *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_OfflineGroup(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_OfflineGroup *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_OfflineGroup(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_OfflineGroup *r)
{
	ndr_print_struct(ndr, name, "clusapi_OfflineGroup");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_OfflineGroup");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroup", &r->in.hGroup);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_OfflineGroup");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_MoveGroup(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_MoveGroup *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_MoveGroup(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_MoveGroup *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_MoveGroup(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_MoveGroup *r)
{
	ndr_print_struct(ndr, name, "clusapi_MoveGroup");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_MoveGroup");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroup", &r->in.hGroup);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_MoveGroup");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_MoveGroupToNode(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_MoveGroupToNode *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_MoveGroupToNode(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_MoveGroupToNode *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_MoveGroupToNode(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_MoveGroupToNode *r)
{
	ndr_print_struct(ndr, name, "clusapi_MoveGroupToNode");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_MoveGroupToNode");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroup", &r->in.hGroup);
		ndr_print_policy_handle(ndr, "hNode", &r->in.hNode);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_MoveGroupToNode");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CreateGroupResourceEnum(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CreateGroupResourceEnum *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_push_ClusterGroupEnumType(ndr, NDR_SCALARS, r->in.dwType));
	}
	if (flags & NDR_OUT) {
		if (r->out.ReturnEnum == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ReturnEnum));
		if (*r->out.ReturnEnum) {
			NDR_CHECK(ndr_push_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ReturnEnum));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CreateGroupResourceEnum(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CreateGroupResourceEnum *r)
{
	uint32_t _ptr_ReturnEnum;
	TALLOC_CTX *_mem_save_ReturnEnum_0 = NULL;
	TALLOC_CTX *_mem_save_ReturnEnum_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_pull_ClusterGroupEnumType(ndr, NDR_SCALARS, &r->in.dwType));
		NDR_PULL_ALLOC(ndr, r->out.ReturnEnum);
		NDR_ZERO_STRUCTP(r->out.ReturnEnum);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ReturnEnum);
		}
		_mem_save_ReturnEnum_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ReturnEnum, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ReturnEnum));
		if (_ptr_ReturnEnum) {
			NDR_PULL_ALLOC(ndr, *r->out.ReturnEnum);
		} else {
			*r->out.ReturnEnum = NULL;
		}
		if (*r->out.ReturnEnum) {
			_mem_save_ReturnEnum_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ReturnEnum, 0);
			NDR_CHECK(ndr_pull_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ReturnEnum));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReturnEnum_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReturnEnum_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CreateGroupResourceEnum(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CreateGroupResourceEnum *r)
{
	ndr_print_struct(ndr, name, "clusapi_CreateGroupResourceEnum");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CreateGroupResourceEnum");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroup", &r->in.hGroup);
		ndr_print_ClusterGroupEnumType(ndr, "dwType", r->in.dwType);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CreateGroupResourceEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "ReturnEnum", r->out.ReturnEnum);
		ndr->depth++;
		ndr_print_ptr(ndr, "ReturnEnum", *r->out.ReturnEnum);
		ndr->depth++;
		if (*r->out.ReturnEnum) {
			ndr_print_ENUM_LIST(ndr, "ReturnEnum", *r->out.ReturnEnum);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_SetGroupNodeList(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_SetGroupNodeList *r)
{
	uint32_t cntr_multiSzNodeList_1;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.multiSzNodeList));
		if (r->in.multiSzNodeList) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cchListSize));
			for (cntr_multiSzNodeList_1 = 0; cntr_multiSzNodeList_1 < (r->in.cchListSize); cntr_multiSzNodeList_1++) {
				NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.multiSzNodeList[cntr_multiSzNodeList_1]));
			}
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cchListSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_SetGroupNodeList(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_SetGroupNodeList *r)
{
	uint32_t _ptr_multiSzNodeList;
	uint32_t size_multiSzNodeList_1 = 0;
	uint32_t cntr_multiSzNodeList_1;
	TALLOC_CTX *_mem_save_multiSzNodeList_0 = NULL;
	TALLOC_CTX *_mem_save_multiSzNodeList_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_multiSzNodeList));
		if (_ptr_multiSzNodeList) {
			NDR_PULL_ALLOC(ndr, r->in.multiSzNodeList);
		} else {
			r->in.multiSzNodeList = NULL;
		}
		if (r->in.multiSzNodeList) {
			_mem_save_multiSzNodeList_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.multiSzNodeList, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.multiSzNodeList));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.multiSzNodeList, &size_multiSzNodeList_1));
			NDR_PULL_ALLOC_N(ndr, r->in.multiSzNodeList, size_multiSzNodeList_1);
			_mem_save_multiSzNodeList_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.multiSzNodeList, 0);
			for (cntr_multiSzNodeList_1 = 0; cntr_multiSzNodeList_1 < (size_multiSzNodeList_1); cntr_multiSzNodeList_1++) {
				NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.multiSzNodeList[cntr_multiSzNodeList_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_multiSzNodeList_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_multiSzNodeList_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cchListSize));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.multiSzNodeList) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.multiSzNodeList, r->in.cchListSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_SetGroupNodeList(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_SetGroupNodeList *r)
{
	uint32_t cntr_multiSzNodeList_1;
	ndr_print_struct(ndr, name, "clusapi_SetGroupNodeList");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_SetGroupNodeList");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroup", &r->in.hGroup);
		ndr_print_ptr(ndr, "multiSzNodeList", r->in.multiSzNodeList);
		ndr->depth++;
		if (r->in.multiSzNodeList) {
			ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "multiSzNodeList", (uint32_t)(r->in.cchListSize));
			ndr->depth++;
			for (cntr_multiSzNodeList_1 = 0; cntr_multiSzNodeList_1 < (r->in.cchListSize); cntr_multiSzNodeList_1++) {
				ndr_print_uint16(ndr, "multiSzNodeList", r->in.multiSzNodeList[cntr_multiSzNodeList_1]);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "cchListSize", r->in.cchListSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_SetGroupNodeList");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CreateNotify(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CreateNotify *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.Status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.hNotify == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.Status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.hNotify));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CreateNotify(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CreateNotify *r)
{
	TALLOC_CTX *_mem_save_Status_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	TALLOC_CTX *_mem_save_hNotify_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.Status);
		NDR_ZERO_STRUCTP(r->out.Status);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		NDR_PULL_ALLOC(ndr, r->out.hNotify);
		NDR_ZERO_STRUCTP(r->out.hNotify);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Status);
		}
		_mem_save_Status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.Status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.hNotify);
		}
		_mem_save_hNotify_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.hNotify, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.hNotify));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hNotify_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CreateNotify(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CreateNotify *r)
{
	ndr_print_struct(ndr, name, "clusapi_CreateNotify");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CreateNotify");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CreateNotify");
		ndr->depth++;
		ndr_print_ptr(ndr, "Status", r->out.Status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "Status", *r->out.Status);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_ptr(ndr, "hNotify", r->out.hNotify);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNotify", r->out.hNotify);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CloseNotify(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CloseNotify *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.Notify == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.Notify));
	}
	if (flags & NDR_OUT) {
		if (r->out.Notify == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.Notify));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CloseNotify(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CloseNotify *r)
{
	TALLOC_CTX *_mem_save_Notify_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.Notify);
		}
		_mem_save_Notify_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.Notify, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.Notify));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Notify_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.Notify);
		*r->out.Notify = *r->in.Notify;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.Notify == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.Notify);
			NDR_ZERO_STRUCTP(r->in.Notify);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Notify);
		}
		_mem_save_Notify_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Notify, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.Notify));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Notify_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CloseNotify(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CloseNotify *r)
{
	ndr_print_struct(ndr, name, "clusapi_CloseNotify");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CloseNotify");
		ndr->depth++;
		ndr_print_ptr(ndr, "Notify", r->in.Notify);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "Notify", r->in.Notify);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CloseNotify");
		ndr->depth++;
		ndr_print_ptr(ndr, "Notify", r->out.Notify);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "Notify", r->out.Notify);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_AddNotifyCluster(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_AddNotifyCluster *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hCluster));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwFilter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwNotifyKey));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_AddNotifyCluster(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_AddNotifyCluster *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hCluster));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwFilter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwNotifyKey));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_AddNotifyCluster(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_AddNotifyCluster *r)
{
	ndr_print_struct(ndr, name, "clusapi_AddNotifyCluster");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_AddNotifyCluster");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNotify", &r->in.hNotify);
		ndr_print_policy_handle(ndr, "hCluster", &r->in.hCluster);
		ndr_print_uint32(ndr, "dwFilter", r->in.dwFilter);
		ndr_print_uint32(ndr, "dwNotifyKey", r->in.dwNotifyKey);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_AddNotifyCluster");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_AddNotifyNode(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_AddNotifyNode *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwFilter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwNotifyKey));
	}
	if (flags & NDR_OUT) {
		if (r->out.dwStateSequence == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.dwStateSequence));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_AddNotifyNode(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_AddNotifyNode *r)
{
	TALLOC_CTX *_mem_save_dwStateSequence_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwFilter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwNotifyKey));
		NDR_PULL_ALLOC(ndr, r->out.dwStateSequence);
		NDR_ZERO_STRUCTP(r->out.dwStateSequence);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.dwStateSequence);
		}
		_mem_save_dwStateSequence_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.dwStateSequence, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.dwStateSequence));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dwStateSequence_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_AddNotifyNode(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_AddNotifyNode *r)
{
	ndr_print_struct(ndr, name, "clusapi_AddNotifyNode");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_AddNotifyNode");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNotify", &r->in.hNotify);
		ndr_print_policy_handle(ndr, "hNode", &r->in.hNode);
		ndr_print_uint32(ndr, "dwFilter", r->in.dwFilter);
		ndr_print_uint32(ndr, "dwNotifyKey", r->in.dwNotifyKey);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_AddNotifyNode");
		ndr->depth++;
		ndr_print_ptr(ndr, "dwStateSequence", r->out.dwStateSequence);
		ndr->depth++;
		ndr_print_uint32(ndr, "dwStateSequence", *r->out.dwStateSequence);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_AddNotifyGroup(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_AddNotifyGroup *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwFilter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwNotifyKey));
	}
	if (flags & NDR_OUT) {
		if (r->out.dwStateSequence == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.dwStateSequence));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_AddNotifyGroup(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_AddNotifyGroup *r)
{
	TALLOC_CTX *_mem_save_dwStateSequence_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwFilter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwNotifyKey));
		NDR_PULL_ALLOC(ndr, r->out.dwStateSequence);
		NDR_ZERO_STRUCTP(r->out.dwStateSequence);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.dwStateSequence);
		}
		_mem_save_dwStateSequence_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.dwStateSequence, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.dwStateSequence));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dwStateSequence_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_AddNotifyGroup(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_AddNotifyGroup *r)
{
	ndr_print_struct(ndr, name, "clusapi_AddNotifyGroup");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_AddNotifyGroup");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNotify", &r->in.hNotify);
		ndr_print_policy_handle(ndr, "hGroup", &r->in.hGroup);
		ndr_print_uint32(ndr, "dwFilter", r->in.dwFilter);
		ndr_print_uint32(ndr, "dwNotifyKey", r->in.dwNotifyKey);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_AddNotifyGroup");
		ndr->depth++;
		ndr_print_ptr(ndr, "dwStateSequence", r->out.dwStateSequence);
		ndr->depth++;
		ndr_print_uint32(ndr, "dwStateSequence", *r->out.dwStateSequence);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_AddNotifyResource(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_AddNotifyResource *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwFilter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwNotifyKey));
	}
	if (flags & NDR_OUT) {
		if (r->out.dwStateSequence == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.dwStateSequence));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_AddNotifyResource(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_AddNotifyResource *r)
{
	TALLOC_CTX *_mem_save_dwStateSequence_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwFilter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwNotifyKey));
		NDR_PULL_ALLOC(ndr, r->out.dwStateSequence);
		NDR_ZERO_STRUCTP(r->out.dwStateSequence);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.dwStateSequence);
		}
		_mem_save_dwStateSequence_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.dwStateSequence, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.dwStateSequence));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dwStateSequence_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_AddNotifyResource(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_AddNotifyResource *r)
{
	ndr_print_struct(ndr, name, "clusapi_AddNotifyResource");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_AddNotifyResource");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNotify", &r->in.hNotify);
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr_print_uint32(ndr, "dwFilter", r->in.dwFilter);
		ndr_print_uint32(ndr, "dwNotifyKey", r->in.dwNotifyKey);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_AddNotifyResource");
		ndr->depth++;
		ndr_print_ptr(ndr, "dwStateSequence", r->out.dwStateSequence);
		ndr->depth++;
		ndr_print_uint32(ndr, "dwStateSequence", *r->out.dwStateSequence);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_AddNotifyKey(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_AddNotifyKey *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwNotifyKey));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.Filter));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->in.WatchSubTree));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_AddNotifyKey(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_AddNotifyKey *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwNotifyKey));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.Filter));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->in.WatchSubTree));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_AddNotifyKey(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_AddNotifyKey *r)
{
	ndr_print_struct(ndr, name, "clusapi_AddNotifyKey");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_AddNotifyKey");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNotify", &r->in.hNotify);
		ndr_print_policy_handle(ndr, "hKey", &r->in.hKey);
		ndr_print_uint32(ndr, "dwNotifyKey", r->in.dwNotifyKey);
		ndr_print_uint32(ndr, "Filter", r->in.Filter);
		ndr_print_uint8(ndr, "WatchSubTree", r->in.WatchSubTree);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_AddNotifyKey");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_ReAddNotifyNode(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_ReAddNotifyNode *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwFilter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwNotifyKey));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.StateSequence));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_ReAddNotifyNode(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_ReAddNotifyNode *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwFilter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwNotifyKey));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.StateSequence));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_ReAddNotifyNode(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_ReAddNotifyNode *r)
{
	ndr_print_struct(ndr, name, "clusapi_ReAddNotifyNode");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_ReAddNotifyNode");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNotify", &r->in.hNotify);
		ndr_print_policy_handle(ndr, "hNode", &r->in.hNode);
		ndr_print_uint32(ndr, "dwFilter", r->in.dwFilter);
		ndr_print_uint32(ndr, "dwNotifyKey", r->in.dwNotifyKey);
		ndr_print_uint32(ndr, "StateSequence", r->in.StateSequence);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_ReAddNotifyNode");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_ReAddNotifyGroup(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_ReAddNotifyGroup *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwFilter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwNotifyKey));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.StateSequence));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_ReAddNotifyGroup(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_ReAddNotifyGroup *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwFilter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwNotifyKey));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.StateSequence));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_ReAddNotifyGroup(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_ReAddNotifyGroup *r)
{
	ndr_print_struct(ndr, name, "clusapi_ReAddNotifyGroup");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_ReAddNotifyGroup");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNotify", &r->in.hNotify);
		ndr_print_policy_handle(ndr, "hGroup", &r->in.hGroup);
		ndr_print_uint32(ndr, "dwFilter", r->in.dwFilter);
		ndr_print_uint32(ndr, "dwNotifyKey", r->in.dwNotifyKey);
		ndr_print_uint32(ndr, "StateSequence", r->in.StateSequence);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_ReAddNotifyGroup");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_ReAddNotifyResource(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_ReAddNotifyResource *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwFilter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwNotifyKey));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.StateSequence));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_ReAddNotifyResource(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_ReAddNotifyResource *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwFilter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwNotifyKey));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.StateSequence));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_ReAddNotifyResource(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_ReAddNotifyResource *r)
{
	ndr_print_struct(ndr, name, "clusapi_ReAddNotifyResource");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_ReAddNotifyResource");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNotify", &r->in.hNotify);
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr_print_uint32(ndr, "dwFilter", r->in.dwFilter);
		ndr_print_uint32(ndr, "dwNotifyKey", r->in.dwNotifyKey);
		ndr_print_uint32(ndr, "StateSequence", r->in.StateSequence);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_ReAddNotifyResource");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_GetNotify(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_GetNotify *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
	}
	if (flags & NDR_OUT) {
		if (r->out.dwNotifyKey == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.dwFilter == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.dwStateSequence == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.Name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.dwNotifyKey));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.dwFilter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.dwStateSequence));
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.Name));
		if (*r->out.Name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.Name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.Name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.Name, ndr_charset_length(*r->out.Name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GetNotify(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_GetNotify *r)
{
	uint32_t _ptr_Name;
	uint32_t size_Name_2 = 0;
	uint32_t length_Name_2 = 0;
	TALLOC_CTX *_mem_save_dwNotifyKey_0 = NULL;
	TALLOC_CTX *_mem_save_dwFilter_0 = NULL;
	TALLOC_CTX *_mem_save_dwStateSequence_0 = NULL;
	TALLOC_CTX *_mem_save_Name_0 = NULL;
	TALLOC_CTX *_mem_save_Name_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_PULL_ALLOC(ndr, r->out.dwNotifyKey);
		NDR_ZERO_STRUCTP(r->out.dwNotifyKey);
		NDR_PULL_ALLOC(ndr, r->out.dwFilter);
		NDR_ZERO_STRUCTP(r->out.dwFilter);
		NDR_PULL_ALLOC(ndr, r->out.dwStateSequence);
		NDR_ZERO_STRUCTP(r->out.dwStateSequence);
		NDR_PULL_ALLOC(ndr, r->out.Name);
		NDR_ZERO_STRUCTP(r->out.Name);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.dwNotifyKey);
		}
		_mem_save_dwNotifyKey_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.dwNotifyKey, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.dwNotifyKey));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dwNotifyKey_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.dwFilter);
		}
		_mem_save_dwFilter_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.dwFilter, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.dwFilter));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dwFilter_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.dwStateSequence);
		}
		_mem_save_dwStateSequence_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.dwStateSequence, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.dwStateSequence));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dwStateSequence_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Name);
		}
		_mem_save_Name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Name));
		if (_ptr_Name) {
			NDR_PULL_ALLOC(ndr, *r->out.Name);
		} else {
			*r->out.Name = NULL;
		}
		if (*r->out.Name) {
			_mem_save_Name_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.Name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.Name));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.Name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.Name, &size_Name_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.Name, &length_Name_2));
			if (length_Name_2 > size_Name_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_Name_2, length_Name_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_Name_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.Name, length_Name_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Name_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Name_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GetNotify(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_GetNotify *r)
{
	ndr_print_struct(ndr, name, "clusapi_GetNotify");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_GetNotify");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNotify", &r->in.hNotify);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_GetNotify");
		ndr->depth++;
		ndr_print_ptr(ndr, "dwNotifyKey", r->out.dwNotifyKey);
		ndr->depth++;
		ndr_print_uint32(ndr, "dwNotifyKey", *r->out.dwNotifyKey);
		ndr->depth--;
		ndr_print_ptr(ndr, "dwFilter", r->out.dwFilter);
		ndr->depth++;
		ndr_print_uint32(ndr, "dwFilter", *r->out.dwFilter);
		ndr->depth--;
		ndr_print_ptr(ndr, "dwStateSequence", r->out.dwStateSequence);
		ndr->depth++;
		ndr_print_uint32(ndr, "dwStateSequence", *r->out.dwStateSequence);
		ndr->depth--;
		ndr_print_ptr(ndr, "Name", r->out.Name);
		ndr->depth++;
		ndr_print_ptr(ndr, "Name", *r->out.Name);
		ndr->depth++;
		if (*r->out.Name) {
			ndr_print_string(ndr, "Name", *r->out.Name);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_OpenNode(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_OpenNode *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszNodeName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszNodeName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszNodeName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszNodeName, ndr_charset_length(r->in.lpszNodeName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.Status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.hNode == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.Status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.hNode));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_OpenNode(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_OpenNode *r)
{
	uint32_t size_lpszNodeName_1 = 0;
	uint32_t length_lpszNodeName_1 = 0;
	TALLOC_CTX *_mem_save_Status_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	TALLOC_CTX *_mem_save_hNode_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszNodeName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszNodeName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszNodeName, &size_lpszNodeName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszNodeName, &length_lpszNodeName_1));
		if (length_lpszNodeName_1 > size_lpszNodeName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszNodeName_1, length_lpszNodeName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszNodeName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszNodeName, length_lpszNodeName_1, sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.Status);
		NDR_ZERO_STRUCTP(r->out.Status);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		NDR_PULL_ALLOC(ndr, r->out.hNode);
		NDR_ZERO_STRUCTP(r->out.hNode);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Status);
		}
		_mem_save_Status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.Status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.hNode);
		}
		_mem_save_hNode_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.hNode, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.hNode));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hNode_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_OpenNode(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_OpenNode *r)
{
	ndr_print_struct(ndr, name, "clusapi_OpenNode");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_OpenNode");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszNodeName", r->in.lpszNodeName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszNodeName", r->in.lpszNodeName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_OpenNode");
		ndr->depth++;
		ndr_print_ptr(ndr, "Status", r->out.Status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "Status", *r->out.Status);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_ptr(ndr, "hNode", r->out.hNode);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNode", r->out.hNode);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CloseNode(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CloseNode *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.Node == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.Node));
	}
	if (flags & NDR_OUT) {
		if (r->out.Node == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.Node));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CloseNode(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CloseNode *r)
{
	TALLOC_CTX *_mem_save_Node_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.Node);
		}
		_mem_save_Node_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.Node, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.Node));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Node_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.Node);
		*r->out.Node = *r->in.Node;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.Node == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.Node);
			NDR_ZERO_STRUCTP(r->in.Node);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Node);
		}
		_mem_save_Node_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Node, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.Node));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Node_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CloseNode(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CloseNode *r)
{
	ndr_print_struct(ndr, name, "clusapi_CloseNode");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CloseNode");
		ndr->depth++;
		ndr_print_ptr(ndr, "Node", r->in.Node);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "Node", r->in.Node);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CloseNode");
		ndr->depth++;
		ndr_print_ptr(ndr, "Node", r->out.Node);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "Node", r->out.Node);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_GetNodeState(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_GetNodeState *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
	}
	if (flags & NDR_OUT) {
		if (r->out.State == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_clusapi_ClusterNodeState(ndr, NDR_SCALARS, *r->out.State));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GetNodeState(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_GetNodeState *r)
{
	TALLOC_CTX *_mem_save_State_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_PULL_ALLOC(ndr, r->out.State);
		NDR_ZERO_STRUCTP(r->out.State);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.State);
		}
		_mem_save_State_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.State, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_clusapi_ClusterNodeState(ndr, NDR_SCALARS, r->out.State));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_State_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GetNodeState(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_GetNodeState *r)
{
	ndr_print_struct(ndr, name, "clusapi_GetNodeState");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_GetNodeState");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNode", &r->in.hNode);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_GetNodeState");
		ndr->depth++;
		ndr_print_ptr(ndr, "State", r->out.State);
		ndr->depth++;
		ndr_print_clusapi_ClusterNodeState(ndr, "State", *r->out.State);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_PauseNode(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_PauseNode *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_PauseNode(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_PauseNode *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_PauseNode(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_PauseNode *r)
{
	ndr_print_struct(ndr, name, "clusapi_PauseNode");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_PauseNode");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNode", &r->in.hNode);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_PauseNode");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_ResumeNode(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_ResumeNode *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_ResumeNode(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_ResumeNode *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_ResumeNode(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_ResumeNode *r)
{
	ndr_print_struct(ndr, name, "clusapi_ResumeNode");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_ResumeNode");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNode", &r->in.hNode);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_ResumeNode");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_EvictNode(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_EvictNode *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_EvictNode(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_EvictNode *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_EvictNode(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_EvictNode *r)
{
	ndr_print_struct(ndr, name, "clusapi_EvictNode");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_EvictNode");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNode", &r->in.hNode);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_EvictNode");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_NodeResourceControl(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_NodeResourceControl *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwControlCode));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpInBuffer));
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nInBufferSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, r->in.nInBufferSize));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nInBufferSize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nOutBufferSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpOutBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpBytesReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpcbRequired == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nOutBufferSize));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpcbRequired));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_NodeResourceControl(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_NodeResourceControl *r)
{
	uint32_t _ptr_lpInBuffer;
	uint32_t size_lpInBuffer_1 = 0;
	uint32_t size_lpOutBuffer_1 = 0;
	uint32_t length_lpOutBuffer_1 = 0;
	TALLOC_CTX *_mem_save_lpInBuffer_0 = NULL;
	TALLOC_CTX *_mem_save_lpBytesReturned_0 = NULL;
	TALLOC_CTX *_mem_save_lpcbRequired_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwControlCode));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpInBuffer));
		if (_ptr_lpInBuffer) {
			NDR_PULL_ALLOC(ndr, r->in.lpInBuffer);
		} else {
			r->in.lpInBuffer = NULL;
		}
		if (r->in.lpInBuffer) {
			_mem_save_lpInBuffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpInBuffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpInBuffer));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpInBuffer, &size_lpInBuffer_1));
			NDR_PULL_ALLOC_N(ndr, r->in.lpInBuffer, size_lpInBuffer_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, size_lpInBuffer_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpInBuffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nInBufferSize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nOutBufferSize));
		NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, r->in.nOutBufferSize);
		memset(r->out.lpOutBuffer, 0, (r->in.nOutBufferSize) * sizeof(*r->out.lpOutBuffer));
		NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		NDR_ZERO_STRUCTP(r->out.lpBytesReturned);
		NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		NDR_ZERO_STRUCTP(r->out.lpcbRequired);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpInBuffer, r->in.nInBufferSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.lpOutBuffer, &size_lpOutBuffer_1));
		NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->out.lpOutBuffer, &length_lpOutBuffer_1));
		if (length_lpOutBuffer_1 > size_lpOutBuffer_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpOutBuffer_1, length_lpOutBuffer_1);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, size_lpOutBuffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, length_lpOutBuffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		}
		_mem_save_lpBytesReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpBytesReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpBytesReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpBytesReturned_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		}
		_mem_save_lpcbRequired_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpcbRequired, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpcbRequired));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpcbRequired_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.lpOutBuffer, r->in.nOutBufferSize));
		}
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->out.lpOutBuffer, *r->out.lpBytesReturned));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_NodeResourceControl(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_NodeResourceControl *r)
{
	ndr_print_struct(ndr, name, "clusapi_NodeResourceControl");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_NodeResourceControl");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr_print_policy_handle(ndr, "hNode", &r->in.hNode);
		ndr_print_uint32(ndr, "dwControlCode", r->in.dwControlCode);
		ndr_print_ptr(ndr, "lpInBuffer", r->in.lpInBuffer);
		ndr->depth++;
		if (r->in.lpInBuffer) {
			ndr_print_array_uint8(ndr, "lpInBuffer", r->in.lpInBuffer, r->in.nInBufferSize);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "nInBufferSize", r->in.nInBufferSize);
		ndr_print_uint32(ndr, "nOutBufferSize", r->in.nOutBufferSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_NodeResourceControl");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpOutBuffer", r->out.lpOutBuffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpOutBuffer", r->out.lpOutBuffer, *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpBytesReturned", r->out.lpBytesReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpBytesReturned", *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpcbRequired", r->out.lpcbRequired);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpcbRequired", *r->out.lpcbRequired);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_ResourceControl(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_ResourceControl *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_push_clusapi_ResourceControlCode(ndr, NDR_SCALARS, r->in.dwControlCode));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpInBuffer));
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nInBufferSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, r->in.nInBufferSize));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nInBufferSize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nOutBufferSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpOutBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpBytesReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpcbRequired == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nOutBufferSize));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpcbRequired));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_ResourceControl(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_ResourceControl *r)
{
	uint32_t _ptr_lpInBuffer;
	uint32_t size_lpInBuffer_1 = 0;
	uint32_t size_lpOutBuffer_1 = 0;
	uint32_t length_lpOutBuffer_1 = 0;
	TALLOC_CTX *_mem_save_lpInBuffer_0 = NULL;
	TALLOC_CTX *_mem_save_lpBytesReturned_0 = NULL;
	TALLOC_CTX *_mem_save_lpcbRequired_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_pull_clusapi_ResourceControlCode(ndr, NDR_SCALARS, &r->in.dwControlCode));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpInBuffer));
		if (_ptr_lpInBuffer) {
			NDR_PULL_ALLOC(ndr, r->in.lpInBuffer);
		} else {
			r->in.lpInBuffer = NULL;
		}
		if (r->in.lpInBuffer) {
			_mem_save_lpInBuffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpInBuffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpInBuffer));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpInBuffer, &size_lpInBuffer_1));
			NDR_PULL_ALLOC_N(ndr, r->in.lpInBuffer, size_lpInBuffer_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, size_lpInBuffer_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpInBuffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nInBufferSize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nOutBufferSize));
		NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, r->in.nOutBufferSize);
		memset(r->out.lpOutBuffer, 0, (r->in.nOutBufferSize) * sizeof(*r->out.lpOutBuffer));
		NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		NDR_ZERO_STRUCTP(r->out.lpBytesReturned);
		NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		NDR_ZERO_STRUCTP(r->out.lpcbRequired);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpInBuffer, r->in.nInBufferSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.lpOutBuffer, &size_lpOutBuffer_1));
		NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->out.lpOutBuffer, &length_lpOutBuffer_1));
		if (length_lpOutBuffer_1 > size_lpOutBuffer_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpOutBuffer_1, length_lpOutBuffer_1);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, size_lpOutBuffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, length_lpOutBuffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		}
		_mem_save_lpBytesReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpBytesReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpBytesReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpBytesReturned_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		}
		_mem_save_lpcbRequired_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpcbRequired, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpcbRequired));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpcbRequired_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.lpOutBuffer, r->in.nOutBufferSize));
		}
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->out.lpOutBuffer, *r->out.lpBytesReturned));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_ResourceControl(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_ResourceControl *r)
{
	ndr_print_struct(ndr, name, "clusapi_ResourceControl");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_ResourceControl");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr_print_clusapi_ResourceControlCode(ndr, "dwControlCode", r->in.dwControlCode);
		ndr_print_ptr(ndr, "lpInBuffer", r->in.lpInBuffer);
		ndr->depth++;
		if (r->in.lpInBuffer) {
			ndr_print_array_uint8(ndr, "lpInBuffer", r->in.lpInBuffer, r->in.nInBufferSize);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "nInBufferSize", r->in.nInBufferSize);
		ndr_print_uint32(ndr, "nOutBufferSize", r->in.nOutBufferSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_ResourceControl");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpOutBuffer", r->out.lpOutBuffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpOutBuffer", r->out.lpOutBuffer, *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpBytesReturned", r->out.lpBytesReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpBytesReturned", *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpcbRequired", r->out.lpcbRequired);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpcbRequired", *r->out.lpcbRequired);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_NodeResourceTypeControl(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_NodeResourceTypeControl *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszResourceTypeName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hCluster));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszResourceTypeName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszResourceTypeName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszResourceTypeName, ndr_charset_length(r->in.lpszResourceTypeName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwControlCode));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpInBuffer));
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nInBufferSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, r->in.nInBufferSize));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nInBufferSize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nOutBufferSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpOutBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpBytesReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpcbRequired == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nOutBufferSize));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpcbRequired));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_NodeResourceTypeControl(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_NodeResourceTypeControl *r)
{
	uint32_t size_lpszResourceTypeName_1 = 0;
	uint32_t length_lpszResourceTypeName_1 = 0;
	uint32_t _ptr_lpInBuffer;
	uint32_t size_lpInBuffer_1 = 0;
	uint32_t size_lpOutBuffer_1 = 0;
	uint32_t length_lpOutBuffer_1 = 0;
	TALLOC_CTX *_mem_save_lpInBuffer_0 = NULL;
	TALLOC_CTX *_mem_save_lpBytesReturned_0 = NULL;
	TALLOC_CTX *_mem_save_lpcbRequired_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hCluster));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszResourceTypeName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszResourceTypeName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszResourceTypeName, &size_lpszResourceTypeName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszResourceTypeName, &length_lpszResourceTypeName_1));
		if (length_lpszResourceTypeName_1 > size_lpszResourceTypeName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszResourceTypeName_1, length_lpszResourceTypeName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszResourceTypeName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszResourceTypeName, length_lpszResourceTypeName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwControlCode));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpInBuffer));
		if (_ptr_lpInBuffer) {
			NDR_PULL_ALLOC(ndr, r->in.lpInBuffer);
		} else {
			r->in.lpInBuffer = NULL;
		}
		if (r->in.lpInBuffer) {
			_mem_save_lpInBuffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpInBuffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpInBuffer));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpInBuffer, &size_lpInBuffer_1));
			NDR_PULL_ALLOC_N(ndr, r->in.lpInBuffer, size_lpInBuffer_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, size_lpInBuffer_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpInBuffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nInBufferSize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nOutBufferSize));
		NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, r->in.nOutBufferSize);
		memset(r->out.lpOutBuffer, 0, (r->in.nOutBufferSize) * sizeof(*r->out.lpOutBuffer));
		NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		NDR_ZERO_STRUCTP(r->out.lpBytesReturned);
		NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		NDR_ZERO_STRUCTP(r->out.lpcbRequired);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpInBuffer, r->in.nInBufferSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.lpOutBuffer, &size_lpOutBuffer_1));
		NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->out.lpOutBuffer, &length_lpOutBuffer_1));
		if (length_lpOutBuffer_1 > size_lpOutBuffer_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpOutBuffer_1, length_lpOutBuffer_1);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, size_lpOutBuffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, length_lpOutBuffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		}
		_mem_save_lpBytesReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpBytesReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpBytesReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpBytesReturned_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		}
		_mem_save_lpcbRequired_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpcbRequired, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpcbRequired));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpcbRequired_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.lpOutBuffer, r->in.nOutBufferSize));
		}
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->out.lpOutBuffer, *r->out.lpBytesReturned));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_NodeResourceTypeControl(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_NodeResourceTypeControl *r)
{
	ndr_print_struct(ndr, name, "clusapi_NodeResourceTypeControl");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_NodeResourceTypeControl");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hCluster", &r->in.hCluster);
		ndr_print_ptr(ndr, "lpszResourceTypeName", r->in.lpszResourceTypeName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszResourceTypeName", r->in.lpszResourceTypeName);
		ndr->depth--;
		ndr_print_policy_handle(ndr, "hNode", &r->in.hNode);
		ndr_print_uint32(ndr, "dwControlCode", r->in.dwControlCode);
		ndr_print_ptr(ndr, "lpInBuffer", r->in.lpInBuffer);
		ndr->depth++;
		if (r->in.lpInBuffer) {
			ndr_print_array_uint8(ndr, "lpInBuffer", r->in.lpInBuffer, r->in.nInBufferSize);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "nInBufferSize", r->in.nInBufferSize);
		ndr_print_uint32(ndr, "nOutBufferSize", r->in.nOutBufferSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_NodeResourceTypeControl");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpOutBuffer", r->out.lpOutBuffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpOutBuffer", r->out.lpOutBuffer, *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpBytesReturned", r->out.lpBytesReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpBytesReturned", *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpcbRequired", r->out.lpcbRequired);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpcbRequired", *r->out.lpcbRequired);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_ResourceTypeControl(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_ResourceTypeControl *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszResourceTypeName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hCluster));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszResourceTypeName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszResourceTypeName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszResourceTypeName, ndr_charset_length(r->in.lpszResourceTypeName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_clusapi_ResourceTypeControlCode(ndr, NDR_SCALARS, r->in.dwControlCode));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpInBuffer));
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nInBufferSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, r->in.nInBufferSize));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nInBufferSize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nOutBufferSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpOutBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpBytesReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpcbRequired == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nOutBufferSize));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpcbRequired));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_ResourceTypeControl(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_ResourceTypeControl *r)
{
	uint32_t size_lpszResourceTypeName_1 = 0;
	uint32_t length_lpszResourceTypeName_1 = 0;
	uint32_t _ptr_lpInBuffer;
	uint32_t size_lpInBuffer_1 = 0;
	uint32_t size_lpOutBuffer_1 = 0;
	uint32_t length_lpOutBuffer_1 = 0;
	TALLOC_CTX *_mem_save_lpInBuffer_0 = NULL;
	TALLOC_CTX *_mem_save_lpBytesReturned_0 = NULL;
	TALLOC_CTX *_mem_save_lpcbRequired_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hCluster));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszResourceTypeName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszResourceTypeName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszResourceTypeName, &size_lpszResourceTypeName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszResourceTypeName, &length_lpszResourceTypeName_1));
		if (length_lpszResourceTypeName_1 > size_lpszResourceTypeName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszResourceTypeName_1, length_lpszResourceTypeName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszResourceTypeName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszResourceTypeName, length_lpszResourceTypeName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_clusapi_ResourceTypeControlCode(ndr, NDR_SCALARS, &r->in.dwControlCode));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpInBuffer));
		if (_ptr_lpInBuffer) {
			NDR_PULL_ALLOC(ndr, r->in.lpInBuffer);
		} else {
			r->in.lpInBuffer = NULL;
		}
		if (r->in.lpInBuffer) {
			_mem_save_lpInBuffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpInBuffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpInBuffer));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpInBuffer, &size_lpInBuffer_1));
			NDR_PULL_ALLOC_N(ndr, r->in.lpInBuffer, size_lpInBuffer_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, size_lpInBuffer_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpInBuffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nInBufferSize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nOutBufferSize));
		NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, r->in.nOutBufferSize);
		memset(r->out.lpOutBuffer, 0, (r->in.nOutBufferSize) * sizeof(*r->out.lpOutBuffer));
		NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		NDR_ZERO_STRUCTP(r->out.lpBytesReturned);
		NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		NDR_ZERO_STRUCTP(r->out.lpcbRequired);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpInBuffer, r->in.nInBufferSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.lpOutBuffer, &size_lpOutBuffer_1));
		NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->out.lpOutBuffer, &length_lpOutBuffer_1));
		if (length_lpOutBuffer_1 > size_lpOutBuffer_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpOutBuffer_1, length_lpOutBuffer_1);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, size_lpOutBuffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, length_lpOutBuffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		}
		_mem_save_lpBytesReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpBytesReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpBytesReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpBytesReturned_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		}
		_mem_save_lpcbRequired_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpcbRequired, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpcbRequired));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpcbRequired_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.lpOutBuffer, r->in.nOutBufferSize));
		}
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->out.lpOutBuffer, *r->out.lpBytesReturned));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_ResourceTypeControl(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_ResourceTypeControl *r)
{
	ndr_print_struct(ndr, name, "clusapi_ResourceTypeControl");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_ResourceTypeControl");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hCluster", &r->in.hCluster);
		ndr_print_ptr(ndr, "lpszResourceTypeName", r->in.lpszResourceTypeName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszResourceTypeName", r->in.lpszResourceTypeName);
		ndr->depth--;
		ndr_print_clusapi_ResourceTypeControlCode(ndr, "dwControlCode", r->in.dwControlCode);
		ndr_print_ptr(ndr, "lpInBuffer", r->in.lpInBuffer);
		ndr->depth++;
		if (r->in.lpInBuffer) {
			ndr_print_array_uint8(ndr, "lpInBuffer", r->in.lpInBuffer, r->in.nInBufferSize);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "nInBufferSize", r->in.nInBufferSize);
		ndr_print_uint32(ndr, "nOutBufferSize", r->in.nOutBufferSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_ResourceTypeControl");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpOutBuffer", r->out.lpOutBuffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpOutBuffer", r->out.lpOutBuffer, *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpBytesReturned", r->out.lpBytesReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpBytesReturned", *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpcbRequired", r->out.lpcbRequired);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpcbRequired", *r->out.lpcbRequired);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_NodeGroupControl(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_NodeGroupControl *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwControlCode));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpInBuffer));
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nInBufferSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, r->in.nInBufferSize));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nInBufferSize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nOutBufferSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpOutBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpBytesReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpcbRequired == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nOutBufferSize));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpcbRequired));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_NodeGroupControl(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_NodeGroupControl *r)
{
	uint32_t _ptr_lpInBuffer;
	uint32_t size_lpInBuffer_1 = 0;
	uint32_t size_lpOutBuffer_1 = 0;
	uint32_t length_lpOutBuffer_1 = 0;
	TALLOC_CTX *_mem_save_lpInBuffer_0 = NULL;
	TALLOC_CTX *_mem_save_lpBytesReturned_0 = NULL;
	TALLOC_CTX *_mem_save_lpcbRequired_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwControlCode));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpInBuffer));
		if (_ptr_lpInBuffer) {
			NDR_PULL_ALLOC(ndr, r->in.lpInBuffer);
		} else {
			r->in.lpInBuffer = NULL;
		}
		if (r->in.lpInBuffer) {
			_mem_save_lpInBuffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpInBuffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpInBuffer));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpInBuffer, &size_lpInBuffer_1));
			NDR_PULL_ALLOC_N(ndr, r->in.lpInBuffer, size_lpInBuffer_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, size_lpInBuffer_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpInBuffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nInBufferSize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nOutBufferSize));
		NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, r->in.nOutBufferSize);
		memset(r->out.lpOutBuffer, 0, (r->in.nOutBufferSize) * sizeof(*r->out.lpOutBuffer));
		NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		NDR_ZERO_STRUCTP(r->out.lpBytesReturned);
		NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		NDR_ZERO_STRUCTP(r->out.lpcbRequired);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpInBuffer, r->in.nInBufferSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.lpOutBuffer, &size_lpOutBuffer_1));
		NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->out.lpOutBuffer, &length_lpOutBuffer_1));
		if (length_lpOutBuffer_1 > size_lpOutBuffer_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpOutBuffer_1, length_lpOutBuffer_1);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, size_lpOutBuffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, length_lpOutBuffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		}
		_mem_save_lpBytesReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpBytesReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpBytesReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpBytesReturned_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		}
		_mem_save_lpcbRequired_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpcbRequired, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpcbRequired));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpcbRequired_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.lpOutBuffer, r->in.nOutBufferSize));
		}
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->out.lpOutBuffer, *r->out.lpBytesReturned));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_NodeGroupControl(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_NodeGroupControl *r)
{
	ndr_print_struct(ndr, name, "clusapi_NodeGroupControl");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_NodeGroupControl");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroup", &r->in.hGroup);
		ndr_print_policy_handle(ndr, "hNode", &r->in.hNode);
		ndr_print_uint32(ndr, "dwControlCode", r->in.dwControlCode);
		ndr_print_ptr(ndr, "lpInBuffer", r->in.lpInBuffer);
		ndr->depth++;
		if (r->in.lpInBuffer) {
			ndr_print_array_uint8(ndr, "lpInBuffer", r->in.lpInBuffer, r->in.nInBufferSize);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "nInBufferSize", r->in.nInBufferSize);
		ndr_print_uint32(ndr, "nOutBufferSize", r->in.nOutBufferSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_NodeGroupControl");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpOutBuffer", r->out.lpOutBuffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpOutBuffer", r->out.lpOutBuffer, *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpBytesReturned", r->out.lpBytesReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpBytesReturned", *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpcbRequired", r->out.lpcbRequired);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpcbRequired", *r->out.lpcbRequired);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_GroupControl(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_GroupControl *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_push_clusapi_GroupControlCode(ndr, NDR_SCALARS, r->in.dwControlCode));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpInBuffer));
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nInBufferSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, r->in.nInBufferSize));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nInBufferSize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nOutBufferSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpOutBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpBytesReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpcbRequired == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nOutBufferSize));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpcbRequired));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GroupControl(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_GroupControl *r)
{
	uint32_t _ptr_lpInBuffer;
	uint32_t size_lpInBuffer_1 = 0;
	uint32_t size_lpOutBuffer_1 = 0;
	uint32_t length_lpOutBuffer_1 = 0;
	TALLOC_CTX *_mem_save_lpInBuffer_0 = NULL;
	TALLOC_CTX *_mem_save_lpBytesReturned_0 = NULL;
	TALLOC_CTX *_mem_save_lpcbRequired_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_pull_clusapi_GroupControlCode(ndr, NDR_SCALARS, &r->in.dwControlCode));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpInBuffer));
		if (_ptr_lpInBuffer) {
			NDR_PULL_ALLOC(ndr, r->in.lpInBuffer);
		} else {
			r->in.lpInBuffer = NULL;
		}
		if (r->in.lpInBuffer) {
			_mem_save_lpInBuffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpInBuffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpInBuffer));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpInBuffer, &size_lpInBuffer_1));
			NDR_PULL_ALLOC_N(ndr, r->in.lpInBuffer, size_lpInBuffer_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, size_lpInBuffer_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpInBuffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nInBufferSize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nOutBufferSize));
		NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, r->in.nOutBufferSize);
		memset(r->out.lpOutBuffer, 0, (r->in.nOutBufferSize) * sizeof(*r->out.lpOutBuffer));
		NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		NDR_ZERO_STRUCTP(r->out.lpBytesReturned);
		NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		NDR_ZERO_STRUCTP(r->out.lpcbRequired);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpInBuffer, r->in.nInBufferSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.lpOutBuffer, &size_lpOutBuffer_1));
		NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->out.lpOutBuffer, &length_lpOutBuffer_1));
		if (length_lpOutBuffer_1 > size_lpOutBuffer_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpOutBuffer_1, length_lpOutBuffer_1);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, size_lpOutBuffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, length_lpOutBuffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		}
		_mem_save_lpBytesReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpBytesReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpBytesReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpBytesReturned_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		}
		_mem_save_lpcbRequired_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpcbRequired, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpcbRequired));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpcbRequired_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.lpOutBuffer, r->in.nOutBufferSize));
		}
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->out.lpOutBuffer, *r->out.lpBytesReturned));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GroupControl(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_GroupControl *r)
{
	ndr_print_struct(ndr, name, "clusapi_GroupControl");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_GroupControl");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroup", &r->in.hGroup);
		ndr_print_clusapi_GroupControlCode(ndr, "dwControlCode", r->in.dwControlCode);
		ndr_print_ptr(ndr, "lpInBuffer", r->in.lpInBuffer);
		ndr->depth++;
		if (r->in.lpInBuffer) {
			ndr_print_array_uint8(ndr, "lpInBuffer", r->in.lpInBuffer, r->in.nInBufferSize);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "nInBufferSize", r->in.nInBufferSize);
		ndr_print_uint32(ndr, "nOutBufferSize", r->in.nOutBufferSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_GroupControl");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpOutBuffer", r->out.lpOutBuffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpOutBuffer", r->out.lpOutBuffer, *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpBytesReturned", r->out.lpBytesReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpBytesReturned", *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpcbRequired", r->out.lpcbRequired);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpcbRequired", *r->out.lpcbRequired);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_NodeNodeControl(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_NodeNodeControl *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hHostNode));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwControlCode));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpInBuffer));
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nInBufferSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, r->in.nInBufferSize));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nInBufferSize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nOutBufferSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpOutBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpBytesReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpcbRequired == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nOutBufferSize));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpcbRequired));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_NodeNodeControl(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_NodeNodeControl *r)
{
	uint32_t _ptr_lpInBuffer;
	uint32_t size_lpInBuffer_1 = 0;
	uint32_t size_lpOutBuffer_1 = 0;
	uint32_t length_lpOutBuffer_1 = 0;
	TALLOC_CTX *_mem_save_lpInBuffer_0 = NULL;
	TALLOC_CTX *_mem_save_lpBytesReturned_0 = NULL;
	TALLOC_CTX *_mem_save_lpcbRequired_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hHostNode));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwControlCode));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpInBuffer));
		if (_ptr_lpInBuffer) {
			NDR_PULL_ALLOC(ndr, r->in.lpInBuffer);
		} else {
			r->in.lpInBuffer = NULL;
		}
		if (r->in.lpInBuffer) {
			_mem_save_lpInBuffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpInBuffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpInBuffer));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpInBuffer, &size_lpInBuffer_1));
			NDR_PULL_ALLOC_N(ndr, r->in.lpInBuffer, size_lpInBuffer_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, size_lpInBuffer_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpInBuffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nInBufferSize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nOutBufferSize));
		NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, r->in.nOutBufferSize);
		memset(r->out.lpOutBuffer, 0, (r->in.nOutBufferSize) * sizeof(*r->out.lpOutBuffer));
		NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		NDR_ZERO_STRUCTP(r->out.lpBytesReturned);
		NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		NDR_ZERO_STRUCTP(r->out.lpcbRequired);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpInBuffer, r->in.nInBufferSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.lpOutBuffer, &size_lpOutBuffer_1));
		NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->out.lpOutBuffer, &length_lpOutBuffer_1));
		if (length_lpOutBuffer_1 > size_lpOutBuffer_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpOutBuffer_1, length_lpOutBuffer_1);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, size_lpOutBuffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, length_lpOutBuffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		}
		_mem_save_lpBytesReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpBytesReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpBytesReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpBytesReturned_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		}
		_mem_save_lpcbRequired_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpcbRequired, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpcbRequired));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpcbRequired_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.lpOutBuffer, r->in.nOutBufferSize));
		}
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->out.lpOutBuffer, *r->out.lpBytesReturned));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_NodeNodeControl(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_NodeNodeControl *r)
{
	ndr_print_struct(ndr, name, "clusapi_NodeNodeControl");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_NodeNodeControl");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNode", &r->in.hNode);
		ndr_print_policy_handle(ndr, "hHostNode", &r->in.hHostNode);
		ndr_print_uint32(ndr, "dwControlCode", r->in.dwControlCode);
		ndr_print_ptr(ndr, "lpInBuffer", r->in.lpInBuffer);
		ndr->depth++;
		if (r->in.lpInBuffer) {
			ndr_print_array_uint8(ndr, "lpInBuffer", r->in.lpInBuffer, r->in.nInBufferSize);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "nInBufferSize", r->in.nInBufferSize);
		ndr_print_uint32(ndr, "nOutBufferSize", r->in.nOutBufferSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_NodeNodeControl");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpOutBuffer", r->out.lpOutBuffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpOutBuffer", r->out.lpOutBuffer, *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpBytesReturned", r->out.lpBytesReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpBytesReturned", *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpcbRequired", r->out.lpcbRequired);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpcbRequired", *r->out.lpcbRequired);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_NodeControl(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_NodeControl *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_push_clusapi_NodeControlCode(ndr, NDR_SCALARS, r->in.dwControlCode));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpInBuffer));
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nInBufferSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, r->in.nInBufferSize));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nInBufferSize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nOutBufferSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpOutBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpBytesReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpcbRequired == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nOutBufferSize));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpcbRequired));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_NodeControl(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_NodeControl *r)
{
	uint32_t _ptr_lpInBuffer;
	uint32_t size_lpInBuffer_1 = 0;
	uint32_t size_lpOutBuffer_1 = 0;
	uint32_t length_lpOutBuffer_1 = 0;
	TALLOC_CTX *_mem_save_lpInBuffer_0 = NULL;
	TALLOC_CTX *_mem_save_lpBytesReturned_0 = NULL;
	TALLOC_CTX *_mem_save_lpcbRequired_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_pull_clusapi_NodeControlCode(ndr, NDR_SCALARS, &r->in.dwControlCode));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpInBuffer));
		if (_ptr_lpInBuffer) {
			NDR_PULL_ALLOC(ndr, r->in.lpInBuffer);
		} else {
			r->in.lpInBuffer = NULL;
		}
		if (r->in.lpInBuffer) {
			_mem_save_lpInBuffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpInBuffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpInBuffer));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpInBuffer, &size_lpInBuffer_1));
			NDR_PULL_ALLOC_N(ndr, r->in.lpInBuffer, size_lpInBuffer_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, size_lpInBuffer_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpInBuffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nInBufferSize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nOutBufferSize));
		NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, r->in.nOutBufferSize);
		memset(r->out.lpOutBuffer, 0, (r->in.nOutBufferSize) * sizeof(*r->out.lpOutBuffer));
		NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		NDR_ZERO_STRUCTP(r->out.lpBytesReturned);
		NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		NDR_ZERO_STRUCTP(r->out.lpcbRequired);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpInBuffer, r->in.nInBufferSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.lpOutBuffer, &size_lpOutBuffer_1));
		NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->out.lpOutBuffer, &length_lpOutBuffer_1));
		if (length_lpOutBuffer_1 > size_lpOutBuffer_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpOutBuffer_1, length_lpOutBuffer_1);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, size_lpOutBuffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, length_lpOutBuffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		}
		_mem_save_lpBytesReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpBytesReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpBytesReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpBytesReturned_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		}
		_mem_save_lpcbRequired_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpcbRequired, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpcbRequired));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpcbRequired_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.lpOutBuffer, r->in.nOutBufferSize));
		}
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->out.lpOutBuffer, *r->out.lpBytesReturned));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_NodeControl(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_NodeControl *r)
{
	ndr_print_struct(ndr, name, "clusapi_NodeControl");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_NodeControl");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNode", &r->in.hNode);
		ndr_print_clusapi_NodeControlCode(ndr, "dwControlCode", r->in.dwControlCode);
		ndr_print_ptr(ndr, "lpInBuffer", r->in.lpInBuffer);
		ndr->depth++;
		if (r->in.lpInBuffer) {
			ndr_print_array_uint8(ndr, "lpInBuffer", r->in.lpInBuffer, r->in.nInBufferSize);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "nInBufferSize", r->in.nInBufferSize);
		ndr_print_uint32(ndr, "nOutBufferSize", r->in.nOutBufferSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_NodeControl");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpOutBuffer", r->out.lpOutBuffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpOutBuffer", r->out.lpOutBuffer, *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpBytesReturned", r->out.lpBytesReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpBytesReturned", *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpcbRequired", r->out.lpcbRequired);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpcbRequired", *r->out.lpcbRequired);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Opnum80NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct Opnum80NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Opnum80NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct Opnum80NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Opnum80NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct Opnum80NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "Opnum80NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Opnum80NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Opnum80NotUsedOnWire");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_OpenNetwork(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_OpenNetwork *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszNetworkName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszNetworkName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszNetworkName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszNetworkName, ndr_charset_length(r->in.lpszNetworkName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.Status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.hNetwork == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.Status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.hNetwork));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_OpenNetwork(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_OpenNetwork *r)
{
	uint32_t size_lpszNetworkName_1 = 0;
	uint32_t length_lpszNetworkName_1 = 0;
	TALLOC_CTX *_mem_save_Status_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	TALLOC_CTX *_mem_save_hNetwork_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszNetworkName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszNetworkName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszNetworkName, &size_lpszNetworkName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszNetworkName, &length_lpszNetworkName_1));
		if (length_lpszNetworkName_1 > size_lpszNetworkName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszNetworkName_1, length_lpszNetworkName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszNetworkName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszNetworkName, length_lpszNetworkName_1, sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.Status);
		NDR_ZERO_STRUCTP(r->out.Status);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		NDR_PULL_ALLOC(ndr, r->out.hNetwork);
		NDR_ZERO_STRUCTP(r->out.hNetwork);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Status);
		}
		_mem_save_Status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.Status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.hNetwork);
		}
		_mem_save_hNetwork_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.hNetwork, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.hNetwork));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hNetwork_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_OpenNetwork(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_OpenNetwork *r)
{
	ndr_print_struct(ndr, name, "clusapi_OpenNetwork");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_OpenNetwork");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszNetworkName", r->in.lpszNetworkName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszNetworkName", r->in.lpszNetworkName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_OpenNetwork");
		ndr->depth++;
		ndr_print_ptr(ndr, "Status", r->out.Status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "Status", *r->out.Status);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_ptr(ndr, "hNetwork", r->out.hNetwork);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNetwork", r->out.hNetwork);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CloseNetwork(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CloseNetwork *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.Network == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.Network));
	}
	if (flags & NDR_OUT) {
		if (r->out.Network == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.Network));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CloseNetwork(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CloseNetwork *r)
{
	TALLOC_CTX *_mem_save_Network_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.Network);
		}
		_mem_save_Network_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.Network, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.Network));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Network_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.Network);
		*r->out.Network = *r->in.Network;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.Network == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.Network);
			NDR_ZERO_STRUCTP(r->in.Network);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Network);
		}
		_mem_save_Network_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Network, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.Network));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Network_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CloseNetwork(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CloseNetwork *r)
{
	ndr_print_struct(ndr, name, "clusapi_CloseNetwork");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CloseNetwork");
		ndr->depth++;
		ndr_print_ptr(ndr, "Network", r->in.Network);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "Network", r->in.Network);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CloseNetwork");
		ndr->depth++;
		ndr_print_ptr(ndr, "Network", r->out.Network);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "Network", r->out.Network);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_GetNetworkState(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_GetNetworkState *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNetwork));
	}
	if (flags & NDR_OUT) {
		if (r->out.State == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_clusapi_ClusterNetworkState(ndr, NDR_SCALARS, *r->out.State));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GetNetworkState(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_GetNetworkState *r)
{
	TALLOC_CTX *_mem_save_State_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNetwork));
		NDR_PULL_ALLOC(ndr, r->out.State);
		NDR_ZERO_STRUCTP(r->out.State);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.State);
		}
		_mem_save_State_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.State, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_clusapi_ClusterNetworkState(ndr, NDR_SCALARS, r->out.State));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_State_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GetNetworkState(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_GetNetworkState *r)
{
	ndr_print_struct(ndr, name, "clusapi_GetNetworkState");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_GetNetworkState");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNetwork", &r->in.hNetwork);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_GetNetworkState");
		ndr->depth++;
		ndr_print_ptr(ndr, "State", r->out.State);
		ndr->depth++;
		ndr_print_clusapi_ClusterNetworkState(ndr, "State", *r->out.State);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_SetNetworkName(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_SetNetworkName *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszNetworkName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNetwork));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszNetworkName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszNetworkName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszNetworkName, ndr_charset_length(r->in.lpszNetworkName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_SetNetworkName(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_SetNetworkName *r)
{
	uint32_t size_lpszNetworkName_1 = 0;
	uint32_t length_lpszNetworkName_1 = 0;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNetwork));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszNetworkName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszNetworkName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszNetworkName, &size_lpszNetworkName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszNetworkName, &length_lpszNetworkName_1));
		if (length_lpszNetworkName_1 > size_lpszNetworkName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszNetworkName_1, length_lpszNetworkName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszNetworkName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszNetworkName, length_lpszNetworkName_1, sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_SetNetworkName(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_SetNetworkName *r)
{
	ndr_print_struct(ndr, name, "clusapi_SetNetworkName");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_SetNetworkName");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNetwork", &r->in.hNetwork);
		ndr_print_ptr(ndr, "lpszNetworkName", r->in.lpszNetworkName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszNetworkName", r->in.lpszNetworkName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_SetNetworkName");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CreateNetworkEnum(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CreateNetworkEnum *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNetwork));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwType));
	}
	if (flags & NDR_OUT) {
		if (r->out.ReturnEnum == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ReturnEnum));
		if (*r->out.ReturnEnum) {
			NDR_CHECK(ndr_push_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ReturnEnum));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CreateNetworkEnum(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CreateNetworkEnum *r)
{
	uint32_t _ptr_ReturnEnum;
	TALLOC_CTX *_mem_save_ReturnEnum_0 = NULL;
	TALLOC_CTX *_mem_save_ReturnEnum_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNetwork));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwType));
		NDR_PULL_ALLOC(ndr, r->out.ReturnEnum);
		NDR_ZERO_STRUCTP(r->out.ReturnEnum);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ReturnEnum);
		}
		_mem_save_ReturnEnum_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ReturnEnum, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ReturnEnum));
		if (_ptr_ReturnEnum) {
			NDR_PULL_ALLOC(ndr, *r->out.ReturnEnum);
		} else {
			*r->out.ReturnEnum = NULL;
		}
		if (*r->out.ReturnEnum) {
			_mem_save_ReturnEnum_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ReturnEnum, 0);
			NDR_CHECK(ndr_pull_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ReturnEnum));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReturnEnum_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReturnEnum_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CreateNetworkEnum(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CreateNetworkEnum *r)
{
	ndr_print_struct(ndr, name, "clusapi_CreateNetworkEnum");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CreateNetworkEnum");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNetwork", &r->in.hNetwork);
		ndr_print_uint32(ndr, "dwType", r->in.dwType);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CreateNetworkEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "ReturnEnum", r->out.ReturnEnum);
		ndr->depth++;
		ndr_print_ptr(ndr, "ReturnEnum", *r->out.ReturnEnum);
		ndr->depth++;
		if (*r->out.ReturnEnum) {
			ndr_print_ENUM_LIST(ndr, "ReturnEnum", *r->out.ReturnEnum);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_GetNetworkId(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_GetNetworkId *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNetwork));
	}
	if (flags & NDR_OUT) {
		if (r->out.pGuid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.pGuid));
		if (*r->out.pGuid) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.pGuid, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.pGuid, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.pGuid, ndr_charset_length(*r->out.pGuid, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GetNetworkId(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_GetNetworkId *r)
{
	uint32_t _ptr_pGuid;
	uint32_t size_pGuid_2 = 0;
	uint32_t length_pGuid_2 = 0;
	TALLOC_CTX *_mem_save_pGuid_0 = NULL;
	TALLOC_CTX *_mem_save_pGuid_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNetwork));
		NDR_PULL_ALLOC(ndr, r->out.pGuid);
		NDR_ZERO_STRUCTP(r->out.pGuid);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pGuid);
		}
		_mem_save_pGuid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pGuid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pGuid));
		if (_ptr_pGuid) {
			NDR_PULL_ALLOC(ndr, *r->out.pGuid);
		} else {
			*r->out.pGuid = NULL;
		}
		if (*r->out.pGuid) {
			_mem_save_pGuid_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.pGuid, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.pGuid));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.pGuid));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.pGuid, &size_pGuid_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.pGuid, &length_pGuid_2));
			if (length_pGuid_2 > size_pGuid_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pGuid_2, length_pGuid_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pGuid_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.pGuid, length_pGuid_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pGuid_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pGuid_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GetNetworkId(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_GetNetworkId *r)
{
	ndr_print_struct(ndr, name, "clusapi_GetNetworkId");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_GetNetworkId");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNetwork", &r->in.hNetwork);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_GetNetworkId");
		ndr->depth++;
		ndr_print_ptr(ndr, "pGuid", r->out.pGuid);
		ndr->depth++;
		ndr_print_ptr(ndr, "pGuid", *r->out.pGuid);
		ndr->depth++;
		if (*r->out.pGuid) {
			ndr_print_string(ndr, "pGuid", *r->out.pGuid);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_SetNetworkPriorityOrder(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_SetNetworkPriorityOrder *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.NetworkCount));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.NetworkCount));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.NetworkIdList, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.NetworkIdList, ndr_charset_length(r->in.NetworkIdList, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_SetNetworkPriorityOrder(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_SetNetworkPriorityOrder *r)
{
	uint32_t size_NetworkIdList_0 = 0;
	uint32_t length_NetworkIdList_0 = 0;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.NetworkCount));
		if (r->in.NetworkCount > 1000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.NetworkCount), (uint32_t)(0), (uint32_t)(1000));
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.NetworkIdList));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.NetworkIdList));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.NetworkIdList, &size_NetworkIdList_0));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.NetworkIdList, &length_NetworkIdList_0));
		if (length_NetworkIdList_0 > size_NetworkIdList_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_NetworkIdList_0, length_NetworkIdList_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_NetworkIdList_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.NetworkIdList, length_NetworkIdList_0, sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.NetworkIdList) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.NetworkIdList, r->in.NetworkCount));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_SetNetworkPriorityOrder(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_SetNetworkPriorityOrder *r)
{
	ndr_print_struct(ndr, name, "clusapi_SetNetworkPriorityOrder");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_SetNetworkPriorityOrder");
		ndr->depth++;
		ndr_print_uint32(ndr, "NetworkCount", r->in.NetworkCount);
		ndr_print_string(ndr, "NetworkIdList", r->in.NetworkIdList);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_SetNetworkPriorityOrder");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_NodeNetworkControl(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_NodeNetworkControl *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNetwork));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwControlCode));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpInBuffer));
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nInBufferSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, r->in.nInBufferSize));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nInBufferSize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nOutBufferSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpOutBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpBytesReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpcbRequired == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nOutBufferSize));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpcbRequired));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_NodeNetworkControl(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_NodeNetworkControl *r)
{
	uint32_t _ptr_lpInBuffer;
	uint32_t size_lpInBuffer_1 = 0;
	uint32_t size_lpOutBuffer_1 = 0;
	uint32_t length_lpOutBuffer_1 = 0;
	TALLOC_CTX *_mem_save_lpInBuffer_0 = NULL;
	TALLOC_CTX *_mem_save_lpBytesReturned_0 = NULL;
	TALLOC_CTX *_mem_save_lpcbRequired_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNetwork));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwControlCode));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpInBuffer));
		if (_ptr_lpInBuffer) {
			NDR_PULL_ALLOC(ndr, r->in.lpInBuffer);
		} else {
			r->in.lpInBuffer = NULL;
		}
		if (r->in.lpInBuffer) {
			_mem_save_lpInBuffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpInBuffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpInBuffer));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpInBuffer, &size_lpInBuffer_1));
			NDR_PULL_ALLOC_N(ndr, r->in.lpInBuffer, size_lpInBuffer_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, size_lpInBuffer_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpInBuffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nInBufferSize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nOutBufferSize));
		NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, r->in.nOutBufferSize);
		memset(r->out.lpOutBuffer, 0, (r->in.nOutBufferSize) * sizeof(*r->out.lpOutBuffer));
		NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		NDR_ZERO_STRUCTP(r->out.lpBytesReturned);
		NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		NDR_ZERO_STRUCTP(r->out.lpcbRequired);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpInBuffer, r->in.nInBufferSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.lpOutBuffer, &size_lpOutBuffer_1));
		NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->out.lpOutBuffer, &length_lpOutBuffer_1));
		if (length_lpOutBuffer_1 > size_lpOutBuffer_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpOutBuffer_1, length_lpOutBuffer_1);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, size_lpOutBuffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, length_lpOutBuffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		}
		_mem_save_lpBytesReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpBytesReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpBytesReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpBytesReturned_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		}
		_mem_save_lpcbRequired_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpcbRequired, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpcbRequired));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpcbRequired_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.lpOutBuffer, r->in.nOutBufferSize));
		}
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->out.lpOutBuffer, *r->out.lpBytesReturned));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_NodeNetworkControl(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_NodeNetworkControl *r)
{
	ndr_print_struct(ndr, name, "clusapi_NodeNetworkControl");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_NodeNetworkControl");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNetwork", &r->in.hNetwork);
		ndr_print_policy_handle(ndr, "hNode", &r->in.hNode);
		ndr_print_uint32(ndr, "dwControlCode", r->in.dwControlCode);
		ndr_print_ptr(ndr, "lpInBuffer", r->in.lpInBuffer);
		ndr->depth++;
		if (r->in.lpInBuffer) {
			ndr_print_array_uint8(ndr, "lpInBuffer", r->in.lpInBuffer, r->in.nInBufferSize);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "nInBufferSize", r->in.nInBufferSize);
		ndr_print_uint32(ndr, "nOutBufferSize", r->in.nOutBufferSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_NodeNetworkControl");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpOutBuffer", r->out.lpOutBuffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpOutBuffer", r->out.lpOutBuffer, *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpBytesReturned", r->out.lpBytesReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpBytesReturned", *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpcbRequired", r->out.lpcbRequired);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpcbRequired", *r->out.lpcbRequired);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_NetworkControl(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_NetworkControl *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNetwork));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwControlCode));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpInBuffer));
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nInBufferSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, r->in.nInBufferSize));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nInBufferSize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nOutBufferSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpOutBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpBytesReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpcbRequired == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nOutBufferSize));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpcbRequired));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_NetworkControl(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_NetworkControl *r)
{
	uint32_t _ptr_lpInBuffer;
	uint32_t size_lpInBuffer_1 = 0;
	uint32_t size_lpOutBuffer_1 = 0;
	uint32_t length_lpOutBuffer_1 = 0;
	TALLOC_CTX *_mem_save_lpInBuffer_0 = NULL;
	TALLOC_CTX *_mem_save_lpBytesReturned_0 = NULL;
	TALLOC_CTX *_mem_save_lpcbRequired_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNetwork));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwControlCode));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpInBuffer));
		if (_ptr_lpInBuffer) {
			NDR_PULL_ALLOC(ndr, r->in.lpInBuffer);
		} else {
			r->in.lpInBuffer = NULL;
		}
		if (r->in.lpInBuffer) {
			_mem_save_lpInBuffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpInBuffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpInBuffer));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpInBuffer, &size_lpInBuffer_1));
			NDR_PULL_ALLOC_N(ndr, r->in.lpInBuffer, size_lpInBuffer_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, size_lpInBuffer_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpInBuffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nInBufferSize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nOutBufferSize));
		NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, r->in.nOutBufferSize);
		memset(r->out.lpOutBuffer, 0, (r->in.nOutBufferSize) * sizeof(*r->out.lpOutBuffer));
		NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		NDR_ZERO_STRUCTP(r->out.lpBytesReturned);
		NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		NDR_ZERO_STRUCTP(r->out.lpcbRequired);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpInBuffer, r->in.nInBufferSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.lpOutBuffer, &size_lpOutBuffer_1));
		NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->out.lpOutBuffer, &length_lpOutBuffer_1));
		if (length_lpOutBuffer_1 > size_lpOutBuffer_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpOutBuffer_1, length_lpOutBuffer_1);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, size_lpOutBuffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, length_lpOutBuffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		}
		_mem_save_lpBytesReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpBytesReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpBytesReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpBytesReturned_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		}
		_mem_save_lpcbRequired_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpcbRequired, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpcbRequired));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpcbRequired_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.lpOutBuffer, r->in.nOutBufferSize));
		}
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->out.lpOutBuffer, *r->out.lpBytesReturned));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_NetworkControl(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_NetworkControl *r)
{
	ndr_print_struct(ndr, name, "clusapi_NetworkControl");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_NetworkControl");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNetwork", &r->in.hNetwork);
		ndr_print_uint32(ndr, "dwControlCode", r->in.dwControlCode);
		ndr_print_ptr(ndr, "lpInBuffer", r->in.lpInBuffer);
		ndr->depth++;
		if (r->in.lpInBuffer) {
			ndr_print_array_uint8(ndr, "lpInBuffer", r->in.lpInBuffer, r->in.nInBufferSize);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "nInBufferSize", r->in.nInBufferSize);
		ndr_print_uint32(ndr, "nOutBufferSize", r->in.nOutBufferSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_NetworkControl");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpOutBuffer", r->out.lpOutBuffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpOutBuffer", r->out.lpOutBuffer, *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpBytesReturned", r->out.lpBytesReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpBytesReturned", *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpcbRequired", r->out.lpcbRequired);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpcbRequired", *r->out.lpcbRequired);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_AddNotifyNetwork(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_AddNotifyNetwork *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNetwork));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwFilter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwNotifyKey));
	}
	if (flags & NDR_OUT) {
		if (r->out.dwStateSequence == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.dwStateSequence));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_AddNotifyNetwork(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_AddNotifyNetwork *r)
{
	TALLOC_CTX *_mem_save_dwStateSequence_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNetwork));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwFilter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwNotifyKey));
		NDR_PULL_ALLOC(ndr, r->out.dwStateSequence);
		NDR_ZERO_STRUCTP(r->out.dwStateSequence);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.dwStateSequence);
		}
		_mem_save_dwStateSequence_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.dwStateSequence, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.dwStateSequence));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dwStateSequence_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_AddNotifyNetwork(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_AddNotifyNetwork *r)
{
	ndr_print_struct(ndr, name, "clusapi_AddNotifyNetwork");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_AddNotifyNetwork");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNotify", &r->in.hNotify);
		ndr_print_policy_handle(ndr, "hNetwork", &r->in.hNetwork);
		ndr_print_uint32(ndr, "dwFilter", r->in.dwFilter);
		ndr_print_uint32(ndr, "dwNotifyKey", r->in.dwNotifyKey);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_AddNotifyNetwork");
		ndr->depth++;
		ndr_print_ptr(ndr, "dwStateSequence", r->out.dwStateSequence);
		ndr->depth++;
		ndr_print_uint32(ndr, "dwStateSequence", *r->out.dwStateSequence);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_ReAddNotifyNetwork(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_ReAddNotifyNetwork *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNetwork));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwFilter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwNotifyKey));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.StateSequence));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_ReAddNotifyNetwork(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_ReAddNotifyNetwork *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNetwork));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwFilter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwNotifyKey));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.StateSequence));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_ReAddNotifyNetwork(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_ReAddNotifyNetwork *r)
{
	ndr_print_struct(ndr, name, "clusapi_ReAddNotifyNetwork");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_ReAddNotifyNetwork");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNotify", &r->in.hNotify);
		ndr_print_policy_handle(ndr, "hNetwork", &r->in.hNetwork);
		ndr_print_uint32(ndr, "dwFilter", r->in.dwFilter);
		ndr_print_uint32(ndr, "dwNotifyKey", r->in.dwNotifyKey);
		ndr_print_uint32(ndr, "StateSequence", r->in.StateSequence);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_ReAddNotifyNetwork");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_OpenNetInterface(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_OpenNetInterface *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszNetInterfaceName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszNetInterfaceName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszNetInterfaceName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszNetInterfaceName, ndr_charset_length(r->in.lpszNetInterfaceName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.Status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.hNetInterface == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.Status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.hNetInterface));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_OpenNetInterface(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_OpenNetInterface *r)
{
	uint32_t size_lpszNetInterfaceName_1 = 0;
	uint32_t length_lpszNetInterfaceName_1 = 0;
	TALLOC_CTX *_mem_save_Status_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	TALLOC_CTX *_mem_save_hNetInterface_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszNetInterfaceName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszNetInterfaceName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszNetInterfaceName, &size_lpszNetInterfaceName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszNetInterfaceName, &length_lpszNetInterfaceName_1));
		if (length_lpszNetInterfaceName_1 > size_lpszNetInterfaceName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszNetInterfaceName_1, length_lpszNetInterfaceName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszNetInterfaceName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszNetInterfaceName, length_lpszNetInterfaceName_1, sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.Status);
		NDR_ZERO_STRUCTP(r->out.Status);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		NDR_PULL_ALLOC(ndr, r->out.hNetInterface);
		NDR_ZERO_STRUCTP(r->out.hNetInterface);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Status);
		}
		_mem_save_Status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.Status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.hNetInterface);
		}
		_mem_save_hNetInterface_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.hNetInterface, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.hNetInterface));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hNetInterface_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_OpenNetInterface(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_OpenNetInterface *r)
{
	ndr_print_struct(ndr, name, "clusapi_OpenNetInterface");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_OpenNetInterface");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszNetInterfaceName", r->in.lpszNetInterfaceName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszNetInterfaceName", r->in.lpszNetInterfaceName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_OpenNetInterface");
		ndr->depth++;
		ndr_print_ptr(ndr, "Status", r->out.Status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "Status", *r->out.Status);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_ptr(ndr, "hNetInterface", r->out.hNetInterface);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNetInterface", r->out.hNetInterface);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CloseNetInterface(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CloseNetInterface *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.NetInterface == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.NetInterface));
	}
	if (flags & NDR_OUT) {
		if (r->out.NetInterface == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.NetInterface));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CloseNetInterface(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CloseNetInterface *r)
{
	TALLOC_CTX *_mem_save_NetInterface_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.NetInterface);
		}
		_mem_save_NetInterface_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.NetInterface, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.NetInterface));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_NetInterface_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.NetInterface);
		*r->out.NetInterface = *r->in.NetInterface;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.NetInterface == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.NetInterface);
			NDR_ZERO_STRUCTP(r->in.NetInterface);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.NetInterface);
		}
		_mem_save_NetInterface_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.NetInterface, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.NetInterface));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_NetInterface_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CloseNetInterface(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CloseNetInterface *r)
{
	ndr_print_struct(ndr, name, "clusapi_CloseNetInterface");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CloseNetInterface");
		ndr->depth++;
		ndr_print_ptr(ndr, "NetInterface", r->in.NetInterface);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "NetInterface", r->in.NetInterface);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CloseNetInterface");
		ndr->depth++;
		ndr_print_ptr(ndr, "NetInterface", r->out.NetInterface);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "NetInterface", r->out.NetInterface);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_GetNetInterfaceState(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_GetNetInterfaceState *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNetInterface));
	}
	if (flags & NDR_OUT) {
		if (r->out.State == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_clusapi_ClusterNetInterfaceState(ndr, NDR_SCALARS, *r->out.State));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GetNetInterfaceState(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_GetNetInterfaceState *r)
{
	TALLOC_CTX *_mem_save_State_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNetInterface));
		NDR_PULL_ALLOC(ndr, r->out.State);
		NDR_ZERO_STRUCTP(r->out.State);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.State);
		}
		_mem_save_State_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.State, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_clusapi_ClusterNetInterfaceState(ndr, NDR_SCALARS, r->out.State));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_State_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GetNetInterfaceState(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_GetNetInterfaceState *r)
{
	ndr_print_struct(ndr, name, "clusapi_GetNetInterfaceState");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_GetNetInterfaceState");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNetInterface", &r->in.hNetInterface);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_GetNetInterfaceState");
		ndr->depth++;
		ndr_print_ptr(ndr, "State", r->out.State);
		ndr->depth++;
		ndr_print_clusapi_ClusterNetInterfaceState(ndr, "State", *r->out.State);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_GetNetInterface(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_GetNetInterface *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszNodeName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.lpszNetworkName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszNodeName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszNodeName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszNodeName, ndr_charset_length(r->in.lpszNodeName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszNetworkName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszNetworkName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszNetworkName, ndr_charset_length(r->in.lpszNetworkName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.lppszInterfaceName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.lppszInterfaceName));
		if (*r->out.lppszInterfaceName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.lppszInterfaceName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.lppszInterfaceName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.lppszInterfaceName, ndr_charset_length(*r->out.lppszInterfaceName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GetNetInterface(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_GetNetInterface *r)
{
	uint32_t size_lpszNodeName_1 = 0;
	uint32_t length_lpszNodeName_1 = 0;
	uint32_t size_lpszNetworkName_1 = 0;
	uint32_t length_lpszNetworkName_1 = 0;
	uint32_t _ptr_lppszInterfaceName;
	uint32_t size_lppszInterfaceName_2 = 0;
	uint32_t length_lppszInterfaceName_2 = 0;
	TALLOC_CTX *_mem_save_lppszInterfaceName_0 = NULL;
	TALLOC_CTX *_mem_save_lppszInterfaceName_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszNodeName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszNodeName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszNodeName, &size_lpszNodeName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszNodeName, &length_lpszNodeName_1));
		if (length_lpszNodeName_1 > size_lpszNodeName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszNodeName_1, length_lpszNodeName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszNodeName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszNodeName, length_lpszNodeName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszNetworkName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszNetworkName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszNetworkName, &size_lpszNetworkName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszNetworkName, &length_lpszNetworkName_1));
		if (length_lpszNetworkName_1 > size_lpszNetworkName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszNetworkName_1, length_lpszNetworkName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszNetworkName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszNetworkName, length_lpszNetworkName_1, sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.lppszInterfaceName);
		NDR_ZERO_STRUCTP(r->out.lppszInterfaceName);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lppszInterfaceName);
		}
		_mem_save_lppszInterfaceName_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lppszInterfaceName, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lppszInterfaceName));
		if (_ptr_lppszInterfaceName) {
			NDR_PULL_ALLOC(ndr, *r->out.lppszInterfaceName);
		} else {
			*r->out.lppszInterfaceName = NULL;
		}
		if (*r->out.lppszInterfaceName) {
			_mem_save_lppszInterfaceName_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.lppszInterfaceName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.lppszInterfaceName));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.lppszInterfaceName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.lppszInterfaceName, &size_lppszInterfaceName_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.lppszInterfaceName, &length_lppszInterfaceName_2));
			if (length_lppszInterfaceName_2 > size_lppszInterfaceName_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lppszInterfaceName_2, length_lppszInterfaceName_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lppszInterfaceName_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.lppszInterfaceName, length_lppszInterfaceName_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lppszInterfaceName_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lppszInterfaceName_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GetNetInterface(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_GetNetInterface *r)
{
	ndr_print_struct(ndr, name, "clusapi_GetNetInterface");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_GetNetInterface");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszNodeName", r->in.lpszNodeName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszNodeName", r->in.lpszNodeName);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpszNetworkName", r->in.lpszNetworkName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszNetworkName", r->in.lpszNetworkName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_GetNetInterface");
		ndr->depth++;
		ndr_print_ptr(ndr, "lppszInterfaceName", r->out.lppszInterfaceName);
		ndr->depth++;
		ndr_print_ptr(ndr, "lppszInterfaceName", *r->out.lppszInterfaceName);
		ndr->depth++;
		if (*r->out.lppszInterfaceName) {
			ndr_print_string(ndr, "lppszInterfaceName", *r->out.lppszInterfaceName);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_GetNetInterfaceId(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_GetNetInterfaceId *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNetInterface));
	}
	if (flags & NDR_OUT) {
		if (r->out.pGuid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.pGuid));
		if (*r->out.pGuid) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.pGuid, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.pGuid, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.pGuid, ndr_charset_length(*r->out.pGuid, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GetNetInterfaceId(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_GetNetInterfaceId *r)
{
	uint32_t _ptr_pGuid;
	uint32_t size_pGuid_2 = 0;
	uint32_t length_pGuid_2 = 0;
	TALLOC_CTX *_mem_save_pGuid_0 = NULL;
	TALLOC_CTX *_mem_save_pGuid_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNetInterface));
		NDR_PULL_ALLOC(ndr, r->out.pGuid);
		NDR_ZERO_STRUCTP(r->out.pGuid);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pGuid);
		}
		_mem_save_pGuid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pGuid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pGuid));
		if (_ptr_pGuid) {
			NDR_PULL_ALLOC(ndr, *r->out.pGuid);
		} else {
			*r->out.pGuid = NULL;
		}
		if (*r->out.pGuid) {
			_mem_save_pGuid_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.pGuid, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.pGuid));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.pGuid));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.pGuid, &size_pGuid_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.pGuid, &length_pGuid_2));
			if (length_pGuid_2 > size_pGuid_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pGuid_2, length_pGuid_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pGuid_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.pGuid, length_pGuid_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pGuid_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pGuid_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GetNetInterfaceId(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_GetNetInterfaceId *r)
{
	ndr_print_struct(ndr, name, "clusapi_GetNetInterfaceId");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_GetNetInterfaceId");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNetInterface", &r->in.hNetInterface);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_GetNetInterfaceId");
		ndr->depth++;
		ndr_print_ptr(ndr, "pGuid", r->out.pGuid);
		ndr->depth++;
		ndr_print_ptr(ndr, "pGuid", *r->out.pGuid);
		ndr->depth++;
		if (*r->out.pGuid) {
			ndr_print_string(ndr, "pGuid", *r->out.pGuid);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_NodeNetInterfaceControl(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_NodeNetInterfaceControl *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNetInterface));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwControlCode));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpInBuffer));
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nInBufferSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, r->in.nInBufferSize));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nInBufferSize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nOutBufferSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpOutBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpBytesReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpcbRequired == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nOutBufferSize));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpcbRequired));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_NodeNetInterfaceControl(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_NodeNetInterfaceControl *r)
{
	uint32_t _ptr_lpInBuffer;
	uint32_t size_lpInBuffer_1 = 0;
	uint32_t size_lpOutBuffer_1 = 0;
	uint32_t length_lpOutBuffer_1 = 0;
	TALLOC_CTX *_mem_save_lpInBuffer_0 = NULL;
	TALLOC_CTX *_mem_save_lpBytesReturned_0 = NULL;
	TALLOC_CTX *_mem_save_lpcbRequired_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNetInterface));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwControlCode));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpInBuffer));
		if (_ptr_lpInBuffer) {
			NDR_PULL_ALLOC(ndr, r->in.lpInBuffer);
		} else {
			r->in.lpInBuffer = NULL;
		}
		if (r->in.lpInBuffer) {
			_mem_save_lpInBuffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpInBuffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpInBuffer));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpInBuffer, &size_lpInBuffer_1));
			NDR_PULL_ALLOC_N(ndr, r->in.lpInBuffer, size_lpInBuffer_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, size_lpInBuffer_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpInBuffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nInBufferSize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nOutBufferSize));
		NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, r->in.nOutBufferSize);
		memset(r->out.lpOutBuffer, 0, (r->in.nOutBufferSize) * sizeof(*r->out.lpOutBuffer));
		NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		NDR_ZERO_STRUCTP(r->out.lpBytesReturned);
		NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		NDR_ZERO_STRUCTP(r->out.lpcbRequired);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpInBuffer, r->in.nInBufferSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.lpOutBuffer, &size_lpOutBuffer_1));
		NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->out.lpOutBuffer, &length_lpOutBuffer_1));
		if (length_lpOutBuffer_1 > size_lpOutBuffer_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpOutBuffer_1, length_lpOutBuffer_1);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, size_lpOutBuffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, length_lpOutBuffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		}
		_mem_save_lpBytesReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpBytesReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpBytesReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpBytesReturned_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		}
		_mem_save_lpcbRequired_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpcbRequired, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpcbRequired));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpcbRequired_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.lpOutBuffer, r->in.nOutBufferSize));
		}
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->out.lpOutBuffer, *r->out.lpBytesReturned));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_NodeNetInterfaceControl(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_NodeNetInterfaceControl *r)
{
	ndr_print_struct(ndr, name, "clusapi_NodeNetInterfaceControl");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_NodeNetInterfaceControl");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNetInterface", &r->in.hNetInterface);
		ndr_print_policy_handle(ndr, "hNode", &r->in.hNode);
		ndr_print_uint32(ndr, "dwControlCode", r->in.dwControlCode);
		ndr_print_ptr(ndr, "lpInBuffer", r->in.lpInBuffer);
		ndr->depth++;
		if (r->in.lpInBuffer) {
			ndr_print_array_uint8(ndr, "lpInBuffer", r->in.lpInBuffer, r->in.nInBufferSize);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "nInBufferSize", r->in.nInBufferSize);
		ndr_print_uint32(ndr, "nOutBufferSize", r->in.nOutBufferSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_NodeNetInterfaceControl");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpOutBuffer", r->out.lpOutBuffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpOutBuffer", r->out.lpOutBuffer, *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpBytesReturned", r->out.lpBytesReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpBytesReturned", *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpcbRequired", r->out.lpcbRequired);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpcbRequired", *r->out.lpcbRequired);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_NetInterfaceControl(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_NetInterfaceControl *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNetInterface));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwControlCode));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpInBuffer));
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nInBufferSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, r->in.nInBufferSize));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nInBufferSize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nOutBufferSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpOutBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpBytesReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpcbRequired == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nOutBufferSize));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpcbRequired));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_NetInterfaceControl(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_NetInterfaceControl *r)
{
	uint32_t _ptr_lpInBuffer;
	uint32_t size_lpInBuffer_1 = 0;
	uint32_t size_lpOutBuffer_1 = 0;
	uint32_t length_lpOutBuffer_1 = 0;
	TALLOC_CTX *_mem_save_lpInBuffer_0 = NULL;
	TALLOC_CTX *_mem_save_lpBytesReturned_0 = NULL;
	TALLOC_CTX *_mem_save_lpcbRequired_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNetInterface));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwControlCode));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpInBuffer));
		if (_ptr_lpInBuffer) {
			NDR_PULL_ALLOC(ndr, r->in.lpInBuffer);
		} else {
			r->in.lpInBuffer = NULL;
		}
		if (r->in.lpInBuffer) {
			_mem_save_lpInBuffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpInBuffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpInBuffer));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpInBuffer, &size_lpInBuffer_1));
			NDR_PULL_ALLOC_N(ndr, r->in.lpInBuffer, size_lpInBuffer_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, size_lpInBuffer_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpInBuffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nInBufferSize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nOutBufferSize));
		NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, r->in.nOutBufferSize);
		memset(r->out.lpOutBuffer, 0, (r->in.nOutBufferSize) * sizeof(*r->out.lpOutBuffer));
		NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		NDR_ZERO_STRUCTP(r->out.lpBytesReturned);
		NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		NDR_ZERO_STRUCTP(r->out.lpcbRequired);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpInBuffer, r->in.nInBufferSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.lpOutBuffer, &size_lpOutBuffer_1));
		NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->out.lpOutBuffer, &length_lpOutBuffer_1));
		if (length_lpOutBuffer_1 > size_lpOutBuffer_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpOutBuffer_1, length_lpOutBuffer_1);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, size_lpOutBuffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, length_lpOutBuffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		}
		_mem_save_lpBytesReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpBytesReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpBytesReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpBytesReturned_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		}
		_mem_save_lpcbRequired_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpcbRequired, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpcbRequired));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpcbRequired_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.lpOutBuffer, r->in.nOutBufferSize));
		}
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->out.lpOutBuffer, *r->out.lpBytesReturned));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_NetInterfaceControl(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_NetInterfaceControl *r)
{
	ndr_print_struct(ndr, name, "clusapi_NetInterfaceControl");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_NetInterfaceControl");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNetInterface", &r->in.hNetInterface);
		ndr_print_uint32(ndr, "dwControlCode", r->in.dwControlCode);
		ndr_print_ptr(ndr, "lpInBuffer", r->in.lpInBuffer);
		ndr->depth++;
		if (r->in.lpInBuffer) {
			ndr_print_array_uint8(ndr, "lpInBuffer", r->in.lpInBuffer, r->in.nInBufferSize);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "nInBufferSize", r->in.nInBufferSize);
		ndr_print_uint32(ndr, "nOutBufferSize", r->in.nOutBufferSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_NetInterfaceControl");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpOutBuffer", r->out.lpOutBuffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpOutBuffer", r->out.lpOutBuffer, *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpBytesReturned", r->out.lpBytesReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpBytesReturned", *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpcbRequired", r->out.lpcbRequired);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpcbRequired", *r->out.lpcbRequired);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_AddNotifyNetInterface(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_AddNotifyNetInterface *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNetInterface));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwFilter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwNotifyKey));
	}
	if (flags & NDR_OUT) {
		if (r->out.dwStateSequence == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.dwStateSequence));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_AddNotifyNetInterface(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_AddNotifyNetInterface *r)
{
	TALLOC_CTX *_mem_save_dwStateSequence_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNetInterface));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwFilter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwNotifyKey));
		NDR_PULL_ALLOC(ndr, r->out.dwStateSequence);
		NDR_ZERO_STRUCTP(r->out.dwStateSequence);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.dwStateSequence);
		}
		_mem_save_dwStateSequence_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.dwStateSequence, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.dwStateSequence));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dwStateSequence_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_AddNotifyNetInterface(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_AddNotifyNetInterface *r)
{
	ndr_print_struct(ndr, name, "clusapi_AddNotifyNetInterface");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_AddNotifyNetInterface");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNotify", &r->in.hNotify);
		ndr_print_policy_handle(ndr, "hNetInterface", &r->in.hNetInterface);
		ndr_print_uint32(ndr, "dwFilter", r->in.dwFilter);
		ndr_print_uint32(ndr, "dwNotifyKey", r->in.dwNotifyKey);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_AddNotifyNetInterface");
		ndr->depth++;
		ndr_print_ptr(ndr, "dwStateSequence", r->out.dwStateSequence);
		ndr->depth++;
		ndr_print_uint32(ndr, "dwStateSequence", *r->out.dwStateSequence);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_ReAddNotifyNetInterface(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_ReAddNotifyNetInterface *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNetInterface));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwFilter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwNotifyKey));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.StateSequence));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_ReAddNotifyNetInterface(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_ReAddNotifyNetInterface *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNetInterface));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwFilter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwNotifyKey));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.StateSequence));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_ReAddNotifyNetInterface(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_ReAddNotifyNetInterface *r)
{
	ndr_print_struct(ndr, name, "clusapi_ReAddNotifyNetInterface");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_ReAddNotifyNetInterface");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNotify", &r->in.hNotify);
		ndr_print_policy_handle(ndr, "hNetInterface", &r->in.hNetInterface);
		ndr_print_uint32(ndr, "dwFilter", r->in.dwFilter);
		ndr_print_uint32(ndr, "dwNotifyKey", r->in.dwNotifyKey);
		ndr_print_uint32(ndr, "StateSequence", r->in.StateSequence);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_ReAddNotifyNetInterface");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CreateNodeEnum(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CreateNodeEnum *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwType));
	}
	if (flags & NDR_OUT) {
		if (r->out.ReturnEnum == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ReturnEnum));
		if (*r->out.ReturnEnum) {
			NDR_CHECK(ndr_push_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ReturnEnum));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CreateNodeEnum(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CreateNodeEnum *r)
{
	uint32_t _ptr_ReturnEnum;
	TALLOC_CTX *_mem_save_ReturnEnum_0 = NULL;
	TALLOC_CTX *_mem_save_ReturnEnum_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwType));
		NDR_PULL_ALLOC(ndr, r->out.ReturnEnum);
		NDR_ZERO_STRUCTP(r->out.ReturnEnum);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ReturnEnum);
		}
		_mem_save_ReturnEnum_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ReturnEnum, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ReturnEnum));
		if (_ptr_ReturnEnum) {
			NDR_PULL_ALLOC(ndr, *r->out.ReturnEnum);
		} else {
			*r->out.ReturnEnum = NULL;
		}
		if (*r->out.ReturnEnum) {
			_mem_save_ReturnEnum_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ReturnEnum, 0);
			NDR_CHECK(ndr_pull_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ReturnEnum));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReturnEnum_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReturnEnum_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CreateNodeEnum(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CreateNodeEnum *r)
{
	ndr_print_struct(ndr, name, "clusapi_CreateNodeEnum");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CreateNodeEnum");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNode", &r->in.hNode);
		ndr_print_uint32(ndr, "dwType", r->in.dwType);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CreateNodeEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "ReturnEnum", r->out.ReturnEnum);
		ndr->depth++;
		ndr_print_ptr(ndr, "ReturnEnum", *r->out.ReturnEnum);
		ndr->depth++;
		if (*r->out.ReturnEnum) {
			ndr_print_ENUM_LIST(ndr, "ReturnEnum", *r->out.ReturnEnum);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_GetClusterVersion2(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_GetClusterVersion2 *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.lpwMajorVersion == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpwMinorVersion == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpwBuildNumber == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpszVendorId == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpszCSDVersion == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.ppClusterOpVerInfo == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->out.lpwMajorVersion));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->out.lpwMinorVersion));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->out.lpwBuildNumber));
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.lpszVendorId));
		if (*r->out.lpszVendorId) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.lpszVendorId, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.lpszVendorId, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.lpszVendorId, ndr_charset_length(*r->out.lpszVendorId, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.lpszCSDVersion));
		if (*r->out.lpszCSDVersion) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.lpszCSDVersion, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.lpszCSDVersion, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.lpszCSDVersion, ndr_charset_length(*r->out.lpszCSDVersion, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppClusterOpVerInfo));
		if (*r->out.ppClusterOpVerInfo) {
			NDR_CHECK(ndr_push_CLUSTER_OPERATIONAL_VERSION_INFO(ndr, NDR_SCALARS, *r->out.ppClusterOpVerInfo));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GetClusterVersion2(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_GetClusterVersion2 *r)
{
	uint32_t _ptr_lpszVendorId;
	uint32_t size_lpszVendorId_2 = 0;
	uint32_t length_lpszVendorId_2 = 0;
	uint32_t _ptr_lpszCSDVersion;
	uint32_t size_lpszCSDVersion_2 = 0;
	uint32_t length_lpszCSDVersion_2 = 0;
	uint32_t _ptr_ppClusterOpVerInfo;
	TALLOC_CTX *_mem_save_lpwMajorVersion_0 = NULL;
	TALLOC_CTX *_mem_save_lpwMinorVersion_0 = NULL;
	TALLOC_CTX *_mem_save_lpwBuildNumber_0 = NULL;
	TALLOC_CTX *_mem_save_lpszVendorId_0 = NULL;
	TALLOC_CTX *_mem_save_lpszVendorId_1 = NULL;
	TALLOC_CTX *_mem_save_lpszCSDVersion_0 = NULL;
	TALLOC_CTX *_mem_save_lpszCSDVersion_1 = NULL;
	TALLOC_CTX *_mem_save_ppClusterOpVerInfo_0 = NULL;
	TALLOC_CTX *_mem_save_ppClusterOpVerInfo_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.lpwMajorVersion);
		NDR_ZERO_STRUCTP(r->out.lpwMajorVersion);
		NDR_PULL_ALLOC(ndr, r->out.lpwMinorVersion);
		NDR_ZERO_STRUCTP(r->out.lpwMinorVersion);
		NDR_PULL_ALLOC(ndr, r->out.lpwBuildNumber);
		NDR_ZERO_STRUCTP(r->out.lpwBuildNumber);
		NDR_PULL_ALLOC(ndr, r->out.lpszVendorId);
		NDR_ZERO_STRUCTP(r->out.lpszVendorId);
		NDR_PULL_ALLOC(ndr, r->out.lpszCSDVersion);
		NDR_ZERO_STRUCTP(r->out.lpszCSDVersion);
		NDR_PULL_ALLOC(ndr, r->out.ppClusterOpVerInfo);
		NDR_ZERO_STRUCTP(r->out.ppClusterOpVerInfo);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpwMajorVersion);
		}
		_mem_save_lpwMajorVersion_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpwMajorVersion, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->out.lpwMajorVersion));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpwMajorVersion_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpwMinorVersion);
		}
		_mem_save_lpwMinorVersion_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpwMinorVersion, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->out.lpwMinorVersion));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpwMinorVersion_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpwBuildNumber);
		}
		_mem_save_lpwBuildNumber_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpwBuildNumber, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->out.lpwBuildNumber));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpwBuildNumber_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpszVendorId);
		}
		_mem_save_lpszVendorId_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpszVendorId, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpszVendorId));
		if (_ptr_lpszVendorId) {
			NDR_PULL_ALLOC(ndr, *r->out.lpszVendorId);
		} else {
			*r->out.lpszVendorId = NULL;
		}
		if (*r->out.lpszVendorId) {
			_mem_save_lpszVendorId_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.lpszVendorId, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.lpszVendorId));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.lpszVendorId));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.lpszVendorId, &size_lpszVendorId_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.lpszVendorId, &length_lpszVendorId_2));
			if (length_lpszVendorId_2 > size_lpszVendorId_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszVendorId_2, length_lpszVendorId_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszVendorId_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.lpszVendorId, length_lpszVendorId_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpszVendorId_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpszVendorId_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpszCSDVersion);
		}
		_mem_save_lpszCSDVersion_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpszCSDVersion, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpszCSDVersion));
		if (_ptr_lpszCSDVersion) {
			NDR_PULL_ALLOC(ndr, *r->out.lpszCSDVersion);
		} else {
			*r->out.lpszCSDVersion = NULL;
		}
		if (*r->out.lpszCSDVersion) {
			_mem_save_lpszCSDVersion_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.lpszCSDVersion, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.lpszCSDVersion));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.lpszCSDVersion));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.lpszCSDVersion, &size_lpszCSDVersion_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.lpszCSDVersion, &length_lpszCSDVersion_2));
			if (length_lpszCSDVersion_2 > size_lpszCSDVersion_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszCSDVersion_2, length_lpszCSDVersion_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszCSDVersion_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.lpszCSDVersion, length_lpszCSDVersion_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpszCSDVersion_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpszCSDVersion_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppClusterOpVerInfo);
		}
		_mem_save_ppClusterOpVerInfo_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppClusterOpVerInfo, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppClusterOpVerInfo));
		if (_ptr_ppClusterOpVerInfo) {
			NDR_PULL_ALLOC(ndr, *r->out.ppClusterOpVerInfo);
		} else {
			*r->out.ppClusterOpVerInfo = NULL;
		}
		if (*r->out.ppClusterOpVerInfo) {
			_mem_save_ppClusterOpVerInfo_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppClusterOpVerInfo, 0);
			NDR_CHECK(ndr_pull_CLUSTER_OPERATIONAL_VERSION_INFO(ndr, NDR_SCALARS, *r->out.ppClusterOpVerInfo));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppClusterOpVerInfo_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppClusterOpVerInfo_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GetClusterVersion2(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_GetClusterVersion2 *r)
{
	ndr_print_struct(ndr, name, "clusapi_GetClusterVersion2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_GetClusterVersion2");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_GetClusterVersion2");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpwMajorVersion", r->out.lpwMajorVersion);
		ndr->depth++;
		ndr_print_uint16(ndr, "lpwMajorVersion", *r->out.lpwMajorVersion);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpwMinorVersion", r->out.lpwMinorVersion);
		ndr->depth++;
		ndr_print_uint16(ndr, "lpwMinorVersion", *r->out.lpwMinorVersion);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpwBuildNumber", r->out.lpwBuildNumber);
		ndr->depth++;
		ndr_print_uint16(ndr, "lpwBuildNumber", *r->out.lpwBuildNumber);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpszVendorId", r->out.lpszVendorId);
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszVendorId", *r->out.lpszVendorId);
		ndr->depth++;
		if (*r->out.lpszVendorId) {
			ndr_print_string(ndr, "lpszVendorId", *r->out.lpszVendorId);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "lpszCSDVersion", r->out.lpszCSDVersion);
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszCSDVersion", *r->out.lpszCSDVersion);
		ndr->depth++;
		if (*r->out.lpszCSDVersion) {
			ndr_print_string(ndr, "lpszCSDVersion", *r->out.lpszCSDVersion);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "ppClusterOpVerInfo", r->out.ppClusterOpVerInfo);
		ndr->depth++;
		ndr_print_ptr(ndr, "ppClusterOpVerInfo", *r->out.ppClusterOpVerInfo);
		ndr->depth++;
		if (*r->out.ppClusterOpVerInfo) {
			ndr_print_CLUSTER_OPERATIONAL_VERSION_INFO(ndr, "ppClusterOpVerInfo", *r->out.ppClusterOpVerInfo);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CreateResTypeEnum(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CreateResTypeEnum *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszTypeName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszTypeName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszTypeName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszTypeName, ndr_charset_length(r->in.lpszTypeName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_ClusterResTypeEnumType(ndr, NDR_SCALARS, r->in.dwType));
	}
	if (flags & NDR_OUT) {
		if (r->out.ReturnEnum == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ReturnEnum));
		if (*r->out.ReturnEnum) {
			NDR_CHECK(ndr_push_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ReturnEnum));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CreateResTypeEnum(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CreateResTypeEnum *r)
{
	uint32_t size_lpszTypeName_1 = 0;
	uint32_t length_lpszTypeName_1 = 0;
	uint32_t _ptr_ReturnEnum;
	TALLOC_CTX *_mem_save_ReturnEnum_0 = NULL;
	TALLOC_CTX *_mem_save_ReturnEnum_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszTypeName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszTypeName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszTypeName, &size_lpszTypeName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszTypeName, &length_lpszTypeName_1));
		if (length_lpszTypeName_1 > size_lpszTypeName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszTypeName_1, length_lpszTypeName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszTypeName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszTypeName, length_lpszTypeName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_ClusterResTypeEnumType(ndr, NDR_SCALARS, &r->in.dwType));
		NDR_PULL_ALLOC(ndr, r->out.ReturnEnum);
		NDR_ZERO_STRUCTP(r->out.ReturnEnum);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ReturnEnum);
		}
		_mem_save_ReturnEnum_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ReturnEnum, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ReturnEnum));
		if (_ptr_ReturnEnum) {
			NDR_PULL_ALLOC(ndr, *r->out.ReturnEnum);
		} else {
			*r->out.ReturnEnum = NULL;
		}
		if (*r->out.ReturnEnum) {
			_mem_save_ReturnEnum_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ReturnEnum, 0);
			NDR_CHECK(ndr_pull_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ReturnEnum));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReturnEnum_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReturnEnum_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CreateResTypeEnum(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CreateResTypeEnum *r)
{
	ndr_print_struct(ndr, name, "clusapi_CreateResTypeEnum");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CreateResTypeEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszTypeName", r->in.lpszTypeName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszTypeName", r->in.lpszTypeName);
		ndr->depth--;
		ndr_print_ClusterResTypeEnumType(ndr, "dwType", r->in.dwType);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CreateResTypeEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "ReturnEnum", r->out.ReturnEnum);
		ndr->depth++;
		ndr_print_ptr(ndr, "ReturnEnum", *r->out.ReturnEnum);
		ndr->depth++;
		if (*r->out.ReturnEnum) {
			ndr_print_ENUM_LIST(ndr, "ReturnEnum", *r->out.ReturnEnum);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_BackupClusterDatabase(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_BackupClusterDatabase *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszPathName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszPathName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszPathName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszPathName, ndr_charset_length(r->in.lpszPathName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_BackupClusterDatabase(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_BackupClusterDatabase *r)
{
	uint32_t size_lpszPathName_1 = 0;
	uint32_t length_lpszPathName_1 = 0;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszPathName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszPathName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszPathName, &size_lpszPathName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszPathName, &length_lpszPathName_1));
		if (length_lpszPathName_1 > size_lpszPathName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszPathName_1, length_lpszPathName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszPathName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszPathName, length_lpszPathName_1, sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_BackupClusterDatabase(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_BackupClusterDatabase *r)
{
	ndr_print_struct(ndr, name, "clusapi_BackupClusterDatabase");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_BackupClusterDatabase");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszPathName", r->in.lpszPathName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszPathName", r->in.lpszPathName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_BackupClusterDatabase");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_NodeClusterControl(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_NodeClusterControl *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hCluster));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hHostNode));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwControlCode));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpInBuffer));
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nInBufferSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, r->in.nInBufferSize));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nInBufferSize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nOutBufferSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpOutBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpBytesReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpcbRequired == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nOutBufferSize));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpcbRequired));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_NodeClusterControl(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_NodeClusterControl *r)
{
	uint32_t _ptr_lpInBuffer;
	uint32_t size_lpInBuffer_1 = 0;
	uint32_t size_lpOutBuffer_1 = 0;
	uint32_t length_lpOutBuffer_1 = 0;
	TALLOC_CTX *_mem_save_lpInBuffer_0 = NULL;
	TALLOC_CTX *_mem_save_lpBytesReturned_0 = NULL;
	TALLOC_CTX *_mem_save_lpcbRequired_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hCluster));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hHostNode));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwControlCode));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpInBuffer));
		if (_ptr_lpInBuffer) {
			NDR_PULL_ALLOC(ndr, r->in.lpInBuffer);
		} else {
			r->in.lpInBuffer = NULL;
		}
		if (r->in.lpInBuffer) {
			_mem_save_lpInBuffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpInBuffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpInBuffer));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpInBuffer, &size_lpInBuffer_1));
			NDR_PULL_ALLOC_N(ndr, r->in.lpInBuffer, size_lpInBuffer_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, size_lpInBuffer_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpInBuffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nInBufferSize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nOutBufferSize));
		NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, r->in.nOutBufferSize);
		memset(r->out.lpOutBuffer, 0, (r->in.nOutBufferSize) * sizeof(*r->out.lpOutBuffer));
		NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		NDR_ZERO_STRUCTP(r->out.lpBytesReturned);
		NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		NDR_ZERO_STRUCTP(r->out.lpcbRequired);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpInBuffer, r->in.nInBufferSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.lpOutBuffer, &size_lpOutBuffer_1));
		NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->out.lpOutBuffer, &length_lpOutBuffer_1));
		if (length_lpOutBuffer_1 > size_lpOutBuffer_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpOutBuffer_1, length_lpOutBuffer_1);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, size_lpOutBuffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, length_lpOutBuffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		}
		_mem_save_lpBytesReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpBytesReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpBytesReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpBytesReturned_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		}
		_mem_save_lpcbRequired_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpcbRequired, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpcbRequired));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpcbRequired_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.lpOutBuffer, r->in.nOutBufferSize));
		}
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->out.lpOutBuffer, *r->out.lpBytesReturned));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_NodeClusterControl(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_NodeClusterControl *r)
{
	ndr_print_struct(ndr, name, "clusapi_NodeClusterControl");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_NodeClusterControl");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hCluster", &r->in.hCluster);
		ndr_print_policy_handle(ndr, "hHostNode", &r->in.hHostNode);
		ndr_print_uint32(ndr, "dwControlCode", r->in.dwControlCode);
		ndr_print_ptr(ndr, "lpInBuffer", r->in.lpInBuffer);
		ndr->depth++;
		if (r->in.lpInBuffer) {
			ndr_print_array_uint8(ndr, "lpInBuffer", r->in.lpInBuffer, r->in.nInBufferSize);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "nInBufferSize", r->in.nInBufferSize);
		ndr_print_uint32(ndr, "nOutBufferSize", r->in.nOutBufferSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_NodeClusterControl");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpOutBuffer", r->out.lpOutBuffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpOutBuffer", r->out.lpOutBuffer, *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpBytesReturned", r->out.lpBytesReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpBytesReturned", *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpcbRequired", r->out.lpcbRequired);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpcbRequired", *r->out.lpcbRequired);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_ClusterControl(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_ClusterControl *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hCluster));
		NDR_CHECK(ndr_push_clusapi_ClusterControlCode(ndr, NDR_SCALARS, r->in.dwControlCode));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpInBuffer));
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nInBufferSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, r->in.nInBufferSize));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nInBufferSize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nOutBufferSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpOutBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpBytesReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpcbRequired == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nOutBufferSize));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpcbRequired));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_ClusterControl(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_ClusterControl *r)
{
	uint32_t _ptr_lpInBuffer;
	uint32_t size_lpInBuffer_1 = 0;
	uint32_t size_lpOutBuffer_1 = 0;
	uint32_t length_lpOutBuffer_1 = 0;
	TALLOC_CTX *_mem_save_lpInBuffer_0 = NULL;
	TALLOC_CTX *_mem_save_lpBytesReturned_0 = NULL;
	TALLOC_CTX *_mem_save_lpcbRequired_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hCluster));
		NDR_CHECK(ndr_pull_clusapi_ClusterControlCode(ndr, NDR_SCALARS, &r->in.dwControlCode));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpInBuffer));
		if (_ptr_lpInBuffer) {
			NDR_PULL_ALLOC(ndr, r->in.lpInBuffer);
		} else {
			r->in.lpInBuffer = NULL;
		}
		if (r->in.lpInBuffer) {
			_mem_save_lpInBuffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpInBuffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpInBuffer));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpInBuffer, &size_lpInBuffer_1));
			NDR_PULL_ALLOC_N(ndr, r->in.lpInBuffer, size_lpInBuffer_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, size_lpInBuffer_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpInBuffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nInBufferSize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nOutBufferSize));
		NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, r->in.nOutBufferSize);
		memset(r->out.lpOutBuffer, 0, (r->in.nOutBufferSize) * sizeof(*r->out.lpOutBuffer));
		NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		NDR_ZERO_STRUCTP(r->out.lpBytesReturned);
		NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		NDR_ZERO_STRUCTP(r->out.lpcbRequired);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpInBuffer, r->in.nInBufferSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.lpOutBuffer, &size_lpOutBuffer_1));
		NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->out.lpOutBuffer, &length_lpOutBuffer_1));
		if (length_lpOutBuffer_1 > size_lpOutBuffer_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpOutBuffer_1, length_lpOutBuffer_1);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, size_lpOutBuffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, length_lpOutBuffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		}
		_mem_save_lpBytesReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpBytesReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpBytesReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpBytesReturned_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		}
		_mem_save_lpcbRequired_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpcbRequired, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpcbRequired));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpcbRequired_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.lpOutBuffer, r->in.nOutBufferSize));
		}
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->out.lpOutBuffer, *r->out.lpBytesReturned));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_ClusterControl(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_ClusterControl *r)
{
	ndr_print_struct(ndr, name, "clusapi_ClusterControl");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_ClusterControl");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hCluster", &r->in.hCluster);
		ndr_print_clusapi_ClusterControlCode(ndr, "dwControlCode", r->in.dwControlCode);
		ndr_print_ptr(ndr, "lpInBuffer", r->in.lpInBuffer);
		ndr->depth++;
		if (r->in.lpInBuffer) {
			ndr_print_array_uint8(ndr, "lpInBuffer", r->in.lpInBuffer, r->in.nInBufferSize);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "nInBufferSize", r->in.nInBufferSize);
		ndr_print_uint32(ndr, "nOutBufferSize", r->in.nOutBufferSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_ClusterControl");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpOutBuffer", r->out.lpOutBuffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpOutBuffer", r->out.lpOutBuffer, *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpBytesReturned", r->out.lpBytesReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpBytesReturned", *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpcbRequired", r->out.lpcbRequired);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpcbRequired", *r->out.lpcbRequired);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_UnblockGetNotifyCall(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_UnblockGetNotifyCall *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_UnblockGetNotifyCall(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_UnblockGetNotifyCall *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_UnblockGetNotifyCall(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_UnblockGetNotifyCall *r)
{
	ndr_print_struct(ndr, name, "clusapi_UnblockGetNotifyCall");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_UnblockGetNotifyCall");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNotify", &r->in.hNotify);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_UnblockGetNotifyCall");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_SetServiceAccountPassword(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_SetServiceAccountPassword *r)
{
	uint32_t cntr_ReturnStatusBufferPtr_0;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszNewPassword == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszNewPassword, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszNewPassword, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszNewPassword, ndr_charset_length(r->in.lpszNewPassword, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_IDL_CLUSTER_SET_PASSWORD_FLAGS(ndr, NDR_SCALARS, r->in.dwFlags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.ReturnStatusBufferSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.SizeReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.ExpectedBufferSize == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.ReturnStatusBufferSize));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.SizeReturned));
		for (cntr_ReturnStatusBufferPtr_0 = 0; cntr_ReturnStatusBufferPtr_0 < (*r->out.SizeReturned); cntr_ReturnStatusBufferPtr_0++) {
			NDR_CHECK(ndr_push_IDL_CLUSTER_SET_PASSWORD_STATUS(ndr, NDR_SCALARS, &r->out.ReturnStatusBufferPtr[cntr_ReturnStatusBufferPtr_0]));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.SizeReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.ExpectedBufferSize));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_SetServiceAccountPassword(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_SetServiceAccountPassword *r)
{
	uint32_t size_lpszNewPassword_1 = 0;
	uint32_t length_lpszNewPassword_1 = 0;
	uint32_t size_ReturnStatusBufferPtr_0 = 0;
	uint32_t length_ReturnStatusBufferPtr_0 = 0;
	uint32_t cntr_ReturnStatusBufferPtr_0;
	TALLOC_CTX *_mem_save_ReturnStatusBufferPtr_0 = NULL;
	TALLOC_CTX *_mem_save_SizeReturned_0 = NULL;
	TALLOC_CTX *_mem_save_ExpectedBufferSize_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszNewPassword));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszNewPassword));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszNewPassword, &size_lpszNewPassword_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszNewPassword, &length_lpszNewPassword_1));
		if (length_lpszNewPassword_1 > size_lpszNewPassword_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszNewPassword_1, length_lpszNewPassword_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszNewPassword_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszNewPassword, length_lpszNewPassword_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_IDL_CLUSTER_SET_PASSWORD_FLAGS(ndr, NDR_SCALARS, &r->in.dwFlags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.ReturnStatusBufferSize));
		if (r->in.ReturnStatusBufferSize > (64*1024)) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.ReturnStatusBufferSize), (uint32_t)(0), (uint32_t)((64*1024)));
		}
		NDR_PULL_ALLOC(ndr, r->out.SizeReturned);
		NDR_ZERO_STRUCTP(r->out.SizeReturned);
		NDR_PULL_ALLOC(ndr, r->out.ExpectedBufferSize);
		NDR_ZERO_STRUCTP(r->out.ExpectedBufferSize);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.ReturnStatusBufferPtr));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.ReturnStatusBufferPtr));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.ReturnStatusBufferPtr, &size_ReturnStatusBufferPtr_0));
		NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->out.ReturnStatusBufferPtr, &length_ReturnStatusBufferPtr_0));
		if (length_ReturnStatusBufferPtr_0 > size_ReturnStatusBufferPtr_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_ReturnStatusBufferPtr_0, length_ReturnStatusBufferPtr_0);
		}
		NDR_PULL_ALLOC_N(ndr, r->out.ReturnStatusBufferPtr, size_ReturnStatusBufferPtr_0);
		_mem_save_ReturnStatusBufferPtr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ReturnStatusBufferPtr, 0);
		for (cntr_ReturnStatusBufferPtr_0 = 0; cntr_ReturnStatusBufferPtr_0 < (length_ReturnStatusBufferPtr_0); cntr_ReturnStatusBufferPtr_0++) {
			NDR_CHECK(ndr_pull_IDL_CLUSTER_SET_PASSWORD_STATUS(ndr, NDR_SCALARS, &r->out.ReturnStatusBufferPtr[cntr_ReturnStatusBufferPtr_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReturnStatusBufferPtr_0, 0);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.SizeReturned);
		}
		_mem_save_SizeReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.SizeReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.SizeReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_SizeReturned_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ExpectedBufferSize);
		}
		_mem_save_ExpectedBufferSize_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ExpectedBufferSize, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.ExpectedBufferSize));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ExpectedBufferSize_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.ReturnStatusBufferPtr) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.ReturnStatusBufferPtr, r->in.ReturnStatusBufferSize));
		}
		if (r->out.ReturnStatusBufferPtr) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->out.ReturnStatusBufferPtr, *r->out.SizeReturned));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_SetServiceAccountPassword(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_SetServiceAccountPassword *r)
{
	uint32_t cntr_ReturnStatusBufferPtr_0;
	ndr_print_struct(ndr, name, "clusapi_SetServiceAccountPassword");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_SetServiceAccountPassword");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszNewPassword", r->in.lpszNewPassword);
		ndr->depth++;
		ndr_print_string(ndr, "lpszNewPassword", r->in.lpszNewPassword);
		ndr->depth--;
		ndr_print_IDL_CLUSTER_SET_PASSWORD_FLAGS(ndr, "dwFlags", r->in.dwFlags);
		ndr_print_uint32(ndr, "ReturnStatusBufferSize", r->in.ReturnStatusBufferSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_SetServiceAccountPassword");
		ndr->depth++;
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "ReturnStatusBufferPtr", (uint32_t)(*r->out.SizeReturned));
		ndr->depth++;
		for (cntr_ReturnStatusBufferPtr_0 = 0; cntr_ReturnStatusBufferPtr_0 < (*r->out.SizeReturned); cntr_ReturnStatusBufferPtr_0++) {
			ndr_print_IDL_CLUSTER_SET_PASSWORD_STATUS(ndr, "ReturnStatusBufferPtr", &r->out.ReturnStatusBufferPtr[cntr_ReturnStatusBufferPtr_0]);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "SizeReturned", r->out.SizeReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "SizeReturned", *r->out.SizeReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "ExpectedBufferSize", r->out.ExpectedBufferSize);
		ndr->depth++;
		ndr_print_uint32(ndr, "ExpectedBufferSize", *r->out.ExpectedBufferSize);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_SetResourceDependencyExpression(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_SetResourceDependencyExpression *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpszDependencyExpression));
		if (r->in.lpszDependencyExpression) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszDependencyExpression, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszDependencyExpression, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszDependencyExpression, ndr_charset_length(r->in.lpszDependencyExpression, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_SetResourceDependencyExpression(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_SetResourceDependencyExpression *r)
{
	uint32_t _ptr_lpszDependencyExpression;
	uint32_t size_lpszDependencyExpression_1 = 0;
	uint32_t length_lpszDependencyExpression_1 = 0;
	TALLOC_CTX *_mem_save_lpszDependencyExpression_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpszDependencyExpression));
		if (_ptr_lpszDependencyExpression) {
			NDR_PULL_ALLOC(ndr, r->in.lpszDependencyExpression);
		} else {
			r->in.lpszDependencyExpression = NULL;
		}
		if (r->in.lpszDependencyExpression) {
			_mem_save_lpszDependencyExpression_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpszDependencyExpression, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszDependencyExpression));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszDependencyExpression));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszDependencyExpression, &size_lpszDependencyExpression_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszDependencyExpression, &length_lpszDependencyExpression_1));
			if (length_lpszDependencyExpression_1 > size_lpszDependencyExpression_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszDependencyExpression_1, length_lpszDependencyExpression_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszDependencyExpression_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszDependencyExpression, length_lpszDependencyExpression_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpszDependencyExpression_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_SetResourceDependencyExpression(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_SetResourceDependencyExpression *r)
{
	ndr_print_struct(ndr, name, "clusapi_SetResourceDependencyExpression");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_SetResourceDependencyExpression");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr_print_ptr(ndr, "lpszDependencyExpression", r->in.lpszDependencyExpression);
		ndr->depth++;
		if (r->in.lpszDependencyExpression) {
			ndr_print_string(ndr, "lpszDependencyExpression", r->in.lpszDependencyExpression);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_SetResourceDependencyExpression");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_GetResourceDependencyExpression(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_GetResourceDependencyExpression *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpszDependencyExpression == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.lpszDependencyExpression));
		if (*r->out.lpszDependencyExpression) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.lpszDependencyExpression, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.lpszDependencyExpression, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.lpszDependencyExpression, ndr_charset_length(*r->out.lpszDependencyExpression, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GetResourceDependencyExpression(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_GetResourceDependencyExpression *r)
{
	uint32_t _ptr_lpszDependencyExpression;
	uint32_t size_lpszDependencyExpression_2 = 0;
	uint32_t length_lpszDependencyExpression_2 = 0;
	TALLOC_CTX *_mem_save_lpszDependencyExpression_0 = NULL;
	TALLOC_CTX *_mem_save_lpszDependencyExpression_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_PULL_ALLOC(ndr, r->out.lpszDependencyExpression);
		NDR_ZERO_STRUCTP(r->out.lpszDependencyExpression);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpszDependencyExpression);
		}
		_mem_save_lpszDependencyExpression_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpszDependencyExpression, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpszDependencyExpression));
		if (_ptr_lpszDependencyExpression) {
			NDR_PULL_ALLOC(ndr, *r->out.lpszDependencyExpression);
		} else {
			*r->out.lpszDependencyExpression = NULL;
		}
		if (*r->out.lpszDependencyExpression) {
			_mem_save_lpszDependencyExpression_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.lpszDependencyExpression, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.lpszDependencyExpression));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.lpszDependencyExpression));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.lpszDependencyExpression, &size_lpszDependencyExpression_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.lpszDependencyExpression, &length_lpszDependencyExpression_2));
			if (length_lpszDependencyExpression_2 > size_lpszDependencyExpression_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszDependencyExpression_2, length_lpszDependencyExpression_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszDependencyExpression_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.lpszDependencyExpression, length_lpszDependencyExpression_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpszDependencyExpression_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpszDependencyExpression_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GetResourceDependencyExpression(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_GetResourceDependencyExpression *r)
{
	ndr_print_struct(ndr, name, "clusapi_GetResourceDependencyExpression");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_GetResourceDependencyExpression");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_GetResourceDependencyExpression");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszDependencyExpression", r->out.lpszDependencyExpression);
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszDependencyExpression", *r->out.lpszDependencyExpression);
		ndr->depth++;
		if (*r->out.lpszDependencyExpression) {
			ndr_print_string(ndr, "lpszDependencyExpression", *r->out.lpszDependencyExpression);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Opnum111NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct Opnum111NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Opnum111NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct Opnum111NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Opnum111NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct Opnum111NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "Opnum111NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Opnum111NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Opnum111NotUsedOnWire");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_GetResourceNetworkName(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_GetResourceNetworkName *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpszName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.lpszName));
		if (*r->out.lpszName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.lpszName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.lpszName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.lpszName, ndr_charset_length(*r->out.lpszName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GetResourceNetworkName(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_GetResourceNetworkName *r)
{
	uint32_t _ptr_lpszName;
	uint32_t size_lpszName_2 = 0;
	uint32_t length_lpszName_2 = 0;
	TALLOC_CTX *_mem_save_lpszName_0 = NULL;
	TALLOC_CTX *_mem_save_lpszName_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_PULL_ALLOC(ndr, r->out.lpszName);
		NDR_ZERO_STRUCTP(r->out.lpszName);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpszName);
		}
		_mem_save_lpszName_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpszName, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpszName));
		if (_ptr_lpszName) {
			NDR_PULL_ALLOC(ndr, *r->out.lpszName);
		} else {
			*r->out.lpszName = NULL;
		}
		if (*r->out.lpszName) {
			_mem_save_lpszName_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.lpszName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.lpszName));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.lpszName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.lpszName, &size_lpszName_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.lpszName, &length_lpszName_2));
			if (length_lpszName_2 > size_lpszName_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszName_2, length_lpszName_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszName_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.lpszName, length_lpszName_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpszName_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpszName_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GetResourceNetworkName(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_GetResourceNetworkName *r)
{
	ndr_print_struct(ndr, name, "clusapi_GetResourceNetworkName");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_GetResourceNetworkName");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_GetResourceNetworkName");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszName", r->out.lpszName);
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszName", *r->out.lpszName);
		ndr->depth++;
		if (*r->out.lpszName) {
			ndr_print_string(ndr, "lpszName", *r->out.lpszName);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_ExecuteBatch(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_ExecuteBatch *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbData));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbData));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpData, r->in.cbData));
	}
	if (flags & NDR_OUT) {
		if (r->out.pdwFailedCommand == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, *r->out.pdwFailedCommand));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_ExecuteBatch(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_ExecuteBatch *r)
{
	uint32_t size_lpData_1 = 0;
	TALLOC_CTX *_mem_save_pdwFailedCommand_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbData));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpData));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpData, &size_lpData_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.lpData, size_lpData_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpData, size_lpData_1));
		NDR_PULL_ALLOC(ndr, r->out.pdwFailedCommand);
		NDR_ZERO_STRUCTP(r->out.pdwFailedCommand);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.lpData) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpData, r->in.cbData));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pdwFailedCommand);
		}
		_mem_save_pdwFailedCommand_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pdwFailedCommand, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, r->out.pdwFailedCommand));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pdwFailedCommand_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_ExecuteBatch(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_ExecuteBatch *r)
{
	ndr_print_struct(ndr, name, "clusapi_ExecuteBatch");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_ExecuteBatch");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hKey", &r->in.hKey);
		ndr_print_uint32(ndr, "cbData", r->in.cbData);
		ndr_print_ptr(ndr, "lpData", r->in.lpData);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpData", r->in.lpData, r->in.cbData);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_ExecuteBatch");
		ndr->depth++;
		ndr_print_ptr(ndr, "pdwFailedCommand", r->out.pdwFailedCommand);
		ndr->depth++;
		ndr_print_int32(ndr, "pdwFailedCommand", *r->out.pdwFailedCommand);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CreateBatchPort(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CreateBatchPort *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
	}
	if (flags & NDR_OUT) {
		if (r->out.phBatchPort == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.phBatchPort));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CreateBatchPort(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CreateBatchPort *r)
{
	TALLOC_CTX *_mem_save_phBatchPort_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_PULL_ALLOC(ndr, r->out.phBatchPort);
		NDR_ZERO_STRUCTP(r->out.phBatchPort);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.phBatchPort);
		}
		_mem_save_phBatchPort_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.phBatchPort, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.phBatchPort));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_phBatchPort_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CreateBatchPort(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CreateBatchPort *r)
{
	ndr_print_struct(ndr, name, "clusapi_CreateBatchPort");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CreateBatchPort");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hKey", &r->in.hKey);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CreateBatchPort");
		ndr->depth++;
		ndr_print_ptr(ndr, "phBatchPort", r->out.phBatchPort);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "phBatchPort", r->out.phBatchPort);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_GetBatchNotification(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_GetBatchNotification *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hBatchNotify));
	}
	if (flags & NDR_OUT) {
		if (r->out.cbData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.cbData));
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.lpData));
		if (*r->out.lpData) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.cbData));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, *r->out.lpData, *r->out.cbData));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GetBatchNotification(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_GetBatchNotification *r)
{
	uint32_t _ptr_lpData;
	uint32_t size_lpData_2 = 0;
	TALLOC_CTX *_mem_save_cbData_0 = NULL;
	TALLOC_CTX *_mem_save_lpData_0 = NULL;
	TALLOC_CTX *_mem_save_lpData_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hBatchNotify));
		NDR_PULL_ALLOC(ndr, r->out.cbData);
		NDR_ZERO_STRUCTP(r->out.cbData);
		NDR_PULL_ALLOC(ndr, r->out.lpData);
		NDR_ZERO_STRUCTP(r->out.lpData);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.cbData);
		}
		_mem_save_cbData_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.cbData, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.cbData));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_cbData_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpData);
		}
		_mem_save_lpData_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpData, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpData));
		if (_ptr_lpData) {
			NDR_PULL_ALLOC(ndr, *r->out.lpData);
		} else {
			*r->out.lpData = NULL;
		}
		if (*r->out.lpData) {
			_mem_save_lpData_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.lpData, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.lpData));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)r->out.lpData, &size_lpData_2));
			NDR_PULL_ALLOC_N(ndr, *r->out.lpData, size_lpData_2);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, *r->out.lpData, size_lpData_2));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpData_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpData_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (*r->out.lpData) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)r->out.lpData, *r->out.cbData));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GetBatchNotification(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_GetBatchNotification *r)
{
	ndr_print_struct(ndr, name, "clusapi_GetBatchNotification");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_GetBatchNotification");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hBatchNotify", &r->in.hBatchNotify);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_GetBatchNotification");
		ndr->depth++;
		ndr_print_ptr(ndr, "cbData", r->out.cbData);
		ndr->depth++;
		ndr_print_uint32(ndr, "cbData", *r->out.cbData);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpData", r->out.lpData);
		ndr->depth++;
		ndr_print_ptr(ndr, "lpData", *r->out.lpData);
		ndr->depth++;
		if (*r->out.lpData) {
			ndr_print_array_uint8(ndr, "lpData", *r->out.lpData, *r->out.cbData);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CloseBatchPort(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CloseBatchPort *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.phBatchPort == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.phBatchPort));
	}
	if (flags & NDR_OUT) {
		if (r->out.phBatchPort == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.phBatchPort));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CloseBatchPort(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CloseBatchPort *r)
{
	TALLOC_CTX *_mem_save_phBatchPort_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.phBatchPort);
		}
		_mem_save_phBatchPort_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.phBatchPort, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.phBatchPort));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_phBatchPort_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.phBatchPort);
		*r->out.phBatchPort = *r->in.phBatchPort;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.phBatchPort == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.phBatchPort);
			NDR_ZERO_STRUCTP(r->in.phBatchPort);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.phBatchPort);
		}
		_mem_save_phBatchPort_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.phBatchPort, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.phBatchPort));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_phBatchPort_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CloseBatchPort(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CloseBatchPort *r)
{
	ndr_print_struct(ndr, name, "clusapi_CloseBatchPort");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CloseBatchPort");
		ndr->depth++;
		ndr_print_ptr(ndr, "phBatchPort", r->in.phBatchPort);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "phBatchPort", r->in.phBatchPort);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CloseBatchPort");
		ndr->depth++;
		ndr_print_ptr(ndr, "phBatchPort", r->out.phBatchPort);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "phBatchPort", r->out.phBatchPort);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_OpenClusterEx(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_OpenClusterEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_clusapi_DesiredAccessMask(ndr, NDR_SCALARS, r->in.dwDesiredAccess));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpdwGrantedAccess == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.Status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.hCluster == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpdwGrantedAccess));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.Status));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.hCluster));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_OpenClusterEx(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_OpenClusterEx *r)
{
	TALLOC_CTX *_mem_save_lpdwGrantedAccess_0 = NULL;
	TALLOC_CTX *_mem_save_Status_0 = NULL;
	TALLOC_CTX *_mem_save_hCluster_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_clusapi_DesiredAccessMask(ndr, NDR_SCALARS, &r->in.dwDesiredAccess));
		NDR_PULL_ALLOC(ndr, r->out.lpdwGrantedAccess);
		NDR_ZERO_STRUCTP(r->out.lpdwGrantedAccess);
		NDR_PULL_ALLOC(ndr, r->out.Status);
		NDR_ZERO_STRUCTP(r->out.Status);
		NDR_PULL_ALLOC(ndr, r->out.hCluster);
		NDR_ZERO_STRUCTP(r->out.hCluster);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpdwGrantedAccess);
		}
		_mem_save_lpdwGrantedAccess_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpdwGrantedAccess, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpdwGrantedAccess));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpdwGrantedAccess_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Status);
		}
		_mem_save_Status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.Status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.hCluster);
		}
		_mem_save_hCluster_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.hCluster, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.hCluster));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hCluster_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_OpenClusterEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_OpenClusterEx *r)
{
	ndr_print_struct(ndr, name, "clusapi_OpenClusterEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_OpenClusterEx");
		ndr->depth++;
		ndr_print_clusapi_DesiredAccessMask(ndr, "dwDesiredAccess", r->in.dwDesiredAccess);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_OpenClusterEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpdwGrantedAccess", r->out.lpdwGrantedAccess);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpdwGrantedAccess", *r->out.lpdwGrantedAccess);
		ndr->depth--;
		ndr_print_ptr(ndr, "Status", r->out.Status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "Status", *r->out.Status);
		ndr->depth--;
		ndr_print_ptr(ndr, "hCluster", r->out.hCluster);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hCluster", r->out.hCluster);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_OpenNodeEx(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_OpenNodeEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszNodeName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszNodeName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszNodeName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszNodeName, ndr_charset_length(r->in.lpszNodeName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_clusapi_DesiredAccessMask(ndr, NDR_SCALARS, r->in.dwDesiredAccess));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpdwGrantedAccess == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.Status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.hNode == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpdwGrantedAccess));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.Status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.hNode));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_OpenNodeEx(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_OpenNodeEx *r)
{
	uint32_t size_lpszNodeName_1 = 0;
	uint32_t length_lpszNodeName_1 = 0;
	TALLOC_CTX *_mem_save_lpdwGrantedAccess_0 = NULL;
	TALLOC_CTX *_mem_save_Status_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	TALLOC_CTX *_mem_save_hNode_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszNodeName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszNodeName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszNodeName, &size_lpszNodeName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszNodeName, &length_lpszNodeName_1));
		if (length_lpszNodeName_1 > size_lpszNodeName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszNodeName_1, length_lpszNodeName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszNodeName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszNodeName, length_lpszNodeName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_clusapi_DesiredAccessMask(ndr, NDR_SCALARS, &r->in.dwDesiredAccess));
		NDR_PULL_ALLOC(ndr, r->out.lpdwGrantedAccess);
		NDR_ZERO_STRUCTP(r->out.lpdwGrantedAccess);
		NDR_PULL_ALLOC(ndr, r->out.Status);
		NDR_ZERO_STRUCTP(r->out.Status);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		NDR_PULL_ALLOC(ndr, r->out.hNode);
		NDR_ZERO_STRUCTP(r->out.hNode);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpdwGrantedAccess);
		}
		_mem_save_lpdwGrantedAccess_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpdwGrantedAccess, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpdwGrantedAccess));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpdwGrantedAccess_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Status);
		}
		_mem_save_Status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.Status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.hNode);
		}
		_mem_save_hNode_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.hNode, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.hNode));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hNode_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_OpenNodeEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_OpenNodeEx *r)
{
	ndr_print_struct(ndr, name, "clusapi_OpenNodeEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_OpenNodeEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszNodeName", r->in.lpszNodeName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszNodeName", r->in.lpszNodeName);
		ndr->depth--;
		ndr_print_clusapi_DesiredAccessMask(ndr, "dwDesiredAccess", r->in.dwDesiredAccess);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_OpenNodeEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpdwGrantedAccess", r->out.lpdwGrantedAccess);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpdwGrantedAccess", *r->out.lpdwGrantedAccess);
		ndr->depth--;
		ndr_print_ptr(ndr, "Status", r->out.Status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "Status", *r->out.Status);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_ptr(ndr, "hNode", r->out.hNode);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNode", r->out.hNode);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_OpenGroupEx(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_OpenGroupEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszGroupName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszGroupName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszGroupName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszGroupName, ndr_charset_length(r->in.lpszGroupName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_clusapi_DesiredAccessMask(ndr, NDR_SCALARS, r->in.dwDesiredAccess));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpdwGrantedAccess == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.Status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.hGroup == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpdwGrantedAccess));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.Status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.hGroup));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_OpenGroupEx(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_OpenGroupEx *r)
{
	uint32_t size_lpszGroupName_1 = 0;
	uint32_t length_lpszGroupName_1 = 0;
	TALLOC_CTX *_mem_save_lpdwGrantedAccess_0 = NULL;
	TALLOC_CTX *_mem_save_Status_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	TALLOC_CTX *_mem_save_hGroup_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszGroupName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszGroupName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszGroupName, &size_lpszGroupName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszGroupName, &length_lpszGroupName_1));
		if (length_lpszGroupName_1 > size_lpszGroupName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszGroupName_1, length_lpszGroupName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszGroupName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszGroupName, length_lpszGroupName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_clusapi_DesiredAccessMask(ndr, NDR_SCALARS, &r->in.dwDesiredAccess));
		NDR_PULL_ALLOC(ndr, r->out.lpdwGrantedAccess);
		NDR_ZERO_STRUCTP(r->out.lpdwGrantedAccess);
		NDR_PULL_ALLOC(ndr, r->out.Status);
		NDR_ZERO_STRUCTP(r->out.Status);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		NDR_PULL_ALLOC(ndr, r->out.hGroup);
		NDR_ZERO_STRUCTP(r->out.hGroup);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpdwGrantedAccess);
		}
		_mem_save_lpdwGrantedAccess_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpdwGrantedAccess, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpdwGrantedAccess));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpdwGrantedAccess_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Status);
		}
		_mem_save_Status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.Status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.hGroup);
		}
		_mem_save_hGroup_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.hGroup, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.hGroup));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hGroup_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_OpenGroupEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_OpenGroupEx *r)
{
	ndr_print_struct(ndr, name, "clusapi_OpenGroupEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_OpenGroupEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszGroupName", r->in.lpszGroupName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszGroupName", r->in.lpszGroupName);
		ndr->depth--;
		ndr_print_clusapi_DesiredAccessMask(ndr, "dwDesiredAccess", r->in.dwDesiredAccess);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_OpenGroupEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpdwGrantedAccess", r->out.lpdwGrantedAccess);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpdwGrantedAccess", *r->out.lpdwGrantedAccess);
		ndr->depth--;
		ndr_print_ptr(ndr, "Status", r->out.Status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "Status", *r->out.Status);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_ptr(ndr, "hGroup", r->out.hGroup);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroup", r->out.hGroup);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_OpenResourceEx(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_OpenResourceEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszResourceName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszResourceName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszResourceName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszResourceName, ndr_charset_length(r->in.lpszResourceName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_clusapi_DesiredAccessMask(ndr, NDR_SCALARS, r->in.dwDesiredAccess));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpdwGrantedAccess == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.Status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.hResource == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpdwGrantedAccess));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.Status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.hResource));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_OpenResourceEx(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_OpenResourceEx *r)
{
	uint32_t size_lpszResourceName_1 = 0;
	uint32_t length_lpszResourceName_1 = 0;
	TALLOC_CTX *_mem_save_lpdwGrantedAccess_0 = NULL;
	TALLOC_CTX *_mem_save_Status_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	TALLOC_CTX *_mem_save_hResource_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszResourceName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszResourceName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszResourceName, &size_lpszResourceName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszResourceName, &length_lpszResourceName_1));
		if (length_lpszResourceName_1 > size_lpszResourceName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszResourceName_1, length_lpszResourceName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszResourceName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszResourceName, length_lpszResourceName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_clusapi_DesiredAccessMask(ndr, NDR_SCALARS, &r->in.dwDesiredAccess));
		NDR_PULL_ALLOC(ndr, r->out.lpdwGrantedAccess);
		NDR_ZERO_STRUCTP(r->out.lpdwGrantedAccess);
		NDR_PULL_ALLOC(ndr, r->out.Status);
		NDR_ZERO_STRUCTP(r->out.Status);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		NDR_PULL_ALLOC(ndr, r->out.hResource);
		NDR_ZERO_STRUCTP(r->out.hResource);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpdwGrantedAccess);
		}
		_mem_save_lpdwGrantedAccess_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpdwGrantedAccess, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpdwGrantedAccess));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpdwGrantedAccess_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Status);
		}
		_mem_save_Status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.Status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.hResource);
		}
		_mem_save_hResource_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.hResource, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.hResource));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hResource_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_OpenResourceEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_OpenResourceEx *r)
{
	ndr_print_struct(ndr, name, "clusapi_OpenResourceEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_OpenResourceEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszResourceName", r->in.lpszResourceName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszResourceName", r->in.lpszResourceName);
		ndr->depth--;
		ndr_print_clusapi_DesiredAccessMask(ndr, "dwDesiredAccess", r->in.dwDesiredAccess);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_OpenResourceEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpdwGrantedAccess", r->out.lpdwGrantedAccess);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpdwGrantedAccess", *r->out.lpdwGrantedAccess);
		ndr->depth--;
		ndr_print_ptr(ndr, "Status", r->out.Status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "Status", *r->out.Status);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_ptr(ndr, "hResource", r->out.hResource);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", r->out.hResource);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_OpenNetworkEx(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_OpenNetworkEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszNetworkName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszNetworkName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszNetworkName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszNetworkName, ndr_charset_length(r->in.lpszNetworkName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_clusapi_DesiredAccessMask(ndr, NDR_SCALARS, r->in.dwDesiredAccess));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpdwGrantedAccess == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.Status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.hNetwork == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpdwGrantedAccess));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.Status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.hNetwork));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_OpenNetworkEx(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_OpenNetworkEx *r)
{
	uint32_t size_lpszNetworkName_1 = 0;
	uint32_t length_lpszNetworkName_1 = 0;
	TALLOC_CTX *_mem_save_lpdwGrantedAccess_0 = NULL;
	TALLOC_CTX *_mem_save_Status_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	TALLOC_CTX *_mem_save_hNetwork_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszNetworkName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszNetworkName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszNetworkName, &size_lpszNetworkName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszNetworkName, &length_lpszNetworkName_1));
		if (length_lpszNetworkName_1 > size_lpszNetworkName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszNetworkName_1, length_lpszNetworkName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszNetworkName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszNetworkName, length_lpszNetworkName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_clusapi_DesiredAccessMask(ndr, NDR_SCALARS, &r->in.dwDesiredAccess));
		NDR_PULL_ALLOC(ndr, r->out.lpdwGrantedAccess);
		NDR_ZERO_STRUCTP(r->out.lpdwGrantedAccess);
		NDR_PULL_ALLOC(ndr, r->out.Status);
		NDR_ZERO_STRUCTP(r->out.Status);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		NDR_PULL_ALLOC(ndr, r->out.hNetwork);
		NDR_ZERO_STRUCTP(r->out.hNetwork);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpdwGrantedAccess);
		}
		_mem_save_lpdwGrantedAccess_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpdwGrantedAccess, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpdwGrantedAccess));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpdwGrantedAccess_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Status);
		}
		_mem_save_Status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.Status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.hNetwork);
		}
		_mem_save_hNetwork_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.hNetwork, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.hNetwork));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hNetwork_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_OpenNetworkEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_OpenNetworkEx *r)
{
	ndr_print_struct(ndr, name, "clusapi_OpenNetworkEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_OpenNetworkEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszNetworkName", r->in.lpszNetworkName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszNetworkName", r->in.lpszNetworkName);
		ndr->depth--;
		ndr_print_clusapi_DesiredAccessMask(ndr, "dwDesiredAccess", r->in.dwDesiredAccess);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_OpenNetworkEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpdwGrantedAccess", r->out.lpdwGrantedAccess);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpdwGrantedAccess", *r->out.lpdwGrantedAccess);
		ndr->depth--;
		ndr_print_ptr(ndr, "Status", r->out.Status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "Status", *r->out.Status);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_ptr(ndr, "hNetwork", r->out.hNetwork);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNetwork", r->out.hNetwork);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_OpenNetInterfaceEx(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_OpenNetInterfaceEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszNetInterfaceName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszNetInterfaceName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszNetInterfaceName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszNetInterfaceName, ndr_charset_length(r->in.lpszNetInterfaceName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_clusapi_DesiredAccessMask(ndr, NDR_SCALARS, r->in.dwDesiredAccess));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpdwGrantedAccess == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.Status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.hNetInterface == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpdwGrantedAccess));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.Status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.hNetInterface));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_OpenNetInterfaceEx(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_OpenNetInterfaceEx *r)
{
	uint32_t size_lpszNetInterfaceName_1 = 0;
	uint32_t length_lpszNetInterfaceName_1 = 0;
	TALLOC_CTX *_mem_save_lpdwGrantedAccess_0 = NULL;
	TALLOC_CTX *_mem_save_Status_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	TALLOC_CTX *_mem_save_hNetInterface_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszNetInterfaceName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszNetInterfaceName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszNetInterfaceName, &size_lpszNetInterfaceName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszNetInterfaceName, &length_lpszNetInterfaceName_1));
		if (length_lpszNetInterfaceName_1 > size_lpszNetInterfaceName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszNetInterfaceName_1, length_lpszNetInterfaceName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszNetInterfaceName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszNetInterfaceName, length_lpszNetInterfaceName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_clusapi_DesiredAccessMask(ndr, NDR_SCALARS, &r->in.dwDesiredAccess));
		NDR_PULL_ALLOC(ndr, r->out.lpdwGrantedAccess);
		NDR_ZERO_STRUCTP(r->out.lpdwGrantedAccess);
		NDR_PULL_ALLOC(ndr, r->out.Status);
		NDR_ZERO_STRUCTP(r->out.Status);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		NDR_PULL_ALLOC(ndr, r->out.hNetInterface);
		NDR_ZERO_STRUCTP(r->out.hNetInterface);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpdwGrantedAccess);
		}
		_mem_save_lpdwGrantedAccess_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpdwGrantedAccess, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpdwGrantedAccess));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpdwGrantedAccess_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Status);
		}
		_mem_save_Status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.Status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.hNetInterface);
		}
		_mem_save_hNetInterface_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.hNetInterface, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.hNetInterface));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hNetInterface_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_OpenNetInterfaceEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_OpenNetInterfaceEx *r)
{
	ndr_print_struct(ndr, name, "clusapi_OpenNetInterfaceEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_OpenNetInterfaceEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszNetInterfaceName", r->in.lpszNetInterfaceName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszNetInterfaceName", r->in.lpszNetInterfaceName);
		ndr->depth--;
		ndr_print_clusapi_DesiredAccessMask(ndr, "dwDesiredAccess", r->in.dwDesiredAccess);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_OpenNetInterfaceEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpdwGrantedAccess", r->out.lpdwGrantedAccess);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpdwGrantedAccess", *r->out.lpdwGrantedAccess);
		ndr->depth--;
		ndr_print_ptr(ndr, "Status", r->out.Status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "Status", *r->out.Status);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_ptr(ndr, "hNetInterface", r->out.hNetInterface);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNetInterface", r->out.hNetInterface);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_ChangeCsvState(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_ChangeCsvState *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwState));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_ChangeCsvState(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_ChangeCsvState *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwState));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_ChangeCsvState(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_ChangeCsvState *r)
{
	ndr_print_struct(ndr, name, "clusapi_ChangeCsvState");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_ChangeCsvState");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr_print_uint32(ndr, "dwState", r->in.dwState);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_ChangeCsvState");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CreateNodeEnumEx(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CreateNodeEnumEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwType));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwOptions));
	}
	if (flags & NDR_OUT) {
		if (r->out.ReturnIdEnum == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.ReturnNameEnum == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ReturnIdEnum));
		if (*r->out.ReturnIdEnum) {
			NDR_CHECK(ndr_push_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ReturnIdEnum));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ReturnNameEnum));
		if (*r->out.ReturnNameEnum) {
			NDR_CHECK(ndr_push_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ReturnNameEnum));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CreateNodeEnumEx(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CreateNodeEnumEx *r)
{
	uint32_t _ptr_ReturnIdEnum;
	uint32_t _ptr_ReturnNameEnum;
	TALLOC_CTX *_mem_save_ReturnIdEnum_0 = NULL;
	TALLOC_CTX *_mem_save_ReturnIdEnum_1 = NULL;
	TALLOC_CTX *_mem_save_ReturnNameEnum_0 = NULL;
	TALLOC_CTX *_mem_save_ReturnNameEnum_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwType));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwOptions));
		NDR_PULL_ALLOC(ndr, r->out.ReturnIdEnum);
		NDR_ZERO_STRUCTP(r->out.ReturnIdEnum);
		NDR_PULL_ALLOC(ndr, r->out.ReturnNameEnum);
		NDR_ZERO_STRUCTP(r->out.ReturnNameEnum);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ReturnIdEnum);
		}
		_mem_save_ReturnIdEnum_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ReturnIdEnum, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ReturnIdEnum));
		if (_ptr_ReturnIdEnum) {
			NDR_PULL_ALLOC(ndr, *r->out.ReturnIdEnum);
		} else {
			*r->out.ReturnIdEnum = NULL;
		}
		if (*r->out.ReturnIdEnum) {
			_mem_save_ReturnIdEnum_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ReturnIdEnum, 0);
			NDR_CHECK(ndr_pull_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ReturnIdEnum));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReturnIdEnum_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReturnIdEnum_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ReturnNameEnum);
		}
		_mem_save_ReturnNameEnum_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ReturnNameEnum, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ReturnNameEnum));
		if (_ptr_ReturnNameEnum) {
			NDR_PULL_ALLOC(ndr, *r->out.ReturnNameEnum);
		} else {
			*r->out.ReturnNameEnum = NULL;
		}
		if (*r->out.ReturnNameEnum) {
			_mem_save_ReturnNameEnum_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ReturnNameEnum, 0);
			NDR_CHECK(ndr_pull_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ReturnNameEnum));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReturnNameEnum_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReturnNameEnum_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CreateNodeEnumEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CreateNodeEnumEx *r)
{
	ndr_print_struct(ndr, name, "clusapi_CreateNodeEnumEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CreateNodeEnumEx");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNode", &r->in.hNode);
		ndr_print_uint32(ndr, "dwType", r->in.dwType);
		ndr_print_uint32(ndr, "dwOptions", r->in.dwOptions);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CreateNodeEnumEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "ReturnIdEnum", r->out.ReturnIdEnum);
		ndr->depth++;
		ndr_print_ptr(ndr, "ReturnIdEnum", *r->out.ReturnIdEnum);
		ndr->depth++;
		if (*r->out.ReturnIdEnum) {
			ndr_print_ENUM_LIST(ndr, "ReturnIdEnum", *r->out.ReturnIdEnum);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "ReturnNameEnum", r->out.ReturnNameEnum);
		ndr->depth++;
		ndr_print_ptr(ndr, "ReturnNameEnum", *r->out.ReturnNameEnum);
		ndr->depth++;
		if (*r->out.ReturnNameEnum) {
			ndr_print_ENUM_LIST(ndr, "ReturnNameEnum", *r->out.ReturnNameEnum);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CreateEnumEx(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CreateEnumEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hCluster));
		NDR_CHECK(ndr_push_ClusterEnumType(ndr, NDR_SCALARS, r->in.dwType));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwOptions));
	}
	if (flags & NDR_OUT) {
		if (r->out.ReturnIdEnum == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.ReturnNameEnum == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ReturnIdEnum));
		if (*r->out.ReturnIdEnum) {
			NDR_CHECK(ndr_push_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ReturnIdEnum));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ReturnNameEnum));
		if (*r->out.ReturnNameEnum) {
			NDR_CHECK(ndr_push_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ReturnNameEnum));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CreateEnumEx(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CreateEnumEx *r)
{
	uint32_t _ptr_ReturnIdEnum;
	uint32_t _ptr_ReturnNameEnum;
	TALLOC_CTX *_mem_save_ReturnIdEnum_0 = NULL;
	TALLOC_CTX *_mem_save_ReturnIdEnum_1 = NULL;
	TALLOC_CTX *_mem_save_ReturnNameEnum_0 = NULL;
	TALLOC_CTX *_mem_save_ReturnNameEnum_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hCluster));
		NDR_CHECK(ndr_pull_ClusterEnumType(ndr, NDR_SCALARS, &r->in.dwType));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwOptions));
		NDR_PULL_ALLOC(ndr, r->out.ReturnIdEnum);
		NDR_ZERO_STRUCTP(r->out.ReturnIdEnum);
		NDR_PULL_ALLOC(ndr, r->out.ReturnNameEnum);
		NDR_ZERO_STRUCTP(r->out.ReturnNameEnum);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ReturnIdEnum);
		}
		_mem_save_ReturnIdEnum_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ReturnIdEnum, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ReturnIdEnum));
		if (_ptr_ReturnIdEnum) {
			NDR_PULL_ALLOC(ndr, *r->out.ReturnIdEnum);
		} else {
			*r->out.ReturnIdEnum = NULL;
		}
		if (*r->out.ReturnIdEnum) {
			_mem_save_ReturnIdEnum_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ReturnIdEnum, 0);
			NDR_CHECK(ndr_pull_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ReturnIdEnum));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReturnIdEnum_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReturnIdEnum_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ReturnNameEnum);
		}
		_mem_save_ReturnNameEnum_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ReturnNameEnum, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ReturnNameEnum));
		if (_ptr_ReturnNameEnum) {
			NDR_PULL_ALLOC(ndr, *r->out.ReturnNameEnum);
		} else {
			*r->out.ReturnNameEnum = NULL;
		}
		if (*r->out.ReturnNameEnum) {
			_mem_save_ReturnNameEnum_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ReturnNameEnum, 0);
			NDR_CHECK(ndr_pull_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ReturnNameEnum));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReturnNameEnum_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReturnNameEnum_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CreateEnumEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CreateEnumEx *r)
{
	ndr_print_struct(ndr, name, "clusapi_CreateEnumEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CreateEnumEx");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hCluster", &r->in.hCluster);
		ndr_print_ClusterEnumType(ndr, "dwType", r->in.dwType);
		ndr_print_uint32(ndr, "dwOptions", r->in.dwOptions);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CreateEnumEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "ReturnIdEnum", r->out.ReturnIdEnum);
		ndr->depth++;
		ndr_print_ptr(ndr, "ReturnIdEnum", *r->out.ReturnIdEnum);
		ndr->depth++;
		if (*r->out.ReturnIdEnum) {
			ndr_print_ENUM_LIST(ndr, "ReturnIdEnum", *r->out.ReturnIdEnum);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "ReturnNameEnum", r->out.ReturnNameEnum);
		ndr->depth++;
		ndr_print_ptr(ndr, "ReturnNameEnum", *r->out.ReturnNameEnum);
		ndr->depth++;
		if (*r->out.ReturnNameEnum) {
			ndr_print_ENUM_LIST(ndr, "ReturnNameEnum", *r->out.ReturnNameEnum);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_PauseNodeEx(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_PauseNodeEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->in.bDrainNode));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwPauseFlags));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_PauseNodeEx(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_PauseNodeEx *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->in.bDrainNode));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwPauseFlags));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_PauseNodeEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_PauseNodeEx *r)
{
	ndr_print_struct(ndr, name, "clusapi_PauseNodeEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_PauseNodeEx");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNode", &r->in.hNode);
		ndr_print_uint8(ndr, "bDrainNode", r->in.bDrainNode);
		ndr_print_uint32(ndr, "dwPauseFlags", r->in.dwPauseFlags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_PauseNodeEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_PauseNodeWithDrainTarget(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_PauseNodeWithDrainTarget *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwPauseFlags));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNodeDrainTarget));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_PauseNodeWithDrainTarget(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_PauseNodeWithDrainTarget *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwPauseFlags));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNodeDrainTarget));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_PauseNodeWithDrainTarget(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_PauseNodeWithDrainTarget *r)
{
	ndr_print_struct(ndr, name, "clusapi_PauseNodeWithDrainTarget");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_PauseNodeWithDrainTarget");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNode", &r->in.hNode);
		ndr_print_uint32(ndr, "dwPauseFlags", r->in.dwPauseFlags);
		ndr_print_policy_handle(ndr, "hNodeDrainTarget", &r->in.hNodeDrainTarget);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_PauseNodeWithDrainTarget");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_ResumeNodeEx(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_ResumeNodeEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwResumeFailbackType));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwResumeFlagsReserved));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_ResumeNodeEx(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_ResumeNodeEx *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwResumeFailbackType));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwResumeFlagsReserved));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_ResumeNodeEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_ResumeNodeEx *r)
{
	ndr_print_struct(ndr, name, "clusapi_ResumeNodeEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_ResumeNodeEx");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNode", &r->in.hNode);
		ndr_print_uint32(ndr, "dwResumeFailbackType", r->in.dwResumeFailbackType);
		ndr_print_uint32(ndr, "dwResumeFlagsReserved", r->in.dwResumeFlagsReserved);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_ResumeNodeEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CreateGroupEx(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CreateGroupEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszGroupName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszGroupName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszGroupName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszGroupName, ndr_charset_length(r->in.lpszGroupName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pGroupInfo));
		if (r->in.pGroupInfo) {
			NDR_CHECK(ndr_push_CLUSTER_CREATE_GROUP_INFO_RPC(ndr, NDR_SCALARS, r->in.pGroupInfo));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.Status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.hGroup == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.Status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.hGroup));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CreateGroupEx(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CreateGroupEx *r)
{
	uint32_t size_lpszGroupName_1 = 0;
	uint32_t length_lpszGroupName_1 = 0;
	uint32_t _ptr_pGroupInfo;
	TALLOC_CTX *_mem_save_pGroupInfo_0 = NULL;
	TALLOC_CTX *_mem_save_Status_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	TALLOC_CTX *_mem_save_hGroup_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszGroupName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszGroupName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszGroupName, &size_lpszGroupName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszGroupName, &length_lpszGroupName_1));
		if (length_lpszGroupName_1 > size_lpszGroupName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszGroupName_1, length_lpszGroupName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszGroupName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszGroupName, length_lpszGroupName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pGroupInfo));
		if (_ptr_pGroupInfo) {
			NDR_PULL_ALLOC(ndr, r->in.pGroupInfo);
		} else {
			r->in.pGroupInfo = NULL;
		}
		if (r->in.pGroupInfo) {
			_mem_save_pGroupInfo_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pGroupInfo, 0);
			NDR_CHECK(ndr_pull_CLUSTER_CREATE_GROUP_INFO_RPC(ndr, NDR_SCALARS, r->in.pGroupInfo));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pGroupInfo_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.Status);
		NDR_ZERO_STRUCTP(r->out.Status);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		NDR_PULL_ALLOC(ndr, r->out.hGroup);
		NDR_ZERO_STRUCTP(r->out.hGroup);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Status);
		}
		_mem_save_Status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.Status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.hGroup);
		}
		_mem_save_hGroup_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.hGroup, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.hGroup));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hGroup_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CreateGroupEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CreateGroupEx *r)
{
	ndr_print_struct(ndr, name, "clusapi_CreateGroupEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CreateGroupEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszGroupName", r->in.lpszGroupName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszGroupName", r->in.lpszGroupName);
		ndr->depth--;
		ndr_print_ptr(ndr, "pGroupInfo", r->in.pGroupInfo);
		ndr->depth++;
		if (r->in.pGroupInfo) {
			ndr_print_CLUSTER_CREATE_GROUP_INFO_RPC(ndr, "pGroupInfo", r->in.pGroupInfo);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CreateGroupEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "Status", r->out.Status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "Status", *r->out.Status);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_ptr(ndr, "hGroup", r->out.hGroup);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroup", r->out.hGroup);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_OnlineGroupEx(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_OnlineGroupEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpInBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwOnlineFlags));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbInBufferSize));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, r->in.cbInBufferSize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbInBufferSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_OnlineGroupEx(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_OnlineGroupEx *r)
{
	uint32_t size_lpInBuffer_1 = 0;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwOnlineFlags));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpInBuffer));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpInBuffer, &size_lpInBuffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.lpInBuffer, size_lpInBuffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, size_lpInBuffer_1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbInBufferSize));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpInBuffer, r->in.cbInBufferSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_OnlineGroupEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_OnlineGroupEx *r)
{
	ndr_print_struct(ndr, name, "clusapi_OnlineGroupEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_OnlineGroupEx");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroup", &r->in.hGroup);
		ndr_print_uint32(ndr, "dwOnlineFlags", r->in.dwOnlineFlags);
		ndr_print_ptr(ndr, "lpInBuffer", r->in.lpInBuffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpInBuffer", r->in.lpInBuffer, r->in.cbInBufferSize);
		ndr->depth--;
		ndr_print_uint32(ndr, "cbInBufferSize", r->in.cbInBufferSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_OnlineGroupEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_OfflineGroupEx(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_OfflineGroupEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpInBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwOfflineFlags));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbInBufferSize));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, r->in.cbInBufferSize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbInBufferSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_OfflineGroupEx(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_OfflineGroupEx *r)
{
	uint32_t size_lpInBuffer_1 = 0;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwOfflineFlags));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpInBuffer));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpInBuffer, &size_lpInBuffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.lpInBuffer, size_lpInBuffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, size_lpInBuffer_1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbInBufferSize));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpInBuffer, r->in.cbInBufferSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_OfflineGroupEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_OfflineGroupEx *r)
{
	ndr_print_struct(ndr, name, "clusapi_OfflineGroupEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_OfflineGroupEx");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroup", &r->in.hGroup);
		ndr_print_uint32(ndr, "dwOfflineFlags", r->in.dwOfflineFlags);
		ndr_print_ptr(ndr, "lpInBuffer", r->in.lpInBuffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpInBuffer", r->in.lpInBuffer, r->in.cbInBufferSize);
		ndr->depth--;
		ndr_print_uint32(ndr, "cbInBufferSize", r->in.cbInBufferSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_OfflineGroupEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_MoveGroupEx(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_MoveGroupEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpInBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwMoveFlags));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbInBufferSize));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, r->in.cbInBufferSize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbInBufferSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_MoveGroupEx(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_MoveGroupEx *r)
{
	uint32_t size_lpInBuffer_1 = 0;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwMoveFlags));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpInBuffer));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpInBuffer, &size_lpInBuffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.lpInBuffer, size_lpInBuffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, size_lpInBuffer_1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbInBufferSize));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpInBuffer, r->in.cbInBufferSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_MoveGroupEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_MoveGroupEx *r)
{
	ndr_print_struct(ndr, name, "clusapi_MoveGroupEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_MoveGroupEx");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroup", &r->in.hGroup);
		ndr_print_uint32(ndr, "dwMoveFlags", r->in.dwMoveFlags);
		ndr_print_ptr(ndr, "lpInBuffer", r->in.lpInBuffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpInBuffer", r->in.lpInBuffer, r->in.cbInBufferSize);
		ndr->depth--;
		ndr_print_uint32(ndr, "cbInBufferSize", r->in.cbInBufferSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_MoveGroupEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_MoveGroupToNodeEx(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_MoveGroupToNodeEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpInBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwMoveFlags));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbInBufferSize));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, r->in.cbInBufferSize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbInBufferSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_MoveGroupToNodeEx(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_MoveGroupToNodeEx *r)
{
	uint32_t size_lpInBuffer_1 = 0;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwMoveFlags));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpInBuffer));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpInBuffer, &size_lpInBuffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.lpInBuffer, size_lpInBuffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, size_lpInBuffer_1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbInBufferSize));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpInBuffer, r->in.cbInBufferSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_MoveGroupToNodeEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_MoveGroupToNodeEx *r)
{
	ndr_print_struct(ndr, name, "clusapi_MoveGroupToNodeEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_MoveGroupToNodeEx");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroup", &r->in.hGroup);
		ndr_print_policy_handle(ndr, "hNode", &r->in.hNode);
		ndr_print_uint32(ndr, "dwMoveFlags", r->in.dwMoveFlags);
		ndr_print_ptr(ndr, "lpInBuffer", r->in.lpInBuffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpInBuffer", r->in.lpInBuffer, r->in.cbInBufferSize);
		ndr->depth--;
		ndr_print_uint32(ndr, "cbInBufferSize", r->in.cbInBufferSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_MoveGroupToNodeEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CancelClusterGroupOperation(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CancelClusterGroupOperation *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwCancelFlags));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CancelClusterGroupOperation(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CancelClusterGroupOperation *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwCancelFlags));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CancelClusterGroupOperation(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CancelClusterGroupOperation *r)
{
	ndr_print_struct(ndr, name, "clusapi_CancelClusterGroupOperation");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CancelClusterGroupOperation");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroup", &r->in.hGroup);
		ndr_print_uint32(ndr, "dwCancelFlags", r->in.dwCancelFlags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CancelClusterGroupOperation");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_OnlineResourceEx(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_OnlineResourceEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpInBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwOnlineFlags));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbInBufferSize));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, r->in.cbInBufferSize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbInBufferSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_OnlineResourceEx(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_OnlineResourceEx *r)
{
	uint32_t size_lpInBuffer_1 = 0;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwOnlineFlags));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpInBuffer));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpInBuffer, &size_lpInBuffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.lpInBuffer, size_lpInBuffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, size_lpInBuffer_1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbInBufferSize));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpInBuffer, r->in.cbInBufferSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_OnlineResourceEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_OnlineResourceEx *r)
{
	ndr_print_struct(ndr, name, "clusapi_OnlineResourceEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_OnlineResourceEx");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr_print_uint32(ndr, "dwOnlineFlags", r->in.dwOnlineFlags);
		ndr_print_ptr(ndr, "lpInBuffer", r->in.lpInBuffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpInBuffer", r->in.lpInBuffer, r->in.cbInBufferSize);
		ndr->depth--;
		ndr_print_uint32(ndr, "cbInBufferSize", r->in.cbInBufferSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_OnlineResourceEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_OfflineResourceEx(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_OfflineResourceEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpInBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwOfflineFlags));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbInBufferSize));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, r->in.cbInBufferSize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbInBufferSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_OfflineResourceEx(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_OfflineResourceEx *r)
{
	uint32_t size_lpInBuffer_1 = 0;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwOfflineFlags));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpInBuffer));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpInBuffer, &size_lpInBuffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.lpInBuffer, size_lpInBuffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, size_lpInBuffer_1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbInBufferSize));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpInBuffer, r->in.cbInBufferSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_OfflineResourceEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_OfflineResourceEx *r)
{
	ndr_print_struct(ndr, name, "clusapi_OfflineResourceEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_OfflineResourceEx");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr_print_uint32(ndr, "dwOfflineFlags", r->in.dwOfflineFlags);
		ndr_print_ptr(ndr, "lpInBuffer", r->in.lpInBuffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpInBuffer", r->in.lpInBuffer, r->in.cbInBufferSize);
		ndr->depth--;
		ndr_print_uint32(ndr, "cbInBufferSize", r->in.cbInBufferSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_OfflineResourceEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CreateNotifyV2(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CreateNotifyV2 *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_error == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.hNotify == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_error));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.hNotify));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CreateNotifyV2(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CreateNotifyV2 *r)
{
	TALLOC_CTX *_mem_save_rpc_error_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	TALLOC_CTX *_mem_save_hNotify_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.rpc_error);
		NDR_ZERO_STRUCTP(r->out.rpc_error);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		NDR_PULL_ALLOC(ndr, r->out.hNotify);
		NDR_ZERO_STRUCTP(r->out.hNotify);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_error);
		}
		_mem_save_rpc_error_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_error, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_error));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_error_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.hNotify);
		}
		_mem_save_hNotify_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.hNotify, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.hNotify));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hNotify_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CreateNotifyV2(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CreateNotifyV2 *r)
{
	ndr_print_struct(ndr, name, "clusapi_CreateNotifyV2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CreateNotifyV2");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CreateNotifyV2");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_error", r->out.rpc_error);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_error", *r->out.rpc_error);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_ptr(ndr, "hNotify", r->out.hNotify);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNotify", r->out.hNotify);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_AddNotifyV2(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_AddNotifyV2 *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hObject));
		NDR_CHECK(ndr_push_NOTIFY_FILTER_AND_TYPE_RPC(ndr, NDR_SCALARS, &r->in.filter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwNotifyKey));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwVersion));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->in.isTargetedAtObject));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_AddNotifyV2(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_AddNotifyV2 *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hObject));
		NDR_CHECK(ndr_pull_NOTIFY_FILTER_AND_TYPE_RPC(ndr, NDR_SCALARS, &r->in.filter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwNotifyKey));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwVersion));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->in.isTargetedAtObject));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_AddNotifyV2(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_AddNotifyV2 *r)
{
	ndr_print_struct(ndr, name, "clusapi_AddNotifyV2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_AddNotifyV2");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNotify", &r->in.hNotify);
		ndr_print_policy_handle(ndr, "hObject", &r->in.hObject);
		ndr_print_NOTIFY_FILTER_AND_TYPE_RPC(ndr, "filter", &r->in.filter);
		ndr_print_uint32(ndr, "dwNotifyKey", r->in.dwNotifyKey);
		ndr_print_uint32(ndr, "dwVersion", r->in.dwVersion);
		ndr_print_uint8(ndr, "isTargetedAtObject", r->in.isTargetedAtObject);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_AddNotifyV2");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_GetNotifyV2(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_GetNotifyV2 *r)
{
	uint32_t cntr_Notifications_2;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
	}
	if (flags & NDR_OUT) {
		if (r->out.Notifications == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.dwNumNotifications == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.Notifications));
		if (*r->out.Notifications) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.dwNumNotifications));
			for (cntr_Notifications_2 = 0; cntr_Notifications_2 < (*r->out.dwNumNotifications); cntr_Notifications_2++) {
				NDR_CHECK(ndr_push_NOTIFICATION_RPC(ndr, NDR_SCALARS, &(*r->out.Notifications)[cntr_Notifications_2]));
			}
			for (cntr_Notifications_2 = 0; cntr_Notifications_2 < (*r->out.dwNumNotifications); cntr_Notifications_2++) {
				NDR_CHECK(ndr_push_NOTIFICATION_RPC(ndr, NDR_BUFFERS, &(*r->out.Notifications)[cntr_Notifications_2]));
			}
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.dwNumNotifications));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GetNotifyV2(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_GetNotifyV2 *r)
{
	uint32_t _ptr_Notifications;
	uint32_t size_Notifications_2 = 0;
	uint32_t cntr_Notifications_2;
	TALLOC_CTX *_mem_save_Notifications_0 = NULL;
	TALLOC_CTX *_mem_save_Notifications_1 = NULL;
	TALLOC_CTX *_mem_save_Notifications_2 = NULL;
	TALLOC_CTX *_mem_save_dwNumNotifications_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_PULL_ALLOC(ndr, r->out.Notifications);
		NDR_ZERO_STRUCTP(r->out.Notifications);
		NDR_PULL_ALLOC(ndr, r->out.dwNumNotifications);
		NDR_ZERO_STRUCTP(r->out.dwNumNotifications);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Notifications);
		}
		_mem_save_Notifications_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Notifications, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Notifications));
		if (_ptr_Notifications) {
			NDR_PULL_ALLOC(ndr, *r->out.Notifications);
		} else {
			*r->out.Notifications = NULL;
		}
		if (*r->out.Notifications) {
			_mem_save_Notifications_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.Notifications, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.Notifications));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)r->out.Notifications, &size_Notifications_2));
			NDR_PULL_ALLOC_N(ndr, *r->out.Notifications, size_Notifications_2);
			_mem_save_Notifications_2 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.Notifications, 0);
			for (cntr_Notifications_2 = 0; cntr_Notifications_2 < (size_Notifications_2); cntr_Notifications_2++) {
				NDR_CHECK(ndr_pull_NOTIFICATION_RPC(ndr, NDR_SCALARS, &(*r->out.Notifications)[cntr_Notifications_2]));
			}
			for (cntr_Notifications_2 = 0; cntr_Notifications_2 < (size_Notifications_2); cntr_Notifications_2++) {
				NDR_CHECK(ndr_pull_NOTIFICATION_RPC(ndr, NDR_BUFFERS, &(*r->out.Notifications)[cntr_Notifications_2]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Notifications_2, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Notifications_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Notifications_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.dwNumNotifications);
		}
		_mem_save_dwNumNotifications_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.dwNumNotifications, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.dwNumNotifications));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dwNumNotifications_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (*r->out.Notifications) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)r->out.Notifications, *r->out.dwNumNotifications));
		}
		for (cntr_Notifications_2 = 0; cntr_Notifications_2 < (size_Notifications_2); cntr_Notifications_2++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GetNotifyV2(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_GetNotifyV2 *r)
{
	uint32_t cntr_Notifications_2;
	ndr_print_struct(ndr, name, "clusapi_GetNotifyV2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_GetNotifyV2");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNotify", &r->in.hNotify);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_GetNotifyV2");
		ndr->depth++;
		ndr_print_ptr(ndr, "Notifications", r->out.Notifications);
		ndr->depth++;
		ndr_print_ptr(ndr, "Notifications", *r->out.Notifications);
		ndr->depth++;
		if (*r->out.Notifications) {
			ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "Notifications", (uint32_t)(*r->out.dwNumNotifications));
			ndr->depth++;
			for (cntr_Notifications_2 = 0; cntr_Notifications_2 < (*r->out.dwNumNotifications); cntr_Notifications_2++) {
				ndr_print_NOTIFICATION_RPC(ndr, "Notifications", &(*r->out.Notifications)[cntr_Notifications_2]);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "dwNumNotifications", r->out.dwNumNotifications);
		ndr->depth++;
		ndr_print_uint32(ndr, "dwNumNotifications", *r->out.dwNumNotifications);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_QueryAllValues(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_QueryAllValues *r)
{
	uint32_t cntr_ppData_1;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
	}
	if (flags & NDR_OUT) {
		if (r->out.pcbData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.ppData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcbData));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 1));
		for (cntr_ppData_1 = 0; cntr_ppData_1 < (1); cntr_ppData_1++) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.ppData[cntr_ppData_1]));
		}
		for (cntr_ppData_1 = 0; cntr_ppData_1 < (1); cntr_ppData_1++) {
			if (r->out.ppData[cntr_ppData_1]) {
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.pcbData));
				NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.ppData[cntr_ppData_1], *r->out.pcbData));
			}
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_QueryAllValues(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_QueryAllValues *r)
{
	uint32_t _ptr_ppData;
	uint32_t size_ppData_1 = 0;
	uint32_t cntr_ppData_1;
	uint32_t size_ppData_3 = 0;
	TALLOC_CTX *_mem_save_pcbData_0 = NULL;
	TALLOC_CTX *_mem_save_ppData_1 = NULL;
	TALLOC_CTX *_mem_save_ppData_2 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_PULL_ALLOC(ndr, r->out.pcbData);
		NDR_ZERO_STRUCTP(r->out.pcbData);
		NDR_PULL_ALLOC_N(ndr, r->out.ppData, 1);
		memset(r->out.ppData, 0, (1) * sizeof(*r->out.ppData));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcbData);
		}
		_mem_save_pcbData_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcbData, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcbData));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcbData_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.ppData));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.ppData, &size_ppData_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.ppData, size_ppData_1);
		}
		_mem_save_ppData_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppData, 0);
		for (cntr_ppData_1 = 0; cntr_ppData_1 < (size_ppData_1); cntr_ppData_1++) {
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppData));
			if (_ptr_ppData) {
				NDR_PULL_ALLOC(ndr, r->out.ppData[cntr_ppData_1]);
			} else {
				r->out.ppData[cntr_ppData_1] = NULL;
			}
		}
		for (cntr_ppData_1 = 0; cntr_ppData_1 < (size_ppData_1); cntr_ppData_1++) {
			if (r->out.ppData[cntr_ppData_1]) {
				_mem_save_ppData_2 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->out.ppData[cntr_ppData_1], 0);
				NDR_CHECK(ndr_pull_array_size(ndr, &r->out.ppData[cntr_ppData_1]));
				NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.ppData[cntr_ppData_1], &size_ppData_3));
				NDR_PULL_ALLOC_N(ndr, r->out.ppData[cntr_ppData_1], size_ppData_3);
				NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.ppData[cntr_ppData_1], size_ppData_3));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppData_2, 0);
			}
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppData_1, 0);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.ppData) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.ppData, 1));
		}
		for (cntr_ppData_1 = 0; cntr_ppData_1 < (size_ppData_1); cntr_ppData_1++) {
			if (r->out.ppData[cntr_ppData_1]) {
				NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.ppData[cntr_ppData_1], *r->out.pcbData));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_QueryAllValues(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_QueryAllValues *r)
{
	uint32_t cntr_ppData_1;
	ndr_print_struct(ndr, name, "clusapi_QueryAllValues");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_QueryAllValues");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hKey", &r->in.hKey);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_QueryAllValues");
		ndr->depth++;
		ndr_print_ptr(ndr, "pcbData", r->out.pcbData);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcbData", *r->out.pcbData);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppData", r->out.ppData);
		ndr->depth++;
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "ppData", (uint32_t)(1));
		ndr->depth++;
		for (cntr_ppData_1 = 0; cntr_ppData_1 < (1); cntr_ppData_1++) {
			ndr_print_ptr(ndr, "ppData", r->out.ppData[cntr_ppData_1]);
			ndr->depth++;
			if (r->out.ppData[cntr_ppData_1]) {
				ndr_print_array_uint8(ndr, "ppData", r->out.ppData[cntr_ppData_1], *r->out.pcbData);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_StmFindDisk(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_StmFindDisk *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hCluster));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwFlags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pDiskId));
		if (r->in.pDiskId) {
			NDR_CHECK(ndr_push_CLUSTER_DISKID(ndr, NDR_SCALARS, r->in.pDiskId));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pUniqueId));
		if (r->in.pUniqueId) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.uniqueIdSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.pUniqueId, r->in.uniqueIdSize));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.uniqueIdSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.ppszDeviceName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.pDiskId));
		if (r->out.pDiskId) {
			NDR_CHECK(ndr_push_CLUSTER_DISKID(ndr, NDR_SCALARS, r->out.pDiskId));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppszDeviceName));
		if (*r->out.ppszDeviceName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.ppszDeviceName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.ppszDeviceName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.ppszDeviceName, ndr_charset_length(*r->out.ppszDeviceName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_StmFindDisk(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_StmFindDisk *r)
{
	uint32_t _ptr_pDiskId;
	uint32_t _ptr_pUniqueId;
	uint32_t size_pUniqueId_1 = 0;
	uint32_t _ptr_ppszDeviceName;
	uint32_t size_ppszDeviceName_2 = 0;
	uint32_t length_ppszDeviceName_2 = 0;
	TALLOC_CTX *_mem_save_pDiskId_0 = NULL;
	TALLOC_CTX *_mem_save_pUniqueId_0 = NULL;
	TALLOC_CTX *_mem_save_ppszDeviceName_0 = NULL;
	TALLOC_CTX *_mem_save_ppszDeviceName_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hCluster));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwFlags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pDiskId));
		if (_ptr_pDiskId) {
			NDR_PULL_ALLOC(ndr, r->in.pDiskId);
		} else {
			r->in.pDiskId = NULL;
		}
		if (r->in.pDiskId) {
			_mem_save_pDiskId_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pDiskId, 0);
			NDR_CHECK(ndr_pull_CLUSTER_DISKID(ndr, NDR_SCALARS, r->in.pDiskId));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pDiskId_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pUniqueId));
		if (_ptr_pUniqueId) {
			NDR_PULL_ALLOC(ndr, r->in.pUniqueId);
		} else {
			r->in.pUniqueId = NULL;
		}
		if (r->in.pUniqueId) {
			_mem_save_pUniqueId_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pUniqueId, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pUniqueId));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pUniqueId, &size_pUniqueId_1));
			NDR_PULL_ALLOC_N(ndr, r->in.pUniqueId, size_pUniqueId_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.pUniqueId, size_pUniqueId_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pUniqueId_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.uniqueIdSize));
		NDR_PULL_ALLOC(ndr, r->out.ppszDeviceName);
		NDR_ZERO_STRUCTP(r->out.ppszDeviceName);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.pUniqueId) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pUniqueId, r->in.uniqueIdSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pDiskId));
		if (_ptr_pDiskId) {
			NDR_PULL_ALLOC(ndr, r->out.pDiskId);
		} else {
			r->out.pDiskId = NULL;
		}
		if (r->out.pDiskId) {
			_mem_save_pDiskId_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.pDiskId, 0);
			NDR_CHECK(ndr_pull_CLUSTER_DISKID(ndr, NDR_SCALARS, r->out.pDiskId));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pDiskId_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppszDeviceName);
		}
		_mem_save_ppszDeviceName_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppszDeviceName, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppszDeviceName));
		if (_ptr_ppszDeviceName) {
			NDR_PULL_ALLOC(ndr, *r->out.ppszDeviceName);
		} else {
			*r->out.ppszDeviceName = NULL;
		}
		if (*r->out.ppszDeviceName) {
			_mem_save_ppszDeviceName_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppszDeviceName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.ppszDeviceName));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.ppszDeviceName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.ppszDeviceName, &size_ppszDeviceName_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.ppszDeviceName, &length_ppszDeviceName_2));
			if (length_ppszDeviceName_2 > size_ppszDeviceName_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_ppszDeviceName_2, length_ppszDeviceName_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_ppszDeviceName_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.ppszDeviceName, length_ppszDeviceName_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppszDeviceName_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppszDeviceName_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_StmFindDisk(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_StmFindDisk *r)
{
	ndr_print_struct(ndr, name, "clusapi_StmFindDisk");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_StmFindDisk");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hCluster", &r->in.hCluster);
		ndr_print_uint32(ndr, "dwFlags", r->in.dwFlags);
		ndr_print_ptr(ndr, "pDiskId", r->in.pDiskId);
		ndr->depth++;
		if (r->in.pDiskId) {
			ndr_print_CLUSTER_DISKID(ndr, "pDiskId", r->in.pDiskId);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pUniqueId", r->in.pUniqueId);
		ndr->depth++;
		if (r->in.pUniqueId) {
			ndr_print_array_uint8(ndr, "pUniqueId", r->in.pUniqueId, r->in.uniqueIdSize);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "uniqueIdSize", r->in.uniqueIdSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_StmFindDisk");
		ndr->depth++;
		ndr_print_ptr(ndr, "pDiskId", r->out.pDiskId);
		ndr->depth++;
		if (r->out.pDiskId) {
			ndr_print_CLUSTER_DISKID(ndr, "pDiskId", r->out.pDiskId);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "ppszDeviceName", r->out.ppszDeviceName);
		ndr->depth++;
		ndr_print_ptr(ndr, "ppszDeviceName", *r->out.ppszDeviceName);
		ndr->depth++;
		if (*r->out.ppszDeviceName) {
			ndr_print_string(ndr, "ppszDeviceName", *r->out.ppszDeviceName);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_ClusterMrr(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_ClusterMrr *r)
{
	uint32_t cntr_ppInfo_1;
	uint32_t cntr_ppInfo_3;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hCluster));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->in.fExcludeSelf));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->in.nodeSet));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwTimeout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwComponent));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwControlCode));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.inSize));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pInData));
		if (r->in.pInData) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.inSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.pInData, r->in.inSize));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.ppInfo == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 1));
		for (cntr_ppInfo_1 = 0; cntr_ppInfo_1 < (1); cntr_ppInfo_1++) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.ppInfo[cntr_ppInfo_1]));
		}
		for (cntr_ppInfo_1 = 0; cntr_ppInfo_1 < (1); cntr_ppInfo_1++) {
			if (r->out.ppInfo[cntr_ppInfo_1]) {
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 1));
				for (cntr_ppInfo_3 = 0; cntr_ppInfo_3 < (1); cntr_ppInfo_3++) {
					NDR_CHECK(ndr_push_CLUSTER_MRR_RESPONSE(ndr, NDR_SCALARS, &r->out.ppInfo[cntr_ppInfo_1][cntr_ppInfo_3]));
				}
				for (cntr_ppInfo_3 = 0; cntr_ppInfo_3 < (1); cntr_ppInfo_3++) {
					NDR_CHECK(ndr_push_CLUSTER_MRR_RESPONSE(ndr, NDR_BUFFERS, &r->out.ppInfo[cntr_ppInfo_1][cntr_ppInfo_3]));
				}
			}
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_ClusterMrr(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_ClusterMrr *r)
{
	uint32_t _ptr_pInData;
	uint32_t size_pInData_1 = 0;
	uint32_t _ptr_ppInfo;
	uint32_t size_ppInfo_1 = 0;
	uint32_t cntr_ppInfo_1;
	uint32_t size_ppInfo_3 = 0;
	uint32_t cntr_ppInfo_3;
	TALLOC_CTX *_mem_save_pInData_0 = NULL;
	TALLOC_CTX *_mem_save_ppInfo_1 = NULL;
	TALLOC_CTX *_mem_save_ppInfo_2 = NULL;
	TALLOC_CTX *_mem_save_ppInfo_3 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hCluster));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->in.fExcludeSelf));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->in.nodeSet));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwTimeout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwComponent));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwControlCode));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.inSize));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pInData));
		if (_ptr_pInData) {
			NDR_PULL_ALLOC(ndr, r->in.pInData);
		} else {
			r->in.pInData = NULL;
		}
		if (r->in.pInData) {
			_mem_save_pInData_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pInData, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pInData));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pInData, &size_pInData_1));
			NDR_PULL_ALLOC_N(ndr, r->in.pInData, size_pInData_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.pInData, size_pInData_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pInData_0, 0);
		}
		NDR_PULL_ALLOC_N(ndr, r->out.ppInfo, 1);
		memset(r->out.ppInfo, 0, (1) * sizeof(*r->out.ppInfo));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.pInData) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pInData, r->in.inSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.ppInfo));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.ppInfo, &size_ppInfo_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.ppInfo, size_ppInfo_1);
		}
		_mem_save_ppInfo_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppInfo, 0);
		for (cntr_ppInfo_1 = 0; cntr_ppInfo_1 < (size_ppInfo_1); cntr_ppInfo_1++) {
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppInfo));
			if (_ptr_ppInfo) {
				NDR_PULL_ALLOC(ndr, r->out.ppInfo[cntr_ppInfo_1]);
			} else {
				r->out.ppInfo[cntr_ppInfo_1] = NULL;
			}
		}
		for (cntr_ppInfo_1 = 0; cntr_ppInfo_1 < (size_ppInfo_1); cntr_ppInfo_1++) {
			if (r->out.ppInfo[cntr_ppInfo_1]) {
				_mem_save_ppInfo_2 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->out.ppInfo[cntr_ppInfo_1], 0);
				NDR_CHECK(ndr_pull_array_size(ndr, &r->out.ppInfo[cntr_ppInfo_1]));
				NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.ppInfo[cntr_ppInfo_1], &size_ppInfo_3));
				NDR_PULL_ALLOC_N(ndr, r->out.ppInfo[cntr_ppInfo_1], size_ppInfo_3);
				_mem_save_ppInfo_3 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->out.ppInfo[cntr_ppInfo_1], 0);
				for (cntr_ppInfo_3 = 0; cntr_ppInfo_3 < (size_ppInfo_3); cntr_ppInfo_3++) {
					NDR_CHECK(ndr_pull_CLUSTER_MRR_RESPONSE(ndr, NDR_SCALARS, &r->out.ppInfo[cntr_ppInfo_1][cntr_ppInfo_3]));
				}
				for (cntr_ppInfo_3 = 0; cntr_ppInfo_3 < (size_ppInfo_3); cntr_ppInfo_3++) {
					NDR_CHECK(ndr_pull_CLUSTER_MRR_RESPONSE(ndr, NDR_BUFFERS, &r->out.ppInfo[cntr_ppInfo_1][cntr_ppInfo_3]));
				}
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppInfo_3, 0);
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppInfo_2, 0);
			}
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppInfo_1, 0);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.ppInfo) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.ppInfo, 1));
		}
		for (cntr_ppInfo_1 = 0; cntr_ppInfo_1 < (size_ppInfo_1); cntr_ppInfo_1++) {
			if (r->out.ppInfo[cntr_ppInfo_1]) {
				NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.ppInfo[cntr_ppInfo_1], 1));
			}
			for (cntr_ppInfo_3 = 0; cntr_ppInfo_3 < (size_ppInfo_3); cntr_ppInfo_3++) {
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_ClusterMrr(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_ClusterMrr *r)
{
	uint32_t cntr_ppInfo_1;
	uint32_t cntr_ppInfo_3;
	ndr_print_struct(ndr, name, "clusapi_ClusterMrr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_ClusterMrr");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hCluster", &r->in.hCluster);
		ndr_print_uint8(ndr, "fExcludeSelf", r->in.fExcludeSelf);
		ndr_print_hyper(ndr, "nodeSet", r->in.nodeSet);
		ndr_print_uint32(ndr, "dwTimeout", r->in.dwTimeout);
		ndr_print_uint32(ndr, "dwComponent", r->in.dwComponent);
		ndr_print_uint32(ndr, "dwControlCode", r->in.dwControlCode);
		ndr_print_uint32(ndr, "inSize", r->in.inSize);
		ndr_print_ptr(ndr, "pInData", r->in.pInData);
		ndr->depth++;
		if (r->in.pInData) {
			ndr_print_array_uint8(ndr, "pInData", r->in.pInData, r->in.inSize);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_ClusterMrr");
		ndr->depth++;
		ndr_print_ptr(ndr, "ppInfo", r->out.ppInfo);
		ndr->depth++;
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "ppInfo", (uint32_t)(1));
		ndr->depth++;
		for (cntr_ppInfo_1 = 0; cntr_ppInfo_1 < (1); cntr_ppInfo_1++) {
			ndr_print_ptr(ndr, "ppInfo", r->out.ppInfo[cntr_ppInfo_1]);
			ndr->depth++;
			if (r->out.ppInfo[cntr_ppInfo_1]) {
				ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "ppInfo", (uint32_t)(1));
				ndr->depth++;
				for (cntr_ppInfo_3 = 0; cntr_ppInfo_3 < (1); cntr_ppInfo_3++) {
					ndr_print_CLUSTER_MRR_RESPONSE(ndr, "ppInfo", &r->out.ppInfo[cntr_ppInfo_1][cntr_ppInfo_3]);
				}
				ndr->depth--;
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CreateGroupEnum(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CreateGroupEnum *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hCluster));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pProperties));
		if (r->in.pProperties) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbProperties));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.pProperties, r->in.cbProperties));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbProperties));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pRoProperties));
		if (r->in.pRoProperties) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbRoProperties));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.pRoProperties, r->in.cbRoProperties));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbRoProperties));
	}
	if (flags & NDR_OUT) {
		if (r->out.ppResultList == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppResultList));
		if (*r->out.ppResultList) {
			NDR_CHECK(ndr_push_GROUP_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppResultList));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CreateGroupEnum(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CreateGroupEnum *r)
{
	uint32_t _ptr_pProperties;
	uint32_t size_pProperties_1 = 0;
	uint32_t _ptr_pRoProperties;
	uint32_t size_pRoProperties_1 = 0;
	uint32_t _ptr_ppResultList;
	TALLOC_CTX *_mem_save_pProperties_0 = NULL;
	TALLOC_CTX *_mem_save_pRoProperties_0 = NULL;
	TALLOC_CTX *_mem_save_ppResultList_0 = NULL;
	TALLOC_CTX *_mem_save_ppResultList_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hCluster));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pProperties));
		if (_ptr_pProperties) {
			NDR_PULL_ALLOC(ndr, r->in.pProperties);
		} else {
			r->in.pProperties = NULL;
		}
		if (r->in.pProperties) {
			_mem_save_pProperties_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pProperties, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pProperties));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pProperties, &size_pProperties_1));
			NDR_PULL_ALLOC_N(ndr, r->in.pProperties, size_pProperties_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.pProperties, size_pProperties_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pProperties_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbProperties));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pRoProperties));
		if (_ptr_pRoProperties) {
			NDR_PULL_ALLOC(ndr, r->in.pRoProperties);
		} else {
			r->in.pRoProperties = NULL;
		}
		if (r->in.pRoProperties) {
			_mem_save_pRoProperties_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pRoProperties, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pRoProperties));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pRoProperties, &size_pRoProperties_1));
			NDR_PULL_ALLOC_N(ndr, r->in.pRoProperties, size_pRoProperties_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.pRoProperties, size_pRoProperties_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pRoProperties_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbRoProperties));
		NDR_PULL_ALLOC(ndr, r->out.ppResultList);
		NDR_ZERO_STRUCTP(r->out.ppResultList);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.pProperties) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pProperties, r->in.cbProperties));
		}
		if (r->in.pRoProperties) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pRoProperties, r->in.cbRoProperties));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppResultList);
		}
		_mem_save_ppResultList_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppResultList, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppResultList));
		if (_ptr_ppResultList) {
			NDR_PULL_ALLOC(ndr, *r->out.ppResultList);
		} else {
			*r->out.ppResultList = NULL;
		}
		if (*r->out.ppResultList) {
			_mem_save_ppResultList_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppResultList, 0);
			NDR_CHECK(ndr_pull_GROUP_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppResultList));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppResultList_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppResultList_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CreateGroupEnum(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CreateGroupEnum *r)
{
	ndr_print_struct(ndr, name, "clusapi_CreateGroupEnum");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CreateGroupEnum");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hCluster", &r->in.hCluster);
		ndr_print_ptr(ndr, "pProperties", r->in.pProperties);
		ndr->depth++;
		if (r->in.pProperties) {
			ndr_print_array_uint8(ndr, "pProperties", r->in.pProperties, r->in.cbProperties);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "cbProperties", r->in.cbProperties);
		ndr_print_ptr(ndr, "pRoProperties", r->in.pRoProperties);
		ndr->depth++;
		if (r->in.pRoProperties) {
			ndr_print_array_uint8(ndr, "pRoProperties", r->in.pRoProperties, r->in.cbRoProperties);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "cbRoProperties", r->in.cbRoProperties);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CreateGroupEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "ppResultList", r->out.ppResultList);
		ndr->depth++;
		ndr_print_ptr(ndr, "ppResultList", *r->out.ppResultList);
		ndr->depth++;
		if (*r->out.ppResultList) {
			ndr_print_GROUP_ENUM_LIST(ndr, "ppResultList", *r->out.ppResultList);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CreateResourceEnum(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CreateResourceEnum *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hCluster));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pProperties));
		if (r->in.pProperties) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbProperties));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.pProperties, r->in.cbProperties));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbProperties));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pRoProperties));
		if (r->in.pRoProperties) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbRoProperties));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.pRoProperties, r->in.cbRoProperties));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbRoProperties));
	}
	if (flags & NDR_OUT) {
		if (r->out.ppResultList == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppResultList));
		if (*r->out.ppResultList) {
			NDR_CHECK(ndr_push_RESOURCE_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppResultList));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CreateResourceEnum(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CreateResourceEnum *r)
{
	uint32_t _ptr_pProperties;
	uint32_t size_pProperties_1 = 0;
	uint32_t _ptr_pRoProperties;
	uint32_t size_pRoProperties_1 = 0;
	uint32_t _ptr_ppResultList;
	TALLOC_CTX *_mem_save_pProperties_0 = NULL;
	TALLOC_CTX *_mem_save_pRoProperties_0 = NULL;
	TALLOC_CTX *_mem_save_ppResultList_0 = NULL;
	TALLOC_CTX *_mem_save_ppResultList_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hCluster));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pProperties));
		if (_ptr_pProperties) {
			NDR_PULL_ALLOC(ndr, r->in.pProperties);
		} else {
			r->in.pProperties = NULL;
		}
		if (r->in.pProperties) {
			_mem_save_pProperties_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pProperties, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pProperties));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pProperties, &size_pProperties_1));
			NDR_PULL_ALLOC_N(ndr, r->in.pProperties, size_pProperties_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.pProperties, size_pProperties_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pProperties_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbProperties));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pRoProperties));
		if (_ptr_pRoProperties) {
			NDR_PULL_ALLOC(ndr, r->in.pRoProperties);
		} else {
			r->in.pRoProperties = NULL;
		}
		if (r->in.pRoProperties) {
			_mem_save_pRoProperties_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pRoProperties, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pRoProperties));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pRoProperties, &size_pRoProperties_1));
			NDR_PULL_ALLOC_N(ndr, r->in.pRoProperties, size_pRoProperties_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.pRoProperties, size_pRoProperties_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pRoProperties_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbRoProperties));
		NDR_PULL_ALLOC(ndr, r->out.ppResultList);
		NDR_ZERO_STRUCTP(r->out.ppResultList);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.pProperties) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pProperties, r->in.cbProperties));
		}
		if (r->in.pRoProperties) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pRoProperties, r->in.cbRoProperties));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppResultList);
		}
		_mem_save_ppResultList_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppResultList, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppResultList));
		if (_ptr_ppResultList) {
			NDR_PULL_ALLOC(ndr, *r->out.ppResultList);
		} else {
			*r->out.ppResultList = NULL;
		}
		if (*r->out.ppResultList) {
			_mem_save_ppResultList_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppResultList, 0);
			NDR_CHECK(ndr_pull_RESOURCE_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppResultList));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppResultList_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppResultList_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CreateResourceEnum(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CreateResourceEnum *r)
{
	ndr_print_struct(ndr, name, "clusapi_CreateResourceEnum");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CreateResourceEnum");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hCluster", &r->in.hCluster);
		ndr_print_ptr(ndr, "pProperties", r->in.pProperties);
		ndr->depth++;
		if (r->in.pProperties) {
			ndr_print_array_uint8(ndr, "pProperties", r->in.pProperties, r->in.cbProperties);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "cbProperties", r->in.cbProperties);
		ndr_print_ptr(ndr, "pRoProperties", r->in.pRoProperties);
		ndr->depth++;
		if (r->in.pRoProperties) {
			ndr_print_array_uint8(ndr, "pRoProperties", r->in.pRoProperties, r->in.cbRoProperties);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "cbRoProperties", r->in.cbRoProperties);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CreateResourceEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "ppResultList", r->out.ppResultList);
		ndr->depth++;
		ndr_print_ptr(ndr, "ppResultList", *r->out.ppResultList);
		ndr->depth++;
		if (*r->out.ppResultList) {
			ndr_print_RESOURCE_ENUM_LIST(ndr, "ppResultList", *r->out.ppResultList);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_ExecuteReadBatch(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_ExecuteReadBatch *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpInData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbInData));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbInData));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpInData, r->in.cbInData));
	}
	if (flags & NDR_OUT) {
		if (r->out.cbOutData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpOutData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.cbOutData));
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.lpOutData));
		if (*r->out.lpOutData) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.cbOutData));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, *r->out.lpOutData, *r->out.cbOutData));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_ExecuteReadBatch(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_ExecuteReadBatch *r)
{
	uint32_t size_lpInData_1 = 0;
	uint32_t _ptr_lpOutData;
	uint32_t size_lpOutData_2 = 0;
	TALLOC_CTX *_mem_save_cbOutData_0 = NULL;
	TALLOC_CTX *_mem_save_lpOutData_0 = NULL;
	TALLOC_CTX *_mem_save_lpOutData_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbInData));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpInData));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpInData, &size_lpInData_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.lpInData, size_lpInData_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpInData, size_lpInData_1));
		NDR_PULL_ALLOC(ndr, r->out.cbOutData);
		NDR_ZERO_STRUCTP(r->out.cbOutData);
		NDR_PULL_ALLOC(ndr, r->out.lpOutData);
		NDR_ZERO_STRUCTP(r->out.lpOutData);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.lpInData) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpInData, r->in.cbInData));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.cbOutData);
		}
		_mem_save_cbOutData_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.cbOutData, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.cbOutData));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_cbOutData_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpOutData);
		}
		_mem_save_lpOutData_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpOutData, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpOutData));
		if (_ptr_lpOutData) {
			NDR_PULL_ALLOC(ndr, *r->out.lpOutData);
		} else {
			*r->out.lpOutData = NULL;
		}
		if (*r->out.lpOutData) {
			_mem_save_lpOutData_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.lpOutData, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.lpOutData));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)r->out.lpOutData, &size_lpOutData_2));
			NDR_PULL_ALLOC_N(ndr, *r->out.lpOutData, size_lpOutData_2);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, *r->out.lpOutData, size_lpOutData_2));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpOutData_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpOutData_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (*r->out.lpOutData) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)r->out.lpOutData, *r->out.cbOutData));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_ExecuteReadBatch(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_ExecuteReadBatch *r)
{
	ndr_print_struct(ndr, name, "clusapi_ExecuteReadBatch");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_ExecuteReadBatch");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hKey", &r->in.hKey);
		ndr_print_uint32(ndr, "cbInData", r->in.cbInData);
		ndr_print_ptr(ndr, "lpInData", r->in.lpInData);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpInData", r->in.lpInData, r->in.cbInData);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_ExecuteReadBatch");
		ndr->depth++;
		ndr_print_ptr(ndr, "cbOutData", r->out.cbOutData);
		ndr->depth++;
		ndr_print_uint32(ndr, "cbOutData", *r->out.cbOutData);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpOutData", r->out.lpOutData);
		ndr->depth++;
		ndr_print_ptr(ndr, "lpOutData", *r->out.lpOutData);
		ndr->depth++;
		if (*r->out.lpOutData) {
			ndr_print_array_uint8(ndr, "lpOutData", *r->out.lpOutData, *r->out.cbOutData);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_RestartResource(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_RestartResource *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwFlags));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_RestartResource(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_RestartResource *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwFlags));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_RestartResource(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_RestartResource *r)
{
	ndr_print_struct(ndr, name, "clusapi_RestartResource");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_RestartResource");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr_print_uint32(ndr, "dwFlags", r->in.dwFlags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_RestartResource");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_GetNotifyAsync(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_GetNotifyAsync *r)
{
	uint32_t cntr_Notifications_2;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
	}
	if (flags & NDR_OUT) {
		if (r->out.Notifications == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.dwNumNotifications == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.Notifications));
		if (*r->out.Notifications) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.dwNumNotifications));
			for (cntr_Notifications_2 = 0; cntr_Notifications_2 < (*r->out.dwNumNotifications); cntr_Notifications_2++) {
				NDR_CHECK(ndr_push_NOTIFICATION_DATA_ASYNC_RPC(ndr, NDR_SCALARS, &(*r->out.Notifications)[cntr_Notifications_2]));
			}
			for (cntr_Notifications_2 = 0; cntr_Notifications_2 < (*r->out.dwNumNotifications); cntr_Notifications_2++) {
				NDR_CHECK(ndr_push_NOTIFICATION_DATA_ASYNC_RPC(ndr, NDR_BUFFERS, &(*r->out.Notifications)[cntr_Notifications_2]));
			}
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.dwNumNotifications));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GetNotifyAsync(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_GetNotifyAsync *r)
{
	uint32_t _ptr_Notifications;
	uint32_t size_Notifications_2 = 0;
	uint32_t cntr_Notifications_2;
	TALLOC_CTX *_mem_save_Notifications_0 = NULL;
	TALLOC_CTX *_mem_save_Notifications_1 = NULL;
	TALLOC_CTX *_mem_save_Notifications_2 = NULL;
	TALLOC_CTX *_mem_save_dwNumNotifications_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_PULL_ALLOC(ndr, r->out.Notifications);
		NDR_ZERO_STRUCTP(r->out.Notifications);
		NDR_PULL_ALLOC(ndr, r->out.dwNumNotifications);
		NDR_ZERO_STRUCTP(r->out.dwNumNotifications);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Notifications);
		}
		_mem_save_Notifications_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Notifications, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Notifications));
		if (_ptr_Notifications) {
			NDR_PULL_ALLOC(ndr, *r->out.Notifications);
		} else {
			*r->out.Notifications = NULL;
		}
		if (*r->out.Notifications) {
			_mem_save_Notifications_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.Notifications, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.Notifications));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)r->out.Notifications, &size_Notifications_2));
			NDR_PULL_ALLOC_N(ndr, *r->out.Notifications, size_Notifications_2);
			_mem_save_Notifications_2 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.Notifications, 0);
			for (cntr_Notifications_2 = 0; cntr_Notifications_2 < (size_Notifications_2); cntr_Notifications_2++) {
				NDR_CHECK(ndr_pull_NOTIFICATION_DATA_ASYNC_RPC(ndr, NDR_SCALARS, &(*r->out.Notifications)[cntr_Notifications_2]));
			}
			for (cntr_Notifications_2 = 0; cntr_Notifications_2 < (size_Notifications_2); cntr_Notifications_2++) {
				NDR_CHECK(ndr_pull_NOTIFICATION_DATA_ASYNC_RPC(ndr, NDR_BUFFERS, &(*r->out.Notifications)[cntr_Notifications_2]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Notifications_2, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Notifications_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Notifications_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.dwNumNotifications);
		}
		_mem_save_dwNumNotifications_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.dwNumNotifications, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.dwNumNotifications));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dwNumNotifications_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (*r->out.Notifications) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)r->out.Notifications, *r->out.dwNumNotifications));
		}
		for (cntr_Notifications_2 = 0; cntr_Notifications_2 < (size_Notifications_2); cntr_Notifications_2++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GetNotifyAsync(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_GetNotifyAsync *r)
{
	uint32_t cntr_Notifications_2;
	ndr_print_struct(ndr, name, "clusapi_GetNotifyAsync");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_GetNotifyAsync");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNotify", &r->in.hNotify);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_GetNotifyAsync");
		ndr->depth++;
		ndr_print_ptr(ndr, "Notifications", r->out.Notifications);
		ndr->depth++;
		ndr_print_ptr(ndr, "Notifications", *r->out.Notifications);
		ndr->depth++;
		if (*r->out.Notifications) {
			ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "Notifications", (uint32_t)(*r->out.dwNumNotifications));
			ndr->depth++;
			for (cntr_Notifications_2 = 0; cntr_Notifications_2 < (*r->out.dwNumNotifications); cntr_Notifications_2++) {
				ndr_print_NOTIFICATION_DATA_ASYNC_RPC(ndr, "Notifications", &(*r->out.Notifications)[cntr_Notifications_2]);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "dwNumNotifications", r->out.dwNumNotifications);
		ndr->depth++;
		ndr_print_uint32(ndr, "dwNumNotifications", *r->out.dwNumNotifications);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Opnum148NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct Opnum148NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Opnum148NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct Opnum148NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Opnum148NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct Opnum148NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "Opnum148NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Opnum148NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Opnum148NotUsedOnWire");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Opnum149otUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct Opnum149otUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Opnum149otUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct Opnum149otUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Opnum149otUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct Opnum149otUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "Opnum149otUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Opnum149otUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Opnum149otUsedOnWire");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Opnum150NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct Opnum150NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Opnum150NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct Opnum150NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Opnum150NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct Opnum150NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "Opnum150NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Opnum150NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Opnum150NotUsedOnWire");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Opnum151NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct Opnum151NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Opnum151NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct Opnum151NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Opnum151NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct Opnum151NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "Opnum151NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Opnum151NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Opnum151NotUsedOnWire");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Opnum152NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct Opnum152NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Opnum152NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct Opnum152NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Opnum152NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct Opnum152NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "Opnum152NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Opnum152NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Opnum152NotUsedOnWire");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Opnum153NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct Opnum153NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Opnum153NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct Opnum153NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Opnum153NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct Opnum153NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "Opnum153NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Opnum153NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Opnum153NotUsedOnWire");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Opnum154NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct Opnum154NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Opnum154NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct Opnum154NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Opnum154NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct Opnum154NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "Opnum154NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Opnum154NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Opnum154NotUsedOnWire");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_AddNotifyResourceTypeV2(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_AddNotifyResourceTypeV2 *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.resTypeName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->in.filter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwNotifyKey));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.resTypeName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.resTypeName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.resTypeName, ndr_charset_length(r->in.resTypeName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwVersion));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_AddNotifyResourceTypeV2(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_AddNotifyResourceTypeV2 *r)
{
	uint32_t size_resTypeName_1 = 0;
	uint32_t length_resTypeName_1 = 0;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->in.filter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwNotifyKey));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.resTypeName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.resTypeName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.resTypeName, &size_resTypeName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.resTypeName, &length_resTypeName_1));
		if (length_resTypeName_1 > size_resTypeName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_resTypeName_1, length_resTypeName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_resTypeName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.resTypeName, length_resTypeName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwVersion));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_AddNotifyResourceTypeV2(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_AddNotifyResourceTypeV2 *r)
{
	ndr_print_struct(ndr, name, "clusapi_AddNotifyResourceTypeV2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_AddNotifyResourceTypeV2");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNotify", &r->in.hNotify);
		ndr_print_hyper(ndr, "filter", r->in.filter);
		ndr_print_uint32(ndr, "dwNotifyKey", r->in.dwNotifyKey);
		ndr_print_ptr(ndr, "resTypeName", r->in.resTypeName);
		ndr->depth++;
		ndr_print_string(ndr, "resTypeName", r->in.resTypeName);
		ndr->depth--;
		ndr_print_uint32(ndr, "dwVersion", r->in.dwVersion);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_AddNotifyResourceTypeV2");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Opnum156NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct Opnum156NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Opnum156NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct Opnum156NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Opnum156NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct Opnum156NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "Opnum156NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Opnum156NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Opnum156NotUsedOnWire");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_ExecuteReadBatchEx(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_ExecuteReadBatchEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpInData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbInData));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbInData));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpInData, r->in.cbInData));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.cbOutData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpOutData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.cbOutData));
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.lpOutData));
		if (*r->out.lpOutData) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.cbOutData));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, *r->out.lpOutData, *r->out.cbOutData));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_ExecuteReadBatchEx(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_ExecuteReadBatchEx *r)
{
	uint32_t size_lpInData_1 = 0;
	uint32_t _ptr_lpOutData;
	uint32_t size_lpOutData_2 = 0;
	TALLOC_CTX *_mem_save_cbOutData_0 = NULL;
	TALLOC_CTX *_mem_save_lpOutData_0 = NULL;
	TALLOC_CTX *_mem_save_lpOutData_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hKey));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbInData));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpInData));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpInData, &size_lpInData_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.lpInData, size_lpInData_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpInData, size_lpInData_1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.cbOutData);
		NDR_ZERO_STRUCTP(r->out.cbOutData);
		NDR_PULL_ALLOC(ndr, r->out.lpOutData);
		NDR_ZERO_STRUCTP(r->out.lpOutData);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.lpInData) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpInData, r->in.cbInData));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.cbOutData);
		}
		_mem_save_cbOutData_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.cbOutData, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.cbOutData));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_cbOutData_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpOutData);
		}
		_mem_save_lpOutData_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpOutData, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpOutData));
		if (_ptr_lpOutData) {
			NDR_PULL_ALLOC(ndr, *r->out.lpOutData);
		} else {
			*r->out.lpOutData = NULL;
		}
		if (*r->out.lpOutData) {
			_mem_save_lpOutData_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.lpOutData, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.lpOutData));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)r->out.lpOutData, &size_lpOutData_2));
			NDR_PULL_ALLOC_N(ndr, *r->out.lpOutData, size_lpOutData_2);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, *r->out.lpOutData, size_lpOutData_2));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpOutData_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpOutData_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (*r->out.lpOutData) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)r->out.lpOutData, *r->out.cbOutData));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_ExecuteReadBatchEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_ExecuteReadBatchEx *r)
{
	ndr_print_struct(ndr, name, "clusapi_ExecuteReadBatchEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_ExecuteReadBatchEx");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hKey", &r->in.hKey);
		ndr_print_uint32(ndr, "cbInData", r->in.cbInData);
		ndr_print_ptr(ndr, "lpInData", r->in.lpInData);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpInData", r->in.lpInData, r->in.cbInData);
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_ExecuteReadBatchEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "cbOutData", r->out.cbOutData);
		ndr->depth++;
		ndr_print_uint32(ndr, "cbOutData", *r->out.cbOutData);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpOutData", r->out.lpOutData);
		ndr->depth++;
		ndr_print_ptr(ndr, "lpOutData", *r->out.lpOutData);
		ndr->depth++;
		if (*r->out.lpOutData) {
			ndr_print_array_uint8(ndr, "lpOutData", *r->out.lpOutData, *r->out.cbOutData);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Opnum158NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct Opnum158NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Opnum158NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct Opnum158NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Opnum158NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct Opnum158NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "Opnum158NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Opnum158NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Opnum158NotUsedOnWire");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Opnum159NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct Opnum159NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Opnum159NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct Opnum159NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Opnum159NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct Opnum159NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "Opnum159NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Opnum159NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Opnum159NotUsedOnWire");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Opnum160NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct Opnum160NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Opnum160NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct Opnum160NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Opnum160NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct Opnum160NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "Opnum160NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Opnum160NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Opnum160NotUsedOnWire");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Opnum161NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct Opnum161NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Opnum161NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct Opnum161NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Opnum161NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct Opnum161NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "Opnum161NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Opnum161NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Opnum161NotUsedOnWire");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Opnum162NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct Opnum162NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Opnum162NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct Opnum162NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Opnum162NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct Opnum162NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "Opnum162NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Opnum162NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Opnum162NotUsedOnWire");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CreateGroupSet(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CreateGroupSet *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszGroupSetName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszGroupSetName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszGroupSetName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszGroupSetName, ndr_charset_length(r->in.lpszGroupSetName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.Status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.hGroupSet == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.Status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.hGroupSet));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CreateGroupSet(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CreateGroupSet *r)
{
	uint32_t size_lpszGroupSetName_1 = 0;
	uint32_t length_lpszGroupSetName_1 = 0;
	TALLOC_CTX *_mem_save_Status_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	TALLOC_CTX *_mem_save_hGroupSet_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszGroupSetName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszGroupSetName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszGroupSetName, &size_lpszGroupSetName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszGroupSetName, &length_lpszGroupSetName_1));
		if (length_lpszGroupSetName_1 > size_lpszGroupSetName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszGroupSetName_1, length_lpszGroupSetName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszGroupSetName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszGroupSetName, length_lpszGroupSetName_1, sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.Status);
		NDR_ZERO_STRUCTP(r->out.Status);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		NDR_PULL_ALLOC(ndr, r->out.hGroupSet);
		NDR_ZERO_STRUCTP(r->out.hGroupSet);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Status);
		}
		_mem_save_Status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.Status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.hGroupSet);
		}
		_mem_save_hGroupSet_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.hGroupSet, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.hGroupSet));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hGroupSet_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CreateGroupSet(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CreateGroupSet *r)
{
	ndr_print_struct(ndr, name, "clusapi_CreateGroupSet");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CreateGroupSet");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszGroupSetName", r->in.lpszGroupSetName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszGroupSetName", r->in.lpszGroupSetName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CreateGroupSet");
		ndr->depth++;
		ndr_print_ptr(ndr, "Status", r->out.Status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "Status", *r->out.Status);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_ptr(ndr, "hGroupSet", r->out.hGroupSet);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroupSet", r->out.hGroupSet);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_OpenGroupSet(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_OpenGroupSet *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszGroupSetName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszGroupSetName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszGroupSetName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszGroupSetName, ndr_charset_length(r->in.lpszGroupSetName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.Status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.hGroupSet == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.Status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.hGroupSet));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_OpenGroupSet(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_OpenGroupSet *r)
{
	uint32_t size_lpszGroupSetName_1 = 0;
	uint32_t length_lpszGroupSetName_1 = 0;
	TALLOC_CTX *_mem_save_Status_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	TALLOC_CTX *_mem_save_hGroupSet_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszGroupSetName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszGroupSetName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszGroupSetName, &size_lpszGroupSetName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszGroupSetName, &length_lpszGroupSetName_1));
		if (length_lpszGroupSetName_1 > size_lpszGroupSetName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszGroupSetName_1, length_lpszGroupSetName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszGroupSetName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszGroupSetName, length_lpszGroupSetName_1, sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.Status);
		NDR_ZERO_STRUCTP(r->out.Status);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		NDR_PULL_ALLOC(ndr, r->out.hGroupSet);
		NDR_ZERO_STRUCTP(r->out.hGroupSet);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.Status);
		}
		_mem_save_Status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.Status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.Status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.hGroupSet);
		}
		_mem_save_hGroupSet_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.hGroupSet, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.hGroupSet));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hGroupSet_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_OpenGroupSet(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_OpenGroupSet *r)
{
	ndr_print_struct(ndr, name, "clusapi_OpenGroupSet");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_OpenGroupSet");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpszGroupSetName", r->in.lpszGroupSetName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszGroupSetName", r->in.lpszGroupSetName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_OpenGroupSet");
		ndr->depth++;
		ndr_print_ptr(ndr, "Status", r->out.Status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "Status", *r->out.Status);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_ptr(ndr, "hGroupSet", r->out.hGroupSet);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroupSet", r->out.hGroupSet);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CloseGroupSet(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CloseGroupSet *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.GroupSet == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.GroupSet));
	}
	if (flags & NDR_OUT) {
		if (r->out.GroupSet == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.GroupSet));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CloseGroupSet(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CloseGroupSet *r)
{
	TALLOC_CTX *_mem_save_GroupSet_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.GroupSet);
		}
		_mem_save_GroupSet_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.GroupSet, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.GroupSet));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_GroupSet_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.GroupSet);
		*r->out.GroupSet = *r->in.GroupSet;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.GroupSet == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.GroupSet);
			NDR_ZERO_STRUCTP(r->in.GroupSet);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.GroupSet);
		}
		_mem_save_GroupSet_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.GroupSet, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.GroupSet));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_GroupSet_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CloseGroupSet(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CloseGroupSet *r)
{
	ndr_print_struct(ndr, name, "clusapi_CloseGroupSet");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CloseGroupSet");
		ndr->depth++;
		ndr_print_ptr(ndr, "GroupSet", r->in.GroupSet);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "GroupSet", r->in.GroupSet);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CloseGroupSet");
		ndr->depth++;
		ndr_print_ptr(ndr, "GroupSet", r->out.GroupSet);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "GroupSet", r->out.GroupSet);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_DeleteGroupSet(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_DeleteGroupSet *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.GroupSet));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_DeleteGroupSet(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_DeleteGroupSet *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.GroupSet));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_DeleteGroupSet(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_DeleteGroupSet *r)
{
	ndr_print_struct(ndr, name, "clusapi_DeleteGroupSet");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_DeleteGroupSet");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "GroupSet", &r->in.GroupSet);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_DeleteGroupSet");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_AddGroupToGroupSet(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_AddGroupToGroupSet *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.GroupSet));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.Group));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_AddGroupToGroupSet(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_AddGroupToGroupSet *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.GroupSet));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.Group));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_AddGroupToGroupSet(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_AddGroupToGroupSet *r)
{
	ndr_print_struct(ndr, name, "clusapi_AddGroupToGroupSet");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_AddGroupToGroupSet");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "GroupSet", &r->in.GroupSet);
		ndr_print_policy_handle(ndr, "Group", &r->in.Group);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_AddGroupToGroupSet");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_RemoveGroupFromGroupSet(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_RemoveGroupFromGroupSet *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.Group));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_RemoveGroupFromGroupSet(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_RemoveGroupFromGroupSet *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.Group));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_RemoveGroupFromGroupSet(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_RemoveGroupFromGroupSet *r)
{
	ndr_print_struct(ndr, name, "clusapi_RemoveGroupFromGroupSet");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_RemoveGroupFromGroupSet");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "Group", &r->in.Group);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_RemoveGroupFromGroupSet");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_MoveGroupToGroupSet(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_MoveGroupToGroupSet *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.GroupSet));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.Group));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_MoveGroupToGroupSet(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_MoveGroupToGroupSet *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.GroupSet));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.Group));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_MoveGroupToGroupSet(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_MoveGroupToGroupSet *r)
{
	ndr_print_struct(ndr, name, "clusapi_MoveGroupToGroupSet");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_MoveGroupToGroupSet");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "GroupSet", &r->in.GroupSet);
		ndr_print_policy_handle(ndr, "Group", &r->in.Group);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_MoveGroupToGroupSet");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Opnum170NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct Opnum170NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Opnum170NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct Opnum170NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Opnum170NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct Opnum170NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "Opnum170NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Opnum170NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Opnum170NotUsedOnWire");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_AddGroupSetDependency(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_AddGroupSetDependency *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.DependentGroupSet));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.ProviderGroupSet));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_AddGroupSetDependency(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_AddGroupSetDependency *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.DependentGroupSet));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.ProviderGroupSet));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_AddGroupSetDependency(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_AddGroupSetDependency *r)
{
	ndr_print_struct(ndr, name, "clusapi_AddGroupSetDependency");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_AddGroupSetDependency");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "DependentGroupSet", &r->in.DependentGroupSet);
		ndr_print_policy_handle(ndr, "ProviderGroupSet", &r->in.ProviderGroupSet);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_AddGroupSetDependency");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_AddGroupToGroupSetDependency(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_AddGroupToGroupSetDependency *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.DependentGroup));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.ProviderGroupSet));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_AddGroupToGroupSetDependency(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_AddGroupToGroupSetDependency *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.DependentGroup));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.ProviderGroupSet));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_AddGroupToGroupSetDependency(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_AddGroupToGroupSetDependency *r)
{
	ndr_print_struct(ndr, name, "clusapi_AddGroupToGroupSetDependency");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_AddGroupToGroupSetDependency");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "DependentGroup", &r->in.DependentGroup);
		ndr_print_policy_handle(ndr, "ProviderGroupSet", &r->in.ProviderGroupSet);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_AddGroupToGroupSetDependency");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_NodeGroupSetControl(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_NodeGroupSetControl *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hGroupSet));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_push_clusapi_GroupSetControlCode(ndr, NDR_SCALARS, r->in.dwControlCode));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpInBuffer));
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nInBufferSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, r->in.nInBufferSize));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nInBufferSize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nOutBufferSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpOutBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpBytesReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpcbRequired == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nOutBufferSize));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpcbRequired));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_NodeGroupSetControl(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_NodeGroupSetControl *r)
{
	uint32_t _ptr_lpInBuffer;
	uint32_t size_lpInBuffer_1 = 0;
	uint32_t size_lpOutBuffer_1 = 0;
	uint32_t length_lpOutBuffer_1 = 0;
	TALLOC_CTX *_mem_save_lpInBuffer_0 = NULL;
	TALLOC_CTX *_mem_save_lpBytesReturned_0 = NULL;
	TALLOC_CTX *_mem_save_lpcbRequired_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hGroupSet));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNode));
		NDR_CHECK(ndr_pull_clusapi_GroupSetControlCode(ndr, NDR_SCALARS, &r->in.dwControlCode));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpInBuffer));
		if (_ptr_lpInBuffer) {
			NDR_PULL_ALLOC(ndr, r->in.lpInBuffer);
		} else {
			r->in.lpInBuffer = NULL;
		}
		if (r->in.lpInBuffer) {
			_mem_save_lpInBuffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpInBuffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpInBuffer));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpInBuffer, &size_lpInBuffer_1));
			NDR_PULL_ALLOC_N(ndr, r->in.lpInBuffer, size_lpInBuffer_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, size_lpInBuffer_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpInBuffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nInBufferSize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nOutBufferSize));
		if (r->in.nOutBufferSize > 2147483647) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.nOutBufferSize), (uint32_t)(0), (uint32_t)(2147483647));
		}
		NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, r->in.nOutBufferSize);
		memset(r->out.lpOutBuffer, 0, (r->in.nOutBufferSize) * sizeof(*r->out.lpOutBuffer));
		NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		NDR_ZERO_STRUCTP(r->out.lpBytesReturned);
		NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		NDR_ZERO_STRUCTP(r->out.lpcbRequired);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpInBuffer, r->in.nInBufferSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.lpOutBuffer, &size_lpOutBuffer_1));
		NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->out.lpOutBuffer, &length_lpOutBuffer_1));
		if (length_lpOutBuffer_1 > size_lpOutBuffer_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpOutBuffer_1, length_lpOutBuffer_1);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, size_lpOutBuffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, length_lpOutBuffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		}
		_mem_save_lpBytesReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpBytesReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpBytesReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpBytesReturned_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		}
		_mem_save_lpcbRequired_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpcbRequired, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpcbRequired));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpcbRequired_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.lpOutBuffer, r->in.nOutBufferSize));
		}
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->out.lpOutBuffer, *r->out.lpBytesReturned));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_NodeGroupSetControl(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_NodeGroupSetControl *r)
{
	ndr_print_struct(ndr, name, "clusapi_NodeGroupSetControl");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_NodeGroupSetControl");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroupSet", &r->in.hGroupSet);
		ndr_print_policy_handle(ndr, "hNode", &r->in.hNode);
		ndr_print_clusapi_GroupSetControlCode(ndr, "dwControlCode", r->in.dwControlCode);
		ndr_print_ptr(ndr, "lpInBuffer", r->in.lpInBuffer);
		ndr->depth++;
		if (r->in.lpInBuffer) {
			ndr_print_array_uint8(ndr, "lpInBuffer", r->in.lpInBuffer, r->in.nInBufferSize);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "nInBufferSize", r->in.nInBufferSize);
		ndr_print_uint32(ndr, "nOutBufferSize", r->in.nOutBufferSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_NodeGroupSetControl");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpOutBuffer", r->out.lpOutBuffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpOutBuffer", r->out.lpOutBuffer, *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpBytesReturned", r->out.lpBytesReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpBytesReturned", *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpcbRequired", r->out.lpcbRequired);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpcbRequired", *r->out.lpcbRequired);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_GroupSetControl(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_GroupSetControl *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hGroupSet));
		NDR_CHECK(ndr_push_clusapi_GroupSetControlCode(ndr, NDR_SCALARS, r->in.dwControlCode));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpInBuffer));
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nInBufferSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, r->in.nInBufferSize));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nInBufferSize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nOutBufferSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpOutBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpBytesReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.lpcbRequired == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nOutBufferSize));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpBytesReturned));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpcbRequired));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_GroupSetControl(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_GroupSetControl *r)
{
	uint32_t _ptr_lpInBuffer;
	uint32_t size_lpInBuffer_1 = 0;
	uint32_t size_lpOutBuffer_1 = 0;
	uint32_t length_lpOutBuffer_1 = 0;
	TALLOC_CTX *_mem_save_lpInBuffer_0 = NULL;
	TALLOC_CTX *_mem_save_lpBytesReturned_0 = NULL;
	TALLOC_CTX *_mem_save_lpcbRequired_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hGroupSet));
		NDR_CHECK(ndr_pull_clusapi_GroupSetControlCode(ndr, NDR_SCALARS, &r->in.dwControlCode));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpInBuffer));
		if (_ptr_lpInBuffer) {
			NDR_PULL_ALLOC(ndr, r->in.lpInBuffer);
		} else {
			r->in.lpInBuffer = NULL;
		}
		if (r->in.lpInBuffer) {
			_mem_save_lpInBuffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpInBuffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpInBuffer));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpInBuffer, &size_lpInBuffer_1));
			NDR_PULL_ALLOC_N(ndr, r->in.lpInBuffer, size_lpInBuffer_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpInBuffer, size_lpInBuffer_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpInBuffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nInBufferSize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nOutBufferSize));
		if (r->in.nOutBufferSize > 2147483647) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.nOutBufferSize), (uint32_t)(0), (uint32_t)(2147483647));
		}
		NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, r->in.nOutBufferSize);
		memset(r->out.lpOutBuffer, 0, (r->in.nOutBufferSize) * sizeof(*r->out.lpOutBuffer));
		NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		NDR_ZERO_STRUCTP(r->out.lpBytesReturned);
		NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		NDR_ZERO_STRUCTP(r->out.lpcbRequired);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
		if (r->in.lpInBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpInBuffer, r->in.nInBufferSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.lpOutBuffer));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.lpOutBuffer, &size_lpOutBuffer_1));
		NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->out.lpOutBuffer, &length_lpOutBuffer_1));
		if (length_lpOutBuffer_1 > size_lpOutBuffer_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpOutBuffer_1, length_lpOutBuffer_1);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.lpOutBuffer, size_lpOutBuffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.lpOutBuffer, length_lpOutBuffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpBytesReturned);
		}
		_mem_save_lpBytesReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpBytesReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpBytesReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpBytesReturned_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpcbRequired);
		}
		_mem_save_lpcbRequired_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpcbRequired, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpcbRequired));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpcbRequired_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.lpOutBuffer, r->in.nOutBufferSize));
		}
		if (r->out.lpOutBuffer) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->out.lpOutBuffer, *r->out.lpBytesReturned));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_GroupSetControl(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_GroupSetControl *r)
{
	ndr_print_struct(ndr, name, "clusapi_GroupSetControl");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_GroupSetControl");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroupSet", &r->in.hGroupSet);
		ndr_print_clusapi_GroupSetControlCode(ndr, "dwControlCode", r->in.dwControlCode);
		ndr_print_ptr(ndr, "lpInBuffer", r->in.lpInBuffer);
		ndr->depth++;
		if (r->in.lpInBuffer) {
			ndr_print_array_uint8(ndr, "lpInBuffer", r->in.lpInBuffer, r->in.nInBufferSize);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "nInBufferSize", r->in.nInBufferSize);
		ndr_print_uint32(ndr, "nOutBufferSize", r->in.nOutBufferSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_GroupSetControl");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpOutBuffer", r->out.lpOutBuffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "lpOutBuffer", r->out.lpOutBuffer, *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpBytesReturned", r->out.lpBytesReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpBytesReturned", *r->out.lpBytesReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpcbRequired", r->out.lpcbRequired);
		ndr->depth++;
		ndr_print_uint32(ndr, "lpcbRequired", *r->out.lpcbRequired);
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_SetGroupDependencyExpression(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_SetGroupDependencyExpression *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszDependencyExpression == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszDependencyExpression, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszDependencyExpression, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszDependencyExpression, ndr_charset_length(r->in.lpszDependencyExpression, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_SetGroupDependencyExpression(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_SetGroupDependencyExpression *r)
{
	uint32_t size_lpszDependencyExpression_1 = 0;
	uint32_t length_lpszDependencyExpression_1 = 0;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszDependencyExpression));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszDependencyExpression));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszDependencyExpression, &size_lpszDependencyExpression_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszDependencyExpression, &length_lpszDependencyExpression_1));
		if (length_lpszDependencyExpression_1 > size_lpszDependencyExpression_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszDependencyExpression_1, length_lpszDependencyExpression_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszDependencyExpression_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszDependencyExpression, length_lpszDependencyExpression_1, sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_SetGroupDependencyExpression(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_SetGroupDependencyExpression *r)
{
	ndr_print_struct(ndr, name, "clusapi_SetGroupDependencyExpression");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_SetGroupDependencyExpression");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroup", &r->in.hGroup);
		ndr_print_ptr(ndr, "lpszDependencyExpression", r->in.lpszDependencyExpression);
		ndr->depth++;
		ndr_print_string(ndr, "lpszDependencyExpression", r->in.lpszDependencyExpression);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_SetGroupDependencyExpression");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_RemoveClusterGroupDependency(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_RemoveClusterGroupDependency *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hDependsOn));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_RemoveClusterGroupDependency(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_RemoveClusterGroupDependency *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hDependsOn));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_RemoveClusterGroupDependency(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_RemoveClusterGroupDependency *r)
{
	ndr_print_struct(ndr, name, "clusapi_RemoveClusterGroupDependency");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_RemoveClusterGroupDependency");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroup", &r->in.hGroup);
		ndr_print_policy_handle(ndr, "hDependsOn", &r->in.hDependsOn);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_RemoveClusterGroupDependency");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_SetGroupSetDependencyExpression(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_SetGroupSetDependencyExpression *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszDependencyExpression == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hGroupSet));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszDependencyExpression, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszDependencyExpression, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszDependencyExpression, ndr_charset_length(r->in.lpszDependencyExpression, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_SetGroupSetDependencyExpression(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_SetGroupSetDependencyExpression *r)
{
	uint32_t size_lpszDependencyExpression_1 = 0;
	uint32_t length_lpszDependencyExpression_1 = 0;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hGroupSet));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszDependencyExpression));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszDependencyExpression));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszDependencyExpression, &size_lpszDependencyExpression_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszDependencyExpression, &length_lpszDependencyExpression_1));
		if (length_lpszDependencyExpression_1 > size_lpszDependencyExpression_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszDependencyExpression_1, length_lpszDependencyExpression_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszDependencyExpression_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszDependencyExpression, length_lpszDependencyExpression_1, sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_SetGroupSetDependencyExpression(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_SetGroupSetDependencyExpression *r)
{
	ndr_print_struct(ndr, name, "clusapi_SetGroupSetDependencyExpression");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_SetGroupSetDependencyExpression");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroupSet", &r->in.hGroupSet);
		ndr_print_ptr(ndr, "lpszDependencyExpression", r->in.lpszDependencyExpression);
		ndr->depth++;
		ndr_print_string(ndr, "lpszDependencyExpression", r->in.lpszDependencyExpression);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_SetGroupSetDependencyExpression");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_RemoveGroupSetDependency(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_RemoveGroupSetDependency *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hGroupSet));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hDependsOn));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_RemoveGroupSetDependency(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_RemoveGroupSetDependency *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hGroupSet));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hDependsOn));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_RemoveGroupSetDependency(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_RemoveGroupSetDependency *r)
{
	ndr_print_struct(ndr, name, "clusapi_RemoveGroupSetDependency");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_RemoveGroupSetDependency");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroupSet", &r->in.hGroupSet);
		ndr_print_policy_handle(ndr, "hDependsOn", &r->in.hDependsOn);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_RemoveGroupSetDependency");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_RemoveClusterGroupToGroupSetDependency(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_RemoveClusterGroupToGroupSetDependency *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hDependsOn));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_RemoveClusterGroupToGroupSetDependency(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_RemoveClusterGroupToGroupSetDependency *r)
{
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hGroup));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hDependsOn));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_RemoveClusterGroupToGroupSetDependency(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_RemoveClusterGroupToGroupSetDependency *r)
{
	ndr_print_struct(ndr, name, "clusapi_RemoveClusterGroupToGroupSetDependency");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_RemoveClusterGroupToGroupSetDependency");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hGroup", &r->in.hGroup);
		ndr_print_policy_handle(ndr, "hDependsOn", &r->in.hDependsOn);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_RemoveClusterGroupToGroupSetDependency");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CreateGroupSetEnum(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CreateGroupSetEnum *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hCluster));
	}
	if (flags & NDR_OUT) {
		if (r->out.ReturnEnum == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ReturnEnum));
		if (*r->out.ReturnEnum) {
			NDR_CHECK(ndr_push_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ReturnEnum));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CreateGroupSetEnum(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CreateGroupSetEnum *r)
{
	uint32_t _ptr_ReturnEnum;
	TALLOC_CTX *_mem_save_ReturnEnum_0 = NULL;
	TALLOC_CTX *_mem_save_ReturnEnum_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hCluster));
		NDR_PULL_ALLOC(ndr, r->out.ReturnEnum);
		NDR_ZERO_STRUCTP(r->out.ReturnEnum);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ReturnEnum);
		}
		_mem_save_ReturnEnum_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ReturnEnum, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ReturnEnum));
		if (_ptr_ReturnEnum) {
			NDR_PULL_ALLOC(ndr, *r->out.ReturnEnum);
		} else {
			*r->out.ReturnEnum = NULL;
		}
		if (*r->out.ReturnEnum) {
			_mem_save_ReturnEnum_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ReturnEnum, 0);
			NDR_CHECK(ndr_pull_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ReturnEnum));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReturnEnum_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReturnEnum_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CreateGroupSetEnum(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CreateGroupSetEnum *r)
{
	ndr_print_struct(ndr, name, "clusapi_CreateGroupSetEnum");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CreateGroupSetEnum");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hCluster", &r->in.hCluster);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CreateGroupSetEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "ReturnEnum", r->out.ReturnEnum);
		ndr->depth++;
		ndr_print_ptr(ndr, "ReturnEnum", *r->out.ReturnEnum);
		ndr->depth++;
		if (*r->out.ReturnEnum) {
			ndr_print_ENUM_LIST(ndr, "ReturnEnum", *r->out.ReturnEnum);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_CreateNetInterfaceEnum(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_CreateNetInterfaceEnum *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszNodeName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.lpszNetworkName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hCluster));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszNodeName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszNodeName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszNodeName, ndr_charset_length(r->in.lpszNodeName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszNetworkName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszNetworkName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszNetworkName, ndr_charset_length(r->in.lpszNetworkName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.ReturnEnum == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ReturnEnum));
		if (*r->out.ReturnEnum) {
			NDR_CHECK(ndr_push_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ReturnEnum));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_CreateNetInterfaceEnum(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_CreateNetInterfaceEnum *r)
{
	uint32_t size_lpszNodeName_1 = 0;
	uint32_t length_lpszNodeName_1 = 0;
	uint32_t size_lpszNetworkName_1 = 0;
	uint32_t length_lpszNetworkName_1 = 0;
	uint32_t _ptr_ReturnEnum;
	TALLOC_CTX *_mem_save_ReturnEnum_0 = NULL;
	TALLOC_CTX *_mem_save_ReturnEnum_1 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hCluster));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszNodeName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszNodeName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszNodeName, &size_lpszNodeName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszNodeName, &length_lpszNodeName_1));
		if (length_lpszNodeName_1 > size_lpszNodeName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszNodeName_1, length_lpszNodeName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszNodeName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszNodeName, length_lpszNodeName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszNetworkName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszNetworkName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszNetworkName, &size_lpszNetworkName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszNetworkName, &length_lpszNetworkName_1));
		if (length_lpszNetworkName_1 > size_lpszNetworkName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszNetworkName_1, length_lpszNetworkName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszNetworkName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszNetworkName, length_lpszNetworkName_1, sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.ReturnEnum);
		NDR_ZERO_STRUCTP(r->out.ReturnEnum);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ReturnEnum);
		}
		_mem_save_ReturnEnum_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ReturnEnum, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ReturnEnum));
		if (_ptr_ReturnEnum) {
			NDR_PULL_ALLOC(ndr, *r->out.ReturnEnum);
		} else {
			*r->out.ReturnEnum = NULL;
		}
		if (*r->out.ReturnEnum) {
			_mem_save_ReturnEnum_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ReturnEnum, 0);
			NDR_CHECK(ndr_pull_ENUM_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ReturnEnum));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReturnEnum_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReturnEnum_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_CreateNetInterfaceEnum(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_CreateNetInterfaceEnum *r)
{
	ndr_print_struct(ndr, name, "clusapi_CreateNetInterfaceEnum");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_CreateNetInterfaceEnum");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hCluster", &r->in.hCluster);
		ndr_print_ptr(ndr, "lpszNodeName", r->in.lpszNodeName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszNodeName", r->in.lpszNodeName);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpszNetworkName", r->in.lpszNetworkName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszNetworkName", r->in.lpszNetworkName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_CreateNetInterfaceEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "ReturnEnum", r->out.ReturnEnum);
		ndr->depth++;
		ndr_print_ptr(ndr, "ReturnEnum", *r->out.ReturnEnum);
		ndr->depth++;
		if (*r->out.ReturnEnum) {
			ndr_print_ENUM_LIST(ndr, "ReturnEnum", *r->out.ReturnEnum);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_ChangeCsvStateEx(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_ChangeCsvStateEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpszVolumeName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwState));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszVolumeName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpszVolumeName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpszVolumeName, ndr_charset_length(r->in.lpszVolumeName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_ChangeCsvStateEx(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_ChangeCsvStateEx *r)
{
	uint32_t size_lpszVolumeName_1 = 0;
	uint32_t length_lpszVolumeName_1 = 0;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hResource));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwState));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpszVolumeName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpszVolumeName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpszVolumeName, &size_lpszVolumeName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpszVolumeName, &length_lpszVolumeName_1));
		if (length_lpszVolumeName_1 > size_lpszVolumeName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpszVolumeName_1, length_lpszVolumeName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpszVolumeName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpszVolumeName, length_lpszVolumeName_1, sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_ChangeCsvStateEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_ChangeCsvStateEx *r)
{
	ndr_print_struct(ndr, name, "clusapi_ChangeCsvStateEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_ChangeCsvStateEx");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hResource", &r->in.hResource);
		ndr_print_uint32(ndr, "dwState", r->in.dwState);
		ndr_print_ptr(ndr, "lpszVolumeName", r->in.lpszVolumeName);
		ndr->depth++;
		ndr_print_string(ndr, "lpszVolumeName", r->in.lpszVolumeName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_ChangeCsvStateEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_clusapi_AddGroupToGroupSetEx(struct ndr_push *ndr, ndr_flags_type flags, const struct clusapi_AddGroupToGroupSetEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.Reserved == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.GroupSet));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.Group));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.FaultDomain));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.UpdateDomain));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->in.UseDomains));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.Reserved));
	}
	if (flags & NDR_OUT) {
		if (r->out.rpc_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.rpc_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_clusapi_AddGroupToGroupSetEx(struct ndr_pull *ndr, ndr_flags_type flags, struct clusapi_AddGroupToGroupSetEx *r)
{
	TALLOC_CTX *_mem_save_Reserved_0 = NULL;
	TALLOC_CTX *_mem_save_rpc_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.GroupSet));
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.Group));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.FaultDomain));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.UpdateDomain));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->in.UseDomains));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.Reserved);
		}
		_mem_save_Reserved_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.Reserved, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.Reserved));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Reserved_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		NDR_ZERO_STRUCTP(r->out.rpc_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.Reserved == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.Reserved);
			NDR_ZERO_STRUCTP(r->in.Reserved);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rpc_status);
		}
		_mem_save_rpc_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rpc_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.rpc_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rpc_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_clusapi_AddGroupToGroupSetEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct clusapi_AddGroupToGroupSetEx *r)
{
	ndr_print_struct(ndr, name, "clusapi_AddGroupToGroupSetEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "clusapi_AddGroupToGroupSetEx");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "GroupSet", &r->in.GroupSet);
		ndr_print_policy_handle(ndr, "Group", &r->in.Group);
		ndr_print_uint32(ndr, "FaultDomain", r->in.FaultDomain);
		ndr_print_uint32(ndr, "UpdateDomain", r->in.UpdateDomain);
		ndr_print_uint8(ndr, "UseDomains", r->in.UseDomains);
		ndr_print_ptr(ndr, "Reserved", r->in.Reserved);
		ndr->depth++;
		ndr_print_uint32(ndr, "Reserved", *r->in.Reserved);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "clusapi_AddGroupToGroupSetEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "rpc_status", r->out.rpc_status);
		ndr->depth++;
		ndr_print_WERROR(ndr, "rpc_status", *r->out.rpc_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_clusapi
static const struct ndr_interface_public_struct clusapi_public_structs[] = {
	{
		.name = "CLUS_RESOURCE_CLASS_INFO",
		.struct_size = sizeof(struct CLUS_RESOURCE_CLASS_INFO ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_CLUS_RESOURCE_CLASS_INFO,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_CLUS_RESOURCE_CLASS_INFO,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_CLUS_RESOURCE_CLASS_INFO,
	},
	{
		.name = "clusapi_PROPERTY_LIST",
		.struct_size = sizeof(struct clusapi_PROPERTY_LIST ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_clusapi_PROPERTY_LIST,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_clusapi_PROPERTY_LIST,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_clusapi_PROPERTY_LIST,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call clusapi_calls[] = {
	{
		"clusapi_OpenCluster",
		sizeof(struct clusapi_OpenCluster),
		(ndr_push_flags_fn_t) ndr_push_clusapi_OpenCluster,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_OpenCluster,
		(ndr_print_function_t) ndr_print_clusapi_OpenCluster,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CloseCluster",
		sizeof(struct clusapi_CloseCluster),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CloseCluster,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CloseCluster,
		(ndr_print_function_t) ndr_print_clusapi_CloseCluster,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_SetClusterName",
		sizeof(struct clusapi_SetClusterName),
		(ndr_push_flags_fn_t) ndr_push_clusapi_SetClusterName,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_SetClusterName,
		(ndr_print_function_t) ndr_print_clusapi_SetClusterName,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_GetClusterName",
		sizeof(struct clusapi_GetClusterName),
		(ndr_push_flags_fn_t) ndr_push_clusapi_GetClusterName,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_GetClusterName,
		(ndr_print_function_t) ndr_print_clusapi_GetClusterName,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_GetClusterVersion",
		sizeof(struct clusapi_GetClusterVersion),
		(ndr_push_flags_fn_t) ndr_push_clusapi_GetClusterVersion,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_GetClusterVersion,
		(ndr_print_function_t) ndr_print_clusapi_GetClusterVersion,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_GetQuorumResource",
		sizeof(struct clusapi_GetQuorumResource),
		(ndr_push_flags_fn_t) ndr_push_clusapi_GetQuorumResource,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_GetQuorumResource,
		(ndr_print_function_t) ndr_print_clusapi_GetQuorumResource,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_SetQuorumResource",
		sizeof(struct clusapi_SetQuorumResource),
		(ndr_push_flags_fn_t) ndr_push_clusapi_SetQuorumResource,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_SetQuorumResource,
		(ndr_print_function_t) ndr_print_clusapi_SetQuorumResource,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CreateEnum",
		sizeof(struct clusapi_CreateEnum),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CreateEnum,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CreateEnum,
		(ndr_print_function_t) ndr_print_clusapi_CreateEnum,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_OpenResource",
		sizeof(struct clusapi_OpenResource),
		(ndr_push_flags_fn_t) ndr_push_clusapi_OpenResource,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_OpenResource,
		(ndr_print_function_t) ndr_print_clusapi_OpenResource,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CreateResource",
		sizeof(struct clusapi_CreateResource),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CreateResource,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CreateResource,
		(ndr_print_function_t) ndr_print_clusapi_CreateResource,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_DeleteResource",
		sizeof(struct clusapi_DeleteResource),
		(ndr_push_flags_fn_t) ndr_push_clusapi_DeleteResource,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_DeleteResource,
		(ndr_print_function_t) ndr_print_clusapi_DeleteResource,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CloseResource",
		sizeof(struct clusapi_CloseResource),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CloseResource,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CloseResource,
		(ndr_print_function_t) ndr_print_clusapi_CloseResource,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_GetResourceState",
		sizeof(struct clusapi_GetResourceState),
		(ndr_push_flags_fn_t) ndr_push_clusapi_GetResourceState,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_GetResourceState,
		(ndr_print_function_t) ndr_print_clusapi_GetResourceState,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_SetResourceName",
		sizeof(struct clusapi_SetResourceName),
		(ndr_push_flags_fn_t) ndr_push_clusapi_SetResourceName,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_SetResourceName,
		(ndr_print_function_t) ndr_print_clusapi_SetResourceName,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_GetResourceId",
		sizeof(struct clusapi_GetResourceId),
		(ndr_push_flags_fn_t) ndr_push_clusapi_GetResourceId,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_GetResourceId,
		(ndr_print_function_t) ndr_print_clusapi_GetResourceId,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_GetResourceType",
		sizeof(struct clusapi_GetResourceType),
		(ndr_push_flags_fn_t) ndr_push_clusapi_GetResourceType,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_GetResourceType,
		(ndr_print_function_t) ndr_print_clusapi_GetResourceType,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_FailResource",
		sizeof(struct clusapi_FailResource),
		(ndr_push_flags_fn_t) ndr_push_clusapi_FailResource,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_FailResource,
		(ndr_print_function_t) ndr_print_clusapi_FailResource,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_OnlineResource",
		sizeof(struct clusapi_OnlineResource),
		(ndr_push_flags_fn_t) ndr_push_clusapi_OnlineResource,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_OnlineResource,
		(ndr_print_function_t) ndr_print_clusapi_OnlineResource,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_OfflineResource",
		sizeof(struct clusapi_OfflineResource),
		(ndr_push_flags_fn_t) ndr_push_clusapi_OfflineResource,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_OfflineResource,
		(ndr_print_function_t) ndr_print_clusapi_OfflineResource,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_AddResourceDependency",
		sizeof(struct clusapi_AddResourceDependency),
		(ndr_push_flags_fn_t) ndr_push_clusapi_AddResourceDependency,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_AddResourceDependency,
		(ndr_print_function_t) ndr_print_clusapi_AddResourceDependency,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_RemoveResourceDependency",
		sizeof(struct clusapi_RemoveResourceDependency),
		(ndr_push_flags_fn_t) ndr_push_clusapi_RemoveResourceDependency,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_RemoveResourceDependency,
		(ndr_print_function_t) ndr_print_clusapi_RemoveResourceDependency,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CanResourceBeDependent",
		sizeof(struct clusapi_CanResourceBeDependent),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CanResourceBeDependent,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CanResourceBeDependent,
		(ndr_print_function_t) ndr_print_clusapi_CanResourceBeDependent,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CreateResEnum",
		sizeof(struct clusapi_CreateResEnum),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CreateResEnum,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CreateResEnum,
		(ndr_print_function_t) ndr_print_clusapi_CreateResEnum,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_AddResourceNode",
		sizeof(struct clusapi_AddResourceNode),
		(ndr_push_flags_fn_t) ndr_push_clusapi_AddResourceNode,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_AddResourceNode,
		(ndr_print_function_t) ndr_print_clusapi_AddResourceNode,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_RemoveResourceNode",
		sizeof(struct clusapi_RemoveResourceNode),
		(ndr_push_flags_fn_t) ndr_push_clusapi_RemoveResourceNode,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_RemoveResourceNode,
		(ndr_print_function_t) ndr_print_clusapi_RemoveResourceNode,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_ChangeResourceGroup",
		sizeof(struct clusapi_ChangeResourceGroup),
		(ndr_push_flags_fn_t) ndr_push_clusapi_ChangeResourceGroup,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_ChangeResourceGroup,
		(ndr_print_function_t) ndr_print_clusapi_ChangeResourceGroup,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CreateResourceType",
		sizeof(struct clusapi_CreateResourceType),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CreateResourceType,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CreateResourceType,
		(ndr_print_function_t) ndr_print_clusapi_CreateResourceType,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_DeleteResourceType",
		sizeof(struct clusapi_DeleteResourceType),
		(ndr_push_flags_fn_t) ndr_push_clusapi_DeleteResourceType,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_DeleteResourceType,
		(ndr_print_function_t) ndr_print_clusapi_DeleteResourceType,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_GetRootKey",
		sizeof(struct clusapi_GetRootKey),
		(ndr_push_flags_fn_t) ndr_push_clusapi_GetRootKey,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_GetRootKey,
		(ndr_print_function_t) ndr_print_clusapi_GetRootKey,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CreateKey",
		sizeof(struct clusapi_CreateKey),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CreateKey,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CreateKey,
		(ndr_print_function_t) ndr_print_clusapi_CreateKey,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_OpenKey",
		sizeof(struct clusapi_OpenKey),
		(ndr_push_flags_fn_t) ndr_push_clusapi_OpenKey,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_OpenKey,
		(ndr_print_function_t) ndr_print_clusapi_OpenKey,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_EnumKey",
		sizeof(struct clusapi_EnumKey),
		(ndr_push_flags_fn_t) ndr_push_clusapi_EnumKey,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_EnumKey,
		(ndr_print_function_t) ndr_print_clusapi_EnumKey,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_SetValue",
		sizeof(struct clusapi_SetValue),
		(ndr_push_flags_fn_t) ndr_push_clusapi_SetValue,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_SetValue,
		(ndr_print_function_t) ndr_print_clusapi_SetValue,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_DeleteValue",
		sizeof(struct clusapi_DeleteValue),
		(ndr_push_flags_fn_t) ndr_push_clusapi_DeleteValue,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_DeleteValue,
		(ndr_print_function_t) ndr_print_clusapi_DeleteValue,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_QueryValue",
		sizeof(struct clusapi_QueryValue),
		(ndr_push_flags_fn_t) ndr_push_clusapi_QueryValue,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_QueryValue,
		(ndr_print_function_t) ndr_print_clusapi_QueryValue,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_DeleteKey",
		sizeof(struct clusapi_DeleteKey),
		(ndr_push_flags_fn_t) ndr_push_clusapi_DeleteKey,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_DeleteKey,
		(ndr_print_function_t) ndr_print_clusapi_DeleteKey,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_EnumValue",
		sizeof(struct clusapi_EnumValue),
		(ndr_push_flags_fn_t) ndr_push_clusapi_EnumValue,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_EnumValue,
		(ndr_print_function_t) ndr_print_clusapi_EnumValue,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CloseKey",
		sizeof(struct clusapi_CloseKey),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CloseKey,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CloseKey,
		(ndr_print_function_t) ndr_print_clusapi_CloseKey,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_QueryInfoKey",
		sizeof(struct clusapi_QueryInfoKey),
		(ndr_push_flags_fn_t) ndr_push_clusapi_QueryInfoKey,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_QueryInfoKey,
		(ndr_print_function_t) ndr_print_clusapi_QueryInfoKey,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_SetKeySecurity",
		sizeof(struct clusapi_SetKeySecurity),
		(ndr_push_flags_fn_t) ndr_push_clusapi_SetKeySecurity,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_SetKeySecurity,
		(ndr_print_function_t) ndr_print_clusapi_SetKeySecurity,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_GetKeySecurity",
		sizeof(struct clusapi_GetKeySecurity),
		(ndr_push_flags_fn_t) ndr_push_clusapi_GetKeySecurity,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_GetKeySecurity,
		(ndr_print_function_t) ndr_print_clusapi_GetKeySecurity,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_OpenGroup",
		sizeof(struct clusapi_OpenGroup),
		(ndr_push_flags_fn_t) ndr_push_clusapi_OpenGroup,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_OpenGroup,
		(ndr_print_function_t) ndr_print_clusapi_OpenGroup,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CreateGroup",
		sizeof(struct clusapi_CreateGroup),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CreateGroup,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CreateGroup,
		(ndr_print_function_t) ndr_print_clusapi_CreateGroup,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_DeleteGroup",
		sizeof(struct clusapi_DeleteGroup),
		(ndr_push_flags_fn_t) ndr_push_clusapi_DeleteGroup,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_DeleteGroup,
		(ndr_print_function_t) ndr_print_clusapi_DeleteGroup,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CloseGroup",
		sizeof(struct clusapi_CloseGroup),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CloseGroup,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CloseGroup,
		(ndr_print_function_t) ndr_print_clusapi_CloseGroup,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_GetGroupState",
		sizeof(struct clusapi_GetGroupState),
		(ndr_push_flags_fn_t) ndr_push_clusapi_GetGroupState,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_GetGroupState,
		(ndr_print_function_t) ndr_print_clusapi_GetGroupState,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_SetGroupName",
		sizeof(struct clusapi_SetGroupName),
		(ndr_push_flags_fn_t) ndr_push_clusapi_SetGroupName,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_SetGroupName,
		(ndr_print_function_t) ndr_print_clusapi_SetGroupName,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_GetGroupId",
		sizeof(struct clusapi_GetGroupId),
		(ndr_push_flags_fn_t) ndr_push_clusapi_GetGroupId,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_GetGroupId,
		(ndr_print_function_t) ndr_print_clusapi_GetGroupId,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_GetNodeId",
		sizeof(struct clusapi_GetNodeId),
		(ndr_push_flags_fn_t) ndr_push_clusapi_GetNodeId,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_GetNodeId,
		(ndr_print_function_t) ndr_print_clusapi_GetNodeId,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_OnlineGroup",
		sizeof(struct clusapi_OnlineGroup),
		(ndr_push_flags_fn_t) ndr_push_clusapi_OnlineGroup,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_OnlineGroup,
		(ndr_print_function_t) ndr_print_clusapi_OnlineGroup,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_OfflineGroup",
		sizeof(struct clusapi_OfflineGroup),
		(ndr_push_flags_fn_t) ndr_push_clusapi_OfflineGroup,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_OfflineGroup,
		(ndr_print_function_t) ndr_print_clusapi_OfflineGroup,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_MoveGroup",
		sizeof(struct clusapi_MoveGroup),
		(ndr_push_flags_fn_t) ndr_push_clusapi_MoveGroup,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_MoveGroup,
		(ndr_print_function_t) ndr_print_clusapi_MoveGroup,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_MoveGroupToNode",
		sizeof(struct clusapi_MoveGroupToNode),
		(ndr_push_flags_fn_t) ndr_push_clusapi_MoveGroupToNode,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_MoveGroupToNode,
		(ndr_print_function_t) ndr_print_clusapi_MoveGroupToNode,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CreateGroupResourceEnum",
		sizeof(struct clusapi_CreateGroupResourceEnum),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CreateGroupResourceEnum,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CreateGroupResourceEnum,
		(ndr_print_function_t) ndr_print_clusapi_CreateGroupResourceEnum,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_SetGroupNodeList",
		sizeof(struct clusapi_SetGroupNodeList),
		(ndr_push_flags_fn_t) ndr_push_clusapi_SetGroupNodeList,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_SetGroupNodeList,
		(ndr_print_function_t) ndr_print_clusapi_SetGroupNodeList,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CreateNotify",
		sizeof(struct clusapi_CreateNotify),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CreateNotify,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CreateNotify,
		(ndr_print_function_t) ndr_print_clusapi_CreateNotify,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CloseNotify",
		sizeof(struct clusapi_CloseNotify),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CloseNotify,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CloseNotify,
		(ndr_print_function_t) ndr_print_clusapi_CloseNotify,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_AddNotifyCluster",
		sizeof(struct clusapi_AddNotifyCluster),
		(ndr_push_flags_fn_t) ndr_push_clusapi_AddNotifyCluster,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_AddNotifyCluster,
		(ndr_print_function_t) ndr_print_clusapi_AddNotifyCluster,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_AddNotifyNode",
		sizeof(struct clusapi_AddNotifyNode),
		(ndr_push_flags_fn_t) ndr_push_clusapi_AddNotifyNode,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_AddNotifyNode,
		(ndr_print_function_t) ndr_print_clusapi_AddNotifyNode,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_AddNotifyGroup",
		sizeof(struct clusapi_AddNotifyGroup),
		(ndr_push_flags_fn_t) ndr_push_clusapi_AddNotifyGroup,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_AddNotifyGroup,
		(ndr_print_function_t) ndr_print_clusapi_AddNotifyGroup,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_AddNotifyResource",
		sizeof(struct clusapi_AddNotifyResource),
		(ndr_push_flags_fn_t) ndr_push_clusapi_AddNotifyResource,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_AddNotifyResource,
		(ndr_print_function_t) ndr_print_clusapi_AddNotifyResource,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_AddNotifyKey",
		sizeof(struct clusapi_AddNotifyKey),
		(ndr_push_flags_fn_t) ndr_push_clusapi_AddNotifyKey,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_AddNotifyKey,
		(ndr_print_function_t) ndr_print_clusapi_AddNotifyKey,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_ReAddNotifyNode",
		sizeof(struct clusapi_ReAddNotifyNode),
		(ndr_push_flags_fn_t) ndr_push_clusapi_ReAddNotifyNode,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_ReAddNotifyNode,
		(ndr_print_function_t) ndr_print_clusapi_ReAddNotifyNode,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_ReAddNotifyGroup",
		sizeof(struct clusapi_ReAddNotifyGroup),
		(ndr_push_flags_fn_t) ndr_push_clusapi_ReAddNotifyGroup,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_ReAddNotifyGroup,
		(ndr_print_function_t) ndr_print_clusapi_ReAddNotifyGroup,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_ReAddNotifyResource",
		sizeof(struct clusapi_ReAddNotifyResource),
		(ndr_push_flags_fn_t) ndr_push_clusapi_ReAddNotifyResource,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_ReAddNotifyResource,
		(ndr_print_function_t) ndr_print_clusapi_ReAddNotifyResource,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_GetNotify",
		sizeof(struct clusapi_GetNotify),
		(ndr_push_flags_fn_t) ndr_push_clusapi_GetNotify,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_GetNotify,
		(ndr_print_function_t) ndr_print_clusapi_GetNotify,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_OpenNode",
		sizeof(struct clusapi_OpenNode),
		(ndr_push_flags_fn_t) ndr_push_clusapi_OpenNode,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_OpenNode,
		(ndr_print_function_t) ndr_print_clusapi_OpenNode,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CloseNode",
		sizeof(struct clusapi_CloseNode),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CloseNode,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CloseNode,
		(ndr_print_function_t) ndr_print_clusapi_CloseNode,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_GetNodeState",
		sizeof(struct clusapi_GetNodeState),
		(ndr_push_flags_fn_t) ndr_push_clusapi_GetNodeState,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_GetNodeState,
		(ndr_print_function_t) ndr_print_clusapi_GetNodeState,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_PauseNode",
		sizeof(struct clusapi_PauseNode),
		(ndr_push_flags_fn_t) ndr_push_clusapi_PauseNode,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_PauseNode,
		(ndr_print_function_t) ndr_print_clusapi_PauseNode,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_ResumeNode",
		sizeof(struct clusapi_ResumeNode),
		(ndr_push_flags_fn_t) ndr_push_clusapi_ResumeNode,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_ResumeNode,
		(ndr_print_function_t) ndr_print_clusapi_ResumeNode,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_EvictNode",
		sizeof(struct clusapi_EvictNode),
		(ndr_push_flags_fn_t) ndr_push_clusapi_EvictNode,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_EvictNode,
		(ndr_print_function_t) ndr_print_clusapi_EvictNode,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_NodeResourceControl",
		sizeof(struct clusapi_NodeResourceControl),
		(ndr_push_flags_fn_t) ndr_push_clusapi_NodeResourceControl,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_NodeResourceControl,
		(ndr_print_function_t) ndr_print_clusapi_NodeResourceControl,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_ResourceControl",
		sizeof(struct clusapi_ResourceControl),
		(ndr_push_flags_fn_t) ndr_push_clusapi_ResourceControl,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_ResourceControl,
		(ndr_print_function_t) ndr_print_clusapi_ResourceControl,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_NodeResourceTypeControl",
		sizeof(struct clusapi_NodeResourceTypeControl),
		(ndr_push_flags_fn_t) ndr_push_clusapi_NodeResourceTypeControl,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_NodeResourceTypeControl,
		(ndr_print_function_t) ndr_print_clusapi_NodeResourceTypeControl,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_ResourceTypeControl",
		sizeof(struct clusapi_ResourceTypeControl),
		(ndr_push_flags_fn_t) ndr_push_clusapi_ResourceTypeControl,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_ResourceTypeControl,
		(ndr_print_function_t) ndr_print_clusapi_ResourceTypeControl,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_NodeGroupControl",
		sizeof(struct clusapi_NodeGroupControl),
		(ndr_push_flags_fn_t) ndr_push_clusapi_NodeGroupControl,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_NodeGroupControl,
		(ndr_print_function_t) ndr_print_clusapi_NodeGroupControl,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_GroupControl",
		sizeof(struct clusapi_GroupControl),
		(ndr_push_flags_fn_t) ndr_push_clusapi_GroupControl,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_GroupControl,
		(ndr_print_function_t) ndr_print_clusapi_GroupControl,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_NodeNodeControl",
		sizeof(struct clusapi_NodeNodeControl),
		(ndr_push_flags_fn_t) ndr_push_clusapi_NodeNodeControl,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_NodeNodeControl,
		(ndr_print_function_t) ndr_print_clusapi_NodeNodeControl,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_NodeControl",
		sizeof(struct clusapi_NodeControl),
		(ndr_push_flags_fn_t) ndr_push_clusapi_NodeControl,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_NodeControl,
		(ndr_print_function_t) ndr_print_clusapi_NodeControl,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Opnum80NotUsedOnWire",
		sizeof(struct Opnum80NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_Opnum80NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_Opnum80NotUsedOnWire,
		(ndr_print_function_t) ndr_print_Opnum80NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_OpenNetwork",
		sizeof(struct clusapi_OpenNetwork),
		(ndr_push_flags_fn_t) ndr_push_clusapi_OpenNetwork,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_OpenNetwork,
		(ndr_print_function_t) ndr_print_clusapi_OpenNetwork,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CloseNetwork",
		sizeof(struct clusapi_CloseNetwork),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CloseNetwork,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CloseNetwork,
		(ndr_print_function_t) ndr_print_clusapi_CloseNetwork,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_GetNetworkState",
		sizeof(struct clusapi_GetNetworkState),
		(ndr_push_flags_fn_t) ndr_push_clusapi_GetNetworkState,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_GetNetworkState,
		(ndr_print_function_t) ndr_print_clusapi_GetNetworkState,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_SetNetworkName",
		sizeof(struct clusapi_SetNetworkName),
		(ndr_push_flags_fn_t) ndr_push_clusapi_SetNetworkName,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_SetNetworkName,
		(ndr_print_function_t) ndr_print_clusapi_SetNetworkName,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CreateNetworkEnum",
		sizeof(struct clusapi_CreateNetworkEnum),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CreateNetworkEnum,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CreateNetworkEnum,
		(ndr_print_function_t) ndr_print_clusapi_CreateNetworkEnum,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_GetNetworkId",
		sizeof(struct clusapi_GetNetworkId),
		(ndr_push_flags_fn_t) ndr_push_clusapi_GetNetworkId,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_GetNetworkId,
		(ndr_print_function_t) ndr_print_clusapi_GetNetworkId,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_SetNetworkPriorityOrder",
		sizeof(struct clusapi_SetNetworkPriorityOrder),
		(ndr_push_flags_fn_t) ndr_push_clusapi_SetNetworkPriorityOrder,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_SetNetworkPriorityOrder,
		(ndr_print_function_t) ndr_print_clusapi_SetNetworkPriorityOrder,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_NodeNetworkControl",
		sizeof(struct clusapi_NodeNetworkControl),
		(ndr_push_flags_fn_t) ndr_push_clusapi_NodeNetworkControl,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_NodeNetworkControl,
		(ndr_print_function_t) ndr_print_clusapi_NodeNetworkControl,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_NetworkControl",
		sizeof(struct clusapi_NetworkControl),
		(ndr_push_flags_fn_t) ndr_push_clusapi_NetworkControl,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_NetworkControl,
		(ndr_print_function_t) ndr_print_clusapi_NetworkControl,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_AddNotifyNetwork",
		sizeof(struct clusapi_AddNotifyNetwork),
		(ndr_push_flags_fn_t) ndr_push_clusapi_AddNotifyNetwork,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_AddNotifyNetwork,
		(ndr_print_function_t) ndr_print_clusapi_AddNotifyNetwork,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_ReAddNotifyNetwork",
		sizeof(struct clusapi_ReAddNotifyNetwork),
		(ndr_push_flags_fn_t) ndr_push_clusapi_ReAddNotifyNetwork,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_ReAddNotifyNetwork,
		(ndr_print_function_t) ndr_print_clusapi_ReAddNotifyNetwork,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_OpenNetInterface",
		sizeof(struct clusapi_OpenNetInterface),
		(ndr_push_flags_fn_t) ndr_push_clusapi_OpenNetInterface,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_OpenNetInterface,
		(ndr_print_function_t) ndr_print_clusapi_OpenNetInterface,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CloseNetInterface",
		sizeof(struct clusapi_CloseNetInterface),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CloseNetInterface,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CloseNetInterface,
		(ndr_print_function_t) ndr_print_clusapi_CloseNetInterface,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_GetNetInterfaceState",
		sizeof(struct clusapi_GetNetInterfaceState),
		(ndr_push_flags_fn_t) ndr_push_clusapi_GetNetInterfaceState,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_GetNetInterfaceState,
		(ndr_print_function_t) ndr_print_clusapi_GetNetInterfaceState,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_GetNetInterface",
		sizeof(struct clusapi_GetNetInterface),
		(ndr_push_flags_fn_t) ndr_push_clusapi_GetNetInterface,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_GetNetInterface,
		(ndr_print_function_t) ndr_print_clusapi_GetNetInterface,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_GetNetInterfaceId",
		sizeof(struct clusapi_GetNetInterfaceId),
		(ndr_push_flags_fn_t) ndr_push_clusapi_GetNetInterfaceId,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_GetNetInterfaceId,
		(ndr_print_function_t) ndr_print_clusapi_GetNetInterfaceId,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_NodeNetInterfaceControl",
		sizeof(struct clusapi_NodeNetInterfaceControl),
		(ndr_push_flags_fn_t) ndr_push_clusapi_NodeNetInterfaceControl,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_NodeNetInterfaceControl,
		(ndr_print_function_t) ndr_print_clusapi_NodeNetInterfaceControl,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_NetInterfaceControl",
		sizeof(struct clusapi_NetInterfaceControl),
		(ndr_push_flags_fn_t) ndr_push_clusapi_NetInterfaceControl,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_NetInterfaceControl,
		(ndr_print_function_t) ndr_print_clusapi_NetInterfaceControl,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_AddNotifyNetInterface",
		sizeof(struct clusapi_AddNotifyNetInterface),
		(ndr_push_flags_fn_t) ndr_push_clusapi_AddNotifyNetInterface,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_AddNotifyNetInterface,
		(ndr_print_function_t) ndr_print_clusapi_AddNotifyNetInterface,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_ReAddNotifyNetInterface",
		sizeof(struct clusapi_ReAddNotifyNetInterface),
		(ndr_push_flags_fn_t) ndr_push_clusapi_ReAddNotifyNetInterface,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_ReAddNotifyNetInterface,
		(ndr_print_function_t) ndr_print_clusapi_ReAddNotifyNetInterface,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CreateNodeEnum",
		sizeof(struct clusapi_CreateNodeEnum),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CreateNodeEnum,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CreateNodeEnum,
		(ndr_print_function_t) ndr_print_clusapi_CreateNodeEnum,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_GetClusterVersion2",
		sizeof(struct clusapi_GetClusterVersion2),
		(ndr_push_flags_fn_t) ndr_push_clusapi_GetClusterVersion2,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_GetClusterVersion2,
		(ndr_print_function_t) ndr_print_clusapi_GetClusterVersion2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CreateResTypeEnum",
		sizeof(struct clusapi_CreateResTypeEnum),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CreateResTypeEnum,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CreateResTypeEnum,
		(ndr_print_function_t) ndr_print_clusapi_CreateResTypeEnum,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_BackupClusterDatabase",
		sizeof(struct clusapi_BackupClusterDatabase),
		(ndr_push_flags_fn_t) ndr_push_clusapi_BackupClusterDatabase,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_BackupClusterDatabase,
		(ndr_print_function_t) ndr_print_clusapi_BackupClusterDatabase,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_NodeClusterControl",
		sizeof(struct clusapi_NodeClusterControl),
		(ndr_push_flags_fn_t) ndr_push_clusapi_NodeClusterControl,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_NodeClusterControl,
		(ndr_print_function_t) ndr_print_clusapi_NodeClusterControl,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_ClusterControl",
		sizeof(struct clusapi_ClusterControl),
		(ndr_push_flags_fn_t) ndr_push_clusapi_ClusterControl,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_ClusterControl,
		(ndr_print_function_t) ndr_print_clusapi_ClusterControl,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_UnblockGetNotifyCall",
		sizeof(struct clusapi_UnblockGetNotifyCall),
		(ndr_push_flags_fn_t) ndr_push_clusapi_UnblockGetNotifyCall,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_UnblockGetNotifyCall,
		(ndr_print_function_t) ndr_print_clusapi_UnblockGetNotifyCall,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_SetServiceAccountPassword",
		sizeof(struct clusapi_SetServiceAccountPassword),
		(ndr_push_flags_fn_t) ndr_push_clusapi_SetServiceAccountPassword,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_SetServiceAccountPassword,
		(ndr_print_function_t) ndr_print_clusapi_SetServiceAccountPassword,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_SetResourceDependencyExpression",
		sizeof(struct clusapi_SetResourceDependencyExpression),
		(ndr_push_flags_fn_t) ndr_push_clusapi_SetResourceDependencyExpression,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_SetResourceDependencyExpression,
		(ndr_print_function_t) ndr_print_clusapi_SetResourceDependencyExpression,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_GetResourceDependencyExpression",
		sizeof(struct clusapi_GetResourceDependencyExpression),
		(ndr_push_flags_fn_t) ndr_push_clusapi_GetResourceDependencyExpression,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_GetResourceDependencyExpression,
		(ndr_print_function_t) ndr_print_clusapi_GetResourceDependencyExpression,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Opnum111NotUsedOnWire",
		sizeof(struct Opnum111NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_Opnum111NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_Opnum111NotUsedOnWire,
		(ndr_print_function_t) ndr_print_Opnum111NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_GetResourceNetworkName",
		sizeof(struct clusapi_GetResourceNetworkName),
		(ndr_push_flags_fn_t) ndr_push_clusapi_GetResourceNetworkName,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_GetResourceNetworkName,
		(ndr_print_function_t) ndr_print_clusapi_GetResourceNetworkName,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_ExecuteBatch",
		sizeof(struct clusapi_ExecuteBatch),
		(ndr_push_flags_fn_t) ndr_push_clusapi_ExecuteBatch,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_ExecuteBatch,
		(ndr_print_function_t) ndr_print_clusapi_ExecuteBatch,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CreateBatchPort",
		sizeof(struct clusapi_CreateBatchPort),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CreateBatchPort,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CreateBatchPort,
		(ndr_print_function_t) ndr_print_clusapi_CreateBatchPort,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_GetBatchNotification",
		sizeof(struct clusapi_GetBatchNotification),
		(ndr_push_flags_fn_t) ndr_push_clusapi_GetBatchNotification,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_GetBatchNotification,
		(ndr_print_function_t) ndr_print_clusapi_GetBatchNotification,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CloseBatchPort",
		sizeof(struct clusapi_CloseBatchPort),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CloseBatchPort,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CloseBatchPort,
		(ndr_print_function_t) ndr_print_clusapi_CloseBatchPort,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_OpenClusterEx",
		sizeof(struct clusapi_OpenClusterEx),
		(ndr_push_flags_fn_t) ndr_push_clusapi_OpenClusterEx,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_OpenClusterEx,
		(ndr_print_function_t) ndr_print_clusapi_OpenClusterEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_OpenNodeEx",
		sizeof(struct clusapi_OpenNodeEx),
		(ndr_push_flags_fn_t) ndr_push_clusapi_OpenNodeEx,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_OpenNodeEx,
		(ndr_print_function_t) ndr_print_clusapi_OpenNodeEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_OpenGroupEx",
		sizeof(struct clusapi_OpenGroupEx),
		(ndr_push_flags_fn_t) ndr_push_clusapi_OpenGroupEx,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_OpenGroupEx,
		(ndr_print_function_t) ndr_print_clusapi_OpenGroupEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_OpenResourceEx",
		sizeof(struct clusapi_OpenResourceEx),
		(ndr_push_flags_fn_t) ndr_push_clusapi_OpenResourceEx,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_OpenResourceEx,
		(ndr_print_function_t) ndr_print_clusapi_OpenResourceEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_OpenNetworkEx",
		sizeof(struct clusapi_OpenNetworkEx),
		(ndr_push_flags_fn_t) ndr_push_clusapi_OpenNetworkEx,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_OpenNetworkEx,
		(ndr_print_function_t) ndr_print_clusapi_OpenNetworkEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_OpenNetInterfaceEx",
		sizeof(struct clusapi_OpenNetInterfaceEx),
		(ndr_push_flags_fn_t) ndr_push_clusapi_OpenNetInterfaceEx,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_OpenNetInterfaceEx,
		(ndr_print_function_t) ndr_print_clusapi_OpenNetInterfaceEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_ChangeCsvState",
		sizeof(struct clusapi_ChangeCsvState),
		(ndr_push_flags_fn_t) ndr_push_clusapi_ChangeCsvState,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_ChangeCsvState,
		(ndr_print_function_t) ndr_print_clusapi_ChangeCsvState,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CreateNodeEnumEx",
		sizeof(struct clusapi_CreateNodeEnumEx),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CreateNodeEnumEx,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CreateNodeEnumEx,
		(ndr_print_function_t) ndr_print_clusapi_CreateNodeEnumEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CreateEnumEx",
		sizeof(struct clusapi_CreateEnumEx),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CreateEnumEx,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CreateEnumEx,
		(ndr_print_function_t) ndr_print_clusapi_CreateEnumEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_PauseNodeEx",
		sizeof(struct clusapi_PauseNodeEx),
		(ndr_push_flags_fn_t) ndr_push_clusapi_PauseNodeEx,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_PauseNodeEx,
		(ndr_print_function_t) ndr_print_clusapi_PauseNodeEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_PauseNodeWithDrainTarget",
		sizeof(struct clusapi_PauseNodeWithDrainTarget),
		(ndr_push_flags_fn_t) ndr_push_clusapi_PauseNodeWithDrainTarget,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_PauseNodeWithDrainTarget,
		(ndr_print_function_t) ndr_print_clusapi_PauseNodeWithDrainTarget,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_ResumeNodeEx",
		sizeof(struct clusapi_ResumeNodeEx),
		(ndr_push_flags_fn_t) ndr_push_clusapi_ResumeNodeEx,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_ResumeNodeEx,
		(ndr_print_function_t) ndr_print_clusapi_ResumeNodeEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CreateGroupEx",
		sizeof(struct clusapi_CreateGroupEx),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CreateGroupEx,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CreateGroupEx,
		(ndr_print_function_t) ndr_print_clusapi_CreateGroupEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_OnlineGroupEx",
		sizeof(struct clusapi_OnlineGroupEx),
		(ndr_push_flags_fn_t) ndr_push_clusapi_OnlineGroupEx,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_OnlineGroupEx,
		(ndr_print_function_t) ndr_print_clusapi_OnlineGroupEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_OfflineGroupEx",
		sizeof(struct clusapi_OfflineGroupEx),
		(ndr_push_flags_fn_t) ndr_push_clusapi_OfflineGroupEx,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_OfflineGroupEx,
		(ndr_print_function_t) ndr_print_clusapi_OfflineGroupEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_MoveGroupEx",
		sizeof(struct clusapi_MoveGroupEx),
		(ndr_push_flags_fn_t) ndr_push_clusapi_MoveGroupEx,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_MoveGroupEx,
		(ndr_print_function_t) ndr_print_clusapi_MoveGroupEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_MoveGroupToNodeEx",
		sizeof(struct clusapi_MoveGroupToNodeEx),
		(ndr_push_flags_fn_t) ndr_push_clusapi_MoveGroupToNodeEx,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_MoveGroupToNodeEx,
		(ndr_print_function_t) ndr_print_clusapi_MoveGroupToNodeEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CancelClusterGroupOperation",
		sizeof(struct clusapi_CancelClusterGroupOperation),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CancelClusterGroupOperation,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CancelClusterGroupOperation,
		(ndr_print_function_t) ndr_print_clusapi_CancelClusterGroupOperation,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_OnlineResourceEx",
		sizeof(struct clusapi_OnlineResourceEx),
		(ndr_push_flags_fn_t) ndr_push_clusapi_OnlineResourceEx,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_OnlineResourceEx,
		(ndr_print_function_t) ndr_print_clusapi_OnlineResourceEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_OfflineResourceEx",
		sizeof(struct clusapi_OfflineResourceEx),
		(ndr_push_flags_fn_t) ndr_push_clusapi_OfflineResourceEx,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_OfflineResourceEx,
		(ndr_print_function_t) ndr_print_clusapi_OfflineResourceEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CreateNotifyV2",
		sizeof(struct clusapi_CreateNotifyV2),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CreateNotifyV2,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CreateNotifyV2,
		(ndr_print_function_t) ndr_print_clusapi_CreateNotifyV2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_AddNotifyV2",
		sizeof(struct clusapi_AddNotifyV2),
		(ndr_push_flags_fn_t) ndr_push_clusapi_AddNotifyV2,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_AddNotifyV2,
		(ndr_print_function_t) ndr_print_clusapi_AddNotifyV2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_GetNotifyV2",
		sizeof(struct clusapi_GetNotifyV2),
		(ndr_push_flags_fn_t) ndr_push_clusapi_GetNotifyV2,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_GetNotifyV2,
		(ndr_print_function_t) ndr_print_clusapi_GetNotifyV2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_QueryAllValues",
		sizeof(struct clusapi_QueryAllValues),
		(ndr_push_flags_fn_t) ndr_push_clusapi_QueryAllValues,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_QueryAllValues,
		(ndr_print_function_t) ndr_print_clusapi_QueryAllValues,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_StmFindDisk",
		sizeof(struct clusapi_StmFindDisk),
		(ndr_push_flags_fn_t) ndr_push_clusapi_StmFindDisk,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_StmFindDisk,
		(ndr_print_function_t) ndr_print_clusapi_StmFindDisk,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_ClusterMrr",
		sizeof(struct clusapi_ClusterMrr),
		(ndr_push_flags_fn_t) ndr_push_clusapi_ClusterMrr,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_ClusterMrr,
		(ndr_print_function_t) ndr_print_clusapi_ClusterMrr,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CreateGroupEnum",
		sizeof(struct clusapi_CreateGroupEnum),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CreateGroupEnum,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CreateGroupEnum,
		(ndr_print_function_t) ndr_print_clusapi_CreateGroupEnum,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CreateResourceEnum",
		sizeof(struct clusapi_CreateResourceEnum),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CreateResourceEnum,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CreateResourceEnum,
		(ndr_print_function_t) ndr_print_clusapi_CreateResourceEnum,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_ExecuteReadBatch",
		sizeof(struct clusapi_ExecuteReadBatch),
		(ndr_push_flags_fn_t) ndr_push_clusapi_ExecuteReadBatch,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_ExecuteReadBatch,
		(ndr_print_function_t) ndr_print_clusapi_ExecuteReadBatch,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_RestartResource",
		sizeof(struct clusapi_RestartResource),
		(ndr_push_flags_fn_t) ndr_push_clusapi_RestartResource,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_RestartResource,
		(ndr_print_function_t) ndr_print_clusapi_RestartResource,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_GetNotifyAsync",
		sizeof(struct clusapi_GetNotifyAsync),
		(ndr_push_flags_fn_t) ndr_push_clusapi_GetNotifyAsync,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_GetNotifyAsync,
		(ndr_print_function_t) ndr_print_clusapi_GetNotifyAsync,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Opnum148NotUsedOnWire",
		sizeof(struct Opnum148NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_Opnum148NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_Opnum148NotUsedOnWire,
		(ndr_print_function_t) ndr_print_Opnum148NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Opnum149otUsedOnWire",
		sizeof(struct Opnum149otUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_Opnum149otUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_Opnum149otUsedOnWire,
		(ndr_print_function_t) ndr_print_Opnum149otUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Opnum150NotUsedOnWire",
		sizeof(struct Opnum150NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_Opnum150NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_Opnum150NotUsedOnWire,
		(ndr_print_function_t) ndr_print_Opnum150NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Opnum151NotUsedOnWire",
		sizeof(struct Opnum151NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_Opnum151NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_Opnum151NotUsedOnWire,
		(ndr_print_function_t) ndr_print_Opnum151NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Opnum152NotUsedOnWire",
		sizeof(struct Opnum152NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_Opnum152NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_Opnum152NotUsedOnWire,
		(ndr_print_function_t) ndr_print_Opnum152NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Opnum153NotUsedOnWire",
		sizeof(struct Opnum153NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_Opnum153NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_Opnum153NotUsedOnWire,
		(ndr_print_function_t) ndr_print_Opnum153NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Opnum154NotUsedOnWire",
		sizeof(struct Opnum154NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_Opnum154NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_Opnum154NotUsedOnWire,
		(ndr_print_function_t) ndr_print_Opnum154NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_AddNotifyResourceTypeV2",
		sizeof(struct clusapi_AddNotifyResourceTypeV2),
		(ndr_push_flags_fn_t) ndr_push_clusapi_AddNotifyResourceTypeV2,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_AddNotifyResourceTypeV2,
		(ndr_print_function_t) ndr_print_clusapi_AddNotifyResourceTypeV2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Opnum156NotUsedOnWire",
		sizeof(struct Opnum156NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_Opnum156NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_Opnum156NotUsedOnWire,
		(ndr_print_function_t) ndr_print_Opnum156NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_ExecuteReadBatchEx",
		sizeof(struct clusapi_ExecuteReadBatchEx),
		(ndr_push_flags_fn_t) ndr_push_clusapi_ExecuteReadBatchEx,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_ExecuteReadBatchEx,
		(ndr_print_function_t) ndr_print_clusapi_ExecuteReadBatchEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Opnum158NotUsedOnWire",
		sizeof(struct Opnum158NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_Opnum158NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_Opnum158NotUsedOnWire,
		(ndr_print_function_t) ndr_print_Opnum158NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Opnum159NotUsedOnWire",
		sizeof(struct Opnum159NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_Opnum159NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_Opnum159NotUsedOnWire,
		(ndr_print_function_t) ndr_print_Opnum159NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Opnum160NotUsedOnWire",
		sizeof(struct Opnum160NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_Opnum160NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_Opnum160NotUsedOnWire,
		(ndr_print_function_t) ndr_print_Opnum160NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Opnum161NotUsedOnWire",
		sizeof(struct Opnum161NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_Opnum161NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_Opnum161NotUsedOnWire,
		(ndr_print_function_t) ndr_print_Opnum161NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Opnum162NotUsedOnWire",
		sizeof(struct Opnum162NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_Opnum162NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_Opnum162NotUsedOnWire,
		(ndr_print_function_t) ndr_print_Opnum162NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CreateGroupSet",
		sizeof(struct clusapi_CreateGroupSet),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CreateGroupSet,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CreateGroupSet,
		(ndr_print_function_t) ndr_print_clusapi_CreateGroupSet,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_OpenGroupSet",
		sizeof(struct clusapi_OpenGroupSet),
		(ndr_push_flags_fn_t) ndr_push_clusapi_OpenGroupSet,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_OpenGroupSet,
		(ndr_print_function_t) ndr_print_clusapi_OpenGroupSet,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CloseGroupSet",
		sizeof(struct clusapi_CloseGroupSet),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CloseGroupSet,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CloseGroupSet,
		(ndr_print_function_t) ndr_print_clusapi_CloseGroupSet,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_DeleteGroupSet",
		sizeof(struct clusapi_DeleteGroupSet),
		(ndr_push_flags_fn_t) ndr_push_clusapi_DeleteGroupSet,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_DeleteGroupSet,
		(ndr_print_function_t) ndr_print_clusapi_DeleteGroupSet,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_AddGroupToGroupSet",
		sizeof(struct clusapi_AddGroupToGroupSet),
		(ndr_push_flags_fn_t) ndr_push_clusapi_AddGroupToGroupSet,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_AddGroupToGroupSet,
		(ndr_print_function_t) ndr_print_clusapi_AddGroupToGroupSet,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_RemoveGroupFromGroupSet",
		sizeof(struct clusapi_RemoveGroupFromGroupSet),
		(ndr_push_flags_fn_t) ndr_push_clusapi_RemoveGroupFromGroupSet,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_RemoveGroupFromGroupSet,
		(ndr_print_function_t) ndr_print_clusapi_RemoveGroupFromGroupSet,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_MoveGroupToGroupSet",
		sizeof(struct clusapi_MoveGroupToGroupSet),
		(ndr_push_flags_fn_t) ndr_push_clusapi_MoveGroupToGroupSet,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_MoveGroupToGroupSet,
		(ndr_print_function_t) ndr_print_clusapi_MoveGroupToGroupSet,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Opnum170NotUsedOnWire",
		sizeof(struct Opnum170NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_Opnum170NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_Opnum170NotUsedOnWire,
		(ndr_print_function_t) ndr_print_Opnum170NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_AddGroupSetDependency",
		sizeof(struct clusapi_AddGroupSetDependency),
		(ndr_push_flags_fn_t) ndr_push_clusapi_AddGroupSetDependency,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_AddGroupSetDependency,
		(ndr_print_function_t) ndr_print_clusapi_AddGroupSetDependency,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_AddGroupToGroupSetDependency",
		sizeof(struct clusapi_AddGroupToGroupSetDependency),
		(ndr_push_flags_fn_t) ndr_push_clusapi_AddGroupToGroupSetDependency,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_AddGroupToGroupSetDependency,
		(ndr_print_function_t) ndr_print_clusapi_AddGroupToGroupSetDependency,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_NodeGroupSetControl",
		sizeof(struct clusapi_NodeGroupSetControl),
		(ndr_push_flags_fn_t) ndr_push_clusapi_NodeGroupSetControl,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_NodeGroupSetControl,
		(ndr_print_function_t) ndr_print_clusapi_NodeGroupSetControl,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_GroupSetControl",
		sizeof(struct clusapi_GroupSetControl),
		(ndr_push_flags_fn_t) ndr_push_clusapi_GroupSetControl,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_GroupSetControl,
		(ndr_print_function_t) ndr_print_clusapi_GroupSetControl,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_SetGroupDependencyExpression",
		sizeof(struct clusapi_SetGroupDependencyExpression),
		(ndr_push_flags_fn_t) ndr_push_clusapi_SetGroupDependencyExpression,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_SetGroupDependencyExpression,
		(ndr_print_function_t) ndr_print_clusapi_SetGroupDependencyExpression,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_RemoveClusterGroupDependency",
		sizeof(struct clusapi_RemoveClusterGroupDependency),
		(ndr_push_flags_fn_t) ndr_push_clusapi_RemoveClusterGroupDependency,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_RemoveClusterGroupDependency,
		(ndr_print_function_t) ndr_print_clusapi_RemoveClusterGroupDependency,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_SetGroupSetDependencyExpression",
		sizeof(struct clusapi_SetGroupSetDependencyExpression),
		(ndr_push_flags_fn_t) ndr_push_clusapi_SetGroupSetDependencyExpression,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_SetGroupSetDependencyExpression,
		(ndr_print_function_t) ndr_print_clusapi_SetGroupSetDependencyExpression,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_RemoveGroupSetDependency",
		sizeof(struct clusapi_RemoveGroupSetDependency),
		(ndr_push_flags_fn_t) ndr_push_clusapi_RemoveGroupSetDependency,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_RemoveGroupSetDependency,
		(ndr_print_function_t) ndr_print_clusapi_RemoveGroupSetDependency,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_RemoveClusterGroupToGroupSetDependency",
		sizeof(struct clusapi_RemoveClusterGroupToGroupSetDependency),
		(ndr_push_flags_fn_t) ndr_push_clusapi_RemoveClusterGroupToGroupSetDependency,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_RemoveClusterGroupToGroupSetDependency,
		(ndr_print_function_t) ndr_print_clusapi_RemoveClusterGroupToGroupSetDependency,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CreateGroupSetEnum",
		sizeof(struct clusapi_CreateGroupSetEnum),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CreateGroupSetEnum,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CreateGroupSetEnum,
		(ndr_print_function_t) ndr_print_clusapi_CreateGroupSetEnum,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_CreateNetInterfaceEnum",
		sizeof(struct clusapi_CreateNetInterfaceEnum),
		(ndr_push_flags_fn_t) ndr_push_clusapi_CreateNetInterfaceEnum,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_CreateNetInterfaceEnum,
		(ndr_print_function_t) ndr_print_clusapi_CreateNetInterfaceEnum,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_ChangeCsvStateEx",
		sizeof(struct clusapi_ChangeCsvStateEx),
		(ndr_push_flags_fn_t) ndr_push_clusapi_ChangeCsvStateEx,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_ChangeCsvStateEx,
		(ndr_print_function_t) ndr_print_clusapi_ChangeCsvStateEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"clusapi_AddGroupToGroupSetEx",
		sizeof(struct clusapi_AddGroupToGroupSetEx),
		(ndr_push_flags_fn_t) ndr_push_clusapi_AddGroupToGroupSetEx,
		(ndr_pull_flags_fn_t) ndr_pull_clusapi_AddGroupToGroupSetEx,
		(ndr_print_function_t) ndr_print_clusapi_AddGroupToGroupSetEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ .name = NULL }
};

static const char * const clusapi_endpoint_strings[] = {
	"ncacn_ip_tcp:", 
};

static const struct ndr_interface_string_array clusapi_endpoints = {
	.count	= 1,
	.names	= clusapi_endpoint_strings
};

static const char * const clusapi_authservice_strings[] = {
	"MSServerClusterMgmtAPI", 
};

static const struct ndr_interface_string_array clusapi_authservices = {
	.count	= 1,
	.names	= clusapi_authservice_strings
};


const struct ndr_interface_table ndr_table_clusapi = {
	.name		= "clusapi",
	.syntax_id	= {
		{0xb97db8b2,0x4c63,0x11cf,{0xbf,0xf6},{0x08,0x00,0x2b,0xe2,0x3f,0x2f}},
		NDR_CLUSAPI_VERSION
	},
	.helpstring	= NDR_CLUSAPI_HELPSTRING,
	.num_calls	= 184,
	.calls		= clusapi_calls,
	.num_public_structs	= 2,
	.public_structs		= clusapi_public_structs,
	.endpoints	= &clusapi_endpoints,
	.authservices	= &clusapi_authservices
};

#endif /* SKIP_NDR_TABLE_clusapi */
