/* ConfigurationInterfaces.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ConfigurationInterfaces.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#define _XOPEN_SOURCE

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <time.h>

#define NULL_TRANSITION_DESCRIPTOR_EFFECT_ID "org.gnome.shotwell.transitions.null"
#define TRANSITION_EFFECTS_MANAGER_NULL_EFFECT_ID NULL_TRANSITION_DESCRIPTOR_EFFECT_ID
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_CONFIGURATION_ERROR (configuration_error_get_type ())
typedef enum  {
	FUZZY_PROPERTY_STATE_ENABLED,
	FUZZY_PROPERTY_STATE_DISABLED,
	FUZZY_PROPERTY_STATE_UNKNOWN
} FuzzyPropertyState;

#define TYPE_FUZZY_PROPERTY_STATE (fuzzy_property_state_get_type ())
typedef enum  {
	CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY = 0,
	CONFIGURABLE_PROPERTY_GTK_THEME_VARIANT,
	CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_TYPE,
	CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_COLOR,
	CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS,
	CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE,
	CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_MODE,
	CONFIGURABLE_PROPERTY_SCREENSAVER_FILE,
	CONFIGURABLE_PROPERTY_SCREENSAVER_MODE,
	CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN,
	CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM,
	CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT,
	CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE,
	CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH,
	CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES,
	CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS,
	CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES,
	CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR,
	CONFIGURABLE_PROPERTY_DISPLAY_TOOLBAR,
	CONFIGURABLE_PROPERTY_DISPLAY_MAP_WIDGET,
	CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR,
	CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS,
	CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS,
	CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES,
	CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS,
	CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING,
	CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY,
	CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING,
	CONFIGURABLE_PROPERTY_EXPORT_CONSTRAINT,
	CONFIGURABLE_PROPERTY_EXPORT_EXPORT_FORMAT_MODE,
	CONFIGURABLE_PROPERTY_EXPORT_EXPORT_METADATA,
	CONFIGURABLE_PROPERTY_EXPORT_PHOTO_FILE_FORMAT,
	CONFIGURABLE_PROPERTY_EXPORT_QUALITY,
	CONFIGURABLE_PROPERTY_EXPORT_SCALE,
	CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP,
	CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP,
	CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED,
	CONFIGURABLE_PROPERTY_IMPORT_DIR,
	CONFIGURABLE_PROPERTY_KEEP_RELATIVITY,
	CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT,
	CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE,
	CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH,
	CONFIGURABLE_PROPERTY_LAST_USED_SERVICE,
	CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE,
	CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING,
	CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY,
	CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT,
	CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE,
	CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH,
	CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS,
	CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE,
	CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH,
	CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE,
	CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO,
	CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES,
	CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION,
	CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT,
	CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT,
	CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG,
	CONFIGURABLE_PROPERTY_SIDEBAR_POSITION,
	CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY,
	CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY,
	CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID,
	CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE,
	CONFIGURABLE_PROPERTY_SLIDESHOW_SHUFFLE,
	CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME,
	CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES,
	CONFIGURABLE_PROPERTY_NUM_PROPERTIES
} ConfigurableProperty;

#define TYPE_CONFIGURABLE_PROPERTY (configurable_property_get_type ())

#define TYPE_CONFIGURATION_ENGINE (configuration_engine_get_type ())
#define CONFIGURATION_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_ENGINE, ConfigurationEngine))
#define IS_CONFIGURATION_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_ENGINE))
#define CONFIGURATION_ENGINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_CONFIGURATION_ENGINE, ConfigurationEngineIface))

typedef struct _ConfigurationEngine ConfigurationEngine;
typedef struct _ConfigurationEngineIface ConfigurationEngineIface;
enum  {
	CONFIGURATION_ENGINE_PROPERTY_CHANGED_SIGNAL,
	CONFIGURATION_ENGINE_NUM_SIGNALS
};
static guint configuration_engine_signals[CONFIGURATION_ENGINE_NUM_SIGNALS] = {0};

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;
typedef struct _ConfigurationFacadePrivate ConfigurationFacadePrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())
typedef enum  {
	EXPORT_FORMAT_MODE_UNMODIFIED,
	EXPORT_FORMAT_MODE_CURRENT,
	EXPORT_FORMAT_MODE_SPECIFIED,
	EXPORT_FORMAT_MODE_LAST
} ExportFormatMode;

#define TYPE_EXPORT_FORMAT_MODE (export_format_mode_get_type ())
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_GIF,
	PHOTO_FILE_FORMAT_WEBP,
	PHOTO_FILE_FORMAT_AVIF,
	PHOTO_FILE_FORMAT_HEIF,
	PHOTO_FILE_FORMAT_JPEGXL,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())
typedef enum  {
	JPEG_QUALITY_LOW = 50,
	JPEG_QUALITY_MEDIUM = 75,
	JPEG_QUALITY_HIGH = 90,
	JPEG_QUALITY_MAXIMUM = 100
} JpegQuality;

#define JPEG_TYPE_QUALITY (jpeg_quality_get_type ())
typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())
enum  {
	CONFIGURATION_FACADE_0_PROPERTY,
	CONFIGURATION_FACADE_NUM_PROPERTIES
};
static GParamSpec* configuration_facade_properties[CONFIGURATION_FACADE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef enum  {
	RESOURCES_UNIT_SYSTEM_IMPERIAL,
	RESOURCES_UNIT_SYSTEM_METRIC,
	RESOURCES_UNIT_SYSTEM_UNKNOWN
} ResourcesUnitSystem;

#define RESOURCES_TYPE_UNIT_SYSTEM (resources_unit_system_get_type ())
enum  {
	CONFIGURATION_FACADE_AUTO_IMPORT_FROM_LIBRARY_CHANGED_SIGNAL,
	CONFIGURATION_FACADE_BG_COLOR_NAME_CHANGED_SIGNAL,
	CONFIGURATION_FACADE_TRANSPARENT_BACKGROUND_TYPE_CHANGED_SIGNAL,
	CONFIGURATION_FACADE_TRANSPARENT_BACKGROUND_COLOR_CHANGED_SIGNAL,
	CONFIGURATION_FACADE_COMMIT_METADATA_TO_MASTERS_CHANGED_SIGNAL,
	CONFIGURATION_FACADE_EVENTS_SORT_ASCENDING_CHANGED_SIGNAL,
	CONFIGURATION_FACADE_EXTERNAL_APP_CHANGED_SIGNAL,
	CONFIGURATION_FACADE_IMPORT_DIRECTORY_CHANGED_SIGNAL,
	CONFIGURATION_FACADE_NUM_SIGNALS
};
static guint configuration_facade_signals[CONFIGURATION_FACADE_NUM_SIGNALS] = {0};

typedef enum  {
	CONFIGURATION_ERROR_PROPERTY_HAS_NO_VALUE,
	CONFIGURATION_ERROR_ENGINE_ERROR
} ConfigurationError;
#define CONFIGURATION_ERROR configuration_error_quark ()

struct _ConfigurationEngineIface {
	GTypeInterface parent_iface;
	gchar* (*get_name) (ConfigurationEngine* self);
	gint (*get_int_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_int_property) (ConfigurationEngine* self, ConfigurableProperty p, gint val, GError** error);
	gint (*get_enum_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_enum_property) (ConfigurationEngine* self, ConfigurableProperty p, gint val, GError** error);
	gchar* (*get_string_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_string_property) (ConfigurationEngine* self, ConfigurableProperty p, const gchar* val, GError** error);
	gboolean (*get_bool_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_bool_property) (ConfigurationEngine* self, ConfigurableProperty p, gboolean val, GError** error);
	gdouble (*get_double_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_double_property) (ConfigurationEngine* self, ConfigurableProperty p, gdouble val, GError** error);
	gboolean (*get_plugin_bool) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def);
	void (*set_plugin_bool) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val);
	gdouble (*get_plugin_double) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def);
	void (*set_plugin_double) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val);
	gint (*get_plugin_int) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint def);
	void (*set_plugin_int) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint val);
	gchar* (*get_plugin_string) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def);
	void (*set_plugin_string) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val);
	void (*unset_plugin_key) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key);
	FuzzyPropertyState (*is_plugin_enabled) (ConfigurationEngine* self, const gchar* id);
	void (*set_plugin_enabled) (ConfigurationEngine* self, const gchar* id, gboolean enabled);
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _ConfigurationFacade {
	GObject parent_instance;
	ConfigurationFacadePrivate * priv;
};

struct _ConfigurationFacadeClass {
	GObjectClass parent_class;
	gboolean (*get_auto_import_from_library) (ConfigurationFacade* self);
	void (*set_auto_import_from_library) (ConfigurationFacade* self, gboolean auto_import);
	gboolean (*get_gtk_theme_variant) (ConfigurationFacade* self);
	void (*set_gtk_theme_variant) (ConfigurationFacade* self, gboolean dark);
	gchar* (*get_transparent_background_type) (ConfigurationFacade* self);
	void (*set_transparent_background_type) (ConfigurationFacade* self, const gchar* type);
	gchar* (*get_transparent_background_color) (ConfigurationFacade* self);
	void (*set_transparent_background_color) (ConfigurationFacade* self, const gchar* color_name);
	gboolean (*get_commit_metadata_to_masters) (ConfigurationFacade* self);
	void (*set_commit_metadata_to_masters) (ConfigurationFacade* self, gboolean commit_metadata);
	gchar* (*get_desktop_background) (ConfigurationFacade* self);
	void (*set_desktop_background) (ConfigurationFacade* self, const gchar* filename);
	gchar* (*get_screensaver) (ConfigurationFacade* self);
	void (*set_screensaver) (ConfigurationFacade* self, const gchar* filename);
	gchar* (*get_directory_pattern) (ConfigurationFacade* self);
	void (*set_directory_pattern) (ConfigurationFacade* self, const gchar* s);
	gchar* (*get_directory_pattern_custom) (ConfigurationFacade* self);
	void (*set_directory_pattern_custom) (ConfigurationFacade* self, const gchar* s);
	void (*get_direct_window_state) (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
	void (*set_direct_window_state) (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
	gboolean (*get_display_basic_properties) (ConfigurationFacade* self);
	void (*set_display_basic_properties) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_extended_properties) (ConfigurationFacade* self);
	void (*set_display_extended_properties) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_sidebar) (ConfigurationFacade* self);
	void (*set_display_sidebar) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_toolbar) (ConfigurationFacade* self);
	void (*set_display_toolbar) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_map_widget) (ConfigurationFacade* self);
	void (*set_display_map_widget) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_search_bar) (ConfigurationFacade* self);
	void (*set_display_search_bar) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_photo_ratings) (ConfigurationFacade* self);
	void (*set_display_photo_ratings) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_photo_tags) (ConfigurationFacade* self);
	void (*set_display_photo_tags) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_photo_titles) (ConfigurationFacade* self);
	void (*set_display_photo_titles) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_photo_comments) (ConfigurationFacade* self);
	void (*set_display_photo_comments) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_event_comments) (ConfigurationFacade* self);
	void (*set_display_event_comments) (ConfigurationFacade* self, gboolean display);
	void (*get_event_photos_sort) (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
	void (*set_event_photos_sort) (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
	gboolean (*get_events_sort_ascending) (ConfigurationFacade* self);
	void (*set_events_sort_ascending) (ConfigurationFacade* self, gboolean sort);
	gchar* (*get_external_photo_app) (ConfigurationFacade* self);
	void (*set_external_photo_app) (ConfigurationFacade* self, const gchar* external_photo_app);
	gchar* (*get_external_raw_app) (ConfigurationFacade* self);
	void (*set_external_raw_app) (ConfigurationFacade* self, const gchar* external_raw_app);
	ScaleConstraint (*get_export_constraint) (ConfigurationFacade* self);
	void (*set_export_constraint) (ConfigurationFacade* self, ScaleConstraint constraint);
	ExportFormatMode (*get_export_export_format_mode) (ConfigurationFacade* self);
	void (*set_export_export_format_mode) (ConfigurationFacade* self, ExportFormatMode export_format_mode);
	gboolean (*get_export_export_metadata) (ConfigurationFacade* self);
	void (*set_export_export_metadata) (ConfigurationFacade* self, gboolean export_metadata);
	PhotoFileFormat (*get_export_photo_file_format) (ConfigurationFacade* self);
	void (*set_export_photo_file_format) (ConfigurationFacade* self, PhotoFileFormat photo_file_format);
	JpegQuality (*get_export_quality) (ConfigurationFacade* self);
	void (*set_export_quality) (ConfigurationFacade* self, JpegQuality quality);
	gint (*get_export_scale) (ConfigurationFacade* self);
	void (*set_export_scale) (ConfigurationFacade* self, gint scale);
	RawDeveloper (*get_default_raw_developer) (ConfigurationFacade* self);
	void (*set_default_raw_developer) (ConfigurationFacade* self, RawDeveloper d);
	gboolean (*get_hide_photos_already_imported) (ConfigurationFacade* self);
	void (*set_hide_photos_already_imported) (ConfigurationFacade* self, gboolean hide_imported);
	gchar* (*get_import_dir) (ConfigurationFacade* self);
	void (*set_import_dir) (ConfigurationFacade* self, const gchar* import_dir);
	gboolean (*get_keep_relativity) (ConfigurationFacade* self);
	void (*set_keep_relativity) (ConfigurationFacade* self, gboolean keep_relativity);
	gboolean (*get_pin_toolbar_state) (ConfigurationFacade* self);
	void (*set_pin_toolbar_state) (ConfigurationFacade* self, gboolean state);
	gint (*get_last_crop_height) (ConfigurationFacade* self);
	void (*set_last_crop_height) (ConfigurationFacade* self, gint choice);
	gint (*get_last_crop_menu_choice) (ConfigurationFacade* self);
	void (*set_last_crop_menu_choice) (ConfigurationFacade* self, gint choice);
	gint (*get_last_crop_width) (ConfigurationFacade* self);
	void (*set_last_crop_width) (ConfigurationFacade* self, gint choice);
	gchar* (*get_last_used_service) (ConfigurationFacade* self);
	void (*set_last_used_service) (ConfigurationFacade* self, const gchar* service_name);
	gchar* (*get_last_used_dataimports_service) (ConfigurationFacade* self);
	void (*set_last_used_dataimports_service) (ConfigurationFacade* self, const gchar* service_name);
	void (*get_library_photos_sort) (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
	void (*set_library_photos_sort) (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
	void (*get_library_window_state) (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
	void (*set_library_window_state) (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
	gboolean (*get_modify_originals) (ConfigurationFacade* self);
	void (*set_modify_originals) (ConfigurationFacade* self, gboolean modify_originals);
	gint (*get_photo_thumbnail_scale) (ConfigurationFacade* self);
	void (*set_photo_thumbnail_scale) (ConfigurationFacade* self, gint scale);
	gdouble (*get_printing_content_height) (ConfigurationFacade* self);
	void (*set_printing_content_height) (ConfigurationFacade* self, gdouble content_height);
	gint (*get_printing_content_layout) (ConfigurationFacade* self);
	void (*set_printing_content_layout) (ConfigurationFacade* self, gint layout_code);
	gint (*get_printing_content_ppi) (ConfigurationFacade* self);
	void (*set_printing_content_ppi) (ConfigurationFacade* self, gint content_ppi);
	gint (*get_printing_content_units) (ConfigurationFacade* self);
	void (*set_printing_content_units) (ConfigurationFacade* self, gint units_code);
	gdouble (*get_printing_content_width) (ConfigurationFacade* self);
	void (*set_printing_content_width) (ConfigurationFacade* self, gdouble content_width);
	gint (*get_printing_images_per_page) (ConfigurationFacade* self);
	void (*set_printing_images_per_page) (ConfigurationFacade* self, gint images_per_page_code);
	gboolean (*get_printing_match_aspect_ratio) (ConfigurationFacade* self);
	void (*set_printing_match_aspect_ratio) (ConfigurationFacade* self, gboolean match_aspect_ratio);
	gboolean (*get_printing_print_titles) (ConfigurationFacade* self);
	void (*set_printing_print_titles) (ConfigurationFacade* self, gboolean print_titles);
	gint (*get_printing_size_selection) (ConfigurationFacade* self);
	void (*set_printing_size_selection) (ConfigurationFacade* self, gint size_code);
	gchar* (*get_printing_titles_font) (ConfigurationFacade* self);
	void (*set_printing_titles_font) (ConfigurationFacade* self, const gchar* font_name);
	gboolean (*get_show_welcome_dialog) (ConfigurationFacade* self);
	void (*set_show_welcome_dialog) (ConfigurationFacade* self, gboolean show);
	gint (*get_sidebar_position) (ConfigurationFacade* self);
	void (*set_sidebar_position) (ConfigurationFacade* self, gint position);
	gdouble (*get_slideshow_delay) (ConfigurationFacade* self);
	void (*set_slideshow_delay) (ConfigurationFacade* self, gdouble delay);
	gdouble (*get_slideshow_transition_delay) (ConfigurationFacade* self);
	void (*set_slideshow_transition_delay) (ConfigurationFacade* self, gdouble delay);
	gchar* (*get_slideshow_transition_effect_id) (ConfigurationFacade* self);
	void (*set_slideshow_transition_effect_id) (ConfigurationFacade* self, const gchar* id);
	gboolean (*get_slideshow_show_title) (ConfigurationFacade* self);
	void (*set_slideshow_show_title) (ConfigurationFacade* self, gboolean show_title);
	gboolean (*get_slideshow_shuffle) (ConfigurationFacade* self);
	void (*set_slideshow_shuffle) (ConfigurationFacade* self, gboolean shuffle);
	gboolean (*get_use_24_hour_time) (ConfigurationFacade* self);
	void (*set_use_24_hour_time) (ConfigurationFacade* self, gboolean use_24_hour_time);
	gboolean (*get_use_lowercase_filenames) (ConfigurationFacade* self);
	void (*set_use_lowercase_filenames) (ConfigurationFacade* self, gboolean b);
	gboolean (*get_plugin_bool) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def);
	void (*set_plugin_bool) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val);
	gdouble (*get_plugin_double) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def);
	void (*set_plugin_double) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val);
	gint (*get_plugin_int) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint def);
	void (*set_plugin_int) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint val);
	gchar* (*get_plugin_string) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def);
	void (*set_plugin_string) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val);
	void (*unset_plugin_key) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key);
	FuzzyPropertyState (*is_plugin_enabled) (ConfigurationFacade* self, const gchar* id);
	void (*set_plugin_enabled) (ConfigurationFacade* self, const gchar* id, gboolean enabled);
};

struct _ConfigurationFacadePrivate {
	ConfigurationEngine* engine;
};

static gint ConfigurationFacade_private_offset;
static gpointer configuration_facade_parent_class = NULL;

VALA_EXTERN GQuark configuration_error_quark (void);
VALA_EXTERN GType configuration_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType fuzzy_property_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType configurable_property_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* configurable_property_to_string (ConfigurableProperty self);
VALA_EXTERN GType configuration_engine_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigurationEngine, g_object_unref)
VALA_EXTERN gchar* configuration_engine_get_name (ConfigurationEngine* self);
VALA_EXTERN gint configuration_engine_get_int_property (ConfigurationEngine* self,
                                            ConfigurableProperty p,
                                            GError** error);
VALA_EXTERN void configuration_engine_set_int_property (ConfigurationEngine* self,
                                            ConfigurableProperty p,
                                            gint val,
                                            GError** error);
VALA_EXTERN gint configuration_engine_get_enum_property (ConfigurationEngine* self,
                                             ConfigurableProperty p,
                                             GError** error);
VALA_EXTERN void configuration_engine_set_enum_property (ConfigurationEngine* self,
                                             ConfigurableProperty p,
                                             gint val,
                                             GError** error);
VALA_EXTERN gchar* configuration_engine_get_string_property (ConfigurationEngine* self,
                                                 ConfigurableProperty p,
                                                 GError** error);
VALA_EXTERN void configuration_engine_set_string_property (ConfigurationEngine* self,
                                               ConfigurableProperty p,
                                               const gchar* val,
                                               GError** error);
VALA_EXTERN gboolean configuration_engine_get_bool_property (ConfigurationEngine* self,
                                                 ConfigurableProperty p,
                                                 GError** error);
VALA_EXTERN void configuration_engine_set_bool_property (ConfigurationEngine* self,
                                             ConfigurableProperty p,
                                             gboolean val,
                                             GError** error);
VALA_EXTERN gdouble configuration_engine_get_double_property (ConfigurationEngine* self,
                                                  ConfigurableProperty p,
                                                  GError** error);
VALA_EXTERN void configuration_engine_set_double_property (ConfigurationEngine* self,
                                               ConfigurableProperty p,
                                               gdouble val,
                                               GError** error);
VALA_EXTERN gboolean configuration_engine_get_plugin_bool (ConfigurationEngine* self,
                                               const gchar* domain,
                                               const gchar* id,
                                               const gchar* key,
                                               gboolean def);
VALA_EXTERN void configuration_engine_set_plugin_bool (ConfigurationEngine* self,
                                           const gchar* domain,
                                           const gchar* id,
                                           const gchar* key,
                                           gboolean val);
VALA_EXTERN gdouble configuration_engine_get_plugin_double (ConfigurationEngine* self,
                                                const gchar* domain,
                                                const gchar* id,
                                                const gchar* key,
                                                gdouble def);
VALA_EXTERN void configuration_engine_set_plugin_double (ConfigurationEngine* self,
                                             const gchar* domain,
                                             const gchar* id,
                                             const gchar* key,
                                             gdouble val);
VALA_EXTERN gint configuration_engine_get_plugin_int (ConfigurationEngine* self,
                                          const gchar* domain,
                                          const gchar* id,
                                          const gchar* key,
                                          gint def);
VALA_EXTERN void configuration_engine_set_plugin_int (ConfigurationEngine* self,
                                          const gchar* domain,
                                          const gchar* id,
                                          const gchar* key,
                                          gint val);
VALA_EXTERN gchar* configuration_engine_get_plugin_string (ConfigurationEngine* self,
                                               const gchar* domain,
                                               const gchar* id,
                                               const gchar* key,
                                               const gchar* def);
VALA_EXTERN void configuration_engine_set_plugin_string (ConfigurationEngine* self,
                                             const gchar* domain,
                                             const gchar* id,
                                             const gchar* key,
                                             const gchar* val);
VALA_EXTERN void configuration_engine_unset_plugin_key (ConfigurationEngine* self,
                                            const gchar* domain,
                                            const gchar* id,
                                            const gchar* key);
VALA_EXTERN FuzzyPropertyState configuration_engine_is_plugin_enabled (ConfigurationEngine* self,
                                                           const gchar* id);
VALA_EXTERN void configuration_engine_set_plugin_enabled (ConfigurationEngine* self,
                                              const gchar* id,
                                              gboolean enabled);
static GType configuration_engine_get_type_once (void);
VALA_EXTERN GType configuration_facade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigurationFacade, g_object_unref)
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
VALA_EXTERN GType scale_constraint_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType export_format_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType photo_file_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType jpeg_quality_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType raw_developer_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean configuration_facade_get_auto_import_from_library (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_auto_import_from_library (ConfigurationFacade* self,
                                                        gboolean auto_import);
VALA_EXTERN gboolean configuration_facade_get_gtk_theme_variant (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_gtk_theme_variant (ConfigurationFacade* self,
                                                 gboolean dark);
VALA_EXTERN gchar* configuration_facade_get_transparent_background_type (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_transparent_background_type (ConfigurationFacade* self,
                                                           const gchar* type);
VALA_EXTERN gchar* configuration_facade_get_transparent_background_color (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_transparent_background_color (ConfigurationFacade* self,
                                                            const gchar* color_name);
VALA_EXTERN gboolean configuration_facade_get_commit_metadata_to_masters (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_commit_metadata_to_masters (ConfigurationFacade* self,
                                                          gboolean commit_metadata);
VALA_EXTERN gchar* configuration_facade_get_desktop_background (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_desktop_background (ConfigurationFacade* self,
                                                  const gchar* filename);
VALA_EXTERN gchar* configuration_facade_get_screensaver (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_screensaver (ConfigurationFacade* self,
                                           const gchar* filename);
VALA_EXTERN gchar* configuration_facade_get_directory_pattern (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_directory_pattern (ConfigurationFacade* self,
                                                 const gchar* s);
VALA_EXTERN gchar* configuration_facade_get_directory_pattern_custom (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_directory_pattern_custom (ConfigurationFacade* self,
                                                        const gchar* s);
VALA_EXTERN void configuration_facade_get_direct_window_state (ConfigurationFacade* self,
                                                   gboolean* maximize,
                                                   Dimensions* dimensions);
VALA_EXTERN void configuration_facade_set_direct_window_state (ConfigurationFacade* self,
                                                   gboolean maximize,
                                                   Dimensions* dimensions);
VALA_EXTERN gboolean configuration_facade_get_display_basic_properties (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_display_basic_properties (ConfigurationFacade* self,
                                                        gboolean display);
VALA_EXTERN gboolean configuration_facade_get_display_extended_properties (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_display_extended_properties (ConfigurationFacade* self,
                                                           gboolean display);
VALA_EXTERN gboolean configuration_facade_get_display_sidebar (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_display_sidebar (ConfigurationFacade* self,
                                               gboolean display);
VALA_EXTERN gboolean configuration_facade_get_display_toolbar (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_display_toolbar (ConfigurationFacade* self,
                                               gboolean display);
VALA_EXTERN gboolean configuration_facade_get_display_map_widget (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_display_map_widget (ConfigurationFacade* self,
                                                  gboolean display);
VALA_EXTERN gboolean configuration_facade_get_display_search_bar (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_display_search_bar (ConfigurationFacade* self,
                                                  gboolean display);
VALA_EXTERN gboolean configuration_facade_get_display_photo_ratings (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_display_photo_ratings (ConfigurationFacade* self,
                                                     gboolean display);
VALA_EXTERN gboolean configuration_facade_get_display_photo_tags (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_display_photo_tags (ConfigurationFacade* self,
                                                  gboolean display);
VALA_EXTERN gboolean configuration_facade_get_display_photo_titles (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_display_photo_titles (ConfigurationFacade* self,
                                                    gboolean display);
VALA_EXTERN gboolean configuration_facade_get_display_photo_comments (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_display_photo_comments (ConfigurationFacade* self,
                                                      gboolean display);
VALA_EXTERN gboolean configuration_facade_get_display_event_comments (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_display_event_comments (ConfigurationFacade* self,
                                                      gboolean display);
VALA_EXTERN void configuration_facade_get_event_photos_sort (ConfigurationFacade* self,
                                                 gboolean* sort_order,
                                                 gint* sort_by);
VALA_EXTERN void configuration_facade_set_event_photos_sort (ConfigurationFacade* self,
                                                 gboolean sort_order,
                                                 gint sort_by);
VALA_EXTERN gboolean configuration_facade_get_events_sort_ascending (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_events_sort_ascending (ConfigurationFacade* self,
                                                     gboolean sort);
VALA_EXTERN gchar* configuration_facade_get_external_photo_app (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_external_photo_app (ConfigurationFacade* self,
                                                  const gchar* external_photo_app);
VALA_EXTERN gchar* configuration_facade_get_external_raw_app (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_external_raw_app (ConfigurationFacade* self,
                                                const gchar* external_raw_app);
VALA_EXTERN ScaleConstraint configuration_facade_get_export_constraint (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_export_constraint (ConfigurationFacade* self,
                                                 ScaleConstraint constraint);
VALA_EXTERN ExportFormatMode configuration_facade_get_export_export_format_mode (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_export_export_format_mode (ConfigurationFacade* self,
                                                         ExportFormatMode export_format_mode);
VALA_EXTERN gboolean configuration_facade_get_export_export_metadata (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_export_export_metadata (ConfigurationFacade* self,
                                                      gboolean export_metadata);
VALA_EXTERN PhotoFileFormat configuration_facade_get_export_photo_file_format (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_export_photo_file_format (ConfigurationFacade* self,
                                                        PhotoFileFormat photo_file_format);
VALA_EXTERN JpegQuality configuration_facade_get_export_quality (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_export_quality (ConfigurationFacade* self,
                                              JpegQuality quality);
VALA_EXTERN gint configuration_facade_get_export_scale (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_export_scale (ConfigurationFacade* self,
                                            gint scale);
VALA_EXTERN RawDeveloper configuration_facade_get_default_raw_developer (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_default_raw_developer (ConfigurationFacade* self,
                                                     RawDeveloper d);
VALA_EXTERN gboolean configuration_facade_get_hide_photos_already_imported (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_hide_photos_already_imported (ConfigurationFacade* self,
                                                            gboolean hide_imported);
VALA_EXTERN gchar* configuration_facade_get_import_dir (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_import_dir (ConfigurationFacade* self,
                                          const gchar* import_dir);
VALA_EXTERN gboolean configuration_facade_get_keep_relativity (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_keep_relativity (ConfigurationFacade* self,
                                               gboolean keep_relativity);
VALA_EXTERN gboolean configuration_facade_get_pin_toolbar_state (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_pin_toolbar_state (ConfigurationFacade* self,
                                                 gboolean state);
VALA_EXTERN gint configuration_facade_get_last_crop_height (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_last_crop_height (ConfigurationFacade* self,
                                                gint choice);
VALA_EXTERN gint configuration_facade_get_last_crop_menu_choice (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_last_crop_menu_choice (ConfigurationFacade* self,
                                                     gint choice);
VALA_EXTERN gint configuration_facade_get_last_crop_width (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_last_crop_width (ConfigurationFacade* self,
                                               gint choice);
VALA_EXTERN gchar* configuration_facade_get_last_used_service (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_last_used_service (ConfigurationFacade* self,
                                                 const gchar* service_name);
VALA_EXTERN gchar* configuration_facade_get_last_used_dataimports_service (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_last_used_dataimports_service (ConfigurationFacade* self,
                                                             const gchar* service_name);
VALA_EXTERN void configuration_facade_get_library_photos_sort (ConfigurationFacade* self,
                                                   gboolean* sort_order,
                                                   gint* sort_by);
VALA_EXTERN void configuration_facade_set_library_photos_sort (ConfigurationFacade* self,
                                                   gboolean sort_order,
                                                   gint sort_by);
VALA_EXTERN void configuration_facade_get_library_window_state (ConfigurationFacade* self,
                                                    gboolean* maximize,
                                                    Dimensions* dimensions);
VALA_EXTERN void configuration_facade_set_library_window_state (ConfigurationFacade* self,
                                                    gboolean maximize,
                                                    Dimensions* dimensions);
VALA_EXTERN gboolean configuration_facade_get_modify_originals (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_modify_originals (ConfigurationFacade* self,
                                                gboolean modify_originals);
VALA_EXTERN gint configuration_facade_get_photo_thumbnail_scale (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_photo_thumbnail_scale (ConfigurationFacade* self,
                                                     gint scale);
VALA_EXTERN gdouble configuration_facade_get_printing_content_height (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_printing_content_height (ConfigurationFacade* self,
                                                       gdouble content_height);
VALA_EXTERN gint configuration_facade_get_printing_content_layout (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_printing_content_layout (ConfigurationFacade* self,
                                                       gint layout_code);
VALA_EXTERN gint configuration_facade_get_printing_content_ppi (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_printing_content_ppi (ConfigurationFacade* self,
                                                    gint content_ppi);
VALA_EXTERN gint configuration_facade_get_printing_content_units (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_printing_content_units (ConfigurationFacade* self,
                                                      gint units_code);
VALA_EXTERN gdouble configuration_facade_get_printing_content_width (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_printing_content_width (ConfigurationFacade* self,
                                                      gdouble content_width);
VALA_EXTERN gint configuration_facade_get_printing_images_per_page (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_printing_images_per_page (ConfigurationFacade* self,
                                                        gint images_per_page_code);
VALA_EXTERN gboolean configuration_facade_get_printing_match_aspect_ratio (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_printing_match_aspect_ratio (ConfigurationFacade* self,
                                                           gboolean match_aspect_ratio);
VALA_EXTERN gboolean configuration_facade_get_printing_print_titles (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_printing_print_titles (ConfigurationFacade* self,
                                                     gboolean print_titles);
VALA_EXTERN gint configuration_facade_get_printing_size_selection (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_printing_size_selection (ConfigurationFacade* self,
                                                       gint size_code);
VALA_EXTERN gchar* configuration_facade_get_printing_titles_font (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_printing_titles_font (ConfigurationFacade* self,
                                                    const gchar* font_name);
VALA_EXTERN gboolean configuration_facade_get_show_welcome_dialog (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_show_welcome_dialog (ConfigurationFacade* self,
                                                   gboolean show);
VALA_EXTERN gint configuration_facade_get_sidebar_position (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_sidebar_position (ConfigurationFacade* self,
                                                gint position);
VALA_EXTERN gdouble configuration_facade_get_slideshow_delay (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_slideshow_delay (ConfigurationFacade* self,
                                               gdouble delay);
VALA_EXTERN gdouble configuration_facade_get_slideshow_transition_delay (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_slideshow_transition_delay (ConfigurationFacade* self,
                                                          gdouble delay);
VALA_EXTERN gchar* configuration_facade_get_slideshow_transition_effect_id (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_slideshow_transition_effect_id (ConfigurationFacade* self,
                                                              const gchar* id);
VALA_EXTERN gboolean configuration_facade_get_slideshow_show_title (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_slideshow_show_title (ConfigurationFacade* self,
                                                    gboolean show_title);
VALA_EXTERN gboolean configuration_facade_get_slideshow_shuffle (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_slideshow_shuffle (ConfigurationFacade* self,
                                                 gboolean shuffle);
VALA_EXTERN gboolean configuration_facade_get_use_24_hour_time (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_use_24_hour_time (ConfigurationFacade* self,
                                                gboolean use_24_hour_time);
VALA_EXTERN gboolean configuration_facade_get_use_lowercase_filenames (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_set_use_lowercase_filenames (ConfigurationFacade* self,
                                                       gboolean b);
VALA_EXTERN gboolean configuration_facade_get_plugin_bool (ConfigurationFacade* self,
                                               const gchar* domain,
                                               const gchar* id,
                                               const gchar* key,
                                               gboolean def);
VALA_EXTERN void configuration_facade_set_plugin_bool (ConfigurationFacade* self,
                                           const gchar* domain,
                                           const gchar* id,
                                           const gchar* key,
                                           gboolean val);
VALA_EXTERN gdouble configuration_facade_get_plugin_double (ConfigurationFacade* self,
                                                const gchar* domain,
                                                const gchar* id,
                                                const gchar* key,
                                                gdouble def);
VALA_EXTERN void configuration_facade_set_plugin_double (ConfigurationFacade* self,
                                             const gchar* domain,
                                             const gchar* id,
                                             const gchar* key,
                                             gdouble val);
VALA_EXTERN gint configuration_facade_get_plugin_int (ConfigurationFacade* self,
                                          const gchar* domain,
                                          const gchar* id,
                                          const gchar* key,
                                          gint def);
VALA_EXTERN void configuration_facade_set_plugin_int (ConfigurationFacade* self,
                                          const gchar* domain,
                                          const gchar* id,
                                          const gchar* key,
                                          gint val);
VALA_EXTERN gchar* configuration_facade_get_plugin_string (ConfigurationFacade* self,
                                               const gchar* domain,
                                               const gchar* id,
                                               const gchar* key,
                                               const gchar* def);
VALA_EXTERN void configuration_facade_set_plugin_string (ConfigurationFacade* self,
                                             const gchar* domain,
                                             const gchar* id,
                                             const gchar* key,
                                             const gchar* val);
VALA_EXTERN void configuration_facade_unset_plugin_key (ConfigurationFacade* self,
                                            const gchar* domain,
                                            const gchar* id,
                                            const gchar* key);
VALA_EXTERN FuzzyPropertyState configuration_facade_is_plugin_enabled (ConfigurationFacade* self,
                                                           const gchar* id);
VALA_EXTERN void configuration_facade_set_plugin_enabled (ConfigurationFacade* self,
                                              const gchar* id,
                                              gboolean enabled);
VALA_EXTERN ConfigurationFacade* configuration_facade_construct (GType object_type,
                                                     ConfigurationEngine* engine);
static void configuration_facade_on_property_changed (ConfigurationFacade* self,
                                               ConfigurableProperty p);
static void _configuration_facade_on_property_changed_configuration_engine_property_changed (ConfigurationEngine* _sender,
                                                                                      ConfigurableProperty p,
                                                                                      gpointer self);
VALA_EXTERN ConfigurationEngine* configuration_facade_get_engine (ConfigurationFacade* self);
VALA_EXTERN void configuration_facade_on_configuration_error (ConfigurationFacade* self,
                                                  GError* err);
static gboolean configuration_facade_real_get_auto_import_from_library (ConfigurationFacade* self);
static void configuration_facade_real_set_auto_import_from_library (ConfigurationFacade* self,
                                                             gboolean auto_import);
static gboolean configuration_facade_real_get_gtk_theme_variant (ConfigurationFacade* self);
static void configuration_facade_real_set_gtk_theme_variant (ConfigurationFacade* self,
                                                      gboolean dark);
static gchar* configuration_facade_real_get_transparent_background_type (ConfigurationFacade* self);
static void configuration_facade_real_set_transparent_background_type (ConfigurationFacade* self,
                                                                const gchar* type);
static gchar* configuration_facade_real_get_transparent_background_color (ConfigurationFacade* self);
static void configuration_facade_real_set_transparent_background_color (ConfigurationFacade* self,
                                                                 const gchar* color_name);
static gboolean configuration_facade_real_get_commit_metadata_to_masters (ConfigurationFacade* self);
static void configuration_facade_real_set_commit_metadata_to_masters (ConfigurationFacade* self,
                                                               gboolean commit_metadata);
static gchar* configuration_facade_real_get_desktop_background (ConfigurationFacade* self);
static void configuration_facade_real_set_desktop_background (ConfigurationFacade* self,
                                                       const gchar* filename);
static gchar* configuration_facade_real_get_screensaver (ConfigurationFacade* self);
static void configuration_facade_real_set_screensaver (ConfigurationFacade* self,
                                                const gchar* filename);
static gchar* configuration_facade_real_get_directory_pattern (ConfigurationFacade* self);
static void configuration_facade_real_set_directory_pattern (ConfigurationFacade* self,
                                                      const gchar* s);
static gchar* configuration_facade_real_get_directory_pattern_custom (ConfigurationFacade* self);
static void configuration_facade_real_set_directory_pattern_custom (ConfigurationFacade* self,
                                                             const gchar* s);
static void configuration_facade_real_get_direct_window_state (ConfigurationFacade* self,
                                                        gboolean* maximize,
                                                        Dimensions* dimensions);
VALA_EXTERN void dimensions_init (Dimensions *self,
                      gint width,
                      gint height);
static void configuration_facade_real_set_direct_window_state (ConfigurationFacade* self,
                                                        gboolean maximize,
                                                        Dimensions* dimensions);
static gboolean configuration_facade_real_get_display_basic_properties (ConfigurationFacade* self);
static void configuration_facade_real_set_display_basic_properties (ConfigurationFacade* self,
                                                             gboolean display);
static gboolean configuration_facade_real_get_display_extended_properties (ConfigurationFacade* self);
static void configuration_facade_real_set_display_extended_properties (ConfigurationFacade* self,
                                                                gboolean display);
static gboolean configuration_facade_real_get_display_sidebar (ConfigurationFacade* self);
static void configuration_facade_real_set_display_sidebar (ConfigurationFacade* self,
                                                    gboolean display);
static gboolean configuration_facade_real_get_display_toolbar (ConfigurationFacade* self);
static void configuration_facade_real_set_display_toolbar (ConfigurationFacade* self,
                                                    gboolean display);
static gboolean configuration_facade_real_get_display_map_widget (ConfigurationFacade* self);
static void configuration_facade_real_set_display_map_widget (ConfigurationFacade* self,
                                                       gboolean display);
static gboolean configuration_facade_real_get_display_search_bar (ConfigurationFacade* self);
static void configuration_facade_real_set_display_search_bar (ConfigurationFacade* self,
                                                       gboolean display);
static gboolean configuration_facade_real_get_display_photo_ratings (ConfigurationFacade* self);
static void configuration_facade_real_set_display_photo_ratings (ConfigurationFacade* self,
                                                          gboolean display);
static gboolean configuration_facade_real_get_display_photo_tags (ConfigurationFacade* self);
static void configuration_facade_real_set_display_photo_tags (ConfigurationFacade* self,
                                                       gboolean display);
static gboolean configuration_facade_real_get_display_photo_titles (ConfigurationFacade* self);
static void configuration_facade_real_set_display_photo_titles (ConfigurationFacade* self,
                                                         gboolean display);
static gboolean configuration_facade_real_get_display_photo_comments (ConfigurationFacade* self);
static void configuration_facade_real_set_display_photo_comments (ConfigurationFacade* self,
                                                           gboolean display);
static gboolean configuration_facade_real_get_display_event_comments (ConfigurationFacade* self);
static void configuration_facade_real_set_display_event_comments (ConfigurationFacade* self,
                                                           gboolean display);
static void configuration_facade_real_get_event_photos_sort (ConfigurationFacade* self,
                                                      gboolean* sort_order,
                                                      gint* sort_by);
static void configuration_facade_real_set_event_photos_sort (ConfigurationFacade* self,
                                                      gboolean sort_order,
                                                      gint sort_by);
static gboolean configuration_facade_real_get_events_sort_ascending (ConfigurationFacade* self);
static void configuration_facade_real_set_events_sort_ascending (ConfigurationFacade* self,
                                                          gboolean sort);
static gchar* configuration_facade_real_get_external_photo_app (ConfigurationFacade* self);
static void configuration_facade_real_set_external_photo_app (ConfigurationFacade* self,
                                                       const gchar* external_photo_app);
static gchar* configuration_facade_real_get_external_raw_app (ConfigurationFacade* self);
static void configuration_facade_real_set_external_raw_app (ConfigurationFacade* self,
                                                     const gchar* external_raw_app);
static ScaleConstraint configuration_facade_real_get_export_constraint (ConfigurationFacade* self);
static void configuration_facade_real_set_export_constraint (ConfigurationFacade* self,
                                                      ScaleConstraint constraint);
static ExportFormatMode configuration_facade_real_get_export_export_format_mode (ConfigurationFacade* self);
static void configuration_facade_real_set_export_export_format_mode (ConfigurationFacade* self,
                                                              ExportFormatMode export_format_mode);
static gboolean configuration_facade_real_get_export_export_metadata (ConfigurationFacade* self);
static void configuration_facade_real_set_export_export_metadata (ConfigurationFacade* self,
                                                           gboolean export_metadata);
static PhotoFileFormat configuration_facade_real_get_export_photo_file_format (ConfigurationFacade* self);
VALA_EXTERN PhotoFileFormat photo_file_format_unserialize (gint value);
static void configuration_facade_real_set_export_photo_file_format (ConfigurationFacade* self,
                                                             PhotoFileFormat photo_file_format);
VALA_EXTERN gint photo_file_format_serialize (PhotoFileFormat self);
static JpegQuality configuration_facade_real_get_export_quality (ConfigurationFacade* self);
static void configuration_facade_real_set_export_quality (ConfigurationFacade* self,
                                                   JpegQuality quality);
static gint configuration_facade_real_get_export_scale (ConfigurationFacade* self);
static void configuration_facade_real_set_export_scale (ConfigurationFacade* self,
                                                 gint scale);
static RawDeveloper configuration_facade_real_get_default_raw_developer (ConfigurationFacade* self);
VALA_EXTERN RawDeveloper raw_developer_from_string (const gchar* value);
static void configuration_facade_real_set_default_raw_developer (ConfigurationFacade* self,
                                                          RawDeveloper d);
VALA_EXTERN gchar* raw_developer_to_string (RawDeveloper self);
static gboolean configuration_facade_real_get_hide_photos_already_imported (ConfigurationFacade* self);
static void configuration_facade_real_set_hide_photos_already_imported (ConfigurationFacade* self,
                                                                 gboolean hide_imported);
static gchar* configuration_facade_real_get_import_dir (ConfigurationFacade* self);
static void configuration_facade_real_set_import_dir (ConfigurationFacade* self,
                                               const gchar* import_dir);
static gboolean configuration_facade_real_get_keep_relativity (ConfigurationFacade* self);
static void configuration_facade_real_set_keep_relativity (ConfigurationFacade* self,
                                                    gboolean keep_relativity);
static gboolean configuration_facade_real_get_pin_toolbar_state (ConfigurationFacade* self);
static void configuration_facade_real_set_pin_toolbar_state (ConfigurationFacade* self,
                                                      gboolean state);
static gint configuration_facade_real_get_last_crop_height (ConfigurationFacade* self);
static void configuration_facade_real_set_last_crop_height (ConfigurationFacade* self,
                                                     gint choice);
static gint configuration_facade_real_get_last_crop_menu_choice (ConfigurationFacade* self);
static void configuration_facade_real_set_last_crop_menu_choice (ConfigurationFacade* self,
                                                          gint choice);
static gint configuration_facade_real_get_last_crop_width (ConfigurationFacade* self);
static void configuration_facade_real_set_last_crop_width (ConfigurationFacade* self,
                                                    gint choice);
static gchar* configuration_facade_real_get_last_used_service (ConfigurationFacade* self);
static void configuration_facade_real_set_last_used_service (ConfigurationFacade* self,
                                                      const gchar* service_name);
static gchar* configuration_facade_real_get_last_used_dataimports_service (ConfigurationFacade* self);
static void configuration_facade_real_set_last_used_dataimports_service (ConfigurationFacade* self,
                                                                  const gchar* service_name);
static void configuration_facade_real_get_library_photos_sort (ConfigurationFacade* self,
                                                        gboolean* sort_order,
                                                        gint* sort_by);
static void configuration_facade_real_set_library_photos_sort (ConfigurationFacade* self,
                                                        gboolean sort_order,
                                                        gint sort_by);
static void configuration_facade_real_get_library_window_state (ConfigurationFacade* self,
                                                         gboolean* maximize,
                                                         Dimensions* dimensions);
static void configuration_facade_real_set_library_window_state (ConfigurationFacade* self,
                                                         gboolean maximize,
                                                         Dimensions* dimensions);
static gboolean configuration_facade_real_get_modify_originals (ConfigurationFacade* self);
static void configuration_facade_real_set_modify_originals (ConfigurationFacade* self,
                                                     gboolean modify_originals);
static gint configuration_facade_real_get_photo_thumbnail_scale (ConfigurationFacade* self);
VALA_EXTERN gint thumbnail_get_DEFAULT_SCALE (void);
static void configuration_facade_real_set_photo_thumbnail_scale (ConfigurationFacade* self,
                                                          gint scale);
static gdouble configuration_facade_real_get_printing_content_height (ConfigurationFacade* self);
static void configuration_facade_real_set_printing_content_height (ConfigurationFacade* self,
                                                            gdouble content_height);
static gint configuration_facade_real_get_printing_content_layout (ConfigurationFacade* self);
static void configuration_facade_real_set_printing_content_layout (ConfigurationFacade* self,
                                                            gint layout_code);
static gint configuration_facade_real_get_printing_content_ppi (ConfigurationFacade* self);
static void configuration_facade_real_set_printing_content_ppi (ConfigurationFacade* self,
                                                         gint content_ppi);
static gint configuration_facade_real_get_printing_content_units (ConfigurationFacade* self);
static void configuration_facade_real_set_printing_content_units (ConfigurationFacade* self,
                                                           gint units_code);
static gdouble configuration_facade_real_get_printing_content_width (ConfigurationFacade* self);
static void configuration_facade_real_set_printing_content_width (ConfigurationFacade* self,
                                                           gdouble content_width);
static gint configuration_facade_real_get_printing_images_per_page (ConfigurationFacade* self);
static void configuration_facade_real_set_printing_images_per_page (ConfigurationFacade* self,
                                                             gint images_per_page_code);
static gboolean configuration_facade_real_get_printing_match_aspect_ratio (ConfigurationFacade* self);
static void configuration_facade_real_set_printing_match_aspect_ratio (ConfigurationFacade* self,
                                                                gboolean match_aspect_ratio);
static gboolean configuration_facade_real_get_printing_print_titles (ConfigurationFacade* self);
static void configuration_facade_real_set_printing_print_titles (ConfigurationFacade* self,
                                                          gboolean print_titles);
static gint configuration_facade_real_get_printing_size_selection (ConfigurationFacade* self);
VALA_EXTERN GType resources_unit_system_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ResourcesUnitSystem resources_get_default_measurement_unit (void);
static void configuration_facade_real_set_printing_size_selection (ConfigurationFacade* self,
                                                            gint size_code);
static gchar* configuration_facade_real_get_printing_titles_font (ConfigurationFacade* self);
static void configuration_facade_real_set_printing_titles_font (ConfigurationFacade* self,
                                                         const gchar* font_name);
static gboolean configuration_facade_real_get_show_welcome_dialog (ConfigurationFacade* self);
static void configuration_facade_real_set_show_welcome_dialog (ConfigurationFacade* self,
                                                        gboolean show);
static gint configuration_facade_real_get_sidebar_position (ConfigurationFacade* self);
static void configuration_facade_real_set_sidebar_position (ConfigurationFacade* self,
                                                     gint position);
static gdouble configuration_facade_real_get_slideshow_delay (ConfigurationFacade* self);
static void configuration_facade_real_set_slideshow_delay (ConfigurationFacade* self,
                                                    gdouble delay);
static gdouble configuration_facade_real_get_slideshow_transition_delay (ConfigurationFacade* self);
static void configuration_facade_real_set_slideshow_transition_delay (ConfigurationFacade* self,
                                                               gdouble delay);
static gchar* configuration_facade_real_get_slideshow_transition_effect_id (ConfigurationFacade* self);
static void configuration_facade_real_set_slideshow_transition_effect_id (ConfigurationFacade* self,
                                                                   const gchar* id);
static gboolean configuration_facade_real_get_slideshow_show_title (ConfigurationFacade* self);
static void configuration_facade_real_set_slideshow_show_title (ConfigurationFacade* self,
                                                         gboolean show_title);
static gboolean configuration_facade_real_get_slideshow_shuffle (ConfigurationFacade* self);
static void configuration_facade_real_set_slideshow_shuffle (ConfigurationFacade* self,
                                                      gboolean shuffle);
static gboolean configuration_facade_real_get_use_24_hour_time (ConfigurationFacade* self);
VALA_EXTERN gboolean is_string_empty (const gchar* s);
static void configuration_facade_real_set_use_24_hour_time (ConfigurationFacade* self,
                                                     gboolean use_24_hour_time);
static gboolean configuration_facade_real_get_use_lowercase_filenames (ConfigurationFacade* self);
static void configuration_facade_real_set_use_lowercase_filenames (ConfigurationFacade* self,
                                                            gboolean b);
static gboolean configuration_facade_real_get_plugin_bool (ConfigurationFacade* self,
                                                    const gchar* domain,
                                                    const gchar* id,
                                                    const gchar* key,
                                                    gboolean def);
static void configuration_facade_real_set_plugin_bool (ConfigurationFacade* self,
                                                const gchar* domain,
                                                const gchar* id,
                                                const gchar* key,
                                                gboolean val);
static gdouble configuration_facade_real_get_plugin_double (ConfigurationFacade* self,
                                                     const gchar* domain,
                                                     const gchar* id,
                                                     const gchar* key,
                                                     gdouble def);
static void configuration_facade_real_set_plugin_double (ConfigurationFacade* self,
                                                  const gchar* domain,
                                                  const gchar* id,
                                                  const gchar* key,
                                                  gdouble val);
static gint configuration_facade_real_get_plugin_int (ConfigurationFacade* self,
                                               const gchar* domain,
                                               const gchar* id,
                                               const gchar* key,
                                               gint def);
static void configuration_facade_real_set_plugin_int (ConfigurationFacade* self,
                                               const gchar* domain,
                                               const gchar* id,
                                               const gchar* key,
                                               gint val);
static gchar* configuration_facade_real_get_plugin_string (ConfigurationFacade* self,
                                                    const gchar* domain,
                                                    const gchar* id,
                                                    const gchar* key,
                                                    const gchar* def);
static void configuration_facade_real_set_plugin_string (ConfigurationFacade* self,
                                                  const gchar* domain,
                                                  const gchar* id,
                                                  const gchar* key,
                                                  const gchar* val);
static void configuration_facade_real_unset_plugin_key (ConfigurationFacade* self,
                                                 const gchar* domain,
                                                 const gchar* id,
                                                 const gchar* key);
static FuzzyPropertyState configuration_facade_real_is_plugin_enabled (ConfigurationFacade* self,
                                                                const gchar* id);
static void configuration_facade_real_set_plugin_enabled (ConfigurationFacade* self,
                                                   const gchar* id,
                                                   gboolean enabled);
static void configuration_facade_finalize (GObject * obj);
static GType configuration_facade_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

GQuark
configuration_error_quark (void)
{
	return g_quark_from_static_string ("configuration-error-quark");
}

static GType
configuration_error_get_type_once (void)
{
	static const GEnumValue values[] = {{CONFIGURATION_ERROR_PROPERTY_HAS_NO_VALUE, "CONFIGURATION_ERROR_PROPERTY_HAS_NO_VALUE", "property-has-no-value"}, {CONFIGURATION_ERROR_ENGINE_ERROR, "CONFIGURATION_ERROR_ENGINE_ERROR", "engine-error"}, {0, NULL, NULL}};
	GType configuration_error_type_id;
	configuration_error_type_id = g_enum_register_static ("ConfigurationError", values);
	return configuration_error_type_id;
}

GType
configuration_error_get_type (void)
{
	static volatile gsize configuration_error_type_id__once = 0;
	if (g_once_init_enter (&configuration_error_type_id__once)) {
		GType configuration_error_type_id;
		configuration_error_type_id = configuration_error_get_type_once ();
		g_once_init_leave (&configuration_error_type_id__once, configuration_error_type_id);
	}
	return configuration_error_type_id__once;
}

static GType
fuzzy_property_state_get_type_once (void)
{
	static const GEnumValue values[] = {{FUZZY_PROPERTY_STATE_ENABLED, "FUZZY_PROPERTY_STATE_ENABLED", "enabled"}, {FUZZY_PROPERTY_STATE_DISABLED, "FUZZY_PROPERTY_STATE_DISABLED", "disabled"}, {FUZZY_PROPERTY_STATE_UNKNOWN, "FUZZY_PROPERTY_STATE_UNKNOWN", "unknown"}, {0, NULL, NULL}};
	GType fuzzy_property_state_type_id;
	fuzzy_property_state_type_id = g_enum_register_static ("FuzzyPropertyState", values);
	return fuzzy_property_state_type_id;
}

GType
fuzzy_property_state_get_type (void)
{
	static volatile gsize fuzzy_property_state_type_id__once = 0;
	if (g_once_init_enter (&fuzzy_property_state_type_id__once)) {
		GType fuzzy_property_state_type_id;
		fuzzy_property_state_type_id = fuzzy_property_state_get_type_once ();
		g_once_init_leave (&fuzzy_property_state_type_id__once, fuzzy_property_state_type_id);
	}
	return fuzzy_property_state_type_id__once;
}

gchar*
configurable_property_to_string (ConfigurableProperty self)
{
	gchar* result;
	switch (self) {
		case CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("AUTO_IMPORT_FROM_LIBRARY");
			result = _tmp0_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_GTK_THEME_VARIANT:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("GTK_THEME_VARIANT");
			result = _tmp1_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_TYPE:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("TRANSPARENT_BACKGROUND_TYPE");
			result = _tmp2_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_COLOR:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("TRANSPARENT_BACKGROUND_COLOR");
			result = _tmp3_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("COMMIT_METADATA_TO_MASTERS");
			result = _tmp4_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("DESKTOP_BACKGROUND_FILE");
			result = _tmp5_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_MODE:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("DESKTOP_BACKGROUND_MODE");
			result = _tmp6_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_SCREENSAVER_FILE:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("SCREENSAVER_FILE");
			result = _tmp7_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_SCREENSAVER_MODE:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("SCREENSAVER_MODE");
			result = _tmp8_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("DIRECTORY_PATTERN");
			result = _tmp9_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM:
		{
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("DIRECTORY_PATTERN_CUSTOM");
			result = _tmp10_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT:
		{
			gchar* _tmp11_;
			_tmp11_ = g_strdup ("DIRECT_WINDOW_HEIGHT");
			result = _tmp11_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE:
		{
			gchar* _tmp12_;
			_tmp12_ = g_strdup ("DIRECT_WINDOW_MAXIMIZE");
			result = _tmp12_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH:
		{
			gchar* _tmp13_;
			_tmp13_ = g_strdup ("DIRECT_WINDOW_WIDTH");
			result = _tmp13_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES:
		{
			gchar* _tmp14_;
			_tmp14_ = g_strdup ("DISPLAY_BASIC_PROPERTIES");
			result = _tmp14_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES:
		{
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("DISPLAY_EXTENDED_PROPERTIES");
			result = _tmp15_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR:
		{
			gchar* _tmp16_;
			_tmp16_ = g_strdup ("DISPLAY_SIDEBAR");
			result = _tmp16_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_DISPLAY_TOOLBAR:
		{
			gchar* _tmp17_;
			_tmp17_ = g_strdup ("DISPLAY_TOOLBAR");
			result = _tmp17_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_DISPLAY_MAP_WIDGET:
		{
			gchar* _tmp18_;
			_tmp18_ = g_strdup ("DISPLAY_MAP_WIDGET");
			result = _tmp18_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR:
		{
			gchar* _tmp19_;
			_tmp19_ = g_strdup ("DISPLAY_SEARCH_BAR");
			result = _tmp19_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS:
		{
			gchar* _tmp20_;
			_tmp20_ = g_strdup ("DISPLAY_PHOTO_RATINGS");
			result = _tmp20_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS:
		{
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("DISPLAY_PHOTO_TAGS");
			result = _tmp21_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES:
		{
			gchar* _tmp22_;
			_tmp22_ = g_strdup ("DISPLAY_PHOTO_TITLES");
			result = _tmp22_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS:
		{
			gchar* _tmp23_;
			_tmp23_ = g_strdup ("DISPLAY_PHOTO_COMMENTS");
			result = _tmp23_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS:
		{
			gchar* _tmp24_;
			_tmp24_ = g_strdup ("DISPLAY_EVENT_COMMENTS");
			result = _tmp24_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING:
		{
			gchar* _tmp25_;
			_tmp25_ = g_strdup ("EVENT_PHOTOS_SORT_ASCENDING");
			result = _tmp25_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY:
		{
			gchar* _tmp26_;
			_tmp26_ = g_strdup ("EVENT_PHOTOS_SORT_BY");
			result = _tmp26_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING:
		{
			gchar* _tmp27_;
			_tmp27_ = g_strdup ("EVENTS_SORT_ASCENDING");
			result = _tmp27_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_EXPORT_CONSTRAINT:
		{
			gchar* _tmp28_;
			_tmp28_ = g_strdup ("EXPORT_CONSTRAINT");
			result = _tmp28_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_EXPORT_EXPORT_FORMAT_MODE:
		{
			gchar* _tmp29_;
			_tmp29_ = g_strdup ("EXPORT_EXPORT_FORMAT_MODE");
			result = _tmp29_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_EXPORT_EXPORT_METADATA:
		{
			gchar* _tmp30_;
			_tmp30_ = g_strdup ("EXPORT_EXPORT_METADATA");
			result = _tmp30_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_EXPORT_PHOTO_FILE_FORMAT:
		{
			gchar* _tmp31_;
			_tmp31_ = g_strdup ("EXPORT_PHOTO_FILE_FORMAT");
			result = _tmp31_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_EXPORT_QUALITY:
		{
			gchar* _tmp32_;
			_tmp32_ = g_strdup ("EXPORT_QUALITY");
			result = _tmp32_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_EXPORT_SCALE:
		{
			gchar* _tmp33_;
			_tmp33_ = g_strdup ("EXPORT_SCALE");
			result = _tmp33_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP:
		{
			gchar* _tmp34_;
			_tmp34_ = g_strdup ("EXTERNAL_PHOTO_APP");
			result = _tmp34_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP:
		{
			gchar* _tmp35_;
			_tmp35_ = g_strdup ("EXTERNAL_RAW_APP");
			result = _tmp35_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED:
		{
			gchar* _tmp36_;
			_tmp36_ = g_strdup ("HIDE_PHOTOS_ALREADY_IMPORTED");
			result = _tmp36_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_IMPORT_DIR:
		{
			gchar* _tmp37_;
			_tmp37_ = g_strdup ("IMPORT_DIR");
			result = _tmp37_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_KEEP_RELATIVITY:
		{
			gchar* _tmp38_;
			_tmp38_ = g_strdup ("KEEP_RELATIVITY");
			result = _tmp38_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT:
		{
			gchar* _tmp39_;
			_tmp39_ = g_strdup ("LAST_CROP_HEIGHT");
			result = _tmp39_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE:
		{
			gchar* _tmp40_;
			_tmp40_ = g_strdup ("LAST_CROP_MENU_CHOICE");
			result = _tmp40_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH:
		{
			gchar* _tmp41_;
			_tmp41_ = g_strdup ("LAST_CROP_WIDTH");
			result = _tmp41_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_LAST_USED_SERVICE:
		{
			gchar* _tmp42_;
			_tmp42_ = g_strdup ("LAST_USED_SERVICE");
			result = _tmp42_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE:
		{
			gchar* _tmp43_;
			_tmp43_ = g_strdup ("LAST_USED_DATAIMPORTS_SERVICE");
			result = _tmp43_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING:
		{
			gchar* _tmp44_;
			_tmp44_ = g_strdup ("LIBRARY_PHOTOS_SORT_ASCENDING");
			result = _tmp44_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY:
		{
			gchar* _tmp45_;
			_tmp45_ = g_strdup ("LIBRARY_PHOTOS_SORT_BY");
			result = _tmp45_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT:
		{
			gchar* _tmp46_;
			_tmp46_ = g_strdup ("LIBRARY_WINDOW_HEIGHT");
			result = _tmp46_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE:
		{
			gchar* _tmp47_;
			_tmp47_ = g_strdup ("LIBRARY_WINDOW_MAXIMIZE");
			result = _tmp47_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH:
		{
			gchar* _tmp48_;
			_tmp48_ = g_strdup ("LIBRARY_WINDOW_WIDTH");
			result = _tmp48_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS:
		{
			gchar* _tmp49_;
			_tmp49_ = g_strdup ("MODIFY_ORIGINALS");
			result = _tmp49_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE:
		{
			gchar* _tmp50_;
			_tmp50_ = g_strdup ("PHOTO_THUMBNAIL_SCALE");
			result = _tmp50_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE:
		{
			gchar* _tmp51_;
			_tmp51_ = g_strdup ("PIN_TOOLBAR_STATE");
			result = _tmp51_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT:
		{
			gchar* _tmp52_;
			_tmp52_ = g_strdup ("PRINTING_CONTENT_HEIGHT");
			result = _tmp52_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT:
		{
			gchar* _tmp53_;
			_tmp53_ = g_strdup ("PRINTING_CONTENT_LAYOUT");
			result = _tmp53_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI:
		{
			gchar* _tmp54_;
			_tmp54_ = g_strdup ("PRINTING_CONTENT_PPI");
			result = _tmp54_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS:
		{
			gchar* _tmp55_;
			_tmp55_ = g_strdup ("PRINTING_CONTENT_UNITS");
			result = _tmp55_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH:
		{
			gchar* _tmp56_;
			_tmp56_ = g_strdup ("PRINTING_CONTENT_WIDTH");
			result = _tmp56_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE:
		{
			gchar* _tmp57_;
			_tmp57_ = g_strdup ("PRINTING_IMAGES_PER_PAGE");
			result = _tmp57_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO:
		{
			gchar* _tmp58_;
			_tmp58_ = g_strdup ("PRINTING_MATCH_ASPECT_RATIO");
			result = _tmp58_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES:
		{
			gchar* _tmp59_;
			_tmp59_ = g_strdup ("PRINTING_PRINT_TITLES");
			result = _tmp59_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION:
		{
			gchar* _tmp60_;
			_tmp60_ = g_strdup ("PRINTING_SIZE_SELECTION");
			result = _tmp60_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT:
		{
			gchar* _tmp61_;
			_tmp61_ = g_strdup ("PRINTING_TITLES_FONT");
			result = _tmp61_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT:
		{
			gchar* _tmp62_;
			_tmp62_ = g_strdup ("RAW_DEVELOPER_DEFAULT");
			result = _tmp62_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG:
		{
			gchar* _tmp63_;
			_tmp63_ = g_strdup ("SHOW_WELCOME_DIALOG");
			result = _tmp63_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_SIDEBAR_POSITION:
		{
			gchar* _tmp64_;
			_tmp64_ = g_strdup ("SIDEBAR_POSITION");
			result = _tmp64_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY:
		{
			gchar* _tmp65_;
			_tmp65_ = g_strdup ("SLIDESHOW_DELAY");
			result = _tmp65_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY:
		{
			gchar* _tmp66_;
			_tmp66_ = g_strdup ("SLIDESHOW_TRANSITION_DELAY");
			result = _tmp66_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID:
		{
			gchar* _tmp67_;
			_tmp67_ = g_strdup ("SLIDESHOW_TRANSITION_EFFECT_ID");
			result = _tmp67_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE:
		{
			gchar* _tmp68_;
			_tmp68_ = g_strdup ("SLIDESHOW_SHOW_TITLE");
			result = _tmp68_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_SLIDESHOW_SHUFFLE:
		{
			gchar* _tmp69_;
			_tmp69_ = g_strdup ("SLIDESHOW_SHUFFLE");
			result = _tmp69_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME:
		{
			gchar* _tmp70_;
			_tmp70_ = g_strdup ("USE_24_HOUR_TIME");
			result = _tmp70_;
			return result;
		}
		case CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES:
		{
			gchar* _tmp71_;
			_tmp71_ = g_strdup ("USE_LOWERCASE_FILENAMES");
			result = _tmp71_;
			return result;
		}
		default:
		{
			g_error ("ConfigurationInterfaces.vala:318: unknown ConfigurableProperty enumera" \
"tion value");
		}
	}
}

static GType
configurable_property_get_type_once (void)
{
	static const GEnumValue values[] = {{CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY, "CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY", "auto-import-from-library"}, {CONFIGURABLE_PROPERTY_GTK_THEME_VARIANT, "CONFIGURABLE_PROPERTY_GTK_THEME_VARIANT", "gtk-theme-variant"}, {CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_TYPE, "CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_TYPE", "transparent-background-type"}, {CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_COLOR, "CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_COLOR", "transparent-background-color"}, {CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS, "CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS", "commit-metadata-to-masters"}, {CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE, "CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE", "desktop-background-file"}, {CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_MODE, "CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_MODE", "desktop-background-mode"}, {CONFIGURABLE_PROPERTY_SCREENSAVER_FILE, "CONFIGURABLE_PROPERTY_SCREENSAVER_FILE", "screensaver-file"}, {CONFIGURABLE_PROPERTY_SCREENSAVER_MODE, "CONFIGURABLE_PROPERTY_SCREENSAVER_MODE", "screensaver-mode"}, {CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN, "CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN", "directory-pattern"}, {CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM, "CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM", "directory-pattern-custom"}, {CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT, "CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT", "direct-window-height"}, {CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE, "CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE", "direct-window-maximize"}, {CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH, "CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH", "direct-window-width"}, {CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES, "CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES", "display-basic-properties"}, {CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS, "CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS", "display-event-comments"}, {CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES, "CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES", "display-extended-properties"}, {CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR, "CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR", "display-sidebar"}, {CONFIGURABLE_PROPERTY_DISPLAY_TOOLBAR, "CONFIGURABLE_PROPERTY_DISPLAY_TOOLBAR", "display-toolbar"}, {CONFIGURABLE_PROPERTY_DISPLAY_MAP_WIDGET, "CONFIGURABLE_PROPERTY_DISPLAY_MAP_WIDGET", "display-map-widget"}, {CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR, "CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR", "display-search-bar"}, {CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS, "CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS", "display-photo-ratings"}, {CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS, "CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS", "display-photo-tags"}, {CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES, "CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES", "display-photo-titles"}, {CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS, "CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS", "display-photo-comments"}, {CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING, "CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING", "event-photos-sort-ascending"}, {CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY, "CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY", "event-photos-sort-by"}, {CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING, "CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING", "events-sort-ascending"}, {CONFIGURABLE_PROPERTY_EXPORT_CONSTRAINT, "CONFIGURABLE_PROPERTY_EXPORT_CONSTRAINT", "export-constraint"}, {CONFIGURABLE_PROPERTY_EXPORT_EXPORT_FORMAT_MODE, "CONFIGURABLE_PROPERTY_EXPORT_EXPORT_FORMAT_MODE", "export-export-format-mode"}, {CONFIGURABLE_PROPERTY_EXPORT_EXPORT_METADATA, "CONFIGURABLE_PROPERTY_EXPORT_EXPORT_METADATA", "export-export-metadata"}, {CONFIGURABLE_PROPERTY_EXPORT_PHOTO_FILE_FORMAT, "CONFIGURABLE_PROPERTY_EXPORT_PHOTO_FILE_FORMAT", "export-photo-file-format"}, {CONFIGURABLE_PROPERTY_EXPORT_QUALITY, "CONFIGURABLE_PROPERTY_EXPORT_QUALITY", "export-quality"}, {CONFIGURABLE_PROPERTY_EXPORT_SCALE, "CONFIGURABLE_PROPERTY_EXPORT_SCALE", "export-scale"}, {CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP, "CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP", "external-photo-app"}, {CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP, "CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP", "external-raw-app"}, {CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED, "CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED", "hide-photos-already-imported"}, {CONFIGURABLE_PROPERTY_IMPORT_DIR, "CONFIGURABLE_PROPERTY_IMPORT_DIR", "import-dir"}, {CONFIGURABLE_PROPERTY_KEEP_RELATIVITY, "CONFIGURABLE_PROPERTY_KEEP_RELATIVITY", "keep-relativity"}, {CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT, "CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT", "last-crop-height"}, {CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE, "CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE", "last-crop-menu-choice"}, {CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH, "CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH", "last-crop-width"}, {CONFIGURABLE_PROPERTY_LAST_USED_SERVICE, "CONFIGURABLE_PROPERTY_LAST_USED_SERVICE", "last-used-service"}, {CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE, "CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE", "last-used-dataimports-service"}, {CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING, "CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING", "library-photos-sort-ascending"}, {CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY, "CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY", "library-photos-sort-by"}, {CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT, "CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT", "library-window-height"}, {CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE, "CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE", "library-window-maximize"}, {CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH, "CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH", "library-window-width"}, {CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS, "CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS", "modify-originals"}, {CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE, "CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE", "photo-thumbnail-scale"}, {CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE, "CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE", "pin-toolbar-state"}, {CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT, "CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT", "printing-content-height"}, {CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT, "CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT", "printing-content-layout"}, {CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI, "CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI", "printing-content-ppi"}, {CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS, "CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS", "printing-content-units"}, {CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH, "CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH", "printing-content-width"}, {CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE, "CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE", "printing-images-per-page"}, {CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO, "CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO", "printing-match-aspect-ratio"}, {CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES, "CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES", "printing-print-titles"}, {CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION, "CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION", "printing-size-selection"}, {CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT, "CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT", "printing-titles-font"}, {CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT, "CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT", "raw-developer-default"}, {CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG, "CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG", "show-welcome-dialog"}, {CONFIGURABLE_PROPERTY_SIDEBAR_POSITION, "CONFIGURABLE_PROPERTY_SIDEBAR_POSITION", "sidebar-position"}, {CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY, "CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY", "slideshow-delay"}, {CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY, "CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY", "slideshow-transition-delay"}, {CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID, "CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID", "slideshow-transition-effect-id"}, {CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE, "CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE", "slideshow-show-title"}, {CONFIGURABLE_PROPERTY_SLIDESHOW_SHUFFLE, "CONFIGURABLE_PROPERTY_SLIDESHOW_SHUFFLE", "slideshow-shuffle"}, {CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME, "CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME", "use-24-hour-time"}, {CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES, "CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES", "use-lowercase-filenames"}, {CONFIGURABLE_PROPERTY_NUM_PROPERTIES, "CONFIGURABLE_PROPERTY_NUM_PROPERTIES", "num-properties"}, {0, NULL, NULL}};
	GType configurable_property_type_id;
	configurable_property_type_id = g_enum_register_static ("ConfigurableProperty", values);
	return configurable_property_type_id;
}

GType
configurable_property_get_type (void)
{
	static volatile gsize configurable_property_type_id__once = 0;
	if (g_once_init_enter (&configurable_property_type_id__once)) {
		GType configurable_property_type_id;
		configurable_property_type_id = configurable_property_get_type_once ();
		g_once_init_leave (&configurable_property_type_id__once, configurable_property_type_id);
	}
	return configurable_property_type_id__once;
}

gchar*
configuration_engine_get_name (ConfigurationEngine* self)
{
	ConfigurationEngineIface* _iface_;
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), NULL);
	_iface_ = CONFIGURATION_ENGINE_GET_INTERFACE (self);
	if (_iface_->get_name) {
		return _iface_->get_name (self);
	}
	return NULL;
}

gint
configuration_engine_get_int_property (ConfigurationEngine* self,
                                       ConfigurableProperty p,
                                       GError** error)
{
	ConfigurationEngineIface* _iface_;
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0);
	_iface_ = CONFIGURATION_ENGINE_GET_INTERFACE (self);
	if (_iface_->get_int_property) {
		return _iface_->get_int_property (self, p, error);
	}
	return -1;
}

void
configuration_engine_set_int_property (ConfigurationEngine* self,
                                       ConfigurableProperty p,
                                       gint val,
                                       GError** error)
{
	ConfigurationEngineIface* _iface_;
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
	_iface_ = CONFIGURATION_ENGINE_GET_INTERFACE (self);
	if (_iface_->set_int_property) {
		_iface_->set_int_property (self, p, val, error);
	}
}

gint
configuration_engine_get_enum_property (ConfigurationEngine* self,
                                        ConfigurableProperty p,
                                        GError** error)
{
	ConfigurationEngineIface* _iface_;
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0);
	_iface_ = CONFIGURATION_ENGINE_GET_INTERFACE (self);
	if (_iface_->get_enum_property) {
		return _iface_->get_enum_property (self, p, error);
	}
	return -1;
}

void
configuration_engine_set_enum_property (ConfigurationEngine* self,
                                        ConfigurableProperty p,
                                        gint val,
                                        GError** error)
{
	ConfigurationEngineIface* _iface_;
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
	_iface_ = CONFIGURATION_ENGINE_GET_INTERFACE (self);
	if (_iface_->set_enum_property) {
		_iface_->set_enum_property (self, p, val, error);
	}
}

gchar*
configuration_engine_get_string_property (ConfigurationEngine* self,
                                          ConfigurableProperty p,
                                          GError** error)
{
	ConfigurationEngineIface* _iface_;
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), NULL);
	_iface_ = CONFIGURATION_ENGINE_GET_INTERFACE (self);
	if (_iface_->get_string_property) {
		return _iface_->get_string_property (self, p, error);
	}
	return NULL;
}

void
configuration_engine_set_string_property (ConfigurationEngine* self,
                                          ConfigurableProperty p,
                                          const gchar* val,
                                          GError** error)
{
	ConfigurationEngineIface* _iface_;
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
	_iface_ = CONFIGURATION_ENGINE_GET_INTERFACE (self);
	if (_iface_->set_string_property) {
		_iface_->set_string_property (self, p, val, error);
	}
}

gboolean
configuration_engine_get_bool_property (ConfigurationEngine* self,
                                        ConfigurableProperty p,
                                        GError** error)
{
	ConfigurationEngineIface* _iface_;
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), FALSE);
	_iface_ = CONFIGURATION_ENGINE_GET_INTERFACE (self);
	if (_iface_->get_bool_property) {
		return _iface_->get_bool_property (self, p, error);
	}
	return FALSE;
}

void
configuration_engine_set_bool_property (ConfigurationEngine* self,
                                        ConfigurableProperty p,
                                        gboolean val,
                                        GError** error)
{
	ConfigurationEngineIface* _iface_;
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
	_iface_ = CONFIGURATION_ENGINE_GET_INTERFACE (self);
	if (_iface_->set_bool_property) {
		_iface_->set_bool_property (self, p, val, error);
	}
}

gdouble
configuration_engine_get_double_property (ConfigurationEngine* self,
                                          ConfigurableProperty p,
                                          GError** error)
{
	ConfigurationEngineIface* _iface_;
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0.0);
	_iface_ = CONFIGURATION_ENGINE_GET_INTERFACE (self);
	if (_iface_->get_double_property) {
		return _iface_->get_double_property (self, p, error);
	}
	return -1.0;
}

void
configuration_engine_set_double_property (ConfigurationEngine* self,
                                          ConfigurableProperty p,
                                          gdouble val,
                                          GError** error)
{
	ConfigurationEngineIface* _iface_;
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
	_iface_ = CONFIGURATION_ENGINE_GET_INTERFACE (self);
	if (_iface_->set_double_property) {
		_iface_->set_double_property (self, p, val, error);
	}
}

gboolean
configuration_engine_get_plugin_bool (ConfigurationEngine* self,
                                      const gchar* domain,
                                      const gchar* id,
                                      const gchar* key,
                                      gboolean def)
{
	ConfigurationEngineIface* _iface_;
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), FALSE);
	_iface_ = CONFIGURATION_ENGINE_GET_INTERFACE (self);
	if (_iface_->get_plugin_bool) {
		return _iface_->get_plugin_bool (self, domain, id, key, def);
	}
	return FALSE;
}

void
configuration_engine_set_plugin_bool (ConfigurationEngine* self,
                                      const gchar* domain,
                                      const gchar* id,
                                      const gchar* key,
                                      gboolean val)
{
	ConfigurationEngineIface* _iface_;
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
	_iface_ = CONFIGURATION_ENGINE_GET_INTERFACE (self);
	if (_iface_->set_plugin_bool) {
		_iface_->set_plugin_bool (self, domain, id, key, val);
	}
}

gdouble
configuration_engine_get_plugin_double (ConfigurationEngine* self,
                                        const gchar* domain,
                                        const gchar* id,
                                        const gchar* key,
                                        gdouble def)
{
	ConfigurationEngineIface* _iface_;
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0.0);
	_iface_ = CONFIGURATION_ENGINE_GET_INTERFACE (self);
	if (_iface_->get_plugin_double) {
		return _iface_->get_plugin_double (self, domain, id, key, def);
	}
	return -1.0;
}

void
configuration_engine_set_plugin_double (ConfigurationEngine* self,
                                        const gchar* domain,
                                        const gchar* id,
                                        const gchar* key,
                                        gdouble val)
{
	ConfigurationEngineIface* _iface_;
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
	_iface_ = CONFIGURATION_ENGINE_GET_INTERFACE (self);
	if (_iface_->set_plugin_double) {
		_iface_->set_plugin_double (self, domain, id, key, val);
	}
}

gint
configuration_engine_get_plugin_int (ConfigurationEngine* self,
                                     const gchar* domain,
                                     const gchar* id,
                                     const gchar* key,
                                     gint def)
{
	ConfigurationEngineIface* _iface_;
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0);
	_iface_ = CONFIGURATION_ENGINE_GET_INTERFACE (self);
	if (_iface_->get_plugin_int) {
		return _iface_->get_plugin_int (self, domain, id, key, def);
	}
	return -1;
}

void
configuration_engine_set_plugin_int (ConfigurationEngine* self,
                                     const gchar* domain,
                                     const gchar* id,
                                     const gchar* key,
                                     gint val)
{
	ConfigurationEngineIface* _iface_;
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
	_iface_ = CONFIGURATION_ENGINE_GET_INTERFACE (self);
	if (_iface_->set_plugin_int) {
		_iface_->set_plugin_int (self, domain, id, key, val);
	}
}

gchar*
configuration_engine_get_plugin_string (ConfigurationEngine* self,
                                        const gchar* domain,
                                        const gchar* id,
                                        const gchar* key,
                                        const gchar* def)
{
	ConfigurationEngineIface* _iface_;
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), NULL);
	_iface_ = CONFIGURATION_ENGINE_GET_INTERFACE (self);
	if (_iface_->get_plugin_string) {
		return _iface_->get_plugin_string (self, domain, id, key, def);
	}
	return NULL;
}

void
configuration_engine_set_plugin_string (ConfigurationEngine* self,
                                        const gchar* domain,
                                        const gchar* id,
                                        const gchar* key,
                                        const gchar* val)
{
	ConfigurationEngineIface* _iface_;
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
	_iface_ = CONFIGURATION_ENGINE_GET_INTERFACE (self);
	if (_iface_->set_plugin_string) {
		_iface_->set_plugin_string (self, domain, id, key, val);
	}
}

void
configuration_engine_unset_plugin_key (ConfigurationEngine* self,
                                       const gchar* domain,
                                       const gchar* id,
                                       const gchar* key)
{
	ConfigurationEngineIface* _iface_;
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
	_iface_ = CONFIGURATION_ENGINE_GET_INTERFACE (self);
	if (_iface_->unset_plugin_key) {
		_iface_->unset_plugin_key (self, domain, id, key);
	}
}

FuzzyPropertyState
configuration_engine_is_plugin_enabled (ConfigurationEngine* self,
                                        const gchar* id)
{
	ConfigurationEngineIface* _iface_;
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0);
	_iface_ = CONFIGURATION_ENGINE_GET_INTERFACE (self);
	if (_iface_->is_plugin_enabled) {
		return _iface_->is_plugin_enabled (self, id);
	}
	return 0;
}

void
configuration_engine_set_plugin_enabled (ConfigurationEngine* self,
                                         const gchar* id,
                                         gboolean enabled)
{
	ConfigurationEngineIface* _iface_;
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
	_iface_ = CONFIGURATION_ENGINE_GET_INTERFACE (self);
	if (_iface_->set_plugin_enabled) {
		_iface_->set_plugin_enabled (self, id, enabled);
	}
}

static void
configuration_engine_default_init (ConfigurationEngineIface * iface,
                                   gpointer iface_data)
{
	configuration_engine_signals[CONFIGURATION_ENGINE_PROPERTY_CHANGED_SIGNAL] = g_signal_new ("property-changed", TYPE_CONFIGURATION_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__ENUM, G_TYPE_NONE, 1, TYPE_CONFIGURABLE_PROPERTY);
}

static GType
configuration_engine_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConfigurationEngineIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) configuration_engine_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType configuration_engine_type_id;
	configuration_engine_type_id = g_type_register_static (G_TYPE_INTERFACE, "ConfigurationEngine", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (configuration_engine_type_id, G_TYPE_OBJECT);
	return configuration_engine_type_id;
}

GType
configuration_engine_get_type (void)
{
	static volatile gsize configuration_engine_type_id__once = 0;
	if (g_once_init_enter (&configuration_engine_type_id__once)) {
		GType configuration_engine_type_id;
		configuration_engine_type_id = configuration_engine_get_type_once ();
		g_once_init_leave (&configuration_engine_type_id__once, configuration_engine_type_id);
	}
	return configuration_engine_type_id__once;
}

static inline gpointer
configuration_facade_get_instance_private (ConfigurationFacade* self)
{
	return G_STRUCT_MEMBER_P (self, ConfigurationFacade_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_configuration_facade_on_property_changed_configuration_engine_property_changed (ConfigurationEngine* _sender,
                                                                                 ConfigurableProperty p,
                                                                                 gpointer self)
{
	configuration_facade_on_property_changed ((ConfigurationFacade*) self, p);
}

ConfigurationFacade*
configuration_facade_construct (GType object_type,
                                ConfigurationEngine* engine)
{
	ConfigurationFacade * self = NULL;
	ConfigurationEngine* _tmp0_;
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (engine), NULL);
	self = (ConfigurationFacade*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (engine);
	_g_object_unref0 (self->priv->engine);
	self->priv->engine = _tmp0_;
	g_signal_connect_object (engine, "property-changed", (GCallback) _configuration_facade_on_property_changed_configuration_engine_property_changed, self, 0);
	return self;
}

static void
configuration_facade_on_property_changed (ConfigurationFacade* self,
                                          ConfigurableProperty p)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_tmp0_ = configurable_property_to_string (p);
	_tmp1_ = _tmp0_;
	g_debug ("ConfigurationInterfaces.vala:376: ConfigurationFacade: engine reports " \
"property '%s' changed.", _tmp1_);
	_g_free0 (_tmp1_);
	switch (p) {
		case CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY:
		{
			g_signal_emit (self, configuration_facade_signals[CONFIGURATION_FACADE_AUTO_IMPORT_FROM_LIBRARY_CHANGED_SIGNAL], 0);
			break;
		}
		case CONFIGURABLE_PROPERTY_GTK_THEME_VARIANT:
		{
			g_signal_emit (self, configuration_facade_signals[CONFIGURATION_FACADE_BG_COLOR_NAME_CHANGED_SIGNAL], 0);
			break;
		}
		case CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_TYPE:
		{
			g_signal_emit (self, configuration_facade_signals[CONFIGURATION_FACADE_TRANSPARENT_BACKGROUND_TYPE_CHANGED_SIGNAL], 0);
			break;
		}
		case CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_COLOR:
		{
			g_signal_emit (self, configuration_facade_signals[CONFIGURATION_FACADE_TRANSPARENT_BACKGROUND_COLOR_CHANGED_SIGNAL], 0);
			break;
		}
		case CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS:
		{
			g_signal_emit (self, configuration_facade_signals[CONFIGURATION_FACADE_COMMIT_METADATA_TO_MASTERS_CHANGED_SIGNAL], 0);
			break;
		}
		case CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING:
		{
			g_signal_emit (self, configuration_facade_signals[CONFIGURATION_FACADE_EVENTS_SORT_ASCENDING_CHANGED_SIGNAL], 0);
			break;
		}
		case CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP:
		case CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP:
		{
			g_signal_emit (self, configuration_facade_signals[CONFIGURATION_FACADE_EXTERNAL_APP_CHANGED_SIGNAL], 0);
			break;
		}
		case CONFIGURABLE_PROPERTY_IMPORT_DIR:
		{
			g_signal_emit (self, configuration_facade_signals[CONFIGURATION_FACADE_IMPORT_DIRECTORY_CHANGED_SIGNAL], 0);
			break;
		}
		default:
		{
			break;
		}
	}
}

ConfigurationEngine*
configuration_facade_get_engine (ConfigurationFacade* self)
{
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	ConfigurationEngine* result;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
	_tmp0_ = self->priv->engine;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
configuration_facade_on_configuration_error (ConfigurationFacade* self,
                                             GError* err)
{
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	if (g_error_matches (err, CONFIGURATION_ERROR, CONFIGURATION_ERROR_PROPERTY_HAS_NO_VALUE)) {
		ConfigurationEngine* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp0_ = self->priv->engine;
		_tmp1_ = configuration_engine_get_name (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = err->message;
		g_message ("ConfigurationInterfaces.vala:423: configuration engine '%s' reports PR" \
"OPERTY_HAS_NO_VALUE error: %s", _tmp2_, _tmp3_);
		_g_free0 (_tmp2_);
	} else {
		if (g_error_matches (err, CONFIGURATION_ERROR, CONFIGURATION_ERROR_ENGINE_ERROR)) {
			ConfigurationEngine* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			const gchar* _tmp7_;
			_tmp4_ = self->priv->engine;
			_tmp5_ = configuration_engine_get_name (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = err->message;
			g_critical ("ConfigurationInterfaces.vala:427: configuration engine '%s' reports EN" \
"GINE_ERROR: %s", _tmp6_, _tmp7_);
			_g_free0 (_tmp6_);
		} else {
			ConfigurationEngine* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			const gchar* _tmp11_;
			_tmp8_ = self->priv->engine;
			_tmp9_ = configuration_engine_get_name (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = err->message;
			g_critical ("ConfigurationInterfaces.vala:430: configuration engine '%s' reports un" \
"known error: %s", _tmp10_, _tmp11_);
			_g_free0 (_tmp10_);
		}
	}
}

static gboolean
configuration_facade_real_get_auto_import_from_library (ConfigurationFacade* self)
{
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gboolean
configuration_facade_get_auto_import_from_library (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_auto_import_from_library) {
		return _klass_->get_auto_import_from_library (self);
	}
	return FALSE;
}

static void
configuration_facade_real_set_auto_import_from_library (ConfigurationFacade* self,
                                                        gboolean auto_import)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY, auto_import, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_auto_import_from_library (ConfigurationFacade* self,
                                                   gboolean auto_import)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_auto_import_from_library) {
		_klass_->set_auto_import_from_library (self, auto_import);
	}
}

static gboolean
configuration_facade_real_get_gtk_theme_variant (ConfigurationFacade* self)
{
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_GTK_THEME_VARIANT, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = TRUE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gboolean
configuration_facade_get_gtk_theme_variant (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_gtk_theme_variant) {
		return _klass_->get_gtk_theme_variant (self);
	}
	return FALSE;
}

static void
configuration_facade_real_set_gtk_theme_variant (ConfigurationFacade* self,
                                                 gboolean dark)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_GTK_THEME_VARIANT, dark, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_gtk_theme_variant (ConfigurationFacade* self,
                                            gboolean dark)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_gtk_theme_variant) {
		_klass_->set_gtk_theme_variant (self, dark);
	}
}

static gchar*
configuration_facade_real_get_transparent_background_type (ConfigurationFacade* self)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_TYPE, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp5_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		configuration_facade_on_configuration_error (self, _tmp6_);
		_tmp7_ = g_strdup ("checkered");
		result = _tmp7_;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
configuration_facade_get_transparent_background_type (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_transparent_background_type) {
		return _klass_->get_transparent_background_type (self);
	}
	return NULL;
}

static void
configuration_facade_real_set_transparent_background_type (ConfigurationFacade* self,
                                                           const gchar* type)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (type != NULL);
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_TYPE, type, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_transparent_background_type (ConfigurationFacade* self,
                                                      const gchar* type)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_transparent_background_type) {
		_klass_->set_transparent_background_type (self, type);
	}
}

static gchar*
configuration_facade_real_get_transparent_background_color (ConfigurationFacade* self)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_COLOR, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp5_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		configuration_facade_on_configuration_error (self, _tmp6_);
		_tmp7_ = g_strdup ("#444");
		result = _tmp7_;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
configuration_facade_get_transparent_background_color (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_transparent_background_color) {
		return _klass_->get_transparent_background_color (self);
	}
	return NULL;
}

static void
configuration_facade_real_set_transparent_background_color (ConfigurationFacade* self,
                                                            const gchar* color_name)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (color_name != NULL);
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_COLOR, color_name, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_transparent_background_color (ConfigurationFacade* self,
                                                       const gchar* color_name)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_transparent_background_color) {
		_klass_->set_transparent_background_color (self, color_name);
	}
}

static gboolean
configuration_facade_real_get_commit_metadata_to_masters (ConfigurationFacade* self)
{
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gboolean
configuration_facade_get_commit_metadata_to_masters (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_commit_metadata_to_masters) {
		return _klass_->get_commit_metadata_to_masters (self);
	}
	return FALSE;
}

static void
configuration_facade_real_set_commit_metadata_to_masters (ConfigurationFacade* self,
                                                          gboolean commit_metadata)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS, commit_metadata, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_commit_metadata_to_masters (ConfigurationFacade* self,
                                                     gboolean commit_metadata)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_commit_metadata_to_masters) {
		_klass_->set_commit_metadata_to_masters (self, commit_metadata);
	}
}

static gchar*
configuration_facade_real_get_desktop_background (ConfigurationFacade* self)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp5_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		configuration_facade_on_configuration_error (self, _tmp6_);
		_tmp7_ = g_strdup ("");
		result = _tmp7_;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
configuration_facade_get_desktop_background (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_desktop_background) {
		return _klass_->get_desktop_background (self);
	}
	return NULL;
}

static void
configuration_facade_real_set_desktop_background (ConfigurationFacade* self,
                                                  const gchar* filename)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (filename != NULL);
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		ConfigurationEngine* _tmp3_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE, filename, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp2_ = configuration_facade_get_engine (self);
		_tmp3_ = _tmp2_;
		configuration_engine_set_string_property (_tmp3_, CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_MODE, "zoom", &_inner_error0_);
		_g_object_unref0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		configuration_facade_on_configuration_error (self, _tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_desktop_background (ConfigurationFacade* self,
                                             const gchar* filename)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_desktop_background) {
		_klass_->set_desktop_background (self, filename);
	}
}

static gchar*
configuration_facade_real_get_screensaver (ConfigurationFacade* self)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_SCREENSAVER_FILE, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp5_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		configuration_facade_on_configuration_error (self, _tmp6_);
		_tmp7_ = g_strdup ("");
		result = _tmp7_;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
configuration_facade_get_screensaver (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_screensaver) {
		return _klass_->get_screensaver (self);
	}
	return NULL;
}

static void
configuration_facade_real_set_screensaver (ConfigurationFacade* self,
                                           const gchar* filename)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (filename != NULL);
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		ConfigurationEngine* _tmp3_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_SCREENSAVER_FILE, filename, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp2_ = configuration_facade_get_engine (self);
		_tmp3_ = _tmp2_;
		configuration_engine_set_string_property (_tmp3_, CONFIGURABLE_PROPERTY_SCREENSAVER_MODE, "zoom", &_inner_error0_);
		_g_object_unref0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		configuration_facade_on_configuration_error (self, _tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_screensaver (ConfigurationFacade* self,
                                      const gchar* filename)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_screensaver) {
		_klass_->set_screensaver (self, filename);
	}
}

static gchar*
configuration_facade_real_get_directory_pattern (ConfigurationFacade* self)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	{
		gchar* s = NULL;
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = configuration_engine_get_string_property (_tmp1_, CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN, &_inner_error0_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		s = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		if (g_strcmp0 (s, "") == 0) {
			_tmp4_ = NULL;
		} else {
			_tmp4_ = s;
		}
		_tmp5_ = g_strdup (_tmp4_);
		result = _tmp5_;
		_g_free0 (s);
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		configuration_facade_on_configuration_error (self, _tmp6_);
		_tmp7_ = g_strdup ("");
		result = _tmp7_;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
configuration_facade_get_directory_pattern (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_directory_pattern) {
		return _klass_->get_directory_pattern (self);
	}
	return NULL;
}

static void
configuration_facade_real_set_directory_pattern (ConfigurationFacade* self,
                                                 const gchar* s)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		if (s == NULL) {
			s = "";
		}
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN, s, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_directory_pattern (ConfigurationFacade* self,
                                            const gchar* s)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_directory_pattern) {
		_klass_->set_directory_pattern (self, s);
	}
}

static gchar*
configuration_facade_real_get_directory_pattern_custom (ConfigurationFacade* self)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp5_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		configuration_facade_on_configuration_error (self, _tmp6_);
		_tmp7_ = g_strdup ("");
		result = _tmp7_;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
configuration_facade_get_directory_pattern_custom (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_directory_pattern_custom) {
		return _klass_->get_directory_pattern_custom (self);
	}
	return NULL;
}

static void
configuration_facade_real_set_directory_pattern_custom (ConfigurationFacade* self,
                                                        const gchar* s)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (s != NULL);
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM, s, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_directory_pattern_custom (ConfigurationFacade* self,
                                                   const gchar* s)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_directory_pattern_custom) {
		_klass_->set_directory_pattern_custom (self, s);
	}
}

static void
configuration_facade_real_get_direct_window_state (ConfigurationFacade* self,
                                                   gboolean* maximize,
                                                   Dimensions* dimensions)
{
	gboolean _vala_maximize = FALSE;
	Dimensions _vala_dimensions = {0};
	GError* _inner_error0_ = NULL;
	_vala_maximize = FALSE;
	dimensions_init (&_vala_dimensions, 1024, 768);
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gint w = 0;
		ConfigurationEngine* _tmp4_;
		ConfigurationEngine* _tmp5_;
		gint _tmp6_;
		gint h = 0;
		ConfigurationEngine* _tmp7_;
		ConfigurationEngine* _tmp8_;
		gint _tmp9_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_vala_maximize = _tmp0_;
		_tmp4_ = configuration_facade_get_engine (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = configuration_engine_get_int_property (_tmp5_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH, &_inner_error0_);
		_g_object_unref0 (_tmp5_);
		w = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp7_ = configuration_facade_get_engine (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = configuration_engine_get_int_property (_tmp8_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT, &_inner_error0_);
		_g_object_unref0 (_tmp8_);
		h = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		dimensions_init (&_vala_dimensions, w, h);
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp10_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = err;
		configuration_facade_on_configuration_error (self, _tmp10_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (maximize) {
		*maximize = _vala_maximize;
	}
	if (dimensions) {
		*dimensions = _vala_dimensions;
	}
}

void
configuration_facade_get_direct_window_state (ConfigurationFacade* self,
                                              gboolean* maximize,
                                              Dimensions* dimensions)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_direct_window_state) {
		_klass_->get_direct_window_state (self, maximize, dimensions);
	}
}

static void
configuration_facade_real_set_direct_window_state (ConfigurationFacade* self,
                                                   gboolean maximize,
                                                   Dimensions* dimensions)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (dimensions != NULL);
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		ConfigurationEngine* _tmp3_;
		Dimensions _tmp4_;
		ConfigurationEngine* _tmp5_;
		ConfigurationEngine* _tmp6_;
		Dimensions _tmp7_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE, maximize, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp2_ = configuration_facade_get_engine (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = *dimensions;
		configuration_engine_set_int_property (_tmp3_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH, _tmp4_.width, &_inner_error0_);
		_g_object_unref0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp5_ = configuration_facade_get_engine (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = *dimensions;
		configuration_engine_set_int_property (_tmp6_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT, _tmp7_.height, &_inner_error0_);
		_g_object_unref0 (_tmp6_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp8_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = err;
		configuration_facade_on_configuration_error (self, _tmp8_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_direct_window_state (ConfigurationFacade* self,
                                              gboolean maximize,
                                              Dimensions* dimensions)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_direct_window_state) {
		_klass_->set_direct_window_state (self, maximize, dimensions);
	}
}

static gboolean
configuration_facade_real_get_display_basic_properties (ConfigurationFacade* self)
{
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = TRUE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gboolean
configuration_facade_get_display_basic_properties (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_display_basic_properties) {
		return _klass_->get_display_basic_properties (self);
	}
	return FALSE;
}

static void
configuration_facade_real_set_display_basic_properties (ConfigurationFacade* self,
                                                        gboolean display)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES, display, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_display_basic_properties (ConfigurationFacade* self,
                                                   gboolean display)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_display_basic_properties) {
		_klass_->set_display_basic_properties (self, display);
	}
}

static gboolean
configuration_facade_real_get_display_extended_properties (ConfigurationFacade* self)
{
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gboolean
configuration_facade_get_display_extended_properties (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_display_extended_properties) {
		return _klass_->get_display_extended_properties (self);
	}
	return FALSE;
}

static void
configuration_facade_real_set_display_extended_properties (ConfigurationFacade* self,
                                                           gboolean display)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES, display, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_display_extended_properties (ConfigurationFacade* self,
                                                      gboolean display)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_display_extended_properties) {
		_klass_->set_display_extended_properties (self, display);
	}
}

static gboolean
configuration_facade_real_get_display_sidebar (ConfigurationFacade* self)
{
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gboolean
configuration_facade_get_display_sidebar (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_display_sidebar) {
		return _klass_->get_display_sidebar (self);
	}
	return FALSE;
}

static void
configuration_facade_real_set_display_sidebar (ConfigurationFacade* self,
                                               gboolean display)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR, display, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_display_sidebar (ConfigurationFacade* self,
                                          gboolean display)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_display_sidebar) {
		_klass_->set_display_sidebar (self, display);
	}
}

static gboolean
configuration_facade_real_get_display_toolbar (ConfigurationFacade* self)
{
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_TOOLBAR, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gboolean
configuration_facade_get_display_toolbar (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_display_toolbar) {
		return _klass_->get_display_toolbar (self);
	}
	return FALSE;
}

static void
configuration_facade_real_set_display_toolbar (ConfigurationFacade* self,
                                               gboolean display)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_TOOLBAR, display, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_display_toolbar (ConfigurationFacade* self,
                                          gboolean display)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_display_toolbar) {
		_klass_->set_display_toolbar (self, display);
	}
}

static gboolean
configuration_facade_real_get_display_map_widget (ConfigurationFacade* self)
{
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_MAP_WIDGET, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gboolean
configuration_facade_get_display_map_widget (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_display_map_widget) {
		return _klass_->get_display_map_widget (self);
	}
	return FALSE;
}

static void
configuration_facade_real_set_display_map_widget (ConfigurationFacade* self,
                                                  gboolean display)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_MAP_WIDGET, display, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_display_map_widget (ConfigurationFacade* self,
                                             gboolean display)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_display_map_widget) {
		_klass_->set_display_map_widget (self, display);
	}
}

static gboolean
configuration_facade_real_get_display_search_bar (ConfigurationFacade* self)
{
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gboolean
configuration_facade_get_display_search_bar (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_display_search_bar) {
		return _klass_->get_display_search_bar (self);
	}
	return FALSE;
}

static void
configuration_facade_real_set_display_search_bar (ConfigurationFacade* self,
                                                  gboolean display)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR, display, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_display_search_bar (ConfigurationFacade* self,
                                             gboolean display)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_display_search_bar) {
		_klass_->set_display_search_bar (self, display);
	}
}

static gboolean
configuration_facade_real_get_display_photo_ratings (ConfigurationFacade* self)
{
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = TRUE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gboolean
configuration_facade_get_display_photo_ratings (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_display_photo_ratings) {
		return _klass_->get_display_photo_ratings (self);
	}
	return FALSE;
}

static void
configuration_facade_real_set_display_photo_ratings (ConfigurationFacade* self,
                                                     gboolean display)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS, display, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_display_photo_ratings (ConfigurationFacade* self,
                                                gboolean display)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_display_photo_ratings) {
		_klass_->set_display_photo_ratings (self, display);
	}
}

static gboolean
configuration_facade_real_get_display_photo_tags (ConfigurationFacade* self)
{
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = TRUE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gboolean
configuration_facade_get_display_photo_tags (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_display_photo_tags) {
		return _klass_->get_display_photo_tags (self);
	}
	return FALSE;
}

static void
configuration_facade_real_set_display_photo_tags (ConfigurationFacade* self,
                                                  gboolean display)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS, display, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_display_photo_tags (ConfigurationFacade* self,
                                             gboolean display)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_display_photo_tags) {
		_klass_->set_display_photo_tags (self, display);
	}
}

static gboolean
configuration_facade_real_get_display_photo_titles (ConfigurationFacade* self)
{
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gboolean
configuration_facade_get_display_photo_titles (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_display_photo_titles) {
		return _klass_->get_display_photo_titles (self);
	}
	return FALSE;
}

static void
configuration_facade_real_set_display_photo_titles (ConfigurationFacade* self,
                                                    gboolean display)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES, display, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_display_photo_titles (ConfigurationFacade* self,
                                               gboolean display)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_display_photo_titles) {
		_klass_->set_display_photo_titles (self, display);
	}
}

static gboolean
configuration_facade_real_get_display_photo_comments (ConfigurationFacade* self)
{
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gboolean
configuration_facade_get_display_photo_comments (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_display_photo_comments) {
		return _klass_->get_display_photo_comments (self);
	}
	return FALSE;
}

static void
configuration_facade_real_set_display_photo_comments (ConfigurationFacade* self,
                                                      gboolean display)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS, display, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_display_photo_comments (ConfigurationFacade* self,
                                                 gboolean display)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_display_photo_comments) {
		_klass_->set_display_photo_comments (self, display);
	}
}

static gboolean
configuration_facade_real_get_display_event_comments (ConfigurationFacade* self)
{
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gboolean
configuration_facade_get_display_event_comments (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_display_event_comments) {
		return _klass_->get_display_event_comments (self);
	}
	return FALSE;
}

static void
configuration_facade_real_set_display_event_comments (ConfigurationFacade* self,
                                                      gboolean display)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS, display, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_display_event_comments (ConfigurationFacade* self,
                                                 gboolean display)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_display_event_comments) {
		_klass_->set_display_event_comments (self, display);
	}
}

static void
configuration_facade_real_get_event_photos_sort (ConfigurationFacade* self,
                                                 gboolean* sort_order,
                                                 gint* sort_by)
{
	gboolean _vala_sort_order = FALSE;
	gint _vala_sort_by = 0;
	GError* _inner_error0_ = NULL;
	_vala_sort_order = FALSE;
	_vala_sort_by = 2;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gint _tmp4_ = 0;
		ConfigurationEngine* _tmp5_;
		ConfigurationEngine* _tmp6_;
		gint _tmp7_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_vala_sort_order = _tmp0_;
		_tmp5_ = configuration_facade_get_engine (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = configuration_engine_get_int_property (_tmp6_, CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY, &_inner_error0_);
		_g_object_unref0 (_tmp6_);
		_tmp4_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_vala_sort_by = _tmp4_;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp8_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = err;
		configuration_facade_on_configuration_error (self, _tmp8_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (sort_order) {
		*sort_order = _vala_sort_order;
	}
	if (sort_by) {
		*sort_by = _vala_sort_by;
	}
}

void
configuration_facade_get_event_photos_sort (ConfigurationFacade* self,
                                            gboolean* sort_order,
                                            gint* sort_by)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_event_photos_sort) {
		_klass_->get_event_photos_sort (self, sort_order, sort_by);
	}
}

static void
configuration_facade_real_set_event_photos_sort (ConfigurationFacade* self,
                                                 gboolean sort_order,
                                                 gint sort_by)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		ConfigurationEngine* _tmp3_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING, sort_order, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp2_ = configuration_facade_get_engine (self);
		_tmp3_ = _tmp2_;
		configuration_engine_set_int_property (_tmp3_, CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY, sort_by, &_inner_error0_);
		_g_object_unref0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		configuration_facade_on_configuration_error (self, _tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_event_photos_sort (ConfigurationFacade* self,
                                            gboolean sort_order,
                                            gint sort_by)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_event_photos_sort) {
		_klass_->set_event_photos_sort (self, sort_order, sort_by);
	}
}

static gboolean
configuration_facade_real_get_events_sort_ascending (ConfigurationFacade* self)
{
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gboolean
configuration_facade_get_events_sort_ascending (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_events_sort_ascending) {
		return _klass_->get_events_sort_ascending (self);
	}
	return FALSE;
}

static void
configuration_facade_real_set_events_sort_ascending (ConfigurationFacade* self,
                                                     gboolean sort)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING, sort, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_events_sort_ascending (ConfigurationFacade* self,
                                                gboolean sort)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_events_sort_ascending) {
		_klass_->set_events_sort_ascending (self, sort);
	}
}

static gchar*
configuration_facade_real_get_external_photo_app (ConfigurationFacade* self)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp5_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		configuration_facade_on_configuration_error (self, _tmp6_);
		_tmp7_ = g_strdup ("");
		result = _tmp7_;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
configuration_facade_get_external_photo_app (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_external_photo_app) {
		return _klass_->get_external_photo_app (self);
	}
	return NULL;
}

static void
configuration_facade_real_set_external_photo_app (ConfigurationFacade* self,
                                                  const gchar* external_photo_app)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (external_photo_app != NULL);
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP, external_photo_app, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_external_photo_app (ConfigurationFacade* self,
                                             const gchar* external_photo_app)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_external_photo_app) {
		_klass_->set_external_photo_app (self, external_photo_app);
	}
}

static gchar*
configuration_facade_real_get_external_raw_app (ConfigurationFacade* self)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp5_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		configuration_facade_on_configuration_error (self, _tmp6_);
		_tmp7_ = g_strdup ("");
		result = _tmp7_;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
configuration_facade_get_external_raw_app (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_external_raw_app) {
		return _klass_->get_external_raw_app (self);
	}
	return NULL;
}

static void
configuration_facade_real_set_external_raw_app (ConfigurationFacade* self,
                                                const gchar* external_raw_app)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (external_raw_app != NULL);
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP, external_raw_app, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_external_raw_app (ConfigurationFacade* self,
                                           const gchar* external_raw_app)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_external_raw_app) {
		_klass_->set_external_raw_app (self, external_raw_app);
	}
}

static ScaleConstraint
configuration_facade_real_get_export_constraint (ConfigurationFacade* self)
{
	GError* _inner_error0_ = NULL;
	ScaleConstraint result;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_enum_property (_tmp2_, CONFIGURABLE_PROPERTY_EXPORT_CONSTRAINT, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return 0;
		}
		result = (ScaleConstraint) _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		configuration_facade_on_configuration_error (self, _tmp4_);
		result = 0;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return 0;
}

ScaleConstraint
configuration_facade_get_export_constraint (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_export_constraint) {
		return _klass_->get_export_constraint (self);
	}
	return 0;
}

static void
configuration_facade_real_set_export_constraint (ConfigurationFacade* self,
                                                 ScaleConstraint constraint)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_enum_property (_tmp1_, CONFIGURABLE_PROPERTY_EXPORT_CONSTRAINT, (gint) constraint, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_export_constraint (ConfigurationFacade* self,
                                            ScaleConstraint constraint)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_export_constraint) {
		_klass_->set_export_constraint (self, constraint);
	}
}

static ExportFormatMode
configuration_facade_real_get_export_export_format_mode (ConfigurationFacade* self)
{
	GError* _inner_error0_ = NULL;
	ExportFormatMode result;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_enum_property (_tmp2_, CONFIGURABLE_PROPERTY_EXPORT_EXPORT_FORMAT_MODE, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return 0;
		}
		result = (ExportFormatMode) _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		configuration_facade_on_configuration_error (self, _tmp4_);
		result = 0;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return 0;
}

ExportFormatMode
configuration_facade_get_export_export_format_mode (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_export_export_format_mode) {
		return _klass_->get_export_export_format_mode (self);
	}
	return 0;
}

static void
configuration_facade_real_set_export_export_format_mode (ConfigurationFacade* self,
                                                         ExportFormatMode export_format_mode)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_enum_property (_tmp1_, CONFIGURABLE_PROPERTY_EXPORT_EXPORT_FORMAT_MODE, (gint) export_format_mode, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_export_export_format_mode (ConfigurationFacade* self,
                                                    ExportFormatMode export_format_mode)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_export_export_format_mode) {
		_klass_->set_export_export_format_mode (self, export_format_mode);
	}
}

static gboolean
configuration_facade_real_get_export_export_metadata (ConfigurationFacade* self)
{
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_EXPORT_EXPORT_METADATA, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gboolean
configuration_facade_get_export_export_metadata (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_export_export_metadata) {
		return _klass_->get_export_export_metadata (self);
	}
	return FALSE;
}

static void
configuration_facade_real_set_export_export_metadata (ConfigurationFacade* self,
                                                      gboolean export_metadata)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_EXPORT_EXPORT_METADATA, export_metadata, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_export_export_metadata (ConfigurationFacade* self,
                                                 gboolean export_metadata)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_export_export_metadata) {
		_klass_->set_export_export_metadata (self, export_metadata);
	}
}

static PhotoFileFormat
configuration_facade_real_get_export_photo_file_format (ConfigurationFacade* self)
{
	GError* _inner_error0_ = NULL;
	PhotoFileFormat result;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_enum_property (_tmp2_, CONFIGURABLE_PROPERTY_EXPORT_PHOTO_FILE_FORMAT, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return 0;
		}
		result = photo_file_format_unserialize (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		configuration_facade_on_configuration_error (self, _tmp4_);
		result = 0;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return 0;
}

PhotoFileFormat
configuration_facade_get_export_photo_file_format (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_export_photo_file_format) {
		return _klass_->get_export_photo_file_format (self);
	}
	return 0;
}

static void
configuration_facade_real_set_export_photo_file_format (ConfigurationFacade* self,
                                                        PhotoFileFormat photo_file_format)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_enum_property (_tmp1_, CONFIGURABLE_PROPERTY_EXPORT_PHOTO_FILE_FORMAT, photo_file_format_serialize (photo_file_format), &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_export_photo_file_format (ConfigurationFacade* self,
                                                   PhotoFileFormat photo_file_format)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_export_photo_file_format) {
		_klass_->set_export_photo_file_format (self, photo_file_format);
	}
}

static JpegQuality
configuration_facade_real_get_export_quality (ConfigurationFacade* self)
{
	GError* _inner_error0_ = NULL;
	JpegQuality result;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_enum_property (_tmp2_, CONFIGURABLE_PROPERTY_EXPORT_QUALITY, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return 0;
		}
		result = (JpegQuality) _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		configuration_facade_on_configuration_error (self, _tmp4_);
		result = 0;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return 0;
}

JpegQuality
configuration_facade_get_export_quality (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_export_quality) {
		return _klass_->get_export_quality (self);
	}
	return 0;
}

static void
configuration_facade_real_set_export_quality (ConfigurationFacade* self,
                                              JpegQuality quality)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_enum_property (_tmp1_, CONFIGURABLE_PROPERTY_EXPORT_QUALITY, (gint) quality, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_export_quality (ConfigurationFacade* self,
                                         JpegQuality quality)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_export_quality) {
		_klass_->set_export_quality (self, quality);
	}
}

static gint
configuration_facade_real_get_export_scale (ConfigurationFacade* self)
{
	gint _tmp6_ = -1;
	GError* _inner_error0_ = NULL;
	gint result;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_EXPORT_SCALE, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp4_ = -1;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = 0;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gint
configuration_facade_get_export_scale (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_export_scale) {
		return _klass_->get_export_scale (self);
	}
	return -1;
}

static void
configuration_facade_real_set_export_scale (ConfigurationFacade* self,
                                            gint scale)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_EXPORT_SCALE, scale, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_export_scale (ConfigurationFacade* self,
                                       gint scale)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_export_scale) {
		_klass_->set_export_scale (self, scale);
	}
}

static RawDeveloper
configuration_facade_real_get_default_raw_developer (ConfigurationFacade* self)
{
	GError* _inner_error0_ = NULL;
	RawDeveloper result;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return 0;
		}
		result = raw_developer_from_string (_tmp0_);
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = RAW_DEVELOPER_CAMERA;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return 0;
}

RawDeveloper
configuration_facade_get_default_raw_developer (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_default_raw_developer) {
		return _klass_->get_default_raw_developer (self);
	}
	return 0;
}

static void
configuration_facade_real_set_default_raw_developer (ConfigurationFacade* self,
                                                     RawDeveloper d)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = raw_developer_to_string (d);
		_tmp3_ = _tmp2_;
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT, _tmp3_, &_inner_error0_);
		_g_free0 (_tmp3_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		configuration_facade_on_configuration_error (self, _tmp4_);
		_g_error_free0 (err);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_default_raw_developer (ConfigurationFacade* self,
                                                RawDeveloper d)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_default_raw_developer) {
		_klass_->set_default_raw_developer (self, d);
	}
}

static gboolean
configuration_facade_real_get_hide_photos_already_imported (ConfigurationFacade* self)
{
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = TRUE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gboolean
configuration_facade_get_hide_photos_already_imported (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_hide_photos_already_imported) {
		return _klass_->get_hide_photos_already_imported (self);
	}
	return FALSE;
}

static void
configuration_facade_real_set_hide_photos_already_imported (ConfigurationFacade* self,
                                                            gboolean hide_imported)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED, hide_imported, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_hide_photos_already_imported (ConfigurationFacade* self,
                                                       gboolean hide_imported)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_hide_photos_already_imported) {
		_klass_->set_hide_photos_already_imported (self, hide_imported);
	}
}

static gchar*
configuration_facade_real_get_import_dir (ConfigurationFacade* self)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_IMPORT_DIR, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp5_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		configuration_facade_on_configuration_error (self, _tmp6_);
		_tmp7_ = g_strdup ("");
		result = _tmp7_;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
configuration_facade_get_import_dir (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_import_dir) {
		return _klass_->get_import_dir (self);
	}
	return NULL;
}

static void
configuration_facade_real_set_import_dir (ConfigurationFacade* self,
                                          const gchar* import_dir)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (import_dir != NULL);
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_IMPORT_DIR, import_dir, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_import_dir (ConfigurationFacade* self,
                                     const gchar* import_dir)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_import_dir) {
		_klass_->set_import_dir (self, import_dir);
	}
}

static gboolean
configuration_facade_real_get_keep_relativity (ConfigurationFacade* self)
{
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_KEEP_RELATIVITY, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = TRUE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gboolean
configuration_facade_get_keep_relativity (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_keep_relativity) {
		return _klass_->get_keep_relativity (self);
	}
	return FALSE;
}

static void
configuration_facade_real_set_keep_relativity (ConfigurationFacade* self,
                                               gboolean keep_relativity)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_KEEP_RELATIVITY, keep_relativity, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_keep_relativity (ConfigurationFacade* self,
                                          gboolean keep_relativity)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_keep_relativity) {
		_klass_->set_keep_relativity (self, keep_relativity);
	}
}

static gboolean
configuration_facade_real_get_pin_toolbar_state (ConfigurationFacade* self)
{
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gboolean
configuration_facade_get_pin_toolbar_state (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_pin_toolbar_state) {
		return _klass_->get_pin_toolbar_state (self);
	}
	return FALSE;
}

static void
configuration_facade_real_set_pin_toolbar_state (ConfigurationFacade* self,
                                                 gboolean state)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE, state, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_pin_toolbar_state (ConfigurationFacade* self,
                                            gboolean state)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_pin_toolbar_state) {
		_klass_->set_pin_toolbar_state (self, state);
	}
}

static gint
configuration_facade_real_get_last_crop_height (ConfigurationFacade* self)
{
	gint _tmp6_ = -1;
	GError* _inner_error0_ = NULL;
	gint result;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp4_ = -1;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = 1;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gint
configuration_facade_get_last_crop_height (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_last_crop_height) {
		return _klass_->get_last_crop_height (self);
	}
	return -1;
}

static void
configuration_facade_real_set_last_crop_height (ConfigurationFacade* self,
                                                gint choice)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT, choice, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_last_crop_height (ConfigurationFacade* self,
                                           gint choice)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_last_crop_height) {
		_klass_->set_last_crop_height (self, choice);
	}
}

static gint
configuration_facade_real_get_last_crop_menu_choice (ConfigurationFacade* self)
{
	gint _tmp6_ = -1;
	GError* _inner_error0_ = NULL;
	gint result;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp4_ = -1;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = 0;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gint
configuration_facade_get_last_crop_menu_choice (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_last_crop_menu_choice) {
		return _klass_->get_last_crop_menu_choice (self);
	}
	return -1;
}

static void
configuration_facade_real_set_last_crop_menu_choice (ConfigurationFacade* self,
                                                     gint choice)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE, choice, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_last_crop_menu_choice (ConfigurationFacade* self,
                                                gint choice)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_last_crop_menu_choice) {
		_klass_->set_last_crop_menu_choice (self, choice);
	}
}

static gint
configuration_facade_real_get_last_crop_width (ConfigurationFacade* self)
{
	gint _tmp6_ = -1;
	GError* _inner_error0_ = NULL;
	gint result;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp4_ = -1;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = 1;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gint
configuration_facade_get_last_crop_width (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_last_crop_width) {
		return _klass_->get_last_crop_width (self);
	}
	return -1;
}

static void
configuration_facade_real_set_last_crop_width (ConfigurationFacade* self,
                                               gint choice)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH, choice, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_last_crop_width (ConfigurationFacade* self,
                                          gint choice)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_last_crop_width) {
		_klass_->set_last_crop_width (self, choice);
	}
}

static gchar*
configuration_facade_real_get_last_used_service (ConfigurationFacade* self)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_LAST_USED_SERVICE, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp5_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		configuration_facade_on_configuration_error (self, _tmp6_);
		_tmp7_ = g_strdup ("");
		result = _tmp7_;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
configuration_facade_get_last_used_service (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_last_used_service) {
		return _klass_->get_last_used_service (self);
	}
	return NULL;
}

static void
configuration_facade_real_set_last_used_service (ConfigurationFacade* self,
                                                 const gchar* service_name)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (service_name != NULL);
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_LAST_USED_SERVICE, service_name, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_last_used_service (ConfigurationFacade* self,
                                            const gchar* service_name)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_last_used_service) {
		_klass_->set_last_used_service (self, service_name);
	}
}

static gchar*
configuration_facade_real_get_last_used_dataimports_service (ConfigurationFacade* self)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp5_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		configuration_facade_on_configuration_error (self, _tmp6_);
		_tmp7_ = g_strdup ("");
		result = _tmp7_;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
configuration_facade_get_last_used_dataimports_service (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_last_used_dataimports_service) {
		return _klass_->get_last_used_dataimports_service (self);
	}
	return NULL;
}

static void
configuration_facade_real_set_last_used_dataimports_service (ConfigurationFacade* self,
                                                             const gchar* service_name)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (service_name != NULL);
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE, service_name, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_last_used_dataimports_service (ConfigurationFacade* self,
                                                        const gchar* service_name)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_last_used_dataimports_service) {
		_klass_->set_last_used_dataimports_service (self, service_name);
	}
}

static void
configuration_facade_real_get_library_photos_sort (ConfigurationFacade* self,
                                                   gboolean* sort_order,
                                                   gint* sort_by)
{
	gboolean _vala_sort_order = FALSE;
	gint _vala_sort_by = 0;
	GError* _inner_error0_ = NULL;
	_vala_sort_order = FALSE;
	_vala_sort_by = 2;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gint _tmp4_ = 0;
		ConfigurationEngine* _tmp5_;
		ConfigurationEngine* _tmp6_;
		gint _tmp7_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_vala_sort_order = _tmp0_;
		_tmp5_ = configuration_facade_get_engine (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = configuration_engine_get_int_property (_tmp6_, CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY, &_inner_error0_);
		_g_object_unref0 (_tmp6_);
		_tmp4_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_vala_sort_by = _tmp4_;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp8_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = err;
		configuration_facade_on_configuration_error (self, _tmp8_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (sort_order) {
		*sort_order = _vala_sort_order;
	}
	if (sort_by) {
		*sort_by = _vala_sort_by;
	}
}

void
configuration_facade_get_library_photos_sort (ConfigurationFacade* self,
                                              gboolean* sort_order,
                                              gint* sort_by)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_library_photos_sort) {
		_klass_->get_library_photos_sort (self, sort_order, sort_by);
	}
}

static void
configuration_facade_real_set_library_photos_sort (ConfigurationFacade* self,
                                                   gboolean sort_order,
                                                   gint sort_by)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		ConfigurationEngine* _tmp3_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING, sort_order, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp2_ = configuration_facade_get_engine (self);
		_tmp3_ = _tmp2_;
		configuration_engine_set_int_property (_tmp3_, CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY, sort_by, &_inner_error0_);
		_g_object_unref0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		configuration_facade_on_configuration_error (self, _tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_library_photos_sort (ConfigurationFacade* self,
                                              gboolean sort_order,
                                              gint sort_by)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_library_photos_sort) {
		_klass_->set_library_photos_sort (self, sort_order, sort_by);
	}
}

static void
configuration_facade_real_get_library_window_state (ConfigurationFacade* self,
                                                    gboolean* maximize,
                                                    Dimensions* dimensions)
{
	gboolean _vala_maximize = FALSE;
	Dimensions _vala_dimensions = {0};
	GError* _inner_error0_ = NULL;
	_vala_maximize = FALSE;
	dimensions_init (&_vala_dimensions, 1024, 768);
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gint w = 0;
		ConfigurationEngine* _tmp4_;
		ConfigurationEngine* _tmp5_;
		gint _tmp6_;
		gint h = 0;
		ConfigurationEngine* _tmp7_;
		ConfigurationEngine* _tmp8_;
		gint _tmp9_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_vala_maximize = _tmp0_;
		_tmp4_ = configuration_facade_get_engine (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = configuration_engine_get_int_property (_tmp5_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH, &_inner_error0_);
		_g_object_unref0 (_tmp5_);
		w = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp7_ = configuration_facade_get_engine (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = configuration_engine_get_int_property (_tmp8_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT, &_inner_error0_);
		_g_object_unref0 (_tmp8_);
		h = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		dimensions_init (&_vala_dimensions, w, h);
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp10_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = err;
		configuration_facade_on_configuration_error (self, _tmp10_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (maximize) {
		*maximize = _vala_maximize;
	}
	if (dimensions) {
		*dimensions = _vala_dimensions;
	}
}

void
configuration_facade_get_library_window_state (ConfigurationFacade* self,
                                               gboolean* maximize,
                                               Dimensions* dimensions)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_library_window_state) {
		_klass_->get_library_window_state (self, maximize, dimensions);
	}
}

static void
configuration_facade_real_set_library_window_state (ConfigurationFacade* self,
                                                    gboolean maximize,
                                                    Dimensions* dimensions)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (dimensions != NULL);
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		ConfigurationEngine* _tmp3_;
		Dimensions _tmp4_;
		ConfigurationEngine* _tmp5_;
		ConfigurationEngine* _tmp6_;
		Dimensions _tmp7_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE, maximize, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp2_ = configuration_facade_get_engine (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = *dimensions;
		configuration_engine_set_int_property (_tmp3_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH, _tmp4_.width, &_inner_error0_);
		_g_object_unref0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp5_ = configuration_facade_get_engine (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = *dimensions;
		configuration_engine_set_int_property (_tmp6_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT, _tmp7_.height, &_inner_error0_);
		_g_object_unref0 (_tmp6_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp8_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = err;
		configuration_facade_on_configuration_error (self, _tmp8_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_library_window_state (ConfigurationFacade* self,
                                               gboolean maximize,
                                               Dimensions* dimensions)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_library_window_state) {
		_klass_->set_library_window_state (self, maximize, dimensions);
	}
}

static gboolean
configuration_facade_real_get_modify_originals (ConfigurationFacade* self)
{
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gboolean
configuration_facade_get_modify_originals (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_modify_originals) {
		return _klass_->get_modify_originals (self);
	}
	return FALSE;
}

static void
configuration_facade_real_set_modify_originals (ConfigurationFacade* self,
                                                gboolean modify_originals)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS, modify_originals, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_modify_originals (ConfigurationFacade* self,
                                           gboolean modify_originals)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_modify_originals) {
		_klass_->set_modify_originals (self, modify_originals);
	}
}

static gint
configuration_facade_real_get_photo_thumbnail_scale (ConfigurationFacade* self)
{
	gint _tmp8_ = -1;
	GError* _inner_error0_ = NULL;
	gint result;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp4_ = -1;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		_tmp6_ = thumbnail_get_DEFAULT_SCALE ();
		_tmp7_ = _tmp6_;
		result = _tmp7_;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp8_;
}

gint
configuration_facade_get_photo_thumbnail_scale (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_photo_thumbnail_scale) {
		return _klass_->get_photo_thumbnail_scale (self);
	}
	return -1;
}

static void
configuration_facade_real_set_photo_thumbnail_scale (ConfigurationFacade* self,
                                                     gint scale)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE, scale, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_photo_thumbnail_scale (ConfigurationFacade* self,
                                                gint scale)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_photo_thumbnail_scale) {
		_klass_->set_photo_thumbnail_scale (self, scale);
	}
}

static gdouble
configuration_facade_real_get_printing_content_height (ConfigurationFacade* self)
{
	gdouble _tmp6_ = -1.0;
	GError* _inner_error0_ = NULL;
	gdouble result;
	{
		gdouble _tmp0_ = 0.0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gdouble _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_double_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gdouble _tmp4_ = -1.0;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = 5.0;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gdouble
configuration_facade_get_printing_content_height (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0.0);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_printing_content_height) {
		return _klass_->get_printing_content_height (self);
	}
	return -1.0;
}

static void
configuration_facade_real_set_printing_content_height (ConfigurationFacade* self,
                                                       gdouble content_height)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_double_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT, content_height, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_printing_content_height (ConfigurationFacade* self,
                                                  gdouble content_height)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_printing_content_height) {
		_klass_->set_printing_content_height (self, content_height);
	}
}

static gint
configuration_facade_real_get_printing_content_layout (ConfigurationFacade* self)
{
	gint _tmp6_ = -1;
	GError* _inner_error0_ = NULL;
	gint result;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp4_ = -1;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_ - 1;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = 0;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gint
configuration_facade_get_printing_content_layout (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_printing_content_layout) {
		return _klass_->get_printing_content_layout (self);
	}
	return -1;
}

static void
configuration_facade_real_set_printing_content_layout (ConfigurationFacade* self,
                                                       gint layout_code)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT, layout_code + 1, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_printing_content_layout (ConfigurationFacade* self,
                                                  gint layout_code)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_printing_content_layout) {
		_klass_->set_printing_content_layout (self, layout_code);
	}
}

static gint
configuration_facade_real_get_printing_content_ppi (ConfigurationFacade* self)
{
	gint _tmp6_ = -1;
	GError* _inner_error0_ = NULL;
	gint result;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp4_ = -1;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = 600;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gint
configuration_facade_get_printing_content_ppi (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_printing_content_ppi) {
		return _klass_->get_printing_content_ppi (self);
	}
	return -1;
}

static void
configuration_facade_real_set_printing_content_ppi (ConfigurationFacade* self,
                                                    gint content_ppi)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI, content_ppi, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_printing_content_ppi (ConfigurationFacade* self,
                                               gint content_ppi)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_printing_content_ppi) {
		_klass_->set_printing_content_ppi (self, content_ppi);
	}
}

static gint
configuration_facade_real_get_printing_content_units (ConfigurationFacade* self)
{
	gint _tmp6_ = -1;
	GError* _inner_error0_ = NULL;
	gint result;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp4_ = -1;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_ - 1;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = 0;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gint
configuration_facade_get_printing_content_units (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_printing_content_units) {
		return _klass_->get_printing_content_units (self);
	}
	return -1;
}

static void
configuration_facade_real_set_printing_content_units (ConfigurationFacade* self,
                                                      gint units_code)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS, units_code + 1, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_printing_content_units (ConfigurationFacade* self,
                                                 gint units_code)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_printing_content_units) {
		_klass_->set_printing_content_units (self, units_code);
	}
}

static gdouble
configuration_facade_real_get_printing_content_width (ConfigurationFacade* self)
{
	gdouble _tmp6_ = -1.0;
	GError* _inner_error0_ = NULL;
	gdouble result;
	{
		gdouble _tmp0_ = 0.0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gdouble _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_double_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gdouble _tmp4_ = -1.0;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = 7.0;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gdouble
configuration_facade_get_printing_content_width (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0.0);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_printing_content_width) {
		return _klass_->get_printing_content_width (self);
	}
	return -1.0;
}

static void
configuration_facade_real_set_printing_content_width (ConfigurationFacade* self,
                                                      gdouble content_width)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_double_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH, content_width, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_printing_content_width (ConfigurationFacade* self,
                                                 gdouble content_width)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_printing_content_width) {
		_klass_->set_printing_content_width (self, content_width);
	}
}

static gint
configuration_facade_real_get_printing_images_per_page (ConfigurationFacade* self)
{
	gint _tmp6_ = -1;
	GError* _inner_error0_ = NULL;
	gint result;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp4_ = -1;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_ - 1;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = 0;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gint
configuration_facade_get_printing_images_per_page (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_printing_images_per_page) {
		return _klass_->get_printing_images_per_page (self);
	}
	return -1;
}

static void
configuration_facade_real_set_printing_images_per_page (ConfigurationFacade* self,
                                                        gint images_per_page_code)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE, images_per_page_code + 1, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_printing_images_per_page (ConfigurationFacade* self,
                                                   gint images_per_page_code)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_printing_images_per_page) {
		_klass_->set_printing_images_per_page (self, images_per_page_code);
	}
}

static gboolean
configuration_facade_real_get_printing_match_aspect_ratio (ConfigurationFacade* self)
{
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = TRUE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gboolean
configuration_facade_get_printing_match_aspect_ratio (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_printing_match_aspect_ratio) {
		return _klass_->get_printing_match_aspect_ratio (self);
	}
	return FALSE;
}

static void
configuration_facade_real_set_printing_match_aspect_ratio (ConfigurationFacade* self,
                                                           gboolean match_aspect_ratio)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO, match_aspect_ratio, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_printing_match_aspect_ratio (ConfigurationFacade* self,
                                                      gboolean match_aspect_ratio)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_printing_match_aspect_ratio) {
		_klass_->set_printing_match_aspect_ratio (self, match_aspect_ratio);
	}
}

static gboolean
configuration_facade_real_get_printing_print_titles (ConfigurationFacade* self)
{
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gboolean
configuration_facade_get_printing_print_titles (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_printing_print_titles) {
		return _klass_->get_printing_print_titles (self);
	}
	return FALSE;
}

static void
configuration_facade_real_set_printing_print_titles (ConfigurationFacade* self,
                                                     gboolean print_titles)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES, print_titles, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_printing_print_titles (ConfigurationFacade* self,
                                                gboolean print_titles)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_printing_print_titles) {
		_klass_->set_printing_print_titles (self, print_titles);
	}
}

static gint
configuration_facade_real_get_printing_size_selection (ConfigurationFacade* self)
{
	gint _tmp6_ = -1;
	GError* _inner_error0_ = NULL;
	gint result;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint val = 0;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp4_ = -1;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		val = _tmp0_ - 1;
		if (val == -2) {
			if (resources_get_default_measurement_unit () == RESOURCES_UNIT_SYSTEM_IMPERIAL) {
				val = 2;
			} else {
				val = 10;
			}
		}
		result = val;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = 0;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gint
configuration_facade_get_printing_size_selection (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_printing_size_selection) {
		return _klass_->get_printing_size_selection (self);
	}
	return -1;
}

static void
configuration_facade_real_set_printing_size_selection (ConfigurationFacade* self,
                                                       gint size_code)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION, size_code + 1, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_printing_size_selection (ConfigurationFacade* self,
                                                  gint size_code)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_printing_size_selection) {
		_klass_->set_printing_size_selection (self, size_code);
	}
}

static gchar*
configuration_facade_real_get_printing_titles_font (ConfigurationFacade* self)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp5_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		configuration_facade_on_configuration_error (self, _tmp6_);
		_tmp7_ = g_strdup ("Sans Bold 12");
		result = _tmp7_;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
configuration_facade_get_printing_titles_font (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_printing_titles_font) {
		return _klass_->get_printing_titles_font (self);
	}
	return NULL;
}

static void
configuration_facade_real_set_printing_titles_font (ConfigurationFacade* self,
                                                    const gchar* font_name)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (font_name != NULL);
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT, font_name, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_printing_titles_font (ConfigurationFacade* self,
                                               const gchar* font_name)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_printing_titles_font) {
		_klass_->set_printing_titles_font (self, font_name);
	}
}

static gboolean
configuration_facade_real_get_show_welcome_dialog (ConfigurationFacade* self)
{
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = TRUE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gboolean
configuration_facade_get_show_welcome_dialog (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_show_welcome_dialog) {
		return _klass_->get_show_welcome_dialog (self);
	}
	return FALSE;
}

static void
configuration_facade_real_set_show_welcome_dialog (ConfigurationFacade* self,
                                                   gboolean show)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG, show, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_show_welcome_dialog (ConfigurationFacade* self,
                                              gboolean show)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_show_welcome_dialog) {
		_klass_->set_show_welcome_dialog (self, show);
	}
}

static gint
configuration_facade_real_get_sidebar_position (ConfigurationFacade* self)
{
	gint _tmp6_ = -1;
	GError* _inner_error0_ = NULL;
	gint result;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_SIDEBAR_POSITION, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp4_ = -1;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = 180;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gint
configuration_facade_get_sidebar_position (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_sidebar_position) {
		return _klass_->get_sidebar_position (self);
	}
	return -1;
}

static void
configuration_facade_real_set_sidebar_position (ConfigurationFacade* self,
                                                gint position)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_SIDEBAR_POSITION, position, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_sidebar_position (ConfigurationFacade* self,
                                           gint position)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_sidebar_position) {
		_klass_->set_sidebar_position (self, position);
	}
}

static gdouble
configuration_facade_real_get_slideshow_delay (ConfigurationFacade* self)
{
	gdouble _tmp6_ = -1.0;
	GError* _inner_error0_ = NULL;
	gdouble result;
	{
		gdouble _tmp0_ = 0.0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gdouble _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_double_property (_tmp2_, CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gdouble _tmp4_ = -1.0;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = 3.0;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gdouble
configuration_facade_get_slideshow_delay (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0.0);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_slideshow_delay) {
		return _klass_->get_slideshow_delay (self);
	}
	return -1.0;
}

static void
configuration_facade_real_set_slideshow_delay (ConfigurationFacade* self,
                                               gdouble delay)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_double_property (_tmp1_, CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY, delay, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_slideshow_delay (ConfigurationFacade* self,
                                          gdouble delay)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_slideshow_delay) {
		_klass_->set_slideshow_delay (self, delay);
	}
}

static gdouble
configuration_facade_real_get_slideshow_transition_delay (ConfigurationFacade* self)
{
	gdouble _tmp6_ = -1.0;
	GError* _inner_error0_ = NULL;
	gdouble result;
	{
		gdouble _tmp0_ = 0.0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gdouble _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_double_property (_tmp2_, CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gdouble _tmp4_ = -1.0;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = 0.3;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gdouble
configuration_facade_get_slideshow_transition_delay (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0.0);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_slideshow_transition_delay) {
		return _klass_->get_slideshow_transition_delay (self);
	}
	return -1.0;
}

static void
configuration_facade_real_set_slideshow_transition_delay (ConfigurationFacade* self,
                                                          gdouble delay)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_double_property (_tmp1_, CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY, delay, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_slideshow_transition_delay (ConfigurationFacade* self,
                                                     gdouble delay)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_slideshow_transition_delay) {
		_klass_->set_slideshow_transition_delay (self, delay);
	}
}

static gchar*
configuration_facade_real_get_slideshow_transition_effect_id (ConfigurationFacade* self)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp5_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		configuration_facade_on_configuration_error (self, _tmp6_);
		_tmp7_ = g_strdup (TRANSITION_EFFECTS_MANAGER_NULL_EFFECT_ID);
		result = _tmp7_;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
configuration_facade_get_slideshow_transition_effect_id (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_slideshow_transition_effect_id) {
		return _klass_->get_slideshow_transition_effect_id (self);
	}
	return NULL;
}

static void
configuration_facade_real_set_slideshow_transition_effect_id (ConfigurationFacade* self,
                                                              const gchar* id)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (id != NULL);
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID, id, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_slideshow_transition_effect_id (ConfigurationFacade* self,
                                                         const gchar* id)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_slideshow_transition_effect_id) {
		_klass_->set_slideshow_transition_effect_id (self, id);
	}
}

static gboolean
configuration_facade_real_get_slideshow_show_title (ConfigurationFacade* self)
{
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gboolean
configuration_facade_get_slideshow_show_title (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_slideshow_show_title) {
		return _klass_->get_slideshow_show_title (self);
	}
	return FALSE;
}

static void
configuration_facade_real_set_slideshow_show_title (ConfigurationFacade* self,
                                                    gboolean show_title)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE, show_title, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_slideshow_show_title (ConfigurationFacade* self,
                                               gboolean show_title)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_slideshow_show_title) {
		_klass_->set_slideshow_show_title (self, show_title);
	}
}

static gboolean
configuration_facade_real_get_slideshow_shuffle (ConfigurationFacade* self)
{
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_SLIDESHOW_SHUFFLE, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gboolean
configuration_facade_get_slideshow_shuffle (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_slideshow_shuffle) {
		return _klass_->get_slideshow_shuffle (self);
	}
	return FALSE;
}

static void
configuration_facade_real_set_slideshow_shuffle (ConfigurationFacade* self,
                                                 gboolean shuffle)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_SLIDESHOW_SHUFFLE, shuffle, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_slideshow_shuffle (ConfigurationFacade* self,
                                            gboolean shuffle)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_slideshow_shuffle) {
		_klass_->set_slideshow_shuffle (self, shuffle);
	}
}

static void
g_time_local (time_t time,
              struct tm* result)
{
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	localtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}

static gchar*
g_time_format (struct tm *self,
               const gchar* format)
{
	gchar* buffer = NULL;
	gchar* _tmp0_;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (format != NULL, NULL);
	_tmp0_ = g_new0 (gchar, 64);
	buffer = _tmp0_;
	buffer_length1 = 64;
	_buffer_size_ = buffer_length1;
	strftime (buffer, (gint) buffer_length1, format, &(*self));
	_tmp1_ = g_strdup ((const gchar*) buffer);
	result = _tmp1_;
	buffer = (g_free (buffer), NULL);
	return result;
}

static gboolean
configuration_facade_real_get_use_24_hour_time (ConfigurationFacade* self)
{
	gboolean _tmp10_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		struct tm _tmp6_ = {0};
		gchar* _tmp7_;
		gchar* _tmp8_;
		gboolean _tmp9_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		g_time_local ((time_t) 0, &_tmp6_);
		_tmp7_ = g_time_format (&_tmp6_, "%p");
		_tmp8_ = _tmp7_;
		_tmp9_ = is_string_empty (_tmp8_);
		_g_free0 (_tmp8_);
		result = _tmp9_;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp10_;
}

gboolean
configuration_facade_get_use_24_hour_time (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_use_24_hour_time) {
		return _klass_->get_use_24_hour_time (self);
	}
	return FALSE;
}

static void
configuration_facade_real_set_use_24_hour_time (ConfigurationFacade* self,
                                                gboolean use_24_hour_time)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME, use_24_hour_time, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_use_24_hour_time (ConfigurationFacade* self,
                                           gboolean use_24_hour_time)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_use_24_hour_time) {
		_klass_->set_use_24_hour_time (self, use_24_hour_time);
	}
}

static gboolean
configuration_facade_real_get_use_lowercase_filenames (ConfigurationFacade* self)
{
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = configuration_facade_get_engine (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		configuration_facade_on_configuration_error (self, _tmp5_);
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp6_;
}

gboolean
configuration_facade_get_use_lowercase_filenames (ConfigurationFacade* self)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_use_lowercase_filenames) {
		return _klass_->get_use_lowercase_filenames (self);
	}
	return FALSE;
}

static void
configuration_facade_real_set_use_lowercase_filenames (ConfigurationFacade* self,
                                                       gboolean b)
{
	GError* _inner_error0_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		_tmp0_ = configuration_facade_get_engine (self);
		_tmp1_ = _tmp0_;
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES, b, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		configuration_facade_on_configuration_error (self, _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
configuration_facade_set_use_lowercase_filenames (ConfigurationFacade* self,
                                                  gboolean b)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_use_lowercase_filenames) {
		_klass_->set_use_lowercase_filenames (self, b);
	}
}

static gboolean
configuration_facade_real_get_plugin_bool (ConfigurationFacade* self,
                                           const gchar* domain,
                                           const gchar* id,
                                           const gchar* key,
                                           gboolean def)
{
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (domain != NULL, FALSE);
	g_return_val_if_fail (id != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = configuration_facade_get_engine (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = configuration_engine_get_plugin_bool (_tmp1_, domain, id, key, def);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

gboolean
configuration_facade_get_plugin_bool (ConfigurationFacade* self,
                                      const gchar* domain,
                                      const gchar* id,
                                      const gchar* key,
                                      gboolean def)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_plugin_bool) {
		return _klass_->get_plugin_bool (self, domain, id, key, def);
	}
	return FALSE;
}

static void
configuration_facade_real_set_plugin_bool (ConfigurationFacade* self,
                                           const gchar* domain,
                                           const gchar* id,
                                           const gchar* key,
                                           gboolean val)
{
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	g_return_if_fail (domain != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = configuration_facade_get_engine (self);
	_tmp1_ = _tmp0_;
	configuration_engine_set_plugin_bool (_tmp1_, domain, id, key, val);
	_g_object_unref0 (_tmp1_);
}

void
configuration_facade_set_plugin_bool (ConfigurationFacade* self,
                                      const gchar* domain,
                                      const gchar* id,
                                      const gchar* key,
                                      gboolean val)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_plugin_bool) {
		_klass_->set_plugin_bool (self, domain, id, key, val);
	}
}

static gdouble
configuration_facade_real_get_plugin_double (ConfigurationFacade* self,
                                             const gchar* domain,
                                             const gchar* id,
                                             const gchar* key,
                                             gdouble def)
{
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	gdouble _tmp2_;
	gdouble result;
	g_return_val_if_fail (domain != NULL, 0.0);
	g_return_val_if_fail (id != NULL, 0.0);
	g_return_val_if_fail (key != NULL, 0.0);
	_tmp0_ = configuration_facade_get_engine (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = configuration_engine_get_plugin_double (_tmp1_, domain, id, key, def);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

gdouble
configuration_facade_get_plugin_double (ConfigurationFacade* self,
                                        const gchar* domain,
                                        const gchar* id,
                                        const gchar* key,
                                        gdouble def)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0.0);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_plugin_double) {
		return _klass_->get_plugin_double (self, domain, id, key, def);
	}
	return -1.0;
}

static void
configuration_facade_real_set_plugin_double (ConfigurationFacade* self,
                                             const gchar* domain,
                                             const gchar* id,
                                             const gchar* key,
                                             gdouble val)
{
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	g_return_if_fail (domain != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = configuration_facade_get_engine (self);
	_tmp1_ = _tmp0_;
	configuration_engine_set_plugin_double (_tmp1_, domain, id, key, val);
	_g_object_unref0 (_tmp1_);
}

void
configuration_facade_set_plugin_double (ConfigurationFacade* self,
                                        const gchar* domain,
                                        const gchar* id,
                                        const gchar* key,
                                        gdouble val)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_plugin_double) {
		_klass_->set_plugin_double (self, domain, id, key, val);
	}
}

static gint
configuration_facade_real_get_plugin_int (ConfigurationFacade* self,
                                          const gchar* domain,
                                          const gchar* id,
                                          const gchar* key,
                                          gint def)
{
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (domain != NULL, 0);
	g_return_val_if_fail (id != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	_tmp0_ = configuration_facade_get_engine (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = configuration_engine_get_plugin_int (_tmp1_, domain, id, key, def);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

gint
configuration_facade_get_plugin_int (ConfigurationFacade* self,
                                     const gchar* domain,
                                     const gchar* id,
                                     const gchar* key,
                                     gint def)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_plugin_int) {
		return _klass_->get_plugin_int (self, domain, id, key, def);
	}
	return -1;
}

static void
configuration_facade_real_set_plugin_int (ConfigurationFacade* self,
                                          const gchar* domain,
                                          const gchar* id,
                                          const gchar* key,
                                          gint val)
{
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	g_return_if_fail (domain != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = configuration_facade_get_engine (self);
	_tmp1_ = _tmp0_;
	configuration_engine_set_plugin_int (_tmp1_, domain, id, key, val);
	_g_object_unref0 (_tmp1_);
}

void
configuration_facade_set_plugin_int (ConfigurationFacade* self,
                                     const gchar* domain,
                                     const gchar* id,
                                     const gchar* key,
                                     gint val)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_plugin_int) {
		_klass_->set_plugin_int (self, domain, id, key, val);
	}
}

static gchar*
configuration_facade_real_get_plugin_string (ConfigurationFacade* self,
                                             const gchar* domain,
                                             const gchar* id,
                                             const gchar* key,
                                             const gchar* def)
{
	gchar* _result_ = NULL;
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (domain != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = configuration_facade_get_engine (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = configuration_engine_get_plugin_string (_tmp1_, domain, id, key, def);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	_result_ = _tmp3_;
	_tmp5_ = _result_;
	if (g_strcmp0 (_tmp5_, "") == 0) {
		_tmp4_ = NULL;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = _result_;
		_tmp4_ = _tmp6_;
	}
	_tmp7_ = g_strdup (_tmp4_);
	result = _tmp7_;
	_g_free0 (_result_);
	return result;
}

gchar*
configuration_facade_get_plugin_string (ConfigurationFacade* self,
                                        const gchar* domain,
                                        const gchar* id,
                                        const gchar* key,
                                        const gchar* def)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->get_plugin_string) {
		return _klass_->get_plugin_string (self, domain, id, key, def);
	}
	return NULL;
}

static void
configuration_facade_real_set_plugin_string (ConfigurationFacade* self,
                                             const gchar* domain,
                                             const gchar* id,
                                             const gchar* key,
                                             const gchar* val)
{
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	g_return_if_fail (domain != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (key != NULL);
	if (val == NULL) {
		val = "";
	}
	_tmp0_ = configuration_facade_get_engine (self);
	_tmp1_ = _tmp0_;
	configuration_engine_set_plugin_string (_tmp1_, domain, id, key, val);
	_g_object_unref0 (_tmp1_);
}

void
configuration_facade_set_plugin_string (ConfigurationFacade* self,
                                        const gchar* domain,
                                        const gchar* id,
                                        const gchar* key,
                                        const gchar* val)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_plugin_string) {
		_klass_->set_plugin_string (self, domain, id, key, val);
	}
}

static void
configuration_facade_real_unset_plugin_key (ConfigurationFacade* self,
                                            const gchar* domain,
                                            const gchar* id,
                                            const gchar* key)
{
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	g_return_if_fail (domain != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = configuration_facade_get_engine (self);
	_tmp1_ = _tmp0_;
	configuration_engine_unset_plugin_key (_tmp1_, domain, id, key);
	_g_object_unref0 (_tmp1_);
}

void
configuration_facade_unset_plugin_key (ConfigurationFacade* self,
                                       const gchar* domain,
                                       const gchar* id,
                                       const gchar* key)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->unset_plugin_key) {
		_klass_->unset_plugin_key (self, domain, id, key);
	}
}

static FuzzyPropertyState
configuration_facade_real_is_plugin_enabled (ConfigurationFacade* self,
                                             const gchar* id)
{
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	FuzzyPropertyState _tmp2_;
	FuzzyPropertyState result;
	g_return_val_if_fail (id != NULL, 0);
	_tmp0_ = configuration_facade_get_engine (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = configuration_engine_is_plugin_enabled (_tmp1_, id);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

FuzzyPropertyState
configuration_facade_is_plugin_enabled (ConfigurationFacade* self,
                                        const gchar* id)
{
	ConfigurationFacadeClass* _klass_;
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->is_plugin_enabled) {
		return _klass_->is_plugin_enabled (self, id);
	}
	return 0;
}

static void
configuration_facade_real_set_plugin_enabled (ConfigurationFacade* self,
                                              const gchar* id,
                                              gboolean enabled)
{
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	g_return_if_fail (id != NULL);
	_tmp0_ = configuration_facade_get_engine (self);
	_tmp1_ = _tmp0_;
	configuration_engine_set_plugin_enabled (_tmp1_, id, enabled);
	_g_object_unref0 (_tmp1_);
}

void
configuration_facade_set_plugin_enabled (ConfigurationFacade* self,
                                         const gchar* id,
                                         gboolean enabled)
{
	ConfigurationFacadeClass* _klass_;
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
	_klass_ = CONFIGURATION_FACADE_GET_CLASS (self);
	if (_klass_->set_plugin_enabled) {
		_klass_->set_plugin_enabled (self, id, enabled);
	}
}

static void
configuration_facade_class_init (ConfigurationFacadeClass * klass,
                                 gpointer klass_data)
{
	configuration_facade_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ConfigurationFacade_private_offset);
	((ConfigurationFacadeClass *) klass)->get_auto_import_from_library = (gboolean (*) (ConfigurationFacade*)) configuration_facade_real_get_auto_import_from_library;
	((ConfigurationFacadeClass *) klass)->set_auto_import_from_library = (void (*) (ConfigurationFacade*, gboolean)) configuration_facade_real_set_auto_import_from_library;
	((ConfigurationFacadeClass *) klass)->get_gtk_theme_variant = (gboolean (*) (ConfigurationFacade*)) configuration_facade_real_get_gtk_theme_variant;
	((ConfigurationFacadeClass *) klass)->set_gtk_theme_variant = (void (*) (ConfigurationFacade*, gboolean)) configuration_facade_real_set_gtk_theme_variant;
	((ConfigurationFacadeClass *) klass)->get_transparent_background_type = (gchar* (*) (ConfigurationFacade*)) configuration_facade_real_get_transparent_background_type;
	((ConfigurationFacadeClass *) klass)->set_transparent_background_type = (void (*) (ConfigurationFacade*, const gchar*)) configuration_facade_real_set_transparent_background_type;
	((ConfigurationFacadeClass *) klass)->get_transparent_background_color = (gchar* (*) (ConfigurationFacade*)) configuration_facade_real_get_transparent_background_color;
	((ConfigurationFacadeClass *) klass)->set_transparent_background_color = (void (*) (ConfigurationFacade*, const gchar*)) configuration_facade_real_set_transparent_background_color;
	((ConfigurationFacadeClass *) klass)->get_commit_metadata_to_masters = (gboolean (*) (ConfigurationFacade*)) configuration_facade_real_get_commit_metadata_to_masters;
	((ConfigurationFacadeClass *) klass)->set_commit_metadata_to_masters = (void (*) (ConfigurationFacade*, gboolean)) configuration_facade_real_set_commit_metadata_to_masters;
	((ConfigurationFacadeClass *) klass)->get_desktop_background = (gchar* (*) (ConfigurationFacade*)) configuration_facade_real_get_desktop_background;
	((ConfigurationFacadeClass *) klass)->set_desktop_background = (void (*) (ConfigurationFacade*, const gchar*)) configuration_facade_real_set_desktop_background;
	((ConfigurationFacadeClass *) klass)->get_screensaver = (gchar* (*) (ConfigurationFacade*)) configuration_facade_real_get_screensaver;
	((ConfigurationFacadeClass *) klass)->set_screensaver = (void (*) (ConfigurationFacade*, const gchar*)) configuration_facade_real_set_screensaver;
	((ConfigurationFacadeClass *) klass)->get_directory_pattern = (gchar* (*) (ConfigurationFacade*)) configuration_facade_real_get_directory_pattern;
	((ConfigurationFacadeClass *) klass)->set_directory_pattern = (void (*) (ConfigurationFacade*, const gchar*)) configuration_facade_real_set_directory_pattern;
	((ConfigurationFacadeClass *) klass)->get_directory_pattern_custom = (gchar* (*) (ConfigurationFacade*)) configuration_facade_real_get_directory_pattern_custom;
	((ConfigurationFacadeClass *) klass)->set_directory_pattern_custom = (void (*) (ConfigurationFacade*, const gchar*)) configuration_facade_real_set_directory_pattern_custom;
	((ConfigurationFacadeClass *) klass)->get_direct_window_state = (void (*) (ConfigurationFacade*, gboolean*, Dimensions*)) configuration_facade_real_get_direct_window_state;
	((ConfigurationFacadeClass *) klass)->set_direct_window_state = (void (*) (ConfigurationFacade*, gboolean, Dimensions*)) configuration_facade_real_set_direct_window_state;
	((ConfigurationFacadeClass *) klass)->get_display_basic_properties = (gboolean (*) (ConfigurationFacade*)) configuration_facade_real_get_display_basic_properties;
	((ConfigurationFacadeClass *) klass)->set_display_basic_properties = (void (*) (ConfigurationFacade*, gboolean)) configuration_facade_real_set_display_basic_properties;
	((ConfigurationFacadeClass *) klass)->get_display_extended_properties = (gboolean (*) (ConfigurationFacade*)) configuration_facade_real_get_display_extended_properties;
	((ConfigurationFacadeClass *) klass)->set_display_extended_properties = (void (*) (ConfigurationFacade*, gboolean)) configuration_facade_real_set_display_extended_properties;
	((ConfigurationFacadeClass *) klass)->get_display_sidebar = (gboolean (*) (ConfigurationFacade*)) configuration_facade_real_get_display_sidebar;
	((ConfigurationFacadeClass *) klass)->set_display_sidebar = (void (*) (ConfigurationFacade*, gboolean)) configuration_facade_real_set_display_sidebar;
	((ConfigurationFacadeClass *) klass)->get_display_toolbar = (gboolean (*) (ConfigurationFacade*)) configuration_facade_real_get_display_toolbar;
	((ConfigurationFacadeClass *) klass)->set_display_toolbar = (void (*) (ConfigurationFacade*, gboolean)) configuration_facade_real_set_display_toolbar;
	((ConfigurationFacadeClass *) klass)->get_display_map_widget = (gboolean (*) (ConfigurationFacade*)) configuration_facade_real_get_display_map_widget;
	((ConfigurationFacadeClass *) klass)->set_display_map_widget = (void (*) (ConfigurationFacade*, gboolean)) configuration_facade_real_set_display_map_widget;
	((ConfigurationFacadeClass *) klass)->get_display_search_bar = (gboolean (*) (ConfigurationFacade*)) configuration_facade_real_get_display_search_bar;
	((ConfigurationFacadeClass *) klass)->set_display_search_bar = (void (*) (ConfigurationFacade*, gboolean)) configuration_facade_real_set_display_search_bar;
	((ConfigurationFacadeClass *) klass)->get_display_photo_ratings = (gboolean (*) (ConfigurationFacade*)) configuration_facade_real_get_display_photo_ratings;
	((ConfigurationFacadeClass *) klass)->set_display_photo_ratings = (void (*) (ConfigurationFacade*, gboolean)) configuration_facade_real_set_display_photo_ratings;
	((ConfigurationFacadeClass *) klass)->get_display_photo_tags = (gboolean (*) (ConfigurationFacade*)) configuration_facade_real_get_display_photo_tags;
	((ConfigurationFacadeClass *) klass)->set_display_photo_tags = (void (*) (ConfigurationFacade*, gboolean)) configuration_facade_real_set_display_photo_tags;
	((ConfigurationFacadeClass *) klass)->get_display_photo_titles = (gboolean (*) (ConfigurationFacade*)) configuration_facade_real_get_display_photo_titles;
	((ConfigurationFacadeClass *) klass)->set_display_photo_titles = (void (*) (ConfigurationFacade*, gboolean)) configuration_facade_real_set_display_photo_titles;
	((ConfigurationFacadeClass *) klass)->get_display_photo_comments = (gboolean (*) (ConfigurationFacade*)) configuration_facade_real_get_display_photo_comments;
	((ConfigurationFacadeClass *) klass)->set_display_photo_comments = (void (*) (ConfigurationFacade*, gboolean)) configuration_facade_real_set_display_photo_comments;
	((ConfigurationFacadeClass *) klass)->get_display_event_comments = (gboolean (*) (ConfigurationFacade*)) configuration_facade_real_get_display_event_comments;
	((ConfigurationFacadeClass *) klass)->set_display_event_comments = (void (*) (ConfigurationFacade*, gboolean)) configuration_facade_real_set_display_event_comments;
	((ConfigurationFacadeClass *) klass)->get_event_photos_sort = (void (*) (ConfigurationFacade*, gboolean*, gint*)) configuration_facade_real_get_event_photos_sort;
	((ConfigurationFacadeClass *) klass)->set_event_photos_sort = (void (*) (ConfigurationFacade*, gboolean, gint)) configuration_facade_real_set_event_photos_sort;
	((ConfigurationFacadeClass *) klass)->get_events_sort_ascending = (gboolean (*) (ConfigurationFacade*)) configuration_facade_real_get_events_sort_ascending;
	((ConfigurationFacadeClass *) klass)->set_events_sort_ascending = (void (*) (ConfigurationFacade*, gboolean)) configuration_facade_real_set_events_sort_ascending;
	((ConfigurationFacadeClass *) klass)->get_external_photo_app = (gchar* (*) (ConfigurationFacade*)) configuration_facade_real_get_external_photo_app;
	((ConfigurationFacadeClass *) klass)->set_external_photo_app = (void (*) (ConfigurationFacade*, const gchar*)) configuration_facade_real_set_external_photo_app;
	((ConfigurationFacadeClass *) klass)->get_external_raw_app = (gchar* (*) (ConfigurationFacade*)) configuration_facade_real_get_external_raw_app;
	((ConfigurationFacadeClass *) klass)->set_external_raw_app = (void (*) (ConfigurationFacade*, const gchar*)) configuration_facade_real_set_external_raw_app;
	((ConfigurationFacadeClass *) klass)->get_export_constraint = (ScaleConstraint (*) (ConfigurationFacade*)) configuration_facade_real_get_export_constraint;
	((ConfigurationFacadeClass *) klass)->set_export_constraint = (void (*) (ConfigurationFacade*, ScaleConstraint)) configuration_facade_real_set_export_constraint;
	((ConfigurationFacadeClass *) klass)->get_export_export_format_mode = (ExportFormatMode (*) (ConfigurationFacade*)) configuration_facade_real_get_export_export_format_mode;
	((ConfigurationFacadeClass *) klass)->set_export_export_format_mode = (void (*) (ConfigurationFacade*, ExportFormatMode)) configuration_facade_real_set_export_export_format_mode;
	((ConfigurationFacadeClass *) klass)->get_export_export_metadata = (gboolean (*) (ConfigurationFacade*)) configuration_facade_real_get_export_export_metadata;
	((ConfigurationFacadeClass *) klass)->set_export_export_metadata = (void (*) (ConfigurationFacade*, gboolean)) configuration_facade_real_set_export_export_metadata;
	((ConfigurationFacadeClass *) klass)->get_export_photo_file_format = (PhotoFileFormat (*) (ConfigurationFacade*)) configuration_facade_real_get_export_photo_file_format;
	((ConfigurationFacadeClass *) klass)->set_export_photo_file_format = (void (*) (ConfigurationFacade*, PhotoFileFormat)) configuration_facade_real_set_export_photo_file_format;
	((ConfigurationFacadeClass *) klass)->get_export_quality = (JpegQuality (*) (ConfigurationFacade*)) configuration_facade_real_get_export_quality;
	((ConfigurationFacadeClass *) klass)->set_export_quality = (void (*) (ConfigurationFacade*, JpegQuality)) configuration_facade_real_set_export_quality;
	((ConfigurationFacadeClass *) klass)->get_export_scale = (gint (*) (ConfigurationFacade*)) configuration_facade_real_get_export_scale;
	((ConfigurationFacadeClass *) klass)->set_export_scale = (void (*) (ConfigurationFacade*, gint)) configuration_facade_real_set_export_scale;
	((ConfigurationFacadeClass *) klass)->get_default_raw_developer = (RawDeveloper (*) (ConfigurationFacade*)) configuration_facade_real_get_default_raw_developer;
	((ConfigurationFacadeClass *) klass)->set_default_raw_developer = (void (*) (ConfigurationFacade*, RawDeveloper)) configuration_facade_real_set_default_raw_developer;
	((ConfigurationFacadeClass *) klass)->get_hide_photos_already_imported = (gboolean (*) (ConfigurationFacade*)) configuration_facade_real_get_hide_photos_already_imported;
	((ConfigurationFacadeClass *) klass)->set_hide_photos_already_imported = (void (*) (ConfigurationFacade*, gboolean)) configuration_facade_real_set_hide_photos_already_imported;
	((ConfigurationFacadeClass *) klass)->get_import_dir = (gchar* (*) (ConfigurationFacade*)) configuration_facade_real_get_import_dir;
	((ConfigurationFacadeClass *) klass)->set_import_dir = (void (*) (ConfigurationFacade*, const gchar*)) configuration_facade_real_set_import_dir;
	((ConfigurationFacadeClass *) klass)->get_keep_relativity = (gboolean (*) (ConfigurationFacade*)) configuration_facade_real_get_keep_relativity;
	((ConfigurationFacadeClass *) klass)->set_keep_relativity = (void (*) (ConfigurationFacade*, gboolean)) configuration_facade_real_set_keep_relativity;
	((ConfigurationFacadeClass *) klass)->get_pin_toolbar_state = (gboolean (*) (ConfigurationFacade*)) configuration_facade_real_get_pin_toolbar_state;
	((ConfigurationFacadeClass *) klass)->set_pin_toolbar_state = (void (*) (ConfigurationFacade*, gboolean)) configuration_facade_real_set_pin_toolbar_state;
	((ConfigurationFacadeClass *) klass)->get_last_crop_height = (gint (*) (ConfigurationFacade*)) configuration_facade_real_get_last_crop_height;
	((ConfigurationFacadeClass *) klass)->set_last_crop_height = (void (*) (ConfigurationFacade*, gint)) configuration_facade_real_set_last_crop_height;
	((ConfigurationFacadeClass *) klass)->get_last_crop_menu_choice = (gint (*) (ConfigurationFacade*)) configuration_facade_real_get_last_crop_menu_choice;
	((ConfigurationFacadeClass *) klass)->set_last_crop_menu_choice = (void (*) (ConfigurationFacade*, gint)) configuration_facade_real_set_last_crop_menu_choice;
	((ConfigurationFacadeClass *) klass)->get_last_crop_width = (gint (*) (ConfigurationFacade*)) configuration_facade_real_get_last_crop_width;
	((ConfigurationFacadeClass *) klass)->set_last_crop_width = (void (*) (ConfigurationFacade*, gint)) configuration_facade_real_set_last_crop_width;
	((ConfigurationFacadeClass *) klass)->get_last_used_service = (gchar* (*) (ConfigurationFacade*)) configuration_facade_real_get_last_used_service;
	((ConfigurationFacadeClass *) klass)->set_last_used_service = (void (*) (ConfigurationFacade*, const gchar*)) configuration_facade_real_set_last_used_service;
	((ConfigurationFacadeClass *) klass)->get_last_used_dataimports_service = (gchar* (*) (ConfigurationFacade*)) configuration_facade_real_get_last_used_dataimports_service;
	((ConfigurationFacadeClass *) klass)->set_last_used_dataimports_service = (void (*) (ConfigurationFacade*, const gchar*)) configuration_facade_real_set_last_used_dataimports_service;
	((ConfigurationFacadeClass *) klass)->get_library_photos_sort = (void (*) (ConfigurationFacade*, gboolean*, gint*)) configuration_facade_real_get_library_photos_sort;
	((ConfigurationFacadeClass *) klass)->set_library_photos_sort = (void (*) (ConfigurationFacade*, gboolean, gint)) configuration_facade_real_set_library_photos_sort;
	((ConfigurationFacadeClass *) klass)->get_library_window_state = (void (*) (ConfigurationFacade*, gboolean*, Dimensions*)) configuration_facade_real_get_library_window_state;
	((ConfigurationFacadeClass *) klass)->set_library_window_state = (void (*) (ConfigurationFacade*, gboolean, Dimensions*)) configuration_facade_real_set_library_window_state;
	((ConfigurationFacadeClass *) klass)->get_modify_originals = (gboolean (*) (ConfigurationFacade*)) configuration_facade_real_get_modify_originals;
	((ConfigurationFacadeClass *) klass)->set_modify_originals = (void (*) (ConfigurationFacade*, gboolean)) configuration_facade_real_set_modify_originals;
	((ConfigurationFacadeClass *) klass)->get_photo_thumbnail_scale = (gint (*) (ConfigurationFacade*)) configuration_facade_real_get_photo_thumbnail_scale;
	((ConfigurationFacadeClass *) klass)->set_photo_thumbnail_scale = (void (*) (ConfigurationFacade*, gint)) configuration_facade_real_set_photo_thumbnail_scale;
	((ConfigurationFacadeClass *) klass)->get_printing_content_height = (gdouble (*) (ConfigurationFacade*)) configuration_facade_real_get_printing_content_height;
	((ConfigurationFacadeClass *) klass)->set_printing_content_height = (void (*) (ConfigurationFacade*, gdouble)) configuration_facade_real_set_printing_content_height;
	((ConfigurationFacadeClass *) klass)->get_printing_content_layout = (gint (*) (ConfigurationFacade*)) configuration_facade_real_get_printing_content_layout;
	((ConfigurationFacadeClass *) klass)->set_printing_content_layout = (void (*) (ConfigurationFacade*, gint)) configuration_facade_real_set_printing_content_layout;
	((ConfigurationFacadeClass *) klass)->get_printing_content_ppi = (gint (*) (ConfigurationFacade*)) configuration_facade_real_get_printing_content_ppi;
	((ConfigurationFacadeClass *) klass)->set_printing_content_ppi = (void (*) (ConfigurationFacade*, gint)) configuration_facade_real_set_printing_content_ppi;
	((ConfigurationFacadeClass *) klass)->get_printing_content_units = (gint (*) (ConfigurationFacade*)) configuration_facade_real_get_printing_content_units;
	((ConfigurationFacadeClass *) klass)->set_printing_content_units = (void (*) (ConfigurationFacade*, gint)) configuration_facade_real_set_printing_content_units;
	((ConfigurationFacadeClass *) klass)->get_printing_content_width = (gdouble (*) (ConfigurationFacade*)) configuration_facade_real_get_printing_content_width;
	((ConfigurationFacadeClass *) klass)->set_printing_content_width = (void (*) (ConfigurationFacade*, gdouble)) configuration_facade_real_set_printing_content_width;
	((ConfigurationFacadeClass *) klass)->get_printing_images_per_page = (gint (*) (ConfigurationFacade*)) configuration_facade_real_get_printing_images_per_page;
	((ConfigurationFacadeClass *) klass)->set_printing_images_per_page = (void (*) (ConfigurationFacade*, gint)) configuration_facade_real_set_printing_images_per_page;
	((ConfigurationFacadeClass *) klass)->get_printing_match_aspect_ratio = (gboolean (*) (ConfigurationFacade*)) configuration_facade_real_get_printing_match_aspect_ratio;
	((ConfigurationFacadeClass *) klass)->set_printing_match_aspect_ratio = (void (*) (ConfigurationFacade*, gboolean)) configuration_facade_real_set_printing_match_aspect_ratio;
	((ConfigurationFacadeClass *) klass)->get_printing_print_titles = (gboolean (*) (ConfigurationFacade*)) configuration_facade_real_get_printing_print_titles;
	((ConfigurationFacadeClass *) klass)->set_printing_print_titles = (void (*) (ConfigurationFacade*, gboolean)) configuration_facade_real_set_printing_print_titles;
	((ConfigurationFacadeClass *) klass)->get_printing_size_selection = (gint (*) (ConfigurationFacade*)) configuration_facade_real_get_printing_size_selection;
	((ConfigurationFacadeClass *) klass)->set_printing_size_selection = (void (*) (ConfigurationFacade*, gint)) configuration_facade_real_set_printing_size_selection;
	((ConfigurationFacadeClass *) klass)->get_printing_titles_font = (gchar* (*) (ConfigurationFacade*)) configuration_facade_real_get_printing_titles_font;
	((ConfigurationFacadeClass *) klass)->set_printing_titles_font = (void (*) (ConfigurationFacade*, const gchar*)) configuration_facade_real_set_printing_titles_font;
	((ConfigurationFacadeClass *) klass)->get_show_welcome_dialog = (gboolean (*) (ConfigurationFacade*)) configuration_facade_real_get_show_welcome_dialog;
	((ConfigurationFacadeClass *) klass)->set_show_welcome_dialog = (void (*) (ConfigurationFacade*, gboolean)) configuration_facade_real_set_show_welcome_dialog;
	((ConfigurationFacadeClass *) klass)->get_sidebar_position = (gint (*) (ConfigurationFacade*)) configuration_facade_real_get_sidebar_position;
	((ConfigurationFacadeClass *) klass)->set_sidebar_position = (void (*) (ConfigurationFacade*, gint)) configuration_facade_real_set_sidebar_position;
	((ConfigurationFacadeClass *) klass)->get_slideshow_delay = (gdouble (*) (ConfigurationFacade*)) configuration_facade_real_get_slideshow_delay;
	((ConfigurationFacadeClass *) klass)->set_slideshow_delay = (void (*) (ConfigurationFacade*, gdouble)) configuration_facade_real_set_slideshow_delay;
	((ConfigurationFacadeClass *) klass)->get_slideshow_transition_delay = (gdouble (*) (ConfigurationFacade*)) configuration_facade_real_get_slideshow_transition_delay;
	((ConfigurationFacadeClass *) klass)->set_slideshow_transition_delay = (void (*) (ConfigurationFacade*, gdouble)) configuration_facade_real_set_slideshow_transition_delay;
	((ConfigurationFacadeClass *) klass)->get_slideshow_transition_effect_id = (gchar* (*) (ConfigurationFacade*)) configuration_facade_real_get_slideshow_transition_effect_id;
	((ConfigurationFacadeClass *) klass)->set_slideshow_transition_effect_id = (void (*) (ConfigurationFacade*, const gchar*)) configuration_facade_real_set_slideshow_transition_effect_id;
	((ConfigurationFacadeClass *) klass)->get_slideshow_show_title = (gboolean (*) (ConfigurationFacade*)) configuration_facade_real_get_slideshow_show_title;
	((ConfigurationFacadeClass *) klass)->set_slideshow_show_title = (void (*) (ConfigurationFacade*, gboolean)) configuration_facade_real_set_slideshow_show_title;
	((ConfigurationFacadeClass *) klass)->get_slideshow_shuffle = (gboolean (*) (ConfigurationFacade*)) configuration_facade_real_get_slideshow_shuffle;
	((ConfigurationFacadeClass *) klass)->set_slideshow_shuffle = (void (*) (ConfigurationFacade*, gboolean)) configuration_facade_real_set_slideshow_shuffle;
	((ConfigurationFacadeClass *) klass)->get_use_24_hour_time = (gboolean (*) (ConfigurationFacade*)) configuration_facade_real_get_use_24_hour_time;
	((ConfigurationFacadeClass *) klass)->set_use_24_hour_time = (void (*) (ConfigurationFacade*, gboolean)) configuration_facade_real_set_use_24_hour_time;
	((ConfigurationFacadeClass *) klass)->get_use_lowercase_filenames = (gboolean (*) (ConfigurationFacade*)) configuration_facade_real_get_use_lowercase_filenames;
	((ConfigurationFacadeClass *) klass)->set_use_lowercase_filenames = (void (*) (ConfigurationFacade*, gboolean)) configuration_facade_real_set_use_lowercase_filenames;
	((ConfigurationFacadeClass *) klass)->get_plugin_bool = (gboolean (*) (ConfigurationFacade*, const gchar*, const gchar*, const gchar*, gboolean)) configuration_facade_real_get_plugin_bool;
	((ConfigurationFacadeClass *) klass)->set_plugin_bool = (void (*) (ConfigurationFacade*, const gchar*, const gchar*, const gchar*, gboolean)) configuration_facade_real_set_plugin_bool;
	((ConfigurationFacadeClass *) klass)->get_plugin_double = (gdouble (*) (ConfigurationFacade*, const gchar*, const gchar*, const gchar*, gdouble)) configuration_facade_real_get_plugin_double;
	((ConfigurationFacadeClass *) klass)->set_plugin_double = (void (*) (ConfigurationFacade*, const gchar*, const gchar*, const gchar*, gdouble)) configuration_facade_real_set_plugin_double;
	((ConfigurationFacadeClass *) klass)->get_plugin_int = (gint (*) (ConfigurationFacade*, const gchar*, const gchar*, const gchar*, gint)) configuration_facade_real_get_plugin_int;
	((ConfigurationFacadeClass *) klass)->set_plugin_int = (void (*) (ConfigurationFacade*, const gchar*, const gchar*, const gchar*, gint)) configuration_facade_real_set_plugin_int;
	((ConfigurationFacadeClass *) klass)->get_plugin_string = (gchar* (*) (ConfigurationFacade*, const gchar*, const gchar*, const gchar*, const gchar*)) configuration_facade_real_get_plugin_string;
	((ConfigurationFacadeClass *) klass)->set_plugin_string = (void (*) (ConfigurationFacade*, const gchar*, const gchar*, const gchar*, const gchar*)) configuration_facade_real_set_plugin_string;
	((ConfigurationFacadeClass *) klass)->unset_plugin_key = (void (*) (ConfigurationFacade*, const gchar*, const gchar*, const gchar*)) configuration_facade_real_unset_plugin_key;
	((ConfigurationFacadeClass *) klass)->is_plugin_enabled = (FuzzyPropertyState (*) (ConfigurationFacade*, const gchar*)) configuration_facade_real_is_plugin_enabled;
	((ConfigurationFacadeClass *) klass)->set_plugin_enabled = (void (*) (ConfigurationFacade*, const gchar*, gboolean)) configuration_facade_real_set_plugin_enabled;
	G_OBJECT_CLASS (klass)->finalize = configuration_facade_finalize;
	configuration_facade_signals[CONFIGURATION_FACADE_AUTO_IMPORT_FROM_LIBRARY_CHANGED_SIGNAL] = g_signal_new ("auto-import-from-library-changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	configuration_facade_signals[CONFIGURATION_FACADE_BG_COLOR_NAME_CHANGED_SIGNAL] = g_signal_new ("bg-color-name-changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	configuration_facade_signals[CONFIGURATION_FACADE_TRANSPARENT_BACKGROUND_TYPE_CHANGED_SIGNAL] = g_signal_new ("transparent-background-type-changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	configuration_facade_signals[CONFIGURATION_FACADE_TRANSPARENT_BACKGROUND_COLOR_CHANGED_SIGNAL] = g_signal_new ("transparent-background-color-changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	configuration_facade_signals[CONFIGURATION_FACADE_COMMIT_METADATA_TO_MASTERS_CHANGED_SIGNAL] = g_signal_new ("commit-metadata-to-masters-changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	configuration_facade_signals[CONFIGURATION_FACADE_EVENTS_SORT_ASCENDING_CHANGED_SIGNAL] = g_signal_new ("events-sort-ascending-changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	configuration_facade_signals[CONFIGURATION_FACADE_EXTERNAL_APP_CHANGED_SIGNAL] = g_signal_new ("external-app-changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	configuration_facade_signals[CONFIGURATION_FACADE_IMPORT_DIRECTORY_CHANGED_SIGNAL] = g_signal_new ("import-directory-changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
configuration_facade_instance_init (ConfigurationFacade * self,
                                    gpointer klass)
{
	self->priv = configuration_facade_get_instance_private (self);
}

static void
configuration_facade_finalize (GObject * obj)
{
	ConfigurationFacade * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONFIGURATION_FACADE, ConfigurationFacade);
	_g_object_unref0 (self->priv->engine);
	G_OBJECT_CLASS (configuration_facade_parent_class)->finalize (obj);
}

static GType
configuration_facade_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConfigurationFacadeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) configuration_facade_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConfigurationFacade), 0, (GInstanceInitFunc) configuration_facade_instance_init, NULL };
	GType configuration_facade_type_id;
	configuration_facade_type_id = g_type_register_static (G_TYPE_OBJECT, "ConfigurationFacade", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	ConfigurationFacade_private_offset = g_type_add_instance_private (configuration_facade_type_id, sizeof (ConfigurationFacadePrivate));
	return configuration_facade_type_id;
}

GType
configuration_facade_get_type (void)
{
	static volatile gsize configuration_facade_type_id__once = 0;
	if (g_once_init_enter (&configuration_facade_type_id__once)) {
		GType configuration_facade_type_id;
		configuration_facade_type_id = configuration_facade_get_type_once ();
		g_once_init_leave (&configuration_facade_type_id__once, configuration_facade_type_id);
	}
	return configuration_facade_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

